/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import spec.jbb.Company;
import spec.jbb.JBBLogFormatter;
import spec.jbb.JBBProperties;
import spec.jbb.JBButil;
import spec.jbb.RunSequencer;
import spec.jbb.SaveOutput;
import spec.jbb.TimerData;
import spec.jbb.Transaction;
import spec.jbb.TransactionManager;
import spec.jbb.validity.Check;
import spec.jbb.validity.digest;
import spec.reporter.Report;
import spec.reporter.TextiReport;

public class JBBmain
implements Runnable {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";
    public static final String Version = "SPECjbb2005 1.05";
    public static final String VersionDate = "July 6, 2005";
    public static final String[] Header = new String[]{"", "Licensed Materials - Property of SPEC", "SPECjbb2005", "Copyright (c) 2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,"};
    public static final String[] TPC_FAIR_USE = new String[]{"", "Licensed Materials - Property of SPEC", "SPECjbb2005", "Copyright (c) 2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,", "This source code is provided as is, without any express or implied warranty.", "", "TPC Fair Use policy:", "", "SPECjbb2005 is not a TPC Benchmark. SPECjbb2005 results are not comparable with", "any TPC Benchmark results. The workload used by SPECjbb2005 is inspired", "by the TPC-C specification, TPC Benchmark C , Standard Specification,", "Revision 3.2, August 27 1996. TPC Benchmark is a trademark of the Transaction", "Processing Performance Council."};
    private static long deterministic_seed = 2108417082252868L;
    public static final short NON_NUMERIC_ENTRY = -99;
    public static Company myCompany = null;
    public Vector<Thread> threadList;
    public Vector<Short> whIdStack;
    private int testnum = 0;
    private int warehousePopulationBase;
    private int orderlinesPerOrder;
    private int waitTimePercent;
    private boolean forceGC;
    private boolean screenWriteFlag;
    private boolean steadyStateFlag;
    public static boolean uniformRandomItems;
    public static int overrideItemTableSize;
    public static int maxWh;
    private static PrintStream outResultsFile;
    private static PrintStream outRawFile;
    private static PrintStream outDeliveriesFile;
    public static boolean multiJVMMode;
    public static int instanceId;
    public static int port;
    public static BufferedReader socIn;
    public static PrintWriter socOut;
    public static String defaultOutputDir;
    public static String defaultPropsFileName;
    JBBProperties prop;

    public void run() {
        TransactionManager transactionManager = null;
        short s = this.whIdStack.remove(0);
        short s2 = myCompany.getMaxWarehouses();
        if (s > 0 && s <= myCompany.getMaxWarehouses()) {
            transactionManager = new TransactionManager();
            transactionManager.initTransactionManager(myCompany, s);
            myCompany.addWarehouseThread(transactionManager);
            transactionManager.go();
        } else {
            JBButil.getLog().warning("IMPOSSIBLE ERROR: Invalid Warehouse passed in.  Value was " + s + " and should be between 1 and " + myCompany.getMaxWarehouses());
            JBButil.SecondsToSleep(15L);
        }
    }

    public synchronized void startJBBthread(short s) {
        if (this.threadList == null) {
            this.threadList = new Vector();
        }
        if (this.whIdStack == null) {
            this.whIdStack = new Vector();
        }
        Thread thread = new Thread(this);
        this.threadList.add(thread);
        this.whIdStack.add(s);
        thread.start();
    }

    public synchronized void stopJBBthread() {
        while (!this.threadList.isEmpty()) {
            try {
                while (this.threadList.firstElement().isAlive()) {
                    JBButil.SecondsToSleep(1L);
                }
                this.threadList.remove(0);
            }
            catch (NoSuchElementException noSuchElementException) {
                System.out.println("No first element in the thread list: ");
                noSuchElementException.printStackTrace();
            }
        }
    }

    public void DoARun(Company company, short s, int n, int n2) {
        JBButil.getLog().entering("spec.jbb.JBBmain", "DoARun");
        ++this.testnum;
        company.setPropOutputPrefix("result.test" + this.testnum + ".");
        System.out.println("Start User Threads");
        JBButil.getLog().info("Start User Threads");
        company.prepareForStart();
        try {
            for (short s2 = 1; s2 <= s; s2 = (short)(s2 + 1)) {
                company.startAutomated(s2, n, n2);
                this.startJBBthread(s2);
                String string = "  started user thread for Warehouse " + s2;
                System.out.println(string);
                JBButil.getLog().info(string);
            }
        }
        catch (ThreadDeath threadDeath) {
            try {
                JBButil.getLog().log(Level.WARNING, "ERROR:  A thread died, probably out of memory.  Increase the heap size and run again", threadDeath);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.out.println("ERROR:  A thread died, probably out of memory.  Increase the heap size and run again");
                threadDeath.printStackTrace();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            try {
                JBButil.getLog().log(Level.WARNING, "ERROR:  Out of memory error caught!   Increase the heap size and run again.", outOfMemoryError);
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                System.out.println("ERROR:  Out of memory error caught!   Increase the heap size and run again.");
                outOfMemoryError.printStackTrace();
            }
        }
        company.displayResultTotals(this.prop.showWarehouseDetail);
        this.stopJBBthread();
        JBButil.getLog().exiting("spec.jbb.JBBmain", "DoARun");
        this.flushLog();
    }

    public boolean DoAValidationRun(Company company) {
        company.prepareForStart();
        company.startValidation((short)1);
        TransactionManager transactionManager = new TransactionManager();
        transactionManager.initTransactionManager(company, (short)1);
        return transactionManager.goValidate();
    }

    public void doIt() {
        JBButil.getLog().entering("spec.jbb.JBBmain", "DOIT");
        float f = (float)((double)this.prop.minBTPSRatio * 100.0 / (double)this.prop.waitTimePercent * 2.3 / 60.0);
        Transaction.setOrderLineCount(this.prop.orderlinesPerOrder);
        myCompany = new Company();
        if (this.prop.deterministicRandomSeed) {
            JBButil.set_random_seed(deterministic_seed);
        }
        myCompany.setJVMInstanceValues(this.prop.jvm_instances);
        myCompany.setMultiJVMRampingValues(this.prop.per_jvm_warehouse_rampup, this.prop.per_jvm_warehouse_rampdown);
        myCompany.setPopulationValues(this.prop.warehousePopulationBase, JBBProperties.overrideItemTableSize);
        Transaction.setLogWrite(this.prop.screenWriteFlag);
        Transaction.setSteadyState(this.prop.steadyStateFlag);
        int n = 0;
        if (this.prop.sequenceOfWarehouses == null) {
            for (int i = this.prop.startingNumberWarehouses; i <= this.prop.endingNumberWarehouses && this.runWarehouse(n, i, f); i += this.prop.incrementNumberWarehouses) {
                n = i;
            }
        } else {
            int n2;
            for (int i = 0; i < this.prop.sequenceOfWarehouses.length && this.runWarehouse(n, n2 = this.prop.sequenceOfWarehouses[i], f); ++i) {
                n = n2;
            }
        }
        JBButil.getLog().exiting("spec.jbb.JBBmain", "DOIT");
    }

    public boolean doItForValidation() {
        Transaction.setOrderLineCount(this.orderlinesPerOrder);
        myCompany = new Company();
        long l = 528562479389981L;
        JBButil.set_random_seed(l);
        myCompany.setPopulationValues(this.warehousePopulationBase);
        Transaction.setLogWrite(this.screenWriteFlag);
        Transaction.setSteadyState(this.steadyStateFlag);
        Transaction.setValidation(true);
        this.increaseNumWarehouses(0, 1, this.waitTimePercent);
        boolean bl = this.DoAValidationRun(myCompany);
        Transaction.setValidation(false);
        return bl;
    }

    private void increaseNumWarehouses(int n, int n2, int n3) {
        JBButil.getLog().entering("spec.jbb.JBBmain", "increaseNumWarehouses");
        for (int i = n + 1; i <= n2; ++i) {
            myCompany.primeWithDummyData((short)i, 0);
            myCompany.getTimerDataPtr((short)i).useWaitTimesPercentage(n3);
        }
        JBButil.getLog().exiting("spec.jbb.JBBmain", "increaseNumWarehouses");
    }

    public boolean runWarehouse(int n, int n2, float f) {
        TimerData timerData;
        double d;
        JBButil.getLog().entering("spec.jbb.JBBmain", "runWarehouse");
        System.out.println("\n++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
        this.increaseNumWarehouses(n, n2, this.prop.waitTimePercent);
        boolean bl = false;
        if (n2 < this.prop.expectedPeakWarehouse) {
            this.DoARun(myCompany, myCompany.getMaxWarehouses(), 0, this.prop.rampupSeconds);
        } else {
            this.DoARun(myCompany, myCompany.getMaxWarehouses(), 0, this.prop.measurementSeconds);
        }
        if (this.prop.checkThroughput && (d = (timerData = myCompany.getTimerDataPtr((short)0)).getBTPS()) < (double)(f * (float)n2)) {
            System.out.println("result below min for warehouse");
            JBButil.getLog().exiting("spec.jbb.JBBmain", "runWarehouse");
            return false;
        }
        JBButil.getLog().exiting("spec.jbb.JBBmain", "runWarehouse");
        return true;
    }

    public String commandLineParser(String[] stringArray) {
        String string = null;
        if (stringArray.length == 0) {
            string = defaultPropsFileName;
        } else if (stringArray[0].equals("-id")) {
            instanceId = Integer.parseInt(stringArray[1]);
        } else if (stringArray[0].equals("-propfile")) {
            if (stringArray.length == 2) {
                string = stringArray[1];
            } else if (stringArray.length == 1) {
                System.out.println("Missing properties file name");
                System.out.println("   Parameters:  -propfile <properties_file_name> [-id <instance_id>]");
            } else if (stringArray.length == 4 && stringArray[2].equals("-id")) {
                string = stringArray[1];
                instanceId = Integer.parseInt(stringArray[3]);
            } else {
                System.out.println("Too many parameters");
                System.out.println("   Parameters:  -propfile <properties_file_name> [-id <instance_id>]");
            }
        } else {
            System.out.println("Unrecognized command line parameter:  " + stringArray[0]);
            System.out.println("   Parameters:  -propfile <properties_file_name>");
        }
        return string;
    }

    public boolean initOutputDir(String string) {
        File file;
        if (string == null) {
            string = defaultOutputDir;
        }
        if ((file = new File(string)).exists()) {
            if (!file.isDirectory()) {
                System.out.println("ERROR:  Specified input.output_directory is not a directory:  " + string);
                return false;
            }
        } else if (!file.mkdirs()) {
            System.out.println("ERROR:  Cannot create input.output_directory:  " + string);
            return false;
        }
        return true;
    }

    public void callReporter(String string, String string2, String string3, String string4) {
        Report report;
        Object object;
        String string5 = "Calling Reporter";
        JBButil.getLog().info(string5);
        System.out.println();
        System.out.println();
        System.out.println(string5);
        boolean bl = true;
        boolean bl2 = false;
        String string6 = string2;
        String string7 = string4;
        boolean bl3 = false;
        String string8 = null;
        String string9 = string + File.separator + string3 + string4 + ".html";
        String string10 = string + File.separator + string3 + string4 + ".txt";
        String string11 = null;
        Object var15_15 = null;
        boolean bl4 = false;
        try {
            object = new TextiReport(string8, string6, bl3);
            ((TextiReport)object).print(string10);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            report = new Report(bl, bl3, string8, string6, bl4, string11, string7, bl2, string);
        }
        catch (Exception exception) {
            bl2 = true;
            JBButil.getLog().warning("Producing html chart in report instead of JPEG; see Users' Guide");
            report = new Report(bl, bl3, string8, string6, bl4, string11, string7, bl2, string);
        }
        catch (InternalError internalError) {
            bl2 = true;
            JBButil.getLog().warning("Producing html chart in report instead of JPEG; see Users' Guide");
            report = new Report(bl, bl3, string8, string6, bl4, string11, string7, bl2, string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl2 = true;
            JBButil.getLog().warning("Producing html chart in report instead of JPEG; see Users' Guide");
            report = new Report(bl, bl3, string8, string6, bl4, string11, string7, bl2, string);
        }
        catch (Error error) {
            bl2 = true;
            JBButil.getLog().warning("Producing html chart in report instead of JPEG; see Users' Guide");
            report = new Report(bl, bl3, string8, string6, bl4, string11, string7, bl2, string);
        }
        report.print(string9);
        try {
            String string12;
            object = new BufferedReader(new FileReader(string10));
            while ((string12 = ((BufferedReader)object).readLine()) != null) {
                System.out.println(string12);
            }
        }
        catch (IOException iOException) {
            JBButil.getLog().log(Level.WARNING, "Error opening ASCII output file", iOException);
        }
        System.out.println("Output files: " + string10 + ", " + string2 + ", " + string9);
        System.out.println();
        System.out.println();
        System.out.println("Reporter messages:");
        System.out.println(report.messages());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        String string = "SPECjbb.";
        String string2 = ".raw";
        boolean bl3 = !Check.doCheck();
        JBBmain jBBmain = new JBBmain();
        jBBmain.warehousePopulationBase = 30;
        jBBmain.orderlinesPerOrder = 10;
        jBBmain.waitTimePercent = 0;
        jBBmain.forceGC = false;
        jBBmain.screenWriteFlag = false;
        jBBmain.steadyStateFlag = true;
        uniformRandomItems = true;
        String string3 = System.setProperty("java.awt.headless", "true");
        PrintStream printStream = null;
        PrintStream printStream2 = null;
        JBButil.setLog(Logger.getLogger("global"));
        JBButil.getLog().setLevel(Level.WARNING);
        try {
            Handler[] handlerArray;
            int n;
            Object object;
            Object object22;
            Object object3;
            String string4;
            String string5;
            try {
                printStream = new PrintStream(new FileOutputStream("JBB.temp.scratch1"));
                printStream2 = new PrintStream(new FileOutputStream("JBB.temp.scratch2"));
            }
            catch (IOException iOException) {
                JBButil.getLog().log(Level.WARNING, "VALIDATION ERROR:  IOException: " + iOException.getMessage(), iOException);
            }
            Company.setOutputs(printStream, printStream2);
            boolean bl4 = jBBmain.doItForValidation();
            jBBmain = null;
            printStream.close();
            printStream2.close();
            Handler[] handlerArray2 = new File("JBB.temp.scratch1");
            handlerArray2.delete();
            handlerArray2 = new File("JBB.temp.scratch2");
            handlerArray2.delete();
            jBBmain = new JBBmain();
            jBBmain.prop = new JBBProperties(jBBmain.commandLineParser(stringArray));
            if (!jBBmain.prop.getProps()) {
                System.out.println("ERROR:  Properties File error; please start again");
                return;
            }
            if (jBBmain.prop.jvm_instances > 1) {
                multiJVMMode = true;
            }
            if (!multiJVMMode) {
                string5 = jBBmain.prop.getOptionalProperty("input.output_directory") + File.separator + "SPECjbbSingleJVM";
                if (!jBBmain.initOutputDir(string5)) {
                    return;
                }
            } else {
                string4 = jBBmain.prop.getOptionalProperty("input.output_directory");
                object3 = new RunSequencer(string4, "SPECjbbMultiJVM.", "");
                string5 = string4 + File.separator + "SPECjbbMultiJVM." + ((RunSequencer)object3).padNumber(((RunSequencer)object3).getSeq() - 1);
            }
            if (jBBmain.prop.jvm_instances > 1) {
                string4 = String.valueOf(instanceId);
                object3 = string4;
                string4 = "" + (String)object3;
                int n2 = string4.length();
                if (n2 == 1) {
                    string4 = "00" + string4;
                }
                if (n2 == 2) {
                    string4 = "0" + string4;
                }
            } else {
                object3 = new RunSequencer(string5, string, string2);
                string4 = ((RunSequencer)object3).getSeqString();
            }
            object3 = string5 + File.separator + "SPECjbb." + string4 + ".results";
            String string6 = string5 + File.separator + string + string4 + string2;
            String string7 = string5 + File.separator + "SPECjbb." + string4 + ".deliveries";
            String string8 = string5 + File.separator + "SPECjbb." + string4 + ".log";
            System.out.println("The results will be in: " + string6);
            try {
                SaveOutput.start((String)object3);
                System.out.println("Opened " + (String)object3);
                outRawFile = new PrintStream(new FileOutputStream(string6));
                System.out.println("Opened " + string6);
                outDeliveriesFile = new PrintStream(new FileOutputStream(string7));
            }
            catch (IOException iOException) {
                JBButil.getLog().log(Level.WARNING, "ERROR:  IOException: " + iOException.getMessage(), iOException);
            }
            Company.setOutputs(outRawFile, outDeliveriesFile);
            for (Object object22 : Header) {
                System.out.println((String)object22);
            }
            System.out.println("");
            System.out.println("Benchmark SPECjbb2005 1.05 now Opening");
            System.out.println("");
            maxWh = jBBmain.prop.sequenceOfWarehouses == null ? jBBmain.prop.endingNumberWarehouses + 1 : jBBmain.prop.sequenceOfWarehouses[jBBmain.prop.sequenceOfWarehouses.length - 1] + 1;
            if (!jBBmain.initApplicationLogging(string8)) {
                System.out.println("ERROR:  Logging initialization failed!");
                return;
            }
            JBButil.getLog().info("Logging started");
            jBBmain.prop.setProp("config.benchmark_version", Version);
            jBBmain.prop.setProp("config.benchmark_versionDate", VersionDate);
            jBBmain.prop.setProp("config.test.date", DateFormat.getDateInstance().format(new Date()));
            if (!jBBmain.prop.copyPropsToOutput(outRawFile)) {
                System.out.println("ERROR:  Properties File error; please start again");
                return;
            }
            Object object4 = jBBmain.prop.setProp("result.validity.200_check", new Boolean(bl3).toString());
            outRawFile.println("result.validity.200_check=" + (String)object4);
            object4 = jBBmain.prop.setProp("result.validity.jbb_operation", new Boolean(bl4).toString());
            outRawFile.println("result.validity.jbb_operation=" + (String)object4);
            digest digest2 = new digest();
            int n3 = digest2.crunch_jar("jbb.jar") ? 1 : 0;
            object4 = jBBmain.prop.setProp("result.validity.999_checkit", new Boolean(n3 != 0).toString());
            outRawFile.println("result.validity.999_checkit=" + (String)object4);
            jBBmain.prop.checkCompliance();
            jBBmain.flushLog();
            if (multiJVMMode) {
                object22 = "Running Multi-JVM Test: socket " + (port + instanceId);
                JBButil.getLog().info((String)object22);
                System.out.println((String)object22);
                object = null;
                boolean bl5 = false;
                n = 0;
                while (!bl5 && n < 10) {
                    try {
                        if (++n > 1) {
                            Thread.sleep(5000L);
                        }
                        object = new Socket("localhost", port + instanceId);
                        bl5 = true;
                    }
                    catch (Exception exception) {
                        bl5 = false;
                    }
                }
                if (n == 10) {
                    JBButil.getLog().warning("10 failed socket connection attempts. Exiting..");
                    return;
                }
                try {
                    socIn = new BufferedReader(new InputStreamReader(((Socket)object).getInputStream()));
                }
                catch (Exception exception) {
                    Handler[] handlerArray3;
                    JBButil.getLog().log(Level.WARNING, exception + ": error in setting socket input", exception);
                    JBButil.getLog().info("Logging ended");
                    for (Handler handler : handlerArray3 = JBButil.getLog().getHandlers()) {
                        handler.close();
                    }
                    return;
                }
                try {
                    socOut = new PrintWriter(new OutputStreamWriter(((Socket)object).getOutputStream()));
                }
                catch (Exception exception) {
                    Handler[] handlerArray4;
                    JBButil.getLog().log(Level.WARNING, exception + ": error in setting socket out", exception);
                    JBButil.getLog().info("Logging ended");
                    for (Handler handler : handlerArray4 = JBButil.getLog().getHandlers()) {
                        handler.close();
                    }
                    return;
                }
            }
            jBBmain.doIt();
            jBBmain.flushLog();
            if (JBBProperties.printPropertiesAndArgs) {
                object22 = System.getProperties();
                object = ((Properties)object22).keySet();
                Vector<Object> vector = new Vector<Object>((Collection<Object>)object);
                Collections.sort(vector);
                for (n = 0; n < vector.size(); ++n) {
                    handlerArray = (Handler[])vector.elementAt(n);
                    Handler[] handlerArray5 = ((Properties)object22).getProperty((String)handlerArray);
                    outRawFile.println((String)handlerArray + "=" + (String)handlerArray5);
                }
                outRawFile.print("input.cmdline=");
                for (n = 0; n < stringArray.length; ++n) {
                    outRawFile.print(stringArray[n] + " ");
                }
                outRawFile.println();
            }
            jBBmain.callReporter(string5, string6, string, string4);
            outDeliveriesFile.close();
            outRawFile.close();
            if (multiJVMMode) {
                object22 = instanceId + ":FINISHED";
                object = instanceId + ":EXIT";
                JBButil.getLog().info((String)object22);
                System.out.println((String)object22);
                socOut.println((String)object22);
                System.out.println("Sent FINISHED message");
                socOut.flush();
                String string9 = "NULL";
                try {
                    while (string9 != null && !string9.matches((String)object)) {
                        string9 = socIn.readLine();
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (SocketException socketException) {
                }
                catch (Exception exception) {
                    JBButil.getLog().log(Level.WARNING, exception + ": error awaiting final exit message", exception);
                    JBButil.getLog().info("Logging ended");
                    for (Handler handler : handlerArray = JBButil.getLog().getHandlers()) {
                        handler.close();
                    }
                    return;
                }
                System.out.println("Final EXIT reached");
            }
            SaveOutput.stop();
        }
        finally {
            Handler[] handlerArray;
            JBButil.getLog().info("Logging ended");
            for (Handler handler : handlerArray = JBButil.getLog().getHandlers()) {
                handler.close();
            }
        }
        System.exit(0);
    }

    private boolean initApplicationLogging(String string) {
        StreamHandler streamHandler = null;
        try {
            streamHandler = new StreamHandler(new FileOutputStream(string), new JBBLogFormatter());
        }
        catch (FileNotFoundException fileNotFoundException) {
            JBButil.getLog().log(Level.WARNING, "ERROR:  Unable to open logging file " + string, fileNotFoundException);
            return false;
        }
        streamHandler.setLevel(this.prop.getApplicationLoggingLevel());
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.WARNING);
        Logger logger = Logger.getLogger("spec.jbb");
        logger.setLevel(this.prop.getApplicationLoggingLevel());
        logger.setUseParentHandlers(false);
        logger.addHandler(streamHandler);
        logger.addHandler(consoleHandler);
        this.flushLog();
        JBButil.setLog(logger);
        return true;
    }

    private void flushLog() {
        Handler[] handlerArray;
        for (Handler handler : handlerArray = JBButil.getLog().getHandlers()) {
            handler.flush();
        }
    }

    static {
        overrideItemTableSize = 0;
        maxWh = 2;
        outResultsFile = null;
        outRawFile = null;
        outDeliveriesFile = null;
        multiJVMMode = false;
        instanceId = -1;
        port = 1500;
        defaultOutputDir = "results";
        defaultPropsFileName = "SPECjbb.props";
    }
}

