/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef EXTINFOS_H
#define EXTINFOS_H

#include <visu_extension.h>
#include <visu_nodes.h>
#include <visu_data.h>
#include <openGLFunctions/view.h>
#include <extraFunctions/dataNode.h>

/**
 * VisuGlExtInfosDrawId:
 * @DRAW_NEVER: don't draw any information on nodes ;
 * @DRAW_SELECTED: draw information only on a list of nodes ;
 * @DRAW_ALWAYS: draw information on all nodes.
 *
 * This enum represents the possibilities for the information drawing.
 */
typedef enum
  {
    DRAW_NEVER,
    DRAW_SELECTED,
    DRAW_ALWAYS
  } VisuGlExtInfosDrawId;
/**
 * VisuGlExtInfosDrawMethod:
 * @EXT_DRAW_METH_NONE: draw nothing ;
 * @EXT_DRAW_METH_ID: draw the id of nodes ;
 * @EXT_DRAW_METH_TYPE: draw the name of node element ;
 * @EXT_DRAW_METH_OTHER: other possible draw rendering method.
 *
 * This enum represents the method for information drawing.
 */
typedef enum
  {
    EXT_DRAW_METH_NONE,
    EXT_DRAW_METH_ID,
    EXT_DRAW_METH_TYPE,
    EXT_DRAW_METH_OTHER
  } VisuGlExtInfosDrawMethod;

/**
 * VISU_TYPE_GL_EXT_INFOS:
 *
 * return the type of #VisuGlExtInfos.
 *
 * Since: 3.7
 */
#define VISU_TYPE_GL_EXT_INFOS	     (visu_gl_ext_infos_get_type ())
/**
 * VISU_GL_EXT_INFOS:
 * @obj: a #GObject to cast.
 *
 * Cast the given @obj into #VisuGlExtInfos type.
 *
 * Since: 3.7
 */
#define VISU_GL_EXT_INFOS(obj)	     (G_TYPE_CHECK_INSTANCE_CAST(obj, VISU_TYPE_GL_EXT_INFOS, VisuGlExtInfos))
/**
 * VISU_GL_EXT_INFOS_CLASS:
 * @klass: a #GObjectClass to cast.
 *
 * Cast the given @klass into #VisuGlExtInfosClass.
 *
 * Since: 3.7
 */
#define VISU_GL_EXT_INFOS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST(klass, VISU_TYPE_GL_EXT_INFOS, VisuGlExtInfosClass))
/**
 * VISU_IS_GL_EXT_INFOS:
 * @obj: a #GObject to test.
 *
 * Test if the given @ogj is of the type of #VisuGlExtInfos object.
 *
 * Since: 3.7
 */
#define VISU_IS_GL_EXT_INFOS(obj)    (G_TYPE_CHECK_INSTANCE_TYPE(obj, VISU_TYPE_GL_EXT_INFOS))
/**
 * VISU_IS_GL_EXT_INFOS_CLASS:
 * @klass: a #GObjectClass to test.
 *
 * Test if the given @klass is of the type of #VisuGlExtInfosClass class.
 *
 * Since: 3.7
 */
#define VISU_IS_GL_EXT_INFOS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE(klass, VISU_TYPE_GL_EXT_INFOS))
/**
 * VISU_GL_EXT_INFOS_GET_CLASS:
 * @obj: a #GObject to get the class of.
 *
 * It returns the class of the given @obj.
 *
 * Since: 3.7
 */
#define VISU_GL_EXT_INFOS_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS(obj, VISU_TYPE_GL_EXT_INFOS, VisuGlExtInfosClass))

typedef struct _VisuGlExtInfos        VisuGlExtInfos;
typedef struct _VisuGlExtInfosPrivate VisuGlExtInfosPrivate;
typedef struct _VisuGlExtInfosClass   VisuGlExtInfosClass;

struct _VisuGlExtInfos
{
  VisuGlExt parent;

  VisuGlExtInfosPrivate *priv;
};

struct _VisuGlExtInfosClass
{
  VisuGlExtClass parent;
};

/**
 * VISU_GL_EXT_INFOS_ID:
 *
 * The id used to identify this extension, see
 * visu_gl_ext_rebuild() for instance.
 */
#define VISU_GL_EXT_INFOS_ID "Node information"

/**
 * visu_gl_ext_infos_get_type:
 *
 * This method returns the type of #VisuGlExtInfos, use
 * VISU_TYPE_GL_EXT_INFOS instead.
 *
 * Since: 3.7
 *
 * Returns: the type of #VisuGlExtInfos.
 */
GType visu_gl_ext_infos_get_type(void);

VisuGlExtInfos* visu_gl_ext_infos_new(const gchar *name);

gboolean visu_gl_ext_infos_setGlView(VisuGlExtInfos *infos, VisuGlView *view);
gboolean visu_gl_ext_infos_setData(VisuGlExtInfos *infos, VisuData *data);

gboolean visu_gl_ext_infos_drawIds(VisuGlExtInfos *infos, int *nodes);
gboolean visu_gl_ext_infos_drawElements(VisuGlExtInfos *infos, int *nodes);
gboolean visu_gl_ext_infos_drawData(VisuGlExtInfos *infos, VisuDataNode *dataNode, int *nodes);
void visu_gl_ext_infos_draw(VisuGlExtInfos *infos);

VisuGlExtInfos* visu_gl_ext_infos_getDefault();

#endif
