[vset VERSION 2.0]
[comment {-*- tcl -*- doctools manpage}]
[manpage_begin fileutil::magic::rt n [vset VERSION]]
[see_also file(1)]
[see_also fileutil]
[see_also magic(5)]
[keywords {file recognition}]
[keywords {file type}]
[keywords {file utilities}]
[keywords mime]
[keywords type]
[moddesc   {file utilities}]
[titledesc {Runtime core for file type recognition engines written in pure Tcl}]
[category  {Programming tools}]
[require Tcl 8.5]
[require fileutil::magic::rt [opt [vset VERSION]]]
[description]
[para]

This package provides the runtime core for file type recognition
engines written in pure Tcl and is thus used by all other packages in
this module such as [package fileutil::magic::filetype] and the two compiler
packages [package fileutil::magic::cgen] and
[package fileutil::magic::cfront].

[section COMMANDS]

[list_begin definitions]


[call [cmd ::fileutil::magic::rt::>]] 

Increment the level and perform related housekeeping


[call [cmd ::fileutil::magic::rt::<]] 

Decrement the level and perform related housekeeping


[call [cmd ::fileutil::magic::rt::new] [arg chan] [arg named] [arg analyze]]

Create a new command which returns one description of the file each time it is
called, and a code of [arg break] when there are no more descriptions.

[arg chan] is the channel containing the data to describe.  The channel
configuration is then managed as needed.

[arg named] is a dictionary of named tests, as generated by
[cmd fileutil::magic::cfront::compile].

[arg test] is a command prefix for a routine composed of the list of commands
as returned by [cmd fileutil::magic::cfront::compile].


[call [cmd ::fileutil::magic::rt::file_start] [arg name]]

This command marks the start of a magic file when debugging. It
returns the empty string as its result.


[call [cmd ::fileutil::magic::rt::emit] [arg msg]]

This command adds the text [arg msg] to the result buffer. The
message may contain the following special character sequences. They
will be replaced with buffered values before the message is added to
the result. The command returns the empty string as its result.

[list_begin definitions]
[def [const \\b]] This sequence is removed
[def [const %s]]  Replaced with the last buffered string value.
[def [const %ld]] Replaced with the last buffered numeric value.
[def [const %d]]  See above.
[def [const {${x:...?...}}]] Substitute one string if the file is executable, and
another string otherwise.
[list_end]


[call [cmd ::fileutil::magic::rt::O] [arg where]]

Produce an offset from [arg where], relative to the cursor one level up.


[comment [call [cmd ::fileutil::magic::rt::R] [arg where]]]

Produce an offset from [arg where], relative to the offset one level up.

[call [cmd ::fileutil::magic::rt::Nv] [arg type] [arg offset] [
    arg compinvert] [arg comp] [arg expected]]

A limited form of [cmd ::fileutile::magic::rt::N] that only checks for
equality and can't be told to invert the test.



[call [cmd ::fileutil::magic::rt::N] [arg type] [arg offset] [arg testinvert] [
    arg compinvert] [arg mod] [arg mand] [arg comp] [arg expected]]

Fetch the numeric value with [arg type] from the absolute location
[arg offset], compare it with [arg expected] using [arg comp] as the comparision
operator,  and returns the result.

[para]

The argument [arg comp] must be one of Tcl's comparison
operators.

[example {
	<comp> <fetched-and-masked-value> <comp> <expected>
}]

[para]

The special comparison operator [const x] signals that no comparison
should be done, or, in other words, that the fetched value will always
match [arg val].


[call [cmd ::fileutil::magic::rt::S] [arg type] [arg offset] [arg testinvert] [
    arg mod] [arg mand] [arg comp] [arg val]]

Like [cmd ::fileutil::magic::rt::N] except that it fetches and compares string
types , not numeric data.


[call [cmd ::fileutil::magic::rt::L] [arg newlevel]]

Sets the current level in the calling context to
[arg newlevel]. The command returns the empty string as its result.

[call [cmd ::fileutil::magic::rt::I] [arg offset] [arg it] [arg ioi] [arg ioo] [
    arg iir] [arg io]]

Calculates an offset based on an initial offset and the provided modifiers.


[call [cmd ::fileutil::magic::rt::R] [arg offset]]

Given an initial offset, calculates an offset relative to the cursor at the
next level up. The cursor is the position in the data one character after the
data extracted from the file one level up.

[para]


[call [cmd ::fileutil::magic::rt::U] [arg fileindex] [arg name]]

Add a level and use a named test script.

[list_end]

[section {NUMERIC TYPES}]

[list_begin definitions]
[def [const byte]]    8-bit integer
[def [const short]]   16-bit integer, stored in native endianess
[def [const beshort]] see above, stored in big endian
[def [const leshort]] see above, stored in small/little endian
[def [const long]]    32-bit integer, stored in native endianess
[def [const belong]]  see above, stored in big endian
[def [const lelong]]  see above, stored in small/little endian
[list_end]

All of the types above exit in an unsigned form as well. The type
names are the same, with the character "u" added as prefix.

[list_begin definitions]
[def [const date]]    32-bit integer timestamp, stored in native endianess
[def [const bedate]]  see above, stored in big endian
[def [const ledate]]  see above, stored in small/little endian
[def [const ldate]]   32-bit integer timestamp, stored in native endianess
[def [const beldate]] see above, stored in big endian
[def [const leldate]] see above, stored in small/little endian
[list_end]

[vset CATEGORY {fileutil :: magic}]
[include ../common-text/feedback.inc]
[manpage_end]
