/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * AtFS -- Attribute Filesystem
 *
 * afarchive.h - Constant-Definitions for AtFS-archives
 *
 * Author: Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
 *
 * $Header: afarchive.h[7.0] Fri Jun 25 14:32:45 1993 andy@cs.tu-berlin.de frozen $
 */

/*=========================================================================
 * Internal Installation dependent constants
 *=========================================================================*/

#define AF_NEWREVS         8	/* add. space for new revisions in rev list */
#define AF_MAXLISTS      211    /* maximum number of read-in archives */
#define AF_MAXMEM    1000000    /* maximum size of memory occupied by */
                                /* read in archives */
#define AF_LISTSEG         8    /* size of segments of revlists-list */
#define AF_UDASEGSIZ     512    /* size of memory segment for UDAs */

/*=========================================================================
 * Identification strings in archive and derived object cache files
 *=========================================================================*/

#define AF_LINESIZ      1024            /* size of input line */

#define AF_SEGSTRLEN    5
#define AF_ARHEADER 	"\02ARHD"	/* Header of Archive-file */
#define AF_DATAHEADER 	"\02DATA"	/* Header of Data-file */
#define AF_CACHEHEADER	"\02OCHD"	/* Header of Cache Control file */
#define AF_UDASEG 	"\02USEG"	/* User defined attributes Segment */

#define AF_IDSTRLEN 	2
#define AF_NAMEID	"\02I" 	/* Identification path, name, type */ 
#define AF_OWNID	"\02O" 	/* Owner */
#define AF_PRDID	"\02P" 	/* predecessor of busy version */
#define AF_LOCKID	"\02L" 	/* Lock */
#define AF_REVID	"\02R" 	/* revision specific attributes */
				/* gen, rev, state, mode */
#define AF_AUTHORID	"\02A" 	/* Author */
#define AF_DATEID	"\02T" 	/* date of last mod., last access, */
				/* creation, save */
#define AF_REPRID	"\02M" 	/* kind of represetation, size of file, size */
				/* of delta and other delta stuff (tree) */
#define AF_NOTEID	"\02N" 	/* gen, rev, size, text of note */
#define AF_UDAID	"\02U" 	/* gen, rev, size, text of udattrs */
#define AF_DATAID	"\02D" 	/* gen, rev, size, repr, text of data */

/*======================================================================
 * other constants
 *======================================================================*/

#define AF_ARCURVERS	4
#define AF_CACHECURVERS	2

#define AF_NOSTRING     "\01$"

/*=========================================================================
 * Useful macros and function definitions
 *=========================================================================*/

/* test if string is empty */
#define NOTMT(str) ((str && str[0]) ? str : AF_NOSTRING)

#ifdef __STDC__
#define A(alist) alist
#else
#define A(alist) ()
#endif

char	*afFirstItem	A((char *line));
char	*afNextItem	A((char *line));
