// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Accessible;
use crate::AccessibleRole;
use crate::Align;
use crate::Buildable;
use crate::CellEditable;
use crate::ConstraintTarget;
use crate::Editable;
use crate::EntryBuffer;
use crate::EntryCompletion;
use crate::EntryIconPosition;
use crate::ImageType;
use crate::InputHints;
use crate::InputPurpose;
use crate::LayoutManager;
use crate::Overflow;
use crate::Widget;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectExt;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkEntry")]
    pub struct Entry(Object<ffi::GtkEntry, ffi::GtkEntryClass>) @extends Widget, @implements Accessible, Buildable, ConstraintTarget, CellEditable, Editable;

    match fn {
        type_ => || ffi::gtk_entry_get_type(),
    }
}

impl Entry {
    #[doc(alias = "gtk_entry_new")]
    pub fn new() -> Entry {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_entry_new()).unsafe_cast() }
    }

    #[doc(alias = "gtk_entry_new_with_buffer")]
    #[doc(alias = "new_with_buffer")]
    pub fn with_buffer(buffer: &impl IsA<EntryBuffer>) -> Entry {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_entry_new_with_buffer(
                buffer.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Entry`] objects.
    ///
    /// This method returns an instance of [`EntryBuilder`] which can be used to create [`Entry`] objects.
    pub fn builder() -> EntryBuilder {
        EntryBuilder::default()
    }
}

impl Default for Entry {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Entry`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct EntryBuilder {
    activates_default: Option<bool>,
    attributes: Option<pango::AttrList>,
    buffer: Option<EntryBuffer>,
    completion: Option<EntryCompletion>,
    enable_emoji_completion: Option<bool>,
    extra_menu: Option<gio::MenuModel>,
    has_frame: Option<bool>,
    im_module: Option<String>,
    input_hints: Option<InputHints>,
    input_purpose: Option<InputPurpose>,
    invisible_char: Option<u32>,
    invisible_char_set: Option<bool>,
    max_length: Option<i32>,
    overwrite_mode: Option<bool>,
    placeholder_text: Option<String>,
    primary_icon_activatable: Option<bool>,
    primary_icon_gicon: Option<gio::Icon>,
    primary_icon_name: Option<String>,
    primary_icon_paintable: Option<gdk::Paintable>,
    primary_icon_sensitive: Option<bool>,
    primary_icon_tooltip_markup: Option<String>,
    primary_icon_tooltip_text: Option<String>,
    progress_fraction: Option<f64>,
    progress_pulse_step: Option<f64>,
    secondary_icon_activatable: Option<bool>,
    secondary_icon_gicon: Option<gio::Icon>,
    secondary_icon_name: Option<String>,
    secondary_icon_paintable: Option<gdk::Paintable>,
    secondary_icon_sensitive: Option<bool>,
    secondary_icon_tooltip_markup: Option<String>,
    secondary_icon_tooltip_text: Option<String>,
    show_emoji_icon: Option<bool>,
    tabs: Option<pango::TabArray>,
    truncate_multiline: Option<bool>,
    visibility: Option<bool>,
    can_focus: Option<bool>,
    can_target: Option<bool>,
    css_classes: Option<Vec<String>>,
    css_name: Option<String>,
    cursor: Option<gdk::Cursor>,
    focus_on_click: Option<bool>,
    focusable: Option<bool>,
    halign: Option<Align>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    layout_manager: Option<LayoutManager>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    opacity: Option<f64>,
    overflow: Option<Overflow>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
    accessible_role: Option<AccessibleRole>,
    editing_canceled: Option<bool>,
    editable: Option<bool>,
    enable_undo: Option<bool>,
    max_width_chars: Option<i32>,
    text: Option<String>,
    width_chars: Option<i32>,
    xalign: Option<f32>,
}

impl EntryBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`EntryBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Entry`].
    pub fn build(self) -> Entry {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref activates_default) = self.activates_default {
            properties.push(("activates-default", activates_default));
        }
        if let Some(ref attributes) = self.attributes {
            properties.push(("attributes", attributes));
        }
        if let Some(ref buffer) = self.buffer {
            properties.push(("buffer", buffer));
        }
        if let Some(ref completion) = self.completion {
            properties.push(("completion", completion));
        }
        if let Some(ref enable_emoji_completion) = self.enable_emoji_completion {
            properties.push(("enable-emoji-completion", enable_emoji_completion));
        }
        if let Some(ref extra_menu) = self.extra_menu {
            properties.push(("extra-menu", extra_menu));
        }
        if let Some(ref has_frame) = self.has_frame {
            properties.push(("has-frame", has_frame));
        }
        if let Some(ref im_module) = self.im_module {
            properties.push(("im-module", im_module));
        }
        if let Some(ref input_hints) = self.input_hints {
            properties.push(("input-hints", input_hints));
        }
        if let Some(ref input_purpose) = self.input_purpose {
            properties.push(("input-purpose", input_purpose));
        }
        if let Some(ref invisible_char) = self.invisible_char {
            properties.push(("invisible-char", invisible_char));
        }
        if let Some(ref invisible_char_set) = self.invisible_char_set {
            properties.push(("invisible-char-set", invisible_char_set));
        }
        if let Some(ref max_length) = self.max_length {
            properties.push(("max-length", max_length));
        }
        if let Some(ref overwrite_mode) = self.overwrite_mode {
            properties.push(("overwrite-mode", overwrite_mode));
        }
        if let Some(ref placeholder_text) = self.placeholder_text {
            properties.push(("placeholder-text", placeholder_text));
        }
        if let Some(ref primary_icon_activatable) = self.primary_icon_activatable {
            properties.push(("primary-icon-activatable", primary_icon_activatable));
        }
        if let Some(ref primary_icon_gicon) = self.primary_icon_gicon {
            properties.push(("primary-icon-gicon", primary_icon_gicon));
        }
        if let Some(ref primary_icon_name) = self.primary_icon_name {
            properties.push(("primary-icon-name", primary_icon_name));
        }
        if let Some(ref primary_icon_paintable) = self.primary_icon_paintable {
            properties.push(("primary-icon-paintable", primary_icon_paintable));
        }
        if let Some(ref primary_icon_sensitive) = self.primary_icon_sensitive {
            properties.push(("primary-icon-sensitive", primary_icon_sensitive));
        }
        if let Some(ref primary_icon_tooltip_markup) = self.primary_icon_tooltip_markup {
            properties.push(("primary-icon-tooltip-markup", primary_icon_tooltip_markup));
        }
        if let Some(ref primary_icon_tooltip_text) = self.primary_icon_tooltip_text {
            properties.push(("primary-icon-tooltip-text", primary_icon_tooltip_text));
        }
        if let Some(ref progress_fraction) = self.progress_fraction {
            properties.push(("progress-fraction", progress_fraction));
        }
        if let Some(ref progress_pulse_step) = self.progress_pulse_step {
            properties.push(("progress-pulse-step", progress_pulse_step));
        }
        if let Some(ref secondary_icon_activatable) = self.secondary_icon_activatable {
            properties.push(("secondary-icon-activatable", secondary_icon_activatable));
        }
        if let Some(ref secondary_icon_gicon) = self.secondary_icon_gicon {
            properties.push(("secondary-icon-gicon", secondary_icon_gicon));
        }
        if let Some(ref secondary_icon_name) = self.secondary_icon_name {
            properties.push(("secondary-icon-name", secondary_icon_name));
        }
        if let Some(ref secondary_icon_paintable) = self.secondary_icon_paintable {
            properties.push(("secondary-icon-paintable", secondary_icon_paintable));
        }
        if let Some(ref secondary_icon_sensitive) = self.secondary_icon_sensitive {
            properties.push(("secondary-icon-sensitive", secondary_icon_sensitive));
        }
        if let Some(ref secondary_icon_tooltip_markup) = self.secondary_icon_tooltip_markup {
            properties.push((
                "secondary-icon-tooltip-markup",
                secondary_icon_tooltip_markup,
            ));
        }
        if let Some(ref secondary_icon_tooltip_text) = self.secondary_icon_tooltip_text {
            properties.push(("secondary-icon-tooltip-text", secondary_icon_tooltip_text));
        }
        if let Some(ref show_emoji_icon) = self.show_emoji_icon {
            properties.push(("show-emoji-icon", show_emoji_icon));
        }
        if let Some(ref tabs) = self.tabs {
            properties.push(("tabs", tabs));
        }
        if let Some(ref truncate_multiline) = self.truncate_multiline {
            properties.push(("truncate-multiline", truncate_multiline));
        }
        if let Some(ref visibility) = self.visibility {
            properties.push(("visibility", visibility));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref can_target) = self.can_target {
            properties.push(("can-target", can_target));
        }
        if let Some(ref css_classes) = self.css_classes {
            properties.push(("css-classes", css_classes));
        }
        if let Some(ref css_name) = self.css_name {
            properties.push(("css-name", css_name));
        }
        if let Some(ref cursor) = self.cursor {
            properties.push(("cursor", cursor));
        }
        if let Some(ref focus_on_click) = self.focus_on_click {
            properties.push(("focus-on-click", focus_on_click));
        }
        if let Some(ref focusable) = self.focusable {
            properties.push(("focusable", focusable));
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref layout_manager) = self.layout_manager {
            properties.push(("layout-manager", layout_manager));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref overflow) = self.overflow {
            properties.push(("overflow", overflow));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        if let Some(ref accessible_role) = self.accessible_role {
            properties.push(("accessible-role", accessible_role));
        }
        if let Some(ref editing_canceled) = self.editing_canceled {
            properties.push(("editing-canceled", editing_canceled));
        }
        if let Some(ref editable) = self.editable {
            properties.push(("editable", editable));
        }
        if let Some(ref enable_undo) = self.enable_undo {
            properties.push(("enable-undo", enable_undo));
        }
        if let Some(ref max_width_chars) = self.max_width_chars {
            properties.push(("max-width-chars", max_width_chars));
        }
        if let Some(ref text) = self.text {
            properties.push(("text", text));
        }
        if let Some(ref width_chars) = self.width_chars {
            properties.push(("width-chars", width_chars));
        }
        if let Some(ref xalign) = self.xalign {
            properties.push(("xalign", xalign));
        }
        glib::Object::new::<Entry>(&properties).expect("Failed to create an instance of Entry")
    }

    pub fn activates_default(mut self, activates_default: bool) -> Self {
        self.activates_default = Some(activates_default);
        self
    }

    pub fn attributes(mut self, attributes: &pango::AttrList) -> Self {
        self.attributes = Some(attributes.clone());
        self
    }

    pub fn buffer(mut self, buffer: &impl IsA<EntryBuffer>) -> Self {
        self.buffer = Some(buffer.clone().upcast());
        self
    }

    pub fn completion(mut self, completion: &EntryCompletion) -> Self {
        self.completion = Some(completion.clone());
        self
    }

    pub fn enable_emoji_completion(mut self, enable_emoji_completion: bool) -> Self {
        self.enable_emoji_completion = Some(enable_emoji_completion);
        self
    }

    pub fn extra_menu(mut self, extra_menu: &impl IsA<gio::MenuModel>) -> Self {
        self.extra_menu = Some(extra_menu.clone().upcast());
        self
    }

    pub fn has_frame(mut self, has_frame: bool) -> Self {
        self.has_frame = Some(has_frame);
        self
    }

    pub fn im_module(mut self, im_module: &str) -> Self {
        self.im_module = Some(im_module.to_string());
        self
    }

    pub fn input_hints(mut self, input_hints: InputHints) -> Self {
        self.input_hints = Some(input_hints);
        self
    }

    pub fn input_purpose(mut self, input_purpose: InputPurpose) -> Self {
        self.input_purpose = Some(input_purpose);
        self
    }

    pub fn invisible_char(mut self, invisible_char: u32) -> Self {
        self.invisible_char = Some(invisible_char);
        self
    }

    pub fn invisible_char_set(mut self, invisible_char_set: bool) -> Self {
        self.invisible_char_set = Some(invisible_char_set);
        self
    }

    pub fn max_length(mut self, max_length: i32) -> Self {
        self.max_length = Some(max_length);
        self
    }

    pub fn overwrite_mode(mut self, overwrite_mode: bool) -> Self {
        self.overwrite_mode = Some(overwrite_mode);
        self
    }

    pub fn placeholder_text(mut self, placeholder_text: &str) -> Self {
        self.placeholder_text = Some(placeholder_text.to_string());
        self
    }

    pub fn primary_icon_activatable(mut self, primary_icon_activatable: bool) -> Self {
        self.primary_icon_activatable = Some(primary_icon_activatable);
        self
    }

    pub fn primary_icon_gicon(mut self, primary_icon_gicon: &impl IsA<gio::Icon>) -> Self {
        self.primary_icon_gicon = Some(primary_icon_gicon.clone().upcast());
        self
    }

    pub fn primary_icon_name(mut self, primary_icon_name: &str) -> Self {
        self.primary_icon_name = Some(primary_icon_name.to_string());
        self
    }

    pub fn primary_icon_paintable(
        mut self,
        primary_icon_paintable: &impl IsA<gdk::Paintable>,
    ) -> Self {
        self.primary_icon_paintable = Some(primary_icon_paintable.clone().upcast());
        self
    }

    pub fn primary_icon_sensitive(mut self, primary_icon_sensitive: bool) -> Self {
        self.primary_icon_sensitive = Some(primary_icon_sensitive);
        self
    }

    pub fn primary_icon_tooltip_markup(mut self, primary_icon_tooltip_markup: &str) -> Self {
        self.primary_icon_tooltip_markup = Some(primary_icon_tooltip_markup.to_string());
        self
    }

    pub fn primary_icon_tooltip_text(mut self, primary_icon_tooltip_text: &str) -> Self {
        self.primary_icon_tooltip_text = Some(primary_icon_tooltip_text.to_string());
        self
    }

    pub fn progress_fraction(mut self, progress_fraction: f64) -> Self {
        self.progress_fraction = Some(progress_fraction);
        self
    }

    pub fn progress_pulse_step(mut self, progress_pulse_step: f64) -> Self {
        self.progress_pulse_step = Some(progress_pulse_step);
        self
    }

    pub fn secondary_icon_activatable(mut self, secondary_icon_activatable: bool) -> Self {
        self.secondary_icon_activatable = Some(secondary_icon_activatable);
        self
    }

    pub fn secondary_icon_gicon(mut self, secondary_icon_gicon: &impl IsA<gio::Icon>) -> Self {
        self.secondary_icon_gicon = Some(secondary_icon_gicon.clone().upcast());
        self
    }

    pub fn secondary_icon_name(mut self, secondary_icon_name: &str) -> Self {
        self.secondary_icon_name = Some(secondary_icon_name.to_string());
        self
    }

    pub fn secondary_icon_paintable(
        mut self,
        secondary_icon_paintable: &impl IsA<gdk::Paintable>,
    ) -> Self {
        self.secondary_icon_paintable = Some(secondary_icon_paintable.clone().upcast());
        self
    }

    pub fn secondary_icon_sensitive(mut self, secondary_icon_sensitive: bool) -> Self {
        self.secondary_icon_sensitive = Some(secondary_icon_sensitive);
        self
    }

    pub fn secondary_icon_tooltip_markup(mut self, secondary_icon_tooltip_markup: &str) -> Self {
        self.secondary_icon_tooltip_markup = Some(secondary_icon_tooltip_markup.to_string());
        self
    }

    pub fn secondary_icon_tooltip_text(mut self, secondary_icon_tooltip_text: &str) -> Self {
        self.secondary_icon_tooltip_text = Some(secondary_icon_tooltip_text.to_string());
        self
    }

    pub fn show_emoji_icon(mut self, show_emoji_icon: bool) -> Self {
        self.show_emoji_icon = Some(show_emoji_icon);
        self
    }

    pub fn tabs(mut self, tabs: &pango::TabArray) -> Self {
        self.tabs = Some(tabs.clone());
        self
    }

    pub fn truncate_multiline(mut self, truncate_multiline: bool) -> Self {
        self.truncate_multiline = Some(truncate_multiline);
        self
    }

    pub fn visibility(mut self, visibility: bool) -> Self {
        self.visibility = Some(visibility);
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn can_target(mut self, can_target: bool) -> Self {
        self.can_target = Some(can_target);
        self
    }

    pub fn css_classes(mut self, css_classes: Vec<String>) -> Self {
        self.css_classes = Some(css_classes);
        self
    }

    pub fn css_name(mut self, css_name: &str) -> Self {
        self.css_name = Some(css_name.to_string());
        self
    }

    pub fn cursor(mut self, cursor: &gdk::Cursor) -> Self {
        self.cursor = Some(cursor.clone());
        self
    }

    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn focusable(mut self, focusable: bool) -> Self {
        self.focusable = Some(focusable);
        self
    }

    pub fn halign(mut self, halign: Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn layout_manager(mut self, layout_manager: &impl IsA<LayoutManager>) -> Self {
        self.layout_manager = Some(layout_manager.clone().upcast());
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn overflow(mut self, overflow: Overflow) -> Self {
        self.overflow = Some(overflow);
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }

    pub fn accessible_role(mut self, accessible_role: AccessibleRole) -> Self {
        self.accessible_role = Some(accessible_role);
        self
    }

    pub fn editing_canceled(mut self, editing_canceled: bool) -> Self {
        self.editing_canceled = Some(editing_canceled);
        self
    }

    pub fn editable(mut self, editable: bool) -> Self {
        self.editable = Some(editable);
        self
    }

    pub fn enable_undo(mut self, enable_undo: bool) -> Self {
        self.enable_undo = Some(enable_undo);
        self
    }

    pub fn max_width_chars(mut self, max_width_chars: i32) -> Self {
        self.max_width_chars = Some(max_width_chars);
        self
    }

    pub fn text(mut self, text: &str) -> Self {
        self.text = Some(text.to_string());
        self
    }

    pub fn width_chars(mut self, width_chars: i32) -> Self {
        self.width_chars = Some(width_chars);
        self
    }

    pub fn xalign(mut self, xalign: f32) -> Self {
        self.xalign = Some(xalign);
        self
    }
}

pub const NONE_ENTRY: Option<&Entry> = None;

pub trait EntryExt: 'static {
    #[doc(alias = "gtk_entry_get_activates_default")]
    #[doc(alias = "get_activates_default")]
    fn activates_default(&self) -> bool;

    #[doc(alias = "gtk_entry_get_attributes")]
    #[doc(alias = "get_attributes")]
    fn attributes(&self) -> Option<pango::AttrList>;

    #[doc(alias = "gtk_entry_get_buffer")]
    #[doc(alias = "get_buffer")]
    fn buffer(&self) -> EntryBuffer;

    #[doc(alias = "gtk_entry_get_completion")]
    #[doc(alias = "get_completion")]
    fn completion(&self) -> Option<EntryCompletion>;

    #[doc(alias = "gtk_entry_get_current_icon_drag_source")]
    #[doc(alias = "get_current_icon_drag_source")]
    fn current_icon_drag_source(&self) -> i32;

    #[doc(alias = "gtk_entry_get_extra_menu")]
    #[doc(alias = "get_extra_menu")]
    fn extra_menu(&self) -> Option<gio::MenuModel>;

    #[doc(alias = "gtk_entry_get_has_frame")]
    #[doc(alias = "get_has_frame")]
    fn has_frame(&self) -> bool;

    #[doc(alias = "gtk_entry_get_icon_activatable")]
    #[doc(alias = "get_icon_activatable")]
    fn icon_is_activatable(&self, icon_pos: EntryIconPosition) -> bool;

    #[doc(alias = "gtk_entry_get_icon_area")]
    #[doc(alias = "get_icon_area")]
    fn icon_area(&self, icon_pos: EntryIconPosition) -> gdk::Rectangle;

    #[doc(alias = "gtk_entry_get_icon_at_pos")]
    #[doc(alias = "get_icon_at_pos")]
    fn icon_at_pos(&self, x: i32, y: i32) -> i32;

    #[doc(alias = "gtk_entry_get_icon_gicon")]
    #[doc(alias = "get_icon_gicon")]
    fn icon_gicon(&self, icon_pos: EntryIconPosition) -> Option<gio::Icon>;

    #[doc(alias = "gtk_entry_get_icon_name")]
    #[doc(alias = "get_icon_name")]
    fn icon_name(&self, icon_pos: EntryIconPosition) -> Option<glib::GString>;

    #[doc(alias = "gtk_entry_get_icon_paintable")]
    #[doc(alias = "get_icon_paintable")]
    fn icon_paintable(&self, icon_pos: EntryIconPosition) -> Option<gdk::Paintable>;

    #[doc(alias = "gtk_entry_get_icon_sensitive")]
    #[doc(alias = "get_icon_sensitive")]
    fn icon_is_sensitive(&self, icon_pos: EntryIconPosition) -> bool;

    #[doc(alias = "gtk_entry_get_icon_storage_type")]
    #[doc(alias = "get_icon_storage_type")]
    fn icon_storage_type(&self, icon_pos: EntryIconPosition) -> ImageType;

    #[doc(alias = "gtk_entry_get_icon_tooltip_markup")]
    #[doc(alias = "get_icon_tooltip_markup")]
    fn icon_tooltip_markup(&self, icon_pos: EntryIconPosition) -> Option<glib::GString>;

    #[doc(alias = "gtk_entry_get_icon_tooltip_text")]
    #[doc(alias = "get_icon_tooltip_text")]
    fn icon_tooltip_text(&self, icon_pos: EntryIconPosition) -> Option<glib::GString>;

    #[doc(alias = "gtk_entry_get_input_hints")]
    #[doc(alias = "get_input_hints")]
    fn input_hints(&self) -> InputHints;

    #[doc(alias = "gtk_entry_get_input_purpose")]
    #[doc(alias = "get_input_purpose")]
    fn input_purpose(&self) -> InputPurpose;

    #[doc(alias = "gtk_entry_get_max_length")]
    #[doc(alias = "get_max_length")]
    fn max_length(&self) -> i32;

    #[doc(alias = "gtk_entry_get_overwrite_mode")]
    #[doc(alias = "get_overwrite_mode")]
    fn is_overwrite_mode(&self) -> bool;

    #[doc(alias = "gtk_entry_get_placeholder_text")]
    #[doc(alias = "get_placeholder_text")]
    fn placeholder_text(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk_entry_get_progress_fraction")]
    #[doc(alias = "get_progress_fraction")]
    fn progress_fraction(&self) -> f64;

    #[doc(alias = "gtk_entry_get_progress_pulse_step")]
    #[doc(alias = "get_progress_pulse_step")]
    fn progress_pulse_step(&self) -> f64;

    #[doc(alias = "gtk_entry_get_tabs")]
    #[doc(alias = "get_tabs")]
    fn tabs(&self) -> Option<pango::TabArray>;

    #[doc(alias = "gtk_entry_get_text_length")]
    #[doc(alias = "get_text_length")]
    fn text_length(&self) -> u16;

    #[doc(alias = "gtk_entry_get_visibility")]
    #[doc(alias = "get_visibility")]
    fn is_visible(&self) -> bool;

    #[doc(alias = "gtk_entry_grab_focus_without_selecting")]
    fn grab_focus_without_selecting(&self) -> bool;

    #[doc(alias = "gtk_entry_progress_pulse")]
    fn progress_pulse(&self);

    #[doc(alias = "gtk_entry_reset_im_context")]
    fn reset_im_context(&self);

    #[doc(alias = "gtk_entry_set_activates_default")]
    fn set_activates_default(&self, setting: bool);

    #[doc(alias = "gtk_entry_set_attributes")]
    fn set_attributes(&self, attrs: &pango::AttrList);

    #[doc(alias = "gtk_entry_set_buffer")]
    fn set_buffer(&self, buffer: &impl IsA<EntryBuffer>);

    #[doc(alias = "gtk_entry_set_completion")]
    fn set_completion(&self, completion: Option<&EntryCompletion>);

    #[doc(alias = "gtk_entry_set_extra_menu")]
    fn set_extra_menu(&self, model: Option<&impl IsA<gio::MenuModel>>);

    #[doc(alias = "gtk_entry_set_has_frame")]
    fn set_has_frame(&self, setting: bool);

    #[doc(alias = "gtk_entry_set_icon_activatable")]
    fn set_icon_activatable(&self, icon_pos: EntryIconPosition, activatable: bool);

    #[doc(alias = "gtk_entry_set_icon_drag_source")]
    fn set_icon_drag_source(
        &self,
        icon_pos: EntryIconPosition,
        provider: &impl IsA<gdk::ContentProvider>,
        actions: gdk::DragAction,
    );

    #[doc(alias = "gtk_entry_set_icon_from_gicon")]
    fn set_icon_from_gicon(&self, icon_pos: EntryIconPosition, icon: Option<&impl IsA<gio::Icon>>);

    #[doc(alias = "gtk_entry_set_icon_from_icon_name")]
    fn set_icon_from_icon_name(&self, icon_pos: EntryIconPosition, icon_name: Option<&str>);

    #[doc(alias = "gtk_entry_set_icon_from_paintable")]
    fn set_icon_from_paintable(
        &self,
        icon_pos: EntryIconPosition,
        paintable: Option<&impl IsA<gdk::Paintable>>,
    );

    #[doc(alias = "gtk_entry_set_icon_sensitive")]
    fn set_icon_sensitive(&self, icon_pos: EntryIconPosition, sensitive: bool);

    #[doc(alias = "gtk_entry_set_icon_tooltip_markup")]
    fn set_icon_tooltip_markup(&self, icon_pos: EntryIconPosition, tooltip: Option<&str>);

    #[doc(alias = "gtk_entry_set_icon_tooltip_text")]
    fn set_icon_tooltip_text(&self, icon_pos: EntryIconPosition, tooltip: Option<&str>);

    #[doc(alias = "gtk_entry_set_input_hints")]
    fn set_input_hints(&self, hints: InputHints);

    #[doc(alias = "gtk_entry_set_input_purpose")]
    fn set_input_purpose(&self, purpose: InputPurpose);

    #[doc(alias = "gtk_entry_set_invisible_char")]
    fn set_invisible_char(&self, ch: Option<char>);

    #[doc(alias = "gtk_entry_set_max_length")]
    fn set_max_length(&self, max: i32);

    #[doc(alias = "gtk_entry_set_overwrite_mode")]
    fn set_overwrite_mode(&self, overwrite: bool);

    #[doc(alias = "gtk_entry_set_placeholder_text")]
    fn set_placeholder_text(&self, text: Option<&str>);

    #[doc(alias = "gtk_entry_set_progress_fraction")]
    fn set_progress_fraction(&self, fraction: f64);

    #[doc(alias = "gtk_entry_set_progress_pulse_step")]
    fn set_progress_pulse_step(&self, fraction: f64);

    #[doc(alias = "gtk_entry_set_tabs")]
    fn set_tabs(&self, tabs: Option<&pango::TabArray>);

    #[doc(alias = "gtk_entry_set_visibility")]
    fn set_visibility(&self, visible: bool);

    #[doc(alias = "gtk_entry_unset_invisible_char")]
    fn unset_invisible_char(&self);

    #[doc(alias = "enable-emoji-completion")]
    fn enables_emoji_completion(&self) -> bool;

    #[doc(alias = "enable-emoji-completion")]
    fn set_enable_emoji_completion(&self, enable_emoji_completion: bool);

    #[doc(alias = "im-module")]
    fn im_module(&self) -> Option<glib::GString>;

    #[doc(alias = "im-module")]
    fn set_im_module(&self, im_module: Option<&str>);

    #[doc(alias = "invisible-char-set")]
    fn is_invisible_char_set(&self) -> bool;

    #[doc(alias = "invisible-char-set")]
    fn set_invisible_char_set(&self, invisible_char_set: bool);

    #[doc(alias = "primary-icon-activatable")]
    fn is_primary_icon_activatable(&self) -> bool;

    #[doc(alias = "primary-icon-activatable")]
    fn set_primary_icon_activatable(&self, primary_icon_activatable: bool);

    #[doc(alias = "primary-icon-gicon")]
    fn primary_icon_gicon(&self) -> Option<gio::Icon>;

    #[doc(alias = "primary-icon-gicon")]
    fn set_primary_icon_gicon<P: IsA<gio::Icon>>(&self, primary_icon_gicon: Option<&P>);

    #[doc(alias = "primary-icon-name")]
    fn primary_icon_name(&self) -> Option<glib::GString>;

    #[doc(alias = "primary-icon-name")]
    fn set_primary_icon_name(&self, primary_icon_name: Option<&str>);

    #[doc(alias = "primary-icon-paintable")]
    fn primary_icon_paintable(&self) -> Option<gdk::Paintable>;

    #[doc(alias = "primary-icon-paintable")]
    fn set_primary_icon_paintable<P: IsA<gdk::Paintable>>(
        &self,
        primary_icon_paintable: Option<&P>,
    );

    #[doc(alias = "primary-icon-sensitive")]
    fn is_primary_icon_sensitive(&self) -> bool;

    #[doc(alias = "primary-icon-sensitive")]
    fn set_primary_icon_sensitive(&self, primary_icon_sensitive: bool);

    #[doc(alias = "primary-icon-storage-type")]
    fn primary_icon_storage_type(&self) -> ImageType;

    #[doc(alias = "primary-icon-tooltip-markup")]
    fn primary_icon_tooltip_markup(&self) -> Option<glib::GString>;

    #[doc(alias = "primary-icon-tooltip-markup")]
    fn set_primary_icon_tooltip_markup(&self, primary_icon_tooltip_markup: Option<&str>);

    #[doc(alias = "primary-icon-tooltip-text")]
    fn primary_icon_tooltip_text(&self) -> Option<glib::GString>;

    #[doc(alias = "primary-icon-tooltip-text")]
    fn set_primary_icon_tooltip_text(&self, primary_icon_tooltip_text: Option<&str>);

    #[doc(alias = "scroll-offset")]
    fn scroll_offset(&self) -> i32;

    #[doc(alias = "secondary-icon-activatable")]
    fn is_secondary_icon_activatable(&self) -> bool;

    #[doc(alias = "secondary-icon-activatable")]
    fn set_secondary_icon_activatable(&self, secondary_icon_activatable: bool);

    #[doc(alias = "secondary-icon-gicon")]
    fn secondary_icon_gicon(&self) -> Option<gio::Icon>;

    #[doc(alias = "secondary-icon-gicon")]
    fn set_secondary_icon_gicon<P: IsA<gio::Icon>>(&self, secondary_icon_gicon: Option<&P>);

    #[doc(alias = "secondary-icon-name")]
    fn secondary_icon_name(&self) -> Option<glib::GString>;

    #[doc(alias = "secondary-icon-name")]
    fn set_secondary_icon_name(&self, secondary_icon_name: Option<&str>);

    #[doc(alias = "secondary-icon-paintable")]
    fn secondary_icon_paintable(&self) -> Option<gdk::Paintable>;

    #[doc(alias = "secondary-icon-paintable")]
    fn set_secondary_icon_paintable<P: IsA<gdk::Paintable>>(
        &self,
        secondary_icon_paintable: Option<&P>,
    );

    #[doc(alias = "secondary-icon-sensitive")]
    fn is_secondary_icon_sensitive(&self) -> bool;

    #[doc(alias = "secondary-icon-sensitive")]
    fn set_secondary_icon_sensitive(&self, secondary_icon_sensitive: bool);

    #[doc(alias = "secondary-icon-storage-type")]
    fn secondary_icon_storage_type(&self) -> ImageType;

    #[doc(alias = "secondary-icon-tooltip-markup")]
    fn secondary_icon_tooltip_markup(&self) -> Option<glib::GString>;

    #[doc(alias = "secondary-icon-tooltip-markup")]
    fn set_secondary_icon_tooltip_markup(&self, secondary_icon_tooltip_markup: Option<&str>);

    #[doc(alias = "secondary-icon-tooltip-text")]
    fn secondary_icon_tooltip_text(&self) -> Option<glib::GString>;

    #[doc(alias = "secondary-icon-tooltip-text")]
    fn set_secondary_icon_tooltip_text(&self, secondary_icon_tooltip_text: Option<&str>);

    #[doc(alias = "show-emoji-icon")]
    fn shows_emoji_icon(&self) -> bool;

    #[doc(alias = "show-emoji-icon")]
    fn set_show_emoji_icon(&self, show_emoji_icon: bool);

    #[doc(alias = "truncate-multiline")]
    fn must_truncate_multiline(&self) -> bool;

    #[doc(alias = "truncate-multiline")]
    fn set_truncate_multiline(&self, truncate_multiline: bool);

    #[doc(alias = "activate")]
    fn connect_activate<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_activate(&self);

    #[doc(alias = "icon-press")]
    fn connect_icon_press<F: Fn(&Self, EntryIconPosition) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "icon-release")]
    fn connect_icon_release<F: Fn(&Self, EntryIconPosition) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "activates-default")]
    fn connect_activates_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "attributes")]
    fn connect_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "buffer")]
    fn connect_buffer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "completion")]
    fn connect_completion_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "enable-emoji-completion")]
    fn connect_enable_emoji_completion_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "extra-menu")]
    fn connect_extra_menu_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "has-frame")]
    fn connect_has_frame_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "im-module")]
    fn connect_im_module_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "input-hints")]
    fn connect_input_hints_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "input-purpose")]
    fn connect_input_purpose_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "invisible-char")]
    fn connect_invisible_char_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "invisible-char-set")]
    fn connect_invisible_char_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "max-length")]
    fn connect_max_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "overwrite-mode")]
    fn connect_overwrite_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "placeholder-text")]
    fn connect_placeholder_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "primary-icon-activatable")]
    fn connect_primary_icon_activatable_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "primary-icon-gicon")]
    fn connect_primary_icon_gicon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "primary-icon-name")]
    fn connect_primary_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "primary-icon-paintable")]
    fn connect_primary_icon_paintable_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "primary-icon-sensitive")]
    fn connect_primary_icon_sensitive_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "primary-icon-storage-type")]
    fn connect_primary_icon_storage_type_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "primary-icon-tooltip-markup")]
    fn connect_primary_icon_tooltip_markup_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "primary-icon-tooltip-text")]
    fn connect_primary_icon_tooltip_text_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "progress-fraction")]
    fn connect_progress_fraction_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "progress-pulse-step")]
    fn connect_progress_pulse_step_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scroll-offset")]
    fn connect_scroll_offset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "secondary-icon-activatable")]
    fn connect_secondary_icon_activatable_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "secondary-icon-gicon")]
    fn connect_secondary_icon_gicon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "secondary-icon-name")]
    fn connect_secondary_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "secondary-icon-paintable")]
    fn connect_secondary_icon_paintable_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "secondary-icon-sensitive")]
    fn connect_secondary_icon_sensitive_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "secondary-icon-storage-type")]
    fn connect_secondary_icon_storage_type_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "secondary-icon-tooltip-markup")]
    fn connect_secondary_icon_tooltip_markup_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "secondary-icon-tooltip-text")]
    fn connect_secondary_icon_tooltip_text_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "show-emoji-icon")]
    fn connect_show_emoji_icon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tabs")]
    fn connect_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "text-length")]
    fn connect_text_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "truncate-multiline")]
    fn connect_truncate_multiline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "visibility")]
    fn connect_visibility_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Entry>> EntryExt for O {
    fn activates_default(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_get_activates_default(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn attributes(&self) -> Option<pango::AttrList> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_attributes(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn buffer(&self) -> EntryBuffer {
        unsafe { from_glib_none(ffi::gtk_entry_get_buffer(self.as_ref().to_glib_none().0)) }
    }

    fn completion(&self) -> Option<EntryCompletion> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_completion(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn current_icon_drag_source(&self) -> i32 {
        unsafe { ffi::gtk_entry_get_current_icon_drag_source(self.as_ref().to_glib_none().0) }
    }

    fn extra_menu(&self) -> Option<gio::MenuModel> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_extra_menu(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn has_frame(&self) -> bool {
        unsafe { from_glib(ffi::gtk_entry_get_has_frame(self.as_ref().to_glib_none().0)) }
    }

    fn icon_is_activatable(&self, icon_pos: EntryIconPosition) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_get_icon_activatable(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    fn icon_area(&self, icon_pos: EntryIconPosition) -> gdk::Rectangle {
        unsafe {
            let mut icon_area = gdk::Rectangle::uninitialized();
            ffi::gtk_entry_get_icon_area(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                icon_area.to_glib_none_mut().0,
            );
            icon_area
        }
    }

    fn icon_at_pos(&self, x: i32, y: i32) -> i32 {
        unsafe { ffi::gtk_entry_get_icon_at_pos(self.as_ref().to_glib_none().0, x, y) }
    }

    fn icon_gicon(&self, icon_pos: EntryIconPosition) -> Option<gio::Icon> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_icon_gicon(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    fn icon_name(&self, icon_pos: EntryIconPosition) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_icon_name(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    fn icon_paintable(&self, icon_pos: EntryIconPosition) -> Option<gdk::Paintable> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_icon_paintable(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    fn icon_is_sensitive(&self, icon_pos: EntryIconPosition) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_get_icon_sensitive(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    fn icon_storage_type(&self, icon_pos: EntryIconPosition) -> ImageType {
        unsafe {
            from_glib(ffi::gtk_entry_get_icon_storage_type(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    fn icon_tooltip_markup(&self, icon_pos: EntryIconPosition) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gtk_entry_get_icon_tooltip_markup(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    fn icon_tooltip_text(&self, icon_pos: EntryIconPosition) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gtk_entry_get_icon_tooltip_text(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    fn input_hints(&self) -> InputHints {
        unsafe {
            from_glib(ffi::gtk_entry_get_input_hints(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn input_purpose(&self) -> InputPurpose {
        unsafe {
            from_glib(ffi::gtk_entry_get_input_purpose(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn max_length(&self) -> i32 {
        unsafe { ffi::gtk_entry_get_max_length(self.as_ref().to_glib_none().0) }
    }

    fn is_overwrite_mode(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_get_overwrite_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn placeholder_text(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_placeholder_text(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn progress_fraction(&self) -> f64 {
        unsafe { ffi::gtk_entry_get_progress_fraction(self.as_ref().to_glib_none().0) }
    }

    fn progress_pulse_step(&self) -> f64 {
        unsafe { ffi::gtk_entry_get_progress_pulse_step(self.as_ref().to_glib_none().0) }
    }

    fn tabs(&self) -> Option<pango::TabArray> {
        unsafe { from_glib_none(ffi::gtk_entry_get_tabs(self.as_ref().to_glib_none().0)) }
    }

    fn text_length(&self) -> u16 {
        unsafe { ffi::gtk_entry_get_text_length(self.as_ref().to_glib_none().0) }
    }

    fn is_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_get_visibility(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn grab_focus_without_selecting(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_grab_focus_without_selecting(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn progress_pulse(&self) {
        unsafe {
            ffi::gtk_entry_progress_pulse(self.as_ref().to_glib_none().0);
        }
    }

    fn reset_im_context(&self) {
        unsafe {
            ffi::gtk_entry_reset_im_context(self.as_ref().to_glib_none().0);
        }
    }

    fn set_activates_default(&self, setting: bool) {
        unsafe {
            ffi::gtk_entry_set_activates_default(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    fn set_attributes(&self, attrs: &pango::AttrList) {
        unsafe {
            ffi::gtk_entry_set_attributes(self.as_ref().to_glib_none().0, attrs.to_glib_none().0);
        }
    }

    fn set_buffer(&self, buffer: &impl IsA<EntryBuffer>) {
        unsafe {
            ffi::gtk_entry_set_buffer(
                self.as_ref().to_glib_none().0,
                buffer.as_ref().to_glib_none().0,
            );
        }
    }

    fn set_completion(&self, completion: Option<&EntryCompletion>) {
        unsafe {
            ffi::gtk_entry_set_completion(
                self.as_ref().to_glib_none().0,
                completion.to_glib_none().0,
            );
        }
    }

    fn set_extra_menu(&self, model: Option<&impl IsA<gio::MenuModel>>) {
        unsafe {
            ffi::gtk_entry_set_extra_menu(
                self.as_ref().to_glib_none().0,
                model.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_has_frame(&self, setting: bool) {
        unsafe {
            ffi::gtk_entry_set_has_frame(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    fn set_icon_activatable(&self, icon_pos: EntryIconPosition, activatable: bool) {
        unsafe {
            ffi::gtk_entry_set_icon_activatable(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                activatable.into_glib(),
            );
        }
    }

    fn set_icon_drag_source(
        &self,
        icon_pos: EntryIconPosition,
        provider: &impl IsA<gdk::ContentProvider>,
        actions: gdk::DragAction,
    ) {
        unsafe {
            ffi::gtk_entry_set_icon_drag_source(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                provider.as_ref().to_glib_none().0,
                actions.into_glib(),
            );
        }
    }

    fn set_icon_from_gicon(&self, icon_pos: EntryIconPosition, icon: Option<&impl IsA<gio::Icon>>) {
        unsafe {
            ffi::gtk_entry_set_icon_from_gicon(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                icon.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_icon_from_icon_name(&self, icon_pos: EntryIconPosition, icon_name: Option<&str>) {
        unsafe {
            ffi::gtk_entry_set_icon_from_icon_name(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                icon_name.to_glib_none().0,
            );
        }
    }

    fn set_icon_from_paintable(
        &self,
        icon_pos: EntryIconPosition,
        paintable: Option<&impl IsA<gdk::Paintable>>,
    ) {
        unsafe {
            ffi::gtk_entry_set_icon_from_paintable(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                paintable.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_icon_sensitive(&self, icon_pos: EntryIconPosition, sensitive: bool) {
        unsafe {
            ffi::gtk_entry_set_icon_sensitive(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                sensitive.into_glib(),
            );
        }
    }

    fn set_icon_tooltip_markup(&self, icon_pos: EntryIconPosition, tooltip: Option<&str>) {
        unsafe {
            ffi::gtk_entry_set_icon_tooltip_markup(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                tooltip.to_glib_none().0,
            );
        }
    }

    fn set_icon_tooltip_text(&self, icon_pos: EntryIconPosition, tooltip: Option<&str>) {
        unsafe {
            ffi::gtk_entry_set_icon_tooltip_text(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                tooltip.to_glib_none().0,
            );
        }
    }

    fn set_input_hints(&self, hints: InputHints) {
        unsafe {
            ffi::gtk_entry_set_input_hints(self.as_ref().to_glib_none().0, hints.into_glib());
        }
    }

    fn set_input_purpose(&self, purpose: InputPurpose) {
        unsafe {
            ffi::gtk_entry_set_input_purpose(self.as_ref().to_glib_none().0, purpose.into_glib());
        }
    }

    fn set_invisible_char(&self, ch: Option<char>) {
        unsafe {
            ffi::gtk_entry_set_invisible_char(self.as_ref().to_glib_none().0, ch.into_glib());
        }
    }

    fn set_max_length(&self, max: i32) {
        unsafe {
            ffi::gtk_entry_set_max_length(self.as_ref().to_glib_none().0, max);
        }
    }

    fn set_overwrite_mode(&self, overwrite: bool) {
        unsafe {
            ffi::gtk_entry_set_overwrite_mode(
                self.as_ref().to_glib_none().0,
                overwrite.into_glib(),
            );
        }
    }

    fn set_placeholder_text(&self, text: Option<&str>) {
        unsafe {
            ffi::gtk_entry_set_placeholder_text(
                self.as_ref().to_glib_none().0,
                text.to_glib_none().0,
            );
        }
    }

    fn set_progress_fraction(&self, fraction: f64) {
        unsafe {
            ffi::gtk_entry_set_progress_fraction(self.as_ref().to_glib_none().0, fraction);
        }
    }

    fn set_progress_pulse_step(&self, fraction: f64) {
        unsafe {
            ffi::gtk_entry_set_progress_pulse_step(self.as_ref().to_glib_none().0, fraction);
        }
    }

    fn set_tabs(&self, tabs: Option<&pango::TabArray>) {
        unsafe {
            ffi::gtk_entry_set_tabs(
                self.as_ref().to_glib_none().0,
                mut_override(tabs.to_glib_none().0),
            );
        }
    }

    fn set_visibility(&self, visible: bool) {
        unsafe {
            ffi::gtk_entry_set_visibility(self.as_ref().to_glib_none().0, visible.into_glib());
        }
    }

    fn unset_invisible_char(&self) {
        unsafe {
            ffi::gtk_entry_unset_invisible_char(self.as_ref().to_glib_none().0);
        }
    }

    fn enables_emoji_completion(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"enable-emoji-completion\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `enable-emoji-completion` getter")
        }
    }

    fn set_enable_emoji_completion(&self, enable_emoji_completion: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"enable-emoji-completion\0".as_ptr() as *const _,
                enable_emoji_completion.to_value().to_glib_none().0,
            );
        }
    }

    fn im_module(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"im-module\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `im-module` getter")
        }
    }

    fn set_im_module(&self, im_module: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"im-module\0".as_ptr() as *const _,
                im_module.to_value().to_glib_none().0,
            );
        }
    }

    fn is_invisible_char_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"invisible-char-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `invisible-char-set` getter")
        }
    }

    fn set_invisible_char_set(&self, invisible_char_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"invisible-char-set\0".as_ptr() as *const _,
                invisible_char_set.to_value().to_glib_none().0,
            );
        }
    }

    fn is_primary_icon_activatable(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"primary-icon-activatable\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `primary-icon-activatable` getter")
        }
    }

    fn set_primary_icon_activatable(&self, primary_icon_activatable: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"primary-icon-activatable\0".as_ptr() as *const _,
                primary_icon_activatable.to_value().to_glib_none().0,
            );
        }
    }

    fn primary_icon_gicon(&self) -> Option<gio::Icon> {
        unsafe {
            let mut value = glib::Value::from_type(<gio::Icon as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"primary-icon-gicon\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `primary-icon-gicon` getter")
        }
    }

    fn set_primary_icon_gicon<P: IsA<gio::Icon>>(&self, primary_icon_gicon: Option<&P>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"primary-icon-gicon\0".as_ptr() as *const _,
                primary_icon_gicon.to_value().to_glib_none().0,
            );
        }
    }

    fn primary_icon_name(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"primary-icon-name\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `primary-icon-name` getter")
        }
    }

    fn set_primary_icon_name(&self, primary_icon_name: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"primary-icon-name\0".as_ptr() as *const _,
                primary_icon_name.to_value().to_glib_none().0,
            );
        }
    }

    fn primary_icon_paintable(&self) -> Option<gdk::Paintable> {
        unsafe {
            let mut value = glib::Value::from_type(<gdk::Paintable as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"primary-icon-paintable\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `primary-icon-paintable` getter")
        }
    }

    fn set_primary_icon_paintable<P: IsA<gdk::Paintable>>(
        &self,
        primary_icon_paintable: Option<&P>,
    ) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"primary-icon-paintable\0".as_ptr() as *const _,
                primary_icon_paintable.to_value().to_glib_none().0,
            );
        }
    }

    fn is_primary_icon_sensitive(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"primary-icon-sensitive\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `primary-icon-sensitive` getter")
        }
    }

    fn set_primary_icon_sensitive(&self, primary_icon_sensitive: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"primary-icon-sensitive\0".as_ptr() as *const _,
                primary_icon_sensitive.to_value().to_glib_none().0,
            );
        }
    }

    fn primary_icon_storage_type(&self) -> ImageType {
        unsafe {
            let mut value = glib::Value::from_type(<ImageType as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"primary-icon-storage-type\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `primary-icon-storage-type` getter")
        }
    }

    fn primary_icon_tooltip_markup(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"primary-icon-tooltip-markup\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `primary-icon-tooltip-markup` getter")
        }
    }

    fn set_primary_icon_tooltip_markup(&self, primary_icon_tooltip_markup: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"primary-icon-tooltip-markup\0".as_ptr() as *const _,
                primary_icon_tooltip_markup.to_value().to_glib_none().0,
            );
        }
    }

    fn primary_icon_tooltip_text(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"primary-icon-tooltip-text\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `primary-icon-tooltip-text` getter")
        }
    }

    fn set_primary_icon_tooltip_text(&self, primary_icon_tooltip_text: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"primary-icon-tooltip-text\0".as_ptr() as *const _,
                primary_icon_tooltip_text.to_value().to_glib_none().0,
            );
        }
    }

    fn scroll_offset(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"scroll-offset\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `scroll-offset` getter")
        }
    }

    fn is_secondary_icon_activatable(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"secondary-icon-activatable\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `secondary-icon-activatable` getter")
        }
    }

    fn set_secondary_icon_activatable(&self, secondary_icon_activatable: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"secondary-icon-activatable\0".as_ptr() as *const _,
                secondary_icon_activatable.to_value().to_glib_none().0,
            );
        }
    }

    fn secondary_icon_gicon(&self) -> Option<gio::Icon> {
        unsafe {
            let mut value = glib::Value::from_type(<gio::Icon as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"secondary-icon-gicon\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `secondary-icon-gicon` getter")
        }
    }

    fn set_secondary_icon_gicon<P: IsA<gio::Icon>>(&self, secondary_icon_gicon: Option<&P>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"secondary-icon-gicon\0".as_ptr() as *const _,
                secondary_icon_gicon.to_value().to_glib_none().0,
            );
        }
    }

    fn secondary_icon_name(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"secondary-icon-name\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `secondary-icon-name` getter")
        }
    }

    fn set_secondary_icon_name(&self, secondary_icon_name: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"secondary-icon-name\0".as_ptr() as *const _,
                secondary_icon_name.to_value().to_glib_none().0,
            );
        }
    }

    fn secondary_icon_paintable(&self) -> Option<gdk::Paintable> {
        unsafe {
            let mut value = glib::Value::from_type(<gdk::Paintable as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"secondary-icon-paintable\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `secondary-icon-paintable` getter")
        }
    }

    fn set_secondary_icon_paintable<P: IsA<gdk::Paintable>>(
        &self,
        secondary_icon_paintable: Option<&P>,
    ) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"secondary-icon-paintable\0".as_ptr() as *const _,
                secondary_icon_paintable.to_value().to_glib_none().0,
            );
        }
    }

    fn is_secondary_icon_sensitive(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"secondary-icon-sensitive\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `secondary-icon-sensitive` getter")
        }
    }

    fn set_secondary_icon_sensitive(&self, secondary_icon_sensitive: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"secondary-icon-sensitive\0".as_ptr() as *const _,
                secondary_icon_sensitive.to_value().to_glib_none().0,
            );
        }
    }

    fn secondary_icon_storage_type(&self) -> ImageType {
        unsafe {
            let mut value = glib::Value::from_type(<ImageType as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"secondary-icon-storage-type\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `secondary-icon-storage-type` getter")
        }
    }

    fn secondary_icon_tooltip_markup(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"secondary-icon-tooltip-markup\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `secondary-icon-tooltip-markup` getter")
        }
    }

    fn set_secondary_icon_tooltip_markup(&self, secondary_icon_tooltip_markup: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"secondary-icon-tooltip-markup\0".as_ptr() as *const _,
                secondary_icon_tooltip_markup.to_value().to_glib_none().0,
            );
        }
    }

    fn secondary_icon_tooltip_text(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"secondary-icon-tooltip-text\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `secondary-icon-tooltip-text` getter")
        }
    }

    fn set_secondary_icon_tooltip_text(&self, secondary_icon_tooltip_text: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"secondary-icon-tooltip-text\0".as_ptr() as *const _,
                secondary_icon_tooltip_text.to_value().to_glib_none().0,
            );
        }
    }

    fn shows_emoji_icon(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"show-emoji-icon\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `show-emoji-icon` getter")
        }
    }

    fn set_show_emoji_icon(&self, show_emoji_icon: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"show-emoji-icon\0".as_ptr() as *const _,
                show_emoji_icon.to_value().to_glib_none().0,
            );
        }
    }

    fn must_truncate_multiline(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"truncate-multiline\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `truncate-multiline` getter")
        }
    }

    fn set_truncate_multiline(&self, truncate_multiline: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"truncate-multiline\0".as_ptr() as *const _,
                truncate_multiline.to_value().to_glib_none().0,
            );
        }
    }

    fn connect_activate<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn activate_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    activate_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_activate(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("activate", &[])
                .unwrap()
        };
    }

    fn connect_icon_press<F: Fn(&Self, EntryIconPosition) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn icon_press_trampoline<
            P: IsA<Entry>,
            F: Fn(&P, EntryIconPosition) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            icon_pos: ffi::GtkEntryIconPosition,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Entry::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(icon_pos),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"icon-press\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    icon_press_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_icon_release<F: Fn(&Self, EntryIconPosition) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn icon_release_trampoline<
            P: IsA<Entry>,
            F: Fn(&P, EntryIconPosition) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            icon_pos: ffi::GtkEntryIconPosition,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Entry::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(icon_pos),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"icon-release\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    icon_release_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_activates_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_activates_default_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::activates-default\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_activates_default_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_attributes_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::attributes\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_attributes_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_buffer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_buffer_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::buffer\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_buffer_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_completion_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_completion_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::completion\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_completion_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_enable_emoji_completion_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_emoji_completion_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-emoji-completion\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_emoji_completion_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_extra_menu_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_extra_menu_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::extra-menu\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_extra_menu_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_has_frame_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_frame_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::has-frame\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_has_frame_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_im_module_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_im_module_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::im-module\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_im_module_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_input_hints_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_hints_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::input-hints\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_input_hints_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_input_purpose_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_purpose_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::input-purpose\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_input_purpose_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_invisible_char_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_invisible_char_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::invisible-char\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_invisible_char_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_invisible_char_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_invisible_char_set_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::invisible-char-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_invisible_char_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_max_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_length_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-length\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_max_length_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_overwrite_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_overwrite_mode_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::overwrite-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_overwrite_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_placeholder_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_placeholder_text_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::placeholder-text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_placeholder_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_primary_icon_activatable_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_activatable_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-activatable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_primary_icon_activatable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_primary_icon_gicon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_gicon_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-gicon\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_primary_icon_gicon_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_primary_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_name_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_primary_icon_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_primary_icon_paintable_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_paintable_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-paintable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_primary_icon_paintable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_primary_icon_sensitive_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_sensitive_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-sensitive\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_primary_icon_sensitive_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_primary_icon_storage_type_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_storage_type_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-storage-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_primary_icon_storage_type_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_primary_icon_tooltip_markup_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_tooltip_markup_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-tooltip-markup\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_primary_icon_tooltip_markup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_primary_icon_tooltip_text_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_tooltip_text_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-tooltip-text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_primary_icon_tooltip_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_progress_fraction_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_progress_fraction_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::progress-fraction\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_progress_fraction_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_progress_pulse_step_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_progress_pulse_step_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::progress-pulse-step\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_progress_pulse_step_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_scroll_offset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scroll_offset_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scroll-offset\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scroll_offset_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_secondary_icon_activatable_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_activatable_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-activatable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_secondary_icon_activatable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_secondary_icon_gicon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_gicon_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-gicon\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_secondary_icon_gicon_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_secondary_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_name_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_secondary_icon_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_secondary_icon_paintable_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_paintable_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-paintable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_secondary_icon_paintable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_secondary_icon_sensitive_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_sensitive_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-sensitive\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_secondary_icon_sensitive_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_secondary_icon_storage_type_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_storage_type_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-storage-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_secondary_icon_storage_type_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_secondary_icon_tooltip_markup_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_tooltip_markup_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-tooltip-markup\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_secondary_icon_tooltip_markup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_secondary_icon_tooltip_text_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_tooltip_text_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-tooltip-text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_secondary_icon_tooltip_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_show_emoji_icon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_emoji_icon_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-emoji-icon\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_emoji_icon_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tabs_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tabs\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tabs_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_text_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_length_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::text-length\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_text_length_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_truncate_multiline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_truncate_multiline_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::truncate-multiline\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_truncate_multiline_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_visibility_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visibility_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::visibility\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_visibility_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Entry {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Entry")
    }
}
