# THIS FILE WAS AUTOGENERATED, DO NOT EDIT
abort 'Use the rake task or esr-gem-builder to build the gem' if $0 =~ /gem$/ && $*.first == 'build'
require 'yaml'

Class.new do

def initialize
  @project_path = File.dirname(__FILE__)
  @project_config_path = File.join(File.dirname(__FILE__), 'Project.yaml')
  @project_config = YAML.load(File.read(@project_config_path))
end

def rubies
  (@project_config['rubies'] || ['2.3']).map(&:to_s)
end

def platforms
  @project_config['platforms'] || %w(x86_64-linux x64-mingw32)
end

def exclude_files
  @project_config['exclude_files'] || []
end

def encrypt_sources
  @project_config['encrypt_sources'].nil? ? true : @project_config['encrypt_sources']
end

def extensions
  @project_config['extensions'] ||
      Hash[Dir.glob(File.join(@project_path, 'ext', '*')).select { |f| File.directory?(f) }.map { |f| [File.basename(f).to_sym, f] }]
end

def common_native_binary_paths
  @project_config['common_native_binary_paths']
end

def native_library_artifacts
  @project_config['native_library_artifacts']
end

def common_native_binary_artifacts
  @project_config['common_native_binary_artifacts'] || {}
end

def extensions_target_path
  @project_config['extensions_target_path'] || File.join('lib', 'native')
end

# All extension artifact path list
def native_library_artifact_paths(only_platforms = nil)
  platforms_list = only_platforms.nil? ? platforms : only_platforms
  extensions.keys.flat_map do |name|
    rubies.flat_map do |ruby|
      platforms_list.flat_map do |platform|
        if native_library_artifacts && native_library_artifacts[name.to_s]
          native_library_artifacts[name.to_s].map do |artifact_platform, artifacts|
            next unless platform == artifact_platform.to_s
            artifacts.map { |a| File.join(extensions_target_path, name.to_s, ruby, platform, a) }
          end
        elsif @project_config['native_artifacts'] && @project_config['native_artifacts'][name.to_s] # backward compatibility (e.g. esr-licensing <0.3)
          @project_config['native_artifacts'][name.to_s].map do |artifact|
            next unless platform == platform.to_s
            File.join(extensions_target_path, name.to_s, ruby.to_s, platform, artifact)
          end
        else
          [File.join(extensions_target_path, name.to_s, ruby.to_s, platform, name.to_s + '.so')]
        end
      end
    end
  end
end

def common_native_binary_path(name, platform = nil)
  path = common_native_binary_paths[name] unless common_native_binary_paths.nil?
  path = path[platform || RUBY_PLATFORM] if path.is_a?(Hash)
  path || File.join('native', name)
end

def common_native_binary_artifact_paths(only_platforms = nil)
  common_native_binary_artifacts.flat_map do |name, info|
    info.flat_map do |platform, binaries|
      next if only_platforms && !only_platforms.include?(platform.to_s)
      binaries.map { |binary| File.join(common_native_binary_path(name, platform), binary) }
    end
  end.compact
end

def native_artifact_paths(only_platforms = nil)
  native_library_artifact_paths(only_platforms) + common_native_binary_artifact_paths(only_platforms)
end

def gemspec
  Gem::Specification.new do |s|
    s.name = @project_config['name']
    s.version = @project_config['version']
    s.authors = @project_config['authors']
    s.homepage = @project_config['homepage']
    s.summary = @project_config['summary']
    s.description = @project_config['description']
    s.licenses = @project_config['licenses']
    s.bindir = @project_config['bindir'] || 'bin'
    s.executables = @project_config['executables']
    s.extra_rdoc_files = @project_config['extra_rdoc_files']
    s.rdoc_options.push(*@project_config['rdoc_options']) if @project_config['rdoc_options']
    include_patterns = (@project_config['include_files'] || []) + ["lib/**/*.rb", "Project.yaml"]
    include = include_patterns.reject { |i| i.include?('*') } +
        include_patterns.select { |i| i.include?('*') }.flat_map { |i| Dir.glob(File.join(@project_path, i)) }
    include.push(*native_artifact_paths)
    include << "lib/rubyencoder.lic" if encrypt_sources
    exclude_files_expanded = exclude_files.reject { |i| i.include?('*') }
    exclude = [exclude_files_expanded] +
        exclude_files.select { |i| i.include?('*') }.flat_map { |i| Dir.glob(File.join(@project_path, i)) }
    s.files = include - exclude 
    (@project_config['dependencies'] || {}).flat_map do |_, deps|
      deps.map do |d|
        if d.is_a?(String)
          s.add_dependency(d)
        else
          dep_args = [d['name']]
          dep_args.concat(if d['version'].nil?; []; else d['version'].is_a?(String) ? [d['version']] : d['version'] end)
          if d['development']
            s.add_development_dependency(*dep_args)
          else
            s.add_dependency(*dep_args)
          end
        end
      end
    end
  end
end

end.new.gemspec
