# RestfulDB testing

---

## Versions
* RestfulDB: 0.10.0
* Database: 0.3.0

---

## Creating new entries

[ ] **TC-0001**

Creates "sample" record.

Go to `https://<restful_url>/<database>/sample/new`.

Enter input:
```
sample:
    SolsaID: TC-0001-0001,
    acquisition_data: 2019-03-11,
    kind: natural,
    preparation_conditions: grinding
```

Press "Save".

---

[ ] **TC-0002**

Creates "sample" with related "experiment_epma" record.

Go to `https://<restful_url>/<database>/sample/new`.

Enter input:
```
sample:
    SolsaID: TC-0001-0002,
    kind: mixed,
    specimen_type: rock
```

Below "sample" card, choose "experiment_epma" and press "Add table".

Enter input:
```
experiment_epma:
    measurement_date: <Insert>,
    diffracting_crystal_type: TAP,PET
```

Press "Save".

---

[ ] **TC-0003**

Creates "sample" with both "file" and "phase" records.

Go to `https://<restful_url>/<database>/sample/new`.

Enter input:
```
sample:
    SolsaID: TC-0001-0003
    special_details: yet another test
```

Below "sample" card, choose "file" and press "Add table".

Enter input:
```
file:
    content: <Browse..>
```

Below "sample" card, choose "phase" and press "Add table".

Enter input:
```
phase:
    percentage: 10

```

Below "phase" card, press "Add entry".

Enter input:
```
phase:
    percentage: 20
```

Press "Save".

---

[ ] **TC-0004**

Creates "sample" with both related "related_sample (primary_sample_id)" and "related_sample (related_sample_id)" records.

Go to `https://<restful_url>/<database>/sample/new`.

Enter input:
```
sample:
  SolsaID: TC-0001-0004

```

Below "sample" card, choose "related_sample (primary_sample_id)" and press "Add table".

Below "sample" card, choose "related_sample (related_sample_id)" and press "Add table".

Enter input:
```
related_sample (primary_sample_id):
    related_sample: TC-0001-0001
```

Enter input:
```
related_sample (related_sample_id):
    primary_sample: TC-0001-0002
```

Below "related_sample (related_sample_id)" card, press "Add entry".

Enter input:
```
related_sample (related_sample_id):
    primary_sample: TC-0001-0003
```

Press "Save".

---

[ ] **TC-0005**

Creates "sample" with two related "experiment_epma" records.

Go to `https://<restful_url>/<database>/sample/new`.

Enter input:
```
sample:
    SolsaID: TC-0001-0005
```

Below "sample" card, choose "experiment_epma" and press "Add table".

Enter input:
```
experiment_epma:
    measurement_date: <Insert>,
    spectrometer_type: WDS,
    diffracting_crystal_type: TAP,LIF,PET
```

Below "experiment_epma" card, press "Add entry".

Note: secondarily added table should not have any information.

Enter input for second "experiment_epma" card:
```
experiment_epma:
    laboratory: 'France, Trappes, Eramet Ideas'
```

Below second "experiment_epma" card, choose "epma_mineral" and press "Add table".

Below "epma_mineral" card, press "Add entry".

Enter inputs for both cards:
```
epma_mineral:
    name: A

epma_mineral:
    name: B
```

Below the second "epma_mineral" card, choose "epma_content" and press "Add table".

Enter input:
```
epma_content:
    component: C
```

Below "epma_content" table, press "Add entry" two times.

Enter input for second and third cards:
```
epma_content:
  component: D

epma_content:
  component: E
```

Press "Save".

---

[ ] **TC-0006**

Creates "sample" with two related "lithology" and their related "lithology_img" records.

Go to `https://<restful_url>/<database>/sample/new`.

Enter input:
```
sample:
    SolsaID: TC-0001-0006
```

Below "sample" card, choose "lithology" and press "Add table".

Enter input for "lithology" card:
```
lithology:
    material_identification: rock
```

Below "lithology" card, choose "lithology_img" and press "Add table".

Enter input for "lithology_img":
```
lithology_img:
    image: <Browse...>
```

Below "lithology" card, press "Add entry".

Enter input for second "lithology" card:
```
lithology:
    material_identification: rock
```

Below the second "lithology" card, enter input for "lithology_img":
```
lithology_img:
    image: <Browse...>
```

Press "Save".

---

## Editing entries

[ ] **TC-0007**

Edits "sample" record data.

Go to `https://<restful_url>/<database>/sample/TC-0001-0003`.

Press "Edit".

Edit record information:
```
sample:
    kind: natural,
    specimen_type: powder

file:
    name: new file,
    content: <Browse...>,

phase:
    percentage: 50

phase:
    percentage: 60

related_sample(primary_sample_id):
    related_sample: TC-0001-0001
```

Press "Update".

---

[ ] **TC-0008**

Empties out certain "sample" record data.

Go to `https://<restful_url>/<database>/sample/TC-0001-0005`.

Press "Edit"

Edit record information:
```
experiment_epma:
    spectrometer_type: None,
    diffracting_crystal_type:

epma_mineral (first):
    name:

epma_content (third):
    component:
```

Press "Update".
