# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2022 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from DsamPort.idl.

use strict;

package Raritan::RPC::dsam::DsamPort;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "dsam.DsamPort:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::dsam::DsamPort::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant SUCCESS => 0;

use constant SETTINGS_INVALID => 1;

use constant SSH_DPA_PORT_INVALID => 2;

use constant SSH_DPA_PORT_IN_USE => 3;

use Raritan::RPC::dsam::DsamPort::Info;

sub getInfo($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getInfo', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::dsam::DsamPort::Info::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::dsam::DsamPort::Settings;

sub getSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSettings', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::dsam::DsamPort::Settings::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::dsam::DsamPort::Settings;

sub setSettings($$) {
    my ($self, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'settings'} = Raritan::RPC::dsam::DsamPort::Settings::encode($settings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub getTtyUsbNumber($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getTtyUsbNumber', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}


sub setState($$) {
    my ($self, $state) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'state'} = 1 * $state;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setState', $args);
}

Raritan::RPC::Registry::registerProxyClass('dsam.DsamPort', 1, 0, 0, 'Raritan::RPC::dsam::DsamPort');
1;
