// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Panel.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.pdumodel {
  public class Panel_1_1_4 : Com.Raritan.Idl.pdumodel.PowerMeter_1_1_4 {

    static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.Panel:1.1.4", null);

    public Panel_1_1_4(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Panel_1_1_4(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Panel_1_1_4 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Panel_1_1_4(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public enum LabelingScheme {
      SEQUENTIAL,
      ODD_EVEN,
    }

    public class PanelSettings : ICloneable {
      public object Clone() {
        PanelSettings copy = new PanelSettings();
        copy.meterCount = this.meterCount;
        copy.panelSize = this.panelSize;
        copy.columns = this.columns;
        copy.labelingScheme = this.labelingScheme;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["meterCount"] = this.meterCount;
        json["panelSize"] = this.panelSize;
        json["columns"] = this.columns;
        json["labelingScheme"] = (int)this.labelingScheme;
        return json;
      }

      public static PanelSettings Decode(LightJson.JsonObject json, Agent agent) {
        PanelSettings inst = new PanelSettings();
        inst.meterCount = (int)json["meterCount"];
        inst.panelSize = (int)json["panelSize"];
        inst.columns = (int)json["columns"];
        inst.labelingScheme = (Com.Raritan.Idl.pdumodel.Panel_1_1_4.LabelingScheme)(int)json["labelingScheme"];
        return inst;
      }

      public int meterCount = 0;
      public int panelSize = 0;
      public int columns = 0;
      public Com.Raritan.Idl.pdumodel.Panel_1_1_4.LabelingScheme labelingScheme = Com.Raritan.Idl.pdumodel.Panel_1_1_4.LabelingScheme.SEQUENTIAL;
    }

    public class PanelSettingsChangedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.Panel_1_1_4.PanelSettingsChangedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public Com.Raritan.Idl.pdumodel.Panel_1_1_4.PanelSettings oldSettings = new Com.Raritan.Idl.pdumodel.Panel_1_1_4.PanelSettings();
      public Com.Raritan.Idl.pdumodel.Panel_1_1_4.PanelSettings newSettings = new Com.Raritan.Idl.pdumodel.Panel_1_1_4.PanelSettings();
    }

    public class GetPanelSettingsResult {
      public Com.Raritan.Idl.pdumodel.Panel_1_1_4.PanelSettings _ret_;
    }

    public GetPanelSettingsResult getPanelSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getPanelSettings", _parameters);
      var _ret = new GetPanelSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Panel_1_1_4.PanelSettings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getPanelSettings(AsyncRpcResponse<GetPanelSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getPanelSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getPanelSettings(AsyncRpcResponse<GetPanelSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getPanelSettings", _parameters,
        _result => {
          try {
            var _ret = new GetPanelSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Panel_1_1_4.PanelSettings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetPanelSettingsResult {
      public int _ret_;
    }

    public SetPanelSettingsResult setPanelSettings(Com.Raritan.Idl.pdumodel.Panel_1_1_4.PanelSettings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setPanelSettings", _parameters);
      var _ret = new SetPanelSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setPanelSettings(Com.Raritan.Idl.pdumodel.Panel_1_1_4.PanelSettings settings, AsyncRpcResponse<SetPanelSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setPanelSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setPanelSettings(Com.Raritan.Idl.pdumodel.Panel_1_1_4.PanelSettings settings, AsyncRpcResponse<SetPanelSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setPanelSettings", _parameters,
        _result => {
          try {
            var _ret = new SetPanelSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetCircuitsResult {
      public System.Collections.Generic.IDictionary<int, Com.Raritan.Idl.pdumodel.Circuit_1_0_2> _ret_;
    }

    public GetCircuitsResult getCircuits() {
      JsonObject _parameters = null;
      var _result = RpcCall("getCircuits", _parameters);
      var _ret = new GetCircuitsResult();
      _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
        _value => new System.Collections.Generic.KeyValuePair<int, Com.Raritan.Idl.pdumodel.Circuit_1_0_2>(_value["key"], Com.Raritan.Idl.pdumodel.Circuit_1_0_2.StaticCast(ObjectProxy.Decode(_value["value"], agent)))));
      return _ret;
    }

    public AsyncRequest getCircuits(AsyncRpcResponse<GetCircuitsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getCircuits(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getCircuits(AsyncRpcResponse<GetCircuitsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getCircuits", _parameters,
        _result => {
          try {
            var _ret = new GetCircuitsResult();
            _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
              _value => new System.Collections.Generic.KeyValuePair<int, Com.Raritan.Idl.pdumodel.Circuit_1_0_2>(_value["key"], Com.Raritan.Idl.pdumodel.Circuit_1_0_2.StaticCast(ObjectProxy.Decode(_value["value"], agent)))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class CircuitCreatedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.Panel_1_1_4.CircuitCreatedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public Com.Raritan.Idl.pdumodel.Circuit_1_0_2 circuit = null;
      public Com.Raritan.Idl.pdumodel.Circuit_1_0_2.Config config = new Com.Raritan.Idl.pdumodel.Circuit_1_0_2.Config();
      public Com.Raritan.Idl.pdumodel.Circuit_1_0_2.Settings settings = new Com.Raritan.Idl.pdumodel.Circuit_1_0_2.Settings();
    }

    public class CircuitDeletedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.Panel_1_1_4.CircuitDeletedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public Com.Raritan.Idl.pdumodel.Circuit_1_0_2.Config config = new Com.Raritan.Idl.pdumodel.Circuit_1_0_2.Config();
      public Com.Raritan.Idl.pdumodel.Circuit_1_0_2.Settings settings = new Com.Raritan.Idl.pdumodel.Circuit_1_0_2.Settings();
    }

    public class CreateCircuitResult {
      public int _ret_;
      public Com.Raritan.Idl.pdumodel.Circuit_1_0_2 circuit;
    }

    public CreateCircuitResult createCircuit(Com.Raritan.Idl.pdumodel.Circuit_1_0_2.Config config, Com.Raritan.Idl.pdumodel.Circuit_1_0_2.Settings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["config"] = config.Encode();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("createCircuit", _parameters);
      var _ret = new CreateCircuitResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.circuit = Com.Raritan.Idl.pdumodel.Circuit_1_0_2.StaticCast(ObjectProxy.Decode(_result["circuit"], agent));
      return _ret;
    }

    public AsyncRequest createCircuit(Com.Raritan.Idl.pdumodel.Circuit_1_0_2.Config config, Com.Raritan.Idl.pdumodel.Circuit_1_0_2.Settings settings, AsyncRpcResponse<CreateCircuitResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return createCircuit(config, settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest createCircuit(Com.Raritan.Idl.pdumodel.Circuit_1_0_2.Config config, Com.Raritan.Idl.pdumodel.Circuit_1_0_2.Settings settings, AsyncRpcResponse<CreateCircuitResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["config"] = config.Encode();
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("createCircuit", _parameters,
        _result => {
          try {
            var _ret = new CreateCircuitResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.circuit = Com.Raritan.Idl.pdumodel.Circuit_1_0_2.StaticCast(ObjectProxy.Decode(_result["circuit"], agent));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DeleteCircuitResult {
      public int _ret_;
    }

    public DeleteCircuitResult deleteCircuit(int position) {
      var _parameters = new LightJson.JsonObject();
      _parameters["position"] = position;

      var _result = RpcCall("deleteCircuit", _parameters);
      var _ret = new DeleteCircuitResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest deleteCircuit(int position, AsyncRpcResponse<DeleteCircuitResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return deleteCircuit(position, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest deleteCircuit(int position, AsyncRpcResponse<DeleteCircuitResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["position"] = position;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("deleteCircuit", _parameters,
        _result => {
          try {
            var _ret = new DeleteCircuitResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
