% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{xml_dtd}
\alias{xml_dtd}
\title{Construct a document type definition}
\usage{
xml_dtd(name = "", external_id = "", system_id = "")
}
\arguments{
\item{name}{The name of the declaration}

\item{external_id}{The external ID of the declaration}

\item{system_id}{The system ID of the declaration}
}
\description{
This is used to create simple document type definitions. If you need to
create a more complicated definition with internal subsets it is recommended
to parse a string directly with \code{read_xml()}.
}
\examples{
r <- xml_new_root(
  xml_dtd(
    "html",
    "-//W3C//DTD XHTML 1.0 Transitional//EN",
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
  )
)

# Use read_xml directly for more complicated DTD
d <- read_xml(
  '<!DOCTYPE doc [
<!ELEMENT doc (#PCDATA)>
<!ENTITY foo " test ">
]>
<doc>This is a valid document &foo; !</doc>'
)
}
