% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrange.R
\name{step_arrange}
\alias{step_arrange}
\alias{tidy.step_arrange}
\title{Sort rows using dplyr}
\usage{
step_arrange(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  inputs = NULL,
  skip = FALSE,
  id = rand_id("arrange")
)

\method{tidy}{step_arrange}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{Comma separated list of unquoted variable names.
Use \verb{desc()`` to sort a variable in descending order. See [dplyr::arrange()] for more details. For the }tidy`
method, these are not currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{inputs}{Quosure of values given by \code{...}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_arrange} object}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} which
contains the sorting variable(s) or expression(s). The
expressions are text representations and are not parsable.
}
\description{
\code{step_arrange} creates a \emph{specification} of a recipe step
that will sort rows using \code{\link[dplyr:arrange]{dplyr::arrange()}}.
}
\details{
When an object in the user's global environment is
referenced in the expression defining the new variable(s),
it is a good idea to use quasiquotation (e.g. \verb{!!!})
to embed the value of the object in the expression (to
be portable between sessions). See the examples.
}
\examples{
rec <- recipe( ~ ., data = iris) \%>\%
  step_arrange(desc(Sepal.Length), 1/Petal.Length)

prepped <- prep(rec, training = iris \%>\% slice(1:75))
tidy(prepped, number = 1)

library(dplyr)

dplyr_train <-
  iris \%>\%
  as_tibble() \%>\%
  slice(1:75) \%>\%
  dplyr::arrange(desc(Sepal.Length), 1/Petal.Length)

rec_train <- bake(prepped, new_data = NULL)
all.equal(dplyr_train, rec_train)

dplyr_test <-
  iris \%>\%
  as_tibble() \%>\%
  slice(76:150) \%>\%
  dplyr::arrange(desc(Sepal.Length), 1/Petal.Length)
rec_test <- bake(prepped, iris \%>\% slice(76:150))
all.equal(dplyr_test, rec_test)

# When you have variables/expressions, you can create a
# list of symbols with `rlang::syms()`` and splice them in
# the call with `!!!`. See https://tidyeval.tidyverse.org

sort_vars <- c("Sepal.Length", "Petal.Length")

qq_rec <-
  recipe( ~ ., data = iris) \%>\%
  # Embed the `values` object in the call using !!!
  step_arrange(!!!syms(sort_vars)) \%>\%
  prep(training = iris)

tidy(qq_rec, number = 1)
}
\concept{preprocessing}
\keyword{datagen}
