/*
 * charsets.c
 *
 * Copyright (c) Chris Putnam 2003-2020
 *
 * Source code released under the GPL version 2
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include <R.h>


#include "charsets.h"

#define ARRAYSIZE( a )     ( sizeof(a) / sizeof(a[0]) )
#define ARRAYSTART( a )    ( &(a[0]) )
#define CHARSETARRAY( a )  ARRAYSTART( a ), ARRAYSIZE( a )

#define CHARSET_NALIASES ( 7 )

typedef struct convert_t {
	unsigned int index, unicode;
} convert_t;

typedef struct allcharconvert_t {
	char cmdname[15];
	char descriptname[200];
	char aliases[CHARSET_NALIASES][25];
	convert_t *table;
	int ntable;
} allcharconvert_t;

static convert_t adobeiso[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 305 },
	{ 145, 768 },
	{ 146, 769 },
	{ 147, 770 },
	{ 148, 771 },
	{ 149, 772 },
	{ 150, 774 },
	{ 151, 775 },
	{ 152, 776 },
	{ 153, 153 },
	{ 154, 778 },
	{ 155, 807 },
	{ 156, 156 },
	{ 157, 779 },
	{ 158, 808 },
	{ 159, 780 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t adobestd[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 8260 },
	{ 165, 165 },
	{ 166, 402 },
	{ 167, 167 },
	{ 168, 164 },
	{ 169, 169 },
	{ 170, 8220 },
	{ 171, 171 },
	{ 172, 8249 },
	{ 173, 8250 },
	{ 174, 64257 },
	{ 175, 64258 },
	{ 176, 176 },
	{ 177, 8211 },
	{ 178, 8224 },
	{ 179, 8225 },
	{ 180, 183 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 8729 },
	{ 184, 8218 },
	{ 185, 8222 },
	{ 186, 8221 },
	{ 187, 187 },
	{ 188, 8943 },
	{ 189, 8240 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 768 },
	{ 194, 180 },
	{ 195, 770 },
	{ 196, 771 },
	{ 197, 175 },
	{ 198, 728 },
	{ 199, 729 },
	{ 200, 168 },
	{ 201, 201 },
	{ 202, 176 },
	{ 203, 184 },
	{ 204, 204 },
	{ 205, 733 },
	{ 206, 731 },
	{ 207, 711 },
	{ 208, 8212 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 198 },
	{ 226, 226 },
	{ 227, 170 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 321 },
	{ 233, 216 },
	{ 234, 338 },
	{ 235, 186 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 230 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 305 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 322 },
	{ 249, 248 },
	{ 250, 339 },
	{ 251, 223 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 225 },
	{ 97, 227 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 245 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t adobesym[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 8242 },
	{ 163, 8804 },
	{ 164, 8725 },
	{ 165, 8734 },
	{ 166, 402 },
	{ 167, 9827 },
	{ 168, 9830 },
	{ 169, 9829 },
	{ 170, 9824 },
	{ 171, 8596 },
	{ 172, 8592 },
	{ 173, 8593 },
	{ 174, 8594 },
	{ 175, 8595 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 8243 },
	{ 179, 8805 },
	{ 180, 215 },
	{ 181, 8733 },
	{ 182, 8706 },
	{ 183, 8729 },
	{ 184, 247 },
	{ 185, 8800 },
	{ 186, 8801 },
	{ 187, 8776 },
	{ 188, 8943 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 8709 },
	{ 199, 8745 },
	{ 200, 8746 },
	{ 201, 8835 },
	{ 202, 8839 },
	{ 203, 203 },
	{ 204, 8834 },
	{ 205, 8838 },
	{ 206, 8712 },
	{ 207, 207 },
	{ 208, 8736 },
	{ 209, 8711 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 8719 },
	{ 214, 8730 },
	{ 215, 8901 },
	{ 216, 172 },
	{ 217, 8743 },
	{ 218, 8744 },
	{ 219, 8660 },
	{ 220, 8656 },
	{ 221, 8657 },
	{ 222, 8658 },
	{ 223, 8659 },
	{ 224, 9674 },
	{ 225, 9001 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 8721 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 9002 },
	{ 242, 8747 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 220 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t applecro[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 196 },
	{ 129, 197 },
	{ 130, 199 },
	{ 131, 201 },
	{ 132, 209 },
	{ 133, 214 },
	{ 134, 220 },
	{ 135, 225 },
	{ 136, 224 },
	{ 137, 226 },
	{ 138, 228 },
	{ 139, 227 },
	{ 140, 229 },
	{ 141, 231 },
	{ 142, 233 },
	{ 143, 232 },
	{ 144, 234 },
	{ 145, 235 },
	{ 146, 237 },
	{ 147, 236 },
	{ 148, 238 },
	{ 149, 239 },
	{ 150, 241 },
	{ 151, 243 },
	{ 152, 242 },
	{ 153, 244 },
	{ 154, 246 },
	{ 155, 245 },
	{ 156, 250 },
	{ 157, 249 },
	{ 158, 251 },
	{ 159, 252 },
	{ 160, 8224 },
	{ 161, 176 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 167 },
	{ 165, 8729 },
	{ 166, 182 },
	{ 167, 223 },
	{ 168, 174 },
	{ 169, 352 },
	{ 170, 8482 },
	{ 171, 180 },
	{ 172, 168 },
	{ 173, 8800 },
	{ 174, 381 },
	{ 175, 216 },
	{ 176, 8734 },
	{ 177, 177 },
	{ 178, 8804 },
	{ 179, 8805 },
	{ 180, 916 },
	{ 181, 181 },
	{ 182, 8706 },
	{ 183, 8721 },
	{ 184, 8719 },
	{ 185, 353 },
	{ 186, 8747 },
	{ 187, 170 },
	{ 188, 186 },
	{ 189, 937 },
	{ 190, 382 },
	{ 191, 248 },
	{ 192, 191 },
	{ 193, 161 },
	{ 194, 172 },
	{ 195, 8730 },
	{ 196, 402 },
	{ 197, 8776 },
	{ 198, 262 },
	{ 199, 171 },
	{ 200, 268 },
	{ 201, 8943 },
	{ 202, 160 },
	{ 203, 192 },
	{ 204, 195 },
	{ 205, 213 },
	{ 206, 338 },
	{ 207, 339 },
	{ 208, 272 },
	{ 209, 8212 },
	{ 210, 8220 },
	{ 211, 8221 },
	{ 212, 8216 },
	{ 213, 8217 },
	{ 214, 247 },
	{ 215, 9674 },
	{ 216, 65534 },
	{ 217, 169 },
	{ 218, 8260 },
	{ 219, 164 },
	{ 220, 8249 },
	{ 221, 8250 },
	{ 222, 198 },
	{ 223, 187 },
	{ 224, 8211 },
	{ 225, 183 },
	{ 226, 8218 },
	{ 227, 8222 },
	{ 228, 8240 },
	{ 229, 194 },
	{ 230, 263 },
	{ 231, 193 },
	{ 232, 269 },
	{ 233, 200 },
	{ 234, 205 },
	{ 235, 206 },
	{ 236, 207 },
	{ 237, 204 },
	{ 238, 211 },
	{ 239, 212 },
	{ 240, 273 },
	{ 241, 210 },
	{ 242, 218 },
	{ 243, 219 },
	{ 244, 217 },
	{ 245, 305 },
	{ 246, 770 },
	{ 247, 771 },
	{ 248, 175 },
	{ 249, 960 },
	{ 250, 203 },
	{ 251, 730 },
	{ 252, 184 },
	{ 253, 202 },
	{ 254, 230 },
	{ 255, 711 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 264 },
	{ 67, 266 },
	{ 99, 265 },
	{ 99, 267 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 122, 378 },
	{ 122, 380 },
};
static convert_t applecyr[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 1040 },
	{ 129, 1041 },
	{ 130, 1042 },
	{ 131, 1043 },
	{ 132, 1044 },
	{ 133, 1045 },
	{ 134, 1046 },
	{ 135, 1047 },
	{ 136, 1048 },
	{ 137, 1049 },
	{ 138, 1050 },
	{ 139, 1051 },
	{ 140, 1052 },
	{ 141, 1053 },
	{ 142, 1054 },
	{ 143, 1055 },
	{ 144, 1056 },
	{ 145, 1057 },
	{ 146, 1058 },
	{ 147, 1059 },
	{ 148, 1060 },
	{ 149, 1061 },
	{ 150, 1062 },
	{ 151, 1063 },
	{ 152, 1064 },
	{ 153, 1065 },
	{ 154, 1066 },
	{ 155, 1067 },
	{ 156, 1068 },
	{ 157, 1069 },
	{ 158, 1070 },
	{ 159, 1071 },
	{ 160, 8224 },
	{ 161, 176 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 167 },
	{ 165, 8729 },
	{ 166, 182 },
	{ 167, 1030 },
	{ 168, 174 },
	{ 169, 169 },
	{ 170, 8482 },
	{ 171, 1026 },
	{ 172, 1106 },
	{ 173, 8800 },
	{ 174, 1027 },
	{ 175, 1107 },
	{ 176, 8734 },
	{ 177, 177 },
	{ 178, 8804 },
	{ 179, 8805 },
	{ 180, 1110 },
	{ 181, 181 },
	{ 182, 8706 },
	{ 183, 1032 },
	{ 184, 1028 },
	{ 185, 1108 },
	{ 186, 1031 },
	{ 187, 1111 },
	{ 188, 1033 },
	{ 189, 1113 },
	{ 190, 1034 },
	{ 191, 1114 },
	{ 192, 1112 },
	{ 193, 1029 },
	{ 194, 172 },
	{ 195, 8730 },
	{ 196, 402 },
	{ 197, 8776 },
	{ 198, 916 },
	{ 199, 171 },
	{ 200, 187 },
	{ 201, 8943 },
	{ 202, 160 },
	{ 203, 1035 },
	{ 204, 1115 },
	{ 205, 1036 },
	{ 206, 1116 },
	{ 207, 1109 },
	{ 208, 8211 },
	{ 209, 8212 },
	{ 210, 8220 },
	{ 211, 8221 },
	{ 212, 8216 },
	{ 213, 8217 },
	{ 214, 247 },
	{ 215, 8222 },
	{ 216, 1038 },
	{ 217, 1118 },
	{ 218, 1039 },
	{ 219, 1119 },
	{ 220, 8470 },
	{ 221, 1025 },
	{ 222, 1105 },
	{ 223, 1103 },
	{ 224, 1072 },
	{ 225, 1073 },
	{ 226, 1074 },
	{ 227, 1075 },
	{ 228, 1076 },
	{ 229, 1077 },
	{ 230, 1078 },
	{ 231, 1079 },
	{ 232, 1080 },
	{ 233, 1081 },
	{ 234, 1082 },
	{ 235, 1083 },
	{ 236, 1084 },
	{ 237, 1085 },
	{ 238, 1086 },
	{ 239, 1087 },
	{ 240, 1088 },
	{ 241, 1089 },
	{ 242, 1090 },
	{ 243, 1091 },
	{ 244, 1092 },
	{ 245, 1093 },
	{ 246, 1094 },
	{ 247, 1095 },
	{ 248, 1096 },
	{ 249, 1097 },
	{ 250, 1098 },
	{ 251, 1099 },
	{ 252, 1100 },
	{ 253, 1101 },
	{ 254, 1102 },
	{ 255, 164 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 244 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 220 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 252 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t applegk2[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 196 },
	{ 129, 913 },
	{ 130, 914 },
	{ 131, 915 },
	{ 132, 916 },
	{ 133, 214 },
	{ 134, 220 },
	{ 135, 917 },
	{ 136, 224 },
	{ 137, 226 },
	{ 138, 228 },
	{ 139, 918 },
	{ 140, 919 },
	{ 141, 231 },
	{ 142, 233 },
	{ 143, 232 },
	{ 144, 234 },
	{ 145, 235 },
	{ 146, 163 },
	{ 147, 8482 },
	{ 148, 238 },
	{ 149, 239 },
	{ 150, 8729 },
	{ 151, 920 },
	{ 152, 921 },
	{ 153, 244 },
	{ 154, 246 },
	{ 155, 155 },
	{ 156, 922 },
	{ 157, 249 },
	{ 158, 251 },
	{ 159, 252 },
	{ 160, 923 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 223 },
	{ 168, 174 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 938 },
	{ 172, 167 },
	{ 173, 8800 },
	{ 174, 924 },
	{ 175, 903 },
	{ 176, 925 },
	{ 177, 177 },
	{ 178, 8804 },
	{ 179, 8805 },
	{ 180, 926 },
	{ 181, 927 },
	{ 182, 928 },
	{ 183, 929 },
	{ 184, 931 },
	{ 185, 932 },
	{ 186, 933 },
	{ 187, 939 },
	{ 188, 934 },
	{ 189, 935 },
	{ 190, 936 },
	{ 191, 937 },
	{ 192, 940 },
	{ 193, 185 },
	{ 194, 172 },
	{ 195, 178 },
	{ 196, 179 },
	{ 197, 168 },
	{ 198, 901 },
	{ 199, 171 },
	{ 200, 187 },
	{ 201, 8943 },
	{ 202, 160 },
	{ 203, 166 },
	{ 204, 189 },
	{ 205, 902 },
	{ 206, 904 },
	{ 207, 176 },
	{ 208, 8211 },
	{ 209, 8212 },
	{ 210, 8220 },
	{ 211, 8221 },
	{ 212, 8216 },
	{ 213, 8217 },
	{ 214, 900 },
	{ 215, 905 },
	{ 216, 906 },
	{ 217, 908 },
	{ 218, 910 },
	{ 219, 941 },
	{ 220, 942 },
	{ 221, 943 },
	{ 222, 972 },
	{ 223, 911 },
	{ 224, 973 },
	{ 225, 945 },
	{ 226, 946 },
	{ 227, 968 },
	{ 228, 948 },
	{ 229, 949 },
	{ 230, 966 },
	{ 231, 947 },
	{ 232, 951 },
	{ 233, 953 },
	{ 234, 958 },
	{ 235, 954 },
	{ 236, 955 },
	{ 237, 956 },
	{ 238, 957 },
	{ 239, 959 },
	{ 240, 960 },
	{ 241, 974 },
	{ 242, 961 },
	{ 243, 963 },
	{ 244, 964 },
	{ 245, 952 },
	{ 246, 969 },
	{ 247, 962 },
	{ 248, 967 },
	{ 249, 965 },
	{ 250, 950 },
	{ 251, 970 },
	{ 252, 971 },
	{ 253, 912 },
	{ 254, 944 },
	{ 255, 8240 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 225 },
	{ 97, 227 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 245 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 250 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t applegrk[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 900 },
	{ 181, 901 },
	{ 182, 902 },
	{ 183, 183 },
	{ 184, 904 },
	{ 185, 905 },
	{ 186, 906 },
	{ 187, 187 },
	{ 188, 908 },
	{ 189, 189 },
	{ 190, 910 },
	{ 191, 911 },
	{ 192, 912 },
	{ 193, 913 },
	{ 194, 914 },
	{ 195, 915 },
	{ 196, 916 },
	{ 197, 917 },
	{ 198, 918 },
	{ 199, 919 },
	{ 200, 920 },
	{ 201, 921 },
	{ 202, 922 },
	{ 203, 923 },
	{ 204, 924 },
	{ 205, 925 },
	{ 206, 926 },
	{ 207, 927 },
	{ 208, 928 },
	{ 209, 929 },
	{ 210, 210 },
	{ 211, 931 },
	{ 212, 932 },
	{ 213, 933 },
	{ 214, 934 },
	{ 215, 935 },
	{ 216, 936 },
	{ 217, 937 },
	{ 218, 938 },
	{ 219, 939 },
	{ 220, 940 },
	{ 221, 941 },
	{ 222, 942 },
	{ 223, 943 },
	{ 224, 944 },
	{ 225, 945 },
	{ 226, 946 },
	{ 227, 947 },
	{ 228, 948 },
	{ 229, 949 },
	{ 230, 950 },
	{ 231, 951 },
	{ 232, 952 },
	{ 233, 953 },
	{ 234, 954 },
	{ 235, 955 },
	{ 236, 956 },
	{ 237, 957 },
	{ 238, 958 },
	{ 239, 959 },
	{ 240, 960 },
	{ 241, 961 },
	{ 242, 962 },
	{ 243, 963 },
	{ 244, 964 },
	{ 245, 965 },
	{ 246, 966 },
	{ 247, 967 },
	{ 248, 968 },
	{ 249, 969 },
	{ 250, 970 },
	{ 251, 971 },
	{ 252, 972 },
	{ 253, 973 },
	{ 254, 974 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 244 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 220 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 252 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t macice[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 196 },
	{ 129, 197 },
	{ 130, 199 },
	{ 131, 201 },
	{ 132, 209 },
	{ 133, 214 },
	{ 134, 220 },
	{ 135, 225 },
	{ 136, 224 },
	{ 137, 226 },
	{ 138, 228 },
	{ 139, 227 },
	{ 140, 229 },
	{ 141, 231 },
	{ 142, 233 },
	{ 143, 232 },
	{ 144, 234 },
	{ 145, 235 },
	{ 146, 237 },
	{ 147, 236 },
	{ 148, 238 },
	{ 149, 239 },
	{ 150, 241 },
	{ 151, 243 },
	{ 152, 242 },
	{ 153, 244 },
	{ 154, 246 },
	{ 155, 245 },
	{ 156, 250 },
	{ 157, 249 },
	{ 158, 251 },
	{ 159, 252 },
	{ 160, 221 },
	{ 161, 176 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 167 },
	{ 165, 8729 },
	{ 166, 182 },
	{ 167, 223 },
	{ 168, 174 },
	{ 169, 169 },
	{ 170, 8482 },
	{ 171, 180 },
	{ 172, 168 },
	{ 173, 8800 },
	{ 174, 198 },
	{ 175, 216 },
	{ 176, 8734 },
	{ 177, 177 },
	{ 178, 8804 },
	{ 179, 8805 },
	{ 180, 165 },
	{ 181, 181 },
	{ 182, 8706 },
	{ 183, 8721 },
	{ 184, 8719 },
	{ 185, 960 },
	{ 186, 8747 },
	{ 187, 170 },
	{ 188, 186 },
	{ 189, 937 },
	{ 190, 230 },
	{ 191, 248 },
	{ 192, 191 },
	{ 193, 161 },
	{ 194, 172 },
	{ 195, 8730 },
	{ 196, 402 },
	{ 197, 8776 },
	{ 198, 916 },
	{ 199, 171 },
	{ 200, 187 },
	{ 201, 8943 },
	{ 202, 160 },
	{ 203, 192 },
	{ 204, 195 },
	{ 205, 213 },
	{ 206, 338 },
	{ 207, 339 },
	{ 208, 8211 },
	{ 209, 8212 },
	{ 210, 8220 },
	{ 211, 8221 },
	{ 212, 8216 },
	{ 213, 8217 },
	{ 214, 247 },
	{ 215, 9674 },
	{ 216, 255 },
	{ 217, 376 },
	{ 218, 8260 },
	{ 219, 164 },
	{ 220, 208 },
	{ 221, 240 },
	{ 222, 222 },
	{ 223, 254 },
	{ 224, 253 },
	{ 225, 183 },
	{ 226, 8218 },
	{ 227, 8222 },
	{ 228, 8240 },
	{ 229, 194 },
	{ 230, 202 },
	{ 231, 193 },
	{ 232, 203 },
	{ 233, 200 },
	{ 234, 205 },
	{ 235, 206 },
	{ 236, 207 },
	{ 237, 204 },
	{ 238, 211 },
	{ 239, 212 },
	{ 240, 65534 },
	{ 241, 210 },
	{ 242, 218 },
	{ 243, 219 },
	{ 244, 217 },
	{ 245, 305 },
	{ 246, 770 },
	{ 247, 771 },
	{ 248, 175 },
	{ 249, 728 },
	{ 250, 729 },
	{ 251, 730 },
	{ 252, 184 },
	{ 253, 733 },
	{ 254, 731 },
	{ 255, 711 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t macroman[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 196 },
	{ 129, 197 },
	{ 130, 199 },
	{ 131, 201 },
	{ 132, 209 },
	{ 133, 214 },
	{ 134, 220 },
	{ 135, 225 },
	{ 136, 224 },
	{ 137, 226 },
	{ 138, 228 },
	{ 139, 227 },
	{ 140, 229 },
	{ 141, 231 },
	{ 142, 233 },
	{ 143, 232 },
	{ 144, 234 },
	{ 145, 235 },
	{ 146, 237 },
	{ 147, 236 },
	{ 148, 238 },
	{ 149, 239 },
	{ 150, 241 },
	{ 151, 243 },
	{ 152, 242 },
	{ 153, 244 },
	{ 154, 246 },
	{ 155, 245 },
	{ 156, 250 },
	{ 157, 249 },
	{ 158, 251 },
	{ 159, 252 },
	{ 160, 8224 },
	{ 161, 176 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 167 },
	{ 165, 8729 },
	{ 166, 182 },
	{ 167, 223 },
	{ 168, 174 },
	{ 169, 169 },
	{ 170, 8482 },
	{ 171, 180 },
	{ 172, 168 },
	{ 173, 8800 },
	{ 174, 198 },
	{ 175, 216 },
	{ 176, 8734 },
	{ 177, 177 },
	{ 178, 8804 },
	{ 179, 8805 },
	{ 180, 165 },
	{ 181, 181 },
	{ 182, 8706 },
	{ 183, 8721 },
	{ 184, 8719 },
	{ 185, 960 },
	{ 186, 8747 },
	{ 187, 170 },
	{ 188, 186 },
	{ 189, 937 },
	{ 190, 230 },
	{ 191, 248 },
	{ 192, 191 },
	{ 193, 161 },
	{ 194, 172 },
	{ 195, 8730 },
	{ 196, 402 },
	{ 197, 8776 },
	{ 198, 916 },
	{ 199, 171 },
	{ 200, 187 },
	{ 201, 8943 },
	{ 202, 160 },
	{ 203, 192 },
	{ 204, 195 },
	{ 205, 213 },
	{ 206, 338 },
	{ 207, 339 },
	{ 208, 8211 },
	{ 209, 8212 },
	{ 210, 8220 },
	{ 211, 8221 },
	{ 212, 8216 },
	{ 213, 8217 },
	{ 214, 247 },
	{ 215, 9674 },
	{ 216, 255 },
	{ 217, 376 },
	{ 218, 8260 },
	{ 219, 164 },
	{ 220, 8249 },
	{ 221, 8250 },
	{ 222, 64257 },
	{ 223, 64258 },
	{ 224, 8225 },
	{ 225, 183 },
	{ 226, 8218 },
	{ 227, 8222 },
	{ 228, 8240 },
	{ 229, 194 },
	{ 230, 202 },
	{ 231, 193 },
	{ 232, 203 },
	{ 233, 200 },
	{ 234, 205 },
	{ 235, 206 },
	{ 236, 207 },
	{ 237, 204 },
	{ 238, 211 },
	{ 239, 212 },
	{ 240, 240 },
	{ 241, 210 },
	{ 242, 218 },
	{ 243, 219 },
	{ 244, 217 },
	{ 245, 305 },
	{ 246, 770 },
	{ 247, 771 },
	{ 248, 175 },
	{ 249, 728 },
	{ 250, 729 },
	{ 251, 730 },
	{ 252, 184 },
	{ 253, 733 },
	{ 254, 731 },
	{ 255, 711 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 121, 253 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t macromanian[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 196 },
	{ 129, 197 },
	{ 130, 199 },
	{ 131, 201 },
	{ 132, 209 },
	{ 133, 214 },
	{ 134, 220 },
	{ 135, 225 },
	{ 136, 224 },
	{ 137, 226 },
	{ 138, 228 },
	{ 139, 227 },
	{ 140, 229 },
	{ 141, 231 },
	{ 142, 233 },
	{ 143, 232 },
	{ 144, 234 },
	{ 145, 235 },
	{ 146, 237 },
	{ 147, 236 },
	{ 148, 238 },
	{ 149, 239 },
	{ 150, 241 },
	{ 151, 243 },
	{ 152, 242 },
	{ 153, 244 },
	{ 154, 246 },
	{ 155, 245 },
	{ 156, 250 },
	{ 157, 249 },
	{ 158, 251 },
	{ 159, 252 },
	{ 160, 8224 },
	{ 161, 176 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 167 },
	{ 165, 8729 },
	{ 166, 182 },
	{ 167, 223 },
	{ 168, 174 },
	{ 169, 169 },
	{ 170, 8482 },
	{ 171, 180 },
	{ 172, 168 },
	{ 173, 8800 },
	{ 174, 258 },
	{ 175, 350 },
	{ 176, 8734 },
	{ 177, 177 },
	{ 178, 8804 },
	{ 179, 8805 },
	{ 180, 165 },
	{ 181, 181 },
	{ 182, 8706 },
	{ 183, 8721 },
	{ 184, 8719 },
	{ 185, 960 },
	{ 186, 8747 },
	{ 187, 170 },
	{ 188, 186 },
	{ 189, 937 },
	{ 190, 259 },
	{ 191, 351 },
	{ 192, 191 },
	{ 193, 161 },
	{ 194, 172 },
	{ 195, 8730 },
	{ 196, 402 },
	{ 197, 8776 },
	{ 198, 916 },
	{ 199, 171 },
	{ 200, 187 },
	{ 201, 8943 },
	{ 202, 160 },
	{ 203, 192 },
	{ 204, 195 },
	{ 205, 213 },
	{ 206, 338 },
	{ 207, 339 },
	{ 208, 8211 },
	{ 209, 8212 },
	{ 210, 8220 },
	{ 211, 8221 },
	{ 212, 8216 },
	{ 213, 8217 },
	{ 214, 247 },
	{ 215, 9674 },
	{ 216, 255 },
	{ 217, 376 },
	{ 218, 8260 },
	{ 219, 164 },
	{ 220, 8249 },
	{ 221, 8250 },
	{ 222, 354 },
	{ 223, 355 },
	{ 224, 8225 },
	{ 225, 183 },
	{ 226, 8218 },
	{ 227, 8222 },
	{ 228, 8240 },
	{ 229, 194 },
	{ 230, 202 },
	{ 231, 193 },
	{ 232, 203 },
	{ 233, 200 },
	{ 234, 205 },
	{ 235, 206 },
	{ 236, 207 },
	{ 237, 204 },
	{ 238, 211 },
	{ 239, 212 },
	{ 240, 65534 },
	{ 241, 210 },
	{ 242, 218 },
	{ 243, 219 },
	{ 244, 217 },
	{ 245, 305 },
	{ 246, 770 },
	{ 247, 771 },
	{ 248, 175 },
	{ 249, 728 },
	{ 250, 729 },
	{ 251, 730 },
	{ 252, 184 },
	{ 253, 733 },
	{ 254, 731 },
	{ 255, 711 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 353 },
	{ 84, 356 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 121, 253 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t macturkish[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 196 },
	{ 129, 197 },
	{ 130, 199 },
	{ 131, 201 },
	{ 132, 209 },
	{ 133, 214 },
	{ 134, 220 },
	{ 135, 225 },
	{ 136, 224 },
	{ 137, 226 },
	{ 138, 228 },
	{ 139, 227 },
	{ 140, 229 },
	{ 141, 231 },
	{ 142, 233 },
	{ 143, 232 },
	{ 144, 234 },
	{ 145, 235 },
	{ 146, 237 },
	{ 147, 236 },
	{ 148, 238 },
	{ 149, 239 },
	{ 150, 241 },
	{ 151, 243 },
	{ 152, 242 },
	{ 153, 244 },
	{ 154, 246 },
	{ 155, 245 },
	{ 156, 250 },
	{ 157, 249 },
	{ 158, 251 },
	{ 159, 252 },
	{ 160, 8224 },
	{ 161, 176 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 167 },
	{ 165, 8729 },
	{ 166, 182 },
	{ 167, 223 },
	{ 168, 174 },
	{ 169, 169 },
	{ 170, 8482 },
	{ 171, 180 },
	{ 172, 168 },
	{ 173, 8800 },
	{ 174, 198 },
	{ 175, 216 },
	{ 176, 8734 },
	{ 177, 177 },
	{ 178, 8804 },
	{ 179, 8805 },
	{ 180, 165 },
	{ 181, 181 },
	{ 182, 8706 },
	{ 183, 8721 },
	{ 184, 8719 },
	{ 185, 960 },
	{ 186, 8747 },
	{ 187, 170 },
	{ 188, 186 },
	{ 189, 937 },
	{ 190, 230 },
	{ 191, 248 },
	{ 192, 191 },
	{ 193, 161 },
	{ 194, 172 },
	{ 195, 8730 },
	{ 196, 402 },
	{ 197, 8776 },
	{ 198, 916 },
	{ 199, 171 },
	{ 200, 187 },
	{ 201, 8943 },
	{ 202, 160 },
	{ 203, 192 },
	{ 204, 195 },
	{ 205, 213 },
	{ 206, 338 },
	{ 207, 339 },
	{ 208, 8211 },
	{ 209, 8212 },
	{ 210, 8220 },
	{ 211, 8221 },
	{ 212, 8216 },
	{ 213, 8217 },
	{ 214, 247 },
	{ 215, 9674 },
	{ 216, 255 },
	{ 217, 376 },
	{ 218, 286 },
	{ 219, 287 },
	{ 220, 304 },
	{ 221, 305 },
	{ 222, 350 },
	{ 223, 351 },
	{ 224, 8225 },
	{ 225, 183 },
	{ 226, 8218 },
	{ 227, 8222 },
	{ 228, 8240 },
	{ 229, 194 },
	{ 230, 202 },
	{ 231, 193 },
	{ 232, 203 },
	{ 233, 200 },
	{ 234, 205 },
	{ 235, 206 },
	{ 236, 207 },
	{ 237, 204 },
	{ 238, 211 },
	{ 239, 212 },
	{ 240, 65534 },
	{ 241, 210 },
	{ 242, 218 },
	{ 243, 219 },
	{ 244, 217 },
	{ 245, 245 },
	{ 246, 770 },
	{ 247, 771 },
	{ 248, 175 },
	{ 249, 728 },
	{ 250, 729 },
	{ 251, 730 },
	{ 252, 184 },
	{ 253, 733 },
	{ 254, 731 },
	{ 255, 711 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 121, 253 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t atarist[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 199 },
	{ 129, 252 },
	{ 130, 233 },
	{ 131, 226 },
	{ 132, 228 },
	{ 133, 224 },
	{ 134, 229 },
	{ 135, 231 },
	{ 136, 234 },
	{ 137, 235 },
	{ 138, 232 },
	{ 139, 239 },
	{ 140, 238 },
	{ 141, 236 },
	{ 142, 196 },
	{ 143, 197 },
	{ 144, 201 },
	{ 145, 230 },
	{ 146, 198 },
	{ 147, 244 },
	{ 148, 246 },
	{ 149, 242 },
	{ 150, 251 },
	{ 151, 249 },
	{ 152, 255 },
	{ 153, 214 },
	{ 154, 220 },
	{ 155, 162 },
	{ 156, 163 },
	{ 157, 165 },
	{ 158, 223 },
	{ 159, 402 },
	{ 160, 225 },
	{ 161, 237 },
	{ 162, 243 },
	{ 163, 250 },
	{ 164, 241 },
	{ 165, 209 },
	{ 166, 170 },
	{ 167, 186 },
	{ 168, 191 },
	{ 169, 8976 },
	{ 170, 172 },
	{ 171, 189 },
	{ 172, 188 },
	{ 173, 161 },
	{ 174, 171 },
	{ 175, 187 },
	{ 176, 227 },
	{ 177, 245 },
	{ 178, 216 },
	{ 179, 248 },
	{ 180, 339 },
	{ 181, 338 },
	{ 182, 192 },
	{ 183, 195 },
	{ 184, 213 },
	{ 185, 168 },
	{ 186, 180 },
	{ 187, 8224 },
	{ 188, 182 },
	{ 189, 169 },
	{ 190, 174 },
	{ 191, 8482 },
	{ 192, 307 },
	{ 193, 306 },
	{ 194, 1488 },
	{ 195, 1489 },
	{ 196, 1490 },
	{ 197, 1491 },
	{ 198, 1492 },
	{ 199, 1493 },
	{ 200, 1494 },
	{ 201, 1495 },
	{ 202, 1496 },
	{ 203, 1497 },
	{ 204, 1499 },
	{ 205, 1500 },
	{ 206, 1502 },
	{ 207, 1504 },
	{ 208, 1505 },
	{ 209, 1506 },
	{ 210, 1508 },
	{ 211, 1510 },
	{ 212, 1511 },
	{ 213, 1512 },
	{ 214, 1513 },
	{ 215, 1514 },
	{ 216, 1503 },
	{ 217, 1498 },
	{ 218, 1501 },
	{ 219, 1507 },
	{ 220, 1509 },
	{ 221, 167 },
	{ 222, 8743 },
	{ 223, 8734 },
	{ 224, 945 },
	{ 225, 946 },
	{ 226, 915 },
	{ 227, 960 },
	{ 228, 931 },
	{ 229, 963 },
	{ 230, 181 },
	{ 231, 964 },
	{ 232, 934 },
	{ 233, 920 },
	{ 234, 937 },
	{ 235, 948 },
	{ 236, 8750 },
	{ 237, 966 },
	{ 238, 949 },
	{ 239, 8745 },
	{ 240, 8801 },
	{ 241, 177 },
	{ 242, 8805 },
	{ 243, 8804 },
	{ 244, 8992 },
	{ 245, 8993 },
	{ 246, 247 },
	{ 247, 8776 },
	{ 248, 176 },
	{ 249, 8729 },
	{ 250, 183 },
	{ 251, 8730 },
	{ 252, 8319 },
	{ 253, 178 },
	{ 254, 179 },
	{ 255, 175 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp437[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 199 },
	{ 129, 252 },
	{ 130, 233 },
	{ 131, 226 },
	{ 132, 228 },
	{ 133, 224 },
	{ 134, 229 },
	{ 135, 231 },
	{ 136, 234 },
	{ 137, 235 },
	{ 138, 232 },
	{ 139, 239 },
	{ 140, 238 },
	{ 141, 236 },
	{ 142, 196 },
	{ 143, 197 },
	{ 144, 201 },
	{ 145, 230 },
	{ 146, 198 },
	{ 147, 244 },
	{ 148, 246 },
	{ 149, 242 },
	{ 150, 251 },
	{ 151, 249 },
	{ 152, 255 },
	{ 153, 214 },
	{ 154, 220 },
	{ 155, 162 },
	{ 156, 163 },
	{ 157, 165 },
	{ 158, 8359 },
	{ 159, 402 },
	{ 160, 225 },
	{ 161, 237 },
	{ 162, 243 },
	{ 163, 250 },
	{ 164, 241 },
	{ 165, 209 },
	{ 166, 170 },
	{ 167, 186 },
	{ 168, 191 },
	{ 169, 8976 },
	{ 170, 172 },
	{ 171, 189 },
	{ 172, 188 },
	{ 173, 161 },
	{ 174, 171 },
	{ 175, 187 },
	{ 176, 9617 },
	{ 177, 9618 },
	{ 178, 9619 },
	{ 179, 9474 },
	{ 180, 9508 },
	{ 181, 9569 },
	{ 182, 9570 },
	{ 183, 9558 },
	{ 184, 9557 },
	{ 185, 9571 },
	{ 186, 9553 },
	{ 187, 9559 },
	{ 188, 9565 },
	{ 189, 9564 },
	{ 190, 9563 },
	{ 191, 9488 },
	{ 192, 9492 },
	{ 193, 9524 },
	{ 194, 9516 },
	{ 195, 9500 },
	{ 196, 9472 },
	{ 197, 9532 },
	{ 198, 9566 },
	{ 199, 9567 },
	{ 200, 9562 },
	{ 201, 9556 },
	{ 202, 9577 },
	{ 203, 9574 },
	{ 204, 9568 },
	{ 205, 9552 },
	{ 206, 9580 },
	{ 207, 9575 },
	{ 208, 9576 },
	{ 209, 9572 },
	{ 210, 9573 },
	{ 211, 9561 },
	{ 212, 9560 },
	{ 213, 9554 },
	{ 214, 9555 },
	{ 215, 9579 },
	{ 216, 9578 },
	{ 217, 9496 },
	{ 218, 9484 },
	{ 219, 9608 },
	{ 220, 9604 },
	{ 221, 9612 },
	{ 222, 9616 },
	{ 223, 9600 },
	{ 224, 945 },
	{ 225, 223 },
	{ 226, 915 },
	{ 227, 960 },
	{ 228, 931 },
	{ 229, 963 },
	{ 230, 181 },
	{ 231, 964 },
	{ 232, 934 },
	{ 233, 920 },
	{ 234, 937 },
	{ 235, 948 },
	{ 236, 8734 },
	{ 237, 966 },
	{ 238, 949 },
	{ 239, 8745 },
	{ 240, 8801 },
	{ 241, 177 },
	{ 242, 8805 },
	{ 243, 8804 },
	{ 244, 8992 },
	{ 245, 8993 },
	{ 246, 247 },
	{ 247, 8776 },
	{ 248, 176 },
	{ 249, 8729 },
	{ 250, 183 },
	{ 251, 8730 },
	{ 252, 8319 },
	{ 253, 178 },
	{ 254, 9632 },
	{ 255, 160 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 227 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 245 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp737[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 913 },
	{ 129, 914 },
	{ 130, 915 },
	{ 131, 916 },
	{ 132, 917 },
	{ 133, 918 },
	{ 134, 919 },
	{ 135, 920 },
	{ 136, 921 },
	{ 137, 922 },
	{ 138, 923 },
	{ 139, 924 },
	{ 140, 925 },
	{ 141, 926 },
	{ 142, 927 },
	{ 143, 928 },
	{ 144, 929 },
	{ 145, 931 },
	{ 146, 932 },
	{ 147, 933 },
	{ 148, 934 },
	{ 149, 935 },
	{ 150, 936 },
	{ 151, 937 },
	{ 152, 945 },
	{ 153, 946 },
	{ 154, 947 },
	{ 155, 948 },
	{ 156, 949 },
	{ 157, 950 },
	{ 158, 951 },
	{ 159, 952 },
	{ 160, 953 },
	{ 161, 954 },
	{ 162, 955 },
	{ 163, 956 },
	{ 164, 957 },
	{ 165, 958 },
	{ 166, 959 },
	{ 167, 960 },
	{ 168, 961 },
	{ 169, 963 },
	{ 170, 962 },
	{ 171, 964 },
	{ 172, 965 },
	{ 173, 966 },
	{ 174, 967 },
	{ 175, 968 },
	{ 176, 9617 },
	{ 177, 9618 },
	{ 178, 9619 },
	{ 179, 9474 },
	{ 180, 9508 },
	{ 181, 9569 },
	{ 182, 9570 },
	{ 183, 9558 },
	{ 184, 9557 },
	{ 185, 9571 },
	{ 186, 9553 },
	{ 187, 9559 },
	{ 188, 9565 },
	{ 189, 9564 },
	{ 190, 9563 },
	{ 191, 9488 },
	{ 192, 9492 },
	{ 193, 9524 },
	{ 194, 9516 },
	{ 195, 9500 },
	{ 196, 9472 },
	{ 197, 9532 },
	{ 198, 9566 },
	{ 199, 9567 },
	{ 200, 9562 },
	{ 201, 9556 },
	{ 202, 9577 },
	{ 203, 9574 },
	{ 204, 9568 },
	{ 205, 9552 },
	{ 206, 9580 },
	{ 207, 9575 },
	{ 208, 9576 },
	{ 209, 9572 },
	{ 210, 9573 },
	{ 211, 9561 },
	{ 212, 9560 },
	{ 213, 9554 },
	{ 214, 9555 },
	{ 215, 9579 },
	{ 216, 9578 },
	{ 217, 9496 },
	{ 218, 9484 },
	{ 219, 9608 },
	{ 220, 9604 },
	{ 221, 9612 },
	{ 222, 9616 },
	{ 223, 9600 },
	{ 224, 969 },
	{ 225, 940 },
	{ 226, 941 },
	{ 227, 942 },
	{ 228, 970 },
	{ 229, 943 },
	{ 230, 972 },
	{ 231, 973 },
	{ 232, 971 },
	{ 233, 974 },
	{ 234, 902 },
	{ 235, 904 },
	{ 236, 905 },
	{ 237, 906 },
	{ 238, 908 },
	{ 239, 910 },
	{ 240, 911 },
	{ 241, 177 },
	{ 242, 8805 },
	{ 243, 8804 },
	{ 244, 938 },
	{ 245, 939 },
	{ 246, 247 },
	{ 247, 8776 },
	{ 248, 176 },
	{ 249, 8729 },
	{ 250, 183 },
	{ 251, 8730 },
	{ 252, 8319 },
	{ 253, 178 },
	{ 254, 9632 },
	{ 255, 160 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 244 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 220 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 252 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp775[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 262 },
	{ 129, 252 },
	{ 130, 233 },
	{ 131, 257 },
	{ 132, 228 },
	{ 133, 291 },
	{ 134, 229 },
	{ 135, 263 },
	{ 136, 322 },
	{ 137, 275 },
	{ 138, 342 },
	{ 139, 343 },
	{ 140, 299 },
	{ 141, 377 },
	{ 142, 196 },
	{ 143, 197 },
	{ 144, 201 },
	{ 145, 230 },
	{ 146, 198 },
	{ 147, 333 },
	{ 148, 246 },
	{ 149, 290 },
	{ 150, 162 },
	{ 151, 346 },
	{ 152, 347 },
	{ 153, 214 },
	{ 154, 220 },
	{ 155, 248 },
	{ 156, 163 },
	{ 157, 216 },
	{ 158, 215 },
	{ 159, 164 },
	{ 160, 256 },
	{ 161, 298 },
	{ 162, 243 },
	{ 163, 379 },
	{ 164, 380 },
	{ 165, 378 },
	{ 166, 8221 },
	{ 167, 166 },
	{ 168, 169 },
	{ 169, 174 },
	{ 170, 172 },
	{ 171, 189 },
	{ 172, 188 },
	{ 173, 321 },
	{ 174, 171 },
	{ 175, 187 },
	{ 176, 9617 },
	{ 177, 9618 },
	{ 178, 9619 },
	{ 179, 9474 },
	{ 180, 9508 },
	{ 181, 260 },
	{ 182, 268 },
	{ 183, 280 },
	{ 184, 278 },
	{ 185, 9571 },
	{ 186, 9553 },
	{ 187, 9559 },
	{ 188, 9565 },
	{ 189, 302 },
	{ 190, 352 },
	{ 191, 9488 },
	{ 192, 9492 },
	{ 193, 9524 },
	{ 194, 9516 },
	{ 195, 9500 },
	{ 196, 9472 },
	{ 197, 9532 },
	{ 198, 370 },
	{ 199, 362 },
	{ 200, 9562 },
	{ 201, 9556 },
	{ 202, 9577 },
	{ 203, 9574 },
	{ 204, 9568 },
	{ 205, 9552 },
	{ 206, 9580 },
	{ 207, 381 },
	{ 208, 261 },
	{ 209, 269 },
	{ 210, 281 },
	{ 211, 279 },
	{ 212, 303 },
	{ 213, 353 },
	{ 214, 371 },
	{ 215, 363 },
	{ 216, 382 },
	{ 217, 9496 },
	{ 218, 9484 },
	{ 219, 9608 },
	{ 220, 9604 },
	{ 221, 9612 },
	{ 222, 9616 },
	{ 223, 9600 },
	{ 224, 211 },
	{ 225, 223 },
	{ 226, 332 },
	{ 227, 323 },
	{ 228, 245 },
	{ 229, 213 },
	{ 230, 181 },
	{ 231, 324 },
	{ 232, 310 },
	{ 233, 311 },
	{ 234, 315 },
	{ 235, 316 },
	{ 236, 326 },
	{ 237, 274 },
	{ 238, 325 },
	{ 239, 8217 },
	{ 240, 173 },
	{ 241, 177 },
	{ 242, 8220 },
	{ 243, 190 },
	{ 244, 182 },
	{ 245, 167 },
	{ 246, 247 },
	{ 247, 8222 },
	{ 248, 176 },
	{ 249, 8729 },
	{ 250, 183 },
	{ 251, 185 },
	{ 252, 179 },
	{ 253, 178 },
	{ 254, 9632 },
	{ 255, 160 },
	{ 39, 8216 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 258 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 259 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 264 },
	{ 67, 266 },
	{ 99, 231 },
	{ 99, 265 },
	{ 99, 267 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 276 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 277 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 300 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 301 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 488 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 317 },
	{ 76, 319 },
	{ 108, 314 },
	{ 108, 318 },
	{ 108, 320 },
	{ 77, 209 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 212 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 244 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 345 },
	{ 83, 348 },
	{ 83, 350 },
	{ 115, 349 },
	{ 115, 351 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 360 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 361 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
};
static convert_t cp850[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 199 },
	{ 129, 252 },
	{ 130, 233 },
	{ 131, 226 },
	{ 132, 228 },
	{ 133, 224 },
	{ 134, 229 },
	{ 135, 231 },
	{ 136, 234 },
	{ 137, 235 },
	{ 138, 232 },
	{ 139, 239 },
	{ 140, 238 },
	{ 141, 236 },
	{ 142, 196 },
	{ 143, 197 },
	{ 144, 201 },
	{ 145, 230 },
	{ 146, 198 },
	{ 147, 244 },
	{ 148, 246 },
	{ 149, 242 },
	{ 150, 251 },
	{ 151, 249 },
	{ 152, 255 },
	{ 153, 214 },
	{ 154, 220 },
	{ 155, 248 },
	{ 156, 163 },
	{ 157, 216 },
	{ 158, 215 },
	{ 159, 402 },
	{ 160, 225 },
	{ 161, 237 },
	{ 162, 243 },
	{ 163, 250 },
	{ 164, 241 },
	{ 165, 209 },
	{ 166, 170 },
	{ 167, 186 },
	{ 168, 191 },
	{ 169, 174 },
	{ 170, 172 },
	{ 171, 189 },
	{ 172, 188 },
	{ 173, 161 },
	{ 174, 171 },
	{ 175, 187 },
	{ 176, 9617 },
	{ 177, 9618 },
	{ 178, 9619 },
	{ 179, 9474 },
	{ 180, 9508 },
	{ 181, 193 },
	{ 182, 194 },
	{ 183, 192 },
	{ 184, 169 },
	{ 185, 9571 },
	{ 186, 9553 },
	{ 187, 9559 },
	{ 188, 9565 },
	{ 189, 162 },
	{ 190, 165 },
	{ 191, 9488 },
	{ 192, 9492 },
	{ 193, 9524 },
	{ 194, 9516 },
	{ 195, 9500 },
	{ 196, 9472 },
	{ 197, 9532 },
	{ 198, 227 },
	{ 199, 195 },
	{ 200, 9562 },
	{ 201, 9556 },
	{ 202, 9577 },
	{ 203, 9574 },
	{ 204, 9568 },
	{ 205, 9552 },
	{ 206, 9580 },
	{ 207, 164 },
	{ 208, 240 },
	{ 209, 208 },
	{ 210, 202 },
	{ 211, 203 },
	{ 212, 200 },
	{ 213, 305 },
	{ 214, 205 },
	{ 215, 206 },
	{ 216, 207 },
	{ 217, 9496 },
	{ 218, 9484 },
	{ 219, 9608 },
	{ 220, 9604 },
	{ 221, 166 },
	{ 222, 204 },
	{ 223, 9600 },
	{ 224, 211 },
	{ 225, 223 },
	{ 226, 212 },
	{ 227, 210 },
	{ 228, 245 },
	{ 229, 213 },
	{ 230, 181 },
	{ 231, 254 },
	{ 232, 222 },
	{ 233, 218 },
	{ 234, 219 },
	{ 235, 217 },
	{ 236, 253 },
	{ 237, 221 },
	{ 238, 175 },
	{ 239, 180 },
	{ 240, 173 },
	{ 241, 177 },
	{ 242, 8215 },
	{ 243, 190 },
	{ 244, 182 },
	{ 245, 167 },
	{ 246, 247 },
	{ 247, 184 },
	{ 248, 176 },
	{ 249, 168 },
	{ 250, 183 },
	{ 251, 185 },
	{ 252, 179 },
	{ 253, 178 },
	{ 254, 9632 },
	{ 255, 160 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp851[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 199 },
	{ 129, 252 },
	{ 130, 233 },
	{ 131, 226 },
	{ 132, 228 },
	{ 133, 224 },
	{ 134, 902 },
	{ 135, 231 },
	{ 136, 234 },
	{ 137, 235 },
	{ 138, 232 },
	{ 139, 239 },
	{ 140, 238 },
	{ 141, 904 },
	{ 142, 196 },
	{ 143, 905 },
	{ 144, 906 },
	{ 145, 145 },
	{ 146, 908 },
	{ 147, 244 },
	{ 148, 246 },
	{ 149, 910 },
	{ 150, 251 },
	{ 151, 249 },
	{ 152, 911 },
	{ 153, 214 },
	{ 154, 220 },
	{ 155, 940 },
	{ 156, 163 },
	{ 157, 941 },
	{ 158, 942 },
	{ 159, 943 },
	{ 160, 970 },
	{ 161, 912 },
	{ 162, 972 },
	{ 163, 973 },
	{ 164, 913 },
	{ 165, 914 },
	{ 166, 915 },
	{ 167, 916 },
	{ 168, 917 },
	{ 169, 918 },
	{ 170, 919 },
	{ 171, 189 },
	{ 172, 920 },
	{ 173, 921 },
	{ 174, 171 },
	{ 175, 187 },
	{ 176, 9617 },
	{ 177, 9618 },
	{ 178, 9619 },
	{ 179, 9474 },
	{ 180, 9508 },
	{ 181, 922 },
	{ 182, 923 },
	{ 183, 924 },
	{ 184, 925 },
	{ 185, 9571 },
	{ 186, 9553 },
	{ 187, 9559 },
	{ 188, 9565 },
	{ 189, 926 },
	{ 190, 927 },
	{ 191, 9488 },
	{ 192, 9492 },
	{ 193, 9524 },
	{ 194, 9516 },
	{ 195, 9500 },
	{ 196, 9472 },
	{ 197, 9532 },
	{ 198, 928 },
	{ 199, 929 },
	{ 200, 9562 },
	{ 201, 9556 },
	{ 202, 9577 },
	{ 203, 9574 },
	{ 204, 9568 },
	{ 205, 9552 },
	{ 206, 9580 },
	{ 207, 931 },
	{ 208, 932 },
	{ 209, 933 },
	{ 210, 934 },
	{ 211, 935 },
	{ 212, 936 },
	{ 213, 937 },
	{ 214, 945 },
	{ 215, 946 },
	{ 216, 947 },
	{ 217, 9496 },
	{ 218, 9484 },
	{ 219, 9608 },
	{ 220, 9604 },
	{ 221, 948 },
	{ 222, 949 },
	{ 223, 9600 },
	{ 224, 950 },
	{ 225, 951 },
	{ 226, 952 },
	{ 227, 953 },
	{ 228, 954 },
	{ 229, 955 },
	{ 230, 956 },
	{ 231, 957 },
	{ 232, 958 },
	{ 233, 959 },
	{ 234, 960 },
	{ 235, 961 },
	{ 236, 963 },
	{ 237, 962 },
	{ 238, 964 },
	{ 239, 900 },
	{ 240, 173 },
	{ 241, 177 },
	{ 242, 965 },
	{ 243, 966 },
	{ 244, 967 },
	{ 245, 167 },
	{ 246, 968 },
	{ 247, 901 },
	{ 248, 176 },
	{ 249, 168 },
	{ 250, 969 },
	{ 251, 971 },
	{ 252, 944 },
	{ 253, 974 },
	{ 254, 9632 },
	{ 255, 160 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 225 },
	{ 97, 227 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 245 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 250 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp852[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 199 },
	{ 129, 252 },
	{ 130, 233 },
	{ 131, 226 },
	{ 132, 228 },
	{ 133, 367 },
	{ 134, 263 },
	{ 135, 231 },
	{ 136, 322 },
	{ 137, 235 },
	{ 138, 336 },
	{ 139, 337 },
	{ 140, 238 },
	{ 141, 377 },
	{ 142, 196 },
	{ 143, 262 },
	{ 144, 201 },
	{ 145, 313 },
	{ 146, 314 },
	{ 147, 244 },
	{ 148, 246 },
	{ 149, 317 },
	{ 150, 318 },
	{ 151, 346 },
	{ 152, 347 },
	{ 153, 214 },
	{ 154, 220 },
	{ 155, 356 },
	{ 156, 357 },
	{ 157, 321 },
	{ 158, 215 },
	{ 159, 269 },
	{ 160, 225 },
	{ 161, 237 },
	{ 162, 243 },
	{ 163, 250 },
	{ 164, 260 },
	{ 165, 261 },
	{ 166, 381 },
	{ 167, 382 },
	{ 168, 280 },
	{ 169, 281 },
	{ 170, 170 },
	{ 171, 378 },
	{ 172, 268 },
	{ 173, 351 },
	{ 174, 171 },
	{ 175, 187 },
	{ 176, 9617 },
	{ 177, 9618 },
	{ 178, 9619 },
	{ 179, 9474 },
	{ 180, 9508 },
	{ 181, 193 },
	{ 182, 194 },
	{ 183, 282 },
	{ 184, 350 },
	{ 185, 9571 },
	{ 186, 9553 },
	{ 187, 9559 },
	{ 188, 9565 },
	{ 189, 379 },
	{ 190, 380 },
	{ 191, 9488 },
	{ 192, 9492 },
	{ 193, 9524 },
	{ 194, 9516 },
	{ 195, 9500 },
	{ 196, 9472 },
	{ 197, 9532 },
	{ 198, 258 },
	{ 199, 259 },
	{ 200, 9562 },
	{ 201, 9556 },
	{ 202, 9577 },
	{ 203, 9574 },
	{ 204, 9568 },
	{ 205, 9552 },
	{ 206, 9580 },
	{ 207, 164 },
	{ 208, 273 },
	{ 209, 272 },
	{ 210, 270 },
	{ 211, 203 },
	{ 212, 271 },
	{ 213, 327 },
	{ 214, 205 },
	{ 215, 206 },
	{ 216, 283 },
	{ 217, 9496 },
	{ 218, 9484 },
	{ 219, 9608 },
	{ 220, 9604 },
	{ 221, 354 },
	{ 222, 366 },
	{ 223, 9600 },
	{ 224, 211 },
	{ 225, 223 },
	{ 226, 212 },
	{ 227, 323 },
	{ 228, 324 },
	{ 229, 328 },
	{ 230, 352 },
	{ 231, 353 },
	{ 232, 340 },
	{ 233, 218 },
	{ 234, 341 },
	{ 235, 368 },
	{ 236, 253 },
	{ 237, 221 },
	{ 238, 355 },
	{ 239, 180 },
	{ 240, 173 },
	{ 241, 733 },
	{ 242, 731 },
	{ 243, 711 },
	{ 244, 728 },
	{ 245, 167 },
	{ 246, 247 },
	{ 247, 184 },
	{ 248, 176 },
	{ 249, 168 },
	{ 250, 729 },
	{ 251, 369 },
	{ 252, 344 },
	{ 253, 345 },
	{ 254, 9632 },
	{ 255, 160 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 195 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 227 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 462 },
	{ 67, 264 },
	{ 67, 266 },
	{ 99, 265 },
	{ 99, 267 },
	{ 69, 200 },
	{ 69, 202 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 101, 232 },
	{ 101, 234 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 315 },
	{ 76, 319 },
	{ 108, 316 },
	{ 108, 320 },
	{ 77, 209 },
	{ 77, 325 },
	{ 109, 241 },
	{ 109, 326 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 213 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 245 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 342 },
	{ 114, 343 },
	{ 83, 348 },
	{ 115, 349 },
	{ 85, 217 },
	{ 85, 219 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 251 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 255 },
	{ 121, 375 },
};
static convert_t cp853[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 199 },
	{ 129, 252 },
	{ 130, 233 },
	{ 131, 226 },
	{ 132, 228 },
	{ 133, 224 },
	{ 134, 265 },
	{ 135, 231 },
	{ 136, 234 },
	{ 137, 235 },
	{ 138, 232 },
	{ 139, 239 },
	{ 140, 238 },
	{ 141, 236 },
	{ 142, 196 },
	{ 143, 264 },
	{ 144, 201 },
	{ 145, 267 },
	{ 146, 266 },
	{ 147, 244 },
	{ 148, 246 },
	{ 149, 242 },
	{ 150, 251 },
	{ 151, 249 },
	{ 152, 304 },
	{ 153, 214 },
	{ 154, 220 },
	{ 155, 285 },
	{ 156, 163 },
	{ 157, 284 },
	{ 158, 215 },
	{ 159, 309 },
	{ 160, 225 },
	{ 161, 237 },
	{ 162, 243 },
	{ 163, 250 },
	{ 164, 241 },
	{ 165, 209 },
	{ 166, 286 },
	{ 167, 287 },
	{ 168, 292 },
	{ 169, 293 },
	{ 170, 170 },
	{ 171, 189 },
	{ 172, 308 },
	{ 173, 351 },
	{ 174, 171 },
	{ 175, 187 },
	{ 176, 9617 },
	{ 177, 9618 },
	{ 178, 9619 },
	{ 179, 9474 },
	{ 180, 9508 },
	{ 181, 193 },
	{ 182, 194 },
	{ 183, 192 },
	{ 184, 350 },
	{ 185, 9571 },
	{ 186, 9553 },
	{ 187, 9559 },
	{ 188, 9565 },
	{ 189, 379 },
	{ 190, 380 },
	{ 191, 9488 },
	{ 192, 9492 },
	{ 193, 9524 },
	{ 194, 9516 },
	{ 195, 9500 },
	{ 196, 9472 },
	{ 197, 9532 },
	{ 198, 348 },
	{ 199, 349 },
	{ 200, 9562 },
	{ 201, 9556 },
	{ 202, 9577 },
	{ 203, 9574 },
	{ 204, 9568 },
	{ 205, 9552 },
	{ 206, 9580 },
	{ 207, 164 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 202 },
	{ 211, 203 },
	{ 212, 200 },
	{ 213, 305 },
	{ 214, 205 },
	{ 215, 206 },
	{ 216, 207 },
	{ 217, 9496 },
	{ 218, 9484 },
	{ 219, 9608 },
	{ 220, 9604 },
	{ 221, 221 },
	{ 222, 204 },
	{ 223, 9600 },
	{ 224, 211 },
	{ 225, 223 },
	{ 226, 212 },
	{ 227, 210 },
	{ 228, 288 },
	{ 229, 289 },
	{ 230, 181 },
	{ 231, 294 },
	{ 232, 295 },
	{ 233, 218 },
	{ 234, 219 },
	{ 235, 217 },
	{ 236, 364 },
	{ 237, 365 },
	{ 238, 238 },
	{ 239, 180 },
	{ 240, 173 },
	{ 241, 241 },
	{ 242, 8467 },
	{ 243, 329 },
	{ 244, 728 },
	{ 245, 167 },
	{ 246, 247 },
	{ 247, 184 },
	{ 248, 176 },
	{ 249, 168 },
	{ 250, 729 },
	{ 251, 251 },
	{ 252, 179 },
	{ 253, 178 },
	{ 254, 9632 },
	{ 255, 160 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 195 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 227 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 464 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 78, 213 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 245 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 382 },
};
static convert_t cp855[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 1106 },
	{ 129, 1026 },
	{ 130, 1107 },
	{ 131, 1027 },
	{ 132, 1105 },
	{ 133, 1025 },
	{ 134, 1108 },
	{ 135, 1028 },
	{ 136, 1109 },
	{ 137, 1029 },
	{ 138, 1110 },
	{ 139, 1030 },
	{ 140, 1111 },
	{ 141, 1031 },
	{ 142, 1112 },
	{ 143, 1032 },
	{ 144, 1113 },
	{ 145, 1033 },
	{ 146, 1114 },
	{ 147, 1034 },
	{ 148, 1115 },
	{ 149, 1035 },
	{ 150, 1116 },
	{ 151, 1036 },
	{ 152, 1118 },
	{ 153, 1038 },
	{ 154, 1119 },
	{ 155, 1039 },
	{ 156, 1102 },
	{ 157, 1070 },
	{ 158, 1098 },
	{ 159, 1066 },
	{ 160, 1072 },
	{ 161, 1040 },
	{ 162, 1073 },
	{ 163, 1041 },
	{ 164, 1094 },
	{ 165, 1062 },
	{ 166, 1076 },
	{ 167, 1044 },
	{ 168, 1077 },
	{ 169, 1045 },
	{ 170, 1092 },
	{ 171, 1060 },
	{ 172, 1075 },
	{ 173, 1043 },
	{ 174, 171 },
	{ 175, 187 },
	{ 176, 9617 },
	{ 177, 9618 },
	{ 178, 9619 },
	{ 179, 9474 },
	{ 180, 9508 },
	{ 181, 1093 },
	{ 182, 1061 },
	{ 183, 1080 },
	{ 184, 1048 },
	{ 185, 9571 },
	{ 186, 9553 },
	{ 187, 9559 },
	{ 188, 9565 },
	{ 189, 1081 },
	{ 190, 1049 },
	{ 191, 9488 },
	{ 192, 9492 },
	{ 193, 9524 },
	{ 194, 9516 },
	{ 195, 9500 },
	{ 196, 9472 },
	{ 197, 9532 },
	{ 198, 1082 },
	{ 199, 1050 },
	{ 200, 9562 },
	{ 201, 9556 },
	{ 202, 9577 },
	{ 203, 9574 },
	{ 204, 9568 },
	{ 205, 9552 },
	{ 206, 9580 },
	{ 207, 164 },
	{ 208, 1083 },
	{ 209, 1051 },
	{ 210, 1084 },
	{ 211, 1052 },
	{ 212, 1085 },
	{ 213, 1053 },
	{ 214, 1086 },
	{ 215, 1054 },
	{ 216, 1087 },
	{ 217, 9496 },
	{ 218, 9484 },
	{ 219, 9608 },
	{ 220, 9604 },
	{ 221, 1055 },
	{ 222, 1103 },
	{ 223, 9600 },
	{ 224, 1071 },
	{ 225, 1088 },
	{ 226, 1056 },
	{ 227, 1089 },
	{ 228, 1057 },
	{ 229, 1090 },
	{ 230, 1058 },
	{ 231, 1091 },
	{ 232, 1059 },
	{ 233, 1078 },
	{ 234, 1046 },
	{ 235, 1074 },
	{ 236, 1042 },
	{ 237, 1100 },
	{ 238, 1068 },
	{ 239, 8470 },
	{ 240, 173 },
	{ 241, 1099 },
	{ 242, 1067 },
	{ 243, 1079 },
	{ 244, 1047 },
	{ 245, 1096 },
	{ 246, 1064 },
	{ 247, 1101 },
	{ 248, 1069 },
	{ 249, 1097 },
	{ 250, 1065 },
	{ 251, 1095 },
	{ 252, 1063 },
	{ 253, 167 },
	{ 254, 9632 },
	{ 255, 160 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 244 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 220 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 252 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp857[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 199 },
	{ 129, 252 },
	{ 130, 233 },
	{ 131, 226 },
	{ 132, 228 },
	{ 133, 224 },
	{ 134, 229 },
	{ 135, 231 },
	{ 136, 234 },
	{ 137, 235 },
	{ 138, 232 },
	{ 139, 239 },
	{ 140, 238 },
	{ 141, 305 },
	{ 142, 196 },
	{ 143, 197 },
	{ 144, 201 },
	{ 145, 230 },
	{ 146, 198 },
	{ 147, 244 },
	{ 148, 246 },
	{ 149, 242 },
	{ 150, 251 },
	{ 151, 249 },
	{ 152, 304 },
	{ 153, 214 },
	{ 154, 220 },
	{ 155, 248 },
	{ 156, 163 },
	{ 157, 216 },
	{ 158, 350 },
	{ 159, 351 },
	{ 160, 225 },
	{ 161, 237 },
	{ 162, 243 },
	{ 163, 250 },
	{ 164, 241 },
	{ 165, 209 },
	{ 166, 286 },
	{ 167, 287 },
	{ 168, 191 },
	{ 169, 174 },
	{ 170, 172 },
	{ 171, 189 },
	{ 172, 188 },
	{ 173, 161 },
	{ 174, 171 },
	{ 175, 187 },
	{ 176, 9617 },
	{ 177, 9618 },
	{ 178, 9619 },
	{ 179, 9474 },
	{ 180, 9508 },
	{ 181, 193 },
	{ 182, 194 },
	{ 183, 192 },
	{ 184, 169 },
	{ 185, 9571 },
	{ 186, 9553 },
	{ 187, 9559 },
	{ 188, 9565 },
	{ 189, 162 },
	{ 190, 165 },
	{ 191, 9488 },
	{ 192, 9492 },
	{ 193, 9524 },
	{ 194, 9516 },
	{ 195, 9500 },
	{ 196, 9472 },
	{ 197, 9532 },
	{ 198, 227 },
	{ 199, 195 },
	{ 200, 9562 },
	{ 201, 9556 },
	{ 202, 9577 },
	{ 203, 9574 },
	{ 204, 9568 },
	{ 205, 9552 },
	{ 206, 9580 },
	{ 207, 164 },
	{ 208, 186 },
	{ 209, 170 },
	{ 210, 202 },
	{ 211, 203 },
	{ 212, 200 },
	{ 213, 213 },
	{ 214, 205 },
	{ 215, 206 },
	{ 216, 207 },
	{ 217, 9496 },
	{ 218, 9484 },
	{ 219, 9608 },
	{ 220, 9604 },
	{ 221, 166 },
	{ 222, 204 },
	{ 223, 9600 },
	{ 224, 211 },
	{ 225, 223 },
	{ 226, 212 },
	{ 227, 210 },
	{ 228, 245 },
	{ 229, 213 },
	{ 230, 181 },
	{ 231, 231 },
	{ 232, 215 },
	{ 233, 218 },
	{ 234, 219 },
	{ 235, 217 },
	{ 236, 236 },
	{ 237, 255 },
	{ 238, 175 },
	{ 239, 180 },
	{ 240, 173 },
	{ 241, 177 },
	{ 242, 242 },
	{ 243, 190 },
	{ 244, 182 },
	{ 245, 167 },
	{ 246, 247 },
	{ 247, 184 },
	{ 248, 176 },
	{ 249, 168 },
	{ 250, 183 },
	{ 251, 185 },
	{ 252, 179 },
	{ 253, 178 },
	{ 254, 9632 },
	{ 255, 160 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp860[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 199 },
	{ 129, 252 },
	{ 130, 233 },
	{ 131, 226 },
	{ 132, 227 },
	{ 133, 224 },
	{ 134, 193 },
	{ 135, 231 },
	{ 136, 234 },
	{ 137, 202 },
	{ 138, 232 },
	{ 139, 205 },
	{ 140, 212 },
	{ 141, 236 },
	{ 142, 195 },
	{ 143, 194 },
	{ 144, 201 },
	{ 145, 192 },
	{ 146, 200 },
	{ 147, 244 },
	{ 148, 245 },
	{ 149, 242 },
	{ 150, 218 },
	{ 151, 249 },
	{ 152, 204 },
	{ 153, 213 },
	{ 154, 220 },
	{ 155, 162 },
	{ 156, 163 },
	{ 157, 217 },
	{ 158, 8359 },
	{ 159, 211 },
	{ 160, 225 },
	{ 161, 237 },
	{ 162, 243 },
	{ 163, 250 },
	{ 164, 241 },
	{ 165, 209 },
	{ 166, 170 },
	{ 167, 186 },
	{ 168, 191 },
	{ 169, 210 },
	{ 170, 172 },
	{ 171, 189 },
	{ 172, 188 },
	{ 173, 161 },
	{ 174, 171 },
	{ 175, 187 },
	{ 176, 9617 },
	{ 177, 9618 },
	{ 178, 9619 },
	{ 179, 9474 },
	{ 180, 9508 },
	{ 181, 9569 },
	{ 182, 9570 },
	{ 183, 9558 },
	{ 184, 9557 },
	{ 185, 9571 },
	{ 186, 9553 },
	{ 187, 9559 },
	{ 188, 9565 },
	{ 189, 9564 },
	{ 190, 9563 },
	{ 191, 9488 },
	{ 192, 9492 },
	{ 193, 9524 },
	{ 194, 9516 },
	{ 195, 9500 },
	{ 196, 9472 },
	{ 197, 9532 },
	{ 198, 9566 },
	{ 199, 9567 },
	{ 200, 9562 },
	{ 201, 9556 },
	{ 202, 9577 },
	{ 203, 9574 },
	{ 204, 9568 },
	{ 205, 9552 },
	{ 206, 9580 },
	{ 207, 9575 },
	{ 208, 9576 },
	{ 209, 9572 },
	{ 210, 9573 },
	{ 211, 9561 },
	{ 212, 9560 },
	{ 213, 9554 },
	{ 214, 9555 },
	{ 215, 9579 },
	{ 216, 9578 },
	{ 217, 9496 },
	{ 218, 9484 },
	{ 219, 9608 },
	{ 220, 9604 },
	{ 221, 9612 },
	{ 222, 9616 },
	{ 223, 9600 },
	{ 224, 945 },
	{ 225, 223 },
	{ 226, 915 },
	{ 227, 960 },
	{ 228, 931 },
	{ 229, 963 },
	{ 230, 181 },
	{ 231, 964 },
	{ 232, 934 },
	{ 233, 920 },
	{ 234, 937 },
	{ 235, 948 },
	{ 236, 8734 },
	{ 237, 966 },
	{ 238, 949 },
	{ 239, 8745 },
	{ 240, 8801 },
	{ 241, 177 },
	{ 242, 8805 },
	{ 243, 8804 },
	{ 244, 8992 },
	{ 245, 8993 },
	{ 246, 247 },
	{ 247, 8776 },
	{ 248, 176 },
	{ 249, 8729 },
	{ 250, 183 },
	{ 251, 8730 },
	{ 252, 8319 },
	{ 253, 178 },
	{ 254, 9632 },
	{ 255, 160 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 219 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 251 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp861[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 199 },
	{ 129, 252 },
	{ 130, 233 },
	{ 131, 226 },
	{ 132, 228 },
	{ 133, 224 },
	{ 134, 229 },
	{ 135, 231 },
	{ 136, 234 },
	{ 137, 235 },
	{ 138, 232 },
	{ 139, 208 },
	{ 140, 240 },
	{ 141, 222 },
	{ 142, 196 },
	{ 143, 197 },
	{ 144, 201 },
	{ 145, 230 },
	{ 146, 198 },
	{ 147, 244 },
	{ 148, 246 },
	{ 149, 254 },
	{ 150, 251 },
	{ 151, 221 },
	{ 152, 253 },
	{ 153, 214 },
	{ 154, 220 },
	{ 155, 248 },
	{ 156, 163 },
	{ 157, 216 },
	{ 158, 8359 },
	{ 159, 402 },
	{ 160, 225 },
	{ 161, 237 },
	{ 162, 243 },
	{ 163, 250 },
	{ 164, 193 },
	{ 165, 205 },
	{ 166, 211 },
	{ 167, 218 },
	{ 168, 191 },
	{ 169, 8976 },
	{ 170, 172 },
	{ 171, 189 },
	{ 172, 188 },
	{ 173, 161 },
	{ 174, 171 },
	{ 175, 187 },
	{ 176, 9617 },
	{ 177, 9618 },
	{ 178, 9619 },
	{ 179, 9474 },
	{ 180, 9508 },
	{ 181, 9569 },
	{ 182, 9570 },
	{ 183, 9558 },
	{ 184, 9557 },
	{ 185, 9571 },
	{ 186, 9553 },
	{ 187, 9559 },
	{ 188, 9565 },
	{ 189, 9564 },
	{ 190, 9563 },
	{ 191, 9488 },
	{ 192, 9492 },
	{ 193, 9524 },
	{ 194, 9516 },
	{ 195, 9500 },
	{ 196, 9472 },
	{ 197, 9532 },
	{ 198, 9566 },
	{ 199, 9567 },
	{ 200, 9562 },
	{ 201, 9556 },
	{ 202, 9577 },
	{ 203, 9574 },
	{ 204, 9568 },
	{ 205, 9552 },
	{ 206, 9580 },
	{ 207, 9575 },
	{ 208, 9576 },
	{ 209, 9572 },
	{ 210, 9573 },
	{ 211, 9561 },
	{ 212, 9560 },
	{ 213, 9554 },
	{ 214, 9555 },
	{ 215, 9579 },
	{ 216, 9578 },
	{ 217, 9496 },
	{ 218, 9484 },
	{ 219, 9608 },
	{ 220, 9604 },
	{ 221, 9612 },
	{ 222, 9616 },
	{ 223, 9600 },
	{ 224, 945 },
	{ 225, 223 },
	{ 226, 915 },
	{ 227, 960 },
	{ 228, 931 },
	{ 229, 963 },
	{ 230, 181 },
	{ 231, 964 },
	{ 232, 934 },
	{ 233, 920 },
	{ 234, 937 },
	{ 235, 948 },
	{ 236, 8734 },
	{ 237, 966 },
	{ 238, 949 },
	{ 239, 8745 },
	{ 240, 8801 },
	{ 241, 177 },
	{ 242, 8805 },
	{ 243, 8804 },
	{ 244, 8992 },
	{ 245, 8993 },
	{ 246, 247 },
	{ 247, 8776 },
	{ 248, 176 },
	{ 249, 8729 },
	{ 250, 183 },
	{ 251, 8730 },
	{ 252, 8319 },
	{ 253, 178 },
	{ 254, 9632 },
	{ 255, 160 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 227 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 245 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 219 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp862[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 1488 },
	{ 129, 1489 },
	{ 130, 1490 },
	{ 131, 1491 },
	{ 132, 1492 },
	{ 133, 1493 },
	{ 134, 1494 },
	{ 135, 1495 },
	{ 136, 1496 },
	{ 137, 1497 },
	{ 138, 1498 },
	{ 139, 1499 },
	{ 140, 1500 },
	{ 141, 1501 },
	{ 142, 1502 },
	{ 143, 1503 },
	{ 144, 1504 },
	{ 145, 1505 },
	{ 146, 1506 },
	{ 147, 1507 },
	{ 148, 1508 },
	{ 149, 1509 },
	{ 150, 1510 },
	{ 151, 1511 },
	{ 152, 1512 },
	{ 153, 1513 },
	{ 154, 1514 },
	{ 155, 162 },
	{ 156, 163 },
	{ 157, 165 },
	{ 158, 8359 },
	{ 159, 402 },
	{ 160, 225 },
	{ 161, 237 },
	{ 162, 243 },
	{ 163, 250 },
	{ 164, 241 },
	{ 165, 209 },
	{ 166, 170 },
	{ 167, 186 },
	{ 168, 191 },
	{ 169, 8976 },
	{ 170, 172 },
	{ 171, 189 },
	{ 172, 188 },
	{ 173, 161 },
	{ 174, 171 },
	{ 175, 187 },
	{ 176, 9617 },
	{ 177, 9618 },
	{ 178, 9619 },
	{ 179, 9474 },
	{ 180, 9508 },
	{ 181, 9569 },
	{ 182, 9570 },
	{ 183, 9558 },
	{ 184, 9557 },
	{ 185, 9571 },
	{ 186, 9553 },
	{ 187, 9559 },
	{ 188, 9565 },
	{ 189, 9564 },
	{ 190, 9563 },
	{ 191, 9488 },
	{ 192, 9492 },
	{ 193, 9524 },
	{ 194, 9516 },
	{ 195, 9500 },
	{ 196, 9472 },
	{ 197, 9532 },
	{ 198, 9566 },
	{ 199, 9567 },
	{ 200, 9562 },
	{ 201, 9556 },
	{ 202, 9577 },
	{ 203, 9574 },
	{ 204, 9568 },
	{ 205, 9552 },
	{ 206, 9580 },
	{ 207, 9575 },
	{ 208, 9576 },
	{ 209, 9572 },
	{ 210, 9573 },
	{ 211, 9561 },
	{ 212, 9560 },
	{ 213, 9554 },
	{ 214, 9555 },
	{ 215, 9579 },
	{ 216, 9578 },
	{ 217, 9496 },
	{ 218, 9484 },
	{ 219, 9608 },
	{ 220, 9604 },
	{ 221, 9612 },
	{ 222, 9616 },
	{ 223, 9600 },
	{ 224, 945 },
	{ 225, 223 },
	{ 226, 915 },
	{ 227, 960 },
	{ 228, 931 },
	{ 229, 963 },
	{ 230, 181 },
	{ 231, 964 },
	{ 232, 934 },
	{ 233, 920 },
	{ 234, 937 },
	{ 235, 948 },
	{ 236, 8734 },
	{ 237, 966 },
	{ 238, 949 },
	{ 239, 8745 },
	{ 240, 8801 },
	{ 241, 177 },
	{ 242, 8805 },
	{ 243, 8804 },
	{ 244, 8992 },
	{ 245, 8993 },
	{ 246, 247 },
	{ 247, 8776 },
	{ 248, 176 },
	{ 249, 8729 },
	{ 250, 183 },
	{ 251, 8730 },
	{ 252, 8319 },
	{ 253, 178 },
	{ 254, 9632 },
	{ 255, 160 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 244 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 220 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 251 },
	{ 117, 252 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp863[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 199 },
	{ 129, 252 },
	{ 130, 233 },
	{ 131, 226 },
	{ 132, 194 },
	{ 133, 224 },
	{ 134, 182 },
	{ 135, 231 },
	{ 136, 234 },
	{ 137, 235 },
	{ 138, 232 },
	{ 139, 239 },
	{ 140, 238 },
	{ 141, 8215 },
	{ 142, 192 },
	{ 143, 167 },
	{ 144, 201 },
	{ 145, 200 },
	{ 146, 202 },
	{ 147, 244 },
	{ 148, 203 },
	{ 149, 207 },
	{ 150, 251 },
	{ 151, 249 },
	{ 152, 164 },
	{ 153, 212 },
	{ 154, 220 },
	{ 155, 162 },
	{ 156, 163 },
	{ 157, 217 },
	{ 158, 219 },
	{ 159, 402 },
	{ 160, 166 },
	{ 161, 180 },
	{ 162, 243 },
	{ 163, 250 },
	{ 164, 168 },
	{ 165, 184 },
	{ 166, 179 },
	{ 167, 175 },
	{ 168, 206 },
	{ 169, 8976 },
	{ 170, 172 },
	{ 171, 189 },
	{ 172, 188 },
	{ 173, 190 },
	{ 174, 171 },
	{ 175, 187 },
	{ 176, 9617 },
	{ 177, 9618 },
	{ 178, 9619 },
	{ 179, 9474 },
	{ 180, 9508 },
	{ 181, 9569 },
	{ 182, 9570 },
	{ 183, 9558 },
	{ 184, 9557 },
	{ 185, 9571 },
	{ 186, 9553 },
	{ 187, 9559 },
	{ 188, 9565 },
	{ 189, 9564 },
	{ 190, 9563 },
	{ 191, 9488 },
	{ 192, 9492 },
	{ 193, 9524 },
	{ 194, 9516 },
	{ 195, 9500 },
	{ 196, 9472 },
	{ 197, 9532 },
	{ 198, 9566 },
	{ 199, 9567 },
	{ 200, 9562 },
	{ 201, 9556 },
	{ 202, 9577 },
	{ 203, 9574 },
	{ 204, 9568 },
	{ 205, 9552 },
	{ 206, 9580 },
	{ 207, 9575 },
	{ 208, 9576 },
	{ 209, 9572 },
	{ 210, 9573 },
	{ 211, 9561 },
	{ 212, 9560 },
	{ 213, 9554 },
	{ 214, 9555 },
	{ 215, 9579 },
	{ 216, 9578 },
	{ 217, 9496 },
	{ 218, 9484 },
	{ 219, 9608 },
	{ 220, 9604 },
	{ 221, 9612 },
	{ 222, 9616 },
	{ 223, 9600 },
	{ 224, 945 },
	{ 225, 223 },
	{ 226, 915 },
	{ 227, 960 },
	{ 228, 931 },
	{ 229, 963 },
	{ 230, 181 },
	{ 231, 964 },
	{ 232, 934 },
	{ 233, 920 },
	{ 234, 937 },
	{ 235, 948 },
	{ 236, 8734 },
	{ 237, 966 },
	{ 238, 949 },
	{ 239, 8745 },
	{ 240, 8801 },
	{ 241, 177 },
	{ 242, 8805 },
	{ 243, 8804 },
	{ 244, 8992 },
	{ 245, 8993 },
	{ 246, 247 },
	{ 247, 8776 },
	{ 248, 176 },
	{ 249, 8729 },
	{ 250, 183 },
	{ 251, 8730 },
	{ 252, 8319 },
	{ 253, 178 },
	{ 254, 9632 },
	{ 255, 160 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 193 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 225 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 218 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp864[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 176 },
	{ 129, 183 },
	{ 130, 8729 },
	{ 131, 8730 },
	{ 132, 9618 },
	{ 133, 9472 },
	{ 134, 9474 },
	{ 135, 9532 },
	{ 136, 9508 },
	{ 137, 9516 },
	{ 138, 9500 },
	{ 139, 9524 },
	{ 140, 9488 },
	{ 141, 9484 },
	{ 142, 9492 },
	{ 143, 9496 },
	{ 144, 946 },
	{ 145, 8734 },
	{ 146, 966 },
	{ 147, 177 },
	{ 148, 189 },
	{ 149, 188 },
	{ 150, 8776 },
	{ 151, 171 },
	{ 152, 187 },
	{ 153, 65271 },
	{ 154, 65272 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 65275 },
	{ 158, 65276 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 173 },
	{ 162, 65154 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 65156 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 65166 },
	{ 169, 1576 },
	{ 170, 1578 },
	{ 171, 1579 },
	{ 172, 1548 },
	{ 173, 1580 },
	{ 174, 1581 },
	{ 175, 1582 },
	{ 176, 1632 },
	{ 177, 1633 },
	{ 178, 1634 },
	{ 179, 1635 },
	{ 180, 1636 },
	{ 181, 1637 },
	{ 182, 1638 },
	{ 183, 1639 },
	{ 184, 1640 },
	{ 185, 1641 },
	{ 186, 1601 },
	{ 187, 1563 },
	{ 188, 1587 },
	{ 189, 1588 },
	{ 190, 1589 },
	{ 191, 1567 },
	{ 192, 162 },
	{ 193, 1569 },
	{ 194, 1570 },
	{ 195, 1571 },
	{ 196, 1572 },
	{ 197, 65226 },
	{ 198, 65163 },
	{ 199, 1575 },
	{ 200, 65169 },
	{ 201, 1577 },
	{ 202, 65175 },
	{ 203, 65179 },
	{ 204, 65183 },
	{ 205, 65187 },
	{ 206, 65191 },
	{ 207, 1583 },
	{ 208, 1584 },
	{ 209, 1585 },
	{ 210, 1586 },
	{ 211, 65203 },
	{ 212, 65207 },
	{ 213, 65211 },
	{ 214, 65215 },
	{ 215, 1591 },
	{ 216, 1592 },
	{ 217, 65227 },
	{ 218, 65231 },
	{ 219, 166 },
	{ 220, 172 },
	{ 221, 247 },
	{ 222, 215 },
	{ 223, 1593 },
	{ 224, 1600 },
	{ 225, 65235 },
	{ 226, 65239 },
	{ 227, 65243 },
	{ 228, 65247 },
	{ 229, 65251 },
	{ 230, 65255 },
	{ 231, 65259 },
	{ 232, 1608 },
	{ 233, 1609 },
	{ 234, 65267 },
	{ 235, 1590 },
	{ 236, 65228 },
	{ 237, 65230 },
	{ 238, 1594 },
	{ 239, 1605 },
	{ 240, 65149 },
	{ 241, 1617 },
	{ 242, 1606 },
	{ 243, 1607 },
	{ 244, 65260 },
	{ 245, 65264 },
	{ 246, 65266 },
	{ 247, 65232 },
	{ 248, 1602 },
	{ 249, 65269 },
	{ 250, 65270 },
	{ 251, 1604 },
	{ 252, 1603 },
	{ 253, 1610 },
	{ 254, 9632 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 244 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 220 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 252 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp865[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 199 },
	{ 129, 252 },
	{ 130, 233 },
	{ 131, 226 },
	{ 132, 228 },
	{ 133, 224 },
	{ 134, 229 },
	{ 135, 231 },
	{ 136, 234 },
	{ 137, 235 },
	{ 138, 232 },
	{ 139, 239 },
	{ 140, 238 },
	{ 141, 236 },
	{ 142, 196 },
	{ 143, 197 },
	{ 144, 201 },
	{ 145, 230 },
	{ 146, 198 },
	{ 147, 244 },
	{ 148, 246 },
	{ 149, 242 },
	{ 150, 251 },
	{ 151, 249 },
	{ 152, 255 },
	{ 153, 214 },
	{ 154, 220 },
	{ 155, 248 },
	{ 156, 163 },
	{ 157, 216 },
	{ 158, 8359 },
	{ 159, 402 },
	{ 160, 225 },
	{ 161, 237 },
	{ 162, 243 },
	{ 163, 250 },
	{ 164, 241 },
	{ 165, 209 },
	{ 166, 170 },
	{ 167, 186 },
	{ 168, 191 },
	{ 169, 8976 },
	{ 170, 172 },
	{ 171, 189 },
	{ 172, 188 },
	{ 173, 161 },
	{ 174, 171 },
	{ 175, 164 },
	{ 176, 9617 },
	{ 177, 9618 },
	{ 178, 9619 },
	{ 179, 9474 },
	{ 180, 9508 },
	{ 181, 9569 },
	{ 182, 9570 },
	{ 183, 9558 },
	{ 184, 9557 },
	{ 185, 9571 },
	{ 186, 9553 },
	{ 187, 9559 },
	{ 188, 9565 },
	{ 189, 9564 },
	{ 190, 9563 },
	{ 191, 9488 },
	{ 192, 9492 },
	{ 193, 9524 },
	{ 194, 9516 },
	{ 195, 9500 },
	{ 196, 9472 },
	{ 197, 9532 },
	{ 198, 9566 },
	{ 199, 9567 },
	{ 200, 9562 },
	{ 201, 9556 },
	{ 202, 9577 },
	{ 203, 9574 },
	{ 204, 9568 },
	{ 205, 9552 },
	{ 206, 9580 },
	{ 207, 9575 },
	{ 208, 9576 },
	{ 209, 9572 },
	{ 210, 9573 },
	{ 211, 9561 },
	{ 212, 9560 },
	{ 213, 9554 },
	{ 214, 9555 },
	{ 215, 9579 },
	{ 216, 9578 },
	{ 217, 9496 },
	{ 218, 9484 },
	{ 219, 9608 },
	{ 220, 9604 },
	{ 221, 9612 },
	{ 222, 9616 },
	{ 223, 9600 },
	{ 224, 945 },
	{ 225, 223 },
	{ 226, 915 },
	{ 227, 960 },
	{ 228, 931 },
	{ 229, 963 },
	{ 230, 181 },
	{ 231, 964 },
	{ 232, 934 },
	{ 233, 920 },
	{ 234, 937 },
	{ 235, 948 },
	{ 236, 8734 },
	{ 237, 966 },
	{ 238, 949 },
	{ 239, 8745 },
	{ 240, 8801 },
	{ 241, 177 },
	{ 242, 8805 },
	{ 243, 8804 },
	{ 244, 8992 },
	{ 245, 8993 },
	{ 246, 247 },
	{ 247, 8776 },
	{ 248, 176 },
	{ 249, 8729 },
	{ 250, 183 },
	{ 251, 8730 },
	{ 252, 8319 },
	{ 253, 178 },
	{ 254, 9632 },
	{ 255, 160 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 227 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 245 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp866[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 1040 },
	{ 129, 1041 },
	{ 130, 1042 },
	{ 131, 1043 },
	{ 132, 1044 },
	{ 133, 1045 },
	{ 134, 1046 },
	{ 135, 1047 },
	{ 136, 1048 },
	{ 137, 1049 },
	{ 138, 1050 },
	{ 139, 1051 },
	{ 140, 1052 },
	{ 141, 1053 },
	{ 142, 1054 },
	{ 143, 1055 },
	{ 144, 1056 },
	{ 145, 1057 },
	{ 146, 1058 },
	{ 147, 1059 },
	{ 148, 1060 },
	{ 149, 1061 },
	{ 150, 1062 },
	{ 151, 1063 },
	{ 152, 1064 },
	{ 153, 1065 },
	{ 154, 1066 },
	{ 155, 1067 },
	{ 156, 1068 },
	{ 157, 1069 },
	{ 158, 1070 },
	{ 159, 1071 },
	{ 160, 1072 },
	{ 161, 1073 },
	{ 162, 1074 },
	{ 163, 1075 },
	{ 164, 1076 },
	{ 165, 1077 },
	{ 166, 1078 },
	{ 167, 1079 },
	{ 168, 1080 },
	{ 169, 1081 },
	{ 170, 1082 },
	{ 171, 1083 },
	{ 172, 1084 },
	{ 173, 1085 },
	{ 174, 1086 },
	{ 175, 1087 },
	{ 176, 9617 },
	{ 177, 9618 },
	{ 178, 9619 },
	{ 179, 9474 },
	{ 180, 9508 },
	{ 181, 9569 },
	{ 182, 9570 },
	{ 183, 9558 },
	{ 184, 9557 },
	{ 185, 9571 },
	{ 186, 9553 },
	{ 187, 9559 },
	{ 188, 9565 },
	{ 189, 9564 },
	{ 190, 9563 },
	{ 191, 9488 },
	{ 192, 9492 },
	{ 193, 9524 },
	{ 194, 9516 },
	{ 195, 9500 },
	{ 196, 9472 },
	{ 197, 9532 },
	{ 198, 9566 },
	{ 199, 9567 },
	{ 200, 9562 },
	{ 201, 9556 },
	{ 202, 9577 },
	{ 203, 9574 },
	{ 204, 9568 },
	{ 205, 9552 },
	{ 206, 9580 },
	{ 207, 9575 },
	{ 208, 9576 },
	{ 209, 9572 },
	{ 210, 9573 },
	{ 211, 9561 },
	{ 212, 9560 },
	{ 213, 9554 },
	{ 214, 9555 },
	{ 215, 9579 },
	{ 216, 9578 },
	{ 217, 9496 },
	{ 218, 9484 },
	{ 219, 9608 },
	{ 220, 9604 },
	{ 221, 9612 },
	{ 222, 9616 },
	{ 223, 9600 },
	{ 224, 1088 },
	{ 225, 1089 },
	{ 226, 1090 },
	{ 227, 1091 },
	{ 228, 1092 },
	{ 229, 1093 },
	{ 230, 1094 },
	{ 231, 1095 },
	{ 232, 1096 },
	{ 233, 1097 },
	{ 234, 1098 },
	{ 235, 1099 },
	{ 236, 1100 },
	{ 237, 1101 },
	{ 238, 1102 },
	{ 239, 1103 },
	{ 240, 1025 },
	{ 241, 1105 },
	{ 242, 1028 },
	{ 243, 1108 },
	{ 244, 1031 },
	{ 245, 1111 },
	{ 246, 1038 },
	{ 247, 1118 },
	{ 248, 176 },
	{ 249, 8729 },
	{ 250, 183 },
	{ 251, 8730 },
	{ 252, 8470 },
	{ 253, 164 },
	{ 254, 9632 },
	{ 255, 160 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 244 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 220 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 252 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp869[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 902 },
	{ 135, 135 },
	{ 136, 183 },
	{ 137, 172 },
	{ 138, 166 },
	{ 139, 8216 },
	{ 140, 8217 },
	{ 141, 904 },
	{ 142, 8213 },
	{ 143, 905 },
	{ 144, 906 },
	{ 145, 938 },
	{ 146, 908 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 910 },
	{ 150, 939 },
	{ 151, 169 },
	{ 152, 911 },
	{ 153, 178 },
	{ 154, 179 },
	{ 155, 940 },
	{ 156, 163 },
	{ 157, 941 },
	{ 158, 942 },
	{ 159, 943 },
	{ 160, 970 },
	{ 161, 912 },
	{ 162, 972 },
	{ 163, 973 },
	{ 164, 913 },
	{ 165, 914 },
	{ 166, 915 },
	{ 167, 916 },
	{ 168, 917 },
	{ 169, 918 },
	{ 170, 919 },
	{ 171, 189 },
	{ 172, 920 },
	{ 173, 921 },
	{ 174, 171 },
	{ 175, 187 },
	{ 176, 9617 },
	{ 177, 9618 },
	{ 178, 9619 },
	{ 179, 9474 },
	{ 180, 9508 },
	{ 181, 922 },
	{ 182, 923 },
	{ 183, 924 },
	{ 184, 925 },
	{ 185, 9571 },
	{ 186, 9553 },
	{ 187, 9559 },
	{ 188, 9565 },
	{ 189, 926 },
	{ 190, 927 },
	{ 191, 9488 },
	{ 192, 9492 },
	{ 193, 9524 },
	{ 194, 9516 },
	{ 195, 9500 },
	{ 196, 9472 },
	{ 197, 9532 },
	{ 198, 928 },
	{ 199, 929 },
	{ 200, 9562 },
	{ 201, 9556 },
	{ 202, 9577 },
	{ 203, 9574 },
	{ 204, 9568 },
	{ 205, 9552 },
	{ 206, 9580 },
	{ 207, 931 },
	{ 208, 932 },
	{ 209, 933 },
	{ 210, 934 },
	{ 211, 935 },
	{ 212, 936 },
	{ 213, 937 },
	{ 214, 945 },
	{ 215, 946 },
	{ 216, 947 },
	{ 217, 9496 },
	{ 218, 9484 },
	{ 219, 9608 },
	{ 220, 9604 },
	{ 221, 948 },
	{ 222, 949 },
	{ 223, 9600 },
	{ 224, 950 },
	{ 225, 951 },
	{ 226, 952 },
	{ 227, 953 },
	{ 228, 954 },
	{ 229, 955 },
	{ 230, 956 },
	{ 231, 957 },
	{ 232, 958 },
	{ 233, 959 },
	{ 234, 960 },
	{ 235, 961 },
	{ 236, 963 },
	{ 237, 962 },
	{ 238, 964 },
	{ 239, 900 },
	{ 240, 173 },
	{ 241, 177 },
	{ 242, 965 },
	{ 243, 966 },
	{ 244, 967 },
	{ 245, 167 },
	{ 246, 968 },
	{ 247, 901 },
	{ 248, 176 },
	{ 249, 168 },
	{ 250, 969 },
	{ 251, 971 },
	{ 252, 944 },
	{ 253, 974 },
	{ 254, 9632 },
	{ 255, 160 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 244 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 220 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 252 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp874[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 8364 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 8230 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 8216 },
	{ 146, 8217 },
	{ 147, 8220 },
	{ 148, 8221 },
	{ 149, 8226 },
	{ 150, 8211 },
	{ 151, 8212 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 3585 },
	{ 162, 3586 },
	{ 163, 3587 },
	{ 164, 3588 },
	{ 165, 3589 },
	{ 166, 3590 },
	{ 167, 3591 },
	{ 168, 3592 },
	{ 169, 3593 },
	{ 170, 3594 },
	{ 171, 3595 },
	{ 172, 3596 },
	{ 173, 3597 },
	{ 174, 3598 },
	{ 175, 3599 },
	{ 176, 3600 },
	{ 177, 3601 },
	{ 178, 3602 },
	{ 179, 3603 },
	{ 180, 3604 },
	{ 181, 3605 },
	{ 182, 3606 },
	{ 183, 3607 },
	{ 184, 3608 },
	{ 185, 3609 },
	{ 186, 3610 },
	{ 187, 3611 },
	{ 188, 3612 },
	{ 189, 3613 },
	{ 190, 3614 },
	{ 191, 3615 },
	{ 192, 3616 },
	{ 193, 3617 },
	{ 194, 3618 },
	{ 195, 3619 },
	{ 196, 3620 },
	{ 197, 3621 },
	{ 198, 3622 },
	{ 199, 3623 },
	{ 200, 3624 },
	{ 201, 3625 },
	{ 202, 3626 },
	{ 203, 3627 },
	{ 204, 3628 },
	{ 205, 3629 },
	{ 206, 3630 },
	{ 207, 3631 },
	{ 208, 3632 },
	{ 209, 3633 },
	{ 210, 3634 },
	{ 211, 3635 },
	{ 212, 3636 },
	{ 213, 3637 },
	{ 214, 3638 },
	{ 215, 3639 },
	{ 216, 3640 },
	{ 217, 3641 },
	{ 218, 3642 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 3647 },
	{ 224, 3648 },
	{ 225, 3649 },
	{ 226, 3650 },
	{ 227, 3651 },
	{ 228, 3652 },
	{ 229, 3653 },
	{ 230, 3654 },
	{ 231, 3655 },
	{ 232, 3656 },
	{ 233, 3657 },
	{ 234, 3658 },
	{ 235, 3659 },
	{ 236, 3660 },
	{ 237, 3661 },
	{ 238, 3662 },
	{ 239, 3663 },
	{ 240, 3664 },
	{ 241, 3665 },
	{ 242, 3666 },
	{ 243, 3667 },
	{ 244, 3668 },
	{ 245, 3669 },
	{ 246, 3670 },
	{ 247, 3671 },
	{ 248, 3672 },
	{ 249, 3673 },
	{ 250, 3674 },
	{ 251, 3675 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 244 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp895[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 268 },
	{ 129, 252 },
	{ 130, 233 },
	{ 131, 271 },
	{ 132, 228 },
	{ 133, 270 },
	{ 134, 356 },
	{ 135, 269 },
	{ 136, 283 },
	{ 137, 282 },
	{ 138, 313 },
	{ 139, 205 },
	{ 140, 318 },
	{ 141, 314 },
	{ 142, 196 },
	{ 143, 193 },
	{ 144, 201 },
	{ 145, 382 },
	{ 146, 381 },
	{ 147, 244 },
	{ 148, 246 },
	{ 149, 211 },
	{ 150, 367 },
	{ 151, 218 },
	{ 152, 253 },
	{ 153, 214 },
	{ 154, 220 },
	{ 155, 352 },
	{ 156, 317 },
	{ 157, 221 },
	{ 158, 344 },
	{ 159, 357 },
	{ 160, 225 },
	{ 161, 237 },
	{ 162, 243 },
	{ 163, 250 },
	{ 164, 328 },
	{ 165, 327 },
	{ 166, 366 },
	{ 167, 212 },
	{ 168, 353 },
	{ 169, 345 },
	{ 170, 341 },
	{ 171, 340 },
	{ 172, 188 },
	{ 173, 161 },
	{ 174, 171 },
	{ 175, 187 },
	{ 176, 9617 },
	{ 177, 9618 },
	{ 178, 9619 },
	{ 179, 9474 },
	{ 180, 9508 },
	{ 181, 9569 },
	{ 182, 9570 },
	{ 183, 9558 },
	{ 184, 9557 },
	{ 185, 9571 },
	{ 186, 9553 },
	{ 187, 9559 },
	{ 188, 9565 },
	{ 189, 9564 },
	{ 190, 9563 },
	{ 191, 9488 },
	{ 192, 9492 },
	{ 193, 9524 },
	{ 194, 9516 },
	{ 195, 9500 },
	{ 196, 9472 },
	{ 197, 9532 },
	{ 198, 9566 },
	{ 199, 9567 },
	{ 200, 9562 },
	{ 201, 9556 },
	{ 202, 9577 },
	{ 203, 9574 },
	{ 204, 9568 },
	{ 205, 9552 },
	{ 206, 9580 },
	{ 207, 9575 },
	{ 208, 9576 },
	{ 209, 9572 },
	{ 210, 9573 },
	{ 211, 9561 },
	{ 212, 9560 },
	{ 213, 9554 },
	{ 214, 9555 },
	{ 215, 9579 },
	{ 216, 9578 },
	{ 217, 9496 },
	{ 218, 9484 },
	{ 219, 9608 },
	{ 220, 9604 },
	{ 221, 9612 },
	{ 222, 9616 },
	{ 223, 9600 },
	{ 224, 945 },
	{ 225, 223 },
	{ 226, 915 },
	{ 227, 960 },
	{ 228, 931 },
	{ 229, 963 },
	{ 230, 181 },
	{ 231, 964 },
	{ 232, 934 },
	{ 233, 920 },
	{ 234, 937 },
	{ 235, 948 },
	{ 236, 8734 },
	{ 237, 966 },
	{ 238, 949 },
	{ 239, 8745 },
	{ 240, 8801 },
	{ 241, 177 },
	{ 242, 8805 },
	{ 243, 8804 },
	{ 244, 8992 },
	{ 245, 8993 },
	{ 246, 247 },
	{ 247, 8776 },
	{ 248, 176 },
	{ 249, 8729 },
	{ 250, 183 },
	{ 251, 8730 },
	{ 252, 8319 },
	{ 253, 178 },
	{ 254, 9632 },
	{ 255, 160 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 69, 200 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 101, 232 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 315 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 316 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 213 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 245 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 342 },
	{ 114, 343 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 84, 354 },
	{ 116, 355 },
	{ 85, 217 },
	{ 85, 219 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 251 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 122, 378 },
	{ 122, 380 },
};
static convert_t cp1250[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 8364 },
	{ 129, 129 },
	{ 130, 8218 },
	{ 131, 131 },
	{ 132, 8222 },
	{ 133, 8230 },
	{ 134, 8224 },
	{ 135, 8225 },
	{ 136, 136 },
	{ 137, 8240 },
	{ 138, 352 },
	{ 139, 8249 },
	{ 140, 346 },
	{ 141, 356 },
	{ 142, 381 },
	{ 143, 377 },
	{ 144, 144 },
	{ 145, 8216 },
	{ 146, 8217 },
	{ 147, 8220 },
	{ 148, 8221 },
	{ 149, 8226 },
	{ 150, 8211 },
	{ 151, 8212 },
	{ 152, 152 },
	{ 153, 8482 },
	{ 154, 353 },
	{ 155, 8250 },
	{ 156, 347 },
	{ 157, 357 },
	{ 158, 382 },
	{ 159, 378 },
	{ 160, 160 },
	{ 161, 711 },
	{ 162, 728 },
	{ 163, 321 },
	{ 164, 164 },
	{ 165, 260 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 350 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 379 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 731 },
	{ 179, 322 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 261 },
	{ 186, 351 },
	{ 187, 187 },
	{ 188, 376 },
	{ 189, 733 },
	{ 190, 317 },
	{ 191, 380 },
	{ 192, 340 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 258 },
	{ 196, 196 },
	{ 197, 313 },
	{ 198, 262 },
	{ 199, 199 },
	{ 200, 268 },
	{ 201, 201 },
	{ 202, 280 },
	{ 203, 203 },
	{ 204, 282 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 270 },
	{ 208, 272 },
	{ 209, 323 },
	{ 210, 327 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 336 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 344 },
	{ 217, 366 },
	{ 218, 218 },
	{ 219, 368 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 354 },
	{ 223, 223 },
	{ 224, 341 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 259 },
	{ 228, 228 },
	{ 229, 314 },
	{ 230, 263 },
	{ 231, 231 },
	{ 232, 269 },
	{ 233, 233 },
	{ 234, 281 },
	{ 235, 235 },
	{ 236, 283 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 271 },
	{ 240, 273 },
	{ 241, 324 },
	{ 242, 328 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 337 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 345 },
	{ 249, 367 },
	{ 250, 250 },
	{ 251, 369 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 355 },
	{ 255, 729 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 195 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 227 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 462 },
	{ 67, 264 },
	{ 67, 266 },
	{ 99, 265 },
	{ 99, 267 },
	{ 69, 200 },
	{ 69, 202 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 101, 232 },
	{ 101, 234 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 315 },
	{ 76, 319 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 77, 209 },
	{ 77, 325 },
	{ 109, 241 },
	{ 109, 326 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 213 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 245 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 342 },
	{ 114, 343 },
	{ 83, 348 },
	{ 115, 349 },
	{ 85, 217 },
	{ 85, 219 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 251 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 121, 255 },
	{ 121, 375 },
};
static convert_t cp1251[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 1026 },
	{ 129, 1027 },
	{ 130, 8218 },
	{ 131, 1107 },
	{ 132, 8222 },
	{ 133, 8230 },
	{ 134, 8224 },
	{ 135, 8225 },
	{ 136, 8364 },
	{ 137, 8240 },
	{ 138, 1033 },
	{ 139, 8249 },
	{ 140, 1034 },
	{ 141, 1036 },
	{ 142, 1035 },
	{ 143, 1039 },
	{ 144, 1106 },
	{ 145, 8216 },
	{ 146, 8217 },
	{ 147, 8220 },
	{ 148, 8221 },
	{ 149, 8226 },
	{ 150, 8211 },
	{ 151, 8212 },
	{ 152, 152 },
	{ 153, 8482 },
	{ 154, 1113 },
	{ 155, 8250 },
	{ 156, 1114 },
	{ 157, 1116 },
	{ 158, 1115 },
	{ 159, 1119 },
	{ 160, 160 },
	{ 161, 1038 },
	{ 162, 1118 },
	{ 163, 1032 },
	{ 164, 164 },
	{ 165, 1168 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 1025 },
	{ 169, 169 },
	{ 170, 1028 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 1031 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 1030 },
	{ 179, 1110 },
	{ 180, 1169 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 1105 },
	{ 185, 8470 },
	{ 186, 1108 },
	{ 187, 187 },
	{ 188, 1112 },
	{ 189, 1029 },
	{ 190, 1109 },
	{ 191, 1111 },
	{ 192, 1040 },
	{ 193, 1041 },
	{ 194, 1042 },
	{ 195, 1043 },
	{ 196, 1044 },
	{ 197, 1045 },
	{ 198, 1046 },
	{ 199, 1047 },
	{ 200, 1048 },
	{ 201, 1049 },
	{ 202, 1050 },
	{ 203, 1051 },
	{ 204, 1052 },
	{ 205, 1053 },
	{ 206, 1054 },
	{ 207, 1055 },
	{ 208, 1056 },
	{ 209, 1057 },
	{ 210, 1058 },
	{ 211, 1059 },
	{ 212, 1060 },
	{ 213, 1061 },
	{ 214, 1062 },
	{ 215, 1063 },
	{ 216, 1064 },
	{ 217, 1065 },
	{ 218, 1066 },
	{ 219, 1067 },
	{ 220, 1068 },
	{ 221, 1069 },
	{ 222, 1070 },
	{ 223, 1071 },
	{ 224, 1072 },
	{ 225, 1073 },
	{ 226, 1074 },
	{ 227, 1075 },
	{ 228, 1076 },
	{ 229, 1077 },
	{ 230, 1078 },
	{ 231, 1079 },
	{ 232, 1080 },
	{ 233, 1081 },
	{ 234, 1082 },
	{ 235, 1083 },
	{ 236, 1084 },
	{ 237, 1085 },
	{ 238, 1086 },
	{ 239, 1087 },
	{ 240, 1088 },
	{ 241, 1089 },
	{ 242, 1090 },
	{ 243, 1091 },
	{ 244, 1092 },
	{ 245, 1093 },
	{ 246, 1094 },
	{ 247, 1095 },
	{ 248, 1096 },
	{ 249, 1097 },
	{ 250, 1098 },
	{ 251, 1099 },
	{ 252, 1100 },
	{ 253, 1101 },
	{ 254, 1102 },
	{ 255, 1103 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 244 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 220 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 252 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp1252[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 8364 },
	{ 129, 129 },
	{ 130, 8218 },
	{ 131, 402 },
	{ 132, 8222 },
	{ 133, 8230 },
	{ 134, 8224 },
	{ 135, 8225 },
	{ 136, 710 },
	{ 137, 8240 },
	{ 138, 352 },
	{ 139, 8249 },
	{ 140, 338 },
	{ 141, 141 },
	{ 142, 381 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 8216 },
	{ 146, 8217 },
	{ 147, 8220 },
	{ 148, 8221 },
	{ 149, 8226 },
	{ 150, 8211 },
	{ 151, 8212 },
	{ 152, 732 },
	{ 153, 8482 },
	{ 154, 353 },
	{ 155, 8250 },
	{ 156, 339 },
	{ 157, 157 },
	{ 158, 382 },
	{ 159, 376 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 122, 378 },
	{ 122, 380 },
};
static convert_t cp1253[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 8364 },
	{ 129, 129 },
	{ 130, 8218 },
	{ 131, 402 },
	{ 132, 8222 },
	{ 133, 8230 },
	{ 134, 8224 },
	{ 135, 8225 },
	{ 136, 136 },
	{ 137, 8240 },
	{ 138, 138 },
	{ 139, 8249 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 8216 },
	{ 146, 8217 },
	{ 147, 8220 },
	{ 148, 8221 },
	{ 149, 8226 },
	{ 150, 8211 },
	{ 151, 8212 },
	{ 152, 152 },
	{ 153, 8482 },
	{ 154, 154 },
	{ 155, 8250 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 901 },
	{ 162, 902 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 8213 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 900 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 904 },
	{ 185, 905 },
	{ 186, 906 },
	{ 187, 187 },
	{ 188, 908 },
	{ 189, 189 },
	{ 190, 910 },
	{ 191, 911 },
	{ 192, 912 },
	{ 193, 913 },
	{ 194, 914 },
	{ 195, 915 },
	{ 196, 916 },
	{ 197, 917 },
	{ 198, 918 },
	{ 199, 919 },
	{ 200, 920 },
	{ 201, 921 },
	{ 202, 922 },
	{ 203, 923 },
	{ 204, 924 },
	{ 205, 925 },
	{ 206, 926 },
	{ 207, 927 },
	{ 208, 928 },
	{ 209, 929 },
	{ 210, 210 },
	{ 211, 931 },
	{ 212, 932 },
	{ 213, 933 },
	{ 214, 934 },
	{ 215, 935 },
	{ 216, 936 },
	{ 217, 937 },
	{ 218, 938 },
	{ 219, 939 },
	{ 220, 940 },
	{ 221, 941 },
	{ 222, 942 },
	{ 223, 943 },
	{ 224, 944 },
	{ 225, 945 },
	{ 226, 946 },
	{ 227, 947 },
	{ 228, 948 },
	{ 229, 949 },
	{ 230, 950 },
	{ 231, 951 },
	{ 232, 952 },
	{ 233, 953 },
	{ 234, 954 },
	{ 235, 955 },
	{ 236, 956 },
	{ 237, 957 },
	{ 238, 958 },
	{ 239, 959 },
	{ 240, 960 },
	{ 241, 961 },
	{ 242, 962 },
	{ 243, 963 },
	{ 244, 964 },
	{ 245, 965 },
	{ 246, 966 },
	{ 247, 967 },
	{ 248, 968 },
	{ 249, 969 },
	{ 250, 970 },
	{ 251, 971 },
	{ 252, 972 },
	{ 253, 973 },
	{ 254, 974 },
	{ 255, 255 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 244 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 220 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 252 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp1254[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 8364 },
	{ 129, 129 },
	{ 130, 8218 },
	{ 131, 402 },
	{ 132, 8222 },
	{ 133, 8230 },
	{ 134, 8224 },
	{ 135, 8225 },
	{ 136, 710 },
	{ 137, 8240 },
	{ 138, 352 },
	{ 139, 8249 },
	{ 140, 338 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 8216 },
	{ 146, 8217 },
	{ 147, 8220 },
	{ 148, 8221 },
	{ 149, 8226 },
	{ 150, 8211 },
	{ 151, 8212 },
	{ 152, 732 },
	{ 153, 8482 },
	{ 154, 353 },
	{ 155, 8250 },
	{ 156, 339 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 376 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 286 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 304 },
	{ 222, 350 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 287 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 305 },
	{ 254, 351 },
	{ 255, 255 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 115, 347 },
	{ 115, 349 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 121, 253 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp1255[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 8364 },
	{ 129, 129 },
	{ 130, 8218 },
	{ 131, 402 },
	{ 132, 8222 },
	{ 133, 8230 },
	{ 134, 8224 },
	{ 135, 8225 },
	{ 136, 136 },
	{ 137, 8240 },
	{ 138, 138 },
	{ 139, 8249 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 8216 },
	{ 146, 8217 },
	{ 147, 8220 },
	{ 148, 8221 },
	{ 149, 8226 },
	{ 150, 8211 },
	{ 151, 8212 },
	{ 152, 152 },
	{ 153, 8482 },
	{ 154, 154 },
	{ 155, 8250 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 215 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 781 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 247 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 8215 },
	{ 224, 1488 },
	{ 225, 1489 },
	{ 226, 1490 },
	{ 227, 1491 },
	{ 228, 1492 },
	{ 229, 1493 },
	{ 230, 1494 },
	{ 231, 1495 },
	{ 232, 1496 },
	{ 233, 1497 },
	{ 234, 1498 },
	{ 235, 1499 },
	{ 236, 1500 },
	{ 237, 1501 },
	{ 238, 1502 },
	{ 239, 1503 },
	{ 240, 1504 },
	{ 241, 1505 },
	{ 242, 1506 },
	{ 243, 1507 },
	{ 244, 1508 },
	{ 245, 1509 },
	{ 246, 1510 },
	{ 247, 1511 },
	{ 248, 1512 },
	{ 249, 1513 },
	{ 250, 1514 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 244 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp1256[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 1548 },
	{ 129, 129 },
	{ 130, 8218 },
	{ 131, 131 },
	{ 132, 8222 },
	{ 133, 8230 },
	{ 134, 8224 },
	{ 135, 8225 },
	{ 136, 136 },
	{ 137, 8240 },
	{ 138, 138 },
	{ 139, 8249 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 8216 },
	{ 146, 8217 },
	{ 147, 8220 },
	{ 148, 8221 },
	{ 149, 8226 },
	{ 150, 8211 },
	{ 151, 8212 },
	{ 152, 1563 },
	{ 153, 8482 },
	{ 154, 1567 },
	{ 155, 8250 },
	{ 156, 1569 },
	{ 157, 1570 },
	{ 158, 1571 },
	{ 159, 376 },
	{ 160, 160 },
	{ 161, 1572 },
	{ 162, 1573 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 1574 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 1575 },
	{ 169, 169 },
	{ 170, 1576 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 1577 },
	{ 179, 1578 },
	{ 180, 1579 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 1580 },
	{ 185, 185 },
	{ 186, 1581 },
	{ 187, 187 },
	{ 188, 1582 },
	{ 189, 1583 },
	{ 190, 1584 },
	{ 191, 1585 },
	{ 192, 192 },
	{ 193, 1586 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 1587 },
	{ 197, 1588 },
	{ 198, 1589 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 1590 },
	{ 205, 1591 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 1592 },
	{ 209, 1593 },
	{ 210, 1594 },
	{ 211, 1600 },
	{ 212, 212 },
	{ 213, 1601 },
	{ 214, 1602 },
	{ 215, 215 },
	{ 216, 1603 },
	{ 217, 217 },
	{ 218, 1711 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 1604 },
	{ 222, 1605 },
	{ 223, 1606 },
	{ 224, 224 },
	{ 225, 1607 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 1608 },
	{ 229, 1609 },
	{ 230, 1610 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 1611 },
	{ 237, 1612 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 1613 },
	{ 241, 1614 },
	{ 242, 1615 },
	{ 243, 1616 },
	{ 244, 244 },
	{ 245, 1617 },
	{ 246, 1618 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 193 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 225 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 218 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t cp1257[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 8364 },
	{ 129, 129 },
	{ 130, 8218 },
	{ 131, 131 },
	{ 132, 8222 },
	{ 133, 8230 },
	{ 134, 8224 },
	{ 135, 8225 },
	{ 136, 136 },
	{ 137, 8240 },
	{ 138, 138 },
	{ 139, 8249 },
	{ 140, 140 },
	{ 141, 168 },
	{ 142, 711 },
	{ 143, 184 },
	{ 144, 144 },
	{ 145, 8216 },
	{ 146, 8217 },
	{ 147, 8220 },
	{ 148, 8221 },
	{ 149, 8226 },
	{ 150, 8211 },
	{ 151, 8212 },
	{ 152, 152 },
	{ 153, 8482 },
	{ 154, 154 },
	{ 155, 8250 },
	{ 156, 156 },
	{ 157, 175 },
	{ 158, 731 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 216 },
	{ 169, 169 },
	{ 170, 342 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 198 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 248 },
	{ 185, 185 },
	{ 186, 343 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 230 },
	{ 192, 260 },
	{ 193, 302 },
	{ 194, 256 },
	{ 195, 262 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 280 },
	{ 199, 274 },
	{ 200, 268 },
	{ 201, 201 },
	{ 202, 377 },
	{ 203, 278 },
	{ 204, 290 },
	{ 205, 310 },
	{ 206, 298 },
	{ 207, 315 },
	{ 208, 352 },
	{ 209, 323 },
	{ 210, 325 },
	{ 211, 211 },
	{ 212, 332 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 370 },
	{ 217, 321 },
	{ 218, 340 },
	{ 219, 362 },
	{ 220, 220 },
	{ 221, 379 },
	{ 222, 381 },
	{ 223, 223 },
	{ 224, 261 },
	{ 225, 303 },
	{ 226, 257 },
	{ 227, 263 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 281 },
	{ 231, 275 },
	{ 232, 269 },
	{ 233, 233 },
	{ 234, 378 },
	{ 235, 279 },
	{ 236, 291 },
	{ 237, 311 },
	{ 238, 299 },
	{ 239, 316 },
	{ 240, 353 },
	{ 241, 324 },
	{ 242, 326 },
	{ 243, 243 },
	{ 244, 333 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 371 },
	{ 249, 322 },
	{ 250, 347 },
	{ 251, 363 },
	{ 252, 252 },
	{ 253, 380 },
	{ 254, 382 },
	{ 255, 729 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 258 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 259 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 264 },
	{ 67, 266 },
	{ 99, 231 },
	{ 99, 265 },
	{ 99, 267 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 276 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 277 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 300 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 301 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 488 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 317 },
	{ 76, 319 },
	{ 108, 314 },
	{ 108, 318 },
	{ 108, 320 },
	{ 77, 209 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 212 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 244 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 115, 349 },
	{ 115, 351 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 360 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 361 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
};
static convert_t cp1258[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 8364 },
	{ 129, 129 },
	{ 130, 8218 },
	{ 131, 402 },
	{ 132, 8222 },
	{ 133, 8230 },
	{ 134, 8224 },
	{ 135, 8225 },
	{ 136, 710 },
	{ 137, 8240 },
	{ 138, 138 },
	{ 139, 8249 },
	{ 140, 338 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 8216 },
	{ 146, 8217 },
	{ 147, 8220 },
	{ 148, 8221 },
	{ 149, 8226 },
	{ 150, 8211 },
	{ 151, 8212 },
	{ 152, 732 },
	{ 153, 8482 },
	{ 154, 154 },
	{ 155, 8250 },
	{ 156, 339 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 376 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 258 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 832 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 272 },
	{ 209, 209 },
	{ 210, 777 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 416 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 431 },
	{ 222, 771 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 259 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 833 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 273 },
	{ 241, 241 },
	{ 242, 803 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 417 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 432 },
	{ 254, 8363 },
	{ 255, 255 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 195 },
	{ 65, 256 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 227 },
	{ 97, 257 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 213 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 245 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 121, 253 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t decmcs[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 164 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 338 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 376 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 339 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 255 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 121, 253 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t ebc037[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 32 },
	{ 65, 160 },
	{ 66, 226 },
	{ 67, 228 },
	{ 68, 224 },
	{ 69, 225 },
	{ 70, 227 },
	{ 71, 229 },
	{ 72, 231 },
	{ 73, 241 },
	{ 74, 162 },
	{ 75, 46 },
	{ 76, 60 },
	{ 77, 40 },
	{ 78, 43 },
	{ 79, 124 },
	{ 80, 38 },
	{ 81, 233 },
	{ 82, 234 },
	{ 83, 235 },
	{ 84, 232 },
	{ 85, 237 },
	{ 86, 238 },
	{ 87, 239 },
	{ 88, 236 },
	{ 89, 223 },
	{ 90, 33 },
	{ 91, 36 },
	{ 92, 42 },
	{ 93, 41 },
	{ 94, 59 },
	{ 95, 172 },
	{ 96, 45 },
	{ 97, 47 },
	{ 98, 194 },
	{ 99, 196 },
	{ 100, 192 },
	{ 101, 193 },
	{ 102, 195 },
	{ 103, 197 },
	{ 104, 199 },
	{ 105, 209 },
	{ 106, 166 },
	{ 107, 44 },
	{ 108, 37 },
	{ 109, 95 },
	{ 110, 62 },
	{ 111, 63 },
	{ 112, 248 },
	{ 113, 201 },
	{ 114, 202 },
	{ 115, 203 },
	{ 116, 200 },
	{ 117, 205 },
	{ 118, 206 },
	{ 119, 207 },
	{ 120, 204 },
	{ 121, 96 },
	{ 122, 58 },
	{ 123, 35 },
	{ 124, 64 },
	{ 125, 39 },
	{ 126, 61 },
	{ 127, 34 },
	{ 128, 216 },
	{ 129, 97 },
	{ 130, 98 },
	{ 131, 99 },
	{ 132, 100 },
	{ 133, 101 },
	{ 134, 102 },
	{ 135, 103 },
	{ 136, 104 },
	{ 137, 105 },
	{ 138, 171 },
	{ 139, 187 },
	{ 140, 240 },
	{ 141, 253 },
	{ 142, 254 },
	{ 143, 177 },
	{ 144, 176 },
	{ 145, 106 },
	{ 146, 107 },
	{ 147, 108 },
	{ 148, 109 },
	{ 149, 110 },
	{ 150, 111 },
	{ 151, 112 },
	{ 152, 113 },
	{ 153, 114 },
	{ 154, 170 },
	{ 155, 186 },
	{ 156, 230 },
	{ 157, 184 },
	{ 158, 198 },
	{ 159, 164 },
	{ 160, 181 },
	{ 161, 126 },
	{ 162, 115 },
	{ 163, 116 },
	{ 164, 117 },
	{ 165, 118 },
	{ 166, 119 },
	{ 167, 120 },
	{ 168, 121 },
	{ 169, 122 },
	{ 170, 161 },
	{ 171, 191 },
	{ 172, 208 },
	{ 173, 221 },
	{ 174, 222 },
	{ 175, 174 },
	{ 176, 94 },
	{ 177, 163 },
	{ 178, 165 },
	{ 179, 183 },
	{ 180, 169 },
	{ 181, 167 },
	{ 182, 182 },
	{ 183, 188 },
	{ 184, 189 },
	{ 185, 190 },
	{ 186, 91 },
	{ 187, 93 },
	{ 188, 175 },
	{ 189, 168 },
	{ 190, 180 },
	{ 191, 215 },
	{ 192, 123 },
	{ 193, 65 },
	{ 194, 66 },
	{ 195, 67 },
	{ 196, 68 },
	{ 197, 69 },
	{ 198, 70 },
	{ 199, 71 },
	{ 200, 72 },
	{ 201, 73 },
	{ 202, 173 },
	{ 203, 244 },
	{ 204, 246 },
	{ 205, 242 },
	{ 206, 243 },
	{ 207, 245 },
	{ 208, 125 },
	{ 209, 74 },
	{ 210, 75 },
	{ 211, 76 },
	{ 212, 77 },
	{ 213, 78 },
	{ 214, 79 },
	{ 215, 80 },
	{ 216, 81 },
	{ 217, 82 },
	{ 218, 185 },
	{ 219, 251 },
	{ 220, 252 },
	{ 221, 249 },
	{ 222, 250 },
	{ 223, 255 },
	{ 224, 92 },
	{ 225, 247 },
	{ 226, 83 },
	{ 227, 84 },
	{ 228, 85 },
	{ 229, 86 },
	{ 230, 87 },
	{ 231, 88 },
	{ 232, 89 },
	{ 233, 90 },
	{ 234, 178 },
	{ 235, 212 },
	{ 236, 214 },
	{ 237, 210 },
	{ 238, 211 },
	{ 239, 213 },
	{ 240, 48 },
	{ 241, 49 },
	{ 242, 50 },
	{ 243, 51 },
	{ 244, 52 },
	{ 245, 53 },
	{ 246, 54 },
	{ 247, 55 },
	{ 248, 56 },
	{ 249, 57 },
	{ 250, 179 },
	{ 251, 219 },
	{ 252, 220 },
	{ 253, 217 },
	{ 254, 218 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 193, 256 },
	{ 193, 258 },
	{ 193, 260 },
	{ 193, 461 },
	{ 129, 257 },
	{ 129, 259 },
	{ 129, 261 },
	{ 129, 462 },
	{ 195, 262 },
	{ 195, 264 },
	{ 195, 266 },
	{ 195, 268 },
	{ 131, 263 },
	{ 131, 265 },
	{ 131, 267 },
	{ 131, 269 },
	{ 196, 270 },
	{ 132, 271 },
	{ 197, 274 },
	{ 197, 276 },
	{ 197, 278 },
	{ 197, 280 },
	{ 197, 282 },
	{ 133, 275 },
	{ 133, 277 },
	{ 133, 279 },
	{ 133, 281 },
	{ 133, 283 },
	{ 199, 284 },
	{ 199, 286 },
	{ 199, 288 },
	{ 199, 290 },
	{ 199, 486 },
	{ 199, 500 },
	{ 135, 285 },
	{ 135, 287 },
	{ 135, 289 },
	{ 135, 291 },
	{ 135, 487 },
	{ 135, 501 },
	{ 200, 292 },
	{ 136, 293 },
	{ 201, 296 },
	{ 201, 298 },
	{ 201, 300 },
	{ 201, 302 },
	{ 201, 304 },
	{ 201, 463 },
	{ 137, 297 },
	{ 137, 299 },
	{ 137, 301 },
	{ 137, 303 },
	{ 137, 305 },
	{ 137, 464 },
	{ 209, 308 },
	{ 145, 309 },
	{ 210, 310 },
	{ 210, 488 },
	{ 146, 311 },
	{ 146, 489 },
	{ 211, 313 },
	{ 211, 315 },
	{ 211, 317 },
	{ 211, 319 },
	{ 211, 321 },
	{ 147, 314 },
	{ 147, 316 },
	{ 147, 318 },
	{ 147, 320 },
	{ 147, 322 },
	{ 212, 323 },
	{ 212, 325 },
	{ 212, 327 },
	{ 148, 324 },
	{ 148, 326 },
	{ 148, 328 },
	{ 148, 329 },
	{ 213, 332 },
	{ 213, 334 },
	{ 213, 336 },
	{ 213, 465 },
	{ 213, 490 },
	{ 149, 333 },
	{ 149, 335 },
	{ 149, 337 },
	{ 149, 466 },
	{ 149, 491 },
	{ 217, 340 },
	{ 217, 342 },
	{ 217, 344 },
	{ 153, 341 },
	{ 153, 343 },
	{ 153, 345 },
	{ 226, 346 },
	{ 226, 348 },
	{ 226, 350 },
	{ 226, 352 },
	{ 162, 347 },
	{ 162, 349 },
	{ 162, 351 },
	{ 162, 353 },
	{ 227, 354 },
	{ 227, 356 },
	{ 163, 355 },
	{ 163, 357 },
	{ 228, 360 },
	{ 228, 362 },
	{ 228, 364 },
	{ 228, 366 },
	{ 228, 368 },
	{ 228, 370 },
	{ 228, 467 },
	{ 164, 361 },
	{ 164, 363 },
	{ 164, 365 },
	{ 164, 367 },
	{ 164, 369 },
	{ 164, 371 },
	{ 164, 468 },
	{ 230, 372 },
	{ 166, 373 },
	{ 232, 374 },
	{ 232, 376 },
	{ 168, 375 },
	{ 233, 377 },
	{ 233, 379 },
	{ 233, 381 },
	{ 169, 378 },
	{ 169, 380 },
	{ 169, 382 },
};
static convert_t ebc1026[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 32 },
	{ 65, 160 },
	{ 66, 226 },
	{ 67, 228 },
	{ 68, 224 },
	{ 69, 225 },
	{ 70, 227 },
	{ 71, 229 },
	{ 72, 123 },
	{ 73, 241 },
	{ 74, 199 },
	{ 75, 46 },
	{ 76, 60 },
	{ 77, 40 },
	{ 78, 43 },
	{ 79, 33 },
	{ 80, 38 },
	{ 81, 233 },
	{ 82, 234 },
	{ 83, 235 },
	{ 84, 232 },
	{ 85, 237 },
	{ 86, 238 },
	{ 87, 239 },
	{ 88, 236 },
	{ 89, 223 },
	{ 90, 286 },
	{ 91, 304 },
	{ 92, 42 },
	{ 93, 41 },
	{ 94, 59 },
	{ 95, 94 },
	{ 96, 45 },
	{ 97, 47 },
	{ 98, 194 },
	{ 99, 196 },
	{ 100, 192 },
	{ 101, 193 },
	{ 102, 195 },
	{ 103, 197 },
	{ 104, 91 },
	{ 105, 209 },
	{ 106, 351 },
	{ 107, 44 },
	{ 108, 37 },
	{ 109, 95 },
	{ 110, 62 },
	{ 111, 63 },
	{ 112, 248 },
	{ 113, 201 },
	{ 114, 202 },
	{ 115, 203 },
	{ 116, 200 },
	{ 117, 205 },
	{ 118, 206 },
	{ 119, 207 },
	{ 120, 204 },
	{ 121, 305 },
	{ 122, 58 },
	{ 123, 214 },
	{ 124, 350 },
	{ 125, 39 },
	{ 126, 61 },
	{ 127, 220 },
	{ 128, 216 },
	{ 129, 97 },
	{ 130, 98 },
	{ 131, 99 },
	{ 132, 100 },
	{ 133, 101 },
	{ 134, 102 },
	{ 135, 103 },
	{ 136, 104 },
	{ 137, 105 },
	{ 138, 171 },
	{ 139, 187 },
	{ 140, 125 },
	{ 141, 96 },
	{ 142, 166 },
	{ 143, 177 },
	{ 144, 176 },
	{ 145, 106 },
	{ 146, 107 },
	{ 147, 108 },
	{ 148, 109 },
	{ 149, 110 },
	{ 150, 111 },
	{ 151, 112 },
	{ 152, 113 },
	{ 153, 114 },
	{ 154, 170 },
	{ 155, 186 },
	{ 156, 230 },
	{ 157, 184 },
	{ 158, 198 },
	{ 159, 164 },
	{ 160, 181 },
	{ 161, 246 },
	{ 162, 115 },
	{ 163, 116 },
	{ 164, 117 },
	{ 165, 118 },
	{ 166, 119 },
	{ 167, 120 },
	{ 168, 121 },
	{ 169, 122 },
	{ 170, 161 },
	{ 171, 191 },
	{ 172, 93 },
	{ 173, 36 },
	{ 174, 64 },
	{ 175, 174 },
	{ 176, 162 },
	{ 177, 163 },
	{ 178, 165 },
	{ 179, 183 },
	{ 180, 169 },
	{ 181, 167 },
	{ 182, 182 },
	{ 183, 188 },
	{ 184, 189 },
	{ 185, 190 },
	{ 186, 172 },
	{ 187, 124 },
	{ 188, 175 },
	{ 189, 168 },
	{ 190, 180 },
	{ 191, 215 },
	{ 192, 231 },
	{ 193, 65 },
	{ 194, 66 },
	{ 195, 67 },
	{ 196, 68 },
	{ 197, 69 },
	{ 198, 70 },
	{ 199, 71 },
	{ 200, 72 },
	{ 201, 73 },
	{ 202, 173 },
	{ 203, 244 },
	{ 204, 126 },
	{ 205, 242 },
	{ 206, 243 },
	{ 207, 245 },
	{ 208, 287 },
	{ 209, 74 },
	{ 210, 75 },
	{ 211, 76 },
	{ 212, 77 },
	{ 213, 78 },
	{ 214, 79 },
	{ 215, 80 },
	{ 216, 81 },
	{ 217, 82 },
	{ 218, 185 },
	{ 219, 251 },
	{ 220, 92 },
	{ 221, 249 },
	{ 222, 250 },
	{ 223, 255 },
	{ 224, 252 },
	{ 225, 247 },
	{ 226, 83 },
	{ 227, 84 },
	{ 228, 85 },
	{ 229, 86 },
	{ 230, 87 },
	{ 231, 88 },
	{ 232, 89 },
	{ 233, 90 },
	{ 234, 178 },
	{ 235, 212 },
	{ 236, 35 },
	{ 237, 210 },
	{ 238, 211 },
	{ 239, 213 },
	{ 240, 48 },
	{ 241, 49 },
	{ 242, 50 },
	{ 243, 51 },
	{ 244, 52 },
	{ 245, 53 },
	{ 246, 54 },
	{ 247, 55 },
	{ 248, 56 },
	{ 249, 57 },
	{ 250, 179 },
	{ 251, 219 },
	{ 252, 34 },
	{ 253, 217 },
	{ 254, 218 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 193, 256 },
	{ 193, 258 },
	{ 193, 260 },
	{ 193, 461 },
	{ 129, 257 },
	{ 129, 259 },
	{ 129, 261 },
	{ 129, 462 },
	{ 195, 262 },
	{ 195, 264 },
	{ 195, 266 },
	{ 195, 268 },
	{ 131, 263 },
	{ 131, 265 },
	{ 131, 267 },
	{ 131, 269 },
	{ 196, 270 },
	{ 132, 271 },
	{ 197, 274 },
	{ 197, 276 },
	{ 197, 278 },
	{ 197, 280 },
	{ 197, 282 },
	{ 133, 275 },
	{ 133, 277 },
	{ 133, 279 },
	{ 133, 281 },
	{ 133, 283 },
	{ 199, 284 },
	{ 199, 288 },
	{ 199, 290 },
	{ 199, 486 },
	{ 199, 500 },
	{ 135, 285 },
	{ 135, 289 },
	{ 135, 291 },
	{ 135, 487 },
	{ 135, 501 },
	{ 200, 292 },
	{ 136, 293 },
	{ 201, 296 },
	{ 201, 298 },
	{ 201, 300 },
	{ 201, 302 },
	{ 201, 463 },
	{ 137, 297 },
	{ 137, 299 },
	{ 137, 301 },
	{ 137, 303 },
	{ 137, 464 },
	{ 209, 308 },
	{ 145, 309 },
	{ 210, 310 },
	{ 210, 488 },
	{ 146, 311 },
	{ 146, 489 },
	{ 211, 313 },
	{ 211, 315 },
	{ 211, 317 },
	{ 211, 319 },
	{ 211, 321 },
	{ 147, 314 },
	{ 147, 316 },
	{ 147, 318 },
	{ 147, 320 },
	{ 147, 322 },
	{ 212, 323 },
	{ 212, 325 },
	{ 212, 327 },
	{ 148, 324 },
	{ 148, 326 },
	{ 148, 328 },
	{ 148, 329 },
	{ 213, 332 },
	{ 213, 334 },
	{ 213, 336 },
	{ 213, 465 },
	{ 213, 490 },
	{ 149, 333 },
	{ 149, 335 },
	{ 149, 337 },
	{ 149, 466 },
	{ 149, 491 },
	{ 217, 340 },
	{ 217, 342 },
	{ 217, 344 },
	{ 153, 341 },
	{ 153, 343 },
	{ 153, 345 },
	{ 226, 346 },
	{ 226, 348 },
	{ 226, 352 },
	{ 162, 347 },
	{ 162, 349 },
	{ 162, 353 },
	{ 227, 354 },
	{ 227, 356 },
	{ 163, 355 },
	{ 163, 357 },
	{ 228, 360 },
	{ 228, 362 },
	{ 228, 364 },
	{ 228, 366 },
	{ 228, 368 },
	{ 228, 370 },
	{ 228, 467 },
	{ 164, 361 },
	{ 164, 363 },
	{ 164, 365 },
	{ 164, 367 },
	{ 164, 369 },
	{ 164, 371 },
	{ 164, 468 },
	{ 230, 372 },
	{ 166, 373 },
	{ 232, 221 },
	{ 232, 374 },
	{ 232, 376 },
	{ 168, 253 },
	{ 168, 375 },
	{ 233, 377 },
	{ 233, 379 },
	{ 233, 381 },
	{ 169, 378 },
	{ 169, 380 },
	{ 169, 382 },
};
static convert_t ebc1047[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 32 },
	{ 65, 160 },
	{ 66, 226 },
	{ 67, 228 },
	{ 68, 224 },
	{ 69, 225 },
	{ 70, 227 },
	{ 71, 229 },
	{ 72, 231 },
	{ 73, 241 },
	{ 74, 162 },
	{ 75, 46 },
	{ 76, 60 },
	{ 77, 40 },
	{ 78, 43 },
	{ 79, 124 },
	{ 80, 38 },
	{ 81, 233 },
	{ 82, 234 },
	{ 83, 235 },
	{ 84, 232 },
	{ 85, 237 },
	{ 86, 238 },
	{ 87, 239 },
	{ 88, 236 },
	{ 89, 223 },
	{ 90, 33 },
	{ 91, 36 },
	{ 92, 42 },
	{ 93, 41 },
	{ 94, 59 },
	{ 95, 94 },
	{ 96, 45 },
	{ 97, 47 },
	{ 98, 194 },
	{ 99, 196 },
	{ 100, 192 },
	{ 101, 193 },
	{ 102, 195 },
	{ 103, 197 },
	{ 104, 199 },
	{ 105, 209 },
	{ 106, 166 },
	{ 107, 44 },
	{ 108, 37 },
	{ 109, 95 },
	{ 110, 62 },
	{ 111, 63 },
	{ 112, 248 },
	{ 113, 201 },
	{ 114, 202 },
	{ 115, 203 },
	{ 116, 200 },
	{ 117, 205 },
	{ 118, 206 },
	{ 119, 207 },
	{ 120, 204 },
	{ 121, 96 },
	{ 122, 58 },
	{ 123, 35 },
	{ 124, 64 },
	{ 125, 39 },
	{ 126, 61 },
	{ 127, 34 },
	{ 128, 216 },
	{ 129, 97 },
	{ 130, 98 },
	{ 131, 99 },
	{ 132, 100 },
	{ 133, 101 },
	{ 134, 102 },
	{ 135, 103 },
	{ 136, 104 },
	{ 137, 105 },
	{ 138, 171 },
	{ 139, 187 },
	{ 140, 240 },
	{ 141, 253 },
	{ 142, 254 },
	{ 143, 177 },
	{ 144, 176 },
	{ 145, 106 },
	{ 146, 107 },
	{ 147, 108 },
	{ 148, 109 },
	{ 149, 110 },
	{ 150, 111 },
	{ 151, 112 },
	{ 152, 113 },
	{ 153, 114 },
	{ 154, 170 },
	{ 155, 186 },
	{ 156, 230 },
	{ 157, 184 },
	{ 158, 198 },
	{ 159, 164 },
	{ 160, 181 },
	{ 161, 126 },
	{ 162, 115 },
	{ 163, 116 },
	{ 164, 117 },
	{ 165, 118 },
	{ 166, 119 },
	{ 167, 120 },
	{ 168, 121 },
	{ 169, 122 },
	{ 170, 161 },
	{ 171, 191 },
	{ 172, 208 },
	{ 173, 91 },
	{ 174, 222 },
	{ 175, 174 },
	{ 176, 172 },
	{ 177, 163 },
	{ 178, 165 },
	{ 179, 183 },
	{ 180, 169 },
	{ 181, 167 },
	{ 182, 182 },
	{ 183, 188 },
	{ 184, 189 },
	{ 185, 190 },
	{ 186, 221 },
	{ 187, 168 },
	{ 188, 175 },
	{ 189, 93 },
	{ 190, 180 },
	{ 191, 215 },
	{ 192, 123 },
	{ 193, 65 },
	{ 194, 66 },
	{ 195, 67 },
	{ 196, 68 },
	{ 197, 69 },
	{ 198, 70 },
	{ 199, 71 },
	{ 200, 72 },
	{ 201, 73 },
	{ 202, 173 },
	{ 203, 244 },
	{ 204, 246 },
	{ 205, 242 },
	{ 206, 243 },
	{ 207, 245 },
	{ 208, 125 },
	{ 209, 74 },
	{ 210, 75 },
	{ 211, 76 },
	{ 212, 77 },
	{ 213, 78 },
	{ 214, 79 },
	{ 215, 80 },
	{ 216, 81 },
	{ 217, 82 },
	{ 218, 185 },
	{ 219, 251 },
	{ 220, 252 },
	{ 221, 249 },
	{ 222, 250 },
	{ 223, 255 },
	{ 224, 92 },
	{ 225, 247 },
	{ 226, 83 },
	{ 227, 84 },
	{ 228, 85 },
	{ 229, 86 },
	{ 230, 87 },
	{ 231, 88 },
	{ 232, 89 },
	{ 233, 90 },
	{ 234, 178 },
	{ 235, 212 },
	{ 236, 214 },
	{ 237, 210 },
	{ 238, 211 },
	{ 239, 213 },
	{ 240, 48 },
	{ 241, 49 },
	{ 242, 50 },
	{ 243, 51 },
	{ 244, 52 },
	{ 245, 53 },
	{ 246, 54 },
	{ 247, 55 },
	{ 248, 56 },
	{ 249, 57 },
	{ 250, 179 },
	{ 251, 219 },
	{ 252, 220 },
	{ 253, 217 },
	{ 254, 218 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 193, 256 },
	{ 193, 258 },
	{ 193, 260 },
	{ 193, 461 },
	{ 129, 257 },
	{ 129, 259 },
	{ 129, 261 },
	{ 129, 462 },
	{ 195, 262 },
	{ 195, 264 },
	{ 195, 266 },
	{ 195, 268 },
	{ 131, 263 },
	{ 131, 265 },
	{ 131, 267 },
	{ 131, 269 },
	{ 196, 270 },
	{ 132, 271 },
	{ 197, 274 },
	{ 197, 276 },
	{ 197, 278 },
	{ 197, 280 },
	{ 197, 282 },
	{ 133, 275 },
	{ 133, 277 },
	{ 133, 279 },
	{ 133, 281 },
	{ 133, 283 },
	{ 199, 284 },
	{ 199, 286 },
	{ 199, 288 },
	{ 199, 290 },
	{ 199, 486 },
	{ 199, 500 },
	{ 135, 285 },
	{ 135, 287 },
	{ 135, 289 },
	{ 135, 291 },
	{ 135, 487 },
	{ 135, 501 },
	{ 200, 292 },
	{ 136, 293 },
	{ 201, 296 },
	{ 201, 298 },
	{ 201, 300 },
	{ 201, 302 },
	{ 201, 304 },
	{ 201, 463 },
	{ 137, 297 },
	{ 137, 299 },
	{ 137, 301 },
	{ 137, 303 },
	{ 137, 305 },
	{ 137, 464 },
	{ 209, 308 },
	{ 145, 309 },
	{ 210, 310 },
	{ 210, 488 },
	{ 146, 311 },
	{ 146, 489 },
	{ 211, 313 },
	{ 211, 315 },
	{ 211, 317 },
	{ 211, 319 },
	{ 211, 321 },
	{ 147, 314 },
	{ 147, 316 },
	{ 147, 318 },
	{ 147, 320 },
	{ 147, 322 },
	{ 212, 323 },
	{ 212, 325 },
	{ 212, 327 },
	{ 148, 324 },
	{ 148, 326 },
	{ 148, 328 },
	{ 148, 329 },
	{ 213, 332 },
	{ 213, 334 },
	{ 213, 336 },
	{ 213, 465 },
	{ 213, 490 },
	{ 149, 333 },
	{ 149, 335 },
	{ 149, 337 },
	{ 149, 466 },
	{ 149, 491 },
	{ 217, 340 },
	{ 217, 342 },
	{ 217, 344 },
	{ 153, 341 },
	{ 153, 343 },
	{ 153, 345 },
	{ 226, 346 },
	{ 226, 348 },
	{ 226, 350 },
	{ 226, 352 },
	{ 162, 347 },
	{ 162, 349 },
	{ 162, 351 },
	{ 162, 353 },
	{ 227, 354 },
	{ 227, 356 },
	{ 163, 355 },
	{ 163, 357 },
	{ 228, 360 },
	{ 228, 362 },
	{ 228, 364 },
	{ 228, 366 },
	{ 228, 368 },
	{ 228, 370 },
	{ 228, 467 },
	{ 164, 361 },
	{ 164, 363 },
	{ 164, 365 },
	{ 164, 367 },
	{ 164, 369 },
	{ 164, 371 },
	{ 164, 468 },
	{ 230, 372 },
	{ 166, 373 },
	{ 232, 374 },
	{ 232, 376 },
	{ 168, 375 },
	{ 233, 377 },
	{ 233, 379 },
	{ 233, 381 },
	{ 169, 378 },
	{ 169, 380 },
	{ 169, 382 },
};
static convert_t ebc500[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 32 },
	{ 65, 160 },
	{ 66, 226 },
	{ 67, 228 },
	{ 68, 224 },
	{ 69, 225 },
	{ 70, 227 },
	{ 71, 229 },
	{ 72, 231 },
	{ 73, 241 },
	{ 74, 91 },
	{ 75, 46 },
	{ 76, 60 },
	{ 77, 40 },
	{ 78, 43 },
	{ 79, 33 },
	{ 80, 38 },
	{ 81, 233 },
	{ 82, 234 },
	{ 83, 235 },
	{ 84, 232 },
	{ 85, 237 },
	{ 86, 238 },
	{ 87, 239 },
	{ 88, 236 },
	{ 89, 223 },
	{ 90, 93 },
	{ 91, 36 },
	{ 92, 42 },
	{ 93, 41 },
	{ 94, 59 },
	{ 95, 94 },
	{ 96, 45 },
	{ 97, 47 },
	{ 98, 194 },
	{ 99, 196 },
	{ 100, 192 },
	{ 101, 193 },
	{ 102, 195 },
	{ 103, 197 },
	{ 104, 199 },
	{ 105, 209 },
	{ 106, 166 },
	{ 107, 44 },
	{ 108, 37 },
	{ 109, 95 },
	{ 110, 62 },
	{ 111, 63 },
	{ 112, 248 },
	{ 113, 201 },
	{ 114, 202 },
	{ 115, 203 },
	{ 116, 200 },
	{ 117, 205 },
	{ 118, 206 },
	{ 119, 207 },
	{ 120, 204 },
	{ 121, 96 },
	{ 122, 58 },
	{ 123, 35 },
	{ 124, 64 },
	{ 125, 39 },
	{ 126, 61 },
	{ 127, 34 },
	{ 128, 216 },
	{ 129, 97 },
	{ 130, 98 },
	{ 131, 99 },
	{ 132, 100 },
	{ 133, 101 },
	{ 134, 102 },
	{ 135, 103 },
	{ 136, 104 },
	{ 137, 105 },
	{ 138, 171 },
	{ 139, 187 },
	{ 140, 240 },
	{ 141, 253 },
	{ 142, 254 },
	{ 143, 177 },
	{ 144, 176 },
	{ 145, 106 },
	{ 146, 107 },
	{ 147, 108 },
	{ 148, 109 },
	{ 149, 110 },
	{ 150, 111 },
	{ 151, 112 },
	{ 152, 113 },
	{ 153, 114 },
	{ 154, 170 },
	{ 155, 186 },
	{ 156, 230 },
	{ 157, 184 },
	{ 158, 198 },
	{ 159, 164 },
	{ 160, 181 },
	{ 161, 126 },
	{ 162, 115 },
	{ 163, 116 },
	{ 164, 117 },
	{ 165, 118 },
	{ 166, 119 },
	{ 167, 120 },
	{ 168, 121 },
	{ 169, 122 },
	{ 170, 161 },
	{ 171, 191 },
	{ 172, 208 },
	{ 173, 221 },
	{ 174, 222 },
	{ 175, 174 },
	{ 176, 162 },
	{ 177, 163 },
	{ 178, 165 },
	{ 179, 183 },
	{ 180, 169 },
	{ 181, 167 },
	{ 182, 182 },
	{ 183, 188 },
	{ 184, 189 },
	{ 185, 190 },
	{ 186, 172 },
	{ 187, 124 },
	{ 188, 175 },
	{ 189, 168 },
	{ 190, 180 },
	{ 191, 215 },
	{ 192, 123 },
	{ 193, 65 },
	{ 194, 66 },
	{ 195, 67 },
	{ 196, 68 },
	{ 197, 69 },
	{ 198, 70 },
	{ 199, 71 },
	{ 200, 72 },
	{ 201, 73 },
	{ 202, 173 },
	{ 203, 244 },
	{ 204, 246 },
	{ 205, 242 },
	{ 206, 243 },
	{ 207, 245 },
	{ 208, 125 },
	{ 209, 74 },
	{ 210, 75 },
	{ 211, 76 },
	{ 212, 77 },
	{ 213, 78 },
	{ 214, 79 },
	{ 215, 80 },
	{ 216, 81 },
	{ 217, 82 },
	{ 218, 185 },
	{ 219, 251 },
	{ 220, 252 },
	{ 221, 249 },
	{ 222, 250 },
	{ 223, 255 },
	{ 224, 92 },
	{ 225, 247 },
	{ 226, 83 },
	{ 227, 84 },
	{ 228, 85 },
	{ 229, 86 },
	{ 230, 87 },
	{ 231, 88 },
	{ 232, 89 },
	{ 233, 90 },
	{ 234, 178 },
	{ 235, 212 },
	{ 236, 214 },
	{ 237, 210 },
	{ 238, 211 },
	{ 239, 213 },
	{ 240, 48 },
	{ 241, 49 },
	{ 242, 50 },
	{ 243, 51 },
	{ 244, 52 },
	{ 245, 53 },
	{ 246, 54 },
	{ 247, 55 },
	{ 248, 56 },
	{ 249, 57 },
	{ 250, 179 },
	{ 251, 219 },
	{ 252, 220 },
	{ 253, 217 },
	{ 254, 218 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 193, 256 },
	{ 193, 258 },
	{ 193, 260 },
	{ 193, 461 },
	{ 129, 257 },
	{ 129, 259 },
	{ 129, 261 },
	{ 129, 462 },
	{ 195, 262 },
	{ 195, 264 },
	{ 195, 266 },
	{ 195, 268 },
	{ 131, 263 },
	{ 131, 265 },
	{ 131, 267 },
	{ 131, 269 },
	{ 196, 270 },
	{ 132, 271 },
	{ 197, 274 },
	{ 197, 276 },
	{ 197, 278 },
	{ 197, 280 },
	{ 197, 282 },
	{ 133, 275 },
	{ 133, 277 },
	{ 133, 279 },
	{ 133, 281 },
	{ 133, 283 },
	{ 199, 284 },
	{ 199, 286 },
	{ 199, 288 },
	{ 199, 290 },
	{ 199, 486 },
	{ 199, 500 },
	{ 135, 285 },
	{ 135, 287 },
	{ 135, 289 },
	{ 135, 291 },
	{ 135, 487 },
	{ 135, 501 },
	{ 200, 292 },
	{ 136, 293 },
	{ 201, 296 },
	{ 201, 298 },
	{ 201, 300 },
	{ 201, 302 },
	{ 201, 304 },
	{ 201, 463 },
	{ 137, 297 },
	{ 137, 299 },
	{ 137, 301 },
	{ 137, 303 },
	{ 137, 305 },
	{ 137, 464 },
	{ 209, 308 },
	{ 145, 309 },
	{ 210, 310 },
	{ 210, 488 },
	{ 146, 311 },
	{ 146, 489 },
	{ 211, 313 },
	{ 211, 315 },
	{ 211, 317 },
	{ 211, 319 },
	{ 211, 321 },
	{ 147, 314 },
	{ 147, 316 },
	{ 147, 318 },
	{ 147, 320 },
	{ 147, 322 },
	{ 212, 323 },
	{ 212, 325 },
	{ 212, 327 },
	{ 148, 324 },
	{ 148, 326 },
	{ 148, 328 },
	{ 148, 329 },
	{ 213, 332 },
	{ 213, 334 },
	{ 213, 336 },
	{ 213, 465 },
	{ 213, 490 },
	{ 149, 333 },
	{ 149, 335 },
	{ 149, 337 },
	{ 149, 466 },
	{ 149, 491 },
	{ 217, 340 },
	{ 217, 342 },
	{ 217, 344 },
	{ 153, 341 },
	{ 153, 343 },
	{ 153, 345 },
	{ 226, 346 },
	{ 226, 348 },
	{ 226, 350 },
	{ 226, 352 },
	{ 162, 347 },
	{ 162, 349 },
	{ 162, 351 },
	{ 162, 353 },
	{ 227, 354 },
	{ 227, 356 },
	{ 163, 355 },
	{ 163, 357 },
	{ 228, 360 },
	{ 228, 362 },
	{ 228, 364 },
	{ 228, 366 },
	{ 228, 368 },
	{ 228, 370 },
	{ 228, 467 },
	{ 164, 361 },
	{ 164, 363 },
	{ 164, 365 },
	{ 164, 367 },
	{ 164, 369 },
	{ 164, 371 },
	{ 164, 468 },
	{ 230, 372 },
	{ 166, 373 },
	{ 232, 374 },
	{ 232, 376 },
	{ 168, 375 },
	{ 233, 377 },
	{ 233, 379 },
	{ 233, 381 },
	{ 169, 378 },
	{ 169, 380 },
	{ 169, 382 },
};
static convert_t ebc875[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 32 },
	{ 65, 913 },
	{ 66, 914 },
	{ 67, 915 },
	{ 68, 916 },
	{ 69, 917 },
	{ 70, 918 },
	{ 71, 919 },
	{ 72, 920 },
	{ 73, 921 },
	{ 74, 91 },
	{ 75, 46 },
	{ 76, 60 },
	{ 77, 40 },
	{ 78, 43 },
	{ 79, 33 },
	{ 80, 38 },
	{ 81, 922 },
	{ 82, 923 },
	{ 83, 924 },
	{ 84, 925 },
	{ 85, 926 },
	{ 86, 927 },
	{ 87, 928 },
	{ 88, 929 },
	{ 89, 931 },
	{ 90, 93 },
	{ 91, 36 },
	{ 92, 42 },
	{ 93, 41 },
	{ 94, 59 },
	{ 95, 94 },
	{ 96, 45 },
	{ 97, 47 },
	{ 98, 932 },
	{ 99, 933 },
	{ 100, 934 },
	{ 101, 935 },
	{ 102, 936 },
	{ 103, 937 },
	{ 104, 938 },
	{ 105, 939 },
	{ 106, 124 },
	{ 107, 44 },
	{ 108, 37 },
	{ 109, 95 },
	{ 110, 62 },
	{ 111, 63 },
	{ 112, 168 },
	{ 113, 902 },
	{ 114, 904 },
	{ 115, 905 },
	{ 116, 160 },
	{ 117, 906 },
	{ 118, 908 },
	{ 119, 910 },
	{ 120, 911 },
	{ 121, 96 },
	{ 122, 58 },
	{ 123, 35 },
	{ 124, 64 },
	{ 125, 39 },
	{ 126, 61 },
	{ 127, 34 },
	{ 128, 901 },
	{ 129, 97 },
	{ 130, 98 },
	{ 131, 99 },
	{ 132, 100 },
	{ 133, 101 },
	{ 134, 102 },
	{ 135, 103 },
	{ 136, 104 },
	{ 137, 105 },
	{ 138, 945 },
	{ 139, 946 },
	{ 140, 947 },
	{ 141, 948 },
	{ 142, 949 },
	{ 143, 950 },
	{ 144, 176 },
	{ 145, 106 },
	{ 146, 107 },
	{ 147, 108 },
	{ 148, 109 },
	{ 149, 110 },
	{ 150, 111 },
	{ 151, 112 },
	{ 152, 113 },
	{ 153, 114 },
	{ 154, 951 },
	{ 155, 952 },
	{ 156, 953 },
	{ 157, 954 },
	{ 158, 955 },
	{ 159, 956 },
	{ 160, 180 },
	{ 161, 126 },
	{ 162, 115 },
	{ 163, 116 },
	{ 164, 117 },
	{ 165, 118 },
	{ 166, 119 },
	{ 167, 120 },
	{ 168, 121 },
	{ 169, 122 },
	{ 170, 957 },
	{ 171, 958 },
	{ 172, 959 },
	{ 173, 960 },
	{ 174, 961 },
	{ 175, 963 },
	{ 176, 163 },
	{ 177, 940 },
	{ 178, 941 },
	{ 179, 942 },
	{ 180, 970 },
	{ 181, 943 },
	{ 182, 972 },
	{ 183, 973 },
	{ 184, 971 },
	{ 185, 974 },
	{ 186, 962 },
	{ 187, 964 },
	{ 188, 965 },
	{ 189, 966 },
	{ 190, 967 },
	{ 191, 968 },
	{ 192, 123 },
	{ 193, 65 },
	{ 194, 66 },
	{ 195, 67 },
	{ 196, 68 },
	{ 197, 69 },
	{ 198, 70 },
	{ 199, 71 },
	{ 200, 72 },
	{ 201, 73 },
	{ 202, 173 },
	{ 203, 969 },
	{ 204, 912 },
	{ 205, 944 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 125 },
	{ 209, 74 },
	{ 210, 75 },
	{ 211, 76 },
	{ 212, 77 },
	{ 213, 78 },
	{ 214, 79 },
	{ 215, 80 },
	{ 216, 81 },
	{ 217, 82 },
	{ 218, 177 },
	{ 219, 189 },
	{ 220, 220 },
	{ 221, 183 },
	{ 222, 222 },
	{ 223, 166 },
	{ 224, 92 },
	{ 225, 225 },
	{ 226, 83 },
	{ 227, 84 },
	{ 228, 85 },
	{ 229, 86 },
	{ 230, 87 },
	{ 231, 88 },
	{ 232, 89 },
	{ 233, 90 },
	{ 234, 178 },
	{ 235, 167 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 171 },
	{ 239, 172 },
	{ 240, 48 },
	{ 241, 49 },
	{ 242, 50 },
	{ 243, 51 },
	{ 244, 52 },
	{ 245, 53 },
	{ 246, 54 },
	{ 247, 55 },
	{ 248, 56 },
	{ 249, 57 },
	{ 250, 179 },
	{ 251, 169 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 187 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 193, 192 },
	{ 193, 193 },
	{ 193, 194 },
	{ 193, 195 },
	{ 193, 196 },
	{ 193, 197 },
	{ 193, 256 },
	{ 193, 258 },
	{ 193, 260 },
	{ 193, 461 },
	{ 129, 224 },
	{ 129, 226 },
	{ 129, 227 },
	{ 129, 228 },
	{ 129, 229 },
	{ 129, 257 },
	{ 129, 259 },
	{ 129, 261 },
	{ 129, 462 },
	{ 195, 199 },
	{ 195, 262 },
	{ 195, 264 },
	{ 195, 266 },
	{ 195, 268 },
	{ 131, 231 },
	{ 131, 263 },
	{ 131, 265 },
	{ 131, 267 },
	{ 131, 269 },
	{ 196, 270 },
	{ 132, 271 },
	{ 197, 200 },
	{ 197, 201 },
	{ 197, 202 },
	{ 197, 203 },
	{ 197, 274 },
	{ 197, 276 },
	{ 197, 278 },
	{ 197, 280 },
	{ 197, 282 },
	{ 133, 232 },
	{ 133, 233 },
	{ 133, 234 },
	{ 133, 235 },
	{ 133, 275 },
	{ 133, 277 },
	{ 133, 279 },
	{ 133, 281 },
	{ 133, 283 },
	{ 199, 284 },
	{ 199, 286 },
	{ 199, 288 },
	{ 199, 290 },
	{ 199, 486 },
	{ 199, 500 },
	{ 135, 285 },
	{ 135, 287 },
	{ 135, 289 },
	{ 135, 291 },
	{ 135, 487 },
	{ 135, 501 },
	{ 200, 292 },
	{ 136, 293 },
	{ 201, 204 },
	{ 201, 205 },
	{ 201, 296 },
	{ 201, 298 },
	{ 201, 300 },
	{ 201, 302 },
	{ 201, 304 },
	{ 201, 463 },
	{ 137, 238 },
	{ 137, 239 },
	{ 137, 297 },
	{ 137, 299 },
	{ 137, 301 },
	{ 137, 303 },
	{ 137, 305 },
	{ 137, 464 },
	{ 209, 308 },
	{ 145, 309 },
	{ 210, 310 },
	{ 210, 488 },
	{ 146, 311 },
	{ 146, 489 },
	{ 211, 313 },
	{ 211, 315 },
	{ 211, 317 },
	{ 211, 319 },
	{ 211, 321 },
	{ 147, 314 },
	{ 147, 316 },
	{ 147, 318 },
	{ 147, 320 },
	{ 147, 322 },
	{ 212, 209 },
	{ 212, 323 },
	{ 212, 325 },
	{ 212, 327 },
	{ 148, 241 },
	{ 148, 324 },
	{ 148, 326 },
	{ 148, 328 },
	{ 148, 329 },
	{ 213, 210 },
	{ 213, 211 },
	{ 213, 212 },
	{ 213, 213 },
	{ 213, 214 },
	{ 213, 216 },
	{ 213, 332 },
	{ 213, 334 },
	{ 213, 336 },
	{ 213, 465 },
	{ 213, 490 },
	{ 149, 242 },
	{ 149, 243 },
	{ 149, 244 },
	{ 149, 245 },
	{ 149, 246 },
	{ 149, 248 },
	{ 149, 333 },
	{ 149, 335 },
	{ 149, 337 },
	{ 149, 466 },
	{ 149, 491 },
	{ 217, 340 },
	{ 217, 342 },
	{ 217, 344 },
	{ 153, 341 },
	{ 153, 343 },
	{ 153, 345 },
	{ 226, 346 },
	{ 226, 348 },
	{ 226, 350 },
	{ 226, 352 },
	{ 162, 347 },
	{ 162, 349 },
	{ 162, 351 },
	{ 162, 353 },
	{ 227, 354 },
	{ 227, 356 },
	{ 163, 355 },
	{ 163, 357 },
	{ 228, 217 },
	{ 228, 218 },
	{ 228, 219 },
	{ 228, 360 },
	{ 228, 362 },
	{ 228, 364 },
	{ 228, 366 },
	{ 228, 368 },
	{ 228, 370 },
	{ 228, 467 },
	{ 164, 249 },
	{ 164, 250 },
	{ 164, 251 },
	{ 164, 361 },
	{ 164, 363 },
	{ 164, 365 },
	{ 164, 367 },
	{ 164, 369 },
	{ 164, 371 },
	{ 164, 468 },
	{ 230, 372 },
	{ 166, 373 },
	{ 232, 221 },
	{ 232, 374 },
	{ 232, 376 },
	{ 168, 375 },
	{ 233, 377 },
	{ 233, 379 },
	{ 233, 381 },
	{ 169, 378 },
	{ 169, 380 },
	{ 169, 382 },
};
static convert_t hp48[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 8735 },
	{ 129, 129 },
	{ 130, 8711 },
	{ 131, 8730 },
	{ 132, 8747 },
	{ 133, 8721 },
	{ 134, 9654 },
	{ 135, 960 },
	{ 136, 8706 },
	{ 137, 8804 },
	{ 138, 8805 },
	{ 139, 8800 },
	{ 140, 945 },
	{ 141, 8594 },
	{ 142, 8592 },
	{ 143, 8595 },
	{ 144, 8593 },
	{ 145, 947 },
	{ 146, 948 },
	{ 147, 949 },
	{ 148, 951 },
	{ 149, 952 },
	{ 150, 955 },
	{ 151, 961 },
	{ 152, 963 },
	{ 153, 964 },
	{ 154, 969 },
	{ 155, 916 },
	{ 156, 928 },
	{ 157, 937 },
	{ 158, 9644 },
	{ 159, 8734 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t hproman8[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 192 },
	{ 162, 194 },
	{ 163, 200 },
	{ 164, 202 },
	{ 165, 203 },
	{ 166, 206 },
	{ 167, 207 },
	{ 168, 180 },
	{ 169, 768 },
	{ 170, 770 },
	{ 171, 168 },
	{ 172, 771 },
	{ 173, 217 },
	{ 174, 219 },
	{ 175, 8356 },
	{ 176, 175 },
	{ 177, 221 },
	{ 178, 253 },
	{ 179, 176 },
	{ 180, 199 },
	{ 181, 231 },
	{ 182, 209 },
	{ 183, 241 },
	{ 184, 161 },
	{ 185, 191 },
	{ 186, 164 },
	{ 187, 163 },
	{ 188, 165 },
	{ 189, 167 },
	{ 190, 402 },
	{ 191, 162 },
	{ 192, 226 },
	{ 193, 234 },
	{ 194, 244 },
	{ 195, 251 },
	{ 196, 225 },
	{ 197, 233 },
	{ 198, 243 },
	{ 199, 250 },
	{ 200, 224 },
	{ 201, 232 },
	{ 202, 242 },
	{ 203, 249 },
	{ 204, 228 },
	{ 205, 235 },
	{ 206, 246 },
	{ 207, 252 },
	{ 208, 197 },
	{ 209, 238 },
	{ 210, 216 },
	{ 211, 198 },
	{ 212, 229 },
	{ 213, 237 },
	{ 214, 248 },
	{ 215, 230 },
	{ 216, 196 },
	{ 217, 236 },
	{ 218, 214 },
	{ 219, 220 },
	{ 220, 201 },
	{ 221, 239 },
	{ 222, 223 },
	{ 223, 212 },
	{ 224, 193 },
	{ 225, 195 },
	{ 226, 227 },
	{ 227, 208 },
	{ 228, 240 },
	{ 229, 205 },
	{ 230, 204 },
	{ 231, 211 },
	{ 232, 210 },
	{ 233, 213 },
	{ 234, 245 },
	{ 235, 352 },
	{ 236, 353 },
	{ 237, 218 },
	{ 238, 376 },
	{ 239, 255 },
	{ 240, 222 },
	{ 241, 254 },
	{ 242, 183 },
	{ 243, 181 },
	{ 244, 182 },
	{ 245, 190 },
	{ 246, 173 },
	{ 247, 188 },
	{ 248, 189 },
	{ 249, 170 },
	{ 250, 186 },
	{ 251, 171 },
	{ 252, 9632 },
	{ 253, 187 },
	{ 254, 177 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso646[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso646_irv[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso646_ca[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 224 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 226 },
	{ 92, 231 },
	{ 93, 234 },
	{ 94, 238 },
	{ 95, 95 },
	{ 96, 244 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 233 },
	{ 124, 249 },
	{ 125, 232 },
	{ 126, 251 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso646_ch[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 249 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 224 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 233 },
	{ 92, 231 },
	{ 93, 234 },
	{ 94, 238 },
	{ 95, 232 },
	{ 96, 244 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 228 },
	{ 124, 246 },
	{ 125, 252 },
	{ 126, 251 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso646_de[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 167 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 196 },
	{ 92, 214 },
	{ 93, 220 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 228 },
	{ 124, 246 },
	{ 125, 252 },
	{ 126, 223 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso646_es[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 163 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 167 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 161 },
	{ 92, 209 },
	{ 93, 191 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 176 },
	{ 124, 241 },
	{ 125, 231 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso646_fi[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 196 },
	{ 92, 214 },
	{ 93, 197 },
	{ 94, 220 },
	{ 95, 95 },
	{ 96, 233 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 228 },
	{ 124, 246 },
	{ 125, 229 },
	{ 126, 252 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso646_fr[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 163 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 224 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 176 },
	{ 92, 231 },
	{ 93, 167 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 233 },
	{ 124, 249 },
	{ 125, 232 },
	{ 126, 168 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso646_gb[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 163 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso646_it[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 163 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 167 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 176 },
	{ 92, 231 },
	{ 93, 233 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 249 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 224 },
	{ 124, 242 },
	{ 125, 232 },
	{ 126, 236 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso646_nl[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 163 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 190 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 255 },
	{ 92, 189 },
	{ 93, 124 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 168 },
	{ 124, 402 },
	{ 125, 188 },
	{ 126, 180 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso646_no[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 198 },
	{ 92, 216 },
	{ 93, 197 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 230 },
	{ 124, 248 },
	{ 125, 229 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso646_pt[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 195 },
	{ 92, 199 },
	{ 93, 213 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 227 },
	{ 124, 231 },
	{ 125, 245 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso646_se[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 201 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 196 },
	{ 92, 214 },
	{ 93, 197 },
	{ 94, 220 },
	{ 95, 95 },
	{ 96, 233 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 228 },
	{ 124, 246 },
	{ 125, 229 },
	{ 126, 252 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso8859_1[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso8859_2[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 260 },
	{ 162, 728 },
	{ 163, 321 },
	{ 164, 164 },
	{ 165, 317 },
	{ 166, 346 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 352 },
	{ 170, 350 },
	{ 171, 356 },
	{ 172, 377 },
	{ 173, 173 },
	{ 174, 381 },
	{ 175, 379 },
	{ 176, 176 },
	{ 177, 261 },
	{ 178, 731 },
	{ 179, 322 },
	{ 180, 180 },
	{ 181, 318 },
	{ 182, 347 },
	{ 183, 711 },
	{ 184, 184 },
	{ 185, 353 },
	{ 186, 351 },
	{ 187, 357 },
	{ 188, 378 },
	{ 189, 733 },
	{ 190, 382 },
	{ 191, 380 },
	{ 192, 340 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 258 },
	{ 196, 196 },
	{ 197, 313 },
	{ 198, 262 },
	{ 199, 199 },
	{ 200, 268 },
	{ 201, 201 },
	{ 202, 280 },
	{ 203, 203 },
	{ 204, 282 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 270 },
	{ 208, 272 },
	{ 209, 323 },
	{ 210, 327 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 336 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 344 },
	{ 217, 366 },
	{ 218, 218 },
	{ 219, 368 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 354 },
	{ 223, 223 },
	{ 224, 341 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 259 },
	{ 228, 228 },
	{ 229, 314 },
	{ 230, 263 },
	{ 231, 231 },
	{ 232, 269 },
	{ 233, 233 },
	{ 234, 281 },
	{ 235, 235 },
	{ 236, 283 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 271 },
	{ 240, 273 },
	{ 241, 324 },
	{ 242, 328 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 337 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 345 },
	{ 249, 367 },
	{ 250, 250 },
	{ 251, 369 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 355 },
	{ 255, 729 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 195 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 227 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 462 },
	{ 67, 264 },
	{ 67, 266 },
	{ 99, 265 },
	{ 99, 267 },
	{ 69, 200 },
	{ 69, 202 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 101, 232 },
	{ 101, 234 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 315 },
	{ 76, 319 },
	{ 108, 316 },
	{ 108, 320 },
	{ 77, 209 },
	{ 77, 325 },
	{ 109, 241 },
	{ 109, 326 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 213 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 245 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 342 },
	{ 114, 343 },
	{ 83, 348 },
	{ 115, 349 },
	{ 85, 217 },
	{ 85, 219 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 251 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 255 },
	{ 121, 375 },
};
static convert_t iso8859_3[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 294 },
	{ 162, 728 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 292 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 304 },
	{ 170, 350 },
	{ 171, 286 },
	{ 172, 308 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 379 },
	{ 176, 176 },
	{ 177, 295 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 293 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 305 },
	{ 186, 351 },
	{ 187, 287 },
	{ 188, 309 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 380 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 266 },
	{ 198, 264 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 288 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 284 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 364 },
	{ 222, 348 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 267 },
	{ 230, 265 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 289 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 285 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 365 },
	{ 254, 349 },
	{ 255, 729 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 464 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 213 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 245 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 382 },
};
static convert_t iso8859_4[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 260 },
	{ 162, 312 },
	{ 163, 342 },
	{ 164, 164 },
	{ 165, 296 },
	{ 166, 315 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 352 },
	{ 170, 274 },
	{ 171, 290 },
	{ 172, 358 },
	{ 173, 173 },
	{ 174, 381 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 261 },
	{ 178, 731 },
	{ 179, 343 },
	{ 180, 180 },
	{ 181, 297 },
	{ 182, 316 },
	{ 183, 711 },
	{ 184, 184 },
	{ 185, 353 },
	{ 186, 275 },
	{ 187, 291 },
	{ 188, 359 },
	{ 189, 330 },
	{ 190, 382 },
	{ 191, 331 },
	{ 192, 256 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 302 },
	{ 200, 268 },
	{ 201, 201 },
	{ 202, 280 },
	{ 203, 203 },
	{ 204, 278 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 298 },
	{ 208, 272 },
	{ 209, 325 },
	{ 210, 332 },
	{ 211, 310 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 370 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 360 },
	{ 222, 362 },
	{ 223, 223 },
	{ 224, 257 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 303 },
	{ 232, 269 },
	{ 233, 233 },
	{ 234, 281 },
	{ 235, 235 },
	{ 236, 279 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 299 },
	{ 240, 273 },
	{ 241, 326 },
	{ 242, 333 },
	{ 243, 311 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 371 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 361 },
	{ 254, 363 },
	{ 255, 729 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 258 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 259 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 202 },
	{ 69, 276 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 234 },
	{ 101, 277 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 207 },
	{ 73, 300 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 239 },
	{ 105, 301 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 488 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 122, 378 },
	{ 122, 380 },
};
static convert_t iso8859_5[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 1025 },
	{ 162, 1026 },
	{ 163, 1027 },
	{ 164, 1028 },
	{ 165, 1029 },
	{ 166, 1030 },
	{ 167, 1031 },
	{ 168, 1032 },
	{ 169, 1033 },
	{ 170, 1034 },
	{ 171, 1035 },
	{ 172, 1036 },
	{ 173, 173 },
	{ 174, 1038 },
	{ 175, 1039 },
	{ 176, 1040 },
	{ 177, 1041 },
	{ 178, 1042 },
	{ 179, 1043 },
	{ 180, 1044 },
	{ 181, 1045 },
	{ 182, 1046 },
	{ 183, 1047 },
	{ 184, 1048 },
	{ 185, 1049 },
	{ 186, 1050 },
	{ 187, 1051 },
	{ 188, 1052 },
	{ 189, 1053 },
	{ 190, 1054 },
	{ 191, 1055 },
	{ 192, 1056 },
	{ 193, 1057 },
	{ 194, 1058 },
	{ 195, 1059 },
	{ 196, 1060 },
	{ 197, 1061 },
	{ 198, 1062 },
	{ 199, 1063 },
	{ 200, 1064 },
	{ 201, 1065 },
	{ 202, 1066 },
	{ 203, 1067 },
	{ 204, 1068 },
	{ 205, 1069 },
	{ 206, 1070 },
	{ 207, 1071 },
	{ 208, 1072 },
	{ 209, 1073 },
	{ 210, 1074 },
	{ 211, 1075 },
	{ 212, 1076 },
	{ 213, 1077 },
	{ 214, 1078 },
	{ 215, 1079 },
	{ 216, 1080 },
	{ 217, 1081 },
	{ 218, 1082 },
	{ 219, 1083 },
	{ 220, 1084 },
	{ 221, 1085 },
	{ 222, 1086 },
	{ 223, 1087 },
	{ 224, 1088 },
	{ 225, 1089 },
	{ 226, 1090 },
	{ 227, 1091 },
	{ 228, 1092 },
	{ 229, 1093 },
	{ 230, 1094 },
	{ 231, 1095 },
	{ 232, 1096 },
	{ 233, 1097 },
	{ 234, 1098 },
	{ 235, 1099 },
	{ 236, 1100 },
	{ 237, 1101 },
	{ 238, 1102 },
	{ 239, 1103 },
	{ 240, 8470 },
	{ 241, 1105 },
	{ 242, 1106 },
	{ 243, 1107 },
	{ 244, 1108 },
	{ 245, 1109 },
	{ 246, 1110 },
	{ 247, 1111 },
	{ 248, 1112 },
	{ 249, 1113 },
	{ 250, 1114 },
	{ 251, 1115 },
	{ 252, 1116 },
	{ 253, 167 },
	{ 254, 1118 },
	{ 255, 1119 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 244 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 220 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 252 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso8859_6[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 1548 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 1563 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 1567 },
	{ 192, 192 },
	{ 193, 1569 },
	{ 194, 1570 },
	{ 195, 1571 },
	{ 196, 1572 },
	{ 197, 1573 },
	{ 198, 1574 },
	{ 199, 1575 },
	{ 200, 1576 },
	{ 201, 1577 },
	{ 202, 1578 },
	{ 203, 1579 },
	{ 204, 1580 },
	{ 205, 1581 },
	{ 206, 1582 },
	{ 207, 1583 },
	{ 208, 1584 },
	{ 209, 1585 },
	{ 210, 1586 },
	{ 211, 1587 },
	{ 212, 1588 },
	{ 213, 1589 },
	{ 214, 1590 },
	{ 215, 1591 },
	{ 216, 1592 },
	{ 217, 1593 },
	{ 218, 1594 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 1600 },
	{ 225, 1601 },
	{ 226, 1602 },
	{ 227, 1603 },
	{ 228, 1604 },
	{ 229, 1605 },
	{ 230, 1606 },
	{ 231, 1607 },
	{ 232, 1608 },
	{ 233, 1609 },
	{ 234, 1610 },
	{ 235, 1611 },
	{ 236, 1612 },
	{ 237, 1613 },
	{ 238, 1614 },
	{ 239, 1615 },
	{ 240, 1616 },
	{ 241, 1617 },
	{ 242, 1618 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso8859_7[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 8216 },
	{ 162, 8217 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 8213 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 900 },
	{ 181, 901 },
	{ 182, 902 },
	{ 183, 183 },
	{ 184, 904 },
	{ 185, 905 },
	{ 186, 906 },
	{ 187, 187 },
	{ 188, 908 },
	{ 189, 189 },
	{ 190, 910 },
	{ 191, 911 },
	{ 192, 912 },
	{ 193, 913 },
	{ 194, 914 },
	{ 195, 915 },
	{ 196, 916 },
	{ 197, 917 },
	{ 198, 918 },
	{ 199, 919 },
	{ 200, 920 },
	{ 201, 921 },
	{ 202, 922 },
	{ 203, 923 },
	{ 204, 924 },
	{ 205, 925 },
	{ 206, 926 },
	{ 207, 927 },
	{ 208, 928 },
	{ 209, 929 },
	{ 210, 210 },
	{ 211, 931 },
	{ 212, 932 },
	{ 213, 933 },
	{ 214, 934 },
	{ 215, 935 },
	{ 216, 936 },
	{ 217, 937 },
	{ 218, 938 },
	{ 219, 939 },
	{ 220, 940 },
	{ 221, 941 },
	{ 222, 942 },
	{ 223, 943 },
	{ 224, 944 },
	{ 225, 945 },
	{ 226, 946 },
	{ 227, 947 },
	{ 228, 948 },
	{ 229, 949 },
	{ 230, 950 },
	{ 231, 951 },
	{ 232, 952 },
	{ 233, 953 },
	{ 234, 954 },
	{ 235, 955 },
	{ 236, 956 },
	{ 237, 957 },
	{ 238, 958 },
	{ 239, 959 },
	{ 240, 960 },
	{ 241, 961 },
	{ 242, 962 },
	{ 243, 963 },
	{ 244, 964 },
	{ 245, 965 },
	{ 246, 966 },
	{ 247, 967 },
	{ 248, 968 },
	{ 249, 969 },
	{ 250, 970 },
	{ 251, 971 },
	{ 252, 972 },
	{ 253, 973 },
	{ 254, 974 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 244 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 220 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 252 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso8859_8[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 215 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 247 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 8215 },
	{ 224, 1488 },
	{ 225, 1489 },
	{ 226, 1490 },
	{ 227, 1491 },
	{ 228, 1492 },
	{ 229, 1493 },
	{ 230, 1494 },
	{ 231, 1495 },
	{ 232, 1496 },
	{ 233, 1497 },
	{ 234, 1498 },
	{ 235, 1499 },
	{ 236, 1500 },
	{ 237, 1501 },
	{ 238, 1502 },
	{ 239, 1503 },
	{ 240, 1504 },
	{ 241, 1505 },
	{ 242, 1506 },
	{ 243, 1507 },
	{ 244, 1508 },
	{ 245, 1509 },
	{ 246, 1510 },
	{ 247, 1511 },
	{ 248, 1512 },
	{ 249, 1513 },
	{ 250, 1514 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 8206 },
	{ 254, 8207 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 244 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso8859_9[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 180 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 184 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 286 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 304 },
	{ 222, 350 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 287 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 305 },
	{ 254, 351 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso8859_10[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 260 },
	{ 162, 274 },
	{ 163, 290 },
	{ 164, 298 },
	{ 165, 296 },
	{ 166, 310 },
	{ 167, 167 },
	{ 168, 315 },
	{ 169, 272 },
	{ 170, 352 },
	{ 171, 358 },
	{ 172, 381 },
	{ 173, 173 },
	{ 174, 362 },
	{ 175, 330 },
	{ 176, 176 },
	{ 177, 261 },
	{ 178, 275 },
	{ 179, 291 },
	{ 180, 299 },
	{ 181, 297 },
	{ 182, 311 },
	{ 183, 183 },
	{ 184, 316 },
	{ 185, 273 },
	{ 186, 353 },
	{ 187, 359 },
	{ 188, 382 },
	{ 189, 8213 },
	{ 190, 363 },
	{ 191, 331 },
	{ 192, 256 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 302 },
	{ 200, 268 },
	{ 201, 201 },
	{ 202, 280 },
	{ 203, 203 },
	{ 204, 278 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 325 },
	{ 210, 332 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 360 },
	{ 216, 216 },
	{ 217, 370 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 257 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 303 },
	{ 232, 269 },
	{ 233, 233 },
	{ 234, 281 },
	{ 235, 235 },
	{ 236, 279 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 326 },
	{ 242, 333 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 361 },
	{ 248, 248 },
	{ 249, 371 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 312 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 258 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 259 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 202 },
	{ 69, 276 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 234 },
	{ 101, 277 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 300 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 301 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 488 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 122, 378 },
	{ 122, 380 },
};
static convert_t iso8859_11[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 3585 },
	{ 162, 3586 },
	{ 163, 3587 },
	{ 164, 3588 },
	{ 165, 3589 },
	{ 166, 3590 },
	{ 167, 3591 },
	{ 168, 3592 },
	{ 169, 3593 },
	{ 170, 3594 },
	{ 171, 3595 },
	{ 172, 3596 },
	{ 173, 3597 },
	{ 174, 3598 },
	{ 175, 3599 },
	{ 176, 3600 },
	{ 177, 3601 },
	{ 178, 3602 },
	{ 179, 3603 },
	{ 180, 3604 },
	{ 181, 3605 },
	{ 182, 3606 },
	{ 183, 3607 },
	{ 184, 3608 },
	{ 185, 3609 },
	{ 186, 3610 },
	{ 187, 3611 },
	{ 188, 3612 },
	{ 189, 3613 },
	{ 190, 3614 },
	{ 191, 3615 },
	{ 192, 3616 },
	{ 193, 3617 },
	{ 194, 3618 },
	{ 195, 3619 },
	{ 196, 3620 },
	{ 197, 3621 },
	{ 198, 3622 },
	{ 199, 3623 },
	{ 200, 3624 },
	{ 201, 3625 },
	{ 202, 3626 },
	{ 203, 3627 },
	{ 204, 3628 },
	{ 205, 3629 },
	{ 206, 3630 },
	{ 207, 3631 },
	{ 208, 3632 },
	{ 209, 3633 },
	{ 210, 3634 },
	{ 211, 3635 },
	{ 212, 3636 },
	{ 213, 3637 },
	{ 214, 3638 },
	{ 215, 3639 },
	{ 216, 3640 },
	{ 217, 3641 },
	{ 218, 3642 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 3647 },
	{ 224, 3648 },
	{ 225, 3649 },
	{ 226, 3650 },
	{ 227, 3651 },
	{ 228, 3652 },
	{ 229, 3653 },
	{ 230, 3654 },
	{ 231, 3655 },
	{ 232, 3656 },
	{ 233, 3657 },
	{ 234, 3658 },
	{ 235, 3659 },
	{ 236, 3660 },
	{ 237, 3661 },
	{ 238, 3662 },
	{ 239, 3663 },
	{ 240, 3664 },
	{ 241, 3665 },
	{ 242, 3666 },
	{ 243, 3667 },
	{ 244, 3668 },
	{ 245, 3669 },
	{ 246, 3670 },
	{ 247, 3671 },
	{ 248, 3672 },
	{ 249, 3673 },
	{ 250, 3674 },
	{ 251, 3675 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 244 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso8859_13[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 8221 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 8222 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 216 },
	{ 169, 169 },
	{ 170, 342 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 198 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 8220 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 248 },
	{ 185, 185 },
	{ 186, 343 },
	{ 187, 187 },
	{ 188, 188 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 230 },
	{ 192, 260 },
	{ 193, 302 },
	{ 194, 256 },
	{ 195, 262 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 280 },
	{ 199, 274 },
	{ 200, 268 },
	{ 201, 201 },
	{ 202, 377 },
	{ 203, 278 },
	{ 204, 290 },
	{ 205, 310 },
	{ 206, 298 },
	{ 207, 315 },
	{ 208, 352 },
	{ 209, 323 },
	{ 210, 325 },
	{ 211, 211 },
	{ 212, 332 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 370 },
	{ 217, 321 },
	{ 218, 346 },
	{ 219, 362 },
	{ 220, 220 },
	{ 221, 379 },
	{ 222, 381 },
	{ 223, 223 },
	{ 224, 261 },
	{ 225, 303 },
	{ 226, 257 },
	{ 227, 263 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 281 },
	{ 231, 275 },
	{ 232, 269 },
	{ 233, 233 },
	{ 234, 378 },
	{ 235, 279 },
	{ 236, 291 },
	{ 237, 311 },
	{ 238, 299 },
	{ 239, 316 },
	{ 240, 353 },
	{ 241, 324 },
	{ 242, 326 },
	{ 243, 243 },
	{ 244, 333 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 371 },
	{ 249, 322 },
	{ 250, 347 },
	{ 251, 363 },
	{ 252, 252 },
	{ 253, 380 },
	{ 254, 382 },
	{ 255, 8217 },
	{ 39, 8216 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 258 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 259 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 264 },
	{ 67, 266 },
	{ 99, 231 },
	{ 99, 265 },
	{ 99, 267 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 276 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 277 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 300 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 301 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 488 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 317 },
	{ 76, 319 },
	{ 108, 314 },
	{ 108, 318 },
	{ 108, 320 },
	{ 77, 209 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 212 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 244 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 345 },
	{ 83, 348 },
	{ 83, 350 },
	{ 115, 349 },
	{ 115, 351 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 360 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 361 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
};
static convert_t iso8859_14[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 7682 },
	{ 162, 7683 },
	{ 163, 163 },
	{ 164, 266 },
	{ 165, 267 },
	{ 166, 7690 },
	{ 167, 167 },
	{ 168, 7808 },
	{ 169, 169 },
	{ 170, 7810 },
	{ 171, 7691 },
	{ 172, 7922 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 376 },
	{ 176, 7710 },
	{ 177, 7711 },
	{ 178, 288 },
	{ 179, 289 },
	{ 180, 7744 },
	{ 181, 7745 },
	{ 182, 182 },
	{ 183, 7766 },
	{ 184, 7809 },
	{ 185, 7767 },
	{ 186, 7811 },
	{ 187, 7776 },
	{ 188, 7923 },
	{ 189, 7812 },
	{ 190, 7813 },
	{ 191, 7777 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 372 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 7786 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 374 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 373 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 7787 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 375 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t iso8859_15[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 8364 },
	{ 165, 165 },
	{ 166, 352 },
	{ 167, 167 },
	{ 168, 353 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 178 },
	{ 179, 179 },
	{ 180, 381 },
	{ 181, 181 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 382 },
	{ 185, 185 },
	{ 186, 186 },
	{ 187, 187 },
	{ 188, 338 },
	{ 189, 339 },
	{ 190, 376 },
	{ 191, 191 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 215 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 122, 378 },
	{ 122, 380 },
};
static convert_t iso8859_16[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 260 },
	{ 162, 261 },
	{ 163, 321 },
	{ 164, 8364 },
	{ 165, 8222 },
	{ 166, 352 },
	{ 167, 167 },
	{ 168, 353 },
	{ 169, 169 },
	{ 170, 536 },
	{ 171, 171 },
	{ 172, 377 },
	{ 173, 173 },
	{ 174, 378 },
	{ 175, 379 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 268 },
	{ 179, 322 },
	{ 180, 381 },
	{ 181, 8221 },
	{ 182, 182 },
	{ 183, 183 },
	{ 184, 382 },
	{ 185, 269 },
	{ 186, 537 },
	{ 187, 187 },
	{ 188, 338 },
	{ 189, 339 },
	{ 190, 376 },
	{ 191, 380 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 258 },
	{ 196, 196 },
	{ 197, 262 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 272 },
	{ 209, 323 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 336 },
	{ 214, 214 },
	{ 215, 346 },
	{ 216, 368 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 280 },
	{ 222, 538 },
	{ 223, 223 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 259 },
	{ 228, 228 },
	{ 229, 263 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 273 },
	{ 241, 324 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 337 },
	{ 246, 246 },
	{ 247, 347 },
	{ 248, 369 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 281 },
	{ 254, 539 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 195 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 461 },
	{ 97, 227 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 462 },
	{ 67, 264 },
	{ 67, 266 },
	{ 99, 265 },
	{ 99, 267 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 77, 209 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 213 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 245 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 348 },
	{ 83, 350 },
	{ 115, 349 },
	{ 115, 351 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 121, 253 },
	{ 121, 375 },
};
static convert_t koi8_r[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 9472 },
	{ 129, 9474 },
	{ 130, 9484 },
	{ 131, 9488 },
	{ 132, 9492 },
	{ 133, 9496 },
	{ 134, 9500 },
	{ 135, 9508 },
	{ 136, 9516 },
	{ 137, 9524 },
	{ 138, 9532 },
	{ 139, 9600 },
	{ 140, 9604 },
	{ 141, 9608 },
	{ 142, 9612 },
	{ 143, 9616 },
	{ 144, 9617 },
	{ 145, 9618 },
	{ 146, 9619 },
	{ 147, 8992 },
	{ 148, 9632 },
	{ 149, 8729 },
	{ 150, 8730 },
	{ 151, 8776 },
	{ 152, 8804 },
	{ 153, 8805 },
	{ 154, 160 },
	{ 155, 8993 },
	{ 156, 176 },
	{ 157, 178 },
	{ 158, 183 },
	{ 159, 247 },
	{ 160, 9552 },
	{ 161, 9553 },
	{ 162, 9554 },
	{ 163, 1105 },
	{ 164, 9555 },
	{ 165, 9556 },
	{ 166, 9557 },
	{ 167, 9558 },
	{ 168, 9559 },
	{ 169, 9560 },
	{ 170, 9561 },
	{ 171, 9562 },
	{ 172, 9563 },
	{ 173, 9564 },
	{ 174, 9565 },
	{ 175, 9566 },
	{ 176, 9567 },
	{ 177, 9568 },
	{ 178, 9569 },
	{ 179, 1025 },
	{ 180, 9570 },
	{ 181, 9571 },
	{ 182, 9572 },
	{ 183, 9573 },
	{ 184, 9574 },
	{ 185, 9575 },
	{ 186, 9576 },
	{ 187, 9577 },
	{ 188, 9578 },
	{ 189, 9579 },
	{ 190, 9580 },
	{ 191, 169 },
	{ 192, 1102 },
	{ 193, 1072 },
	{ 194, 1073 },
	{ 195, 1094 },
	{ 196, 1076 },
	{ 197, 1077 },
	{ 198, 1092 },
	{ 199, 1075 },
	{ 200, 1093 },
	{ 201, 1080 },
	{ 202, 1081 },
	{ 203, 1082 },
	{ 204, 1083 },
	{ 205, 1084 },
	{ 206, 1085 },
	{ 207, 1086 },
	{ 208, 1087 },
	{ 209, 1103 },
	{ 210, 1088 },
	{ 211, 1089 },
	{ 212, 1090 },
	{ 213, 1091 },
	{ 214, 1078 },
	{ 215, 1074 },
	{ 216, 1100 },
	{ 217, 1099 },
	{ 218, 1079 },
	{ 219, 1096 },
	{ 220, 1101 },
	{ 221, 1097 },
	{ 222, 1095 },
	{ 223, 1098 },
	{ 224, 1070 },
	{ 225, 1040 },
	{ 226, 1041 },
	{ 227, 1062 },
	{ 228, 1044 },
	{ 229, 1045 },
	{ 230, 1060 },
	{ 231, 1043 },
	{ 232, 1061 },
	{ 233, 1048 },
	{ 234, 1049 },
	{ 235, 1050 },
	{ 236, 1051 },
	{ 237, 1052 },
	{ 238, 1053 },
	{ 239, 1054 },
	{ 240, 1055 },
	{ 241, 1071 },
	{ 242, 1056 },
	{ 243, 1057 },
	{ 244, 1058 },
	{ 245, 1059 },
	{ 246, 1046 },
	{ 247, 1042 },
	{ 248, 1068 },
	{ 249, 1067 },
	{ 250, 1047 },
	{ 251, 1064 },
	{ 252, 1069 },
	{ 253, 1065 },
	{ 254, 1063 },
	{ 255, 1066 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 244 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 220 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 252 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t koi8_u[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 9472 },
	{ 129, 9474 },
	{ 130, 9484 },
	{ 131, 9488 },
	{ 132, 9492 },
	{ 133, 9496 },
	{ 134, 9500 },
	{ 135, 9508 },
	{ 136, 9516 },
	{ 137, 9524 },
	{ 138, 9532 },
	{ 139, 9600 },
	{ 140, 9604 },
	{ 141, 9608 },
	{ 142, 9612 },
	{ 143, 9616 },
	{ 144, 9617 },
	{ 145, 9618 },
	{ 146, 9619 },
	{ 147, 8992 },
	{ 148, 9632 },
	{ 149, 8729 },
	{ 150, 8730 },
	{ 151, 8776 },
	{ 152, 8804 },
	{ 153, 8805 },
	{ 154, 160 },
	{ 155, 8993 },
	{ 156, 176 },
	{ 157, 178 },
	{ 158, 183 },
	{ 159, 247 },
	{ 160, 9552 },
	{ 161, 9553 },
	{ 162, 9554 },
	{ 163, 1105 },
	{ 164, 1108 },
	{ 165, 9556 },
	{ 166, 1110 },
	{ 167, 1111 },
	{ 168, 9559 },
	{ 169, 9560 },
	{ 170, 9561 },
	{ 171, 9562 },
	{ 172, 9563 },
	{ 173, 1169 },
	{ 174, 9565 },
	{ 175, 9566 },
	{ 176, 9567 },
	{ 177, 9568 },
	{ 178, 9569 },
	{ 179, 1025 },
	{ 180, 1028 },
	{ 181, 9571 },
	{ 182, 1030 },
	{ 183, 1031 },
	{ 184, 9574 },
	{ 185, 9575 },
	{ 186, 9576 },
	{ 187, 9577 },
	{ 188, 9578 },
	{ 189, 1168 },
	{ 190, 9580 },
	{ 191, 169 },
	{ 192, 1102 },
	{ 193, 1072 },
	{ 194, 1073 },
	{ 195, 1094 },
	{ 196, 1076 },
	{ 197, 1077 },
	{ 198, 1092 },
	{ 199, 1075 },
	{ 200, 1093 },
	{ 201, 1080 },
	{ 202, 1081 },
	{ 203, 1082 },
	{ 204, 1083 },
	{ 205, 1084 },
	{ 206, 1085 },
	{ 207, 1086 },
	{ 208, 1087 },
	{ 209, 1103 },
	{ 210, 1088 },
	{ 211, 1089 },
	{ 212, 1090 },
	{ 213, 1091 },
	{ 214, 1078 },
	{ 215, 1074 },
	{ 216, 1100 },
	{ 217, 1099 },
	{ 218, 1079 },
	{ 219, 1096 },
	{ 220, 1101 },
	{ 221, 1097 },
	{ 222, 1095 },
	{ 223, 1098 },
	{ 224, 1070 },
	{ 225, 1040 },
	{ 226, 1041 },
	{ 227, 1062 },
	{ 228, 1044 },
	{ 229, 1045 },
	{ 230, 1060 },
	{ 231, 1043 },
	{ 232, 1061 },
	{ 233, 1048 },
	{ 234, 1049 },
	{ 235, 1050 },
	{ 236, 1051 },
	{ 237, 1052 },
	{ 238, 1053 },
	{ 239, 1054 },
	{ 240, 1055 },
	{ 241, 1071 },
	{ 242, 1056 },
	{ 243, 1057 },
	{ 244, 1058 },
	{ 245, 1059 },
	{ 246, 1046 },
	{ 247, 1042 },
	{ 248, 1068 },
	{ 249, 1067 },
	{ 250, 1047 },
	{ 251, 1064 },
	{ 252, 1069 },
	{ 253, 1065 },
	{ 254, 1063 },
	{ 255, 1066 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 224 },
	{ 97, 225 },
	{ 97, 226 },
	{ 97, 227 },
	{ 97, 228 },
	{ 97, 229 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 231 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 232 },
	{ 101, 233 },
	{ 101, 234 },
	{ 101, 235 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 236 },
	{ 105, 237 },
	{ 105, 238 },
	{ 105, 239 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 241 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 242 },
	{ 110, 243 },
	{ 110, 244 },
	{ 110, 245 },
	{ 110, 246 },
	{ 110, 248 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 220 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 249 },
	{ 117, 250 },
	{ 117, 251 },
	{ 117, 252 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 253 },
	{ 121, 255 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t mslinedr[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 164 },
	{ 165, 165 },
	{ 166, 166 },
	{ 167, 167 },
	{ 168, 168 },
	{ 169, 169 },
	{ 170, 170 },
	{ 171, 171 },
	{ 172, 172 },
	{ 173, 173 },
	{ 174, 174 },
	{ 175, 175 },
	{ 176, 9639 },
	{ 177, 9638 },
	{ 178, 9640 },
	{ 179, 9474 },
	{ 180, 9508 },
	{ 181, 9569 },
	{ 182, 9570 },
	{ 183, 9558 },
	{ 184, 9557 },
	{ 185, 9571 },
	{ 186, 9553 },
	{ 187, 9559 },
	{ 188, 9565 },
	{ 189, 9564 },
	{ 190, 9563 },
	{ 191, 9488 },
	{ 192, 9492 },
	{ 193, 9524 },
	{ 194, 9516 },
	{ 195, 9500 },
	{ 196, 9472 },
	{ 197, 9532 },
	{ 198, 9566 },
	{ 199, 9567 },
	{ 200, 9562 },
	{ 201, 9556 },
	{ 202, 9577 },
	{ 203, 9574 },
	{ 204, 9568 },
	{ 205, 9552 },
	{ 206, 9580 },
	{ 207, 9575 },
	{ 208, 9576 },
	{ 209, 9572 },
	{ 210, 9573 },
	{ 211, 9561 },
	{ 212, 9560 },
	{ 213, 9554 },
	{ 214, 9555 },
	{ 215, 9579 },
	{ 216, 9578 },
	{ 217, 9496 },
	{ 218, 9484 },
	{ 219, 9608 },
	{ 220, 9604 },
	{ 221, 9612 },
	{ 222, 9616 },
	{ 223, 9600 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 192 },
	{ 65, 193 },
	{ 65, 194 },
	{ 65, 195 },
	{ 65, 196 },
	{ 65, 197 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 199 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 200 },
	{ 69, 201 },
	{ 69, 202 },
	{ 69, 203 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 204 },
	{ 73, 205 },
	{ 73, 206 },
	{ 73, 207 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 76, 321 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 108, 322 },
	{ 77, 209 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 210 },
	{ 78, 211 },
	{ 78, 212 },
	{ 78, 213 },
	{ 78, 214 },
	{ 78, 216 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 217 },
	{ 85, 218 },
	{ 85, 219 },
	{ 85, 220 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 221 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t nextstep[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 160 },
	{ 129, 192 },
	{ 130, 193 },
	{ 131, 194 },
	{ 132, 195 },
	{ 133, 196 },
	{ 134, 197 },
	{ 135, 199 },
	{ 136, 200 },
	{ 137, 201 },
	{ 138, 202 },
	{ 139, 203 },
	{ 140, 204 },
	{ 141, 205 },
	{ 142, 206 },
	{ 143, 207 },
	{ 144, 208 },
	{ 145, 209 },
	{ 146, 210 },
	{ 147, 211 },
	{ 148, 212 },
	{ 149, 213 },
	{ 150, 214 },
	{ 151, 217 },
	{ 152, 218 },
	{ 153, 219 },
	{ 154, 220 },
	{ 155, 221 },
	{ 156, 222 },
	{ 157, 181 },
	{ 158, 215 },
	{ 159, 247 },
	{ 160, 169 },
	{ 161, 161 },
	{ 162, 162 },
	{ 163, 163 },
	{ 164, 8260 },
	{ 165, 165 },
	{ 166, 402 },
	{ 167, 167 },
	{ 168, 164 },
	{ 169, 169 },
	{ 170, 8220 },
	{ 171, 171 },
	{ 172, 8249 },
	{ 173, 8250 },
	{ 174, 64257 },
	{ 175, 64258 },
	{ 176, 174 },
	{ 177, 8211 },
	{ 178, 8224 },
	{ 179, 8225 },
	{ 180, 183 },
	{ 181, 166 },
	{ 182, 182 },
	{ 183, 8729 },
	{ 184, 8218 },
	{ 185, 8222 },
	{ 186, 8221 },
	{ 187, 187 },
	{ 188, 8943 },
	{ 189, 8240 },
	{ 190, 172 },
	{ 191, 191 },
	{ 192, 185 },
	{ 193, 768 },
	{ 194, 180 },
	{ 195, 770 },
	{ 196, 771 },
	{ 197, 175 },
	{ 198, 728 },
	{ 199, 729 },
	{ 200, 168 },
	{ 201, 178 },
	{ 202, 176 },
	{ 203, 184 },
	{ 204, 179 },
	{ 205, 733 },
	{ 206, 731 },
	{ 207, 711 },
	{ 208, 8212 },
	{ 209, 177 },
	{ 210, 188 },
	{ 211, 189 },
	{ 212, 190 },
	{ 213, 224 },
	{ 214, 225 },
	{ 215, 226 },
	{ 216, 227 },
	{ 217, 228 },
	{ 218, 229 },
	{ 219, 231 },
	{ 220, 232 },
	{ 221, 233 },
	{ 222, 234 },
	{ 223, 235 },
	{ 224, 236 },
	{ 225, 198 },
	{ 226, 237 },
	{ 227, 170 },
	{ 228, 238 },
	{ 229, 239 },
	{ 230, 240 },
	{ 231, 241 },
	{ 232, 321 },
	{ 233, 216 },
	{ 234, 338 },
	{ 235, 186 },
	{ 236, 242 },
	{ 237, 243 },
	{ 238, 244 },
	{ 239, 245 },
	{ 240, 246 },
	{ 241, 230 },
	{ 242, 249 },
	{ 243, 250 },
	{ 244, 251 },
	{ 245, 305 },
	{ 246, 252 },
	{ 247, 253 },
	{ 248, 322 },
	{ 249, 248 },
	{ 250, 339 },
	{ 251, 223 },
	{ 252, 254 },
	{ 253, 255 },
	{ 254, 254 },
	{ 255, 255 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 258 },
	{ 65, 260 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 259 },
	{ 97, 261 },
	{ 97, 462 },
	{ 67, 262 },
	{ 67, 264 },
	{ 67, 266 },
	{ 67, 268 },
	{ 99, 263 },
	{ 99, 265 },
	{ 99, 267 },
	{ 99, 269 },
	{ 68, 270 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 69, 280 },
	{ 69, 282 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 101, 281 },
	{ 101, 283 },
	{ 71, 284 },
	{ 71, 286 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 287 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 304 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 313 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 108, 314 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 77, 323 },
	{ 77, 325 },
	{ 77, 327 },
	{ 109, 324 },
	{ 109, 326 },
	{ 109, 328 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 336 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 337 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 340 },
	{ 82, 342 },
	{ 82, 344 },
	{ 114, 341 },
	{ 114, 343 },
	{ 114, 345 },
	{ 83, 346 },
	{ 83, 348 },
	{ 83, 350 },
	{ 83, 352 },
	{ 115, 347 },
	{ 115, 349 },
	{ 115, 351 },
	{ 115, 353 },
	{ 84, 354 },
	{ 84, 356 },
	{ 116, 355 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 366 },
	{ 85, 368 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 367 },
	{ 117, 369 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 89, 376 },
	{ 121, 375 },
	{ 90, 377 },
	{ 90, 379 },
	{ 90, 381 },
	{ 122, 378 },
	{ 122, 380 },
	{ 122, 382 },
};
static convert_t symbol[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 8704 },
	{ 35, 35 },
	{ 36, 8707 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 8715 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 8727 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 8722 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 8773 },
	{ 65, 913 },
	{ 66, 914 },
	{ 67, 935 },
	{ 68, 916 },
	{ 69, 917 },
	{ 70, 934 },
	{ 71, 915 },
	{ 72, 919 },
	{ 73, 921 },
	{ 74, 977 },
	{ 75, 922 },
	{ 76, 923 },
	{ 77, 924 },
	{ 78, 925 },
	{ 79, 927 },
	{ 80, 928 },
	{ 81, 920 },
	{ 82, 929 },
	{ 83, 931 },
	{ 84, 932 },
	{ 85, 933 },
	{ 86, 962 },
	{ 87, 937 },
	{ 88, 926 },
	{ 89, 936 },
	{ 90, 918 },
	{ 91, 91 },
	{ 92, 8756 },
	{ 93, 93 },
	{ 94, 8869 },
	{ 95, 95 },
	{ 96, 8254 },
	{ 97, 945 },
	{ 98, 946 },
	{ 99, 967 },
	{ 100, 948 },
	{ 101, 949 },
	{ 102, 966 },
	{ 103, 947 },
	{ 104, 951 },
	{ 105, 953 },
	{ 106, 981 },
	{ 107, 954 },
	{ 108, 955 },
	{ 109, 956 },
	{ 110, 957 },
	{ 111, 959 },
	{ 112, 960 },
	{ 113, 952 },
	{ 114, 961 },
	{ 115, 963 },
	{ 116, 964 },
	{ 117, 965 },
	{ 118, 982 },
	{ 119, 969 },
	{ 120, 958 },
	{ 121, 968 },
	{ 122, 950 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 8764 },
	{ 127, 127 },
	{ 128, 128 },
	{ 129, 129 },
	{ 130, 130 },
	{ 131, 131 },
	{ 132, 132 },
	{ 133, 133 },
	{ 134, 134 },
	{ 135, 135 },
	{ 136, 136 },
	{ 137, 137 },
	{ 138, 138 },
	{ 139, 139 },
	{ 140, 140 },
	{ 141, 141 },
	{ 142, 142 },
	{ 143, 143 },
	{ 144, 144 },
	{ 145, 145 },
	{ 146, 146 },
	{ 147, 147 },
	{ 148, 148 },
	{ 149, 149 },
	{ 150, 150 },
	{ 151, 151 },
	{ 152, 152 },
	{ 153, 153 },
	{ 154, 154 },
	{ 155, 155 },
	{ 156, 156 },
	{ 157, 157 },
	{ 158, 158 },
	{ 159, 159 },
	{ 160, 160 },
	{ 161, 978 },
	{ 162, 8242 },
	{ 163, 8804 },
	{ 164, 8725 },
	{ 165, 8734 },
	{ 166, 402 },
	{ 167, 9827 },
	{ 168, 9830 },
	{ 169, 9829 },
	{ 170, 9824 },
	{ 171, 8596 },
	{ 172, 8592 },
	{ 173, 8593 },
	{ 174, 8594 },
	{ 175, 8595 },
	{ 176, 176 },
	{ 177, 177 },
	{ 178, 8243 },
	{ 179, 8805 },
	{ 180, 215 },
	{ 181, 8733 },
	{ 182, 8706 },
	{ 183, 8729 },
	{ 184, 247 },
	{ 185, 8800 },
	{ 186, 8801 },
	{ 187, 8776 },
	{ 188, 8943 },
	{ 189, 189 },
	{ 190, 190 },
	{ 191, 8629 },
	{ 192, 192 },
	{ 193, 8465 },
	{ 194, 8476 },
	{ 195, 8472 },
	{ 196, 8855 },
	{ 197, 8853 },
	{ 198, 8709 },
	{ 199, 8745 },
	{ 200, 8746 },
	{ 201, 8835 },
	{ 202, 8839 },
	{ 203, 8836 },
	{ 204, 8834 },
	{ 205, 8838 },
	{ 206, 8712 },
	{ 207, 8713 },
	{ 208, 8736 },
	{ 209, 8711 },
	{ 210, 174 },
	{ 211, 169 },
	{ 212, 8482 },
	{ 213, 8719 },
	{ 214, 8730 },
	{ 215, 8901 },
	{ 216, 172 },
	{ 217, 8743 },
	{ 218, 8744 },
	{ 219, 8660 },
	{ 220, 8656 },
	{ 221, 8657 },
	{ 222, 8658 },
	{ 223, 8659 },
	{ 224, 9674 },
	{ 225, 9001 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 8721 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 9002 },
	{ 242, 8747 },
	{ 243, 8992 },
	{ 244, 244 },
	{ 245, 8993 },
	{ 246, 246 },
	{ 247, 247 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 255 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 192, 65 },
	{ 192, 193 },
	{ 192, 194 },
	{ 192, 195 },
	{ 192, 196 },
	{ 192, 197 },
	{ 192, 256 },
	{ 192, 258 },
	{ 192, 260 },
	{ 192, 461 },
	{ 226, 97 },
	{ 226, 224 },
	{ 226, 225 },
	{ 226, 229 },
	{ 226, 257 },
	{ 226, 259 },
	{ 226, 261 },
	{ 226, 462 },
	{ 231, 99 },
	{ 231, 263 },
	{ 231, 265 },
	{ 231, 267 },
	{ 231, 269 },
	{ 232, 101 },
	{ 232, 275 },
	{ 232, 277 },
	{ 232, 279 },
	{ 232, 281 },
	{ 232, 283 },
	{ 236, 105 },
	{ 236, 297 },
	{ 236, 299 },
	{ 236, 301 },
	{ 236, 303 },
	{ 236, 305 },
	{ 236, 464 },
	{ 244, 110 },
	{ 244, 242 },
	{ 244, 243 },
	{ 244, 245 },
	{ 244, 333 },
	{ 244, 335 },
	{ 244, 337 },
	{ 244, 466 },
	{ 244, 491 },
	{ 249, 117 },
	{ 249, 361 },
	{ 249, 363 },
	{ 249, 365 },
	{ 249, 367 },
	{ 249, 369 },
	{ 249, 371 },
	{ 249, 468 },
	{ 253, 121 },
	{ 253, 375 },
};
static convert_t tex_dcr_in[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 258 },
	{ 129, 260 },
	{ 130, 262 },
	{ 131, 268 },
	{ 132, 270 },
	{ 133, 282 },
	{ 134, 280 },
	{ 135, 286 },
	{ 136, 313 },
	{ 137, 65534 },
	{ 138, 321 },
	{ 139, 323 },
	{ 140, 327 },
	{ 141, 330 },
	{ 142, 336 },
	{ 143, 340 },
	{ 144, 344 },
	{ 145, 346 },
	{ 146, 352 },
	{ 147, 350 },
	{ 148, 356 },
	{ 149, 354 },
	{ 150, 368 },
	{ 151, 366 },
	{ 152, 376 },
	{ 153, 377 },
	{ 154, 381 },
	{ 155, 379 },
	{ 156, 306 },
	{ 157, 304 },
	{ 158, 272 },
	{ 159, 167 },
	{ 160, 259 },
	{ 161, 261 },
	{ 162, 263 },
	{ 163, 269 },
	{ 164, 65534 },
	{ 165, 283 },
	{ 166, 281 },
	{ 167, 287 },
	{ 168, 314 },
	{ 169, 65534 },
	{ 170, 322 },
	{ 171, 324 },
	{ 172, 328 },
	{ 173, 331 },
	{ 174, 337 },
	{ 175, 341 },
	{ 176, 345 },
	{ 177, 347 },
	{ 178, 353 },
	{ 179, 351 },
	{ 180, 65534 },
	{ 181, 355 },
	{ 182, 369 },
	{ 183, 367 },
	{ 184, 255 },
	{ 185, 378 },
	{ 186, 382 },
	{ 187, 380 },
	{ 188, 307 },
	{ 189, 161 },
	{ 190, 191 },
	{ 191, 163 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 338 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 65534 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 339 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 223 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 462 },
	{ 67, 264 },
	{ 67, 266 },
	{ 99, 265 },
	{ 99, 267 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 71, 284 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 77, 325 },
	{ 109, 326 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 342 },
	{ 114, 343 },
	{ 83, 348 },
	{ 115, 349 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 121, 375 },
};
static convert_t tex_dcr_out[] = {
	{ 0, 0 },
	{ 1, 1 },
	{ 2, 2 },
	{ 3, 3 },
	{ 4, 4 },
	{ 5, 5 },
	{ 6, 6 },
	{ 7, 7 },
	{ 8, 8 },
	{ 9, 9 },
	{ 10, 10 },
	{ 11, 11 },
	{ 12, 12 },
	{ 13, 13 },
	{ 14, 14 },
	{ 15, 15 },
	{ 16, 16 },
	{ 17, 17 },
	{ 18, 18 },
	{ 19, 19 },
	{ 20, 20 },
	{ 21, 21 },
	{ 22, 22 },
	{ 23, 23 },
	{ 24, 24 },
	{ 25, 25 },
	{ 26, 26 },
	{ 27, 27 },
	{ 28, 28 },
	{ 29, 29 },
	{ 30, 30 },
	{ 31, 31 },
	{ 32, 32 },
	{ 33, 33 },
	{ 34, 34 },
	{ 35, 35 },
	{ 36, 36 },
	{ 37, 37 },
	{ 38, 38 },
	{ 39, 39 },
	{ 40, 40 },
	{ 41, 41 },
	{ 42, 42 },
	{ 43, 43 },
	{ 44, 44 },
	{ 45, 45 },
	{ 46, 46 },
	{ 47, 47 },
	{ 48, 48 },
	{ 49, 49 },
	{ 50, 50 },
	{ 51, 51 },
	{ 52, 52 },
	{ 53, 53 },
	{ 54, 54 },
	{ 55, 55 },
	{ 56, 56 },
	{ 57, 57 },
	{ 58, 58 },
	{ 59, 59 },
	{ 60, 60 },
	{ 61, 61 },
	{ 62, 62 },
	{ 63, 63 },
	{ 64, 64 },
	{ 65, 65 },
	{ 66, 66 },
	{ 67, 67 },
	{ 68, 68 },
	{ 69, 69 },
	{ 70, 70 },
	{ 71, 71 },
	{ 72, 72 },
	{ 73, 73 },
	{ 74, 74 },
	{ 75, 75 },
	{ 76, 76 },
	{ 77, 77 },
	{ 78, 78 },
	{ 79, 79 },
	{ 80, 80 },
	{ 81, 81 },
	{ 82, 82 },
	{ 83, 83 },
	{ 84, 84 },
	{ 85, 85 },
	{ 86, 86 },
	{ 87, 87 },
	{ 88, 88 },
	{ 89, 89 },
	{ 90, 90 },
	{ 91, 91 },
	{ 92, 92 },
	{ 93, 93 },
	{ 94, 94 },
	{ 95, 95 },
	{ 96, 96 },
	{ 97, 97 },
	{ 98, 98 },
	{ 99, 99 },
	{ 100, 100 },
	{ 101, 101 },
	{ 102, 102 },
	{ 103, 103 },
	{ 104, 104 },
	{ 105, 105 },
	{ 106, 106 },
	{ 107, 107 },
	{ 108, 108 },
	{ 109, 109 },
	{ 110, 110 },
	{ 111, 111 },
	{ 112, 112 },
	{ 113, 113 },
	{ 114, 114 },
	{ 115, 115 },
	{ 116, 116 },
	{ 117, 117 },
	{ 118, 118 },
	{ 119, 119 },
	{ 120, 120 },
	{ 121, 121 },
	{ 122, 122 },
	{ 123, 123 },
	{ 124, 124 },
	{ 125, 125 },
	{ 126, 126 },
	{ 127, 127 },
	{ 128, 258 },
	{ 129, 260 },
	{ 130, 262 },
	{ 131, 268 },
	{ 132, 270 },
	{ 133, 282 },
	{ 134, 280 },
	{ 135, 286 },
	{ 136, 313 },
	{ 137, 65534 },
	{ 138, 321 },
	{ 139, 323 },
	{ 140, 327 },
	{ 141, 330 },
	{ 142, 336 },
	{ 143, 340 },
	{ 144, 344 },
	{ 145, 346 },
	{ 146, 352 },
	{ 147, 350 },
	{ 148, 356 },
	{ 149, 354 },
	{ 150, 368 },
	{ 151, 366 },
	{ 152, 376 },
	{ 153, 377 },
	{ 154, 381 },
	{ 155, 379 },
	{ 156, 306 },
	{ 157, 304 },
	{ 158, 272 },
	{ 159, 167 },
	{ 160, 259 },
	{ 161, 261 },
	{ 162, 263 },
	{ 163, 269 },
	{ 164, 65534 },
	{ 165, 283 },
	{ 166, 281 },
	{ 167, 287 },
	{ 168, 314 },
	{ 169, 65534 },
	{ 170, 322 },
	{ 171, 324 },
	{ 172, 328 },
	{ 173, 331 },
	{ 174, 337 },
	{ 175, 341 },
	{ 176, 345 },
	{ 177, 347 },
	{ 178, 353 },
	{ 179, 351 },
	{ 180, 65534 },
	{ 181, 355 },
	{ 182, 369 },
	{ 183, 367 },
	{ 184, 255 },
	{ 185, 378 },
	{ 186, 382 },
	{ 187, 380 },
	{ 188, 307 },
	{ 189, 161 },
	{ 190, 191 },
	{ 191, 163 },
	{ 192, 192 },
	{ 193, 193 },
	{ 194, 194 },
	{ 195, 195 },
	{ 196, 196 },
	{ 197, 197 },
	{ 198, 198 },
	{ 199, 199 },
	{ 200, 200 },
	{ 201, 201 },
	{ 202, 202 },
	{ 203, 203 },
	{ 204, 204 },
	{ 205, 205 },
	{ 206, 206 },
	{ 207, 207 },
	{ 208, 208 },
	{ 209, 209 },
	{ 210, 210 },
	{ 211, 211 },
	{ 212, 212 },
	{ 213, 213 },
	{ 214, 214 },
	{ 215, 338 },
	{ 216, 216 },
	{ 217, 217 },
	{ 218, 218 },
	{ 219, 219 },
	{ 220, 220 },
	{ 221, 221 },
	{ 222, 222 },
	{ 223, 65534 },
	{ 224, 224 },
	{ 225, 225 },
	{ 226, 226 },
	{ 227, 227 },
	{ 228, 228 },
	{ 229, 229 },
	{ 230, 230 },
	{ 231, 231 },
	{ 232, 232 },
	{ 233, 233 },
	{ 234, 234 },
	{ 235, 235 },
	{ 236, 236 },
	{ 237, 237 },
	{ 238, 238 },
	{ 239, 239 },
	{ 240, 240 },
	{ 241, 241 },
	{ 242, 242 },
	{ 243, 243 },
	{ 244, 244 },
	{ 245, 245 },
	{ 246, 246 },
	{ 247, 339 },
	{ 248, 248 },
	{ 249, 249 },
	{ 250, 250 },
	{ 251, 251 },
	{ 252, 252 },
	{ 253, 253 },
	{ 254, 254 },
	{ 255, 223 },
	{ 34, 8220 },
	{ 34, 8221 },
	{ 39, 8216 },
	{ 39, 8217 },
	{ 45, 8211 },
	{ 45, 8212 },
	{ 32, 8194 },
	{ 32, 8195 },
	{ 32, 8201 },
	{ 65, 256 },
	{ 65, 461 },
	{ 97, 257 },
	{ 97, 462 },
	{ 67, 264 },
	{ 67, 266 },
	{ 99, 265 },
	{ 99, 267 },
	{ 100, 271 },
	{ 69, 274 },
	{ 69, 276 },
	{ 69, 278 },
	{ 101, 275 },
	{ 101, 277 },
	{ 101, 279 },
	{ 71, 284 },
	{ 71, 288 },
	{ 71, 290 },
	{ 71, 486 },
	{ 71, 500 },
	{ 103, 285 },
	{ 103, 289 },
	{ 103, 291 },
	{ 103, 487 },
	{ 103, 501 },
	{ 72, 292 },
	{ 104, 293 },
	{ 73, 296 },
	{ 73, 298 },
	{ 73, 300 },
	{ 73, 302 },
	{ 73, 463 },
	{ 105, 297 },
	{ 105, 299 },
	{ 105, 301 },
	{ 105, 303 },
	{ 105, 305 },
	{ 105, 464 },
	{ 74, 308 },
	{ 106, 309 },
	{ 75, 310 },
	{ 75, 488 },
	{ 107, 311 },
	{ 107, 489 },
	{ 76, 315 },
	{ 76, 317 },
	{ 76, 319 },
	{ 108, 316 },
	{ 108, 318 },
	{ 108, 320 },
	{ 77, 325 },
	{ 109, 326 },
	{ 109, 329 },
	{ 78, 332 },
	{ 78, 334 },
	{ 78, 465 },
	{ 78, 490 },
	{ 110, 333 },
	{ 110, 335 },
	{ 110, 466 },
	{ 110, 491 },
	{ 82, 342 },
	{ 114, 343 },
	{ 83, 348 },
	{ 115, 349 },
	{ 116, 357 },
	{ 85, 360 },
	{ 85, 362 },
	{ 85, 364 },
	{ 85, 370 },
	{ 85, 467 },
	{ 117, 361 },
	{ 117, 363 },
	{ 117, 365 },
	{ 117, 371 },
	{ 117, 468 },
	{ 87, 372 },
	{ 119, 373 },
	{ 89, 374 },
	{ 121, 375 },
};
allcharconvert_t allcharconvert[] = {
{ "adobeiso",
	"Adobe ISO",
	{ "ADOBEISO", "", "", "", "", "", "", },
	CHARSETARRAY( adobeiso )
},
{ "adobestd",
	"Adobe Standard",
	{ "ADOBESTD", "", "", "", "", "", "", },
	CHARSETARRAY( adobestd )
},
{ "adobesym",
	"Adobe Symbol",
	{ "ADOBESYM", "", "", "", "", "", "", },
	CHARSETARRAY( adobesym )
},
{ "applecro",
	"Apple Croatian",
	{ "APPLECRO", "MACCRO", "", "", "", "", "", },
	CHARSETARRAY( applecro )
},
{ "applecyr",
	"Apple Cyrillic",
	{ "MACCYRILLIC", "X-MAC-CYRILLIC", "", "", "", "", "", },
	CHARSETARRAY( applecyr )
},
{ "applegk2",
	"Apple Greek 2",
	{ "APPLEGK2", "", "", "", "", "", "", },
	CHARSETARRAY( applegk2 )
},
{ "applegrk",
	"Apple Greek",
	{ "MACGRK", "APPLEGRK", "", "", "", "", "", },
	CHARSETARRAY( applegrk )
},
{ "macice",
	"Macintosh Iceland(?)",
	{ "MACICE", "APPLEICE", "", "", "", "", "", },
	CHARSETARRAY( macice )
},
{ "macroman",
	"Macintosh Roman",
	{ "MACROMAN", "APPLEROM", "CSMACINTOSH", "MACINTOSH", "MAC", "", "", },
	CHARSETARRAY( macroman )
},
{ "macromanian",
	"Macintosh Romanian",
	{ "MACROMANIAN", "APPLERUM", "", "", "", "", "", },
	CHARSETARRAY( macromanian )
},
{ "macturkish",
	"Macintosh Turkish",
	{ "MACTURKISH", "APPLETURK", "", "", "", "", "", },
	CHARSETARRAY( macturkish )
},
{ "atarist",
	"Atari ST",
	{ "ATARIST", "", "", "", "", "", "", },
	CHARSETARRAY( atarist )
},
{ "cp437",
	"MS-DOS Code Page 437 from original IBM PC",
	{ "CP437", "IBM437", "437", "", "", "", "", },
	CHARSETARRAY( cp437 )
},
{ "cp737",
	"MS-DOS Code Page 737 Greek",
	{ "CP737", "IBM737", "737", "", "", "", "", },
	CHARSETARRAY( cp737 )
},
{ "cp775",
	"MS-DOS Code Page 775 Baltic languages",
	{ "CP775", "IBM775", "775", "", "", "", "", },
	CHARSETARRAY( cp775 )
},
{ "cp850",
	"MS-DOS Code Page 850 Western Europe",
	{ "CP850", "IBM850", "CSPC850MULTILINGUAL", "850", "", "", "", },
	CHARSETARRAY( cp850 )
},
{ "cp851",
	"MS-DOS Code Page 851 Greek 1",
	{ "CP851", "IBM851", "851", "", "", "", "", },
	CHARSETARRAY( cp851 )
},
{ "cp852",
	"MS-DOS Code Page 852 Central European languages",
	{ "CP852", "IBM852", "852", "", "", "", "", },
	CHARSETARRAY( cp852 )
},
{ "cp853",
	"MS-DOS Code Page 853 Multilingual Latin 3",
	{ "CP853", "IBM853", "853", "", "", "", "", },
	CHARSETARRAY( cp853 )
},
{ "cp855",
	"MS-DOS Code Page 855 Cyrillic",
	{ "CP855", "IBM855", "855", "", "", "", "", },
	CHARSETARRAY( cp855 )
},
{ "cp857",
	"MS-DOS Code Page 857 Turkish",
	{ "CP857", "IBM857", "857", "", "", "", "", },
	CHARSETARRAY( cp857 )
},
{ "cp860",
	"MS-DOS Code Page 860 Portugese",
	{ "CP860", "IBM860", "860", "", "", "", "", },
	CHARSETARRAY( cp860 )
},
{ "cp861",
	"MS-DOS Code Page 861 Icelandic languages",
	{ "CP861", "IBM861", "861", "", "", "", "", },
	CHARSETARRAY( cp861 )
},
{ "cp862",
	"MS-DOS Code Page 862 Hebrew",
	{ "CP862", "IBM862", "862", "", "", "", "", },
	CHARSETARRAY( cp862 )
},
{ "cp863",
	"MS-DOS Code Page 863 French",
	{ "CP863", "IBM863", "863", "", "", "", "", },
	CHARSETARRAY( cp863 )
},
{ "cp864",
	"MS-DOS Code Page 864 Arabic",
	{ "CP864", "IBM864", "864", "", "", "", "", },
	CHARSETARRAY( cp864 )
},
{ "cp865",
	"MS-DOS Code Page 865 Nordic languages",
	{ "CP865", "IBM865", "865", "", "", "", "", },
	CHARSETARRAY( cp865 )
},
{ "cp866",
	"MS-DOS Code Page 866 Cyrillic",
	{ "CP866", "IBM866", "866", "CSIBM866", "", "", "", },
	CHARSETARRAY( cp866 )
},
{ "cp869",
	"MS-DOS Code Page 869 Greek",
	{ "CP869", "IBM869", "869", "", "", "", "", },
	CHARSETARRAY( cp869 )
},
{ "cp874",
	"Windows-874 Thai",
	{ "CP874", "WINDOWS-874", "MS874", "X-WINDOWS-874", "X-IBM874", "874", "", },
	CHARSETARRAY( cp874 )
},
{ "cp895",
	"MS-DOS Code Page 895 Kamenicky encoding",
	{ "CP895", "895", "", "", "", "", "", },
	CHARSETARRAY( cp895 )
},
{ "cp1250",
	"Windows-1250 Central and Eastern European",
	{ "CP1250", "WINDOWS-1250", "MS-EE", "", "", "", "", },
	CHARSETARRAY( cp1250 )
},
{ "cp1251",
	"Windows-1251 Cyrillic",
	{ "CP1251", "WINDOWS-1251", "MS-CYRL", "", "", "", "", },
	CHARSETARRAY( cp1251 )
},
{ "cp1252",
	"Windows-1252 ISO 8859-1 superset",
	{ "CP1252", "WINDOWS-1252", "MS-ANSI", "", "", "", "", },
	CHARSETARRAY( cp1252 )
},
{ "cp1253",
	"Windows-1253 Greek",
	{ "CP1253", "WINDOWS-1253", "MS-GREEK", "", "", "", "", },
	CHARSETARRAY( cp1253 )
},
{ "cp1254",
	"Windows-1254 Turkish",
	{ "CP1254", "WINDOWS-1254", "MS-TURK", "", "", "", "", },
	CHARSETARRAY( cp1254 )
},
{ "cp1255",
	"Windows-1255 ISO 8859-8 Hebrew",
	{ "CP1255", "WINDOWS-1255", "MS-HEBR", "", "", "", "", },
	CHARSETARRAY( cp1255 )
},
{ "cp1256",
	"Windows-1256 Arabic",
	{ "CP1256", "WINDOWS-1256", "MS-ARAB", "", "", "", "", },
	CHARSETARRAY( cp1256 )
},
{ "cp1257",
	"Windows-1257 Baltic languages",
	{ "CP1257", "WINDOWS-1257", "WINBALTRIM", "", "", "", "", },
	CHARSETARRAY( cp1257 )
},
{ "cp1258",
	"Windows-1258 Vietnamese",
	{ "CP1258", "WINDOWS-1258", "", "", "", "", "", },
	CHARSETARRAY( cp1258 )
},
{ "decmcs",
	"DEC Multinational Character Set",
	{ "DECMCS", "", "", "", "", "", "", },
	CHARSETARRAY( decmcs )
},
{ "ebc037",
	"EBCDIC Codepage 037 Latin-1",
	{ "EBC037", "", "", "", "", "", "", },
	CHARSETARRAY( ebc037 )
},
{ "ebc1026",
	"EBCDIC 1026 Turkish",
	{ "EBC1026", "", "", "", "", "", "", },
	CHARSETARRAY( ebc1026 )
},
{ "ebc1047",
	"EBCDIC 1047 Latin 1",
	{ "EBC1047", "", "", "", "", "", "", },
	CHARSETARRAY( ebc1047 )
},
{ "ebc500",
	"EBCDIC 500 Latin 1",
	{ "EBC500", "", "", "", "", "", "", },
	CHARSETARRAY( ebc500 )
},
{ "ebc875",
	"EBCDIC 875 Greek",
	{ "EBC875", "", "", "", "", "", "", },
	CHARSETARRAY( ebc875 )
},
{ "hp48",
	"HP48",
	{ "HP48", "", "", "", "", "", "", },
	CHARSETARRAY( hp48 )
},
{ "hproman8",
	"HP Roman8",
	{ "HPROMAN8", "", "", "", "", "", "", },
	CHARSETARRAY( hproman8 )
},
{ "iso646",
	"ISO/IEC 646",
	{ "ISO646", "", "", "", "", "", "", },
	CHARSETARRAY( iso646 )
},
{ "iso646_irv",
	"ISO/IEC 646-IRV International Reference Variant",
	{ "ISO646-IRV", "", "", "", "", "", "", },
	CHARSETARRAY( iso646_irv )
},
{ "iso646_ca",
	"ISO/IEC 646-CA Canada",
	{ "ISO646-CA", "", "", "", "", "", "", },
	CHARSETARRAY( iso646_ca )
},
{ "iso646_ch",
	"ISO/IEC 646-CH",
	{ "ISO646-CH", "", "", "", "", "", "", },
	CHARSETARRAY( iso646_ch )
},
{ "iso646_de",
	"ISO/IEC 646-DE Germany",
	{ "ISO646-DE", "", "", "", "", "", "", },
	CHARSETARRAY( iso646_de )
},
{ "iso646_es",
	"ISO/IEC 646-ES Spain",
	{ "ISO646-ES", "", "", "", "", "", "", },
	CHARSETARRAY( iso646_es )
},
{ "iso646_fi",
	"ISO/IEC 646-FI Finland",
	{ "ISO646-FI", "", "", "", "", "", "", },
	CHARSETARRAY( iso646_fi )
},
{ "iso646_fr",
	"ISO/IEC 646-FR France",
	{ "ISO646-FR", "", "", "", "", "", "", },
	CHARSETARRAY( iso646_fr )
},
{ "iso646_gb",
	"ISO/IEC 646-GB United Kingdom",
	{ "ISO646-GB", "", "", "", "", "", "", },
	CHARSETARRAY( iso646_gb )
},
{ "iso646_it",
	"ISO/IEC 646-IT",
	{ "ISO646-IT", "", "", "", "", "", "", },
	CHARSETARRAY( iso646_it )
},
{ "iso646_nl",
	"ISO/IEC 646-NL",
	{ "ISO646-NL", "", "", "", "", "", "", },
	CHARSETARRAY( iso646_nl )
},
{ "iso646_no",
	"ISO/IEC 646-NO Norway",
	{ "ISO646-NO", "", "", "", "", "", "", },
	CHARSETARRAY( iso646_no )
},
{ "iso646_pt",
	"ISO/IEC 646-PT Portugal",
	{ "ISO646-PT", "", "", "", "", "", "", },
	CHARSETARRAY( iso646_pt )
},
{ "iso646_se",
	"ISO/IEC 646-SE Sweden",
	{ "ISO646-SE", "", "", "", "", "", "", },
	CHARSETARRAY( iso646_se )
},
{ "iso8859_1",
	"ISO/IEC 8859-1:1998 Latin-1",
	{ "ISO-8859-1", "CSISOLATIN", "LATIN1", "ISO-IR-100", "CP819", "IBM819", "ISO_8859-1", },
	CHARSETARRAY( iso8859_1 )
},
{ "iso8859_2",
	"ISO/IEC 8859-2:1999 Latin-2 Eastern European",
	{ "ISO-8859-2", "CSISOLATIN2", "LATIN2", "ISO-IR-101", "ISO_8859-2", "ISO_8859-2:1987", "L2", },
	CHARSETARRAY( iso8859_2 )
},
{ "iso8859_3",
	"ISO/IEC 8859-3:1999 Latin-3 South European",
	{ "ISO-8859-3", "CSISOLATIN3", "LATIN3", "ISO-IR-109", "ISO_8859-3", "ISO_8859-3:1988", "L3", },
	CHARSETARRAY( iso8859_3 )
},
{ "iso8859_4",
	"ISO/IEC 8859-4:1998 Latin-4 North European",
	{ "ISO-8859-4", "CSISOLATIN4", "LATIN4", "ISO-IR-110", "ISO_8859-4", "ISO_8859-4:1988", "L4", },
	CHARSETARRAY( iso8859_4 )
},
{ "iso8859_5",
	"ISO/IEC 8859-5:1999 Latin/Cyrillic",
	{ "ISO-8859-5", "CSISOLATINCYRILLIC", "CYRILLIC", "ISO-IR-144", "ISO_8859-5", "ISO_8859-5:1988", "", },
	CHARSETARRAY( iso8859_5 )
},
{ "iso8859_6",
	"ISO/IEC 8859-6:1999 Latin/Arabic",
	{ "ISO-8859-6", "ARABIC", "ASMO-708", "CSISOLATINARABIC", "ECMA-114", "ISO-IR-127", "ISO_8859-6", },
	CHARSETARRAY( iso8859_6 )
},
{ "iso8859_7",
	"ISO/IEC 8859-7:2003 Latin/Greek",
	{ "ISO-8859-7", "CSISOLATINGREEK", "GREEK", "ECMA-118", "ELOT_928", "GREEK8", "ISO-IR-126", },
	CHARSETARRAY( iso8859_7 )
},
{ "iso8859_8",
	"ISO/IEC 8859-8:1999 Latin/Hebrew",
	{ "ISO-8859-8", "CSISOLATINHEBREW", "HEBREW", "ISO-IR-138", "ISO_8859-8", "ISO_8859-8:1988", "", },
	CHARSETARRAY( iso8859_8 )
},
{ "iso8859_9",
	"ISO/IEC 8859-9:1999 Latin-5 Turkish",
	{ "ISO-8859-9", "CSISOLATIN5", "LATIN5", "ISO-IR-148", "ISO_8859-9", "ISO_8859-9:1989", "L5", },
	CHARSETARRAY( iso8859_9 )
},
{ "iso8859_10",
	"ISO/IEC 8859-10:1998 Latin-6 Nordic languages",
	{ "ISO-8859-10", "CSISOLATIN6", "LATIN6", "ISO-IR-157", "ISO_8859-10", "ISO_8859-10:1992", "L6", },
	CHARSETARRAY( iso8859_10 )
},
{ "iso8859_11",
	"ISO/IEC 8859-11:2001 Latin/Thai",
	{ "ISO-8859-11,", "TIS-620,", "TIS620,", "TACTIS", "", "", "", },
	CHARSETARRAY( iso8859_11 )
},
{ "iso8859_13",
	"ISO/IEC 8859-13:1998 Latin-7 Baltic Rim",
	{ "ISO-8859-13", "CSISOLATIN7", "LATIN7", "ISO-IR-179", "ISO_8859-13", "L7", "", },
	CHARSETARRAY( iso8859_13 )
},
{ "iso8859_14",
	"ISO/IEC 8859-14:1998 Latin-8 Celtic",
	{ "ISO-8859-14", "CSISOLATIN8", "LATIN8", "ISO-IR-199", "ISO_8859-14", "ISO_8859-14:1998", "L8", },
	CHARSETARRAY( iso8859_14 )
},
{ "iso8859_15",
	"ISO/IEC 8859-15:1999 Latin-9 Western European",
	{ "ISO-8859-15", "ISO-IR-203", "ISO_8859-15", "ISO_8859-15:1998", "", "", "", },
	CHARSETARRAY( iso8859_15 )
},
{ "iso8859_16",
	"ISO/IEC 8859-16:2001 Latin-10 South-Eastern European",
	{ "ISO-8859-16", "CSISOLATIN10", "LATIN10", "ISO-IR-226", "ISO_8859-16", "ISO_8859-16:2000", "", },
	CHARSETARRAY( iso8859_16 )
},
{ "koi8_r",
	"KOI8-R Kod Obmena Informatsiey, 8 bit Russian",
	{ "KOI8-R", "KOI8R", "CSKOI8R", "", "", "", "", },
	CHARSETARRAY( koi8_r )
},
{ "koi8_u",
	"KOI8-U Kod Obmena Informatsiey, 8 bit Ukranian",
	{ "KOI8-U", "KOI8U", "CSKOI8U", "", "", "", "", },
	CHARSETARRAY( koi8_u )
},
{ "mslinedr",
	"MS LineDraw",
	{ "MSLINEDR", "", "", "", "", "", "", },
	CHARSETARRAY( mslinedr )
},
{ "nextstep",
	"NextStep",
	{ "NEXTSTEP", "", "", "", "", "", "", },
	CHARSETARRAY( nextstep )
},
{ "symbol",
	"MS Windows Symbol Font",
	{ "SYMBOL", "", "", "", "", "", "", },
	CHARSETARRAY( symbol )
},
{ "tex_dcr_in",
	"TeX dcr input for European Computer Roman Font",
	{ "TEX_DCR_IN", "", "", "", "", "", "", },
	CHARSETARRAY( tex_dcr_in )
},
{ "tex_dcr_out",
	"TeX dcr output for European Computer Roman Font",
	{ "TEX_DCR_OUT", "", "", "", "", "", "", },
	CHARSETARRAY( tex_dcr_out )
},
};
int nallcharconvert = ARRAYSIZE( allcharconvert );

char *
charset_get_xmlname( int n )
{
	static char unknown[] = "???";
	static char utf8[] = "UTF-8";
	static char gb18030[] = "GB18030";
	char *ret = unknown;
	if ( n>=0 && n < nallcharconvert ) {
		ret = allcharconvert[n].aliases[0];
	} else if ( n==CHARSET_UNICODE ) {
		ret = utf8;
	} else if ( n==CHARSET_GB18030 ) {
		ret = gb18030;
	}
	return ret;
}

int
charset_find( char *name )
{
	int i, j, ret = CHARSET_UNKNOWN;
	if ( name==NULL ) return ret;
	for ( i=0; i<nallcharconvert && ret==CHARSET_UNKNOWN; ++i ){
		if ( !strcasecmp( name, allcharconvert[i].cmdname ) ) ret = i;
		else {
			for ( j=0; j<CHARSET_NALIASES && ret==CHARSET_UNKNOWN; ++j ) {
				if ( allcharconvert[i].aliases[j][0]=='\0' ) continue;
				if ( !strcasecmp( name, allcharconvert[i].aliases[j] ) ) ret = i;
			}
		}
	}
	return ret;
}

void
charset_list_all( FILE *fp )
{
	int i;
	for ( i=0; i<nallcharconvert; ++i ){
		fprintf( fp, " %s %s\n", allcharconvert[i].cmdname,
			allcharconvert[i].descriptname );
	}
}

// Georgi
void
charset_list_all_stderr( void )
{
	int i;
	for ( i=0; i<nallcharconvert; ++i ){
		REprintf(" %s %s\n", allcharconvert[i].cmdname,
			allcharconvert[i].descriptname );
	}
}

unsigned int
charset_lookupchar( int charsetin, char c )
{
	unsigned char uc;
	uc = ( unsigned char ) c;
	return allcharconvert[charsetin].table[uc].unicode;
}

unsigned int
charset_lookupuni( int charsetout, unsigned int unicode )
{
	int i;
	if ( charsetout==CHARSET_UNICODE ) return unicode;
	for ( i=0; i<allcharconvert[charsetout].ntable; ++i ) {
		if ( unicode == allcharconvert[charsetout].table[i].unicode )
			return allcharconvert[charsetout].table[i].index;
	}
	return '?';
}

