% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_rpushbullet.R
\name{handler_rpushbullet}
\alias{handler_rpushbullet}
\title{Progression Handler: Progress Reported via the Pushbullet Messaging Service}
\usage{
handler_rpushbullet(
  intrusiveness = getOption("progressr.intrusiveness.rpushbullet", 5),
  target = "gui",
  ...,
  title = "Progress update from R",
  recipients = NULL,
  email = NULL,
  channel = NULL,
  apikey = NULL,
  device = NULL
)
}
\arguments{
\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{title}{The title of the note being posted.}

\item{recipients}{A character or numeric vector indicating the
devices this post should go to. If missing, the default device
is looked up from an optional setting, and if none has been set
the push is sent to all devices.}

\item{email}{An alternative way to specify a recipient is to specify
an email address. If both \code{recipients} and \code{email} are
present, \code{recipients} is used.}

\item{channel}{A channel tag used to specify the name of the channel
as the recipient. If either \code{recipients} or \code{email} are present,
they will take precedence over \code{channel}.}

\item{apikey}{The API key used to access the service. It can be
supplied as an argument here, via the global option
\code{rpushbullet.key}, or via the file \code{~/.rpushbullet.json}
which is read at package initialization (and, if found, also sets
the global option).}

\item{\ldots}{Additional arguments passed to \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
A progression handler for \code{pbPost()} of the \pkg{RPushbullet} package.
}
\section{Requirements}{

This progression handler requires the \pkg{RPushbullet} package, a
Pushbullet account, and configuration according to the instructions
of the \pkg{RPushbullet} package.  It also requires internet access
from the computer where this progress handler is registered.
}

\examples{
pkg <- "RPushbullet"
if (requireNamespace(pkg, quietly = TRUE)) {

  handlers("rpushbullet")
  with_progress({ y <- slow_sum(1:10) })
  print(y)
  
}
}
\keyword{internal}
