% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/namespace.R
\name{getLoadingNamespace}
\alias{getLoadingNamespace}
\alias{isLoadingNamespace}
\alias{isNamespaceLoaded2}
\alias{isDevNamespace}
\alias{addNamespaceExport}
\alias{ns_get}
\title{Namespace Development Functions}
\usage{
getLoadingNamespace(env = FALSE, info = FALSE, nodev = FALSE)

isLoadingNamespace(ns, nodev = FALSE)

isNamespaceLoaded2(ns)

isDevNamespace(ns)

addNamespaceExport(x)

ns_get(x, ns = NULL, ...)
}
\arguments{
\item{env}{logical that indicates that the namespace's environment (i.e. the
namespace itself) should be returned.}

\item{info}{logical that indicates that the complete information list should
be returned}

\item{nodev}{logical that indicates if loading devtools namespace should
be discarded.}

\item{ns}{the name of a namespace or a namespace whose loading state is tested.
If missing \code{isLoadingNamespace} test if any namespace is being loaded.}

\item{x}{character vector containing the names of R objects to export in the
loading namespace.}

\item{...}{extra arguments passed to \link{get0}.}
}
\value{
the name of the loading namespace if \code{env} and \code{info} are
\code{FALSE}, an environment if \code{env=TRUE}, a list with elements
\code{pkgname} and \code{libname} if \code{info=TRUE}.
}
\description{
\code{getLoadingNamespace} returns information about the loading namespace.
It is a wrapper to \code{\link{loadingNamespaceInfo}}, that does not throw
an error.
}
\section{Functions}{
\itemize{
\item \code{isLoadingNamespace}: Tests if a namespace is being loaded.

\item \code{isNamespaceLoaded2}: tests if a given namespace is loaded, without loading it,
contrary to \code{\link{isNamespace}}.
It is similar to \code{\link{isNamespaceLoaded}} -- which it uses -- but also accepts
environments.

\item \code{isDevNamespace}: tests the -- current -- namespace is a devtools namespace.

\item \code{addNamespaceExport}: Dynamically adds exported objects into the loading namespace.

\item \code{ns_get}: gets an object from a given namespace.
}}

