% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writexlsx.R
\name{write.xlsx}
\alias{write.xlsx}
\title{write data to an xlsx file}
\usage{
write.xlsx(x, file, asTable = FALSE, overwrite = TRUE, ...)
}
\arguments{
\item{x}{A data.frame or a (named) list of objects that can be handled by
\code{\link[=writeData]{writeData()}} or \code{\link[=writeDataTable]{writeDataTable()}} to write to file}

\item{file}{A file path to save the xlsx file}

\item{asTable}{If \code{TRUE} will use \code{\link[=writeDataTable]{writeDataTable()}} rather
than \code{\link[=writeData]{writeData()}} to write \code{x} to the file (default:
\code{FALSE})}

\item{overwrite}{Overwrite existing file (Defaults to \code{TRUE} as with \code{write.table})}

\item{...}{Additional arguments passed to \code{\link[=buildWorkbook]{buildWorkbook()}}; see details}
}
\value{
A workbook object
}
\description{
write a data.frame or list of data.frames to an xlsx file
}
\section{Optional Parameters}{


\strong{createWorkbook Parameters}
\describe{
\item{\strong{creator}}{ A string specifying the workbook author}
}

\strong{addWorksheet Parameters}
\describe{
\item{\strong{sheetName}}{ Name of the worksheet}
\item{\strong{gridLines}}{ A logical. If \code{FALSE}, the worksheet grid lines will be hidden.}
\item{\strong{tabColour}}{ Colour of the worksheet tab. A valid colour (belonging to colours())
or a valid hex colour beginning with "#".}
\item{\strong{zoom}}{ A numeric between 10 and 400. Worksheet zoom level as a percentage.}
}

\strong{writeData/writeDataTable Parameters}
\describe{
\item{\strong{startCol}}{ A vector specifying the starting column(s) to write df}
\item{\strong{startRow}}{ A vector specifying the starting row(s) to write df}
\item{\strong{xy}}{ An alternative to specifying startCol and startRow individually.
A vector of the form c(startCol, startRow)}
\item{\strong{colNames or col.names}}{ If \code{TRUE}, column names of x are written.}
\item{\strong{rowNames or row.names}}{ If \code{TRUE}, row names of x are written.}
\item{\strong{headerStyle}}{ Custom style to apply to column names.}
\item{\strong{borders}}{ Either "surrounding", "columns" or "rows" or NULL.  If "surrounding", a border is drawn around the
data.  If "rows", a surrounding border is drawn a border around each row. If "columns", a surrounding border is drawn with a border
between each column.  If "\code{all}" all cell borders are drawn.}
\item{\strong{borderColour}}{ Colour of cell border}
\item{\strong{borderStyle}}{ Border line style.}
\item{\strong{keepNA}}{If \code{TRUE}, NA values are converted to #N/A (or \code{na.string}, if not NULL) in Excel, else NA cells will be empty. Defaults to FALSE.}
\item{\strong{na.string}}{If not NULL, and if \code{keepNA} is \code{TRUE}, NA values are converted to this string in Excel. Defaults to NULL.}
}

\strong{freezePane Parameters}
\describe{
\item{\strong{firstActiveRow}}{Top row of active region to freeze pane.}
\item{\strong{firstActiveCol}}{Furthest left column of active region to freeze pane.}
\item{\strong{firstRow}}{If \code{TRUE}, freezes the first row (equivalent to firstActiveRow = 2)}
\item{\strong{firstCol}}{If \code{TRUE}, freezes the first column (equivalent to firstActiveCol = 2)}
}

\strong{colWidths Parameters}
\describe{
\item{\strong{colWidths}}{May be a single value for all columns (or "auto"), or a list of vectors that will be recycled for each sheet (see examples)}
}
}

\examples{

## write to working directory
options("openxlsx.borderColour" = "#4F80BD") ## set default border colour
\dontrun{
write.xlsx(iris, file = "writeXLSX1.xlsx", colNames = TRUE, borders = "columns")
write.xlsx(iris, file = "writeXLSX2.xlsx", colNames = TRUE, borders = "surrounding")
}


hs <- createStyle(
  textDecoration = "BOLD", fontColour = "#FFFFFF", fontSize = 12,
  fontName = "Arial Narrow", fgFill = "#4F80BD"
)
\dontrun{
write.xlsx(iris,
  file = "writeXLSX3.xlsx",
  colNames = TRUE, borders = "rows", headerStyle = hs
)
}

## Lists elements are written to individual worksheets, using list names as sheet names if available
l <- list("IRIS" = iris, "MTCATS" = mtcars, matrix(runif(1000), ncol = 5))
\dontrun{
write.xlsx(l, "writeList1.xlsx", colWidths = c(NA, "auto", "auto"))
}

## different sheets can be given different parameters
\dontrun{
write.xlsx(l, "writeList2.xlsx",
  startCol = c(1, 2, 3), startRow = 2,
  asTable = c(TRUE, TRUE, FALSE), withFilter = c(TRUE, FALSE, FALSE)
)
}

# specify column widths for multiple sheets
\dontrun{
write.xlsx(l, "writeList2.xlsx", colWidths = 20)
write.xlsx(l, "writeList2.xlsx", colWidths = list(100, 200, 300))
write.xlsx(l, "writeList2.xlsx", colWidths = list(rep(10, 5), rep(8, 11), rep(5, 5)))
}

}
\seealso{
\code{\link[=addWorksheet]{addWorksheet()}}

\code{\link[=writeData]{writeData()}}

\code{\link[=createStyle]{createStyle()}} for style parameters

\code{\link[=buildWorkbook]{buildWorkbook()}}
}
\author{
Alexander Walker, Jordan Mark Barbone
}
