% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodes.R
\name{get_nodes}
\alias{get_nodes}
\title{Create a node extractor function}
\usage{
get_nodes(...)
}
\arguments{
\item{...}{Additional data that should be cbind'ed together with the node
data.}
}
\value{
A data.frame with the node data as well of any additional data
supplied through \code{...}
}
\description{
This function returns another function that can extract nodes from a
ggraph_layout object. As a ggraph_layout object is essentially a data.frame
of nodes it might seem useless to provide this function, but since the node
data is not necessarily available until after the \code{ggraph()} call it
can be beneficial to be able to add information to the node data on a
per-layer basis. Unlike \code{\link[=get_edges]{get_edges()}} the use of \code{get_nodes} is not
mandatory and is only required if additional data should be added to selected
node layers.
}
\seealso{
Other extractors: 
\code{\link{get_con}()},
\code{\link{get_edges}()}
}
\concept{extractors}
