% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hv.R
\name{hypervolume}
\alias{hypervolume}
\title{Hypervolume metric}
\usage{
hypervolume(data, reference, maximise = FALSE)
}
\arguments{
\item{data}{(\code{matrix} | \code{data.frame}) \cr Matrix or data frame of numerical
values, where each row gives the coordinates of a point.}

\item{reference}{(\code{numeric()}) \cr Reference point as a vector of numerical values.}

\item{maximise}{(\code{logical()} | \code{logical(1)}) \cr Whether the objectives must be
maximised instead of minimised. Either a single logical value that applies
to all objectives or a vector of logical values, with one value per
objective.}
}
\value{
A single numerical value.
}
\description{
Computes the hypervolume metric with respect to a given reference point
assuming minimization of all objectives.
}
\details{
The algorithm has \eqn{O(n^{d-2} \log n)} time and linear space
  complexity in the worst-case, but experimental results show that the
  pruning techniques used may reduce the time complexity even further.
}
\examples{

data(SPEA2minstoptimeRichmond)
# The second objective must be maximized
# We calculate the hypervolume of the union of all sets.
hypervolume(SPEA2minstoptimeRichmond[, 1:2], reference = c(250, 0),
            maximise = c(FALSE, TRUE))

}
\references{
C. M. Fonseca, L. Paquete, and M. López-Ibáñez. An improved dimension-sweep
algorithm for the hypervolume indicator. In IEEE Congress on Evolutionary
Computation, pages 1157-1163, Vancouver, Canada, July 2006.

Nicola Beume, Carlos M. Fonseca, Manuel López-Ibáñez, Luís Paquete, and
J. Vahrenhold. On the complexity of computing the hypervolume indicator.
IEEE Transactions on Evolutionary Computation, 13(5):1075-1082, 2009.
}
\author{
Manuel \enc{López-Ibáñez}{Lopez-Ibanez}
}
