% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_main_dbs_contexts.R
\name{plot_main_dbs_contexts}
\alias{plot_main_dbs_contexts}
\title{Plot the main DBS contexts}
\usage{
plot_main_dbs_contexts(counts, same_y = FALSE)
}
\arguments{
\item{counts}{A tibble containing the number of DBS per COSMIC context.}

\item{same_y}{A boolean describing whether the same y axis should be used for all samples.}
}
\value{
A ggplot figure.
}
\description{
Plot the main DBS contexts
}
\details{
Plots the number of DBS per main COSMIC context per sample.
The contexts are only divided by REF and not by ALT.
It takes a tibble with counts as its input. This tibble can be generated by count_dbs_contexts
Each sample is plotted in a separate facet.
The same y axis can be used for all samples or a separate y axis can be used.
}
\examples{
## Get The dbs counts
## See 'count_dbs_contexts()' for more info on how to do this.
dbs_counts <- readRDS(system.file("states/blood_dbs_counts.rds",
  package = "MutationalPatterns"
))

## Plot contexts
plot_main_dbs_contexts(dbs_counts)

## Use the same y axis for all samples.
plot_main_dbs_contexts(dbs_counts, same_y = TRUE)
}
\seealso{
\code{\link{count_dbs_contexts}}, \code{\link{plot_dbs_contexts}}

Other DBS: 
\code{\link{count_dbs_contexts}()},
\code{\link{get_dbs_context}()},
\code{\link{plot_compare_dbs}()},
\code{\link{plot_dbs_contexts}()}
}
\concept{DBS}
