
#include "bdl.h"

static BDL_Record moonrecords[] = {

     {
          2458849.5,
          {0.1179059778,4.546580055e-05,132.6870686,0.1596399447,0.0002898966366,0.03092401432}, /*cmx*/
          {-6.341048517,-7.197527214,-236.8516739,-4.9814681}, /*cfx*/
          {-0.001164456419,8.330732268e-05,189.3295097,-0.05593521384,-0.000227859412,-0.05165246293}, /*cmy*/
          {-1.765803358,6.218931901,15.55435855,-3.634633592}, /*cfy*/
          {-0.1054051219,7.295404166e-05,139.9560179,-0.127057028,-0.000177936708,-0.04568039027}, /*cmz*/
          {-3.461851322,-9.640575993,-5.734032332,-5.338640787} /*cfz*/
     },
     {
          2459107.5,
          {0.1155946266,-3.779156077e-06,151.873889,-0.1437931298,-0.0006638617155,0.04079829413}, /*cmx*/
          {2.171501961,1.772404371,-7.816173468,5.663853633}, /*cfx*/
          {0.01766645292,7.004693203e-05,190.5343174,-0.03231368972,3.001102187e-05,-0.05464589907}, /*cmy*/
          {0.5519135413,1.899940851,6.407036728,0.8549874749}, /*cfy*/
          {-0.1018373497,2.515465105e-05,116.4884031,0.1844369322,-0.0007606676179,-0.03465999628}, /*cmz*/
          {5.179951866,4.798663176,4.908411845,5.549482288} /*cfz*/
     },
     {
          2459365.5,
          {0.1246042698,-4.209841123e-05,156.2320302,-0.05060843543,0.0002565575333,0.03647436369}, /*cmx*/
          {4.417682139,2.039770496,1.524746846,4.048473247}, /*cfx*/
          {0.02699520617,9.401346906e-05,190.7337317,0.06517404107,0.0002309008155,-0.04933390881}, /*cmy*/
          {2.813544922,4.381536064,-5.062688359,5.430913125}, /*cfy*/
          {-0.07967657963,4.218186523e-05,110.0871348,-0.07573056515,0.0004331394689,-0.0381508085}, /*cmz*/
          {1.175584543,0.4060969364,0.6013172716,3.530478083} /*cfz*/
     },
     {
          2459623.5,
          {0.1153825574,-3.944721783e-05,150.0205413,-0.1881824094,0.0005100204767,0.03524232536}, /*cmx*/
          {0.4702995763,9.167675808,2.759392659,1.986916224}, /*cfx*/
          {0.04395740907,8.518768287e-05,190.5214616,-0.05455050233,-0.0002251020152,-0.04629046008}, /*cmy*/
          {5.127337331,0.4845153549,3.597499662,3.523672739}, /*cfy*/
          {-0.06472768738,3.966090191e-05,119.6948947,-0.2278331793,0.0005335894074,-0.0307850417}, /*cmz*/
          {3.4635936,3.294707709,3.385732309,1.829545136} /*cfz*/
     },
     {
          2459881.5,
          {0.1030034233,-5.28075263e-05,162.334426,0.06711013986,-0.0004341413095,0.04634262606}, /*cmx*/
          {2.746391716,6.04532647,5.485870478,0.2111904753}, /*cfx*/
          {0.06394060276,4.131654901e-05,190.8828925,-0.0500547421,-3.315249192e-05,-0.04650157313}, /*cmy*/
          {1.16159419,2.70496772,5.806550799,1.687169433}, /*cfy*/
          {-0.07088562692,4.021330798e-05,100.3599404,0.1354635323,-0.0007637172792,-0.01925223552}, /*cmz*/
          {5.839107707,5.279929503,5.436043713,-0.06268907213} /*cfz*/
     },
     {
          2460139.5,
          {0.1080338613,-0.0001135568584,172.9207641,0.09180632645,-0.0002936052001,0.03701785448}, /*cmx*/
          {4.973657077,0.7702809014,0.4974478868,4.916876002}, /*cfx*/
          {0.07087000023,4.622008142e-05,190.9141535,0.07396567378,0.0002987118777,-0.04450060235}, /*cmy*/
          {3.414046805,4.996636276,1.856148869,-0.04979091852}, /*cfy*/
          {-0.04557760293,9.392117145e-06,81.35958231,0.08206228121,-0.0001514736971,-0.03096432035}, /*cmz*/
          {1.891434548,1.88822545,2.507927291,4.023788014} /*cfz*/
     },
     {
          2460397.5,
          {0.09202360501,-8.973572933e-05,167.2353793,-0.1490880879,-0.000505743996,0.03557774709}, /*cmx*/
          {1.003286647,3.521479563,-18.57017998,2.693556369}, /*cfx*/
          {0.08127103644,5.48983071e-05,190.9861139,-0.05353459498,-0.0002368499271,-0.04212723675}, /*cmy*/
          {5.716593948,0.9413133525,4.098457643,4.283312926}, /*cfy*/
          {-0.02544412814,-2.717779597e-05,92.98908272,-0.27658978,0.0008616573543,-0.01938610423}, /*cmz*/
          {4.141337371,-2.437525838,10.15901505,2.787887858} /*cfz*/
     },
     {
          2460655.5,
          {0.06766579682,-2.740584851e-05,171.8077507,-0.07984859327,-0.0001639887406,0.04520709773}, /*cmx*/
          {3.315898951,4.962796633,13.25599408,0.8871260352}, /*cfx*/
          {0.09850267995,1.045972505e-05,190.9466857,-0.08118547195,-0.0001212575475,-0.04219250374}, /*cmy*/
          {1.754171629,3.303155652,0.2474497669,2.466049876}, /*cfy*/
          {-0.04217727852,4.764631728e-05,83.22885381,-0.03056295861,-0.0004656586297,-0.008385219073}, /*cmz*/
          {0.2238377854,1.66284487,5.972046246,0.6892765156} /*cfz*/
     },
     {
          2460913.5,
          {0.06598146621,-8.634535142e-05,183.620525,0.1121291554,-0.0004571148859,0.03732088535}, /*cmx*/
          {5.545350671,1.540637516,-17.47278121,5.497482038}, /*cfx*/
          {0.1010177573,4.317442753e-06,190.369952,0.0811555741,0.0003833760857,-0.03927100531}, /*cmy*/
          {3.99794682,5.525603217,2.398484145,0.6771498667}, /*cfy*/
          {-0.02598767703,6.015729387e-05,55.28398943,0.2010081305,-0.0006354515088,-0.01626469161}, /*cmz*/
          {2.686198479,21.07993984,2.287144978,4.551476938} /*cfz*/
     },
     {
          2461171.5,
          {0.05196041725,-9.934598989e-05,181.3557208,-0.06976521476,0.0002983263484,0.03815636858}, /*cmx*/
          {1.544212477,4.30465078,4.115598998,3.405884801}, /*cfx*/
          {0.1038037473,3.152975137e-05,190.5116928,-0.02942183363,-0.0001771033975,-0.03813027351}, /*cmy*/
          {-0.003609342976,1.370199768,4.583638732,4.905747559}, /*cfy*/
          {-0.0008414276972,-2.24450723e-05,61.47910854,-0.2367875218,0.0009096408841,-0.004734752912}, /*cmz*/
          {4.909548476,4.442373907,4.460718672,11.23498244} /*cfz*/
     },
     {
          2461429.5,
          {0.02797859296,-1.82057751e-05,181.0523197,-0.1276476834,0.0002905723166,0.04089042115}, /*cmx*/
          {3.874195598,-0.5157971659,-0.6950247312,1.600713128}, /*cfx*/
          {0.1165370759,-9.843494694e-06,190.6460622,-0.1229947472,-0.0002768239939,-0.0413922963}, /*cmy*/
          {2.32587215,3.827753995,0.7151859364,3.181911163}, /*cfy*/
          {-0.01727598076,5.755338568e-05,62.7351701,-0.1431546583,6.410793689e-05,0.004439486797}, /*cmz*/
          {0.9397540104,0.6059012568,1.425999744,3.632569652} /*cfz*/
     },
     {
          2461687.5,
          {0.02006985007,-5.16484034e-05,188.9169627,0.06681140747,-0.0003864699244,0.03351906677}, /*cmx*/
          {6.125652842,2.166612694,1.909197429,6.04126644}, /*cfx*/
          {0.1157084561,-3.654307431e-05,189.6880181,0.06444460896,0.0004055737948,-0.03598757881}, /*cmy*/
          {4.572281652,6.040997719,2.930330867,1.388108191}, /*cfy*/
          {-0.01034961116,0.0001297841429,35.6026968,0.2392626478,-0.0009612897232,0.005668419977}, /*cmz*/
          {3.643936009,2.798265427,15.38502716,3.104399861} /*cfz*/
     },
     {
          2461945.5,
          {0.004796610425,-7.606236431e-05,189.5712636,0.03972142172,-0.0001009149909,0.04039664083}, /*cmx*/
          {2.095876212,3.366625915,-198.1426931,4.076867314}, /*cfx*/
          {0.1134388559,-7.033808945e-07,189.6108304,0.02818963769,2.209981518e-05,-0.03407719037}, /*cmy*/
          {0.5389830692,2.215456334,5.907456485,5.574999027}, /*cfy*/
          {0.01353159971,3.197443061e-05,31.84856279,-0.10882929,0.0005895121832,0.01721502905}, /*cmz*/
          {6.035083956,5.049869004,5.076786441,9.487427539} /*cfz*/
     },
     {
          2462203.5,
          {-0.01413003027,-1.414136885e-05,188.6112783,0.1248162091,-0.0003846206042,0.03973143527}, /*cmx*/
          {4.425440176,3.024101239,-3.294971527,2.347292411}, /*cfx*/
          {0.121333744,-2.201467487e-05,189.8989241,-0.1525832273,-0.0004424743796,-0.04117627941}, /*cmy*/
          {2.874945013,4.368741942,13.80098087,3.892414641}, /*cfy*/
          {0.004111746244,3.737451419e-05,39.29730294,-0.2621809063,0.0005599215794,-0.008899819853}, /*cmz*/
          {1.845504095,1.138631911,1.146428844,6.033729495} /*cfz*/
     },
     {
          2462461.5,
          {-0.02352579398,-5.1317408e-05,190.6657014,0.01411546536,0.0001582765125,0.03331125848}, /*cmx*/
          {0.42532483,4.979156721,5.180749367,0.5323289111}, /*cfx*/
          {0.114917764,-3.467294821e-05,189.2361945,0.009642825451,0.0002842692326,-0.03586770156}, /*cmy*/
          {5.141708622,0.02263413091,3.475918161,2.073339579}, /*cfy*/
          {0.01010881966,9.256130857e-05,26.07728609,0.1727585,-0.0009317554871,-0.009360959089}, /*cmz*/
          {4.905126076,3.428010418,3.431080291,-4.28953397} /*cfz*/
     },
     {
          2462719.5,
          {-0.04328029686,-5.911904447e-05,190.415664,-0.08307442155,0.0002879096165,0.04048560365}, /*cmx*/
          {2.659616124,1.073664717,1.101696605,4.866016848}, /*cfx*/
          {0.1092769318,8.033101088e-06,189.0839932,-0.09293839427,0.0002916621973,-0.03654791715}, /*cmy*/
          {1.076979219,5.812245428,5.816665978,0.151804054}, /*cfy*/
          {0.02578117861,1.162407361e-05,30.999324,0.0596853779,1.400800651e-05,-0.02203052038}, /*cmz*/
          {1.616439249,5.718354999,6.615748917,0.7643166236} /*cfz*/
     },
     {
          2462977.5,
          {-0.05940653634,-5.245924554e-06,191.5245867,0.09855586453,-0.0003660742588,0.0410765297}, /*cmx*/
          {4.974847808,3.061879977,3.123178966,3.140181798}, /*cfx*/
          {0.1158681615,-9.698316302e-06,189.1255558,0.1395322906,-0.0004912205162,-0.04260907743}, /*cmy*/
          {3.403378637,1.797284836,1.797431999,4.72094083}, /*cfy*/
          {0.01346865399,-2.811801438e-05,26.39057272,-0.3097193488,0.0009194626304,-0.01247268357}, /*cmz*/
          {3.448756304,1.763611263,-48.50851144,6.016805922} /*cfz*/
     },
     {
          2463235.5,
          {-0.06788202649,-5.68049526e-05,190.1176896,0.07603871968,0.0001325707059,0.03951410417}, /*cmx*/
          {1.002309909,5.823493241,9.892095783,1.399302108}, /*cfx*/
          {0.1057994619,-4.208758214e-06,189.0573194,0.07089893844,2.259855715e-05,-0.03685269292}, /*cmy*/
          {5.702265519,4.107200534,3.851176483,2.808575491}, /*cfy*/
          {0.01698439738,-2.651189422e-05,31.54475115,0.03582167059,-0.0005805054321,-0.02007004897}, /*cmz*/
          {6.251790613,4.339483674,4.110211168,3.23319558} /*cfz*/
     },
     {
          2463493.5,
          {-0.08885369733,-5.341241724e-05,184.688771,-0.1019745683,-0.000421523139,0.04407464162}, /*cmx*/
          {3.232424105,1.252364771,4.510576277,5.765980987}, /*cfx*/
          {0.09909276427,3.72305944e-05,189.2441197,-0.1211036063,-0.0004888673758,-0.04537151897}, /*cmy*/
          {1.625333434,0.09561484778,9.514747557,0.9926893519}, /*cfy*/
          {0.02124115602,-8.561791364e-05,55.74825016,0.1929073638,-0.0005709985812,-0.01984576614}, /*cmz*/
          {2.742257431,0.06829277105,0.02437082965,1.917861342} /*cfz*/
     },
     {
          2463751.5,
          {-0.09983517303,6.950673312e-08,186.8686472,0.08752012676,0.0003587561995,0.04597391568}, /*cmx*/
          {5.522625952,2.901068581,-0.09142223816,4.017526941}, /*cfx*/
          {0.1069349544,-7.497559253e-07,189.0780342,0.07394658888,0.0003351171325,-0.04995380718}, /*cmy*/
          {3.92113323,2.405667887,5.536958097,5.591060214}, /*cfy*/
          {-0.003125255121,-0.0001083429342,48.26098572,-0.2630658981,0.0009607829002,-0.011191898}, /*cmz*/
          {4.925408793,2.436299466,2.423105878,0.2968655188} /*cfz*/
     },
     {
          2464009.5,
          {-0.1082992635,-4.113417321e-05,186.5936808,0.1200950771,0.0002535054792,0.04878674206}, /*cmx*/
          {1.566826177,5.957783616,3.300470961,2.267496703}, /*cfx*/
          {0.09557137641,1.660476279e-06,189.1870406,0.1339567878,0.0002628784919,-0.04337915339}, /*cmy*/
          {6.247925213,4.655555438,1.501176268,3.686071946}, /*cfy*/
          {-0.007163625681,-0.0001270105338,49.33172636,-0.1177039005,-9.899163051e-05,-0.02629081706}, /*cmz*/
          {0.9885506789,4.5164804,5.548430406,4.079971964} /*cfz*/
     },
     {
          2464267.5,
          {-0.1267192575,-3.960699471e-05,174.9329846,-0.1138645371,0.000527991017,0.05174232547}, /*cmx*/
          {3.809040374,1.29169642,7.761956914,0.3531147328}, /*cfx*/
          {0.09041871226,1.080896896e-05,189.8045052,-0.08603446261,-0.0004669963608,-0.05458405541}, /*cmy*/
          {2.190215218,0.6893968392,3.809902246,1.86693815}, /*cfy*/
          {-0.01540719147,-0.0001373465135,79.61732681,0.2337131506,-0.0008953516933,-0.02533973739}, /*cmz*/
          {3.523408999,0.7461728239,-5.588586288,3.088400664} /*cfz*/
     },
     {
          2464525.5,
          {-0.1268738612,-8.378489716e-06,173.5489713,0.06441439056,-0.0003068289274,0.05457532426}, /*cmx*/
          {6.067316068,2.728843974,3.02292597,4.90982256}, /*cfx*/
          {0.09803207063,-5.399209296e-05,189.9081443,-0.01534204207,3.315587283e-05,-0.05835208584}, /*cmy*/
          {4.448916783,2.633484656,6.654849478,0.1167848916}, /*cfy*/
          {-0.05298127668,-9.724222158e-05,81.9787806,-0.1401078875,0.0006625886585,-0.01678995036}, /*cmz*/
          {5.800080293,3.220504636,3.169954835,1.484410296} /*cfz*/
     },
     {
          2464783.5,
          {-0.137675207,-4.863329261e-06,177.8636863,0.1758453701,-0.0004223039654,0.05741805857}, /*cmx*/
          {2.117085441,6.050037451,6.248915499,3.072197123}, /*cfx*/
          {0.08034900412,-3.067819926e-05,189.7570216,-0.1395816244,0.0004011755332,-0.05729097779}, /*cmy*/
          {0.4988651722,2.080696546,-4.216685036,4.515437922}, /*cfy*/
          {-0.0606760137,-0.0001269944658,74.39566824,-0.2236720114,0.0004285205989,-0.02401309781}, /*cmz*/
          {1.794203327,5.229755599,5.095996934,5.401446832} /*cfz*/
     },
     {
          2465041.5,
          {-0.1571473397,1.032887014e-05,163.4071517,-0.1034296026,0.0005840103727,0.05854539517}, /*cmx*/
          {4.381466143,1.3756203,1.677181887,1.130004558}, /*cfx*/
          {0.0691517593,-1.622404015e-05,190.3871615,0.004892007118,-0.0002196526106,-0.06769567403}, /*cmy*/
          {2.766449205,5.04733749,4.393221824,2.746891253}, /*cfy*/
          {-0.07183947357,-0.0001087630968,99.56235534,0.1765995199,-0.0008613718625,-0.03029279429}, /*cmz*/
          {4.216453905,1.498328455,1.392189772,4.25914882} /*cfz*/
     },
     {
          2465299.5,
          {-0.1378789875,-6.01225864e-05,153.321023,-0.0658904635,0.0002007649873,0.06368280308}, /*cmx*/
          {0.3213778331,4.822044099,11.72093358,5.739637478}, /*cfx*/
          {0.070461736,-9.188022453e-05,190.8037159,-0.07146246914,-0.0002428249812,-0.06481895868}, /*cmy*/
          {5.005046278,-9.108295902,0.2990181543,0.9577071201}, /*cfy*/
          {-0.1174298233,9.861142933e-06,114.1368698,-0.03603069915,0.0002115950625,-0.0261278065}, /*cmz*/
          {0.2411134988,-0.7036553137,4.435139453,2.348059514} /*cfz*/
     },
     {
          2465557.5,
          {-0.1431908816,-5.167316983e-05,161.7393341,-0.231002979,0.0006846796302,0.05744677906}, /*cmx*/
          {2.649919816,3.181280103,15.82136808,3.843327888}, /*cfx*/
          {0.04764609708,-6.074414503e-05,190.6045138,0.08005109863,0.0002998580143,-0.06742705241}, /*cmy*/
          {1.035338168,5.779838924,2.626216789,5.343183999}, /*cfy*/
          {-0.1227761281,-4.797457634e-05,103.364733,0.2535900571,-0.0007048067401,-0.03978420438}, /*cmz*/
          {2.506385838,-9.769314633,2.735708811,0.541351893} /*cfz*/
     },
     {
          2465815.5,
          {-0.1722958099,5.39035256e-05,150.3591536,-0.06050649893,-0.0004677574091,0.05654630723}, /*cmx*/
          {4.939022714,-36.68038528,5.078513279,1.877741395}, /*cfx*/
          {0.03179278857,-4.243946558e-05,190.8349697,0.0720405244,0.0001001120908,-0.07644455716}, /*cmy*/
          {3.344350972,1.761165879,4.924473932,3.588906813}, /*cfy*/
          {-0.1200283814,-9.911826573e-05,117.612911,-0.07462247425,0.0005587738939,-0.04752560567}, /*cmz*/
          {4.874134755,5.801994609,5.342133058,5.398140445} /*cfz*/
     },
     {
          2466073.5,
          {-0.1438400967,-6.728743886e-05,130.1384026,-0.1544737089,-0.0004910548669,0.06561754965}, /*cmx*/
          {0.8467779464,-1.567825257,1.722881864,0.2220402054}, /*cfx*/
          {0.02613311686,-0.0001099471428,190.8523654,-0.06143086273,-0.0002978489026,-0.07240534691}, /*cmy*/
          {5.595583213,4.01596678,0.8791270288,1.830372447}, /*cfy*/
          {-0.1631427629,6.246354119e-05,140.1808447,-0.1246720726,0.000347216722,-0.03618724307}, /*cmz*/
          {0.9165632439,0.9732494651,0.7221281239,3.48569593} /*cfz*/
     },
     {
          2458849.5,
          {-0.511596404,-0.0003646080804,185.2540041,0.1868999579,-0.0002297742524,-0.3646604136}, /*cmx*/
          {3.519020555,2.721846461,-3.986917852,1.120818107}, /*cfx*/
          {-1.301073385,0.0002632553979,263.7668909,0.0489784496,0.0001891383312,0.5034634141}, /*cmy*/
          {1.81282177,0.4427097888,3.440403227,2.610631328}, /*cfy*/
          {0.7284324508,-0.0009467296245,194.2998519,-0.1515181027,0.0001367304163,0.3515373357}, /*cmz*/
          {0.1177261952,6.430525153,-4.882703358,0.9558160408} /*cfz*/
     },
     {
          2459091.5,
          {-0.5270961415,-6.293212351e-06,213.4118479,-0.2207234692,-0.0009013368794,-0.3871517385}, /*cmx*/
          {5.923243573,5.435223902,2.184916892,6.026790672}, /*cfx*/
          {-1.337831009,0.0001711188163,265.536303,0.01745568921,-9.312511284e-05,0.5114416992}, /*cmy*/
          {4.308434432,2.088784238,6.30949615,1.263380216}, /*cfy*/
          {0.5351913521,0.0003064878579,159.9714827,0.2595273483,0.0009735252792,0.3378301193}, /*cmz*/
          {2.656522314,2.359661373,5.584374751,5.920397973} /*cfz*/
     },
     {
          2459333.5,
          {-0.5290707404,-0.0001147945906,210.559381,0.1834906642,0.0007888252644,-0.4125007876}, /*cmx*/
          {2.11109652,1.69847529,4.800918196,4.681956948}, /*cfx*/
          {-1.294062155,-0.0004203519406,265.4272532,-0.02305142858,-5.807202503e-05,0.5115885057}, /*cmy*/
          {0.4891390998,4.966531283,1.643045092,6.195205049}, /*cfy*/
          {0.4438877203,0.0001800775209,163.6341119,-0.2598600183,-0.001090926183,0.3004562424}, /*cmz*/
          {5.115834417,4.797698379,1.675243278,4.514242365} /*cfz*/
     },
     {
          2459575.5,
          {-0.5006142026,-0.000203640671,208.6815437,0.1360485434,-0.0001413486525,-0.3985059329}, /*cmx*/
          {4.619365249,3.681723174,21.37515002,3.292913596}, /*cfx*/
          {-1.286137993,-0.0005704076775,265.3189796,0.07232125519,0.0001790058578,0.5013417501}, /*cmy*/
          {2.99148054,1.467679157,4.584454007,4.82802333}, /*cfy*/
          {0.4986833323,-0.0008517008369,166.2072474,-0.1115531142,0.0002553592535,0.3087505224}, /*cmz*/
          {1.329742577,1.419626482,3.719310576,3.188274774} /*cfz*/
     },
     {
          2459817.5,
          {-0.6278812595,0.0009231518445,233.5075648,-0.1885065379,0.0007270415444,-0.4171141385}, /*cmx*/
          {0.7490867539,6.454038606,0.03708447408,1.922155455}, /*cfx*/
          {-1.357551016,-0.0001326234375,266.0179476,-0.03776845003,-0.0002646910842,0.5028801143}, /*cmy*/
          {5.462089861,3.958535764,0.7812636092,3.485282223}, /*cfy*/
          {0.3417318807,-3.79524128e-05,127.9747097,0.2676284886,0.0009152132984,0.2794005776}, /*cmz*/
          {3.889294902,3.57960867,6.790476844,1.891649388} /*cfz*/
     },
     {
          2460059.5,
          {-0.572189159,0.0003836926008,228.3313481,0.1859821727,-0.0007339692447,-0.4565347372}, /*cmx*/
          {3.229964244,2.721413554,2.679701103,0.5487600681}, /*cfx*/
          {-1.443231708,0.0003367936098,265.9677488,0.03030610004,0.0001566682141,0.5087533947}, /*cmy*/
          {1.650697944,0.06730229646,3.211649378,2.123256313}, /*cfy*/
          {0.2728978913,-4.499575828e-05,136.9994803,-0.3264785751,-0.001255825286,0.2341561017}, /*cmz*/
          {0.05343891775,6.028713463,2.901112337,0.5600109411} /*cfz*/
     },
     {
          2460301.5,
          {-0.4107932805,-0.0006262577767,229.6214837,0.09729877831,0.0001651472667,-0.4627894905}, /*cmx*/
          {5.730480515,4.561021424,6.001018165,5.504666825}, /*cfx*/
          {-1.468675437,0.0002954486857,265.9834886,0.08036529452,0.0001089761138,0.5147301879}, /*cmy*/
          {4.153047825,2.579512248,5.814044883,0.7556082097}, /*cfy*/
          {0.2933990056,-0.000495516843,134.2210199,-0.06018115597,0.0004818781249,0.2234750085}, /*cmz*/
          {2.562801419,2.823612814,5.20213034,5.366650052} /*cfz*/
     },
     {
          2460543.5,
          {-0.4655571915,3.262559418e-05,249.3896928,-0.148505899,0.0005491026247,-0.4520756593}, /*cmx*/
          {1.866103198,1.13480077,0.9696981338,4.121666346}, /*cfx*/
          {-1.395219846,-0.0004029463144,265.6541922,-0.07889850606,-0.0003760422653,0.5090996056}, /*cmy*/
          {0.3158517253,4.995591773,1.866746239,5.687081287}, /*cfy*/
          {0.1176997297,0.0002665615489,94.40355061,-0.2523179455,0.0007642506359,0.2332200187}, /*cmz*/
          {5.166987608,7.940628687,1.722100715,4.075543229} /*cfz*/
     },
     {
          2460785.5,
          {-0.4854805757,0.0002992254667,243.6205073,0.1726291223,-0.0006373478012,-0.4739146433}, /*cmx*/
          {4.354965438,3.678446984,3.627798152,2.704130593}, /*cfx*/
          {-1.367553543,-0.000596922422,265.8842523,0.09085671435,0.0003667516432,0.5046192857}, /*cmy*/
          {2.800335858,1.135124331,4.285673049,4.295263223}, /*cfy*/
          {0.0821861265,-0.0001387833393,108.1655445,0.3791832077,-0.001342421345,0.1730406966}, /*cmz*/
          {1.304774771,4.095670186,4.106174329,2.89875759} /*cfz*/
     },
     {
          2461027.5,
          {-0.4493708679,0.0003595260961,247.0637629,0.07026232083,0.0001928845252,-0.4853133056}, /*cmx*/
          {0.5653770377,5.345542959,6.691362847,1.349636764}, /*cfx*/
          {-1.450519607,-2.210023977e-05,265.7058314,0.06765575108,-3.606271928e-05,0.506340494}, /*cmy*/
          {5.295839546,3.722426459,-0.1553193898,2.943173827}, /*cfy*/
          {0.1427539526,-0.0006072596885,98.85409055,-0.02989363119,0.0007538034279,0.1514679343}, /*cmz*/
          {3.843189524,-0.4847802359,0.2317761251,1.50561029} /*cfz*/
     },
     {
          2461269.5,
          {-0.4727109435,0.0005855162541,260.2769408,-0.113147751,0.0004134070781,-0.4968613868}, /*cmx*/
          {2.98763901,1.986120148,1.808721861,0.02276528168}, /*cfx*/
          {-1.5179443,0.0004281693779,264.7389042,-0.1027117651,-0.0004055319183,0.5087261918}, /*cmy*/
          {1.438398163,6.112307321,9.27084877,1.595927097}, /*cfy*/
          {0.01436617188,2.885433336e-05,61.89835807,0.2121871669,0.0005267645423,0.123238931}, /*cmz*/
          {0.2864553188,5.985255298,2.905451485,0.1611505333} /*cfz*/
     },
     {
          2461511.5,
          {-0.354676242,-0.0002836440461,255.7115733,0.150955277,-0.0005303403936,-0.4973073171}, /*cmx*/
          {5.483754543,4.524359731,4.469549646,4.899309603}, /*cfx*/
          {-1.52170384,0.0004052322112,265.2219757,0.1459465566,0.0005243666196,0.5047654292}, /*cmy*/
          {3.937192921,2.273230779,5.420700009,0.2085641618}, /*cfy*/
          {-0.04678443107,-0.0002146499031,78.2284309,-0.4132838145,-0.001341394049,0.1101809052}, /*cmz*/
          {2.623523507,2.151443872,5.300640351,5.278731461} /*cfz*/
     },
     {
          2461753.5,
          {-0.2556279753,-0.0005229109195,259.4643412,0.04568188758,0.0001877827754,-0.5053084577}, /*cmx*/
          {1.686060585,-0.098459827,0.9554371943,3.518369162}, /*cfx*/
          {-1.462625387,-0.0001940503954,264.6958813,0.03715020715,-0.0002068589672,0.503247477}, /*cmy*/
          {0.136424329,4.945281207,1.500639988,5.094089199}, /*cfy*/
          {-0.05864762572,-0.0002927959107,63.0401078,0.09866360517,0.00100887258,0.08776116841}, /*cmz*/
          {5.259662718,4.499819262,1.457924612,4.289462549} /*cfz*/
     },
     {
          2461995.5,
          {-0.3364148198,0.0003926621081,265.582346,-0.08802577325,0.0003173178032,-0.5052783837}, /*cmx*/
          {4.111766808,2.750665619,2.629735413,2.161928555}, /*cfx*/
          {-1.419371979,-0.0005352244767,263.8741253,-0.1009853834,-0.0003374675275,0.5099703577}, /*cmy*/
          {2.550051628,0.9690360776,4.126808265,3.740184627}, /*cfy*/
          {-0.1183245593,2.982495434e-05,38.11647967,0.141955517,0.0001959755537,0.05052032738}, /*cmz*/
          {2.053442535,0.8896628287,4.130874015,2.973524669} /*cfz*/
     },
     {
          2462237.5,
          {-0.3506943594,0.0005324868742,263.7479722,0.1403694176,-0.0004704898783,-0.5007040946}, /*cmx*/
          {0.3310585112,5.227000752,5.205036746,0.7942641247}, /*cfx*/
          {-1.472572278,2.453404377e-05,264.3405357,0.1888906,0.0006144285281,0.4985722166}, /*cmy*/
          {5.061544995,3.41537458,0.2773462462,2.370554398}, /*cfy*/
          {-0.1065931147,-0.0004554447958,49.93794967,-0.4217269179,-0.001240966529,0.05901343796}, /*cmz*/
          {4.129759413,3.334014567,0.1946514455,2.045828348} /*cfz*/
     },
     {
          2462479.5,
          {-0.2787008295,0.000292964089,265.352692,0.01977495387,0.0002125910499,-0.4934031048}, /*cmx*/
          {2.8076604,1.284563105,1.230181477,5.711880263}, /*cfx*/
          {-1.529083949,0.0004835721997,263.7101953,-0.004577795477,-0.0003737376313,0.488874747}, /*cmy*/
          {1.243487128,4.872118388,2.718588,1.021288426}, /*cfy*/
          {-0.1670994096,-0.0002859665063,37.11608486,0.1720730006,0.001215630894,0.08534459982}, /*cmz*/
          {0.869378804,5.811268597,2.675207759,0.7849789269} /*cfz*/
     },
     {
          2462721.5,
          {-0.2094184148,9.887215412e-06,265.22398,-0.06742407046,0.0002136229043,-0.5048357806}, /*cmx*/
          {5.236695387,3.616020717,3.666932126,4.349869053}, /*cfx*/
          {-1.526889635,0.0003176492366,263.4313101,-0.07770681699,-0.0001999483431,0.4903678088}, /*cmy*/
          {3.654568669,14.6768402,5.269209179,5.898474248}, /*cfy*/
          {-0.2462500809,0.000143689169,42.58578347,0.06146457714,-0.0001411290191,0.1141278408}, /*cmz*/
          {4.176290867,2.06189557,5.170305671,6.409921002} /*cfz*/
     },
     {
          2462963.5,
          {-0.1127349137,-0.0005230648853,266.8200836,0.1528942104,-0.000469562694,-0.5002939372}, /*cmx*/
          {1.460717195,5.917672392,5.967289915,2.964610311}, /*cfx*/
          {-1.484219422,-0.000126166703,263.5678999,0.2089101841,0.0006183605688,0.5058299031}, /*cmy*/
          {6.174154807,4.559047754,1.418545959,4.514641411}, /*cfy*/
          {-0.1981377919,-0.0002381078334,36.28915176,-0.4045494159,-0.001054751806,0.1014152207}, /*cmz*/
          {-0.1528959138,4.515624245,1.369739574,5.441363487} /*cfz*/
     },
     {
          2463205.5,
          {-0.1335176904,7.528867651e-05,263.7482365,-0.03557919911,0.0003695767649,-0.4948549528}, /*cmx*/
          {3.927002088,-11.50779923,1.765721206,1.629112781}, /*cfx*/
          {-1.42989631,-0.0004399827175,263.2624971,-0.04604755516,-0.0005185031949,0.4896151349}, /*cmy*/
          {2.338259304,0.7301001532,3.882879165,3.172257339}, /*cfy*/
          {-0.2033697367,-0.0002845785542,49.94306215,0.2385482745,0.001362608921,0.09841597851}, /*cmz*/
          {3.062241251,0.753133912,3.872089074,3.772094349} /*cfz*/
     },
     {
          2463447.5,
          {-0.1998293012,0.0008456326736,259.3318917,-0.0439892543,-0.0001366175607,-0.4763018351}, /*cmx*/
          {0.07721234674,4.916186703,8.705837781,0.2600365391}, /*cfx*/
          {-1.441639629,-0.0001967566242,263.4816499,-0.04094287636,-3.880821842e-05,0.4858616883}, /*cmy*/
          {4.758165835,3.182059875,-0.1455987226,1.794896612}, /*cfy*/
          {-0.2683630318,1.515702951e-05,69.39040625,-0.03291368079,-0.0004899473852,0.1333905559}, /*cmz*/
          {5.795545225,3.525554882,0.1820165396,2.630119481} /*cfz*/
     },
     {
          2463689.5,
          {-0.0977022675,0.0001608714146,264.0349025,-0.1787835706,-0.0004700289295,-0.4798720013}, /*cmx*/
          {2.588545266,3.597774267,13.14376621,5.167761485}, /*cfx*/
          {-1.525395456,0.0003368390784,263.3675281,0.2056602041,-0.0005520909958,0.4915832054}, /*cmy*/
          {0.9967439984,5.695304829,-0.5910908175,0.404776391}, /*cfy*/
          {-0.2683901185,0.0001749806395,53.83366305,0.366685925,-0.000817603,0.1656986188}, /*cmz*/
          {1.801040732,2.537486645,2.512613344,1.428187328} /*cfz*/
     },
     {
          2463931.5,
          {-0.01649606127,-0.0002455279047,253.9743066,0.09584392219,0.000598023565,-0.4882905429}, /*cmx*/
          {5.042503485,5.492493285,2.639124983,3.815358743}, /*cfx*/
          {-1.556285252,0.0004052772793,263.711915,-0.07457947398,0.0005745526955,0.5052241555}, /*cmy*/
          {3.43153264,1.905277695,1.886636547,5.359059987}, /*cfy*/
          {-0.2274219918,6.622455466e-05,85.89361908,-0.2837482362,0.00140456444,0.1470894681}, /*cmz*/
          {4.612266642,5.096775927,5.058432902,0.1944083896} /*cfz*/
     },
     {
          2464173.5,
          {-0.005163374949,-9.160081305e-05,248.0311606,-0.04579689708,-0.0002940799637,-0.4836630488}, /*cmx*/
          {1.198693091,0.9313157512,4.478078007,2.464644726}, /*cfx*/
          {-1.489726053,-0.0001294636862,264.2184271,-0.003787937305,-0.0001009387177,0.4922857344}, /*cmy*/
          {5.866489724,3.684475709,4.4759846,3.97434708}, /*cfy*/
          {-0.1859834701,-0.0001861364992,100.6307109,0.1215238531,-0.0007848393688,0.1780106984}, /*cmz*/
          {0.8654877492,1.38497371,1.350270481,5.0523005} /*cfz*/
     },
     {
          2464415.5,
          {0.05075814825,-0.0001437076022,254.577266,0.1992526122,-0.0004243395153,-0.4541055769}, /*cmx*/
          {3.712873761,7.705615203,1.64231168,1.067078292}, /*cfx*/
          {-1.426965381,-0.0005851320059,263.8872653,-0.1816840896,-0.0004460161919,0.4958867008}, /*cmy*/
          {2.10096449,-21.45191863,0.5300033394,2.558704445}, /*cfy*/
          {-0.2119734537,0.0002037342632,86.32952554,0.3038308214,-0.0005259012406,0.2203149871}, /*cmz*/
          {3.285754687,3.684624175,3.597815527,3.803324012} /*cfz*/
     },
     {
          2464657.5,
          {0.00532439431,0.0004325962229,236.1991762,-0.1646146427,0.0008264029796,-0.4585621868}, /*cmx*/
          {6.151305337,3.476433071,-2.643353838,5.980517684}, /*cfx*/
          {-1.462442846,-0.0003045502617,264.8512498,0.08257359998,0.0005387458794,0.5015364418}, /*cmy*/
          {4.532649533,6.20187017,3.027217989,1.211555712}, /*cfy*/
          {-0.2160918103,0.0005875766267,124.8383256,-0.3030639757,0.001341296122,0.2206260034}, /*cmz*/
          {5.929653004,6.289702933,6.238836416,2.567469514} /*cfz*/
     },
     {
          2464899.5,
          {-0.02238706401,0.0004572313617,231.8057454,0.1113551337,-0.000586623081,-0.4451138182}, /*cmx*/
          {2.316671565,5.719144806,5.810592079,4.597550379}, /*cfx*/
          {-1.552579108,0.0003798907859,265.1151664,-0.01729633164,-0.0001480673289,0.5093999815}, /*cmy*/
          {0.7002109173,2.550563046,5.586926873,6.143123312}, /*cfy*/
          {-0.1413341187,0.0004108602759,132.0857606,0.1912906591,-0.0009710056107,0.2371216104}, /*cmz*/
          {2.128963098,2.565182875,2.543570302,1.341218384} /*cfz*/
     },
     {
          2465141.5,
          {0.1163309125,-0.0004049619314,238.3292495,0.2014305013,-0.0003158310467,-0.4471823904}, /*cmx*/
          {4.831158065,2.464996616,2.879909961,3.242532575}, /*cfx*/
          {-1.5672263,0.0004433365417,264.8392402,-0.1460648712,-0.0003397766451,0.5023299959}, /*cmy*/
          {3.211474099,-1.478691848,1.654757689,4.766558504}, /*cfy*/
          {-0.09692695395,0.0002714320338,121.8499257,0.2321734247,-0.0002574275669,0.2439820369}, /*cmz*/
          {4.595855313,4.819185018,4.524781276,-0.1190082219} /*cfz*/
     },
     {
          2465383.5,
          {0.1483682162,-0.0002322313451,211.669422,-0.2251636647,-0.0009863728175,-0.422095877}, /*cmx*/
          {0.9658382002,4.603488539,7.852487578,1.87160062}, /*cfx*/
          {-1.503971908,-0.0001345929211,265.826863,0.06955370909,0.0004311604997,0.5093526397}, /*cmy*/
          {5.650611106,1.026212295,4.135382626,3.38933607}, /*cfy*/
          {-0.0218868013,-2.777101336e-05,161.6963074,-0.2912467271,-0.001168830161,0.2876800156}, /*cmz*/
          {0.8926433801,1.193067612,-2.016508982,4.840105096} /*cfz*/
     },
     {
          2465625.5,
          {0.09814672642,2.317335641e-05,211.3644793,0.2001421068,0.0009033300694,-0.4027163223}, /*cmx*/
          {3.427612116,0.6583858272,3.837125567,0.4393066432}, /*cfx*/
          {-1.454333292,-0.0005046254091,265.8057784,-0.01457898185,-0.0001051584446,0.5095219667}, /*cmy*/
          {1.830393818,3.606207321,0.3866033869,2.01577491}, /*cfy*/
          {0.0355593474,0.0002262530836,161.8763337,0.2393989617,0.001057318809,0.3194120609}, /*cmz*/
          {3.356568707,3.754259442,0.5947431547,3.589101721} /*cfz*/
     },
     {
          2465867.5,
          {0.1018214561,-7.741952248e-06,215.3663661,0.1751611513,-0.0001809167881,-0.3873737812}, /*cmx*/
          {5.93862137,3.561689624,10.98058958,5.351814397}, /*cfx*/
          {-1.471699063,-0.0001947918762,265.8064847,-0.111434749,-0.0002719808915,0.5040776064}, /*cmy*/
          {4.33591844,5.90821999,2.778191164,0.6517826431}, /*cfy*/
          {0.02338714958,0.0007908916015,156.9076256,0.1567324982,0.0001480632054,0.3203671938}, /*cmz*/
          {5.847699354,5.863126636,1.250487013,2.251562662} /*cfz*/
     },
     {
          2466109.5,
          {0.04131030934,0.000686110676,182.1043401,-0.2647306204,-0.001037259996,-0.3781029943}, /*cmx*/
          {2.046241702,5.722250731,2.663633702,4.008843906}, /*cfx*/
          {-1.536486595,0.0004127444838,265.8803465,0.03819988787,0.0002780600452,0.4985344982}, /*cmy*/
          {0.5083184172,2.033574429,5.193989816,5.589129885}, /*cfy*/
          {0.1146888336,0.00027124701,194.4851614,-0.2534809964,-0.0009211447289,0.327891159}, /*cmz*/
          {2.109808747,2.373943799,105.9497087,0.8925492908} /*cfz*/
     },
     {
          2458849.5,
          {0.05454669368,0.001055264203,305.0216513,0.2290877879,0.0001182745704,0.2900275417}, /*cmx*/
          {-5.681555194,-6.332999222,-29.74747758,-5.101534224}, /*cfx*/
          {1.334106123,-0.000288143837,432.7991166,-0.01450014276,-0.0001234043397,0.4411043119}, /*cmy*/
          {-1.100208037,-10.725262,-2.59711179,-0.4331813027}, /*cfy*/
          {-0.1930823836,-1.617890807e-05,316.9192038,0.2020956515,-0.0002367236401,0.3255187402}, /*cmz*/
          {-2.792775186,-6.117193389,-3.329718717,-2.003053917} /*cfz*/
     },
     {
          2459072.5,
          {0.2620822835,-0.001233096732,350.8435262,-0.3067054198,0.0009731711925,0.2408452161}, /*cmx*/
          {4.384588396,3.808685642,-2.516887478,2.557046652}, /*cfx*/
          {1.084484116,0.0005165894484,435.6492243,0.02983054803,0.0001440139102,0.3855340336}, /*cmy*/
          {2.771950586,4.849239802,1.530204129,0.9764876262}, /*cfy*/
          {-0.1411322112,9.269677864e-05,261.1571852,-0.3363479649,-0.001033190907,0.3096828952}, /*cmz*/
          {1.123294851,4.046190223,0.9309560947,5.695167525} /*cfz*/
     },
     {
          2459295.5,
          {0.109317126,0.0005738485245,333.8125796,0.4220961984,-0.001425125702,0.3304598944}, /*cmx*/
          {1.988338976,1.456867088,1.401817126,4.121546703}, /*cfx*/
          {1.353755928,-0.0007457905654,434.8792878,-0.01445063693,-0.0001250591846,0.4259720132}, /*cmy*/
          {0.347829757,3.271755601,5.432628708,2.457547227}, /*cfy*/
          {-0.1724938447,-0.0001801330761,284.388409,0.5432103123,0.00175650857,0.2952586699}, /*cmz*/
          {4.96091396,1.56794878,4.742958796,0.7426997101} /*cfz*/
     },
     {
          2459518.5,
          {0.08535615385,-0.0001779262217,354.6435509,-0.2128225881,0.001400265957,0.308013132}, /*cmx*/
          {5.826227006,5.364168143,5.312075191,5.318873898}, /*cfx*/
          {1.067679787,0.0008085821135,435.7032449,-0.008843415785,6.616872433e-05,0.3911980193}, /*cmy*/
          {4.21925422,-13.91572604,3.344246323,3.808711693}, /*cfy*/
          {-0.177040776,0.0007027568361,254.6870889,-0.2978675794,-0.001899099424,0.2322322274}, /*cmz*/
          {2.579479702,5.410526871,2.28935367,2.320198916} /*cfz*/
     },
     {
          2459741.5,
          {0.1964508848,0.0004151147873,372.8316496,0.1139958126,-0.0008334416891,0.3105043888}, /*cmx*/
          {3.366626937,3.21474737,2.979501011,0.6154735683}, /*cfx*/
          {1.315990423,-0.0009407729234,436.1341264,-0.03537629783,-2.460862918e-05,0.407732}, /*cmy*/
          {1.785254945,0.1358779162,-16.30407103,5.368752248}, /*cfy*/
          {-0.1127904272,0.0002590351387,226.6378926,0.2031062099,0.00134328737,0.2520733135}, /*cmz*/
          {0.1867943337,2.936981933,6.147894523,3.899296199} /*cfz*/
     },
     {
          2459964.5,
          {0.1123933928,-3.741391943e-08,359.6441199,0.2282162632,-0.0002145213988,0.3135335864}, /*cmx*/
          {0.9762157293,0.2984382686,-0.1523718429,1.908998774}, /*cfx*/
          {1.085016192,0.0008836146979,435.9144903,0.05487883312,-0.000106091346,0.3841493866}, /*cmy*/
          {5.660159697,4.175431235,-8.305016333,0.3891828719}, /*cfy*/
          {-0.003392310169,0.0002619495246,248.1068604,0.292012307,-4.73182832e-05,0.2498755416}, /*cmz*/
          {4.028539511,0.6398885732,2.701190188,5.254484488} /*cfz*/
     },
     {
          2460187.5,
          {0.2924682608,-0.0006014334518,396.448506,-0.2752376456,-0.0009569588776,0.3024037743}, /*cmx*/
          {4.778298914,4.135344708,0.9557933492,3.559751524}, /*cfx*/
          {1.274113265,-0.0009346902911,436.1558255,-0.1017911279,0.0003927496682,0.3967746729}, /*cmy*/
          {3.220592451,1.639746786,1.640282187,1.942189215}, /*cfy*/
          {-0.02991543654,-0.0003510516823,183.5802795,-0.4251040824,-0.001425470179,0.2776537496}, /*cmz*/
          {1.706435197,4.536778383,26.54112756,0.2965394449} /*cfz*/
     },
     {
          2460410.5,
          {0.0522601412,0.0002643666735,384.9690525,0.3257163985,0.001176462335,0.3675830798}, /*cmx*/
          {2.372181275,1.766819081,4.836733942,4.815078522}, /*cfx*/
          {1.135512827,0.0007644930659,436.3156005,0.1149719095,-0.0005051308677,0.4162093379}, /*cmy*/
          {0.8057371305,5.45548375,5.468758559,3.233866449}, /*cfy*/
          {-0.01346943528,0.000169938163,206.8806654,0.6196427232,0.00211365718,0.1830291582}, /*cmz*/
          {5.527034725,2.075285344,5.236231392,1.526288245} /*cfz*/
     },
     {
          2460633.5,
          {0.2268582739,-0.000138868637,397.8213097,-0.1282316579,-0.0009917416692,0.3172129556}, /*cmx*/
          {6.222419817,5.723690068,2.476708244,6.273598277}, /*cfx*/
          {1.204705121,-0.0009027243294,436.0148166,-0.03660361099,0.000387901712,0.367792828}, /*cmy*/
          {4.665696896,2.97187865,3.007980079,4.78837332}, /*cfy*/
          {-0.09897657728,0.0008462140581,178.8322864,-0.28593722,-0.002038229836,0.1754357477}, /*cmz*/
          {3.166622897,5.929116798,2.801954337,3.43136305} /*cfz*/
     },
     {
          2460856.5,
          {0.07118403852,0.000628977718,413.1016352,0.05651800508,0.0004959252565,0.3590254364}, /*cmx*/
          {3.76271793,3.970190438,0.2065283191,1.367909119}, /*cfx*/
          {1.148650207,0.0005628947294,435.2871275,-0.01375215385,-0.0001815495709,0.3890263208}, /*cmy*/
          {2.214481441,0.7762004542,0.5526448529,6.103521101}, /*cfy*/
          {0.1023409637,0.0002357945957,142.9796418,0.163593476,0.001291788408,0.1870882553}, /*cmz*/
          {0.8345142863,3.476225838,0.3880946875,4.935647724} /*cfz*/
     },
     {
          2461079.5,
          {0.2768254381,-0.0006188923054,403.2921681,0.2042789248,0.0003237356752,0.3156817675}, /*cmx*/
          {1.369929605,0.5410036681,3.506724825,2.862197158}, /*cfx*/
          {1.118194706,-0.0005265207182,435.9397605,-0.1323937384,-0.0002104933397,0.3538948}, /*cmy*/
          {6.100834654,7.599945505,4.533691765,1.37193636}, /*cfy*/
          {0.02807778488,0.0004279415309,168.5960552,0.3782348323,0.0002310583792,0.2101648596}, /*cmz*/
          {4.633070878,1.139194034,4.417348482,-0.02512680303} /*cfz*/
     },
     {
          2461302.5,
          {0.08727026785,0.000454796912,426.6900937,-0.2192766068,-0.000827650239,0.3810735083}, /*cmx*/
          {5.181913864,4.316999629,1.141523893,4.289031683}, /*cfx*/
          {1.230613919,0.0001204661226,434.3490941,0.1832055296,0.0007057646665,0.4271430632}, /*cmy*/
          {3.632843664,5.164199829,2.026150295,2.721170457}, /*cfy*/
          {0.08098453327,-0.0001527852109,102.3709827,-0.4994351171,-0.001796258045,0.1876838666}, /*cmz*/
          {2.4758458,5.023781548,1.886754262,0.9561501557} /*cfz*/
     },
     {
          2461525.5,
          {0.2387574611,-0.0008406350707,421.2335014,0.2147664552,0.0008566515154,0.3431462363}, /*cmx*/
          {2.769982767,1.875287223,4.934590219,5.650448005}, /*cfx*/
          {1.063141997,-0.0002141384176,434.812791,-0.20776484,-0.0008579767469,0.3507003896}, /*cmy*/
          {1.223392834,2.695555181,5.847855189,4.094404093}, /*cfy*/
          {-0.02830176575,0.0008448680696,122.0570786,0.6609791925,0.002362936141,0.06568400983}, /*cmz*/
          {-0.0541323101,2.579161763,5.729854011,2.700737978} /*cfz*/
     },
     {
          2461748.5,
          {0.06982887661,0.001072284069,426.4363457,-0.05149569053,-0.0005776124899,0.3741311507}, /*cmx*/
          {0.3440438435,5.870429769,2.533720643,0.8133356935}, /*cfx*/
          {1.249275065,-0.0004766630682,434.1132465,0.05784057419,0.0006403072242,0.3942479044}, /*cmy*/
          {5.077098689,0.2664577359,3.422018622,5.550738399}, /*cfy*/
          {0.08123830708,0.0006281110913,99.95650014,-0.2514031101,-0.002056030196,0.1190034923}, /*cmz*/
          {3.946846354,0.1697592763,3.313655043,4.631013632} /*cfz*/
     },
     {
          2461971.5,
          {0.2087781715,-0.0007195635691,434.2049056,-0.03876189296,0.0001816767346,0.3314526804}, /*cmx*/
          {4.165848027,2.216156217,0.4244040405,2.231270708}, /*cfx*/
          {0.9533756422,0.0004532755607,432.9693626,0.02211646755,-0.0002384303396,0.3106728852}, /*cmy*/
          {2.60714816,4.307833208,0.9450091589,0.7150946939}, /*cfy*/
          {0.1360248013,0.0004411906297,67.75051141,0.1072624841,0.001134224604,0.1577236337}, /*cmz*/
          {1.948000081,3.993454505,0.8929634003,6.116440337} /*cfz*/
     },
     {
          2462194.5,
          {0.1689997541,0.0006032562243,430.5767023,-0.1702425163,0.0003751358615,0.3952018087}, /*cmx*/
          {1.772582783,3.668834126,3.71704803,3.707196958}, /*cfx*/
          {1.264973172,-0.0008545339641,433.623032,0.2076213703,-0.0003788690748,0.406052824}, /*cmy*/
          {0.2213338482,11.1513356,4.898925212,2.205146798}, /*cfy*/
          {0.1312115706,0.0001212306497,88.54084535,0.4540719506,0.000510974983,0.144690076}, /*cmz*/
          {5.498663395,1.634075956,4.802359577,0.6699260109} /*cfz*/
     },
     {
          2462417.5,
          {0.125028721,-0.000578019934,436.8084517,0.1754642653,-0.0007180235295,0.3538143569}, /*cmx*/
          {5.588610695,1.031629287,1.024105693,5.021962484}, /*cfx*/
          {0.9909125993,0.0006287217768,432.2315491,-0.2472034107,0.0009912932438,0.3722933984}, /*cmy*/
          {4.015906832,2.436499478,2.438215043,3.446129852}, /*cfy*/
          {0.0358402432,0.0005525404941,59.95981876,-0.5431291859,-0.002067520218,0.05197674357}, /*cmz*/
          {4.112866329,5.506873285,2.364255401,1.466548295} /*cfz*/
     },
     {
          2462640.5,
          {0.24547905,-2.1941135e-05,436.7682236,-0.1624882996,0.0007209853775,0.3743798744}, /*cmx*/
          {3.173240475,4.58586093,4.60285043,0.2394875914}, /*cfx*/
          {1.259327876,-0.001391107623,432.3900946,0.2559451483,-0.001070773,0.3749213942}, /*cmy*/
          {1.607045287,-0.007734142962,-0.004139996997,4.960461108}, /*cfy*/
          {0.07117267796,0.0006841629263,59.96735668,0.6633614198,0.002475614104,-0.04674842022}, /*cmz*/
          {1.36443425,3.085292966,6.227646865,2.101909377} /*cfz*/
     },
     {
          2462863.5,
          {0.02284596992,0.0003254303068,435.7548394,0.02816047519,-0.0004506704383,0.3424107784}, /*cmx*/
          {0.7510167156,1.425781457,1.940462905,1.591358855}, /*cfx*/
          {0.9538291589,0.0008342131566,432.0603829,-0.05219407502,0.0007312882489,0.3246556758}, /*cmy*/
          {5.460390405,3.840152868,3.851795369,-0.03184646951}, /*cfy*/
          {0.1478717798,0.0005077415805,60.75393062,-0.1986348807,-0.001946165235,-0.1003522505}, /*cmz*/
          {5.588798684,0.6959702279,3.822138914,3.039032536} /*cfz*/
     },
     {
          2463086.5,
          {0.3056480947,-0.0004948190422,431.3504044,0.05205925287,9.347078111e-05,0.3754558438}, /*cmx*/
          {4.569578633,6.139691399,5.029784194,3.164981565}, /*cfx*/
          {1.121674657,-0.0008906037416,432.0029728,-0.04517673308,-0.0001769847364,0.3471687539}, /*cmy*/
          {2.977693981,1.461428123,1.397532684,1.668168401}, /*cfy*/
          {0.240735547,-0.0002961452047,89.01205638,0.03774543121,0.0008733401527,-0.1179730956}, /*cmz*/
          {3.800705841,4.52856769,1.397674202,3.802156499} /*cfz*/
     },
     {
          2463309.5,
          {0.01108255903,0.0007474175869,436.2385747,-0.1851901849,-0.0004070085153,0.3879775318}, /*cmx*/
          {2.176676832,15.92097416,6.773790394,4.36188612}, /*cfx*/
          {1.030913434,0.0007378504171,431.8020187,0.2503807885,-0.000533921083,0.3996527202}, /*cmy*/
          {0.5968352706,5.295240348,5.304358048,2.859077398}, /*cfy*/
          {0.1258012297,0.0001180019224,68.19339185,0.5051697528,0.0007669654524,-0.02469848222}, /*cmz*/
          {1.027138446,2.11918675,5.230892669,-21.43227054} /*cfz*/
     },
     {
          2463532.5,
          {0.3214830667,-0.001120036314,423.4001774,0.2083025144,0.0008749920963,0.3437470992}, /*cmx*/
          {5.993143825,0.7254783616,3.897509124,5.918183793}, /*cfx*/
          {1.098197248,-0.0009608054354,432.2620187,-0.255399843,0.001072582908,0.3464891084}, /*cmy*/
          {4.387323018,2.859206776,2.858222801,4.32581286}, /*cfy*/
          {0.08828705658,0.0003883602173,122.7790492,-0.5480737247,-0.00219281347,-0.06369925357}, /*cmz*/
          {5.474509023,5.993849622,2.847640432,15.28219114} /*cfz*/
     },
     {
          2463755.5,
          {0.03228127377,0.0006929618963,426.9279832,-0.2475299395,-0.001045853386,0.3488090454}, /*cmx*/
          {3.574358787,4.27532775,1.209914948,0.9561669376}, /*cfx*/
          {1.096633847,3.473557587e-05,432.0544855,0.2391873073,-0.001044745126,0.3661495825}, /*cmy*/
          {1.972919318,0.4357679292,0.4324626517,5.612228996}, /*cfy*/
          {0.0759619644,0.0009339962544,110.9970476,0.6270921373,0.002434704866,-0.1076733797}, /*cmz*/
          {2.982277404,3.597640925,0.448093017,3.651788605} /*cfz*/
     },
     {
          2463978.5,
          {0.2434939481,-0.0008607027302,422.0710508,0.05407736112,0.0007270156511,0.319650907}, /*cmx*/
          {1.154656533,1.22795327,4.866744584,2.518876866}, /*cfx*/
          {0.9444169024,-0.0002212517397,432.1930723,-0.01792549705,0.0005906101981,0.2944799819}, /*cmy*/
          {5.831791743,4.276528803,4.284622659,0.9161274951}, /*cfy*/
          {0.2231821434,-0.000169377804,123.9948905,-0.1349940592,-0.001719207403,-0.1003254187}, /*cmz*/
          {0.6390279192,1.225454991,4.327493022,4.280715307} /*cfz*/
     },
     {
          2464201.5,
          {0.08883045154,0.0008074796062,402.0996666,0.07237334492,-0.0001853147926,0.4069324963}, /*cmx*/
          {4.96559317,6.257919418,1.707352341,3.83184427}, /*cfx*/
          {1.110711551,-9.233727853e-05,433.7548716,-0.07048086736,-3.116431494e-05,0.3878270228}, /*cmy*/
          {3.348469188,1.85104752,1.892301886,2.348489184}, /*cfy*/
          {0.1623404944,0.0001158221347,175.7195696,-0.03266125186,0.0005610955897,-0.008969576452}, /*cmz*/
          {4.665941652,4.750935063,1.957933954,5.544994184} /*cfz*/
     },
     {
          2464424.5,
          {0.230312247,-0.0007840228236,416.3918114,0.281109642,0.0005475640242,0.3157826903}, /*cmx*/
          {2.5754651,6.411773101,16.05059055,5.154128796}, /*cfx*/
          {0.9165667205,0.0002532374318,432.7547932,0.231578596,-0.0005697051223,0.3407865533}, /*cmy*/
          {0.9631201191,5.710246315,5.699076082,3.606989572}, /*cfy*/
          {0.1172492022,-0.0002524862117,144.3423367,0.5179518336,0.0009391677701,-0.1038559277}, /*cmz*/
          {2.156413445,27.74199534,5.691373359,8.671035896} /*cfz*/
     },
     {
          2464647.5,
          {0.1583727374,0.0002723273007,385.6321775,-0.3084853424,-0.001322602474,0.3282612269}, /*cmx*/
          {0.1041979275,3.894092197,0.7789042036,0.3795870321}, /*cfx*/
          {1.168703916,-0.0009652284009,434.5659436,-0.203920316,0.0009030702465,0.3638139728}, /*cmy*/
          {4.768583673,3.287470983,3.284644656,5.085384782}, /*cfy*/
          {0.03427486197,0.001145685791,208.5225374,-0.5113483272,-0.002141858419,-0.1440952495}, /*cmz*/
          {6.174545059,0.2103967316,3.344400967,3.456170035} /*cfz*/
     },
     {
          2464870.5,
          {0.1661100153,-0.0008595314851,390.0197068,0.3665331236,0.001539265293,0.2720122766}, /*cmx*/
          {3.965552816,1.303066095,4.500523321,1.719893869}, /*cfx*/
          {0.8661144316,0.0005417148109,434.3489571,0.1543273596,-0.0007331111697,0.3059993679}, /*cmy*/
          {2.346190598,0.8650097003,0.8514969878,0.0957152188}, /*cfy*/
          {0.1010491952,0.0002335684998,200.8063617,0.5572534974,0.002244091241,-0.1572191952}, /*cmz*/
          {3.732786344,4.121148754,0.9609544685,4.644135202} /*cfz*/
     },
     {
          2465093.5,
          {0.1606007079,0.0004448296619,384.1986403,-0.05596054405,-0.0009938566157,0.3479058972}, /*cmx*/
          {1.548332536,4.437885937,1.920823864,3.333402456}, /*cfx*/
          {1.096951498,-0.0009113259753,434.4517591,0.02486754576,0.0002733422033,0.340108906}, /*cmy*/
          {6.213104553,4.703242819,4.70033962,1.762020771}, /*cfy*/
          {0.1860290796,0.0001998464597,209.6344508,-0.0697479313,-0.001394960344,-0.09662021716}, /*cmz*/
          {1.336665944,1.883401655,4.858806643,5.98837065} /*cfz*/
     },
     {
          2465316.5,
          {0.1560645876,-0.0003809663761,348.2807132,-0.1058741613,0.0001581219103,0.3268039406}, /*cmx*/
          {5.343916089,3.106283997,4.972908849,4.442139329}, /*cfx*/
          {0.8798397184,0.0008197767397,436.069506,-0.07873397971,0.0001174505434,0.3479732851}, /*cmy*/
          {3.744879218,2.227644349,2.175906731,2.983182419}, /*cfy*/
          {0.05748663995,-0.0002103881842,263.3210564,-0.08553624823,0.000286818464,-0.1109027197}, /*cmz*/
          {5.267724981,5.275471314,2.718197596,1.808156036} /*cfz*/
     },
     {
          2465539.5,
          {0.2730962387,-0.000120334491,370.945251,-0.4096091623,-0.0008453518844,0.2784417333}, /*cmx*/
          {2.961213731,9.766993304,6.739501531,5.976695918}, /*cfx*/
          {1.063637334,-0.00107358773,435.4013328,0.1520637121,-0.0004617788648,0.3289458057}, /*cmy*/
          {1.346654905,6.103092696,6.093690683,4.507108817}, /*cfy*/
          {0.1007208522,0.000211010484,233.215087,0.4832118793,0.000981645827,-0.1884908691}, /*cmz*/
          {2.810715756,-3.177149001,-0.1235539671,3.108617523} /*cfz*/
     },
     {
          2465762.5,
          {0.09360027243,-0.0002140597043,326.8042202,0.4050010319,0.001796476816,0.2611889252}, /*cmx*/
          {0.4753967722,1.018765931,4.177754886,0.9962210174}, /*cfx*/
          {0.9238961213,0.000493881436,436.2886204,-0.1087191768,0.0005204442084,0.3252273737}, /*cmy*/
          {5.180376925,3.66429341,3.661317352,5.746445129}, /*cfy*/
          {-0.04320148675,0.0008054143177,289.5509182,-0.4414246064,-0.001928855022,-0.1961413653}, /*cmz*/
          {0.4600763335,0.7255839619,3.855626977,4.26258092} /*cfz*/
     },
     {
          2465985.5,
          {0.245915654,-0.0004587462705,329.3766832,-0.4575414719,-0.001964471364,0.2305603863}, /*cmx*/
          {4.33367777,4.77154475,1.668035204,2.692750241}, /*cfx*/
          {0.9562279732,-0.0007549198724,436.3001296,0.03291174846,-0.0002439835986,0.2979847819}, /*cmy*/
          {2.752858263,1.108759081,1.1378903,1.104861806}, /*cfy*/
          {0.1939947624,-0.0002385151612,286.6824593,0.4550806643,0.001893056634,-0.1963443072}, /*cmz*/
          {4.311972969,4.662171309,1.486986901,5.769630642} /*cfz*/
     },
     {
          2458849.5,
          {0.8872370919,0.0002424794185,407.7842513,-0.2618810776,0.0002546312,0.3117744253}, /*cmx*/
          {-1.15209063,-4.890070532,-1.561368231,-1.53258871}, /*cfx*/
          {0.2116629376,6.147263429e-06,579.0411003,-0.01598677888,-6.734867626e-05,0.4558517276}, /*cmy*/
          {-2.85010979,-5.730933847,1.793328537,-2.74163717}, /*cfy*/
          {-1.049067375,0.001322412192,423.5036692,-0.2295766802,0.0005347402559,0.3572825662}, /*cmz*/
          {-4.538279054,-4.667705203,-1.843093289,-3.908085301} /*cfz*/
     },
     {
          2459055.5,
          {0.7536753209,0.0002421954967,466.5878762,0.2542878124,0.0004694016219,0.4321397814}, /*cmx*/
          {0.6615400409,3.191434905,-0.1938181706,2.391633289}, /*cfx*/
          {0.5002271149,0.0002067684843,582.5196575,-0.0268850568,0.0001713210124,0.4425010472}, /*cmy*/
          {5.331601226,4.186084639,3.872058745,0.8557661362}, /*cfy*/
          {-0.920927034,-0.0004881612348,352.137781,0.2859012495,0.0004594440837,0.1910713755}, /*cmz*/
          {3.685747711,3.416441073,0.334899267,5.638476143} /*cfz*/
     },
     {
          2459261.5,
          {1.080660136,0.0003600693623,436.1661969,-0.5111107411,-0.001154815055,0.5024641698}, /*cmx*/
          {2.590417814,5.167620571,2.002482074,6.488582476}, /*cfx*/
          {0.3731796343,-0.000479812305,581.1579871,0.02365702912,-7.729228386e-05,0.487292251}, /*cmy*/
          {0.9378781981,6.541437579,6.221489692,4.813710929}, /*cfy*/
          {-1.056318503,0.001236777766,392.4529069,-0.5965428442,-0.001226287911,0.1775236294}, /*cmz*/
          {5.54650308,5.323241658,2.218675452,2.681796254} /*cfz*/
     },
     {
          2459467.5,
          {1.090089346,-0.001110723818,488.0193504,0.4451678006,0.001798633904,0.2877173975}, /*cmx*/
          {4.420311179,0.7573732431,3.862175377,3.935846219}, /*cfx*/
          {0.355144439,0.0008183413642,583.3673171,-0.03029474772,0.0001948796791,0.4113298697}, /*cmy*/
          {2.830621871,1.838339984,1.614916393,2.18245105}, /*cfy*/
          {-0.517525977,-0.001031257515,321.0629643,0.5702856628,0.002240019295,0.3317075335}, /*cmz*/
          {1.21285697,0.9210948289,4.079866117,0.3400909582} /*cfz*/
     },
     {
          2459673.5,
          {1.24591355,0.0002049496918,472.3159954,-0.5279733787,-0.00186411001,0.3999983921}, /*cmx*/
          {0.04296231978,2.618573187,5.734934052,1.294295759}, /*cfx*/
          {0.5176539433,-0.0002798489757,582.9113909,0.07673748046,-0.0003316581694,0.5212806501}, /*cmy*/
          {4.72056116,9.526235491,3.225751114,5.987423618}, /*cfy*/
          {-0.6924667363,-0.0003325649758,345.0617701,-0.7547682904,-0.002613534382,0.3253550486}, /*cmz*/
          {3.079762697,2.812857134,5.96416716,4.356219331} /*cfz*/
     },
     {
          2459879.5,
          {1.040445209,-2.792197103e-05,498.6123275,0.3368078458,0.001988989331,0.3790106743}, /*cmx*/
          {1.906728252,4.544335667,1.352133302,5.211798147}, /*cfx*/
          {0.2573851602,0.0006304242893,583.2619609,-0.03040613785,0.0003031904104,0.4426538484}, /*cmy*/
          {0.3270080542,5.108351376,5.082316025,3.526892558}, /*cfy*/
          {-0.7369390443,0.0005809703968,303.0012175,0.5045583068,0.002890636345,0.2190940904}, /*cmz*/
          {5.014408086,4.693751238,1.567957513,1.807511481} /*cfz*/
     },
     {
          2460085.5,
          {1.119133683,0.00130748058,508.8551256,-0.3371962588,-0.001660721048,0.4384190693}, /*cmx*/
          {3.778578198,0.1081943585,3.220745827,2.506328196}, /*cfx*/
          {0.6063206417,-0.0001383092715,583.3893103,0.07535896375,-0.0004282716469,0.4981635835}, /*cmy*/
          {2.208093487,0.6216993984,0.6253125459,0.8840251063}, /*cfy*/
          {-0.6717603126,0.0008965541851,286.0637355,-0.595483891,-0.002871479788,0.2683424997}, /*cmz*/
          {0.6364432918,0.3200846984,3.471936843,5.576112993} /*cfz*/
     },
     {
          2460291.5,
          {1.256838341,2.302734109e-05,506.9651938,0.03318734455,0.001057694291,0.3293315163}, /*cmx*/
          {5.677586955,2.619661309,5.102042079,0.01196983672}, /*cfx*/
          {0.3170454601,-0.0001872051825,583.2890177,0.01440166044,0.0002904110983,0.463001986}, /*cmy*/
          {4.105255606,2.881717299,2.408714103,4.86108802}, /*cfy*/
          {-0.7327083675,0.001423293369,288.1443739,0.1073488115,0.002014463809,0.3601243975}, /*cmz*/
          {2.531211811,2.050650652,5.334425831,3.433849378} /*cfz*/
     },
     {
          2460497.5,
          {1.084527346,-8.522905085e-05,538.731111,-0.05910888169,-0.0007394371958,0.470946926}, /*cmx*/
          {1.238642164,4.328826719,0.8033489904,3.510445352}, /*cfx*/
          {0.5227325995,0.0007227295212,582.8110827,-0.01257054665,-0.0001612163345,0.4373157514}, /*cmy*/
          {5.969519856,4.484934545,4.296375293,2.01788324}, /*cfy*/
          {-0.466532923,-0.00110902787,225.0327333,-0.1322859225,-0.001521328439,0.1342953345}, /*cmz*/
          {4.506598054,4.029797721,0.9513826782,1.804777856} /*cfz*/
     },
     {
          2460703.5,
          {1.300631657,0.0006312183155,521.4363303,0.2521381205,-0.0001471835773,0.5656922443}, /*cmx*/
          {3.156720877,2.426528402,2.289693694,1.197012681}, /*cfx*/
          {0.5378020286,-0.0007353414903,583.5031202,-0.1133374931,-1.196767774e-05,0.5365862309}, /*cmy*/
          {1.59522629,-3.187282857,7.128532144,5.97721312}, /*cfy*/
          {-0.8247996793,0.001198092423,262.1939613,-0.391881371,0.0002034070509,0.08158909024}, /*cmz*/
          {0.06014902943,6.019303366,2.904763206,5.035223297} /*cfz*/
     },
     {
          2460909.5,
          {1.252178366,-0.0004063142723,558.9801731,-0.2096215063,0.0005394372287,0.4471306025}, /*cmx*/
          {4.99260585,4.206211588,4.064871557,5.2271396}, /*cfx*/
          {0.3477832331,0.0009457911876,581.9879416,0.1500829991,-0.0004642311414,0.515068699}, /*cmy*/
          {3.445208773,5.008766275,30.17504994,3.443035737}, /*cfy*/
          {-0.3073859573,-0.0006332712037,174.0591691,0.4273733397,0.0009666707255,0.2719095745}, /*cmz*/
          {2.124372614,1.688416703,4.890501886,-5.413367315} /*cfz*/
     },
     {
          2461115.5,
          {1.447053629,0.0007222087521,542.4813794,0.3594861487,-0.0009450598489,0.5094953663}, /*cmx*/
          {0.6259381951,6.095959572,6.063604155,2.512349527}, /*cfx*/
          {0.5874142085,-0.0006010597061,583.0214865,-0.24655004,0.0006390129547,0.5442850955}, /*cmy*/
          {5.359342118,0.5391987103,0.5422404831,0.9354041515}, /*cfy*/
          {-0.303636949,0.0005020105241,218.9692796,-0.7596611006,-0.001745499664,0.2559640572}, /*cmz*/
          {3.911050351,3.52194682,0.3766174011,5.729538626} /*cfz*/
     },
     {
          2461321.5,
          {1.351045157,-0.0004698330513,568.9366738,-0.2900465441,0.001287324736,0.4225559181}, /*cmx*/
          {2.474309734,1.68053827,1.630641039,-0.00255134307}, /*cfx*/
          {0.2479968772,0.000733423774,580.7534088,0.2245041305,-0.001031567897,0.4498701354}, /*cmy*/
          {0.9264801229,2.432502431,2.437335454,4.78860443}, /*cfy*/
          {-0.2282257011,-0.0007983019193,142.9253228,0.7117346467,0.002975336977,0.2498897909}, /*cmz*/
          {6.032596213,5.438511116,2.301683353,3.627332316} /*cfz*/
     },
     {
          2461527.5,
          {1.258849472,0.001373235158,563.5373548,0.302250277,-0.00114786675,0.5190527265}, /*cmx*/
          {4.371607147,3.424808973,3.39262596,3.598356572}, /*cfx*/
          {0.6762371465,-0.0004974560184,581.3165519,-0.3016882024,0.001164526861,0.5098164238}, /*cmy*/
          {2.825672882,4.302323736,4.305728431,2.038508762}, /*cfy*/
          {-0.3572987364,0.001008234351,162.8525718,-0.8670805521,-0.003153358259,0.08878385365}, /*cmz*/
          {1.559023165,1.041536744,4.187193223,1.571627515} /*cfz*/
     },
     {
          2461733.5,
          {1.524643715,-0.0001077560505,572.62808,-0.1589538258,0.001105781721,0.4922393424}, /*cmx*/
          {6.247441174,5.393566164,5.297004192,1.322377892}, /*cfx*/
          {0.4179503401,-0.001018886226,580.0752651,0.1580872006,-0.001139812752,0.516675468}, /*cmy*/
          {4.697259047,6.179754686,6.19031482,6.062414149}, /*cfy*/
          {-0.4011750596,0.00167965878,127.2785981,0.5263140252,0.003269119619,0.1470206674}, /*cmz*/
          {3.625367194,2.935483274,6.081005342,4.748298731} /*cfz*/
     },
     {
          2461939.5,
          {1.308976086,-8.124560885e-05,577.9335739,0.1589124406,-0.0008790655109,0.4597030938}, /*cmx*/
          {1.833620165,0.7210925888,0.6880299964,4.818836893}, /*cfx*/
          {0.4583774268,0.0005208897889,579.2550617,-0.2056529137,0.001122883957,0.4375420812}, /*cmy*/
          {0.2793494545,1.784604388,1.786890064,3.310876553}, /*cfy*/
          {-0.06036087379,-6.109284386e-05,105.9243912,-0.608367391,-0.003101950938,0.1755737215}, /*cmz*/
          {5.69058451,4.825091486,1.687706382,3.032802594} /*cfz*/
     },
     {
          2462145.5,
          {1.581741573,1.082113161e-05,575.9266569,0.04729132857,0.0004032158953,0.5570408489}, /*cmx*/
          {3.735819988,2.605507442,2.365685069,2.385187059}, /*cfx*/
          {0.5978006255,-0.001052313796,579.5802827,-0.02253983968,-0.0006983928638,0.5699083866}, /*cmy*/
          {2.182307525,3.780441871,3.663753516,0.8244197377}, /*cfy*/
          {-0.3415189424,0.0007919794182,112.3657289,0.03889145596,0.002015015709,0.09322374855}, /*cmz*/
          {1.240551837,0.621277599,3.605205802,1.446389619} /*cfz*/
     },
     {
          2462351.5,
          {1.43886506,-0.0005735464475,583.3062318,-0.02782001518,-0.000196529557,0.5316873308}, /*cmx*/
          {5.581986165,3.784117522,4.422405086,6.206272049}, /*cfx*/
          {0.3136836524,0.0009853287174,578.0543739,0.03661518908,0.0002798738197,0.5383298362}, /*cmy*/
          {4.01150904,5.692950793,5.482981006,4.489165797}, /*cfy*/
          {-0.009022877942,-0.001011103322,80.09100893,-0.03009814395,-0.001197693633,-0.1768506694}, /*cmz*/
          {3.947844386,2.117597183,5.469629988,3.56217917} /*cfz*/
     },
     {
          2462557.5,
          {1.609075107,0.0003170800975,581.3111163,-0.1940083904,-0.0003059381884,0.6068090917}, /*cmx*/
          {1.215709727,2.962722466,0.246095528,3.655744466}, /*cfx*/
          {0.5897491451,-0.0008748526617,578.6952848,-0.2440612283,0.0001890548748,0.5967109143}, /*cmy*/
          {5.939576773,1.175001261,1.255327077,2.171967172}, /*cfy*/
          {0.04775321535,0.001181426565,92.14056934,0.4842798233,-4.307725307e-05,0.1752847074}, /*cmz*/
          {5.306070354,7.38159451,1.135508434,0.3750643444} /*cfz*/
     },
     {
          2462763.5,
          {1.495260414,-0.0004278393191,581.5190848,0.1772219816,0.0005890406684,0.4758754028}, /*cmx*/
          {3.055147169,4.505813495,1.377421311,1.3498873}, /*cfx*/
          {0.07318373307,0.0009857067619,577.2613185,0.2579719152,-0.0008136691122,0.4839141795}, /*cmy*/
          {1.470468258,3.035176108,3.031137201,6.075584019}, /*cfy*/
          {0.4081968182,-0.001314871059,100.6705545,-0.5363368804,-0.001463346312,0.1562549396}, /*cmz*/
          {2.056211763,2.981910274,6.106435468,4.949198617} /*cfz*/
     },
     {
          2462969.5,
          {1.343780289,0.0008589953979,584.8184431,-0.2660511201,-0.0007436142164,0.4971784176}, /*cmx*/
          {4.968389764,-0.02155637874,3.197923562,4.844792332}, /*cfx*/
          {0.5473081475,-0.0001053497303,577.6099874,-0.3872441475,0.001065337809,0.4528530327}, /*cmy*/
          {3.397542648,4.938942425,4.948162034,3.180541237}, /*cfy*/
          {0.1104322698,0.001207123855,82.25036506,0.8424219356,0.002136688113,0.2739205446}, /*cmz*/
          {3.416979282,4.90024191,1.76401521,3.628036531} /*cfz*/
     },
     {
          2463175.5,
          {1.679532049,-0.0004752683463,576.867942,0.2216780444,0.001070773718,0.5333490483}, /*cmx*/
          {0.5386924544,1.739347863,4.915145265,2.431764732}, /*cfx*/
          {0.392439702,-0.0008413267453,577.3025681,0.312498729,-0.001479688044,0.5606184763}, /*cmy*/
          {5.22842909,0.5307412004,0.5310503504,0.8520803833}, /*cfy*/
          {0.0007412449721,0.001346688317,124.3310903,-0.7324675282,-0.003226006671,0.1333413451}, /*cmz*/
          {6.067074975,0.5027353208,3.640273117,1.900707313} /*cfz*/
     },
     {
          2463381.5,
          {1.415546708,-0.0003828753873,579.872375,-0.307631927,-0.001222857986,0.4713330313}, /*cmx*/
          {2.432116567,3.351291928,0.235022655,6.047394182}, /*cfx*/
          {0.3797718299,0.0003437292583,577.1949216,-0.3765118341,0.001490173436,0.5036504832}, /*cmy*/
          {0.8426955964,2.419947726,2.421005885,4.456270675}, /*cfy*/
          {0.2003442048,0.001230121116,112.3183147,0.8766737229,0.00332857832,0.1223003516}, /*cmz*/
          {1.569065327,2.407594536,5.549205176,5.844370108} /*cfz*/
     },
     {
          2463587.5,
          {1.674390501,-0.0002340553869,572.1236855,0.1446714259,0.001120710078,0.5441949564}, /*cmx*/
          {4.311370752,5.081677859,2.051215311,3.634621424}, /*cfx*/
          {0.4750487184,-0.0006186986461,577.268034,0.1743590369,-0.001359040504,0.5531524595}, /*cmy*/
          {2.711850703,4.279992297,4.286026496,1.942224635}, /*cfy*/
          {0.3500084666,0.0001042482547,140.3321366,-0.4745260827,-0.003207601807,0.2220206495}, /*cmz*/
          {3.661825077,4.307672574,1.156606556,3.006227719} /*cfz*/
     },
     {
          2463793.5,
          {1.373494302,0.0003740586428,563.1378503,-0.2157956679,-0.001209486726,0.4859048873}, /*cmx*/
          {6.175185477,0.5631057238,3.755004042,1.017694993}, /*cfx*/
          {0.1467174688,0.001420589793,577.9251932,-0.1919839417,0.001113518619,0.4906687567}, /*cmy*/
          {4.566614485,6.205484905,6.201840841,5.717227843}, /*cfy*/
          {0.5330204108,-0.001657569686,172.4990856,0.5386068407,0.002901873397,0.2186804312}, /*cmz*/
          {5.678792697,6.22321821,3.079937986,0.8771373773} /*cfz*/
     },
     {
          2463999.5,
          {1.574757574,0.000536461709,566.9140383,-0.06805716377,0.0007429086604,0.5977225335}, /*cmx*/
          {1.797556456,3.470347659,5.386127799,4.722803113}, /*cfx*/
          {0.5580402883,-0.0006332544265,577.5732197,-0.07709036948,-0.0005131064929,0.6543790825}, /*cmy*/
          {0.1925058267,1.824353653,1.752234953,3.22899149}, /*cfy*/
          {0.4137389626,0.001185163749,159.4252378,0.05046698761,-0.001649783736,0.1652665761}, /*cmz*/
          {1.240278883,1.74114235,4.950540278,5.559880251} /*cfz*/
     },
     {
          2464205.5,
          {1.460077063,-0.0002587373564,538.0739423,0.05256570354,-0.00034500892,0.589757877}, /*cmx*/
          {3.63545676,4.862990296,0.825070975,2.547216463}, /*cfx*/
          {0.05837392752,0.0002938900189,579.5452228,0.05115730984,0.0001961237732,0.5271394532}, /*cmy*/
          {2.016822706,3.558459889,3.808630267,0.9346236905}, /*cfy*/
          {0.8052445349,-0.0003403473692,235.0642353,-0.03045138643,0.000936191817,0.106455333}, /*cmz*/
          {3.324599697,3.176224394,0.6590265397,7.394916578} /*cfz*/
     },
     {
          2464411.5,
          {1.27728312,0.0003795808281,556.7149934,0.2877908864,-0.0002646351583,0.4937121833}, /*cmx*/
          {5.555641055,3.183035281,3.914389007,-0.1562256672}, /*cfx*/
          {0.4331208457,-6.26270489e-05,578.4683692,-0.2657967172,0.0004041044897,0.4847485127}, /*cmy*/
          {3.943078893,5.548989116,5.54809375,4.448639296}, /*cfy*/
          {0.6125153845,0.001487979711,192.4374682,-0.5421585398,0.000449752657,0.2464704009}, /*cmz*/
          {5.124921084,-3.844081301,2.331242077,4.939326358} /*cfz*/
     },
     {
          2464617.5,
          {1.580370478,2.73610496e-05,513.2249148,-0.3354905608,-0.001082085234,0.3951818724}, /*cmx*/
          {1.102151559,4.948833234,8.166184594,3.696588121}, /*cfx*/
          {0.3183652232,-0.0006335047976,581.3753704,0.2178400568,-0.0007451583011,0.5616991121}, /*cmy*/
          {5.767091562,1.163141737,1.159524182,1.879743323}, /*cfy*/
          {0.6910553258,-0.000114390161,283.4769946,0.5250201562,-0.001562826324,0.4582373928}, /*cmz*/
          {0.895825081,4.368956209,4.353084791,3.305847755} /*cfz*/
     },
     {
          2464823.5,
          {1.420771549,-0.0004944445754,535.7994412,0.5159721033,0.001404657705,0.4291044866}, /*cmx*/
          {3.019485309,0.4446916424,3.629717509,0.8698651685}, /*cfx*/
          {0.338136145,0.0001148890892,580.0043983,-0.3057360816,0.0009232093766,0.5153648332}, /*cmy*/
          {1.399717926,3.022978888,3.019038604,5.60617107}, /*cfy*/
          {0.5050569281,0.001388249028,242.7236969,-0.7919625785,0.00215160008,0.3156941364}, /*cmz*/
          {2.725405179,6.242303031,6.223454364,0.9932758919} /*cfz*/
     },
     {
          2465029.5,
          {1.601270723,-0.0003310030206,494.9048599,-0.4387558559,-0.002076487144,0.5560953553}, /*cmx*/
          {4.864789257,2.286880155,5.464133977,4.741187936}, /*cfx*/
          {0.4189481799,-0.0006838756311,581.9581631,0.2104183017,-0.001072267971,0.6072966747}, /*cmy*/
          {3.249823501,4.912193312,4.903030477,3.194793949}, /*cfy*/
          {0.8981170806,0.0002364424766,312.4200498,0.6492507666,-0.002986025798,0.2703588726}, /*cmz*/
          {4.71015733,1.89197038,1.876021062,4.795099553} /*cfz*/
     },
     {
          2465235.5,
          {1.225142934,0.0001277675924,500.9769809,0.5843125348,0.002330404332,0.4366078778}, /*cmx*/
          {0.4727188655,4.096550055,0.9710608759,2.323522255}, /*cfx*/
          {0.1240528286,0.0004518155837,581.7913097,-0.1993231379,0.0008252365236,0.5152415585}, /*cmy*/
          {5.13851506,0.5081715066,0.5056884428,0.7087023639}, /*cfy*/
          {1.025725831,-0.0009464119122,303.9870306,-0.7433151623,0.002922411977,0.2927185238}, /*cmz*/
          {0.3020568424,3.787684952,3.783830507,2.131989256} /*cfz*/
     },
     {
          2465441.5,
          {1.398045547,0.0006175670971,482.4403355,-0.2694710182,-0.002095898938,0.4863792963}, /*cmx*/
          {2.350070539,5.89385025,2.830765752,5.88367957}, /*cfx*/
          {0.5105014493,-0.0003536894948,582.3110394,0.05721494046,-0.0006403157839,0.6262232738}, /*cmy*/
          {0.7398686074,2.401037024,2.378977879,4.330141462}, /*cfy*/
          {0.9270637825,0.0001803670796,329.3140583,0.3523488159,-0.002608051749,0.3765020313}, /*cmz*/
          {2.224424943,5.730356178,5.691809124,6.025598912} /*cfz*/
     },
     {
          2465647.5,
          {1.367047959,-0.0005124239954,454.3444177,0.3583824224,0.002065492443,0.5549332266}, /*cmx*/
          {4.198835198,1.485685106,4.656909958,3.531400143}, /*cfx*/
          {0.1148380119,-0.0001180609955,583.2317843,-0.05851885252,0.0004022931953,0.5896154349}, /*cmy*/
          {2.605922406,4.238289926,4.232518614,2.038950194}, /*cfy*/
          {1.166829957,-0.0003182173422,366.1743192,-0.4093838285,0.002320944204,0.2548188085}, /*cmz*/
          {4.142548553,1.321513167,1.312126322,3.723088326} /*cfz*/
     },
     {
          2465853.5,
          {1.159313621,-0.0005377001918,466.7854051,0.08658022768,-0.001207128372,0.4364083283}, /*cmx*/
          {6.110469577,3.869713958,0.1964064511,1.092444645}, /*cfx*/
          {0.3416844002,0.0004195099956,582.9984989,-0.08262880685,-2.974501531e-06,0.5384198819}, /*cmy*/
          {4.50899303,6.09870577,5.827328386,5.63461879}, /*cfy*/
          {1.025710768,0.001298755044,350.0742565,-0.108208795,-0.001129875594,0.2900088366}, /*cmz*/
          {6.023644575,2.871588291,3.304970407,0.6722076543} /*cfz*/
     },
     {
          2466059.5,
          {1.255778937,-8.125314208e-06,404.8933774,-0.1218513149,0.0003654299049,0.3956348893}, /*cmx*/
          {1.634310067,5.552076547,1.764293315,5.274807579}, /*cfx*/
          {0.2749762642,-0.0004272457071,583.5206889,0.03894968868,-6.718108166e-05,0.566425638}, /*cmy*/
          {0.0885799643,1.770973116,14.57061387,3.185130783}, /*cfy*/
          {1.381018994,-0.0006082340018,420.2112946,0.08433815231,0.000462781987,0.5370187854}, /*cmz*/
          {1.682609306,5.048154917,5.172786143,4.406003206} /*cfz*/
     },
     {
          2458849.5,
          {-0.1542959329,0.0001422496906,-88.15627035,-4.627480091,-0.07500271562,-0.05553101052}, /*cmx*/
          {2.345260397,0.5836351055,4.554585234,23.66372036}, /*cfx*/
          {0.2196467862,0.0005818187977,-133.5175102,-7.022009294,-0.1142897296,0.1236300277}, /*cmy*/
          {0.6753791679,5.200066181,2.881168685,0.2057966957}, /*cfy*/
          {0.1508670863,-0.0002763349895,-102.1251259,-5.360380352,-0.08659874672,0.0692332203}, /*cmz*/
          {-0.9697676379,3.546056808,1.220448264,4.541022769} /*cfz*/
     },
     {
          2458890.5,
          {-0.1646642016,0.0001783795775,-88.87235473,-4.72436775,-0.07719160735,0.05714782131}, /*cmx*/
          {8.645770121,6.896529296,4.58616295,1.713253538}, /*cfx*/
          {0.2127443342,0.0003858687179,133.5458651,7.001978117,0.1136644287,-0.124261919}, /*cmy*/
          {3.839832462,2.082309141,6.047277675,3.366113959}, /*cfy*/
          {0.1597162347,-0.0003999874184,101.4389538,5.259166602,0.08405708627,-0.06695896318}, /*cmz*/
          {2.196348787,6.700343535,4.371249252,1.42257119} /*cfz*/
     },
     {
          2458931.5,
          {-0.1675519693,-3.779892245e-05,-91.5796723,-4.877125948,-0.07979922463,-0.05949374399}, /*cmx*/
          {8.656042322,6.914529557,4.605019961,4.856077207}, /*cfx*/
          {0.1999797282,0.0007500064592,-133.6098593,-6.961024186,-0.1126164843,0.1236891721}, /*cmy*/
          {7.010426502,5.255090948,2.939278028,0.2394896818}, /*cfy*/
          {0.1565012886,-0.0002311514261,-98.72777578,-5.045737537,-0.07984754169,0.06319315553}, /*cmz*/
          {5.37391899,3.588651848,7.544122884,4.597482779} /*cfz*/
     },
     {
          2458972.5,
          {-0.1850800983,0.0003290963282,95.22253122,-5.029843787,-0.08195128538,0.06147208308}, /*cmx*/
          {5.529675083,6.931457805,4.622507382,1.761540745}, /*cfx*/
          {0.1857068636,0.0006968919294,133.6611173,6.916902106,-0.1115727467,-0.1239604955}, /*cmy*/
          {3.907850087,2.154973014,2.983526962,3.420504374}, /*cfy*/
          {0.1659176946,-0.0005300067764,-94.84832428,-4.792186272,-0.07541231055,-0.05847675578}, /*cmz*/
          {5.425157536,9.924790692,7.603593629,1.563968581} /*cfz*/
     },
     {
          2459013.5,
          {-0.1879317999,6.945084157e-05,98.605496,-5.143231646,-0.0831901443,-0.06227444452}, /*cmx*/
          {5.557936657,6.955393082,4.645581204,4.933403016}, /*cfx*/
          {0.1814422493,0.00064048281,133.6884853,-6.884142182,-0.1108535805,0.1237084231}, /*cmy*/
          {-27.45910654,11.6306206,9.319783862,0.312874348}, /*cfy*/
          {0.1605767781,-0.0001635255248,-91.02130936,-4.584004573,-0.07225554995,0.05471204254}, /*cmz*/
          {5.489360785,9.998790322,7.687366282,4.818183192} /*cfz*/
     },
     {
          2459054.5,
          {-0.1960114651,0.0002041756708,-100.7281372,-5.190282737,0.08335018001,0.06222423444}, /*cmx*/
          {2.459001125,13.27254554,1.535764296,1.874282878}, /*cfx*/
          {0.1621963092,0.0008163542554,133.7015386,-6.876809909,-0.1108032235,-0.1246176358}, /*cmy*/
          {10.29604099,5.404388712,9.377659562,3.506178061}, /*cfy*/
          {0.1648114682,-0.000169186208,-88.49902471,-4.49292208,-0.0715489495,-0.05341001234}, /*cmz*/
          {5.558187538,10.08342224,7.781401647,1.838126549} /*cfz*/
     },
     {
          2459095.5,
          {-0.1971901161,5.255791559e-05,100.9997371,5.164491076,-0.08253636172,-0.06042534423}, /*cmx*/
          {11.93672347,3.890125206,4.717092993,5.078788101}, /*cfx*/
          {0.1522088947,0.0009374744926,133.7415447,-6.906377073,0.111654412,0.1250146899}, /*cmy*/
          {10.35329366,5.460926225,12.57468346,0.4003153939}, /*cfy*/
          {0.1678758095,8.558065741e-05,-88.19073361,-4.554794536,-0.07359596237,0.05408253452}, /*cmz*/
          {5.620186089,10.15950437,7.860140986,5.083896048} /*cfz*/
     },
     {
          2459136.5,
          {-0.2028552908,0.0002989278559,99.48104654,-5.087800031,0.08128415714,0.05932629609}, /*cmx*/
          {5.708575719,13.36260088,7.905681359,2.027560647}, /*cfx*/
          {0.1354202767,0.0009978130057,-133.8370215,6.969873055,-0.1131566603,-0.126873465}, /*cmy*/
          {19.82860611,14.93311949,3.193712935,3.574305313}, /*cfy*/
          {0.1805839488,-9.275827957e-05,90.0443854,4.725954128,0.07711063125,-0.05687066071}, /*cmz*/
          {2.524286124,7.066644019,4.761278655,2.010440168} /*cfz*/
     },
     {
          2459177.5,
          {-0.1983975819,-0.0001242413275,97.22717327,-5.021538617,-0.08067229066,-0.05801756368}, /*cmx*/
          {5.756209005,13.41145757,11.09790832,5.226685311}, /*cfx*/
          {0.1349999513,0.0007754871736,133.9396513,7.034832801,-0.1145069321,0.1275422097}, /*cmy*/
          {4.158367728,33.81638887,-3.060209515,0.4407626824}, /*cfy*/
          {0.1857995244,0.0001824385445,92.70139459,4.891193417,0.07974119017,0.05781086529}, /*cmz*/
          {8.836324612,7.085230998,4.769473186,5.139304997} /*cfz*/
     },
     {
          2459218.5,
          {-0.1979756156,-0.000195283267,-95.91284292,5.026012139,0.08149805308,0.05955755746}, /*cmx*/
          {2.647457583,4.029344078,1.718633112,2.146937625}, /*cfx*/
          {0.1144115179,0.001167416559,-133.9959106,-7.061447021,-0.1148984632,-0.1282276234}, /*cmy*/
          {7.325926043,5.565757225,-3.038891329,3.592521327}, /*cfy*/
          {0.1913620651,-4.141231627e-07,94.19717928,4.934379503,0.07972115231,-0.05801209562}, /*cmz*/
          {8.856812499,7.0899235,4.765727546,1.99273537} /*cfz*/
     },
     {
          2459259.5,
          {-0.2055629974,-0.0003013536874,-96.66301747,5.117489542,0.08354284329,-0.06120543991}, /*cmx*/
          {8.949534393,10.34267052,8.033890778,5.314403145}, /*cfx*/
          {0.1109495808,0.0009192413489,134.0051071,7.04558814,0.1143632008,0.1275273093}, /*cmy*/
          {4.206663825,2.446767861,6.408692631,0.4578305631}, /*cfy*/
          {0.1944892565,-5.635032591e-05,-93.39332618,-4.821313774,-0.07693572706,0.05550055147}, /*cmz*/
          {5.739760549,3.959160944,1.631022384,5.137408504} /*cfz*/
     },
     {
          2459300.5,
          {-0.2116166826,-0.000316970705,-99.2959379,5.25985623,0.08593891235,0.06447999945}, /*cmx*/
          {8.96348704,10.36372917,8.056114841,2.198364663}, /*cfx*/
          {0.09743590141,0.0009346898814,-133.9948622,-7.003316618,-0.1132731833,-0.1271397218}, /*cmy*/
          {7.375240622,5.616943921,3.297746591,3.62093022}, /*cfy*/
          {0.1889490232,-0.0001049260574,-90.40705104,4.592358625,0.07246997415,-0.05310780264}, /*cmz*/
          {-6.788521585,7.131560946,17.37120657,2.053907931} /*cfz*/
     },
     {
          2459341.5,
          {-0.2187622185,-0.0005754140057,-102.7904251,5.402939312,0.08792452591,-0.06599052374}, /*cmx*/
          {8.983294842,10.38511406,8.078129961,5.372108976}, /*cfx*/
          {0.09313276053,0.0006628677973,133.940864,6.953238945,0.1120982348,0.1250519991}, /*cmy*/
          {-2.013282024,2.513808196,6.480532662,0.5086010045}, /*cfy*/
          {0.1818130809,9.816973008e-05,-86.18899734,4.32620715,0.06787359297,0.04971166538}, /*cmz*/
          {5.833015794,7.18817049,4.868160997,5.299548528} /*cfz*/
     },
     {
          2459382.5,
          {-0.2246438605,-0.0004339147834,-105.9981384,5.507425983,0.08906443957,0.06829267431}, /*cmx*/
          {9.015385852,10.41388645,33.23935283,2.284246244}, /*cfx*/
          {0.07211648205,0.001044175738,133.8593408,-6.908557939,-0.1111128922,-0.1237028992}, /*cmy*/
          {4.316035165,18.26999017,28.52267189,3.691821953}, /*cfy*/
          {0.1733589003,0.0001224117971,-82.03427897,4.107834554,0.06464576376,-0.04903961692}, /*cmz*/
          {5.901570701,7.268055505,4.958912691,2.30266454} /*cfz*/
     },
     {
          2459423.5,
          {-0.237441226,-0.0002379956616,108.0289292,-5.55440341,0.08928823762,-0.06860364139}, /*cmx*/
          {5.919164709,1.027149181,14.42604201,5.500181349}, /*cfx*/
          {0.07001425896,0.0004613120935,133.7924947,-6.889556102,-0.1108020187,0.1219528849}, /*cmy*/
          {10.65341615,5.759250358,9.730306651,0.5971186478}, /*cfy*/
          {0.1741594391,0.0001732046859,-79.27168251,4.013665171,0.0639876968,0.04999539981}, /*cmz*/
          {5.973768603,7.358577593,5.059505327,5.595811033} /*cfz*/
     },
     {
          2459464.5,
          {-0.23038506,-0.0004654064449,108.3583166,-5.538837739,-0.0887191902,0.06904747191}, /*cmx*/
          {12.2566193,45.05453016,5.043851193,2.424374918}, /*cfx*/
          {0.05680867862,0.0005728684115,133.8176513,-6.909506602,-0.111427995,-0.1215261579}, /*cmy*/
          {10.71036159,5.81600983,9.786826774,3.779971269}, /*cfy*/
          {0.1679795138,0.0005329887645,-78.84567489,4.077166466,0.06613269177,-0.0536766644}, /*cmz*/
          {6.036246585,7.437554021,5.140915574,2.550526661} /*cfz*/
     },
     {
          2459505.5,
          {-0.2342557068,-0.0003247659302,107.0386478,5.479533826,0.0878184738,-0.06834007686}, /*cmx*/
          {6.028516895,10.54547572,27.08223914,5.642396066}, /*cfx*/
          {0.04230294705,0.0005250198263,-133.9463825,-6.970943819,0.112908257,0.1210349667}, /*cmy*/
          {13.90382446,-0.4179405114,6.691359738,0.6703838686}, /*cfy*/
          {0.1778500651,0.0005141439645,80.71242918,-4.251639776,0.06972361641,0.056959957}, /*cmz*/
          {2.937634066,4.342985182,-1.102350041,5.743664032} /*cfz*/
     },
     {
          2459546.5,
          {-0.2308119557,-0.0003014928459,105.0218769,-5.427988231,0.08744623883,0.06921070693}, /*cmx*/
          {12.35855843,20.01768182,39.69683957,2.548944097}, /*cfx*/
          {0.03007378135,0.0006306708657,134.1167975,-7.040104734,-0.1143450786,-0.1219646616}, /*cmy*/
          {4.518563711,5.900564974,-27.83522005,3.824107648}, /*cfy*/
          {0.1854969359,0.0004035264775,83.46004157,-4.415563948,0.0722862681,-0.05879856508}, /*cmz*/
          {9.245422912,10.63966918,5.183078072,2.59019162} /*cfz*/
     },
     {
          2459587.5,
          {-0.2353027509,-0.0003032586209,-103.854577,5.438441092,-0.08831623598,-0.07096715722}, /*cmx*/
          {2.966579029,4.350547147,5.181972746,5.74039413}, /*cfx*/
          {0.02564529506,0.0001879878081,-134.2191327,7.076518409,0.1149437778,0.1217958538}, /*cmy*/
          {1.404117324,-9.783207778,-43.52202119,0.6927256807}, /*cfy*/
          {0.1947650448,0.0001784500472,85.01022005,-4.453450517,0.07209667403,0.05769469117}, /*cmz*/
          {9.263049647,10.63914073,5.173280343,5.725581555} /*cfz*/
     },
     {
          2459628.5,
          {-0.2288330886,-0.0007252683465,104.5802648,-5.522936505,-0.09017858693,0.07378808391}, /*cmx*/
          {12.41170165,13.80529569,5.213514986,2.607700724}, /*cfx*/
          {0.01332717098,0.0005109571623,134.2237416,-7.065119898,-0.1145027592,-0.1216054806}, /*cmy*/
          {4.567448907,5.946064933,3.623039655,3.838869341}, /*cfy*/
          {0.1860600189,0.0002737151512,-84.11581445,4.329609726,-0.06907595844,-0.05511307581}, /*cmz*/
          {6.145730296,7.505654973,2.035351282,2.574127324} /*cfz*/
     },
     {
          2459669.5,
          {-0.2461065416,-0.0002835469116,107.0172114,-5.649807348,-0.09228702019,-0.07679465756}, /*cmx*/
          {6.145269547,7.545256128,5.237880198,5.783183966}, /*cfx*/
          {-0.003417530324,0.0005099200755,-134.1433648,7.022996819,0.1134284301,0.1196643323}, /*cmy*/
          {1.450824128,2.830673009,6.792555131,0.723991317}, /*cfy*/
          {0.1867132224,-0.0001893872033,-80.89767794,-4.088048204,-0.06440206058,0.05212715794}, /*cmz*/
          {-0.0968093354,-14.45371227,8.351559884,5.775311189} /*cfz*/
     },
     {
          2459710.5,
          {-0.2506344837,-0.0004345189548,110.2227005,-5.775365263,-0.09396068993,0.07932636567}, /*cmx*/
          {6.168350324,26.4193427,5.263192234,2.6598784}, /*cfx*/
          {-0.005031485183,0.0002661056115,133.9978838,6.966720146,-0.1121115941,-0.1177087968}, /*cmy*/
          {4.625744885,2.866068103,3.689204211,3.892289108}, /*cfy*/
          {0.172699221,-6.28788673e-05,-76.40375868,-3.811380929,-0.05965075085,-0.04977197332}, /*cmz*/
          {6.246372033,10.73991662,8.419493327,2.708363795} /*cfz*/
     },
     {
          2459751.5,
          {-0.2584964361,-0.0002962325446,113.1252523,5.864961447,0.0948958098,-0.08194436947}, /*cmx*/
          {6.2033932,10.74403088,-4.12876391,5.861146103}, /*cfx*/
          {-0.02140525042,0.0003205831496,-133.8214461,6.912272256,0.1109307896,0.114493743}, /*cmy*/
          {1.527536959,-3.371265971,19.44626022,0.8037784749}, /*cfy*/
          {0.1612820354,-3.747728068e-05,-71.99719758,-3.587548258,-0.05639265256,0.04971075625}, /*cmz*/
          {6.320864345,10.82706085,8.518366184,-0.3072124918} /*cfz*/
     },
     {
          2459792.5,
          {-0.2585184742,-0.0003723278537,-114.9594681,-5.905295404,-0.09506496077,0.08309596683}, /*cmx*/
          {3.109316922,7.644114254,5.336423749,2.766178088}, /*cfx*/
          {-0.03286443113,0.0004719951932,133.6895197,6.879832606,0.1103372987,-0.1118442931}, /*cmy*/
          {-7.844931365,9.249563864,6.936892241,3.990880869}, /*cfy*/
          {0.1501838432,0.0002112879942,-69.05424349,-3.49275629,-0.05578647273,-0.05160770016}, /*cmz*/
          {6.397642665,4.641714242,8.626921688,2.930065689} /*cfz*/
     },
     {
          2459833.5,
          {-0.2662555724,0.0001205473787,-115.2824777,5.896244205,-0.09469630117,-0.08458374018}, /*cmx*/
          {9.448195788,-14.29882665,-0.9008021397,-0.3011437298}, /*cfx*/
          {-0.05126095696,0.000438778506,133.6917817,6.890599759,0.1107712353,0.1094436109}, /*cmy*/
          {4.778364736,9.307058344,6.99493514,0.9103343962}, /*cfy*/
          {0.1512065897,0.0001397251774,-68.53448481,-3.55938981,-0.05803374062,0.05624511788}, /*cmz*/
          {6.460852928,4.724176415,8.711182353,-0.1291857345} /*cfz*/
     },
     {
          2459874.5,
          {-0.2561381972,-0.0002571755359,-114.1663649,-5.853844736,-0.09411758498,0.08452936673}, /*cmx*/
          {9.504022078,7.742058948,17.99680157,2.883693466}, /*cfx*/
          {-0.05592093146,0.00021343224,-133.8513305,-6.948284765,-0.1121933126,-0.1087607331}, /*cmy*/
          {7.973419809,-18.91590554,3.902255408,4.081653732}, /*cfy*/
          {0.1516041933,0.000470362376,-70.41932272,3.736355685,-0.06165037626,-0.06023015929}, /*cmz*/
          {0.2168907342,1.626656715,2.463634587,3.029062775} /*cfz*/
     },
     {
          2459915.5,
          {-0.2498328679,-0.0001745927523,112.3986639,5.818053364,-0.09401404343,-0.0862580174}, /*cmx*/
          {12.69271999,-33.05161492,-0.805861399,-0.208148688}, /*cfx*/
          {-0.08329142667,0.0007270872721,134.0779348,7.021322343,-0.1137440224,0.1084104754}, /*cmy*/
          {4.873608157,-3.170294447,10.21882904,0.9715824292}, /*cfy*/
          {0.1583447351,0.0003164106247,73.24318228,3.898322074,-0.0641431066,0.06256389576}, /*cmz*/
          {9.660681323,7.916812409,8.74151982,-0.1104706337} /*cfz*/
     },
     {
          2459956.5,
          {-0.2482848031,-0.0003177404381,-111.3758086,-5.834946275,0.0949162212,0.08778175616}, /*cmx*/
          {3.301330351,1.545284098,2.375763643,2.949247137}, /*cfx*/
          {-0.08882296952,0.0005497184213,-134.2280278,7.066727351,0.1145367914,-0.1084934501}, /*cmy*/
          {1.760695945,3.138048335,19.66523345,4.11039331}, /*cfy*/
          {0.1649736909,0.0001432180886,74.84992235,3.930111025,-0.06377925054,-0.06070752476}, /*cmz*/
          {9.674444783,7.909700677,8.724386785,3.009696884} /*cfz*/
     },
     {
          2459997.5,
          {-0.2461335498,-0.0003666673836,112.020784,5.911560715,0.09659274114,-0.09171686286}, /*cmx*/
          {-12.38477606,136.6635313,8.689700833,-0.1694896018}, /*cfx*/
          {-0.1041523756,0.0006994381617,134.2380019,-7.062955375,-0.1142589738,0.1080146971}, /*cmy*/
          {4.923995256,6.300247686,3.977176112,0.9898050362}, /*cfy*/
          {0.1599428659,-4.246753218e-05,-73.89547129,-3.797591301,0.06057640196,0.05774732412}, /*cmz*/
          {6.556853105,4.772986102,5.58262161,-0.1197451293} /*cfz*/
     },
     {
          2460038.5,
          {-0.2461725123,-0.0007036321532,114.1808289,6.019132543,0.09832120817,0.09398912421}, /*cmx*/
          {6.483706779,4.740876703,8.715062669,2.983605686}, /*cfx*/
          {-0.1086993797,0.0005480488535,-134.1161586,7.022094167,0.1132273696,-0.1063347355}, /*cmy*/
          {1.805662479,3.182861218,7.144435308,4.145665324}, /*cfy*/
          {0.1480127817,2.233154091e-07,-70.51731803,-3.546315696,0.05572328713,-0.05321451028}, /*cmz*/
          {6.60088349,4.805789365,5.616485489,3.054990542} /*cfz*/
     },
     {
          2460079.5,
          {-0.2477401592,-0.0005779134599,116.9728117,6.120661192,-0.09958623553,-0.09743657278}, /*cmx*/
          {6.509098076,4.767817787,24.45097712,-0.1270630478}, /*cfx*/
          {-0.1287816194,0.0009865081287,133.9048432,-6.960926948,-0.1118110288,0.1039329858}, /*cmy*/
          {4.97799408,6.357336712,4.038770368,1.053438253}, /*cfy*/
          {0.1308934171,-4.591743834e-05,-65.82105457,-3.26199435,0.05086096547,0.0503077793}, /*cmz*/
          {6.667409044,4.872569021,5.690901008,-0.01208714268} /*cfz*/
     },
     {
          2460120.5,
          {-0.2549905227,-0.0005222983652,-119.4742092,6.190477974,-0.1002069837,0.0990412379}, /*cmx*/
          {15.97114817,4.803397494,5.637529211,3.051011734}, /*cfx*/
          {-0.1287448444,0.0004844578825,-133.6654278,-6.899831901,-0.1104920376,-0.1005670777}, /*cmy*/
          {1.877514972,0.1180872057,10.36939461,4.241643416}, /*cfy*/
          {0.1183361086,-2.41210756e-06,-61.25772682,-3.036113159,0.04759008093,-0.04865877815}, /*cmz*/
          {6.750222789,4.969269466,5.800607464,3.214635542} /*cfz*/
     },
     {
          2460161.5,
          {-0.2451554227,-0.0006915840672,121.0290065,-6.219032736,0.1002480078,-0.1014062891}, /*cmx*/
          {6.595677169,1.706906571,2.540496265,-0.03801073076}, /*cfx*/
          {-0.1410281196,0.0006179139444,133.4870813,-6.855775552,-0.1096745468,0.09746646579}, /*cmy*/
          {11.35321356,6.455157072,10.42676411,1.180258337}, /*cfy*/
          {0.1004791675,0.0003166460675,-58.21093647,-2.943596014,0.04705926963,0.05029258777}, /*cmz*/
          {6.833709171,5.077010794,5.92006501,0.1565815295} /*cfz*/
     },
     {
          2460202.5,
          {-0.2435227523,-0.000642256863,121.3141671,-6.212956722,0.0999864034,0.1018003202}, /*cmx*/
          {6.652861996,8.041281445,21.43933233,3.154663841}, /*cfx*/
          {-0.1509772455,0.0004057872503,133.469494,-6.856635938,-0.1099196581,-0.09409657736}, /*cmy*/
          {5.127275388,6.513841408,10.48682658,4.38917139}, /*cfy*/
          {0.095768675,0.0004895825152,-57.64141728,-3.013895865,0.04937328464,-0.0538812117}, /*cmz*/
          {6.897966427,5.163458534,6.007586315,3.346708478} /*cfz*/
     },
     {
          2460243.5,
          {-0.2312115815,-0.0006474841686,120.3854872,6.185939911,0.09971292126,-0.1031798956}, /*cmx*/
          {6.709963815,11.23457755,15.20584902,0.05516313252}, /*cfx*/
          {-0.1663010888,0.0005755858854,133.6422485,6.909190473,-0.1112650801,0.09323383681}, /*cmy*/
          {5.18276179,9.709483069,-8.310360636,1.31190257}, /*cfy*/
          {0.0946926284,0.0006273310844,-59.53454233,-3.192278521,-0.05298513773,0.05883669173}, /*cmz*/
          {6.931781461,-1.08002027,-9.670787709,0.216662174} /*cfz*/
     },
     {
          2460284.5,
          {-0.2278713152,-0.0005831847178,-118.8924652,6.167651247,0.09989649672,0.1036408505}, /*cmx*/
          {9.899780496,-7.567737134,8.968826229,3.227911969}, /*cfx*/
          {-0.1727815162,0.0001183923667,-133.9083507,-6.98735017,-0.1129684511,-0.09216853831}, /*cmy*/
          {2.085863458,6.608558209,10.57550242,4.480929083}, /*cfy*/
          {0.1031681561,0.0005221548634,-62.42913627,-3.352061829,0.05540315938,-0.06099918125}, /*cmz*/
          {6.943075738,5.201179059,-0.2615115023,3.348649564} /*cfz*/
     },
     {
          2460325.5,
          {-0.2093031556,-0.00105979919,-118.0121093,-6.19063129,0.1008276316,-0.105994822}, /*cmx*/
          {9.934187982,1.89547124,2.723726854,0.1006742702}, /*cfx*/
          {-0.1828314117,0.0003070812087,134.0974658,7.039964629,0.1139419427,0.09265571257}, /*cmy*/
          {5.258047844,-2.789455952,20.02328496,1.357936078}, /*cfy*/
          {0.1008369797,0.0005645222421,-64.09620401,-3.378159169,0.0548993924,0.05983015612}, /*cmz*/
          {6.951524651,5.185674928,5.995355252,0.1947354445} /*cfz*/
     },
     {
          2460366.5,
          {-0.2123823634,-0.0008455728802,-118.5510901,-6.259351685,-0.1022916005,0.1085667978}, /*cmx*/
          {3.67430277,1.924695839,12.17791441,3.25696551}, /*cfx*/
          {-0.1958644279,0.0003081195298,-134.1252183,7.045343429,0.1138544302,-0.09157221555}, /*cmy*/
          {2.138597318,3.514151423,1.192791728,4.515023402}, /*cfy*/
          {0.1013333079,0.0001948887343,63.12358582,3.239423903,-0.05156388992,-0.05554684945}, /*cmz*/
          {3.833455515,2.044670981,2.848462749,3.347501594} /*cfz*/
     },
     {
          2460407.5,
          {-0.2073955894,-0.00100223676,-120.3728849,6.345231146,0.1036008153,-0.1115318547}, /*cmx*/
          {9.978001147,-64.0240168,9.062068641,0.1246996223}, /*cfx*/
          {-0.1960849432,0.000172338997,133.9897016,-7.007490711,-0.1128932631,0.09134647567}, /*cmy*/
          {5.302225149,6.678471278,4.358407351,1.399805917}, /*cfy*/
          {0.08910984547,0.0001284776726,59.65539878,2.982032946,-0.0466006205,0.05036390597}, /*cmz*/
          {10.16518164,8.362036201,9.166665999,0.2394866739} /*cfz*/
     },
     {
          2460448.5,
          {-0.210159039,-0.0008580922441,-122.6901272,-6.419988226,-0.1044046099,0.1130991188}, /*cmx*/
          {10.00494064,-10.5885072,5.95009289,3.29532701}, /*cfx*/
          {-0.2022926613,-3.039422816e-05,-133.7479389,6.945898196,0.1114786211,-0.08859744136}, /*cmy*/
          {2.189384884,3.567891394,-5.032441201,4.594764391}, /*cfy*/
          {0.0755004851,1.878575631e-05,54.85482074,2.693962076,-0.04168919705,-0.04526991547}, /*cmz*/
          {10.24080209,8.43690665,9.250318233,3.453783976} /*cfz*/
     },
     {
          2460489.5,
          {-0.2015089684,-0.001071444486,-124.72732,-6.464978171,0.1045976962,-0.1145256798}, /*cmx*/
          {3.760345563,2.01539385,2.84706297,0.1843071705}, /*cfx*/
          {-0.2059485544,6.149870382e-05,133.4802193,-6.878723198,-0.1100319729,0.08683589478}, /*cmy*/
          {5.370103574,6.75185257,17.00498503,1.52300161}, /*cfy*/
          {0.05773835917,0.0001791106814,50.23378052,2.468681986,-0.03843178565,0.04224978809}, /*cmz*/
          {10.33543167,8.547122645,9.376155451,0.3926355636} /*cfz*/
     },
     {
          2460530.5,
          {-0.2069813037,-0.0004525606329,125.9581035,-6.479197916,-0.10444799,0.115390633}, /*cmx*/
          {0.6694118372,2.063299521,-6.529688206,3.377596987}, /*cfx*/
          {-0.218464117,2.405349648e-05,133.2806548,-6.827832147,-0.109080462,-0.08385544593}, /*cmy*/
          {11.70341996,6.805549099,10.77945412,4.769083594}, /*cfy*/
          {0.04840165137,0.0001062900978,47.1703398,2.381547952,-0.03801161627,-0.04206202554}, /*cmz*/
          {10.42887546,8.668920844,9.511515113,3.615695904} /*cfz*/
     },
     {
          2460571.5,
          {-0.1955266467,-0.0006679416532,126.1865782,-6.471901016,-0.1042053413,-0.1154137087}, /*cmx*/
          {7.011017276,8.400364341,12.37255567,0.2746303908}, /*cfx*/
          {-0.2130837412,-0.0004569005182,133.2431165,-6.819448234,-0.109165886,0.08274504381}, /*cmy*/
          {5.478099376,6.865718964,4.558593141,1.715631461}, /*cfy*/
          {0.04122262601,0.0003438542969,46.59286334,2.455967254,-0.04038200698,0.04490136329}, /*cmz*/
          {10.49433023,8.760129938,9.603066629,0.5067383492} /*cfz*/
     },
     {
          2460612.5,
          {-0.1834890217,-0.0005409571664,125.444769,-6.459456726,0.1042169931,0.1154306343}, /*cmx*/
          {7.069588737,8.454180004,9.282530137,3.460568478}, /*cfx*/
          {-0.2325975215,-0.000178981666,133.4086,-6.86837071,0.1104820271,-0.08177234641}, /*cmy*/
          {5.535895784,6.922733094,7.755902608,4.953835021}, /*cfy*/
          {0.03957295851,0.0004398167364,-48.48471018,-2.634394278,-0.04395452847,-0.04923877189}, /*cmz*/
          {13.66111156,-0.6322052068,9.623179403,3.65278239} /*cfz*/
     },
     {
          2460653.5,
          {-0.1741330923,-0.0005433749151,-124.2388844,6.457970735,-0.1046537772,-0.1158488279}, /*cmx*/
          {10.26074075,-0.9229832282,6.186765245,0.3375730162}, /*cfx*/
          {-0.239911748,-0.0002141600329,133.6913955,6.949724315,-0.1123017013,0.08237921706}, /*cmy*/
          {-0.6996048145,3.824967337,4.653819639,1.849120713}, /*cfy*/
          {0.04540960647,0.0003847101677,51.43269524,2.790808733,0.0462652364,0.05223767084}, /*cmz*/
          {10.51900935,2.494104144,6.451182573,0.4855605457} /*cfz*/
     },
     {
          2460694.5,
          {-0.167025348,-0.0003254940772,123.5015338,-6.488146056,0.1056558847,0.1174295473}, /*cmx*/
          {0.8715526593,2.256430809,9.364917776,3.499549505}, /*cfx*/
          {-0.2534830648,-0.0001190138253,-133.9077142,7.011256896,-0.1135019248,-0.08255986587}, /*cmy*/
          {2.474853384,-2.429441698,10.96159952,5.029164416}, /*cfy*/
          {0.04956135575,0.0001321253954,53.16576467,2.813190451,0.04568720433,-0.05141608807}, /*cmz*/
          {10.51970823,8.750376749,6.412231674,3.620132156} /*cfz*/
     },
     {
          2460735.5,
          {-0.1562033594,-0.0007489839181,-123.9328182,-6.547709627,-0.1068672495,-0.1191418129}, /*cmx*/
          {4.037374538,2.284596792,-6.315273057,0.359195634}, /*cfx*/
          {-0.2511290979,-0.0003605820207,133.9593131,7.025626642,0.113601428,0.08268452666}, /*cmy*/
          {5.639128308,3.874203043,-11.01108038,1.885496462}, /*cfy*/
          {0.04643293141,9.493664924e-05,-52.22016971,-2.670897514,-0.0422800839,0.04705419545}, /*cmz*/
          {7.400444668,5.603189047,3.258051347,0.4819654728} /*cfz*/
     },
     {
          2460776.5,
          {-0.1487478385,-0.0006205190739,-125.3843784,6.61291811,0.107785273,0.1211006212}, /*cmx*/
          {10.34201534,30.58355515,-3.14841105,3.522107377}, /*cfx*/
          {-0.27050008,0.000290852947,-133.8331495,-6.993673396,-0.1127666016,-0.08242811683}, /*cmy*/
          {2.518644532,7.037351417,4.719363117,5.076016758}, /*cfy*/
          {0.03591599752,-2.408449513e-05,-48.73014061,-2.411958355,-0.03730594732,-0.04107309175}, /*cmz*/
          {7.455090346,5.639324648,9.577691228,3.677380585} /*cfz*/
     },
     {
          2460817.5,
          {-0.1528821467,-0.0004201033246,127.2032793,-6.658586405,-0.1080759264,-0.1216224962}, /*cmx*/
          {13.51105912,2.338065156,6.306746898,0.398167253}, /*cfx*/
          {-0.2666423345,-8.273367295e-05,133.6003966,6.933505617,0.1113719818,0.08160275508}, /*cmy*/
          {5.687240969,3.925022262,1.609829153,1.971190558}, /*cfy*/
          {0.02793957268,-0.0001756779699,-43.92225444,-2.124131375,-0.03241622072,0.0350751255}, /*cmz*/
          {7.543759617,5.725980245,9.675368058,0.6128724821} /*cfz*/
     },
     {
          2460858.5,
          {-0.1393455032,-0.0005508831872,-128.7463787,6.67683589,0.1078257567,0.1216071711}, /*cmx*/
          {4.125234781,5.518326506,3.20543582,3.582382879}, /*cfx*/
          {-0.2719701846,6.8100371e-05,-133.3351905,-6.863690826,0.109865138,-0.08144662853}, /*cmy*/
          {2.583077134,7.107611882,849.8848614,5.208598635}, /*cfy*/
          {0.01215562275,-3.524622758e-05,-39.34887829,-1.903767436,0.0292716365,-0.0307591132}, /*cmz*/
          {7.656508032,5.857775173,0.4032129281,3.873248511} /*cfz*/
     },
     {
          2460899.5,
          {-0.1329740826,-0.0005707057063,-129.6466088,6.673601605,-0.1073942384,-0.1203516912}, /*cmx*/
          {-33.5227655,24.41749467,12.68083829,0.4789020426}, /*cfx*/
          {-0.2743370255,-4.9293081e-05,133.1386292,-6.808838106,0.1088135812,0.0807928664}, /*cmy*/
          {24.62365207,7.160908388,7.995349153,2.153702939}, /*cfy*/
          {0.002332282985,7.305913547e-05,-36.3693678,-1.826050681,-0.02903378597,0.02931500915}, /*cmz*/
          {7.765631153,6.00124866,9.988287963,0.8216876943} /*cfz*/
     },
     {
          2460940.5,
          {-0.1190070641,-0.0004309728882,-129.7944517,6.663943915,-0.107168221,0.1195503286}, /*cmx*/
          {10.51879452,5.624252001,6.453511592,3.672287735}, /*cfx*/
          {-0.2853564861,0.0002479418808,133.0810501,-6.793676869,0.1087976954,-0.0823482853}, /*cmy*/
          {5.832606421,7.222440248,8.059541787,5.418825127}, /*cfy*/
          {-0.005074299904,0.0001949053168,-35.81757264,-1.906855214,-0.03150675138,-0.03121608876}, /*cmz*/
          {7.832674211,6.098466627,10.08386784,4.010521425} /*cfz*/
     },
     {
          2460981.5,
          {-0.1114337037,-0.0003437786514,-129.2440389,6.662658311,0.1074001414,-0.1183514939}, /*cmx*/
          {10.57839665,5.679817942,9.648640309,0.5623382302}, /*cfx*/
          {-0.2834723123,-0.0002879553124,133.2305184,-6.83924646,0.1100757461,0.08327039973}, /*cmy*/
          {5.89244571,7.281929475,8.117909702,2.354528397}, /*cfy*/
          {-0.004146073677,0.0002318613033,-37.68211589,-2.082886095,0.0349858041,0.03517673299}, /*cmz*/
          {7.84276517,6.117530054,6.945876923,0.8362055872} /*cfz*/
     },
     {
          2461022.5,
          {-0.08316143466,-0.0008397027476,128.327809,6.677942155,-0.1080991799,0.1183382946}, /*cmx*/
          {13.77070089,-0.5554041323,6.552624958,3.734471493}, /*cfx*/
          {-0.2923103487,1.020284445e-06,-133.5008566,6.923114317,-0.1120056349,-0.08596036768}, /*cmy*/
          {27.93392365,4.187037857,5.018626519,5.559129761}, /*cfy*/
          {-0.00643382526,0.0004172465648,40.65050736,2.23402898,-0.03715528939,-0.0384812852}, /*cmz*/
          {4.681313825,2.939796817,3.751004833,3.940538251} /*cfz*/
     },
     {
          2461063.5,
          {-0.07818578893,-0.0006167061979,-127.7436966,-6.716071276,-0.1091892388,-0.1186615803}, /*cmx*/
          {4.382375499,-3.659995425,6.587588394,0.5999629439}, /*cfx*/
          {-0.302268446,-1.133654192e-05,-133.732049,6.993699829,0.1134285828,0.08613119978}, /*cmy*/
          {9.119283376,4.217566325,8.186030076,2.433966142}, /*cfy*/
          {-0.001748804646,0.0002370018028,-42.4591599,2.254362392,-0.03652977655,0.03832513157}, /*cmz*/
          {14.09464879,2.895702679,3.69293292,0.763467001} /*cfz*/
     },
     {
          2461104.5,
          {-0.06251370088,-0.0008644295192,128.0632209,6.767726707,0.1102046286,0.120267707}, /*cmx*/
          {7.548524386,-0.491551442,-2.811291267,3.754942311}, /*cfx*/
          {-0.3014054536,-4.173387457e-05,133.8009936,-7.015948062,-0.1137182183,-0.08771531721}, /*cmy*/
          {6.000709354,1.09653356,17.62899253,5.594954251}, /*cfy*/
          {-0.003666321155,0.0001795449604,41.57925389,-2.112257347,-0.0331418578,-0.03471037388}, /*cmz*/
          {4.690078237,6.022912191,9.952863449,3.921229664} /*cfz*/
     },
     {
          2461145.5,
          {-0.05673543816,-0.0008543484385,-129.1625571,-6.81272425,0.1107354212,-0.1204735691}, /*cmx*/
          {10.71145995,-3.609674272,3.495729069,0.6246521796}, /*cfx*/
          {-0.3024357223,-0.0002417606746,133.7083233,6.991209473,0.1130018544,0.08715052475}, /*cmy*/
          {6.020785876,4.258215955,1.941480573,2.474467031}, /*cfy*/
          {-0.007653988435,7.419379404e-05,38.14533354,-1.855818039,-0.0282318861,0.02871634591}, /*cmz*/
          {4.7533936,6.06170724,9.99106071,0.8389429424} /*cfz*/
     },
     {
          2461186.5,
          {-0.04076642563,-0.001178063765,130.4922844,6.830433148,-0.1105326547,0.1202866132}, /*cmx*/
          {1.313606789,5.843308284,6.667401633,3.794809015}, /*cfx*/
          {-0.3014802792,-7.616738448e-05,-133.497605,-6.933006616,-0.1116429422,-0.08843808992}, /*cmy*/
          {2.904361639,7.427310504,5.113286342,5.659801701}, /*cfy*/
          {-0.01655704516,0.0001326873991,33.43522761,-1.573265371,-0.0234589254,-0.02277227742}, /*cmz*/
          {4.862796404,6.167945687,16.39578906,4.116536423} /*cfz*/
     },
     {
          2461227.5,
          {-0.04192246703,-0.0006737394497,-131.5493553,-6.822326289,0.1098651882,-0.1181810756}, /*cmx*/
          {4.493482772,2.740583275,3.566927929,0.6898973172}, /*cfx*/
          {-0.3050107159,-0.0001680857552,133.2621397,6.863210888,-0.1101130429,0.08849069866}, /*cmy*/
          {18.64808061,4.325122673,-1.126583301,2.584114002}, /*cfy*/
          {-0.02169033809,1.160521258e-05,-29.05046606,-1.365158247,0.02057873257,0.01830407796}, /*cmz*/
          {8.148587565,12.62166551,32.3051954,1.170470372} /*cfz*/
     },
     {
          2461268.5,
          {-0.0266002347,-0.0009202107091,132.1263095,6.80008829,0.1091261734,0.1159521359}, /*cmx*/
          {-180.8099656,12.21571004,9.902542649,3.883742855}, /*cfx*/
          {-0.2929753078,-0.0005217905653,-133.0807567,6.8052697,-0.1089711037,-0.09075940506}, /*cmy*/
          {-28.42737045,10.66077154,5.213080786,5.805632771}, /*cfy*/
          {-0.02757960945,7.40315522e-05,-26.29139631,-1.304854631,0.02069605607,-0.01697860107}, /*cmz*/
          {8.286316812,12.80340196,26.22477218,4.506656585} /*cfz*/
     },
     {
          2461309.5,
          {-0.01465873279,-0.0007140275418,132.2013139,6.786471072,0.1088818106,-0.1127175185}, /*cmx*/
          {7.74489421,5.990419672,9.960903241,0.7946795571}, /*cfx*/
          {-0.2982893624,-0.0004682779401,-133.0159483,6.786476235,-0.1088725762,0.09286274406}, /*cmy*/
          {9.330541874,10.72278339,5.277733153,2.757238926}, /*cfy*/
          {-0.03277923696,0.0001312254016,-25.80639893,-1.395411618,-0.02332070063,0.01823521732}, /*cmz*/
          {8.356084383,6.623154266,10.61146211,1.419679784} /*cfz*/
     },
     {
          2461350.5,
          {8.584714177e-05,-0.0007716938531,131.8320068,6.793736139,0.109292235,0.1112330841}, /*cmx*/
          {7.804937369,6.04730976,10.01631927,3.978580491}, /*cfx*/
          {-0.2927209319,-0.000628919036,-133.1326379,6.828080348,-0.1101072446,-0.09674958425}, /*cmy*/
          {9.391744893,10.78403998,5.338061065,-0.320412841}, /*cfy*/
          {-0.03420989154,0.0001882938596,27.5647014,1.564786987,0.02662315634,-0.02155768426}, /*cmz*/
          {5.196317613,3.47420933,7.442407487,4.473457754} /*cfz*/
     },
     {
          2461391.5,
          {0.01067696737,-0.0004203174112,-131.1968538,6.825776517,-0.110287354,-0.1097188092}, /*cmx*/
          {10.99794195,-0.1877052645,6.91994871,0.8664202023}, /*cfx*/
          {-0.2980755828,-0.0006444340329,133.3845259,-6.915119865,0.1121406885,0.09934178411}, /*cmy*/
          {12.58568828,1.407989282,2.2405285,2.870734836}, /*cfy*/
          {-0.03329954273,0.0001336492762,-30.4795151,-1.706342446,-0.0285717854,0.02430881745}, /*cmz*/
          {2.00061573,6.544636455,4.210536355,1.214103571} /*cfz*/
     },
     {
          2461432.5,
          {0.02600958352,-0.0007230453507,130.7786657,6.871495496,0.1114546935,0.1101079137}, /*cmx*/
          {1.609803764,6.131137165,-27.60450793,4.020657229}, /*cfx*/
          {-0.2883498798,-0.001021838568,-133.6192922,6.993245096,-0.1137408316,-0.1013752503}, /*cmy*/
          {166.5600174,-1.702029248,-63.70653772,-0.2610521066}, /*cfy*/
          {-0.0316712515,0.000164391883,32.3566645,1.723443425,0.0278668402,-0.02483141057}, /*cmz*/
          {5.110316328,3.331803156,7.264893097,4.278773622} /*cfz*/
     },
     {
          2461473.5,
          {0.03946637033,-0.0006459710656,-131.0017507,6.91748988,0.1123403898,-0.1100773953}, /*cmx*/
          {4.775598881,-0.1269362912,-15.01451917,0.8937351698}, /*cfx*/
          {-0.2994938441,-0.0005754467319,133.7019807,-7.0234338,-0.1142196389,0.102388784}, /*cmy*/
          {6.36177308,2816.326876,5.425982146,2.899818272}, /*cfy*/
          {-0.03216248818,0.0001341705215,-31.58389287,-1.584660768,0.0245502991,0.02183007753}, /*cmz*/
          {1.985750865,6.445915071,-11.62429117,1.141714481} /*cfz*/
     },
     {
          2461514.5,
          {0.04012543622,-0.0004938814884,-131.7764358,6.943429012,0.112512453,0.1106200073}, /*cmx*/
          {11.07901775,-0.1054137237,10.13998616,4.045715878}, /*cfx*/
          {-0.2923112145,-0.0008400036766,133.6474361,7.004265588,0.1135872146,-0.1026808311}, /*cmy*/
          {0.09724120616,4.619760493,2.302714734,-0.2388877574}, /*cfy*/
          {-0.02917730819,-1.052365279e-06,-28.28382906,-1.334397521,0.01976675516,-0.01707683365}, /*cmz*/
          {8.346991371,6.490619229,7.267896477,4.37487221} /*cfz*/
     },
     {
          2461555.5,
          {0.05051637064,-0.0004182137491,-132.6550408,-6.937715331,-0.1119207239,-0.1085860029}, /*cmx*/
          {-1.461827778,3.06292267,7.027072631,0.9410063803}, /*cfx*/
          {-0.2930957042,-0.0007079588773,-133.476506,-6.950014385,-0.1122800078,0.1030855777}, /*cmy*/
          {3.262053014,1.503543332,5.472067931,2.941878208}, /*cfy*/
          {-0.03077115041,-1.969505754e-05,-23.81578015,1.064184272,-0.01523078255,0.01207683242}, /*cmz*/
          {14.7781068,-2.788800261,16.86243109,1.51096576} /*cfz*/
     },
     {
          2461596.5,
          {0.0563031064,-0.0004659861225,133.2698435,6.90368258,0.1108348916,0.1061658892}, /*cmx*/
          {33.1322417,6.24248843,3.926599544,4.124681999}, /*cfx*/
          {-0.285817699,-0.0008698831677,133.2808101,6.879910612,-0.1106988722,-0.1035712735}, /*cmy*/
          {6.437419611,4.682456582,-0.7699703935,-0.1635195374}, /*cfy*/
          {-0.03102430193,-5.376807233e-05,19.86891201,-0.8818132865,-0.0128863251,-0.009713767059}, /*cmz*/
          {43.26041191,-18.24301654,-1.678905144,5.106830058} /*cfz*/
     },
     {
          2461637.5,
          {0.06852874024,-0.0002570370218,133.5385134,-6.864138009,0.1098480583,-0.1022116024}, /*cmx*/
          {-10.80089526,9.434563116,10.26334303,1.055578588}, /*cfx*/
          {-0.2923777314,-0.0003476554828,-133.1177383,6.81962732,-0.1094795981,0.1056386739}, /*cmy*/
          {3.342907781,4.733597543,5.568299568,3.048902828}, /*cfy*/
          {-0.03341459599,-5.084718357e-05,17.61654904,0.8582870302,-0.01371841155,0.01048882025}, /*cmz*/
          {24.61045033,-14.84540643,-13.97187946,2.337279903} /*cfz*/
     },
     {
          2461678.5,
          {0.06830880601,0.0001358773441,133.5472578,-6.845756823,0.1095722485,0.0991449038}, /*cmx*/
          {8.10720945,9.493284526,10.32350604,4.254015343}, /*cfx*/
          {-0.2812245708,-0.0008025717575,-133.0655277,6.797972962,-0.1092580456,-0.1073480816}, /*cmy*/
          {9.684525119,4.7949162,5.63211309,-0.0393807711}, /*cfy*/
          {-0.03343126055,-0.0001519004322,17.2553083,0.9629840179,0.01651314216,-0.01218085009}, /*cmz*/
          {5.83767138,10.38540752,1.804381995,5.480080337} /*cfz*/
     },
     {
          2461719.5,
          {0.09405360786,-0.0002151273472,133.3457841,-6.861933974,0.1101994911,-0.09628325552}, /*cmx*/
          {8.167233086,9.551189441,10.38040083,1.182208978}, /*cfx*/
          {-0.2774827334,-0.0006061518187,-133.1481608,6.836887761,-0.1104574255,0.1112682411}, /*cmy*/
          {9.746374353,4.856986459,5.693246197,3.164816793}, /*cfy*/
          {-0.03784850378,-6.883220283e-05,-18.68243132,-1.115079869,-0.01944051939,0.01385837785}, /*cmz*/
          {2.619792498,7.178674057,4.854734378,2.150599324} /*cfz*/
     },
     {
          2461760.5,
          {0.1025498869,-3.975991838e-05,-132.9796236,6.908284234,-0.1114533868,0.09535761708}, /*cmx*/
          {11.36032455,0.1744075569,7.283592097,4.350431035}, /*cfx*/
          {-0.2780328133,-0.0005648086698,133.3783304,-6.924655275,0.1125170113,-0.113916143}, /*cmy*/
          {12.94136561,-17.08449718,2.596552276,0.0471792261}, /*cfy*/
          {-0.04024231827,-2.631547421e-05,21.33305165,1.23436877,0.02096179957,-0.01498060344}, /*cmz*/
          {5.63866598,3.903301403,1.562488297,5.013637743} /*cfz*/
     },
     {
          2461801.5,
          {0.119476893,-0.0001284456573,-132.724216,6.963701745,0.112761343,-0.09517069642}, /*cmx*/
          {-1.169636771,12.77494242,-2.110358366,1.2401145}, /*cfx*/
          {-0.2760039114,-0.0004092959599,133.605412,-7.009031995,-0.1142722592,0.1167681435}, /*cmy*/
          {0.4119500919,-23.33567552,-13.08499503,3.208025523}, /*cfy*/
          {-0.04112866005,4.150721454e-05,-23.21212467,-1.243210977,-0.02008620054,0.01477406739}, /*cmz*/
          {2.427863055,6.929475621,4.571969474,1.703874635} /*cfz*/
     },
     {
          2461842.5,
          {0.1246103099,-6.334564949e-05,132.8806498,-7.006498256,-0.1135681197,0.09546828568}, /*cmx*/
          {1.995205245,-2.910122178,13.61840676,4.379516824}, /*cfx*/
          {-0.2702179,-0.0007573087023,-133.7129601,7.04623959,-0.114880393,-0.1167754792}, /*cmy*/
          {3.576011005,11.24114124,5.780649403,0.0635355306}, /*cfy*/
          {-0.03817833913,4.536308163e-05,22.57583794,1.107872752,-0.01682897866,-0.01240100181}, /*cmz*/
          {5.582336959,3.74167873,4.50871011,4.786263031} /*cfz*/
     },
     {
          2461883.5,
          {0.1460881584,-0.0006199321571,133.3720597,7.016711648,-0.113467963,-0.09509779779}, /*cmx*/
          {2.013740801,0.2506859588,1.071388129,1.270691313}, /*cfx*/
          {-0.2686820587,-0.0004306163952,133.6723823,7.031237056,-0.1143426782,0.1177534007}, /*cmy*/
          {113.5487196,-7.591804703,-0.4861581417,3.221112916}, /*cfy*/
          {-0.03681416365,0.0001726254644,19.5197108,0.867492352,-0.01221660381,0.008716580109}, /*cmz*/
          {5.691432964,10.08835734,4.568284703,1.846280656} /*cfz*/
     },
     {
          2461924.5,
          {0.1426268196,-0.0001352713233,133.8599597,-6.991104943,0.1125394607,0.09350754933}, /*cmx*/
          {8.320377281,3.416844511,4.239456495,4.435826253}, /*cfx*/
          {-0.2726690131,-0.0003278039409,-133.5464202,-6.97923041,0.113028764,-0.1168201688}, /*cmy*/
          {3.613958427,1.855802597,2.68045725,0.09583868115}, /*cfy*/
          {-0.03158881167,0.0001068762757,-15.58179379,0.6217918174,-0.008123816218,-0.006159896992}, /*cmz*/
          {-78.89799114,-27.36146714,-7.687527571,5.57371137} /*cfz*/
     },
     {
          2461965.5,
          {0.1543546585,-0.0004056125081,-134.0879322,6.935878673,-0.1111279447,-0.09119713726}, /*cmx*/
          {-89.03466676,6.594951326,7.421350574,1.366562551}, /*cfx*/
          {-0.2579154014,-0.0005602071214,133.3832368,-6.908828132,-0.1114054008,0.1172976833}, /*cmy*/
          {6.787193549,1.890888943,5.860905703,3.277127921}, /*cfy*/
          {-0.02625919686,4.23253392e-05,-12.72076492,0.5075163036,-0.007210099174,0.007608075809}, /*cmz*/
          {21.9890314,10.81164777,-0.8141696804,3.086657348} /*cfz*/
     },
     {
          2462006.5,
          {0.1629889745,-0.0003175079055,-134.0871587,-6.881481764,-0.1099489423,0.08760534735}, /*cmx*/
          {-1.022768529,9.786625205,7.475353232,4.58054567}, /*cfx*/
          {-0.2566935546,-0.0004674513104,133.2441148,6.845774397,-0.1100771269,-0.1167563578}, /*cmy*/
          {6.832592464,11.36494107,5.914138737,0.1806147583}, /*cfy*/
          {-0.02396481485,-2.023105929e-05,-11.7489144,-0.5667779304,0.009397513199,-0.01027263374}, /*cmz*/
          {3.465629864,-4.535326177,-3.650199966,0.1267201388} /*cfz*/
     },
     {
          2462047.5,
          {0.1764806567,-0.0004410847681,-134.0363714,-6.858640502,-0.1096598123,-0.08538145389}, /*cmx*/
          {5.317785759,9.845800042,7.536941415,1.542511319}, /*cfx*/
          {-0.246685311,-0.0003669690213,133.1861306,6.820412413,-0.1097404251,0.1186266974}, /*cmy*/
          {6.890092985,5.142028489,5.976873728,3.376633586}, /*cfy*/
          {-0.02433725909,-8.454613128e-05,-11.63252808,0.6807391473,-0.01205804549,0.01229895541}, /*cmz*/
          {9.83942698,4.920119591,5.728135254,3.183238197} /*cfz*/
     },
     {
          2462088.5,
          {0.1818609232,1.406869982e-05,-133.9970465,-6.884794272,-0.1105160112,0.08320235009}, /*cmx*/
          {5.377505379,9.90429024,7.594550334,4.755958261}, /*cfx*/
          {-0.2399797011,-0.0004695880215,133.2575082,6.856505906,-0.1108518001,-0.1203719903}, /*cmy*/
          {6.951876003,5.203797933,6.037760727,0.2769309645}, /*cfy*/
          {-0.02805194392,-0.000157991187,12.05896195,-0.7827249857,0.01406806206,-0.01278881766}, /*cmz*/
          {6.514059959,1.596751617,2.377749826,-0.1853697067} /*cfz*/
     },
     {
          2462129.5,
          {0.2003355016,-0.0004331447967,133.8796475,6.943715626,0.1120225513,-0.08336559191}, /*cmx*/
          {8.570331225,6.810432491,4.497381752,1.673843331}, /*cfx*/
          {-0.2173855748,-0.0009301897274,133.4604232,6.943310938,0.1129063351,0.123634132}, /*cmy*/
          {-68.39260699,-1.029395111,2.941495044,3.444434929}, /*cfy*/
          {-0.03316975921,-8.119475632e-05,-13.77414753,0.8497535877,-0.01474093358,0.01206752975}, /*cmz*/
          {3.101094083,4.495228259,5.274445296,2.68066187} /*cfz*/
     },
     {
          2462170.5,
          {0.2146875026,-0.0003560115769,133.7870767,7.009668937,-0.1134946428,0.08272616688}, /*cmx*/
          {27.45582949,0.5598577404,20.23377522,4.834225322}, /*cfx*/
          {-0.2200811748,-0.0006061347309,-133.6770204,-7.032185109,0.1147681738,-0.1252234492}, /*cmy*/
          {-2.382072792,52.40961043,9.250720978,0.3111700525}, /*cfy*/
          {-0.03755873622,7.140347641e-05,15.39514105,-0.8338036458,0.01344919516,-0.009972792966}, /*cmz*/
          {6.093814187,1.16648079,1.936625904,5.595190392} /*cfz*/
     },
     {
          2462211.5,
          {0.2176375809,-0.0002924029813,-133.9039906,-7.050488633,-0.1142426361,-0.08395164106}, /*cmx*/
          {5.486723157,16.2884088,7.685419239,1.706259145}, /*cfx*/
          {-0.2063984703,-0.0009618770746,133.7967748,-7.074761602,0.1154848175,0.1266948157}, /*cmy*/
          {7.064384621,21.01188116,9.265416255,3.453861186}, /*cfy*/
          {-0.03414207056,0.0001281130929,-14.89737806,-0.6972139029,0.01015324058,0.007188337699}, /*cmz*/
          {2.96150389,7.384333053,8.133864142,2.40548763} /*cfz*/
     },
     {
          2462252.5,
          {0.2267545079,-0.0002697992937,134.1663763,7.049387704,0.1139472101,0.08304046147}, /*cmx*/
          {8.64507447,32.01317217,-1.722762757,4.869424838}, /*cfx*/
          {-0.2026963099,-0.000960932679,-133.7776852,7.063050114,-0.1150092402,-0.1260768135}, /*cmy*/
          {10.22125289,11.6018675,50.12050096,0.3218345874}, /*cfy*/
          {-0.0276016214,0.0001681465798,12.34172621,-0.4743741285,0.005806414053,-0.004404560226}, /*cmz*/
          {25.14197868,13.8166323,20.86787436,5.97195666} /*cfz*/
     },
     {
          2462293.5,
          {0.2300839429,-0.0004196882589,-134.317419,-7.005013115,-0.1127120114,-0.08291112411}, /*cmx*/
          {-0.7585784239,3.761185757,1.44333276,1.765886789}, /*cfx*/
          {-0.1916221745,-0.0011745409,-133.676854,-7.010905622,0.1136569915,0.1254575169}, /*cmy*/
          {3.95682252,2.197582227,3.019306347,3.477461221}, /*cfy*/
          {-0.01781895941,0.0001333268711,-9.820870368,-0.3127990381,0.003677929988,0.004987343528}, /*cmz*/
          {-2.688428227,1.898084162,3.012911194,3.688366818} /*cfz*/
     },
     {
          2462334.5,
          {0.235446167,-0.0002013855934,134.2211265,-6.934463368,0.1110650455,0.08082053366}, /*cmx*/
          {2.41525382,-15.05344866,4.623833227,4.983269313}, /*cfx*/
          {-0.1940455048,-0.0007337690591,133.5360781,6.940551059,-0.1120061657,-0.1240067546}, /*cmy*/
          {7.128082708,5.37218363,6.197562181,0.3708070682}, /*cfy*/
          {-0.009445156362,9.337857662e-05,-9.763193385,-0.4020483852,0.006572169397,-0.007900283437}, /*cmz*/
          {4.170301404,2.642759523,3.660199248,0.8502728229} /*cfz*/
     },
     {
          2462375.5,
          {0.2293808025,0.0001365995255,-133.9928104,6.867226542,0.1097232236,-0.08012020826}, /*cmx*/
          {-13.24727251,13.27040873,4.678089016,1.934998866}, /*cfx*/
          {-0.1780653237,-0.001107799933,-133.4195155,-6.873657348,-0.1105524875,0.1227747505}, /*cmy*/
          {4.030156051,14.84431434,6.249124817,3.55272807}, /*cfy*/
          {-0.00195932173,-9.381419166e-05,11.15049196,-0.5626610104,-0.009578783185,0.01041309333}, /*cmz*/
          {1.381039282,9.118238757,6.82432365,3.966271561} /*cfz*/
     },
     {
          2462416.5,
          {0.2440742517,2.429996234e-05,-133.8926571,6.841996979,0.1094651158,0.07917296042}, /*cmx*/
          {5.658549422,7.04682716,4.740733076,5.199928339}, /*cfx*/
          {-0.1692371427,-0.0008400940568,-133.3578113,-6.843836488,-0.110087632,-0.1218787516}, /*cmy*/
          {10.36971345,8.620169958,6.310794719,0.4642052021}, /*cfy*/
          {-0.000423703423,-0.0002330876123,11.36400733,0.6474631908,0.0112205597,-0.01189306151}, /*cmz*/
          {7.746453845,5.889976969,3.499328936,0.6463947061} /*cfz*/
     },
     {
          2462457.5,
          {0.2440433762,0.0003303222929,-134.0022257,6.876877688,0.1105242456,-0.08021667775}, /*cmx*/
          {5.71789898,7.105838795,4.799028398,2.137523634}, /*cfx*/
          {-0.1570111817,-0.0009006163186,-133.4183625,-6.875292056,-0.1110593335,0.1227769194}, /*cmy*/
          {10.4310018,8.681234191,6.371258244,3.639363881}, /*cfy*/
          {-0.006097358474,-0.0002893103057,-10.0058682,-0.6494657869,-0.01150038018,0.01240385}, /*cmz*/
          {4.417959644,2.488258448,6.34188475,3.529852111} /*cfz*/
     },
     {
          2462498.5,
          {0.2564904683,0.0003531345103,-134.1257162,-6.950790623,-0.1123214347,0.08102727296}, /*cmx*/
          {12.05232394,4.011822608,1.70119955,5.350600395}, /*cfx*/
          {-0.1452547551,-0.0007077095982,-133.598847,-6.961542608,0.113119833,-0.1244354705}, /*cmy*/
          {16.7680716,2.448186691,3.275209495,0.5265485974}, /*cfy*/
          {-0.01426978177,-0.0002227143339,9.208542244,0.6100790651,0.01061112895,-0.01119760701}, /*cmz*/
          {7.139344561,5.290668388,2.87494045,0.1682257569} /*cfz*/
     },
     {
          2462539.5,
          {0.2560039976,0.0006007171737,-134.1928605,-7.025109072,0.1139226487,-0.08198370988}, /*cmx*/
          {5.804588083,4.043092657,11.15248829,2.218738924}, /*cfx*/
          {-0.131163073,-0.001069726589,-133.8131154,7.05103821,0.114994296,0.1260244374}, /*cmy*/
          {10.52180396,131.2850809,9.584221824,3.668766629}, /*cfy*/
          {-0.01910738042,-9.117526894e-05,-9.68818093,-0.5324268726,-0.008412936285,0.008282324853}, /*cmz*/
          {3.69278567,1.888167452,30.90936962,3.177773423} /*cfz*/
     },
     {
          2462580.5,
          {0.2736584984,0.0001359486337,-134.2908392,-7.065589983,0.1146387406,0.08283605274}, /*cmx*/
          {5.825697266,10.34493301,4.884820896,5.386350909}, /*cfx*/
          {-0.1227880849,-0.0008807396239,-133.9332606,7.09797209,0.1157995354,-0.1269169088}, /*cmy*/
          {-20.87306953,5.638744149,9.597778815,0.5343492721}, /*cfy*/
          {-0.01865444947,0.000126309372,9.303902431,0.3876543012,-0.004985484405,-0.004881738028}, /*cmz*/
          {6.848136828,5.016906847,5.796149513,0.2175317197} /*cfz*/
     },
     {
          2462621.5,
          {0.2680308337,0.0005323365286,134.3727,7.055491908,0.1141682037,-0.08277941079}, /*cmx*/
          {8.982672428,13.50122327,23.74854539,2.240771357}, /*cfx*/
          {-0.1246961937,-0.0007647628834,133.9313396,7.087930088,-0.1153465564,0.1265911698}, /*cmy*/
          {13.69833911,5.651963093,12.75219291,3.673996379}, /*cfy*/
          {-0.01159911677,0.000242058791,-8.167070624,0.2515849347,-0.002902280157,0.003814895126}, /*cmz*/
          {-2.198281371,-0.6574701012,0.5906532435,4.252749916} /*cfz*/
     },
     {
          2462662.5,
          {0.2735467719,0.0003307473722,134.2380738,-6.996338873,-0.1127001695,0.08280589754}, /*cmx*/
          {2.718897108,4.097116892,1.780277968,5.435122252}, /*cfx*/
          {-0.1142343098,-0.0007830040019,-133.8411847,-7.035766248,0.1139914561,-0.1250157601}, /*cmy*/
          {-20.84208476,2.529255547,3.34850612,0.5570614798}, /*cfy*/
          {0.0003535716406,0.0002426792025,-9.092484639,0.3734939871,-0.006505018355,-0.006482791409}, /*cmz*/
          {4.703964248,0.2099576638,1.318521129,1.647381243} /*cfz*/
     },
     {
          2462703.5,
          {0.2717345193,0.0004532055426,-133.8629109,6.911674349,0.1108192326,-0.08229015509}, /*cmx*/
          {5.891038879,44.97144035,4.959655751,2.343780395}, /*cfx*/
          {-0.1115965327,-0.0007326276235,133.7174926,6.962843854,-0.112251558,0.1226047389}, /*cmy*/
          {7.460246461,5.702099229,6.52519598,3.723962391}, /*cfy*/
          {0.01152655298,0.0001799544078,-12.33477107,0.6108021614,-0.01054406304,0.009147622853}, /*cmz*/
          {-1.162829603,6.732474456,1.377392261,4.845863591} /*cfz*/
     },
     {
          2462744.5,
          {0.2804209315,0.0001295837307,133.440886,-6.835282464,0.1093657574,0.08378967401}, /*cmx*/
          {2.793662104,10.46323155,5.014199771,5.590853131}, /*cfx*/
          {-0.1023775735,-0.0004289757376,-133.6028713,-6.8934771,-0.1107268765,-0.1200919057}, /*cmy*/
          {4.361116759,1347.208281,6.575667365,0.635326188}, /*cfy*/
          {0.02037027505,2.653499565e-05,-15.11482212,-0.7845754645,0.01316471735,-0.01051813164}, /*cmz*/
          {11.59843801,3.610436808,4.438031157,1.611562452} /*cfz*/
     },
     {
          2462785.5,
          {0.274231283,0.0007168025316,133.3130834,-6.810041064,0.1091523624,-0.08476483479}, /*cmx*/
          {9.132534894,10.52337639,5.077692849,2.53227232}, /*cfx*/
          {-0.09987300326,-0.000166926348,-133.5379324,-6.858222979,-0.1101332734,0.1174256127}, /*cmy*/
          {10.69971965,8.947912022,6.636842589,3.819246101}, /*cfy*/
          {0.02120162772,-0.0001070816643,15.50074608,0.8325253343,-0.01379381366,0.01061832632}, /*cmz*/
          {8.517510929,6.661629394,7.412497506,4.47549435} /*cfz*/
     },
     {
          2462826.5,
          {0.2828532957,0.0003921509196,133.5579771,-6.853877005,0.1104247879,0.08848671072}, /*cmx*/
          {9.19184961,10.58324023,5.136820696,5.765775482}, /*cfx*/
          {-0.07262609832,-0.0005152582748,-133.5790923,-6.884782091,-0.1109837413,-0.1165821746}, /*cmy*/
          {10.76061862,9.008601665,6.697277088,0.7277161218}, /*cfy*/
          {0.01698973103,-0.0002723963418,-13.22711441,-0.7549183182,0.01250846207,-0.01035575262}, /*cmz*/
          {5.303194732,3.334563182,4.033856744,1.000131726} /*cfz*/
     },
     {
          2462867.5,
          {0.2929947363,0.0003593229026,133.921253,6.942342463,-0.1124699278,-0.09020680422}, /*cmx*/
          {15.52655284,7.489130877,2.038297828,2.664209428}, /*cfx*/
          {-0.06553279738,-0.0002282120314,133.7401057,-6.968601868,0.1129922311,0.1171951609}, /*cmy*/
          {39.08896908,2.775690348,3.601613865,3.886389154}, /*cfy*/
          {0.006335021972,-0.0001837878,-10.11708976,-0.6081580182,-0.009930968087,0.009333859801}, /*cmz*/
          {5.062513165,15.66232274,6.934989633,3.888317061} /*cfz*/
     },
     {
          2462908.5,
          {0.2960116924,0.0002913399459,134.1483975,-7.024822282,-0.1142011461,0.09271750829}, /*cmx*/
          {9.278789504,-1.90516217,8.346721642,5.829444075}, /*cfx*/
          {-0.0472513163,-0.0004167786291,-133.9417543,7.058437732,0.1148916093,-0.118808136}, /*cmy*/
          {-1.714653463,49.93135872,9.910899902,0.7578351532}, /*cfy*/
          {-0.001136320128,4.263533575e-06,8.480364271,-0.4542455632,0.006804410025,-0.006706712386}, /*cmz*/
          {1.646777588,9.238363334,10.01064708,0.7796030772} /*cfz*/
     },
     {
          2462949.5,
          {0.299076292,0.0004542991355,-134.2487971,-7.065191301,-0.1148666788,-0.09228149928}, /*cmx*/
          {6.157928042,10.67843196,8.360205224,2.685526813}, /*cfx*/
          {-0.03961489352,-0.0004991894674,-134.0615451,7.107486945,0.1157479925,0.1191612205}, /*cmy*/
          {-1.693888647,5.96607052,9.923966701,3.89271251}, /*cfy*/
          {-0.0008156594311,0.0001901891225,-8.240727601,-0.3483580815,-0.004845068543,0.004548829778}, /*cmz*/
          {4.819832781,-28.21245882,57.62754587,4.546502312} /*cfz*/
     },
     {
          2462990.5,
          {0.3047043264,1.030797802e-05,134.1614601,7.046050628,-0.1142310993,0.09343720744}, /*cmx*/
          {9.314207946,13.83350479,14.65610525,5.840585286}, /*cfx*/
          {-0.02272693554,-0.0008934273016,-134.0665403,7.099033981,0.1153122315,-0.1190598453}, /*cmy*/
          {4.602479971,5.97844367,9.935866595,0.7630008528}, /*cfy*/
          {0.008369180293,0.0002520914632,9.58263102,-0.4242866424,-0.007217449893,-0.006859413115}, /*cmz*/
          {-4.252811083,3.769610755,1.711143555,2.161895412} /*cfz*/
     },
     {
          2463031.5,
          {0.3086774553,4.743403537e-05,133.7786423,-6.974026636,0.1125385592,-0.09244760406}, /*cmx*/
          {9.332809067,4.428369189,5.253149066,2.724603135}, /*cfx*/
          {-0.02851429665,-0.0003722736365,-133.9808805,-7.046906782,-0.1139655253,0.1170069078}, /*cmy*/
          {-1.664519553,2.854909382,6.814553665,3.918711967}, /*cfy*/
          {0.02014570145,0.0003278871912,13.18940385,-0.6634512704,-0.01165491617,0.0106021838}, /*cmz*/
          {2.374897103,4.048774695,1.875430926,5.511482982} /*cfz*/
     },
     {
          2463072.5,
          {0.2957931285,0.0003048409889,-133.1391752,6.87558063,-0.1104353193,0.09347569161}, /*cmx*/
          {6.220890825,7.603107468,2.149111363,-0.3692763946}, /*cfx*/
          {-0.01384018593,-0.0007764529253,133.8636665,6.971125762,-0.1121587214,-0.1145739475}, /*cmy*/
          {1.50408827,6.026854237,-5.717336769,0.8161871582}, /*cfy*/
          {0.03313698013,0.0002141633444,-17.60755963,0.9152412836,0.01563668356,-0.01347557413}, /*cmz*/
          {18.29082722,7.270237089,5.018200073,2.408381115} /*cfz*/
     },
     {
          2463113.5,
          {0.3019824068,0.0001135347925,132.5391064,6.792340269,-0.1088823461,-0.09421503441}, /*cmx*/
          {3.123092328,-17.48008212,8.487226823,2.845222099}, /*cfx*/
          {-0.00421414682,-0.000622821983,-133.7461358,-6.900276316,-0.1106013231,0.1104685804}, /*cmy*/
          {4.687545484,-47.3346645,6.899027046,4.006910632}, /*cfy*/
          {0.0444876532,3.028829695e-06,-20.80075592,-1.085070117,-0.01803567202,0.01400428719}, /*cmz*/
          {5.84135023,4.12519577,1.810588246,5.502165409} /*cfz*/
     },
     {
          2463154.5,
          {0.2964671945,0.0002233272689,132.377576,6.767364719,-0.1087248131,0.09782350511}, /*cmx*/
          {9.461957035,7.713881132,8.552130146,-0.2241022327}, /*cfx*/
          {0.007980186126,-0.0005877102069,-133.6697986,-6.860549598,-0.1099123304,-0.1074979373}, /*cmy*/
          {4.742503716,9.27172622,6.960286115,0.9267813934}, /*cfy*/
          {0.04672698708,-0.0001832009806,21.29957719,1.118755148,0.01824193424,-0.01253223557}, /*cmz*/
          {2.751100917,7.205154733,4.835188736,2.194820224} /*cfz*/
     },
     {
          2463195.5,
          {0.2970629108,0.0004282314857,132.7685521,6.821349494,-0.1102022297,-0.1012294281}, /*cmx*/
          {9.521689728,7.774717238,8.612053525,2.983648034}, /*cfx*/
          {0.02053142053,-0.000308900628,-133.6846921,-6.882469721,-0.1106802672,0.1049008542}, /*cmy*/
          {4.803253555,9.332483308,7.021121956,4.120069351}, /*cfy*/
          {0.04114150993,-0.0002712874381,18.85827243,-1.011528982,-0.01625258547,0.009949838342}, /*cmz*/
          {9.013505645,16.51973969,1.544720952,5.038461146} /*cfz*/
     },
     {
          2463236.5,
          {0.2879006815,0.0007176665363,133.3650038,-6.923324533,0.112464859,0.1049872581}, /*cmx*/
          {15.85688399,4.680749693,5.513094976,-0.1292699411}, /*cfx*/
          {0.04538286259,-0.0008469640522,133.8217164,-6.961595134,0.1125935645,-0.1051725473}, /*cmy*/
          {1.71582995,3.099861399,3.926210449,1.008827317}, /*cfy*/
          {0.03040600687,-0.0002478836254,15.09172957,0.823170893,-0.01294296999,-0.008119499813}, /*cmz*/
          {8.911386686,6.98236584,7.720021425,1.651866997} /*cfz*/
     },
     {
          2463277.5,
          {0.3000914884,0.0003221270011,-133.7578595,-7.014744887,0.1143296877,-0.106815423}, /*cmx*/
          {6.467964842,105.2417976,5.537321406,3.032431573}, /*cfx*/
          {0.06124887424,-0.0007081786219,-134.0039385,7.052296011,0.1145331319,0.1053237508}, /*cmy*/
          {4.895044814,18.8402058,10.2360526,4.160668579}, /*cfy*/
          {0.02301000035,-7.703812488e-05,12.53642853,-0.653467205,-0.009963852642,0.006656958868}, /*cmz*/
          {8.79473007,3.843314662,7.808863633,4.982209393} /*cfz*/
     },
     {
          2463318.5,
          {0.2892640354,0.0007819641544,133.8635551,-7.052933001,0.1149148613,0.1076102927}, /*cmx*/
          {-2.935993858,4.727239845,5.549671544,-0.1154530829}, /*cfx*/
          {0.06617045023,-0.0007241980851,-134.1187491,7.101268195,0.115398001,-0.1065736917}, /*cmy*/
          {-1.367316699,6.290937045,10.24931275,1.015842635}, /*cfy*/
          {0.02057965315,0.0001870046166,-12.43100392,0.6093043104,0.009661223115,-0.008017556491}, /*cmz*/
          {5.680611822,132.8687104,-1.266610781,2.37950823} /*cfz*/
     },
     {
          2463359.5,
          {0.2905172898,0.0006476123175,-133.6165834,7.024780813,0.1140969687,-0.1074095163}, /*cmx*/
          {12.78667292,7.881657593,11.84460243,3.041732364}, /*cfx*/
          {0.07978754832,-0.0008681899146,-134.1260386,7.094351004,0.1149937727,0.1054492161}, /*cmy*/
          {4.928867426,6.303096334,-2.305514175,4.170498039}, /*cfy*/
          {0.02831341689,0.0003079657453,14.87093385,0.7498244002,-0.01277836923,0.0123458868}, /*cmz*/
          {8.995061098,-5.094830171,-4.12959952,5.845461584} /*cfz*/
     },
     {
          2463400.5,
          {0.2830564224,0.0007922768323,132.978693,-6.939219422,-0.1121557771,0.1065837221}, /*cmx*/
          {3.380425051,4.759316348,2.441201233,-0.08989123246}, /*cfx*/
          {0.08157076482,-0.0008822572042,-134.0472701,-7.041408422,-0.1136280793,-0.1042613272}, /*cmy*/
          {11.2278513,3.179217019,7.139390038,1.044985941}, /*cfy*/
          {0.03948853923,0.0003597840279,19.23705099,-1.002670432,0.01724804553,-0.01713307086}, /*cmz*/
          {9.174158838,4.474279504,5.393964277,2.809320249} /*cfz*/
     },
     {
          2463441.5,
          {0.2835265213,0.0005124055672,-132.0624829,-6.827547823,0.1098606883,-0.1066537436}, /*cmx*/
          {6.551640248,4.792787946,5.620874474,3.099913767}, /*cfx*/
          {0.08751938314,-0.0006052092257,133.9286487,6.9654678,-0.1118405537,0.1009037434}, /*cmy*/
          {1.829858407,6.351112489,-11.67565957,4.238115966}, /*cfy*/
          {0.05251170259,0.0002856447712,-23.98250485,1.256498394,-0.02124204652,0.02068130238}, /*cmz*/
          {12.44741442,7.671178331,2.261617568,-0.2777852513} /*cfz*/
     },
     {
          2463482.5,
          {0.2680524109,0.001020827887,131.2814125,-6.736284323,0.1081616562,0.1070723692}, /*cmx*/
          {3.453866863,4.842801189,5.676517754,0.00413457347}, /*cfx*/
          {0.08733197487,-0.0003667206771,-133.8084106,6.892511334,-0.1102489516,-0.09757666017}, /*cmy*/
          {5.012992643,-12.45310451,7.223913206,1.154328279}, /*cfy*/
          {0.05903329697,0.0002582321818,-27.35577615,-1.427930155,0.02364439833,-0.02158339118}, /*cmz*/
          {-0.02980594895,4.533053151,5.362197328,2.855365271} /*cfz*/
     },
     {
          2463523.5,
          {0.2657905594,0.0007627559081,131.079242,-6.713027871,0.1080675432,-0.1101488207}, /*cmx*/
          {9.793107771,4.905254029,5.742791082,3.213689536}, /*cfx*/
          {0.1073448992,-0.0004659442217,-133.7138583,6.850915112,-0.1095400362,0.09334735338}, /*cmy*/
          {5.067787371,6.454128154,7.285328491,4.385506227}, /*cfy*/
          {0.06377325175,-1.23712465e-05,27.99240991,1.462332749,-0.0238014734,0.01973776168}, /*cmz*/
          {3.160515311,1.354475523,2.142493905,-0.3248115624} /*cfz*/
     },
     {
          2463564.5,
          {0.2610317799,0.0009431303923,131.6218534,-6.777027659,0.1097238283,0.1134151021}, /*cmx*/
          {9.853303945,4.966941597,5.803480744,0.1100977822}, /*cfx*/
          {0.1102254728,-2.155411097e-05,-133.6929226,6.868126389,-0.1102375511,-0.09129152289}, /*cmy*/
          {5.128366716,6.515001123,7.346691697,1.301422958}, /*cfy*/
          {0.05864084142,-9.18551743e-05,25.63316786,1.35130661,-0.02164967493,-0.01571821406}, /*cmz*/
          {229.3549775,7.571030163,8.332593366,2.69059944} /*cfz*/
     },
     {
          2463605.5,
          {0.2562127801,0.0008503296041,-132.4604107,6.892961551,-0.1122185544,-0.1175354175}, /*cmx*/
          {19.33055749,1.873121395,2.704094431,3.286690572}, /*cfx*/
          {0.1302147546,-8.409565365e-05,133.7880261,-6.943435645,0.1121006719,0.09035404733}, /*cmy*/
          {8.324246238,-2.858787853,4.252457111,4.50066568}, /*cfy*/
          {0.04889345252,-6.962007322e-05,21.80461422,-1.156494315,-0.01822169123,0.012565831}, /*cmz*/
          {9.393613534,10.65882632,8.288803818,5.756887821} /*cfz*/
     },
     {
          2463646.5,
          {0.250837234,0.00111307012,133.0458421,6.992201675,-0.1141380162,0.1189084277}, /*cmx*/
          {9.941973637,14.46871695,9.010079812,0.1467200053}, /*cfx*/
          {0.1378692805,3.024813996e-05,-133.9444195,-7.032662399,0.1140236726,-0.0908267803}, /*cmy*/
          {5.220579159,16.02356042,10.56279704,1.360428893}, /*cfy*/
          {0.03994435732,0.0001281348154,-19.09018854,-0.9947685649,-0.01558796039,-0.01192065612}, /*cmz*/
          {6.198091145,10.69340135,8.385816348,2.696875296} /*cfz*/
     },
     {
          2463687.5,
          {0.2495288354,0.0007833566142,133.1419324,7.027266534,-0.1146407187,-0.1201982879}, /*cmx*/
          {9.963105849,8.201438297,9.021601106,3.295607421}, /*cfx*/
          {0.1576405635,-0.0003763790975,-134.0458916,-7.081550309,0.1149073614,0.09134701518}, /*cmy*/
          {11.52480678,9.75782335,10.57652004,4.518997589}, /*cfy*/
          {0.03964013233,0.0002257238452,19.07590678,0.9763594046,-0.01582150769,0.01495364259}, /*cmz*/
          {3.0785302,13.98446362,121.7035292,-0.2302047922} /*cfz*/
     },
     {
          2463728.5,
          {0.2521938425,0.0007075543008,132.723863,-6.987356282,-0.1135760913,0.1186067845}, /*cmx*/
          {41.39398732,11.35530028,27.88216844,0.1524715816}, /*cfx*/
          {0.1526644454,8.391590677e-05,-134.0547469,-7.075890623,0.1145297617,-0.09105348433}, /*cmy*/
          {5.254627473,9.770019162,10.58797777,1.370991916}, /*cfy*/
          {0.04441004245,0.0004145556306,21.83926146,-1.130578567,0.01901691969,-0.01991858243}, /*cmz*/
          {9.463430122,11.00814601,11.92610163,3.042035484} /*cfz*/
     },
     {
          2463769.5,
          {0.240528845,0.0007558142759,-131.7915612,6.886675625,0.111371358,-0.1176171362}, /*cmx*/
          {6.855316313,1.949760857,5.912259383,3.316464936}, /*cfx*/
          {0.1621389386,-0.000181719732,-133.9857259,7.023505935,-0.1131804955,0.08975816889}, /*cmy*/
          {11.55352176,6.646124329,7.466557127,4.556077217}, /*cfy*/
          {0.05321529562,0.0004425733206,-26.44278333,1.385238504,-0.02346230676,0.02559713803}, /*cmz*/
          {12.72429321,1.689706935,2.585043721,-0.01767150458} /*cfz*/
     },
     {
          2463810.5,
          {0.2391987424,0.0006119500343,130.5675519,-6.759508902,-0.1088116662,0.1155527988}, /*cmx*/
          {3.743592081,-1.158033303,2.809320456,0.2044494882}, /*cfx*/
          {0.1646129857,-2.788169689e-05,133.8761472,-6.948391349,0.1114272169,-0.08718224725}, /*cmy*/
          {2.155531519,3.534932716,4.359612279,1.459964974}, /*cfy*/
          {0.06464809575,0.0003720363745,31.33088926,-1.641467284,0.02751416542,-0.02970918388}, /*cmz*/
          {3.401952961,4.884550194,5.748732091,3.164261879} /*cfz*/
     },
     {
          2463851.5,
          {0.2301114354,0.0004117679513,129.5488027,-6.657849337,-0.1069643265,-0.1157256957}, /*cmx*/
          {3.787610666,5.17611753,9.149554743,3.397272702}, /*cfx*/
          {0.1745815316,-0.000150669376,-133.7514658,6.875069427,0.109860355,0.08492510015}, /*cmy*/
          {5.338564551,-12.12760521,10.69309614,4.696884081}, /*cfy*/
          {0.07281547999,0.0001765847093,-34.83709791,1.818479453,-0.03004037519,0.03164808438}, /*cmz*/
          {6.621966215,1.757912249,2.588425764,0.04520328085} /*cfz*/
     },
     {
          2463892.5,
          {0.2266852322,0.000394474767,129.2977317,-6.635254462,-0.1068852613,0.1161779054}, /*cmx*/
          {10.12715885,5.239551646,9.217097741,0.3035283308}, /*cfx*/
          {0.1751280934,0.0004024304941,-133.642364,6.835033238,0.1091957349,-0.08180389144}, /*cmy*/
          {5.393223643,6.779427726,10.75402124,1.641588673}, /*cfy*/
          {0.07615387292,7.351419761e-05,35.64855811,1.861803069,0.03033825706,-0.02984022494}, /*cmz*/
          {3.529579529,8.023347072,5.680145094,3.172978868} /*cfz*/
     },
     {
          2463933.5,
          {0.2071236935,0.0007175198711,129.9832257,-6.709396488,-0.1087235814,-0.1196003498}, /*cmx*/
          {10.18766175,5.302030804,9.278543504,3.48760511}, /*cfx*/
          {0.1931881219,-1.127520994e-05,-133.5776301,6.848687317,0.1098606824,0.08113100458}, /*cmy*/
          {5.453376772,6.840165846,10.81550913,4.886395397}, /*cfy*/
          {0.07088346138,-7.115345309e-06,33.47224857,1.758529598,0.02828578913,0.02604410257}, /*cmz*/
          {-2.742518248,1.700838224,-0.661476469,-0.007238446545} /*cfz*/
     },
     {
          2463974.5,
          {0.2103940154,0.0003178663831,-131.0820282,6.83826908,0.1114095786,0.122433145}, /*cmx*/
          {25.94825967,2.20800236,6.178531592,0.3671193461}, /*cfx*/
          {0.2094871812,4.495403541e-05,133.6202575,-6.920027577,-0.1116715821,-0.08040828139}, /*cmy*/
          {2.365845661,-2.53354332,1.438310988,1.800134455}, /*cfy*/
          {0.06669243586,-0.0001132047295,-29.76799661,1.569811349,0.02496286039,-0.02209405499}, /*cmz*/
          {12.94020797,14.24132873,5.605724266,3.106605411} /*cfz*/
     },
     {
          2464015.5,
          {0.1968908785,0.0005824980644,131.863136,-6.94390794,0.1133625941,-0.1249503481}, /*cmx*/
          {10.27661031,17.9442085,6.199822633,3.51428483}, /*cfx*/
          {0.2172471671,1.7500177e-05,-133.7350274,7.005924307,-0.1135475354,0.0818054258}, /*cmy*/
          {5.545351717,19.49066092,7.749111256,4.964946645}, /*cfy*/
          {0.05770299151,5.584289693e-05,27.10562126,1.418214642,0.02256991988,0.02134014285}, /*cmz*/
          {3.488074673,7.9955779,5.686943687,0.001571719596} /*cfz*/
     },
     {
          2464056.5,
          {0.1918687744,0.0006119077689,-131.9506502,-6.974749201,0.113736907,0.1246824383}, /*cmx*/
          {7.156529124,5.393001499,6.210176797,0.373485572}, /*cfx*/
          {0.2300376924,-6.950428112e-05,133.8236219,7.055759506,-0.1144582632,-0.08142853206}, /*cmy*/
          {2.425070337,6.942067723,7.763005688,1.824789081}, /*cfy*/
          {0.05547744714,0.0002073122725,-27.18428547,1.411959703,-0.02298779614,-0.02396447303}, /*cmz*/
          {0.3669267135,8.10395188,8.9824875,3.233842953} /*cfz*/
     },
     {
          2464097.5,
          {0.1806860758,0.0007548660606,-131.3079652,6.919321611,0.1123743695,-0.1237138552}, /*cmx*/
          {-5.394447352,39.9625043,-50.327871,3.519328847}, /*cfx*/
          {0.2393057774,-0.0004645984985,133.8327028,7.048876725,-0.1140764495,0.08218163159}, /*cmy*/
          {8.721331195,6.954628345,7.775092377,4.978419105}, /*cfy*/
          {0.05758146099,0.0002920916553,30.08879001,1.569093264,-0.02612991381,0.02922759687}, /*cmz*/
          {3.581604708,8.224829857,9.116348258,0.1700806168} /*cfz*/
     },
     {
          2464138.5,
          {0.1837441746,0.0003002246784,130.0201041,-6.799754804,-0.1098480305,0.1209061454}, /*cmx*/
          {4.049758229,5.424448259,3.10058485,0.3973963436}, /*cfx*/
          {0.244175366,-0.0002750893068,133.7864983,-6.998561157,0.1127621118,-0.08080477226}, /*cmy*/
          {15.02053731,3.831052652,4.653868972,1.873861705}, /*cfy*/
          {0.06606702219,0.0002356193313,-34.8014413,-1.822688607,0.03051358662,-0.03490461328}, /*cmz*/
          {6.816131729,5.172770698,6.052006764,3.373062122} /*cfz*/
     },
     {
          2464179.5,
          {0.1641883423,0.0008281646572,-128.4227367,6.653318891,-0.1069611294,-0.1182273075}, /*cmx*/
          {7.221716669,2.317217135,3.140191975,3.567692431}, /*cfx*/
          {0.2381281742,-9.646339988e-05,-133.6969669,6.924989449,-0.1110556689,0.0805811275}, /*cmy*/
          {5.622902735,7.003485773,1.547388948,5.072680368}, /*cfy*/
          {0.06758957157,0.0004220631126,39.77687334,-2.080381851,0.03460052472,0.0396674388}, /*cmz*/
          {3.763057059,-1.055444239,-12.7647323,0.2675620905} /*cfz*/
     },
     {
          2464220.5,
          {0.1548004602,0.0006082541944,127.105217,6.538999577,-0.1049439622,0.1157612909}, /*cmx*/
          {-2.158519963,8.652779632,9.482444346,0.4773100508}, /*cfx*/
          {0.2540708959,-0.000385049076,133.578781,-6.854726348,-0.1095874498,-0.07909435454}, /*cmy*/
          {2.523128055,-52.64090291,7.881142388,2.035305558}, /*cfy*/
          {0.07328543317,0.0002609016153,43.39663757,-2.264395027,0.03728780789,-0.04196754621}, /*cmz*/
          {3.837055786,5.253504511,81.48231243,3.439121436} /*cfz*/
     },
     {
          2464261.5,
          {0.1441744026,0.0006434824474,126.7575136,6.513363127,-0.104829498,-0.1155770412}, /*cmx*/
          {10.46454997,8.717623781,9.552109508,3.664844217}, /*cfx*/
          {0.2517705969,-5.963846255e-05,133.4573397,-6.816035357,-0.1089735092,0.07934161147}, /*cmy*/
          {8.860887096,10.24832519,7.941794431,5.274665353}, /*cfy*/
          {0.07451687944,0.0001998852666,-44.39283258,-2.319224122,-0.03779959627,0.04123240682}, /*cmz*/
          {7.02982928,5.25160959,9.198022698,0.2942532107} /*cfz*/
     },
     {
          2464302.5,
          {0.130184283,0.0006286865851,127.5819666,6.597353669,-0.1068473792,0.1171614082}, /*cmx*/
          {10.52545662,8.781138524,9.614649156,0.5678343748}, /*cfx*/
          {0.2606468214,8.720503393e-05,133.3572409,-6.829932209,-0.1096528375,-0.07994421774}, /*cmy*/
          {8.920730854,10.30867971,8.002570563,2.243687654}, /*cfy*/
          {0.07162482037,0.0001436435301,-42.44770675,2.22968015,-0.03598085375,-0.03776810363}, /*cmz*/
          {7.049729369,2.090272319,-9.686374441,3.425625108} /*cfz*/
     },
     {
          2464343.5,
          {0.1116078234,0.001097671663,128.9626582,-6.737582686,0.1096771562,-0.1197805882}, /*cmx*/
          {73.41009951,5.686878789,6.514231112,3.723961068}, /*cfx*/
          {0.2632326306,0.0002186987836,-133.3364703,-6.896256845,0.1113940252,0.0815695275}, /*cmy*/
          {-6.733585007,-2.206674198,4.908663569,5.435459805}, /*cfy*/
          {0.06382335952,0.0002636719267,38.93914844,2.052036639,-0.03285002963,0.03377786378}, /*cmz*/
          {-14.95085858,-4.20224618,9.162089568,0.267553228} /*cfz*/
     },
     {
          2464384.5,
          {0.1025847426,0.0008408397495,129.9408398,-6.849379083,-0.1116717941,0.1214457887}, /*cmx*/
          {16.89811601,5.714421783,3.392563549,0.5928440928}, /*cfx*/
          {0.281914042,-0.0001275380944,133.3968378,6.978031742,-0.1132198462,-0.08279521775}, /*cmy*/
          {2.729149995,13.53483244,8.078557232,2.334904596}, /*cfy*/
          {0.05999985531,0.00018158883,-36.39102197,1.910858856,-0.03065535462,-0.03236212696}, /*cmz*/
          {7.028504494,8.400665462,9.230186831,3.44375368} /*cfz*/
     },
     {
          2464425.5,
          {0.09764925571,0.0009310352153,-130.0086261,-6.872803618,-0.111836784,-0.1216317683}, /*cmx*/
          {7.4954073,5.728783293,9.684911258,3.727831586}, /*cfx*/
          {0.2748505089,0.0004001308722,-133.4750646,7.026677091,-0.1140999461,0.08337082941}, /*cmy*/
          {5.8925129,7.270013286,8.093097631,5.46570058}, /*cfy*/
          {0.05566318013,0.0003474708524,-36.56247483,1.911303474,-0.0311264005,0.03437078677}, /*cmz*/
          {-24.36654503,8.485139076,9.347115564,0.350096386} /*cfz*/
     },
     {
          2464466.5,
          {0.08233781653,0.0010696127,129.0922096,-6.799609607,-0.1101500298,0.1194921098}, /*cmx*/
          {4.370136175,-0.5423788171,3.412168455,0.6001890035}, /*cfx*/
          {0.2842080145,0.000109371332,133.4954274,7.019809069,0.1137326224,-0.0839666804}, /*cmy*/
          {-9.801622513,7.283604182,11.24793861,2.352667544}, /*cfy*/
          {0.05239388073,0.0004382834715,39.54595112,2.067734439,-0.03416328538,-0.03890894572}, /*cmz*/
          {3.967209988,8.581675664,9.455609458,3.557940287} /*cfz*/
     },
     {
          2464507.5,
          {0.0812517817,0.0009238267223,-127.3759291,6.655554304,0.1072044033,-0.1159084461}, /*cmx*/
          {7.532072524,2.619194908,6.575840491,3.752682894}, /*cfx*/
          {0.2817656586,0.0003164316982,133.481813,-6.970606858,-0.1124398082,0.08360340843}, /*cmy*/
          {53.04722648,4.161146325,1.84468789,5.509744546}, /*cfy*/
          {0.05362910692,0.0004813973938,-44.30750067,-2.316740428,0.03841005909,0.04407838787}, /*cmz*/
          {7.187508641,5.519690736,6.387285205,0.4586406737} /*cfz*/
     },
     {
          2464548.5,
          {0.07130389224,0.000731730926,125.3126595,-6.487377146,0.1039849078,0.1118775541}, /*cmx*/
          {4.421891208,5.796446665,12.90024586,0.6546206108}, /*cfx*/
          {0.2851213533,0.0002122957699,-133.4280254,6.900809171,0.1108241743,-0.08462612233}, /*cmy*/
          {5.951738817,7.334860114,5.022551844,2.443300152}, /*cfy*/
          {0.05402997422,0.0003977168865,-49.32285654,2.57356004,0.04247911531,-0.04875975132}, /*cmz*/
          {0.9850589828,2.435140473,0.1448843583,3.647264864} /*cfz*/
     },
     {
          2464589.5,
          {0.06573552723,0.0006245043395,123.6357516,-6.355894372,0.1017200446,-0.1079456409}, /*cmx*/
          {48.44953502,5.85066347,6.679021297,3.842740453}, /*cfx*/
          {0.2768864406,0.000727163358,133.3430941,-6.836082723,0.1094736014,0.08491623487}, /*cmy*/
          {2.853096457,29.37274272,5.07358842,5.655567166}, /*cfy*/
          {0.05428801972,0.0004360725005,-53.03072152,2.76209196,0.04526850001,0.05113423534}, /*cmz*/
          {-11.5092708,2.469726288,6.44174328,0.5277522194} /*cfz*/
     },
     {
          2464630.5,
          {0.04532786226,0.0007148606778,123.1345711,-6.324548197,0.1015604353,0.1058242565}, /*cmx*/
          {10.80786251,5.917870779,6.752128787,0.7681913092}, /*cfx*/
          {0.2840216361,0.0004069991772,133.2178364,-6.801169136,0.1089662418,-0.08754587708}, /*cmy*/
          {9.191315543,10.58093276,5.134234819,2.617623608}, /*cfy*/
          {0.05005180945,0.0004455398635,-54.19616006,2.828361559,0.04600426321,-0.05089725588}, /*cmz*/
          {-17.73833897,8.764398158,6.432064717,3.683926565} /*cfz*/
     },
     {
          2464671.5,
          {0.04203079521,0.0003226936588,124.0767807,-6.41592211,0.1037210428,-0.1061382968}, /*cmx*/
          {4.586270808,5.983095246,6.816724805,3.946713062}, /*cfx*/
          {0.2847526054,0.0007091376054,133.1013564,-6.81732348,0.1096672502,0.08923767783}, /*cmy*/
          {9.251053297,10.64078516,5.19393272,5.826728976}, /*cfy*/
          {0.05310186183,0.0002647259097,52.49230579,2.754362252,-0.0444625428,0.04798374814}, /*cmz*/
          {4.280578361,8.760010767,3.273472136,0.5272137848} /*cfz*/
     },
     {
          2464712.5,
          {0.02207386178,0.0004952704255,-125.7427091,6.568463457,-0.1067261202,0.1079644246}, /*cmx*/
          {472.7370171,2.889190829,3.716301231,0.8360558446}, /*cfx*/
          {0.2857920946,0.0006835353531,-133.0274922,-6.880408111,-0.1113569751,-0.09296840683}, /*cmy*/
          {25.01240928,-1.874652208,2.099907348,2.745750121}, /*cfy*/
          {0.04813276346,0.0002657673431,49.20396353,-2.591205081,0.04159466575,-0.04436828199}, /*cmz*/
          {4.283564047,5.621127719,-43.84161291,3.675288339} /*cfz*/
     },
     {
          2464753.5,
          {0.01473215876,0.0004070139737,-126.9337875,6.684363628,-0.1087146882,-0.1089543716}, /*cmx*/
          {7.818622248,9.19930898,10.0182359,3.974394903}, /*cfx*/
          {0.2893651988,0.0008430410618,133.0444182,6.957292656,0.1130873304,0.09391067253}, /*cmy*/
          {3.059400172,13.86735499,11.55367616,-0.3798974604}, /*cfy*/
          {0.04575454263,0.0002205745592,-46.78851923,-2.459746657,0.03956485366,0.04216727654}, /*cmz*/
          {7.424508856,-19.4756102,6.483666361,0.556108092} /*cfz*/
     },
     {
          2464794.5,
          {-0.001350960306,0.0006616718965,126.9561655,6.699024446,-0.1086481279,0.1091126172}, /*cmx*/
          {4.700061893,9.213086639,10.02626441,0.8389356934}, /*cfx*/
          {0.294722153,0.0004979620131,-133.1039544,-7.002695599,0.1139145951,-0.0959604328}, /*cmy*/
          {6.22359052,10.74540938,5.286581183,2.771549998}, /*cfy*/
          {0.0389563209,0.0002415461546,47.02768258,-2.463848879,0.04003216111,-0.04337959025}, /*cmz*/
          {4.305392971,5.727493851,6.57863577,3.753210307} /*cfz*/
     },
     {
          2464835.5,
          {0.002158873617,0.0002067010663,-125.7177608,-6.606861967,0.1066217286,-0.1065615719}, /*cmx*/
          {1.576114245,6.083667755,6.894787434,3.981809195}, /*cfx*/
          {0.2999384435,0.0005602038054,133.1618333,6.997185912,-0.113552717,0.09534676212}, /*cmy*/
          {9.380583495,13.90219406,27.29257416,-0.363754861}, /*cfy*/
          {0.03882194449,5.125758339e-05,-50.03611712,-2.616271334,0.04291281331,0.04658902378}, /*cmz*/
          {7.499078908,5.809172997,6.67121217,0.6630093437} /*cfz*/
     },
     {
          2464876.5,
          {-0.009835097629,0.0004941371087,123.5012616,6.435557997,-0.1032357031,0.102608985}, /*cmx*/
          {4.739259953,2.962829149,3.776264111,0.8703507987}, /*cfx*/
          {0.2933504851,0.0006253564096,133.1893178,-6.949208039,0.112296809,-0.09653509234}, /*cmy*/
          {3.116280262,4.498675613,5.325189358,2.80539111}, /*cfy*/
          {0.02978481399,0.0002157652449,54.78159844,2.85660607,-0.04694959086,-0.05077037343}, /*cmz*/
          {4.427565205,2.740695667,3.600086585,3.862247248} /*cfz*/
     },
     {
          2464917.5,
          {-0.01469822324,0.0002909271324,-120.8965907,-6.241839096,-0.09963730253,-0.09718423675}, /*cmx*/
          {-168.0157602,6.14164409,10.10276725,4.054380805}, /*cfx*/
          {0.3011134678,0.0003863121842,-133.187848,-6.884117346,-0.1107685787,0.09682715584}, /*cmy*/
          {6.288412875,4.532780945,2.221587285,-0.2871458385}, /*cfy*/
          {0.02549784592,0.0001474301154,-59.77312262,-3.107190869,0.05089080882,0.05418205407}, /*cmz*/
          {-4.921547272,5.940914242,6.788561775,0.7636234953} /*cfz*/
     },
     {
          2464958.5,
          {-0.02404536184,0.0002762531964,118.7866712,-6.090949179,-0.09710718077,0.09293390529}, /*cmx*/
          {11.10139437,6.198277236,10.16841476,0.9843354939}, /*cfx*/
          {0.297302065,0.0003182580067,133.1448654,-6.82648118,-0.1095683104,-0.0992100427}, /*cmy*/
          {15.75803238,10.86426091,8.55692494,2.916656727}, /*cfy*/
          {0.01920465982,0.0002074447252,-63.51079531,3.296237605,0.0537000934,-0.05643622619}, /*cmz*/
          {13.99927697,9.12428781,25.66327976,3.940305813} /*cfz*/
     },
     {
          2464999.5,
          {-0.03132934554,-9.363703636e-05,118.0810817,-6.052959977,-0.09692989407,-0.08932229336}, /*cmx*/
          {4.876696578,6.26873577,10.24598015,4.200980545}, /*cfx*/
          {0.2986702663,0.0004042795457,133.0504294,-6.799664023,-0.1092182636,0.1007087535}, /*cmy*/
          {9.530959466,4.639332595,8.617365772,-0.1533087009}, /*cfy*/
          {0.0176259347,0.0001107259943,-64.80650939,3.371762207,0.05463408963,0.05593308686}, /*cmz*/
          {14.05659028,9.147028448,6.818850327,0.8089788309} /*cfz*/
     },
     {
          2465040.5,
          {-0.05272568263,0.0003119493749,119.1118723,-6.148591272,-0.09920336963,0.08924509868}, /*cmx*/
          {4.939145045,6.336422081,10.31377261,1.124811407}, /*cfx*/
          {0.2891525607,0.0005688319579,132.93026,-6.818876323,-0.109953074,-0.1041242138}, /*cmy*/
          {9.590599869,4.698666278,8.675970796,3.041824259}, /*cfy*/
          {0.01064883542,0.0003947993237,63.3313063,-3.312778084,0.05336551614,-0.05380009972}, /*cmz*/
          {4.666561942,-0.2697123771,6.81608829,3.949153204} /*cfz*/
     },
     {
          2465081.5,
          {-0.06950177643,0.0001875281118,-121.0576094,6.313834895,0.1024010947,-0.08984568422}, /*cmx*/
          {102.3829736,3.243299631,7.213517775,4.297626301}, /*cfx*/
          {0.3009018962,0.0001226164329,132.8303431,6.880503475,0.1115836119,0.1070110017}, /*cmy*/
          {15.92681824,-4.675676658,5.58121171,-0.05543433253}, /*cfy*/
          {0.01049390933,0.0002201200562,60.26655958,3.165925653,0.05079839566,0.05034358939}, /*cmz*/
          {-14.16979482,2.884038279,6.832370185,0.8157199447} /*cfz*/
     },
     {
          2465122.5,
          {-0.07828083,0.0002540779766,-122.4661895,6.43379826,0.1043841125,0.09145697062}, /*cmx*/
          {1.890190968,9.552790375,7.230933264,1.156275012}, /*cfx*/
          {0.2897709655,0.0005620235083,-132.8194739,-6.951939773,0.1131923086,-0.1094029434}, /*cmy*/
          {6.54030755,11.06674484,11.89411547,3.094584921}, /*cfy*/
          {0.008962077497,0.0001716718173,-57.97916383,-3.044279177,0.04893927407,-0.04834814246}, /*cmz*/
          {1.546261659,-0.2211677579,6.887200769,3.990671874} /*cfz*/
     },
     {
          2465163.5,
          {-0.09517782949,0.0005155435753,122.4302625,6.440484722,0.1041264535,-0.09038960776}, /*cmx*/
          {5.055886094,9.565839202,7.237321736,4.299464481}, /*cfx*/
          {0.2921100289,0.0004610528833,132.8713597,6.993872817,0.1139541281,0.1103671993}, /*cmy*/
          {3.422422168,26.79593156,5.628850191,-0.0337685644}, /*cfy*/
          {-0.0001594193198,0.0001764738084,58.24684446,-3.04972914,0.04938614899,0.04818072182}, /*cmz*/
          {4.712303618,6.123876041,6.968523534,0.9117721755} /*cfz*/
     },
     {
          2465204.5,
          {-0.1013795529,0.0007143388582,-120.840093,-6.327101085,-0.1017100834,0.08858729141}, /*cmx*/
          {1.932984261,6.435975929,4.104974803,1.163105141}, /*cfx*/
          {0.2894645304,0.0004754445023,-132.9626944,6.987603029,0.1135537453,-0.1108860263}, /*cmy*/
          {31.7141259,-4.602663738,-0.6372165573,3.110564028}, /*cfy*/
          {-0.01047692601,0.0002544201086,-61.21336811,-3.194161129,0.05204756059,-0.05043180953}, /*cmz*/
          {1.618393483,6.195704487,7.050362863,4.117356695} /*cfz*/
     },
     {
          2465245.5,
          {-0.1050202255,0.0005118527202,118.0771898,6.129903375,0.09793053564,-0.0839696077}, /*cmx*/
          {5.097202769,3.315567544,7.269925635,4.343116351}, /*cfx*/
          {0.2945914845,0.000195841849,133.0387937,-6.941886002,-0.1123500335,0.1113589975}, /*cmy*/
          {3.461348235,4.846154137,2.530939319,0.001041016029}, /*cfy*/
          {-0.02061349068,9.230805965e-05,65.85555504,-3.421741423,0.05581994402,0.05290720797}, /*cmz*/
          {4.824384439,-0.01886552243,0.8353727989,1.047027376} /*cfz*/
     },
     {
          2465286.5,
          {-0.1027304034,0.000438911585,-114.8826799,5.90832945,0.09393741356,0.07949215934}, /*cmx*/
          {1.988815692,22.2035849,7.31528327,1.254896016}, /*cfx*/
          {0.2781955697,0.000815072096,-133.0949565,6.880827298,0.1108873415,-0.1115464072}, /*cmy*/
          {6.636224365,1.741148931,5.712858997,3.172595828}, /*cfy*/
          {-0.03107467402,0.0002174845998,-70.73399312,3.659518856,-0.05952435397,-0.05543574891}, /*cmz*/
          {-17.09492746,3.182379992,4.028506881,4.240492131} /*cfz*/
     },
     {
          2465327.5,
          {-0.1182963905,0.0006158073723,-112.293045,5.737864565,0.09117101564,-0.07450598051}, /*cmx*/
          {8.31903731,9.696355721,7.384735462,4.504131242}, /*cfx*/
          {0.2789779785,0.0004231803115,-133.0903964,-6.8319735,0.1098755508,0.1130940521}, /*cmy*/
          {0.4002947212,11.21626707,5.766448353,0.09294317514}, /*cfy*/
          {-0.04851748499,0.0004600012033,74.41832964,-3.843757441,0.06226792812,0.05615870342}, /*cmz*/
          {11.2501688,6.371441771,333.9300431,1.154257848} /*cfz*/
     },
     {
          2465368.5,
          {-0.1175600671,0.0001483965581,-111.3481595,5.690980828,0.09093942973,0.07227279215}, /*cmx*/
          {8.378252274,9.770305846,7.467379537,1.464270954}, /*cfx*/
          {0.2723851755,0.000615046939,-133.045729,-6.814673991,0.1096899605,-0.1144151399}, /*cmy*/
          {6.740792819,4.991760405,5.826632721,3.280652181}, /*cfy*/
          {-0.04983865183,0.0003546239428,75.7883033,-3.924428107,0.063324569,-0.05576397604}, /*cmz*/
          {-1.256167454,6.403158901,7.221537584,4.309450132} /*cfz*/
     },
     {
          2465409.5,
          {-0.134818335,0.000150750635,-112.4348887,5.79083468,0.09336618811,-0.07199145359}, /*cmx*/
          {8.441624732,9.84112328,7.538908619,4.714524107}, /*cfx*/
          {0.2612865246,0.000719364125,-132.9522719,-6.83952063,0.1105091145,0.1171081311}, /*cmy*/
          {6.800188992,5.050319486,5.883909581,0.1912425752}, /*cfy*/
          {-0.05534484324,0.0004504911098,-74.51199964,3.87935991,-0.06233338921,0.05341786896}, /*cmz*/
          {1.926063572,3.279805568,-2.194386551,1.184622463} /*cfz*/
     },
     {
          2465450.5,
          {-0.1472626968,0.0001473874652,114.6451979,-5.9667254,-0.09673568697,0.07316388965}, /*cmx*/
          {-604.1135925,6.748836949,4.43886412,1.603188656}, /*cfx*/
          {0.250574443,0.001062418475,132.8682259,-6.899948775,-0.1120335245,-0.1189513744}, /*cmy*/
          {9.993878252,-1.183798301,2.787630569,3.353322095}, /*cfy*/
          {-0.05359677939,0.0004151062357,71.66970699,-3.748869151,0.06006904017,-0.05074228211}, /*cmz*/
          {5.088856461,6.440810063,7.252440581,4.33133949} /*cfz*/
     },
     {
          2465491.5,
          {-0.1669396523,0.0004201804929,-116.2722961,-6.092714282,-0.09876061792,-0.07374324302}, /*cmx*/
          {-4.03036029,6.774149184,10.73737817,4.7653486}, /*cfx*/
          {0.2479431709,0.0007663776018,-132.8410869,6.966870858,0.1135395941,0.121732309}, /*cmy*/
          {6.890344181,-10.57398222,37.37521853,0.2316737503}, /*cfy*/
          {-0.05857212032,0.000346051669,-69.49889215,3.637897931,0.05840901197,0.04860195209}, /*cmz*/
          {1.962216815,3.336342476,7.303985155,1.254097688} /*cfz*/
     },
     {
          2465532.5,
          {-0.1636607415,6.585964091e-05,116.1864085,-6.092132386,-0.09831966276,0.07307110296}, /*cmx*/
          {5.41911311,6.785502564,10.74100364,1.60128295}, /*cfx*/
          {0.2428546837,0.001054615493,132.9081735,-7.003209214,-0.1141633806,-0.1222596645}, /*cmy*/
          {3.773346421,-1.12678906,9.120489004,3.373015565}, /*cfy*/
          {-0.05771921322,-5.289817329e-05,69.75064793,3.642818365,0.05882308707,-0.04856307173}, /*cmz*/
          {5.129945124,9.675693973,7.375906873,4.461773572} /*cfz*/
     },
     {
          2465573.5,
          {-0.1735346773,0.0004648800161,-114.2404598,5.959240054,0.09556227157,-0.07096201492}, /*cmx*/
          {2.29646749,3.654132147,7.606470258,4.768157476}, /*cfx*/
          {0.2314906286,0.001136040598,133.0217937,-6.99443296,0.1137013225,0.122872859}, /*cmy*/
          {28.92555114,5.176094724,5.998596101,0.2487785514}, /*cfy*/
          {-0.07410881798,6.422181049e-05,-72.59201306,-3.77572131,0.06123891885,0.04999877964}, /*cmz*/
          {2.0329267,12.88219106,7.449908896,1.425048944} /*cfz*/
     },
     {
          2465614.5,
          {-0.1680930647,0.0002232521668,110.9340036,-5.737818953,-0.09141013268,0.06723304243}, /*cmx*/
          {5.460672857,6.815938135,4.486940178,1.649513257}, /*cfx*/
          {0.2345864348,0.0009642866595,-133.1395239,6.949542932,-0.1124880098,-0.1218071387}, /*cmy*/
          {6.958882174,2.061308781,2.886353628,3.406965885}, /*cfy*/
          {-0.08466185344,-0.0001476575785,77.03204464,3.986212044,0.06468723937,-0.05184053567}, /*cmz*/
          {5.234554713,-2.76092924,-5.050742114,4.642015407} /*cfz*/
     },
     {
          2465655.5,
          {-0.1658301357,0.0001908589314,-107.1518536,5.490956697,-0.08707721799,-0.06388029313}, /*cmx*/
          {2.351836588,16.27936391,10.81641441,4.888398571}, /*cfx*/
          {0.2252758025,0.0008886196446,-133.2216063,-6.892064093,-0.1111195329,0.122147873}, /*cmy*/
          {-5.571127099,5.242468904,2.929545971,0.3071107621}, /*cfy*/
          {-0.1003969698,-8.223703912e-05,-81.68624807,-4.205827074,-0.0680913094,0.05368354519}, /*cmz*/
          {46.1438927,6.724031132,4.428890213,1.599877269} /*cfz*/
     },
     {
          2465696.5,
          {-0.159805375,-0.0002382528642,-104.0844802,5.301408171,-0.08407742523,0.06082314691}, /*cmx*/
          {8.681527798,10.05699436,4.605722984,1.862650778}, /*cfx*/
          {0.2205807956,0.0009172060122,133.2606267,-6.850385012,-0.1102393811,-0.121350357}, /*cmy*/
          {41.60238244,5.294586605,9.267755022,3.492789086}, /*cfy*/
          {-0.108515282,-0.0002401711137,-85.22069507,4.379588174,0.07068359764,-0.05390530562}, /*cmz*/
          {8.514681206,3.633972719,1.328456791,4.802386904} /*cfz*/
     },
     {
          2465737.5,
          {-0.1678115046,-0.0001373370651,-102.8876304,5.245021539,-0.08378296108,-0.06130144182}, /*cmx*/
          {8.740624406,10.13430024,4.693493375,5.162806907}, /*cfx*/
          {0.2050295943,0.0009656049888,133.2596764,-6.843428056,-0.1102410882,0.122138555}, /*cmy*/
          {10.24478372,5.353575496,9.327626877,0.4021582817}, /*cfy*/
          {-0.1213958071,0.0001248532247,-86.59223164,4.460913736,0.07180322167,0.05339895503}, /*cmz*/
          {8.576524705,3.672683687,32.77115767,1.718353964} /*cfz*/
     },
     {
          2465778.5,
          {-0.1752747862,-0.0005175036354,-104.0150466,5.349220965,-0.08636119687,0.06284328598}, /*cmx*/
          {8.804684744,10.2083636,4.768670063,2.128398841}, /*cfx*/
          {0.2069962065,0.0005842596749,133.2219881,-6.875847986,0.1111669145,-0.1225128478}, /*cmy*/
          {10.30347703,5.410771558,18.80783799,3.578292836}, /*cfy*/
          {-0.1216993644,-1.342116573e-05,-85.48446763,-4.429091962,-0.07109029104,-0.05100371738}, /*cmz*/
          {4576.497477,6.840496508,4.514667069,4.871274606} /*cfz*/
     },
     {
          2465819.5,
          {-0.1866131081,-0.0004644859,-106.469257,-5.534913948,0.08991440511,-0.065770681}, /*cmx*/
          {-16.27198736,7.116886341,7.951886999,5.331525032}, /*cfx*/
          {0.1895489065,0.0008226818911,133.1799161,6.935572575,-0.1126083914,0.1242245976}, /*cmy*/
          {85.75210056,2.316274589,3.14322299,0.4629136445}, /*cfy*/
          {-0.1193241537,-1.072630534e-05,82.85865606,4.31481958,0.0691410678,0.04932474879}, /*cmz*/
          {5.507357811,3.723843351,1.399573719,1.769374574} /*cfz*/
     },
     {
          2465860.5,
          {-0.2004179473,-0.0003786387764,108.3209516,-5.668668721,0.09200850188,0.06565472359}, /*cmx*/
          {5.758652835,7.140259827,7.963690405,2.192343551}, /*cfx*/
          {0.1858112965,0.0007025364343,-133.1765737,-6.997109498,0.1139398332,-0.1250083484}, /*cmy*/
          {7.249330787,-32.20762641,0.03103531736,3.61350984}, /*cfy*/
          {-0.1199190097,-0.0002060534426,-80.80181959,-4.215875143,0.06770142413,-0.04799740638}, /*cmz*/
          {2.38571594,6.902760005,7.73101753,4.97133093} /*cfz*/
     },
     {
          2465901.5,
          {-0.2068433129,-4.462143317e-05,-108.2072441,-5.66308825,-0.09143856625,-0.06525894935}, /*cmx*/
          {2.641465886,7.14859623,4.821529292,5.322336404}, /*cfx*/
          {0.173940446,0.0008187394602,133.2489342,-7.026244089,0.1143910249,0.1263057209}, /*cmy*/
          {4.132788405,-0.7684835567,-6.231216565,0.4785471022}, /*cfy*/
          {-0.1266787,-0.0001875817528,80.99461419,-4.21903964,0.06808198557,0.04965619157}, /*cmz*/
          {5.554456661,6.954510544,7.795655434,1.924238965} /*cfz*/
     },
     {
          2465942.5,
          {-0.208164182,-4.138104234e-05,105.9552883,5.516098393,0.08843133593,0.06208494847}, /*cmx*/
          {5.801032408,4.013869659,1.682487475,2.181838837}, /*cfx*/
          {0.1782140987,0.0003690374533,-133.3644578,7.012678614,-0.113831267,-0.1253972302}, /*cmy*/
          {7.295739887,2.394972238,3.21571598,3.633661642}, /*cfy*/
          {-0.1379354021,-0.0004444072429,-83.63437663,-4.339389099,0.07025620439,-0.05164303864}, /*cmz*/
          {2.454898546,19.58014048,7.86263156,5.163847353} /*cfz*/
     },
     {
          2465983.5,
          {-0.198144116,-3.4317262e-05,-102.1602493,-5.273700437,0.08395560672,-0.05963386278}, /*cmx*/
          {2.680131606,7.172544066,14.26736886,5.35394903}, /*cfx*/
          {0.1627808492,0.0007522571719,133.4844996,-6.964976292,0.1125420358,0.1242635279}, /*cmy*/
          {4.181347914,5.565969015,6.389448927,0.5168222255}, /*cfy*/
          {-0.1494853194,-0.0004665141283,87.77174289,4.528737671,-0.07333059251,0.05510692409}, /*cmz*/
          {5.652528297,-2.349867415,-51.76488923,2.119684459} /*cfz*/
     },
     {
          2466024.5,
          {-0.1989209087,0.0001482509306,97.85923098,-5.006642155,0.07934080877,0.05690141212}, /*cmx*/
          {5.85209904,7.209187099,8.028864564,2.299464123}, /*cfx*/
          {0.1590545922,0.000415398888,-133.5540882,6.909204327,-0.1112268249,-0.1222960962}, /*cmy*/
          {7.362290308,2.466746347,34.70973196,3.700192745}, /*cfy*/
          {-0.1716185747,-0.0002409891313,92.09892216,4.727139515,0.07639650197,-0.05743908692}, /*cmz*/
          {24.56760171,3.993041224,1.698306015,5.365596614} /*cfz*/
     },
     {
          2466065.5,
          {-0.1886892039,-8.056110493e-05,94.36812582,-4.799603038,0.07611089328,-0.05688690105}, /*cmx*/
          {5.896159832,7.270150047,8.103162268,5.553878844}, /*cfx*/
          {0.1495634432,0.000423474219,133.5926609,6.871947666,-0.110456415,0.1209931416}, /*cmy*/
          {10.55558531,8.803833581,9.633775352,0.6043430189}, /*cfy*/
          {-0.1809684768,-0.0001900513626,95.38577756,-4.885151652,-0.07877171303,0.05948052255}, /*cmz*/
          {5.786467753,7.188793443,4.886135056,2.301518424} /*cfz*/
     },
     {
          2466106.5,
          {-0.1903125755,-0.0002850848889,92.95238108,-4.735170842,0.07573765676,0.05904927273}, /*cmx*/
          {5.953950158,7.350081647,8.195207793,2.555666866}, /*cfx*/
          {0.139771781,0.0002615675885,133.6208455,6.87548096,-0.1106772852,-0.1193083608}, /*cmy*/
          {10.61454992,8.862965418,9.693266008,3.796281408}, /*cfy*/
          {-0.1912232747,-0.0001032284496,96.69583626,4.965451501,-0.07993739765,-0.05909068406}, /*cmz*/
          {5.849229224,4.090960702,4.919764651,5.513596504} /*cfz*/
     },
     {
          2466147.5,
          {-0.1939747169,-0.0004136876354,94.1126425,-4.841300784,0.07840259913,-0.06377045755}, /*cmx*/
          {6.01810288,7.42733271,8.27412144,5.789546654}, /*cfx*/
          {0.1200999849,0.0007140157774,133.6509256,-6.915342508,0.1117020751,0.1190498357}, /*cmy*/
          {10.67188666,18.34299743,19.17129944,0.6878476898}, /*cfy*/
          {-0.1905001159,3.337759806e-06,-95.72531342,-4.944537397,0.07947721899,0.05803279738}, /*cmz*/
          {9.039064136,7.264678324,1.802884718,2.400110325} /*cfz*/
     }

};

static unsigned idn_list[] = {2,31,62,95,131};
static double freq_list[] = {2.493,1.5162,0.7217,0.4667,4.488};
static double delt_list[] = {258.0,242.0,223.0,206.0,41.0};

BDL_Dataset uranus_2040 = {
     5, /*nsat*/
     2458849.5, /*djj*/
     idn_list,
     freq_list,
     delt_list,
     moonrecords
};
