
import pkg_resources

from pathspider.cmd.measure import job_feeder_csv as job_feeder

class FakeSpider:
    def __init__(self):
        self.was_shutdown = False
        self.jobs = []

    def add_job(self, row):
        self.jobs.append(row)

    def shutdown(self):
        self.was_shutdown = True

def test_job_feeder_csv_webtest():
    spider = FakeSpider()

    expected_jobs = [{'dip': '160.85.31.173', 'dp': '80', 'domain': 'mami-project.eu', 'rank': '1'},
                     {'dip': '139.133.210.32', 'dp': '80', 'domain': 'erg.abdn.ac.uk', 'rank': '2'},
                     {'dip': '2001:630:241:210:569f:35ff:fe0a:116a', 'dp': '80', 'domain': 'erg.abdn.ac.uk',  'rank': '3'},
                     {'dip': '129.132.52.158', 'dp': '80', 'domain': 'ecn.ethz.ch', 'rank': '4'},
                     {'dip': '2001:67c:10ec:36c2::61', 'dp': '80', 'domain': 'ecn.ethz.ch', 'rank': '5'},
                     {'dip': '139.133.1.4', 'dp': '80', 'domain': 'abdn.ac.uk', 'rank': '6'}]

    job_feeder(pkg_resources.resource_filename("pathspider", "tests/data/webtest.csv"), spider)
    assert spider.was_shutdown
    print (spider.jobs)
    print (expected_jobs)
    assert spider.jobs == expected_jobs

def test_job_feeder_csv_webtest_newline():
    spider = FakeSpider()

    expected_jobs = [{'dip': '160.85.31.173', 'dp': '80', 'domain': 'mami-project.eu', 'rank': '1'},
                     {'dip': '139.133.210.32', 'dp': '80', 'domain': 'erg.abdn.ac.uk', 'rank': '2'},
                     {'dip': '2001:630:241:210:569f:35ff:fe0a:116a', 'dp': '80', 'domain': 'erg.abdn.ac.uk',  'rank': '3'},
                     {'dip': '129.132.52.158', 'dp': '80', 'domain': 'ecn.ethz.ch', 'rank': '4'},
                     {'dip': '2001:67c:10ec:36c2::61', 'dp': '80', 'domain': 'ecn.ethz.ch', 'rank': '5'},
                     {'dip': '139.133.1.4', 'dp': '80', 'domain': 'abdn.ac.uk', 'rank': '6'}]

    job_feeder(pkg_resources.resource_filename("pathspider", "tests/data/webtest_newline.csv"), spider)
    assert spider.was_shutdown
    assert spider.jobs == expected_jobs

def test_job_feeder_csv_webtest_duplicates():
    spider = FakeSpider()

    expected_jobs = [{'dip': '160.85.31.173', 'dp': '80', 'domain': 'mami-project.eu', 'rank': '1'},
                     {'dip': '139.133.210.32', 'dp': '80', 'domain': 'erg.abdn.ac.uk', 'rank': '2'},
                     {'dip': '2001:630:241:210:569f:35ff:fe0a:116a', 'dp': '80', 'domain': 'erg.abdn.ac.uk',  'rank': '3'},
                     {'dip': '129.132.52.158', 'dp': '80', 'domain': 'ecn.ethz.ch', 'rank': '4'},
                     {'dip': '2001:67c:10ec:36c2::61', 'dp': '80', 'domain': 'ecn.ethz.ch', 'rank': '5'},
                     {'dip': '139.133.1.4', 'dp': '80', 'domain': 'abdn.ac.uk', 'rank': '6'}]

    job_feeder(pkg_resources.resource_filename("pathspider", "tests/data/webtest_duplicates.csv"), spider)
    assert spider.was_shutdown
    print (spider.jobs)
    print (expected_jobs)
    assert spider.jobs == expected_jobs

def test_job_feeder_csv_webtest_09x():
    spider = FakeSpider()

    expected_jobs = [{'dip': '160.85.31.173', 'dp': '80', 'domain': 'mami-project.eu'},
                     {'dip': '139.133.210.32', 'dp': '80', 'domain': 'erg.abdn.ac.uk'},
                     {'dip': '2001:630:241:210:569f:35ff:fe0a:116a', 'dp': '80', 'domain': 'erg.abdn.ac.uk'},
                     {'dip': '129.132.52.158', 'dp': '80', 'domain': 'ecn.ethz.ch'},
                     {'dip': '2001:67c:10ec:36c2::61', 'dp': '80', 'domain': 'ecn.ethz.ch'},
                     {'dip': '139.133.1.4', 'dp': '80', 'domain': 'abdn.ac.uk'}]

    job_feeder(pkg_resources.resource_filename("pathspider", "tests/data/webtest_0.9.x.csv"), spider)
    assert spider.was_shutdown
    print (spider.jobs)
    print (expected_jobs)
    assert spider.jobs == expected_jobs

def test_job_feeder_csv_dnsresolvtest():
    spider = FakeSpider()

    expected_jobs = [{'rank': '1', 'domain': 'google.com'},
                     {'rank': '2', 'domain': 'youtube.com'},
                     {'rank': '3', 'domain': 'facebook.com'},
                     {'rank': '4', 'domain': 'baidu.com'},
                     {'rank': '5', 'domain': 'wikipedia.org'},
                     {'rank': '6', 'domain': 'yahoo.com'},
                     {'rank': '7', 'domain': 'google.co.in'},
                     {'rank': '8', 'domain': 'twitter.com'},
                     {'rank': '9', 'domain': 'amazon.com'},
                     {'rank': '10', 'domain': 'qq.com'},
                     {'rank': '11', 'domain': 'google.co.jp'},
                     {'rank': '12', 'domain': 'live.com'},
                     {'rank': '13', 'domain': 'linkedin.com'},
                     {'rank': '14', 'domain': 'taobao.com'},
                     {'rank': '15', 'domain': 'instagram.com'},
                     {'rank': '16', 'domain': 'vk.com'},
                     {'rank': '17', 'domain': 'hao123.com'},
                     {'rank': '18', 'domain': 'sohu.com'},
                     {'rank': '19', 'domain': 'sina.com.cn'},
                     {'rank': '20', 'domain': 'weibo.com'},
                     {'rank': '21', 'domain': '360.cn'},
                     {'rank': '22', 'domain': 'google.de'},
                     {'rank': '23', 'domain': 'reddit.com'},
                     {'rank': '24', 'domain': 'yahoo.co.jp'},
                     {'rank': '25', 'domain': 'google.com.br'},
                     {'rank': '26', 'domain': 'tmall.com'},
                     {'rank': '27', 'domain': 'google.co.uk'},
                     {'rank': '28', 'domain': 'yandex.ru'},
                     {'rank': '29', 'domain': 'google.fr'},
                     {'rank': '30', 'domain': 't.co'},
                     {'rank': '31', 'domain': 'onclickads.net'},
                     {'rank': '32', 'domain': 'google.ru'},
                     {'rank': '33', 'domain': 'ebay.com'},
                     {'rank': '34', 'domain': 'wordpress.com'},
                     {'rank': '35', 'domain': 'soso.com'},
                     {'rank': '36', 'domain': 'stackoverflow.com'},
                     {'rank': '37', 'domain': 'bing.com'},
                     {'rank': '38', 'domain': 'tumblr.com'},
                     {'rank': '39', 'domain': 'blogspot.com'},
                     {'rank': '40', 'domain': 'google.it'},
                     {'rank': '41', 'domain': 'google.es'},
                     {'rank': '42', 'domain': 'msn.com'},
                     {'rank': '43', 'domain': 'microsoft.com'},
                     {'rank': '44', 'domain': 'apple.com'},
                     {'rank': '45', 'domain': 'pinterest.com'},
                     {'rank': '46', 'domain': 'aliexpress.com'},
                     {'rank': '47', 'domain': 'paypal.com'},
                     {'rank': '48', 'domain': 'netflix.com'},
                     {'rank': '49', 'domain': 'google.com.mx'},
                     {'rank': '50', 'domain': 'blogger.com'},
                     {'rank': '51', 'domain': 'gmw.cn'},
                     {'rank': '52', 'domain': 'github.com'},
                     {'rank': '53', 'domain': 'imgur.com'},
                     {'rank': '54', 'domain': 'imdb.com'},
                     {'rank': '55', 'domain': 'mail.ru'},
                     {'rank': '56', 'domain': 'amazon.co.jp'},
                     {'rank': '57', 'domain': 'google.ca'},
                     {'rank': '58', 'domain': 'whatsapp.com'},
                     {'rank': '59', 'domain': 'naver.com'},
                     {'rank': '60', 'domain': 'google.com.hk'},
                     {'rank': '61', 'domain': 'amazon.in'},
                     {'rank': '62', 'domain': 'popads.net'},
                     {'rank': '63', 'domain': 'google.co.kr'},
                     {'rank': '64', 'domain': 'pornhub.com'},
                     {'rank': '65', 'domain': 'ok.ru'},
                     {'rank': '66', 'domain': 'office.com'},
                     {'rank': '67', 'domain': 'cnzz.com'},
                     {'rank': '68', 'domain': 'google.co.id'},
                     {'rank': '69', 'domain': 'fc2.com'},
                     {'rank': '70', 'domain': 'dropbox.com'},
                     {'rank': '71', 'domain': 'youku.com'},
                     {'rank': '72', 'domain': 'xvideos.com'},
                     {'rank': '73', 'domain': 'google.com.tr'},
                     {'rank': '74', 'domain': 'googleusercontent.com'},
                     {'rank': '75', 'domain': 'microsoftonline.com'},
                     {'rank': '76', 'domain': 'google.com.au'},
                     {'rank': '77', 'domain': 'google.pl'},
                     {'rank': '78', 'domain': 'google.com.tw'},
                     {'rank': '79', 'domain': 'xhamster.com'},
                     {'rank': '80', 'domain': 'quora.com'},
                     {'rank': '81', 'domain': 'cnn.com'},
                     {'rank': '82', 'domain': 'adobe.com'},
                     {'rank': '83', 'domain': 'xinhuanet.com'},
                     {'rank': '84', 'domain': 'flipkart.com'},
                     {'rank': '85', 'domain': 'tianya.cn'},
                     {'rank': '86', 'domain': 'amazon.de'},
                     {'rank': '87', 'domain': 'bongacams.com'},
                     {'rank': '88', 'domain': 'twitch.tv'},
                     {'rank': '89', 'domain': 'youth.cn'},
                     {'rank': '90', 'domain': 'craigslist.org'},
                     {'rank': '91', 'domain': 'pixnet.net'},
                     {'rank': '92', 'domain': 'wikia.com'},
                     {'rank': '93', 'domain': 'alibaba.com'},
                     {'rank': '94', 'domain': 'godaddy.com'},
                     {'rank': '95', 'domain': '360.com'},
                     {'rank': '96', 'domain': 'isanalyze.com'},
                     {'rank': '97', 'domain': 'google.com.eg'},
                     {'rank': '98', 'domain': 'coccoc.com'},
                     {'rank': '99', 'domain': 'google.com.ar'},
                     {'rank': '100', 'domain': 'haosou.com'},
                     {'rank': '101', 'domain': 'adf.ly'},
                     {'rank': '102', 'domain': 'bbc.com'},
                     {'rank': '103', 'domain': 'so.com'},
                     {'rank': '104', 'domain': 'amazon.co.uk'},
                     {'rank': '105', 'domain': 'rakuten.co.jp'},
                     {'rank': '106', 'domain': 'google.com.sa'},
                     {'rank': '107', 'domain': 'salesforce.com'},
                     {'rank': '108', 'domain': 'amazonaws.com'},
                     {'rank': '109', 'domain': 'google.com.pk'},
                     {'rank': '110', 'domain': 'google.co.th'},
                     {'rank': '111', 'domain': 'terraclicks.com'},
                     {'rank': '112', 'domain': 'vimeo.com'},
                     {'rank': '113', 'domain': 'espn.com'},
                     {'rank': '114', 'domain': 'nytimes.com'},
                     {'rank': '115', 'domain': 'bbc.co.uk'},
                     {'rank': '116', 'domain': 'booking.com'},
                     {'rank': '117', 'domain': 'soundcloud.com'},
                     {'rank': '118', 'domain': 'indiatimes.com'},
                     {'rank': '119', 'domain': 'ask.com'},
                     {'rank': '120', 'domain': 'ebay.de'},
                     {'rank': '121', 'domain': 'txxx.com'},
                     {'rank': '122', 'domain': 'google.nl'},
                     {'rank': '123', 'domain': 'people.com.cn'},
                     {'rank': '124', 'domain': 'dailymotion.com'},
                     {'rank': '125', 'domain': 'globo.com'},
                     {'rank': '126', 'domain': 'uol.com.br'},
                     {'rank': '127', 'domain': 'w3schools.com'},
                     {'rank': '128', 'domain': 'china.com.cn'},
                     {'rank': '129', 'domain': 'ebay.co.uk'},
                     {'rank': '130', 'domain': 'stackexchange.com'},
                     {'rank': '131', 'domain': 'alipay.com'},
                     {'rank': '132', 'domain': 'diply.com'},
                     {'rank': '133', 'domain': 'zhihu.com'},
                     {'rank': '134', 'domain': 'dailymail.co.uk'},
                     {'rank': '135', 'domain': 'daum.net'},
                     {'rank': '136', 'domain': 'tudou.com'},
                     {'rank': '137', 'domain': 'thepiratebay.org'},
                     {'rank': '138', 'domain': 'bet365.com'},
                     {'rank': '139', 'domain': 'wordpress.org'},
                     {'rank': '140', 'domain': 'outbrain.com'},
                     {'rank': '141', 'domain': 'ettoday.net'},
                     {'rank': '142', 'domain': 'google.co.ve'},
                     {'rank': '143', 'domain': 'savefrom.net'},
                     {'rank': '144', 'domain': 'indeed.com'},
                     {'rank': '145', 'domain': 'nicovideo.jp'},
                     {'rank': '146', 'domain': 'force.com'},
                     {'rank': '147', 'domain': 'google.co.za'},
                     {'rank': '148', 'domain': 'trello.com'},
                     {'rank': '149', 'domain': 'deviantart.com'},
                     {'rank': '150', 'domain': 'theguardian.com'},
                     {'rank': '151', 'domain': '9gag.com'},
                     {'rank': '152', 'domain': 'slideshare.net'},
                     {'rank': '153', 'domain': 'chase.com'},
                     {'rank': '154', 'domain': 'huffingtonpost.com'},
                     {'rank': '155', 'domain': 'blastingnews.com'},
                     {'rank': '156', 'domain': 'buzzfeed.com'},
                     {'rank': '157', 'domain': 'uptodown.com'},
                     {'rank': '158', 'domain': 'vice.com'},
                     {'rank': '159', 'domain': 'doubleclick.net'},
                     {'rank': '160', 'domain': 'slack.com'},
                     {'rank': '161', 'domain': 'bp.blogspot.com'},
                     {'rank': '162', 'domain': 'github.io'},
                     {'rank': '163', 'domain': 'avito.ru'},
                     {'rank': '164', 'domain': 'google.com.ph'},
                     {'rank': '165', 'domain': 'livejasmin.com'},
                     {'rank': '166', 'domain': 'cnet.com'},
                     {'rank': '167', 'domain': 'thewhizmarketing.com'},
                     {'rank': '168', 'domain': 'bilibili.com'},
                     {'rank': '169', 'domain': 'tribunnews.com'},
                     {'rank': '170', 'domain': 'google.com.co'},
                     {'rank': '171', 'domain': 'steampowered.com'},
                     {'rank': '172', 'domain': 'snapdeal.com'},
                     {'rank': '173', 'domain': 'livedoor.jp'},
                     {'rank': '174', 'domain': 'mediafire.com'},
                     {'rank': '175', 'domain': 'google.com.vn'},
                     {'rank': '176', 'domain': 'etsy.com'},
                     {'rank': '177', 'domain': 'china.com'},
                     {'rank': '178', 'domain': 'blogspot.in'},
                     {'rank': '179', 'domain': 'popcash.net'},
                     {'rank': '180', 'domain': 'google.gr'},
                     {'rank': '181', 'domain': 'ameblo.jp'},
                     {'rank': '182', 'domain': 'sogou.com'},
                     {'rank': '183', 'domain': 'washingtonpost.com'},
                     {'rank': '184', 'domain': 'huanqiu.com'},
                     {'rank': '185', 'domain': 'shutterstock.com'},
                     {'rank': '186', 'domain': 'addthis.com'},
                     {'rank': '187', 'domain': 'chaturbate.com'},
                     {'rank': '188', 'domain': 'google.com.ng'},
                     {'rank': '189', 'domain': 'fbcdn.net'},
                     {'rank': '190', 'domain': 'onlinesbi.com'},
                     {'rank': '191', 'domain': 'spotify.com'},
                     {'rank': '192', 'domain': 'extratorrent.cc'},
                     {'rank': '193', 'domain': 'mozilla.org'},
                     {'rank': '194', 'domain': 'skype.com'},
                     {'rank': '195', 'domain': 'weather.com'},
                     {'rank': '196', 'domain': 'bankofamerica.com'},
                     {'rank': '197', 'domain': 'hclips.com'},
                     {'rank': '198', 'domain': 'naver.jp'},
                     {'rank': '199', 'domain': 'google.com.sg'},
                     {'rank': '200', 'domain': 'google.be'},
                     {'rank': '201', 'domain': 'twimg.com'},
                     {'rank': '202', 'domain': 'google.ro'},
                     {'rank': '203', 'domain': 'wikihow.com'},
                     {'rank': '204', 'domain': 'cloudfront.net'},
                     {'rank': '205', 'domain': 'google.com.ua'},
                     {'rank': '206', 'domain': 'forbes.com'},
                     {'rank': '207', 'domain': 'mercadolivre.com.br'},
                     {'rank': '208', 'domain': 'goo.ne.jp'},
                     {'rank': '209', 'domain': 'blogspot.co.id'},
                     {'rank': '210', 'domain': 'cctv.com'},
                     {'rank': '211', 'domain': 'babytree.com'},
                     {'rank': '212', 'domain': 'livejournal.com'},
                     {'rank': '213', 'domain': 'csdn.net'},
                     {'rank': '214', 'domain': 'adexchangeprediction.com'},
                     {'rank': '215', 'domain': 'ozock.com'},
                     {'rank': '216', 'domain': 'tistory.com'},
                     {'rank': '217', 'domain': 'detik.com'},
                     {'rank': '218', 'domain': 'xnxx.com'},
                     {'rank': '219', 'domain': 'google.se'},
                     {'rank': '220', 'domain': 'wetransfer.com'},
                     {'rank': '221', 'domain': 'amazon.it'},
                     {'rank': '222', 'domain': 'walmart.com'},
                     {'rank': '223', 'domain': 'wordreference.com'},
                     {'rank': '224', 'domain': 'giphy.com'},
                     {'rank': '225', 'domain': 'wellsfargo.com'},
                     {'rank': '226', 'domain': 'zol.com.cn'},
                     {'rank': '227', 'domain': 'archive.org'},
                     {'rank': '228', 'domain': 'feedly.com'},
                     {'rank': '229', 'domain': 'redtube.com'},
                     {'rank': '230', 'domain': 'amazon.fr'},
                     {'rank': '231', 'domain': 'wikimedia.org'},
                     {'rank': '232', 'domain': '51.la'},
                     {'rank': '233', 'domain': 'flickr.com'},
                     {'rank': '234', 'domain': 'foxnews.com'},
                     {'rank': '235', 'domain': 'nih.gov'},
                     {'rank': '236', 'domain': 'google.com.pe'},
                     {'rank': '237', 'domain': 'openload.co'},
                     {'rank': '238', 'domain': 'gfycat.com'},
                     {'rank': '239', 'domain': 'upornia.com'},
                     {'rank': '240', 'domain': 'google.dz'},
                     {'rank': '241', 'domain': 'yelp.com'},
                     {'rank': '242', 'domain': 'files.wordpress.com'},
                     {'rank': '243', 'domain': 'google.at'},
                     {'rank': '244', 'domain': 'kinogo.club'},
                     {'rank': '245', 'domain': '163.com'},
                     {'rank': '246', 'domain': 'weebly.com'},
                     {'rank': '247', 'domain': 'mama.cn'},
                     {'rank': '248', 'domain': 'themeforest.net'},
                     {'rank': '249', 'domain': 'pinimg.com'},
                     {'rank': '250', 'domain': 'ikea.com'},
                     {'rank': '251', 'domain': 'paytm.com'},
                     {'rank': '252', 'domain': 'mailchimp.com'},
                     {'rank': '253', 'domain': 'tripadvisor.com'},
                     {'rank': '254', 'domain': 'aol.com'},
                     {'rank': '255', 'domain': 'taboola.com'},
                     {'rank': '256', 'domain': 'freepik.com'},
                     {'rank': '257', 'domain': 'reimageplus.com'},
                     {'rank': '258', 'domain': 'putlocker.is'},
                     {'rank': '259', 'domain': 'rutracker.org'},
                     {'rank': '260', 'domain': 'instructure.com'},
                     {'rank': '261', 'domain': 'tuberel.com'},
                     {'rank': '262', 'domain': 'detail.tmall.com'},
                     {'rank': '263', 'domain': 'allegro.pl'},
                     {'rank': '264', 'domain': 'sourceforge.net'},
                     {'rank': '265', 'domain': 'businessinsider.com'},
                     {'rank': '266', 'domain': 'zendesk.com'},
                     {'rank': '267', 'domain': 'google.ch'},
                     {'rank': '268', 'domain': 'theladbible.com'},
                     {'rank': '269', 'domain': 'iwanttodeliver.com'},
                     {'rank': '270', 'domain': 'ndtv.com'},
                     {'rank': '271', 'domain': 'google.pt'},
                     {'rank': '272', 'domain': 'myway.com'},
                     {'rank': '273', 'domain': 'youporn.com'},
                     {'rank': '274', 'domain': 'espncricinfo.com'},
                     {'rank': '275', 'domain': 'dmm.co.jp'},
                     {'rank': '276', 'domain': 'google.ae'},
                     {'rank': '277', 'domain': 'douban.com'},
                     {'rank': '278', 'domain': 'upwork.com'},
                     {'rank': '279', 'domain': 'hdfcbank.com'},
                     {'rank': '280', 'domain': 'zillow.com'},
                     {'rank': '281', 'domain': 'varzesh3.com'},
                     {'rank': '282', 'domain': 'google.az'},
                     {'rank': '283', 'domain': 'xywy.com'},
                     {'rank': '284', 'domain': 'google.cz'},
                     {'rank': '285', 'domain': 'google.cn'},
                     {'rank': '286', 'domain': 'thesaurus.com'},
                     {'rank': '287', 'domain': 'speedtest.net'},
                     {'rank': '288', 'domain': 'youm7.com'},
                     {'rank': '289', 'domain': 'zippyshare.com'},
                     {'rank': '290', 'domain': 'rt.com'},
                     {'rank': '291', 'domain': 'doublepimp.com'},
                     {'rank': '292', 'domain': 'webtretho.com'},
                     {'rank': '293', 'domain': 'medium.com'},
                     {'rank': '294', 'domain': 'google.com.bd'},
                     {'rank': '295', 'domain': 'disqus.com'},
                     {'rank': '296', 'domain': 'nametests.com'},
                     {'rank': '297', 'domain': 'globaloffers.link'},
                     {'rank': '298', 'domain': 'scribd.com'},
                     {'rank': '299', 'domain': 'fiverr.com'},
                     {'rank': '300', 'domain': 'bitauto.com'},
                     {'rank': '301', 'domain': 'douyu.com'},
                     {'rank': '302', 'domain': 'kinopoisk.ru'},
                     {'rank': '303', 'domain': 'gsmarena.com'},
                     {'rank': '304', 'domain': 'softonic.com'},
                     {'rank': '305', 'domain': 'google.cl'},
                     {'rank': '306', 'domain': 'sh.st'},
                     {'rank': '307', 'domain': 'icicibank.com'},
                     {'rank': '308', 'domain': 'mega.nz'},
                     {'rank': '309', 'domain': 'gearbest.com'},
                     {'rank': '310', 'domain': 'zoho.com'},
                     {'rank': '311', 'domain': 'secureserver.net'},
                     {'rank': '312', 'domain': 'media.tumblr.com'},
                     {'rank': '313', 'domain': 'nfl.com'},
                     {'rank': '314', 'domain': 'caijing.com.cn'},
                     {'rank': '315', 'domain': 'rambler.ru'},
                     {'rank': '316', 'domain': 'leboncoin.fr'},
                     {'rank': '317', 'domain': 'kakaku.com'},
                     {'rank': '318', 'domain': 'amazon.es'},
                     {'rank': '319', 'domain': 'daikynguyenvn.com'},
                     {'rank': '320', 'domain': 'rarbg.to'},
                     {'rank': '321', 'domain': 'ebay-kleinanzeigen.de'},
                     {'rank': '322', 'domain': 'oracle.com'},
                     {'rank': '323', 'domain': 'wix.com'},
                     {'rank': '324', 'domain': '39.net'},
                     {'rank': '325', 'domain': 'hatenablog.com'},
                     {'rank': '326', 'domain': 'spotscenered.info'},
                     {'rank': '327', 'domain': 'behance.net'},
                     {'rank': '328', 'domain': 'messenger.com'},
                     {'rank': '329', 'domain': 'directrev.com'},
                     {'rank': '330', 'domain': 'evernote.com'},
                     {'rank': '331', 'domain': 'asos.com'},
                     {'rank': '332', 'domain': 'iqiyi.com'},
                     {'rank': '333', 'domain': 'onclickpredictiv.com'},
                     {'rank': '334', 'domain': 'tokopedia.com'},
                     {'rank': '335', 'domain': 'jd.com'},
                     {'rank': '336', 'domain': 'google.no'},
                     {'rank': '337', 'domain': 'icloud.com'},
                     {'rank': '338', 'domain': 'hatena.ne.jp'},
                     {'rank': '339', 'domain': 'goodreads.com'},
                     {'rank': '340', 'domain': 'ytimg.com'},
                     {'rank': '341', 'domain': '51yes.com'},
                     {'rank': '342', 'domain': 'bloomberg.com'},
                     {'rank': '343', 'domain': '1905.com'},
                     {'rank': '344', 'domain': 'hootsuite.com'},
                     {'rank': '345', 'domain': 'go.com'},
                     {'rank': '346', 'domain': 'hp.com'},
                     {'rank': '347', 'domain': 'canva.com'},
                     {'rank': '348', 'domain': 'chinadaily.com.cn'},
                     {'rank': '349', 'domain': 'cnblogs.com'},
                     {'rank': '350', 'domain': 'samsung.com'},
                     {'rank': '351', 'domain': 'adnetworkperformance.com'},
                     {'rank': '352', 'domain': 'shopify.com'},
                     {'rank': '353', 'domain': 'repubblica.it'},
                     {'rank': '354', 'domain': 'battle.net'},
                     {'rank': '355', 'domain': 'onedio.com'},
                     {'rank': '356', 'domain': 'tradeadexchange.com'},
                     {'rank': '357', 'domain': '1688.com'},
                     {'rank': '358', 'domain': 'google.hu'},
                     {'rank': '359', 'domain': 'youtube-mp3.org'},
                     {'rank': '360', 'domain': 'atlassian.net'},
                     {'rank': '361', 'domain': 'ltn.com.tw'},
                     {'rank': '362', 'domain': 'sharepoint.com'},
                     {'rank': '363', 'domain': '123movies.to'},
                     {'rank': '364', 'domain': 'telegraph.co.uk'},
                     {'rank': '365', 'domain': 'google.ie'},
                     {'rank': '366', 'domain': 'yesky.com'},
                     {'rank': '367', 'domain': 'cnnic.cn'},
                     {'rank': '368', 'domain': 'americanexpress.com'},
                     {'rank': '369', 'domain': 'kompas.com'},
                     {'rank': '370', 'domain': 'onet.pl'},
                     {'rank': '371', 'domain': '2ch.net'},
                     {'rank': '372', 'domain': 'googleapis.com'},
                     {'rank': '373', 'domain': 'amazon.cn'},
                     {'rank': '374', 'domain': 'pandora.com'},
                     {'rank': '375', 'domain': 'steamcommunity.com'},
                     {'rank': '376', 'domain': 'eksisozluk.com'},
                     {'rank': '377', 'domain': 'nyaa.se'},
                     {'rank': '378', 'domain': 'roblox.com'},
                     {'rank': '379', 'domain': 'quizlet.com'},
                     {'rank': '380', 'domain': 'kaskus.co.id'},
                     {'rank': '381', 'domain': 'blkget.com'},
                     {'rank': '382', 'domain': 'gmx.net'},
                     {'rank': '383', 'domain': 'bukalapak.com'},
                     {'rank': '384', 'domain': 'xfinity.com'},
                     {'rank': '385', 'domain': 'google.co.il'},
                     {'rank': '386', 'domain': 'enet.com.cn'},
                     {'rank': '387', 'domain': 'elpais.com'},
                     {'rank': '388', 'domain': 'pixabay.com'},
                     {'rank': '389', 'domain': 'irctc.co.in'},
                     {'rank': '390', 'domain': 'blogspot.jp'},
                     {'rank': '391', 'domain': 'bestbuy.com'},
                     {'rank': '392', 'domain': 'wsj.com'},
                     {'rank': '393', 'domain': '4dsply.com'},
                     {'rank': '394', 'domain': 'web.de'},
                     {'rank': '395', 'domain': 'udemy.com'},
                     {'rank': '396', 'domain': 'kissanime.to'},
                     {'rank': '397', 'domain': 'dictionary.com'},
                     {'rank': '398', 'domain': 'usatoday.com'},
                     {'rank': '399', 'domain': 'thewhizproducts.com'},
                     {'rank': '400', 'domain': 'seasonvar.ru'},
                     {'rank': '401', 'domain': 'fastpokemap.se'},
                     {'rank': '402', 'domain': 'telegram.org'},
                     {'rank': '403', 'domain': 'ebay.in'},
                     {'rank': '404', 'domain': 'reddituploads.com'},
                     {'rank': '405', 'domain': 'infusionsoft.com'},
                     {'rank': '406', 'domain': 'sberbank.ru'},
                     {'rank': '407', 'domain': 'liputan6.com'},
                     {'rank': '408', 'domain': 'yts.ag'},
                     {'rank': '409', 'domain': 'accuweather.com'},
                     {'rank': '410', 'domain': 'airbnb.com'},
                     {'rank': '411', 'domain': 'about.com'},
                     {'rank': '412', 'domain': 'blackboard.com'},
                     {'rank': '413', 'domain': 'conservativetribune.com'},
                     {'rank': '414', 'domain': 'google.dk'},
                     {'rank': '415', 'domain': 'mediawhirl.net'},
                     {'rank': '416', 'domain': 'google.fi'},
                     {'rank': '417', 'domain': 'ruten.com.tw'},
                     {'rank': '418', 'domain': 'sabah.com.tr'},
                     {'rank': '419', 'domain': 'weblio.jp'},
                     {'rank': '420', 'domain': 'wittyfeed.com'},
                     {'rank': '421', 'domain': 'tutorialspoint.com'},
                     {'rank': '422', 'domain': 'wixsite.com'},
                     {'rank': '423', 'domain': 'reuters.com'},
                     {'rank': '424', 'domain': 'hubspot.com'},
                     {'rank': '425', 'domain': 'box.com'},
                     {'rank': '426', 'domain': 'clickadu.com'},
                     {'rank': '427', 'domain': 'avg.com'},
                     {'rank': '428', 'domain': 'usps.com'},
                     {'rank': '429', 'domain': 'ups.com'},
                     {'rank': '430', 'domain': 'exoclick.com'},
                     {'rank': '431', 'domain': 'capitalone.com'},
                     {'rank': '432', 'domain': 'techcrunch.com'},
                     {'rank': '433', 'domain': 'sciencedirect.com'},
                     {'rank': '434', 'domain': 'digikala.com'},
                     {'rank': '435', 'domain': 'dell.com'},
                     {'rank': '436', 'domain': 'spiegel.de'},
                     {'rank': '437', 'domain': 'homedepot.com'},
                     {'rank': '438', 'domain': 'php.net'},
                     {'rank': '439', 'domain': 'taleo.net'},
                     {'rank': '440', 'domain': 'kapanlagi.com'},
                     {'rank': '441', 'domain': 'kickstarter.com'},
                     {'rank': '442', 'domain': 'list-manage.com'},
                     {'rank': '443', 'domain': 'ebay.it'},
                     {'rank': '444', 'domain': 'neobux.com'},
                     {'rank': '445', 'domain': 'target.com'},
                     {'rank': '446', 'domain': 'goo.gl'},
                     {'rank': '447', 'domain': 'blog.jp'},
                     {'rank': '448', 'domain': 'indianexpress.com'},
                     {'rank': '449', 'domain': 'adexc.net'},
                     {'rank': '450', 'domain': 'fedex.com'},
                     {'rank': '451', 'domain': 'ign.com'},
                     {'rank': '452', 'domain': 'abs-cbn.com'},
                     {'rank': '453', 'domain': 'thefreedictionary.com'},
                     {'rank': '454', 'domain': 'researchgate.net'},
                     {'rank': '455', 'domain': 'subscene.com'},
                     {'rank': '456', 'domain': 'imzog.com'},
                     {'rank': '457', 'domain': 'intuit.com'},
                     {'rank': '458', 'domain': 'mi.com'},
                     {'rank': '459', 'domain': 'taringa.net'},
                     {'rank': '460', 'domain': 'google.sk'},
                     {'rank': '461', 'domain': 'marca.com'},
                     {'rank': '462', 'domain': 'uploaded.net'},
                     {'rank': '463', 'domain': 'kooora.com'},
                     {'rank': '464', 'domain': 'beeg.com'},
                     {'rank': '465', 'domain': 'bhaskar.com'},
                     {'rank': '466', 'domain': 'baike.com'},
                     {'rank': '467', 'domain': 'asana.com'},
                     {'rank': '468', 'domain': 'wp.pl'},
                     {'rank': '469', 'domain': 'ouo.io'},
                     {'rank': '470', 'domain': 'qiita.com'},
                     {'rank': '471', 'domain': 'mlb.com'},
                     {'rank': '472', 'domain': 'ci123.com'},
                     {'rank': '473', 'domain': 'groupon.com'},
                     {'rank': '474', 'domain': 'spankbang.com'},
                     {'rank': '475', 'domain': 'lifebuzz.com'},
                     {'rank': '476', 'domain': 'mercadolibre.com.ar'},
                     {'rank': '477', 'domain': 'webmd.com'},
                     {'rank': '478', 'domain': 'hotstar.com'},
                     {'rank': '479', 'domain': 'clipconverter.cc'},
                     {'rank': '480', 'domain': 'youdao.com'},
                     {'rank': '481', 'domain': 'orange.fr'},
                     {'rank': '482', 'domain': 'tube8.com'},
                     {'rank': '483', 'domain': 'zone-telechargement.com'},
                     {'rank': '484', 'domain': 'mashable.com'},
                     {'rank': '485', 'domain': 'hurriyet.com.tr'},
                     {'rank': '486', 'domain': 'teepr.com'},
                     {'rank': '487', 'domain': 'eastday.com'},
                     {'rank': '488', 'domain': 'billdesk.com'},
                     {'rank': '489', 'domain': 'free.fr'},
                     {'rank': '490', 'domain': '4chan.org'},
                     {'rank': '491', 'domain': 'azlyrics.com'},
                     {'rank': '492', 'domain': 'ebay.com.au'},
                     {'rank': '493', 'domain': 'bitbucket.org'},
                     {'rank': '494', 'domain': 'bitly.com'},
                     {'rank': '495', 'domain': 'leagueoflegends.com'},
                     {'rank': '496', 'domain': 'amazon.ca'},
                     {'rank': '497', 'domain': '4shared.com'},
                     {'rank': '498', 'domain': 'naukri.com'},
                     {'rank': '499', 'domain': 'zomato.com'},
                     {'rank': '500', 'domain': 'gizmodo.com'},
                     {'rank': '501', 'domain': 'rediff.com'},
                     {'rank': '502', 'domain': 'goal.com'},
                     {'rank': '503', 'domain': 'dcinside.com'},
                     {'rank': '504', 'domain': 'theverge.com'},
                     {'rank': '505', 'domain': 'sahibinden.com'},
                     {'rank': '506', 'domain': 'att.com'},
                     {'rank': '507', 'domain': '17ok.com'},
                     {'rank': '508', 'domain': 'comcast.net'},
                     {'rank': '509', 'domain': 'xe.com'},
                     {'rank': '510', 'domain': 'fivethirtyeight.com'},
                     {'rank': '511', 'domain': 'watsons.tmall.com'},
                     {'rank': '512', 'domain': 'engadget.com'},
                     {'rank': '513', 'domain': 'hola.com'},
                     {'rank': '514', 'domain': 'vk.me'},
                     {'rank': '515', 'domain': 'independent.co.uk'},
                     {'rank': '516', 'domain': 'hulu.com'},
                     {'rank': '517', 'domain': 'elmundo.es'},
                     {'rank': '518', 'domain': 'haber7.com'},
                     {'rank': '519', 'domain': 'citi.com'},
                     {'rank': '520', 'domain': 'nownews.com'},
                     {'rank': '521', 'domain': 'ask.fm'},
                     {'rank': '522', 'domain': 'meetup.com'},
                     {'rank': '523', 'domain': 'gamepedia.com'},
                     {'rank': '524', 'domain': 'mit.edu'},
                     {'rank': '525', 'domain': 'gyazo.com'},
                     {'rank': '526', 'domain': 'hilltopads.net'},
                     {'rank': '527', 'domain': 'corriere.it'},
                     {'rank': '528', 'domain': 'rednet.cn'},
                     {'rank': '529', 'domain': 'tabelog.com'},
                     {'rank': '530', 'domain': 'shopclues.com'},
                     {'rank': '531', 'domain': 'gamefaqs.com'},
                     {'rank': '532', 'domain': 'chatwork.com'},
                     {'rank': '533', 'domain': 'cricbuzz.com'},
                     {'rank': '534', 'domain': 'poptm.com'},
                     {'rank': '535', 'domain': 'pikabu.ru'},
                     {'rank': '536', 'domain': 'blogfa.com'},
                     {'rank': '537', 'domain': 'wowhead.com'},
                     {'rank': '538', 'domain': 'ifeng.com'},
                     {'rank': '539', 'domain': 'xda-developers.com'},
                     {'rank': '540', 'domain': 'intoday.in'},
                     {'rank': '541', 'domain': 'aparat.com'},
                     {'rank': '542', 'domain': 'reverso.net'},
                     {'rank': '543', 'domain': 'livedoor.com'},
                     {'rank': '544', 'domain': 'verizonwireless.com'},
                     {'rank': '545', 'domain': 'aliyun.com'},
                     {'rank': '546', 'domain': 'namu.wiki'},
                     {'rank': '547', 'domain': 'buzzhand.com'},
                     {'rank': '548', 'domain': 't-online.de'},
                     {'rank': '549', 'domain': 'gamer.com.tw'},
                     {'rank': '550', 'domain': 'seznam.cz'},
                     {'rank': '551', 'domain': 'rapidgator.net'},
                     {'rank': '552', 'domain': 'google.com.kw'},
                     {'rank': '553', 'domain': 'chaoshi.tmall.com'},
                     {'rank': '554', 'domain': 'coursera.org'},
                     {'rank': '555', 'domain': 'lemonde.fr'},
                     {'rank': '556', 'domain': 'bild.de'},
                     {'rank': '557', 'domain': 'adidas.tmall.com'},
                     {'rank': '558', 'domain': 'abril.com.br'},
                     {'rank': '559', 'domain': 'milliyet.com.tr'},
                     {'rank': '560', 'domain': 'google.lk'},
                     {'rank': '561', 'domain': 'prezi.com'},
                     {'rank': '562', 'domain': 'hm.com'},
                     {'rank': '563', 'domain': 'google.kz'},
                     {'rank': '564', 'domain': 'surveymonkey.com'},
                     {'rank': '565', 'domain': 'jabong.com'},
                     {'rank': '566', 'domain': 'howtogeek.com'},
                     {'rank': '567', 'domain': 'urdupoint.com'},
                     {'rank': '568', 'domain': 'playstation.com'},
                     {'rank': '569', 'domain': 'wp.com'},
                     {'rank': '570', 'domain': 'souq.com'},
                     {'rank': '571', 'domain': 'clixsense.com'},
                     {'rank': '572', 'domain': 'pantip.com'},
                     {'rank': '573', 'domain': 'line.me'},
                     {'rank': '574', 'domain': 'politico.com'},
                     {'rank': '575', 'domain': 'mercadolibre.com.mx'},
                     {'rank': '576', 'domain': 'gismeteo.ru'},
                     {'rank': '577', 'domain': 'prnt.sc'},
                     {'rank': '578', 'domain': 'airtel.in'},
                     {'rank': '579', 'domain': 'doorblog.jp'},
                     {'rank': '580', 'domain': 'asus.com'},
                     {'rank': '581', 'domain': 'lenta.ru'},
                     {'rank': '582', 'domain': 'umblr.com'},
                     {'rank': '583', 'domain': 'olx.com.br'},
                     {'rank': '584', 'domain': 'sq.cn'},
                     {'rank': '585', 'domain': 'wiktionary.org'},
                     {'rank': '586', 'domain': 'urbandictionary.com'},
                     {'rank': '587', 'domain': 'reference.com'},
                     {'rank': '588', 'domain': 'merdeka.com'},
                     {'rank': '589', 'domain': 'sakura.ne.jp'},
                     {'rank': '590', 'domain': 'superuser.com'},
                     {'rank': '591', 'domain': 'chinaz.com'},
                     {'rank': '592', 'domain': 'drudgereport.com'},
                     {'rank': '593', 'domain': 'nbcnews.com'},
                     {'rank': '594', 'domain': 'state.gov'},
                     {'rank': '595', 'domain': 'uber.com'},
                     {'rank': '596', 'domain': 'instructables.com'},
                     {'rank': '597', 'domain': 'alicdn.com'},
                     {'rank': '598', 'domain': 'lifehacker.com'},
                     {'rank': '599', 'domain': 'wiley.com'},
                     {'rank': '600', 'domain': 'glassdoor.com'},
                     {'rank': '601', 'domain': 'macys.com'},
                     {'rank': '602', 'domain': '51sole.com'},
                     {'rank': '603', 'domain': 'hespress.com'},
                     {'rank': '604', 'domain': 'livescore.com'},
                     {'rank': '605', 'domain': 'nike.com'},
                     {'rank': '606', 'domain': 'digitalocean.com'},
                     {'rank': '607', 'domain': 'seesaa.net'},
                     {'rank': '608', 'domain': 'jrj.com.cn'},
                     {'rank': '609', 'domain': 'google.bg'},
                     {'rank': '610', 'domain': 'ero-advertising.com'},
                     {'rank': '611', 'domain': 'wunderground.com'},
                     {'rank': '612', 'domain': 'ck101.com'},
                     {'rank': '613', 'domain': 'dingit.tv'},
                     {'rank': '614', 'domain': 'bookmyshow.com'},
                     {'rank': '615', 'domain': 'stumbleupon.com'},
                     {'rank': '616', 'domain': 'huaban.com'},
                     {'rank': '617', 'domain': 'freelancer.com'},
                     {'rank': '618', 'domain': 'codepen.io'},
                     {'rank': '619', 'domain': 'cbssports.com'},
                     {'rank': '620', 'domain': 'jimdo.com'},
                     {'rank': '621', 'domain': 'basecamp.com'},
                     {'rank': '622', 'domain': 'expedia.com'},
                     {'rank': '623', 'domain': 'android.com'},
                     {'rank': '624', 'domain': 'blogspot.mx'},
                     {'rank': '625', 'domain': 'issuu.com'},
                     {'rank': '626', 'domain': 'time.com'},
                     {'rank': '627', 'domain': 'yandex.ua'},
                     {'rank': '628', 'domain': 'kdnet.net'},
                     {'rank': '629', 'domain': 'squarespace.com'},
                     {'rank': '630', 'domain': 'investing.com'},
                     {'rank': '631', 'domain': 'mirror.co.uk'},
                     {'rank': '632', 'domain': 'myanimelist.net'},
                     {'rank': '633', 'domain': 'eventbrite.com'},
                     {'rank': '634', 'domain': 'npr.org'},
                     {'rank': '635', 'domain': 'google.co.nz'},
                     {'rank': '636', 'domain': 'photobucket.com'},
                     {'rank': '637', 'domain': 'rottentomatoes.com'},
                     {'rank': '638', 'domain': 'chip.de'},
                     {'rank': '639', 'domain': 'cpasbien.cm'},
                     {'rank': '640', 'domain': 'dmm.com'},
                     {'rank': '641', 'domain': 'springer.com'},
                     {'rank': '642', 'domain': 'filehippo.com'},
                     {'rank': '643', 'domain': 'justdial.com'},
                     {'rank': '644', 'domain': 'viralthread.com'},
                     {'rank': '645', 'domain': 'noaa.gov'},
                     {'rank': '646', 'domain': 'mobile.de'},
                     {'rank': '647', 'domain': 'smartnewtab.com'},
                     {'rank': '648', 'domain': 'spzan.com'},
                     {'rank': '649', 'domain': 'duckduckgo.com'},
                     {'rank': '650', 'domain': 'lenovo.com'},
                     {'rank': '651', 'domain': 'westernjournalism.com'},
                     {'rank': '652', 'domain': 'my-hit.org'},
                     {'rank': '653', 'domain': 'askubuntu.com'},
                     {'rank': '654', 'domain': 'olx.in'},
                     {'rank': '655', 'domain': '4pda.ru'},
                     {'rank': '656', 'domain': 'sitepoint.com'},
                     {'rank': '657', 'domain': 'torrentz2.eu'},
                     {'rank': '658', 'domain': 'curapelanatureza.com.br'},
                     {'rank': '659', 'domain': 'impress.co.jp'},
                     {'rank': '660', 'domain': 'ibm.com'},
                     {'rank': '661', 'domain': 'academia.edu'},
                     {'rank': '662', 'domain': 'drom.ru'},
                     {'rank': '663', 'domain': 'latimes.com'},
                     {'rank': '664', 'domain': 'getpocket.com'},
                     {'rank': '665', 'domain': 'hdzog.com'},
                     {'rank': '666', 'domain': 'japanpost.jp'},
                     {'rank': '667', 'domain': 'commentcamarche.net'},
                     {'rank': '668', 'domain': 'kijiji.ca'},
                     {'rank': '669', 'domain': 'mercadolibre.com.ve'},
                     {'rank': '670', 'domain': 'adbooth.com'},
                     {'rank': '671', 'domain': 'zing.vn'},
                     {'rank': '672', 'domain': 'makeuseof.com'},
                     {'rank': '673', 'domain': 'livedoor.biz'},
                     {'rank': '674', 'domain': 'lazada.co.id'},
                     {'rank': '675', 'domain': 'nikkeibp.co.jp'},
                     {'rank': '676', 'domain': 'e-hentai.org'},
                     {'rank': '677', 'domain': 'adplxmd.com'},
                     {'rank': '678', 'domain': 'myntra.com'},
                     {'rank': '679', 'domain': 'xing.com'},
                     {'rank': '680', 'domain': 'moneycontrol.com'},
                     {'rank': '681', 'domain': 'acfun.tv'},
                     {'rank': '682', 'domain': 'webex.com'},
                     {'rank': '683', 'domain': 'inquirer.net'},
                     {'rank': '684', 'domain': 'newegg.com'},
                     {'rank': '685', 'domain': 'hotels.com'},
                     {'rank': '686', 'domain': 'akamaihd.net'},
                     {'rank': '687', 'domain': 'shink.in'},
                     {'rank': '688', 'domain': 'breitbart.com'},
                     {'rank': '689', 'domain': 'ab4hr.com'},
                     {'rank': '690', 'domain': 'chinaso.com'},
                     {'rank': '691', 'domain': 'answers.com'},
                     {'rank': '692', 'domain': 'lefigaro.fr'},
                     {'rank': '693', 'domain': 'office365.com'},
                     {'rank': '694', 'domain': 'cisco.com'},
                     {'rank': '695', 'domain': '123rf.com'},
                     {'rank': '696', 'domain': 'okezone.com'},
                     {'rank': '697', 'domain': 'banggood.com'},
                     {'rank': '698', 'domain': 'dafont.com'},
                     {'rank': '699', 'domain': 'timeanddate.com'},
                     {'rank': '700', 'domain': 'itmedia.co.jp'},
                     {'rank': '701', 'domain': 'ebay.fr'},
                     {'rank': '702', 'domain': 'blog.me'},
                     {'rank': '703', 'domain': 'nordstrom.com'},
                     {'rank': '704', 'domain': 'olx.pl'},
                     {'rank': '705', 'domain': 'lanacion.com.ar'},
                     {'rank': '706', 'domain': 'as.com'},
                     {'rank': '707', 'domain': 'ouedkniss.com'},
                     {'rank': '708', 'domain': 'badoo.com'},
                     {'rank': '709', 'domain': 'ria.ru'},
                     {'rank': '710', 'domain': 'infobae.com'},
                     {'rank': '711', 'domain': 'cambridge.org'},
                     {'rank': '712', 'domain': 'rbc.ru'},
                     {'rank': '713', 'domain': 'google.com.do'},
                     {'rank': '714', 'domain': 'makemytrip.com'},
                     {'rank': '715', 'domain': 'google.rs'},
                     {'rank': '716', 'domain': 'realclearpolitics.com'},
                     {'rank': '717', 'domain': 'getbootstrap.com'},
                     {'rank': '718', 'domain': 'nikkei.com'},
                     {'rank': '719', 'domain': 'genius.com'},
                     {'rank': '720', 'domain': 'grammarly.com'},
                     {'rank': '721', 'domain': 'imagebam.com'},
                     {'rank': '722', 'domain': 'shaparak.ir'},
                     {'rank': '723', 'domain': 'siteadvisor.com'},
                     {'rank': '724', 'domain': 'cbsnews.com'},
                     {'rank': '725', 'domain': 'subito.it'},
                     {'rank': '726', 'domain': 'suning.com'},
                     {'rank': '727', 'domain': 'voc.com.cn'},
                     {'rank': '728', 'domain': 'redirectvoluum.com'},
                     {'rank': '729', 'domain': 'india.com'},
                     {'rank': '730', 'domain': 'ca.gov'},
                     {'rank': '731', 'domain': 'drive2.ru'},
                     {'rank': '732', 'domain': 'vporn.com'},
                     {'rank': '733', 'domain': 'libero.it'},
                     {'rank': '734', 'domain': 'albawabhnews.com'},
                     {'rank': '735', 'domain': 'utorrent.com'},
                     {'rank': '736', 'domain': 'paytm.in'},
                     {'rank': '737', 'domain': 'the-watch-series.to'},
                     {'rank': '738', 'domain': 'www.gov.uk'},
                     {'rank': '739', 'domain': 'appledaily.com.tw'},
                     {'rank': '740', 'domain': 'investopedia.com'},
                     {'rank': '741', 'domain': 'clarin.com'},
                     {'rank': '742', 'domain': 'cnbc.com'},
                     {'rank': '743', 'domain': 'ruliweb.com'},
                     {'rank': '744', 'domain': 'donga.com'},
                     {'rank': '745', 'domain': 'biobiochile.cl'},
                     {'rank': '746', 'domain': 'eyny.com'},
                     {'rank': '747', 'domain': 'sabq.org'},
                     {'rank': '748', 'domain': 'dribbble.com'},
                     {'rank': '749', 'domain': 'bola.net'},
                     {'rank': '750', 'domain': 'discogs.com'},
                     {'rank': '751', 'domain': 'thesportbible.com'},
                     {'rank': '752', 'domain': 'google.com.my'},
                     {'rank': '753', 'domain': 'nypost.com'},
                     {'rank': '754', 'domain': 'quikr.com'},
                     {'rank': '755', 'domain': 'streamcloud.eu'},
                     {'rank': '756', 'domain': 'europa.eu'},
                     {'rank': '757', 'domain': 'emol.com'},
                     {'rank': '758', 'domain': 'youjizz.com'},
                     {'rank': '759', 'domain': 'vnexpress.net'},
                     {'rank': '760', 'domain': 'momoshop.com.tw'},
                     {'rank': '761', 'domain': 'khanacademy.org'},
                     {'rank': '762', 'domain': 'patch.com'},
                     {'rank': '763', 'domain': 'drtuber.com'},
                     {'rank': '764', 'domain': 'merriam-webster.com'},
                     {'rank': '765', 'domain': 'okcupid.com'},
                     {'rank': '766', 'domain': 'youboy.com'},
                     {'rank': '767', 'domain': 'gazeta.pl'},
                     {'rank': '768', 'domain': 'gotporn.com'},
                     {'rank': '769', 'domain': 'torrentkim3.net'},
                     {'rank': '770', 'domain': 'bodybuilding.com'},
                     {'rank': '771', 'domain': 'prothom-alo.com'},
                     {'rank': '772', 'domain': 'thekitchn.com'},
                     {'rank': '773', 'domain': 'chron.com'},
                     {'rank': '774', 'domain': 'elbalad.news'},
                     {'rank': '775', 'domain': 'ultimate-guitar.com'},
                     {'rank': '776', 'domain': 'thehindu.com'},
                     {'rank': '777', 'domain': 'slickdeals.net'},
                     {'rank': '778', 'domain': 'norton.com'},
                     {'rank': '779', 'domain': 'google.by'},
                     {'rank': '780', 'domain': 'gstatic.com'},
                     {'rank': '781', 'domain': 'discordapp.com'},
                     {'rank': '782', 'domain': 'oschina.net'},
                     {'rank': '783', 'domain': 'olx.ua'},
                     {'rank': '784', 'domain': 'google.com.ec'},
                     {'rank': '785', 'domain': 'likes.com'},
                     {'rank': '786', 'domain': 'wish.com'},
                     {'rank': '787', 'domain': 'linkshrink.net'},
                     {'rank': '788', 'domain': 'codecanyon.net'},
                     {'rank': '789', 'domain': 'ccm.net'},
                     {'rank': '790', 'domain': 'watchseries.ac'},
                     {'rank': '791', 'domain': 'pof.com'},
                     {'rank': '792', 'domain': 'ameba.jp'},
                     {'rank': '793', 'domain': 'nudevista.com'},
                     {'rank': '794', 'domain': 'abcnews.go.com'},
                     {'rank': '795', 'domain': 'cdiscount.com'},
                     {'rank': '796', 'domain': 'leadzupc.com'},
                     {'rank': '797', 'domain': 'custhelp.com'},
                     {'rank': '798', 'domain': 'theodysseyonline.com'},
                     {'rank': '799', 'domain': 'apache.org'},
                     {'rank': '800', 'domain': 'pixiv.net'},
                     {'rank': '801', 'domain': 'topix.com'},
                     {'rank': '802', 'domain': 'bhphotovideo.com'},
                     {'rank': '803', 'domain': 'lapatilla.com'},
                     {'rank': '804', 'domain': 'stanford.edu'},
                     {'rank': '805', 'domain': 'trulia.com'},
                     {'rank': '806', 'domain': '1337x.to'},
                     {'rank': '807', 'domain': 'gigazine.net'},
                     {'rank': '808', 'domain': 'nhk.or.jp'},
                     {'rank': '809', 'domain': 'manoramaonline.com'},
                     {'rank': '810', 'domain': 'jeuxvideo.com'},
                     {'rank': '811', 'domain': 'istockphoto.com'},
                     {'rank': '812', 'domain': 'folha.uol.com.br'},
                     {'rank': '813', 'domain': 'allrecipes.com'},
                     {'rank': '814', 'domain': 'ted.com'},
                     {'rank': '815', 'domain': 'porn.com'},
                     {'rank': '816', 'domain': 'popmyads.com'},
                     {'rank': '817', 'domain': 'inven.co.kr'},
                     {'rank': '818', 'domain': 'elevenia.co.id'},
                     {'rank': '819', 'domain': 'cnmo.com'},
                     {'rank': '820', 'domain': 'realtor.com'},
                     {'rank': '821', 'domain': 'cookpad.com'},
                     {'rank': '822', 'domain': 'informer.com'},
                     {'rank': '823', 'domain': 'intel.com'},
                     {'rank': '824', 'domain': 'turbobit.net'},
                     {'rank': '825', 'domain': 'le.com'},
                     {'rank': '826', 'domain': 'ensonhaber.com'},
                     {'rank': '827', 'domain': 'entrepreneur.com'},
                     {'rank': '828', 'domain': 'deviantart.net'},
                     {'rank': '829', 'domain': 'adme.ru'},
                     {'rank': '830', 'domain': 'flaticon.com'},
                     {'rank': '831', 'domain': 'allocine.fr'},
                     {'rank': '832', 'domain': 'flirt4free.com'},
                     {'rank': '833', 'domain': 'sputniknews.com'},
                     {'rank': '834', 'domain': 'bidverdrs.com'},
                     {'rank': '835', 'domain': 'bluehost.com'},
                     {'rank': '836', 'domain': 'imagetwist.com'},
                     {'rank': '837', 'domain': 'bleacherreport.com'},
                     {'rank': '838', 'domain': 'gazzetta.it'},
                     {'rank': '839', 'domain': 'fmovies.to'},
                     {'rank': '840', 'domain': 'k618.cn'},
                     {'rank': '841', 'domain': 'convert2mp3.net'},
                     {'rank': '842', 'domain': 'nanoadexchange.com'},
                     {'rank': '843', 'domain': 'fanfiction.net'},
                     {'rank': '844', 'domain': 'pcmag.com'},
                     {'rank': '845', 'domain': 'tmz.com'},
                     {'rank': '846', 'domain': 'zara.com'},
                     {'rank': '847', 'domain': 'shareasale.com'},
                     {'rank': '848', 'domain': 'ablogica.com'},
                     {'rank': '849', 'domain': 'gmarket.co.kr'},
                     {'rank': '850', 'domain': 'bandcamp.com'},
                     {'rank': '851', 'domain': 'mynavi.jp'},
                     {'rank': '852', 'domain': 'trackingclick.net'},
                     {'rank': '853', 'domain': 'kayak.com'},
                     {'rank': '854', 'domain': 'thevideo.me'},
                     {'rank': '855', 'domain': 'lowes.com'},
                     {'rank': '856', 'domain': 'constantcontact.com'},
                     {'rank': '857', 'domain': 'googlevideo.com'},
                     {'rank': '858', 'domain': 'techradar.com'},
                     {'rank': '859', 'domain': 'jquery.com'},
                     {'rank': '860', 'domain': 'wired.com'},
                     {'rank': '861', 'domain': 'gmanetwork.com'},
                     {'rank': '862', 'domain': 'harvard.edu'},
                     {'rank': '863', 'domain': 'gamespot.com'},
                     {'rank': '864', 'domain': 'zhanqi.tv'},
                     {'rank': '865', 'domain': 'fbsbx.com'},
                     {'rank': '866', 'domain': 'stockstar.com'},
                     {'rank': '867', 'domain': '58.com'},
                     {'rank': '868', 'domain': 'adp.com'},
                     {'rank': '869', 'domain': 'aweber.com'},
                     {'rank': '870', 'domain': 'jsfiddle.net'},
                     {'rank': '871', 'domain': 'blogimg.jp'},
                     {'rank': '872', 'domain': 'cqnews.net'},
                     {'rank': '873', 'domain': 'liveleak.com'},
                     {'rank': '874', 'domain': 'google.hr'},
                     {'rank': '875', 'domain': 'mangafox.me'},
                     {'rank': '876', 'domain': 'gazetaexpress.com'},
                     {'rank': '877', 'domain': 'ptt.cc'},
                     {'rank': '878', 'domain': 'altervista.org'},
                     {'rank': '879', 'domain': 'google.tn'},
                     {'rank': '880', 'domain': 'r7mediar.com'},
                     {'rank': '881', 'domain': 'digitaltrends.com'},
                     {'rank': '882', 'domain': 'fidelity.com'},
                     {'rank': '883', 'domain': '360doc.com'},
                     {'rank': '884', 'domain': 'clicksor.net'},
                     {'rank': '885', 'domain': 'onlinevideoconverter.com'},
                     {'rank': '886', 'domain': 'dict.cc'},
                     {'rank': '887', 'domain': 'kohls.com'},
                     {'rank': '888', 'domain': 'absoluteclickscom.com'},
                     {'rank': '889', 'domain': 'blogspot.de'},
                     {'rank': '890', 'domain': 'microsoftstore.com'},
                     {'rank': '891', 'domain': 'discuss.com.hk'},
                     {'rank': '892', 'domain': 'slimspots.com'},
                     {'rank': '893', 'domain': 'oneindia.com'},
                     {'rank': '894', 'domain': 'southwest.com'},
                     {'rank': '895', 'domain': 'asahi.com'},
                     {'rank': '896', 'domain': 'agoda.com'},
                     {'rank': '897', 'domain': 'namesakeoscilloscopemarquis.com'},
                     {'rank': '898', 'domain': 'epwk.com'},
                     {'rank': '899', 'domain': 'buzzfil.net'},
                     {'rank': '900', 'domain': 'duolingo.com'},
                     {'rank': '901', 'domain': 'chouftv.ma'},
                     {'rank': '902', 'domain': 'zytpirwai.net'},
                     {'rank': '903', 'domain': 'criteo.com'},
                     {'rank': '904', 'domain': 'indiamart.com'},
                     {'rank': '905', 'domain': 'unity3d.com'},
                     {'rank': '906', 'domain': 'envato.com'},
                     {'rank': '907', 'domain': 'okta.com'},
                     {'rank': '908', 'domain': 'so-net.ne.jp'},
                     {'rank': '909', 'domain': 'backpage.com'},
                     {'rank': '910', 'domain': 'americanas.com.br'},
                     {'rank': '911', 'domain': 'nairaland.com'},
                     {'rank': '912', 'domain': 'thatviralfeed.net'},
                     {'rank': '913', 'domain': 'xtube.com'},
                     {'rank': '914', 'domain': 'narod.ru'},
                     {'rank': '915', 'domain': 'slate.com'},
                     {'rank': '916', 'domain': 'vodlocker.com'},
                     {'rank': '917', 'domain': 'fontawesome.io'},
                     {'rank': '918', 'domain': 'fishki.net'},
                     {'rank': '919', 'domain': 'twoo.com'},
                     {'rank': '920', 'domain': 'yandex.com.tr'},
                     {'rank': '921', 'domain': 'ancestry.com'},
                     {'rank': '922', 'domain': 'google.co.ao'},
                     {'rank': '923', 'domain': 'nexusmods.com'},
                     {'rank': '924', 'domain': 'g2a.com'},
                     {'rank': '925', 'domain': 'people.com'},
                     {'rank': '926', 'domain': 'yaplakal.com'},
                     {'rank': '927', 'domain': 'codeonclick.com'},
                     {'rank': '928', 'domain': 'nydailynews.com'},
                     {'rank': '929', 'domain': 'idnes.cz'},
                     {'rank': '930', 'domain': 'hh.ru'},
                     {'rank': '931', 'domain': 'junbi-tracker.com'},
                     {'rank': '932', 'domain': 'dl-protect.com'},
                     {'rank': '933', 'domain': 'ps4ux.com'},
                     {'rank': '934', 'domain': 'aiomp3.com'},
                     {'rank': '935', 'domain': 'java.com'},
                     {'rank': '936', 'domain': 'keepvid.com'},
                     {'rank': '937', 'domain': 'sapo.pt'},
                     {'rank': '938', 'domain': 'verizon.com'},
                     {'rank': '939', 'domain': 'tempo.co'},
                     {'rank': '940', 'domain': 'costco.com'},
                     {'rank': '941', 'domain': '11st.co.kr'},
                     {'rank': '942', 'domain': 'liveinternet.ru'},
                     {'rank': '943', 'domain': 'ticketmaster.com'},
                     {'rank': '944', 'domain': 'gutefrage.net'},
                     {'rank': '945', 'domain': 'wattpad.com'},
                     {'rank': '946', 'domain': 'scribol.com'},
                     {'rank': '947', 'domain': 'zopim.com'},
                     {'rank': '948', 'domain': 'thisav.com'},
                     {'rank': '949', 'domain': 'mobile01.com'},
                     {'rank': '950', 'domain': 'caixa.gov.br'},
                     {'rank': '951', 'domain': 'zedo.com'},
                     {'rank': '952', 'domain': 'udn.com'},
                     {'rank': '953', 'domain': 'ssl-images-amazon.com'},
                     {'rank': '954', 'domain': 'axisbank.co.in'},
                     {'rank': '955', 'domain': 'motherless.com'},
                     {'rank': '956', 'domain': 'pixlr.com'},
                     {'rank': '957', 'domain': 'op.gg'},
                     {'rank': '958', 'domain': 'houzz.com'},
                     {'rank': '959', 'domain': 'list.tmall.com'},
                     {'rank': '960', 'domain': 'rutube.ru'},
                     {'rank': '961', 'domain': 'himado.in'},
                     {'rank': '962', 'domain': 'javedch.com'},
                     {'rank': '963', 'domain': 'xunlei.com'},
                     {'rank': '964', 'domain': 'gap.com'},
                     {'rank': '965', 'domain': 'safefinder.com'},
                     {'rank': '966', 'domain': 'mgid.com'},
                     {'rank': '967', 'domain': 'marketwatch.com'},
                     {'rank': '968', 'domain': 'google.com.ly'},
                     {'rank': '969', 'domain': 'gotowebinar.com'},
                     {'rank': '970', 'domain': 'getmyads.com'},
                     {'rank': '971', 'domain': 'lequipe.fr'},
                     {'rank': '972', 'domain': 'givemesport.com'},
                     {'rank': '973', 'domain': 'cam4.com'},
                     {'rank': '974', 'domain': 'lolesports.com'},
                     {'rank': '975', 'domain': 'voyeurhit.com'},
                     {'rank': '976', 'domain': 'socialblade.com'},
                     {'rank': '977', 'domain': 'ebay.es'},
                     {'rank': '978', 'domain': 'angel.co'},
                     {'rank': '979', 'domain': 'detonate.com'},
                     {'rank': '980', 'domain': 'truecaller.com'},
                     {'rank': '981', 'domain': '52pk.com'},
                     {'rank': '982', 'domain': 'fanpage.gr'},
                     {'rank': '983', 'domain': 'hepsiburada.com'},
                     {'rank': '984', 'domain': 'eonline.com'},
                     {'rank': '985', 'domain': 'pocofh.com'},
                     {'rank': '986', 'domain': 'nature.com'},
                     {'rank': '987', 'domain': 'tomshardware.com'},
                     {'rank': '988', 'domain': 'jb51.net'},
                     {'rank': '989', 'domain': 'theatlantic.com'},
                     {'rank': '990', 'domain': 'hostgator.com'},
                     {'rank': '991', 'domain': 'xbox.com'},
                     {'rank': '992', 'domain': 'tnaflix.com'},
                     {'rank': '993', 'domain': 'uptobox.com'},
                     {'rank': '994', 'domain': 'klikbca.com'},
                     {'rank': '995', 'domain': 'biblegateway.com'},
                     {'rank': '996', 'domain': 'reallifecam.com'},
                     {'rank': '997', 'domain': 'retailmenot.com'},
                     {'rank': '998', 'domain': 'ibtimes.co.uk'},
                     {'rank': '999', 'domain': 'myfreecams.com'},
                     {'rank': '1000', 'domain': 'ilbe.com'}]

    job_feeder(pkg_resources.resource_filename("pathspider", "tests/data/dnsresolvtest.csv"), spider)
    assert spider.was_shutdown
    print (spider.jobs)
    print (expected_jobs)
    assert spider.jobs == expected_jobs
