/*
 * Copyright (C) 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored-by: Florian Boucault <florian.boucault@canonical.com>
 */

#version 440

layout(location = 0) in vec2 qt_TexCoord0;
layout(location = 0) out vec4 fragColor;

layout(std140, binding = 0) uniform buf {

    mat4 qt_Matrix;
    float qt_Opacity;

    vec4 backgroundColor;
    vec4 contourColor;
    vec4 outsideColor;
    float sourceWidth;
    float sourceHeight;

} ubuf;

layout(binding = 1) uniform sampler2D source;

void main() {
    vec4 sourceColor = texture(source, vec2(qt_TexCoord0.x / ubuf.sourceWidth, qt_TexCoord0.y / ubuf.sourceHeight));
    vec4 backgroundMix = ubuf.backgroundColor * sourceColor.r;
    vec4 contourMix = ubuf.contourColor * sourceColor.g;
    vec4 outsideMix = ubuf.outsideColor * sourceColor.b;
    fragColor = (contourMix + backgroundMix * (1.0 - contourMix.a) + outsideMix * (1.0 - contourMix.a)) * ubuf.qt_Opacity;
}
