/*
 * J721E Clocks Info
 *
 * Copyright (C) 2022 Texas Instruments Incorporated - https://www.ti.com/
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <tisci.h>
#include <socinfo.h>

struct ti_sci_clocks_info j721e_clocks_info[] = {
	{4, 0, "DEV_A72SS0_PLL_CTRL_CLK", "Input clock"},
	{4, 1, "DEV_A72SS0_MSMC_CLK", "Input clock"},
	{4, 2, "DEV_A72SS0_ARM_CLK_CLK", "Input clock"},
	{202, 2, "DEV_A72SS0_CORE0_ARM_CLK_CLK", "Input clock"},
	{203, 0, "DEV_A72SS0_CORE1_ARM_CLK_CLK", "Input clock"},
	{139, 0, "DEV_AASRC0_SYS_CLK", "Input clock"},
	{139, 1, "DEV_AASRC0_VBUSP_CLK", "Input clock"},
	{139, 2, "DEV_AASRC0_RX0_SYNC", "Input muxed clock"},
	{139, 3, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP0_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 4, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP1_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 5, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP2_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 6, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP3_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 7, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP4_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 8, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP5_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 9, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP6_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 10, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP7_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 11, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP8_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 12, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP9_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 13, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP10_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 14, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP11_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 15, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP0_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 16, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP1_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 17, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP2_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 18, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP3_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 19, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP4_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 20, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP5_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 21, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP6_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 22, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP7_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 23, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP8_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 24, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP9_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 25, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP10_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 26, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCASP11_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 27, "DEV_AASRC0_RX0_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 28, "DEV_AASRC0_RX0_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 29, "DEV_AASRC0_RX0_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 30, "DEV_AASRC0_RX0_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 31, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 32, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 33, "DEV_AASRC0_RX0_SYNC_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT3_CLK", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 34, "DEV_AASRC0_RX0_SYNC_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT3_CLK", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 35, "DEV_AASRC0_RX0_SYNC_PARENT_MCU_ADC_CLK_SEL_OUT0", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 36, "DEV_AASRC0_RX0_SYNC_PARENT_MCU_ADC_CLK_SEL_OUT1", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 37, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 38, "DEV_AASRC0_RX0_SYNC_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_AASRC0_RX0_SYNC"},
	{139, 39, "DEV_AASRC0_RX1_SYNC", "Input muxed clock"},
	{139, 40, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP0_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 41, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP1_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 42, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP2_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 43, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP3_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 44, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP4_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 45, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP5_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 46, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP6_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 47, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP7_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 48, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP8_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 49, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP9_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 50, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP10_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 51, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP11_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 52, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP0_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 53, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP1_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 54, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP2_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 55, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP3_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 56, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP4_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 57, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP5_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 58, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP6_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 59, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP7_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 60, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP8_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 61, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP9_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 62, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP10_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 63, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCASP11_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 64, "DEV_AASRC0_RX1_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 65, "DEV_AASRC0_RX1_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 66, "DEV_AASRC0_RX1_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 67, "DEV_AASRC0_RX1_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 68, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 69, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 70, "DEV_AASRC0_RX1_SYNC_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT3_CLK", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 71, "DEV_AASRC0_RX1_SYNC_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT3_CLK", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 72, "DEV_AASRC0_RX1_SYNC_PARENT_MCU_ADC_CLK_SEL_OUT0", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 73, "DEV_AASRC0_RX1_SYNC_PARENT_MCU_ADC_CLK_SEL_OUT1", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 74, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 75, "DEV_AASRC0_RX1_SYNC_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_AASRC0_RX1_SYNC"},
	{139, 76, "DEV_AASRC0_RX2_SYNC", "Input muxed clock"},
	{139, 77, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP0_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 78, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP1_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 79, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP2_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 80, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP3_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 81, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP4_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 82, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP5_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 83, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP6_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 84, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP7_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 85, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP8_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 86, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP9_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 87, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP10_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 88, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP11_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 89, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP0_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 90, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP1_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 91, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP2_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 92, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP3_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 93, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP4_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 94, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP5_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 95, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP6_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 96, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP7_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 97, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP8_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 98, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP9_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 99, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP10_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 100, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCASP11_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 101, "DEV_AASRC0_RX2_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 102, "DEV_AASRC0_RX2_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 103, "DEV_AASRC0_RX2_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 104, "DEV_AASRC0_RX2_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 105, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 106, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 107, "DEV_AASRC0_RX2_SYNC_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT3_CLK", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 108, "DEV_AASRC0_RX2_SYNC_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT3_CLK", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 109, "DEV_AASRC0_RX2_SYNC_PARENT_MCU_ADC_CLK_SEL_OUT0", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 110, "DEV_AASRC0_RX2_SYNC_PARENT_MCU_ADC_CLK_SEL_OUT1", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 111, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 112, "DEV_AASRC0_RX2_SYNC_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_AASRC0_RX2_SYNC"},
	{139, 113, "DEV_AASRC0_RX3_SYNC", "Input muxed clock"},
	{139, 114, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP0_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 115, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP1_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 116, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP2_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 117, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP3_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 118, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP4_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 119, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP5_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 120, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP6_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 121, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP7_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 122, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP8_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 123, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP9_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 124, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP10_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 125, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP11_AFSR_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 126, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP0_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 127, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP1_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 128, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP2_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 129, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP3_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 130, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP4_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 131, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP5_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 132, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP6_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 133, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP7_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 134, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP8_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 135, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP9_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 136, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP10_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 137, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCASP11_AFSX_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 138, "DEV_AASRC0_RX3_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 139, "DEV_AASRC0_RX3_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 140, "DEV_AASRC0_RX3_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 141, "DEV_AASRC0_RX3_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 142, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 143, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 144, "DEV_AASRC0_RX3_SYNC_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT3_CLK", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 145, "DEV_AASRC0_RX3_SYNC_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT3_CLK", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 146, "DEV_AASRC0_RX3_SYNC_PARENT_MCU_ADC_CLK_SEL_OUT0", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 147, "DEV_AASRC0_RX3_SYNC_PARENT_MCU_ADC_CLK_SEL_OUT1", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 148, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 149, "DEV_AASRC0_RX3_SYNC_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_AASRC0_RX3_SYNC"},
	{139, 150, "DEV_AASRC0_TX0_SYNC", "Input muxed clock"},
	{139, 151, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP0_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 152, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP1_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 153, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP2_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 154, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP3_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 155, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP4_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 156, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP5_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 157, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP6_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 158, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP7_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 159, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP8_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 160, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP9_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 161, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP10_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 162, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP11_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 163, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP0_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 164, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP1_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 165, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP2_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 166, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP3_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 167, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP4_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 168, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP5_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 169, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP6_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 170, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP7_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 171, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP8_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 172, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP9_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 173, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP10_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 174, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCASP11_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 175, "DEV_AASRC0_TX0_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 176, "DEV_AASRC0_TX0_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 177, "DEV_AASRC0_TX0_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 178, "DEV_AASRC0_TX0_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 179, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 180, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 181, "DEV_AASRC0_TX0_SYNC_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT3_CLK", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 182, "DEV_AASRC0_TX0_SYNC_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT3_CLK", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 183, "DEV_AASRC0_TX0_SYNC_PARENT_MCU_ADC_CLK_SEL_OUT0", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 184, "DEV_AASRC0_TX0_SYNC_PARENT_MCU_ADC_CLK_SEL_OUT1", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 185, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 186, "DEV_AASRC0_TX0_SYNC_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_AASRC0_TX0_SYNC"},
	{139, 187, "DEV_AASRC0_TX1_SYNC", "Input muxed clock"},
	{139, 188, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP0_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 189, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP1_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 190, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP2_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 191, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP3_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 192, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP4_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 193, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP5_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 194, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP6_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 195, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP7_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 196, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP8_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 197, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP9_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 198, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP10_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 199, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP11_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 200, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP0_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 201, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP1_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 202, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP2_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 203, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP3_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 204, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP4_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 205, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP5_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 206, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP6_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 207, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP7_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 208, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP8_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 209, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP9_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 210, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP10_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 211, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCASP11_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 212, "DEV_AASRC0_TX1_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 213, "DEV_AASRC0_TX1_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 214, "DEV_AASRC0_TX1_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 215, "DEV_AASRC0_TX1_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 216, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 217, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 218, "DEV_AASRC0_TX1_SYNC_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT3_CLK", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 219, "DEV_AASRC0_TX1_SYNC_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT3_CLK", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 220, "DEV_AASRC0_TX1_SYNC_PARENT_MCU_ADC_CLK_SEL_OUT0", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 221, "DEV_AASRC0_TX1_SYNC_PARENT_MCU_ADC_CLK_SEL_OUT1", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 222, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 223, "DEV_AASRC0_TX1_SYNC_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_AASRC0_TX1_SYNC"},
	{139, 224, "DEV_AASRC0_TX2_SYNC", "Input muxed clock"},
	{139, 225, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP0_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 226, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP1_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 227, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP2_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 228, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP3_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 229, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP4_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 230, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP5_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 231, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP6_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 232, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP7_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 233, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP8_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 234, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP9_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 235, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP10_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 236, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP11_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 237, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP0_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 238, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP1_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 239, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP2_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 240, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP3_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 241, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP4_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 242, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP5_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 243, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP6_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 244, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP7_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 245, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP8_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 246, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP9_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 247, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP10_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 248, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCASP11_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 249, "DEV_AASRC0_TX2_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 250, "DEV_AASRC0_TX2_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 251, "DEV_AASRC0_TX2_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 252, "DEV_AASRC0_TX2_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 253, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 254, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 255, "DEV_AASRC0_TX2_SYNC_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT3_CLK", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 256, "DEV_AASRC0_TX2_SYNC_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT3_CLK", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 257, "DEV_AASRC0_TX2_SYNC_PARENT_MCU_ADC_CLK_SEL_OUT0", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 258, "DEV_AASRC0_TX2_SYNC_PARENT_MCU_ADC_CLK_SEL_OUT1", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 259, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 260, "DEV_AASRC0_TX2_SYNC_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_AASRC0_TX2_SYNC"},
	{139, 261, "DEV_AASRC0_TX3_SYNC", "Input muxed clock"},
	{139, 262, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP0_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 263, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP1_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 264, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP2_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 265, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP3_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 266, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP4_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 267, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP5_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 268, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP6_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 269, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP7_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 270, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP8_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 271, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP9_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 272, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP10_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 273, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP11_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 274, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP0_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 275, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP1_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 276, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP2_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 277, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP3_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 278, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP4_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 279, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP5_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 280, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP6_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 281, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP7_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 282, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP8_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 283, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP9_AFSX_OUT", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 284, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP10_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 285, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCASP11_AFSX_OUT_DUP0", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 286, "DEV_AASRC0_TX3_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 287, "DEV_AASRC0_TX3_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 288, "DEV_AASRC0_TX3_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 289, "DEV_AASRC0_TX3_SYNC_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 290, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 291, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 292, "DEV_AASRC0_TX3_SYNC_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT3_CLK", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 293, "DEV_AASRC0_TX3_SYNC_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT3_CLK", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 294, "DEV_AASRC0_TX3_SYNC_PARENT_MCU_ADC_CLK_SEL_OUT0", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 295, "DEV_AASRC0_TX3_SYNC_PARENT_MCU_ADC_CLK_SEL_OUT1", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 296, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{139, 297, "DEV_AASRC0_TX3_SYNC_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_AASRC0_TX3_SYNC"},
	{337, 0, "DEV_ASCPCIE_BUFFER0_CLKIN0", "Input muxed clock"},
	{337, 1, "DEV_ASCPCIE_BUFFER0_CLKIN0_PARENT_WIZ16B4M4CS_MAIN_0_REF_DER_OUT_CLK", "Parent input clock option to DEV_ASCPCIE_BUFFER0_CLKIN0"},
	{337, 2, "DEV_ASCPCIE_BUFFER0_CLKIN0_PARENT_WIZ16B4M4CS_MAIN_1_REF_DER_OUT_CLK", "Parent input clock option to DEV_ASCPCIE_BUFFER0_CLKIN0"},
	{337, 3, "DEV_ASCPCIE_BUFFER0_CLKIN0_PARENT_WIZ16B4M4CS_MAIN_0_REF1_OUT_CLK", "Parent input clock option to DEV_ASCPCIE_BUFFER0_CLKIN0"},
	{337, 4, "DEV_ASCPCIE_BUFFER0_CLKIN0_PARENT_WIZ16B4M4CS_MAIN_1_REF1_OUT_CLK", "Parent input clock option to DEV_ASCPCIE_BUFFER0_CLKIN0"},
	{337, 5, "DEV_ASCPCIE_BUFFER0_CLKIN1", "Input muxed clock"},
	{337, 6, "DEV_ASCPCIE_BUFFER0_CLKIN1_PARENT_WIZ16B4M4CS_MAIN_0_REF_DER_OUT_CLK", "Parent input clock option to DEV_ASCPCIE_BUFFER0_CLKIN1"},
	{337, 7, "DEV_ASCPCIE_BUFFER0_CLKIN1_PARENT_WIZ16B4M4CS_MAIN_1_REF_DER_OUT_CLK", "Parent input clock option to DEV_ASCPCIE_BUFFER0_CLKIN1"},
	{337, 8, "DEV_ASCPCIE_BUFFER0_CLKIN1_PARENT_WIZ16B4M4CS_MAIN_0_REF1_OUT_CLK", "Parent input clock option to DEV_ASCPCIE_BUFFER0_CLKIN1"},
	{337, 9, "DEV_ASCPCIE_BUFFER0_CLKIN1_PARENT_WIZ16B4M4CS_MAIN_1_REF1_OUT_CLK", "Parent input clock option to DEV_ASCPCIE_BUFFER0_CLKIN1"},
	{337, 10, "DEV_ASCPCIE_BUFFER0_CLKOUT0_N", "Output clock"},
	{337, 11, "DEV_ASCPCIE_BUFFER0_CLKOUT0_P", "Output clock"},
	{337, 12, "DEV_ASCPCIE_BUFFER0_CLKOUT1_N", "Output clock"},
	{337, 13, "DEV_ASCPCIE_BUFFER0_CLKOUT1_P", "Output clock"},
	{338, 0, "DEV_ASCPCIE_BUFFER1_CLKIN0", "Input muxed clock"},
	{338, 1, "DEV_ASCPCIE_BUFFER1_CLKIN0_PARENT_WIZ16B4M4CS_MAIN_2_REF_DER_OUT_CLK", "Parent input clock option to DEV_ASCPCIE_BUFFER1_CLKIN0"},
	{338, 2, "DEV_ASCPCIE_BUFFER1_CLKIN0_PARENT_WIZ16B4M4CS_MAIN_3_REF_DER_OUT_CLK", "Parent input clock option to DEV_ASCPCIE_BUFFER1_CLKIN0"},
	{338, 3, "DEV_ASCPCIE_BUFFER1_CLKIN0_PARENT_WIZ16B4M4CS_MAIN_2_REF1_OUT_CLK", "Parent input clock option to DEV_ASCPCIE_BUFFER1_CLKIN0"},
	{338, 4, "DEV_ASCPCIE_BUFFER1_CLKIN0_PARENT_WIZ16B4M4CS_MAIN_3_REF1_OUT_CLK", "Parent input clock option to DEV_ASCPCIE_BUFFER1_CLKIN0"},
	{338, 5, "DEV_ASCPCIE_BUFFER1_CLKIN1", "Input muxed clock"},
	{338, 6, "DEV_ASCPCIE_BUFFER1_CLKIN1_PARENT_WIZ16B4M4CS_MAIN_2_REF_DER_OUT_CLK", "Parent input clock option to DEV_ASCPCIE_BUFFER1_CLKIN1"},
	{338, 7, "DEV_ASCPCIE_BUFFER1_CLKIN1_PARENT_WIZ16B4M4CS_MAIN_3_REF_DER_OUT_CLK", "Parent input clock option to DEV_ASCPCIE_BUFFER1_CLKIN1"},
	{338, 8, "DEV_ASCPCIE_BUFFER1_CLKIN1_PARENT_WIZ16B4M4CS_MAIN_2_REF1_OUT_CLK", "Parent input clock option to DEV_ASCPCIE_BUFFER1_CLKIN1"},
	{338, 9, "DEV_ASCPCIE_BUFFER1_CLKIN1_PARENT_WIZ16B4M4CS_MAIN_3_REF1_OUT_CLK", "Parent input clock option to DEV_ASCPCIE_BUFFER1_CLKIN1"},
	{338, 10, "DEV_ASCPCIE_BUFFER1_CLKOUT0_N", "Output clock"},
	{338, 11, "DEV_ASCPCIE_BUFFER1_CLKOUT0_P", "Output clock"},
	{338, 12, "DEV_ASCPCIE_BUFFER1_CLKOUT1_N", "Output clock"},
	{338, 13, "DEV_ASCPCIE_BUFFER1_CLKOUT1_P", "Output clock"},
	{2, 0, "DEV_ATL0_VBUS_CLK", "Input clock"},
	{2, 1, "DEV_ATL0_ATL_CLK", "Input muxed clock"},
	{2, 2, "DEV_ATL0_ATL_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT1_CLK", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 3, "DEV_ATL0_ATL_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 4, "DEV_ATL0_ATL_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT1_CLK", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 5, "DEV_ATL0_ATL_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 6, "DEV_ATL0_ATL_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 7, "DEV_ATL0_ATL_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 8, "DEV_ATL0_ATL_IO_PORT_ATCLK_OUT_1", "Output clock"},
	{2, 9, "DEV_ATL0_ATL_IO_PORT_ATCLK_OUT", "Output clock"},
	{2, 10, "DEV_ATL0_ATL_IO_PORT_ATCLK_OUT_3", "Output clock"},
	{2, 11, "DEV_ATL0_ATL_IO_PORT_ATCLK_OUT_2", "Output clock"},
	{157, 0, "DEV_BOARD0_SPI0_CLK_IN", "Input clock"},
	{157, 2, "DEV_BOARD0_SPI1_CLK_IN", "Input clock"},
	{157, 4, "DEV_BOARD0_SPI2_CLK_IN", "Input clock"},
	{157, 6, "DEV_BOARD0_SPI3_CLK_IN", "Input clock"},
	{157, 8, "DEV_BOARD0_SPI5_CLK_IN", "Input clock"},
	{157, 10, "DEV_BOARD0_SPI6_CLK_IN", "Input clock"},
	{157, 12, "DEV_BOARD0_SPI7_CLK_IN", "Input clock"},
	{157, 14, "DEV_BOARD0_MCU_SPI0_CLK_IN", "Input clock"},
	{157, 16, "DEV_BOARD0_MCU_SPI1_CLK_IN", "Input clock"},
	{157, 18, "DEV_BOARD0_MCU_OSPI0_CLK_IN", "Input clock"},
	{157, 19, "DEV_BOARD0_MCU_OSPI0_LBCLKO_IN", "Input clock"},
	{157, 20, "DEV_BOARD0_MCU_OSPI0_DQS_OUT", "Output clock"},
	{157, 21, "DEV_BOARD0_MCU_OSPI1_CLK_IN", "Input clock"},
	{157, 22, "DEV_BOARD0_MCU_OSPI1_LBCLKO_IN", "Input clock"},
	{157, 23, "DEV_BOARD0_MCU_OSPI1_DQS_OUT", "Output clock"},
	{157, 25, "DEV_BOARD0_I2C0_SCL_OUT", "Output clock"},
	{157, 27, "DEV_BOARD0_I2C1_SCL_OUT", "Output clock"},
	{157, 29, "DEV_BOARD0_I2C2_SCL_OUT", "Output clock"},
	{157, 31, "DEV_BOARD0_I2C3_SCL_OUT", "Output clock"},
	{157, 33, "DEV_BOARD0_I2C4_SCL_OUT", "Output clock"},
	{157, 35, "DEV_BOARD0_I2C5_SCL_OUT", "Output clock"},
	{157, 37, "DEV_BOARD0_I2C6_SCL_OUT", "Output clock"},
	{157, 38, "DEV_BOARD0_MCU_I2C0_SCL_IN", "Input clock"},
	{157, 39, "DEV_BOARD0_MCU_I2C0_SCL_OUT", "Output clock"},
	{157, 41, "DEV_BOARD0_MCU_I2C1_SCL_OUT", "Output clock"},
	{157, 42, "DEV_BOARD0_WKUP_I2C0_SCL_IN", "Input clock"},
	{157, 43, "DEV_BOARD0_WKUP_I2C0_SCL_OUT", "Output clock"},
	{157, 44, "DEV_BOARD0_I3C0_SCL_IN", "Input clock"},
	{157, 45, "DEV_BOARD0_I3C0_SCL_OUT", "Output clock"},
	{157, 46, "DEV_BOARD0_MCU_I3C0_SCL_IN", "Input clock"},
	{157, 47, "DEV_BOARD0_MCU_I3C0_SCL_OUT", "Output clock"},
	{157, 48, "DEV_BOARD0_MCU_I3C1_SCL_IN", "Input clock"},
	{157, 49, "DEV_BOARD0_MCU_I3C1_SCL_OUT", "Output clock"},
	{157, 50, "DEV_BOARD0_MCU_HYPERBUS0_CK_IN", "Input clock"},
	{157, 51, "DEV_BOARD0_MCU_HYPERBUS0_CKN_IN", "Input clock"},
	{157, 52, "DEV_BOARD0_DSI_TXCLKP_IN", "Input clock"},
	{157, 53, "DEV_BOARD0_DSI_TXCLKN_IN", "Input clock"},
	{157, 54, "DEV_BOARD0_PRG0_MDIO0_MDC_IN", "Input clock"},
	{157, 55, "DEV_BOARD0_PRG0_RGMII1_TXC_IN", "Input clock"},
	{157, 56, "DEV_BOARD0_PRG0_RGMII1_TXC_OUT", "Output clock"},
	{157, 57, "DEV_BOARD0_PRG0_RGMII1_RXC_OUT", "Output clock"},
	{157, 58, "DEV_BOARD0_PRG0_RGMII2_TXC_IN", "Input clock"},
	{157, 59, "DEV_BOARD0_PRG0_RGMII2_TXC_OUT", "Output clock"},
	{157, 60, "DEV_BOARD0_PRG0_RGMII2_RXC_OUT", "Output clock"},
	{157, 61, "DEV_BOARD0_PRG1_MDIO0_MDC_IN", "Input clock"},
	{157, 62, "DEV_BOARD0_PRG1_RGMII1_TXC_IN", "Input clock"},
	{157, 63, "DEV_BOARD0_PRG1_RGMII1_TXC_OUT", "Output clock"},
	{157, 64, "DEV_BOARD0_PRG1_RGMII1_RXC_OUT", "Output clock"},
	{157, 65, "DEV_BOARD0_PRG1_RGMII2_TXC_IN", "Input clock"},
	{157, 66, "DEV_BOARD0_PRG1_RGMII2_TXC_OUT", "Output clock"},
	{157, 67, "DEV_BOARD0_PRG1_RGMII2_RXC_OUT", "Output clock"},
	{157, 68, "DEV_BOARD0_MDIO0_MDC_IN", "Input clock"},
	{157, 70, "DEV_BOARD0_RGMII3_RXC_OUT", "Output clock"},
	{157, 72, "DEV_BOARD0_RGMII4_RXC_OUT", "Output clock"},
	{157, 74, "DEV_BOARD0_RGMII5_RXC_OUT", "Output clock"},
	{157, 76, "DEV_BOARD0_RGMII6_RXC_OUT", "Output clock"},
	{157, 78, "DEV_BOARD0_RGMII7_RXC_OUT", "Output clock"},
	{157, 80, "DEV_BOARD0_RGMII8_RXC_OUT", "Output clock"},
	{157, 81, "DEV_BOARD0_RMII_REF_CLK_OUT", "Output clock"},
	{157, 82, "DEV_BOARD0_CPTS0_RFT_CLK_OUT", "Output clock"},
	{157, 83, "DEV_BOARD0_MCU_MDIO0_MDC_IN", "Input clock"},
	{157, 84, "DEV_BOARD0_MCU_RGMII1_TXC_IN", "Input clock"},
	{157, 85, "DEV_BOARD0_MCU_RGMII1_TXC_OUT", "Output clock"},
	{157, 86, "DEV_BOARD0_MCU_RGMII1_RXC_OUT", "Output clock"},
	{157, 87, "DEV_BOARD0_MCU_RMII1_REF_CLK_OUT", "Output clock"},
	{157, 88, "DEV_BOARD0_MCU_CPTS0_RFT_CLK_OUT", "Output clock"},
	{157, 89, "DEV_BOARD0_UFS0_REF_CLK_IN", "Input clock"},
	{157, 91, "DEV_BOARD0_DDR0_CK0_IN", "Input clock"},
	{157, 92, "DEV_BOARD0_DDR0_CK0_N_IN", "Input clock"},
	{157, 99, "DEV_BOARD0_MMC0_CLK_IN", "Input clock"},
	{157, 100, "DEV_BOARD0_MMC1_CLK_IN", "Input clock"},
	{157, 101, "DEV_BOARD0_MMC2_CLK_IN", "Input clock"},
	{157, 102, "DEV_BOARD0_GPMC0_CLK_IN", "Input clock"},
	{157, 103, "DEV_BOARD0_GPMC0_CLK_OUT", "Output clock"},
	{157, 104, "DEV_BOARD0_GPMC0_FCLK_MUX_IN", "Input clock"},
	{157, 105, "DEV_BOARD0_MLB0_MLBCLK_OUT", "Output clock"},
	{157, 106, "DEV_BOARD0_MLB0_MLBCP_OUT", "Output clock"},
	{157, 108, "DEV_BOARD0_VPFE0_PCLK_OUT", "Output clock"},
	{157, 109, "DEV_BOARD0_VOUT1_PCLK_IN", "Input clock"},
	{157, 110, "DEV_BOARD0_VOUT1_EXTPCLKIN_OUT", "Output clock"},
	{157, 111, "DEV_BOARD0_VOUT2_PCLK_IN", "Input clock"},
	{157, 112, "DEV_BOARD0_VOUT2_EXTPCLKIN_OUT", "Output clock"},
	{157, 113, "DEV_BOARD0_OBSCLK0_IN", "Input clock"},
	{157, 114, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 115, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 116, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 117, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 118, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 119, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV3_16FFT_MAIN_5_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 120, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV0_16FFT_MAIN_6_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 126, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV0_16FFT_MAIN_12_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 127, "DEV_BOARD0_OBSCLK0_IN_PARENT_OBSCLK1_MUX_OUT0", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 128, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_14_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 129, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 130, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 131, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_17_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 132, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_18_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 133, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_19_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 137, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_23_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 138, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV0_16FFT_MAIN_24_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 139, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_25_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 140, "DEV_BOARD0_OBSCLK0_IN_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 141, "DEV_BOARD0_OBSCLK0_IN_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 142, "DEV_BOARD0_OBSCLK0_IN_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 143, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT0_CLK_DUP0", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 144, "DEV_BOARD0_OBSCLK0_IN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 145, "DEV_BOARD0_OBSCLK0_IN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 146, "DEV_BOARD0_OBSCLK1_IN", "Input muxed clock"},
	{157, 147, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV0_16FFT_MAIN_7_HSDIVOUT0_CLK4", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 148, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV0_16FFT_MAIN_8_HSDIVOUT0_CLK8", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 149, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV3_16FFT_MAIN_13_HSDIVOUT0_CLK4", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 152, "DEV_BOARD0_MCU_OBSCLK0_IN", "Input muxed clock"},
	{157, 153, "DEV_BOARD0_MCU_OBSCLK0_IN_PARENT_MCU_OBSCLK_DIV_OUT0", "Parent input clock option to DEV_BOARD0_MCU_OBSCLK0_IN"},
	{157, 154, "DEV_BOARD0_MCU_OBSCLK0_IN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_BOARD0_MCU_OBSCLK0_IN"},
	{157, 169, "DEV_BOARD0_SYSCLKOUT0_IN", "Input clock"},
	{157, 170, "DEV_BOARD0_MCU_SYSCLKOUT0_IN", "Input clock"},
	{157, 171, "DEV_BOARD0_TRC_CLK_IN", "Input clock"},
	{157, 172, "DEV_BOARD0_CLKOUT_IN", "Input muxed clock"},
	{157, 173, "DEV_BOARD0_CLKOUT_IN_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT0_CLK5", "Parent input clock option to DEV_BOARD0_CLKOUT_IN"},
	{157, 174, "DEV_BOARD0_CLKOUT_IN_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT0_CLK10", "Parent input clock option to DEV_BOARD0_CLKOUT_IN"},
	{157, 175, "DEV_BOARD0_MCU_CLKOUT0_IN", "Input muxed clock"},
	{157, 176, "DEV_BOARD0_MCU_CLKOUT0_IN_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT0_CLK5", "Parent input clock option to DEV_BOARD0_MCU_CLKOUT0_IN"},
	{157, 177, "DEV_BOARD0_MCU_CLKOUT0_IN_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT0_CLK10", "Parent input clock option to DEV_BOARD0_MCU_CLKOUT0_IN"},
	{157, 178, "DEV_BOARD0_LED_CLK_OUT", "Output clock"},
	{157, 179, "DEV_BOARD0_EXT_REFCLK1_OUT", "Output clock"},
	{157, 180, "DEV_BOARD0_MCU_EXT_REFCLK0_OUT", "Output clock"},
	{157, 181, "DEV_BOARD0_HFOSC1_CLK_OUT", "Output clock"},
	{157, 182, "DEV_BOARD0_TCK_OUT", "Output clock"},
	{157, 183, "DEV_BOARD0_PCIE_REFCLK0P_IN", "Input clock"},
	{157, 184, "DEV_BOARD0_PCIE_REFCLK0N_IN", "Input clock"},
	{157, 185, "DEV_BOARD0_PCIE_REFCLK0P_OUT", "Output clock"},
	{157, 186, "DEV_BOARD0_PCIE_REFCLK0N_OUT", "Output clock"},
	{157, 187, "DEV_BOARD0_PCIE_REFCLK0P_OUT_IN", "Input clock"},
	{157, 188, "DEV_BOARD0_PCIE_REFCLK0N_OUT_IN", "Input clock"},
	{157, 189, "DEV_BOARD0_PCIE_REFCLK1P_IN", "Input clock"},
	{157, 190, "DEV_BOARD0_PCIE_REFCLK1N_IN", "Input clock"},
	{157, 191, "DEV_BOARD0_PCIE_REFCLK1P_OUT", "Output clock"},
	{157, 192, "DEV_BOARD0_PCIE_REFCLK1N_OUT", "Output clock"},
	{157, 193, "DEV_BOARD0_PCIE_REFCLK1P_OUT_IN", "Input clock"},
	{157, 194, "DEV_BOARD0_PCIE_REFCLK1N_OUT_IN", "Input clock"},
	{157, 195, "DEV_BOARD0_PCIE_REFCLK2P_IN", "Input clock"},
	{157, 196, "DEV_BOARD0_PCIE_REFCLK2N_IN", "Input clock"},
	{157, 197, "DEV_BOARD0_PCIE_REFCLK2P_OUT", "Output clock"},
	{157, 198, "DEV_BOARD0_PCIE_REFCLK2N_OUT", "Output clock"},
	{157, 201, "DEV_BOARD0_PCIE_REFCLK3P_OUT", "Output clock"},
	{157, 202, "DEV_BOARD0_PCIE_REFCLK3N_OUT", "Output clock"},
	{157, 203, "DEV_BOARD0_PCIE_REFCLK3P_IN", "Input clock"},
	{157, 204, "DEV_BOARD0_PCIE_REFCLK3N_IN", "Input clock"},
	{157, 217, "DEV_BOARD0_MCASP0_ACLKR_IN", "Input clock"},
	{157, 218, "DEV_BOARD0_MCASP0_ACLKR_OUT", "Output clock"},
	{157, 219, "DEV_BOARD0_MCASP0_AFSR_OUT", "Output clock"},
	{157, 220, "DEV_BOARD0_MCASP0_ACLKX_IN", "Input clock"},
	{157, 221, "DEV_BOARD0_MCASP0_ACLKX_OUT", "Output clock"},
	{157, 222, "DEV_BOARD0_MCASP0_AFSX_OUT", "Output clock"},
	{157, 223, "DEV_BOARD0_MCASP1_ACLKR_IN", "Input clock"},
	{157, 224, "DEV_BOARD0_MCASP1_ACLKR_OUT", "Output clock"},
	{157, 225, "DEV_BOARD0_MCASP1_AFSR_OUT", "Output clock"},
	{157, 226, "DEV_BOARD0_MCASP1_ACLKX_IN", "Input clock"},
	{157, 227, "DEV_BOARD0_MCASP1_ACLKX_OUT", "Output clock"},
	{157, 228, "DEV_BOARD0_MCASP1_AFSX_OUT", "Output clock"},
	{157, 229, "DEV_BOARD0_MCASP2_ACLKR_IN", "Input clock"},
	{157, 230, "DEV_BOARD0_MCASP2_ACLKR_OUT", "Output clock"},
	{157, 231, "DEV_BOARD0_MCASP2_AFSR_OUT", "Output clock"},
	{157, 232, "DEV_BOARD0_MCASP2_ACLKX_IN", "Input clock"},
	{157, 233, "DEV_BOARD0_MCASP2_ACLKX_OUT", "Output clock"},
	{157, 234, "DEV_BOARD0_MCASP2_AFSX_OUT", "Output clock"},
	{157, 235, "DEV_BOARD0_MCASP3_ACLKR_IN", "Input clock"},
	{157, 236, "DEV_BOARD0_MCASP3_ACLKR_OUT", "Output clock"},
	{157, 237, "DEV_BOARD0_MCASP3_AFSR_OUT", "Output clock"},
	{157, 238, "DEV_BOARD0_MCASP3_ACLKX_IN", "Input clock"},
	{157, 239, "DEV_BOARD0_MCASP3_ACLKX_OUT", "Output clock"},
	{157, 240, "DEV_BOARD0_MCASP3_AFSX_OUT", "Output clock"},
	{157, 241, "DEV_BOARD0_MCASP4_ACLKR_IN", "Input clock"},
	{157, 242, "DEV_BOARD0_MCASP4_ACLKR_OUT", "Output clock"},
	{157, 243, "DEV_BOARD0_MCASP4_AFSR_OUT", "Output clock"},
	{157, 244, "DEV_BOARD0_MCASP4_ACLKX_IN", "Input clock"},
	{157, 245, "DEV_BOARD0_MCASP4_ACLKX_OUT", "Output clock"},
	{157, 246, "DEV_BOARD0_MCASP4_AFSX_OUT", "Output clock"},
	{157, 247, "DEV_BOARD0_MCASP5_ACLKR_IN", "Input clock"},
	{157, 248, "DEV_BOARD0_MCASP5_ACLKR_OUT", "Output clock"},
	{157, 249, "DEV_BOARD0_MCASP5_AFSR_OUT", "Output clock"},
	{157, 250, "DEV_BOARD0_MCASP5_ACLKX_IN", "Input clock"},
	{157, 251, "DEV_BOARD0_MCASP5_ACLKX_OUT", "Output clock"},
	{157, 252, "DEV_BOARD0_MCASP5_AFSX_OUT", "Output clock"},
	{157, 253, "DEV_BOARD0_MCASP6_ACLKR_IN", "Input clock"},
	{157, 254, "DEV_BOARD0_MCASP6_ACLKR_OUT", "Output clock"},
	{157, 255, "DEV_BOARD0_MCASP6_AFSR_OUT", "Output clock"},
	{157, 256, "DEV_BOARD0_MCASP6_ACLKX_IN", "Input clock"},
	{157, 257, "DEV_BOARD0_MCASP6_ACLKX_OUT", "Output clock"},
	{157, 258, "DEV_BOARD0_MCASP6_AFSX_OUT", "Output clock"},
	{157, 259, "DEV_BOARD0_MCASP7_ACLKR_IN", "Input clock"},
	{157, 260, "DEV_BOARD0_MCASP7_ACLKR_OUT", "Output clock"},
	{157, 261, "DEV_BOARD0_MCASP7_AFSR_OUT", "Output clock"},
	{157, 262, "DEV_BOARD0_MCASP7_ACLKX_IN", "Input clock"},
	{157, 263, "DEV_BOARD0_MCASP7_ACLKX_OUT", "Output clock"},
	{157, 264, "DEV_BOARD0_MCASP7_AFSX_OUT", "Output clock"},
	{157, 265, "DEV_BOARD0_MCASP8_ACLKR_IN", "Input clock"},
	{157, 267, "DEV_BOARD0_MCASP8_ACLKR_OUT", "Output clock"},
	{157, 268, "DEV_BOARD0_MCASP8_AFSR_OUT", "Output clock"},
	{157, 269, "DEV_BOARD0_MCASP8_ACLKX_IN", "Input clock"},
	{157, 270, "DEV_BOARD0_MCASP8_ACLKX_OUT", "Output clock"},
	{157, 271, "DEV_BOARD0_MCASP8_AFSX_OUT", "Output clock"},
	{157, 272, "DEV_BOARD0_MCASP9_ACLKR_IN", "Input clock"},
	{157, 273, "DEV_BOARD0_MCASP9_ACLKR_OUT", "Output clock"},
	{157, 274, "DEV_BOARD0_MCASP9_AFSR_OUT", "Output clock"},
	{157, 275, "DEV_BOARD0_MCASP9_ACLKX_IN", "Input clock"},
	{157, 276, "DEV_BOARD0_MCASP9_ACLKX_OUT", "Output clock"},
	{157, 278, "DEV_BOARD0_MCASP9_AFSX_OUT", "Output clock"},
	{157, 279, "DEV_BOARD0_MCASP10_ACLKR_IN", "Input clock"},
	{157, 280, "DEV_BOARD0_MCASP10_ACLKR_OUT", "Output clock"},
	{157, 281, "DEV_BOARD0_MCASP10_AFSR_OUT", "Output clock"},
	{157, 282, "DEV_BOARD0_MCASP10_ACLKX_IN", "Input clock"},
	{157, 283, "DEV_BOARD0_MCASP10_ACLKX_OUT", "Output clock"},
	{157, 284, "DEV_BOARD0_MCASP10_AFSX_OUT", "Output clock"},
	{157, 285, "DEV_BOARD0_MCASP11_ACLKR_IN", "Input clock"},
	{157, 286, "DEV_BOARD0_MCASP11_ACLKR_OUT", "Output clock"},
	{157, 287, "DEV_BOARD0_MCASP11_AFSR_OUT", "Output clock"},
	{157, 288, "DEV_BOARD0_MCASP11_ACLKX_IN", "Input clock"},
	{157, 289, "DEV_BOARD0_MCASP11_ACLKX_OUT", "Output clock"},
	{157, 290, "DEV_BOARD0_MCASP11_AFSX_OUT", "Output clock"},
	{157, 300, "DEV_BOARD0_AUDIO_EXT_REFCLK0_OUT", "Output clock"},
	{157, 301, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN", "Input muxed clock"},
	{157, 302, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 303, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 304, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 305, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_3_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 306, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_4_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 307, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_5_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 308, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_6_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 309, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_7_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 310, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_8_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 311, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_9_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 312, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_10_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 313, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_11_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 314, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 315, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 316, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 317, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_3_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 318, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_4_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 319, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_5_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 320, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_6_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 321, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_7_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 322, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_8_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 323, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_9_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 324, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_10_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 325, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_11_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 326, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 327, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 328, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 329, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 330, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 331, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 334, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 335, "DEV_BOARD0_AUDIO_EXT_REFCLK1_OUT", "Output clock"},
	{157, 336, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN", "Input muxed clock"},
	{157, 337, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 338, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 339, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 340, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_3_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 341, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_4_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 342, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_5_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 343, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_6_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 344, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_7_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 345, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_8_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 346, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_9_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 347, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_10_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 348, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_11_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 349, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 350, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 351, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 352, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_3_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 353, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_4_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 354, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_5_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 355, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_6_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 356, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_7_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 357, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_8_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 358, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_9_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 359, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_10_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 360, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_11_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 361, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 362, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 363, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 364, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 365, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 366, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 369, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 370, "DEV_BOARD0_AUDIO_EXT_REFCLK2_OUT", "Output clock"},
	{157, 371, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN", "Input muxed clock"},
	{157, 372, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 373, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 374, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 375, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_3_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 376, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_4_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 377, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_5_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 378, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_6_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 379, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_7_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 380, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_8_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 381, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_9_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 382, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_10_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 383, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_11_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 384, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 385, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 386, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 387, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_3_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 388, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_4_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 389, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_5_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 390, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_6_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 391, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_7_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 392, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_8_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 393, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_9_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 394, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_10_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 395, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_MCASP_MAIN_11_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 396, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 397, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 398, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 399, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 400, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 401, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 404, "DEV_BOARD0_AUDIO_EXT_REFCLK2_IN_PARENT_BOARD_0_AUDIO_EXT_REFCLK2_OUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK2_IN"},
	{157, 405, "DEV_BOARD0_AUDIO_EXT_REFCLK3_OUT", "Output clock"},
	{157, 406, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN", "Input muxed clock"},
	{157, 407, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 408, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 409, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 410, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_3_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 411, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_4_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 412, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_5_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 413, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_6_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 414, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_7_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 415, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_8_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 416, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_9_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 417, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_10_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 418, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_11_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 419, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 420, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 421, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 422, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_3_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 423, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_4_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 424, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_5_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 425, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_6_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 426, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_7_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 427, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_8_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 428, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_9_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 429, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_10_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 430, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_MCASP_MAIN_11_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 431, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 432, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 433, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 434, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 435, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 436, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{157, 439, "DEV_BOARD0_AUDIO_EXT_REFCLK3_IN_PARENT_BOARD_0_AUDIO_EXT_REFCLK3_OUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK3_IN"},
	{142, 0, "DEV_C66SS0_CORE0_GEM_TRC_CLK", "Input clock"},
	{142, 1, "DEV_C66SS0_CORE0_GEM_CLK2_OUT_CLK", "Output clock"},
	{142, 4, "DEV_C66SS0_CORE0_GEM_PBIST_ROM_CLK", "Output clock"},
	{142, 6, "DEV_C66SS0_CORE0_GEM_CLKIN_CLK", "Input clock"},
	{121, 0, "DEV_C66SS0_INTROUTER0_INTR_CLK", "Input clock"},
	{143, 0, "DEV_C66SS1_CORE0_GEM_TRC_CLK", "Input clock"},
	{143, 1, "DEV_C66SS1_CORE0_GEM_CLK2_OUT_CLK", "Output clock"},
	{143, 4, "DEV_C66SS1_CORE0_GEM_PBIST_ROM_CLK", "Output clock"},
	{143, 6, "DEV_C66SS1_CORE0_GEM_CLKIN_CLK", "Input clock"},
	{122, 0, "DEV_C66SS1_INTROUTER0_INTR_CLK", "Input clock"},
	{15, 0, "DEV_C71SS0_C7X_CLK", "Input clock"},
	{15, 1, "DEV_C71SS0_PLL_CTRL_CLK", "Input clock"},
	{16, 0, "DEV_C71SS0_MMA_PLL_CTRL_CLK", "Input clock"},
	{16, 1, "DEV_C71SS0_MMA_MMA_CLK", "Input clock"},
	{123, 0, "DEV_CMPEVENT_INTRTR0_INTR_CLK", "Input clock"},
	{5, 0, "DEV_COMPUTE_CLUSTER0_CFG_WRAP_CLK4_CLK", "Input clock"},
	{6, 0, "DEV_COMPUTE_CLUSTER0_CLEC_CLK4_CLK", "Input clock"},
	{6, 1, "DEV_COMPUTE_CLUSTER0_CLEC_CLK1_CLK", "Input clock"},
	{7, 0, "DEV_COMPUTE_CLUSTER0_CORE_CORE_PSIL_LEAF_CLK", "Input clock"},
	{7, 1, "DEV_COMPUTE_CLUSTER0_CORE_CORE_CLK1_CLK", "Input clock"},
	{8, 0, "DEV_COMPUTE_CLUSTER0_DDR32SS_EMIF0_EW_PLL_CTRL_CLK", "Input clock"},
	{8, 1, "DEV_COMPUTE_CLUSTER0_DDR32SS_EMIF0_EW_DDRSS_DDR_PLL_CLK", "Input clock"},
	{9, 0, "DEV_COMPUTE_CLUSTER0_DEBUG_WRAP_CLK1_CLK_CLK", "Input clock"},
	{9, 1, "DEV_COMPUTE_CLUSTER0_DEBUG_WRAP_CLK2_CLK_CLK", "Input clock"},
	{12, 0, "DEV_COMPUTE_CLUSTER0_DMSC_WRAP_CLK4_CLK_CLK", "Input clock"},
	{13, 0, "DEV_COMPUTE_CLUSTER0_EN_MSMC_DOMAIN_MSMC_CLK1_CLK", "Input clock"},
	{14, 0, "DEV_COMPUTE_CLUSTER0_GIC500SS_VCLK_CLK", "Input clock"},
	{17, 0, "DEV_COMPUTE_CLUSTER0_PBIST_WRAP_DIVP_CLK1_CLK_CLK", "Input clock"},
	{17, 1, "DEV_COMPUTE_CLUSTER0_PBIST_WRAP_DIVH_CLK4_CLK_CLK", "Input clock"},
	{17, 2, "DEV_COMPUTE_CLUSTER0_PBIST_WRAP_DIVH_CLK2_CLK_CLK", "Input clock"},
	{19, 0, "DEV_CPSW0_GMII3_MT_CLK", "Input clock"},
	{19, 1, "DEV_CPSW0_SERDES6_TXFCLK", "Input clock"},
	{19, 2, "DEV_CPSW0_SERDES8_TXMCLK", "Input clock"},
	{19, 3, "DEV_CPSW0_GMII2_MR_CLK", "Input clock"},
	{19, 4, "DEV_CPSW0_SERDES2_TXFCLK", "Input clock"},
	{19, 5, "DEV_CPSW0_SERDES4_RXCLK", "Input clock"},
	{19, 6, "DEV_CPSW0_SERDES7_TXMCLK", "Input clock"},
	{19, 7, "DEV_CPSW0_SERDES7_RXCLK", "Input clock"},
	{19, 8, "DEV_CPSW0_SERDES6_REFCLK", "Input clock"},
	{19, 9, "DEV_CPSW0_SERDES5_TXFCLK", "Input clock"},
	{19, 10, "DEV_CPSW0_SERDES5_RXCLK", "Input clock"},
	{19, 11, "DEV_CPSW0_GMII4_MT_CLK", "Input clock"},
	{19, 12, "DEV_CPSW0_SERDES3_TXFCLK", "Input clock"},
	{19, 13, "DEV_CPSW0_SERDES2_REFCLK", "Input clock"},
	{19, 14, "DEV_CPSW0_SERDES4_RXFCLK", "Input clock"},
	{19, 15, "DEV_CPSW0_SERDES6_RXFCLK", "Input clock"},
	{19, 16, "DEV_CPSW0_CPTS_RFT_CLK", "Input muxed clock"},
	{19, 17, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 18, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 19, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 20, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 21, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 22, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 23, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 24, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 25, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 26, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 27, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN0_TXMCLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 28, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN1_TXMCLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 29, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B4M4CS_MAIN_3_IP2_LN0_TXMCLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 30, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B4M4CS_MAIN_3_IP2_LN1_TXMCLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 31, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 32, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 33, "DEV_CPSW0_SERDES5_RXFCLK", "Input clock"},
	{19, 34, "DEV_CPSW0_SERDES5_TXMCLK", "Input clock"},
	{19, 35, "DEV_CPSW0_GMII5_MT_CLK", "Input clock"},
	{19, 36, "DEV_CPSW0_SERDES2_RXCLK", "Input clock"},
	{19, 37, "DEV_CPSW0_SERDES8_RXFCLK", "Input clock"},
	{19, 38, "DEV_CPSW0_SERDES1_RXFCLK", "Input clock"},
	{19, 39, "DEV_CPSW0_SERDES8_RXCLK", "Input clock"},
	{19, 40, "DEV_CPSW0_GMII_RFT_CLK", "Input clock"},
	{19, 41, "DEV_CPSW0_SERDES3_REFCLK", "Input clock"},
	{19, 42, "DEV_CPSW0_RGMII_MHZ_250_CLK", "Input clock"},
	{19, 43, "DEV_CPSW0_SERDES7_REFCLK", "Input clock"},
	{19, 44, "DEV_CPSW0_GMII6_MT_CLK", "Input clock"},
	{19, 45, "DEV_CPSW0_SERDES6_TXMCLK", "Input clock"},
	{19, 46, "DEV_CPSW0_RMII_MHZ_50_CLK", "Input clock"},
	{19, 47, "DEV_CPSW0_GMII4_MR_CLK", "Input clock"},
	{19, 48, "DEV_CPSW0_SERDES2_TXMCLK", "Input clock"},
	{19, 49, "DEV_CPSW0_RGMII_MHZ_50_CLK", "Input clock"},
	{19, 50, "DEV_CPSW0_SERDES4_TXMCLK", "Input clock"},
	{19, 51, "DEV_CPSW0_SERDES3_RXFCLK", "Input clock"},
	{19, 52, "DEV_CPSW0_GMII8_MT_CLK", "Input clock"},
	{19, 53, "DEV_CPSW0_SERDES7_TXFCLK", "Input clock"},
	{19, 54, "DEV_CPSW0_GMII7_MT_CLK", "Input clock"},
	{19, 55, "DEV_CPSW0_GMII7_MR_CLK", "Input clock"},
	{19, 56, "DEV_CPSW0_SERDES6_RXCLK", "Input clock"},
	{19, 57, "DEV_CPSW0_SERDES3_RXCLK", "Input clock"},
	{19, 58, "DEV_CPSW0_SERDES4_REFCLK", "Input clock"},
	{19, 59, "DEV_CPSW0_SERDES1_RXCLK", "Input clock"},
	{19, 60, "DEV_CPSW0_SERDES1_TXFCLK", "Input clock"},
	{19, 61, "DEV_CPSW0_GMII6_MR_CLK", "Input clock"},
	{19, 62, "DEV_CPSW0_SERDES1_REFCLK", "Input clock"},
	{19, 63, "DEV_CPSW0_RGMII_MHZ_5_CLK", "Input clock"},
	{19, 64, "DEV_CPSW0_SERDES5_REFCLK", "Input clock"},
	{19, 65, "DEV_CPSW0_GMII2_MT_CLK", "Input clock"},
	{19, 66, "DEV_CPSW0_SERDES8_TXFCLK", "Input clock"},
	{19, 67, "DEV_CPSW0_GMII8_MR_CLK", "Input clock"},
	{19, 68, "DEV_CPSW0_GMII1_MR_CLK", "Input clock"},
	{19, 69, "DEV_CPSW0_SERDES8_REFCLK", "Input clock"},
	{19, 70, "DEV_CPSW0_SERDES3_TXMCLK", "Input clock"},
	{19, 71, "DEV_CPSW0_GMII3_MR_CLK", "Input clock"},
	{19, 72, "DEV_CPSW0_SERDES1_TXMCLK", "Input clock"},
	{19, 73, "DEV_CPSW0_SERDES7_RXFCLK", "Input clock"},
	{19, 74, "DEV_CPSW0_GMII5_MR_CLK", "Input clock"},
	{19, 75, "DEV_CPSW0_GMII1_MT_CLK", "Input clock"},
	{19, 76, "DEV_CPSW0_SERDES2_RXFCLK", "Input clock"},
	{19, 77, "DEV_CPSW0_SERDES4_TXFCLK", "Input clock"},
	{19, 78, "DEV_CPSW0_SERDES3_TXCLK", "Output clock"},
	{19, 79, "DEV_CPSW0_CPTS_GENF0", "Output clock"},
	{19, 80, "DEV_CPSW0_SERDES5_TXCLK", "Output clock"},
	{19, 81, "DEV_CPSW0_SERDES6_TXCLK", "Output clock"},
	{19, 82, "DEV_CPSW0_SERDES8_TXCLK", "Output clock"},
	{19, 83, "DEV_CPSW0_SERDES1_TXCLK", "Output clock"},
	{19, 84, "DEV_CPSW0_SERDES4_TXCLK", "Output clock"},
	{19, 85, "DEV_CPSW0_SERDES2_TXCLK", "Output clock"},
	{19, 86, "DEV_CPSW0_SERDES7_TXCLK", "Output clock"},
	{19, 87, "DEV_CPSW0_MDIO_MDCLK_O", "Output clock"},
	{19, 89, "DEV_CPSW0_CPPI_CLK_CLK", "Input clock"},
	{20, 0, "DEV_CPT2_AGGR0_VCLK_CLK", "Input clock"},
	{21, 0, "DEV_CPT2_AGGR1_VCLK_CLK", "Input clock"},
	{23, 0, "DEV_CPT2_AGGR2_VCLK_CLK", "Input clock"},
	{25, 0, "DEV_CSI_PSILSS0_MAIN_CLK", "Input clock"},
	{26, 0, "DEV_CSI_RX_IF0_VBUS_CLK_CLK", "Input clock"},
	{26, 1, "DEV_CSI_RX_IF0_PPI_RX_BYTE_CLK", "Input clock"},
	{26, 2, "DEV_CSI_RX_IF0_MAIN_CLK_CLK", "Input clock"},
	{26, 3, "DEV_CSI_RX_IF0_VP_CLK_CLK", "Input clock"},
	{27, 0, "DEV_CSI_RX_IF1_VBUS_CLK_CLK", "Input clock"},
	{27, 1, "DEV_CSI_RX_IF1_PPI_RX_BYTE_CLK", "Input clock"},
	{27, 2, "DEV_CSI_RX_IF1_MAIN_CLK_CLK", "Input clock"},
	{27, 3, "DEV_CSI_RX_IF1_VP_CLK_CLK", "Input clock"},
	{28, 0, "DEV_CSI_TX_IF0_ESC_CLK_CLK", "Input clock"},
	{28, 1, "DEV_CSI_TX_IF0_DPHY_TXBYTECLKHS_CL_CLK", "Input clock"},
	{28, 2, "DEV_CSI_TX_IF0_VBUS_CLK_CLK", "Input clock"},
	{28, 3, "DEV_CSI_TX_IF0_MAIN_CLK_CLK", "Input clock"},
	{30, 0, "DEV_DCC0_DCC_INPUT10_CLK", "Input clock"},
	{30, 1, "DEV_DCC0_DCC_INPUT01_CLK", "Input clock"},
	{30, 2, "DEV_DCC0_DCC_CLKSRC2_CLK", "Input clock"},
	{30, 3, "DEV_DCC0_DCC_CLKSRC7_CLK", "Input clock"},
	{30, 4, "DEV_DCC0_DCC_CLKSRC0_CLK", "Input clock"},
	{30, 5, "DEV_DCC0_VBUS_CLK", "Input clock"},
	{30, 6, "DEV_DCC0_DCC_CLKSRC4_CLK", "Input clock"},
	{30, 7, "DEV_DCC0_DCC_CLKSRC1_CLK", "Input clock"},
	{30, 8, "DEV_DCC0_DCC_CLKSRC3_CLK", "Input clock"},
	{30, 9, "DEV_DCC0_DCC_INPUT00_CLK", "Input clock"},
	{30, 10, "DEV_DCC0_DCC_CLKSRC5_CLK", "Input clock"},
	{30, 11, "DEV_DCC0_DCC_CLKSRC6_CLK", "Input clock"},
	{30, 12, "DEV_DCC0_DCC_INPUT02_CLK", "Input clock"},
	{31, 0, "DEV_DCC1_DCC_INPUT10_CLK", "Input clock"},
	{31, 1, "DEV_DCC1_DCC_INPUT01_CLK", "Input clock"},
	{31, 2, "DEV_DCC1_DCC_CLKSRC2_CLK", "Input clock"},
	{31, 3, "DEV_DCC1_DCC_CLKSRC7_CLK", "Input clock"},
	{31, 4, "DEV_DCC1_DCC_CLKSRC0_CLK", "Input clock"},
	{31, 5, "DEV_DCC1_VBUS_CLK", "Input clock"},
	{31, 6, "DEV_DCC1_DCC_CLKSRC4_CLK", "Input clock"},
	{31, 7, "DEV_DCC1_DCC_CLKSRC1_CLK", "Input clock"},
	{31, 8, "DEV_DCC1_DCC_CLKSRC3_CLK", "Input clock"},
	{31, 9, "DEV_DCC1_DCC_INPUT00_CLK", "Input clock"},
	{31, 10, "DEV_DCC1_DCC_CLKSRC5_CLK", "Input clock"},
	{31, 11, "DEV_DCC1_DCC_CLKSRC6_CLK", "Input clock"},
	{31, 12, "DEV_DCC1_DCC_INPUT02_CLK", "Input clock"},
	{41, 0, "DEV_DCC10_DCC_INPUT10_CLK", "Input clock"},
	{41, 1, "DEV_DCC10_DCC_INPUT01_CLK", "Input clock"},
	{41, 2, "DEV_DCC10_DCC_CLKSRC2_CLK", "Input clock"},
	{41, 3, "DEV_DCC10_DCC_CLKSRC7_CLK", "Input clock"},
	{41, 4, "DEV_DCC10_DCC_CLKSRC0_CLK", "Input clock"},
	{41, 5, "DEV_DCC10_VBUS_CLK", "Input clock"},
	{41, 6, "DEV_DCC10_DCC_CLKSRC4_CLK", "Input clock"},
	{41, 7, "DEV_DCC10_DCC_CLKSRC1_CLK", "Input clock"},
	{41, 8, "DEV_DCC10_DCC_CLKSRC3_CLK", "Input clock"},
	{41, 9, "DEV_DCC10_DCC_INPUT00_CLK", "Input clock"},
	{41, 10, "DEV_DCC10_DCC_CLKSRC5_CLK", "Input clock"},
	{41, 11, "DEV_DCC10_DCC_CLKSRC6_CLK", "Input clock"},
	{41, 12, "DEV_DCC10_DCC_INPUT02_CLK", "Input clock"},
	{42, 0, "DEV_DCC11_DCC_INPUT10_CLK", "Input clock"},
	{42, 1, "DEV_DCC11_DCC_INPUT01_CLK", "Input clock"},
	{42, 2, "DEV_DCC11_DCC_CLKSRC2_CLK", "Input clock"},
	{42, 3, "DEV_DCC11_DCC_CLKSRC7_CLK", "Input clock"},
	{42, 4, "DEV_DCC11_DCC_CLKSRC0_CLK", "Input clock"},
	{42, 5, "DEV_DCC11_VBUS_CLK", "Input clock"},
	{42, 6, "DEV_DCC11_DCC_CLKSRC4_CLK", "Input clock"},
	{42, 7, "DEV_DCC11_DCC_CLKSRC1_CLK", "Input clock"},
	{42, 8, "DEV_DCC11_DCC_CLKSRC3_CLK", "Input clock"},
	{42, 9, "DEV_DCC11_DCC_INPUT00_CLK", "Input clock"},
	{42, 10, "DEV_DCC11_DCC_CLKSRC5_CLK", "Input clock"},
	{42, 11, "DEV_DCC11_DCC_CLKSRC6_CLK", "Input clock"},
	{42, 12, "DEV_DCC11_DCC_INPUT02_CLK", "Input clock"},
	{43, 0, "DEV_DCC12_DCC_INPUT10_CLK", "Input clock"},
	{43, 1, "DEV_DCC12_DCC_INPUT01_CLK", "Input clock"},
	{43, 2, "DEV_DCC12_DCC_CLKSRC2_CLK", "Input clock"},
	{43, 3, "DEV_DCC12_DCC_CLKSRC7_CLK", "Input clock"},
	{43, 4, "DEV_DCC12_DCC_CLKSRC0_CLK", "Input clock"},
	{43, 5, "DEV_DCC12_VBUS_CLK", "Input clock"},
	{43, 6, "DEV_DCC12_DCC_CLKSRC4_CLK", "Input clock"},
	{43, 7, "DEV_DCC12_DCC_CLKSRC1_CLK", "Input clock"},
	{43, 8, "DEV_DCC12_DCC_CLKSRC3_CLK", "Input clock"},
	{43, 9, "DEV_DCC12_DCC_INPUT00_CLK", "Input clock"},
	{43, 10, "DEV_DCC12_DCC_CLKSRC5_CLK", "Input clock"},
	{43, 11, "DEV_DCC12_DCC_CLKSRC6_CLK", "Input clock"},
	{43, 12, "DEV_DCC12_DCC_INPUT02_CLK", "Input clock"},
	{32, 0, "DEV_DCC2_DCC_INPUT10_CLK", "Input clock"},
	{32, 1, "DEV_DCC2_DCC_INPUT01_CLK", "Input clock"},
	{32, 2, "DEV_DCC2_DCC_CLKSRC2_CLK", "Input clock"},
	{32, 3, "DEV_DCC2_DCC_CLKSRC7_CLK", "Input clock"},
	{32, 4, "DEV_DCC2_DCC_CLKSRC0_CLK", "Input clock"},
	{32, 5, "DEV_DCC2_VBUS_CLK", "Input clock"},
	{32, 6, "DEV_DCC2_DCC_CLKSRC4_CLK", "Input clock"},
	{32, 7, "DEV_DCC2_DCC_CLKSRC1_CLK", "Input clock"},
	{32, 8, "DEV_DCC2_DCC_CLKSRC3_CLK", "Input clock"},
	{32, 9, "DEV_DCC2_DCC_INPUT00_CLK", "Input clock"},
	{32, 10, "DEV_DCC2_DCC_CLKSRC5_CLK", "Input clock"},
	{32, 11, "DEV_DCC2_DCC_CLKSRC6_CLK", "Input clock"},
	{32, 12, "DEV_DCC2_DCC_INPUT02_CLK", "Input clock"},
	{33, 0, "DEV_DCC3_DCC_INPUT10_CLK", "Input clock"},
	{33, 1, "DEV_DCC3_DCC_INPUT01_CLK", "Input clock"},
	{33, 2, "DEV_DCC3_DCC_CLKSRC2_CLK", "Input clock"},
	{33, 3, "DEV_DCC3_DCC_CLKSRC7_CLK", "Input clock"},
	{33, 4, "DEV_DCC3_DCC_CLKSRC0_CLK", "Input clock"},
	{33, 5, "DEV_DCC3_VBUS_CLK", "Input clock"},
	{33, 6, "DEV_DCC3_DCC_CLKSRC4_CLK", "Input clock"},
	{33, 7, "DEV_DCC3_DCC_CLKSRC1_CLK", "Input clock"},
	{33, 8, "DEV_DCC3_DCC_CLKSRC3_CLK", "Input clock"},
	{33, 9, "DEV_DCC3_DCC_INPUT00_CLK", "Input clock"},
	{33, 10, "DEV_DCC3_DCC_CLKSRC5_CLK", "Input clock"},
	{33, 11, "DEV_DCC3_DCC_CLKSRC6_CLK", "Input clock"},
	{33, 12, "DEV_DCC3_DCC_INPUT02_CLK", "Input clock"},
	{34, 0, "DEV_DCC4_DCC_INPUT10_CLK", "Input clock"},
	{34, 1, "DEV_DCC4_DCC_INPUT01_CLK", "Input clock"},
	{34, 2, "DEV_DCC4_DCC_CLKSRC2_CLK", "Input clock"},
	{34, 3, "DEV_DCC4_DCC_CLKSRC7_CLK", "Input clock"},
	{34, 4, "DEV_DCC4_DCC_CLKSRC0_CLK", "Input clock"},
	{34, 5, "DEV_DCC4_VBUS_CLK", "Input clock"},
	{34, 6, "DEV_DCC4_DCC_CLKSRC4_CLK", "Input clock"},
	{34, 7, "DEV_DCC4_DCC_CLKSRC1_CLK", "Input clock"},
	{34, 8, "DEV_DCC4_DCC_CLKSRC3_CLK", "Input clock"},
	{34, 9, "DEV_DCC4_DCC_INPUT00_CLK", "Input clock"},
	{34, 10, "DEV_DCC4_DCC_CLKSRC5_CLK", "Input clock"},
	{34, 11, "DEV_DCC4_DCC_CLKSRC6_CLK", "Input clock"},
	{34, 12, "DEV_DCC4_DCC_INPUT02_CLK", "Input clock"},
	{36, 0, "DEV_DCC5_DCC_INPUT10_CLK", "Input clock"},
	{36, 1, "DEV_DCC5_DCC_INPUT01_CLK", "Input clock"},
	{36, 2, "DEV_DCC5_DCC_CLKSRC2_CLK", "Input clock"},
	{36, 3, "DEV_DCC5_DCC_CLKSRC7_CLK", "Input clock"},
	{36, 4, "DEV_DCC5_DCC_CLKSRC0_CLK", "Input clock"},
	{36, 5, "DEV_DCC5_VBUS_CLK", "Input clock"},
	{36, 6, "DEV_DCC5_DCC_CLKSRC4_CLK", "Input clock"},
	{36, 7, "DEV_DCC5_DCC_CLKSRC1_CLK", "Input clock"},
	{36, 8, "DEV_DCC5_DCC_CLKSRC3_CLK", "Input clock"},
	{36, 9, "DEV_DCC5_DCC_INPUT00_CLK", "Input clock"},
	{36, 10, "DEV_DCC5_DCC_CLKSRC5_CLK", "Input clock"},
	{36, 11, "DEV_DCC5_DCC_CLKSRC6_CLK", "Input clock"},
	{36, 12, "DEV_DCC5_DCC_INPUT02_CLK", "Input clock"},
	{37, 0, "DEV_DCC6_DCC_INPUT10_CLK", "Input clock"},
	{37, 1, "DEV_DCC6_DCC_INPUT01_CLK", "Input clock"},
	{37, 2, "DEV_DCC6_DCC_CLKSRC2_CLK", "Input clock"},
	{37, 3, "DEV_DCC6_DCC_CLKSRC7_CLK", "Input clock"},
	{37, 4, "DEV_DCC6_DCC_CLKSRC0_CLK", "Input clock"},
	{37, 5, "DEV_DCC6_VBUS_CLK", "Input clock"},
	{37, 6, "DEV_DCC6_DCC_CLKSRC4_CLK", "Input clock"},
	{37, 7, "DEV_DCC6_DCC_CLKSRC1_CLK", "Input clock"},
	{37, 8, "DEV_DCC6_DCC_CLKSRC3_CLK", "Input clock"},
	{37, 9, "DEV_DCC6_DCC_INPUT00_CLK", "Input clock"},
	{37, 10, "DEV_DCC6_DCC_CLKSRC5_CLK", "Input clock"},
	{37, 11, "DEV_DCC6_DCC_CLKSRC6_CLK", "Input clock"},
	{37, 12, "DEV_DCC6_DCC_INPUT02_CLK", "Input clock"},
	{38, 0, "DEV_DCC7_DCC_INPUT10_CLK", "Input clock"},
	{38, 1, "DEV_DCC7_DCC_INPUT01_CLK", "Input clock"},
	{38, 2, "DEV_DCC7_DCC_CLKSRC2_CLK", "Input clock"},
	{38, 3, "DEV_DCC7_DCC_CLKSRC7_CLK", "Input clock"},
	{38, 4, "DEV_DCC7_DCC_CLKSRC0_CLK", "Input clock"},
	{38, 5, "DEV_DCC7_VBUS_CLK", "Input clock"},
	{38, 6, "DEV_DCC7_DCC_CLKSRC4_CLK", "Input clock"},
	{38, 7, "DEV_DCC7_DCC_CLKSRC1_CLK", "Input clock"},
	{38, 8, "DEV_DCC7_DCC_CLKSRC3_CLK", "Input clock"},
	{38, 9, "DEV_DCC7_DCC_INPUT00_CLK", "Input clock"},
	{38, 10, "DEV_DCC7_DCC_CLKSRC5_CLK", "Input clock"},
	{38, 11, "DEV_DCC7_DCC_CLKSRC6_CLK", "Input clock"},
	{38, 12, "DEV_DCC7_DCC_INPUT02_CLK", "Input clock"},
	{39, 0, "DEV_DCC8_DCC_INPUT10_CLK", "Input clock"},
	{39, 1, "DEV_DCC8_DCC_INPUT01_CLK", "Input clock"},
	{39, 2, "DEV_DCC8_DCC_CLKSRC2_CLK", "Input clock"},
	{39, 3, "DEV_DCC8_DCC_CLKSRC7_CLK", "Input clock"},
	{39, 4, "DEV_DCC8_DCC_CLKSRC0_CLK", "Input clock"},
	{39, 5, "DEV_DCC8_VBUS_CLK", "Input clock"},
	{39, 6, "DEV_DCC8_DCC_CLKSRC4_CLK", "Input clock"},
	{39, 7, "DEV_DCC8_DCC_CLKSRC1_CLK", "Input clock"},
	{39, 8, "DEV_DCC8_DCC_CLKSRC3_CLK", "Input clock"},
	{39, 9, "DEV_DCC8_DCC_INPUT00_CLK", "Input clock"},
	{39, 10, "DEV_DCC8_DCC_CLKSRC5_CLK", "Input clock"},
	{39, 11, "DEV_DCC8_DCC_CLKSRC6_CLK", "Input clock"},
	{39, 12, "DEV_DCC8_DCC_INPUT02_CLK", "Input clock"},
	{40, 0, "DEV_DCC9_DCC_INPUT10_CLK", "Input clock"},
	{40, 1, "DEV_DCC9_DCC_INPUT01_CLK", "Input clock"},
	{40, 2, "DEV_DCC9_DCC_CLKSRC2_CLK", "Input clock"},
	{40, 3, "DEV_DCC9_DCC_CLKSRC7_CLK", "Input clock"},
	{40, 4, "DEV_DCC9_DCC_CLKSRC0_CLK", "Input clock"},
	{40, 5, "DEV_DCC9_VBUS_CLK", "Input clock"},
	{40, 6, "DEV_DCC9_DCC_CLKSRC4_CLK", "Input clock"},
	{40, 7, "DEV_DCC9_DCC_CLKSRC1_CLK", "Input clock"},
	{40, 8, "DEV_DCC9_DCC_CLKSRC3_CLK", "Input clock"},
	{40, 9, "DEV_DCC9_DCC_INPUT00_CLK", "Input clock"},
	{40, 10, "DEV_DCC9_DCC_CLKSRC5_CLK", "Input clock"},
	{40, 11, "DEV_DCC9_DCC_CLKSRC6_CLK", "Input clock"},
	{40, 12, "DEV_DCC9_DCC_INPUT02_CLK", "Input clock"},
	{47, 0, "DEV_DDR0_DDRSS_VBUS_CLK", "Input clock"},
	{47, 1, "DEV_DDR0_PLL_CTRL_CLK", "Input clock"},
	{47, 2, "DEV_DDR0_DDRSS_DDR_PLL_CLK", "Input clock"},
	{47, 3, "DEV_DDR0_DDRSS_CFG_CLK", "Input clock"},
	{47, 4, "DEV_DDR0_DDRSS_IO_CK_N", "Output clock"},
	{47, 5, "DEV_DDR0_DDRSS_IO_CK", "Output clock"},
	{304, 5, "DEV_DEBUGSS_WRAP0_TREXPT_CLK", "Input clock"},
	{304, 9, "DEV_DEBUGSS_WRAP0_CORE_CLK", "Input clock"},
	{304, 25, "DEV_DEBUGSS_WRAP0_JTAG_TCK", "Input clock"},
	{304, 32, "DEV_DEBUGSS_WRAP0_CSTPIU_TRACECLK", "Output clock"},
	{304, 35, "DEV_DEBUGSS_WRAP0_ATB_CLK", "Input clock"},
	{144, 0, "DEV_DECODER0_SYS_CLK", "Input clock"},
	{48, 0, "DEV_DMPAC0_CLK", "Input clock"},
	{48, 1, "DEV_DMPAC0_PLL_DCO_CLK", "Input clock"},
	{305, 0, "DEV_DMPAC0_SDE_0_CLK", "Input clock"},
	{147, 0, "DEV_DPHY_RX0_MAIN_CLK_CLK", "Input clock"},
	{147, 1, "DEV_DPHY_RX0_PPI_RX_BYTE_CLK", "Output clock"},
	{148, 0, "DEV_DPHY_RX1_MAIN_CLK_CLK", "Input clock"},
	{148, 1, "DEV_DPHY_RX1_PPI_RX_BYTE_CLK", "Output clock"},
	{296, 0, "DEV_DPHY_TX0_CLK", "Input clock"},
	{296, 1, "DEV_DPHY_TX0_PSM_CLK", "Input clock"},
	{296, 2, "DEV_DPHY_TX0_IP1_PPI_M_TXCLKESC_CLK", "Input clock"},
	{296, 3, "DEV_DPHY_TX0_DPHY_REF_CLK", "Input muxed clock"},
	{296, 4, "DEV_DPHY_TX0_DPHY_REF_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_DPHY_TX0_DPHY_REF_CLK"},
	{296, 5, "DEV_DPHY_TX0_DPHY_REF_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_DPHY_TX0_DPHY_REF_CLK"},
	{296, 6, "DEV_DPHY_TX0_DPHY_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_DPHY_TX0_DPHY_REF_CLK"},
	{296, 7, "DEV_DPHY_TX0_DPHY_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_DPHY_TX0_DPHY_REF_CLK"},
	{296, 8, "DEV_DPHY_TX0_IP1_PPI_TXBYTECLKHS_CL_CLK", "Output clock"},
	{296, 9, "DEV_DPHY_TX0_IP1_PPI_M_RXCLKESC_CLK", "Output clock"},
	{296, 10, "DEV_DPHY_TX0_CK_P", "Output clock"},
	{296, 11, "DEV_DPHY_TX0_CK_M", "Output clock"},
	{296, 12, "DEV_DPHY_TX0_IP2_PPI_TXBYTECLKHS_CL_CLK", "Output clock"},
	{152, 0, "DEV_DSS0_DSS_FUNC_CLK", "Input clock"},
	{152, 1, "DEV_DSS0_DSS_INST0_DPI_0_IN_2X_CLK", "Input muxed clock"},
	{152, 2, "DEV_DSS0_DSS_INST0_DPI_0_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_0_IN_2X_CLK"},
	{152, 3, "DEV_DSS0_DSS_INST0_DPI_0_IN_2X_CLK_PARENT_DPI_1_PCLK_SEL_OUT0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_0_IN_2X_CLK"},
	{152, 4, "DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK", "Input muxed clock"},
	{152, 5, "DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_17_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK"},
	{152, 6, "DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK_PARENT_DPI0_EXT_CLKSEL_OUT0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK"},
	{152, 7, "DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK_PARENT_DPI1_EXT_CLKSEL_OUT0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK"},
	{152, 8, "DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK"},
	{152, 9, "DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK", "Input muxed clock"},
	{152, 10, "DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK"},
	{152, 11, "DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_18_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK"},
	{152, 12, "DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK_PARENT_DPI0_EXT_CLKSEL_OUT0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK"},
	{152, 13, "DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK", "Input muxed clock"},
	{152, 14, "DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT1_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK"},
	{152, 15, "DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_17_HSDIVOUT1_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK"},
	{152, 16, "DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_18_HSDIVOUT1_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK"},
	{152, 17, "DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK_PARENT_DPI0_EXT_CLKSEL_OUT0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK"},
	{152, 18, "DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK_PARENT_DPI1_EXT_CLKSEL_OUT0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK"},
	{152, 23, "DEV_DSS0_DSS_INST0_DPI_0_OUT_CLK", "Output clock"},
	{152, 24, "DEV_DSS0_DSS_INST0_DPI_0_OUT_2X_CLK", "Output clock"},
	{152, 25, "DEV_DSS0_DSS_INST0_DPI_1_OUT_CLK", "Output clock"},
	{152, 27, "DEV_DSS0_DSS_INST0_DPI_2_OUT_CLK", "Output clock"},
	{152, 29, "DEV_DSS0_DSS_INST0_DPI_3_OUT_CLK", "Output clock"},
	{152, 31, "DEV_DSS0_DPI0_EXT_CLKSEL", "Input muxed clock"},
	{152, 32, "DEV_DSS0_DPI0_EXT_CLKSEL_PARENT_HSDIV1_16FFT_MAIN_19_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DPI0_EXT_CLKSEL"},
	{152, 33, "DEV_DSS0_DPI0_EXT_CLKSEL_PARENT_BOARD_0_VOUT1_EXTPCLKIN_OUT", "Parent input clock option to DEV_DSS0_DPI0_EXT_CLKSEL"},
	{152, 34, "DEV_DSS0_DPI1_EXT_CLKSEL", "Input muxed clock"},
	{152, 35, "DEV_DSS0_DPI1_EXT_CLKSEL_PARENT_HSDIV1_16FFT_MAIN_23_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DPI1_EXT_CLKSEL"},
	{152, 36, "DEV_DSS0_DPI1_EXT_CLKSEL_PARENT_BOARD_0_VOUT2_EXTPCLKIN_OUT", "Parent input clock option to DEV_DSS0_DPI1_EXT_CLKSEL"},
	{150, 0, "DEV_DSS_DSI0_DPHY_0_RX_ESC_CLK", "Input clock"},
	{150, 1, "DEV_DSS_DSI0_DPI_0_CLK", "Input clock"},
	{150, 2, "DEV_DSS_DSI0_PLL_CTRL_CLK", "Input clock"},
	{150, 3, "DEV_DSS_DSI0_PPI_0_TXBYTECLKHS_CL_CLK", "Input clock"},
	{150, 4, "DEV_DSS_DSI0_DPHY_0_TX_ESC_CLK", "Input clock"},
	{150, 5, "DEV_DSS_DSI0_SYS_CLK", "Input clock"},
	{151, 0, "DEV_DSS_EDP0_PHY_LN1_TXFCLK", "Input clock"},
	{151, 1, "DEV_DSS_EDP0_DPI_2_CLK", "Input clock"},
	{151, 2, "DEV_DSS_EDP0_PHY_LN2_TXFCLK", "Input clock"},
	{151, 3, "DEV_DSS_EDP0_PHY_LN0_RXCLK", "Input clock"},
	{151, 4, "DEV_DSS_EDP0_PHY_LN2_TXMCLK", "Input clock"},
	{151, 5, "DEV_DSS_EDP0_PHY_LN0_RXFCLK", "Input clock"},
	{151, 6, "DEV_DSS_EDP0_PHY_LN0_REFCLK", "Input clock"},
	{151, 7, "DEV_DSS_EDP0_PHY_LN1_RXCLK", "Input clock"},
	{151, 8, "DEV_DSS_EDP0_PHY_LN2_RXFCLK", "Input clock"},
	{151, 9, "DEV_DSS_EDP0_DPI_4_CLK", "Input clock"},
	{151, 10, "DEV_DSS_EDP0_DPI_2_2X_CLK", "Input clock"},
	{151, 11, "DEV_DSS_EDP0_PHY_LN0_TXFCLK", "Input clock"},
	{151, 12, "DEV_DSS_EDP0_PHY_LN2_RXCLK", "Input clock"},
	{151, 13, "DEV_DSS_EDP0_PHY_LN2_REFCLK", "Input clock"},
	{151, 14, "DEV_DSS_EDP0_PHY_LN3_REFCLK", "Input clock"},
	{151, 15, "DEV_DSS_EDP0_DPI_5_CLK", "Input clock"},
	{151, 16, "DEV_DSS_EDP0_PHY_LN3_RXCLK", "Input clock"},
	{151, 17, "DEV_DSS_EDP0_PHY_LN1_REFCLK", "Input clock"},
	{151, 18, "DEV_DSS_EDP0_AIF_I2S_CLK", "Input clock"},
	{151, 19, "DEV_DSS_EDP0_PHY_LN3_TXFCLK", "Input clock"},
	{151, 20, "DEV_DSS_EDP0_DPI_3_CLK", "Input clock"},
	{151, 21, "DEV_DSS_EDP0_PHY_LN1_RXFCLK", "Input clock"},
	{151, 22, "DEV_DSS_EDP0_PHY_LN1_TXMCLK", "Input clock"},
	{151, 23, "DEV_DSS_EDP0_PLL_CTRL_CLK", "Input clock"},
	{151, 24, "DEV_DSS_EDP0_PHY_LN3_TXMCLK", "Input clock"},
	{151, 25, "DEV_DSS_EDP0_PHY_LN3_RXFCLK", "Input clock"},
	{151, 26, "DEV_DSS_EDP0_PHY_LN0_TXMCLK", "Input clock"},
	{151, 27, "DEV_DSS_EDP0_PHY_LN2_TXCLK", "Output clock"},
	{151, 28, "DEV_DSS_EDP0_PHY_LN3_TXCLK", "Output clock"},
	{151, 29, "DEV_DSS_EDP0_PHY_LN0_TXCLK", "Output clock"},
	{151, 30, "DEV_DSS_EDP0_PHY_LN1_TXCLK", "Output clock"},
	{151, 36, "DEV_DSS_EDP0_DPTX_MOD_CLK", "Input clock"},
	{80, 0, "DEV_ECAP0_VBUS_CLK", "Input clock"},
	{81, 0, "DEV_ECAP1_VBUS_CLK", "Input clock"},
	{82, 0, "DEV_ECAP2_VBUS_CLK", "Input clock"},
	{83, 0, "DEV_EHRPWM0_VBUSP_CLK", "Input clock"},
	{84, 0, "DEV_EHRPWM1_VBUSP_CLK", "Input clock"},
	{85, 0, "DEV_EHRPWM2_VBUSP_CLK", "Input clock"},
	{86, 0, "DEV_EHRPWM3_VBUSP_CLK", "Input clock"},
	{87, 0, "DEV_EHRPWM4_VBUSP_CLK", "Input clock"},
	{88, 0, "DEV_EHRPWM5_VBUSP_CLK", "Input clock"},
	{89, 0, "DEV_ELM0_VBUSP_CLK", "Input clock"},
	{153, 0, "DEV_ENCODER0_SYS_CLK", "Input clock"},
	{94, 0, "DEV_EQEP0_VBUS_CLK", "Input clock"},
	{95, 0, "DEV_EQEP1_VBUS_CLK", "Input clock"},
	{96, 0, "DEV_EQEP2_VBUS_CLK", "Input clock"},
	{97, 0, "DEV_ESM0_CLK", "Input clock"},
	{105, 0, "DEV_GPIO0_MMR_CLK", "Input clock"},
	{106, 0, "DEV_GPIO1_MMR_CLK", "Input clock"},
	{107, 0, "DEV_GPIO2_MMR_CLK", "Input clock"},
	{108, 0, "DEV_GPIO3_MMR_CLK", "Input clock"},
	{109, 0, "DEV_GPIO4_MMR_CLK", "Input clock"},
	{110, 0, "DEV_GPIO5_MMR_CLK", "Input clock"},
	{111, 0, "DEV_GPIO6_MMR_CLK", "Input clock"},
	{112, 0, "DEV_GPIO7_MMR_CLK", "Input clock"},
	{131, 0, "DEV_GPIOMUX_INTRTR0_INTR_CLK", "Input clock"},
	{115, 0, "DEV_GPMC0_PI_GPMC_RET_CLK", "Input clock"},
	{115, 1, "DEV_GPMC0_VBUSP_CLK", "Input clock"},
	{115, 2, "DEV_GPMC0_FUNC_CLK", "Input muxed clock"},
	{115, 3, "DEV_GPMC0_FUNC_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{115, 4, "DEV_GPMC0_FUNC_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT1_CLK6", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{115, 5, "DEV_GPMC0_FUNC_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT1_CLK4", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{115, 6, "DEV_GPMC0_FUNC_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK4", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{115, 7, "DEV_GPMC0_PO_GPMC_DEV_CLK", "Output clock"},
	{125, 0, "DEV_GPU0_GPU_0_GPU_PLL_CLK", "Input clock"},
	{61, 0, "DEV_GTC0_VBUSP_CLK", "Input clock"},
	{61, 1, "DEV_GTC0_GTC_CLK", "Input muxed clock"},
	{61, 2, "DEV_GTC0_GTC_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 3, "DEV_GTC0_GTC_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 4, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 5, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 6, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 7, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 8, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 9, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 10, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 11, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 12, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN0_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 13, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN1_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 14, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B4M4CS_MAIN_3_IP2_LN0_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 15, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B4M4CS_MAIN_3_IP2_LN1_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 16, "DEV_GTC0_GTC_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 17, "DEV_GTC0_GTC_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{187, 0, "DEV_I2C0_PISYS_CLK", "Input clock"},
	{187, 1, "DEV_I2C0_PISCL", "Input clock"},
	{187, 2, "DEV_I2C0_CLK", "Input clock"},
	{187, 3, "DEV_I2C0_PORSCL", "Output clock"},
	{188, 0, "DEV_I2C1_PISYS_CLK", "Input clock"},
	{188, 1, "DEV_I2C1_PISCL", "Input clock"},
	{188, 2, "DEV_I2C1_CLK", "Input clock"},
	{188, 3, "DEV_I2C1_PORSCL", "Output clock"},
	{189, 0, "DEV_I2C2_PISYS_CLK", "Input clock"},
	{189, 1, "DEV_I2C2_PISCL", "Input clock"},
	{189, 2, "DEV_I2C2_CLK", "Input clock"},
	{189, 3, "DEV_I2C2_PORSCL", "Output clock"},
	{190, 0, "DEV_I2C3_PISYS_CLK", "Input clock"},
	{190, 1, "DEV_I2C3_PISCL", "Input clock"},
	{190, 2, "DEV_I2C3_CLK", "Input clock"},
	{190, 3, "DEV_I2C3_PORSCL", "Output clock"},
	{191, 0, "DEV_I2C4_PISYS_CLK", "Input clock"},
	{191, 1, "DEV_I2C4_PISCL", "Input clock"},
	{191, 2, "DEV_I2C4_CLK", "Input clock"},
	{191, 3, "DEV_I2C4_PORSCL", "Output clock"},
	{192, 0, "DEV_I2C5_PISYS_CLK", "Input clock"},
	{192, 1, "DEV_I2C5_PISCL", "Input clock"},
	{192, 2, "DEV_I2C5_CLK", "Input clock"},
	{192, 3, "DEV_I2C5_PORSCL", "Output clock"},
	{193, 0, "DEV_I2C6_PISYS_CLK", "Input clock"},
	{193, 1, "DEV_I2C6_PISCL", "Input clock"},
	{193, 2, "DEV_I2C6_CLK", "Input clock"},
	{193, 3, "DEV_I2C6_PORSCL", "Output clock"},
	{116, 0, "DEV_I3C0_I3C_PCLK_CLK", "Input clock"},
	{116, 1, "DEV_I3C0_I3C_SCL_DI", "Input clock"},
	{116, 2, "DEV_I3C0_I3C_SCLK_CLK", "Input clock"},
	{116, 3, "DEV_I3C0_I3C_SCL_DO", "Output clock"},
	{127, 0, "DEV_LED0_LED_CLK", "Input clock"},
	{127, 1, "DEV_LED0_VBUS_CLK", "Input clock"},
	{128, 0, "DEV_MAIN2MCU_LVL_INTRTR0_INTR_CLK", "Input clock"},
	{130, 0, "DEV_MAIN2MCU_PLS_INTRTR0_INTR_CLK", "Input clock"},
	{156, 0, "DEV_MCAN0_MCANSS_HCLK_CLK", "Input clock"},
	{156, 1, "DEV_MCAN0_MCANSS_CCLK_CLK", "Input muxed clock"},
	{156, 2, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{156, 3, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{156, 4, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{156, 5, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{158, 0, "DEV_MCAN1_MCANSS_HCLK_CLK", "Input clock"},
	{158, 1, "DEV_MCAN1_MCANSS_CCLK_CLK", "Input muxed clock"},
	{158, 2, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{158, 3, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{158, 4, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{158, 5, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{168, 0, "DEV_MCAN10_MCANSS_HCLK_CLK", "Input clock"},
	{168, 1, "DEV_MCAN10_MCANSS_CCLK_CLK", "Input muxed clock"},
	{168, 2, "DEV_MCAN10_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN10_MCANSS_CCLK_CLK"},
	{168, 3, "DEV_MCAN10_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN10_MCANSS_CCLK_CLK"},
	{168, 4, "DEV_MCAN10_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN10_MCANSS_CCLK_CLK"},
	{168, 5, "DEV_MCAN10_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN10_MCANSS_CCLK_CLK"},
	{169, 0, "DEV_MCAN11_MCANSS_HCLK_CLK", "Input clock"},
	{169, 1, "DEV_MCAN11_MCANSS_CCLK_CLK", "Input muxed clock"},
	{169, 2, "DEV_MCAN11_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN11_MCANSS_CCLK_CLK"},
	{169, 3, "DEV_MCAN11_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN11_MCANSS_CCLK_CLK"},
	{169, 4, "DEV_MCAN11_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN11_MCANSS_CCLK_CLK"},
	{169, 5, "DEV_MCAN11_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN11_MCANSS_CCLK_CLK"},
	{170, 0, "DEV_MCAN12_MCANSS_HCLK_CLK", "Input clock"},
	{170, 1, "DEV_MCAN12_MCANSS_CCLK_CLK", "Input muxed clock"},
	{170, 2, "DEV_MCAN12_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN12_MCANSS_CCLK_CLK"},
	{170, 3, "DEV_MCAN12_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN12_MCANSS_CCLK_CLK"},
	{170, 4, "DEV_MCAN12_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN12_MCANSS_CCLK_CLK"},
	{170, 5, "DEV_MCAN12_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN12_MCANSS_CCLK_CLK"},
	{171, 0, "DEV_MCAN13_MCANSS_HCLK_CLK", "Input clock"},
	{171, 1, "DEV_MCAN13_MCANSS_CCLK_CLK", "Input muxed clock"},
	{171, 2, "DEV_MCAN13_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN13_MCANSS_CCLK_CLK"},
	{171, 3, "DEV_MCAN13_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN13_MCANSS_CCLK_CLK"},
	{171, 4, "DEV_MCAN13_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN13_MCANSS_CCLK_CLK"},
	{171, 5, "DEV_MCAN13_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN13_MCANSS_CCLK_CLK"},
	{160, 0, "DEV_MCAN2_MCANSS_HCLK_CLK", "Input clock"},
	{160, 1, "DEV_MCAN2_MCANSS_CCLK_CLK", "Input muxed clock"},
	{160, 2, "DEV_MCAN2_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN2_MCANSS_CCLK_CLK"},
	{160, 3, "DEV_MCAN2_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN2_MCANSS_CCLK_CLK"},
	{160, 4, "DEV_MCAN2_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN2_MCANSS_CCLK_CLK"},
	{160, 5, "DEV_MCAN2_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN2_MCANSS_CCLK_CLK"},
	{161, 0, "DEV_MCAN3_MCANSS_HCLK_CLK", "Input clock"},
	{161, 1, "DEV_MCAN3_MCANSS_CCLK_CLK", "Input muxed clock"},
	{161, 2, "DEV_MCAN3_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN3_MCANSS_CCLK_CLK"},
	{161, 3, "DEV_MCAN3_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN3_MCANSS_CCLK_CLK"},
	{161, 4, "DEV_MCAN3_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN3_MCANSS_CCLK_CLK"},
	{161, 5, "DEV_MCAN3_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN3_MCANSS_CCLK_CLK"},
	{162, 0, "DEV_MCAN4_MCANSS_HCLK_CLK", "Input clock"},
	{162, 1, "DEV_MCAN4_MCANSS_CCLK_CLK", "Input muxed clock"},
	{162, 2, "DEV_MCAN4_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN4_MCANSS_CCLK_CLK"},
	{162, 3, "DEV_MCAN4_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN4_MCANSS_CCLK_CLK"},
	{162, 4, "DEV_MCAN4_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN4_MCANSS_CCLK_CLK"},
	{162, 5, "DEV_MCAN4_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN4_MCANSS_CCLK_CLK"},
	{163, 0, "DEV_MCAN5_MCANSS_HCLK_CLK", "Input clock"},
	{163, 1, "DEV_MCAN5_MCANSS_CCLK_CLK", "Input muxed clock"},
	{163, 2, "DEV_MCAN5_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN5_MCANSS_CCLK_CLK"},
	{163, 3, "DEV_MCAN5_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN5_MCANSS_CCLK_CLK"},
	{163, 4, "DEV_MCAN5_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN5_MCANSS_CCLK_CLK"},
	{163, 5, "DEV_MCAN5_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN5_MCANSS_CCLK_CLK"},
	{164, 0, "DEV_MCAN6_MCANSS_HCLK_CLK", "Input clock"},
	{164, 1, "DEV_MCAN6_MCANSS_CCLK_CLK", "Input muxed clock"},
	{164, 2, "DEV_MCAN6_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN6_MCANSS_CCLK_CLK"},
	{164, 3, "DEV_MCAN6_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN6_MCANSS_CCLK_CLK"},
	{164, 4, "DEV_MCAN6_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN6_MCANSS_CCLK_CLK"},
	{164, 5, "DEV_MCAN6_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN6_MCANSS_CCLK_CLK"},
	{165, 0, "DEV_MCAN7_MCANSS_HCLK_CLK", "Input clock"},
	{165, 1, "DEV_MCAN7_MCANSS_CCLK_CLK", "Input muxed clock"},
	{165, 2, "DEV_MCAN7_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN7_MCANSS_CCLK_CLK"},
	{165, 3, "DEV_MCAN7_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN7_MCANSS_CCLK_CLK"},
	{165, 4, "DEV_MCAN7_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN7_MCANSS_CCLK_CLK"},
	{165, 5, "DEV_MCAN7_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN7_MCANSS_CCLK_CLK"},
	{166, 0, "DEV_MCAN8_MCANSS_HCLK_CLK", "Input clock"},
	{166, 1, "DEV_MCAN8_MCANSS_CCLK_CLK", "Input muxed clock"},
	{166, 2, "DEV_MCAN8_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN8_MCANSS_CCLK_CLK"},
	{166, 3, "DEV_MCAN8_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN8_MCANSS_CCLK_CLK"},
	{166, 4, "DEV_MCAN8_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN8_MCANSS_CCLK_CLK"},
	{166, 5, "DEV_MCAN8_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN8_MCANSS_CCLK_CLK"},
	{167, 0, "DEV_MCAN9_MCANSS_HCLK_CLK", "Input clock"},
	{167, 1, "DEV_MCAN9_MCANSS_CCLK_CLK", "Input muxed clock"},
	{167, 2, "DEV_MCAN9_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN9_MCANSS_CCLK_CLK"},
	{167, 3, "DEV_MCAN9_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN9_MCANSS_CCLK_CLK"},
	{167, 4, "DEV_MCAN9_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN9_MCANSS_CCLK_CLK"},
	{167, 5, "DEV_MCAN9_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN9_MCANSS_CCLK_CLK"},
	{174, 0, "DEV_MCASP0_VBUSP_CLK", "Input clock"},
	{174, 1, "DEV_MCASP0_AUX_CLK", "Input muxed clock"},
	{174, 2, "DEV_MCASP0_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{174, 3, "DEV_MCASP0_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{174, 4, "DEV_MCASP0_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{174, 6, "DEV_MCASP0_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{174, 7, "DEV_MCASP0_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{174, 8, "DEV_MCASP0_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{174, 9, "DEV_MCASP0_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{174, 10, "DEV_MCASP0_MCASP_ACLKX_POUT", "Output clock"},
	{174, 11, "DEV_MCASP0_MCASP_ACLKX_PIN", "Input clock"},
	{174, 12, "DEV_MCASP0_MCASP_ACLKR_POUT", "Output clock"},
	{174, 13, "DEV_MCASP0_MCASP_ACLKR_PIN", "Input clock"},
	{174, 14, "DEV_MCASP0_MCASP_AHCLKX_POUT", "Output clock"},
	{174, 15, "DEV_MCASP0_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{174, 16, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 17, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 18, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 19, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 20, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 21, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 22, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 23, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 24, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 25, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 26, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 27, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 28, "DEV_MCASP0_MCASP_AHCLKR_POUT", "Output clock"},
	{174, 29, "DEV_MCASP0_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{174, 30, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 31, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 32, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 33, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 34, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 35, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 36, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 37, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 38, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 39, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 40, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 41, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{175, 0, "DEV_MCASP1_VBUSP_CLK", "Input clock"},
	{175, 1, "DEV_MCASP1_AUX_CLK", "Input muxed clock"},
	{175, 2, "DEV_MCASP1_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{175, 3, "DEV_MCASP1_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{175, 4, "DEV_MCASP1_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{175, 6, "DEV_MCASP1_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{175, 7, "DEV_MCASP1_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{175, 8, "DEV_MCASP1_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{175, 9, "DEV_MCASP1_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{175, 10, "DEV_MCASP1_MCASP_ACLKX_POUT", "Output clock"},
	{175, 11, "DEV_MCASP1_MCASP_ACLKX_PIN", "Input clock"},
	{175, 12, "DEV_MCASP1_MCASP_ACLKR_POUT", "Output clock"},
	{175, 13, "DEV_MCASP1_MCASP_ACLKR_PIN", "Input clock"},
	{175, 14, "DEV_MCASP1_MCASP_AHCLKX_POUT", "Output clock"},
	{175, 15, "DEV_MCASP1_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{175, 16, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 17, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 18, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 19, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 20, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 21, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 22, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 23, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 24, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 25, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 26, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 27, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 28, "DEV_MCASP1_MCASP_AHCLKR_POUT", "Output clock"},
	{175, 29, "DEV_MCASP1_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{175, 30, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 31, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 32, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 33, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 34, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 35, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 36, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 37, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 38, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 39, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 40, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 41, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{184, 0, "DEV_MCASP10_VBUSP_CLK", "Input clock"},
	{184, 1, "DEV_MCASP10_AUX_CLK", "Input muxed clock"},
	{184, 2, "DEV_MCASP10_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP10_AUX_CLK"},
	{184, 3, "DEV_MCASP10_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP10_AUX_CLK"},
	{184, 4, "DEV_MCASP10_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP10_AUX_CLK"},
	{184, 6, "DEV_MCASP10_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP10_AUX_CLK"},
	{184, 7, "DEV_MCASP10_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP10_AUX_CLK"},
	{184, 8, "DEV_MCASP10_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP10_AUX_CLK"},
	{184, 9, "DEV_MCASP10_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP10_AUX_CLK"},
	{184, 10, "DEV_MCASP10_MCASP_ACLKX_POUT", "Output clock"},
	{184, 11, "DEV_MCASP10_MCASP_ACLKX_PIN", "Input clock"},
	{184, 12, "DEV_MCASP10_MCASP_ACLKR_POUT", "Output clock"},
	{184, 13, "DEV_MCASP10_MCASP_ACLKR_PIN", "Input clock"},
	{184, 14, "DEV_MCASP10_MCASP_AHCLKX_POUT", "Output clock"},
	{184, 15, "DEV_MCASP10_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{184, 16, "DEV_MCASP10_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKX_PIN"},
	{184, 17, "DEV_MCASP10_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKX_PIN"},
	{184, 18, "DEV_MCASP10_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKX_PIN"},
	{184, 19, "DEV_MCASP10_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKX_PIN"},
	{184, 20, "DEV_MCASP10_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKX_PIN"},
	{184, 21, "DEV_MCASP10_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKX_PIN"},
	{184, 22, "DEV_MCASP10_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKX_PIN"},
	{184, 23, "DEV_MCASP10_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKX_PIN"},
	{184, 24, "DEV_MCASP10_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKX_PIN"},
	{184, 25, "DEV_MCASP10_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKX_PIN"},
	{184, 26, "DEV_MCASP10_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKX_PIN"},
	{184, 27, "DEV_MCASP10_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKX_PIN"},
	{184, 28, "DEV_MCASP10_MCASP_AHCLKR_POUT", "Output clock"},
	{184, 29, "DEV_MCASP10_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{184, 30, "DEV_MCASP10_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKR_PIN"},
	{184, 31, "DEV_MCASP10_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKR_PIN"},
	{184, 32, "DEV_MCASP10_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKR_PIN"},
	{184, 33, "DEV_MCASP10_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKR_PIN"},
	{184, 34, "DEV_MCASP10_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKR_PIN"},
	{184, 35, "DEV_MCASP10_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKR_PIN"},
	{184, 36, "DEV_MCASP10_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKR_PIN"},
	{184, 37, "DEV_MCASP10_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKR_PIN"},
	{184, 38, "DEV_MCASP10_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKR_PIN"},
	{184, 39, "DEV_MCASP10_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKR_PIN"},
	{184, 40, "DEV_MCASP10_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKR_PIN"},
	{184, 41, "DEV_MCASP10_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP10_MCASP_AHCLKR_PIN"},
	{185, 0, "DEV_MCASP11_VBUSP_CLK", "Input clock"},
	{185, 1, "DEV_MCASP11_AUX_CLK", "Input muxed clock"},
	{185, 2, "DEV_MCASP11_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP11_AUX_CLK"},
	{185, 3, "DEV_MCASP11_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP11_AUX_CLK"},
	{185, 4, "DEV_MCASP11_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP11_AUX_CLK"},
	{185, 6, "DEV_MCASP11_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP11_AUX_CLK"},
	{185, 7, "DEV_MCASP11_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP11_AUX_CLK"},
	{185, 8, "DEV_MCASP11_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP11_AUX_CLK"},
	{185, 9, "DEV_MCASP11_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP11_AUX_CLK"},
	{185, 10, "DEV_MCASP11_MCASP_ACLKX_POUT", "Output clock"},
	{185, 11, "DEV_MCASP11_MCASP_ACLKX_PIN", "Input clock"},
	{185, 12, "DEV_MCASP11_MCASP_ACLKR_POUT", "Output clock"},
	{185, 13, "DEV_MCASP11_MCASP_ACLKR_PIN", "Input clock"},
	{185, 14, "DEV_MCASP11_MCASP_AHCLKX_POUT", "Output clock"},
	{185, 15, "DEV_MCASP11_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{185, 16, "DEV_MCASP11_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKX_PIN"},
	{185, 17, "DEV_MCASP11_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKX_PIN"},
	{185, 18, "DEV_MCASP11_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKX_PIN"},
	{185, 19, "DEV_MCASP11_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKX_PIN"},
	{185, 20, "DEV_MCASP11_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKX_PIN"},
	{185, 21, "DEV_MCASP11_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKX_PIN"},
	{185, 22, "DEV_MCASP11_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKX_PIN"},
	{185, 23, "DEV_MCASP11_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKX_PIN"},
	{185, 24, "DEV_MCASP11_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKX_PIN"},
	{185, 25, "DEV_MCASP11_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKX_PIN"},
	{185, 26, "DEV_MCASP11_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKX_PIN"},
	{185, 27, "DEV_MCASP11_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKX_PIN"},
	{185, 28, "DEV_MCASP11_MCASP_AHCLKR_POUT", "Output clock"},
	{185, 29, "DEV_MCASP11_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{185, 30, "DEV_MCASP11_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKR_PIN"},
	{185, 31, "DEV_MCASP11_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKR_PIN"},
	{185, 32, "DEV_MCASP11_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKR_PIN"},
	{185, 33, "DEV_MCASP11_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKR_PIN"},
	{185, 34, "DEV_MCASP11_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKR_PIN"},
	{185, 35, "DEV_MCASP11_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKR_PIN"},
	{185, 36, "DEV_MCASP11_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKR_PIN"},
	{185, 37, "DEV_MCASP11_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKR_PIN"},
	{185, 38, "DEV_MCASP11_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKR_PIN"},
	{185, 39, "DEV_MCASP11_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKR_PIN"},
	{185, 40, "DEV_MCASP11_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKR_PIN"},
	{185, 41, "DEV_MCASP11_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP11_MCASP_AHCLKR_PIN"},
	{176, 0, "DEV_MCASP2_VBUSP_CLK", "Input clock"},
	{176, 1, "DEV_MCASP2_AUX_CLK", "Input muxed clock"},
	{176, 2, "DEV_MCASP2_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{176, 3, "DEV_MCASP2_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{176, 4, "DEV_MCASP2_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{176, 6, "DEV_MCASP2_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{176, 7, "DEV_MCASP2_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{176, 8, "DEV_MCASP2_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{176, 9, "DEV_MCASP2_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{176, 10, "DEV_MCASP2_MCASP_ACLKX_POUT", "Output clock"},
	{176, 11, "DEV_MCASP2_MCASP_ACLKX_PIN", "Input clock"},
	{176, 12, "DEV_MCASP2_MCASP_ACLKR_POUT", "Output clock"},
	{176, 13, "DEV_MCASP2_MCASP_ACLKR_PIN", "Input clock"},
	{176, 14, "DEV_MCASP2_MCASP_AHCLKX_POUT", "Output clock"},
	{176, 15, "DEV_MCASP2_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{176, 16, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 17, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 18, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 19, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 20, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 21, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 22, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 23, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 24, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 25, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 26, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 27, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 28, "DEV_MCASP2_MCASP_AHCLKR_POUT", "Output clock"},
	{176, 29, "DEV_MCASP2_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{176, 30, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 31, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 32, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 33, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 34, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 35, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 36, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 37, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 38, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 39, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 40, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 41, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{177, 0, "DEV_MCASP3_VBUSP_CLK", "Input clock"},
	{177, 1, "DEV_MCASP3_AUX_CLK", "Input muxed clock"},
	{177, 2, "DEV_MCASP3_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{177, 3, "DEV_MCASP3_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{177, 4, "DEV_MCASP3_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{177, 6, "DEV_MCASP3_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{177, 7, "DEV_MCASP3_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{177, 8, "DEV_MCASP3_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{177, 9, "DEV_MCASP3_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{177, 10, "DEV_MCASP3_MCASP_ACLKX_POUT", "Output clock"},
	{177, 11, "DEV_MCASP3_MCASP_ACLKX_PIN", "Input clock"},
	{177, 12, "DEV_MCASP3_MCASP_ACLKR_POUT", "Output clock"},
	{177, 13, "DEV_MCASP3_MCASP_ACLKR_PIN", "Input clock"},
	{177, 14, "DEV_MCASP3_MCASP_AHCLKX_POUT", "Output clock"},
	{177, 15, "DEV_MCASP3_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{177, 16, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{177, 17, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{177, 18, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{177, 19, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{177, 20, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{177, 21, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{177, 22, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{177, 23, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{177, 24, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{177, 25, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{177, 26, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{177, 27, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{177, 28, "DEV_MCASP3_MCASP_AHCLKR_POUT", "Output clock"},
	{177, 29, "DEV_MCASP3_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{177, 30, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{177, 31, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{177, 32, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{177, 33, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{177, 34, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{177, 35, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{177, 36, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{177, 37, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{177, 38, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{177, 39, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{177, 40, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{177, 41, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{178, 0, "DEV_MCASP4_VBUSP_CLK", "Input clock"},
	{178, 1, "DEV_MCASP4_AUX_CLK", "Input muxed clock"},
	{178, 2, "DEV_MCASP4_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{178, 3, "DEV_MCASP4_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{178, 4, "DEV_MCASP4_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{178, 6, "DEV_MCASP4_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{178, 7, "DEV_MCASP4_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{178, 8, "DEV_MCASP4_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{178, 9, "DEV_MCASP4_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{178, 10, "DEV_MCASP4_MCASP_ACLKX_POUT", "Output clock"},
	{178, 11, "DEV_MCASP4_MCASP_ACLKX_PIN", "Input clock"},
	{178, 12, "DEV_MCASP4_MCASP_ACLKR_POUT", "Output clock"},
	{178, 13, "DEV_MCASP4_MCASP_ACLKR_PIN", "Input clock"},
	{178, 14, "DEV_MCASP4_MCASP_AHCLKX_POUT", "Output clock"},
	{178, 15, "DEV_MCASP4_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{178, 16, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{178, 17, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{178, 18, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{178, 19, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{178, 20, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{178, 21, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{178, 22, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{178, 23, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{178, 24, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{178, 25, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{178, 26, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{178, 27, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{178, 28, "DEV_MCASP4_MCASP_AHCLKR_POUT", "Output clock"},
	{178, 29, "DEV_MCASP4_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{178, 30, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{178, 31, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{178, 32, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{178, 33, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{178, 34, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{178, 35, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{178, 36, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{178, 37, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{178, 38, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{178, 39, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{178, 40, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{178, 41, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{179, 0, "DEV_MCASP5_VBUSP_CLK", "Input clock"},
	{179, 1, "DEV_MCASP5_AUX_CLK", "Input muxed clock"},
	{179, 2, "DEV_MCASP5_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP5_AUX_CLK"},
	{179, 3, "DEV_MCASP5_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP5_AUX_CLK"},
	{179, 4, "DEV_MCASP5_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP5_AUX_CLK"},
	{179, 6, "DEV_MCASP5_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP5_AUX_CLK"},
	{179, 7, "DEV_MCASP5_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP5_AUX_CLK"},
	{179, 8, "DEV_MCASP5_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP5_AUX_CLK"},
	{179, 9, "DEV_MCASP5_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP5_AUX_CLK"},
	{179, 10, "DEV_MCASP5_MCASP_ACLKX_POUT", "Output clock"},
	{179, 11, "DEV_MCASP5_MCASP_ACLKX_PIN", "Input clock"},
	{179, 12, "DEV_MCASP5_MCASP_ACLKR_POUT", "Output clock"},
	{179, 13, "DEV_MCASP5_MCASP_ACLKR_PIN", "Input clock"},
	{179, 14, "DEV_MCASP5_MCASP_AHCLKX_POUT", "Output clock"},
	{179, 15, "DEV_MCASP5_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{179, 16, "DEV_MCASP5_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKX_PIN"},
	{179, 17, "DEV_MCASP5_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKX_PIN"},
	{179, 18, "DEV_MCASP5_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKX_PIN"},
	{179, 19, "DEV_MCASP5_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKX_PIN"},
	{179, 20, "DEV_MCASP5_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKX_PIN"},
	{179, 21, "DEV_MCASP5_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKX_PIN"},
	{179, 22, "DEV_MCASP5_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKX_PIN"},
	{179, 23, "DEV_MCASP5_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKX_PIN"},
	{179, 24, "DEV_MCASP5_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKX_PIN"},
	{179, 25, "DEV_MCASP5_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKX_PIN"},
	{179, 26, "DEV_MCASP5_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKX_PIN"},
	{179, 27, "DEV_MCASP5_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKX_PIN"},
	{179, 28, "DEV_MCASP5_MCASP_AHCLKR_POUT", "Output clock"},
	{179, 29, "DEV_MCASP5_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{179, 30, "DEV_MCASP5_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKR_PIN"},
	{179, 31, "DEV_MCASP5_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKR_PIN"},
	{179, 32, "DEV_MCASP5_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKR_PIN"},
	{179, 33, "DEV_MCASP5_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKR_PIN"},
	{179, 34, "DEV_MCASP5_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKR_PIN"},
	{179, 35, "DEV_MCASP5_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKR_PIN"},
	{179, 36, "DEV_MCASP5_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKR_PIN"},
	{179, 37, "DEV_MCASP5_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKR_PIN"},
	{179, 38, "DEV_MCASP5_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKR_PIN"},
	{179, 39, "DEV_MCASP5_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKR_PIN"},
	{179, 40, "DEV_MCASP5_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKR_PIN"},
	{179, 41, "DEV_MCASP5_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP5_MCASP_AHCLKR_PIN"},
	{180, 0, "DEV_MCASP6_VBUSP_CLK", "Input clock"},
	{180, 1, "DEV_MCASP6_AUX_CLK", "Input muxed clock"},
	{180, 2, "DEV_MCASP6_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP6_AUX_CLK"},
	{180, 3, "DEV_MCASP6_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP6_AUX_CLK"},
	{180, 4, "DEV_MCASP6_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP6_AUX_CLK"},
	{180, 6, "DEV_MCASP6_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP6_AUX_CLK"},
	{180, 7, "DEV_MCASP6_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP6_AUX_CLK"},
	{180, 8, "DEV_MCASP6_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP6_AUX_CLK"},
	{180, 9, "DEV_MCASP6_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP6_AUX_CLK"},
	{180, 10, "DEV_MCASP6_MCASP_ACLKX_POUT", "Output clock"},
	{180, 11, "DEV_MCASP6_MCASP_ACLKX_PIN", "Input clock"},
	{180, 12, "DEV_MCASP6_MCASP_ACLKR_POUT", "Output clock"},
	{180, 13, "DEV_MCASP6_MCASP_ACLKR_PIN", "Input clock"},
	{180, 14, "DEV_MCASP6_MCASP_AHCLKX_POUT", "Output clock"},
	{180, 15, "DEV_MCASP6_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{180, 16, "DEV_MCASP6_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKX_PIN"},
	{180, 17, "DEV_MCASP6_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKX_PIN"},
	{180, 18, "DEV_MCASP6_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKX_PIN"},
	{180, 19, "DEV_MCASP6_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKX_PIN"},
	{180, 20, "DEV_MCASP6_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKX_PIN"},
	{180, 21, "DEV_MCASP6_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKX_PIN"},
	{180, 22, "DEV_MCASP6_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKX_PIN"},
	{180, 23, "DEV_MCASP6_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKX_PIN"},
	{180, 24, "DEV_MCASP6_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKX_PIN"},
	{180, 25, "DEV_MCASP6_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKX_PIN"},
	{180, 26, "DEV_MCASP6_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKX_PIN"},
	{180, 27, "DEV_MCASP6_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKX_PIN"},
	{180, 28, "DEV_MCASP6_MCASP_AHCLKR_POUT", "Output clock"},
	{180, 29, "DEV_MCASP6_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{180, 30, "DEV_MCASP6_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKR_PIN"},
	{180, 31, "DEV_MCASP6_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKR_PIN"},
	{180, 32, "DEV_MCASP6_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKR_PIN"},
	{180, 33, "DEV_MCASP6_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKR_PIN"},
	{180, 34, "DEV_MCASP6_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKR_PIN"},
	{180, 35, "DEV_MCASP6_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKR_PIN"},
	{180, 36, "DEV_MCASP6_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKR_PIN"},
	{180, 37, "DEV_MCASP6_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKR_PIN"},
	{180, 38, "DEV_MCASP6_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKR_PIN"},
	{180, 39, "DEV_MCASP6_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKR_PIN"},
	{180, 40, "DEV_MCASP6_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKR_PIN"},
	{180, 41, "DEV_MCASP6_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP6_MCASP_AHCLKR_PIN"},
	{181, 0, "DEV_MCASP7_VBUSP_CLK", "Input clock"},
	{181, 1, "DEV_MCASP7_AUX_CLK", "Input muxed clock"},
	{181, 2, "DEV_MCASP7_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP7_AUX_CLK"},
	{181, 3, "DEV_MCASP7_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP7_AUX_CLK"},
	{181, 4, "DEV_MCASP7_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP7_AUX_CLK"},
	{181, 6, "DEV_MCASP7_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP7_AUX_CLK"},
	{181, 7, "DEV_MCASP7_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP7_AUX_CLK"},
	{181, 8, "DEV_MCASP7_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP7_AUX_CLK"},
	{181, 9, "DEV_MCASP7_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP7_AUX_CLK"},
	{181, 10, "DEV_MCASP7_MCASP_ACLKX_POUT", "Output clock"},
	{181, 11, "DEV_MCASP7_MCASP_ACLKX_PIN", "Input clock"},
	{181, 12, "DEV_MCASP7_MCASP_ACLKR_POUT", "Output clock"},
	{181, 13, "DEV_MCASP7_MCASP_ACLKR_PIN", "Input clock"},
	{181, 14, "DEV_MCASP7_MCASP_AHCLKX_POUT", "Output clock"},
	{181, 15, "DEV_MCASP7_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{181, 16, "DEV_MCASP7_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKX_PIN"},
	{181, 17, "DEV_MCASP7_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKX_PIN"},
	{181, 18, "DEV_MCASP7_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKX_PIN"},
	{181, 19, "DEV_MCASP7_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKX_PIN"},
	{181, 20, "DEV_MCASP7_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKX_PIN"},
	{181, 21, "DEV_MCASP7_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKX_PIN"},
	{181, 22, "DEV_MCASP7_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKX_PIN"},
	{181, 23, "DEV_MCASP7_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKX_PIN"},
	{181, 24, "DEV_MCASP7_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKX_PIN"},
	{181, 25, "DEV_MCASP7_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKX_PIN"},
	{181, 26, "DEV_MCASP7_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKX_PIN"},
	{181, 27, "DEV_MCASP7_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKX_PIN"},
	{181, 28, "DEV_MCASP7_MCASP_AHCLKR_POUT", "Output clock"},
	{181, 29, "DEV_MCASP7_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{181, 30, "DEV_MCASP7_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKR_PIN"},
	{181, 31, "DEV_MCASP7_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKR_PIN"},
	{181, 32, "DEV_MCASP7_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKR_PIN"},
	{181, 33, "DEV_MCASP7_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKR_PIN"},
	{181, 34, "DEV_MCASP7_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKR_PIN"},
	{181, 35, "DEV_MCASP7_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKR_PIN"},
	{181, 36, "DEV_MCASP7_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKR_PIN"},
	{181, 37, "DEV_MCASP7_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKR_PIN"},
	{181, 38, "DEV_MCASP7_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKR_PIN"},
	{181, 39, "DEV_MCASP7_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKR_PIN"},
	{181, 40, "DEV_MCASP7_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKR_PIN"},
	{181, 41, "DEV_MCASP7_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP7_MCASP_AHCLKR_PIN"},
	{182, 0, "DEV_MCASP8_VBUSP_CLK", "Input clock"},
	{182, 1, "DEV_MCASP8_AUX_CLK", "Input muxed clock"},
	{182, 2, "DEV_MCASP8_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP8_AUX_CLK"},
	{182, 3, "DEV_MCASP8_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP8_AUX_CLK"},
	{182, 4, "DEV_MCASP8_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP8_AUX_CLK"},
	{182, 6, "DEV_MCASP8_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP8_AUX_CLK"},
	{182, 7, "DEV_MCASP8_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP8_AUX_CLK"},
	{182, 8, "DEV_MCASP8_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP8_AUX_CLK"},
	{182, 9, "DEV_MCASP8_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP8_AUX_CLK"},
	{182, 10, "DEV_MCASP8_MCASP_ACLKX_POUT", "Output clock"},
	{182, 11, "DEV_MCASP8_MCASP_ACLKX_PIN", "Input clock"},
	{182, 12, "DEV_MCASP8_MCASP_ACLKR_POUT", "Output clock"},
	{182, 13, "DEV_MCASP8_MCASP_ACLKR_PIN", "Input clock"},
	{182, 14, "DEV_MCASP8_MCASP_AHCLKX_POUT", "Output clock"},
	{182, 15, "DEV_MCASP8_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{182, 16, "DEV_MCASP8_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKX_PIN"},
	{182, 17, "DEV_MCASP8_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKX_PIN"},
	{182, 18, "DEV_MCASP8_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKX_PIN"},
	{182, 19, "DEV_MCASP8_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKX_PIN"},
	{182, 20, "DEV_MCASP8_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKX_PIN"},
	{182, 21, "DEV_MCASP8_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKX_PIN"},
	{182, 22, "DEV_MCASP8_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKX_PIN"},
	{182, 23, "DEV_MCASP8_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKX_PIN"},
	{182, 24, "DEV_MCASP8_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKX_PIN"},
	{182, 25, "DEV_MCASP8_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKX_PIN"},
	{182, 26, "DEV_MCASP8_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKX_PIN"},
	{182, 27, "DEV_MCASP8_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKX_PIN"},
	{182, 28, "DEV_MCASP8_MCASP_AHCLKR_POUT", "Output clock"},
	{182, 29, "DEV_MCASP8_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{182, 30, "DEV_MCASP8_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKR_PIN"},
	{182, 31, "DEV_MCASP8_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKR_PIN"},
	{182, 32, "DEV_MCASP8_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKR_PIN"},
	{182, 33, "DEV_MCASP8_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKR_PIN"},
	{182, 34, "DEV_MCASP8_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKR_PIN"},
	{182, 35, "DEV_MCASP8_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKR_PIN"},
	{182, 36, "DEV_MCASP8_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKR_PIN"},
	{182, 37, "DEV_MCASP8_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKR_PIN"},
	{182, 38, "DEV_MCASP8_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKR_PIN"},
	{182, 39, "DEV_MCASP8_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKR_PIN"},
	{182, 40, "DEV_MCASP8_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKR_PIN"},
	{182, 41, "DEV_MCASP8_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP8_MCASP_AHCLKR_PIN"},
	{183, 0, "DEV_MCASP9_VBUSP_CLK", "Input clock"},
	{183, 1, "DEV_MCASP9_AUX_CLK", "Input muxed clock"},
	{183, 2, "DEV_MCASP9_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP9_AUX_CLK"},
	{183, 3, "DEV_MCASP9_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP9_AUX_CLK"},
	{183, 4, "DEV_MCASP9_AUX_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP9_AUX_CLK"},
	{183, 6, "DEV_MCASP9_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP9_AUX_CLK"},
	{183, 7, "DEV_MCASP9_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP9_AUX_CLK"},
	{183, 8, "DEV_MCASP9_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP9_AUX_CLK"},
	{183, 9, "DEV_MCASP9_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP9_AUX_CLK"},
	{183, 10, "DEV_MCASP9_MCASP_ACLKX_POUT", "Output clock"},
	{183, 11, "DEV_MCASP9_MCASP_ACLKX_PIN", "Input clock"},
	{183, 12, "DEV_MCASP9_MCASP_ACLKR_POUT", "Output clock"},
	{183, 13, "DEV_MCASP9_MCASP_ACLKR_PIN", "Input clock"},
	{183, 14, "DEV_MCASP9_MCASP_AHCLKX_POUT", "Output clock"},
	{183, 15, "DEV_MCASP9_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{183, 16, "DEV_MCASP9_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKX_PIN"},
	{183, 17, "DEV_MCASP9_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKX_PIN"},
	{183, 18, "DEV_MCASP9_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKX_PIN"},
	{183, 19, "DEV_MCASP9_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKX_PIN"},
	{183, 20, "DEV_MCASP9_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKX_PIN"},
	{183, 21, "DEV_MCASP9_MCASP_AHCLKX_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKX_PIN"},
	{183, 22, "DEV_MCASP9_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKX_PIN"},
	{183, 23, "DEV_MCASP9_MCASP_AHCLKX_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKX_PIN"},
	{183, 24, "DEV_MCASP9_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKX_PIN"},
	{183, 25, "DEV_MCASP9_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKX_PIN"},
	{183, 26, "DEV_MCASP9_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKX_PIN"},
	{183, 27, "DEV_MCASP9_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKX_PIN"},
	{183, 28, "DEV_MCASP9_MCASP_AHCLKR_POUT", "Output clock"},
	{183, 29, "DEV_MCASP9_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{183, 30, "DEV_MCASP9_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKR_PIN"},
	{183, 31, "DEV_MCASP9_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKR_PIN"},
	{183, 32, "DEV_MCASP9_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT0", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKR_PIN"},
	{183, 33, "DEV_MCASP9_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT1", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKR_PIN"},
	{183, 34, "DEV_MCASP9_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT2", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKR_PIN"},
	{183, 35, "DEV_MCASP9_MCASP_AHCLKR_PIN_PARENT_MCASP_AHCLKO_MUX_OUT3", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKR_PIN"},
	{183, 36, "DEV_MCASP9_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCLK_OUT", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKR_PIN"},
	{183, 37, "DEV_MCASP9_MCASP_AHCLKR_PIN_PARENT_BOARD_0_MLB0_MLBCP_OUT2", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKR_PIN"},
	{183, 38, "DEV_MCASP9_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKR_PIN"},
	{183, 39, "DEV_MCASP9_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKR_PIN"},
	{183, 40, "DEV_MCASP9_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKR_PIN"},
	{183, 41, "DEV_MCASP9_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP9_MCASP_AHCLKR_PIN"},
	{266, 0, "DEV_MCSPI0_VBUSP_CLK", "Input clock"},
	{266, 1, "DEV_MCSPI0_CLKSPIREF_CLK", "Input clock"},
	{266, 2, "DEV_MCSPI0_IO_CLKSPIO_CLK", "Output clock"},
	{267, 0, "DEV_MCSPI1_VBUSP_CLK", "Input clock"},
	{267, 1, "DEV_MCSPI1_CLKSPIREF_CLK", "Input clock"},
	{267, 2, "DEV_MCSPI1_IO_CLKSPIO_CLK", "Output clock"},
	{268, 0, "DEV_MCSPI2_VBUSP_CLK", "Input clock"},
	{268, 1, "DEV_MCSPI2_CLKSPIREF_CLK", "Input clock"},
	{268, 2, "DEV_MCSPI2_IO_CLKSPIO_CLK", "Output clock"},
	{269, 0, "DEV_MCSPI3_VBUSP_CLK", "Input clock"},
	{269, 1, "DEV_MCSPI3_CLKSPIREF_CLK", "Input clock"},
	{269, 2, "DEV_MCSPI3_IO_CLKSPII_CLK", "Input muxed clock"},
	{269, 3, "DEV_MCSPI3_IO_CLKSPII_CLK_PARENT_SPI_MAIN_3_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI3_IO_CLKSPII_CLK"},
	{269, 4, "DEV_MCSPI3_IO_CLKSPIO_CLK", "Output clock"},
	{270, 0, "DEV_MCSPI4_VBUSP_CLK", "Input clock"},
	{270, 1, "DEV_MCSPI4_CLKSPIREF_CLK", "Input clock"},
	{270, 2, "DEV_MCSPI4_IO_CLKSPII_CLK", "Input clock"},
	{270, 3, "DEV_MCSPI4_IO_CLKSPIO_CLK", "Output clock"},
	{271, 0, "DEV_MCSPI5_VBUSP_CLK", "Input clock"},
	{271, 1, "DEV_MCSPI5_CLKSPIREF_CLK", "Input clock"},
	{271, 2, "DEV_MCSPI5_IO_CLKSPIO_CLK", "Output clock"},
	{272, 0, "DEV_MCSPI6_VBUSP_CLK", "Input clock"},
	{272, 1, "DEV_MCSPI6_CLKSPIREF_CLK", "Input clock"},
	{272, 2, "DEV_MCSPI6_IO_CLKSPIO_CLK", "Output clock"},
	{273, 0, "DEV_MCSPI7_VBUSP_CLK", "Input clock"},
	{273, 1, "DEV_MCSPI7_CLKSPIREF_CLK", "Input clock"},
	{273, 2, "DEV_MCSPI7_IO_CLKSPIO_CLK", "Output clock"},
	{0, 0, "DEV_MCU_ADC12_16FFC0_SYS_CLK", "Input clock"},
	{0, 1, "DEV_MCU_ADC12_16FFC0_ADC_CLK", "Input muxed clock"},
	{0, 2, "DEV_MCU_ADC12_16FFC0_ADC_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_ADC12_16FFC0_ADC_CLK"},
	{0, 3, "DEV_MCU_ADC12_16FFC0_ADC_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_ADC12_16FFC0_ADC_CLK"},
	{0, 4, "DEV_MCU_ADC12_16FFC0_ADC_CLK_PARENT_HSDIV1_16FFT_MCU_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_ADC12_16FFC0_ADC_CLK"},
	{0, 5, "DEV_MCU_ADC12_16FFC0_ADC_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_ADC12_16FFC0_ADC_CLK"},
	{0, 6, "DEV_MCU_ADC12_16FFC0_VBUS_CLK", "Input clock"},
	{1, 0, "DEV_MCU_ADC12_16FFC1_SYS_CLK", "Input clock"},
	{1, 1, "DEV_MCU_ADC12_16FFC1_ADC_CLK", "Input muxed clock"},
	{1, 2, "DEV_MCU_ADC12_16FFC1_ADC_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_ADC12_16FFC1_ADC_CLK"},
	{1, 3, "DEV_MCU_ADC12_16FFC1_ADC_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_ADC12_16FFC1_ADC_CLK"},
	{1, 4, "DEV_MCU_ADC12_16FFC1_ADC_CLK_PARENT_HSDIV1_16FFT_MCU_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_ADC12_16FFC1_ADC_CLK"},
	{1, 5, "DEV_MCU_ADC12_16FFC1_ADC_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_ADC12_16FFC1_ADC_CLK"},
	{1, 6, "DEV_MCU_ADC12_16FFC1_VBUS_CLK", "Input clock"},
	{18, 0, "DEV_MCU_CPSW0_RGMII1_RXC_I", "Input clock"},
	{18, 1, "DEV_MCU_CPSW0_RGMII_MHZ_250_CLK", "Input clock"},
	{18, 2, "DEV_MCU_CPSW0_CPTS_RFT_CLK", "Input muxed clock"},
	{18, 3, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 4, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 5, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 6, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 7, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 8, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 9, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 10, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 11, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 12, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 13, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN0_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 14, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN1_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 15, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B4M4CS_MAIN_3_IP2_LN0_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 16, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B4M4CS_MAIN_3_IP2_LN1_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 17, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 18, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK2", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 19, "DEV_MCU_CPSW0_GMII_RFT_CLK", "Input clock"},
	{18, 20, "DEV_MCU_CPSW0_RMII_MHZ_50_CLK", "Input clock"},
	{18, 21, "DEV_MCU_CPSW0_RGMII_MHZ_50_CLK", "Input clock"},
	{18, 22, "DEV_MCU_CPSW0_CPPI_CLK_CLK", "Input clock"},
	{18, 23, "DEV_MCU_CPSW0_RGMII_MHZ_5_CLK", "Input clock"},
	{18, 24, "DEV_MCU_CPSW0_GMII1_MR_CLK", "Input clock"},
	{18, 25, "DEV_MCU_CPSW0_GMII1_MT_CLK", "Input clock"},
	{18, 26, "DEV_MCU_CPSW0_RGMII1_TXC_I", "Input clock"},
	{18, 27, "DEV_MCU_CPSW0_RGMII1_TXC_O", "Output clock"},
	{18, 28, "DEV_MCU_CPSW0_CPTS_GENF0", "Output clock"},
	{18, 29, "DEV_MCU_CPSW0_MDIO_MDCLK_O", "Output clock"},
	{24, 0, "DEV_MCU_CPT2_AGGR0_VCLK_CLK", "Input clock"},
	{44, 0, "DEV_MCU_DCC0_DCC_INPUT10_CLK", "Input clock"},
	{44, 1, "DEV_MCU_DCC0_DCC_INPUT01_CLK", "Input clock"},
	{44, 2, "DEV_MCU_DCC0_DCC_CLKSRC2_CLK", "Input clock"},
	{44, 3, "DEV_MCU_DCC0_DCC_CLKSRC7_CLK", "Input clock"},
	{44, 4, "DEV_MCU_DCC0_DCC_CLKSRC0_CLK", "Input clock"},
	{44, 5, "DEV_MCU_DCC0_VBUS_CLK", "Input clock"},
	{44, 6, "DEV_MCU_DCC0_DCC_CLKSRC4_CLK", "Input clock"},
	{44, 7, "DEV_MCU_DCC0_DCC_CLKSRC1_CLK", "Input clock"},
	{44, 8, "DEV_MCU_DCC0_DCC_CLKSRC3_CLK", "Input clock"},
	{44, 9, "DEV_MCU_DCC0_DCC_INPUT00_CLK", "Input clock"},
	{44, 10, "DEV_MCU_DCC0_DCC_CLKSRC5_CLK", "Input clock"},
	{44, 11, "DEV_MCU_DCC0_DCC_CLKSRC6_CLK", "Input clock"},
	{44, 12, "DEV_MCU_DCC0_DCC_INPUT02_CLK", "Input clock"},
	{45, 0, "DEV_MCU_DCC1_DCC_INPUT10_CLK", "Input clock"},
	{45, 1, "DEV_MCU_DCC1_DCC_INPUT01_CLK", "Input clock"},
	{45, 2, "DEV_MCU_DCC1_DCC_CLKSRC2_CLK", "Input clock"},
	{45, 3, "DEV_MCU_DCC1_DCC_CLKSRC7_CLK", "Input clock"},
	{45, 4, "DEV_MCU_DCC1_DCC_CLKSRC0_CLK", "Input clock"},
	{45, 5, "DEV_MCU_DCC1_VBUS_CLK", "Input clock"},
	{45, 6, "DEV_MCU_DCC1_DCC_CLKSRC4_CLK", "Input clock"},
	{45, 7, "DEV_MCU_DCC1_DCC_CLKSRC1_CLK", "Input clock"},
	{45, 8, "DEV_MCU_DCC1_DCC_CLKSRC3_CLK", "Input clock"},
	{45, 9, "DEV_MCU_DCC1_DCC_INPUT00_CLK", "Input clock"},
	{45, 10, "DEV_MCU_DCC1_DCC_CLKSRC5_CLK", "Input clock"},
	{45, 11, "DEV_MCU_DCC1_DCC_CLKSRC6_CLK", "Input clock"},
	{45, 12, "DEV_MCU_DCC1_DCC_INPUT02_CLK", "Input clock"},
	{46, 0, "DEV_MCU_DCC2_DCC_INPUT10_CLK", "Input clock"},
	{46, 1, "DEV_MCU_DCC2_DCC_INPUT01_CLK", "Input clock"},
	{46, 2, "DEV_MCU_DCC2_DCC_CLKSRC7_CLK", "Input clock"},
	{46, 3, "DEV_MCU_DCC2_DCC_CLKSRC0_CLK", "Input clock"},
	{46, 4, "DEV_MCU_DCC2_VBUS_CLK", "Input clock"},
	{46, 5, "DEV_MCU_DCC2_DCC_CLKSRC4_CLK", "Input clock"},
	{46, 6, "DEV_MCU_DCC2_DCC_CLKSRC1_CLK", "Input clock"},
	{46, 7, "DEV_MCU_DCC2_DCC_CLKSRC3_CLK", "Input clock"},
	{46, 8, "DEV_MCU_DCC2_DCC_INPUT00_CLK", "Input clock"},
	{46, 9, "DEV_MCU_DCC2_DCC_CLKSRC6_CLK", "Input clock"},
	{46, 10, "DEV_MCU_DCC2_DCC_INPUT02_CLK", "Input clock"},
	{98, 0, "DEV_MCU_ESM0_CLK", "Input clock"},
	{101, 0, "DEV_MCU_FSS0_FSAS_0_GCLK", "Input clock"},
	{102, 0, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_CLKX2_INV_CLK", "Input clock"},
	{102, 1, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_CLKX1_INV_CLK", "Input clock"},
	{102, 2, "DEV_MCU_FSS0_HYPERBUS1P0_0_CBA_CLK", "Input clock"},
	{102, 3, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_CLKX2_CLK", "Input clock"},
	{102, 4, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_CLKX1_CLK", "Input clock"},
	{102, 5, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_OUT_CLK_N", "Output clock"},
	{102, 6, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_OUT_CLK_P", "Output clock"},
	{103, 0, "DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK", "Input muxed clock"},
	{103, 1, "DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK"},
	{103, 2, "DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK"},
	{103, 3, "DEV_MCU_FSS0_OSPI_0_OSPI_HCLK_CLK", "Input clock"},
	{103, 4, "DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK", "Input muxed clock"},
	{103, 5, "DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK_PARENT_BOARD_0_MCU_OSPI0_DQS_OUT", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK"},
	{103, 6, "DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK_PARENT_FSS_MCU_0_OSPI_0_OSPI_OCLK_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK"},
	{103, 7, "DEV_MCU_FSS0_OSPI_0_OSPI_PCLK_CLK", "Input clock"},
	{103, 8, "DEV_MCU_FSS0_OSPI_0_OSPI_DQS_CLK", "Input clock"},
	{103, 9, "DEV_MCU_FSS0_OSPI_0_OSPI_OCLK_CLK", "Output clock"},
	{104, 0, "DEV_MCU_FSS0_OSPI_1_OSPI_RCLK_CLK", "Input muxed clock"},
	{104, 1, "DEV_MCU_FSS0_OSPI_1_OSPI_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_1_OSPI_RCLK_CLK"},
	{104, 2, "DEV_MCU_FSS0_OSPI_1_OSPI_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_1_OSPI_RCLK_CLK"},
	{104, 3, "DEV_MCU_FSS0_OSPI_1_OSPI_HCLK_CLK", "Input clock"},
	{104, 4, "DEV_MCU_FSS0_OSPI_1_OSPI_ICLK_CLK", "Input muxed clock"},
	{104, 5, "DEV_MCU_FSS0_OSPI_1_OSPI_ICLK_CLK_PARENT_BOARD_0_MCU_OSPI1_DQS_OUT", "Parent input clock option to DEV_MCU_FSS0_OSPI_1_OSPI_ICLK_CLK"},
	{104, 6, "DEV_MCU_FSS0_OSPI_1_OSPI_ICLK_CLK_PARENT_FSS_MCU_0_OSPI_1_OSPI_OCLK_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_1_OSPI_ICLK_CLK"},
	{104, 7, "DEV_MCU_FSS0_OSPI_1_OSPI_PCLK_CLK", "Input clock"},
	{104, 8, "DEV_MCU_FSS0_OSPI_1_OSPI_DQS_CLK", "Input clock"},
	{104, 9, "DEV_MCU_FSS0_OSPI_1_OSPI_OCLK_CLK", "Output clock"},
	{194, 0, "DEV_MCU_I2C0_PISYS_CLK", "Input clock"},
	{194, 1, "DEV_MCU_I2C0_PISCL", "Input clock"},
	{194, 2, "DEV_MCU_I2C0_CLK", "Input clock"},
	{194, 3, "DEV_MCU_I2C0_PORSCL", "Output clock"},
	{195, 0, "DEV_MCU_I2C1_PISYS_CLK", "Input clock"},
	{195, 1, "DEV_MCU_I2C1_PISCL", "Input clock"},
	{195, 2, "DEV_MCU_I2C1_CLK", "Input clock"},
	{195, 3, "DEV_MCU_I2C1_PORSCL", "Output clock"},
	{117, 0, "DEV_MCU_I3C0_I3C_PCLK_CLK", "Input clock"},
	{117, 1, "DEV_MCU_I3C0_I3C_SCL_DI", "Input clock"},
	{117, 2, "DEV_MCU_I3C0_I3C_SCLK_CLK", "Input clock"},
	{117, 3, "DEV_MCU_I3C0_I3C_SCL_DO", "Output clock"},
	{118, 0, "DEV_MCU_I3C1_I3C_PCLK_CLK", "Input clock"},
	{118, 1, "DEV_MCU_I3C1_I3C_SCL_DI", "Input clock"},
	{118, 2, "DEV_MCU_I3C1_I3C_SCLK_CLK", "Input clock"},
	{118, 3, "DEV_MCU_I3C1_I3C_SCL_DO", "Output clock"},
	{172, 0, "DEV_MCU_MCAN0_MCANSS_HCLK_CLK", "Input clock"},
	{172, 1, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK", "Input muxed clock"},
	{172, 2, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{172, 3, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{172, 4, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{172, 5, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{173, 0, "DEV_MCU_MCAN1_MCANSS_HCLK_CLK", "Input clock"},
	{173, 1, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK", "Input muxed clock"},
	{173, 2, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{173, 3, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{173, 4, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{173, 5, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{274, 0, "DEV_MCU_MCSPI0_VBUSP_CLK", "Input clock"},
	{274, 1, "DEV_MCU_MCSPI0_CLKSPIREF_CLK", "Input clock"},
	{274, 2, "DEV_MCU_MCSPI0_IO_CLKSPIO_CLK", "Output clock"},
	{275, 0, "DEV_MCU_MCSPI1_VBUSP_CLK", "Input clock"},
	{275, 1, "DEV_MCU_MCSPI1_CLKSPIREF_CLK", "Input clock"},
	{275, 2, "DEV_MCU_MCSPI1_IO_CLKSPII_CLK", "Input muxed clock"},
	{275, 3, "DEV_MCU_MCSPI1_IO_CLKSPII_CLK_PARENT_SPI_MAIN_3_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCU_MCSPI1_IO_CLKSPII_CLK"},
	{275, 4, "DEV_MCU_MCSPI1_IO_CLKSPIO_CLK", "Output clock"},
	{276, 0, "DEV_MCU_MCSPI2_VBUSP_CLK", "Input clock"},
	{276, 1, "DEV_MCU_MCSPI2_CLKSPIREF_CLK", "Input clock"},
	{276, 2, "DEV_MCU_MCSPI2_IO_CLKSPII_CLK", "Input clock"},
	{276, 3, "DEV_MCU_MCSPI2_IO_CLKSPIO_CLK", "Output clock"},
	{237, 0, "DEV_MCU_NAVSS0_INTR_0_INTR_CLK", "Input clock"},
	{238, 0, "DEV_MCU_NAVSS0_MCRC_0_CLK", "Input clock"},
	{302, 0, "DEV_MCU_NAVSS0_MODSS_VD2CLK", "Input clock"},
	{234, 0, "DEV_MCU_NAVSS0_PROXY0_CLK_CLK", "Input clock"},
	{235, 0, "DEV_MCU_NAVSS0_RINGACC0_SYS_CLK", "Input clock"},
	{236, 0, "DEV_MCU_NAVSS0_UDMAP_0_SYS_CLK", "Input clock"},
	{303, 0, "DEV_MCU_NAVSS0_UDMASS_VD2CLK", "Input clock"},
	{233, 0, "DEV_MCU_NAVSS0_UDMASS_INTA_0_SYS_CLK", "Input clock"},
	{250, 0, "DEV_MCU_R5FSS0_CORE0_CPU_CLK", "Input muxed clock"},
	{250, 1, "DEV_MCU_R5FSS0_CORE0_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_MCU_R5FSS0_CORE0_CPU_CLK"},
	{250, 2, "DEV_MCU_R5FSS0_CORE0_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK3", "Parent input clock option to DEV_MCU_R5FSS0_CORE0_CPU_CLK"},
	{250, 3, "DEV_MCU_R5FSS0_CORE0_INTERFACE_CLK", "Input clock"},
	{250, 4, "DEV_MCU_R5FSS0_CORE0_INTERFACE_PHASE", "Input clock"},
	{251, 0, "DEV_MCU_R5FSS0_CORE1_CPU_CLK", "Input muxed clock"},
	{251, 1, "DEV_MCU_R5FSS0_CORE1_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_MCU_R5FSS0_CORE1_CPU_CLK"},
	{251, 2, "DEV_MCU_R5FSS0_CORE1_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK3", "Parent input clock option to DEV_MCU_R5FSS0_CORE1_CPU_CLK"},
	{251, 3, "DEV_MCU_R5FSS0_CORE1_INTERFACE_CLK", "Input clock"},
	{251, 4, "DEV_MCU_R5FSS0_CORE1_INTERFACE_PHASE", "Input clock"},
	{262, 0, "DEV_MCU_RTI0_VBUSP_CLK", "Input clock"},
	{262, 1, "DEV_MCU_RTI0_RTI_CLK", "Input muxed clock"},
	{262, 2, "DEV_MCU_RTI0_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{262, 3, "DEV_MCU_RTI0_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{262, 4, "DEV_MCU_RTI0_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{262, 5, "DEV_MCU_RTI0_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{263, 0, "DEV_MCU_RTI1_VBUSP_CLK", "Input clock"},
	{263, 1, "DEV_MCU_RTI1_RTI_CLK", "Input muxed clock"},
	{263, 2, "DEV_MCU_RTI1_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_RTI1_RTI_CLK"},
	{263, 3, "DEV_MCU_RTI1_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_RTI1_RTI_CLK"},
	{263, 4, "DEV_MCU_RTI1_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_RTI1_RTI_CLK"},
	{263, 5, "DEV_MCU_RTI1_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_RTI1_RTI_CLK"},
	{265, 0, "DEV_MCU_SA2_UL0_X2_CLK", "Input clock"},
	{265, 1, "DEV_MCU_SA2_UL0_PKA_IN_CLK", "Input clock"},
	{265, 2, "DEV_MCU_SA2_UL0_X1_CLK", "Input clock"},
	{35, 0, "DEV_MCU_TIMER0_TIMER_HCLK_CLK", "Input clock"},
	{35, 1, "DEV_MCU_TIMER0_TIMER_TCLK_CLK", "Input muxed clock"},
	{35, 2, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 3, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK6", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 4, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 5, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 6, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 7, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 8, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 9, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 10, "DEV_MCU_TIMER0_TIMER_PWM", "Output clock"},
	{71, 0, "DEV_MCU_TIMER1_TIMER_HCLK_CLK", "Input clock"},
	{71, 1, "DEV_MCU_TIMER1_TIMER_TCLK_CLK", "Input muxed clock"},
	{71, 2, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT1", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{71, 3, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_0_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{322, 0, "DEV_MCU_TIMER1_CLKSEL_VD_CLK", "Input muxed clock"},
	{322, 1, "DEV_MCU_TIMER1_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER1_CLKSEL_VD_CLK"},
	{322, 2, "DEV_MCU_TIMER1_CLKSEL_VD_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK6", "Parent input clock option to DEV_MCU_TIMER1_CLKSEL_VD_CLK"},
	{322, 3, "DEV_MCU_TIMER1_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER1_CLKSEL_VD_CLK"},
	{322, 4, "DEV_MCU_TIMER1_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER1_CLKSEL_VD_CLK"},
	{322, 5, "DEV_MCU_TIMER1_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER1_CLKSEL_VD_CLK"},
	{322, 6, "DEV_MCU_TIMER1_CLKSEL_VD_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER1_CLKSEL_VD_CLK"},
	{322, 7, "DEV_MCU_TIMER1_CLKSEL_VD_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER1_CLKSEL_VD_CLK"},
	{322, 8, "DEV_MCU_TIMER1_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER1_CLKSEL_VD_CLK"},
	{72, 0, "DEV_MCU_TIMER2_TIMER_HCLK_CLK", "Input clock"},
	{72, 1, "DEV_MCU_TIMER2_TIMER_TCLK_CLK", "Input muxed clock"},
	{72, 2, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{72, 3, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK6", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{72, 4, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{72, 5, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{72, 6, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{72, 7, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{72, 8, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{72, 9, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{72, 10, "DEV_MCU_TIMER2_TIMER_PWM", "Output clock"},
	{73, 0, "DEV_MCU_TIMER3_TIMER_HCLK_CLK", "Input clock"},
	{73, 1, "DEV_MCU_TIMER3_TIMER_TCLK_CLK", "Input muxed clock"},
	{73, 2, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT3", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{73, 3, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_2_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{323, 0, "DEV_MCU_TIMER3_CLKSEL_VD_CLK", "Input muxed clock"},
	{323, 1, "DEV_MCU_TIMER3_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER3_CLKSEL_VD_CLK"},
	{323, 2, "DEV_MCU_TIMER3_CLKSEL_VD_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK6", "Parent input clock option to DEV_MCU_TIMER3_CLKSEL_VD_CLK"},
	{323, 3, "DEV_MCU_TIMER3_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER3_CLKSEL_VD_CLK"},
	{323, 4, "DEV_MCU_TIMER3_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER3_CLKSEL_VD_CLK"},
	{323, 5, "DEV_MCU_TIMER3_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER3_CLKSEL_VD_CLK"},
	{323, 6, "DEV_MCU_TIMER3_CLKSEL_VD_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER3_CLKSEL_VD_CLK"},
	{323, 7, "DEV_MCU_TIMER3_CLKSEL_VD_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER3_CLKSEL_VD_CLK"},
	{323, 8, "DEV_MCU_TIMER3_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER3_CLKSEL_VD_CLK"},
	{74, 0, "DEV_MCU_TIMER4_TIMER_HCLK_CLK", "Input clock"},
	{74, 1, "DEV_MCU_TIMER4_TIMER_TCLK_CLK", "Input muxed clock"},
	{74, 2, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{74, 3, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK6", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{74, 4, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{74, 5, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{74, 6, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{74, 7, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{74, 8, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{74, 9, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{74, 10, "DEV_MCU_TIMER4_TIMER_PWM", "Output clock"},
	{75, 0, "DEV_MCU_TIMER5_TIMER_HCLK_CLK", "Input clock"},
	{75, 1, "DEV_MCU_TIMER5_TIMER_TCLK_CLK", "Input muxed clock"},
	{75, 2, "DEV_MCU_TIMER5_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT5", "Parent input clock option to DEV_MCU_TIMER5_TIMER_TCLK_CLK"},
	{75, 3, "DEV_MCU_TIMER5_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_4_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER5_TIMER_TCLK_CLK"},
	{324, 0, "DEV_MCU_TIMER5_CLKSEL_VD_CLK", "Input muxed clock"},
	{324, 1, "DEV_MCU_TIMER5_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER5_CLKSEL_VD_CLK"},
	{324, 2, "DEV_MCU_TIMER5_CLKSEL_VD_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK6", "Parent input clock option to DEV_MCU_TIMER5_CLKSEL_VD_CLK"},
	{324, 3, "DEV_MCU_TIMER5_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER5_CLKSEL_VD_CLK"},
	{324, 4, "DEV_MCU_TIMER5_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER5_CLKSEL_VD_CLK"},
	{324, 5, "DEV_MCU_TIMER5_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER5_CLKSEL_VD_CLK"},
	{324, 6, "DEV_MCU_TIMER5_CLKSEL_VD_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER5_CLKSEL_VD_CLK"},
	{324, 7, "DEV_MCU_TIMER5_CLKSEL_VD_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER5_CLKSEL_VD_CLK"},
	{324, 8, "DEV_MCU_TIMER5_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER5_CLKSEL_VD_CLK"},
	{76, 0, "DEV_MCU_TIMER6_TIMER_HCLK_CLK", "Input clock"},
	{76, 1, "DEV_MCU_TIMER6_TIMER_TCLK_CLK", "Input muxed clock"},
	{76, 2, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{76, 3, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK6", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{76, 4, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{76, 5, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{76, 6, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{76, 7, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{76, 8, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{76, 9, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{76, 10, "DEV_MCU_TIMER6_TIMER_PWM", "Output clock"},
	{77, 0, "DEV_MCU_TIMER7_TIMER_HCLK_CLK", "Input clock"},
	{77, 1, "DEV_MCU_TIMER7_TIMER_TCLK_CLK", "Input muxed clock"},
	{77, 2, "DEV_MCU_TIMER7_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT7", "Parent input clock option to DEV_MCU_TIMER7_TIMER_TCLK_CLK"},
	{77, 3, "DEV_MCU_TIMER7_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_6_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER7_TIMER_TCLK_CLK"},
	{325, 0, "DEV_MCU_TIMER7_CLKSEL_VD_CLK", "Input muxed clock"},
	{325, 1, "DEV_MCU_TIMER7_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER7_CLKSEL_VD_CLK"},
	{325, 2, "DEV_MCU_TIMER7_CLKSEL_VD_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK6", "Parent input clock option to DEV_MCU_TIMER7_CLKSEL_VD_CLK"},
	{325, 3, "DEV_MCU_TIMER7_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER7_CLKSEL_VD_CLK"},
	{325, 4, "DEV_MCU_TIMER7_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER7_CLKSEL_VD_CLK"},
	{325, 5, "DEV_MCU_TIMER7_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER7_CLKSEL_VD_CLK"},
	{325, 6, "DEV_MCU_TIMER7_CLKSEL_VD_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER7_CLKSEL_VD_CLK"},
	{325, 7, "DEV_MCU_TIMER7_CLKSEL_VD_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER7_CLKSEL_VD_CLK"},
	{325, 8, "DEV_MCU_TIMER7_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER7_CLKSEL_VD_CLK"},
	{78, 0, "DEV_MCU_TIMER8_TIMER_HCLK_CLK", "Input clock"},
	{78, 1, "DEV_MCU_TIMER8_TIMER_TCLK_CLK", "Input muxed clock"},
	{78, 2, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{78, 3, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK6", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{78, 4, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{78, 5, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{78, 6, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{78, 7, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{78, 8, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{78, 9, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{78, 10, "DEV_MCU_TIMER8_TIMER_PWM", "Output clock"},
	{79, 0, "DEV_MCU_TIMER9_TIMER_HCLK_CLK", "Input clock"},
	{79, 1, "DEV_MCU_TIMER9_TIMER_TCLK_CLK", "Input muxed clock"},
	{79, 2, "DEV_MCU_TIMER9_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT9", "Parent input clock option to DEV_MCU_TIMER9_TIMER_TCLK_CLK"},
	{79, 3, "DEV_MCU_TIMER9_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_8_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER9_TIMER_TCLK_CLK"},
	{326, 0, "DEV_MCU_TIMER9_CLKSEL_VD_CLK", "Input muxed clock"},
	{326, 1, "DEV_MCU_TIMER9_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER9_CLKSEL_VD_CLK"},
	{326, 2, "DEV_MCU_TIMER9_CLKSEL_VD_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK6", "Parent input clock option to DEV_MCU_TIMER9_CLKSEL_VD_CLK"},
	{326, 3, "DEV_MCU_TIMER9_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER9_CLKSEL_VD_CLK"},
	{326, 4, "DEV_MCU_TIMER9_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER9_CLKSEL_VD_CLK"},
	{326, 5, "DEV_MCU_TIMER9_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER9_CLKSEL_VD_CLK"},
	{326, 6, "DEV_MCU_TIMER9_CLKSEL_VD_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER9_CLKSEL_VD_CLK"},
	{326, 7, "DEV_MCU_TIMER9_CLKSEL_VD_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER9_CLKSEL_VD_CLK"},
	{326, 8, "DEV_MCU_TIMER9_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER9_CLKSEL_VD_CLK"},
	{149, 0, "DEV_MCU_UART0_FCLK_CLK", "Input muxed clock"},
	{149, 1, "DEV_MCU_UART0_FCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_UART0_FCLK_CLK"},
	{149, 2, "DEV_MCU_UART0_FCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_1_HSDIVOUT5_CLK", "Parent input clock option to DEV_MCU_UART0_FCLK_CLK"},
	{149, 3, "DEV_MCU_UART0_VBUSP_CLK", "Input clock"},
	{186, 0, "DEV_MLB0_MLBSS_MLB_CLK", "Input clock"},
	{186, 1, "DEV_MLB0_MLBSS_SCLK_CLK", "Input clock"},
	{186, 2, "DEV_MLB0_MLBSS_HCLK_CLK", "Input clock"},
	{186, 3, "DEV_MLB0_MLBSS_PCLK_CLK", "Input clock"},
	{186, 4, "DEV_MLB0_MLBSS_AMLB_CLK", "Input clock"},
	{91, 0, "DEV_MMCSD0_EMMCSS_VBUS_CLK", "Input clock"},
	{91, 1, "DEV_MMCSD0_EMMCSS_XIN_CLK", "Input muxed clock"},
	{91, 2, "DEV_MMCSD0_EMMCSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSS_XIN_CLK"},
	{91, 3, "DEV_MMCSD0_EMMCSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSS_XIN_CLK"},
	{91, 4, "DEV_MMCSD0_EMMCSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSS_XIN_CLK"},
	{91, 5, "DEV_MMCSD0_EMMCSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSS_XIN_CLK"},
	{91, 6, "DEV_MMCSD0_EMMCSS_IO_CLK", "Output clock"},
	{92, 0, "DEV_MMCSD1_EMMCSDSS_XIN_CLK", "Input muxed clock"},
	{92, 1, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{92, 2, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{92, 3, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{92, 4, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{92, 5, "DEV_MMCSD1_EMMCSDSS_VBUS_CLK", "Input clock"},
	{92, 6, "DEV_MMCSD1_EMMCSDSS_IO_CLK_I", "Input clock"},
	{92, 7, "DEV_MMCSD1_EMMCSDSS_IO_CLK_O", "Output clock"},
	{93, 0, "DEV_MMCSD2_EMMCSDSS_XIN_CLK", "Input muxed clock"},
	{93, 1, "DEV_MMCSD2_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD2_EMMCSDSS_XIN_CLK"},
	{93, 2, "DEV_MMCSD2_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD2_EMMCSDSS_XIN_CLK"},
	{93, 3, "DEV_MMCSD2_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD2_EMMCSDSS_XIN_CLK"},
	{93, 4, "DEV_MMCSD2_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD2_EMMCSDSS_XIN_CLK"},
	{93, 5, "DEV_MMCSD2_EMMCSDSS_VBUS_CLK", "Input clock"},
	{93, 6, "DEV_MMCSD2_EMMCSDSS_IO_CLK_I", "Input clock"},
	{93, 7, "DEV_MMCSD2_EMMCSDSS_IO_CLK_O", "Output clock"},
	{199, 0, "DEV_NAVSS0_CPTS0_GENF3", "Output clock"},
	{199, 1, "DEV_NAVSS0_CPTS0_GENF2", "Output clock"},
	{201, 0, "DEV_NAVSS0_CPTS_0_VBUSP_GCLK", "Input clock"},
	{201, 1, "DEV_NAVSS0_CPTS_0_RCLK", "Input muxed clock"},
	{201, 2, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 3, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 4, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 5, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 6, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 7, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 8, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 9, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 10, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 11, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 12, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN0_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 13, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN1_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 14, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B4M4CS_MAIN_3_IP2_LN0_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 15, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B4M4CS_MAIN_3_IP2_LN1_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 16, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 17, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 18, "DEV_NAVSS0_CPTS_0_TS_GENF0", "Output clock"},
	{201, 19, "DEV_NAVSS0_CPTS_0_TS_GENF1", "Output clock"},
	{206, 0, "DEV_NAVSS0_DTI_0_CLK_CLK", "Input clock"},
	{206, 1, "DEV_NAVSS0_DTI_0_EXT0_DTI_CLK_CLK", "Input clock"},
	{206, 2, "DEV_NAVSS0_DTI_0_EXT3_DTI_CLK_CLK", "Input clock"},
	{206, 3, "DEV_NAVSS0_DTI_0_EXT1_DTI_CLK_CLK", "Input clock"},
	{206, 4, "DEV_NAVSS0_DTI_0_EXT2_DTI_CLK_CLK", "Input clock"},
	{213, 0, "DEV_NAVSS0_INTR_ROUTER_0_INTR_CLK", "Input clock"},
	{214, 0, "DEV_NAVSS0_MAILBOX_0_VCLK_CLK", "Input clock"},
	{215, 0, "DEV_NAVSS0_MAILBOX_1_VCLK_CLK", "Input clock"},
	{224, 0, "DEV_NAVSS0_MAILBOX_10_VCLK_CLK", "Input clock"},
	{225, 0, "DEV_NAVSS0_MAILBOX_11_VCLK_CLK", "Input clock"},
	{216, 0, "DEV_NAVSS0_MAILBOX_2_VCLK_CLK", "Input clock"},
	{217, 0, "DEV_NAVSS0_MAILBOX_3_VCLK_CLK", "Input clock"},
	{218, 0, "DEV_NAVSS0_MAILBOX_4_VCLK_CLK", "Input clock"},
	{219, 0, "DEV_NAVSS0_MAILBOX_5_VCLK_CLK", "Input clock"},
	{220, 0, "DEV_NAVSS0_MAILBOX_6_VCLK_CLK", "Input clock"},
	{221, 0, "DEV_NAVSS0_MAILBOX_7_VCLK_CLK", "Input clock"},
	{222, 0, "DEV_NAVSS0_MAILBOX_8_VCLK_CLK", "Input clock"},
	{223, 0, "DEV_NAVSS0_MAILBOX_9_VCLK_CLK", "Input clock"},
	{227, 0, "DEV_NAVSS0_MCRC_0_CLK", "Input clock"},
	{299, 0, "DEV_NAVSS0_MODSS_VD2CLK", "Input clock"},
	{207, 0, "DEV_NAVSS0_MODSS_INTAGGR_0_SYS_CLK", "Input clock"},
	{208, 0, "DEV_NAVSS0_MODSS_INTAGGR_1_SYS_CLK", "Input clock"},
	{210, 0, "DEV_NAVSS0_PROXY_0_CLK_CLK", "Input clock"},
	{339, 0, "DEV_NAVSS0_PVU_0_CLK_CLK", "Input clock"},
	{340, 0, "DEV_NAVSS0_PVU_1_CLK_CLK", "Input clock"},
	{341, 0, "DEV_NAVSS0_PVU_2_CLK_CLK", "Input clock"},
	{211, 0, "DEV_NAVSS0_RINGACC_0_SYS_CLK", "Input clock"},
	{226, 0, "DEV_NAVSS0_SPINLOCK_0_CLK", "Input clock"},
	{228, 0, "DEV_NAVSS0_TBU_0_CLK_CLK", "Input clock"},
	{229, 0, "DEV_NAVSS0_TCU_0_CLK_CLK", "Input clock"},
	{230, 0, "DEV_NAVSS0_TIMERMGR_0_VCLK_CLK", "Input clock"},
	{230, 1, "DEV_NAVSS0_TIMERMGR_0_EON_TICK_EVT", "Input clock"},
	{231, 0, "DEV_NAVSS0_TIMERMGR_1_VCLK_CLK", "Input clock"},
	{231, 1, "DEV_NAVSS0_TIMERMGR_1_EON_TICK_EVT", "Input clock"},
	{212, 0, "DEV_NAVSS0_UDMAP_0_SYS_CLK", "Input clock"},
	{300, 0, "DEV_NAVSS0_UDMASS_VD2CLK", "Input clock"},
	{209, 0, "DEV_NAVSS0_UDMASS_INTAGGR_0_SYS_CLK", "Input clock"},
	{301, 0, "DEV_NAVSS0_VIRTSS_VD2CLK", "Input clock"},
	{239, 0, "DEV_PCIE0_PCIE_LANE1_TXMCLK", "Input clock"},
	{239, 1, "DEV_PCIE0_PCIE_CBA_CLK", "Input clock"},
	{239, 2, "DEV_PCIE0_PCIE_LANE1_RXCLK", "Input clock"},
	{239, 3, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK", "Input muxed clock"},
	{239, 4, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{239, 5, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{239, 6, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{239, 7, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{239, 8, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{239, 9, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{239, 10, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{239, 11, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{239, 12, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{239, 13, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{239, 14, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{239, 15, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{239, 16, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN0_TXMCLK_DUP0", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{239, 17, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN1_TXMCLK_DUP0", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{239, 18, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{239, 19, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{239, 20, "DEV_PCIE0_PCIE_LANE1_TXFCLK", "Input clock"},
	{239, 21, "DEV_PCIE0_PCIE_LANE1_REFCLK", "Input clock"},
	{239, 22, "DEV_PCIE0_PCIE_LANE0_REFCLK", "Input clock"},
	{239, 23, "DEV_PCIE0_PCIE_LANE0_TXMCLK", "Input clock"},
	{239, 24, "DEV_PCIE0_PCIE_LANE0_TXFCLK", "Input clock"},
	{239, 25, "DEV_PCIE0_PCIE_PM_CLK", "Input clock"},
	{239, 26, "DEV_PCIE0_PCIE_LANE0_RXFCLK", "Input clock"},
	{239, 27, "DEV_PCIE0_PCIE_LANE1_RXFCLK", "Input clock"},
	{239, 28, "DEV_PCIE0_PCIE_LANE0_RXCLK", "Input clock"},
	{239, 29, "DEV_PCIE0_PCIE_LANE1_TXCLK", "Output clock"},
	{239, 30, "DEV_PCIE0_PCIE_LANE0_TXCLK", "Output clock"},
	{240, 0, "DEV_PCIE1_PCIE_LANE1_TXMCLK", "Input clock"},
	{240, 1, "DEV_PCIE1_PCIE_CBA_CLK", "Input clock"},
	{240, 2, "DEV_PCIE1_PCIE_LANE1_RXCLK", "Input clock"},
	{240, 3, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK", "Input muxed clock"},
	{240, 4, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 5, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 6, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 7, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 8, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 9, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 10, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 11, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 12, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 13, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 14, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 15, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 16, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN0_TXMCLK_DUP0", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 17, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN1_TXMCLK_DUP0", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 18, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 19, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 20, "DEV_PCIE1_PCIE_LANE1_TXFCLK", "Input clock"},
	{240, 21, "DEV_PCIE1_PCIE_LANE1_REFCLK", "Input clock"},
	{240, 22, "DEV_PCIE1_PCIE_LANE0_REFCLK", "Input clock"},
	{240, 23, "DEV_PCIE1_PCIE_LANE0_TXMCLK", "Input clock"},
	{240, 24, "DEV_PCIE1_PCIE_LANE0_TXFCLK", "Input clock"},
	{240, 25, "DEV_PCIE1_PCIE_PM_CLK", "Input clock"},
	{240, 26, "DEV_PCIE1_PCIE_LANE0_RXFCLK", "Input clock"},
	{240, 27, "DEV_PCIE1_PCIE_LANE1_RXFCLK", "Input clock"},
	{240, 28, "DEV_PCIE1_PCIE_LANE0_RXCLK", "Input clock"},
	{240, 29, "DEV_PCIE1_PCIE_LANE1_TXCLK", "Output clock"},
	{240, 30, "DEV_PCIE1_PCIE_LANE0_TXCLK", "Output clock"},
	{241, 0, "DEV_PCIE2_PCIE_LANE1_TXMCLK", "Input clock"},
	{241, 1, "DEV_PCIE2_PCIE_CBA_CLK", "Input clock"},
	{241, 2, "DEV_PCIE2_PCIE_LANE1_RXCLK", "Input clock"},
	{241, 3, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK", "Input muxed clock"},
	{241, 4, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{241, 5, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{241, 6, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{241, 7, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{241, 8, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{241, 9, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{241, 10, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{241, 11, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{241, 12, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{241, 13, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{241, 14, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{241, 15, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{241, 16, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN0_TXMCLK_DUP0", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{241, 17, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN1_TXMCLK_DUP0", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{241, 18, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{241, 19, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{241, 20, "DEV_PCIE2_PCIE_LANE1_TXFCLK", "Input clock"},
	{241, 21, "DEV_PCIE2_PCIE_LANE1_REFCLK", "Input clock"},
	{241, 22, "DEV_PCIE2_PCIE_LANE0_REFCLK", "Input clock"},
	{241, 23, "DEV_PCIE2_PCIE_LANE0_TXMCLK", "Input clock"},
	{241, 24, "DEV_PCIE2_PCIE_LANE0_TXFCLK", "Input clock"},
	{241, 25, "DEV_PCIE2_PCIE_PM_CLK", "Input clock"},
	{241, 26, "DEV_PCIE2_PCIE_LANE0_RXFCLK", "Input clock"},
	{241, 27, "DEV_PCIE2_PCIE_LANE1_RXFCLK", "Input clock"},
	{241, 28, "DEV_PCIE2_PCIE_LANE0_RXCLK", "Input clock"},
	{241, 29, "DEV_PCIE2_PCIE_LANE1_TXCLK", "Output clock"},
	{241, 30, "DEV_PCIE2_PCIE_LANE0_TXCLK", "Output clock"},
	{242, 0, "DEV_PCIE3_PCIE_LANE1_TXMCLK", "Input clock"},
	{242, 1, "DEV_PCIE3_PCIE_CBA_CLK", "Input clock"},
	{242, 2, "DEV_PCIE3_PCIE_LANE1_RXCLK", "Input clock"},
	{242, 3, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK", "Input muxed clock"},
	{242, 4, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{242, 5, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{242, 6, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{242, 7, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{242, 8, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{242, 9, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{242, 10, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{242, 11, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{242, 12, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{242, 13, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{242, 14, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{242, 15, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{242, 16, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN0_TXMCLK_DUP0", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{242, 17, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN1_TXMCLK_DUP0", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{242, 18, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{242, 19, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{242, 20, "DEV_PCIE3_PCIE_LANE1_TXFCLK", "Input clock"},
	{242, 21, "DEV_PCIE3_PCIE_LANE1_REFCLK", "Input clock"},
	{242, 22, "DEV_PCIE3_PCIE_LANE0_REFCLK", "Input clock"},
	{242, 23, "DEV_PCIE3_PCIE_LANE0_TXMCLK", "Input clock"},
	{242, 24, "DEV_PCIE3_PCIE_LANE0_TXFCLK", "Input clock"},
	{242, 25, "DEV_PCIE3_PCIE_PM_CLK", "Input clock"},
	{242, 26, "DEV_PCIE3_PCIE_LANE0_RXFCLK", "Input clock"},
	{242, 27, "DEV_PCIE3_PCIE_LANE1_RXFCLK", "Input clock"},
	{242, 28, "DEV_PCIE3_PCIE_LANE0_RXCLK", "Input clock"},
	{242, 29, "DEV_PCIE3_PCIE_LANE1_TXCLK", "Output clock"},
	{242, 30, "DEV_PCIE3_PCIE_LANE0_TXCLK", "Output clock"},
	{119, 0, "DEV_PRU_ICSSG0_PR1_RGMII0_RXC_I", "Input clock"},
	{119, 1, "DEV_PRU_ICSSG0_VCLK_CLK", "Input clock"},
	{119, 2, "DEV_PRU_ICSSG0_PR1_RGMII1_TXC_I", "Input clock"},
	{119, 3, "DEV_PRU_ICSSG0_IEP_CLK", "Input muxed clock"},
	{119, 4, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{119, 5, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{119, 6, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{119, 7, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{119, 8, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{119, 9, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{119, 10, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{119, 11, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{119, 12, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{119, 13, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{119, 14, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{119, 15, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{119, 16, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_WIZ16B4M4CS_MAIN_3_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{119, 17, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_WIZ16B4M4CS_MAIN_3_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{119, 18, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{119, 19, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{119, 20, "DEV_PRU_ICSSG0_RGMII_MHZ_5_CLK", "Input clock"},
	{119, 21, "DEV_PRU_ICSSG0_PR1_RGMII1_RXC_I", "Input clock"},
	{119, 22, "DEV_PRU_ICSSG0_UCLK_CLK", "Input clock"},
	{119, 23, "DEV_PRU_ICSSG0_PR1_RGMII0_TXC_I", "Input clock"},
	{119, 24, "DEV_PRU_ICSSG0_CORE_CLK", "Input muxed clock"},
	{119, 25, "DEV_PRU_ICSSG0_CORE_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT0_CLK", "Parent input clock option to DEV_PRU_ICSSG0_CORE_CLK"},
	{119, 26, "DEV_PRU_ICSSG0_CORE_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_PRU_ICSSG0_CORE_CLK"},
	{119, 27, "DEV_PRU_ICSSG0_RGMII_MHZ_250_CLK", "Input clock"},
	{119, 28, "DEV_PRU_ICSSG0_RGMII_MHZ_50_CLK", "Input clock"},
	{119, 29, "DEV_PRU_ICSSG0_PR1_RGMII1_TXC_O", "Output clock"},
	{119, 30, "DEV_PRU_ICSSG0_PR1_MDIO_MDCLK_O", "Output clock"},
	{119, 31, "DEV_PRU_ICSSG0_PR1_RGMII0_TXC_O", "Output clock"},
	{120, 0, "DEV_PRU_ICSSG1_SERDES0_RXCLK", "Input muxed clock"},
	{120, 1, "DEV_PRU_ICSSG1_SERDES0_RXCLK_PARENT_WIZ16B4M4CS_MAIN_1_IP4_LN0_RXCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES0_RXCLK"},
	{120, 2, "DEV_PRU_ICSSG1_SERDES0_RXCLK_PARENT_WIZ16B4M4CS_MAIN_2_IP4_LN0_RXCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES0_RXCLK"},
	{120, 3, "DEV_PRU_ICSSG1_PR1_RGMII0_RXC_I", "Input clock"},
	{120, 4, "DEV_PRU_ICSSG1_VCLK_CLK", "Input clock"},
	{120, 5, "DEV_PRU_ICSSG1_PR1_RGMII1_TXC_I", "Input clock"},
	{120, 6, "DEV_PRU_ICSSG1_SERDES0_RXFCLK", "Input muxed clock"},
	{120, 7, "DEV_PRU_ICSSG1_SERDES0_RXFCLK_PARENT_WIZ16B4M4CS_MAIN_1_IP4_LN0_RXFCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES0_RXFCLK"},
	{120, 8, "DEV_PRU_ICSSG1_SERDES0_RXFCLK_PARENT_WIZ16B4M4CS_MAIN_2_IP4_LN0_RXFCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES0_RXFCLK"},
	{120, 9, "DEV_PRU_ICSSG1_IEP_CLK", "Input muxed clock"},
	{120, 10, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{120, 11, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{120, 12, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{120, 13, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{120, 14, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{120, 15, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{120, 16, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{120, 17, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_WIZ16B4M4CS_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{120, 18, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{120, 19, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_WIZ16B4M4CS_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{120, 20, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{120, 21, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_WIZ16B4M4CS_MAIN_2_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{120, 22, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_WIZ16B4M4CS_MAIN_3_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{120, 23, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_WIZ16B4M4CS_MAIN_3_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{120, 24, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{120, 25, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{120, 26, "DEV_PRU_ICSSG1_RGMII_MHZ_5_CLK", "Input clock"},
	{120, 27, "DEV_PRU_ICSSG1_SERDES0_TXMCLK", "Input muxed clock"},
	{120, 28, "DEV_PRU_ICSSG1_SERDES0_TXMCLK_PARENT_WIZ16B4M4CS_MAIN_1_IP4_LN0_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES0_TXMCLK"},
	{120, 29, "DEV_PRU_ICSSG1_SERDES0_TXMCLK_PARENT_WIZ16B4M4CS_MAIN_2_IP4_LN0_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES0_TXMCLK"},
	{120, 30, "DEV_PRU_ICSSG1_SERDES0_REFCLK", "Input muxed clock"},
	{120, 31, "DEV_PRU_ICSSG1_SERDES0_REFCLK_PARENT_WIZ16B4M4CS_MAIN_1_IP4_LN0_REFCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES0_REFCLK"},
	{120, 32, "DEV_PRU_ICSSG1_SERDES0_REFCLK_PARENT_WIZ16B4M4CS_MAIN_2_IP4_LN0_REFCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES0_REFCLK"},
	{120, 33, "DEV_PRU_ICSSG1_SERDES1_RXFCLK", "Input muxed clock"},
	{120, 34, "DEV_PRU_ICSSG1_SERDES1_RXFCLK_PARENT_WIZ16B4M4CS_MAIN_1_IP4_LN1_RXFCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES1_RXFCLK"},
	{120, 35, "DEV_PRU_ICSSG1_SERDES1_RXFCLK_PARENT_WIZ16B4M4CS_MAIN_2_IP4_LN1_RXFCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES1_RXFCLK"},
	{120, 36, "DEV_PRU_ICSSG1_PR1_RGMII1_RXC_I", "Input clock"},
	{120, 37, "DEV_PRU_ICSSG1_SERDES1_RXCLK", "Input muxed clock"},
	{120, 38, "DEV_PRU_ICSSG1_SERDES1_RXCLK_PARENT_WIZ16B4M4CS_MAIN_1_IP4_LN1_RXCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES1_RXCLK"},
	{120, 39, "DEV_PRU_ICSSG1_SERDES1_RXCLK_PARENT_WIZ16B4M4CS_MAIN_2_IP4_LN1_RXCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES1_RXCLK"},
	{120, 40, "DEV_PRU_ICSSG1_SERDES1_TXFCLK", "Input muxed clock"},
	{120, 41, "DEV_PRU_ICSSG1_SERDES1_TXFCLK_PARENT_WIZ16B4M4CS_MAIN_1_IP4_LN1_TXFCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES1_TXFCLK"},
	{120, 42, "DEV_PRU_ICSSG1_SERDES1_TXFCLK_PARENT_WIZ16B4M4CS_MAIN_2_IP4_LN1_TXFCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES1_TXFCLK"},
	{120, 43, "DEV_PRU_ICSSG1_SERDES1_TXMCLK", "Input muxed clock"},
	{120, 44, "DEV_PRU_ICSSG1_SERDES1_TXMCLK_PARENT_WIZ16B4M4CS_MAIN_1_IP4_LN1_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES1_TXMCLK"},
	{120, 45, "DEV_PRU_ICSSG1_SERDES1_TXMCLK_PARENT_WIZ16B4M4CS_MAIN_2_IP4_LN1_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES1_TXMCLK"},
	{120, 46, "DEV_PRU_ICSSG1_SERDES0_TXFCLK", "Input muxed clock"},
	{120, 47, "DEV_PRU_ICSSG1_SERDES0_TXFCLK_PARENT_WIZ16B4M4CS_MAIN_1_IP4_LN0_TXFCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES0_TXFCLK"},
	{120, 48, "DEV_PRU_ICSSG1_SERDES0_TXFCLK_PARENT_WIZ16B4M4CS_MAIN_2_IP4_LN0_TXFCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES0_TXFCLK"},
	{120, 49, "DEV_PRU_ICSSG1_UCLK_CLK", "Input clock"},
	{120, 50, "DEV_PRU_ICSSG1_PR1_RGMII0_TXC_I", "Input clock"},
	{120, 51, "DEV_PRU_ICSSG1_SERDES1_REFCLK", "Input muxed clock"},
	{120, 52, "DEV_PRU_ICSSG1_SERDES1_REFCLK_PARENT_WIZ16B4M4CS_MAIN_1_IP4_LN1_REFCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES1_REFCLK"},
	{120, 53, "DEV_PRU_ICSSG1_SERDES1_REFCLK_PARENT_WIZ16B4M4CS_MAIN_2_IP4_LN1_REFCLK", "Parent input clock option to DEV_PRU_ICSSG1_SERDES1_REFCLK"},
	{120, 54, "DEV_PRU_ICSSG1_CORE_CLK", "Input muxed clock"},
	{120, 55, "DEV_PRU_ICSSG1_CORE_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT0_CLK", "Parent input clock option to DEV_PRU_ICSSG1_CORE_CLK"},
	{120, 56, "DEV_PRU_ICSSG1_CORE_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_PRU_ICSSG1_CORE_CLK"},
	{120, 57, "DEV_PRU_ICSSG1_RGMII_MHZ_250_CLK", "Input clock"},
	{120, 58, "DEV_PRU_ICSSG1_RGMII_MHZ_50_CLK", "Input clock"},
	{120, 59, "DEV_PRU_ICSSG1_PR1_RGMII1_TXC_O", "Output clock"},
	{120, 60, "DEV_PRU_ICSSG1_PR1_MDIO_MDCLK_O", "Output clock"},
	{120, 61, "DEV_PRU_ICSSG1_PR1_RGMII0_TXC_O", "Output clock"},
	{120, 62, "DEV_PRU_ICSSG1_SERDES0_TXCLK", "Output clock"},
	{120, 63, "DEV_PRU_ICSSG1_SERDES1_TXCLK", "Output clock"},
	{133, 0, "DEV_PSC0_SLOW_CLK", "Input clock"},
	{133, 1, "DEV_PSC0_CLK", "Input clock"},
	{245, 0, "DEV_R5FSS0_CORE0_CPU_CLK", "Input clock"},
	{245, 1, "DEV_R5FSS0_CORE0_INTERFACE_CLK", "Input clock"},
	{245, 2, "DEV_R5FSS0_CORE0_INTERFACE_PHASE", "Input clock"},
	{246, 0, "DEV_R5FSS0_CORE1_CPU_CLK", "Input clock"},
	{246, 1, "DEV_R5FSS0_CORE1_INTERFACE_CLK", "Input clock"},
	{246, 2, "DEV_R5FSS0_CORE1_INTERFACE_PHASE", "Input clock"},
	{134, 0, "DEV_R5FSS0_INTROUTER0_INTR_CLK", "Input clock"},
	{247, 0, "DEV_R5FSS1_CORE0_CPU_CLK", "Input clock"},
	{247, 1, "DEV_R5FSS1_CORE0_INTERFACE_CLK", "Input clock"},
	{247, 2, "DEV_R5FSS1_CORE0_INTERFACE_PHASE", "Input clock"},
	{248, 0, "DEV_R5FSS1_CORE1_CPU_CLK", "Input clock"},
	{248, 1, "DEV_R5FSS1_CORE1_INTERFACE_CLK", "Input clock"},
	{248, 2, "DEV_R5FSS1_CORE1_INTERFACE_PHASE", "Input clock"},
	{135, 0, "DEV_R5FSS1_INTROUTER0_INTR_CLK", "Input clock"},
	{252, 0, "DEV_RTI0_VBUSP_CLK", "Input clock"},
	{252, 1, "DEV_RTI0_RTI_CLK", "Input muxed clock"},
	{252, 2, "DEV_RTI0_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{252, 3, "DEV_RTI0_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{252, 4, "DEV_RTI0_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{252, 5, "DEV_RTI0_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{252, 6, "DEV_RTI0_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{252, 7, "DEV_RTI0_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{252, 8, "DEV_RTI0_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{252, 9, "DEV_RTI0_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{253, 0, "DEV_RTI1_VBUSP_CLK", "Input clock"},
	{253, 1, "DEV_RTI1_RTI_CLK", "Input muxed clock"},
	{253, 2, "DEV_RTI1_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{253, 3, "DEV_RTI1_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{253, 4, "DEV_RTI1_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{253, 5, "DEV_RTI1_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{253, 6, "DEV_RTI1_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{253, 7, "DEV_RTI1_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{253, 8, "DEV_RTI1_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{253, 9, "DEV_RTI1_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{257, 0, "DEV_RTI15_VBUSP_CLK", "Input clock"},
	{257, 1, "DEV_RTI15_RTI_CLK", "Input muxed clock"},
	{257, 2, "DEV_RTI15_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{257, 3, "DEV_RTI15_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{257, 4, "DEV_RTI15_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{257, 5, "DEV_RTI15_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{257, 6, "DEV_RTI15_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{257, 7, "DEV_RTI15_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{257, 8, "DEV_RTI15_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{257, 9, "DEV_RTI15_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{256, 0, "DEV_RTI16_VBUSP_CLK", "Input clock"},
	{256, 1, "DEV_RTI16_RTI_CLK", "Input muxed clock"},
	{256, 2, "DEV_RTI16_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{256, 3, "DEV_RTI16_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{256, 4, "DEV_RTI16_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{256, 5, "DEV_RTI16_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{256, 6, "DEV_RTI16_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{256, 7, "DEV_RTI16_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{256, 8, "DEV_RTI16_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{256, 9, "DEV_RTI16_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{254, 0, "DEV_RTI24_VBUSP_CLK", "Input clock"},
	{254, 1, "DEV_RTI24_RTI_CLK", "Input muxed clock"},
	{254, 2, "DEV_RTI24_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI24_RTI_CLK"},
	{254, 3, "DEV_RTI24_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI24_RTI_CLK"},
	{254, 4, "DEV_RTI24_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI24_RTI_CLK"},
	{254, 5, "DEV_RTI24_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI24_RTI_CLK"},
	{254, 6, "DEV_RTI24_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI24_RTI_CLK"},
	{254, 7, "DEV_RTI24_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI24_RTI_CLK"},
	{254, 8, "DEV_RTI24_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI24_RTI_CLK"},
	{254, 9, "DEV_RTI24_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI24_RTI_CLK"},
	{255, 0, "DEV_RTI25_VBUSP_CLK", "Input clock"},
	{255, 1, "DEV_RTI25_RTI_CLK", "Input muxed clock"},
	{255, 2, "DEV_RTI25_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI25_RTI_CLK"},
	{255, 3, "DEV_RTI25_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI25_RTI_CLK"},
	{255, 4, "DEV_RTI25_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI25_RTI_CLK"},
	{255, 5, "DEV_RTI25_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI25_RTI_CLK"},
	{255, 6, "DEV_RTI25_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI25_RTI_CLK"},
	{255, 7, "DEV_RTI25_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI25_RTI_CLK"},
	{255, 8, "DEV_RTI25_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI25_RTI_CLK"},
	{255, 9, "DEV_RTI25_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI25_RTI_CLK"},
	{258, 0, "DEV_RTI28_VBUSP_CLK", "Input clock"},
	{258, 1, "DEV_RTI28_RTI_CLK", "Input muxed clock"},
	{258, 2, "DEV_RTI28_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{258, 3, "DEV_RTI28_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{258, 4, "DEV_RTI28_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{258, 5, "DEV_RTI28_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{258, 6, "DEV_RTI28_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{258, 7, "DEV_RTI28_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{258, 8, "DEV_RTI28_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{258, 9, "DEV_RTI28_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{259, 0, "DEV_RTI29_VBUSP_CLK", "Input clock"},
	{259, 1, "DEV_RTI29_RTI_CLK", "Input muxed clock"},
	{259, 2, "DEV_RTI29_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{259, 3, "DEV_RTI29_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{259, 4, "DEV_RTI29_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{259, 5, "DEV_RTI29_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{259, 6, "DEV_RTI29_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{259, 7, "DEV_RTI29_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{259, 8, "DEV_RTI29_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{259, 9, "DEV_RTI29_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{260, 0, "DEV_RTI30_VBUSP_CLK", "Input clock"},
	{260, 1, "DEV_RTI30_RTI_CLK", "Input muxed clock"},
	{260, 2, "DEV_RTI30_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{260, 3, "DEV_RTI30_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{260, 4, "DEV_RTI30_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{260, 5, "DEV_RTI30_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{260, 6, "DEV_RTI30_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{260, 7, "DEV_RTI30_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{260, 8, "DEV_RTI30_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{260, 9, "DEV_RTI30_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{261, 0, "DEV_RTI31_VBUSP_CLK", "Input clock"},
	{261, 1, "DEV_RTI31_RTI_CLK", "Input muxed clock"},
	{261, 2, "DEV_RTI31_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{261, 3, "DEV_RTI31_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{261, 4, "DEV_RTI31_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{261, 5, "DEV_RTI31_RTI_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{261, 6, "DEV_RTI31_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{261, 7, "DEV_RTI31_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{261, 8, "DEV_RTI31_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{261, 9, "DEV_RTI31_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{264, 0, "DEV_SA2_UL0_X2_CLK", "Input clock"},
	{264, 1, "DEV_SA2_UL0_PKA_IN_CLK", "Input clock"},
	{264, 2, "DEV_SA2_UL0_X1_CLK", "Input clock"},
	{297, 0, "DEV_SERDES_10G0_IP1_LN3_TXCLK", "Input clock"},
	{297, 1, "DEV_SERDES_10G0_CLK", "Input clock"},
	{297, 2, "DEV_SERDES_10G0_IP3_LN2_TXCLK", "Input clock"},
	{297, 3, "DEV_SERDES_10G0_IP1_LN2_TXCLK", "Input clock"},
	{297, 4, "DEV_SERDES_10G0_IP1_LN0_TXCLK", "Input clock"},
	{297, 5, "DEV_SERDES_10G0_IP3_LN1_TXCLK", "Input clock"},
	{297, 6, "DEV_SERDES_10G0_IP3_LN3_TXCLK", "Input clock"},
	{297, 7, "DEV_SERDES_10G0_IP3_LN0_TXCLK", "Input clock"},
	{297, 8, "DEV_SERDES_10G0_IP1_LN1_TXCLK", "Input clock"},
	{297, 9, "DEV_SERDES_10G0_CORE_REF_CLK", "Input muxed clock"},
	{297, 10, "DEV_SERDES_10G0_CORE_REF_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_SERDES_10G0_CORE_REF_CLK"},
	{297, 11, "DEV_SERDES_10G0_CORE_REF_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_SERDES_10G0_CORE_REF_CLK"},
	{297, 12, "DEV_SERDES_10G0_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_10G0_CORE_REF_CLK"},
	{297, 13, "DEV_SERDES_10G0_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_10G0_CORE_REF_CLK"},
	{297, 14, "DEV_SERDES_10G0_IP1_LN1_REFCLK", "Output clock"},
	{297, 15, "DEV_SERDES_10G0_IP1_LN2_RXCLK", "Output clock"},
	{297, 16, "DEV_SERDES_10G0_IP3_LN1_TXFCLK", "Output clock"},
	{297, 17, "DEV_SERDES_10G0_IP1_LN0_RXFCLK", "Output clock"},
	{297, 18, "DEV_SERDES_10G0_IP1_LN3_RXCLK", "Output clock"},
	{297, 19, "DEV_SERDES_10G0_IP3_LN3_RXCLK", "Output clock"},
	{297, 20, "DEV_SERDES_10G0_IP3_LN1_TXMCLK", "Output clock"},
	{297, 21, "DEV_SERDES_10G0_IP3_LN3_RXFCLK", "Output clock"},
	{297, 22, "DEV_SERDES_10G0_IP3_LN3_REFCLK", "Output clock"},
	{297, 23, "DEV_SERDES_10G0_IP3_LN2_RXCLK", "Output clock"},
	{297, 24, "DEV_SERDES_10G0_IP1_LN0_TXFCLK", "Output clock"},
	{297, 25, "DEV_SERDES_10G0_IP3_LN3_TXMCLK", "Output clock"},
	{297, 26, "DEV_SERDES_10G0_IP3_LN1_RXFCLK", "Output clock"},
	{297, 27, "DEV_SERDES_10G0_IP3_LN0_RXFCLK", "Output clock"},
	{297, 28, "DEV_SERDES_10G0_IP1_LN1_TXMCLK", "Output clock"},
	{297, 29, "DEV_SERDES_10G0_IP1_LN1_RXFCLK", "Output clock"},
	{297, 30, "DEV_SERDES_10G0_IP3_LN3_TXFCLK", "Output clock"},
	{297, 31, "DEV_SERDES_10G0_IP1_LN3_TXFCLK", "Output clock"},
	{297, 32, "DEV_SERDES_10G0_IP1_LN3_TXMCLK", "Output clock"},
	{297, 33, "DEV_SERDES_10G0_IP3_LN1_REFCLK", "Output clock"},
	{297, 34, "DEV_SERDES_10G0_IP3_LN0_REFCLK", "Output clock"},
	{297, 35, "DEV_SERDES_10G0_IP1_LN3_REFCLK", "Output clock"},
	{297, 36, "DEV_SERDES_10G0_IP3_LN0_RXCLK", "Output clock"},
	{297, 37, "DEV_SERDES_10G0_IP3_LN2_REFCLK", "Output clock"},
	{297, 38, "DEV_SERDES_10G0_IP1_LN0_RXCLK", "Output clock"},
	{297, 39, "DEV_SERDES_10G0_IP1_LN0_REFCLK", "Output clock"},
	{297, 40, "DEV_SERDES_10G0_IP1_LN2_RXFCLK", "Output clock"},
	{297, 41, "DEV_SERDES_10G0_IP1_LN1_TXFCLK", "Output clock"},
	{297, 42, "DEV_SERDES_10G0_IP3_LN0_TXFCLK", "Output clock"},
	{297, 43, "DEV_SERDES_10G0_REF_OUT_CLK", "Output clock"},
	{297, 44, "DEV_SERDES_10G0_IP3_LN1_RXCLK", "Output clock"},
	{297, 45, "DEV_SERDES_10G0_IP1_LN2_TXFCLK", "Output clock"},
	{297, 46, "DEV_SERDES_10G0_IP1_LN0_TXMCLK", "Output clock"},
	{297, 47, "DEV_SERDES_10G0_IP3_LN2_RXFCLK", "Output clock"},
	{297, 48, "DEV_SERDES_10G0_IP1_LN2_TXMCLK", "Output clock"},
	{297, 49, "DEV_SERDES_10G0_IP3_LN2_TXMCLK", "Output clock"},
	{297, 50, "DEV_SERDES_10G0_IP1_LN2_REFCLK", "Output clock"},
	{297, 51, "DEV_SERDES_10G0_IP3_LN2_TXFCLK", "Output clock"},
	{297, 52, "DEV_SERDES_10G0_IP3_LN0_TXMCLK", "Output clock"},
	{297, 53, "DEV_SERDES_10G0_IP1_LN3_RXFCLK", "Output clock"},
	{297, 54, "DEV_SERDES_10G0_IP1_LN1_RXCLK", "Output clock"},
	{292, 0, "DEV_SERDES_16G0_CORE_REF1_CLK", "Input muxed clock"},
	{292, 1, "DEV_SERDES_16G0_CORE_REF1_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_SERDES_16G0_CORE_REF1_CLK"},
	{292, 2, "DEV_SERDES_16G0_CORE_REF1_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_SERDES_16G0_CORE_REF1_CLK"},
	{292, 3, "DEV_SERDES_16G0_CORE_REF1_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_16G0_CORE_REF1_CLK"},
	{292, 4, "DEV_SERDES_16G0_CORE_REF1_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_16G0_CORE_REF1_CLK"},
	{292, 5, "DEV_SERDES_16G0_CLK", "Input clock"},
	{292, 6, "DEV_SERDES_16G0_IP1_LN0_TXCLK", "Input clock"},
	{292, 7, "DEV_SERDES_16G0_IP2_LN1_TXCLK", "Input clock"},
	{292, 8, "DEV_SERDES_16G0_IP3_LN1_TXCLK", "Input clock"},
	{292, 9, "DEV_SERDES_16G0_IP2_LN0_TXCLK", "Input clock"},
	{292, 10, "DEV_SERDES_16G0_IP1_LN1_TXCLK", "Input clock"},
	{292, 11, "DEV_SERDES_16G0_CORE_REF_CLK", "Input muxed clock"},
	{292, 12, "DEV_SERDES_16G0_CORE_REF_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_SERDES_16G0_CORE_REF_CLK"},
	{292, 13, "DEV_SERDES_16G0_CORE_REF_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_SERDES_16G0_CORE_REF_CLK"},
	{292, 14, "DEV_SERDES_16G0_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_16G0_CORE_REF_CLK"},
	{292, 15, "DEV_SERDES_16G0_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_16G0_CORE_REF_CLK"},
	{292, 16, "DEV_SERDES_16G0_IP2_LN0_TXFCLK", "Output clock"},
	{292, 17, "DEV_SERDES_16G0_IP1_LN1_REFCLK", "Output clock"},
	{292, 18, "DEV_SERDES_16G0_IP3_LN1_TXMCLK", "Output clock"},
	{292, 19, "DEV_SERDES_16G0_IP3_LN1_TXFCLK", "Output clock"},
	{292, 20, "DEV_SERDES_16G0_IP1_LN0_RXFCLK", "Output clock"},
	{292, 21, "DEV_SERDES_16G0_IP2_LN1_REFCLK", "Output clock"},
	{292, 22, "DEV_SERDES_16G0_IP2_LN1_TXFCLK", "Output clock"},
	{292, 23, "DEV_SERDES_16G0_REF_DER_OUT_CLK", "Output clock"},
	{292, 24, "DEV_SERDES_16G0_IP1_LN0_TXFCLK", "Output clock"},
	{292, 25, "DEV_SERDES_16G0_IP3_LN1_RXFCLK", "Output clock"},
	{292, 26, "DEV_SERDES_16G0_IP1_LN1_TXMCLK", "Output clock"},
	{292, 27, "DEV_SERDES_16G0_IP1_LN1_RXFCLK", "Output clock"},
	{292, 28, "DEV_SERDES_16G0_IP3_LN1_RXCLK", "Output clock"},
	{292, 29, "DEV_SERDES_16G0_IP3_LN1_REFCLK", "Output clock"},
	{292, 30, "DEV_SERDES_16G0_IP2_LN1_RXCLK", "Output clock"},
	{292, 31, "DEV_SERDES_16G0_IP2_LN0_RXFCLK", "Output clock"},
	{292, 32, "DEV_SERDES_16G0_IP1_LN0_RXCLK", "Output clock"},
	{292, 33, "DEV_SERDES_16G0_REF_OUT_CLK", "Output clock"},
	{292, 34, "DEV_SERDES_16G0_REF1_OUT_CLK", "Output clock"},
	{292, 35, "DEV_SERDES_16G0_IP1_LN0_REFCLK", "Output clock"},
	{292, 36, "DEV_SERDES_16G0_IP1_LN0_TXMCLK", "Output clock"},
	{292, 37, "DEV_SERDES_16G0_IP2_LN1_RXFCLK", "Output clock"},
	{292, 38, "DEV_SERDES_16G0_IP2_LN1_TXMCLK", "Output clock"},
	{292, 39, "DEV_SERDES_16G0_IP2_LN0_REFCLK", "Output clock"},
	{292, 40, "DEV_SERDES_16G0_IP2_LN0_TXMCLK", "Output clock"},
	{292, 41, "DEV_SERDES_16G0_IP1_LN1_TXFCLK", "Output clock"},
	{292, 42, "DEV_SERDES_16G0_IP2_LN0_RXCLK", "Output clock"},
	{292, 43, "DEV_SERDES_16G0_IP1_LN1_RXCLK", "Output clock"},
	{292, 49, "DEV_SERDES_16G0_CMN_REFCLK1_M", "Input clock"},
	{292, 57, "DEV_SERDES_16G0_CMN_REFCLK1_P", "Input clock"},
	{293, 0, "DEV_SERDES_16G1_CORE_REF1_CLK", "Input muxed clock"},
	{293, 1, "DEV_SERDES_16G1_CORE_REF1_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_SERDES_16G1_CORE_REF1_CLK"},
	{293, 2, "DEV_SERDES_16G1_CORE_REF1_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_SERDES_16G1_CORE_REF1_CLK"},
	{293, 3, "DEV_SERDES_16G1_CORE_REF1_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_16G1_CORE_REF1_CLK"},
	{293, 4, "DEV_SERDES_16G1_CORE_REF1_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_16G1_CORE_REF1_CLK"},
	{293, 5, "DEV_SERDES_16G1_CLK", "Input clock"},
	{293, 6, "DEV_SERDES_16G1_IP1_LN0_TXCLK", "Input clock"},
	{293, 7, "DEV_SERDES_16G1_IP2_LN1_TXCLK", "Input clock"},
	{293, 8, "DEV_SERDES_16G1_IP4_LN1_TXCLK", "Input clock"},
	{293, 9, "DEV_SERDES_16G1_IP4_LN0_TXCLK", "Input clock"},
	{293, 10, "DEV_SERDES_16G1_IP3_LN1_TXCLK", "Input clock"},
	{293, 11, "DEV_SERDES_16G1_IP2_LN0_TXCLK", "Input clock"},
	{293, 12, "DEV_SERDES_16G1_IP1_LN1_TXCLK", "Input clock"},
	{293, 13, "DEV_SERDES_16G1_CORE_REF_CLK", "Input muxed clock"},
	{293, 14, "DEV_SERDES_16G1_CORE_REF_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_SERDES_16G1_CORE_REF_CLK"},
	{293, 15, "DEV_SERDES_16G1_CORE_REF_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_SERDES_16G1_CORE_REF_CLK"},
	{293, 16, "DEV_SERDES_16G1_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_16G1_CORE_REF_CLK"},
	{293, 17, "DEV_SERDES_16G1_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_16G1_CORE_REF_CLK"},
	{293, 18, "DEV_SERDES_16G1_IP2_LN0_TXFCLK", "Output clock"},
	{293, 19, "DEV_SERDES_16G1_IP1_LN1_REFCLK", "Output clock"},
	{293, 20, "DEV_SERDES_16G1_IP4_LN1_RXFCLK", "Output clock"},
	{293, 21, "DEV_SERDES_16G1_IP3_LN1_TXMCLK", "Output clock"},
	{293, 22, "DEV_SERDES_16G1_IP3_LN1_TXFCLK", "Output clock"},
	{293, 23, "DEV_SERDES_16G1_IP1_LN0_RXFCLK", "Output clock"},
	{293, 24, "DEV_SERDES_16G1_IP2_LN1_REFCLK", "Output clock"},
	{293, 25, "DEV_SERDES_16G1_IP2_LN1_TXFCLK", "Output clock"},
	{293, 26, "DEV_SERDES_16G1_REF_DER_OUT_CLK", "Output clock"},
	{293, 27, "DEV_SERDES_16G1_IP1_LN0_TXFCLK", "Output clock"},
	{293, 28, "DEV_SERDES_16G1_IP3_LN1_RXFCLK", "Output clock"},
	{293, 29, "DEV_SERDES_16G1_IP1_LN1_TXMCLK", "Output clock"},
	{293, 30, "DEV_SERDES_16G1_IP1_LN1_RXFCLK", "Output clock"},
	{293, 31, "DEV_SERDES_16G1_IP4_LN1_REFCLK", "Output clock"},
	{293, 32, "DEV_SERDES_16G1_IP3_LN1_RXCLK", "Output clock"},
	{293, 33, "DEV_SERDES_16G1_IP4_LN1_TXMCLK", "Output clock"},
	{293, 34, "DEV_SERDES_16G1_IP3_LN1_REFCLK", "Output clock"},
	{293, 35, "DEV_SERDES_16G1_IP4_LN0_REFCLK", "Output clock"},
	{293, 36, "DEV_SERDES_16G1_IP2_LN1_RXCLK", "Output clock"},
	{293, 37, "DEV_SERDES_16G1_IP2_LN0_RXFCLK", "Output clock"},
	{293, 38, "DEV_SERDES_16G1_IP1_LN0_RXCLK", "Output clock"},
	{293, 39, "DEV_SERDES_16G1_REF_OUT_CLK", "Output clock"},
	{293, 40, "DEV_SERDES_16G1_REF1_OUT_CLK", "Output clock"},
	{293, 41, "DEV_SERDES_16G1_IP4_LN1_RXCLK", "Output clock"},
	{293, 42, "DEV_SERDES_16G1_IP1_LN0_REFCLK", "Output clock"},
	{293, 43, "DEV_SERDES_16G1_IP1_LN0_TXMCLK", "Output clock"},
	{293, 44, "DEV_SERDES_16G1_IP4_LN0_TXFCLK", "Output clock"},
	{293, 45, "DEV_SERDES_16G1_IP4_LN0_RXCLK", "Output clock"},
	{293, 46, "DEV_SERDES_16G1_IP2_LN1_RXFCLK", "Output clock"},
	{293, 47, "DEV_SERDES_16G1_IP2_LN1_TXMCLK", "Output clock"},
	{293, 48, "DEV_SERDES_16G1_IP4_LN0_RXFCLK", "Output clock"},
	{293, 49, "DEV_SERDES_16G1_IP2_LN0_REFCLK", "Output clock"},
	{293, 50, "DEV_SERDES_16G1_IP2_LN0_TXMCLK", "Output clock"},
	{293, 51, "DEV_SERDES_16G1_IP1_LN1_TXFCLK", "Output clock"},
	{293, 52, "DEV_SERDES_16G1_IP2_LN0_RXCLK", "Output clock"},
	{293, 53, "DEV_SERDES_16G1_IP4_LN0_TXMCLK", "Output clock"},
	{293, 54, "DEV_SERDES_16G1_IP1_LN1_RXCLK", "Output clock"},
	{293, 55, "DEV_SERDES_16G1_IP4_LN1_TXFCLK", "Output clock"},
	{293, 60, "DEV_SERDES_16G1_CMN_REFCLK1_M", "Input clock"},
	{293, 67, "DEV_SERDES_16G1_CMN_REFCLK1_P", "Input clock"},
	{294, 0, "DEV_SERDES_16G2_CORE_REF1_CLK", "Input muxed clock"},
	{294, 1, "DEV_SERDES_16G2_CORE_REF1_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_SERDES_16G2_CORE_REF1_CLK"},
	{294, 2, "DEV_SERDES_16G2_CORE_REF1_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_SERDES_16G2_CORE_REF1_CLK"},
	{294, 3, "DEV_SERDES_16G2_CORE_REF1_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_16G2_CORE_REF1_CLK"},
	{294, 4, "DEV_SERDES_16G2_CORE_REF1_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_16G2_CORE_REF1_CLK"},
	{294, 5, "DEV_SERDES_16G2_CLK", "Input clock"},
	{294, 6, "DEV_SERDES_16G2_IP2_LN1_TXCLK", "Input clock"},
	{294, 7, "DEV_SERDES_16G2_IP4_LN1_TXCLK", "Input clock"},
	{294, 8, "DEV_SERDES_16G2_IP4_LN0_TXCLK", "Input clock"},
	{294, 9, "DEV_SERDES_16G2_IP3_LN1_TXCLK", "Input clock"},
	{294, 10, "DEV_SERDES_16G2_IP2_LN0_TXCLK", "Input clock"},
	{294, 11, "DEV_SERDES_16G2_CORE_REF_CLK", "Input muxed clock"},
	{294, 12, "DEV_SERDES_16G2_CORE_REF_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_SERDES_16G2_CORE_REF_CLK"},
	{294, 13, "DEV_SERDES_16G2_CORE_REF_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_SERDES_16G2_CORE_REF_CLK"},
	{294, 14, "DEV_SERDES_16G2_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_16G2_CORE_REF_CLK"},
	{294, 15, "DEV_SERDES_16G2_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_16G2_CORE_REF_CLK"},
	{294, 16, "DEV_SERDES_16G2_IP2_LN0_TXFCLK", "Output clock"},
	{294, 17, "DEV_SERDES_16G2_IP4_LN1_RXFCLK", "Output clock"},
	{294, 18, "DEV_SERDES_16G2_IP3_LN1_TXMCLK", "Output clock"},
	{294, 19, "DEV_SERDES_16G2_IP3_LN1_TXFCLK", "Output clock"},
	{294, 20, "DEV_SERDES_16G2_IP2_LN1_REFCLK", "Output clock"},
	{294, 21, "DEV_SERDES_16G2_IP2_LN1_TXFCLK", "Output clock"},
	{294, 22, "DEV_SERDES_16G2_REF_DER_OUT_CLK", "Output clock"},
	{294, 23, "DEV_SERDES_16G2_IP3_LN1_RXFCLK", "Output clock"},
	{294, 24, "DEV_SERDES_16G2_IP4_LN1_REFCLK", "Output clock"},
	{294, 25, "DEV_SERDES_16G2_IP3_LN1_RXCLK", "Output clock"},
	{294, 26, "DEV_SERDES_16G2_IP4_LN1_TXMCLK", "Output clock"},
	{294, 27, "DEV_SERDES_16G2_IP3_LN1_REFCLK", "Output clock"},
	{294, 28, "DEV_SERDES_16G2_IP4_LN0_REFCLK", "Output clock"},
	{294, 29, "DEV_SERDES_16G2_IP2_LN1_RXCLK", "Output clock"},
	{294, 30, "DEV_SERDES_16G2_IP2_LN0_RXFCLK", "Output clock"},
	{294, 31, "DEV_SERDES_16G2_REF_OUT_CLK", "Output clock"},
	{294, 32, "DEV_SERDES_16G2_REF1_OUT_CLK", "Output clock"},
	{294, 33, "DEV_SERDES_16G2_IP4_LN1_RXCLK", "Output clock"},
	{294, 34, "DEV_SERDES_16G2_IP4_LN0_TXFCLK", "Output clock"},
	{294, 35, "DEV_SERDES_16G2_IP4_LN0_RXCLK", "Output clock"},
	{294, 36, "DEV_SERDES_16G2_IP2_LN1_RXFCLK", "Output clock"},
	{294, 37, "DEV_SERDES_16G2_IP2_LN1_TXMCLK", "Output clock"},
	{294, 38, "DEV_SERDES_16G2_IP4_LN0_RXFCLK", "Output clock"},
	{294, 39, "DEV_SERDES_16G2_IP2_LN0_REFCLK", "Output clock"},
	{294, 40, "DEV_SERDES_16G2_IP2_LN0_TXMCLK", "Output clock"},
	{294, 41, "DEV_SERDES_16G2_IP2_LN0_RXCLK", "Output clock"},
	{294, 42, "DEV_SERDES_16G2_IP4_LN0_TXMCLK", "Output clock"},
	{294, 43, "DEV_SERDES_16G2_IP4_LN1_TXFCLK", "Output clock"},
	{294, 51, "DEV_SERDES_16G2_CMN_REFCLK1_M", "Input clock"},
	{294, 61, "DEV_SERDES_16G2_CMN_REFCLK1_P", "Input clock"},
	{295, 0, "DEV_SERDES_16G3_CORE_REF1_CLK", "Input muxed clock"},
	{295, 1, "DEV_SERDES_16G3_CORE_REF1_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_SERDES_16G3_CORE_REF1_CLK"},
	{295, 2, "DEV_SERDES_16G3_CORE_REF1_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_SERDES_16G3_CORE_REF1_CLK"},
	{295, 3, "DEV_SERDES_16G3_CORE_REF1_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_16G3_CORE_REF1_CLK"},
	{295, 4, "DEV_SERDES_16G3_CORE_REF1_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_16G3_CORE_REF1_CLK"},
	{295, 5, "DEV_SERDES_16G3_CLK", "Input clock"},
	{295, 6, "DEV_SERDES_16G3_IP2_LN1_TXCLK", "Input clock"},
	{295, 7, "DEV_SERDES_16G3_IP3_LN1_TXCLK", "Input clock"},
	{295, 8, "DEV_SERDES_16G3_IP2_LN0_TXCLK", "Input clock"},
	{295, 9, "DEV_SERDES_16G3_CORE_REF_CLK", "Input muxed clock"},
	{295, 10, "DEV_SERDES_16G3_CORE_REF_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_SERDES_16G3_CORE_REF_CLK"},
	{295, 11, "DEV_SERDES_16G3_CORE_REF_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_SERDES_16G3_CORE_REF_CLK"},
	{295, 12, "DEV_SERDES_16G3_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_16G3_CORE_REF_CLK"},
	{295, 13, "DEV_SERDES_16G3_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_16G3_CORE_REF_CLK"},
	{295, 14, "DEV_SERDES_16G3_IP2_LN0_TXFCLK", "Output clock"},
	{295, 15, "DEV_SERDES_16G3_IP3_LN1_TXMCLK", "Output clock"},
	{295, 16, "DEV_SERDES_16G3_IP3_LN1_TXFCLK", "Output clock"},
	{295, 17, "DEV_SERDES_16G3_IP2_LN1_REFCLK", "Output clock"},
	{295, 18, "DEV_SERDES_16G3_IP2_LN1_TXFCLK", "Output clock"},
	{295, 19, "DEV_SERDES_16G3_REF_DER_OUT_CLK", "Output clock"},
	{295, 20, "DEV_SERDES_16G3_IP3_LN1_RXFCLK", "Output clock"},
	{295, 21, "DEV_SERDES_16G3_IP3_LN1_RXCLK", "Output clock"},
	{295, 22, "DEV_SERDES_16G3_IP3_LN1_REFCLK", "Output clock"},
	{295, 23, "DEV_SERDES_16G3_IP2_LN1_RXCLK", "Output clock"},
	{295, 24, "DEV_SERDES_16G3_IP2_LN0_RXFCLK", "Output clock"},
	{295, 25, "DEV_SERDES_16G3_REF_OUT_CLK", "Output clock"},
	{295, 26, "DEV_SERDES_16G3_REF1_OUT_CLK", "Output clock"},
	{295, 27, "DEV_SERDES_16G3_IP2_LN1_RXFCLK", "Output clock"},
	{295, 28, "DEV_SERDES_16G3_IP2_LN1_TXMCLK", "Output clock"},
	{295, 29, "DEV_SERDES_16G3_IP2_LN0_REFCLK", "Output clock"},
	{295, 30, "DEV_SERDES_16G3_IP2_LN0_TXMCLK", "Output clock"},
	{295, 31, "DEV_SERDES_16G3_IP2_LN0_RXCLK", "Output clock"},
	{295, 40, "DEV_SERDES_16G3_CMN_REFCLK1_M", "Input clock"},
	{295, 51, "DEV_SERDES_16G3_CMN_REFCLK1_P", "Input clock"},
	{29, 0, "DEV_STM0_VBUSP_CLK", "Input clock"},
	{29, 1, "DEV_STM0_CORE_CLK", "Input clock"},
	{29, 2, "DEV_STM0_ATB_CLK", "Input clock"},
	{49, 0, "DEV_TIMER0_TIMER_HCLK_CLK", "Input clock"},
	{49, 1, "DEV_TIMER0_TIMER_TCLK_CLK", "Input muxed clock"},
	{49, 2, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 3, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 4, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 5, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 6, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 7, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 8, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 9, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 10, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 11, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 12, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 13, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 14, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 15, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 16, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 17, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 18, "DEV_TIMER0_TIMER_PWM", "Output clock"},
	{50, 0, "DEV_TIMER1_TIMER_HCLK_CLK", "Input clock"},
	{50, 1, "DEV_TIMER1_TIMER_TCLK_CLK", "Input muxed clock"},
	{50, 2, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT1", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{50, 3, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_0_TIMER_PWM", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{60, 0, "DEV_TIMER10_TIMER_HCLK_CLK", "Input clock"},
	{60, 1, "DEV_TIMER10_TIMER_TCLK_CLK", "Input muxed clock"},
	{60, 2, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 3, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 4, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 5, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 6, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 7, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 8, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 9, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 10, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 11, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 12, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 13, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 14, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 15, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 16, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 17, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 18, "DEV_TIMER10_TIMER_PWM", "Output clock"},
	{62, 0, "DEV_TIMER11_TIMER_HCLK_CLK", "Input clock"},
	{62, 1, "DEV_TIMER11_TIMER_TCLK_CLK", "Input muxed clock"},
	{62, 2, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT11", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{62, 3, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_10_TIMER_PWM", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{332, 0, "DEV_TIMER11_CLKSEL_VD_CLK", "Input muxed clock"},
	{332, 1, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{332, 2, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{332, 3, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{332, 4, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{332, 5, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{332, 6, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{332, 7, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{332, 8, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{332, 9, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{332, 10, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{332, 11, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{332, 12, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{332, 13, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{332, 14, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{332, 15, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{332, 16, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{63, 0, "DEV_TIMER12_TIMER_HCLK_CLK", "Input clock"},
	{63, 1, "DEV_TIMER12_TIMER_TCLK_CLK", "Input muxed clock"},
	{63, 2, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 3, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 4, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 5, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 6, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 7, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 8, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 9, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 10, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 11, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 12, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 13, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 14, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 15, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 16, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 17, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 18, "DEV_TIMER12_TIMER_PWM", "Output clock"},
	{64, 0, "DEV_TIMER13_TIMER_HCLK_CLK", "Input clock"},
	{64, 1, "DEV_TIMER13_TIMER_TCLK_CLK", "Input muxed clock"},
	{64, 2, "DEV_TIMER13_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT13", "Parent input clock option to DEV_TIMER13_TIMER_TCLK_CLK"},
	{64, 3, "DEV_TIMER13_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_12_TIMER_PWM", "Parent input clock option to DEV_TIMER13_TIMER_TCLK_CLK"},
	{333, 0, "DEV_TIMER13_CLKSEL_VD_CLK", "Input muxed clock"},
	{333, 1, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{333, 2, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{333, 3, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{333, 4, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{333, 5, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{333, 6, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{333, 7, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{333, 8, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{333, 9, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{333, 10, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{333, 11, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{333, 12, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{333, 13, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{333, 14, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{333, 15, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{333, 16, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{65, 0, "DEV_TIMER14_TIMER_HCLK_CLK", "Input clock"},
	{65, 1, "DEV_TIMER14_TIMER_TCLK_CLK", "Input muxed clock"},
	{65, 2, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 3, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 4, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 5, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 6, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 7, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 8, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 9, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 10, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 11, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 12, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 13, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 14, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 15, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 16, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 17, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 18, "DEV_TIMER14_TIMER_PWM", "Output clock"},
	{66, 0, "DEV_TIMER15_TIMER_HCLK_CLK", "Input clock"},
	{66, 1, "DEV_TIMER15_TIMER_TCLK_CLK", "Input muxed clock"},
	{66, 2, "DEV_TIMER15_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT15", "Parent input clock option to DEV_TIMER15_TIMER_TCLK_CLK"},
	{66, 3, "DEV_TIMER15_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_14_TIMER_PWM", "Parent input clock option to DEV_TIMER15_TIMER_TCLK_CLK"},
	{334, 0, "DEV_TIMER15_CLKSEL_VD_CLK", "Input muxed clock"},
	{334, 1, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{334, 2, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{334, 3, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{334, 4, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{334, 5, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{334, 6, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{334, 7, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{334, 8, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{334, 9, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{334, 10, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{334, 11, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{334, 12, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{334, 13, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{334, 14, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{334, 15, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{334, 16, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{67, 0, "DEV_TIMER16_TIMER_HCLK_CLK", "Input clock"},
	{67, 1, "DEV_TIMER16_TIMER_TCLK_CLK", "Input muxed clock"},
	{67, 2, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 3, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 4, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 5, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 6, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 7, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 8, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 9, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 10, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 11, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 12, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 13, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 14, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 15, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 16, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 17, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 18, "DEV_TIMER16_TIMER_PWM", "Output clock"},
	{68, 0, "DEV_TIMER17_TIMER_HCLK_CLK", "Input clock"},
	{68, 1, "DEV_TIMER17_TIMER_TCLK_CLK", "Input muxed clock"},
	{68, 2, "DEV_TIMER17_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT17", "Parent input clock option to DEV_TIMER17_TIMER_TCLK_CLK"},
	{68, 3, "DEV_TIMER17_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_16_TIMER_PWM", "Parent input clock option to DEV_TIMER17_TIMER_TCLK_CLK"},
	{335, 0, "DEV_TIMER17_CLKSEL_VD_CLK", "Input muxed clock"},
	{335, 1, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{335, 2, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{335, 3, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{335, 4, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{335, 5, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{335, 6, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{335, 7, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{335, 8, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{335, 9, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{335, 10, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{335, 11, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{335, 12, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{335, 13, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{335, 14, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{335, 15, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{335, 16, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{69, 0, "DEV_TIMER18_TIMER_HCLK_CLK", "Input clock"},
	{69, 1, "DEV_TIMER18_TIMER_TCLK_CLK", "Input muxed clock"},
	{69, 2, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 3, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 4, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 5, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 6, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 7, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 8, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 9, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 10, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 11, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 12, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 13, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 14, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 15, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 16, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 17, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 18, "DEV_TIMER18_TIMER_PWM", "Output clock"},
	{70, 0, "DEV_TIMER19_TIMER_HCLK_CLK", "Input clock"},
	{70, 1, "DEV_TIMER19_TIMER_TCLK_CLK", "Input muxed clock"},
	{70, 2, "DEV_TIMER19_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT19", "Parent input clock option to DEV_TIMER19_TIMER_TCLK_CLK"},
	{70, 3, "DEV_TIMER19_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_18_TIMER_PWM", "Parent input clock option to DEV_TIMER19_TIMER_TCLK_CLK"},
	{336, 0, "DEV_TIMER19_CLKSEL_VD_CLK", "Input muxed clock"},
	{336, 1, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{336, 2, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{336, 3, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{336, 4, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{336, 5, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{336, 6, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{336, 7, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{336, 8, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{336, 9, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{336, 10, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{336, 11, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{336, 12, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{336, 13, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{336, 14, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{336, 15, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{336, 16, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{327, 0, "DEV_TIMER1_CLKSEL_VD_CLK", "Input muxed clock"},
	{327, 1, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{327, 2, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{327, 3, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{327, 4, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{327, 5, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{327, 6, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{327, 7, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{327, 8, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{327, 9, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{327, 10, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{327, 11, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{327, 12, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{327, 13, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{327, 14, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{327, 15, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{327, 16, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{51, 0, "DEV_TIMER2_TIMER_HCLK_CLK", "Input clock"},
	{51, 1, "DEV_TIMER2_TIMER_TCLK_CLK", "Input muxed clock"},
	{51, 2, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 3, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 4, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 5, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 6, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 7, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 8, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 9, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 10, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 11, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 12, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 13, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 14, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 15, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 16, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 17, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 18, "DEV_TIMER2_TIMER_PWM", "Output clock"},
	{52, 0, "DEV_TIMER3_TIMER_HCLK_CLK", "Input clock"},
	{52, 1, "DEV_TIMER3_TIMER_TCLK_CLK", "Input muxed clock"},
	{52, 2, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT3", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{52, 3, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_2_TIMER_PWM", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{328, 0, "DEV_TIMER3_CLKSEL_VD_CLK", "Input muxed clock"},
	{328, 1, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{328, 2, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{328, 3, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{328, 4, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{328, 5, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{328, 6, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{328, 7, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{328, 8, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{328, 9, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{328, 10, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{328, 11, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{328, 12, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{328, 13, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{328, 14, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{328, 15, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{328, 16, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{53, 0, "DEV_TIMER4_TIMER_HCLK_CLK", "Input clock"},
	{53, 1, "DEV_TIMER4_TIMER_TCLK_CLK", "Input muxed clock"},
	{53, 2, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 3, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 4, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 5, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 6, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 7, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 8, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 9, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 10, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 11, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 12, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 13, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 14, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 15, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 16, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 17, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 18, "DEV_TIMER4_TIMER_PWM", "Output clock"},
	{54, 0, "DEV_TIMER5_TIMER_HCLK_CLK", "Input clock"},
	{54, 1, "DEV_TIMER5_TIMER_TCLK_CLK", "Input muxed clock"},
	{54, 2, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT5", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{54, 3, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_4_TIMER_PWM", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{329, 0, "DEV_TIMER5_CLKSEL_VD_CLK", "Input muxed clock"},
	{329, 1, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{329, 2, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{329, 3, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{329, 4, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{329, 5, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{329, 6, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{329, 7, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{329, 8, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{329, 9, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{329, 10, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{329, 11, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{329, 12, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{329, 13, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{329, 14, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{329, 15, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{329, 16, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{55, 0, "DEV_TIMER6_TIMER_HCLK_CLK", "Input clock"},
	{55, 1, "DEV_TIMER6_TIMER_TCLK_CLK", "Input muxed clock"},
	{55, 2, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 3, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 4, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 5, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 6, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 7, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 8, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 9, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 10, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 11, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 12, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 13, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 14, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 15, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 16, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 17, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 18, "DEV_TIMER6_TIMER_PWM", "Output clock"},
	{57, 0, "DEV_TIMER7_TIMER_HCLK_CLK", "Input clock"},
	{57, 1, "DEV_TIMER7_TIMER_TCLK_CLK", "Input muxed clock"},
	{57, 2, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT7", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{57, 3, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_6_TIMER_PWM", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{330, 0, "DEV_TIMER7_CLKSEL_VD_CLK", "Input muxed clock"},
	{330, 1, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{330, 2, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{330, 3, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{330, 4, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{330, 5, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{330, 6, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{330, 7, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{330, 8, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{330, 9, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{330, 10, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{330, 11, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{330, 12, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{330, 13, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{330, 14, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{330, 15, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{330, 16, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{58, 0, "DEV_TIMER8_TIMER_HCLK_CLK", "Input clock"},
	{58, 1, "DEV_TIMER8_TIMER_TCLK_CLK", "Input muxed clock"},
	{58, 2, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 3, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 4, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 5, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 6, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 7, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 8, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 9, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 10, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 11, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 12, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 13, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 14, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 15, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 16, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 17, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 18, "DEV_TIMER8_TIMER_PWM", "Output clock"},
	{59, 0, "DEV_TIMER9_TIMER_HCLK_CLK", "Input clock"},
	{59, 1, "DEV_TIMER9_TIMER_TCLK_CLK", "Input muxed clock"},
	{59, 2, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT9", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{59, 3, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_8_TIMER_PWM", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{331, 0, "DEV_TIMER9_CLKSEL_VD_CLK", "Input muxed clock"},
	{331, 1, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{331, 2, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{331, 3, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{331, 4, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_J7_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{331, 5, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{331, 6, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{331, 7, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{331, 8, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{331, 9, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{331, 10, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{331, 11, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{331, 12, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{331, 13, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{331, 14, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_NAVSS512L_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{331, 15, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_CPSW_9XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{331, 16, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_HSDIV3_16FFT_MAIN_15_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{136, 0, "DEV_TIMESYNC_INTRTR0_INTR_CLK", "Input clock"},
	{146, 0, "DEV_UART0_FCLK_CLK", "Input clock"},
	{146, 1, "DEV_UART0_VBUSP_CLK", "Input clock"},
	{278, 0, "DEV_UART1_FCLK_CLK", "Input clock"},
	{278, 1, "DEV_UART1_VBUSP_CLK", "Input clock"},
	{279, 0, "DEV_UART2_FCLK_CLK", "Input clock"},
	{279, 1, "DEV_UART2_VBUSP_CLK", "Input clock"},
	{280, 0, "DEV_UART3_FCLK_CLK", "Input clock"},
	{280, 1, "DEV_UART3_VBUSP_CLK", "Input clock"},
	{281, 0, "DEV_UART4_FCLK_CLK", "Input clock"},
	{281, 1, "DEV_UART4_VBUSP_CLK", "Input clock"},
	{282, 0, "DEV_UART5_FCLK_CLK", "Input clock"},
	{282, 1, "DEV_UART5_VBUSP_CLK", "Input clock"},
	{283, 0, "DEV_UART6_FCLK_CLK", "Input clock"},
	{283, 1, "DEV_UART6_VBUSP_CLK", "Input clock"},
	{284, 0, "DEV_UART7_FCLK_CLK", "Input clock"},
	{284, 1, "DEV_UART7_VBUSP_CLK", "Input clock"},
	{285, 0, "DEV_UART8_FCLK_CLK", "Input clock"},
	{285, 1, "DEV_UART8_VBUSP_CLK", "Input clock"},
	{286, 0, "DEV_UART9_FCLK_CLK", "Input clock"},
	{286, 1, "DEV_UART9_VBUSP_CLK", "Input clock"},
	{277, 0, "DEV_UFS0_UFSHCI_HCLK_CLK", "Input clock"},
	{277, 1, "DEV_UFS0_UFSHCI_MCLK_CLK", "Input muxed clock"},
	{277, 2, "DEV_UFS0_UFSHCI_MCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_UFS0_UFSHCI_MCLK_CLK"},
	{277, 3, "DEV_UFS0_UFSHCI_MCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_UFS0_UFSHCI_MCLK_CLK"},
	{277, 4, "DEV_UFS0_UFSHCI_MCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_1_HSDIVOUT6_CLK", "Parent input clock option to DEV_UFS0_UFSHCI_MCLK_CLK"},
	{277, 5, "DEV_UFS0_UFSHCI_MCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_UFS0_UFSHCI_MCLK_CLK"},
	{277, 6, "DEV_UFS0_UFSHCI_MPHY_REFCLK", "Output clock"},
	{288, 0, "DEV_USB0_PIPE_REFCLK", "Input muxed clock"},
	{288, 1, "DEV_USB0_PIPE_REFCLK_PARENT_WIZ16B4M4CS_MAIN_0_IP3_LN1_REFCLK", "Parent input clock option to DEV_USB0_PIPE_REFCLK"},
	{288, 2, "DEV_USB0_PIPE_REFCLK_PARENT_WIZ16B4M4CS_MAIN_3_IP3_LN1_REFCLK", "Parent input clock option to DEV_USB0_PIPE_REFCLK"},
	{288, 3, "DEV_USB0_CLK_LPM_CLK", "Input clock"},
	{288, 4, "DEV_USB0_BUF_CLK", "Input clock"},
	{288, 5, "DEV_USB0_USB2_APB_PCLK_CLK", "Input clock"},
	{288, 6, "DEV_USB0_PIPE_RXCLK", "Input muxed clock"},
	{288, 7, "DEV_USB0_PIPE_RXCLK_PARENT_WIZ16B4M4CS_MAIN_0_IP3_LN1_RXCLK", "Parent input clock option to DEV_USB0_PIPE_RXCLK"},
	{288, 8, "DEV_USB0_PIPE_RXCLK_PARENT_WIZ16B4M4CS_MAIN_3_IP3_LN1_RXCLK", "Parent input clock option to DEV_USB0_PIPE_RXCLK"},
	{288, 9, "DEV_USB0_PIPE_TXMCLK", "Input muxed clock"},
	{288, 10, "DEV_USB0_PIPE_TXMCLK_PARENT_WIZ16B4M4CS_MAIN_0_IP3_LN1_TXMCLK", "Parent input clock option to DEV_USB0_PIPE_TXMCLK"},
	{288, 11, "DEV_USB0_PIPE_TXMCLK_PARENT_WIZ16B4M4CS_MAIN_3_IP3_LN1_TXMCLK", "Parent input clock option to DEV_USB0_PIPE_TXMCLK"},
	{288, 12, "DEV_USB0_PIPE_RXFCLK", "Input muxed clock"},
	{288, 13, "DEV_USB0_PIPE_RXFCLK_PARENT_WIZ16B4M4CS_MAIN_0_IP3_LN1_RXFCLK", "Parent input clock option to DEV_USB0_PIPE_RXFCLK"},
	{288, 14, "DEV_USB0_PIPE_RXFCLK_PARENT_WIZ16B4M4CS_MAIN_3_IP3_LN1_RXFCLK", "Parent input clock option to DEV_USB0_PIPE_RXFCLK"},
	{288, 15, "DEV_USB0_USB2_REFCLOCK_CLK", "Input muxed clock"},
	{288, 16, "DEV_USB0_USB2_REFCLOCK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_USB0_USB2_REFCLOCK_CLK"},
	{288, 17, "DEV_USB0_USB2_REFCLOCK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_USB0_USB2_REFCLOCK_CLK"},
	{288, 18, "DEV_USB0_PCLK_CLK", "Input clock"},
	{288, 19, "DEV_USB0_ACLK_CLK", "Input clock"},
	{288, 20, "DEV_USB0_PIPE_TXFCLK", "Input muxed clock"},
	{288, 21, "DEV_USB0_PIPE_TXFCLK_PARENT_WIZ16B4M4CS_MAIN_0_IP3_LN1_TXFCLK", "Parent input clock option to DEV_USB0_PIPE_TXFCLK"},
	{288, 22, "DEV_USB0_PIPE_TXFCLK_PARENT_WIZ16B4M4CS_MAIN_3_IP3_LN1_TXFCLK", "Parent input clock option to DEV_USB0_PIPE_TXFCLK"},
	{288, 23, "DEV_USB0_PIPE_TXCLK", "Output clock"},
	{289, 0, "DEV_USB1_PIPE_REFCLK", "Input muxed clock"},
	{289, 1, "DEV_USB1_PIPE_REFCLK_PARENT_WIZ16B4M4CS_MAIN_1_IP3_LN1_REFCLK", "Parent input clock option to DEV_USB1_PIPE_REFCLK"},
	{289, 2, "DEV_USB1_PIPE_REFCLK_PARENT_WIZ16B4M4CS_MAIN_2_IP3_LN1_REFCLK", "Parent input clock option to DEV_USB1_PIPE_REFCLK"},
	{289, 3, "DEV_USB1_CLK_LPM_CLK", "Input clock"},
	{289, 4, "DEV_USB1_BUF_CLK", "Input clock"},
	{289, 5, "DEV_USB1_USB2_APB_PCLK_CLK", "Input clock"},
	{289, 6, "DEV_USB1_PIPE_RXCLK", "Input muxed clock"},
	{289, 7, "DEV_USB1_PIPE_RXCLK_PARENT_WIZ16B4M4CS_MAIN_1_IP3_LN1_RXCLK", "Parent input clock option to DEV_USB1_PIPE_RXCLK"},
	{289, 8, "DEV_USB1_PIPE_RXCLK_PARENT_WIZ16B4M4CS_MAIN_2_IP3_LN1_RXCLK", "Parent input clock option to DEV_USB1_PIPE_RXCLK"},
	{289, 9, "DEV_USB1_PIPE_TXMCLK", "Input muxed clock"},
	{289, 10, "DEV_USB1_PIPE_TXMCLK_PARENT_WIZ16B4M4CS_MAIN_1_IP3_LN1_TXMCLK", "Parent input clock option to DEV_USB1_PIPE_TXMCLK"},
	{289, 11, "DEV_USB1_PIPE_TXMCLK_PARENT_WIZ16B4M4CS_MAIN_2_IP3_LN1_TXMCLK", "Parent input clock option to DEV_USB1_PIPE_TXMCLK"},
	{289, 12, "DEV_USB1_PIPE_RXFCLK", "Input muxed clock"},
	{289, 13, "DEV_USB1_PIPE_RXFCLK_PARENT_WIZ16B4M4CS_MAIN_1_IP3_LN1_RXFCLK", "Parent input clock option to DEV_USB1_PIPE_RXFCLK"},
	{289, 14, "DEV_USB1_PIPE_RXFCLK_PARENT_WIZ16B4M4CS_MAIN_2_IP3_LN1_RXFCLK", "Parent input clock option to DEV_USB1_PIPE_RXFCLK"},
	{289, 15, "DEV_USB1_USB2_REFCLOCK_CLK", "Input muxed clock"},
	{289, 16, "DEV_USB1_USB2_REFCLOCK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_USB1_USB2_REFCLOCK_CLK"},
	{289, 17, "DEV_USB1_USB2_REFCLOCK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_USB1_USB2_REFCLOCK_CLK"},
	{289, 18, "DEV_USB1_PCLK_CLK", "Input clock"},
	{289, 19, "DEV_USB1_ACLK_CLK", "Input clock"},
	{289, 20, "DEV_USB1_PIPE_TXFCLK", "Input muxed clock"},
	{289, 21, "DEV_USB1_PIPE_TXFCLK_PARENT_WIZ16B4M4CS_MAIN_1_IP3_LN1_TXFCLK", "Parent input clock option to DEV_USB1_PIPE_TXFCLK"},
	{289, 22, "DEV_USB1_PIPE_TXFCLK_PARENT_WIZ16B4M4CS_MAIN_2_IP3_LN1_TXFCLK", "Parent input clock option to DEV_USB1_PIPE_TXFCLK"},
	{289, 23, "DEV_USB1_PIPE_TXCLK", "Output clock"},
	{290, 0, "DEV_VPAC0_CLK", "Input clock"},
	{290, 1, "DEV_VPAC0_PLL_DCO_CLK", "Input clock"},
	{291, 0, "DEV_VPFE0_CCD_PCLK_CLK", "Input clock"},
	{291, 1, "DEV_VPFE0_VPFE_CLK", "Input clock"},
	{145, 0, "DEV_WKUP_DDPA0_DDPA_CLK", "Input clock"},
	{99, 0, "DEV_WKUP_ESM0_CLK", "Input clock"},
	{113, 0, "DEV_WKUP_GPIO0_MMR_CLK", "Input clock"},
	{114, 0, "DEV_WKUP_GPIO1_MMR_CLK", "Input clock"},
	{137, 0, "DEV_WKUP_GPIOMUX_INTRTR0_INTR_CLK", "Input clock"},
	{197, 0, "DEV_WKUP_I2C0_PISYS_CLK", "Input muxed clock"},
	{197, 1, "DEV_WKUP_I2C0_PISYS_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_WKUP_I2C0_PISYS_CLK"},
	{197, 2, "DEV_WKUP_I2C0_PISYS_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_WKUP_I2C0_PISYS_CLK"},
	{197, 3, "DEV_WKUP_I2C0_PISCL", "Input clock"},
	{197, 4, "DEV_WKUP_I2C0_CLK", "Input clock"},
	{197, 5, "DEV_WKUP_I2C0_PORSCL", "Output clock"},
	{132, 0, "DEV_WKUP_PORZ_SYNC0_CLK_12M_RC_CLK", "Input clock"},
	{138, 0, "DEV_WKUP_PSC0_SLOW_CLK", "Input clock"},
	{138, 1, "DEV_WKUP_PSC0_CLK", "Input clock"},
	{287, 0, "DEV_WKUP_UART0_FCLK_CLK", "Input muxed clock"},
	{287, 1, "DEV_WKUP_UART0_FCLK_CLK_PARENT_WKUPUSART_CLK_SEL_OUT0", "Parent input clock option to DEV_WKUP_UART0_FCLK_CLK"},
	{287, 2, "DEV_WKUP_UART0_FCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_WKUP_UART0_FCLK_CLK"},
	{287, 3, "DEV_WKUP_UART0_VBUSP_CLK", "Input clock"},
	{154, 0, "DEV_WKUP_VTM0_FIX_REF2_CLK", "Input clock"},
	{154, 1, "DEV_WKUP_VTM0_VBUSP_CLK", "Input clock"},
	{154, 2, "DEV_WKUP_VTM0_FIX_REF_CLK", "Input clock"},
};
