
// copicatreplay1_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  1.000000
 // --table_div  44.133383
 // --table_op  0.040000

struct tablecopicatreplay1 { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tablecopicatreplay1_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tablecopicatreplay1&() const { return *(tablecopicatreplay1*)this; }
};

 static tablecopicatreplay1_imp<2048> copicatreplay1_table __rt_data = {
	0,-0.833333,81.88,2048, {
	0.000000000000,-0.000552293731,-0.001104460682,-0.001656500787,-0.002208413977,
	-0.002760200186,-0.003311859348,-0.003863391395,-0.004414796261,-0.004966073879,
	-0.005517224183,-0.006068247107,-0.006619142585,-0.007169910550,-0.007720550938,
	-0.008271063681,-0.008821448715,-0.009371705974,-0.009921835392,-0.010471836906,
	-0.011021710448,-0.011571455955,-0.012121073361,-0.012670562602,-0.013219923613,
	-0.013769156329,-0.014318260687,-0.014867236622,-0.015416084070,-0.015964802966,
	-0.016513393248,-0.017061854851,-0.017610187711,-0.018158391766,-0.018706466951,
	-0.019254413204,-0.019802230461,-0.020349918660,-0.020897477736,-0.021444907629,
	-0.021992208274,-0.022539379610,-0.023086421573,-0.023633334103,-0.024180117136,
	-0.024726770610,-0.025273294464,-0.025819688636,-0.026365953064,-0.026912087686,
	-0.027458092441,-0.028003967268,-0.028549712106,-0.029095326893,-0.029640811568,
	-0.030186166071,-0.030731390341,-0.031276484317,-0.031821447940,-0.032366281147,
	-0.032910983880,-0.033455556078,-0.033999997680,-0.034544308628,-0.035088488862,
	-0.035632538321,-0.036176456946,-0.036720244679,-0.037263901458,-0.037807427227,
	-0.038350821924,-0.038894085492,-0.039437217871,-0.039980219003,-0.040523088830,
	-0.041065827292,-0.041608434332,-0.042150909891,-0.042693253911,-0.043235466334,
	-0.043777547102,-0.044319496158,-0.044861313444,-0.045402998902,-0.045944552475,
	-0.046485974105,-0.047027263737,-0.047568421311,-0.048109446772,-0.048650340063,
	-0.049191101126,-0.049731729906,-0.050272226346,-0.050812590389,-0.051352821979,
	-0.051892921061,-0.052432887578,-0.052972721474,-0.053512422693,-0.054051991181,
	-0.054591426880,-0.055130729737,-0.055669899695,-0.056208936699,-0.056747840694,
	-0.057286611626,-0.057825249439,-0.058363754079,-0.058902125490,-0.059440363620,
	-0.059978468412,-0.060516439813,-0.061054277769,-0.061591982226,-0.062129553129,
	-0.062666990425,-0.063204294060,-0.063741463981,-0.064278500133,-0.064815402465,
	-0.065352170922,-0.065888805451,-0.066425305999,-0.066961672513,-0.067497904941,
	-0.068034003230,-0.068569967327,-0.069105797180,-0.069641492736,-0.070177053944,
	-0.070712480750,-0.071247773104,-0.071782930952,-0.072317954244,-0.072852842927,
	-0.073387596951,-0.073922216263,-0.074456700812,-0.074991050548,-0.075525265418,
	-0.076059345372,-0.076593290359,-0.077127100328,-0.077660775229,-0.078194315010,
	-0.078727719622,-0.079260989014,-0.079794123137,-0.080327121938,-0.080859985370,
	-0.081392713381,-0.081925305923,-0.082457762944,-0.082990084397,-0.083522270231,
	-0.084054320396,-0.084586234845,-0.085118013527,-0.085649656393,-0.086181163396,
	-0.086712534485,-0.087243769612,-0.087774868728,-0.088305831786,-0.088836658736,
	-0.089367349531,-0.089897904122,-0.090428322462,-0.090958604501,-0.091488750193,
	-0.092018759490,-0.092548632343,-0.093078368707,-0.093607968532,-0.094137431773,
	-0.094666758381,-0.095195948310,-0.095725001513,-0.096253917942,-0.096782697551,
	-0.097311340294,-0.097839846124,-0.098368214995,-0.098896446859,-0.099424541671,
	-0.099952499386,-0.100480319956,-0.101008003336,-0.101535549480,-0.102062958343,
	-0.102590229878,-0.103117364041,-0.103644360786,-0.104171220068,-0.104697941841,
	-0.105224526061,-0.105750972683,-0.106277281661,-0.106803452952,-0.107329486510,
	-0.107855382291,-0.108381140250,-0.108906760344,-0.109432242527,-0.109957586757,
	-0.110482792988,-0.111007861178,-0.111532791282,-0.112057583256,-0.112582237057,
	-0.113106752642,-0.113631129967,-0.114155368989,-0.114679469665,-0.115203431951,
	-0.115727255805,-0.116250941184,-0.116774488045,-0.117297896345,-0.117821166043,
	-0.118344297095,-0.118867289459,-0.119390143093,-0.119912857955,-0.120435434002,
	-0.120957871194,-0.121480169487,-0.122002328841,-0.122524349214,-0.123046230564,
	-0.123567972849,-0.124089576030,-0.124611040063,-0.125132364909,-0.125653550526,
	-0.126174596873,-0.126695503910,-0.127216271595,-0.127736899889,-0.128257388750,
	-0.128777738139,-0.129297948015,-0.129818018338,-0.130337949068,-0.130857740164,
	-0.131377391587,-0.131896903298,-0.132416275255,-0.132935507421,-0.133454599755,
	-0.133973552218,-0.134492364771,-0.135011037374,-0.135529569989,-0.136047962576,
	-0.136566215097,-0.137084327513,-0.137602299784,-0.138120131873,-0.138637823742,
	-0.139155375351,-0.139672786662,-0.140190057638,-0.140707188239,-0.141224178429,
	-0.141741028169,-0.142257737421,-0.142774306148,-0.143290734313,-0.143807021877,
	-0.144323168803,-0.144839175054,-0.145355040593,-0.145870765383,-0.146386349386,
	-0.146901792566,-0.147417094886,-0.147932256309,-0.148447276799,-0.148962156319,
	-0.149476894833,-0.149991492304,-0.150505948696,-0.151020263973,-0.151534438099,
	-0.152048471038,-0.152562362755,-0.153076113213,-0.153589722377,-0.154103190211,
	-0.154616516679,-0.155129701748,-0.155642745380,-0.156155647542,-0.156668408198,
	-0.157181027313,-0.157693504852,-0.158205840780,-0.158718035063,-0.159230087666,
	-0.159741998555,-0.160253767695,-0.160765395052,-0.161276880592,-0.161788224280,
	-0.162299426083,-0.162810485967,-0.163321403897,-0.163832179841,-0.164342813764,
	-0.164853305633,-0.165363655415,-0.165873863076,-0.166383928583,-0.166893851902,
	-0.167403633002,-0.167913271848,-0.168422768408,-0.168932122648,-0.169441334538,
	-0.169950404043,-0.170459331131,-0.170968115770,-0.171476757927,-0.171985257571,
	-0.172493614669,-0.173001829189,-0.173509901100,-0.174017830368,-0.174525616963,
	-0.175033260853,-0.175540762007,-0.176048120392,-0.176555335977,-0.177062408732,
	-0.177569338625,-0.178076125624,-0.178582769699,-0.179089270819,-0.179595628953,
	-0.180101844071,-0.180607916141,-0.181113845133,-0.181619631016,-0.182125273761,
	-0.182630773337,-0.183136129713,-0.183641342860,-0.184146412748,-0.184651339346,
	-0.185156122625,-0.185660762555,-0.186165259106,-0.186669612250,-0.187173821956,
	-0.187677888194,-0.188181810937,-0.188685590154,-0.189189225816,-0.189692717895,
	-0.190196066361,-0.190699271186,-0.191202332340,-0.191705249796,-0.192208023524,
	-0.192710653497,-0.193213139685,-0.193715482061,-0.194217680595,-0.194719735261,
	-0.195221646030,-0.195723412874,-0.196225035765,-0.196726514676,-0.197227849578,
	-0.197729040445,-0.198230087248,-0.198730989961,-0.199231748555,-0.199732363004,
	-0.200232833281,-0.200733159358,-0.201233341209,-0.201733378806,-0.202233272123,
	-0.202733021132,-0.203232625809,-0.203732086125,-0.204231402055,-0.204730573572,
	-0.205229600649,-0.205728483261,-0.206227221382,-0.206725814985,-0.207224264045,
	-0.207722568535,-0.208220728430,-0.208718743705,-0.209216614333,-0.209714340290,
	-0.210211921549,-0.210709358085,-0.211206649874,-0.211703796890,-0.212200799108,
	-0.212697656503,-0.213194369050,-0.213690936724,-0.214187359501,-0.214683637356,
	-0.215179770264,-0.215675758201,-0.216171601143,-0.216667299064,-0.217162851942,
	-0.217658259752,-0.218153522469,-0.218648640070,-0.219143612532,-0.219638439829,
	-0.220133121939,-0.220627658838,-0.221122050502,-0.221616296908,-0.222110398032,
	-0.222604353852,-0.223098164344,-0.223591829484,-0.224085349251,-0.224578723620,
	-0.225071952569,-0.225565036076,-0.226057974117,-0.226550766670,-0.227043413712,
	-0.227535915222,-0.228028271176,-0.228520481552,-0.229012546328,-0.229504465483,
	-0.229996238993,-0.230487866837,-0.230979348993,-0.231470685440,-0.231961876155,
	-0.232452921118,-0.232943820305,-0.233434573697,-0.233925181271,-0.234415643006,
	-0.234905958882,-0.235396128877,-0.235886152969,-0.236376031138,-0.236865763364,
	-0.237355349624,-0.237844789899,-0.238334084168,-0.238823232410,-0.239312234606,
	-0.239801090733,-0.240289800772,-0.240778364704,-0.241266782507,-0.241755054162,
	-0.242243179648,-0.242731158946,-0.243218992035,-0.243706678897,-0.244194219512,
	-0.244681613859,-0.245168861919,-0.245655963673,-0.246142919102,-0.246629728186,
	-0.247116390906,-0.247602907243,-0.248089277177,-0.248575500691,-0.249061577764,
	-0.249547508379,-0.250033292517,-0.250518930158,-0.251004421284,-0.251489765877,
	-0.251974963919,-0.252460015390,-0.252944920274,-0.253429678551,-0.253914290204,
	-0.254398755214,-0.254883073563,-0.255367245235,-0.255851270210,-0.256335148472,
	-0.256818880002,-0.257302464783,-0.257785902798,-0.258269194029,-0.258752338459,
	-0.259235336071,-0.259718186847,-0.260200890771,-0.260683447825,-0.261165857992,
	-0.261648121257,-0.262130237601,-0.262612207008,-0.263094029461,-0.263575704945,
	-0.264057233442,-0.264538614937,-0.265019849412,-0.265500936852,-0.265981877240,
	-0.266462670561,-0.266943316798,-0.267423815935,-0.267904167957,-0.268384372848,
	-0.268864430591,-0.269344341173,-0.269824104576,-0.270303720785,-0.270783189786,
	-0.271262511562,-0.271741686099,-0.272220713381,-0.272699593393,-0.273178326120,
	-0.273656911547,-0.274135349660,-0.274613640443,-0.275091783882,-0.275569779962,
	-0.276047628669,-0.276525329987,-0.277002883903,-0.277480290403,-0.277957549472,
	-0.278434661095,-0.278911625259,-0.279388441949,-0.279865111152,-0.280341632854,
	-0.280818007041,-0.281294233698,-0.281770312814,-0.282246244373,-0.282722028362,
	-0.283197664768,-0.283673153577,-0.284148494776,-0.284623688353,-0.285098734293,
	-0.285573632583,-0.286048383211,-0.286522986163,-0.286997441427,-0.287471748990,
	-0.287945908839,-0.288419920962,-0.288893785345,-0.289367501977,-0.289841070844,
	-0.290314491935,-0.290787765238,-0.291260890739,-0.291733868427,-0.292206698289,
	-0.292679380315,-0.293151914491,-0.293624300806,-0.294096539248,-0.294568629805,
	-0.295040572466,-0.295512367219,-0.295984014053,-0.296455512955,-0.296926863916,
	-0.297398066923,-0.297869121965,-0.298340029031,-0.298810788110,-0.299281399190,
	-0.299751862262,-0.300222177314,-0.300692344335,-0.301162363315,-0.301632234242,
	-0.302101957107,-0.302571531899,-0.303040958606,-0.303510237220,-0.303979367729,
	-0.304448350123,-0.304917184393,-0.305385870527,-0.305854408517,-0.306322798351,
	-0.306791040020,-0.307259133515,-0.307727078825,-0.308194875941,-0.308662524853,
	-0.309130025543,-0.309597378018,-0.310064582262,-0.310531638263,-0.310998546014,
	-0.311465305505,-0.311931916726,-0.312398379669,-0.312864694324,-0.313330860683,
	-0.313796878737,-0.314262748476,-0.314728469893,-0.315194042979,-0.315659467724,
	-0.316124744121,-0.316589872161,-0.317054851835,-0.317519683136,-0.317984366054,
	-0.318448900583,-0.318913286712,-0.319377524436,-0.319841613745,-0.320305554632,
	-0.320769347088,-0.321232991106,-0.321696486679,-0.322159833798,-0.322623032457,
	-0.323086082646,-0.323548984360,-0.324011737590,-0.324474342330,-0.324936798572,
	-0.325399106308,-0.325861265533,-0.326323276237,-0.326785138416,-0.327246852061,
	-0.327708417166,-0.328169833725,-0.328631101729,-0.329092221173,-0.329553192050,
	-0.330014014354,-0.330474688078,-0.330935213215,-0.331395589760,-0.331855817705,
	-0.332315897046,-0.332775827775,-0.333235609886,-0.333695243375,-0.334154728233,
	-0.334614064457,-0.335073252039,-0.335532290975,-0.335991181258,-0.336449922883,
	-0.336908515844,-0.337366960136,-0.337825255753,-0.338283402690,-0.338741400942,
	-0.339199250503,-0.339656951368,-0.340114503533,-0.340571906992,-0.341029161739,
	-0.341486267771,-0.341943225082,-0.342400033667,-0.342856693522,-0.343313204643,
	-0.343769567024,-0.344225780660,-0.344681845548,-0.345137761683,-0.345593529061,
	-0.346049147677,-0.346504617527,-0.346959938608,-0.347415110914,-0.347870134442,
	-0.348325009187,-0.348779735147,-0.349234312317,-0.349688740693,-0.350143020271,
	-0.350597151049,-0.351051133022,-0.351504966186,-0.351958650539,-0.352412186076,
	-0.352865572795,-0.353318810692,-0.353771899764,-0.354224840008,-0.354677631420,
	-0.355130273998,-0.355582767739,-0.356035112639,-0.356487308696,-0.356939355907,
	-0.357391254270,-0.357843003780,-0.358294604437,-0.358746056237,-0.359197359178,
	-0.359648513258,-0.360099518473,-0.360550374823,-0.361001082303,-0.361451640913,
	-0.361902050651,-0.362352311513,-0.362802423498,-0.363252386604,-0.363702200830,
	-0.364151866172,-0.364601382631,-0.365050750203,-0.365499968887,-0.365949038682,
	-0.366397959586,-0.366846731598,-0.367295354715,-0.367743828938,-0.368192154264,
	-0.368640330692,-0.369088358221,-0.369536236850,-0.369983966578,-0.370431547404,
	-0.370878979326,-0.371326262345,-0.371773396459,-0.372220381667,-0.372667217969,
	-0.373113905364,-0.373560443851,-0.374006833430,-0.374453074101,-0.374899165863,
	-0.375345108715,-0.375790902658,-0.376236547690,-0.376682043813,-0.377127391025,
	-0.377572589327,-0.378017638719,-0.378462539200,-0.378907290771,-0.379351893433,
	-0.379796347184,-0.380240652026,-0.380684807958,-0.381128814982,-0.381572673097,
	-0.382016382305,-0.382459942605,-0.382903353998,-0.383346616486,-0.383789730068,
	-0.384232694745,-0.384675510519,-0.385118177390,-0.385560695359,-0.386003064428,
	-0.386445284596,-0.386887355866,-0.387329278239,-0.387771051715,-0.388212676296,
	-0.388654151984,-0.389095478780,-0.389536656685,-0.389977685700,-0.390418565829,
	-0.390859297071,-0.391299879429,-0.391740312904,-0.392180597498,-0.392620733214,
	-0.393060720053,-0.393500558016,-0.393940247107,-0.394379787326,-0.394819178677,
	-0.395258421161,-0.395697514781,-0.396136459538,-0.396575255436,-0.397013902476,
	-0.397452400662,-0.397890749995,-0.398328950478,-0.398767002114,-0.399204904906,
	-0.399642658855,-0.400080263966,-0.400517720241,-0.400955027682,-0.401392186293,
	-0.401829196076,-0.402266057035,-0.402702769174,-0.403139332494,-0.403575746999,
	-0.404012012692,-0.404448129578,-0.404884097659,-0.405319916938,-0.405755587419,
	-0.406191109106,-0.406626482002,-0.407061706111,-0.407496781437,-0.407931707983,
	-0.408366485753,-0.408801114751,-0.409235594980,-0.409669926446,-0.410104109152,
	-0.410538143101,-0.410972028299,-0.411405764748,-0.411839352454,-0.412272791421,
	-0.412706081653,-0.413139223154,-0.413572215930,-0.414005059983,-0.414437755320,
	-0.414870301944,-0.415302699860,-0.415734949073,-0.416167049587,-0.416599001408,
	-0.417030804540,-0.417462458988,-0.417893964757,-0.418325321853,-0.418756530279,
	-0.419187590042,-0.419618501146,-0.420049263597,-0.420479877400,-0.420910342560,
	-0.421340659082,-0.421770826973,-0.422200846237,-0.422630716880,-0.423060438907,
	-0.423490012325,-0.423919437139,-0.424348713354,-0.424777840976,-0.425206820012,
	-0.425635650466,-0.426064332346,-0.426492865656,-0.426921250404,-0.427349486594,
	-0.427777574234,-0.428205513329,-0.428633303885,-0.429060945909,-0.429488439408,
	-0.429915784387,-0.430342980853,-0.430770028812,-0.431196928271,-0.431623679237,
	-0.432050281716,-0.432476735715,-0.432903041240,-0.433329198299,-0.433755206898,
	-0.434181067044,-0.434606778743,-0.435032342004,-0.435457756832,-0.435883023236,
	-0.436308141221,-0.436733110796,-0.437157931967,-0.437582604742,-0.438007129128,
	-0.438431505133,-0.438855732763,-0.439279812026,-0.439703742930,-0.440127525483,
	-0.440551159691,-0.440974645563,-0.441397983106,-0.441821172329,-0.442244213238,
	-0.442667105841,-0.443089850147,-0.443512446164,-0.443934893899,-0.444357193360,
	-0.444779344557,-0.445201347495,-0.445623202185,-0.446044908634,-0.446466466850,
	-0.446887876841,-0.447309138617,-0.447730252185,-0.448151217555,-0.448572034733,
	-0.448992703730,-0.449413224553,-0.449833597211,-0.450253821713,-0.450673898068,
	-0.451093826284,-0.451513606371,-0.451933238336,-0.452352722190,-0.452772057941,
	-0.453191245598,-0.453610285170,-0.454029176666,-0.454447920096,-0.454866515468,
	-0.455284962792,-0.455703262077,-0.456121413333,-0.456539416569,-0.456957271794,
	-0.457374979018,-0.457792538250,-0.458209949500,-0.458627212778,-0.459044328093,
	-0.459461295455,-0.459878114873,-0.460294786358,-0.460711309920,-0.461127685567,
	-0.461543913311,-0.461959993161,-0.462375925126,-0.462791709219,-0.463207345447,
	-0.463622833822,-0.464038174354,-0.464453367053,-0.464868411928,-0.465283308992,
	-0.465698058254,-0.466112659724,-0.466527113412,-0.466941419331,-0.467355577489,
	-0.467769587898,-0.468183450568,-0.468597165510,-0.469010732735,-0.469424152253,
	-0.469837424076,-0.470250548213,-0.470663524677,-0.471076353478,-0.471489034627,
	-0.471901568135,-0.472313954013,-0.472726192273,-0.473138282925,-0.473550225981,
	-0.473962021452,-0.474373669349,-0.474785169684,-0.475196522468,-0.475607727712,
	-0.476018785429,-0.476429695629,-0.476840458324,-0.477251073526,-0.477661541246,
	-0.478071861496,-0.478482034288,-0.478892059634,-0.479301937545,-0.479711668033,
	-0.480121251111,-0.480530686789,-0.480939975081,-0.481349115998,-0.481758109553,
	-0.482166955757,-0.482575654622,-0.482984206161,-0.483392610387,-0.483800867310,
	-0.484208976944,-0.484616939302,-0.485024754394,-0.485432422235,-0.485839942836,
	-0.486247316211,-0.486654542370,-0.487061621328,-0.487468553097,-0.487875337689,
	-0.488281975118,-0.488688465396,-0.489094808536,-0.489501004551,-0.489907053453,
	-0.490312955256,-0.490718709973,-0.491124317617,-0.491529778201,-0.491935091737,
	-0.492340258240,-0.492745277722,-0.493150150197,-0.493554875678,-0.493959454178,
	-0.494363885710,-0.494768170289,-0.495172307927,-0.495576298638,-0.495980142435,
	-0.496383839333,-0.496787389344,-0.497190792482,-0.497594048762,-0.497997158196,
	-0.498400120799,-0.498802936584,-0.499205605566,-0.499608127757,-0.500010503173,
	-0.500412731826,-0.500814813732,-0.501216748903,-0.501618537355,-0.502020179101,
	-0.502421674156,-0.502823022533,-0.503224224247,-0.503625279313,-0.504026187744,
	-0.504426949555,-0.504827564760,-0.505228033374,-0.505628355411,-0.506028530887,
	-0.506428559814,-0.506828442209,-0.507228178085,-0.507627767457,-0.508027210341,
	-0.508426506750,-0.508825656700,-0.509224660205,-0.509623517280,-0.510022227941,
	-0.510420792202,-0.510819210078,-0.511217481584,-0.511615606736,-0.512013585547,
	-0.512411418035,-0.512809104213,-0.513206644097,-0.513604037702,-0.514001285043,
	-0.514398386137,-0.514795340997,-0.515192149640,-0.515588812081,-0.515985328336,
	-0.516381698420,-0.516777922348,-0.517174000137,-0.517569931801,-0.517965717357,
	-0.518361356820,-0.518756850206,-0.519152197531,-0.519547398811,-0.519942454061,
	-0.520337363297,-0.520732126536,-0.521126743793,-0.521521215084,-0.521915540425,
	-0.522309719833,-0.522703753324,-0.523097640913,-0.523491382617,-0.523884978452,
	-0.524278428435,-0.524671732581,-0.525064890907,-0.525457903430,-0.525850770165,
	-0.526243491130,-0.526636066341,-0.527028495813,-0.527420779565,-0.527812917612,
	-0.528204909971,-0.528596756659,-0.528988457693,-0.529380013088,-0.529771422863,
	-0.530162687033,-0.530553805616,-0.530944778629,-0.531335606087,-0.531726288010,
	-0.532116824412,-0.532507215313,-0.532897460727,-0.533287560673,-0.533677515168,
	-0.534067324229,-0.534456987872,-0.534846506117,-0.535235878978,-0.535625106475,
	-0.536014188624,-0.536403125442,-0.536791916948,-0.537180563157,-0.537569064089,
	-0.537957419761,-0.538345630189,-0.538733695393,-0.539121615388,-0.539509390193,
	-0.539897019826,-0.540284504304,-0.540671843646,-0.541059037868,-0.541446086989,
	-0.541832991027,-0.542219749999,-0.542606363924,-0.542992832819,-0.543379156702,
	-0.543765335592,-0.544151369507,-0.544537258464,-0.544923002482,-0.545308601579,
	-0.545694055773,-0.546079365082,-0.546464529525,-0.546849549120,-0.547234423885,
	-0.547619153840,-0.548003739001,-0.548388179388,-0.548772475018,-0.549156625912,
	-0.549540632086,-0.549924493560,-0.550308210353,-0.550691782482,-0.551075209967,
	-0.551458492827,-0.551841631079,-0.552224624743,-0.552607473838,-0.552990178382,
	-0.553372738395,-0.553755153895,-0.554137424901,-0.554519551433,-0.554901533509,
	-0.555283371148,-0.555665064369,-0.556046613191,-0.556428017635,-0.556809277718,
	-0.557190393460,-0.557571364880,-0.557952191997,-0.558332874832,-0.558713413402,
	-0.559093807728,-0.559474057829,-0.559854163723,-0.560234125432,-0.560613942974,
	-0.560993616369,-0.561373145636,-0.561752530795,-0.562131771865,-0.562510868867,
	-0.562889821819,-0.563268630742,-0.563647295655,-0.564025816579,-0.564404193532,
	-0.564782426535,-0.565160515608,-0.565538460771,-0.565916262042,-0.566293919444,
	-0.566671432994,-0.567048802714,-0.567426028624,-0.567803110744,-0.568180049093,
	-0.568556843692,-0.568933494561,-0.569310001720,-0.569686365190,-0.570062584991,
	-0.570438661143,-0.570814593667,-0.571190382582,-0.571566027910,-0.571941529670,
	-0.572316887884,-0.572692102571,-0.573067173753,-0.573442101449,-0.573816885680,
	-0.574191526468,-0.574566023832,-0.574940377793,-0.575314588373,-0.575688655591,
	-0.576062579468,-0.576436360026,-0.576809997285,-0.577183491266,-0.577556841990,
	-0.577930049478,-0.578303113750,-0.578676034828,-0.579048812733,-0.579421447485,
	-0.579793939106,-0.580166287618,-0.580538493040,-0.580910555394,-0.581282474702,
	-0.581654250985,-0.582025884263,-0.582397374558,-0.582768721892,-0.583139926286,
	-0.583510987760,-0.583881906337,-0.584252682038,-0.584623314885,-0.584993804898,
	-0.585364152100,-0.585734356511,-0.586104418154,-0.586474337050,-0.586844113221,
	-0.587213746688,-0.587583237473,-0.587952585598,-0.588321791084,-0.588690853953,
	-0.589059774227,-0.589428551929,-0.589797187079,-0.590165679699,-0.590534029812,
	-0.590902237439,-0.591270302603,-0.591638225325,-0.592006005628,-0.592373643532,
	-0.592741139062,-0.593108492238,-0.593475703083,-0.593842771619,-0.594209697867,
	-0.594576481852,-0.594943123593,-0.595309623115,-0.595675980439,-0.596042195587,
	-0.596408268582,-0.596774199447,-0.597139988203,-0.597505634873,-0.597871139479,
	-0.598236502045,-0.598601722592,-0.598966801143,-0.599331737721,-0.599696532349,
	-0.600061185048,-0.600425695842,-0.600790064753,-0.601154291804,-0.601518377018,
	-0.601882320418,-0.602246122025,-0.602609781864,-0.602973299957,-0.603336676326,
	-0.603699910996,-0.604063003988,-0.604425955326,-0.604788765032,-0.605151433130,
	-0.605513959643,-0.605876344593,-0.606238588004,-0.606600689899,-0.606962650301,
	-0.607324469234,-0.607686146720,-0.608047682782,-0.608409077445,-0.608770330730,
	-0.609131442662,-0.609492413264,-0.609853242559,-0.610213930571,-0.610574477323,
	-0.610934882838,-0.611295147140,-0.611655270252,-0.612015252198,-0.612375093001,
	-0.612734792686,-0.613094351275,-0.613453768792,-0.613813045260,-0.614172180705,
	-0.614531175148,-0.614890028614,-0.615248741127,-0.615607312710,-0.615965743387,
	-0.616324033183,-0.616682182120,-0.617040190222,-0.617398057515,-0.617755784020,
	-0.618113369764,-0.618470814768,-0.618828119058,-0.619185282658,-0.619542305590,
	-0.619899187881,-0.620255929553,-0.620612530630,-0.620968991138,-0.621325311100,
	-0.621681490539,-0.622037529482,-0.622393427951,-0.622749185971,-0.623104803566,
	-0.623460280761,-0.623815617580,-0.624170814047,-0.624525870186,-0.624880786023,
	-0.625235561582,-0.625590196886,-0.625944691961,-0.626299046831,-0.626653261520,
	-0.627007336053,-0.627361270456,-0.627715064751,-0.628068718964,-0.628422233120,
	-0.628775607243,-0.629128841359,-0.629481935490,-0.629834889664,-0.630187703903,
	-0.630540378234,-0.630892912680,-0.631245307267,-0.631597562020,-0.631949676963,
	-0.632301652122,-0.632653487521,-0.633005183185,-0.633356739139,-0.633708155409,
	-0.634059432019,-0.634410568994,-0.634761566360,-0.635112424142,-0.635463142364,
	-0.635813721052,-0.636164160232,-0.636514459927,-0.636864620164,-0.637214640968,
	-0.637564522363,-0.637914264376,-0.638263867032,-0.638613330355,-0.638962654372,
	-0.639311839107,-0.639660884587,-0.640009790836,-0.640358557880,-0.640707185744,
	-0.641055674454,-0.641404024036,-0.641752234515,-0.642100305916,-0.642448238266,
	-0.642796031589,-0.643143685912,-0.643491201260,-0.643838577658,-0.644185815133,
	-0.644532913710,-0.644879873415,-0.645226694273,-0.645573376311,-0.645919919555,
	-0.646266324029,-0.646612589760,-0.646958716775,-0.647304705097,-0.647650554755,
	-0.647996265773,-0.648341838178,-0.648687271995,-0.649032567250,-0.649377723971,
	-0.649722742182,-0.650067621909,-0.650412363180,-0.650756966019,-0.651101430453,
	-0.651445756509,-0.651789944212,-0.652133993588,-0.652477904665,-0.652821677467,
	-0.653165312022,-0.653508808355,-0.653852166494,-0.654195386463,-0.654538468290,
	-0.654881412001,-0.655224217623,-0.655566885181,-0.655909414703,-0.656251806214,
	-0.656594059741,-0.656936175311,-0.657278152950,-0.657619992685,-0.657961694542,
	-0.658303258549,-0.658644684730,-0.658985973114,-0.659327123726,-0.659668136594,
	-0.660009011744,-0.660349749202,-0.660690348996,-0.661030811153,-0.661371135698,
	-0.661711322659,-0.662051372063,-0.662391283937,-0.662731058306,-0.663070695199,
	-0.663410194642,-0.663749556662,-0.664088781286,-0.664427868541,-0.664766818453,
	-0.665105631051,-0.665444306360,-0.665782844408,-0.666121245222,-0.666459508829,
	-0.666797635256,-0.667135624530,-0.667473476679,-0.667811191729,-0.668148769708,
	-0.668486210642,-0.668823514560,-0.669160681488,-0.669497711453,-0.669834604484,
	-0.670171360606,-0.670507979847,-0.670844462236,-0.671180807798,-0.671517016562,
	-0.671853088555,-0.672189023804,-0.672524822336,-0.672860484180,-0.673196009362,
	-0.673531397910,-0.673866649852,-0.674201765215,-0.674536744026,-0.674871586313,
	-0.675206292105,-0.675540861427,-0.675875294309,-0.676209590777,-0.676543750859,
	-0.676877774583,-0.677211661977,-0.677545413068,-0.677879027884,-0.678212506453,
	-0.678545848802,-0.678879054960,-0.679212124954,-0.679545058811,-0.679877856561,
	-0.680210518230,-0.680543043847,-0.680875433439,-0.681207687034,-0.681539804661,
	-0.681871786347,-0.682203632120,-0.682535342008,-0.682866916040,-0.683198354242,
	-0.683529656644,-0.683860823273,-0.684191854158,-0.684522749326,-0.684853508806,
	-0.685184132625,-0.685514620812,-0.685844973395,-0.686175190403,-0.686505271863,
	-0.686835217803,-0.687165028253,-0.687494703239,-0.687824242792,-0.688153646937,
	-0.688482915705,-0.688812049123,-0.689141047220,-0.689469910024,-0.689798637563,
	-0.690127229867,-0.690455686962,-0.690784008878,-0.691112195644,-0.691440247286,
	-0.691768163836,-0.692095945319,-0.692423591766,-0.692751103204,-0.693078479663,
	-0.693405721171,-0.693732827755,-0.694059799446,-0.694386636272,-0.694713338260,
	-0.695039905441,-0.695366337842,-0.695692635493,-0.696018798421,-0.696344826656,
	-0.696670720227,-0.696996479162,-0.697322103489,-0.697647593239,-0.697972948439,
	-0.698298169119,-0.698623255307,-0.698948207032,-0.699273024323,-0.699597707208,
	-0.699922255718,-0.700246669880,-0.700570949725,-0.700895095279,-0.701219106573,
	-0.701542983636,-0.701866726497,-0.702190335184,-0.702513809727,-0.702837150154,
	-0.703160356495,-0.703483428779,-0.703806367036,-0.704129171293,-0.704451841580,
	-0.704774377927,-0.705096780363,-0.705419048916,-0.705741183616,-0.706063184492,
	-0.706385051574,-0.706706784890,-0.707028384471,-0.707349850344,-0.707671182540,
	-0.707992381088,-0.708313446017,-0.708634377357,-0.708955175136,-0.709275839384,
	-0.709596370132,-0.709916767407,-0.710237031239,-0.710557161659,-0.710877158695,
	-0.711197022376,-0.711516752733,-0.711836349795,-0.712155813591,-0.712475144151,
	-0.712794341504,-0.713113405680,-0.713432336709,-0.713751134620,-0.714069799442,
	-0.714388331206,-0.714706729941,-0.715024995676,-0.715343128442,-0.715661128268,
	-0.715978995183,-0.716296729218,-0.716614330402,-0.716931798764,-0.717249134336,
	-0.717566337145,-0.717883407223,-0.718200344599,-0.718517149303,-0.718833821364,
	-0.719150360812,-0.719466767678,-0.719783041991,-0.720099183782,-0.720415193079,
	-0.720731069913,-0.721046814314,-0.721362426312,-0.721677905936,-0.721993253217,
	-0.722308468185,-0.722623550870,-0.722938501301,-0.723253319509,-0.723568005524,
	-0.723882559376,-0.724196981095,-0.724511270710,-0.724825428253,-0.725139453754,
	-0.725453347241,-0.725767108746,-0.726080738299,-0.726394235930,-0.726707601669,
	-0.727020835546,-0.727333937591,-0.727646907836,-0.727959746309,-0.728272453041,
	-0.728585028063,-0.728897471405,-0.729209783097,-0.729521963169,-0.729834011652,
	-0.730145928576,-0.730457713972,-0.730769367869,-0.731080890298,-0.731392281290,
	-0.731703540875,-0.732014669084,-0.732325665946,-0.732636531492,-0.732947265754,
	-0.733257868760,-0.733568340542,-0.733878681131,-0.734188890556,-0.734498968848,
	-0.734808916038,-0.735118732157,-0.735428417234,-0.735737971301,-0.736047394388,
	-0.736356686526,-0.736665847745,-0.736974878076,-0.737283777550,-0.737592546197,
	-0.737901184048,-0.738209691133,-0.738518067484,-0.738826313131,-0.739134428105,
	-0.739442412436,-0.739750266155,-0.740057989294,-0.740365581882,-0.740673043951,
	-0.740980375531,-0.741287576654,-0.741594647349,-0.741901587649,-0.742208397583,
	-0.742515077182,-0.742821626478,-0.743128045502,-0.743434334284,-0.743740492855,
	-0.744046521246,-0.744352419488,-0.744658187612,-0.744963825649,-0.745269333630,
	-0.745574711585,-0.745879959547,-0.746185077546,-0.746490065612,-0.746794923778,
	-0.747099652074,-0.747404250530,-0.747708719179,-0.748013058051,-0.748317267178,
	-0.748621346590,-0.748925296319,-0.749229116395,-0.749532806850,-0.749836367715,
	-0.750139799022,-0.750443100800,-0.750746273083,-0.751049315900,-0.751352229283,
	-0.751655013263,-0.751957667872,-0.752260193140,-0.752562589100,-0.752864855781,
	-0.753166993216,-0.753469001436,-0.753770880472,-0.754072630356,-0.754374251118,
	-0.754675742791,-0.754977105405,-0.755278338992,-0.755579443583,-0.755880419209,
	-0.756181265903,-0.756481983695,-0.756782572617,-0.757083032700,-0.757383363976,
	-0.757683566477,-0.757983640232,-0.758283585275,-0.758583401637,-0.758883089349,
	-0.759182648442,-0.759482078949,-0.759781380900,-0.760080554327,-0.760379599263,
	-0.760678515737,-0.760977303783,-0.761275963431,-0.761574494713,-0.761872897661,
	-0.762171172307,-0.762469318681,-0.762767336816,-0.763065226743,-0.763362988495,
	-0.763660622102,-0.763958127596,-0.764255505009,-0.764552754373,-0.764849875719,
	-0.765146869080,-0.765443734486,-0.765740471971,-0.766037081564,-0.766333563299,
	-0.766629917207,-0.766926143319,-0.767222241668,-0.767518212286,-0.767814055203,
	-0.768109770453,-0.768405358066,-0.768700818075,-0.768996150512,-0.769291355408,
	-0.769586432796,-0.769881382707,-0.770176205173,-0.770470900226,-0.770765467898,
	-0.771059908221,-0.771354221226,-0.771648406947,-0.771942465414,-0.772236396660,
	-0.772530200717,-0.772823877617,-0.773117427391,-0.773410850072,-0.773704145691,
	-0.773997314282,-0.774290355875,-0.774583270503,-0.774876058199,-0.775168718993,
	-0.775461252918,-0.775753660007,-0.776045940290,-0.776338093801,-0.776630120572,
	-0.776922020635,-0.777213794021,-0.777505440763,-0.777796960893,-0.778088354443,
	-0.778379621446,-0.778670761934,-0.778961775938,-0.779252663491,-0.779543424626,
	-0.779834059374,-0.780124567768,-0.780414949839,-0.780705205621,-0.780995335146,
	-0.781285338445,-0.781575215551,-0.781864966496,-0.782154591313,-0.782444090034,
	-0.782733462691,-0.783022709316,-0.783311829943,-0.783600824602,-0.783889693328,
	-0.784178436151,-0.784467053104,-0.784755544220,-0.785043909531,-0.785332149070,
	-0.785620262868,-0.785908250959,-0.786196113374,-0.786483850146,-0.786771461308,
	-0.787058946892,-0.787346306931,-0.787633541456,-0.787920650501,-0.788207634098,
	-0.788494492279,-0.788781225077,-0.789067832524,-0.789354314653,-0.789640671497,
	-0.789926903088,-0.790213009458,-0.790498990640,-0.790784846667,-0.791070577571,
	-0.791356183385,-0.791641664141,-0.791927019872,-0.792212250610,-0.792497356389,
	-0.792782337240,-0.793067193197,-0.793351924292,-0.793636530558,-0.793921012027,
	-0.794205368732,-0.794489600705,-0.794773707980,-0.795057690589,-0.795341548564,
	-0.795625281939,-0.795908890746,-0.796192375018,-0.796475734787,-0.796758970087,
	-0.797042080949,-0.797325067408,-0.797607929495,-0.797890667243,-0.798173280685,
	-0.798455769854,-0.798738134782,-0.799020375503,-0.799302492049,-0.799584484454,
	-0.799866352749,-0.800148096967,-0.800429717142,-0.800711213307,-0.800992585493,
	-0.801273833735,-0.801554958064,-0.801835958515,-0.802116835118,-0.802397587909,
	-0.802678216918,-0.802958722180,-0.803239103728,-0.803519361593,-0.803799495809,
	-0.804079506410,-0.804359393427,-0.804639156894,-0.804918796844,-0.805198313310,
	-0.805477706324,-0.805756975920,-0.806036122131,-0.806315144990,-0.806594044529,
	-0.806872820781,-0.807151473781,-0.807430003560,-0.807708410152,-0.807986693589,
	-0.808264853906,-0.808542891134,-0.808820805307,-0.809098596458,-0.809376264619,
	-0.809653809825,-0.809931232108,-0.810208531502,-0.810485708038,-0.810762761751,
	-0.811039692674,-0.811316500839,-0.811593186280,-0.811869749030,-0.812146189122,
	-0.812422506589,-0.812698701464,-0.812974773780,-0.813250723572,-0.813526550871,
	-0.813802255711,-0.814077838125,-0.814353298146,-0.814628635808,-0.814903851144,
	-0.815178944186,-0.815453914969,-0.815728763525,-0.816003489887,-0.816278094089,
	-0.816552576165,-0.816826936146,-0.817101174067,-0.817375289961,-0.817649283861,
	-0.817923155800,-0.818196905812,-0.818470533929,-0.818744040186,-0.819017424615,
	-0.819290687250,-0.819563828124,-0.819836847270,-0.820109744722,-0.820382520513,
	-0.820655174677,-0.820927707245,-0.821200118253,-0.821472407734,-0.821744575720,
	-0.822016622245,-0.822288547342,-0.822560351046,-0.822832033388,-0.823103594403,
	-0.823375034124,-0.823646352585,-0.823917549818,-0.824188625857,-0.824459580736,
	-0.824730414488,-0.825001127147,-0.825271718745,-0.825542189316,-0.825812538894,
	-0.826082767513,-0.826352875205,-0.826622862004,-0.826892727944,-0.827162473057,
	-0.827432097378,-0.827701600941,-0.827970983777,-0.828240245922,-0.828509387408,
	-0.828778408269,-0.829047308538,-0.829316088250,-0.829584747437,-0.829853286133,
	-0.830121704371,-0.830390002186,-0.830658179610,-0.830926236678,-0.831194173422,
	-0.831461989876,-0.831729686074,-0.831997262050,-0.832264717837,-0.832532053468,
	-0.832799268977,-0.833066364399,-0.833333339765
	}
};

double always_inline copicatreplay1clip(double x) {
    double f = fabs(x);
    f = f * copicatreplay1_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = copicatreplay1_table.data[0];
    } else if (i >= copicatreplay1_table.size-1) {
        f = copicatreplay1_table.data[copicatreplay1_table.size-1];
    } else {
    f -= i;
    f = copicatreplay1_table.data[i]*(1-f) + copicatreplay1_table.data[i+1]*f;
    }
    return copysign(f, x);
}

