//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/blueprint/armblueprint"
	"net/http"
	"net/url"
	"regexp"
)

// PublishedArtifactsServer is a fake server for instances of the armblueprint.PublishedArtifactsClient type.
type PublishedArtifactsServer struct {
	// Get is the fake for method PublishedArtifactsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceScope string, blueprintName string, versionID string, artifactName string, options *armblueprint.PublishedArtifactsClientGetOptions) (resp azfake.Responder[armblueprint.PublishedArtifactsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method PublishedArtifactsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceScope string, blueprintName string, versionID string, options *armblueprint.PublishedArtifactsClientListOptions) (resp azfake.PagerResponder[armblueprint.PublishedArtifactsClientListResponse])
}

// NewPublishedArtifactsServerTransport creates a new instance of PublishedArtifactsServerTransport with the provided implementation.
// The returned PublishedArtifactsServerTransport instance is connected to an instance of armblueprint.PublishedArtifactsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPublishedArtifactsServerTransport(srv *PublishedArtifactsServer) *PublishedArtifactsServerTransport {
	return &PublishedArtifactsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armblueprint.PublishedArtifactsClientListResponse]](),
	}
}

// PublishedArtifactsServerTransport connects instances of armblueprint.PublishedArtifactsClient to instances of PublishedArtifactsServer.
// Don't use this type directly, use NewPublishedArtifactsServerTransport instead.
type PublishedArtifactsServerTransport struct {
	srv          *PublishedArtifactsServer
	newListPager *tracker[azfake.PagerResponder[armblueprint.PublishedArtifactsClientListResponse]]
}

// Do implements the policy.Transporter interface for PublishedArtifactsServerTransport.
func (p *PublishedArtifactsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PublishedArtifactsClient.Get":
		resp, err = p.dispatchGet(req)
	case "PublishedArtifactsClient.NewListPager":
		resp, err = p.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PublishedArtifactsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprints/(?P<blueprintName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions/(?P<versionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/artifacts/(?P<artifactName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
	if err != nil {
		return nil, err
	}
	blueprintNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blueprintName")])
	if err != nil {
		return nil, err
	}
	versionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("versionId")])
	if err != nil {
		return nil, err
	}
	artifactNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("artifactName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceScopeParam, blueprintNameParam, versionIDParam, artifactNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ArtifactClassification, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PublishedArtifactsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := p.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprints/(?P<blueprintName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions/(?P<versionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/artifacts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
		if err != nil {
			return nil, err
		}
		blueprintNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blueprintName")])
		if err != nil {
			return nil, err
		}
		versionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("versionId")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListPager(resourceScopeParam, blueprintNameParam, versionIDParam, nil)
		newListPager = &resp
		p.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armblueprint.PublishedArtifactsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		p.newListPager.remove(req)
	}
	return resp, nil
}
