//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armblockchain

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// MembersClient contains the methods for the BlockchainMembers group.
// Don't use this type directly, use NewMembersClient() instead.
type MembersClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewMembersClient creates a new instance of MembersClient with the specified values.
//   - subscriptionID - Gets the subscription Id which uniquely identifies the Microsoft Azure subscription. The subscription
//     ID is part of the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewMembersClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*MembersClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &MembersClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreate - Create a blockchain member.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-06-01-preview
//   - blockchainMemberName - Blockchain member name.
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - options - MembersClientBeginCreateOptions contains the optional parameters for the MembersClient.BeginCreate method.
func (client *MembersClient) BeginCreate(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *MembersClientBeginCreateOptions) (*runtime.Poller[MembersClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, blockchainMemberName, resourceGroupName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[MembersClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[MembersClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Create - Create a blockchain member.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-06-01-preview
func (client *MembersClient) create(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *MembersClientBeginCreateOptions) (*http.Response, error) {
	var err error
	const operationName = "MembersClient.BeginCreate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, blockchainMemberName, resourceGroupName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createCreateRequest creates the Create request.
func (client *MembersClient) createCreateRequest(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *MembersClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Blockchain/blockchainMembers/{blockchainMemberName}"
	if blockchainMemberName == "" {
		return nil, errors.New("parameter blockchainMemberName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{blockchainMemberName}", url.PathEscape(blockchainMemberName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.BlockchainMember != nil {
		if err := runtime.MarshalAsJSON(req, *options.BlockchainMember); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// BeginDelete - Delete a blockchain member.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-06-01-preview
//   - blockchainMemberName - Blockchain member name
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - options - MembersClientBeginDeleteOptions contains the optional parameters for the MembersClient.BeginDelete method.
func (client *MembersClient) BeginDelete(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *MembersClientBeginDeleteOptions) (*runtime.Poller[MembersClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, blockchainMemberName, resourceGroupName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[MembersClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[MembersClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Delete a blockchain member.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-06-01-preview
func (client *MembersClient) deleteOperation(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *MembersClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "MembersClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, blockchainMemberName, resourceGroupName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *MembersClient) deleteCreateRequest(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *MembersClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Blockchain/blockchainMembers/{blockchainMemberName}"
	if blockchainMemberName == "" {
		return nil, errors.New("parameter blockchainMemberName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{blockchainMemberName}", url.PathEscape(blockchainMemberName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Get - Get details about a blockchain member.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-06-01-preview
//   - blockchainMemberName - Blockchain member name.
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - options - MembersClientGetOptions contains the optional parameters for the MembersClient.Get method.
func (client *MembersClient) Get(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *MembersClientGetOptions) (MembersClientGetResponse, error) {
	var err error
	const operationName = "MembersClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, blockchainMemberName, resourceGroupName, options)
	if err != nil {
		return MembersClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return MembersClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return MembersClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *MembersClient) getCreateRequest(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *MembersClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Blockchain/blockchainMembers/{blockchainMemberName}"
	if blockchainMemberName == "" {
		return nil, errors.New("parameter blockchainMemberName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{blockchainMemberName}", url.PathEscape(blockchainMemberName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *MembersClient) getHandleResponse(resp *http.Response) (MembersClientGetResponse, error) {
	result := MembersClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Member); err != nil {
		return MembersClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Lists the blockchain members for a resource group.
//
// Generated from API version 2018-06-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - options - MembersClientListOptions contains the optional parameters for the MembersClient.NewListPager method.
func (client *MembersClient) NewListPager(resourceGroupName string, options *MembersClientListOptions) *runtime.Pager[MembersClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[MembersClientListResponse]{
		More: func(page MembersClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *MembersClientListResponse) (MembersClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "MembersClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return MembersClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *MembersClient) listCreateRequest(ctx context.Context, resourceGroupName string, options *MembersClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Blockchain/blockchainMembers"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *MembersClient) listHandleResponse(resp *http.Response) (MembersClientListResponse, error) {
	result := MembersClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MemberCollection); err != nil {
		return MembersClientListResponse{}, err
	}
	return result, nil
}

// ListAPIKeys - Lists the API keys for a blockchain member.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-06-01-preview
//   - blockchainMemberName - Blockchain member name.
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - options - MembersClientListAPIKeysOptions contains the optional parameters for the MembersClient.ListAPIKeys method.
func (client *MembersClient) ListAPIKeys(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *MembersClientListAPIKeysOptions) (MembersClientListAPIKeysResponse, error) {
	var err error
	const operationName = "MembersClient.ListAPIKeys"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listAPIKeysCreateRequest(ctx, blockchainMemberName, resourceGroupName, options)
	if err != nil {
		return MembersClientListAPIKeysResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return MembersClientListAPIKeysResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return MembersClientListAPIKeysResponse{}, err
	}
	resp, err := client.listAPIKeysHandleResponse(httpResp)
	return resp, err
}

// listAPIKeysCreateRequest creates the ListAPIKeys request.
func (client *MembersClient) listAPIKeysCreateRequest(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *MembersClientListAPIKeysOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Blockchain/blockchainMembers/{blockchainMemberName}/listApiKeys"
	if blockchainMemberName == "" {
		return nil, errors.New("parameter blockchainMemberName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{blockchainMemberName}", url.PathEscape(blockchainMemberName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAPIKeysHandleResponse handles the ListAPIKeys response.
func (client *MembersClient) listAPIKeysHandleResponse(resp *http.Response) (MembersClientListAPIKeysResponse, error) {
	result := MembersClientListAPIKeysResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.APIKeyCollection); err != nil {
		return MembersClientListAPIKeysResponse{}, err
	}
	return result, nil
}

// NewListAllPager - Lists the blockchain members for a subscription.
//
// Generated from API version 2018-06-01-preview
//   - options - MembersClientListAllOptions contains the optional parameters for the MembersClient.NewListAllPager method.
func (client *MembersClient) NewListAllPager(options *MembersClientListAllOptions) *runtime.Pager[MembersClientListAllResponse] {
	return runtime.NewPager(runtime.PagingHandler[MembersClientListAllResponse]{
		More: func(page MembersClientListAllResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *MembersClientListAllResponse) (MembersClientListAllResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "MembersClient.NewListAllPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listAllCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return MembersClientListAllResponse{}, err
			}
			return client.listAllHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listAllCreateRequest creates the ListAll request.
func (client *MembersClient) listAllCreateRequest(ctx context.Context, options *MembersClientListAllOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Blockchain/blockchainMembers"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAllHandleResponse handles the ListAll response.
func (client *MembersClient) listAllHandleResponse(resp *http.Response) (MembersClientListAllResponse, error) {
	result := MembersClientListAllResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MemberCollection); err != nil {
		return MembersClientListAllResponse{}, err
	}
	return result, nil
}

// NewListConsortiumMembersPager - Lists the consortium members for a blockchain member.
//
// Generated from API version 2018-06-01-preview
//   - blockchainMemberName - Blockchain member name.
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - options - MembersClientListConsortiumMembersOptions contains the optional parameters for the MembersClient.NewListConsortiumMembersPager
//     method.
func (client *MembersClient) NewListConsortiumMembersPager(blockchainMemberName string, resourceGroupName string, options *MembersClientListConsortiumMembersOptions) *runtime.Pager[MembersClientListConsortiumMembersResponse] {
	return runtime.NewPager(runtime.PagingHandler[MembersClientListConsortiumMembersResponse]{
		More: func(page MembersClientListConsortiumMembersResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *MembersClientListConsortiumMembersResponse) (MembersClientListConsortiumMembersResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "MembersClient.NewListConsortiumMembersPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listConsortiumMembersCreateRequest(ctx, blockchainMemberName, resourceGroupName, options)
			}, nil)
			if err != nil {
				return MembersClientListConsortiumMembersResponse{}, err
			}
			return client.listConsortiumMembersHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listConsortiumMembersCreateRequest creates the ListConsortiumMembers request.
func (client *MembersClient) listConsortiumMembersCreateRequest(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *MembersClientListConsortiumMembersOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Blockchain/blockchainMembers/{blockchainMemberName}/consortiumMembers"
	if blockchainMemberName == "" {
		return nil, errors.New("parameter blockchainMemberName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{blockchainMemberName}", url.PathEscape(blockchainMemberName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listConsortiumMembersHandleResponse handles the ListConsortiumMembers response.
func (client *MembersClient) listConsortiumMembersHandleResponse(resp *http.Response) (MembersClientListConsortiumMembersResponse, error) {
	result := MembersClientListConsortiumMembersResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ConsortiumMemberCollection); err != nil {
		return MembersClientListConsortiumMembersResponse{}, err
	}
	return result, nil
}

// ListRegenerateAPIKeys - Regenerate the API keys for a blockchain member.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-06-01-preview
//   - blockchainMemberName - Blockchain member name.
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - options - MembersClientListRegenerateAPIKeysOptions contains the optional parameters for the MembersClient.ListRegenerateAPIKeys
//     method.
func (client *MembersClient) ListRegenerateAPIKeys(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *MembersClientListRegenerateAPIKeysOptions) (MembersClientListRegenerateAPIKeysResponse, error) {
	var err error
	const operationName = "MembersClient.ListRegenerateAPIKeys"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listRegenerateAPIKeysCreateRequest(ctx, blockchainMemberName, resourceGroupName, options)
	if err != nil {
		return MembersClientListRegenerateAPIKeysResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return MembersClientListRegenerateAPIKeysResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return MembersClientListRegenerateAPIKeysResponse{}, err
	}
	resp, err := client.listRegenerateAPIKeysHandleResponse(httpResp)
	return resp, err
}

// listRegenerateAPIKeysCreateRequest creates the ListRegenerateAPIKeys request.
func (client *MembersClient) listRegenerateAPIKeysCreateRequest(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *MembersClientListRegenerateAPIKeysOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Blockchain/blockchainMembers/{blockchainMemberName}/regenerateApiKeys"
	if blockchainMemberName == "" {
		return nil, errors.New("parameter blockchainMemberName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{blockchainMemberName}", url.PathEscape(blockchainMemberName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.APIKey != nil {
		if err := runtime.MarshalAsJSON(req, *options.APIKey); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// listRegenerateAPIKeysHandleResponse handles the ListRegenerateAPIKeys response.
func (client *MembersClient) listRegenerateAPIKeysHandleResponse(resp *http.Response) (MembersClientListRegenerateAPIKeysResponse, error) {
	result := MembersClientListRegenerateAPIKeysResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.APIKeyCollection); err != nil {
		return MembersClientListRegenerateAPIKeysResponse{}, err
	}
	return result, nil
}

// Update - Update a blockchain member.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-06-01-preview
//   - blockchainMemberName - Blockchain member name.
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - options - MembersClientUpdateOptions contains the optional parameters for the MembersClient.Update method.
func (client *MembersClient) Update(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *MembersClientUpdateOptions) (MembersClientUpdateResponse, error) {
	var err error
	const operationName = "MembersClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, blockchainMemberName, resourceGroupName, options)
	if err != nil {
		return MembersClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return MembersClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return MembersClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *MembersClient) updateCreateRequest(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *MembersClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Blockchain/blockchainMembers/{blockchainMemberName}"
	if blockchainMemberName == "" {
		return nil, errors.New("parameter blockchainMemberName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{blockchainMemberName}", url.PathEscape(blockchainMemberName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.BlockchainMember != nil {
		if err := runtime.MarshalAsJSON(req, *options.BlockchainMember); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *MembersClient) updateHandleResponse(resp *http.Response) (MembersClientUpdateResponse, error) {
	result := MembersClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Member); err != nil {
		return MembersClientUpdateResponse{}, err
	}
	return result, nil
}
