// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudformation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudformation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Validates a specified template. CloudFormation first checks if the template is
// valid JSON. If it isn't, CloudFormation checks if the template is valid YAML. If
// both these checks fail, CloudFormation returns a template validation error.
func (c *Client) ValidateTemplate(ctx context.Context, params *ValidateTemplateInput, optFns ...func(*Options)) (*ValidateTemplateOutput, error) {
	if params == nil {
		params = &ValidateTemplateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ValidateTemplate", params, optFns, c.addOperationValidateTemplateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ValidateTemplateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The input for ValidateTemplate action.
type ValidateTemplateInput struct {

	// Structure containing the template body with a minimum length of 1 byte and a
	// maximum length of 51,200 bytes. For more information, go to [Template Anatomy]in the
	// CloudFormation User Guide.
	//
	// Conditional: You must pass TemplateURL or TemplateBody . If both are passed,
	// only TemplateBody is used.
	//
	// [Template Anatomy]: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html
	TemplateBody *string

	// Location of file containing the template body. The URL must point to a template
	// (max size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems
	// Manager document. For more information, go to [Template Anatomy]in the CloudFormation User Guide.
	// The location for an Amazon S3 bucket must start with https:// .
	//
	// Conditional: You must pass TemplateURL or TemplateBody . If both are passed,
	// only TemplateBody is used.
	//
	// [Template Anatomy]: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html
	TemplateURL *string

	noSmithyDocumentSerde
}

// The output for ValidateTemplate action.
type ValidateTemplateOutput struct {

	// The capabilities found within the template. If your template contains IAM
	// resources, you must specify the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for
	// this parameter when you use the CreateStackor UpdateStack actions with your template; otherwise,
	// those actions return an InsufficientCapabilities error.
	//
	// For more information, see [Acknowledging IAM Resources in CloudFormation Templates].
	//
	// [Acknowledging IAM Resources in CloudFormation Templates]: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities
	Capabilities []types.Capability

	// The list of resources that generated the values in the Capabilities response
	// element.
	CapabilitiesReason *string

	// A list of the transforms that are declared in the template.
	DeclaredTransforms []string

	// The description found within the template.
	Description *string

	// A list of TemplateParameter structures.
	Parameters []types.TemplateParameter

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationValidateTemplateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpValidateTemplate{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpValidateTemplate{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ValidateTemplate"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opValidateTemplate(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opValidateTemplate(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ValidateTemplate",
	}
}
