#!/usr/bin/env bash
# Deal with gmtselect -Z+h option
cat << EOF > input.txt
> -Z.390000
 38.01660 38.21025  0.50000
 38.12926 38.22511  0.50000
 38.12893 38.22655  9.50000
 38.01627 38.21169  9.50000
> -Z.005270
 38.00179 38.20296  0.58000
 37.96190 38.11862  0.58000
 37.98032 38.11319  9.42000
 38.02023 38.19752  9.42000
> -Z.037600
 37.26096 38.01535  0.58000
 37.36783 37.98445  0.58000
 37.37458 37.99904  9.42000
 37.26769 38.02994  9.42000
> -Z.656000
 37.20471 38.01427  0.50000
 37.31859 38.01423  0.50000
 37.31859 38.01567  9.50000
 37.20471 38.01571  9.50000
EOF
# Only retrieve segments with 0.02 <= z <= 0.4
gmt select input.txt -Z0.02/0.4+h > result.txt
# Only skip segments with 0.02 <= z <= 0.4
gmt select input.txt -Z0.02/0.4+h -Iz >> result.txt
# Record answer
cat << EOF > answer.txt
> -Z.390000
38.0166	38.21025	0.5
38.12926	38.22511	0.5
38.12893	38.22655	9.5
38.01627	38.21169	9.5
> -Z.037600
37.26096	38.01535	0.58
37.36783	37.98445	0.58
37.37458	37.99904	9.42
37.26769	38.02994	9.42
> -Z.005270
38.00179	38.20296	0.58
37.9619	38.11862	0.58
37.98032	38.11319	9.42
38.02023	38.19752	9.42
> -Z.656000
37.20471	38.01427	0.5
37.31859	38.01423	0.5
37.31859	38.01567	9.5
37.20471	38.01571	9.5
EOF
# Compare results to answer
diff result.txt answer.txt --strip-trailing-cr  > fail
