/****************************************************************************
 *
 * $GAMGI/src/io/gamgi_io_font_hershey.c
 *
 * Copyright (C) 1967 Allen V. Hershey
 *
 * The Hershey fonts in this file were taken from the GNU package 
 * plotutils, that includes the arrays _occidental_hershey_glyphs[] and 
 * _oriental_hershey_glyphs[]. The first array includes the standard
 * (`occidental') Hershey glyphs digitized by Dr. Allen V. Hershey, some
 * glyphs due to other people, and his Japanese Hiragana and Katakana
 * glyphs. The second array includes his digitizations of Japanese
 * ideographic symbols (Kanji glyphs).  It originally included the Hiragana
 * and Katakana glyphs as well, but they were moved to the first array
 * because some people may not wish to include Kanji support.
 *
 * Dr. Hershey digitized the glyphs c. 1967, at what is now the U.S. Naval
 * Surface Weapons Center in Dahlgren, Virginia.  For many years he
 * distributed copies of the glyphs, and his typographic software, on
 * magnetic tape.  Over 120 copies of the tape were distributed.  There
 * have been many other distributions of the glyphs.  In the 1970's they
 * were incorporated, not always with attribution, in several commercial
 * plotting packages.  They were first freely distributed in 1985(?), by
 * being posted to Usenet (to vol. 4 of mod.sources) by Pete Holzmann
 * <pete@xc.org>, then at Octopus Enterprises.  In the 1980's the glyphs
 * were incorporated in at least two freeware plotting programs, Nelson
 * Beebe's PLOT79 and Tim Pearson's PGPLOT. The latter is still available
 * (see http://astro.caltech.edu/~tjp/pgplot/).
 *
 * The _occidental_hershey_glyphs[] array was constructed from
 * releases of the Hershey glyphs that are later than the one described in
 * the 1976 NBS publication above. For example, Fig. 15 of that work
 * portrays 43 additional glyphs digitized by Norman Wolcott of the NBS;
 * they are included here.  See the file ./doc/hershey-number for details
 * on how the array was assembled.  The original Hershey glyphs, including
 * the 43 Wolcott glyphs, are stored in the 0..3999 slots of the array.
 *
 * The _occidental_hershey_glyphs[] array also includes non-Hershey glyphs
 * taken from various sources.  All post-Hershey glyphs have been placed in
 * slots 4000..4194.  This includes a few glyphs taken from the UGS (the
 * Unified Graphics System, developed by Bob Beach at SLAC; see Computer
 * Graphics, Fall 1974, pp. 22-23).  As well, it includes some freeware
 * glyphs developed by Thomas Wolff <wolff@inf.fu-berlin.de> and
 * distributed as part of the Ghostscript distribution.  The Beach and
 * Wolff glyphs are used in the Hershey Symbol fonts.  Locally developed
 * glyphs (accented characters, in particular) have been added too.
 *
 * The Japanese Hiragana and Katakana glyphs digitized by Dr. Hershey,
 * formerly located among the `oriental' glyphs, are now located in slots
 * 4195..4399 of the _occidental_hershey_glyphs[] array.
 *
 * The format of the glyphs in the _occidental_hershey_glyphs[] and
 * _oriental_hershey_glyphs[] arrays is the format in which the Hershey
 * glyphs were distributed to mod.sources in 1985(?) by Pete Holzmann, and
 * is due to Jim Hurt, then at Cognition Inc.
 *
 * The standard hardcopy reference for the occidental Hershey glyphs, which
 * tabulates and displays them, is:
 *
 * @TechReport{Wolcott76,
 *   author =       {Norman M. Wolcott and Joseph Hilsenrath},
 *   title =        {A Contribution to Computer Typesetting Techniques:
 *                   Tables of Coordinates for {Hershey's} Repertory of
 *                   Occidental Type Fonts and Graphic Symbols},
 *   institution =  {U.S. National Bureau of Standards},
 *   year =         {1976},
 *   month =        {April},
 *   type =         {Special Publication},
 *   number =       {424},
 *   OPTnote =      {US NTIS stock number PB251845}}
 *
 * This publication is available from the NTIS (US National Technical
 * Information Service, +1 703 487 4650).  The NTIS stock number is given
 * above.  See also Dr. Hershey's original TR, which describes the
 * alphabets from which the glyphs were taken and gives information on the
 * oriental glyphs:
 *
 * @TechReport{Hershey67,
 *   author =    {Allen V. Hershey},
 *   title =     {Calligraphy for Computers},
 *   institution =  {U.S. Naval Weapons Laboratory},
 *   address =   {Dahlgren, VA},
 *   year =      {1967},
 *   type =      {Report},
 *   number =    {TR--2101},
 *   month =     {Aug},
 *   OPTnote =   {US NTIS stock number AD662398}}
 *
 */

/***********************************************
 * Data taken from the package PLOTUTILS-2.4.1 *
 *                              Carlos Pereira *
 ***********************************************/
 
/********************************************************************
 * changed char 96 in sans_symbol, serif_symbol, serif_symbol_bold: *
 * the upperscore now appears immediately above the next character  *
 *                                                                  *
 * changed char 86 in gothic_italian: improved one of the strokes   *
 ********************************************************************/

#include "gamgi_engine.h"
#include "gamgi_io.h"

/*********
 * fonts *
 *********/

const float gamgi_io_font_hershey_sans_points[GAMGI_IO_POINTS_SANS] = {

/***************
 * bottom, top *
 ***************/

-32.3232, 120.0576,

/**************
 * char 32-40 *
 **************/

73.8816, 46.1760, 73.8816, 101.5872, 92.3520, 110.8224, 120.0576, 46.1760, 64.6464, 

/**************
 * char 41-50 *
 **************/

64.6464, 73.8816, 120.0576, 46.1760, 120.0576, 46.1760, 101.5872, 92.3520, 92.3520, 92.3520, 

/**************
 * char 51-60 *
 **************/

92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 46.1760, 46.1760, 110.8224, 

/**************
 * char 61-70 *
 **************/

120.0576, 110.8224, 83.1168, 133.9104, 83.1168, 96.9696, 96.9696, 96.9696, 87.7344, 83.1168, 

/**************
 * char 71-80 *
 **************/

96.9696, 101.5872, 36.9408, 73.8816, 96.9696, 78.4992, 110.8224, 101.5872, 101.5872, 96.9696, 

/**************
 * char 81-90 *
 **************/

101.5872, 96.9696, 92.3520, 73.8816, 101.5872, 83.1168, 110.8224, 92.3520, 83.1168, 92.3520, 

/***************
 * char 91-100 *
 ***************/

64.6464, 101.5872, 64.6464, 73.8816, 101.5872, 46.1760, 87.7344, 87.7344, 83.1168, 87.7344, 

/****************
 * char 101-110 *
 ****************/

83.1168, 55.4112, 87.7344, 87.7344, 36.9408, 46.1760, 78.4992, 36.9408, 138.5280, 87.7344, 

/****************
 * char 111-120 *
 ****************/

87.7344, 87.7344, 87.7344, 60.0288, 78.4992, 55.4112, 87.7344, 73.8816, 101.5872, 78.4992, 

/****************
 * char 121-126 *
 ****************/

73.8816, 78.4992, 64.6464, 36.9408, 64.6464, 110.8224, 

/*************************
 * char: 32   strokes: 0 *
 *************************/

GAMGI_IO_CHAR,

/*************************
 * char: 33 ! strokes: 2 *
 *************************/

23.0880, 99.2784, 23.0880, 34.6320, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 6.9264, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 34 " strokes: 2 *
 *************************/

18.4704, 99.2784, 18.4704, 66.9552, GAMGI_IO_STROKE,

55.4112, 99.2784, 55.4112, 66.9552, GAMGI_IO_CHAR,

/*************************
 * char: 35 # strokes: 4 *
 *************************/

36.9408, 99.2784, 36.9408, -30.0144, GAMGI_IO_STROKE,

64.6464, 99.2784, 64.6464, -30.0144, GAMGI_IO_STROKE,

13.8528, 48.4848, 87.7344, 48.4848, GAMGI_IO_STROKE,

13.8528, 20.7792, 87.7344, 20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 36 $ strokes: 3 *
 *************************/

36.9408, 117.7488, 36.9408, -16.1616, GAMGI_IO_STROKE,

55.4112, 117.7488, 55.4112, -16.1616, GAMGI_IO_STROKE,

78.4992, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, 23.0880, 94.6608, 13.8528, 85.4256, 13.8528, 76.1904, 18.4704, 66.9552, 23.0880, 62.3376, 32.3232, 57.7200, 60.0288, 48.4848, 69.2640, 43.8672, 73.8816, 39.2496, 78.4992, 30.0144, 78.4992, 16.1616, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 13.8528, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 37 % strokes: 3 *
 *************************/

96.9696, 99.2784, 87.7344, 94.6608, 73.8816, 90.0432, 60.0288, 90.0432, 46.1760, 94.6608, 36.9408, 99.2784, 27.7056, 99.2784, 18.4704, 94.6608, 13.8528, 85.4256, 13.8528, 76.1904, 23.0880, 66.9552, 32.3232, 66.9552, 41.5584, 71.5728, 46.1760, 80.8080, 46.1760, 90.0432, 36.9408, 99.2784, GAMGI_IO_STROKE,

96.9696, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

87.7344, 34.6320, 78.4992, 34.6320, 69.2640, 30.0144, 64.6464, 20.7792, 64.6464, 11.5440, 73.8816, 2.3088, 83.1168, 2.3088, 92.3520, 6.9264, 96.9696, 16.1616, 96.9696, 25.3968, 87.7344, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 38 & strokes: 1 *
 *************************/

106.2048, 57.7200, 106.2048, 62.3376, 101.5872, 66.9552, 96.9696, 66.9552, 92.3520, 62.3376, 87.7344, 53.1024, 78.4992, 30.0144, 69.2640, 16.1616, 60.0288, 6.9264, 50.7936, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 30.0144, 18.4704, 39.2496, 23.0880, 43.8672, 55.4112, 62.3376, 60.0288, 66.9552, 64.6464, 76.1904, 64.6464, 85.4256, 60.0288, 94.6608, 50.7936, 99.2784, 41.5584, 94.6608, 36.9408, 85.4256, 36.9408, 76.1904, 41.5584, 62.3376, 50.7936, 48.4848, 73.8816, 16.1616, 83.1168, 6.9264, 92.3520, 2.3088, 101.5872, 2.3088, 106.2048, 6.9264, 106.2048, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 39 ' strokes: 1 *
 *************************/

23.0880, 90.0432, 18.4704, 94.6608, 23.0880, 99.2784, 27.7056, 94.6608, 27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 71.5728, GAMGI_IO_CHAR,

/*************************
 * char: 40 ( strokes: 1 *
 *************************/

50.7936, 117.7488, 41.5584, 108.5136, 32.3232, 94.6608, 23.0880, 76.1904, 18.4704, 53.1024, 18.4704, 34.6320, 23.0880, 11.5440, 32.3232, -6.9264, 41.5584, -20.7792, 50.7936, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 41 ) strokes: 1 *
 *************************/

13.8528, 117.7488, 23.0880, 108.5136, 32.3232, 94.6608, 41.5584, 76.1904, 46.1760, 53.1024, 46.1760, 34.6320, 41.5584, 11.5440, 32.3232, -6.9264, 23.0880, -20.7792, 13.8528, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 42 * strokes: 3 *
 *************************/

36.9408, 71.5728, 36.9408, 16.1616, GAMGI_IO_STROKE,

13.8528, 57.7200, 60.0288, 30.0144, GAMGI_IO_STROKE,

60.0288, 57.7200, 13.8528, 30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 43 + strokes: 2 *
 *************************/

60.0288, 85.4256, 60.0288, 2.3088, GAMGI_IO_STROKE,

18.4704, 43.8672, 101.5872, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 44 , strokes: 1 *
 *************************/

27.7056, 6.9264, 23.0880, 2.3088, 18.4704, 6.9264, 23.0880, 11.5440, 27.7056, 6.9264, 27.7056, -2.3088, 23.0880, -11.5440, 18.4704, -16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 45 - strokes: 1 *
 *************************/

18.4704, 43.8672, 101.5872, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 46 . strokes: 1 *
 *************************/

23.0880, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 6.9264, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 47 / strokes: 1 *
 *************************/

92.3520, 117.7488, 9.2352, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 48 0 strokes: 1 *
 *************************/

41.5584, 99.2784, 27.7056, 94.6608, 18.4704, 80.8080, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 20.7792, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 20.7792, 78.4992, 43.8672, 78.4992, 57.7200, 73.8816, 80.8080, 64.6464, 94.6608, 50.7936, 99.2784, 41.5584, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 49 1 strokes: 1 *
 *************************/

27.7056, 80.8080, 36.9408, 85.4256, 50.7936, 99.2784, 50.7936, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 50 2 strokes: 1 *
 *************************/

18.4704, 76.1904, 18.4704, 80.8080, 23.0880, 90.0432, 27.7056, 94.6608, 36.9408, 99.2784, 55.4112, 99.2784, 64.6464, 94.6608, 69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 71.5728, 69.2640, 62.3376, 60.0288, 48.4848, 13.8528, 2.3088, 78.4992, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 51 3 strokes: 1 *
 *************************/

23.0880, 99.2784, 73.8816, 99.2784, 46.1760, 62.3376, 60.0288, 62.3376, 69.2640, 57.7200, 73.8816, 53.1024, 78.4992, 39.2496, 78.4992, 30.0144, 73.8816, 16.1616, 64.6464, 6.9264, 50.7936, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 52 4 strokes: 2 *
 *************************/

60.0288, 99.2784, 13.8528, 34.6320, 83.1168, 34.6320, GAMGI_IO_STROKE,

60.0288, 99.2784, 60.0288, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 53 5 strokes: 1 *
 *************************/

69.2640, 99.2784, 23.0880, 99.2784, 18.4704, 57.7200, 23.0880, 62.3376, 36.9408, 66.9552, 50.7936, 66.9552, 64.6464, 62.3376, 73.8816, 53.1024, 78.4992, 39.2496, 78.4992, 30.0144, 73.8816, 16.1616, 64.6464, 6.9264, 50.7936, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 54 6 strokes: 1 *
 *************************/

73.8816, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 80.8080, 18.4704, 57.7200, 18.4704, 34.6320, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 30.0144, 78.4992, 34.6320, 73.8816, 48.4848, 64.6464, 57.7200, 50.7936, 62.3376, 46.1760, 62.3376, 32.3232, 57.7200, 23.0880, 48.4848, 18.4704, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 55 7 strokes: 2 *
 *************************/

78.4992, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 78.4992, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 56 8 strokes: 1 *
 *************************/

36.9408, 99.2784, 23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 76.1904, 23.0880, 66.9552, 32.3232, 62.3376, 50.7936, 57.7200, 64.6464, 53.1024, 73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 20.7792, 73.8816, 11.5440, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 34.6320, 18.4704, 43.8672, 27.7056, 53.1024, 41.5584, 57.7200, 60.0288, 62.3376, 69.2640, 66.9552, 73.8816, 76.1904, 73.8816, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 57 9 strokes: 1 *
 *************************/

73.8816, 66.9552, 69.2640, 53.1024, 60.0288, 43.8672, 46.1760, 39.2496, 41.5584, 39.2496, 27.7056, 43.8672, 18.4704, 53.1024, 13.8528, 66.9552, 13.8528, 71.5728, 18.4704, 85.4256, 27.7056, 94.6608, 41.5584, 99.2784, 46.1760, 99.2784, 60.0288, 94.6608, 69.2640, 85.4256, 73.8816, 66.9552, 73.8816, 43.8672, 69.2640, 20.7792, 60.0288, 6.9264, 46.1760, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 58 : strokes: 2 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 23.0880, 57.7200, 27.7056, 62.3376, 23.0880, 66.9552, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 6.9264, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 59 ; strokes: 2 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 23.0880, 57.7200, 27.7056, 62.3376, 23.0880, 66.9552, GAMGI_IO_STROKE,

27.7056, 6.9264, 23.0880, 2.3088, 18.4704, 6.9264, 23.0880, 11.5440, 27.7056, 6.9264, 27.7056, -2.3088, 23.0880, -11.5440, 18.4704, -16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 60 < strokes: 1 *
 *************************/

92.3520, 85.4256, 18.4704, 43.8672, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 61 = strokes: 2 *
 *************************/

18.4704, 57.7200, 101.5872, 57.7200, GAMGI_IO_STROKE,

18.4704, 30.0144, 101.5872, 30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 62 > strokes: 1 *
 *************************/

18.4704, 85.4256, 92.3520, 43.8672, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 63 ? strokes: 2 *
 *************************/

13.8528, 76.1904, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 32.3232, 99.2784, 50.7936, 99.2784, 60.0288, 94.6608, 64.6464, 90.0432, 69.2640, 80.8080, 69.2640, 71.5728, 64.6464, 62.3376, 60.0288, 57.7200, 41.5584, 48.4848, 41.5584, 34.6320, GAMGI_IO_STROKE,

41.5584, 11.5440, 36.9408, 6.9264, 41.5584, 2.3088, 46.1760, 6.9264, 41.5584, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 64 @ strokes: 2 *
 *************************/

87.7344, 62.3376, 83.1168, 71.5728, 73.8816, 76.1904, 60.0288, 76.1904, 50.7936, 71.5728, 46.1760, 66.9552, 41.5584, 57.7200, 41.5584, 43.8672, 46.1760, 34.6320, 50.7936, 30.0144, 60.0288, 25.3968, 73.8816, 25.3968, 83.1168, 30.0144, 87.7344, 39.2496, GAMGI_IO_STROKE,

87.7344, 76.1904, 87.7344, 39.2496, 92.3520, 30.0144, 96.9696, 25.3968, 106.2048, 25.3968, 110.8224, 30.0144, 115.4400, 39.2496, 115.4400, 57.7200, 110.8224, 71.5728, 106.2048, 80.8080, 96.9696, 90.0432, 87.7344, 94.6608, 73.8816, 99.2784, 60.0288, 99.2784, 46.1760, 94.6608, 36.9408, 90.0432, 27.7056, 80.8080, 23.0880, 71.5728, 18.4704, 57.7200, 18.4704, 43.8672, 23.0880, 30.0144, 27.7056, 20.7792, 36.9408, 11.5440, 46.1760, 6.9264, 60.0288, 2.3088, 73.8816, 2.3088, 87.7344, 6.9264, 96.9696, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 65 A strokes: 3 *
 *************************/

41.5584, 99.2784, 4.6176, 2.3088, GAMGI_IO_STROKE,

41.5584, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

18.4704, 34.6320, 64.6464, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 66 B strokes: 3 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 60.0288, 99.2784, 73.8816, 94.6608, 78.4992, 90.0432, 83.1168, 80.8080, 83.1168, 71.5728, 78.4992, 62.3376, 73.8816, 57.7200, 60.0288, 53.1024, GAMGI_IO_STROKE,

18.4704, 53.1024, 60.0288, 53.1024, 73.8816, 48.4848, 78.4992, 43.8672, 83.1168, 34.6320, 83.1168, 20.7792, 78.4992, 11.5440, 73.8816, 6.9264, 60.0288, 2.3088, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 67 C strokes: 1 *
 *************************/

83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 41.5584, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 62.3376, 13.8528, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 68 D strokes: 2 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 50.7936, 99.2784, 64.6464, 94.6608, 73.8816, 85.4256, 78.4992, 76.1904, 83.1168, 62.3376, 83.1168, 39.2496, 78.4992, 25.3968, 73.8816, 16.1616, 64.6464, 6.9264, 50.7936, 2.3088, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 69 E strokes: 4 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 78.4992, 99.2784, GAMGI_IO_STROKE,

18.4704, 53.1024, 55.4112, 53.1024, GAMGI_IO_STROKE,

18.4704, 2.3088, 78.4992, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 70 F strokes: 3 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 78.4992, 99.2784, GAMGI_IO_STROKE,

18.4704, 53.1024, 55.4112, 53.1024, GAMGI_IO_CHAR,

/*************************
 * char: 71 G strokes: 2 *
 *************************/

83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 41.5584, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 62.3376, 13.8528, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, 83.1168, 39.2496, GAMGI_IO_STROKE,

60.0288, 39.2496, 83.1168, 39.2496, GAMGI_IO_CHAR,

/*************************
 * char: 72 H strokes: 3 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 83.1168, 2.3088, GAMGI_IO_STROKE,

18.4704, 53.1024, 83.1168, 53.1024, GAMGI_IO_CHAR,

/*************************
 * char: 73 I strokes: 1 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 74 J strokes: 1 *
 *************************/

55.4112, 99.2784, 55.4112, 25.3968, 50.7936, 11.5440, 46.1760, 6.9264, 36.9408, 2.3088, 27.7056, 2.3088, 18.4704, 6.9264, 13.8528, 11.5440, 9.2352, 25.3968, 9.2352, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 75 K strokes: 3 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 18.4704, 34.6320, GAMGI_IO_STROKE,

41.5584, 57.7200, 83.1168, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 76 L strokes: 2 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 2.3088, 73.8816, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 77 M strokes: 4 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 55.4112, 2.3088, GAMGI_IO_STROKE,

92.3520, 99.2784, 55.4112, 2.3088, GAMGI_IO_STROKE,

92.3520, 99.2784, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 78 N strokes: 3 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 83.1168, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 83.1168, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 79 O strokes: 1 *
 *************************/

41.5584, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 62.3376, 13.8528, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, 87.7344, 39.2496, 87.7344, 62.3376, 83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 41.5584, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 80 P strokes: 2 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 60.0288, 99.2784, 73.8816, 94.6608, 78.4992, 90.0432, 83.1168, 80.8080, 83.1168, 66.9552, 78.4992, 57.7200, 73.8816, 53.1024, 60.0288, 48.4848, 18.4704, 48.4848, GAMGI_IO_CHAR,

/*************************
 * char: 81 Q strokes: 2 *
 *************************/

41.5584, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 62.3376, 13.8528, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, 87.7344, 39.2496, 87.7344, 62.3376, 83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

55.4112, 20.7792, 83.1168, -6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 82 R strokes: 3 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 60.0288, 99.2784, 73.8816, 94.6608, 78.4992, 90.0432, 83.1168, 80.8080, 83.1168, 71.5728, 78.4992, 62.3376, 73.8816, 57.7200, 60.0288, 53.1024, 18.4704, 53.1024, GAMGI_IO_STROKE,

50.7936, 53.1024, 83.1168, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 83 S strokes: 1 *
 *************************/

78.4992, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, 23.0880, 94.6608, 13.8528, 85.4256, 13.8528, 76.1904, 18.4704, 66.9552, 23.0880, 62.3376, 32.3232, 57.7200, 60.0288, 48.4848, 69.2640, 43.8672, 73.8816, 39.2496, 78.4992, 30.0144, 78.4992, 16.1616, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 13.8528, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 84 T strokes: 2 *
 *************************/

36.9408, 99.2784, 36.9408, 2.3088, GAMGI_IO_STROKE,

4.6176, 99.2784, 69.2640, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 85 U strokes: 1 *
 *************************/

18.4704, 99.2784, 18.4704, 30.0144, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 30.0144, 83.1168, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 86 V strokes: 2 *
 *************************/

4.6176, 99.2784, 41.5584, 2.3088, GAMGI_IO_STROKE,

78.4992, 99.2784, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 87 W strokes: 4 *
 *************************/

9.2352, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

55.4112, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

55.4112, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

101.5872, 99.2784, 78.4992, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 88 X strokes: 2 *
 *************************/

13.8528, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

78.4992, 99.2784, 13.8528, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 89 Y strokes: 2 *
 *************************/

4.6176, 99.2784, 41.5584, 53.1024, 41.5584, 2.3088, GAMGI_IO_STROKE,

78.4992, 99.2784, 41.5584, 53.1024, GAMGI_IO_CHAR,

/*************************
 * char: 90 Z strokes: 3 *
 *************************/

78.4992, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 78.4992, 99.2784, GAMGI_IO_STROKE,

13.8528, 2.3088, 78.4992, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 91 [ strokes: 3 *
 *************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_STROKE,

18.4704, 117.7488, 50.7936, 117.7488, GAMGI_IO_STROKE,

18.4704, -30.0144, 50.7936, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 92 \ strokes: 1 *
 *************************/

9.2352, 117.7488, 92.3520, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 93 ] strokes: 3 *
 *************************/

46.1760, 117.7488, 46.1760, -30.0144, GAMGI_IO_STROKE,

13.8528, 117.7488, 46.1760, 117.7488, GAMGI_IO_STROKE,

13.8528, -30.0144, 46.1760, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 94 ^ strokes: 2 *
 *************************/

27.7056, 71.5728, 36.9408, 85.4256, 46.1760, 71.5728, GAMGI_IO_STROKE,

13.8528, 57.7200, 36.9408, 80.8080, 60.0288, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 95 _ strokes: 1 *
 *************************/

9.2352, -6.9264, 92.3520, -6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 96 ` strokes: 1 *
 *************************/

27.7056, 99.2784, 23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 76.1904, 23.0880, 71.5728, 27.7056, 76.1904, 23.0880, 80.8080, GAMGI_IO_CHAR,

/*************************
 * char: 97 a strokes: 2 *
 *************************/

69.2640, 66.9552, 69.2640, 2.3088, GAMGI_IO_STROKE,

69.2640, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, 36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 36.9408, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 98 b strokes: 2 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 53.1024, 27.7056, 62.3376, 36.9408, 66.9552, 50.7936, 66.9552, 60.0288, 62.3376, 69.2640, 53.1024, 73.8816, 39.2496, 73.8816, 30.0144, 69.2640, 16.1616, 60.0288, 6.9264, 50.7936, 2.3088, 36.9408, 2.3088, 27.7056, 6.9264, 18.4704, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 99 c strokes: 1 *
 *************************/

69.2640, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, 36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 36.9408, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 100 d strokes: 2 *
 **************************/

69.2640, 99.2784, 69.2640, 2.3088, GAMGI_IO_STROKE,

69.2640, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, 36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 36.9408, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 101 e strokes: 1 *
 **************************/

13.8528, 39.2496, 69.2640, 39.2496, 69.2640, 48.4848, 64.6464, 57.7200, 60.0288, 62.3376, 50.7936, 66.9552, 36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 36.9408, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 102 f strokes: 2 *
 **************************/

46.1760, 99.2784, 36.9408, 99.2784, 27.7056, 94.6608, 23.0880, 80.8080, 23.0880, 2.3088, GAMGI_IO_STROKE,

9.2352, 66.9552, 41.5584, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 103 g strokes: 2 *
 **************************/

69.2640, 66.9552, 69.2640, -6.9264, 64.6464, -20.7792, 60.0288, -25.3968, 50.7936, -30.0144, 36.9408, -30.0144, 27.7056, -25.3968, GAMGI_IO_STROKE,

69.2640, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, 36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 36.9408, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 104 h strokes: 2 *
 **************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 48.4848, 32.3232, 62.3376, 41.5584, 66.9552, 55.4112, 66.9552, 64.6464, 62.3376, 69.2640, 48.4848, 69.2640, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 105 i strokes: 2 *
 **************************/

13.8528, 99.2784, 18.4704, 94.6608, 23.0880, 99.2784, 18.4704, 103.8960, 13.8528, 99.2784, GAMGI_IO_STROKE,

18.4704, 66.9552, 18.4704, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 106 j strokes: 2 *
 **************************/

23.0880, 99.2784, 27.7056, 94.6608, 32.3232, 99.2784, 27.7056, 103.8960, 23.0880, 99.2784, GAMGI_IO_STROKE,

27.7056, 66.9552, 27.7056, -11.5440, 23.0880, -25.3968, 13.8528, -30.0144, 4.6176, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 107 k strokes: 3 *
 **************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

64.6464, 66.9552, 18.4704, 20.7792, GAMGI_IO_STROKE,

36.9408, 39.2496, 69.2640, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 108 l strokes: 1 *
 **************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 109 m strokes: 3 *
 **************************/

18.4704, 66.9552, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 48.4848, 32.3232, 62.3376, 41.5584, 66.9552, 55.4112, 66.9552, 64.6464, 62.3376, 69.2640, 48.4848, 69.2640, 2.3088, GAMGI_IO_STROKE,

69.2640, 48.4848, 83.1168, 62.3376, 92.3520, 66.9552, 106.2048, 66.9552, 115.4400, 62.3376, 120.0576, 48.4848, 120.0576, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 110 n strokes: 2 *
 **************************/

18.4704, 66.9552, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 48.4848, 32.3232, 62.3376, 41.5584, 66.9552, 55.4112, 66.9552, 64.6464, 62.3376, 69.2640, 48.4848, 69.2640, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 111 o strokes: 1 *
 **************************/

36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 36.9408, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, 73.8816, 30.0144, 73.8816, 39.2496, 69.2640, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, 36.9408, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 112 p strokes: 2 *
 **************************/

18.4704, 66.9552, 18.4704, -30.0144, GAMGI_IO_STROKE,

18.4704, 53.1024, 27.7056, 62.3376, 36.9408, 66.9552, 50.7936, 66.9552, 60.0288, 62.3376, 69.2640, 53.1024, 73.8816, 39.2496, 73.8816, 30.0144, 69.2640, 16.1616, 60.0288, 6.9264, 50.7936, 2.3088, 36.9408, 2.3088, 27.7056, 6.9264, 18.4704, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 113 q strokes: 2 *
 **************************/

69.2640, 66.9552, 69.2640, -30.0144, GAMGI_IO_STROKE,

69.2640, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, 36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 36.9408, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 114 r strokes: 2 *
 **************************/

18.4704, 66.9552, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 39.2496, 23.0880, 53.1024, 32.3232, 62.3376, 41.5584, 66.9552, 55.4112, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 115 s strokes: 1 *
 **************************/

64.6464, 53.1024, 60.0288, 62.3376, 46.1760, 66.9552, 32.3232, 66.9552, 18.4704, 62.3376, 13.8528, 53.1024, 18.4704, 43.8672, 27.7056, 39.2496, 50.7936, 34.6320, 60.0288, 30.0144, 64.6464, 20.7792, 64.6464, 16.1616, 60.0288, 6.9264, 46.1760, 2.3088, 32.3232, 2.3088, 18.4704, 6.9264, 13.8528, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 116 t strokes: 2 *
 **************************/

23.0880, 99.2784, 23.0880, 20.7792, 27.7056, 6.9264, 36.9408, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

9.2352, 66.9552, 41.5584, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 117 u strokes: 2 *
 **************************/

18.4704, 66.9552, 18.4704, 20.7792, 23.0880, 6.9264, 32.3232, 2.3088, 46.1760, 2.3088, 55.4112, 6.9264, 69.2640, 20.7792, GAMGI_IO_STROKE,

69.2640, 66.9552, 69.2640, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 118 v strokes: 2 *
 **************************/

9.2352, 66.9552, 36.9408, 2.3088, GAMGI_IO_STROKE,

64.6464, 66.9552, 36.9408, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 119 w strokes: 4 *
 **************************/

13.8528, 66.9552, 32.3232, 2.3088, GAMGI_IO_STROKE,

50.7936, 66.9552, 32.3232, 2.3088, GAMGI_IO_STROKE,

50.7936, 66.9552, 69.2640, 2.3088, GAMGI_IO_STROKE,

87.7344, 66.9552, 69.2640, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 120 x strokes: 2 *
 **************************/

13.8528, 66.9552, 64.6464, 2.3088, GAMGI_IO_STROKE,

64.6464, 66.9552, 13.8528, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 121 y strokes: 2 *
 **************************/

9.2352, 66.9552, 36.9408, 2.3088, GAMGI_IO_STROKE,

64.6464, 66.9552, 36.9408, 2.3088, 27.7056, -16.1616, 18.4704, -25.3968, 9.2352, -30.0144, 4.6176, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 122 z strokes: 3 *
 **************************/

64.6464, 66.9552, 13.8528, 2.3088, GAMGI_IO_STROKE,

13.8528, 66.9552, 64.6464, 66.9552, GAMGI_IO_STROKE,

13.8528, 2.3088, 64.6464, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 123 { strokes: 1 *
 **************************/

41.5584, 117.7488, 27.7056, 103.8960, 23.0880, 90.0432, 23.0880, 80.8080, 27.7056, 66.9552, 36.9408, 57.7200, 36.9408, 53.1024, 18.4704, 43.8672, 36.9408, 34.6320, 36.9408, 30.0144, 27.7056, 20.7792, 23.0880, 6.9264, 23.0880, -2.3088, 27.7056, -16.1616, 41.5584, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 124 | strokes: 1 *
 **************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 125 } strokes: 1 *
 **************************/

23.0880, 117.7488, 36.9408, 103.8960, 41.5584, 90.0432, 41.5584, 80.8080, 36.9408, 66.9552, 27.7056, 57.7200, 27.7056, 53.1024, 46.1760, 43.8672, 27.7056, 34.6320, 27.7056, 30.0144, 36.9408, 20.7792, 41.5584, 6.9264, 41.5584, -2.3088, 36.9408, -16.1616, 23.0880, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 126 ~ strokes: 2 *
 **************************/

13.8528, 30.0144, 13.8528, 39.2496, 18.4704, 53.1024, 27.7056, 57.7200, 36.9408, 57.7200, 46.1760, 53.1024, 64.6464, 39.2496, 73.8816, 34.6320, 83.1168, 34.6320, 92.3520, 39.2496, 96.9696, 48.4848, GAMGI_IO_STROKE,

13.8528, 39.2496, 18.4704, 48.4848, 27.7056, 53.1024, 36.9408, 53.1024, 46.1760, 48.4848, 64.6464, 34.6320, 73.8816, 30.0144, 83.1168, 30.0144, 92.3520, 34.6320, 96.9696, 48.4848, 96.9696, 57.7200, GAMGI_IO_CHAR,

};

const float gamgi_io_font_hershey_sans_bold_points[GAMGI_IO_POINTS_SANS_BOLD] = {

/***************
 * bottom, top *
 ***************/

-32.3232, 120.0576,

/**************
 * char 32-40 *
 **************/

73.8816, 50.7936, 83.1168, 106.2048, 87.7344, 110.8224, 115.4400, 50.7936, 64.6464, 

/**************
 * char 41-50 *
 **************/

64.6464, 73.8816, 115.4400, 50.7936, 115.4400, 50.7936, 106.2048, 92.3520, 92.3520, 92.3520, 

/**************
 * char 51-60 *
 **************/

92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 50.7936, 50.7936, 110.8224, 

/**************
 * char 61-70 *
 **************/

115.4400, 110.8224, 87.7344, 124.6752, 92.3520, 92.3520, 96.9696, 96.9696, 87.7344, 83.1168, 

/**************
 * char 71-80 *
 **************/

96.9696, 101.5872, 41.5584, 78.4992, 96.9696, 78.4992, 110.8224, 101.5872, 101.5872, 92.3520, 

/**************
 * char 81-90 *
 **************/

101.5872, 92.3520, 92.3520, 78.4992, 101.5872, 92.3520, 120.0576, 92.3520, 87.7344, 92.3520, 

/***************
 * char 91-100 *
 ***************/

64.6464, 106.2048, 64.6464, 73.8816, 101.5872, 50.7936, 92.3520, 92.3520, 83.1168, 92.3520, 

/****************
 * char 101-110 *
 ****************/

83.1168, 64.6464, 92.3520, 92.3520, 41.5584, 41.5584, 87.7344, 41.5584, 143.1456, 92.3520, 

/****************
 * char 111-120 *
 ****************/

87.7344, 92.3520, 92.3520, 64.6464, 78.4992, 50.7936, 92.3520, 73.8816, 110.8224, 83.1168, 

/****************
 * char 121-126 *
 ****************/

73.8816, 83.1168, 69.2640, 41.5584, 69.2640, 110.8224, 

/*************************
 * char: 32   strokes: 0 *
 *************************/

GAMGI_IO_CHAR,

/*************************
 * char: 33 ! strokes: 4 *
 *************************/

23.0880, 99.2784, 23.0880, 34.6320, 27.7056, 34.6320, GAMGI_IO_STROKE,

23.0880, 99.2784, 27.7056, 99.2784, 27.7056, 34.6320, GAMGI_IO_STROKE,

23.0880, 16.1616, 18.4704, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 2.3088, 32.3232, 6.9264, 32.3232, 11.5440, 27.7056, 16.1616, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 34 " strokes: 6 *
 *************************/

23.0880, 99.2784, 18.4704, 94.6608, 18.4704, 66.9552, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 66.9552, GAMGI_IO_STROKE,

23.0880, 99.2784, 27.7056, 94.6608, 18.4704, 66.9552, GAMGI_IO_STROKE,

64.6464, 99.2784, 60.0288, 94.6608, 60.0288, 66.9552, GAMGI_IO_STROKE,

64.6464, 94.6608, 60.0288, 66.9552, GAMGI_IO_STROKE,

64.6464, 99.2784, 69.2640, 94.6608, 60.0288, 66.9552, GAMGI_IO_CHAR,

/*************************
 * char: 35 # strokes: 8 *
 *************************/

36.9408, 99.2784, 36.9408, -30.0144, 41.5584, -30.0144, GAMGI_IO_STROKE,

36.9408, 99.2784, 41.5584, 99.2784, 41.5584, -30.0144, GAMGI_IO_STROKE,

64.6464, 99.2784, 64.6464, -30.0144, 69.2640, -30.0144, GAMGI_IO_STROKE,

64.6464, 99.2784, 69.2640, 99.2784, 69.2640, -30.0144, GAMGI_IO_STROKE,

13.8528, 53.1024, 92.3520, 53.1024, 92.3520, 48.4848, GAMGI_IO_STROKE,

13.8528, 53.1024, 13.8528, 48.4848, 92.3520, 48.4848, GAMGI_IO_STROKE,

13.8528, 20.7792, 92.3520, 20.7792, 92.3520, 16.1616, GAMGI_IO_STROKE,

13.8528, 20.7792, 13.8528, 16.1616, 92.3520, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 36 $ strokes: 5 *
 *************************/

41.5584, 117.7488, 41.5584, -16.1616, 46.1760, -16.1616, GAMGI_IO_STROKE,

41.5584, 117.7488, 46.1760, 117.7488, 46.1760, -16.1616, GAMGI_IO_STROKE,

64.6464, 85.4256, 73.8816, 85.4256, 64.6464, 94.6608, 50.7936, 99.2784, 36.9408, 99.2784, 23.0880, 94.6608, 13.8528, 85.4256, 13.8528, 76.1904, 18.4704, 66.9552, 23.0880, 62.3376, 60.0288, 43.8672, 64.6464, 39.2496, 69.2640, 30.0144, 69.2640, 20.7792, 64.6464, 11.5440, 50.7936, 6.9264, 36.9408, 6.9264, 27.7056, 11.5440, 23.0880, 16.1616, GAMGI_IO_STROKE,

64.6464, 85.4256, 60.0288, 90.0432, 50.7936, 94.6608, 36.9408, 94.6608, 23.0880, 90.0432, 18.4704, 85.4256, 18.4704, 76.1904, 23.0880, 66.9552, 60.0288, 48.4848, 69.2640, 39.2496, 73.8816, 30.0144, 73.8816, 20.7792, 69.2640, 11.5440, 64.6464, 6.9264, 50.7936, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 13.8528, 16.1616, 23.0880, 16.1616, GAMGI_IO_STROKE,

69.2640, 16.1616, 55.4112, 6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 37 % strokes: 8 *
 *************************/

96.9696, 99.2784, 87.7344, 94.6608, 73.8816, 90.0432, 60.0288, 90.0432, 46.1760, 94.6608, 36.9408, 99.2784, 27.7056, 99.2784, 18.4704, 94.6608, 13.8528, 85.4256, 13.8528, 76.1904, 23.0880, 66.9552, 32.3232, 66.9552, 41.5584, 71.5728, 46.1760, 80.8080, 46.1760, 90.0432, 36.9408, 99.2784, GAMGI_IO_STROKE,

96.9696, 99.2784, 9.2352, 2.3088, 13.8528, 2.3088, GAMGI_IO_STROKE,

96.9696, 99.2784, 101.5872, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

87.7344, 34.6320, 78.4992, 34.6320, 69.2640, 30.0144, 64.6464, 20.7792, 64.6464, 11.5440, 73.8816, 2.3088, 83.1168, 2.3088, 92.3520, 6.9264, 96.9696, 16.1616, 96.9696, 25.3968, 87.7344, 34.6320, GAMGI_IO_STROKE,

36.9408, 99.2784, 18.4704, 94.6608, 13.8528, 76.1904, 32.3232, 66.9552, 46.1760, 80.8080, 36.9408, 99.2784, GAMGI_IO_STROKE,

27.7056, 99.2784, 13.8528, 85.4256, 23.0880, 66.9552, 41.5584, 71.5728, 46.1760, 90.0432, 27.7056, 99.2784, GAMGI_IO_STROKE,

87.7344, 34.6320, 69.2640, 30.0144, 64.6464, 11.5440, 83.1168, 2.3088, 96.9696, 16.1616, 87.7344, 34.6320, GAMGI_IO_STROKE,

78.4992, 34.6320, 64.6464, 20.7792, 73.8816, 2.3088, 92.3520, 6.9264, 96.9696, 25.3968, 78.4992, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 38 & strokes: 5 *
 *************************/

101.5872, 66.9552, 92.3520, 66.9552, 83.1168, 62.3376, 78.4992, 53.1024, 69.2640, 25.3968, 64.6464, 16.1616, 60.0288, 11.5440, 50.7936, 6.9264, 32.3232, 6.9264, 23.0880, 11.5440, 18.4704, 20.7792, 18.4704, 30.0144, 23.0880, 39.2496, 27.7056, 43.8672, 50.7936, 57.7200, 60.0288, 66.9552, 64.6464, 76.1904, 64.6464, 85.4256, 60.0288, 94.6608, 50.7936, 99.2784, 46.1760, 99.2784, 36.9408, 94.6608, 32.3232, 85.4256, 32.3232, 76.1904, 36.9408, 62.3376, 46.1760, 48.4848, 69.2640, 20.7792, 83.1168, 6.9264, 92.3520, 2.3088, 101.5872, 2.3088, GAMGI_IO_STROKE,

101.5872, 66.9552, 101.5872, 62.3376, 92.3520, 62.3376, 78.4992, 53.1024, GAMGI_IO_STROKE,

92.3520, 66.9552, 83.1168, 53.1024, 73.8816, 25.3968, 69.2640, 16.1616, 60.0288, 6.9264, 50.7936, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 30.0144, 18.4704, 39.2496, 27.7056, 48.4848, 50.7936, 62.3376, 55.4112, 66.9552, 60.0288, 76.1904, 60.0288, 85.4256, 55.4112, 94.6608, GAMGI_IO_STROKE,

60.0288, 90.0432, 50.7936, 94.6608, 46.1760, 94.6608, 36.9408, 90.0432, GAMGI_IO_STROKE,

41.5584, 94.6608, 36.9408, 85.4256, 36.9408, 76.1904, 41.5584, 62.3376, 50.7936, 48.4848, 73.8816, 20.7792, 83.1168, 11.5440, 92.3520, 6.9264, 101.5872, 6.9264, 101.5872, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 39 ' strokes: 4 *
 *************************/

32.3232, 90.0432, 27.7056, 85.4256, 23.0880, 85.4256, 18.4704, 90.0432, 18.4704, 94.6608, 23.0880, 99.2784, 27.7056, 99.2784, 32.3232, 94.6608, 32.3232, 80.8080, 27.7056, 71.5728, 18.4704, 66.9552, GAMGI_IO_STROKE,

23.0880, 94.6608, 23.0880, 90.0432, 27.7056, 90.0432, 27.7056, 94.6608, 23.0880, 94.6608, GAMGI_IO_STROKE,

27.7056, 85.4256, 32.3232, 80.8080, GAMGI_IO_STROKE,

32.3232, 90.0432, 27.7056, 71.5728, GAMGI_IO_CHAR,

/*************************
 * char: 40 ( strokes: 2 *
 *************************/

46.1760, 117.7488, 36.9408, 108.5136, 27.7056, 94.6608, 18.4704, 76.1904, 13.8528, 53.1024, 13.8528, 34.6320, 18.4704, 11.5440, 27.7056, -6.9264, 36.9408, -20.7792, 46.1760, -30.0144, 50.7936, -30.0144, GAMGI_IO_STROKE,

46.1760, 117.7488, 50.7936, 117.7488, 41.5584, 108.5136, 32.3232, 94.6608, 23.0880, 76.1904, 18.4704, 53.1024, 18.4704, 34.6320, 23.0880, 11.5440, 32.3232, -6.9264, 41.5584, -20.7792, 50.7936, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 41 ) strokes: 2 *
 *************************/

13.8528, 117.7488, 23.0880, 108.5136, 32.3232, 94.6608, 41.5584, 76.1904, 46.1760, 53.1024, 46.1760, 34.6320, 41.5584, 11.5440, 32.3232, -6.9264, 23.0880, -20.7792, 13.8528, -30.0144, 18.4704, -30.0144, GAMGI_IO_STROKE,

13.8528, 117.7488, 18.4704, 117.7488, 27.7056, 108.5136, 36.9408, 94.6608, 46.1760, 76.1904, 50.7936, 53.1024, 50.7936, 34.6320, 46.1760, 11.5440, 36.9408, -6.9264, 27.7056, -20.7792, 18.4704, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 42 * strokes: 9 *
 *************************/

36.9408, 99.2784, 32.3232, 94.6608, 41.5584, 48.4848, 36.9408, 43.8672, GAMGI_IO_STROKE,

36.9408, 99.2784, 36.9408, 43.8672, GAMGI_IO_STROKE,

36.9408, 99.2784, 41.5584, 94.6608, 32.3232, 48.4848, 36.9408, 43.8672, GAMGI_IO_STROKE,

13.8528, 85.4256, 18.4704, 85.4256, 55.4112, 57.7200, 60.0288, 57.7200, GAMGI_IO_STROKE,

13.8528, 85.4256, 60.0288, 57.7200, GAMGI_IO_STROKE,

13.8528, 85.4256, 13.8528, 80.8080, 60.0288, 62.3376, 60.0288, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 55.4112, 85.4256, 18.4704, 57.7200, 13.8528, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 13.8528, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 60.0288, 80.8080, 13.8528, 62.3376, 13.8528, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 43 + strokes: 4 *
 *************************/

55.4112, 85.4256, 55.4112, 6.9264, 60.0288, 6.9264, GAMGI_IO_STROKE,

55.4112, 85.4256, 60.0288, 85.4256, 60.0288, 6.9264, GAMGI_IO_STROKE,

18.4704, 48.4848, 96.9696, 48.4848, 96.9696, 43.8672, GAMGI_IO_STROKE,

18.4704, 48.4848, 18.4704, 43.8672, 96.9696, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 44 , strokes: 4 *
 *************************/

32.3232, 6.9264, 27.7056, 2.3088, 23.0880, 2.3088, 18.4704, 6.9264, 18.4704, 11.5440, 23.0880, 16.1616, 27.7056, 16.1616, 32.3232, 11.5440, 32.3232, -2.3088, 27.7056, -11.5440, 18.4704, -16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_STROKE,

27.7056, 2.3088, 32.3232, -2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 27.7056, -11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 45 - strokes: 2 *
 *************************/

18.4704, 48.4848, 96.9696, 48.4848, 96.9696, 43.8672, GAMGI_IO_STROKE,

18.4704, 48.4848, 18.4704, 43.8672, 96.9696, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 46 . strokes: 2 *
 *************************/

23.0880, 16.1616, 18.4704, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 2.3088, 32.3232, 6.9264, 32.3232, 11.5440, 27.7056, 16.1616, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 47 / strokes: 2 *
 *************************/

92.3520, 117.7488, 9.2352, -30.0144, 13.8528, -30.0144, GAMGI_IO_STROKE,

92.3520, 117.7488, 96.9696, 117.7488, 13.8528, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 48 0 strokes: 5 *
 *************************/

41.5584, 99.2784, 27.7056, 94.6608, 18.4704, 80.8080, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 20.7792, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 20.7792, 78.4992, 43.8672, 78.4992, 57.7200, 73.8816, 80.8080, 64.6464, 94.6608, 50.7936, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

32.3232, 94.6608, 23.0880, 80.8080, 18.4704, 57.7200, 18.4704, 43.8672, 23.0880, 20.7792, 32.3232, 6.9264, GAMGI_IO_STROKE,

27.7056, 11.5440, 41.5584, 6.9264, 50.7936, 6.9264, 64.6464, 11.5440, GAMGI_IO_STROKE,

60.0288, 6.9264, 69.2640, 20.7792, 73.8816, 43.8672, 73.8816, 57.7200, 69.2640, 80.8080, 60.0288, 94.6608, GAMGI_IO_STROKE,

64.6464, 90.0432, 50.7936, 94.6608, 41.5584, 94.6608, 27.7056, 90.0432, GAMGI_IO_CHAR,

/*************************
 * char: 49 1 strokes: 2 *
 *************************/

27.7056, 80.8080, 36.9408, 85.4256, 50.7936, 99.2784, 50.7936, 2.3088, GAMGI_IO_STROKE,

27.7056, 80.8080, 27.7056, 76.1904, 36.9408, 80.8080, 46.1760, 90.0432, 46.1760, 2.3088, 50.7936, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 50 2 strokes: 4 *
 *************************/

18.4704, 76.1904, 18.4704, 80.8080, 23.0880, 90.0432, 27.7056, 94.6608, 36.9408, 99.2784, 55.4112, 99.2784, 64.6464, 94.6608, 69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 71.5728, 69.2640, 62.3376, 60.0288, 48.4848, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 76.1904, 23.0880, 76.1904, 23.0880, 80.8080, 27.7056, 90.0432, 36.9408, 94.6608, 55.4112, 94.6608, 64.6464, 90.0432, 69.2640, 80.8080, 69.2640, 71.5728, 64.6464, 62.3376, 55.4112, 48.4848, 13.8528, 2.3088, GAMGI_IO_STROKE,

18.4704, 6.9264, 78.4992, 6.9264, 78.4992, 2.3088, GAMGI_IO_STROKE,

13.8528, 2.3088, 78.4992, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 51 3 strokes: 8 *
 *************************/

23.0880, 99.2784, 73.8816, 99.2784, 41.5584, 57.7200, GAMGI_IO_STROKE,

23.0880, 99.2784, 23.0880, 94.6608, 69.2640, 94.6608, GAMGI_IO_STROKE,

69.2640, 99.2784, 36.9408, 57.7200, GAMGI_IO_STROKE,

41.5584, 62.3376, 50.7936, 62.3376, 64.6464, 57.7200, 73.8816, 48.4848, 78.4992, 34.6320, 78.4992, 30.0144, 73.8816, 16.1616, 64.6464, 6.9264, 50.7936, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 18.4704, 20.7792, GAMGI_IO_STROKE,

36.9408, 57.7200, 50.7936, 57.7200, 64.6464, 53.1024, 73.8816, 39.2496, GAMGI_IO_STROKE,

55.4112, 57.7200, 69.2640, 48.4848, 73.8816, 34.6320, 73.8816, 30.0144, 69.2640, 16.1616, 55.4112, 6.9264, GAMGI_IO_STROKE,

73.8816, 25.3968, 64.6464, 11.5440, 50.7936, 6.9264, 36.9408, 6.9264, 23.0880, 11.5440, 18.4704, 20.7792, GAMGI_IO_STROKE,

32.3232, 6.9264, 18.4704, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 52 4 strokes: 5 *
 *************************/

60.0288, 85.4256, 60.0288, 2.3088, 64.6464, 2.3088, GAMGI_IO_STROKE,

64.6464, 99.2784, 64.6464, 2.3088, GAMGI_IO_STROKE,

64.6464, 99.2784, 13.8528, 25.3968, 83.1168, 25.3968, GAMGI_IO_STROKE,

60.0288, 85.4256, 18.4704, 25.3968, GAMGI_IO_STROKE,

18.4704, 30.0144, 83.1168, 30.0144, 83.1168, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 53 5 strokes: 9 *
 *************************/

23.0880, 99.2784, 18.4704, 57.7200, GAMGI_IO_STROKE,

27.7056, 94.6608, 23.0880, 62.3376, GAMGI_IO_STROKE,

23.0880, 99.2784, 69.2640, 99.2784, 69.2640, 94.6608, GAMGI_IO_STROKE,

27.7056, 94.6608, 69.2640, 94.6608, GAMGI_IO_STROKE,

23.0880, 62.3376, 36.9408, 66.9552, 50.7936, 66.9552, 64.6464, 62.3376, 73.8816, 53.1024, 78.4992, 39.2496, 78.4992, 30.0144, 73.8816, 16.1616, 64.6464, 6.9264, 50.7936, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 18.4704, 20.7792, GAMGI_IO_STROKE,

18.4704, 57.7200, 23.0880, 57.7200, 32.3232, 62.3376, 50.7936, 62.3376, 64.6464, 57.7200, 73.8816, 43.8672, GAMGI_IO_STROKE,

55.4112, 62.3376, 69.2640, 53.1024, 73.8816, 39.2496, 73.8816, 30.0144, 69.2640, 16.1616, 55.4112, 6.9264, GAMGI_IO_STROKE,

73.8816, 25.3968, 64.6464, 11.5440, 50.7936, 6.9264, 36.9408, 6.9264, 23.0880, 11.5440, 18.4704, 20.7792, GAMGI_IO_STROKE,

32.3232, 6.9264, 18.4704, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 54 6 strokes: 7 *
 *************************/

64.6464, 94.6608, 69.2640, 85.4256, 73.8816, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 80.8080, 18.4704, 57.7200, 18.4704, 34.6320, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 30.0144, 78.4992, 34.6320, 73.8816, 48.4848, 64.6464, 57.7200, 50.7936, 62.3376, 46.1760, 62.3376, 32.3232, 57.7200, 23.0880, 48.4848, GAMGI_IO_STROKE,

69.2640, 90.0432, 55.4112, 94.6608, 46.1760, 94.6608, 32.3232, 90.0432, GAMGI_IO_STROKE,

36.9408, 94.6608, 27.7056, 80.8080, 23.0880, 57.7200, 23.0880, 34.6320, 27.7056, 16.1616, 41.5584, 6.9264, GAMGI_IO_STROKE,

23.0880, 25.3968, 32.3232, 11.5440, 46.1760, 6.9264, 50.7936, 6.9264, 64.6464, 11.5440, 73.8816, 25.3968, GAMGI_IO_STROKE,

55.4112, 6.9264, 69.2640, 16.1616, 73.8816, 30.0144, 73.8816, 34.6320, 69.2640, 48.4848, 55.4112, 57.7200, GAMGI_IO_STROKE,

73.8816, 39.2496, 64.6464, 53.1024, 50.7936, 57.7200, 46.1760, 57.7200, 32.3232, 53.1024, 23.0880, 39.2496, GAMGI_IO_STROKE,

41.5584, 57.7200, 27.7056, 48.4848, 23.0880, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 55 7 strokes: 3 *
 *************************/

13.8528, 99.2784, 78.4992, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 13.8528, 94.6608, 73.8816, 94.6608, GAMGI_IO_STROKE,

73.8816, 99.2784, 27.7056, 2.3088, 32.3232, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 56 8 strokes: 5 *
 *************************/

36.9408, 99.2784, 23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 76.1904, 23.0880, 66.9552, 27.7056, 62.3376, 36.9408, 57.7200, 55.4112, 53.1024, 64.6464, 48.4848, 69.2640, 43.8672, 73.8816, 34.6320, 73.8816, 20.7792, 69.2640, 11.5440, 55.4112, 6.9264, 36.9408, 6.9264, 23.0880, 11.5440, 18.4704, 20.7792, 18.4704, 34.6320, 23.0880, 43.8672, 27.7056, 48.4848, 36.9408, 53.1024, 55.4112, 57.7200, 64.6464, 62.3376, 69.2640, 66.9552, 73.8816, 76.1904, 73.8816, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, GAMGI_IO_STROKE,

27.7056, 94.6608, 23.0880, 85.4256, 23.0880, 76.1904, 27.7056, 66.9552, 36.9408, 62.3376, 55.4112, 57.7200, 64.6464, 53.1024, 73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 20.7792, 73.8816, 11.5440, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 34.6320, 18.4704, 43.8672, 27.7056, 53.1024, 36.9408, 57.7200, 55.4112, 62.3376, 64.6464, 66.9552, 69.2640, 76.1904, 69.2640, 85.4256, 64.6464, 94.6608, GAMGI_IO_STROKE,

69.2640, 90.0432, 55.4112, 94.6608, 36.9408, 94.6608, 23.0880, 90.0432, GAMGI_IO_STROKE,

18.4704, 16.1616, 32.3232, 6.9264, GAMGI_IO_STROKE,

60.0288, 6.9264, 73.8816, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 57 9 strokes: 7 *
 *************************/

69.2640, 53.1024, 60.0288, 43.8672, 46.1760, 39.2496, 41.5584, 39.2496, 27.7056, 43.8672, 18.4704, 53.1024, 13.8528, 66.9552, 13.8528, 71.5728, 18.4704, 85.4256, 27.7056, 94.6608, 41.5584, 99.2784, 46.1760, 99.2784, 60.0288, 94.6608, 69.2640, 85.4256, 73.8816, 66.9552, 73.8816, 43.8672, 69.2640, 20.7792, 60.0288, 6.9264, 46.1760, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 16.1616, 23.0880, 16.1616, 27.7056, 6.9264, GAMGI_IO_STROKE,

69.2640, 66.9552, 64.6464, 53.1024, 50.7936, 43.8672, GAMGI_IO_STROKE,

69.2640, 62.3376, 60.0288, 48.4848, 46.1760, 43.8672, 41.5584, 43.8672, 27.7056, 48.4848, 18.4704, 62.3376, GAMGI_IO_STROKE,

36.9408, 43.8672, 23.0880, 53.1024, 18.4704, 66.9552, 18.4704, 71.5728, 23.0880, 85.4256, 36.9408, 94.6608, GAMGI_IO_STROKE,

18.4704, 76.1904, 27.7056, 90.0432, 41.5584, 94.6608, 46.1760, 94.6608, 60.0288, 90.0432, 69.2640, 76.1904, GAMGI_IO_STROKE,

50.7936, 94.6608, 64.6464, 85.4256, 69.2640, 66.9552, 69.2640, 43.8672, 64.6464, 20.7792, 55.4112, 6.9264, GAMGI_IO_STROKE,

60.0288, 11.5440, 46.1760, 6.9264, 36.9408, 6.9264, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 58 : strokes: 4 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 18.4704, 57.7200, 23.0880, 53.1024, 27.7056, 53.1024, 32.3232, 57.7200, 32.3232, 62.3376, 27.7056, 66.9552, 23.0880, 66.9552, GAMGI_IO_STROKE,

23.0880, 62.3376, 23.0880, 57.7200, 27.7056, 57.7200, 27.7056, 62.3376, 23.0880, 62.3376, GAMGI_IO_STROKE,

23.0880, 16.1616, 18.4704, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 2.3088, 32.3232, 6.9264, 32.3232, 11.5440, 27.7056, 16.1616, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 59 ; strokes: 6 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 18.4704, 57.7200, 23.0880, 53.1024, 27.7056, 53.1024, 32.3232, 57.7200, 32.3232, 62.3376, 27.7056, 66.9552, 23.0880, 66.9552, GAMGI_IO_STROKE,

23.0880, 62.3376, 23.0880, 57.7200, 27.7056, 57.7200, 27.7056, 62.3376, 23.0880, 62.3376, GAMGI_IO_STROKE,

32.3232, 6.9264, 27.7056, 2.3088, 23.0880, 2.3088, 18.4704, 6.9264, 18.4704, 11.5440, 23.0880, 16.1616, 27.7056, 16.1616, 32.3232, 11.5440, 32.3232, -2.3088, 27.7056, -11.5440, 18.4704, -16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_STROKE,

27.7056, 2.3088, 32.3232, -2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 27.7056, -11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 60 < strokes: 2 *
 *************************/

92.3520, 85.4256, 18.4704, 43.8672, 92.3520, 2.3088, GAMGI_IO_STROKE,

92.3520, 85.4256, 92.3520, 80.8080, 27.7056, 43.8672, 92.3520, 6.9264, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 61 = strokes: 4 *
 *************************/

18.4704, 66.9552, 96.9696, 66.9552, 96.9696, 62.3376, GAMGI_IO_STROKE,

18.4704, 66.9552, 18.4704, 62.3376, 96.9696, 62.3376, GAMGI_IO_STROKE,

18.4704, 30.0144, 96.9696, 30.0144, 96.9696, 25.3968, GAMGI_IO_STROKE,

18.4704, 30.0144, 18.4704, 25.3968, 96.9696, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 62 > strokes: 2 *
 *************************/

18.4704, 85.4256, 92.3520, 43.8672, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 85.4256, 18.4704, 80.8080, 83.1168, 43.8672, 18.4704, 6.9264, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 63 ? strokes: 8 *
 *************************/

13.8528, 76.1904, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 36.9408, 99.2784, 50.7936, 99.2784, 64.6464, 94.6608, 69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 71.5728, 69.2640, 62.3376, 64.6464, 57.7200, 55.4112, 53.1024, 41.5584, 48.4848, GAMGI_IO_STROKE,

13.8528, 76.1904, 18.4704, 76.1904, 18.4704, 80.8080, 23.0880, 90.0432, 36.9408, 94.6608, 50.7936, 94.6608, 64.6464, 90.0432, 69.2640, 80.8080, 69.2640, 71.5728, 64.6464, 62.3376, 55.4112, 57.7200, 41.5584, 53.1024, GAMGI_IO_STROKE,

18.4704, 85.4256, 32.3232, 94.6608, GAMGI_IO_STROKE,

55.4112, 94.6608, 69.2640, 85.4256, GAMGI_IO_STROKE,

69.2640, 66.9552, 50.7936, 53.1024, GAMGI_IO_STROKE,

41.5584, 53.1024, 41.5584, 34.6320, 46.1760, 34.6320, 46.1760, 53.1024, GAMGI_IO_STROKE,

41.5584, 16.1616, 36.9408, 11.5440, 36.9408, 6.9264, 41.5584, 2.3088, 46.1760, 2.3088, 50.7936, 6.9264, 50.7936, 11.5440, 46.1760, 16.1616, 41.5584, 16.1616, GAMGI_IO_STROKE,

41.5584, 11.5440, 41.5584, 6.9264, 46.1760, 6.9264, 46.1760, 11.5440, 41.5584, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 64 @ strokes: 5 *
 *************************/

83.1168, 66.9552, 69.2640, 76.1904, 55.4112, 76.1904, 46.1760, 71.5728, 41.5584, 66.9552, 36.9408, 57.7200, 36.9408, 43.8672, 41.5584, 34.6320, 46.1760, 30.0144, 55.4112, 25.3968, 69.2640, 25.3968, 83.1168, 34.6320, GAMGI_IO_STROKE,

83.1168, 66.9552, 69.2640, 71.5728, 55.4112, 71.5728, 46.1760, 66.9552, 41.5584, 57.7200, 41.5584, 43.8672, 46.1760, 34.6320, 55.4112, 30.0144, 69.2640, 30.0144, 83.1168, 34.6320, GAMGI_IO_STROKE,

78.4992, 76.1904, 78.4992, 39.2496, 83.1168, 30.0144, 92.3520, 25.3968, 96.9696, 25.3968, 106.2048, 30.0144, 110.8224, 39.2496, 110.8224, 57.7200, 106.2048, 71.5728, 101.5872, 80.8080, 92.3520, 90.0432, 83.1168, 94.6608, 69.2640, 99.2784, 55.4112, 99.2784, 41.5584, 94.6608, 32.3232, 90.0432, 23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 55.4112, 2.3088, 73.8816, 2.3088, 92.3520, 6.9264, GAMGI_IO_STROKE,

78.4992, 76.1904, 83.1168, 76.1904, 83.1168, 39.2496, 87.7344, 30.0144, 96.9696, 25.3968, GAMGI_IO_STROKE,

92.3520, 25.3968, 101.5872, 30.0144, 106.2048, 39.2496, 106.2048, 57.7200, 101.5872, 71.5728, 96.9696, 80.8080, 92.3520, 85.4256, 83.1168, 90.0432, 69.2640, 94.6608, 55.4112, 94.6608, 41.5584, 90.0432, 32.3232, 85.4256, 27.7056, 80.8080, 23.0880, 71.5728, 18.4704, 57.7200, 18.4704, 43.8672, 23.0880, 30.0144, 27.7056, 20.7792, 32.3232, 16.1616, 41.5584, 11.5440, 55.4112, 6.9264, 73.8816, 6.9264, 92.3520, 11.5440, 92.3520, 6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 65 A strokes: 6 *
 *************************/

46.1760, 99.2784, 9.2352, 2.3088, GAMGI_IO_STROKE,

46.1760, 85.4256, 13.8528, 2.3088, 9.2352, 2.3088, GAMGI_IO_STROKE,

46.1760, 85.4256, 78.4992, 2.3088, 83.1168, 2.3088, GAMGI_IO_STROKE,

46.1760, 99.2784, 83.1168, 2.3088, GAMGI_IO_STROKE,

23.0880, 30.0144, 69.2640, 30.0144, GAMGI_IO_STROKE,

18.4704, 25.3968, 73.8816, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 66 B strokes: 6 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

23.0880, 94.6608, 23.0880, 6.9264, GAMGI_IO_STROKE,

18.4704, 99.2784, 55.4112, 99.2784, 69.2640, 94.6608, 73.8816, 90.0432, 78.4992, 80.8080, 78.4992, 66.9552, 73.8816, 57.7200, 69.2640, 53.1024, 55.4112, 48.4848, GAMGI_IO_STROKE,

23.0880, 94.6608, 55.4112, 94.6608, 69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 66.9552, 69.2640, 57.7200, 55.4112, 53.1024, GAMGI_IO_STROKE,

23.0880, 53.1024, 55.4112, 53.1024, 69.2640, 48.4848, 73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 20.7792, 73.8816, 11.5440, 69.2640, 6.9264, 55.4112, 2.3088, 18.4704, 2.3088, GAMGI_IO_STROKE,

23.0880, 48.4848, 55.4112, 48.4848, 69.2640, 43.8672, 73.8816, 34.6320, 73.8816, 20.7792, 69.2640, 11.5440, 55.4112, 6.9264, 23.0880, 6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 67 C strokes: 2 *
 *************************/

83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 41.5584, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 62.3376, 13.8528, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, GAMGI_IO_STROKE,

83.1168, 76.1904, 78.4992, 76.1904, 73.8816, 85.4256, 69.2640, 90.0432, 60.0288, 94.6608, 41.5584, 94.6608, 32.3232, 90.0432, 23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 25.3968, 32.3232, 11.5440, 41.5584, 6.9264, 60.0288, 6.9264, 69.2640, 11.5440, 73.8816, 16.1616, 78.4992, 25.3968, 83.1168, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 68 D strokes: 4 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

23.0880, 94.6608, 23.0880, 6.9264, GAMGI_IO_STROKE,

18.4704, 99.2784, 50.7936, 99.2784, 64.6464, 94.6608, 73.8816, 85.4256, 78.4992, 76.1904, 83.1168, 62.3376, 83.1168, 39.2496, 78.4992, 25.3968, 73.8816, 16.1616, 64.6464, 6.9264, 50.7936, 2.3088, 18.4704, 2.3088, GAMGI_IO_STROKE,

23.0880, 94.6608, 50.7936, 94.6608, 64.6464, 90.0432, 69.2640, 85.4256, 73.8816, 76.1904, 78.4992, 62.3376, 78.4992, 39.2496, 73.8816, 25.3968, 69.2640, 16.1616, 64.6464, 11.5440, 50.7936, 6.9264, 23.0880, 6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 69 E strokes: 8 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

23.0880, 94.6608, 23.0880, 6.9264, GAMGI_IO_STROKE,

18.4704, 99.2784, 73.8816, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 73.8816, 94.6608, 73.8816, 99.2784, GAMGI_IO_STROKE,

23.0880, 53.1024, 50.7936, 53.1024, 50.7936, 48.4848, GAMGI_IO_STROKE,

23.0880, 48.4848, 50.7936, 48.4848, GAMGI_IO_STROKE,

23.0880, 6.9264, 73.8816, 6.9264, 73.8816, 2.3088, GAMGI_IO_STROKE,

18.4704, 2.3088, 73.8816, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 70 F strokes: 6 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

23.0880, 94.6608, 23.0880, 2.3088, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 73.8816, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 73.8816, 94.6608, 73.8816, 99.2784, GAMGI_IO_STROKE,

23.0880, 53.1024, 50.7936, 53.1024, 50.7936, 48.4848, GAMGI_IO_STROKE,

23.0880, 48.4848, 50.7936, 48.4848, GAMGI_IO_CHAR,

/*************************
 * char: 71 G strokes: 2 *
 *************************/

83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 41.5584, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 62.3376, 13.8528, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, 83.1168, 43.8672, 60.0288, 43.8672, GAMGI_IO_STROKE,

83.1168, 76.1904, 78.4992, 76.1904, 73.8816, 85.4256, 69.2640, 90.0432, 60.0288, 94.6608, 41.5584, 94.6608, 32.3232, 90.0432, 27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 25.3968, 27.7056, 16.1616, 32.3232, 11.5440, 41.5584, 6.9264, 60.0288, 6.9264, 69.2640, 11.5440, 73.8816, 16.1616, 78.4992, 25.3968, 78.4992, 39.2496, 60.0288, 39.2496, 60.0288, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 72 H strokes: 6 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 99.2784, 23.0880, 2.3088, 18.4704, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 78.4992, 99.2784, 78.4992, 2.3088, 83.1168, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 83.1168, 2.3088, GAMGI_IO_STROKE,

23.0880, 53.1024, 78.4992, 53.1024, GAMGI_IO_STROKE,

23.0880, 48.4848, 78.4992, 48.4848, GAMGI_IO_CHAR,

/*************************
 * char: 73 I strokes: 2 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, 23.0880, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 74 J strokes: 2 *
 *************************/

55.4112, 99.2784, 55.4112, 25.3968, 50.7936, 11.5440, 41.5584, 6.9264, 32.3232, 6.9264, 23.0880, 11.5440, 18.4704, 25.3968, 13.8528, 25.3968, GAMGI_IO_STROKE,

55.4112, 99.2784, 60.0288, 99.2784, 60.0288, 25.3968, 55.4112, 11.5440, 50.7936, 6.9264, 41.5584, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 75 K strokes: 6 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, 23.0880, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 78.4992, 99.2784, 23.0880, 43.8672, GAMGI_IO_STROKE,

83.1168, 99.2784, 23.0880, 39.2496, GAMGI_IO_STROKE,

36.9408, 57.7200, 78.4992, 2.3088, 83.1168, 2.3088, GAMGI_IO_STROKE,

41.5584, 57.7200, 83.1168, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 76 L strokes: 4 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 99.2784, 23.0880, 6.9264, GAMGI_IO_STROKE,

23.0880, 6.9264, 73.8816, 6.9264, 73.8816, 2.3088, GAMGI_IO_STROKE,

18.4704, 2.3088, 73.8816, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 77 M strokes: 8 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

23.0880, 76.1904, 23.0880, 2.3088, 18.4704, 2.3088, GAMGI_IO_STROKE,

23.0880, 76.1904, 55.4112, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 55.4112, 16.1616, GAMGI_IO_STROKE,

92.3520, 99.2784, 55.4112, 16.1616, GAMGI_IO_STROKE,

87.7344, 76.1904, 55.4112, 2.3088, GAMGI_IO_STROKE,

87.7344, 76.1904, 87.7344, 2.3088, 92.3520, 2.3088, GAMGI_IO_STROKE,

92.3520, 99.2784, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 78 N strokes: 6 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

23.0880, 85.4256, 23.0880, 2.3088, 18.4704, 2.3088, GAMGI_IO_STROKE,

23.0880, 85.4256, 83.1168, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 78.4992, 16.1616, GAMGI_IO_STROKE,

78.4992, 99.2784, 78.4992, 16.1616, GAMGI_IO_STROKE,

78.4992, 99.2784, 83.1168, 99.2784, 83.1168, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 79 O strokes: 2 *
 *************************/

41.5584, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 62.3376, 13.8528, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, 87.7344, 39.2496, 87.7344, 62.3376, 83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

46.1760, 94.6608, 32.3232, 90.0432, 23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 25.3968, 32.3232, 11.5440, 46.1760, 6.9264, 55.4112, 6.9264, 69.2640, 11.5440, 78.4992, 25.3968, 83.1168, 39.2496, 83.1168, 62.3376, 78.4992, 76.1904, 69.2640, 90.0432, 55.4112, 94.6608, 46.1760, 94.6608, GAMGI_IO_CHAR,

/*************************
 * char: 80 P strokes: 4 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

23.0880, 94.6608, 23.0880, 2.3088, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 60.0288, 99.2784, 69.2640, 94.6608, 73.8816, 90.0432, 78.4992, 80.8080, 78.4992, 66.9552, 73.8816, 57.7200, 69.2640, 53.1024, 60.0288, 48.4848, 23.0880, 48.4848, GAMGI_IO_STROKE,

23.0880, 94.6608, 60.0288, 94.6608, 69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 66.9552, 69.2640, 57.7200, 60.0288, 53.1024, 23.0880, 53.1024, GAMGI_IO_CHAR,

/*************************
 * char: 81 Q strokes: 4 *
 *************************/

41.5584, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 62.3376, 13.8528, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, 87.7344, 39.2496, 87.7344, 62.3376, 83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

46.1760, 94.6608, 32.3232, 90.0432, 23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 25.3968, 32.3232, 11.5440, 46.1760, 6.9264, 55.4112, 6.9264, 69.2640, 11.5440, 78.4992, 25.3968, 83.1168, 39.2496, 83.1168, 62.3376, 78.4992, 76.1904, 69.2640, 90.0432, 55.4112, 94.6608, 46.1760, 94.6608, GAMGI_IO_STROKE,

55.4112, 16.1616, 78.4992, -6.9264, 83.1168, -6.9264, GAMGI_IO_STROKE,

55.4112, 16.1616, 60.0288, 16.1616, 83.1168, -6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 82 R strokes: 6 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

23.0880, 94.6608, 23.0880, 2.3088, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 55.4112, 99.2784, 69.2640, 94.6608, 73.8816, 90.0432, 78.4992, 80.8080, 78.4992, 66.9552, 73.8816, 57.7200, 69.2640, 53.1024, 55.4112, 48.4848, 23.0880, 48.4848, GAMGI_IO_STROKE,

23.0880, 94.6608, 55.4112, 94.6608, 69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 66.9552, 69.2640, 57.7200, 55.4112, 53.1024, 23.0880, 53.1024, GAMGI_IO_STROKE,

46.1760, 48.4848, 73.8816, 2.3088, 78.4992, 2.3088, GAMGI_IO_STROKE,

50.7936, 48.4848, 78.4992, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 83 S strokes: 2 *
 *************************/

78.4992, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, 23.0880, 94.6608, 13.8528, 85.4256, 13.8528, 76.1904, 18.4704, 66.9552, 23.0880, 62.3376, 32.3232, 57.7200, 55.4112, 48.4848, 64.6464, 43.8672, 69.2640, 39.2496, 73.8816, 30.0144, 73.8816, 16.1616, 69.2640, 11.5440, 55.4112, 6.9264, 36.9408, 6.9264, 27.7056, 11.5440, 23.0880, 16.1616, 13.8528, 16.1616, GAMGI_IO_STROKE,

78.4992, 85.4256, 69.2640, 85.4256, 64.6464, 90.0432, 55.4112, 94.6608, 36.9408, 94.6608, 23.0880, 90.0432, 18.4704, 85.4256, 18.4704, 76.1904, 23.0880, 66.9552, 32.3232, 62.3376, 55.4112, 53.1024, 64.6464, 48.4848, 73.8816, 39.2496, 78.4992, 30.0144, 78.4992, 16.1616, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 13.8528, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 84 T strokes: 4 *
 *************************/

36.9408, 94.6608, 36.9408, 2.3088, GAMGI_IO_STROKE,

41.5584, 94.6608, 41.5584, 2.3088, 36.9408, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 69.2640, 99.2784, 69.2640, 94.6608, GAMGI_IO_STROKE,

9.2352, 99.2784, 9.2352, 94.6608, 69.2640, 94.6608, GAMGI_IO_CHAR,

/*************************
 * char: 85 U strokes: 2 *
 *************************/

18.4704, 99.2784, 18.4704, 30.0144, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 30.0144, 83.1168, 99.2784, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 99.2784, 23.0880, 30.0144, 27.7056, 16.1616, 32.3232, 11.5440, 46.1760, 6.9264, 55.4112, 6.9264, 69.2640, 11.5440, 73.8816, 16.1616, 78.4992, 30.0144, 78.4992, 99.2784, 83.1168, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 86 V strokes: 4 *
 *************************/

9.2352, 99.2784, 46.1760, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 13.8528, 99.2784, 46.1760, 16.1616, GAMGI_IO_STROKE,

83.1168, 99.2784, 78.4992, 99.2784, 46.1760, 16.1616, GAMGI_IO_STROKE,

83.1168, 99.2784, 46.1760, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 87 W strokes: 8 *
 *************************/

9.2352, 99.2784, 36.9408, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 13.8528, 99.2784, 36.9408, 16.1616, GAMGI_IO_STROKE,

60.0288, 99.2784, 36.9408, 16.1616, GAMGI_IO_STROKE,

60.0288, 85.4256, 36.9408, 2.3088, GAMGI_IO_STROKE,

60.0288, 85.4256, 83.1168, 2.3088, GAMGI_IO_STROKE,

60.0288, 99.2784, 83.1168, 16.1616, GAMGI_IO_STROKE,

110.8224, 99.2784, 106.2048, 99.2784, 83.1168, 16.1616, GAMGI_IO_STROKE,

110.8224, 99.2784, 83.1168, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 88 X strokes: 4 *
 *************************/

13.8528, 99.2784, 73.8816, 2.3088, 78.4992, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 18.4704, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

78.4992, 99.2784, 73.8816, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

78.4992, 99.2784, 18.4704, 2.3088, 13.8528, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 89 Y strokes: 4 *
 *************************/

9.2352, 99.2784, 41.5584, 53.1024, 41.5584, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 13.8528, 99.2784, 46.1760, 53.1024, GAMGI_IO_STROKE,

78.4992, 99.2784, 73.8816, 99.2784, 41.5584, 53.1024, GAMGI_IO_STROKE,

78.4992, 99.2784, 46.1760, 53.1024, 46.1760, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 90 Z strokes: 6 *
 *************************/

73.8816, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

78.4992, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 78.4992, 99.2784, GAMGI_IO_STROKE,

13.8528, 99.2784, 13.8528, 94.6608, 73.8816, 94.6608, GAMGI_IO_STROKE,

18.4704, 6.9264, 78.4992, 6.9264, 78.4992, 2.3088, GAMGI_IO_STROKE,

13.8528, 2.3088, 78.4992, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 91 [ strokes: 4 *
 *************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_STROKE,

23.0880, 117.7488, 23.0880, -30.0144, GAMGI_IO_STROKE,

18.4704, 117.7488, 50.7936, 117.7488, GAMGI_IO_STROKE,

18.4704, -30.0144, 50.7936, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 92 \ strokes: 2 *
 *************************/

13.8528, 117.7488, 96.9696, -30.0144, 92.3520, -30.0144, GAMGI_IO_STROKE,

13.8528, 117.7488, 9.2352, 117.7488, 92.3520, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 93 ] strokes: 4 *
 *************************/

41.5584, 117.7488, 41.5584, -30.0144, GAMGI_IO_STROKE,

46.1760, 117.7488, 46.1760, -30.0144, GAMGI_IO_STROKE,

13.8528, 117.7488, 46.1760, 117.7488, GAMGI_IO_STROKE,

13.8528, -30.0144, 46.1760, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 94 ^ strokes: 2 *
 *************************/

27.7056, 71.5728, 36.9408, 85.4256, 46.1760, 71.5728, GAMGI_IO_STROKE,

13.8528, 57.7200, 36.9408, 80.8080, 60.0288, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 95 _ strokes: 1 *
 *************************/

9.2352, -6.9264, 92.3520, -6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 96 ` strokes: 4 *
 *************************/

32.3232, 99.2784, 23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 71.5728, 23.0880, 66.9552, 27.7056, 66.9552, 32.3232, 71.5728, 32.3232, 76.1904, 27.7056, 80.8080, 23.0880, 80.8080, 18.4704, 76.1904, GAMGI_IO_STROKE,

23.0880, 76.1904, 23.0880, 71.5728, 27.7056, 71.5728, 27.7056, 76.1904, 23.0880, 76.1904, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 76.1904, GAMGI_IO_STROKE,

18.4704, 85.4256, 23.0880, 80.8080, GAMGI_IO_CHAR,

/*************************
 * char: 97 a strokes: 4 *
 *************************/

69.2640, 66.9552, 69.2640, 2.3088, 73.8816, 2.3088, GAMGI_IO_STROKE,

69.2640, 66.9552, 73.8816, 66.9552, 73.8816, 2.3088, GAMGI_IO_STROKE,

69.2640, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, 36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 36.9408, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, GAMGI_IO_STROKE,

69.2640, 53.1024, 50.7936, 62.3376, 36.9408, 62.3376, 27.7056, 57.7200, 23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 30.0144, 23.0880, 16.1616, 27.7056, 11.5440, 36.9408, 6.9264, 50.7936, 6.9264, 69.2640, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 98 b strokes: 4 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, 23.0880, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

23.0880, 53.1024, 32.3232, 62.3376, 41.5584, 66.9552, 55.4112, 66.9552, 64.6464, 62.3376, 73.8816, 53.1024, 78.4992, 39.2496, 78.4992, 30.0144, 73.8816, 16.1616, 64.6464, 6.9264, 55.4112, 2.3088, 41.5584, 2.3088, 32.3232, 6.9264, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 53.1024, 41.5584, 62.3376, 55.4112, 62.3376, 64.6464, 57.7200, 69.2640, 53.1024, 73.8816, 39.2496, 73.8816, 30.0144, 69.2640, 16.1616, 64.6464, 11.5440, 55.4112, 6.9264, 41.5584, 6.9264, 23.0880, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 99 c strokes: 2 *
 *************************/

69.2640, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, 36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 36.9408, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, GAMGI_IO_STROKE,

69.2640, 53.1024, 64.6464, 48.4848, 60.0288, 57.7200, 50.7936, 62.3376, 36.9408, 62.3376, 27.7056, 57.7200, 23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 30.0144, 23.0880, 16.1616, 27.7056, 11.5440, 36.9408, 6.9264, 50.7936, 6.9264, 60.0288, 11.5440, 64.6464, 20.7792, 69.2640, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 100 d strokes: 4 *
 **************************/

69.2640, 99.2784, 69.2640, 2.3088, 73.8816, 2.3088, GAMGI_IO_STROKE,

69.2640, 99.2784, 73.8816, 99.2784, 73.8816, 2.3088, GAMGI_IO_STROKE,

69.2640, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, 36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 36.9408, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, GAMGI_IO_STROKE,

69.2640, 53.1024, 50.7936, 62.3376, 36.9408, 62.3376, 27.7056, 57.7200, 23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 30.0144, 23.0880, 16.1616, 27.7056, 11.5440, 36.9408, 6.9264, 50.7936, 6.9264, 69.2640, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 101 e strokes: 2 *
 **************************/

18.4704, 34.6320, 69.2640, 34.6320, 69.2640, 48.4848, 64.6464, 57.7200, 60.0288, 62.3376, 50.7936, 66.9552, 36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 36.9408, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, GAMGI_IO_STROKE,

18.4704, 39.2496, 64.6464, 39.2496, 64.6464, 48.4848, 60.0288, 57.7200, 50.7936, 62.3376, 36.9408, 62.3376, 27.7056, 57.7200, 23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 30.0144, 23.0880, 16.1616, 27.7056, 11.5440, 36.9408, 6.9264, 50.7936, 6.9264, 60.0288, 11.5440, 64.6464, 20.7792, 69.2640, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 102 f strokes: 5 *
 **************************/

50.7936, 99.2784, 41.5584, 99.2784, 32.3232, 94.6608, 27.7056, 80.8080, 27.7056, 2.3088, 32.3232, 2.3088, GAMGI_IO_STROKE,

50.7936, 99.2784, 50.7936, 94.6608, 41.5584, 94.6608, 32.3232, 90.0432, GAMGI_IO_STROKE,

36.9408, 94.6608, 32.3232, 80.8080, 32.3232, 2.3088, GAMGI_IO_STROKE,

13.8528, 66.9552, 46.1760, 66.9552, 46.1760, 62.3376, GAMGI_IO_STROKE,

13.8528, 66.9552, 13.8528, 62.3376, 46.1760, 62.3376, GAMGI_IO_CHAR,

/**************************
 * char: 103 g strokes: 4 *
 **************************/

73.8816, 66.9552, 69.2640, 66.9552, 69.2640, -2.3088, 64.6464, -16.1616, 60.0288, -20.7792, 50.7936, -25.3968, 41.5584, -25.3968, 32.3232, -20.7792, 27.7056, -16.1616, 18.4704, -16.1616, GAMGI_IO_STROKE,

73.8816, 66.9552, 73.8816, -2.3088, 69.2640, -16.1616, 60.0288, -25.3968, 50.7936, -30.0144, 36.9408, -30.0144, 27.7056, -25.3968, 18.4704, -16.1616, GAMGI_IO_STROKE,

69.2640, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, 36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 36.9408, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, GAMGI_IO_STROKE,

69.2640, 53.1024, 50.7936, 62.3376, 36.9408, 62.3376, 27.7056, 57.7200, 23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 30.0144, 23.0880, 16.1616, 27.7056, 11.5440, 36.9408, 6.9264, 50.7936, 6.9264, 69.2640, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 104 h strokes: 4 *
 **************************/

18.4704, 99.2784, 18.4704, 2.3088, 23.0880, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

23.0880, 48.4848, 36.9408, 62.3376, 46.1760, 66.9552, 60.0288, 66.9552, 69.2640, 62.3376, 73.8816, 48.4848, 73.8816, 2.3088, GAMGI_IO_STROKE,

23.0880, 48.4848, 36.9408, 57.7200, 46.1760, 62.3376, 55.4112, 62.3376, 64.6464, 57.7200, 69.2640, 48.4848, 69.2640, 2.3088, 73.8816, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 105 i strokes: 4 *
 **************************/

18.4704, 99.2784, 13.8528, 94.6608, 13.8528, 90.0432, 18.4704, 85.4256, 23.0880, 85.4256, 27.7056, 90.0432, 27.7056, 94.6608, 23.0880, 99.2784, 18.4704, 99.2784, GAMGI_IO_STROKE,

18.4704, 94.6608, 18.4704, 90.0432, 23.0880, 90.0432, 23.0880, 94.6608, 18.4704, 94.6608, GAMGI_IO_STROKE,

18.4704, 66.9552, 18.4704, 2.3088, 23.0880, 2.3088, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 66.9552, 23.0880, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 106 j strokes: 4 *
 **************************/

18.4704, 99.2784, 13.8528, 94.6608, 13.8528, 90.0432, 18.4704, 85.4256, 23.0880, 85.4256, 27.7056, 90.0432, 27.7056, 94.6608, 23.0880, 99.2784, 18.4704, 99.2784, GAMGI_IO_STROKE,

18.4704, 94.6608, 18.4704, 90.0432, 23.0880, 90.0432, 23.0880, 94.6608, 18.4704, 94.6608, GAMGI_IO_STROKE,

18.4704, 66.9552, 18.4704, -30.0144, 23.0880, -30.0144, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 66.9552, 23.0880, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 107 k strokes: 6 *
 **************************/

18.4704, 99.2784, 18.4704, 2.3088, 23.0880, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

73.8816, 66.9552, 69.2640, 66.9552, 23.0880, 20.7792, GAMGI_IO_STROKE,

73.8816, 66.9552, 23.0880, 16.1616, GAMGI_IO_STROKE,

36.9408, 34.6320, 64.6464, 2.3088, 73.8816, 2.3088, GAMGI_IO_STROKE,

41.5584, 39.2496, 73.8816, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 108 l strokes: 2 *
 **************************/

18.4704, 99.2784, 18.4704, 2.3088, 23.0880, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 109 m strokes: 6 *
 **************************/

18.4704, 66.9552, 18.4704, 2.3088, 23.0880, 2.3088, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 66.9552, 23.0880, 2.3088, GAMGI_IO_STROKE,

23.0880, 48.4848, 36.9408, 62.3376, 46.1760, 66.9552, 60.0288, 66.9552, 69.2640, 62.3376, 73.8816, 48.4848, 73.8816, 2.3088, GAMGI_IO_STROKE,

23.0880, 48.4848, 36.9408, 57.7200, 46.1760, 62.3376, 55.4112, 62.3376, 64.6464, 57.7200, 69.2640, 48.4848, 69.2640, 2.3088, 73.8816, 2.3088, GAMGI_IO_STROKE,

73.8816, 48.4848, 87.7344, 62.3376, 96.9696, 66.9552, 110.8224, 66.9552, 120.0576, 62.3376, 124.6752, 48.4848, 124.6752, 2.3088, GAMGI_IO_STROKE,

73.8816, 48.4848, 87.7344, 57.7200, 96.9696, 62.3376, 106.2048, 62.3376, 115.4400, 57.7200, 120.0576, 48.4848, 120.0576, 2.3088, 124.6752, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 110 n strokes: 4 *
 **************************/

18.4704, 66.9552, 18.4704, 2.3088, 23.0880, 2.3088, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 66.9552, 23.0880, 2.3088, GAMGI_IO_STROKE,

23.0880, 48.4848, 36.9408, 62.3376, 46.1760, 66.9552, 60.0288, 66.9552, 69.2640, 62.3376, 73.8816, 48.4848, 73.8816, 2.3088, GAMGI_IO_STROKE,

23.0880, 48.4848, 36.9408, 57.7200, 46.1760, 62.3376, 55.4112, 62.3376, 64.6464, 57.7200, 69.2640, 48.4848, 69.2640, 2.3088, 73.8816, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 111 o strokes: 2 *
 **************************/

36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 36.9408, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, 73.8816, 30.0144, 73.8816, 39.2496, 69.2640, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, 36.9408, 66.9552, GAMGI_IO_STROKE,

36.9408, 62.3376, 27.7056, 57.7200, 23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 30.0144, 23.0880, 16.1616, 27.7056, 11.5440, 36.9408, 6.9264, 50.7936, 6.9264, 60.0288, 11.5440, 64.6464, 16.1616, 69.2640, 30.0144, 69.2640, 39.2496, 64.6464, 53.1024, 60.0288, 57.7200, 50.7936, 62.3376, 36.9408, 62.3376, GAMGI_IO_CHAR,

/**************************
 * char: 112 p strokes: 4 *
 **************************/

18.4704, 66.9552, 18.4704, -30.0144, 23.0880, -30.0144, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 66.9552, 23.0880, -30.0144, GAMGI_IO_STROKE,

23.0880, 53.1024, 32.3232, 62.3376, 41.5584, 66.9552, 55.4112, 66.9552, 64.6464, 62.3376, 73.8816, 53.1024, 78.4992, 39.2496, 78.4992, 30.0144, 73.8816, 16.1616, 64.6464, 6.9264, 55.4112, 2.3088, 41.5584, 2.3088, 32.3232, 6.9264, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 53.1024, 41.5584, 62.3376, 55.4112, 62.3376, 64.6464, 57.7200, 69.2640, 53.1024, 73.8816, 39.2496, 73.8816, 30.0144, 69.2640, 16.1616, 64.6464, 11.5440, 55.4112, 6.9264, 41.5584, 6.9264, 23.0880, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 113 q strokes: 4 *
 **************************/

69.2640, 66.9552, 69.2640, -30.0144, 73.8816, -30.0144, GAMGI_IO_STROKE,

69.2640, 66.9552, 73.8816, 66.9552, 73.8816, -30.0144, GAMGI_IO_STROKE,

69.2640, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, 36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 36.9408, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, GAMGI_IO_STROKE,

69.2640, 53.1024, 50.7936, 62.3376, 36.9408, 62.3376, 27.7056, 57.7200, 23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 30.0144, 23.0880, 16.1616, 27.7056, 11.5440, 36.9408, 6.9264, 50.7936, 6.9264, 69.2640, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 114 r strokes: 4 *
 **************************/

18.4704, 66.9552, 18.4704, 2.3088, 23.0880, 2.3088, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 66.9552, 23.0880, 2.3088, GAMGI_IO_STROKE,

23.0880, 39.2496, 27.7056, 53.1024, 36.9408, 62.3376, 46.1760, 66.9552, 60.0288, 66.9552, GAMGI_IO_STROKE,

23.0880, 39.2496, 27.7056, 48.4848, 36.9408, 57.7200, 46.1760, 62.3376, 60.0288, 62.3376, 60.0288, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 115 s strokes: 8 *
 **************************/

64.6464, 53.1024, 60.0288, 62.3376, 46.1760, 66.9552, 32.3232, 66.9552, 18.4704, 62.3376, 13.8528, 53.1024, 18.4704, 43.8672, 27.7056, 39.2496, 50.7936, 30.0144, 60.0288, 25.3968, GAMGI_IO_STROKE,

55.4112, 30.0144, 60.0288, 20.7792, 60.0288, 16.1616, 55.4112, 6.9264, GAMGI_IO_STROKE,

60.0288, 11.5440, 46.1760, 6.9264, 32.3232, 6.9264, 18.4704, 11.5440, GAMGI_IO_STROKE,

23.0880, 6.9264, 18.4704, 16.1616, 13.8528, 16.1616, GAMGI_IO_STROKE,

64.6464, 53.1024, 60.0288, 53.1024, 55.4112, 62.3376, GAMGI_IO_STROKE,

60.0288, 57.7200, 46.1760, 62.3376, 32.3232, 62.3376, 18.4704, 57.7200, GAMGI_IO_STROKE,

23.0880, 62.3376, 18.4704, 53.1024, 23.0880, 43.8672, GAMGI_IO_STROKE,

18.4704, 48.4848, 27.7056, 43.8672, 50.7936, 34.6320, 60.0288, 30.0144, 64.6464, 20.7792, 64.6464, 16.1616, 60.0288, 6.9264, 46.1760, 2.3088, 32.3232, 2.3088, 18.4704, 6.9264, 13.8528, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 116 t strokes: 4 *
 **************************/

23.0880, 99.2784, 23.0880, 2.3088, 27.7056, 2.3088, GAMGI_IO_STROKE,

23.0880, 99.2784, 27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

9.2352, 66.9552, 41.5584, 66.9552, 41.5584, 62.3376, GAMGI_IO_STROKE,

9.2352, 66.9552, 9.2352, 62.3376, 41.5584, 62.3376, GAMGI_IO_CHAR,

/**************************
 * char: 117 u strokes: 4 *
 **************************/

18.4704, 66.9552, 18.4704, 20.7792, 23.0880, 6.9264, 32.3232, 2.3088, 46.1760, 2.3088, 55.4112, 6.9264, 69.2640, 20.7792, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 66.9552, 23.0880, 20.7792, 27.7056, 11.5440, 36.9408, 6.9264, 46.1760, 6.9264, 55.4112, 11.5440, 69.2640, 20.7792, GAMGI_IO_STROKE,

69.2640, 66.9552, 69.2640, 2.3088, 73.8816, 2.3088, GAMGI_IO_STROKE,

69.2640, 66.9552, 73.8816, 66.9552, 73.8816, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 118 v strokes: 4 *
 **************************/

9.2352, 66.9552, 36.9408, 2.3088, GAMGI_IO_STROKE,

9.2352, 66.9552, 13.8528, 66.9552, 36.9408, 11.5440, GAMGI_IO_STROKE,

64.6464, 66.9552, 60.0288, 66.9552, 36.9408, 11.5440, GAMGI_IO_STROKE,

64.6464, 66.9552, 36.9408, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 119 w strokes: 8 *
 **************************/

13.8528, 66.9552, 36.9408, 2.3088, GAMGI_IO_STROKE,

13.8528, 66.9552, 18.4704, 66.9552, 36.9408, 16.1616, GAMGI_IO_STROKE,

55.4112, 66.9552, 36.9408, 16.1616, GAMGI_IO_STROKE,

55.4112, 53.1024, 36.9408, 2.3088, GAMGI_IO_STROKE,

55.4112, 53.1024, 73.8816, 2.3088, GAMGI_IO_STROKE,

55.4112, 66.9552, 73.8816, 16.1616, GAMGI_IO_STROKE,

96.9696, 66.9552, 92.3520, 66.9552, 73.8816, 16.1616, GAMGI_IO_STROKE,

96.9696, 66.9552, 73.8816, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 120 x strokes: 4 *
 **************************/

13.8528, 66.9552, 64.6464, 2.3088, 69.2640, 2.3088, GAMGI_IO_STROKE,

13.8528, 66.9552, 18.4704, 66.9552, 69.2640, 2.3088, GAMGI_IO_STROKE,

69.2640, 66.9552, 64.6464, 66.9552, 13.8528, 2.3088, GAMGI_IO_STROKE,

69.2640, 66.9552, 18.4704, 2.3088, 13.8528, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 121 y strokes: 4 *
 **************************/

9.2352, 66.9552, 36.9408, 2.3088, GAMGI_IO_STROKE,

9.2352, 66.9552, 13.8528, 66.9552, 36.9408, 11.5440, GAMGI_IO_STROKE,

64.6464, 66.9552, 60.0288, 66.9552, 36.9408, 11.5440, 18.4704, -30.0144, GAMGI_IO_STROKE,

64.6464, 66.9552, 36.9408, 2.3088, 23.0880, -30.0144, 18.4704, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 122 z strokes: 6 *
 **************************/

60.0288, 62.3376, 13.8528, 2.3088, GAMGI_IO_STROKE,

69.2640, 66.9552, 23.0880, 6.9264, GAMGI_IO_STROKE,

13.8528, 66.9552, 69.2640, 66.9552, GAMGI_IO_STROKE,

13.8528, 66.9552, 13.8528, 62.3376, 60.0288, 62.3376, GAMGI_IO_STROKE,

23.0880, 6.9264, 69.2640, 6.9264, 69.2640, 2.3088, GAMGI_IO_STROKE,

13.8528, 2.3088, 69.2640, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 123 { strokes: 3 *
 **************************/

46.1760, 117.7488, 32.3232, 103.8960, 27.7056, 90.0432, 27.7056, 80.8080, 32.3232, 66.9552, 41.5584, 57.7200, 41.5584, 53.1024, 23.0880, 43.8672, 41.5584, 34.6320, 41.5584, 30.0144, 32.3232, 20.7792, 27.7056, 6.9264, 27.7056, -2.3088, 32.3232, -16.1616, 46.1760, -30.0144, GAMGI_IO_STROKE,

36.9408, 108.5136, 32.3232, 94.6608, 32.3232, 76.1904, 36.9408, 62.3376, GAMGI_IO_STROKE,

36.9408, 25.3968, 32.3232, 11.5440, 32.3232, -6.9264, 36.9408, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 124 | strokes: 2 *
 **************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_STROKE,

23.0880, 117.7488, 23.0880, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 125 } strokes: 3 *
 **************************/

23.0880, 117.7488, 36.9408, 103.8960, 41.5584, 90.0432, 41.5584, 80.8080, 36.9408, 66.9552, 27.7056, 57.7200, 27.7056, 53.1024, 46.1760, 43.8672, 27.7056, 34.6320, 27.7056, 30.0144, 36.9408, 20.7792, 41.5584, 6.9264, 41.5584, -2.3088, 36.9408, -16.1616, 23.0880, -30.0144, GAMGI_IO_STROKE,

32.3232, 108.5136, 36.9408, 94.6608, 36.9408, 76.1904, 32.3232, 62.3376, GAMGI_IO_STROKE,

32.3232, 25.3968, 36.9408, 11.5440, 36.9408, -6.9264, 32.3232, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 126 ~ strokes: 2 *
 **************************/

13.8528, 30.0144, 13.8528, 39.2496, 18.4704, 53.1024, 27.7056, 57.7200, 36.9408, 57.7200, 46.1760, 53.1024, 64.6464, 39.2496, 73.8816, 34.6320, 83.1168, 34.6320, 92.3520, 39.2496, 96.9696, 48.4848, GAMGI_IO_STROKE,

13.8528, 39.2496, 18.4704, 48.4848, 27.7056, 53.1024, 36.9408, 53.1024, 46.1760, 48.4848, 64.6464, 34.6320, 73.8816, 30.0144, 83.1168, 30.0144, 92.3520, 34.6320, 96.9696, 48.4848, 96.9696, 57.7200, GAMGI_IO_CHAR,

};

const float gamgi_io_font_hershey_serif_points[GAMGI_IO_POINTS_SERIF] = {

/***************
 * bottom, top *
 ***************/

-32.3232, 120.0576,

/**************
 * char 32-40 *
 **************/

73.8816, 46.1760, 73.8816, 101.5872, 92.3520, 110.8224, 115.4400, 46.1760, 64.6464, 

/**************
 * char 41-50 *
 **************/

64.6464, 73.8816, 120.0576, 46.1760, 120.0576, 46.1760, 101.5872, 92.3520, 92.3520, 92.3520, 

/**************
 * char 51-60 *
 **************/

92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 46.1760, 46.1760, 110.8224, 

/**************
 * char 61-70 *
 **************/

120.0576, 110.8224, 83.1168, 124.6752, 92.3520, 101.5872, 96.9696, 101.5872, 96.9696, 92.3520, 

/**************
 * char 71-80 *
 **************/

106.2048, 110.8224, 50.7936, 69.2640, 101.5872, 83.1168, 115.4400, 106.2048, 101.5872, 101.5872, 

/**************
 * char 81-90 *
 **************/

101.5872, 101.5872, 92.3520, 87.7344, 110.8224, 92.3520, 110.8224, 92.3520, 96.9696, 92.3520, 

/***************
 * char 91-100 *
 ***************/

64.6464, 101.5872, 64.6464, 73.8816, 101.5872, 46.1760, 92.3520, 96.9696, 87.7344, 96.9696, 

/****************
 * char 101-110 *
 ****************/

87.7344, 60.0288, 87.7344, 101.5872, 50.7936, 50.7936, 96.9696, 50.7936, 152.3808, 101.5872, 

/****************
 * char 111-120 *
 ****************/

92.3520, 96.9696, 92.3520, 78.4992, 78.4992, 69.2640, 101.5872, 83.1168, 110.8224, 92.3520, 

/****************
 * char 121-126 *
 ****************/

87.7344, 83.1168, 69.2640, 36.9408, 69.2640, 110.8224, 

/*************************
 * char: 32   strokes: 0 *
 *************************/

GAMGI_IO_CHAR,

/*************************
 * char: 33 ! strokes: 3 *
 *************************/

23.0880, 99.2784, 18.4704, 90.0432, 23.0880, 34.6320, 27.7056, 90.0432, 23.0880, 99.2784, GAMGI_IO_STROKE,

23.0880, 90.0432, 23.0880, 62.3376, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 6.9264, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 34 " strokes: 4 *
 *************************/

18.4704, 99.2784, 13.8528, 66.9552, GAMGI_IO_STROKE,

23.0880, 99.2784, 13.8528, 66.9552, GAMGI_IO_STROKE,

55.4112, 99.2784, 50.7936, 66.9552, GAMGI_IO_STROKE,

60.0288, 99.2784, 50.7936, 66.9552, GAMGI_IO_CHAR,

/*************************
 * char: 35 # strokes: 4 *
 *************************/

36.9408, 99.2784, 36.9408, -30.0144, GAMGI_IO_STROKE,

64.6464, 99.2784, 64.6464, -30.0144, GAMGI_IO_STROKE,

13.8528, 48.4848, 87.7344, 48.4848, GAMGI_IO_STROKE,

13.8528, 20.7792, 87.7344, 20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 36 $ strokes: 4 *
 *************************/

36.9408, 117.7488, 36.9408, -16.1616, GAMGI_IO_STROKE,

55.4112, 117.7488, 55.4112, -16.1616, GAMGI_IO_STROKE,

73.8816, 85.4256, 69.2640, 80.8080, 73.8816, 76.1904, 78.4992, 80.8080, 78.4992, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, 23.0880, 94.6608, 13.8528, 85.4256, 13.8528, 76.1904, 18.4704, 66.9552, 23.0880, 62.3376, 32.3232, 57.7200, 60.0288, 48.4848, 69.2640, 43.8672, 78.4992, 34.6320, GAMGI_IO_STROKE,

13.8528, 76.1904, 23.0880, 66.9552, 32.3232, 62.3376, 60.0288, 53.1024, 69.2640, 48.4848, 73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 16.1616, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 13.8528, 16.1616, 13.8528, 20.7792, 18.4704, 25.3968, 23.0880, 20.7792, 18.4704, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 37 % strokes: 3 *
 *************************/

96.9696, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

36.9408, 99.2784, 46.1760, 90.0432, 46.1760, 80.8080, 41.5584, 71.5728, 32.3232, 66.9552, 23.0880, 66.9552, 13.8528, 76.1904, 13.8528, 85.4256, 18.4704, 94.6608, 27.7056, 99.2784, 36.9408, 99.2784, 46.1760, 94.6608, 60.0288, 90.0432, 73.8816, 90.0432, 87.7344, 94.6608, 96.9696, 99.2784, GAMGI_IO_STROKE,

78.4992, 34.6320, 69.2640, 30.0144, 64.6464, 20.7792, 64.6464, 11.5440, 73.8816, 2.3088, 83.1168, 2.3088, 92.3520, 6.9264, 96.9696, 16.1616, 96.9696, 25.3968, 87.7344, 34.6320, 78.4992, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 38 & strokes: 3 *
 *************************/

96.9696, 62.3376, 92.3520, 57.7200, 96.9696, 53.1024, 101.5872, 57.7200, 101.5872, 62.3376, 96.9696, 66.9552, 92.3520, 66.9552, 87.7344, 62.3376, 83.1168, 53.1024, 73.8816, 30.0144, 64.6464, 16.1616, 55.4112, 6.9264, 46.1760, 2.3088, 32.3232, 2.3088, 18.4704, 6.9264, 13.8528, 16.1616, 13.8528, 30.0144, 18.4704, 39.2496, 46.1760, 57.7200, 55.4112, 66.9552, 60.0288, 76.1904, 60.0288, 85.4256, 55.4112, 94.6608, 46.1760, 99.2784, 36.9408, 94.6608, 32.3232, 85.4256, 32.3232, 76.1904, 36.9408, 62.3376, 46.1760, 48.4848, 69.2640, 16.1616, 78.4992, 6.9264, 92.3520, 2.3088, 96.9696, 2.3088, 101.5872, 6.9264, 101.5872, 11.5440, GAMGI_IO_STROKE,

32.3232, 2.3088, 23.0880, 6.9264, 18.4704, 16.1616, 18.4704, 30.0144, 23.0880, 39.2496, 32.3232, 48.4848, GAMGI_IO_STROKE,

32.3232, 76.1904, 36.9408, 66.9552, 73.8816, 16.1616, 83.1168, 6.9264, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 39 ' strokes: 1 *
 *************************/

23.0880, 90.0432, 18.4704, 94.6608, 23.0880, 99.2784, 27.7056, 94.6608, 27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 71.5728, GAMGI_IO_CHAR,

/*************************
 * char: 40 ( strokes: 2 *
 *************************/

50.7936, 117.7488, 41.5584, 108.5136, 32.3232, 94.6608, 23.0880, 76.1904, 18.4704, 53.1024, 18.4704, 34.6320, 23.0880, 11.5440, 32.3232, -6.9264, 41.5584, -20.7792, 50.7936, -30.0144, GAMGI_IO_STROKE,

41.5584, 108.5136, 32.3232, 90.0432, 27.7056, 76.1904, 23.0880, 53.1024, 23.0880, 34.6320, 27.7056, 11.5440, 32.3232, -2.3088, 41.5584, -20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 41 ) strokes: 2 *
 *************************/

13.8528, 117.7488, 23.0880, 108.5136, 32.3232, 94.6608, 41.5584, 76.1904, 46.1760, 53.1024, 46.1760, 34.6320, 41.5584, 11.5440, 32.3232, -6.9264, 23.0880, -20.7792, 13.8528, -30.0144, GAMGI_IO_STROKE,

23.0880, 108.5136, 32.3232, 90.0432, 36.9408, 76.1904, 41.5584, 53.1024, 41.5584, 34.6320, 36.9408, 11.5440, 32.3232, -2.3088, 23.0880, -20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 42 * strokes: 3 *
 *************************/

36.9408, 99.2784, 36.9408, 43.8672, GAMGI_IO_STROKE,

13.8528, 85.4256, 60.0288, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 13.8528, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 43 + strokes: 2 *
 *************************/

60.0288, 85.4256, 60.0288, 2.3088, GAMGI_IO_STROKE,

18.4704, 43.8672, 101.5872, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 44 , strokes: 1 *
 *************************/

23.0880, 2.3088, 18.4704, 6.9264, 23.0880, 11.5440, 27.7056, 6.9264, 27.7056, -2.3088, 23.0880, -11.5440, 18.4704, -16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 45 - strokes: 1 *
 *************************/

18.4704, 43.8672, 101.5872, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 46 . strokes: 1 *
 *************************/

23.0880, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 6.9264, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 47 / strokes: 1 *
 *************************/

92.3520, 117.7488, 9.2352, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 48 0 strokes: 3 *
 *************************/

41.5584, 99.2784, 27.7056, 94.6608, 18.4704, 80.8080, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 20.7792, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 20.7792, 78.4992, 43.8672, 78.4992, 57.7200, 73.8816, 80.8080, 64.6464, 94.6608, 50.7936, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, 27.7056, 90.0432, 23.0880, 80.8080, 18.4704, 57.7200, 18.4704, 43.8672, 23.0880, 20.7792, 27.7056, 11.5440, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 11.5440, 69.2640, 20.7792, 73.8816, 43.8672, 73.8816, 57.7200, 69.2640, 80.8080, 64.6464, 90.0432, 60.0288, 94.6608, 50.7936, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 49 1 strokes: 3 *
 *************************/

27.7056, 80.8080, 36.9408, 85.4256, 50.7936, 99.2784, 50.7936, 2.3088, GAMGI_IO_STROKE,

46.1760, 94.6608, 46.1760, 2.3088, GAMGI_IO_STROKE,

27.7056, 2.3088, 69.2640, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 50 2 strokes: 4 *
 *************************/

18.4704, 80.8080, 23.0880, 76.1904, 18.4704, 71.5728, 13.8528, 76.1904, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 36.9408, 99.2784, 55.4112, 99.2784, 69.2640, 94.6608, 73.8816, 90.0432, 78.4992, 80.8080, 78.4992, 71.5728, 73.8816, 62.3376, 60.0288, 53.1024, 36.9408, 43.8672, 27.7056, 39.2496, 18.4704, 30.0144, 13.8528, 16.1616, 13.8528, 2.3088, GAMGI_IO_STROKE,

55.4112, 99.2784, 64.6464, 94.6608, 69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 71.5728, 69.2640, 62.3376, 55.4112, 53.1024, 36.9408, 43.8672, GAMGI_IO_STROKE,

13.8528, 11.5440, 18.4704, 16.1616, 27.7056, 16.1616, 50.7936, 6.9264, 64.6464, 6.9264, 73.8816, 11.5440, 78.4992, 16.1616, GAMGI_IO_STROKE,

27.7056, 16.1616, 50.7936, 2.3088, 69.2640, 2.3088, 73.8816, 6.9264, 78.4992, 16.1616, 78.4992, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 51 3 strokes: 4 *
 *************************/

18.4704, 80.8080, 23.0880, 76.1904, 18.4704, 71.5728, 13.8528, 76.1904, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 36.9408, 99.2784, 55.4112, 99.2784, 69.2640, 94.6608, 73.8816, 85.4256, 73.8816, 71.5728, 69.2640, 62.3376, 55.4112, 57.7200, 41.5584, 57.7200, GAMGI_IO_STROKE,

55.4112, 99.2784, 64.6464, 94.6608, 69.2640, 85.4256, 69.2640, 71.5728, 64.6464, 62.3376, 55.4112, 57.7200, GAMGI_IO_STROKE,

55.4112, 57.7200, 64.6464, 53.1024, 73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 20.7792, 73.8816, 11.5440, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 25.3968, 18.4704, 30.0144, 23.0880, 25.3968, 18.4704, 20.7792, GAMGI_IO_STROKE,

69.2640, 48.4848, 73.8816, 34.6320, 73.8816, 20.7792, 69.2640, 11.5440, 64.6464, 6.9264, 55.4112, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 52 4 strokes: 4 *
 *************************/

55.4112, 90.0432, 55.4112, 2.3088, GAMGI_IO_STROKE,

60.0288, 99.2784, 60.0288, 2.3088, GAMGI_IO_STROKE,

60.0288, 99.2784, 9.2352, 30.0144, 83.1168, 30.0144, GAMGI_IO_STROKE,

41.5584, 2.3088, 73.8816, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 53 5 strokes: 5 *
 *************************/

23.0880, 99.2784, 13.8528, 53.1024, GAMGI_IO_STROKE,

13.8528, 53.1024, 23.0880, 62.3376, 36.9408, 66.9552, 50.7936, 66.9552, 64.6464, 62.3376, 73.8816, 53.1024, 78.4992, 39.2496, 78.4992, 30.0144, 73.8816, 16.1616, 64.6464, 6.9264, 50.7936, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 25.3968, 18.4704, 30.0144, 23.0880, 25.3968, 18.4704, 20.7792, GAMGI_IO_STROKE,

50.7936, 66.9552, 60.0288, 62.3376, 69.2640, 53.1024, 73.8816, 39.2496, 73.8816, 30.0144, 69.2640, 16.1616, 60.0288, 6.9264, 50.7936, 2.3088, GAMGI_IO_STROKE,

23.0880, 99.2784, 69.2640, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 46.1760, 94.6608, 69.2640, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 54 6 strokes: 3 *
 *************************/

69.2640, 85.4256, 64.6464, 80.8080, 69.2640, 76.1904, 73.8816, 80.8080, 73.8816, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 57.7200, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 30.0144, 78.4992, 34.6320, 73.8816, 48.4848, 64.6464, 57.7200, 50.7936, 62.3376, 46.1760, 62.3376, 32.3232, 57.7200, 23.0880, 48.4848, 18.4704, 34.6320, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 57.7200, 18.4704, 30.0144, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, 73.8816, 30.0144, 73.8816, 34.6320, 69.2640, 48.4848, 60.0288, 57.7200, 50.7936, 62.3376, GAMGI_IO_CHAR,

/*************************
 * char: 55 7 strokes: 5 *
 *************************/

13.8528, 99.2784, 13.8528, 71.5728, GAMGI_IO_STROKE,

13.8528, 80.8080, 18.4704, 90.0432, 27.7056, 99.2784, 36.9408, 99.2784, 60.0288, 85.4256, 69.2640, 85.4256, 73.8816, 90.0432, 78.4992, 99.2784, GAMGI_IO_STROKE,

18.4704, 90.0432, 27.7056, 94.6608, 36.9408, 94.6608, 60.0288, 85.4256, GAMGI_IO_STROKE,

78.4992, 99.2784, 78.4992, 85.4256, 73.8816, 71.5728, 55.4112, 48.4848, 50.7936, 39.2496, 46.1760, 25.3968, 46.1760, 2.3088, GAMGI_IO_STROKE,

73.8816, 71.5728, 50.7936, 48.4848, 46.1760, 39.2496, 41.5584, 25.3968, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 56 8 strokes: 6 *
 *************************/

36.9408, 99.2784, 23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 71.5728, 23.0880, 62.3376, 36.9408, 57.7200, 55.4112, 57.7200, 69.2640, 62.3376, 73.8816, 71.5728, 73.8816, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, GAMGI_IO_STROKE,

36.9408, 99.2784, 27.7056, 94.6608, 23.0880, 85.4256, 23.0880, 71.5728, 27.7056, 62.3376, 36.9408, 57.7200, GAMGI_IO_STROKE,

55.4112, 57.7200, 64.6464, 62.3376, 69.2640, 71.5728, 69.2640, 85.4256, 64.6464, 94.6608, 55.4112, 99.2784, GAMGI_IO_STROKE,

36.9408, 57.7200, 23.0880, 53.1024, 18.4704, 48.4848, 13.8528, 39.2496, 13.8528, 20.7792, 18.4704, 11.5440, 23.0880, 6.9264, 36.9408, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 73.8816, 11.5440, 78.4992, 20.7792, 78.4992, 39.2496, 73.8816, 48.4848, 69.2640, 53.1024, 55.4112, 57.7200, GAMGI_IO_STROKE,

36.9408, 57.7200, 27.7056, 53.1024, 23.0880, 48.4848, 18.4704, 39.2496, 18.4704, 20.7792, 23.0880, 11.5440, 27.7056, 6.9264, 36.9408, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 64.6464, 6.9264, 69.2640, 11.5440, 73.8816, 20.7792, 73.8816, 39.2496, 69.2640, 48.4848, 64.6464, 53.1024, 55.4112, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 57 9 strokes: 3 *
 *************************/

73.8816, 66.9552, 69.2640, 53.1024, 60.0288, 43.8672, 46.1760, 39.2496, 41.5584, 39.2496, 27.7056, 43.8672, 18.4704, 53.1024, 13.8528, 66.9552, 13.8528, 71.5728, 18.4704, 85.4256, 27.7056, 94.6608, 41.5584, 99.2784, 50.7936, 99.2784, 64.6464, 94.6608, 73.8816, 85.4256, 78.4992, 71.5728, 78.4992, 43.8672, 73.8816, 25.3968, 69.2640, 16.1616, 60.0288, 6.9264, 46.1760, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, 18.4704, 16.1616, 18.4704, 20.7792, 23.0880, 25.3968, 27.7056, 20.7792, 23.0880, 16.1616, GAMGI_IO_STROKE,

41.5584, 39.2496, 32.3232, 43.8672, 23.0880, 53.1024, 18.4704, 66.9552, 18.4704, 71.5728, 23.0880, 85.4256, 32.3232, 94.6608, 41.5584, 99.2784, GAMGI_IO_STROKE,

50.7936, 99.2784, 60.0288, 94.6608, 69.2640, 85.4256, 73.8816, 71.5728, 73.8816, 43.8672, 69.2640, 25.3968, 64.6464, 16.1616, 55.4112, 6.9264, 46.1760, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 58 : strokes: 2 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 23.0880, 57.7200, 27.7056, 62.3376, 23.0880, 66.9552, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 6.9264, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 59 ; strokes: 2 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 23.0880, 57.7200, 27.7056, 62.3376, 23.0880, 66.9552, GAMGI_IO_STROKE,

23.0880, 2.3088, 18.4704, 6.9264, 23.0880, 11.5440, 27.7056, 6.9264, 27.7056, -2.3088, 23.0880, -11.5440, 18.4704, -16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 60 < strokes: 1 *
 *************************/

92.3520, 85.4256, 18.4704, 43.8672, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 61 = strokes: 2 *
 *************************/

18.4704, 57.7200, 101.5872, 57.7200, GAMGI_IO_STROKE,

18.4704, 30.0144, 101.5872, 30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 62 > strokes: 1 *
 *************************/

18.4704, 85.4256, 92.3520, 43.8672, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 63 ? strokes: 3 *
 *************************/

18.4704, 80.8080, 23.0880, 76.1904, 18.4704, 71.5728, 13.8528, 76.1904, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 32.3232, 99.2784, 46.1760, 99.2784, 60.0288, 94.6608, 64.6464, 90.0432, 69.2640, 80.8080, 69.2640, 71.5728, 64.6464, 62.3376, 60.0288, 57.7200, 41.5584, 48.4848, 41.5584, 34.6320, GAMGI_IO_STROKE,

46.1760, 99.2784, 55.4112, 94.6608, 60.0288, 90.0432, 64.6464, 80.8080, 64.6464, 71.5728, 60.0288, 62.3376, 50.7936, 53.1024, GAMGI_IO_STROKE,

41.5584, 11.5440, 36.9408, 6.9264, 41.5584, 2.3088, 46.1760, 6.9264, 41.5584, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 64 @ strokes: 4 *
 *************************/

83.1168, 62.3376, 78.4992, 71.5728, 69.2640, 76.1904, 55.4112, 76.1904, 46.1760, 71.5728, 41.5584, 66.9552, 36.9408, 53.1024, 36.9408, 39.2496, 41.5584, 30.0144, 50.7936, 25.3968, 64.6464, 25.3968, 73.8816, 30.0144, 78.4992, 39.2496, GAMGI_IO_STROKE,

55.4112, 76.1904, 46.1760, 66.9552, 41.5584, 53.1024, 41.5584, 39.2496, 46.1760, 30.0144, 50.7936, 25.3968, GAMGI_IO_STROKE,

83.1168, 76.1904, 78.4992, 39.2496, 78.4992, 30.0144, 87.7344, 25.3968, 96.9696, 25.3968, 106.2048, 34.6320, 110.8224, 48.4848, 110.8224, 57.7200, 106.2048, 71.5728, 101.5872, 80.8080, 92.3520, 90.0432, 83.1168, 94.6608, 69.2640, 99.2784, 55.4112, 99.2784, 41.5584, 94.6608, 32.3232, 90.0432, 23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 55.4112, 2.3088, 69.2640, 2.3088, 83.1168, 6.9264, 92.3520, 11.5440, 96.9696, 16.1616, GAMGI_IO_STROKE,

87.7344, 76.1904, 83.1168, 39.2496, 83.1168, 30.0144, 87.7344, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 65 A strokes: 6 *
 *************************/

46.1760, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

46.1760, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

46.1760, 85.4256, 73.8816, 2.3088, GAMGI_IO_STROKE,

23.0880, 30.0144, 64.6464, 30.0144, GAMGI_IO_STROKE,

4.6176, 2.3088, 32.3232, 2.3088, GAMGI_IO_STROKE,

60.0288, 2.3088, 87.7344, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 66 B strokes: 6 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 64.6464, 99.2784, 78.4992, 94.6608, 83.1168, 90.0432, 87.7344, 80.8080, 87.7344, 71.5728, 83.1168, 62.3376, 78.4992, 57.7200, 64.6464, 53.1024, GAMGI_IO_STROKE,

64.6464, 99.2784, 73.8816, 94.6608, 78.4992, 90.0432, 83.1168, 80.8080, 83.1168, 71.5728, 78.4992, 62.3376, 73.8816, 57.7200, 64.6464, 53.1024, GAMGI_IO_STROKE,

27.7056, 53.1024, 64.6464, 53.1024, 78.4992, 48.4848, 83.1168, 43.8672, 87.7344, 34.6320, 87.7344, 20.7792, 83.1168, 11.5440, 78.4992, 6.9264, 64.6464, 2.3088, 9.2352, 2.3088, GAMGI_IO_STROKE,

64.6464, 53.1024, 73.8816, 48.4848, 78.4992, 43.8672, 83.1168, 34.6320, 83.1168, 20.7792, 78.4992, 11.5440, 73.8816, 6.9264, 64.6464, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 67 C strokes: 2 *
 *************************/

78.4992, 85.4256, 83.1168, 71.5728, 83.1168, 99.2784, 78.4992, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 62.3376, 13.8528, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 25.3968, 27.7056, 16.1616, 36.9408, 6.9264, 46.1760, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 68 D strokes: 4 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 55.4112, 99.2784, 69.2640, 94.6608, 78.4992, 85.4256, 83.1168, 76.1904, 87.7344, 62.3376, 87.7344, 39.2496, 83.1168, 25.3968, 78.4992, 16.1616, 69.2640, 6.9264, 55.4112, 2.3088, 9.2352, 2.3088, GAMGI_IO_STROKE,

55.4112, 99.2784, 64.6464, 94.6608, 73.8816, 85.4256, 78.4992, 76.1904, 83.1168, 62.3376, 83.1168, 39.2496, 78.4992, 25.3968, 73.8816, 16.1616, 64.6464, 6.9264, 55.4112, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 69 E strokes: 6 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

55.4112, 71.5728, 55.4112, 34.6320, GAMGI_IO_STROKE,

9.2352, 99.2784, 83.1168, 99.2784, 83.1168, 71.5728, 78.4992, 99.2784, GAMGI_IO_STROKE,

27.7056, 53.1024, 55.4112, 53.1024, GAMGI_IO_STROKE,

9.2352, 2.3088, 83.1168, 2.3088, 83.1168, 30.0144, 78.4992, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 70 F strokes: 6 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

55.4112, 71.5728, 55.4112, 34.6320, GAMGI_IO_STROKE,

9.2352, 99.2784, 83.1168, 99.2784, 83.1168, 71.5728, 78.4992, 99.2784, GAMGI_IO_STROKE,

27.7056, 53.1024, 55.4112, 53.1024, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 71 G strokes: 5 *
 *************************/

78.4992, 85.4256, 83.1168, 71.5728, 83.1168, 99.2784, 78.4992, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 62.3376, 13.8528, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 25.3968, 27.7056, 16.1616, 36.9408, 6.9264, 46.1760, 2.3088, GAMGI_IO_STROKE,

78.4992, 39.2496, 78.4992, 2.3088, GAMGI_IO_STROKE,

83.1168, 39.2496, 83.1168, 2.3088, GAMGI_IO_STROKE,

64.6464, 39.2496, 96.9696, 39.2496, GAMGI_IO_CHAR,

/*************************
 * char: 72 H strokes: 9 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 83.1168, 2.3088, GAMGI_IO_STROKE,

87.7344, 99.2784, 87.7344, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

69.2640, 99.2784, 101.5872, 99.2784, GAMGI_IO_STROKE,

27.7056, 53.1024, 83.1168, 53.1024, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_STROKE,

69.2640, 2.3088, 101.5872, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 73 I strokes: 4 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 74 J strokes: 3 *
 *************************/

46.1760, 99.2784, 46.1760, 20.7792, 41.5584, 6.9264, 32.3232, 2.3088, 23.0880, 2.3088, 13.8528, 6.9264, 9.2352, 16.1616, 9.2352, 25.3968, 13.8528, 30.0144, 18.4704, 25.3968, 13.8528, 20.7792, GAMGI_IO_STROKE,

41.5584, 99.2784, 41.5584, 20.7792, 36.9408, 6.9264, 32.3232, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 60.0288, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 75 K strokes: 9 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

87.7344, 99.2784, 27.7056, 39.2496, GAMGI_IO_STROKE,

50.7936, 57.7200, 87.7344, 2.3088, GAMGI_IO_STROKE,

46.1760, 57.7200, 83.1168, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

69.2640, 99.2784, 96.9696, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_STROKE,

69.2640, 2.3088, 96.9696, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 76 L strokes: 4 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 78.4992, 2.3088, 78.4992, 30.0144, 73.8816, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 77 M strokes: 10 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 55.4112, 16.1616, GAMGI_IO_STROKE,

23.0880, 99.2784, 55.4112, 2.3088, GAMGI_IO_STROKE,

87.7344, 99.2784, 55.4112, 2.3088, GAMGI_IO_STROKE,

87.7344, 99.2784, 87.7344, 2.3088, GAMGI_IO_STROKE,

92.3520, 99.2784, 92.3520, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 27.7056, 99.2784, GAMGI_IO_STROKE,

87.7344, 99.2784, 106.2048, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 36.9408, 2.3088, GAMGI_IO_STROKE,

73.8816, 2.3088, 106.2048, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 78 N strokes: 7 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 83.1168, 11.5440, GAMGI_IO_STROKE,

27.7056, 90.0432, 83.1168, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 83.1168, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 27.7056, 99.2784, GAMGI_IO_STROKE,

69.2640, 99.2784, 96.9696, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 36.9408, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 79 O strokes: 3 *
 *************************/

46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, 87.7344, 43.8672, 87.7344, 57.7200, 83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 46.1760, 99.2784, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 57.7200, 18.4704, 43.8672, 23.0880, 25.3968, 27.7056, 16.1616, 36.9408, 6.9264, 46.1760, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 25.3968, 83.1168, 43.8672, 83.1168, 57.7200, 78.4992, 76.1904, 73.8816, 85.4256, 64.6464, 94.6608, 55.4112, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 80 P strokes: 5 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 64.6464, 99.2784, 78.4992, 94.6608, 83.1168, 90.0432, 87.7344, 80.8080, 87.7344, 66.9552, 83.1168, 57.7200, 78.4992, 53.1024, 64.6464, 48.4848, 27.7056, 48.4848, GAMGI_IO_STROKE,

64.6464, 99.2784, 73.8816, 94.6608, 78.4992, 90.0432, 83.1168, 80.8080, 83.1168, 66.9552, 78.4992, 57.7200, 73.8816, 53.1024, 64.6464, 48.4848, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 81 Q strokes: 5 *
 *************************/

46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, 87.7344, 43.8672, 87.7344, 57.7200, 83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 46.1760, 99.2784, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 57.7200, 18.4704, 43.8672, 23.0880, 25.3968, 27.7056, 16.1616, 36.9408, 6.9264, 46.1760, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 25.3968, 83.1168, 43.8672, 83.1168, 57.7200, 78.4992, 76.1904, 73.8816, 85.4256, 64.6464, 94.6608, 55.4112, 99.2784, GAMGI_IO_STROKE,

32.3232, 11.5440, 32.3232, 16.1616, 36.9408, 25.3968, 46.1760, 30.0144, 50.7936, 30.0144, 60.0288, 25.3968, 64.6464, 16.1616, 69.2640, -16.1616, 73.8816, -20.7792, 83.1168, -20.7792, 87.7344, -11.5440, 87.7344, -6.9264, GAMGI_IO_STROKE,

64.6464, 16.1616, 69.2640, -2.3088, 73.8816, -11.5440, 78.4992, -16.1616, 83.1168, -16.1616, 87.7344, -11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 82 R strokes: 7 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 64.6464, 99.2784, 78.4992, 94.6608, 83.1168, 90.0432, 87.7344, 80.8080, 87.7344, 71.5728, 83.1168, 62.3376, 78.4992, 57.7200, 64.6464, 53.1024, 27.7056, 53.1024, GAMGI_IO_STROKE,

64.6464, 99.2784, 73.8816, 94.6608, 78.4992, 90.0432, 83.1168, 80.8080, 83.1168, 71.5728, 78.4992, 62.3376, 73.8816, 57.7200, 64.6464, 53.1024, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 53.1024, 60.0288, 48.4848, 64.6464, 43.8672, 78.4992, 11.5440, 83.1168, 6.9264, 87.7344, 6.9264, 92.3520, 11.5440, GAMGI_IO_STROKE,

60.0288, 48.4848, 64.6464, 39.2496, 73.8816, 6.9264, 78.4992, 2.3088, 87.7344, 2.3088, 92.3520, 11.5440, 92.3520, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 83 S strokes: 2 *
 *************************/

73.8816, 85.4256, 78.4992, 99.2784, 78.4992, 71.5728, 73.8816, 85.4256, 64.6464, 94.6608, 50.7936, 99.2784, 36.9408, 99.2784, 23.0880, 94.6608, 13.8528, 85.4256, 13.8528, 76.1904, 18.4704, 66.9552, 23.0880, 62.3376, 32.3232, 57.7200, 60.0288, 48.4848, 69.2640, 43.8672, 78.4992, 34.6320, GAMGI_IO_STROKE,

13.8528, 76.1904, 23.0880, 66.9552, 32.3232, 62.3376, 60.0288, 53.1024, 69.2640, 48.4848, 73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 16.1616, 69.2640, 6.9264, 55.4112, 2.3088, 41.5584, 2.3088, 27.7056, 6.9264, 18.4704, 16.1616, 13.8528, 30.0144, 13.8528, 2.3088, 18.4704, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 84 T strokes: 4 *
 *************************/

41.5584, 99.2784, 41.5584, 2.3088, GAMGI_IO_STROKE,

46.1760, 99.2784, 46.1760, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 9.2352, 71.5728, 9.2352, 99.2784, 78.4992, 99.2784, 78.4992, 71.5728, 73.8816, 99.2784, GAMGI_IO_STROKE,

27.7056, 2.3088, 60.0288, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 85 U strokes: 4 *
 *************************/

23.0880, 99.2784, 23.0880, 30.0144, 27.7056, 16.1616, 36.9408, 6.9264, 50.7936, 2.3088, 60.0288, 2.3088, 73.8816, 6.9264, 83.1168, 16.1616, 87.7344, 30.0144, 87.7344, 99.2784, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 30.0144, 32.3232, 16.1616, 41.5584, 6.9264, 50.7936, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

73.8816, 99.2784, 101.5872, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 86 V strokes: 5 *
 *************************/

13.8528, 99.2784, 46.1760, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 46.1760, 16.1616, GAMGI_IO_STROKE,

78.4992, 99.2784, 46.1760, 2.3088, GAMGI_IO_STROKE,

4.6176, 99.2784, 32.3232, 99.2784, GAMGI_IO_STROKE,

60.0288, 99.2784, 87.7344, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 87 W strokes: 8 *
 *************************/

18.4704, 99.2784, 36.9408, 2.3088, GAMGI_IO_STROKE,

23.0880, 99.2784, 36.9408, 25.3968, GAMGI_IO_STROKE,

55.4112, 99.2784, 36.9408, 2.3088, GAMGI_IO_STROKE,

55.4112, 99.2784, 73.8816, 2.3088, GAMGI_IO_STROKE,

60.0288, 99.2784, 73.8816, 25.3968, GAMGI_IO_STROKE,

92.3520, 99.2784, 73.8816, 2.3088, GAMGI_IO_STROKE,

4.6176, 99.2784, 36.9408, 99.2784, GAMGI_IO_STROKE,

78.4992, 99.2784, 106.2048, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 88 X strokes: 7 *
 *************************/

13.8528, 99.2784, 73.8816, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

78.4992, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

4.6176, 99.2784, 32.3232, 99.2784, GAMGI_IO_STROKE,

60.0288, 99.2784, 87.7344, 99.2784, GAMGI_IO_STROKE,

4.6176, 2.3088, 32.3232, 2.3088, GAMGI_IO_STROKE,

60.0288, 2.3088, 87.7344, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 89 Y strokes: 6 *
 *************************/

13.8528, 99.2784, 46.1760, 48.4848, 46.1760, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 50.7936, 48.4848, 50.7936, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 50.7936, 48.4848, GAMGI_IO_STROKE,

4.6176, 99.2784, 32.3232, 99.2784, GAMGI_IO_STROKE,

64.6464, 99.2784, 92.3520, 99.2784, GAMGI_IO_STROKE,

32.3232, 2.3088, 64.6464, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 90 Z strokes: 4 *
 *************************/

73.8816, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

78.4992, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 13.8528, 71.5728, 13.8528, 99.2784, 78.4992, 99.2784, GAMGI_IO_STROKE,

13.8528, 2.3088, 78.4992, 2.3088, 78.4992, 30.0144, 73.8816, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 91 [ strokes: 4 *
 *************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_STROKE,

23.0880, 117.7488, 23.0880, -30.0144, GAMGI_IO_STROKE,

18.4704, 117.7488, 50.7936, 117.7488, GAMGI_IO_STROKE,

18.4704, -30.0144, 50.7936, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 92 \ strokes: 1 *
 *************************/

9.2352, 117.7488, 92.3520, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 93 ] strokes: 4 *
 *************************/

41.5584, 117.7488, 41.5584, -30.0144, GAMGI_IO_STROKE,

46.1760, 117.7488, 46.1760, -30.0144, GAMGI_IO_STROKE,

13.8528, 117.7488, 46.1760, 117.7488, GAMGI_IO_STROKE,

13.8528, -30.0144, 46.1760, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 94 ^ strokes: 2 *
 *************************/

27.7056, 71.5728, 36.9408, 85.4256, 46.1760, 71.5728, GAMGI_IO_STROKE,

13.8528, 57.7200, 36.9408, 80.8080, 60.0288, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 95 _ strokes: 1 *
 *************************/

9.2352, -6.9264, 92.3520, -6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 96 ` strokes: 1 *
 *************************/

27.7056, 99.2784, 23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 76.1904, 23.0880, 71.5728, 27.7056, 76.1904, 23.0880, 80.8080, GAMGI_IO_CHAR,

/*************************
 * char: 97 a strokes: 4 *
 *************************/

23.0880, 57.7200, 23.0880, 53.1024, 18.4704, 53.1024, 18.4704, 57.7200, 23.0880, 62.3376, 32.3232, 66.9552, 50.7936, 66.9552, 60.0288, 62.3376, 64.6464, 57.7200, 69.2640, 48.4848, 69.2640, 16.1616, 73.8816, 6.9264, 78.4992, 2.3088, GAMGI_IO_STROKE,

64.6464, 57.7200, 64.6464, 16.1616, 69.2640, 6.9264, 78.4992, 2.3088, 83.1168, 2.3088, GAMGI_IO_STROKE,

64.6464, 48.4848, 60.0288, 43.8672, 32.3232, 39.2496, 18.4704, 34.6320, 13.8528, 25.3968, 13.8528, 16.1616, 18.4704, 6.9264, 32.3232, 2.3088, 46.1760, 2.3088, 55.4112, 6.9264, 64.6464, 16.1616, GAMGI_IO_STROKE,

32.3232, 39.2496, 23.0880, 34.6320, 18.4704, 25.3968, 18.4704, 16.1616, 23.0880, 6.9264, 32.3232, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 98 b strokes: 5 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

27.7056, 53.1024, 36.9408, 62.3376, 46.1760, 66.9552, 55.4112, 66.9552, 69.2640, 62.3376, 78.4992, 53.1024, 83.1168, 39.2496, 83.1168, 30.0144, 78.4992, 16.1616, 69.2640, 6.9264, 55.4112, 2.3088, 46.1760, 2.3088, 36.9408, 6.9264, 27.7056, 16.1616, GAMGI_IO_STROKE,

55.4112, 66.9552, 64.6464, 62.3376, 73.8816, 53.1024, 78.4992, 39.2496, 78.4992, 30.0144, 73.8816, 16.1616, 64.6464, 6.9264, 55.4112, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 27.7056, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 99 c strokes: 2 *
 *************************/

69.2640, 53.1024, 64.6464, 48.4848, 69.2640, 43.8672, 73.8816, 48.4848, 73.8816, 53.1024, 64.6464, 62.3376, 55.4112, 66.9552, 41.5584, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, GAMGI_IO_STROKE,

41.5584, 66.9552, 32.3232, 62.3376, 23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 30.0144, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 100 d strokes: 6 *
 **************************/

69.2640, 99.2784, 69.2640, 2.3088, GAMGI_IO_STROKE,

73.8816, 99.2784, 73.8816, 2.3088, GAMGI_IO_STROKE,

69.2640, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, 41.5584, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, GAMGI_IO_STROKE,

41.5584, 66.9552, 32.3232, 62.3376, 23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 30.0144, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

55.4112, 99.2784, 73.8816, 99.2784, GAMGI_IO_STROKE,

69.2640, 2.3088, 87.7344, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 101 e strokes: 3 *
 **************************/

18.4704, 39.2496, 73.8816, 39.2496, 73.8816, 48.4848, 69.2640, 57.7200, 64.6464, 62.3376, 55.4112, 66.9552, 41.5584, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, GAMGI_IO_STROKE,

69.2640, 39.2496, 69.2640, 53.1024, 64.6464, 62.3376, GAMGI_IO_STROKE,

41.5584, 66.9552, 32.3232, 62.3376, 23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 30.0144, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 102 f strokes: 4 *
 **************************/

46.1760, 94.6608, 41.5584, 90.0432, 46.1760, 85.4256, 50.7936, 90.0432, 50.7936, 94.6608, 46.1760, 99.2784, 36.9408, 99.2784, 27.7056, 94.6608, 23.0880, 85.4256, 23.0880, 2.3088, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 94.6608, 27.7056, 85.4256, 27.7056, 2.3088, GAMGI_IO_STROKE,

9.2352, 66.9552, 46.1760, 66.9552, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 103 g strokes: 6 *
 **************************/

36.9408, 66.9552, 27.7056, 62.3376, 23.0880, 57.7200, 18.4704, 48.4848, 18.4704, 39.2496, 23.0880, 30.0144, 27.7056, 25.3968, 36.9408, 20.7792, 46.1760, 20.7792, 55.4112, 25.3968, 60.0288, 30.0144, 64.6464, 39.2496, 64.6464, 48.4848, 60.0288, 57.7200, 55.4112, 62.3376, 46.1760, 66.9552, 36.9408, 66.9552, GAMGI_IO_STROKE,

27.7056, 62.3376, 23.0880, 53.1024, 23.0880, 34.6320, 27.7056, 25.3968, GAMGI_IO_STROKE,

55.4112, 25.3968, 60.0288, 34.6320, 60.0288, 53.1024, 55.4112, 62.3376, GAMGI_IO_STROKE,

60.0288, 57.7200, 64.6464, 62.3376, 73.8816, 66.9552, 73.8816, 62.3376, 64.6464, 62.3376, GAMGI_IO_STROKE,

23.0880, 30.0144, 18.4704, 25.3968, 13.8528, 16.1616, 13.8528, 11.5440, 18.4704, 2.3088, 32.3232, -2.3088, 55.4112, -2.3088, 69.2640, -6.9264, 73.8816, -11.5440, GAMGI_IO_STROKE,

13.8528, 11.5440, 18.4704, 6.9264, 32.3232, 2.3088, 55.4112, 2.3088, 69.2640, -2.3088, 73.8816, -11.5440, 73.8816, -16.1616, 69.2640, -25.3968, 55.4112, -30.0144, 27.7056, -30.0144, 13.8528, -25.3968, 9.2352, -16.1616, 9.2352, -11.5440, 13.8528, -2.3088, 27.7056, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 104 h strokes: 7 *
 **************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

27.7056, 53.1024, 36.9408, 62.3376, 50.7936, 66.9552, 60.0288, 66.9552, 73.8816, 62.3376, 78.4992, 53.1024, 78.4992, 2.3088, GAMGI_IO_STROKE,

60.0288, 66.9552, 69.2640, 62.3376, 73.8816, 53.1024, 73.8816, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 27.7056, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_STROKE,

60.0288, 2.3088, 92.3520, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 105 i strokes: 5 *
 **************************/

23.0880, 99.2784, 18.4704, 94.6608, 23.0880, 90.0432, 27.7056, 94.6608, 23.0880, 99.2784, GAMGI_IO_STROKE,

23.0880, 66.9552, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 66.9552, 27.7056, 2.3088, GAMGI_IO_STROKE,

9.2352, 66.9552, 27.7056, 66.9552, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 106 j strokes: 4 *
 **************************/

27.7056, 99.2784, 23.0880, 94.6608, 27.7056, 90.0432, 32.3232, 94.6608, 27.7056, 99.2784, GAMGI_IO_STROKE,

32.3232, 66.9552, 32.3232, -16.1616, 27.7056, -25.3968, 18.4704, -30.0144, 9.2352, -30.0144, 4.6176, -25.3968, 4.6176, -20.7792, 9.2352, -16.1616, 13.8528, -20.7792, 9.2352, -25.3968, GAMGI_IO_STROKE,

27.7056, 66.9552, 27.7056, -16.1616, 23.0880, -25.3968, 18.4704, -30.0144, GAMGI_IO_STROKE,

13.8528, 66.9552, 32.3232, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 107 k strokes: 9 *
 **************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

73.8816, 66.9552, 27.7056, 20.7792, GAMGI_IO_STROKE,

50.7936, 39.2496, 78.4992, 2.3088, GAMGI_IO_STROKE,

46.1760, 39.2496, 73.8816, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 27.7056, 99.2784, GAMGI_IO_STROKE,

60.0288, 66.9552, 87.7344, 66.9552, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_STROKE,

60.0288, 2.3088, 87.7344, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 108 l strokes: 4 *
 **************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 27.7056, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 109 m strokes: 10 *
 **************************/

23.0880, 66.9552, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 66.9552, 27.7056, 2.3088, GAMGI_IO_STROKE,

27.7056, 53.1024, 36.9408, 62.3376, 50.7936, 66.9552, 60.0288, 66.9552, 73.8816, 62.3376, 78.4992, 53.1024, 78.4992, 2.3088, GAMGI_IO_STROKE,

60.0288, 66.9552, 69.2640, 62.3376, 73.8816, 53.1024, 73.8816, 2.3088, GAMGI_IO_STROKE,

78.4992, 53.1024, 87.7344, 62.3376, 101.5872, 66.9552, 110.8224, 66.9552, 124.6752, 62.3376, 129.2928, 53.1024, 129.2928, 2.3088, GAMGI_IO_STROKE,

110.8224, 66.9552, 120.0576, 62.3376, 124.6752, 53.1024, 124.6752, 2.3088, GAMGI_IO_STROKE,

9.2352, 66.9552, 27.7056, 66.9552, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_STROKE,

60.0288, 2.3088, 92.3520, 2.3088, GAMGI_IO_STROKE,

110.8224, 2.3088, 143.1456, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 110 n strokes: 7 *
 **************************/

23.0880, 66.9552, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 66.9552, 27.7056, 2.3088, GAMGI_IO_STROKE,

27.7056, 53.1024, 36.9408, 62.3376, 50.7936, 66.9552, 60.0288, 66.9552, 73.8816, 62.3376, 78.4992, 53.1024, 78.4992, 2.3088, GAMGI_IO_STROKE,

60.0288, 66.9552, 69.2640, 62.3376, 73.8816, 53.1024, 73.8816, 2.3088, GAMGI_IO_STROKE,

9.2352, 66.9552, 27.7056, 66.9552, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_STROKE,

60.0288, 2.3088, 92.3520, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 111 o strokes: 3 *
 **************************/

41.5584, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 30.0144, 78.4992, 39.2496, 73.8816, 53.1024, 64.6464, 62.3376, 50.7936, 66.9552, 41.5584, 66.9552, GAMGI_IO_STROKE,

41.5584, 66.9552, 32.3232, 62.3376, 23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 30.0144, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, 73.8816, 30.0144, 73.8816, 39.2496, 69.2640, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 112 p strokes: 6 *
 **************************/

23.0880, 66.9552, 23.0880, -30.0144, GAMGI_IO_STROKE,

27.7056, 66.9552, 27.7056, -30.0144, GAMGI_IO_STROKE,

27.7056, 53.1024, 36.9408, 62.3376, 46.1760, 66.9552, 55.4112, 66.9552, 69.2640, 62.3376, 78.4992, 53.1024, 83.1168, 39.2496, 83.1168, 30.0144, 78.4992, 16.1616, 69.2640, 6.9264, 55.4112, 2.3088, 46.1760, 2.3088, 36.9408, 6.9264, 27.7056, 16.1616, GAMGI_IO_STROKE,

55.4112, 66.9552, 64.6464, 62.3376, 73.8816, 53.1024, 78.4992, 39.2496, 78.4992, 30.0144, 73.8816, 16.1616, 64.6464, 6.9264, 55.4112, 2.3088, GAMGI_IO_STROKE,

9.2352, 66.9552, 27.7056, 66.9552, GAMGI_IO_STROKE,

9.2352, -30.0144, 41.5584, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 113 q strokes: 5 *
 **************************/

69.2640, 66.9552, 69.2640, -30.0144, GAMGI_IO_STROKE,

73.8816, 66.9552, 73.8816, -30.0144, GAMGI_IO_STROKE,

69.2640, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, 41.5584, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, GAMGI_IO_STROKE,

41.5584, 66.9552, 32.3232, 62.3376, 23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 30.0144, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

55.4112, -30.0144, 87.7344, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 114 r strokes: 5 *
 **************************/

23.0880, 66.9552, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 66.9552, 27.7056, 2.3088, GAMGI_IO_STROKE,

27.7056, 39.2496, 32.3232, 53.1024, 41.5584, 62.3376, 50.7936, 66.9552, 64.6464, 66.9552, 69.2640, 62.3376, 69.2640, 57.7200, 64.6464, 53.1024, 60.0288, 57.7200, 64.6464, 62.3376, GAMGI_IO_STROKE,

9.2352, 66.9552, 27.7056, 66.9552, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 115 s strokes: 2 *
 **************************/

60.0288, 57.7200, 64.6464, 66.9552, 64.6464, 48.4848, 60.0288, 57.7200, 55.4112, 62.3376, 46.1760, 66.9552, 27.7056, 66.9552, 18.4704, 62.3376, 13.8528, 57.7200, 13.8528, 48.4848, 18.4704, 43.8672, 27.7056, 39.2496, 50.7936, 30.0144, 60.0288, 25.3968, 64.6464, 20.7792, GAMGI_IO_STROKE,

13.8528, 53.1024, 18.4704, 48.4848, 27.7056, 43.8672, 50.7936, 34.6320, 60.0288, 30.0144, 64.6464, 25.3968, 64.6464, 11.5440, 60.0288, 6.9264, 50.7936, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 2.3088, 18.4704, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 116 t strokes: 3 *
 **************************/

23.0880, 99.2784, 23.0880, 20.7792, 27.7056, 6.9264, 36.9408, 2.3088, 46.1760, 2.3088, 55.4112, 6.9264, 60.0288, 16.1616, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 20.7792, 32.3232, 6.9264, 36.9408, 2.3088, GAMGI_IO_STROKE,

9.2352, 66.9552, 46.1760, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 117 u strokes: 7 *
 **************************/

23.0880, 66.9552, 23.0880, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, GAMGI_IO_STROKE,

27.7056, 66.9552, 27.7056, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

73.8816, 66.9552, 73.8816, 2.3088, GAMGI_IO_STROKE,

78.4992, 66.9552, 78.4992, 2.3088, GAMGI_IO_STROKE,

9.2352, 66.9552, 27.7056, 66.9552, GAMGI_IO_STROKE,

60.0288, 66.9552, 78.4992, 66.9552, GAMGI_IO_STROKE,

73.8816, 2.3088, 92.3520, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 118 v strokes: 5 *
 **************************/

13.8528, 66.9552, 41.5584, 2.3088, GAMGI_IO_STROKE,

18.4704, 66.9552, 41.5584, 11.5440, GAMGI_IO_STROKE,

69.2640, 66.9552, 41.5584, 2.3088, GAMGI_IO_STROKE,

4.6176, 66.9552, 32.3232, 66.9552, GAMGI_IO_STROKE,

50.7936, 66.9552, 78.4992, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 119 w strokes: 8 *
 **************************/

18.4704, 66.9552, 36.9408, 2.3088, GAMGI_IO_STROKE,

23.0880, 66.9552, 36.9408, 16.1616, GAMGI_IO_STROKE,

55.4112, 66.9552, 36.9408, 2.3088, GAMGI_IO_STROKE,

55.4112, 66.9552, 73.8816, 2.3088, GAMGI_IO_STROKE,

60.0288, 66.9552, 73.8816, 16.1616, GAMGI_IO_STROKE,

92.3520, 66.9552, 73.8816, 2.3088, GAMGI_IO_STROKE,

4.6176, 66.9552, 36.9408, 66.9552, GAMGI_IO_STROKE,

78.4992, 66.9552, 106.2048, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 120 x strokes: 7 *
 **************************/

18.4704, 66.9552, 69.2640, 2.3088, GAMGI_IO_STROKE,

23.0880, 66.9552, 73.8816, 2.3088, GAMGI_IO_STROKE,

73.8816, 66.9552, 18.4704, 2.3088, GAMGI_IO_STROKE,

9.2352, 66.9552, 36.9408, 66.9552, GAMGI_IO_STROKE,

55.4112, 66.9552, 83.1168, 66.9552, GAMGI_IO_STROKE,

9.2352, 2.3088, 36.9408, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 83.1168, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 121 y strokes: 5 *
 **************************/

18.4704, 66.9552, 46.1760, 2.3088, GAMGI_IO_STROKE,

23.0880, 66.9552, 46.1760, 11.5440, GAMGI_IO_STROKE,

73.8816, 66.9552, 46.1760, 2.3088, 36.9408, -16.1616, 27.7056, -25.3968, 18.4704, -30.0144, 13.8528, -30.0144, 9.2352, -25.3968, 13.8528, -20.7792, 18.4704, -25.3968, GAMGI_IO_STROKE,

9.2352, 66.9552, 36.9408, 66.9552, GAMGI_IO_STROKE,

55.4112, 66.9552, 83.1168, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 122 z strokes: 4 *
 **************************/

64.6464, 66.9552, 13.8528, 2.3088, GAMGI_IO_STROKE,

69.2640, 66.9552, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 66.9552, 13.8528, 48.4848, 13.8528, 66.9552, 69.2640, 66.9552, GAMGI_IO_STROKE,

13.8528, 2.3088, 69.2640, 2.3088, 69.2640, 20.7792, 64.6464, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 123 { strokes: 3 *
 **************************/

46.1760, 117.7488, 32.3232, 103.8960, 27.7056, 90.0432, 27.7056, 80.8080, 32.3232, 66.9552, 41.5584, 57.7200, 41.5584, 53.1024, 23.0880, 43.8672, 41.5584, 34.6320, 41.5584, 30.0144, 32.3232, 20.7792, 27.7056, 6.9264, 27.7056, -2.3088, 32.3232, -16.1616, 46.1760, -30.0144, GAMGI_IO_STROKE,

36.9408, 108.5136, 32.3232, 94.6608, 32.3232, 76.1904, 36.9408, 62.3376, GAMGI_IO_STROKE,

36.9408, 25.3968, 32.3232, 11.5440, 32.3232, -6.9264, 36.9408, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 124 | strokes: 1 *
 **************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 125 } strokes: 3 *
 **************************/

23.0880, 117.7488, 36.9408, 103.8960, 41.5584, 90.0432, 41.5584, 80.8080, 36.9408, 66.9552, 27.7056, 57.7200, 27.7056, 53.1024, 46.1760, 43.8672, 27.7056, 34.6320, 27.7056, 30.0144, 36.9408, 20.7792, 41.5584, 6.9264, 41.5584, -2.3088, 36.9408, -16.1616, 23.0880, -30.0144, GAMGI_IO_STROKE,

32.3232, 108.5136, 36.9408, 94.6608, 36.9408, 76.1904, 32.3232, 62.3376, GAMGI_IO_STROKE,

32.3232, 25.3968, 36.9408, 11.5440, 36.9408, -6.9264, 32.3232, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 126 ~ strokes: 2 *
 **************************/

13.8528, 30.0144, 13.8528, 39.2496, 18.4704, 53.1024, 27.7056, 57.7200, 36.9408, 57.7200, 46.1760, 53.1024, 64.6464, 39.2496, 73.8816, 34.6320, 83.1168, 34.6320, 92.3520, 39.2496, 96.9696, 48.4848, GAMGI_IO_STROKE,

13.8528, 39.2496, 18.4704, 48.4848, 27.7056, 53.1024, 36.9408, 53.1024, 46.1760, 48.4848, 64.6464, 34.6320, 73.8816, 30.0144, 83.1168, 30.0144, 92.3520, 34.6320, 96.9696, 48.4848, 96.9696, 57.7200, GAMGI_IO_CHAR,

};

const float gamgi_io_font_hershey_serif_bold_points[GAMGI_IO_POINTS_SERIF_BOLD] = {

/***************
 * bottom, top *
 ***************/

-32.3232, 120.0576,

/**************
 * char 32-40 *
 **************/

73.8816, 50.7936, 83.1168, 106.2048, 92.3520, 110.8224, 120.0576, 50.7936, 64.6464, 

/**************
 * char 41-50 *
 **************/

64.6464, 73.8816, 115.4400, 50.7936, 115.4400, 50.7936, 106.2048, 92.3520, 92.3520, 92.3520, 

/**************
 * char 51-60 *
 **************/

92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 50.7936, 50.7936, 110.8224, 

/**************
 * char 61-70 *
 **************/

115.4400, 110.8224, 87.7344, 124.6752, 92.3520, 101.5872, 96.9696, 101.5872, 96.9696, 92.3520, 

/**************
 * char 71-80 *
 **************/

106.2048, 110.8224, 55.4112, 73.8816, 101.5872, 83.1168, 120.0576, 110.8224, 101.5872, 101.5872, 

/**************
 * char 81-90 *
 **************/

101.5872, 101.5872, 92.3520, 92.3520, 110.8224, 92.3520, 110.8224, 92.3520, 101.5872, 92.3520, 

/***************
 * char 91-100 *
 ***************/

64.6464, 106.2048, 64.6464, 73.8816, 101.5872, 50.7936, 92.3520, 96.9696, 87.7344, 96.9696, 

/****************
 * char 101-110 *
 ****************/

87.7344, 64.6464, 87.7344, 106.2048, 55.4112, 60.0288, 101.5872, 55.4112, 156.9984, 106.2048, 

/****************
 * char 111-120 *
 ****************/

92.3520, 96.9696, 92.3520, 78.4992, 78.4992, 69.2640, 106.2048, 83.1168, 110.8224, 92.3520, 

/****************
 * char 121-126 *
 ****************/

87.7344, 83.1168, 69.2640, 41.5584, 69.2640, 110.8224, 

/*************************
 * char: 32   strokes: 0 *
 *************************/

GAMGI_IO_CHAR,

/*************************
 * char: 33 ! strokes: 6 *
 *************************/

23.0880, 99.2784, 18.4704, 94.6608, 18.4704, 85.4256, 23.0880, 48.4848, GAMGI_IO_STROKE,

23.0880, 99.2784, 23.0880, 34.6320, 27.7056, 34.6320, GAMGI_IO_STROKE,

23.0880, 99.2784, 27.7056, 99.2784, 27.7056, 34.6320, GAMGI_IO_STROKE,

27.7056, 99.2784, 32.3232, 94.6608, 32.3232, 85.4256, 27.7056, 48.4848, GAMGI_IO_STROKE,

23.0880, 16.1616, 18.4704, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 2.3088, 32.3232, 6.9264, 32.3232, 11.5440, 27.7056, 16.1616, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 34 " strokes: 6 *
 *************************/

23.0880, 99.2784, 18.4704, 94.6608, 18.4704, 66.9552, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 66.9552, GAMGI_IO_STROKE,

23.0880, 99.2784, 27.7056, 94.6608, 18.4704, 66.9552, GAMGI_IO_STROKE,

64.6464, 99.2784, 60.0288, 94.6608, 60.0288, 66.9552, GAMGI_IO_STROKE,

64.6464, 94.6608, 60.0288, 66.9552, GAMGI_IO_STROKE,

64.6464, 99.2784, 69.2640, 94.6608, 60.0288, 66.9552, GAMGI_IO_CHAR,

/*************************
 * char: 35 # strokes: 8 *
 *************************/

36.9408, 99.2784, 36.9408, -30.0144, 41.5584, -30.0144, GAMGI_IO_STROKE,

36.9408, 99.2784, 41.5584, 99.2784, 41.5584, -30.0144, GAMGI_IO_STROKE,

64.6464, 99.2784, 64.6464, -30.0144, 69.2640, -30.0144, GAMGI_IO_STROKE,

64.6464, 99.2784, 69.2640, 99.2784, 69.2640, -30.0144, GAMGI_IO_STROKE,

13.8528, 53.1024, 92.3520, 53.1024, 92.3520, 48.4848, GAMGI_IO_STROKE,

13.8528, 53.1024, 13.8528, 48.4848, 92.3520, 48.4848, GAMGI_IO_STROKE,

13.8528, 20.7792, 92.3520, 20.7792, 92.3520, 16.1616, GAMGI_IO_STROKE,

13.8528, 20.7792, 13.8528, 16.1616, 92.3520, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 36 $ strokes: 5 *
 *************************/

36.9408, 117.7488, 36.9408, -16.1616, GAMGI_IO_STROKE,

55.4112, 117.7488, 55.4112, -16.1616, GAMGI_IO_STROKE,

73.8816, 76.1904, 73.8816, 80.8080, 69.2640, 80.8080, 69.2640, 71.5728, 78.4992, 71.5728, 78.4992, 80.8080, 73.8816, 90.0432, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, 23.0880, 94.6608, 13.8528, 85.4256, 13.8528, 71.5728, 18.4704, 62.3376, 32.3232, 53.1024, 60.0288, 43.8672, 69.2640, 39.2496, 73.8816, 30.0144, 73.8816, 16.1616, 69.2640, 6.9264, GAMGI_IO_STROKE,

18.4704, 71.5728, 23.0880, 62.3376, 32.3232, 57.7200, 60.0288, 48.4848, 69.2640, 43.8672, 73.8816, 34.6320, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 76.1904, 23.0880, 66.9552, 32.3232, 62.3376, 60.0288, 53.1024, 73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 20.7792, 73.8816, 11.5440, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 30.0144, 23.0880, 30.0144, 23.0880, 20.7792, 18.4704, 20.7792, 18.4704, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 37 % strokes: 12 *
 *************************/

96.9696, 99.2784, 87.7344, 94.6608, 73.8816, 90.0432, 60.0288, 90.0432, 46.1760, 94.6608, 36.9408, 99.2784, 27.7056, 99.2784, 18.4704, 94.6608, 13.8528, 85.4256, 13.8528, 76.1904, 23.0880, 66.9552, 32.3232, 66.9552, 41.5584, 71.5728, 46.1760, 80.8080, 46.1760, 90.0432, 36.9408, 99.2784, GAMGI_IO_STROKE,

96.9696, 99.2784, 9.2352, 2.3088, GAMGI_IO_STROKE,

96.9696, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

96.9696, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

87.7344, 34.6320, 78.4992, 34.6320, 69.2640, 30.0144, 64.6464, 20.7792, 64.6464, 11.5440, 73.8816, 2.3088, 83.1168, 2.3088, 92.3520, 6.9264, 96.9696, 16.1616, 96.9696, 25.3968, 87.7344, 34.6320, GAMGI_IO_STROKE,

41.5584, 94.6608, 27.7056, 99.2784, 13.8528, 85.4256, 18.4704, 71.5728, 32.3232, 66.9552, 46.1760, 80.8080, 41.5584, 94.6608, GAMGI_IO_STROKE,

36.9408, 99.2784, 18.4704, 94.6608, 13.8528, 76.1904, GAMGI_IO_STROKE,

23.0880, 66.9552, 41.5584, 71.5728, 46.1760, 90.0432, GAMGI_IO_STROKE,

92.3520, 30.0144, 78.4992, 34.6320, 64.6464, 20.7792, 69.2640, 6.9264, 83.1168, 2.3088, 96.9696, 16.1616, 92.3520, 30.0144, GAMGI_IO_STROKE,

87.7344, 34.6320, 69.2640, 30.0144, 64.6464, 11.5440, GAMGI_IO_STROKE,

73.8816, 2.3088, 92.3520, 6.9264, 96.9696, 25.3968, GAMGI_IO_STROKE,

9.2352, 2.3088, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 38 & strokes: 8 *
 *************************/

101.5872, 57.7200, 101.5872, 62.3376, 96.9696, 62.3376, 96.9696, 53.1024, 106.2048, 53.1024, 106.2048, 62.3376, 101.5872, 66.9552, 96.9696, 66.9552, 92.3520, 62.3376, 87.7344, 53.1024, 78.4992, 30.0144, 69.2640, 16.1616, 60.0288, 6.9264, 50.7936, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, 18.4704, 16.1616, 18.4704, 30.0144, 23.0880, 39.2496, 50.7936, 57.7200, 60.0288, 66.9552, 64.6464, 76.1904, 64.6464, 85.4256, 60.0288, 94.6608, 50.7936, 99.2784, 41.5584, 94.6608, 36.9408, 85.4256, 36.9408, 71.5728, 41.5584, 57.7200, 50.7936, 43.8672, 69.2640, 20.7792, 83.1168, 6.9264, 92.3520, 2.3088, 101.5872, 2.3088, 106.2048, 11.5440, 106.2048, 16.1616, GAMGI_IO_STROKE,

27.7056, 6.9264, 23.0880, 16.1616, 23.0880, 30.0144, 27.7056, 39.2496, 32.3232, 43.8672, GAMGI_IO_STROKE,

60.0288, 66.9552, 64.6464, 85.4256, GAMGI_IO_STROKE,

64.6464, 76.1904, 60.0288, 94.6608, GAMGI_IO_STROKE,

41.5584, 94.6608, 36.9408, 76.1904, GAMGI_IO_STROKE,

41.5584, 62.3376, 50.7936, 48.4848, 69.2640, 25.3968, 83.1168, 11.5440, 92.3520, 6.9264, GAMGI_IO_STROKE,

41.5584, 2.3088, 32.3232, 6.9264, 27.7056, 16.1616, 27.7056, 30.0144, 32.3232, 39.2496, 50.7936, 57.7200, GAMGI_IO_STROKE,

36.9408, 85.4256, 41.5584, 66.9552, 55.4112, 48.4848, 73.8816, 25.3968, 87.7344, 11.5440, 96.9696, 6.9264, 101.5872, 6.9264, 106.2048, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 39 ' strokes: 4 *
 *************************/

32.3232, 90.0432, 27.7056, 85.4256, 23.0880, 85.4256, 18.4704, 90.0432, 18.4704, 94.6608, 23.0880, 99.2784, 27.7056, 99.2784, 32.3232, 94.6608, 32.3232, 80.8080, 27.7056, 71.5728, 18.4704, 66.9552, GAMGI_IO_STROKE,

23.0880, 94.6608, 23.0880, 90.0432, 27.7056, 90.0432, 27.7056, 94.6608, 23.0880, 94.6608, GAMGI_IO_STROKE,

27.7056, 85.4256, 32.3232, 80.8080, GAMGI_IO_STROKE,

32.3232, 90.0432, 27.7056, 71.5728, GAMGI_IO_CHAR,

/*************************
 * char: 40 ( strokes: 3 *
 *************************/

46.1760, 117.7488, 36.9408, 108.5136, 27.7056, 94.6608, 18.4704, 76.1904, 13.8528, 53.1024, 13.8528, 34.6320, 18.4704, 11.5440, 27.7056, -6.9264, 36.9408, -20.7792, 46.1760, -30.0144, GAMGI_IO_STROKE,

27.7056, 90.0432, 23.0880, 76.1904, 18.4704, 57.7200, 18.4704, 30.0144, 23.0880, 11.5440, 27.7056, -2.3088, GAMGI_IO_STROKE,

36.9408, 108.5136, 32.3232, 99.2784, 27.7056, 85.4256, 23.0880, 57.7200, 23.0880, 30.0144, 27.7056, 2.3088, 32.3232, -11.5440, 36.9408, -20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 41 ) strokes: 3 *
 *************************/

18.4704, 117.7488, 27.7056, 108.5136, 36.9408, 94.6608, 46.1760, 76.1904, 50.7936, 53.1024, 50.7936, 34.6320, 46.1760, 11.5440, 36.9408, -6.9264, 27.7056, -20.7792, 18.4704, -30.0144, GAMGI_IO_STROKE,

36.9408, 90.0432, 41.5584, 76.1904, 46.1760, 57.7200, 46.1760, 30.0144, 41.5584, 11.5440, 36.9408, -2.3088, GAMGI_IO_STROKE,

27.7056, 108.5136, 32.3232, 99.2784, 36.9408, 85.4256, 41.5584, 57.7200, 41.5584, 30.0144, 36.9408, 2.3088, 32.3232, -11.5440, 27.7056, -20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 42 * strokes: 9 *
 *************************/

36.9408, 99.2784, 32.3232, 94.6608, 41.5584, 48.4848, 36.9408, 43.8672, GAMGI_IO_STROKE,

36.9408, 99.2784, 36.9408, 43.8672, GAMGI_IO_STROKE,

36.9408, 99.2784, 41.5584, 94.6608, 32.3232, 48.4848, 36.9408, 43.8672, GAMGI_IO_STROKE,

13.8528, 85.4256, 18.4704, 85.4256, 55.4112, 57.7200, 60.0288, 57.7200, GAMGI_IO_STROKE,

13.8528, 85.4256, 60.0288, 57.7200, GAMGI_IO_STROKE,

13.8528, 85.4256, 13.8528, 80.8080, 60.0288, 62.3376, 60.0288, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 55.4112, 85.4256, 18.4704, 57.7200, 13.8528, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 13.8528, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 60.0288, 80.8080, 13.8528, 62.3376, 13.8528, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 43 + strokes: 4 *
 *************************/

55.4112, 85.4256, 55.4112, 6.9264, 60.0288, 6.9264, GAMGI_IO_STROKE,

55.4112, 85.4256, 60.0288, 85.4256, 60.0288, 6.9264, GAMGI_IO_STROKE,

18.4704, 48.4848, 96.9696, 48.4848, 96.9696, 43.8672, GAMGI_IO_STROKE,

18.4704, 48.4848, 18.4704, 43.8672, 96.9696, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 44 , strokes: 4 *
 *************************/

32.3232, 6.9264, 27.7056, 2.3088, 23.0880, 2.3088, 18.4704, 6.9264, 18.4704, 11.5440, 23.0880, 16.1616, 27.7056, 16.1616, 32.3232, 11.5440, 32.3232, -2.3088, 27.7056, -11.5440, 18.4704, -16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_STROKE,

27.7056, 2.3088, 32.3232, -2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 27.7056, -11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 45 - strokes: 2 *
 *************************/

18.4704, 48.4848, 96.9696, 48.4848, 96.9696, 43.8672, GAMGI_IO_STROKE,

18.4704, 48.4848, 18.4704, 43.8672, 96.9696, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 46 . strokes: 2 *
 *************************/

23.0880, 16.1616, 18.4704, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 2.3088, 32.3232, 6.9264, 32.3232, 11.5440, 27.7056, 16.1616, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 47 / strokes: 2 *
 *************************/

92.3520, 117.7488, 9.2352, -30.0144, 13.8528, -30.0144, GAMGI_IO_STROKE,

92.3520, 117.7488, 96.9696, 117.7488, 13.8528, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 48 0 strokes: 5 *
 *************************/

41.5584, 99.2784, 27.7056, 94.6608, 18.4704, 80.8080, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 20.7792, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 20.7792, 78.4992, 43.8672, 78.4992, 57.7200, 73.8816, 80.8080, 64.6464, 94.6608, 50.7936, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

27.7056, 90.0432, 23.0880, 80.8080, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 20.7792, 27.7056, 11.5440, GAMGI_IO_STROKE,

64.6464, 11.5440, 69.2640, 20.7792, 73.8816, 39.2496, 73.8816, 62.3376, 69.2640, 80.8080, 64.6464, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, 27.7056, 85.4256, 23.0880, 62.3376, 23.0880, 39.2496, 27.7056, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 16.1616, 69.2640, 39.2496, 69.2640, 62.3376, 64.6464, 85.4256, 60.0288, 94.6608, 50.7936, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 49 1 strokes: 9 *
 *************************/

41.5584, 90.0432, 41.5584, 2.3088, GAMGI_IO_STROKE,

46.1760, 90.0432, 46.1760, 6.9264, GAMGI_IO_STROKE,

50.7936, 99.2784, 50.7936, 2.3088, GAMGI_IO_STROKE,

50.7936, 99.2784, 36.9408, 85.4256, 27.7056, 80.8080, GAMGI_IO_STROKE,

23.0880, 2.3088, 69.2640, 2.3088, GAMGI_IO_STROKE,

41.5584, 6.9264, 32.3232, 2.3088, GAMGI_IO_STROKE,

41.5584, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

50.7936, 11.5440, 55.4112, 2.3088, GAMGI_IO_STROKE,

50.7936, 6.9264, 60.0288, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 50 2 strokes: 7 *
 *************************/

18.4704, 80.8080, 18.4704, 76.1904, 23.0880, 76.1904, 23.0880, 80.8080, 18.4704, 80.8080, GAMGI_IO_STROKE,

18.4704, 85.4256, 23.0880, 85.4256, 27.7056, 80.8080, 27.7056, 76.1904, 23.0880, 71.5728, 18.4704, 71.5728, 13.8528, 76.1904, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 36.9408, 99.2784, 55.4112, 99.2784, 69.2640, 94.6608, 73.8816, 90.0432, 78.4992, 80.8080, 78.4992, 71.5728, 73.8816, 62.3376, 60.0288, 53.1024, 36.9408, 43.8672, 27.7056, 39.2496, 18.4704, 30.0144, 13.8528, 16.1616, 13.8528, 2.3088, GAMGI_IO_STROKE,

69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 71.5728, 69.2640, 62.3376, GAMGI_IO_STROKE,

55.4112, 99.2784, 64.6464, 94.6608, 69.2640, 80.8080, 69.2640, 71.5728, 64.6464, 62.3376, 55.4112, 53.1024, 36.9408, 43.8672, GAMGI_IO_STROKE,

13.8528, 11.5440, 18.4704, 16.1616, 27.7056, 16.1616, 50.7936, 11.5440, 69.2640, 11.5440, 78.4992, 16.1616, GAMGI_IO_STROKE,

27.7056, 16.1616, 50.7936, 6.9264, 69.2640, 6.9264, 73.8816, 11.5440, GAMGI_IO_STROKE,

27.7056, 16.1616, 50.7936, 2.3088, 69.2640, 2.3088, 73.8816, 6.9264, 78.4992, 16.1616, 78.4992, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 51 3 strokes: 8 *
 *************************/

18.4704, 80.8080, 18.4704, 76.1904, 23.0880, 76.1904, 23.0880, 80.8080, 18.4704, 80.8080, GAMGI_IO_STROKE,

18.4704, 85.4256, 23.0880, 85.4256, 27.7056, 80.8080, 27.7056, 76.1904, 23.0880, 71.5728, 18.4704, 71.5728, 13.8528, 76.1904, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 36.9408, 99.2784, 55.4112, 99.2784, 69.2640, 94.6608, 73.8816, 85.4256, 73.8816, 71.5728, 69.2640, 62.3376, 55.4112, 57.7200, GAMGI_IO_STROKE,

64.6464, 94.6608, 69.2640, 85.4256, 69.2640, 71.5728, 64.6464, 62.3376, GAMGI_IO_STROKE,

50.7936, 99.2784, 60.0288, 94.6608, 64.6464, 85.4256, 64.6464, 71.5728, 60.0288, 62.3376, 50.7936, 57.7200, GAMGI_IO_STROKE,

41.5584, 57.7200, 55.4112, 57.7200, 64.6464, 53.1024, 73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 20.7792, 73.8816, 11.5440, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 25.3968, 18.4704, 30.0144, 23.0880, 30.0144, 27.7056, 25.3968, 27.7056, 20.7792, 23.0880, 16.1616, 18.4704, 16.1616, GAMGI_IO_STROKE,

69.2640, 43.8672, 73.8816, 34.6320, 73.8816, 20.7792, 69.2640, 11.5440, GAMGI_IO_STROKE,

50.7936, 57.7200, 60.0288, 53.1024, 64.6464, 48.4848, 69.2640, 34.6320, 69.2640, 20.7792, 64.6464, 6.9264, 55.4112, 2.3088, GAMGI_IO_STROKE,

18.4704, 25.3968, 18.4704, 20.7792, 23.0880, 20.7792, 23.0880, 25.3968, 18.4704, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 52 4 strokes: 9 *
 *************************/

50.7936, 85.4256, 50.7936, 2.3088, GAMGI_IO_STROKE,

55.4112, 90.0432, 55.4112, 6.9264, GAMGI_IO_STROKE,

60.0288, 99.2784, 60.0288, 2.3088, GAMGI_IO_STROKE,

60.0288, 99.2784, 9.2352, 30.0144, 83.1168, 30.0144, GAMGI_IO_STROKE,

36.9408, 2.3088, 73.8816, 2.3088, GAMGI_IO_STROKE,

50.7936, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 11.5440, 46.1760, 2.3088, GAMGI_IO_STROKE,

60.0288, 11.5440, 64.6464, 2.3088, GAMGI_IO_STROKE,

60.0288, 6.9264, 69.2640, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 53 5 strokes: 7 *
 *************************/

23.0880, 99.2784, 13.8528, 53.1024, 23.0880, 62.3376, 36.9408, 66.9552, 50.7936, 66.9552, 64.6464, 62.3376, 73.8816, 53.1024, 78.4992, 39.2496, 78.4992, 30.0144, 73.8816, 16.1616, 64.6464, 6.9264, 50.7936, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 25.3968, 18.4704, 30.0144, 23.0880, 30.0144, 27.7056, 25.3968, 27.7056, 20.7792, 23.0880, 16.1616, 18.4704, 16.1616, GAMGI_IO_STROKE,

69.2640, 53.1024, 73.8816, 43.8672, 73.8816, 25.3968, 69.2640, 16.1616, GAMGI_IO_STROKE,

50.7936, 66.9552, 60.0288, 62.3376, 64.6464, 57.7200, 69.2640, 43.8672, 69.2640, 25.3968, 64.6464, 11.5440, 60.0288, 6.9264, 50.7936, 2.3088, GAMGI_IO_STROKE,

18.4704, 25.3968, 18.4704, 20.7792, 23.0880, 20.7792, 23.0880, 25.3968, 18.4704, 25.3968, GAMGI_IO_STROKE,

23.0880, 99.2784, 69.2640, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 60.0288, 94.6608, GAMGI_IO_STROKE,

23.0880, 90.0432, 41.5584, 90.0432, 60.0288, 94.6608, 69.2640, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 54 6 strokes: 6 *
 *************************/

64.6464, 85.4256, 64.6464, 80.8080, 69.2640, 80.8080, 69.2640, 85.4256, 64.6464, 85.4256, GAMGI_IO_STROKE,

69.2640, 90.0432, 64.6464, 90.0432, 60.0288, 85.4256, 60.0288, 80.8080, 64.6464, 76.1904, 69.2640, 76.1904, 73.8816, 80.8080, 73.8816, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 57.7200, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 30.0144, 78.4992, 34.6320, 73.8816, 48.4848, 64.6464, 57.7200, 50.7936, 62.3376, 41.5584, 62.3376, 32.3232, 57.7200, 27.7056, 53.1024, 23.0880, 43.8672, GAMGI_IO_STROKE,

27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 57.7200, 18.4704, 30.0144, 23.0880, 16.1616, 27.7056, 11.5440, GAMGI_IO_STROKE,

69.2640, 16.1616, 73.8816, 25.3968, 73.8816, 39.2496, 69.2640, 48.4848, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 32.3232, 90.0432, 27.7056, 80.8080, 23.0880, 62.3376, 23.0880, 30.0144, 27.7056, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 11.5440, 69.2640, 25.3968, 69.2640, 39.2496, 64.6464, 53.1024, 60.0288, 57.7200, 50.7936, 62.3376, GAMGI_IO_CHAR,

/*************************
 * char: 55 7 strokes: 7 *
 *************************/

13.8528, 99.2784, 13.8528, 71.5728, GAMGI_IO_STROKE,

78.4992, 99.2784, 78.4992, 85.4256, 73.8816, 71.5728, 55.4112, 48.4848, 50.7936, 39.2496, 46.1760, 20.7792, 46.1760, 2.3088, GAMGI_IO_STROKE,

50.7936, 43.8672, 46.1760, 34.6320, 41.5584, 20.7792, 41.5584, 2.3088, GAMGI_IO_STROKE,

73.8816, 71.5728, 50.7936, 48.4848, 41.5584, 34.6320, 36.9408, 20.7792, 36.9408, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

13.8528, 80.8080, 18.4704, 90.0432, 27.7056, 99.2784, 36.9408, 99.2784, 60.0288, 85.4256, 69.2640, 85.4256, 73.8816, 90.0432, 78.4992, 99.2784, GAMGI_IO_STROKE,

23.0880, 90.0432, 27.7056, 94.6608, 36.9408, 94.6608, 46.1760, 90.0432, GAMGI_IO_STROKE,

13.8528, 80.8080, 18.4704, 85.4256, 27.7056, 90.0432, 36.9408, 90.0432, 60.0288, 85.4256, GAMGI_IO_CHAR,

/*************************
 * char: 56 8 strokes: 10 *
 *************************/

36.9408, 99.2784, 23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 71.5728, 23.0880, 62.3376, 36.9408, 57.7200, 55.4112, 57.7200, 69.2640, 62.3376, 73.8816, 71.5728, 73.8816, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, GAMGI_IO_STROKE,

27.7056, 94.6608, 23.0880, 85.4256, 23.0880, 71.5728, 27.7056, 62.3376, GAMGI_IO_STROKE,

64.6464, 62.3376, 69.2640, 71.5728, 69.2640, 85.4256, 64.6464, 94.6608, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 94.6608, 27.7056, 85.4256, 27.7056, 71.5728, 32.3232, 62.3376, 36.9408, 57.7200, GAMGI_IO_STROKE,

55.4112, 57.7200, 60.0288, 62.3376, 64.6464, 71.5728, 64.6464, 85.4256, 60.0288, 94.6608, 55.4112, 99.2784, GAMGI_IO_STROKE,

36.9408, 57.7200, 23.0880, 53.1024, 18.4704, 48.4848, 13.8528, 39.2496, 13.8528, 20.7792, 18.4704, 11.5440, 23.0880, 6.9264, 36.9408, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 73.8816, 11.5440, 78.4992, 20.7792, 78.4992, 39.2496, 73.8816, 48.4848, 69.2640, 53.1024, 55.4112, 57.7200, GAMGI_IO_STROKE,

23.0880, 48.4848, 18.4704, 39.2496, 18.4704, 20.7792, 23.0880, 11.5440, GAMGI_IO_STROKE,

69.2640, 11.5440, 73.8816, 20.7792, 73.8816, 39.2496, 69.2640, 48.4848, GAMGI_IO_STROKE,

36.9408, 57.7200, 27.7056, 53.1024, 23.0880, 39.2496, 23.0880, 20.7792, 27.7056, 6.9264, 36.9408, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 64.6464, 6.9264, 69.2640, 20.7792, 69.2640, 39.2496, 64.6464, 53.1024, 55.4112, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 57 9 strokes: 6 *
 *************************/

23.0880, 20.7792, 23.0880, 16.1616, 27.7056, 16.1616, 27.7056, 20.7792, 23.0880, 20.7792, GAMGI_IO_STROKE,

69.2640, 57.7200, 64.6464, 48.4848, 60.0288, 43.8672, 50.7936, 39.2496, 41.5584, 39.2496, 27.7056, 43.8672, 18.4704, 53.1024, 13.8528, 66.9552, 13.8528, 71.5728, 18.4704, 85.4256, 27.7056, 94.6608, 41.5584, 99.2784, 50.7936, 99.2784, 64.6464, 94.6608, 73.8816, 85.4256, 78.4992, 71.5728, 78.4992, 43.8672, 73.8816, 25.3968, 69.2640, 16.1616, 60.0288, 6.9264, 46.1760, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, 18.4704, 16.1616, 18.4704, 20.7792, 23.0880, 25.3968, 27.7056, 25.3968, 32.3232, 20.7792, 32.3232, 16.1616, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_STROKE,

23.0880, 53.1024, 18.4704, 62.3376, 18.4704, 76.1904, 23.0880, 85.4256, GAMGI_IO_STROKE,

64.6464, 90.0432, 69.2640, 85.4256, 73.8816, 71.5728, 73.8816, 43.8672, 69.2640, 25.3968, 64.6464, 16.1616, GAMGI_IO_STROKE,

41.5584, 39.2496, 32.3232, 43.8672, 27.7056, 48.4848, 23.0880, 62.3376, 23.0880, 76.1904, 27.7056, 90.0432, 32.3232, 94.6608, 41.5584, 99.2784, GAMGI_IO_STROKE,

50.7936, 99.2784, 60.0288, 94.6608, 64.6464, 85.4256, 69.2640, 71.5728, 69.2640, 39.2496, 64.6464, 20.7792, 60.0288, 11.5440, 55.4112, 6.9264, 46.1760, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 58 : strokes: 4 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 18.4704, 57.7200, 23.0880, 53.1024, 27.7056, 53.1024, 32.3232, 57.7200, 32.3232, 62.3376, 27.7056, 66.9552, 23.0880, 66.9552, GAMGI_IO_STROKE,

23.0880, 62.3376, 23.0880, 57.7200, 27.7056, 57.7200, 27.7056, 62.3376, 23.0880, 62.3376, GAMGI_IO_STROKE,

23.0880, 16.1616, 18.4704, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 2.3088, 32.3232, 6.9264, 32.3232, 11.5440, 27.7056, 16.1616, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 59 ; strokes: 6 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 18.4704, 57.7200, 23.0880, 53.1024, 27.7056, 53.1024, 32.3232, 57.7200, 32.3232, 62.3376, 27.7056, 66.9552, 23.0880, 66.9552, GAMGI_IO_STROKE,

23.0880, 62.3376, 23.0880, 57.7200, 27.7056, 57.7200, 27.7056, 62.3376, 23.0880, 62.3376, GAMGI_IO_STROKE,

32.3232, 6.9264, 27.7056, 2.3088, 23.0880, 2.3088, 18.4704, 6.9264, 18.4704, 11.5440, 23.0880, 16.1616, 27.7056, 16.1616, 32.3232, 11.5440, 32.3232, -2.3088, 27.7056, -11.5440, 18.4704, -16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_STROKE,

27.7056, 2.3088, 32.3232, -2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 27.7056, -11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 60 < strokes: 2 *
 *************************/

92.3520, 85.4256, 18.4704, 43.8672, 92.3520, 2.3088, GAMGI_IO_STROKE,

92.3520, 85.4256, 92.3520, 80.8080, 27.7056, 43.8672, 92.3520, 6.9264, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 61 = strokes: 4 *
 *************************/

18.4704, 66.9552, 96.9696, 66.9552, 96.9696, 62.3376, GAMGI_IO_STROKE,

18.4704, 66.9552, 18.4704, 62.3376, 96.9696, 62.3376, GAMGI_IO_STROKE,

18.4704, 30.0144, 96.9696, 30.0144, 96.9696, 25.3968, GAMGI_IO_STROKE,

18.4704, 30.0144, 18.4704, 25.3968, 96.9696, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 62 > strokes: 2 *
 *************************/

18.4704, 85.4256, 92.3520, 43.8672, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 85.4256, 18.4704, 80.8080, 83.1168, 43.8672, 18.4704, 6.9264, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 63 ? strokes: 6 *
 *************************/

18.4704, 76.1904, 18.4704, 80.8080, 23.0880, 80.8080, 23.0880, 71.5728, 13.8528, 71.5728, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 32.3232, 99.2784, 50.7936, 99.2784, 64.6464, 94.6608, 69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 71.5728, 69.2640, 62.3376, 64.6464, 57.7200, 46.1760, 48.4848, GAMGI_IO_STROKE,

64.6464, 90.0432, 69.2640, 85.4256, 69.2640, 66.9552, 64.6464, 62.3376, GAMGI_IO_STROKE,

50.7936, 99.2784, 60.0288, 94.6608, 64.6464, 85.4256, 64.6464, 66.9552, 60.0288, 57.7200, 55.4112, 53.1024, GAMGI_IO_STROKE,

41.5584, 48.4848, 41.5584, 34.6320, 46.1760, 34.6320, 46.1760, 48.4848, 41.5584, 48.4848, GAMGI_IO_STROKE,

41.5584, 16.1616, 36.9408, 11.5440, 36.9408, 6.9264, 41.5584, 2.3088, 46.1760, 2.3088, 50.7936, 6.9264, 50.7936, 11.5440, 46.1760, 16.1616, 41.5584, 16.1616, GAMGI_IO_STROKE,

41.5584, 11.5440, 41.5584, 6.9264, 46.1760, 6.9264, 46.1760, 11.5440, 41.5584, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 64 @ strokes: 6 *
 *************************/

78.4992, 62.3376, 73.8816, 71.5728, 64.6464, 76.1904, 55.4112, 76.1904, 46.1760, 71.5728, 41.5584, 66.9552, 36.9408, 57.7200, 36.9408, 43.8672, 41.5584, 34.6320, 46.1760, 30.0144, 55.4112, 25.3968, 64.6464, 25.3968, 73.8816, 30.0144, 78.4992, 39.2496, GAMGI_IO_STROKE,

46.1760, 66.9552, 41.5584, 57.7200, 41.5584, 43.8672, 46.1760, 34.6320, GAMGI_IO_STROKE,

55.4112, 76.1904, 50.7936, 71.5728, 46.1760, 57.7200, 46.1760, 43.8672, 50.7936, 30.0144, 55.4112, 25.3968, GAMGI_IO_STROKE,

78.4992, 76.1904, 78.4992, 39.2496, 83.1168, 30.0144, 92.3520, 25.3968, 96.9696, 25.3968, 106.2048, 30.0144, 110.8224, 43.8672, 110.8224, 57.7200, 106.2048, 71.5728, 101.5872, 80.8080, 92.3520, 90.0432, 83.1168, 94.6608, 69.2640, 99.2784, 55.4112, 99.2784, 41.5584, 94.6608, 32.3232, 90.0432, 23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 55.4112, 2.3088, 69.2640, 2.3088, 83.1168, 6.9264, 92.3520, 11.5440, 87.7344, 11.5440, 83.1168, 6.9264, GAMGI_IO_STROKE,

83.1168, 71.5728, 83.1168, 39.2496, 87.7344, 30.0144, GAMGI_IO_STROKE,

78.4992, 76.1904, 87.7344, 76.1904, 87.7344, 39.2496, 92.3520, 30.0144, 96.9696, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 65 A strokes: 12 *
 *************************/

46.1760, 99.2784, 13.8528, 6.9264, GAMGI_IO_STROKE,

41.5584, 85.4256, 69.2640, 2.3088, GAMGI_IO_STROKE,

46.1760, 85.4256, 73.8816, 2.3088, GAMGI_IO_STROKE,

46.1760, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

23.0880, 30.0144, 64.6464, 30.0144, GAMGI_IO_STROKE,

4.6176, 2.3088, 32.3232, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 87.7344, 2.3088, GAMGI_IO_STROKE,

13.8528, 6.9264, 9.2352, 2.3088, GAMGI_IO_STROKE,

13.8528, 6.9264, 23.0880, 2.3088, GAMGI_IO_STROKE,

69.2640, 6.9264, 60.0288, 2.3088, GAMGI_IO_STROKE,

69.2640, 11.5440, 64.6464, 2.3088, GAMGI_IO_STROKE,

73.8816, 11.5440, 83.1168, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 66 B strokes: 17 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 64.6464, 99.2784, 78.4992, 94.6608, 83.1168, 90.0432, 87.7344, 80.8080, 87.7344, 71.5728, 83.1168, 62.3376, 78.4992, 57.7200, 64.6464, 53.1024, GAMGI_IO_STROKE,

78.4992, 90.0432, 83.1168, 80.8080, 83.1168, 71.5728, 78.4992, 62.3376, GAMGI_IO_STROKE,

64.6464, 99.2784, 73.8816, 94.6608, 78.4992, 85.4256, 78.4992, 66.9552, 73.8816, 57.7200, 64.6464, 53.1024, GAMGI_IO_STROKE,

32.3232, 53.1024, 64.6464, 53.1024, 78.4992, 48.4848, 83.1168, 43.8672, 87.7344, 34.6320, 87.7344, 20.7792, 83.1168, 11.5440, 78.4992, 6.9264, 64.6464, 2.3088, 9.2352, 2.3088, GAMGI_IO_STROKE,

78.4992, 43.8672, 83.1168, 34.6320, 83.1168, 20.7792, 78.4992, 11.5440, GAMGI_IO_STROKE,

64.6464, 53.1024, 73.8816, 48.4848, 78.4992, 39.2496, 78.4992, 16.1616, 73.8816, 6.9264, 64.6464, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 67 C strokes: 3 *
 *************************/

78.4992, 85.4256, 83.1168, 99.2784, 83.1168, 71.5728, 78.4992, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 62.3376, 13.8528, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, GAMGI_IO_STROKE,

27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 25.3968, 27.7056, 16.1616, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 27.7056, 80.8080, 23.0880, 62.3376, 23.0880, 39.2496, 27.7056, 20.7792, 36.9408, 6.9264, 46.1760, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 68 D strokes: 14 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 55.4112, 99.2784, 69.2640, 94.6608, 78.4992, 85.4256, 83.1168, 76.1904, 87.7344, 62.3376, 87.7344, 39.2496, 83.1168, 25.3968, 78.4992, 16.1616, 69.2640, 6.9264, 55.4112, 2.3088, 9.2352, 2.3088, GAMGI_IO_STROKE,

73.8816, 85.4256, 78.4992, 76.1904, 83.1168, 62.3376, 83.1168, 39.2496, 78.4992, 25.3968, 73.8816, 16.1616, GAMGI_IO_STROKE,

55.4112, 99.2784, 64.6464, 94.6608, 73.8816, 80.8080, 78.4992, 62.3376, 78.4992, 39.2496, 73.8816, 20.7792, 64.6464, 6.9264, 55.4112, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 69 E strokes: 26 *
 **************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 83.1168, 99.2784, 83.1168, 71.5728, GAMGI_IO_STROKE,

32.3232, 53.1024, 60.0288, 53.1024, GAMGI_IO_STROKE,

60.0288, 71.5728, 60.0288, 34.6320, GAMGI_IO_STROKE,

9.2352, 2.3088, 83.1168, 2.3088, 83.1168, 30.0144, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

60.0288, 99.2784, 83.1168, 94.6608, GAMGI_IO_STROKE,

69.2640, 99.2784, 83.1168, 90.0432, GAMGI_IO_STROKE,

73.8816, 99.2784, 83.1168, 85.4256, GAMGI_IO_STROKE,

78.4992, 99.2784, 83.1168, 71.5728, GAMGI_IO_STROKE,

60.0288, 71.5728, 55.4112, 53.1024, 60.0288, 34.6320, GAMGI_IO_STROKE,

60.0288, 62.3376, 50.7936, 53.1024, 60.0288, 43.8672, GAMGI_IO_STROKE,

60.0288, 57.7200, 41.5584, 53.1024, 60.0288, 48.4848, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

60.0288, 2.3088, 83.1168, 6.9264, GAMGI_IO_STROKE,

69.2640, 2.3088, 83.1168, 11.5440, GAMGI_IO_STROKE,

73.8816, 2.3088, 83.1168, 16.1616, GAMGI_IO_STROKE,

78.4992, 2.3088, 83.1168, 30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 70 F strokes: 22 *
 **************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 83.1168, 99.2784, 83.1168, 71.5728, GAMGI_IO_STROKE,

32.3232, 53.1024, 60.0288, 53.1024, GAMGI_IO_STROKE,

60.0288, 71.5728, 60.0288, 34.6320, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

60.0288, 99.2784, 83.1168, 94.6608, GAMGI_IO_STROKE,

69.2640, 99.2784, 83.1168, 90.0432, GAMGI_IO_STROKE,

73.8816, 99.2784, 83.1168, 85.4256, GAMGI_IO_STROKE,

78.4992, 99.2784, 83.1168, 71.5728, GAMGI_IO_STROKE,

60.0288, 71.5728, 55.4112, 53.1024, 60.0288, 34.6320, GAMGI_IO_STROKE,

60.0288, 62.3376, 50.7936, 53.1024, 60.0288, 43.8672, GAMGI_IO_STROKE,

60.0288, 57.7200, 41.5584, 53.1024, 60.0288, 48.4848, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 71 G strokes: 10 *
 **************************/

78.4992, 85.4256, 83.1168, 99.2784, 83.1168, 71.5728, 78.4992, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 62.3376, 13.8528, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 78.4992, 6.9264, 83.1168, 2.3088, 83.1168, 39.2496, GAMGI_IO_STROKE,

27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 25.3968, 27.7056, 16.1616, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 27.7056, 80.8080, 23.0880, 62.3376, 23.0880, 39.2496, 27.7056, 20.7792, 36.9408, 6.9264, 46.1760, 2.3088, GAMGI_IO_STROKE,

78.4992, 34.6320, 78.4992, 11.5440, GAMGI_IO_STROKE,

73.8816, 39.2496, 73.8816, 11.5440, 69.2640, 6.9264, GAMGI_IO_STROKE,

60.0288, 39.2496, 96.9696, 39.2496, GAMGI_IO_STROKE,

64.6464, 39.2496, 73.8816, 34.6320, GAMGI_IO_STROKE,

69.2640, 39.2496, 73.8816, 30.0144, GAMGI_IO_STROKE,

87.7344, 39.2496, 83.1168, 30.0144, GAMGI_IO_STROKE,

92.3520, 39.2496, 83.1168, 34.6320, GAMGI_IO_CHAR,

/**************************
 * char: 72 H strokes: 27 *
 **************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

78.4992, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

83.1168, 94.6608, 83.1168, 6.9264, GAMGI_IO_STROKE,

87.7344, 99.2784, 87.7344, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 46.1760, 99.2784, GAMGI_IO_STROKE,

64.6464, 99.2784, 101.5872, 99.2784, GAMGI_IO_STROKE,

32.3232, 53.1024, 78.4992, 53.1024, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

64.6464, 2.3088, 101.5872, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

69.2640, 99.2784, 78.4992, 94.6608, GAMGI_IO_STROKE,

73.8816, 99.2784, 78.4992, 90.0432, GAMGI_IO_STROKE,

92.3520, 99.2784, 87.7344, 90.0432, GAMGI_IO_STROKE,

96.9696, 99.2784, 87.7344, 94.6608, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

78.4992, 6.9264, 69.2640, 2.3088, GAMGI_IO_STROKE,

78.4992, 11.5440, 73.8816, 2.3088, GAMGI_IO_STROKE,

87.7344, 11.5440, 92.3520, 2.3088, GAMGI_IO_STROKE,

87.7344, 6.9264, 96.9696, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 73 I strokes: 13 *
 **************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 46.1760, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 74 J strokes: 9 *
 *************************/

41.5584, 99.2784, 41.5584, 20.7792, 36.9408, 6.9264, 32.3232, 2.3088, GAMGI_IO_STROKE,

46.1760, 94.6608, 46.1760, 20.7792, 41.5584, 6.9264, GAMGI_IO_STROKE,

50.7936, 99.2784, 50.7936, 20.7792, 46.1760, 6.9264, 32.3232, 2.3088, 23.0880, 2.3088, 13.8528, 6.9264, 9.2352, 16.1616, 9.2352, 25.3968, 13.8528, 30.0144, 18.4704, 30.0144, 23.0880, 25.3968, 23.0880, 20.7792, 18.4704, 16.1616, 13.8528, 16.1616, GAMGI_IO_STROKE,

13.8528, 25.3968, 13.8528, 20.7792, 18.4704, 20.7792, 18.4704, 25.3968, 13.8528, 25.3968, GAMGI_IO_STROKE,

27.7056, 99.2784, 64.6464, 99.2784, GAMGI_IO_STROKE,

32.3232, 99.2784, 41.5584, 94.6608, GAMGI_IO_STROKE,

36.9408, 99.2784, 41.5584, 90.0432, GAMGI_IO_STROKE,

55.4112, 99.2784, 50.7936, 90.0432, GAMGI_IO_STROKE,

60.0288, 99.2784, 50.7936, 94.6608, GAMGI_IO_CHAR,

/*************************
 * char: 75 K strokes: 23 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

83.1168, 94.6608, 32.3232, 43.8672, GAMGI_IO_STROKE,

46.1760, 53.1024, 78.4992, 2.3088, GAMGI_IO_STROKE,

50.7936, 53.1024, 83.1168, 2.3088, GAMGI_IO_STROKE,

50.7936, 62.3376, 87.7344, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 46.1760, 99.2784, GAMGI_IO_STROKE,

69.2640, 99.2784, 96.9696, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

64.6464, 2.3088, 96.9696, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

78.4992, 99.2784, 83.1168, 94.6608, GAMGI_IO_STROKE,

92.3520, 99.2784, 83.1168, 94.6608, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

78.4992, 11.5440, 69.2640, 2.3088, GAMGI_IO_STROKE,

78.4992, 11.5440, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 76 L strokes: 17 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 46.1760, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 78.4992, 2.3088, 78.4992, 30.0144, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 78.4992, 6.9264, GAMGI_IO_STROKE,

64.6464, 2.3088, 78.4992, 11.5440, GAMGI_IO_STROKE,

69.2640, 2.3088, 78.4992, 16.1616, GAMGI_IO_STROKE,

73.8816, 2.3088, 78.4992, 30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 77 M strokes: 21 *
 *************************/

23.0880, 99.2784, 23.0880, 6.9264, GAMGI_IO_STROKE,

23.0880, 99.2784, 55.4112, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 55.4112, 16.1616, GAMGI_IO_STROKE,

32.3232, 99.2784, 60.0288, 16.1616, GAMGI_IO_STROKE,

87.7344, 99.2784, 55.4112, 2.3088, GAMGI_IO_STROKE,

87.7344, 99.2784, 87.7344, 2.3088, GAMGI_IO_STROKE,

92.3520, 94.6608, 92.3520, 6.9264, GAMGI_IO_STROKE,

96.9696, 99.2784, 96.9696, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 32.3232, 99.2784, GAMGI_IO_STROKE,

87.7344, 99.2784, 110.8224, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 36.9408, 2.3088, GAMGI_IO_STROKE,

73.8816, 2.3088, 110.8224, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

101.5872, 99.2784, 96.9696, 90.0432, GAMGI_IO_STROKE,

106.2048, 99.2784, 96.9696, 94.6608, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 6.9264, 32.3232, 2.3088, GAMGI_IO_STROKE,

87.7344, 6.9264, 78.4992, 2.3088, GAMGI_IO_STROKE,

87.7344, 11.5440, 83.1168, 2.3088, GAMGI_IO_STROKE,

96.9696, 11.5440, 101.5872, 2.3088, GAMGI_IO_STROKE,

96.9696, 6.9264, 106.2048, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 78 N strokes: 13 *
 *************************/

23.0880, 99.2784, 23.0880, 6.9264, GAMGI_IO_STROKE,

23.0880, 99.2784, 87.7344, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 83.1168, 16.1616, GAMGI_IO_STROKE,

32.3232, 99.2784, 87.7344, 16.1616, GAMGI_IO_STROKE,

87.7344, 94.6608, 87.7344, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 32.3232, 99.2784, GAMGI_IO_STROKE,

73.8816, 99.2784, 101.5872, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 36.9408, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

78.4992, 99.2784, 87.7344, 94.6608, GAMGI_IO_STROKE,

96.9696, 99.2784, 87.7344, 94.6608, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 6.9264, 32.3232, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 79 O strokes: 5 *
 *************************/

46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, 87.7344, 43.8672, 87.7344, 57.7200, 83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 46.1760, 99.2784, GAMGI_IO_STROKE,

27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 25.3968, 27.7056, 16.1616, GAMGI_IO_STROKE,

73.8816, 16.1616, 78.4992, 25.3968, 83.1168, 39.2496, 83.1168, 62.3376, 78.4992, 76.1904, 73.8816, 85.4256, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 27.7056, 80.8080, 23.0880, 62.3376, 23.0880, 39.2496, 27.7056, 20.7792, 36.9408, 6.9264, 46.1760, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 64.6464, 6.9264, 73.8816, 20.7792, 78.4992, 39.2496, 78.4992, 62.3376, 73.8816, 80.8080, 64.6464, 94.6608, 55.4112, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 80 P strokes: 15 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 64.6464, 99.2784, 78.4992, 94.6608, 83.1168, 90.0432, 87.7344, 80.8080, 87.7344, 66.9552, 83.1168, 57.7200, 78.4992, 53.1024, 64.6464, 48.4848, 32.3232, 48.4848, GAMGI_IO_STROKE,

78.4992, 90.0432, 83.1168, 80.8080, 83.1168, 66.9552, 78.4992, 57.7200, GAMGI_IO_STROKE,

64.6464, 99.2784, 73.8816, 94.6608, 78.4992, 85.4256, 78.4992, 62.3376, 73.8816, 53.1024, 64.6464, 48.4848, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 81 Q strokes: 8 *
 *************************/

46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, 87.7344, 43.8672, 87.7344, 57.7200, 83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 46.1760, 99.2784, GAMGI_IO_STROKE,

27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 25.3968, 27.7056, 16.1616, GAMGI_IO_STROKE,

73.8816, 16.1616, 78.4992, 25.3968, 83.1168, 39.2496, 83.1168, 62.3376, 78.4992, 76.1904, 73.8816, 85.4256, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 27.7056, 80.8080, 23.0880, 62.3376, 23.0880, 39.2496, 27.7056, 20.7792, 36.9408, 6.9264, 46.1760, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 64.6464, 6.9264, 73.8816, 20.7792, 78.4992, 39.2496, 78.4992, 62.3376, 73.8816, 80.8080, 64.6464, 94.6608, 55.4112, 99.2784, GAMGI_IO_STROKE,

32.3232, 16.1616, 36.9408, 25.3968, 46.1760, 30.0144, 50.7936, 30.0144, 60.0288, 25.3968, 64.6464, 16.1616, 69.2640, -11.5440, 73.8816, -20.7792, 83.1168, -20.7792, 87.7344, -11.5440, 87.7344, -2.3088, GAMGI_IO_STROKE,

69.2640, -2.3088, 73.8816, -11.5440, 78.4992, -16.1616, 83.1168, -16.1616, GAMGI_IO_STROKE,

64.6464, 16.1616, 73.8816, -6.9264, 78.4992, -11.5440, 83.1168, -11.5440, 87.7344, -6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 82 R strokes: 18 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 64.6464, 99.2784, 78.4992, 94.6608, 83.1168, 90.0432, 87.7344, 80.8080, 87.7344, 71.5728, 83.1168, 62.3376, 78.4992, 57.7200, 64.6464, 53.1024, 32.3232, 53.1024, GAMGI_IO_STROKE,

78.4992, 90.0432, 83.1168, 80.8080, 83.1168, 71.5728, 78.4992, 62.3376, GAMGI_IO_STROKE,

64.6464, 99.2784, 73.8816, 94.6608, 78.4992, 85.4256, 78.4992, 66.9552, 73.8816, 57.7200, 64.6464, 53.1024, GAMGI_IO_STROKE,

50.7936, 53.1024, 60.0288, 48.4848, 64.6464, 39.2496, 73.8816, 11.5440, 78.4992, 2.3088, 87.7344, 2.3088, 92.3520, 11.5440, 92.3520, 20.7792, GAMGI_IO_STROKE,

73.8816, 20.7792, 78.4992, 11.5440, 83.1168, 6.9264, 87.7344, 6.9264, GAMGI_IO_STROKE,

60.0288, 48.4848, 64.6464, 43.8672, 78.4992, 16.1616, 83.1168, 11.5440, 87.7344, 11.5440, 92.3520, 16.1616, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 83 S strokes: 3 *
 *************************/

73.8816, 85.4256, 78.4992, 99.2784, 78.4992, 71.5728, 73.8816, 85.4256, 64.6464, 94.6608, 50.7936, 99.2784, 36.9408, 99.2784, 23.0880, 94.6608, 13.8528, 85.4256, 13.8528, 71.5728, 18.4704, 62.3376, 32.3232, 53.1024, 60.0288, 43.8672, 69.2640, 39.2496, 73.8816, 30.0144, 73.8816, 16.1616, 69.2640, 6.9264, GAMGI_IO_STROKE,

18.4704, 71.5728, 23.0880, 62.3376, 32.3232, 57.7200, 60.0288, 48.4848, 69.2640, 43.8672, 73.8816, 34.6320, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 76.1904, 23.0880, 66.9552, 32.3232, 62.3376, 60.0288, 53.1024, 73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 20.7792, 73.8816, 11.5440, 69.2640, 6.9264, 55.4112, 2.3088, 41.5584, 2.3088, 27.7056, 6.9264, 18.4704, 16.1616, 13.8528, 30.0144, 13.8528, 2.3088, 18.4704, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 84 T strokes: 19 *
 *************************/

9.2352, 99.2784, 9.2352, 71.5728, GAMGI_IO_STROKE,

41.5584, 99.2784, 41.5584, 2.3088, GAMGI_IO_STROKE,

46.1760, 94.6608, 46.1760, 6.9264, GAMGI_IO_STROKE,

50.7936, 99.2784, 50.7936, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 83.1168, 71.5728, GAMGI_IO_STROKE,

9.2352, 99.2784, 83.1168, 99.2784, GAMGI_IO_STROKE,

27.7056, 2.3088, 64.6464, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 9.2352, 71.5728, GAMGI_IO_STROKE,

18.4704, 99.2784, 9.2352, 85.4256, GAMGI_IO_STROKE,

23.0880, 99.2784, 9.2352, 90.0432, GAMGI_IO_STROKE,

32.3232, 99.2784, 9.2352, 94.6608, GAMGI_IO_STROKE,

60.0288, 99.2784, 83.1168, 94.6608, GAMGI_IO_STROKE,

69.2640, 99.2784, 83.1168, 90.0432, GAMGI_IO_STROKE,

73.8816, 99.2784, 83.1168, 85.4256, GAMGI_IO_STROKE,

78.4992, 99.2784, 83.1168, 71.5728, GAMGI_IO_STROKE,

41.5584, 6.9264, 32.3232, 2.3088, GAMGI_IO_STROKE,

41.5584, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

50.7936, 11.5440, 55.4112, 2.3088, GAMGI_IO_STROKE,

50.7936, 6.9264, 60.0288, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 85 U strokes: 11 *
 *************************/

23.0880, 99.2784, 23.0880, 30.0144, 27.7056, 16.1616, 36.9408, 6.9264, 50.7936, 2.3088, 60.0288, 2.3088, 73.8816, 6.9264, 83.1168, 16.1616, 87.7344, 30.0144, 87.7344, 94.6608, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 25.3968, 32.3232, 16.1616, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 25.3968, 36.9408, 11.5440, 41.5584, 6.9264, 50.7936, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 46.1760, 99.2784, GAMGI_IO_STROKE,

73.8816, 99.2784, 101.5872, 99.2784, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

78.4992, 99.2784, 87.7344, 94.6608, GAMGI_IO_STROKE,

96.9696, 99.2784, 87.7344, 94.6608, GAMGI_IO_CHAR,

/*************************
 * char: 86 V strokes: 11 *
 *************************/

13.8528, 99.2784, 46.1760, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 46.1760, 16.1616, 46.1760, 2.3088, GAMGI_IO_STROKE,

23.0880, 99.2784, 50.7936, 16.1616, GAMGI_IO_STROKE,

78.4992, 94.6608, 46.1760, 2.3088, GAMGI_IO_STROKE,

4.6176, 99.2784, 36.9408, 99.2784, GAMGI_IO_STROKE,

60.0288, 99.2784, 87.7344, 99.2784, GAMGI_IO_STROKE,

9.2352, 99.2784, 18.4704, 90.0432, GAMGI_IO_STROKE,

27.7056, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

32.3232, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

69.2640, 99.2784, 78.4992, 94.6608, GAMGI_IO_STROKE,

83.1168, 99.2784, 78.4992, 94.6608, GAMGI_IO_CHAR,

/*************************
 * char: 87 W strokes: 17 *
 *************************/

18.4704, 99.2784, 36.9408, 2.3088, GAMGI_IO_STROKE,

23.0880, 99.2784, 36.9408, 25.3968, 36.9408, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 41.5584, 25.3968, GAMGI_IO_STROKE,

55.4112, 99.2784, 41.5584, 25.3968, 36.9408, 2.3088, GAMGI_IO_STROKE,

55.4112, 99.2784, 73.8816, 2.3088, GAMGI_IO_STROKE,

60.0288, 99.2784, 73.8816, 25.3968, 73.8816, 2.3088, GAMGI_IO_STROKE,

64.6464, 99.2784, 78.4992, 25.3968, GAMGI_IO_STROKE,

92.3520, 94.6608, 78.4992, 25.3968, 73.8816, 2.3088, GAMGI_IO_STROKE,

4.6176, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

55.4112, 99.2784, 64.6464, 99.2784, GAMGI_IO_STROKE,

78.4992, 99.2784, 106.2048, 99.2784, GAMGI_IO_STROKE,

9.2352, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

32.3232, 99.2784, 27.7056, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 27.7056, 94.6608, GAMGI_IO_STROKE,

83.1168, 99.2784, 92.3520, 94.6608, GAMGI_IO_STROKE,

101.5872, 99.2784, 92.3520, 94.6608, GAMGI_IO_CHAR,

/*************************
 * char: 88 X strokes: 18 *
 *************************/

13.8528, 99.2784, 69.2640, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 73.8816, 2.3088, GAMGI_IO_STROKE,

23.0880, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

73.8816, 94.6608, 18.4704, 6.9264, GAMGI_IO_STROKE,

4.6176, 99.2784, 36.9408, 99.2784, GAMGI_IO_STROKE,

60.0288, 99.2784, 87.7344, 99.2784, GAMGI_IO_STROKE,

4.6176, 2.3088, 32.3232, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 87.7344, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

27.7056, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

32.3232, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

64.6464, 99.2784, 73.8816, 94.6608, GAMGI_IO_STROKE,

83.1168, 99.2784, 73.8816, 94.6608, GAMGI_IO_STROKE,

18.4704, 6.9264, 9.2352, 2.3088, GAMGI_IO_STROKE,

18.4704, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

69.2640, 6.9264, 60.0288, 2.3088, GAMGI_IO_STROKE,

69.2640, 11.5440, 64.6464, 2.3088, GAMGI_IO_STROKE,

69.2640, 11.5440, 83.1168, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 89 Y strokes: 15 *
 *************************/

13.8528, 99.2784, 46.1760, 48.4848, 46.1760, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 50.7936, 48.4848, 50.7936, 6.9264, GAMGI_IO_STROKE,

23.0880, 99.2784, 55.4112, 48.4848, 55.4112, 2.3088, GAMGI_IO_STROKE,

83.1168, 94.6608, 55.4112, 48.4848, GAMGI_IO_STROKE,

4.6176, 99.2784, 36.9408, 99.2784, GAMGI_IO_STROKE,

69.2640, 99.2784, 96.9696, 99.2784, GAMGI_IO_STROKE,

32.3232, 2.3088, 69.2640, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 18.4704, 94.6608, GAMGI_IO_STROKE,

32.3232, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

73.8816, 99.2784, 83.1168, 94.6608, GAMGI_IO_STROKE,

92.3520, 99.2784, 83.1168, 94.6608, GAMGI_IO_STROKE,

46.1760, 6.9264, 36.9408, 2.3088, GAMGI_IO_STROKE,

46.1760, 11.5440, 41.5584, 2.3088, GAMGI_IO_STROKE,

55.4112, 11.5440, 60.0288, 2.3088, GAMGI_IO_STROKE,

55.4112, 6.9264, 64.6464, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 90 Z strokes: 13 *
 *************************/

78.4992, 99.2784, 13.8528, 99.2784, 13.8528, 71.5728, GAMGI_IO_STROKE,

69.2640, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

73.8816, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

78.4992, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

13.8528, 2.3088, 78.4992, 2.3088, 78.4992, 30.0144, GAMGI_IO_STROKE,

18.4704, 99.2784, 13.8528, 71.5728, GAMGI_IO_STROKE,

23.0880, 99.2784, 13.8528, 85.4256, GAMGI_IO_STROKE,

27.7056, 99.2784, 13.8528, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 13.8528, 94.6608, GAMGI_IO_STROKE,

55.4112, 2.3088, 78.4992, 6.9264, GAMGI_IO_STROKE,

64.6464, 2.3088, 78.4992, 11.5440, GAMGI_IO_STROKE,

69.2640, 2.3088, 78.4992, 16.1616, GAMGI_IO_STROKE,

73.8816, 2.3088, 78.4992, 30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 91 [ strokes: 4 *
 *************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_STROKE,

23.0880, 117.7488, 23.0880, -30.0144, GAMGI_IO_STROKE,

18.4704, 117.7488, 50.7936, 117.7488, GAMGI_IO_STROKE,

18.4704, -30.0144, 50.7936, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 92 \ strokes: 2 *
 *************************/

13.8528, 117.7488, 96.9696, -30.0144, 92.3520, -30.0144, GAMGI_IO_STROKE,

13.8528, 117.7488, 9.2352, 117.7488, 92.3520, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 93 ] strokes: 4 *
 *************************/

41.5584, 117.7488, 41.5584, -30.0144, GAMGI_IO_STROKE,

46.1760, 117.7488, 46.1760, -30.0144, GAMGI_IO_STROKE,

13.8528, 117.7488, 46.1760, 117.7488, GAMGI_IO_STROKE,

13.8528, -30.0144, 46.1760, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 94 ^ strokes: 2 *
 *************************/

27.7056, 71.5728, 36.9408, 85.4256, 46.1760, 71.5728, GAMGI_IO_STROKE,

13.8528, 57.7200, 36.9408, 80.8080, 60.0288, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 95 _ strokes: 1 *
 *************************/

9.2352, -6.9264, 92.3520, -6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 96 ` strokes: 4 *
 *************************/

32.3232, 99.2784, 23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 71.5728, 23.0880, 66.9552, 27.7056, 66.9552, 32.3232, 71.5728, 32.3232, 76.1904, 27.7056, 80.8080, 23.0880, 80.8080, 18.4704, 76.1904, GAMGI_IO_STROKE,

23.0880, 76.1904, 23.0880, 71.5728, 27.7056, 71.5728, 27.7056, 76.1904, 23.0880, 76.1904, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 76.1904, GAMGI_IO_STROKE,

18.4704, 85.4256, 23.0880, 80.8080, GAMGI_IO_CHAR,

/*************************
 * char: 97 a strokes: 6 *
 *************************/

23.0880, 53.1024, 23.0880, 57.7200, 27.7056, 57.7200, 27.7056, 48.4848, 18.4704, 48.4848, 18.4704, 57.7200, 23.0880, 62.3376, 32.3232, 66.9552, 50.7936, 66.9552, 60.0288, 62.3376, 64.6464, 57.7200, 69.2640, 48.4848, 69.2640, 16.1616, 73.8816, 6.9264, 78.4992, 2.3088, GAMGI_IO_STROKE,

60.0288, 57.7200, 64.6464, 48.4848, 64.6464, 16.1616, 69.2640, 6.9264, GAMGI_IO_STROKE,

50.7936, 66.9552, 55.4112, 62.3376, 60.0288, 53.1024, 60.0288, 16.1616, 64.6464, 6.9264, 78.4992, 2.3088, 83.1168, 2.3088, GAMGI_IO_STROKE,

60.0288, 43.8672, 55.4112, 39.2496, 32.3232, 34.6320, 18.4704, 30.0144, 13.8528, 20.7792, 13.8528, 16.1616, 18.4704, 6.9264, 32.3232, 2.3088, 46.1760, 2.3088, 55.4112, 6.9264, 60.0288, 16.1616, GAMGI_IO_STROKE,

23.0880, 30.0144, 18.4704, 20.7792, 18.4704, 16.1616, 23.0880, 6.9264, GAMGI_IO_STROKE,

55.4112, 39.2496, 36.9408, 34.6320, 27.7056, 30.0144, 23.0880, 20.7792, 23.0880, 16.1616, 27.7056, 6.9264, 32.3232, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 98 b strokes: 8 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, 27.7056, 6.9264, 36.9408, 6.9264, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 11.5440, GAMGI_IO_STROKE,

9.2352, 99.2784, 32.3232, 99.2784, 32.3232, 6.9264, GAMGI_IO_STROKE,

32.3232, 53.1024, 36.9408, 62.3376, 46.1760, 66.9552, 55.4112, 66.9552, 69.2640, 62.3376, 78.4992, 53.1024, 83.1168, 39.2496, 83.1168, 30.0144, 78.4992, 16.1616, 69.2640, 6.9264, 55.4112, 2.3088, 46.1760, 2.3088, 36.9408, 6.9264, 32.3232, 16.1616, GAMGI_IO_STROKE,

73.8816, 53.1024, 78.4992, 43.8672, 78.4992, 25.3968, 73.8816, 16.1616, GAMGI_IO_STROKE,

55.4112, 66.9552, 64.6464, 62.3376, 69.2640, 57.7200, 73.8816, 43.8672, 73.8816, 25.3968, 69.2640, 11.5440, 64.6464, 6.9264, 55.4112, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_CHAR,

/*************************
 * char: 99 c strokes: 3 *
 *************************/

69.2640, 48.4848, 69.2640, 53.1024, 64.6464, 53.1024, 64.6464, 43.8672, 73.8816, 43.8672, 73.8816, 53.1024, 64.6464, 62.3376, 55.4112, 66.9552, 41.5584, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, GAMGI_IO_STROKE,

23.0880, 53.1024, 18.4704, 43.8672, 18.4704, 25.3968, 23.0880, 16.1616, GAMGI_IO_STROKE,

41.5584, 66.9552, 32.3232, 62.3376, 27.7056, 57.7200, 23.0880, 43.8672, 23.0880, 25.3968, 27.7056, 11.5440, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 100 d strokes: 10 *
 **************************/

64.6464, 99.2784, 64.6464, 2.3088, 87.7344, 2.3088, GAMGI_IO_STROKE,

69.2640, 94.6608, 69.2640, 6.9264, GAMGI_IO_STROKE,

50.7936, 99.2784, 73.8816, 99.2784, 73.8816, 2.3088, GAMGI_IO_STROKE,

64.6464, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, 41.5584, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 16.1616, GAMGI_IO_STROKE,

23.0880, 53.1024, 18.4704, 43.8672, 18.4704, 25.3968, 23.0880, 16.1616, GAMGI_IO_STROKE,

41.5584, 66.9552, 32.3232, 62.3376, 27.7056, 57.7200, 23.0880, 43.8672, 23.0880, 25.3968, 27.7056, 11.5440, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

55.4112, 99.2784, 64.6464, 94.6608, GAMGI_IO_STROKE,

60.0288, 99.2784, 64.6464, 90.0432, GAMGI_IO_STROKE,

73.8816, 11.5440, 78.4992, 2.3088, GAMGI_IO_STROKE,

73.8816, 6.9264, 83.1168, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 101 e strokes: 5 *
 **************************/

23.0880, 39.2496, 73.8816, 39.2496, 73.8816, 48.4848, 69.2640, 57.7200, 64.6464, 62.3376, 50.7936, 66.9552, 41.5584, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, GAMGI_IO_STROKE,

69.2640, 43.8672, 69.2640, 48.4848, 64.6464, 57.7200, GAMGI_IO_STROKE,

23.0880, 53.1024, 18.4704, 43.8672, 18.4704, 25.3968, 23.0880, 16.1616, GAMGI_IO_STROKE,

64.6464, 39.2496, 64.6464, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, GAMGI_IO_STROKE,

41.5584, 66.9552, 32.3232, 62.3376, 27.7056, 57.7200, 23.0880, 43.8672, 23.0880, 25.3968, 27.7056, 11.5440, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 102 f strokes: 9 *
 **************************/

55.4112, 90.0432, 55.4112, 94.6608, 50.7936, 94.6608, 50.7936, 85.4256, 60.0288, 85.4256, 60.0288, 94.6608, 55.4112, 99.2784, 41.5584, 99.2784, 32.3232, 94.6608, 27.7056, 90.0432, 23.0880, 76.1904, 23.0880, 2.3088, GAMGI_IO_STROKE,

32.3232, 90.0432, 27.7056, 76.1904, 27.7056, 6.9264, GAMGI_IO_STROKE,

41.5584, 99.2784, 36.9408, 94.6608, 32.3232, 85.4256, 32.3232, 2.3088, GAMGI_IO_STROKE,

9.2352, 66.9552, 50.7936, 66.9552, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 103 g strokes: 10 *
 **************************/

69.2640, 62.3376, 73.8816, 57.7200, 78.4992, 62.3376, 73.8816, 66.9552, 69.2640, 66.9552, 60.0288, 62.3376, 55.4112, 57.7200, GAMGI_IO_STROKE,

36.9408, 66.9552, 27.7056, 62.3376, 23.0880, 57.7200, 18.4704, 48.4848, 18.4704, 39.2496, 23.0880, 30.0144, 27.7056, 25.3968, 36.9408, 20.7792, 46.1760, 20.7792, 55.4112, 25.3968, 60.0288, 30.0144, 64.6464, 39.2496, 64.6464, 48.4848, 60.0288, 57.7200, 55.4112, 62.3376, 46.1760, 66.9552, 36.9408, 66.9552, GAMGI_IO_STROKE,

27.7056, 57.7200, 23.0880, 48.4848, 23.0880, 39.2496, 27.7056, 30.0144, GAMGI_IO_STROKE,

55.4112, 30.0144, 60.0288, 39.2496, 60.0288, 48.4848, 55.4112, 57.7200, GAMGI_IO_STROKE,

36.9408, 66.9552, 32.3232, 62.3376, 27.7056, 53.1024, 27.7056, 34.6320, 32.3232, 25.3968, 36.9408, 20.7792, GAMGI_IO_STROKE,

46.1760, 20.7792, 50.7936, 25.3968, 55.4112, 34.6320, 55.4112, 53.1024, 50.7936, 62.3376, 46.1760, 66.9552, GAMGI_IO_STROKE,

23.0880, 30.0144, 18.4704, 25.3968, 13.8528, 16.1616, 13.8528, 11.5440, 18.4704, 2.3088, 23.0880, -2.3088, 36.9408, -6.9264, 55.4112, -6.9264, 69.2640, -11.5440, 73.8816, -16.1616, GAMGI_IO_STROKE,

23.0880, 2.3088, 36.9408, -2.3088, 55.4112, -2.3088, 69.2640, -6.9264, GAMGI_IO_STROKE,

13.8528, 11.5440, 18.4704, 6.9264, 32.3232, 2.3088, 55.4112, 2.3088, 69.2640, -2.3088, 73.8816, -11.5440, 73.8816, -16.1616, 69.2640, -25.3968, 55.4112, -30.0144, 27.7056, -30.0144, 13.8528, -25.3968, 9.2352, -16.1616, 9.2352, -11.5440, 13.8528, -2.3088, 27.7056, 2.3088, GAMGI_IO_STROKE,

27.7056, -30.0144, 18.4704, -25.3968, 13.8528, -16.1616, 13.8528, -11.5440, 18.4704, -2.3088, 27.7056, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 104 h strokes: 18 *
 **************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

9.2352, 99.2784, 32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

32.3232, 48.4848, 36.9408, 57.7200, 41.5584, 62.3376, 50.7936, 66.9552, 64.6464, 66.9552, 73.8816, 62.3376, 78.4992, 57.7200, 83.1168, 43.8672, 83.1168, 2.3088, GAMGI_IO_STROKE,

73.8816, 57.7200, 78.4992, 43.8672, 78.4992, 6.9264, GAMGI_IO_STROKE,

64.6464, 66.9552, 69.2640, 62.3376, 73.8816, 48.4848, 73.8816, 2.3088, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

60.0288, 2.3088, 96.9696, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

73.8816, 6.9264, 64.6464, 2.3088, GAMGI_IO_STROKE,

73.8816, 11.5440, 69.2640, 2.3088, GAMGI_IO_STROKE,

83.1168, 11.5440, 87.7344, 2.3088, GAMGI_IO_STROKE,

83.1168, 6.9264, 92.3520, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 105 i strokes: 13 *
 **************************/

23.0880, 99.2784, 23.0880, 90.0432, 32.3232, 90.0432, 32.3232, 99.2784, 23.0880, 99.2784, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 90.0432, GAMGI_IO_STROKE,

23.0880, 94.6608, 32.3232, 94.6608, GAMGI_IO_STROKE,

23.0880, 66.9552, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 62.3376, 27.7056, 6.9264, GAMGI_IO_STROKE,

9.2352, 66.9552, 32.3232, 66.9552, 32.3232, 2.3088, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

13.8528, 66.9552, 23.0880, 62.3376, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 57.7200, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 106 j strokes: 8 *
 **************************/

32.3232, 99.2784, 32.3232, 90.0432, 41.5584, 90.0432, 41.5584, 99.2784, 32.3232, 99.2784, GAMGI_IO_STROKE,

36.9408, 99.2784, 36.9408, 90.0432, GAMGI_IO_STROKE,

32.3232, 94.6608, 41.5584, 94.6608, GAMGI_IO_STROKE,

32.3232, 66.9552, 32.3232, -11.5440, 27.7056, -25.3968, 23.0880, -30.0144, GAMGI_IO_STROKE,

36.9408, 62.3376, 36.9408, -6.9264, 32.3232, -20.7792, GAMGI_IO_STROKE,

18.4704, 66.9552, 41.5584, 66.9552, 41.5584, -6.9264, 36.9408, -20.7792, 32.3232, -25.3968, 23.0880, -30.0144, 9.2352, -30.0144, 4.6176, -25.3968, 4.6176, -16.1616, 13.8528, -16.1616, 13.8528, -25.3968, 9.2352, -25.3968, 9.2352, -20.7792, GAMGI_IO_STROKE,

23.0880, 66.9552, 32.3232, 62.3376, GAMGI_IO_STROKE,

27.7056, 66.9552, 32.3232, 57.7200, GAMGI_IO_CHAR,

/**************************
 * char: 107 k strokes: 20 *
 **************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

9.2352, 99.2784, 32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

73.8816, 62.3376, 32.3232, 20.7792, GAMGI_IO_STROKE,

50.7936, 39.2496, 83.1168, 2.3088, GAMGI_IO_STROKE,

50.7936, 34.6320, 78.4992, 2.3088, GAMGI_IO_STROKE,

46.1760, 34.6320, 73.8816, 2.3088, GAMGI_IO_STROKE,

60.0288, 66.9552, 92.3520, 66.9552, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

60.0288, 2.3088, 92.3520, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

64.6464, 66.9552, 73.8816, 62.3376, GAMGI_IO_STROKE,

87.7344, 66.9552, 73.8816, 62.3376, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

73.8816, 11.5440, 64.6464, 2.3088, GAMGI_IO_STROKE,

69.2640, 11.5440, 87.7344, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 108 l strokes: 10 *
 **************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

9.2352, 99.2784, 32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 109 m strokes: 26 *
 **************************/

23.0880, 66.9552, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 62.3376, 27.7056, 6.9264, GAMGI_IO_STROKE,

9.2352, 66.9552, 32.3232, 66.9552, 32.3232, 2.3088, GAMGI_IO_STROKE,

32.3232, 48.4848, 36.9408, 57.7200, 41.5584, 62.3376, 50.7936, 66.9552, 64.6464, 66.9552, 73.8816, 62.3376, 78.4992, 57.7200, 83.1168, 43.8672, 83.1168, 2.3088, GAMGI_IO_STROKE,

73.8816, 57.7200, 78.4992, 43.8672, 78.4992, 6.9264, GAMGI_IO_STROKE,

64.6464, 66.9552, 69.2640, 62.3376, 73.8816, 48.4848, 73.8816, 2.3088, GAMGI_IO_STROKE,

83.1168, 48.4848, 87.7344, 57.7200, 92.3520, 62.3376, 101.5872, 66.9552, 115.4400, 66.9552, 124.6752, 62.3376, 129.2928, 57.7200, 133.9104, 43.8672, 133.9104, 2.3088, GAMGI_IO_STROKE,

124.6752, 57.7200, 129.2928, 43.8672, 129.2928, 6.9264, GAMGI_IO_STROKE,

115.4400, 66.9552, 120.0576, 62.3376, 124.6752, 48.4848, 124.6752, 2.3088, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

60.0288, 2.3088, 96.9696, 2.3088, GAMGI_IO_STROKE,

110.8224, 2.3088, 147.7632, 2.3088, GAMGI_IO_STROKE,

13.8528, 66.9552, 23.0880, 62.3376, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 57.7200, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

73.8816, 6.9264, 64.6464, 2.3088, GAMGI_IO_STROKE,

73.8816, 11.5440, 69.2640, 2.3088, GAMGI_IO_STROKE,

83.1168, 11.5440, 87.7344, 2.3088, GAMGI_IO_STROKE,

83.1168, 6.9264, 92.3520, 2.3088, GAMGI_IO_STROKE,

124.6752, 6.9264, 115.4400, 2.3088, GAMGI_IO_STROKE,

124.6752, 11.5440, 120.0576, 2.3088, GAMGI_IO_STROKE,

133.9104, 11.5440, 138.5280, 2.3088, GAMGI_IO_STROKE,

133.9104, 6.9264, 143.1456, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 110 n strokes: 18 *
 **************************/

23.0880, 66.9552, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 62.3376, 27.7056, 6.9264, GAMGI_IO_STROKE,

9.2352, 66.9552, 32.3232, 66.9552, 32.3232, 2.3088, GAMGI_IO_STROKE,

32.3232, 48.4848, 36.9408, 57.7200, 41.5584, 62.3376, 50.7936, 66.9552, 64.6464, 66.9552, 73.8816, 62.3376, 78.4992, 57.7200, 83.1168, 43.8672, 83.1168, 2.3088, GAMGI_IO_STROKE,

73.8816, 57.7200, 78.4992, 43.8672, 78.4992, 6.9264, GAMGI_IO_STROKE,

64.6464, 66.9552, 69.2640, 62.3376, 73.8816, 48.4848, 73.8816, 2.3088, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

60.0288, 2.3088, 96.9696, 2.3088, GAMGI_IO_STROKE,

13.8528, 66.9552, 23.0880, 62.3376, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 57.7200, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

73.8816, 6.9264, 64.6464, 2.3088, GAMGI_IO_STROKE,

73.8816, 11.5440, 69.2640, 2.3088, GAMGI_IO_STROKE,

83.1168, 11.5440, 87.7344, 2.3088, GAMGI_IO_STROKE,

83.1168, 6.9264, 92.3520, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 111 o strokes: 5 *
 **************************/

41.5584, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 30.0144, 78.4992, 39.2496, 73.8816, 53.1024, 64.6464, 62.3376, 50.7936, 66.9552, 41.5584, 66.9552, GAMGI_IO_STROKE,

23.0880, 53.1024, 18.4704, 43.8672, 18.4704, 25.3968, 23.0880, 16.1616, GAMGI_IO_STROKE,

69.2640, 16.1616, 73.8816, 25.3968, 73.8816, 43.8672, 69.2640, 53.1024, GAMGI_IO_STROKE,

41.5584, 66.9552, 32.3232, 62.3376, 27.7056, 57.7200, 23.0880, 43.8672, 23.0880, 25.3968, 27.7056, 11.5440, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 11.5440, 69.2640, 25.3968, 69.2640, 43.8672, 64.6464, 57.7200, 60.0288, 62.3376, 50.7936, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 112 p strokes: 13 *
 **************************/

23.0880, 66.9552, 23.0880, -30.0144, GAMGI_IO_STROKE,

27.7056, 62.3376, 27.7056, -25.3968, GAMGI_IO_STROKE,

9.2352, 66.9552, 32.3232, 66.9552, 32.3232, -30.0144, GAMGI_IO_STROKE,

32.3232, 53.1024, 36.9408, 62.3376, 46.1760, 66.9552, 55.4112, 66.9552, 69.2640, 62.3376, 78.4992, 53.1024, 83.1168, 39.2496, 83.1168, 30.0144, 78.4992, 16.1616, 69.2640, 6.9264, 55.4112, 2.3088, 46.1760, 2.3088, 36.9408, 6.9264, 32.3232, 16.1616, GAMGI_IO_STROKE,

73.8816, 53.1024, 78.4992, 43.8672, 78.4992, 25.3968, 73.8816, 16.1616, GAMGI_IO_STROKE,

55.4112, 66.9552, 64.6464, 62.3376, 69.2640, 57.7200, 73.8816, 43.8672, 73.8816, 25.3968, 69.2640, 11.5440, 64.6464, 6.9264, 55.4112, 2.3088, GAMGI_IO_STROKE,

9.2352, -30.0144, 46.1760, -30.0144, GAMGI_IO_STROKE,

13.8528, 66.9552, 23.0880, 62.3376, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 57.7200, GAMGI_IO_STROKE,

23.0880, -25.3968, 13.8528, -30.0144, GAMGI_IO_STROKE,

23.0880, -20.7792, 18.4704, -30.0144, GAMGI_IO_STROKE,

32.3232, -20.7792, 36.9408, -30.0144, GAMGI_IO_STROKE,

32.3232, -25.3968, 41.5584, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 113 q strokes: 11 *
 **************************/

64.6464, 62.3376, 64.6464, -30.0144, GAMGI_IO_STROKE,

69.2640, 57.7200, 69.2640, -25.3968, GAMGI_IO_STROKE,

60.0288, 62.3376, 69.2640, 62.3376, 73.8816, 66.9552, 73.8816, -30.0144, GAMGI_IO_STROKE,

64.6464, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, 41.5584, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 16.1616, GAMGI_IO_STROKE,

23.0880, 53.1024, 18.4704, 43.8672, 18.4704, 25.3968, 23.0880, 16.1616, GAMGI_IO_STROKE,

41.5584, 66.9552, 32.3232, 62.3376, 27.7056, 57.7200, 23.0880, 43.8672, 23.0880, 25.3968, 27.7056, 11.5440, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, -30.0144, 87.7344, -30.0144, GAMGI_IO_STROKE,

64.6464, -25.3968, 55.4112, -30.0144, GAMGI_IO_STROKE,

64.6464, -20.7792, 60.0288, -30.0144, GAMGI_IO_STROKE,

73.8816, -20.7792, 78.4992, -30.0144, GAMGI_IO_STROKE,

73.8816, -25.3968, 83.1168, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 114 r strokes: 11 *
 **************************/

23.0880, 66.9552, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 62.3376, 27.7056, 6.9264, GAMGI_IO_STROKE,

9.2352, 66.9552, 32.3232, 66.9552, 32.3232, 2.3088, GAMGI_IO_STROKE,

64.6464, 57.7200, 64.6464, 62.3376, 60.0288, 62.3376, 60.0288, 53.1024, 69.2640, 53.1024, 69.2640, 62.3376, 64.6464, 66.9552, 55.4112, 66.9552, 46.1760, 62.3376, 36.9408, 53.1024, 32.3232, 39.2496, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

13.8528, 66.9552, 23.0880, 62.3376, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 57.7200, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 115 s strokes: 5 *
 **************************/

60.0288, 57.7200, 64.6464, 66.9552, 64.6464, 48.4848, 60.0288, 57.7200, 55.4112, 62.3376, 46.1760, 66.9552, 27.7056, 66.9552, 18.4704, 62.3376, 13.8528, 57.7200, 13.8528, 48.4848, 18.4704, 39.2496, 27.7056, 34.6320, 50.7936, 30.0144, 60.0288, 25.3968, 64.6464, 11.5440, GAMGI_IO_STROKE,

18.4704, 62.3376, 13.8528, 48.4848, GAMGI_IO_STROKE,

18.4704, 43.8672, 27.7056, 39.2496, 50.7936, 34.6320, 60.0288, 30.0144, GAMGI_IO_STROKE,

64.6464, 25.3968, 60.0288, 6.9264, GAMGI_IO_STROKE,

13.8528, 57.7200, 18.4704, 48.4848, 27.7056, 43.8672, 50.7936, 39.2496, 60.0288, 34.6320, 64.6464, 25.3968, 64.6464, 11.5440, 60.0288, 6.9264, 50.7936, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 2.3088, 18.4704, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 116 t strokes: 4 *
 **************************/

23.0880, 90.0432, 23.0880, 25.3968, 27.7056, 11.5440, 32.3232, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 16.1616, GAMGI_IO_STROKE,

27.7056, 90.0432, 27.7056, 20.7792, 32.3232, 11.5440, GAMGI_IO_STROKE,

23.0880, 90.0432, 32.3232, 99.2784, 32.3232, 20.7792, 36.9408, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

9.2352, 66.9552, 50.7936, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 117 u strokes: 10 *
 **************************/

23.0880, 66.9552, 23.0880, 25.3968, 27.7056, 11.5440, 32.3232, 6.9264, 41.5584, 2.3088, 55.4112, 2.3088, 64.6464, 6.9264, 69.2640, 11.5440, 73.8816, 20.7792, GAMGI_IO_STROKE,

27.7056, 62.3376, 27.7056, 20.7792, 32.3232, 11.5440, GAMGI_IO_STROKE,

9.2352, 66.9552, 32.3232, 66.9552, 32.3232, 20.7792, 36.9408, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

73.8816, 66.9552, 73.8816, 2.3088, 96.9696, 2.3088, GAMGI_IO_STROKE,

78.4992, 62.3376, 78.4992, 6.9264, GAMGI_IO_STROKE,

60.0288, 66.9552, 83.1168, 66.9552, 83.1168, 2.3088, GAMGI_IO_STROKE,

13.8528, 66.9552, 23.0880, 62.3376, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 57.7200, GAMGI_IO_STROKE,

83.1168, 11.5440, 87.7344, 2.3088, GAMGI_IO_STROKE,

83.1168, 6.9264, 92.3520, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 118 v strokes: 10 *
 **************************/

13.8528, 66.9552, 41.5584, 2.3088, GAMGI_IO_STROKE,

18.4704, 66.9552, 41.5584, 11.5440, GAMGI_IO_STROKE,

23.0880, 66.9552, 46.1760, 11.5440, GAMGI_IO_STROKE,

69.2640, 62.3376, 46.1760, 11.5440, 41.5584, 2.3088, GAMGI_IO_STROKE,

4.6176, 66.9552, 36.9408, 66.9552, GAMGI_IO_STROKE,

50.7936, 66.9552, 78.4992, 66.9552, GAMGI_IO_STROKE,

9.2352, 66.9552, 23.0880, 57.7200, GAMGI_IO_STROKE,

32.3232, 66.9552, 23.0880, 62.3376, GAMGI_IO_STROKE,

60.0288, 66.9552, 69.2640, 62.3376, GAMGI_IO_STROKE,

73.8816, 66.9552, 69.2640, 62.3376, GAMGI_IO_CHAR,

/**************************
 * char: 119 w strokes: 14 *
 **************************/

18.4704, 66.9552, 36.9408, 2.3088, GAMGI_IO_STROKE,

23.0880, 66.9552, 36.9408, 16.1616, GAMGI_IO_STROKE,

27.7056, 66.9552, 41.5584, 16.1616, GAMGI_IO_STROKE,

55.4112, 66.9552, 41.5584, 16.1616, 36.9408, 2.3088, GAMGI_IO_STROKE,

55.4112, 66.9552, 73.8816, 2.3088, GAMGI_IO_STROKE,

60.0288, 66.9552, 73.8816, 16.1616, GAMGI_IO_STROKE,

55.4112, 66.9552, 64.6464, 66.9552, 78.4992, 16.1616, GAMGI_IO_STROKE,

92.3520, 62.3376, 78.4992, 16.1616, 73.8816, 2.3088, GAMGI_IO_STROKE,

4.6176, 66.9552, 41.5584, 66.9552, GAMGI_IO_STROKE,

78.4992, 66.9552, 106.2048, 66.9552, GAMGI_IO_STROKE,

9.2352, 66.9552, 23.0880, 62.3376, GAMGI_IO_STROKE,

36.9408, 66.9552, 27.7056, 62.3376, GAMGI_IO_STROKE,

83.1168, 66.9552, 92.3520, 62.3376, GAMGI_IO_STROKE,

101.5872, 66.9552, 92.3520, 62.3376, GAMGI_IO_CHAR,

/**************************
 * char: 120 x strokes: 16 *
 **************************/

18.4704, 66.9552, 64.6464, 2.3088, GAMGI_IO_STROKE,

23.0880, 66.9552, 69.2640, 2.3088, GAMGI_IO_STROKE,

27.7056, 66.9552, 73.8816, 2.3088, GAMGI_IO_STROKE,

69.2640, 62.3376, 23.0880, 6.9264, GAMGI_IO_STROKE,

9.2352, 66.9552, 41.5584, 66.9552, GAMGI_IO_STROKE,

55.4112, 66.9552, 83.1168, 66.9552, GAMGI_IO_STROKE,

9.2352, 2.3088, 36.9408, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 83.1168, 2.3088, GAMGI_IO_STROKE,

13.8528, 66.9552, 23.0880, 62.3376, GAMGI_IO_STROKE,

36.9408, 66.9552, 27.7056, 62.3376, GAMGI_IO_STROKE,

60.0288, 66.9552, 69.2640, 62.3376, GAMGI_IO_STROKE,

78.4992, 66.9552, 69.2640, 62.3376, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 6.9264, 32.3232, 2.3088, GAMGI_IO_STROKE,

64.6464, 6.9264, 55.4112, 2.3088, GAMGI_IO_STROKE,

69.2640, 6.9264, 78.4992, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 121 y strokes: 10 *
 **************************/

18.4704, 66.9552, 46.1760, 2.3088, GAMGI_IO_STROKE,

23.0880, 66.9552, 46.1760, 11.5440, GAMGI_IO_STROKE,

27.7056, 66.9552, 50.7936, 11.5440, GAMGI_IO_STROKE,

73.8816, 62.3376, 50.7936, 11.5440, 36.9408, -16.1616, 27.7056, -25.3968, 18.4704, -30.0144, 9.2352, -30.0144, 4.6176, -25.3968, 4.6176, -16.1616, 13.8528, -16.1616, 13.8528, -25.3968, 9.2352, -25.3968, 9.2352, -20.7792, GAMGI_IO_STROKE,

9.2352, 66.9552, 41.5584, 66.9552, GAMGI_IO_STROKE,

55.4112, 66.9552, 83.1168, 66.9552, GAMGI_IO_STROKE,

13.8528, 66.9552, 27.7056, 57.7200, GAMGI_IO_STROKE,

36.9408, 66.9552, 27.7056, 62.3376, GAMGI_IO_STROKE,

64.6464, 66.9552, 73.8816, 62.3376, GAMGI_IO_STROKE,

78.4992, 66.9552, 73.8816, 62.3376, GAMGI_IO_CHAR,

/**************************
 * char: 122 z strokes: 13 *
 **************************/

60.0288, 66.9552, 13.8528, 2.3088, GAMGI_IO_STROKE,

64.6464, 66.9552, 18.4704, 2.3088, GAMGI_IO_STROKE,

69.2640, 66.9552, 23.0880, 2.3088, GAMGI_IO_STROKE,

69.2640, 66.9552, 13.8528, 66.9552, 13.8528, 48.4848, GAMGI_IO_STROKE,

13.8528, 2.3088, 69.2640, 2.3088, 69.2640, 20.7792, GAMGI_IO_STROKE,

18.4704, 66.9552, 13.8528, 48.4848, GAMGI_IO_STROKE,

23.0880, 66.9552, 13.8528, 53.1024, GAMGI_IO_STROKE,

27.7056, 66.9552, 13.8528, 57.7200, GAMGI_IO_STROKE,

36.9408, 66.9552, 13.8528, 62.3376, GAMGI_IO_STROKE,

46.1760, 2.3088, 69.2640, 6.9264, GAMGI_IO_STROKE,

55.4112, 2.3088, 69.2640, 11.5440, GAMGI_IO_STROKE,

60.0288, 2.3088, 69.2640, 16.1616, GAMGI_IO_STROKE,

64.6464, 2.3088, 69.2640, 20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 123 { strokes: 3 *
 **************************/

46.1760, 117.7488, 32.3232, 103.8960, 27.7056, 90.0432, 27.7056, 80.8080, 32.3232, 66.9552, 41.5584, 57.7200, 41.5584, 53.1024, 23.0880, 43.8672, 41.5584, 34.6320, 41.5584, 30.0144, 32.3232, 20.7792, 27.7056, 6.9264, 27.7056, -2.3088, 32.3232, -16.1616, 46.1760, -30.0144, GAMGI_IO_STROKE,

36.9408, 108.5136, 32.3232, 94.6608, 32.3232, 76.1904, 36.9408, 62.3376, GAMGI_IO_STROKE,

36.9408, 25.3968, 32.3232, 11.5440, 32.3232, -6.9264, 36.9408, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 124 | strokes: 2 *
 **************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_STROKE,

23.0880, 117.7488, 23.0880, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 125 } strokes: 3 *
 **************************/

23.0880, 117.7488, 36.9408, 103.8960, 41.5584, 90.0432, 41.5584, 80.8080, 36.9408, 66.9552, 27.7056, 57.7200, 27.7056, 53.1024, 46.1760, 43.8672, 27.7056, 34.6320, 27.7056, 30.0144, 36.9408, 20.7792, 41.5584, 6.9264, 41.5584, -2.3088, 36.9408, -16.1616, 23.0880, -30.0144, GAMGI_IO_STROKE,

32.3232, 108.5136, 36.9408, 94.6608, 36.9408, 76.1904, 32.3232, 62.3376, GAMGI_IO_STROKE,

32.3232, 25.3968, 36.9408, 11.5440, 36.9408, -6.9264, 32.3232, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 126 ~ strokes: 2 *
 **************************/

13.8528, 30.0144, 13.8528, 39.2496, 18.4704, 53.1024, 27.7056, 57.7200, 36.9408, 57.7200, 46.1760, 53.1024, 64.6464, 39.2496, 73.8816, 34.6320, 83.1168, 34.6320, 92.3520, 39.2496, 96.9696, 48.4848, GAMGI_IO_STROKE,

13.8528, 39.2496, 18.4704, 48.4848, 27.7056, 53.1024, 36.9408, 53.1024, 46.1760, 48.4848, 64.6464, 34.6320, 73.8816, 30.0144, 83.1168, 30.0144, 92.3520, 34.6320, 96.9696, 48.4848, 96.9696, 57.7200, GAMGI_IO_CHAR,

};

const float gamgi_io_font_hershey_script_points[GAMGI_IO_POINTS_SCRIPT] = {

/***************
 * bottom, top *
 ***************/

-32.3232, 120.0576,

/**************
 * char 32-40 *
 **************/

73.8816, 46.1760, 73.8816, 101.5872, 92.3520, 110.8224, 120.0576, 46.1760, 64.6464, 

/**************
 * char 41-50 *
 **************/

64.6464, 73.8816, 120.0576, 46.1760, 120.0576, 46.1760, 101.5872, 92.3520, 92.3520, 92.3520, 

/**************
 * char 51-60 *
 **************/

92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 46.1760, 46.1760, 110.8224, 

/**************
 * char 61-70 *
 **************/

120.0576, 110.8224, 83.1168, 133.9104, 92.3520, 106.2048, 92.3520, 106.2048, 92.3520, 92.3520, 

/**************
 * char 71-80 *
 **************/

106.2048, 110.8224, 78.4992, 69.2640, 110.8224, 87.7344, 152.3808, 110.8224, 96.9696, 115.4400, 

/**************
 * char 81-90 *
 **************/

101.5872, 115.4400, 92.3520, 87.7344, 110.8224, 106.2048, 129.2928, 110.8224, 106.2048, 96.9696, 

/***************
 * char 91-100 *
 ***************/

64.6464, 101.5872, 64.6464, 73.8816, 101.5872, 46.1760, 73.8816, 64.6464, 50.7936, 73.8816, 

/****************
 * char 101-110 *
 ****************/

46.1760, 36.9408, 69.2640, 69.2640, 32.3232, 32.3232, 64.6464, 36.9408, 115.4400, 83.1168, 

/****************
 * char 111-120 *
 ****************/

64.6464, 69.2640, 69.2640, 60.0288, 50.7936, 41.5584, 69.2640, 69.2640, 96.9696, 73.8816, 

/****************
 * char 121-126 *
 ****************/

69.2640, 64.6464, 64.6464, 36.9408, 64.6464, 110.8224, 

/*************************
 * char: 32   strokes: 0 *
 *************************/

GAMGI_IO_CHAR,

/*************************
 * char: 33 ! strokes: 2 *
 *************************/

23.0880, 99.2784, 23.0880, 34.6320, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 6.9264, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 34 " strokes: 2 *
 *************************/

18.4704, 99.2784, 18.4704, 66.9552, GAMGI_IO_STROKE,

55.4112, 99.2784, 55.4112, 66.9552, GAMGI_IO_CHAR,

/*************************
 * char: 35 # strokes: 4 *
 *************************/

36.9408, 99.2784, 36.9408, -30.0144, GAMGI_IO_STROKE,

64.6464, 99.2784, 64.6464, -30.0144, GAMGI_IO_STROKE,

13.8528, 48.4848, 87.7344, 48.4848, GAMGI_IO_STROKE,

13.8528, 20.7792, 87.7344, 20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 36 $ strokes: 3 *
 *************************/

36.9408, 117.7488, 36.9408, -16.1616, GAMGI_IO_STROKE,

55.4112, 117.7488, 55.4112, -16.1616, GAMGI_IO_STROKE,

78.4992, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, 23.0880, 94.6608, 13.8528, 85.4256, 13.8528, 76.1904, 18.4704, 66.9552, 23.0880, 62.3376, 32.3232, 57.7200, 60.0288, 48.4848, 69.2640, 43.8672, 73.8816, 39.2496, 78.4992, 30.0144, 78.4992, 16.1616, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 13.8528, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 37 % strokes: 3 *
 *************************/

96.9696, 99.2784, 87.7344, 94.6608, 73.8816, 90.0432, 60.0288, 90.0432, 46.1760, 94.6608, 36.9408, 99.2784, 27.7056, 99.2784, 18.4704, 94.6608, 13.8528, 85.4256, 13.8528, 76.1904, 23.0880, 66.9552, 32.3232, 66.9552, 41.5584, 71.5728, 46.1760, 80.8080, 46.1760, 90.0432, 36.9408, 99.2784, GAMGI_IO_STROKE,

96.9696, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

87.7344, 34.6320, 78.4992, 34.6320, 69.2640, 30.0144, 64.6464, 20.7792, 64.6464, 11.5440, 73.8816, 2.3088, 83.1168, 2.3088, 92.3520, 6.9264, 96.9696, 16.1616, 96.9696, 25.3968, 87.7344, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 38 & strokes: 1 *
 *************************/

106.2048, 57.7200, 106.2048, 62.3376, 101.5872, 66.9552, 96.9696, 66.9552, 92.3520, 62.3376, 87.7344, 53.1024, 78.4992, 30.0144, 69.2640, 16.1616, 60.0288, 6.9264, 50.7936, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 30.0144, 18.4704, 39.2496, 23.0880, 43.8672, 55.4112, 62.3376, 60.0288, 66.9552, 64.6464, 76.1904, 64.6464, 85.4256, 60.0288, 94.6608, 50.7936, 99.2784, 41.5584, 94.6608, 36.9408, 85.4256, 36.9408, 76.1904, 41.5584, 62.3376, 50.7936, 48.4848, 73.8816, 16.1616, 83.1168, 6.9264, 92.3520, 2.3088, 101.5872, 2.3088, 106.2048, 6.9264, 106.2048, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 39 ' strokes: 1 *
 *************************/

23.0880, 90.0432, 18.4704, 94.6608, 23.0880, 99.2784, 27.7056, 94.6608, 27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 71.5728, GAMGI_IO_CHAR,

/*************************
 * char: 40 ( strokes: 1 *
 *************************/

50.7936, 117.7488, 41.5584, 108.5136, 32.3232, 94.6608, 23.0880, 76.1904, 18.4704, 53.1024, 18.4704, 34.6320, 23.0880, 11.5440, 32.3232, -6.9264, 41.5584, -20.7792, 50.7936, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 41 ) strokes: 1 *
 *************************/

13.8528, 117.7488, 23.0880, 108.5136, 32.3232, 94.6608, 41.5584, 76.1904, 46.1760, 53.1024, 46.1760, 34.6320, 41.5584, 11.5440, 32.3232, -6.9264, 23.0880, -20.7792, 13.8528, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 42 * strokes: 3 *
 *************************/

36.9408, 71.5728, 36.9408, 16.1616, GAMGI_IO_STROKE,

13.8528, 57.7200, 60.0288, 30.0144, GAMGI_IO_STROKE,

60.0288, 57.7200, 13.8528, 30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 43 + strokes: 2 *
 *************************/

60.0288, 85.4256, 60.0288, 2.3088, GAMGI_IO_STROKE,

18.4704, 43.8672, 101.5872, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 44 , strokes: 1 *
 *************************/

27.7056, 6.9264, 23.0880, 2.3088, 18.4704, 6.9264, 23.0880, 11.5440, 27.7056, 6.9264, 27.7056, -2.3088, 23.0880, -11.5440, 18.4704, -16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 45 - strokes: 1 *
 *************************/

18.4704, 43.8672, 101.5872, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 46 . strokes: 1 *
 *************************/

23.0880, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 6.9264, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 47 / strokes: 1 *
 *************************/

92.3520, 117.7488, 9.2352, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 48 0 strokes: 1 *
 *************************/

41.5584, 99.2784, 27.7056, 94.6608, 18.4704, 80.8080, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 20.7792, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 20.7792, 78.4992, 43.8672, 78.4992, 57.7200, 73.8816, 80.8080, 64.6464, 94.6608, 50.7936, 99.2784, 41.5584, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 49 1 strokes: 1 *
 *************************/

27.7056, 80.8080, 36.9408, 85.4256, 50.7936, 99.2784, 50.7936, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 50 2 strokes: 1 *
 *************************/

18.4704, 76.1904, 18.4704, 80.8080, 23.0880, 90.0432, 27.7056, 94.6608, 36.9408, 99.2784, 55.4112, 99.2784, 64.6464, 94.6608, 69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 71.5728, 69.2640, 62.3376, 60.0288, 48.4848, 13.8528, 2.3088, 78.4992, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 51 3 strokes: 1 *
 *************************/

23.0880, 99.2784, 73.8816, 99.2784, 46.1760, 62.3376, 60.0288, 62.3376, 69.2640, 57.7200, 73.8816, 53.1024, 78.4992, 39.2496, 78.4992, 30.0144, 73.8816, 16.1616, 64.6464, 6.9264, 50.7936, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 52 4 strokes: 2 *
 *************************/

60.0288, 99.2784, 13.8528, 34.6320, 83.1168, 34.6320, GAMGI_IO_STROKE,

60.0288, 99.2784, 60.0288, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 53 5 strokes: 1 *
 *************************/

69.2640, 99.2784, 23.0880, 99.2784, 18.4704, 57.7200, 23.0880, 62.3376, 36.9408, 66.9552, 50.7936, 66.9552, 64.6464, 62.3376, 73.8816, 53.1024, 78.4992, 39.2496, 78.4992, 30.0144, 73.8816, 16.1616, 64.6464, 6.9264, 50.7936, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 54 6 strokes: 1 *
 *************************/

73.8816, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 80.8080, 18.4704, 57.7200, 18.4704, 34.6320, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 30.0144, 78.4992, 34.6320, 73.8816, 48.4848, 64.6464, 57.7200, 50.7936, 62.3376, 46.1760, 62.3376, 32.3232, 57.7200, 23.0880, 48.4848, 18.4704, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 55 7 strokes: 2 *
 *************************/

78.4992, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 78.4992, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 56 8 strokes: 1 *
 *************************/

36.9408, 99.2784, 23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 76.1904, 23.0880, 66.9552, 32.3232, 62.3376, 50.7936, 57.7200, 64.6464, 53.1024, 73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 20.7792, 73.8816, 11.5440, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 34.6320, 18.4704, 43.8672, 27.7056, 53.1024, 41.5584, 57.7200, 60.0288, 62.3376, 69.2640, 66.9552, 73.8816, 76.1904, 73.8816, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 57 9 strokes: 1 *
 *************************/

73.8816, 66.9552, 69.2640, 53.1024, 60.0288, 43.8672, 46.1760, 39.2496, 41.5584, 39.2496, 27.7056, 43.8672, 18.4704, 53.1024, 13.8528, 66.9552, 13.8528, 71.5728, 18.4704, 85.4256, 27.7056, 94.6608, 41.5584, 99.2784, 46.1760, 99.2784, 60.0288, 94.6608, 69.2640, 85.4256, 73.8816, 66.9552, 73.8816, 43.8672, 69.2640, 20.7792, 60.0288, 6.9264, 46.1760, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 58 : strokes: 2 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 23.0880, 57.7200, 27.7056, 62.3376, 23.0880, 66.9552, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 6.9264, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 59 ; strokes: 2 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 23.0880, 57.7200, 27.7056, 62.3376, 23.0880, 66.9552, GAMGI_IO_STROKE,

27.7056, 6.9264, 23.0880, 2.3088, 18.4704, 6.9264, 23.0880, 11.5440, 27.7056, 6.9264, 27.7056, -2.3088, 23.0880, -11.5440, 18.4704, -16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 60 < strokes: 1 *
 *************************/

92.3520, 85.4256, 18.4704, 43.8672, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 61 = strokes: 2 *
 *************************/

18.4704, 57.7200, 101.5872, 57.7200, GAMGI_IO_STROKE,

18.4704, 30.0144, 101.5872, 30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 62 > strokes: 1 *
 *************************/

18.4704, 85.4256, 92.3520, 43.8672, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 63 ? strokes: 2 *
 *************************/

13.8528, 76.1904, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 32.3232, 99.2784, 50.7936, 99.2784, 60.0288, 94.6608, 64.6464, 90.0432, 69.2640, 80.8080, 69.2640, 71.5728, 64.6464, 62.3376, 60.0288, 57.7200, 41.5584, 48.4848, 41.5584, 34.6320, GAMGI_IO_STROKE,

41.5584, 11.5440, 36.9408, 6.9264, 41.5584, 2.3088, 46.1760, 6.9264, 41.5584, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 64 @ strokes: 2 *
 *************************/

87.7344, 62.3376, 83.1168, 71.5728, 73.8816, 76.1904, 60.0288, 76.1904, 50.7936, 71.5728, 46.1760, 66.9552, 41.5584, 57.7200, 41.5584, 43.8672, 46.1760, 34.6320, 50.7936, 30.0144, 60.0288, 25.3968, 73.8816, 25.3968, 83.1168, 30.0144, 87.7344, 39.2496, GAMGI_IO_STROKE,

87.7344, 76.1904, 87.7344, 39.2496, 92.3520, 30.0144, 96.9696, 25.3968, 106.2048, 25.3968, 110.8224, 30.0144, 115.4400, 39.2496, 115.4400, 57.7200, 110.8224, 71.5728, 106.2048, 80.8080, 96.9696, 90.0432, 87.7344, 94.6608, 73.8816, 99.2784, 60.0288, 99.2784, 46.1760, 94.6608, 36.9408, 90.0432, 27.7056, 80.8080, 23.0880, 71.5728, 18.4704, 57.7200, 18.4704, 43.8672, 23.0880, 30.0144, 27.7056, 20.7792, 36.9408, 11.5440, 46.1760, 6.9264, 60.0288, 2.3088, 73.8816, 2.3088, 87.7344, 6.9264, 96.9696, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 65 A strokes: 1 *
 *************************/

0.0000, 2.3088, 9.2352, 6.9264, 23.0880, 20.7792, 36.9408, 39.2496, 55.4112, 71.5728, 69.2640, 99.2784, 69.2640, 2.3088, 64.6464, 16.1616, 55.4112, 30.0144, 46.1760, 39.2496, 32.3232, 48.4848, 23.0880, 48.4848, 18.4704, 43.8672, 18.4704, 34.6320, 23.0880, 25.3968, 32.3232, 16.1616, 46.1760, 6.9264, 60.0288, 2.3088, 83.1168, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 66 B strokes: 2 *
 *************************/

60.0288, 90.0432, 64.6464, 85.4256, 64.6464, 71.5728, 60.0288, 53.1024, 55.4112, 39.2496, 50.7936, 30.0144, 41.5584, 16.1616, 32.3232, 6.9264, 23.0880, 2.3088, 18.4704, 2.3088, 13.8528, 6.9264, 13.8528, 20.7792, 18.4704, 43.8672, 23.0880, 57.7200, 27.7056, 66.9552, 36.9408, 80.8080, 46.1760, 90.0432, 55.4112, 94.6608, 69.2640, 99.2784, 83.1168, 99.2784, 92.3520, 94.6608, 96.9696, 85.4256, 96.9696, 76.1904, 92.3520, 66.9552, 87.7344, 62.3376, 78.4992, 57.7200, 64.6464, 53.1024, GAMGI_IO_STROKE,

60.0288, 53.1024, 64.6464, 53.1024, 78.4992, 48.4848, 83.1168, 43.8672, 87.7344, 34.6320, 87.7344, 20.7792, 83.1168, 11.5440, 78.4992, 6.9264, 69.2640, 2.3088, 55.4112, 2.3088, 46.1760, 6.9264, 41.5584, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 67 C strokes: 1 *
 *************************/

55.4112, 71.5728, 55.4112, 66.9552, 60.0288, 62.3376, 69.2640, 62.3376, 78.4992, 66.9552, 83.1168, 76.1904, 83.1168, 85.4256, 78.4992, 94.6608, 69.2640, 99.2784, 55.4112, 99.2784, 41.5584, 94.6608, 32.3232, 85.4256, 23.0880, 71.5728, 18.4704, 62.3376, 13.8528, 43.8672, 13.8528, 25.3968, 18.4704, 11.5440, 23.0880, 6.9264, 32.3232, 2.3088, 41.5584, 2.3088, 55.4112, 6.9264, 64.6464, 16.1616, 69.2640, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 68 D strokes: 1 *
 *************************/

60.0288, 99.2784, 50.7936, 94.6608, 46.1760, 85.4256, 41.5584, 66.9552, 36.9408, 39.2496, 32.3232, 25.3968, 27.7056, 16.1616, 18.4704, 6.9264, 9.2352, 2.3088, 0.0000, 2.3088, -4.6176, 6.9264, -4.6176, 16.1616, 0.0000, 20.7792, 9.2352, 20.7792, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 87.7344, 34.6320, 92.3520, 57.7200, 92.3520, 76.1904, 87.7344, 90.0432, 83.1168, 94.6608, 73.8816, 99.2784, 60.0288, 99.2784, 50.7936, 90.0432, 50.7936, 80.8080, 55.4112, 66.9552, 64.6464, 53.1024, 73.8816, 43.8672, 87.7344, 34.6320, 96.9696, 30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 69 E strokes: 1 *
 *************************/

64.6464, 80.8080, 64.6464, 76.1904, 69.2640, 71.5728, 78.4992, 71.5728, 83.1168, 76.1904, 83.1168, 85.4256, 78.4992, 94.6608, 64.6464, 99.2784, 46.1760, 99.2784, 32.3232, 94.6608, 27.7056, 85.4256, 27.7056, 71.5728, 32.3232, 62.3376, 36.9408, 57.7200, 50.7936, 53.1024, 36.9408, 53.1024, 23.0880, 48.4848, 18.4704, 43.8672, 13.8528, 34.6320, 13.8528, 20.7792, 18.4704, 11.5440, 23.0880, 6.9264, 36.9408, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 70 F strokes: 3 *
 *************************/

46.1760, 71.5728, 36.9408, 71.5728, 27.7056, 76.1904, 23.0880, 85.4256, 27.7056, 94.6608, 41.5584, 99.2784, 55.4112, 99.2784, 73.8816, 94.6608, 87.7344, 94.6608, 96.9696, 99.2784, GAMGI_IO_STROKE,

73.8816, 94.6608, 64.6464, 62.3376, 55.4112, 34.6320, 46.1760, 16.1616, 36.9408, 6.9264, 27.7056, 2.3088, 18.4704, 2.3088, 9.2352, 6.9264, 4.6176, 16.1616, 4.6176, 25.3968, 9.2352, 30.0144, 18.4704, 30.0144, 27.7056, 25.3968, GAMGI_IO_STROKE,

41.5584, 53.1024, 83.1168, 53.1024, GAMGI_IO_CHAR,

/*************************
 * char: 71 G strokes: 1 *
 *************************/

0.0000, 2.3088, 9.2352, 6.9264, 27.7056, 25.3968, 41.5584, 48.4848, 46.1760, 62.3376, 50.7936, 80.8080, 50.7936, 94.6608, 46.1760, 99.2784, 41.5584, 99.2784, 36.9408, 94.6608, 32.3232, 85.4256, 32.3232, 71.5728, 36.9408, 62.3376, 46.1760, 57.7200, 64.6464, 57.7200, 78.4992, 62.3376, 83.1168, 66.9552, 87.7344, 76.1904, 87.7344, 48.4848, 83.1168, 25.3968, 78.4992, 16.1616, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 13.8528, 16.1616, 9.2352, 25.3968, 9.2352, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 72 H strokes: 2 *
 *************************/

32.3232, 66.9552, 23.0880, 71.5728, 18.4704, 80.8080, 18.4704, 85.4256, 23.0880, 94.6608, 32.3232, 99.2784, 36.9408, 99.2784, 46.1760, 94.6608, 50.7936, 85.4256, 50.7936, 76.1904, 46.1760, 57.7200, 36.9408, 30.0144, 27.7056, 11.5440, 18.4704, 2.3088, 9.2352, 2.3088, 4.6176, 6.9264, 4.6176, 16.1616, GAMGI_IO_STROKE,

32.3232, 43.8672, 73.8816, 57.7200, 83.1168, 62.3376, 96.9696, 71.5728, 106.2048, 80.8080, 110.8224, 90.0432, 110.8224, 94.6608, 106.2048, 99.2784, 101.5872, 99.2784, 92.3520, 90.0432, 83.1168, 71.5728, 73.8816, 43.8672, 69.2640, 20.7792, 69.2640, 6.9264, 73.8816, 2.3088, 78.4992, 2.3088, 87.7344, 6.9264, 92.3520, 11.5440, 101.5872, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 73 I strokes: 1 *
 *************************/

64.6464, 25.3968, 55.4112, 34.6320, 46.1760, 48.4848, 41.5584, 57.7200, 36.9408, 71.5728, 36.9408, 85.4256, 41.5584, 94.6608, 46.1760, 99.2784, 55.4112, 99.2784, 60.0288, 94.6608, 64.6464, 85.4256, 64.6464, 71.5728, 60.0288, 48.4848, 50.7936, 25.3968, 46.1760, 16.1616, 36.9408, 6.9264, 27.7056, 2.3088, 18.4704, 2.3088, 9.2352, 6.9264, 4.6176, 16.1616, 4.6176, 25.3968, 9.2352, 30.0144, 18.4704, 30.0144, 27.7056, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 74 J strokes: 1 *
 *************************/

46.1760, -11.5440, 36.9408, 2.3088, 27.7056, 25.3968, 23.0880, 53.1024, 23.0880, 80.8080, 27.7056, 94.6608, 36.9408, 99.2784, 46.1760, 99.2784, 50.7936, 94.6608, 55.4112, 80.8080, 55.4112, 66.9552, 50.7936, 43.8672, 36.9408, 2.3088, 27.7056, -25.3968, 23.0880, -39.2496, 18.4704, -48.4848, 9.2352, -53.1024, 4.6176, -48.4848, 4.6176, -39.2496, 9.2352, -25.3968, 18.4704, -11.5440, 27.7056, -2.3088, 41.5584, 6.9264, 60.0288, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 75 K strokes: 3 *
 *************************/

32.3232, 66.9552, 23.0880, 71.5728, 18.4704, 80.8080, 18.4704, 85.4256, 23.0880, 94.6608, 32.3232, 99.2784, 36.9408, 99.2784, 46.1760, 94.6608, 50.7936, 85.4256, 50.7936, 76.1904, 46.1760, 57.7200, 36.9408, 30.0144, 27.7056, 11.5440, 18.4704, 2.3088, 9.2352, 2.3088, 4.6176, 6.9264, 4.6176, 16.1616, GAMGI_IO_STROKE,

110.8224, 85.4256, 110.8224, 94.6608, 106.2048, 99.2784, 101.5872, 99.2784, 92.3520, 94.6608, 83.1168, 85.4256, 73.8816, 71.5728, 64.6464, 62.3376, 55.4112, 57.7200, 46.1760, 57.7200, GAMGI_IO_STROKE,

55.4112, 57.7200, 60.0288, 48.4848, 60.0288, 16.1616, 64.6464, 6.9264, 69.2640, 2.3088, 73.8816, 2.3088, 83.1168, 6.9264, 87.7344, 11.5440, 96.9696, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 76 L strokes: 1 *
 *************************/

18.4704, 43.8672, 27.7056, 43.8672, 46.1760, 48.4848, 60.0288, 57.7200, 69.2640, 66.9552, 73.8816, 76.1904, 73.8816, 90.0432, 69.2640, 99.2784, 60.0288, 99.2784, 55.4112, 94.6608, 50.7936, 85.4256, 46.1760, 62.3376, 41.5584, 39.2496, 36.9408, 25.3968, 32.3232, 16.1616, 23.0880, 6.9264, 13.8528, 2.3088, 4.6176, 2.3088, 0.0000, 6.9264, 0.0000, 16.1616, 4.6176, 20.7792, 13.8528, 20.7792, 23.0880, 16.1616, 36.9408, 6.9264, 50.7936, 2.3088, 60.0288, 2.3088, 73.8816, 6.9264, 83.1168, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 77 M strokes: 3 *
 *************************/

23.0880, 66.9552, 13.8528, 71.5728, 9.2352, 80.8080, 9.2352, 85.4256, 13.8528, 94.6608, 23.0880, 99.2784, 27.7056, 99.2784, 36.9408, 94.6608, 41.5584, 85.4256, 41.5584, 76.1904, 36.9408, 53.1024, 32.3232, 34.6320, 23.0880, 2.3088, GAMGI_IO_STROKE,

32.3232, 34.6320, 46.1760, 71.5728, 55.4112, 90.0432, 60.0288, 94.6608, 69.2640, 99.2784, 73.8816, 99.2784, 83.1168, 94.6608, 87.7344, 85.4256, 87.7344, 76.1904, 83.1168, 53.1024, 78.4992, 34.6320, 69.2640, 2.3088, GAMGI_IO_STROKE,

78.4992, 34.6320, 92.3520, 71.5728, 101.5872, 90.0432, 106.2048, 94.6608, 115.4400, 99.2784, 120.0576, 99.2784, 129.2928, 94.6608, 133.9104, 85.4256, 133.9104, 76.1904, 129.2928, 53.1024, 120.0576, 20.7792, 120.0576, 6.9264, 124.6752, 2.3088, 129.2928, 2.3088, 138.5280, 6.9264, 143.1456, 11.5440, 152.3808, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 78 N strokes: 2 *
 *************************/

23.0880, 66.9552, 13.8528, 71.5728, 9.2352, 80.8080, 9.2352, 85.4256, 13.8528, 94.6608, 23.0880, 99.2784, 27.7056, 99.2784, 36.9408, 94.6608, 41.5584, 85.4256, 41.5584, 76.1904, 36.9408, 53.1024, 32.3232, 34.6320, 23.0880, 2.3088, GAMGI_IO_STROKE,

32.3232, 34.6320, 46.1760, 71.5728, 55.4112, 90.0432, 60.0288, 94.6608, 69.2640, 99.2784, 78.4992, 99.2784, 87.7344, 94.6608, 92.3520, 85.4256, 92.3520, 76.1904, 87.7344, 53.1024, 78.4992, 20.7792, 78.4992, 6.9264, 83.1168, 2.3088, 87.7344, 2.3088, 96.9696, 6.9264, 101.5872, 11.5440, 110.8224, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 79 O strokes: 1 *
 *************************/

55.4112, 99.2784, 41.5584, 94.6608, 32.3232, 85.4256, 23.0880, 71.5728, 18.4704, 62.3376, 13.8528, 43.8672, 13.8528, 25.3968, 18.4704, 11.5440, 23.0880, 6.9264, 32.3232, 2.3088, 41.5584, 2.3088, 55.4112, 6.9264, 64.6464, 16.1616, 73.8816, 30.0144, 78.4992, 39.2496, 83.1168, 57.7200, 83.1168, 76.1904, 78.4992, 90.0432, 73.8816, 94.6608, 64.6464, 99.2784, 55.4112, 99.2784, 46.1760, 90.0432, 46.1760, 76.1904, 50.7936, 62.3376, 60.0288, 48.4848, 69.2640, 39.2496, 83.1168, 30.0144, 92.3520, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 80 P strokes: 1 *
 *************************/

60.0288, 90.0432, 64.6464, 85.4256, 64.6464, 71.5728, 60.0288, 53.1024, 55.4112, 39.2496, 50.7936, 30.0144, 41.5584, 16.1616, 32.3232, 6.9264, 23.0880, 2.3088, 18.4704, 2.3088, 13.8528, 6.9264, 13.8528, 20.7792, 18.4704, 43.8672, 23.0880, 57.7200, 27.7056, 66.9552, 36.9408, 80.8080, 46.1760, 90.0432, 55.4112, 94.6608, 69.2640, 99.2784, 92.3520, 99.2784, 101.5872, 94.6608, 106.2048, 90.0432, 110.8224, 80.8080, 110.8224, 66.9552, 106.2048, 57.7200, 101.5872, 53.1024, 92.3520, 48.4848, 78.4992, 48.4848, 69.2640, 53.1024, 64.6464, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 81 Q strokes: 1 *
 *************************/

60.0288, 71.5728, 55.4112, 62.3376, 50.7936, 57.7200, 41.5584, 53.1024, 32.3232, 53.1024, 27.7056, 62.3376, 27.7056, 71.5728, 32.3232, 85.4256, 41.5584, 94.6608, 55.4112, 99.2784, 69.2640, 99.2784, 78.4992, 94.6608, 83.1168, 85.4256, 83.1168, 66.9552, 78.4992, 53.1024, 69.2640, 39.2496, 50.7936, 20.7792, 36.9408, 11.5440, 27.7056, 6.9264, 13.8528, 2.3088, 4.6176, 2.3088, 0.0000, 6.9264, 0.0000, 16.1616, 4.6176, 20.7792, 13.8528, 20.7792, 23.0880, 16.1616, 36.9408, 6.9264, 50.7936, 2.3088, 64.6464, 2.3088, 78.4992, 6.9264, 87.7344, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 82 R strokes: 1 *
 *************************/

60.0288, 90.0432, 64.6464, 85.4256, 64.6464, 71.5728, 60.0288, 53.1024, 55.4112, 39.2496, 50.7936, 30.0144, 41.5584, 16.1616, 32.3232, 6.9264, 23.0880, 2.3088, 18.4704, 2.3088, 13.8528, 6.9264, 13.8528, 20.7792, 18.4704, 43.8672, 23.0880, 57.7200, 27.7056, 66.9552, 36.9408, 80.8080, 46.1760, 90.0432, 55.4112, 94.6608, 69.2640, 99.2784, 87.7344, 99.2784, 96.9696, 94.6608, 101.5872, 90.0432, 106.2048, 80.8080, 106.2048, 66.9552, 101.5872, 57.7200, 96.9696, 53.1024, 87.7344, 48.4848, 73.8816, 48.4848, 60.0288, 53.1024, 64.6464, 48.4848, 69.2640, 39.2496, 69.2640, 16.1616, 73.8816, 6.9264, 83.1168, 2.3088, 92.3520, 6.9264, 96.9696, 11.5440, 106.2048, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 83 S strokes: 1 *
 *************************/

0.0000, 2.3088, 9.2352, 6.9264, 18.4704, 16.1616, 32.3232, 34.6320, 41.5584, 48.4848, 50.7936, 66.9552, 55.4112, 80.8080, 55.4112, 94.6608, 50.7936, 99.2784, 46.1760, 99.2784, 41.5584, 94.6608, 36.9408, 85.4256, 36.9408, 76.1904, 41.5584, 66.9552, 50.7936, 57.7200, 64.6464, 48.4848, 73.8816, 39.2496, 78.4992, 30.0144, 78.4992, 20.7792, 73.8816, 11.5440, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 13.8528, 16.1616, 9.2352, 25.3968, 9.2352, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 84 T strokes: 2 *
 *************************/

46.1760, 71.5728, 36.9408, 71.5728, 27.7056, 76.1904, 23.0880, 85.4256, 27.7056, 94.6608, 41.5584, 99.2784, 55.4112, 99.2784, 73.8816, 94.6608, 87.7344, 94.6608, 96.9696, 99.2784, GAMGI_IO_STROKE,

73.8816, 94.6608, 64.6464, 62.3376, 55.4112, 34.6320, 46.1760, 16.1616, 36.9408, 6.9264, 27.7056, 2.3088, 18.4704, 2.3088, 9.2352, 6.9264, 4.6176, 16.1616, 4.6176, 25.3968, 9.2352, 30.0144, 18.4704, 30.0144, 27.7056, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 85 U strokes: 2 *
 *************************/

23.0880, 66.9552, 13.8528, 71.5728, 9.2352, 80.8080, 9.2352, 85.4256, 13.8528, 94.6608, 23.0880, 99.2784, 27.7056, 99.2784, 36.9408, 94.6608, 41.5584, 85.4256, 41.5584, 76.1904, 36.9408, 57.7200, 32.3232, 43.8672, 27.7056, 25.3968, 27.7056, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 11.5440, 73.8816, 30.0144, 87.7344, 66.9552, 96.9696, 99.2784, GAMGI_IO_STROKE,

87.7344, 66.9552, 83.1168, 48.4848, 78.4992, 20.7792, 78.4992, 6.9264, 83.1168, 2.3088, 87.7344, 2.3088, 96.9696, 6.9264, 101.5872, 11.5440, 110.8224, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 86 V strokes: 1 *
 *************************/

23.0880, 66.9552, 13.8528, 71.5728, 9.2352, 80.8080, 9.2352, 85.4256, 13.8528, 94.6608, 23.0880, 99.2784, 27.7056, 99.2784, 36.9408, 94.6608, 41.5584, 85.4256, 41.5584, 76.1904, 36.9408, 57.7200, 32.3232, 43.8672, 27.7056, 25.3968, 27.7056, 11.5440, 32.3232, 2.3088, 41.5584, 2.3088, 50.7936, 6.9264, 64.6464, 20.7792, 73.8816, 34.6320, 83.1168, 53.1024, 87.7344, 66.9552, 92.3520, 85.4256, 92.3520, 94.6608, 87.7344, 99.2784, 83.1168, 99.2784, 78.4992, 94.6608, 73.8816, 85.4256, 73.8816, 76.1904, 78.4992, 62.3376, 87.7344, 53.1024, 96.9696, 48.4848, GAMGI_IO_CHAR,

/*************************
 * char: 87 W strokes: 4 *
 *************************/

23.0880, 66.9552, 13.8528, 71.5728, 9.2352, 80.8080, 9.2352, 85.4256, 13.8528, 94.6608, 23.0880, 99.2784, 27.7056, 99.2784, 36.9408, 94.6608, 41.5584, 85.4256, 41.5584, 71.5728, 36.9408, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 36.9408, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 73.8816, 2.3088, GAMGI_IO_STROKE,

138.5280, 99.2784, 129.2928, 94.6608, 115.4400, 80.8080, 101.5872, 62.3376, 87.7344, 34.6320, 73.8816, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 88 X strokes: 2 *
 *************************/

36.9408, 71.5728, 27.7056, 71.5728, 23.0880, 76.1904, 23.0880, 85.4256, 27.7056, 94.6608, 36.9408, 99.2784, 46.1760, 99.2784, 55.4112, 94.6608, 60.0288, 85.4256, 60.0288, 71.5728, 50.7936, 30.0144, 50.7936, 16.1616, 55.4112, 6.9264, 64.6464, 2.3088, 73.8816, 2.3088, 83.1168, 6.9264, 87.7344, 16.1616, 87.7344, 25.3968, 83.1168, 30.0144, 73.8816, 30.0144, GAMGI_IO_STROKE,

106.2048, 85.4256, 106.2048, 94.6608, 101.5872, 99.2784, 92.3520, 99.2784, 83.1168, 94.6608, 73.8816, 85.4256, 64.6464, 71.5728, 46.1760, 30.0144, 36.9408, 16.1616, 27.7056, 6.9264, 18.4704, 2.3088, 9.2352, 2.3088, 4.6176, 6.9264, 4.6176, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 89 Y strokes: 2 *
 *************************/

23.0880, 66.9552, 13.8528, 71.5728, 9.2352, 80.8080, 9.2352, 85.4256, 13.8528, 94.6608, 23.0880, 99.2784, 27.7056, 99.2784, 36.9408, 94.6608, 41.5584, 85.4256, 41.5584, 76.1904, 36.9408, 57.7200, 32.3232, 43.8672, 27.7056, 25.3968, 27.7056, 16.1616, 32.3232, 6.9264, 36.9408, 2.3088, 46.1760, 2.3088, 55.4112, 6.9264, 64.6464, 16.1616, 73.8816, 30.0144, 78.4992, 39.2496, 87.7344, 66.9552, GAMGI_IO_STROKE,

96.9696, 99.2784, 87.7344, 66.9552, 73.8816, 20.7792, 64.6464, -6.9264, 55.4112, -30.0144, 46.1760, -48.4848, 36.9408, -53.1024, 32.3232, -48.4848, 32.3232, -39.2496, 36.9408, -25.3968, 46.1760, -11.5440, 60.0288, 2.3088, 73.8816, 11.5440, 96.9696, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 90 Z strokes: 1 *
 *************************/

60.0288, 71.5728, 55.4112, 62.3376, 50.7936, 57.7200, 41.5584, 53.1024, 32.3232, 53.1024, 27.7056, 62.3376, 27.7056, 71.5728, 32.3232, 85.4256, 41.5584, 94.6608, 55.4112, 99.2784, 69.2640, 99.2784, 78.4992, 94.6608, 83.1168, 85.4256, 83.1168, 66.9552, 78.4992, 53.1024, 69.2640, 34.6320, 55.4112, 20.7792, 36.9408, 6.9264, 27.7056, 2.3088, 13.8528, 2.3088, 9.2352, 6.9264, 9.2352, 16.1616, 13.8528, 20.7792, 27.7056, 20.7792, 36.9408, 16.1616, 41.5584, 11.5440, 46.1760, 2.3088, 46.1760, -11.5440, 41.5584, -25.3968, 36.9408, -34.6320, 27.7056, -48.4848, 18.4704, -53.1024, 13.8528, -48.4848, 13.8528, -39.2496, 18.4704, -25.3968, 27.7056, -11.5440, 41.5584, 2.3088, 55.4112, 11.5440, 83.1168, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 91 [ strokes: 3 *
 *************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_STROKE,

18.4704, 117.7488, 50.7936, 117.7488, GAMGI_IO_STROKE,

18.4704, -30.0144, 50.7936, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 92 \ strokes: 1 *
 *************************/

9.2352, 117.7488, 92.3520, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 93 ] strokes: 3 *
 *************************/

46.1760, 117.7488, 46.1760, -30.0144, GAMGI_IO_STROKE,

13.8528, 117.7488, 46.1760, 117.7488, GAMGI_IO_STROKE,

13.8528, -30.0144, 46.1760, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 94 ^ strokes: 2 *
 *************************/

27.7056, 71.5728, 36.9408, 85.4256, 46.1760, 71.5728, GAMGI_IO_STROKE,

13.8528, 57.7200, 36.9408, 80.8080, 60.0288, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 95 _ strokes: 1 *
 *************************/

9.2352, -6.9264, 92.3520, -6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 96 ` strokes: 1 *
 *************************/

27.7056, 99.2784, 23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 76.1904, 23.0880, 71.5728, 27.7056, 76.1904, 23.0880, 80.8080, GAMGI_IO_CHAR,

/*************************
 * char: 97 a strokes: 1 *
 *************************/

41.5584, 30.0144, 36.9408, 39.2496, 27.7056, 43.8672, 18.4704, 43.8672, 9.2352, 39.2496, 4.6176, 34.6320, 0.0000, 25.3968, 0.0000, 16.1616, 4.6176, 6.9264, 13.8528, 2.3088, 23.0880, 2.3088, 32.3232, 6.9264, 36.9408, 16.1616, 46.1760, 43.8672, 41.5584, 20.7792, 41.5584, 6.9264, 46.1760, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 11.5440, 73.8816, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 98 b strokes: 1 *
 *************************/

0.0000, 25.3968, 9.2352, 39.2496, 23.0880, 62.3376, 27.7056, 71.5728, 32.3232, 85.4256, 32.3232, 94.6608, 27.7056, 99.2784, 18.4704, 94.6608, 13.8528, 85.4256, 9.2352, 66.9552, 4.6176, 34.6320, 4.6176, 6.9264, 9.2352, 2.3088, 13.8528, 2.3088, 23.0880, 6.9264, 32.3232, 16.1616, 36.9408, 30.0144, 36.9408, 43.8672, 41.5584, 25.3968, 46.1760, 20.7792, 55.4112, 20.7792, 64.6464, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 99 c strokes: 1 *
 *************************/

32.3232, 34.6320, 32.3232, 39.2496, 27.7056, 43.8672, 18.4704, 43.8672, 9.2352, 39.2496, 4.6176, 34.6320, 0.0000, 25.3968, 0.0000, 16.1616, 4.6176, 6.9264, 13.8528, 2.3088, 27.7056, 2.3088, 41.5584, 11.5440, 50.7936, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 100 d strokes: 2 *
 **************************/

41.5584, 30.0144, 36.9408, 39.2496, 27.7056, 43.8672, 18.4704, 43.8672, 9.2352, 39.2496, 4.6176, 34.6320, 0.0000, 25.3968, 0.0000, 16.1616, 4.6176, 6.9264, 13.8528, 2.3088, 23.0880, 2.3088, 32.3232, 6.9264, 36.9408, 16.1616, 64.6464, 99.2784, GAMGI_IO_STROKE,

46.1760, 43.8672, 41.5584, 20.7792, 41.5584, 6.9264, 46.1760, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 11.5440, 73.8816, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 101 e strokes: 1 *
 **************************/

4.6176, 11.5440, 13.8528, 16.1616, 18.4704, 20.7792, 23.0880, 30.0144, 23.0880, 39.2496, 18.4704, 43.8672, 13.8528, 43.8672, 4.6176, 39.2496, 0.0000, 30.0144, 0.0000, 16.1616, 4.6176, 6.9264, 13.8528, 2.3088, 23.0880, 2.3088, 32.3232, 6.9264, 36.9408, 11.5440, 46.1760, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 102 f strokes: 1 *
 **************************/

0.0000, 25.3968, 18.4704, 48.4848, 27.7056, 62.3376, 32.3232, 71.5728, 36.9408, 85.4256, 36.9408, 94.6608, 32.3232, 99.2784, 23.0880, 94.6608, 18.4704, 85.4256, 9.2352, 48.4848, -4.6176, 6.9264, -18.4704, -25.3968, -23.0880, -39.2496, -23.0880, -48.4848, -18.4704, -53.1024, -9.2352, -48.4848, -4.6176, -34.6320, 0.0000, 6.9264, 4.6176, 2.3088, 13.8528, 2.3088, 23.0880, 6.9264, 27.7056, 11.5440, 36.9408, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 103 g strokes: 2 *
 **************************/

41.5584, 30.0144, 36.9408, 39.2496, 27.7056, 43.8672, 18.4704, 43.8672, 9.2352, 39.2496, 4.6176, 34.6320, 0.0000, 25.3968, 0.0000, 16.1616, 4.6176, 6.9264, 13.8528, 2.3088, 23.0880, 2.3088, 32.3232, 6.9264, 36.9408, 11.5440, GAMGI_IO_STROKE,

46.1760, 43.8672, 36.9408, 11.5440, 18.4704, -39.2496, 13.8528, -48.4848, 4.6176, -53.1024, 0.0000, -48.4848, 0.0000, -39.2496, 4.6176, -25.3968, 18.4704, -11.5440, 32.3232, -2.3088, 41.5584, 2.3088, 55.4112, 11.5440, 69.2640, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 104 h strokes: 2 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 23.0880, 62.3376, 27.7056, 71.5728, 32.3232, 85.4256, 32.3232, 94.6608, 27.7056, 99.2784, 18.4704, 94.6608, 13.8528, 85.4256, 9.2352, 66.9552, 4.6176, 39.2496, 0.0000, 2.3088, GAMGI_IO_STROKE,

0.0000, 2.3088, 4.6176, 16.1616, 9.2352, 25.3968, 18.4704, 39.2496, 27.7056, 43.8672, 36.9408, 43.8672, 41.5584, 39.2496, 41.5584, 30.0144, 36.9408, 16.1616, 36.9408, 6.9264, 41.5584, 2.3088, 46.1760, 2.3088, 55.4112, 6.9264, 60.0288, 11.5440, 69.2640, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 105 i strokes: 2 *
 **************************/

13.8528, 66.9552, 13.8528, 62.3376, 18.4704, 62.3376, 18.4704, 66.9552, 13.8528, 66.9552, GAMGI_IO_STROKE,

0.0000, 25.3968, 9.2352, 43.8672, 0.0000, 16.1616, 0.0000, 6.9264, 4.6176, 2.3088, 9.2352, 2.3088, 18.4704, 6.9264, 23.0880, 11.5440, 32.3232, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 106 j strokes: 2 *
 **************************/

13.8528, 66.9552, 13.8528, 62.3376, 18.4704, 62.3376, 18.4704, 66.9552, 13.8528, 66.9552, GAMGI_IO_STROKE,

0.0000, 25.3968, 9.2352, 43.8672, -18.4704, -39.2496, -23.0880, -48.4848, -32.3232, -53.1024, -36.9408, -48.4848, -36.9408, -39.2496, -32.3232, -25.3968, -18.4704, -11.5440, -4.6176, -2.3088, 4.6176, 2.3088, 18.4704, 11.5440, 32.3232, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 107 k strokes: 3 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 23.0880, 62.3376, 27.7056, 71.5728, 32.3232, 85.4256, 32.3232, 94.6608, 27.7056, 99.2784, 18.4704, 94.6608, 13.8528, 85.4256, 9.2352, 66.9552, 4.6176, 39.2496, 0.0000, 2.3088, GAMGI_IO_STROKE,

0.0000, 2.3088, 4.6176, 16.1616, 9.2352, 25.3968, 18.4704, 39.2496, 27.7056, 43.8672, 36.9408, 43.8672, 41.5584, 39.2496, 41.5584, 30.0144, 32.3232, 25.3968, 18.4704, 25.3968, GAMGI_IO_STROKE,

18.4704, 25.3968, 27.7056, 20.7792, 32.3232, 6.9264, 36.9408, 2.3088, 41.5584, 2.3088, 50.7936, 6.9264, 55.4112, 11.5440, 64.6464, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 108 l strokes: 1 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 23.0880, 62.3376, 27.7056, 71.5728, 32.3232, 85.4256, 32.3232, 94.6608, 27.7056, 99.2784, 18.4704, 94.6608, 13.8528, 85.4256, 9.2352, 66.9552, 4.6176, 34.6320, 4.6176, 6.9264, 9.2352, 2.3088, 13.8528, 2.3088, 23.0880, 6.9264, 27.7056, 11.5440, 36.9408, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 109 m strokes: 3 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 18.4704, 43.8672, 23.0880, 39.2496, 23.0880, 34.6320, 18.4704, 16.1616, 13.8528, 2.3088, GAMGI_IO_STROKE,

18.4704, 16.1616, 23.0880, 25.3968, 32.3232, 39.2496, 41.5584, 43.8672, 50.7936, 43.8672, 55.4112, 39.2496, 55.4112, 34.6320, 50.7936, 16.1616, 46.1760, 2.3088, GAMGI_IO_STROKE,

50.7936, 16.1616, 55.4112, 25.3968, 64.6464, 39.2496, 73.8816, 43.8672, 83.1168, 43.8672, 87.7344, 39.2496, 87.7344, 30.0144, 83.1168, 16.1616, 83.1168, 6.9264, 87.7344, 2.3088, 92.3520, 2.3088, 101.5872, 6.9264, 106.2048, 11.5440, 115.4400, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 110 n strokes: 2 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 18.4704, 43.8672, 23.0880, 39.2496, 23.0880, 34.6320, 18.4704, 16.1616, 13.8528, 2.3088, GAMGI_IO_STROKE,

18.4704, 16.1616, 23.0880, 25.3968, 32.3232, 39.2496, 41.5584, 43.8672, 50.7936, 43.8672, 55.4112, 39.2496, 55.4112, 30.0144, 50.7936, 16.1616, 50.7936, 6.9264, 55.4112, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 73.8816, 11.5440, 83.1168, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 111 o strokes: 1 *
 **************************/

27.7056, 43.8672, 18.4704, 43.8672, 9.2352, 39.2496, 4.6176, 34.6320, 0.0000, 25.3968, 0.0000, 16.1616, 4.6176, 6.9264, 13.8528, 2.3088, 23.0880, 2.3088, 32.3232, 6.9264, 36.9408, 11.5440, 41.5584, 20.7792, 41.5584, 30.0144, 36.9408, 39.2496, 27.7056, 43.8672, 23.0880, 39.2496, 23.0880, 30.0144, 27.7056, 20.7792, 36.9408, 16.1616, 50.7936, 16.1616, 60.0288, 20.7792, 64.6464, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 112 p strokes: 3 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 13.8528, 48.4848, 9.2352, 30.0144, -18.4704, -53.1024, GAMGI_IO_STROKE,

9.2352, 30.0144, 13.8528, 39.2496, 23.0880, 43.8672, 32.3232, 43.8672, 41.5584, 39.2496, 46.1760, 30.0144, 46.1760, 20.7792, 41.5584, 11.5440, 36.9408, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

9.2352, 6.9264, 18.4704, 2.3088, 32.3232, 2.3088, 46.1760, 6.9264, 55.4112, 11.5440, 69.2640, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 113 q strokes: 2 *
 **************************/

41.5584, 30.0144, 36.9408, 39.2496, 27.7056, 43.8672, 18.4704, 43.8672, 9.2352, 39.2496, 4.6176, 34.6320, 0.0000, 25.3968, 0.0000, 16.1616, 4.6176, 6.9264, 13.8528, 2.3088, 23.0880, 2.3088, 32.3232, 6.9264, GAMGI_IO_STROKE,

46.1760, 43.8672, 41.5584, 30.0144, 32.3232, 6.9264, 18.4704, -25.3968, 13.8528, -39.2496, 13.8528, -48.4848, 18.4704, -53.1024, 27.7056, -48.4848, 32.3232, -34.6320, 32.3232, -2.3088, 41.5584, 2.3088, 55.4112, 11.5440, 69.2640, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 114 r strokes: 1 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 13.8528, 48.4848, 13.8528, 39.2496, 27.7056, 39.2496, 32.3232, 34.6320, 32.3232, 25.3968, 27.7056, 11.5440, 27.7056, 6.9264, 32.3232, 2.3088, 36.9408, 2.3088, 46.1760, 6.9264, 50.7936, 11.5440, 60.0288, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 115 s strokes: 2 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 13.8528, 48.4848, 13.8528, 39.2496, 23.0880, 25.3968, 27.7056, 16.1616, 27.7056, 6.9264, 18.4704, 2.3088, GAMGI_IO_STROKE,

0.0000, 6.9264, 9.2352, 2.3088, 27.7056, 2.3088, 36.9408, 6.9264, 41.5584, 11.5440, 50.7936, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 116 t strokes: 3 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 18.4704, 57.7200, GAMGI_IO_STROKE,

32.3232, 99.2784, 4.6176, 16.1616, 4.6176, 6.9264, 9.2352, 2.3088, 18.4704, 2.3088, 27.7056, 6.9264, 32.3232, 11.5440, 41.5584, 25.3968, GAMGI_IO_STROKE,

4.6176, 62.3376, 36.9408, 62.3376, GAMGI_IO_CHAR,

/**************************
 * char: 117 u strokes: 2 *
 **************************/

0.0000, 25.3968, 9.2352, 43.8672, 0.0000, 16.1616, 0.0000, 6.9264, 4.6176, 2.3088, 13.8528, 2.3088, 23.0880, 6.9264, 32.3232, 16.1616, 41.5584, 30.0144, GAMGI_IO_STROKE,

46.1760, 43.8672, 36.9408, 16.1616, 36.9408, 6.9264, 41.5584, 2.3088, 46.1760, 2.3088, 55.4112, 6.9264, 60.0288, 11.5440, 69.2640, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 118 v strokes: 2 *
 **************************/

0.0000, 25.3968, 9.2352, 43.8672, 4.6176, 20.7792, 4.6176, 6.9264, 9.2352, 2.3088, 13.8528, 2.3088, 27.7056, 6.9264, 36.9408, 16.1616, 41.5584, 30.0144, 41.5584, 43.8672, GAMGI_IO_STROKE,

41.5584, 43.8672, 46.1760, 25.3968, 50.7936, 20.7792, 60.0288, 20.7792, 69.2640, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 119 w strokes: 3 *
 **************************/

13.8528, 43.8672, 4.6176, 34.6320, 0.0000, 20.7792, 0.0000, 11.5440, 4.6176, 2.3088, 13.8528, 2.3088, 23.0880, 6.9264, 32.3232, 16.1616, GAMGI_IO_STROKE,

41.5584, 43.8672, 32.3232, 16.1616, 32.3232, 6.9264, 36.9408, 2.3088, 46.1760, 2.3088, 55.4112, 6.9264, 64.6464, 16.1616, 69.2640, 30.0144, 69.2640, 43.8672, GAMGI_IO_STROKE,

69.2640, 43.8672, 73.8816, 25.3968, 78.4992, 20.7792, 87.7344, 20.7792, 96.9696, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 120 x strokes: 2 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 18.4704, 43.8672, 27.7056, 43.8672, 32.3232, 39.2496, 32.3232, 6.9264, 36.9408, 2.3088, 50.7936, 2.3088, 64.6464, 11.5440, 73.8816, 25.3968, GAMGI_IO_STROKE,

60.0288, 39.2496, 55.4112, 43.8672, 46.1760, 43.8672, 41.5584, 39.2496, 23.0880, 6.9264, 18.4704, 2.3088, 9.2352, 2.3088, 4.6176, 6.9264, GAMGI_IO_CHAR,

/**************************
 * char: 121 y strokes: 2 *
 **************************/

0.0000, 25.3968, 9.2352, 43.8672, 0.0000, 16.1616, 0.0000, 6.9264, 4.6176, 2.3088, 13.8528, 2.3088, 23.0880, 6.9264, 32.3232, 16.1616, 41.5584, 30.0144, GAMGI_IO_STROKE,

46.1760, 43.8672, 18.4704, -39.2496, 13.8528, -48.4848, 4.6176, -53.1024, 0.0000, -48.4848, 0.0000, -39.2496, 4.6176, -25.3968, 18.4704, -11.5440, 32.3232, -2.3088, 41.5584, 2.3088, 55.4112, 11.5440, 69.2640, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 122 z strokes: 1 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 18.4704, 43.8672, 27.7056, 43.8672, 36.9408, 34.6320, 36.9408, 25.3968, 32.3232, 16.1616, 23.0880, 6.9264, 9.2352, 2.3088, 18.4704, -2.3088, 23.0880, -11.5440, 23.0880, -25.3968, 18.4704, -39.2496, 13.8528, -48.4848, 4.6176, -53.1024, 0.0000, -48.4848, 0.0000, -39.2496, 4.6176, -25.3968, 18.4704, -11.5440, 32.3232, -2.3088, 50.7936, 11.5440, 64.6464, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 123 { strokes: 1 *
 **************************/

41.5584, 117.7488, 27.7056, 103.8960, 23.0880, 90.0432, 23.0880, 80.8080, 27.7056, 66.9552, 36.9408, 57.7200, 36.9408, 53.1024, 18.4704, 43.8672, 36.9408, 34.6320, 36.9408, 30.0144, 27.7056, 20.7792, 23.0880, 6.9264, 23.0880, -2.3088, 27.7056, -16.1616, 41.5584, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 124 | strokes: 1 *
 **************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 125 } strokes: 1 *
 **************************/

23.0880, 117.7488, 36.9408, 103.8960, 41.5584, 90.0432, 41.5584, 80.8080, 36.9408, 66.9552, 27.7056, 57.7200, 27.7056, 53.1024, 46.1760, 43.8672, 27.7056, 34.6320, 27.7056, 30.0144, 36.9408, 20.7792, 41.5584, 6.9264, 41.5584, -2.3088, 36.9408, -16.1616, 23.0880, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 126 ~ strokes: 2 *
 **************************/

13.8528, 30.0144, 13.8528, 39.2496, 18.4704, 53.1024, 27.7056, 57.7200, 36.9408, 57.7200, 46.1760, 53.1024, 64.6464, 39.2496, 73.8816, 34.6320, 83.1168, 34.6320, 92.3520, 39.2496, 96.9696, 48.4848, GAMGI_IO_STROKE,

13.8528, 39.2496, 18.4704, 48.4848, 27.7056, 53.1024, 36.9408, 53.1024, 46.1760, 48.4848, 64.6464, 34.6320, 73.8816, 30.0144, 83.1168, 30.0144, 92.3520, 34.6320, 96.9696, 48.4848, 96.9696, 57.7200, GAMGI_IO_CHAR,

};

const float gamgi_io_font_hershey_script_bold_points[GAMGI_IO_POINTS_SCRIPT_BOLD] = {

/***************
 * bottom, top *
 ***************/

-32.3232, 120.0576,

/**************
 * char 32-40 *
 **************/

73.8816, 50.7936, 83.1168, 96.9696, 96.9696, 120.0576, 120.0576, 50.7936, 69.2640, 

/**************
 * char 41-50 *
 **************/

69.2640, 78.4992, 120.0576, 50.7936, 120.0576, 50.7936, 101.5872, 96.9696, 96.9696, 96.9696, 

/**************
 * char 51-60 *
 **************/

96.9696, 96.9696, 96.9696, 96.9696, 96.9696, 96.9696, 96.9696, 50.7936, 50.7936, 110.8224, 

/**************
 * char 61-70 *
 **************/

120.0576, 110.8224, 96.9696, 124.6752, 106.2048, 110.8224, 96.9696, 106.2048, 87.7344, 96.9696, 

/**************
 * char 71-80 *
 **************/

101.5872, 110.8224, 73.8816, 78.4992, 110.8224, 83.1168, 129.2928, 106.2048, 96.9696, 106.2048, 

/**************
 * char 81-90 *
 **************/

96.9696, 110.8224, 92.3520, 83.1168, 101.5872, 96.9696, 106.2048, 92.3520, 101.5872, 96.9696, 

/***************
 * char 91-100 *
 ***************/

64.6464, 101.5872, 64.6464, 73.8816, 101.5872, 50.7936, 73.8816, 64.6464, 55.4112, 73.8816, 

/****************
 * char 101-110 *
 ****************/

55.4112, 41.5584, 73.8816, 69.2640, 36.9408, 36.9408, 64.6464, 36.9408, 115.4400, 83.1168, 

/****************
 * char 111-120 *
 ****************/

64.6464, 69.2640, 73.8816, 64.6464, 55.4112, 36.9408, 73.8816, 69.2640, 96.9696, 73.8816, 

/****************
 * char 121-126 *
 ****************/

73.8816, 60.0288, 69.2640, 36.9408, 69.2640, 110.8224, 

/*************************
 * char: 32   strokes: 0 *
 *************************/

GAMGI_IO_CHAR,

/*************************
 * char: 33 ! strokes: 4 *
 *************************/

36.9408, 99.2784, 32.3232, 94.6608, 23.0880, 39.2496, GAMGI_IO_STROKE,

36.9408, 94.6608, 23.0880, 39.2496, GAMGI_IO_STROKE,

36.9408, 99.2784, 41.5584, 94.6608, 23.0880, 39.2496, GAMGI_IO_STROKE,

13.8528, 11.5440, 9.2352, 6.9264, 13.8528, 2.3088, 18.4704, 6.9264, 13.8528, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 34 " strokes: 4 *
 *************************/

32.3232, 99.2784, 23.0880, 66.9552, GAMGI_IO_STROKE,

36.9408, 99.2784, 23.0880, 66.9552, GAMGI_IO_STROKE,

73.8816, 99.2784, 64.6464, 66.9552, GAMGI_IO_STROKE,

78.4992, 99.2784, 64.6464, 66.9552, GAMGI_IO_CHAR,

/*************************
 * char: 35 # strokes: 4 *
 *************************/

50.7936, 99.2784, 18.4704, -30.0144, GAMGI_IO_STROKE,

78.4992, 99.2784, 46.1760, -30.0144, GAMGI_IO_STROKE,

18.4704, 48.4848, 83.1168, 48.4848, GAMGI_IO_STROKE,

13.8528, 20.7792, 78.4992, 20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 36 $ strokes: 4 *
 *************************/

55.4112, 117.7488, 18.4704, -16.1616, GAMGI_IO_STROKE,

78.4992, 117.7488, 41.5584, -16.1616, GAMGI_IO_STROKE,

83.1168, 80.8080, 78.4992, 76.1904, 83.1168, 71.5728, 87.7344, 76.1904, 87.7344, 80.8080, 83.1168, 90.0432, 78.4992, 94.6608, 64.6464, 99.2784, 46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 23.0880, 76.1904, 27.7056, 66.9552, 32.3232, 62.3376, 64.6464, 43.8672, 73.8816, 34.6320, GAMGI_IO_STROKE,

23.0880, 76.1904, 32.3232, 66.9552, 64.6464, 48.4848, 69.2640, 43.8672, 73.8816, 34.6320, 73.8816, 20.7792, 69.2640, 11.5440, 64.6464, 6.9264, 50.7936, 2.3088, 32.3232, 2.3088, 18.4704, 6.9264, 13.8528, 11.5440, 9.2352, 20.7792, 9.2352, 25.3968, 13.8528, 30.0144, 18.4704, 25.3968, 13.8528, 20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 37 % strokes: 3 *
 *************************/

115.4400, 99.2784, 106.2048, 94.6608, 87.7344, 90.0432, 73.8816, 90.0432, 55.4112, 94.6608, 46.1760, 99.2784, 36.9408, 99.2784, 27.7056, 94.6608, 23.0880, 85.4256, 23.0880, 76.1904, 32.3232, 66.9552, 41.5584, 66.9552, 50.7936, 71.5728, 55.4112, 80.8080, 55.4112, 90.0432, 46.1760, 99.2784, GAMGI_IO_STROKE,

115.4400, 99.2784, 4.6176, 2.3088, GAMGI_IO_STROKE,

87.7344, 34.6320, 78.4992, 34.6320, 69.2640, 30.0144, 64.6464, 20.7792, 64.6464, 11.5440, 73.8816, 2.3088, 83.1168, 2.3088, 92.3520, 6.9264, 96.9696, 16.1616, 96.9696, 25.3968, 87.7344, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 38 & strokes: 3 *
 *************************/

106.2048, 62.3376, 101.5872, 57.7200, 106.2048, 53.1024, 110.8224, 57.7200, 110.8224, 62.3376, 106.2048, 66.9552, 101.5872, 66.9552, 92.3520, 62.3376, 83.1168, 53.1024, 60.0288, 16.1616, 50.7936, 6.9264, 41.5584, 2.3088, 27.7056, 2.3088, 13.8528, 6.9264, 9.2352, 16.1616, 9.2352, 25.3968, 13.8528, 34.6320, 18.4704, 39.2496, 27.7056, 43.8672, 50.7936, 53.1024, 60.0288, 57.7200, 69.2640, 66.9552, 73.8816, 76.1904, 73.8816, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 50.7936, 94.6608, 46.1760, 85.4256, 46.1760, 71.5728, 50.7936, 43.8672, 55.4112, 30.0144, 64.6464, 16.1616, 73.8816, 6.9264, 83.1168, 2.3088, 92.3520, 2.3088, 96.9696, 11.5440, 96.9696, 16.1616, GAMGI_IO_STROKE,

27.7056, 2.3088, 18.4704, 6.9264, 13.8528, 16.1616, 13.8528, 25.3968, 18.4704, 34.6320, 23.0880, 39.2496, 50.7936, 53.1024, GAMGI_IO_STROKE,

46.1760, 71.5728, 50.7936, 48.4848, 55.4112, 34.6320, 64.6464, 20.7792, 73.8816, 11.5440, 83.1168, 6.9264, 92.3520, 6.9264, 96.9696, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 39 ' strokes: 1 *
 *************************/

36.9408, 90.0432, 32.3232, 94.6608, 36.9408, 99.2784, 41.5584, 94.6608, 41.5584, 90.0432, 36.9408, 80.8080, 27.7056, 71.5728, GAMGI_IO_CHAR,

/*************************
 * char: 40 ( strokes: 2 *
 *************************/

69.2640, 117.7488, 50.7936, 103.8960, 36.9408, 90.0432, 27.7056, 76.1904, 18.4704, 57.7200, 13.8528, 34.6320, 13.8528, 16.1616, 18.4704, -6.9264, 23.0880, -20.7792, 27.7056, -30.0144, GAMGI_IO_STROKE,

50.7936, 103.8960, 36.9408, 85.4256, 27.7056, 66.9552, 23.0880, 53.1024, 18.4704, 30.0144, 18.4704, 6.9264, 23.0880, -16.1616, 27.7056, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 41 ) strokes: 2 *
 *************************/

41.5584, 117.7488, 46.1760, 108.5136, 50.7936, 94.6608, 55.4112, 71.5728, 55.4112, 53.1024, 50.7936, 30.0144, 41.5584, 11.5440, 32.3232, -2.3088, 18.4704, -16.1616, 0.0000, -30.0144, GAMGI_IO_STROKE,

41.5584, 117.7488, 46.1760, 103.8960, 50.7936, 80.8080, 50.7936, 57.7200, 46.1760, 34.6320, 41.5584, 20.7792, 32.3232, 2.3088, 18.4704, -16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 42 * strokes: 3 *
 *************************/

46.1760, 99.2784, 46.1760, 43.8672, GAMGI_IO_STROKE,

23.0880, 85.4256, 69.2640, 57.7200, GAMGI_IO_STROKE,

69.2640, 85.4256, 23.0880, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 43 + strokes: 2 *
 *************************/

60.0288, 85.4256, 60.0288, 2.3088, GAMGI_IO_STROKE,

18.4704, 43.8672, 101.5872, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 44 , strokes: 1 *
 *************************/

13.8528, 2.3088, 9.2352, 6.9264, 13.8528, 11.5440, 18.4704, 6.9264, 18.4704, 2.3088, 13.8528, -6.9264, 4.6176, -16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 45 - strokes: 1 *
 *************************/

18.4704, 43.8672, 101.5872, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 46 . strokes: 1 *
 *************************/

13.8528, 11.5440, 9.2352, 6.9264, 13.8528, 2.3088, 18.4704, 6.9264, 13.8528, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 47 / strokes: 1 *
 *************************/

110.8224, 117.7488, -9.2352, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 48 0 strokes: 3 *
 *************************/

55.4112, 99.2784, 41.5584, 94.6608, 32.3232, 85.4256, 23.0880, 71.5728, 18.4704, 57.7200, 13.8528, 39.2496, 13.8528, 25.3968, 18.4704, 11.5440, 23.0880, 6.9264, 32.3232, 2.3088, 41.5584, 2.3088, 55.4112, 6.9264, 64.6464, 16.1616, 73.8816, 30.0144, 78.4992, 43.8672, 83.1168, 62.3376, 83.1168, 76.1904, 78.4992, 90.0432, 73.8816, 94.6608, 64.6464, 99.2784, 55.4112, 99.2784, GAMGI_IO_STROKE,

55.4112, 99.2784, 46.1760, 94.6608, 36.9408, 85.4256, 27.7056, 71.5728, 23.0880, 57.7200, 18.4704, 39.2496, 18.4704, 25.3968, 23.0880, 11.5440, 32.3232, 2.3088, GAMGI_IO_STROKE,

41.5584, 2.3088, 50.7936, 6.9264, 60.0288, 16.1616, 69.2640, 30.0144, 73.8816, 43.8672, 78.4992, 62.3376, 78.4992, 76.1904, 73.8816, 90.0432, 64.6464, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 49 1 strokes: 4 *
 *************************/

55.4112, 80.8080, 32.3232, 2.3088, GAMGI_IO_STROKE,

64.6464, 99.2784, 36.9408, 2.3088, GAMGI_IO_STROKE,

64.6464, 99.2784, 50.7936, 85.4256, 36.9408, 76.1904, 27.7056, 71.5728, GAMGI_IO_STROKE,

60.0288, 85.4256, 41.5584, 76.1904, 27.7056, 71.5728, GAMGI_IO_CHAR,

/*************************
 * char: 50 2 strokes: 4 *
 *************************/

32.3232, 80.8080, 36.9408, 76.1904, 32.3232, 71.5728, 27.7056, 76.1904, 27.7056, 80.8080, 32.3232, 90.0432, 36.9408, 94.6608, 50.7936, 99.2784, 64.6464, 99.2784, 78.4992, 94.6608, 83.1168, 85.4256, 83.1168, 76.1904, 78.4992, 66.9552, 69.2640, 57.7200, 55.4112, 48.4848, 36.9408, 39.2496, 23.0880, 30.0144, 13.8528, 20.7792, 4.6176, 2.3088, GAMGI_IO_STROKE,

64.6464, 99.2784, 73.8816, 94.6608, 78.4992, 85.4256, 78.4992, 76.1904, 73.8816, 66.9552, 64.6464, 57.7200, 36.9408, 39.2496, GAMGI_IO_STROKE,

9.2352, 11.5440, 13.8528, 16.1616, 23.0880, 16.1616, 46.1760, 6.9264, 60.0288, 6.9264, 69.2640, 11.5440, 73.8816, 20.7792, GAMGI_IO_STROKE,

23.0880, 16.1616, 46.1760, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 73.8816, 20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 51 3 strokes: 4 *
 *************************/

32.3232, 80.8080, 36.9408, 76.1904, 32.3232, 71.5728, 27.7056, 76.1904, 27.7056, 80.8080, 32.3232, 90.0432, 36.9408, 94.6608, 50.7936, 99.2784, 64.6464, 99.2784, 78.4992, 94.6608, 83.1168, 85.4256, 83.1168, 76.1904, 78.4992, 66.9552, 64.6464, 57.7200, 50.7936, 53.1024, GAMGI_IO_STROKE,

64.6464, 99.2784, 73.8816, 94.6608, 78.4992, 85.4256, 78.4992, 76.1904, 73.8816, 66.9552, 64.6464, 57.7200, GAMGI_IO_STROKE,

41.5584, 53.1024, 50.7936, 53.1024, 64.6464, 48.4848, 69.2640, 43.8672, 73.8816, 34.6320, 73.8816, 20.7792, 69.2640, 11.5440, 64.6464, 6.9264, 50.7936, 2.3088, 32.3232, 2.3088, 18.4704, 6.9264, 13.8528, 11.5440, 9.2352, 20.7792, 9.2352, 25.3968, 13.8528, 30.0144, 18.4704, 25.3968, 13.8528, 20.7792, GAMGI_IO_STROKE,

50.7936, 53.1024, 60.0288, 48.4848, 64.6464, 43.8672, 69.2640, 34.6320, 69.2640, 20.7792, 64.6464, 11.5440, 60.0288, 6.9264, 50.7936, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 52 4 strokes: 3 *
 *************************/

73.8816, 94.6608, 46.1760, 2.3088, GAMGI_IO_STROKE,

78.4992, 99.2784, 50.7936, 2.3088, GAMGI_IO_STROKE,

78.4992, 99.2784, 9.2352, 30.0144, 83.1168, 30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 53 5 strokes: 5 *
 *************************/

41.5584, 99.2784, 18.4704, 53.1024, GAMGI_IO_STROKE,

41.5584, 99.2784, 87.7344, 99.2784, GAMGI_IO_STROKE,

41.5584, 94.6608, 64.6464, 94.6608, 87.7344, 99.2784, GAMGI_IO_STROKE,

18.4704, 53.1024, 23.0880, 57.7200, 36.9408, 62.3376, 50.7936, 62.3376, 64.6464, 57.7200, 69.2640, 53.1024, 73.8816, 43.8672, 73.8816, 30.0144, 69.2640, 16.1616, 60.0288, 6.9264, 46.1760, 2.3088, 32.3232, 2.3088, 18.4704, 6.9264, 13.8528, 11.5440, 9.2352, 20.7792, 9.2352, 25.3968, 13.8528, 30.0144, 18.4704, 25.3968, 13.8528, 20.7792, GAMGI_IO_STROKE,

50.7936, 62.3376, 60.0288, 57.7200, 64.6464, 53.1024, 69.2640, 43.8672, 69.2640, 30.0144, 64.6464, 16.1616, 55.4112, 6.9264, 46.1760, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 54 6 strokes: 3 *
 *************************/

78.4992, 85.4256, 73.8816, 80.8080, 78.4992, 76.1904, 83.1168, 80.8080, 83.1168, 85.4256, 78.4992, 94.6608, 69.2640, 99.2784, 55.4112, 99.2784, 41.5584, 94.6608, 32.3232, 85.4256, 23.0880, 71.5728, 18.4704, 57.7200, 13.8528, 39.2496, 13.8528, 20.7792, 18.4704, 11.5440, 23.0880, 6.9264, 32.3232, 2.3088, 46.1760, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, 73.8816, 25.3968, 73.8816, 39.2496, 69.2640, 48.4848, 64.6464, 53.1024, 55.4112, 57.7200, 41.5584, 57.7200, 32.3232, 53.1024, 23.0880, 43.8672, 18.4704, 34.6320, GAMGI_IO_STROKE,

55.4112, 99.2784, 46.1760, 94.6608, 36.9408, 85.4256, 27.7056, 71.5728, 23.0880, 57.7200, 18.4704, 39.2496, 18.4704, 16.1616, 23.0880, 6.9264, GAMGI_IO_STROKE,

46.1760, 2.3088, 55.4112, 6.9264, 64.6464, 16.1616, 69.2640, 25.3968, 69.2640, 43.8672, 64.6464, 53.1024, GAMGI_IO_CHAR,

/*************************
 * char: 55 7 strokes: 5 *
 *************************/

27.7056, 99.2784, 18.4704, 71.5728, GAMGI_IO_STROKE,

87.7344, 99.2784, 83.1168, 85.4256, 73.8816, 71.5728, 50.7936, 43.8672, 41.5584, 30.0144, 36.9408, 20.7792, 32.3232, 2.3088, GAMGI_IO_STROKE,

73.8816, 71.5728, 46.1760, 43.8672, 36.9408, 30.0144, 32.3232, 20.7792, 27.7056, 2.3088, GAMGI_IO_STROKE,

23.0880, 85.4256, 36.9408, 99.2784, 46.1760, 99.2784, 69.2640, 85.4256, GAMGI_IO_STROKE,

27.7056, 90.0432, 36.9408, 94.6608, 46.1760, 94.6608, 69.2640, 85.4256, 78.4992, 85.4256, 83.1168, 90.0432, 87.7344, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 56 8 strokes: 6 *
 *************************/

50.7936, 99.2784, 36.9408, 94.6608, 32.3232, 90.0432, 27.7056, 80.8080, 27.7056, 66.9552, 32.3232, 57.7200, 41.5584, 53.1024, 55.4112, 53.1024, 73.8816, 57.7200, 78.4992, 62.3376, 83.1168, 71.5728, 83.1168, 85.4256, 78.4992, 94.6608, 64.6464, 99.2784, 50.7936, 99.2784, GAMGI_IO_STROKE,

50.7936, 99.2784, 41.5584, 94.6608, 36.9408, 90.0432, 32.3232, 80.8080, 32.3232, 66.9552, 36.9408, 57.7200, 41.5584, 53.1024, GAMGI_IO_STROKE,

55.4112, 53.1024, 69.2640, 57.7200, 73.8816, 62.3376, 78.4992, 71.5728, 78.4992, 85.4256, 73.8816, 94.6608, 64.6464, 99.2784, GAMGI_IO_STROKE,

41.5584, 53.1024, 23.0880, 48.4848, 13.8528, 39.2496, 9.2352, 30.0144, 9.2352, 16.1616, 13.8528, 6.9264, 27.7056, 2.3088, 46.1760, 2.3088, 64.6464, 6.9264, 69.2640, 11.5440, 73.8816, 20.7792, 73.8816, 34.6320, 69.2640, 43.8672, 64.6464, 48.4848, 55.4112, 53.1024, GAMGI_IO_STROKE,

41.5584, 53.1024, 27.7056, 48.4848, 18.4704, 39.2496, 13.8528, 30.0144, 13.8528, 16.1616, 18.4704, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

46.1760, 2.3088, 60.0288, 6.9264, 64.6464, 11.5440, 69.2640, 20.7792, 69.2640, 39.2496, 64.6464, 48.4848, GAMGI_IO_CHAR,

/*************************
 * char: 57 9 strokes: 3 *
 *************************/

78.4992, 66.9552, 73.8816, 57.7200, 64.6464, 48.4848, 55.4112, 43.8672, 41.5584, 43.8672, 32.3232, 48.4848, 27.7056, 53.1024, 23.0880, 62.3376, 23.0880, 76.1904, 27.7056, 85.4256, 36.9408, 94.6608, 50.7936, 99.2784, 64.6464, 99.2784, 73.8816, 94.6608, 78.4992, 90.0432, 83.1168, 80.8080, 83.1168, 62.3376, 78.4992, 43.8672, 73.8816, 30.0144, 64.6464, 16.1616, 55.4112, 6.9264, 41.5584, 2.3088, 27.7056, 2.3088, 18.4704, 6.9264, 13.8528, 16.1616, 13.8528, 20.7792, 18.4704, 25.3968, 23.0880, 20.7792, 18.4704, 16.1616, GAMGI_IO_STROKE,

32.3232, 48.4848, 27.7056, 57.7200, 27.7056, 76.1904, 32.3232, 85.4256, 41.5584, 94.6608, 50.7936, 99.2784, GAMGI_IO_STROKE,

73.8816, 94.6608, 78.4992, 85.4256, 78.4992, 62.3376, 73.8816, 43.8672, 69.2640, 30.0144, 60.0288, 16.1616, 50.7936, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 58 : strokes: 2 *
 *************************/

27.7056, 66.9552, 23.0880, 62.3376, 27.7056, 57.7200, 32.3232, 62.3376, 27.7056, 66.9552, GAMGI_IO_STROKE,

13.8528, 11.5440, 9.2352, 6.9264, 13.8528, 2.3088, 18.4704, 6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 59 ; strokes: 2 *
 *************************/

27.7056, 66.9552, 23.0880, 62.3376, 27.7056, 57.7200, 32.3232, 62.3376, 27.7056, 66.9552, GAMGI_IO_STROKE,

13.8528, 2.3088, 9.2352, 6.9264, 13.8528, 11.5440, 18.4704, 6.9264, 18.4704, 2.3088, 13.8528, -6.9264, 4.6176, -16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 60 < strokes: 1 *
 *************************/

92.3520, 85.4256, 18.4704, 43.8672, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 61 = strokes: 2 *
 *************************/

18.4704, 57.7200, 101.5872, 57.7200, GAMGI_IO_STROKE,

18.4704, 30.0144, 101.5872, 30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 62 > strokes: 1 *
 *************************/

18.4704, 85.4256, 92.3520, 43.8672, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 63 ? strokes: 3 *
 *************************/

32.3232, 80.8080, 36.9408, 76.1904, 32.3232, 71.5728, 27.7056, 76.1904, 27.7056, 80.8080, 32.3232, 90.0432, 36.9408, 94.6608, 50.7936, 99.2784, 69.2640, 99.2784, 83.1168, 94.6608, 87.7344, 85.4256, 87.7344, 76.1904, 83.1168, 66.9552, 78.4992, 62.3376, 50.7936, 53.1024, 41.5584, 48.4848, 41.5584, 39.2496, 46.1760, 34.6320, 55.4112, 34.6320, GAMGI_IO_STROKE,

69.2640, 99.2784, 78.4992, 94.6608, 83.1168, 85.4256, 83.1168, 76.1904, 78.4992, 66.9552, 73.8816, 62.3376, 64.6464, 57.7200, GAMGI_IO_STROKE,

36.9408, 11.5440, 32.3232, 6.9264, 36.9408, 2.3088, 41.5584, 6.9264, 36.9408, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 64 @ strokes: 4 *
 *************************/

83.1168, 62.3376, 78.4992, 71.5728, 69.2640, 76.1904, 55.4112, 76.1904, 46.1760, 71.5728, 41.5584, 66.9552, 36.9408, 53.1024, 36.9408, 39.2496, 41.5584, 30.0144, 50.7936, 25.3968, 64.6464, 25.3968, 73.8816, 30.0144, 78.4992, 39.2496, GAMGI_IO_STROKE,

55.4112, 76.1904, 46.1760, 66.9552, 41.5584, 53.1024, 41.5584, 39.2496, 46.1760, 30.0144, 50.7936, 25.3968, GAMGI_IO_STROKE,

83.1168, 76.1904, 78.4992, 39.2496, 78.4992, 30.0144, 87.7344, 25.3968, 96.9696, 25.3968, 106.2048, 34.6320, 110.8224, 48.4848, 110.8224, 57.7200, 106.2048, 71.5728, 101.5872, 80.8080, 92.3520, 90.0432, 83.1168, 94.6608, 69.2640, 99.2784, 55.4112, 99.2784, 41.5584, 94.6608, 32.3232, 90.0432, 23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 55.4112, 2.3088, 69.2640, 2.3088, 83.1168, 6.9264, 92.3520, 11.5440, 96.9696, 16.1616, GAMGI_IO_STROKE,

87.7344, 76.1904, 83.1168, 39.2496, 83.1168, 30.0144, 87.7344, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 65 A strokes: 4 *
 *************************/

87.7344, 99.2784, 78.4992, 90.0432, 69.2640, 76.1904, 55.4112, 53.1024, 46.1760, 39.2496, 32.3232, 20.7792, 18.4704, 6.9264, 9.2352, 2.3088, 0.0000, 2.3088, -4.6176, 6.9264, -4.6176, 16.1616, 0.0000, 20.7792, 4.6176, 16.1616, 0.0000, 11.5440, GAMGI_IO_STROKE,

87.7344, 99.2784, 83.1168, 80.8080, 73.8816, 34.6320, 69.2640, 2.3088, GAMGI_IO_STROKE,

87.7344, 99.2784, 73.8816, 2.3088, GAMGI_IO_STROKE,

69.2640, 2.3088, 69.2640, 11.5440, 64.6464, 25.3968, 60.0288, 34.6320, 50.7936, 43.8672, 41.5584, 48.4848, 32.3232, 48.4848, 27.7056, 43.8672, 27.7056, 34.6320, 32.3232, 20.7792, 46.1760, 6.9264, 60.0288, 2.3088, 78.4992, 2.3088, 87.7344, 6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 66 B strokes: 6 *
 *************************/

69.2640, 94.6608, 64.6464, 90.0432, 60.0288, 80.8080, 50.7936, 57.7200, 41.5584, 30.0144, 36.9408, 20.7792, 27.7056, 6.9264, 18.4704, 2.3088, GAMGI_IO_STROKE,

64.6464, 90.0432, 60.0288, 76.1904, 50.7936, 39.2496, 46.1760, 25.3968, 41.5584, 16.1616, 32.3232, 6.9264, 18.4704, 2.3088, 9.2352, 2.3088, 4.6176, 6.9264, 4.6176, 16.1616, 9.2352, 20.7792, 13.8528, 16.1616, 9.2352, 11.5440, GAMGI_IO_STROKE,

41.5584, 71.5728, 36.9408, 62.3376, 32.3232, 57.7200, 23.0880, 57.7200, 18.4704, 62.3376, 18.4704, 71.5728, 23.0880, 80.8080, 32.3232, 90.0432, 41.5584, 94.6608, 55.4112, 99.2784, 83.1168, 99.2784, 92.3520, 94.6608, 96.9696, 85.4256, 96.9696, 76.1904, 92.3520, 66.9552, 83.1168, 62.3376, 64.6464, 57.7200, 55.4112, 57.7200, GAMGI_IO_STROKE,

83.1168, 99.2784, 87.7344, 94.6608, 92.3520, 85.4256, 92.3520, 76.1904, 87.7344, 66.9552, 83.1168, 62.3376, GAMGI_IO_STROKE,

64.6464, 57.7200, 78.4992, 53.1024, 83.1168, 48.4848, 87.7344, 39.2496, 87.7344, 25.3968, 83.1168, 11.5440, 78.4992, 6.9264, 69.2640, 2.3088, 60.0288, 2.3088, 55.4112, 6.9264, 55.4112, 16.1616, 60.0288, 30.0144, GAMGI_IO_STROKE,

64.6464, 57.7200, 73.8816, 53.1024, 78.4992, 48.4848, 83.1168, 39.2496, 83.1168, 25.3968, 78.4992, 11.5440, 69.2640, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 67 C strokes: 2 *
 *************************/

13.8528, 90.0432, 9.2352, 80.8080, 9.2352, 71.5728, 13.8528, 62.3376, 27.7056, 57.7200, 41.5584, 57.7200, 60.0288, 62.3376, 69.2640, 66.9552, 78.4992, 76.1904, 83.1168, 85.4256, 83.1168, 94.6608, 78.4992, 99.2784, 69.2640, 99.2784, 55.4112, 94.6608, 41.5584, 80.8080, 32.3232, 66.9552, 23.0880, 48.4848, 18.4704, 30.0144, 18.4704, 16.1616, 23.0880, 6.9264, 36.9408, 2.3088, 46.1760, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, 73.8816, 25.3968, 73.8816, 34.6320, 69.2640, 43.8672, 60.0288, 43.8672, 50.7936, 39.2496, 46.1760, 30.0144, GAMGI_IO_STROKE,

69.2640, 99.2784, 60.0288, 94.6608, 46.1760, 80.8080, 36.9408, 66.9552, 27.7056, 48.4848, 23.0880, 30.0144, 23.0880, 16.1616, 27.7056, 6.9264, 36.9408, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 68 D strokes: 2 *
 *************************/

69.2640, 94.6608, 64.6464, 90.0432, 60.0288, 80.8080, 50.7936, 57.7200, 41.5584, 30.0144, 36.9408, 20.7792, 27.7056, 6.9264, 18.4704, 2.3088, GAMGI_IO_STROKE,

64.6464, 90.0432, 60.0288, 76.1904, 50.7936, 39.2496, 46.1760, 25.3968, 41.5584, 16.1616, 32.3232, 6.9264, 18.4704, 2.3088, 9.2352, 2.3088, 4.6176, 6.9264, 4.6176, 16.1616, 9.2352, 20.7792, 18.4704, 20.7792, 27.7056, 16.1616, 36.9408, 6.9264, 46.1760, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 87.7344, 34.6320, 92.3520, 57.7200, 92.3520, 71.5728, 87.7344, 85.4256, 78.4992, 94.6608, 69.2640, 99.2784, 46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 18.4704, 66.9552, 23.0880, 62.3376, 32.3232, 62.3376, 36.9408, 66.9552, 41.5584, 76.1904, GAMGI_IO_CHAR,

/*************************
 * char: 69 E strokes: 4 *
 *************************/

64.6464, 85.4256, 60.0288, 80.8080, 60.0288, 71.5728, 64.6464, 66.9552, 73.8816, 66.9552, 78.4992, 76.1904, 78.4992, 85.4256, 73.8816, 94.6608, 64.6464, 99.2784, 50.7936, 99.2784, 41.5584, 94.6608, 36.9408, 90.0432, 32.3232, 80.8080, 32.3232, 71.5728, 36.9408, 62.3376, 46.1760, 57.7200, GAMGI_IO_STROKE,

50.7936, 99.2784, 41.5584, 90.0432, 36.9408, 80.8080, 36.9408, 66.9552, 46.1760, 57.7200, GAMGI_IO_STROKE,

46.1760, 57.7200, 36.9408, 57.7200, 23.0880, 53.1024, 13.8528, 43.8672, 9.2352, 34.6320, 9.2352, 20.7792, 13.8528, 11.5440, 18.4704, 6.9264, 27.7056, 2.3088, 41.5584, 2.3088, 55.4112, 6.9264, 64.6464, 16.1616, 69.2640, 25.3968, 69.2640, 34.6320, 64.6464, 43.8672, 55.4112, 43.8672, 46.1760, 39.2496, 41.5584, 30.0144, GAMGI_IO_STROKE,

36.9408, 57.7200, 27.7056, 53.1024, 18.4704, 43.8672, 13.8528, 34.6320, 13.8528, 16.1616, 18.4704, 6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 70 F strokes: 4 *
 *************************/

73.8816, 90.0432, 69.2640, 80.8080, 60.0288, 57.7200, 50.7936, 30.0144, 46.1760, 20.7792, 36.9408, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

46.1760, 71.5728, 41.5584, 62.3376, 32.3232, 57.7200, 23.0880, 57.7200, 18.4704, 66.9552, 18.4704, 76.1904, 23.0880, 85.4256, 32.3232, 94.6608, 46.1760, 99.2784, 92.3520, 99.2784, 78.4992, 94.6608, 73.8816, 90.0432, 69.2640, 76.1904, 60.0288, 39.2496, 55.4112, 25.3968, 50.7936, 16.1616, 41.5584, 6.9264, 27.7056, 2.3088, 18.4704, 2.3088, 9.2352, 6.9264, 4.6176, 11.5440, 4.6176, 16.1616, 9.2352, 20.7792, 13.8528, 16.1616, 9.2352, 11.5440, GAMGI_IO_STROKE,

55.4112, 99.2784, 73.8816, 94.6608, 78.4992, 94.6608, GAMGI_IO_STROKE,

36.9408, 39.2496, 41.5584, 43.8672, 50.7936, 48.4848, 69.2640, 48.4848, 78.4992, 53.1024, 87.7344, 66.9552, 78.4992, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 71 G strokes: 4 *
 *************************/

13.8528, 85.4256, 9.2352, 76.1904, 9.2352, 66.9552, 13.8528, 57.7200, 23.0880, 53.1024, 36.9408, 53.1024, 50.7936, 57.7200, 60.0288, 62.3376, 73.8816, 76.1904, 78.4992, 90.0432, 78.4992, 94.6608, 73.8816, 99.2784, 69.2640, 99.2784, 60.0288, 94.6608, 50.7936, 85.4256, 46.1760, 76.1904, 41.5584, 62.3376, 41.5584, 48.4848, 46.1760, 39.2496, 55.4112, 34.6320, 64.6464, 34.6320, 73.8816, 39.2496, 83.1168, 48.4848, 87.7344, 57.7200, GAMGI_IO_STROKE,

73.8816, 99.2784, 64.6464, 94.6608, 55.4112, 85.4256, 50.7936, 76.1904, 46.1760, 62.3376, 46.1760, 43.8672, 55.4112, 34.6320, GAMGI_IO_STROKE,

87.7344, 57.7200, 83.1168, 39.2496, 73.8816, 20.7792, 64.6464, 11.5440, 55.4112, 6.9264, 36.9408, 2.3088, 23.0880, 2.3088, 13.8528, 6.9264, 9.2352, 16.1616, 9.2352, 20.7792, 13.8528, 25.3968, 18.4704, 20.7792, 13.8528, 16.1616, GAMGI_IO_STROKE,

83.1168, 39.2496, 73.8816, 25.3968, 64.6464, 16.1616, 50.7936, 6.9264, 36.9408, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 72 H strokes: 4 *
 *************************/

27.7056, 71.5728, 23.0880, 76.1904, 23.0880, 85.4256, 27.7056, 94.6608, 41.5584, 99.2784, 55.4112, 99.2784, 41.5584, 48.4848, 32.3232, 20.7792, 27.7056, 11.5440, 23.0880, 6.9264, 13.8528, 2.3088, 4.6176, 2.3088, 0.0000, 6.9264, 0.0000, 16.1616, 4.6176, 20.7792, 9.2352, 16.1616, 4.6176, 11.5440, GAMGI_IO_STROKE,

55.4112, 99.2784, 41.5584, 57.7200, 36.9408, 43.8672, 27.7056, 20.7792, 23.0880, 11.5440, 13.8528, 2.3088, GAMGI_IO_STROKE,

18.4704, 34.6320, 23.0880, 39.2496, 32.3232, 43.8672, 73.8816, 57.7200, 83.1168, 62.3376, 96.9696, 71.5728, 106.2048, 80.8080, 110.8224, 90.0432, 110.8224, 94.6608, 106.2048, 99.2784, 101.5872, 99.2784, 92.3520, 94.6608, 83.1168, 80.8080, 78.4992, 71.5728, 69.2640, 43.8672, 64.6464, 25.3968, 64.6464, 11.5440, 73.8816, 2.3088, 78.4992, 2.3088, 87.7344, 6.9264, 96.9696, 16.1616, GAMGI_IO_STROKE,

101.5872, 99.2784, 92.3520, 90.0432, 83.1168, 71.5728, 73.8816, 43.8672, 69.2640, 25.3968, 69.2640, 11.5440, 73.8816, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 73 I strokes: 2 *
 *************************/

64.6464, 90.0432, 55.4112, 76.1904, 46.1760, 53.1024, 36.9408, 30.0144, 32.3232, 20.7792, 23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

73.8816, 71.5728, 64.6464, 62.3376, 50.7936, 57.7200, 36.9408, 57.7200, 27.7056, 62.3376, 23.0880, 71.5728, 23.0880, 80.8080, 27.7056, 90.0432, 36.9408, 94.6608, 55.4112, 99.2784, 73.8816, 99.2784, 64.6464, 90.0432, 60.0288, 80.8080, 50.7936, 53.1024, 41.5584, 25.3968, 36.9408, 16.1616, 27.7056, 6.9264, 13.8528, 2.3088, 4.6176, 2.3088, 0.0000, 6.9264, 0.0000, 16.1616, 4.6176, 20.7792, 9.2352, 16.1616, 4.6176, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 74 J strokes: 2 *
 *************************/

73.8816, 99.2784, 64.6464, 90.0432, 55.4112, 76.1904, 46.1760, 53.1024, 32.3232, 11.5440, 23.0880, -6.9264, GAMGI_IO_STROKE,

73.8816, 66.9552, 64.6464, 57.7200, 50.7936, 53.1024, 36.9408, 53.1024, 27.7056, 57.7200, 23.0880, 66.9552, 23.0880, 76.1904, 27.7056, 85.4256, 36.9408, 94.6608, 55.4112, 99.2784, 73.8816, 99.2784, 64.6464, 85.4256, 60.0288, 76.1904, 46.1760, 34.6320, 36.9408, 16.1616, 32.3232, 6.9264, 23.0880, -6.9264, 18.4704, -11.5440, 9.2352, -16.1616, 4.6176, -11.5440, 4.6176, -2.3088, 9.2352, 6.9264, 18.4704, 16.1616, 27.7056, 20.7792, 41.5584, 25.3968, 60.0288, 30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 75 K strokes: 6 *
 *************************/

27.7056, 71.5728, 23.0880, 76.1904, 23.0880, 85.4256, 32.3232, 94.6608, 46.1760, 99.2784, 55.4112, 99.2784, 41.5584, 48.4848, 32.3232, 20.7792, 27.7056, 11.5440, 23.0880, 6.9264, 13.8528, 2.3088, 4.6176, 2.3088, 0.0000, 6.9264, 0.0000, 16.1616, 4.6176, 20.7792, 9.2352, 16.1616, 4.6176, 11.5440, GAMGI_IO_STROKE,

55.4112, 99.2784, 41.5584, 57.7200, 36.9408, 43.8672, 27.7056, 20.7792, 23.0880, 11.5440, 13.8528, 2.3088, GAMGI_IO_STROKE,

92.3520, 94.6608, 78.4992, 76.1904, 69.2640, 66.9552, 60.0288, 62.3376, 46.1760, 57.7200, GAMGI_IO_STROKE,

106.2048, 94.6608, 101.5872, 90.0432, 106.2048, 85.4256, 110.8224, 90.0432, 110.8224, 94.6608, 106.2048, 99.2784, 101.5872, 99.2784, 92.3520, 94.6608, 78.4992, 71.5728, 73.8816, 66.9552, 64.6464, 62.3376, 46.1760, 57.7200, GAMGI_IO_STROKE,

46.1760, 57.7200, 60.0288, 53.1024, 64.6464, 43.8672, 69.2640, 11.5440, 73.8816, 2.3088, GAMGI_IO_STROKE,

46.1760, 57.7200, 55.4112, 53.1024, 60.0288, 43.8672, 64.6464, 11.5440, 73.8816, 2.3088, 78.4992, 2.3088, 87.7344, 6.9264, 96.9696, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 76 L strokes: 2 *
 *************************/

18.4704, 85.4256, 13.8528, 76.1904, 13.8528, 66.9552, 18.4704, 57.7200, 27.7056, 53.1024, 41.5584, 53.1024, 55.4112, 57.7200, 64.6464, 62.3376, 78.4992, 76.1904, 83.1168, 90.0432, 83.1168, 94.6608, 78.4992, 99.2784, 73.8816, 99.2784, 64.6464, 94.6608, 60.0288, 90.0432, 50.7936, 76.1904, 32.3232, 30.0144, 27.7056, 20.7792, 18.4704, 6.9264, 9.2352, 2.3088, GAMGI_IO_STROKE,

60.0288, 90.0432, 50.7936, 71.5728, 41.5584, 39.2496, 36.9408, 25.3968, 32.3232, 16.1616, 23.0880, 6.9264, 9.2352, 2.3088, 0.0000, 2.3088, -4.6176, 6.9264, -4.6176, 16.1616, 0.0000, 20.7792, 9.2352, 20.7792, 18.4704, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, 55.4112, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 77 M strokes: 6 *
 *************************/

64.6464, 99.2784, 46.1760, 57.7200, 32.3232, 30.0144, 23.0880, 16.1616, 13.8528, 6.9264, 4.6176, 2.3088, -4.6176, 2.3088, -9.2352, 6.9264, -9.2352, 16.1616, -4.6176, 20.7792, 0.0000, 16.1616, -4.6176, 11.5440, GAMGI_IO_STROKE,

64.6464, 99.2784, 55.4112, 66.9552, 50.7936, 48.4848, 46.1760, 25.3968, 46.1760, 6.9264, 55.4112, 2.3088, GAMGI_IO_STROKE,

64.6464, 99.2784, 60.0288, 80.8080, 55.4112, 57.7200, 50.7936, 25.3968, 50.7936, 6.9264, 55.4112, 2.3088, GAMGI_IO_STROKE,

106.2048, 99.2784, 87.7344, 57.7200, 64.6464, 16.1616, 55.4112, 2.3088, GAMGI_IO_STROKE,

106.2048, 99.2784, 96.9696, 66.9552, 92.3520, 48.4848, 87.7344, 25.3968, 87.7344, 6.9264, 96.9696, 2.3088, 101.5872, 2.3088, 110.8224, 6.9264, 120.0576, 16.1616, GAMGI_IO_STROKE,

106.2048, 99.2784, 101.5872, 80.8080, 96.9696, 57.7200, 92.3520, 25.3968, 92.3520, 6.9264, 96.9696, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 78 N strokes: 4 *
 *************************/

50.7936, 99.2784, 46.1760, 80.8080, 36.9408, 53.1024, 27.7056, 30.0144, 23.0880, 20.7792, 13.8528, 6.9264, 4.6176, 2.3088, -4.6176, 2.3088, -9.2352, 6.9264, -9.2352, 16.1616, -4.6176, 20.7792, 0.0000, 16.1616, -4.6176, 11.5440, GAMGI_IO_STROKE,

50.7936, 99.2784, 50.7936, 76.1904, 55.4112, 25.3968, 60.0288, 2.3088, GAMGI_IO_STROKE,

50.7936, 99.2784, 55.4112, 76.1904, 60.0288, 25.3968, 60.0288, 2.3088, GAMGI_IO_STROKE,

115.4400, 94.6608, 110.8224, 90.0432, 115.4400, 85.4256, 120.0576, 90.0432, 120.0576, 94.6608, 115.4400, 99.2784, 106.2048, 99.2784, 96.9696, 94.6608, 87.7344, 80.8080, 83.1168, 71.5728, 73.8816, 48.4848, 64.6464, 20.7792, 60.0288, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 79 O strokes: 2 *
 *************************/

50.7936, 99.2784, 41.5584, 94.6608, 32.3232, 85.4256, 23.0880, 71.5728, 18.4704, 62.3376, 13.8528, 43.8672, 13.8528, 25.3968, 18.4704, 11.5440, 23.0880, 6.9264, 32.3232, 2.3088, 41.5584, 2.3088, 55.4112, 6.9264, 64.6464, 16.1616, 73.8816, 30.0144, 78.4992, 39.2496, 83.1168, 57.7200, 83.1168, 76.1904, 78.4992, 90.0432, 73.8816, 94.6608, 69.2640, 94.6608, 60.0288, 90.0432, 50.7936, 80.8080, 41.5584, 62.3376, 36.9408, 39.2496, 36.9408, 25.3968, GAMGI_IO_STROKE,

41.5584, 94.6608, 32.3232, 80.8080, 23.0880, 62.3376, 18.4704, 43.8672, 18.4704, 25.3968, 23.0880, 11.5440, 32.3232, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 80 P strokes: 4 *
 *************************/

69.2640, 94.6608, 64.6464, 90.0432, 60.0288, 80.8080, 50.7936, 57.7200, 41.5584, 30.0144, 36.9408, 20.7792, 27.7056, 6.9264, 18.4704, 2.3088, GAMGI_IO_STROKE,

64.6464, 90.0432, 60.0288, 76.1904, 50.7936, 39.2496, 46.1760, 25.3968, 41.5584, 16.1616, 32.3232, 6.9264, 18.4704, 2.3088, 9.2352, 2.3088, 4.6176, 6.9264, 4.6176, 16.1616, 9.2352, 20.7792, 13.8528, 16.1616, 9.2352, 11.5440, GAMGI_IO_STROKE,

41.5584, 71.5728, 36.9408, 62.3376, 32.3232, 57.7200, 23.0880, 57.7200, 18.4704, 62.3376, 18.4704, 71.5728, 23.0880, 80.8080, 32.3232, 90.0432, 41.5584, 94.6608, 55.4112, 99.2784, 73.8816, 99.2784, 87.7344, 94.6608, 92.3520, 90.0432, 96.9696, 80.8080, 96.9696, 66.9552, 92.3520, 57.7200, 87.7344, 53.1024, 73.8816, 48.4848, 64.6464, 48.4848, 55.4112, 53.1024, GAMGI_IO_STROKE,

73.8816, 99.2784, 83.1168, 94.6608, 87.7344, 90.0432, 92.3520, 80.8080, 92.3520, 66.9552, 87.7344, 57.7200, 83.1168, 53.1024, 73.8816, 48.4848, GAMGI_IO_CHAR,

/*************************
 * char: 81 Q strokes: 2 *
 *************************/

60.0288, 80.8080, 60.0288, 71.5728, 55.4112, 62.3376, 50.7936, 57.7200, 41.5584, 53.1024, 32.3232, 53.1024, 27.7056, 62.3376, 27.7056, 71.5728, 32.3232, 85.4256, 41.5584, 94.6608, 55.4112, 99.2784, 69.2640, 99.2784, 78.4992, 94.6608, 83.1168, 85.4256, 83.1168, 66.9552, 78.4992, 53.1024, 69.2640, 39.2496, 50.7936, 20.7792, 36.9408, 11.5440, 27.7056, 6.9264, 13.8528, 2.3088, 4.6176, 2.3088, 0.0000, 6.9264, 0.0000, 16.1616, 4.6176, 20.7792, 13.8528, 20.7792, 23.0880, 16.1616, 36.9408, 6.9264, 50.7936, 2.3088, 64.6464, 2.3088, 73.8816, 6.9264, 83.1168, 16.1616, GAMGI_IO_STROKE,

69.2640, 99.2784, 73.8816, 94.6608, 78.4992, 85.4256, 78.4992, 66.9552, 73.8816, 53.1024, 64.6464, 39.2496, 50.7936, 25.3968, 32.3232, 11.5440, 13.8528, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 82 R strokes: 6 *
 *************************/

69.2640, 94.6608, 64.6464, 90.0432, 60.0288, 80.8080, 50.7936, 57.7200, 41.5584, 30.0144, 36.9408, 20.7792, 27.7056, 6.9264, 18.4704, 2.3088, GAMGI_IO_STROKE,

64.6464, 90.0432, 60.0288, 76.1904, 50.7936, 39.2496, 46.1760, 25.3968, 41.5584, 16.1616, 32.3232, 6.9264, 18.4704, 2.3088, 9.2352, 2.3088, 4.6176, 6.9264, 4.6176, 16.1616, 9.2352, 20.7792, 13.8528, 16.1616, 9.2352, 11.5440, GAMGI_IO_STROKE,

41.5584, 71.5728, 36.9408, 62.3376, 32.3232, 57.7200, 23.0880, 57.7200, 18.4704, 62.3376, 18.4704, 71.5728, 23.0880, 80.8080, 32.3232, 90.0432, 41.5584, 94.6608, 55.4112, 99.2784, 78.4992, 99.2784, 92.3520, 94.6608, 96.9696, 85.4256, 96.9696, 76.1904, 92.3520, 66.9552, 87.7344, 62.3376, 73.8816, 57.7200, 55.4112, 57.7200, GAMGI_IO_STROKE,

78.4992, 99.2784, 87.7344, 94.6608, 92.3520, 85.4256, 92.3520, 76.1904, 87.7344, 66.9552, 83.1168, 62.3376, 73.8816, 57.7200, GAMGI_IO_STROKE,

55.4112, 57.7200, 69.2640, 53.1024, 73.8816, 43.8672, 78.4992, 11.5440, 83.1168, 2.3088, GAMGI_IO_STROKE,

55.4112, 57.7200, 64.6464, 53.1024, 69.2640, 43.8672, 73.8816, 11.5440, 83.1168, 2.3088, 87.7344, 2.3088, 96.9696, 6.9264, 106.2048, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 83 S strokes: 2 *
 *************************/

27.7056, 85.4256, 23.0880, 76.1904, 23.0880, 66.9552, 27.7056, 57.7200, 36.9408, 53.1024, 50.7936, 53.1024, 64.6464, 57.7200, 73.8816, 62.3376, 87.7344, 76.1904, 92.3520, 90.0432, 92.3520, 94.6608, 87.7344, 99.2784, 83.1168, 99.2784, 73.8816, 94.6608, 69.2640, 90.0432, 64.6464, 80.8080, 60.0288, 66.9552, 50.7936, 34.6320, 46.1760, 20.7792, 36.9408, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

64.6464, 80.8080, 60.0288, 62.3376, 55.4112, 30.0144, 50.7936, 16.1616, 41.5584, 6.9264, 27.7056, 2.3088, 13.8528, 2.3088, 4.6176, 6.9264, 0.0000, 16.1616, 0.0000, 20.7792, 4.6176, 25.3968, 9.2352, 20.7792, 4.6176, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 84 T strokes: 3 *
 *************************/

73.8816, 90.0432, 69.2640, 80.8080, 60.0288, 57.7200, 50.7936, 30.0144, 46.1760, 20.7792, 36.9408, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

46.1760, 71.5728, 41.5584, 62.3376, 32.3232, 57.7200, 23.0880, 57.7200, 18.4704, 66.9552, 18.4704, 76.1904, 23.0880, 85.4256, 32.3232, 94.6608, 46.1760, 99.2784, 87.7344, 99.2784, 78.4992, 94.6608, 73.8816, 90.0432, 69.2640, 76.1904, 60.0288, 39.2496, 55.4112, 25.3968, 50.7936, 16.1616, 41.5584, 6.9264, 27.7056, 2.3088, 18.4704, 2.3088, 9.2352, 6.9264, 4.6176, 11.5440, 4.6176, 16.1616, 9.2352, 20.7792, 13.8528, 16.1616, 9.2352, 11.5440, GAMGI_IO_STROKE,

55.4112, 99.2784, 73.8816, 94.6608, 78.4992, 94.6608, GAMGI_IO_CHAR,

/*************************
 * char: 85 U strokes: 4 *
 *************************/

4.6176, 80.8080, 13.8528, 94.6608, 23.0880, 99.2784, 27.7056, 99.2784, 36.9408, 90.0432, 36.9408, 76.1904, 32.3232, 62.3376, 18.4704, 25.3968, 18.4704, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 32.3232, 90.0432, 32.3232, 76.1904, 18.4704, 39.2496, 13.8528, 25.3968, 13.8528, 11.5440, 23.0880, 2.3088, 32.3232, 2.3088, 41.5584, 6.9264, 55.4112, 20.7792, 64.6464, 34.6320, 69.2640, 43.8672, GAMGI_IO_STROKE,

87.7344, 99.2784, 69.2640, 43.8672, 64.6464, 25.3968, 64.6464, 11.5440, 73.8816, 2.3088, 78.4992, 2.3088, 87.7344, 6.9264, 96.9696, 16.1616, GAMGI_IO_STROKE,

92.3520, 99.2784, 73.8816, 43.8672, 69.2640, 25.3968, 69.2640, 11.5440, 73.8816, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 86 V strokes: 2 *
 *************************/

4.6176, 80.8080, 13.8528, 94.6608, 23.0880, 99.2784, 27.7056, 99.2784, 36.9408, 90.0432, 36.9408, 76.1904, 32.3232, 57.7200, 23.0880, 25.3968, 23.0880, 11.5440, 27.7056, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 32.3232, 90.0432, 32.3232, 76.1904, 23.0880, 43.8672, 18.4704, 25.3968, 18.4704, 11.5440, 27.7056, 2.3088, 32.3232, 2.3088, 46.1760, 6.9264, 60.0288, 20.7792, 69.2640, 34.6320, 78.4992, 53.1024, 83.1168, 66.9552, 87.7344, 85.4256, 87.7344, 94.6608, 83.1168, 99.2784, 78.4992, 99.2784, 73.8816, 94.6608, 69.2640, 85.4256, 69.2640, 71.5728, 73.8816, 62.3376, 83.1168, 53.1024, 92.3520, 48.4848, 101.5872, 48.4848, GAMGI_IO_CHAR,

/*************************
 * char: 87 W strokes: 6 *
 *************************/

13.8528, 71.5728, 9.2352, 71.5728, 4.6176, 76.1904, 4.6176, 85.4256, 9.2352, 94.6608, 18.4704, 99.2784, 36.9408, 99.2784, 32.3232, 90.0432, 27.7056, 71.5728, 23.0880, 30.0144, 18.4704, 2.3088, GAMGI_IO_STROKE,

27.7056, 71.5728, 27.7056, 30.0144, 23.0880, 2.3088, GAMGI_IO_STROKE,

73.8816, 99.2784, 64.6464, 90.0432, 55.4112, 71.5728, 41.5584, 30.0144, 32.3232, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

73.8816, 99.2784, 69.2640, 90.0432, 64.6464, 71.5728, 60.0288, 30.0144, 55.4112, 2.3088, GAMGI_IO_STROKE,

64.6464, 71.5728, 64.6464, 30.0144, 60.0288, 2.3088, GAMGI_IO_STROKE,

120.0576, 99.2784, 110.8224, 94.6608, 101.5872, 85.4256, 92.3520, 71.5728, 78.4992, 30.0144, 69.2640, 11.5440, 60.0288, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 88 X strokes: 3 *
 *************************/

36.9408, 76.1904, 32.3232, 71.5728, 23.0880, 71.5728, 18.4704, 76.1904, 18.4704, 85.4256, 23.0880, 94.6608, 32.3232, 99.2784, 41.5584, 99.2784, 50.7936, 94.6608, 55.4112, 85.4256, 55.4112, 71.5728, 50.7936, 53.1024, 41.5584, 30.0144, 32.3232, 16.1616, 23.0880, 6.9264, 9.2352, 2.3088, 0.0000, 2.3088, -4.6176, 6.9264, -4.6176, 16.1616, 0.0000, 20.7792, 4.6176, 16.1616, 0.0000, 11.5440, GAMGI_IO_STROKE,

41.5584, 99.2784, 46.1760, 94.6608, 50.7936, 85.4256, 50.7936, 71.5728, 46.1760, 53.1024, 36.9408, 30.0144, 27.7056, 16.1616, 18.4704, 6.9264, 9.2352, 2.3088, GAMGI_IO_STROKE,

96.9696, 94.6608, 92.3520, 90.0432, 96.9696, 85.4256, 101.5872, 90.0432, 101.5872, 94.6608, 96.9696, 99.2784, 87.7344, 99.2784, 78.4992, 94.6608, 69.2640, 85.4256, 60.0288, 71.5728, 50.7936, 53.1024, 46.1760, 30.0144, 46.1760, 16.1616, 50.7936, 6.9264, 55.4112, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 89 Y strokes: 4 *
 *************************/

13.8528, 80.8080, 23.0880, 94.6608, 32.3232, 99.2784, 36.9408, 99.2784, 46.1760, 94.6608, 46.1760, 85.4256, 36.9408, 57.7200, 36.9408, 43.8672, 41.5584, 34.6320, GAMGI_IO_STROKE,

36.9408, 99.2784, 41.5584, 94.6608, 41.5584, 85.4256, 32.3232, 57.7200, 32.3232, 43.8672, 41.5584, 34.6320, 50.7936, 34.6320, 64.6464, 39.2496, 73.8816, 48.4848, 83.1168, 62.3376, 87.7344, 71.5728, GAMGI_IO_STROKE,

96.9696, 99.2784, 87.7344, 71.5728, 73.8816, 34.6320, 64.6464, 16.1616, GAMGI_IO_STROKE,

101.5872, 99.2784, 92.3520, 71.5728, 83.1168, 48.4848, 73.8816, 30.0144, 64.6464, 16.1616, 55.4112, 6.9264, 41.5584, 2.3088, 23.0880, 2.3088, 13.8528, 6.9264, 9.2352, 16.1616, 9.2352, 20.7792, 13.8528, 25.3968, 18.4704, 20.7792, 13.8528, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 90 Z strokes: 3 *
 *************************/

87.7344, 90.0432, 83.1168, 80.8080, 73.8816, 57.7200, 69.2640, 43.8672, 64.6464, 34.6320, 55.4112, 20.7792, 46.1760, 11.5440, 36.9408, 6.9264, 23.0880, 2.3088, GAMGI_IO_STROKE,

55.4112, 71.5728, 50.7936, 62.3376, 41.5584, 57.7200, 32.3232, 57.7200, 27.7056, 66.9552, 27.7056, 76.1904, 32.3232, 85.4256, 41.5584, 94.6608, 55.4112, 99.2784, 101.5872, 99.2784, 92.3520, 94.6608, 87.7344, 90.0432, 83.1168, 76.1904, 78.4992, 57.7200, 69.2640, 30.0144, 60.0288, 16.1616, 46.1760, 6.9264, 23.0880, 2.3088, 4.6176, 2.3088, 0.0000, 6.9264, 0.0000, 16.1616, 4.6176, 20.7792, 13.8528, 20.7792, 23.0880, 16.1616, 36.9408, 6.9264, 46.1760, 2.3088, 60.0288, 2.3088, 73.8816, 6.9264, 83.1168, 16.1616, GAMGI_IO_STROKE,

69.2640, 99.2784, 87.7344, 94.6608, 92.3520, 94.6608, GAMGI_IO_CHAR,

/*************************
 * char: 91 [ strokes: 4 *
 *************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_STROKE,

23.0880, 117.7488, 23.0880, -30.0144, GAMGI_IO_STROKE,

18.4704, 117.7488, 50.7936, 117.7488, GAMGI_IO_STROKE,

18.4704, -30.0144, 50.7936, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 92 \ strokes: 1 *
 *************************/

9.2352, 117.7488, 92.3520, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 93 ] strokes: 4 *
 *************************/

41.5584, 117.7488, 41.5584, -30.0144, GAMGI_IO_STROKE,

46.1760, 117.7488, 46.1760, -30.0144, GAMGI_IO_STROKE,

13.8528, 117.7488, 46.1760, 117.7488, GAMGI_IO_STROKE,

13.8528, -30.0144, 46.1760, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 94 ^ strokes: 2 *
 *************************/

27.7056, 71.5728, 36.9408, 85.4256, 46.1760, 71.5728, GAMGI_IO_STROKE,

13.8528, 57.7200, 36.9408, 80.8080, 60.0288, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 95 _ strokes: 1 *
 *************************/

9.2352, -6.9264, 92.3520, -6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 96 ` strokes: 1 *
 *************************/

41.5584, 99.2784, 32.3232, 90.0432, 27.7056, 80.8080, 27.7056, 76.1904, 32.3232, 71.5728, 36.9408, 76.1904, 32.3232, 80.8080, GAMGI_IO_CHAR,

/*************************
 * char: 97 a strokes: 4 *
 *************************/

46.1760, 30.0144, 41.5584, 39.2496, 32.3232, 43.8672, 23.0880, 43.8672, 13.8528, 39.2496, 9.2352, 34.6320, 4.6176, 25.3968, 4.6176, 16.1616, 9.2352, 6.9264, 18.4704, 2.3088, 27.7056, 2.3088, 36.9408, 6.9264, 41.5584, 16.1616, GAMGI_IO_STROKE,

23.0880, 43.8672, 13.8528, 34.6320, 9.2352, 25.3968, 9.2352, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

50.7936, 43.8672, 41.5584, 16.1616, 41.5584, 6.9264, 50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 11.5440, 73.8816, 25.3968, GAMGI_IO_STROKE,

55.4112, 43.8672, 46.1760, 16.1616, 46.1760, 6.9264, 50.7936, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 98 b strokes: 3 *
 *************************/

0.0000, 25.3968, 9.2352, 39.2496, 18.4704, 57.7200, GAMGI_IO_STROKE,

32.3232, 99.2784, 4.6176, 16.1616, 4.6176, 6.9264, 13.8528, 2.3088, 18.4704, 2.3088, 27.7056, 6.9264, 36.9408, 16.1616, 41.5584, 30.0144, 41.5584, 43.8672, 46.1760, 25.3968, 50.7936, 20.7792, 55.4112, 20.7792, 64.6464, 25.3968, GAMGI_IO_STROKE,

36.9408, 99.2784, 9.2352, 16.1616, 9.2352, 6.9264, 13.8528, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 99 c strokes: 2 *
 *************************/

36.9408, 39.2496, 32.3232, 34.6320, 36.9408, 34.6320, 36.9408, 39.2496, 32.3232, 43.8672, 23.0880, 43.8672, 13.8528, 39.2496, 9.2352, 34.6320, 4.6176, 25.3968, 4.6176, 16.1616, 9.2352, 6.9264, 18.4704, 2.3088, 32.3232, 2.3088, 46.1760, 11.5440, 55.4112, 25.3968, GAMGI_IO_STROKE,

23.0880, 43.8672, 13.8528, 34.6320, 9.2352, 25.3968, 9.2352, 11.5440, 18.4704, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 100 d strokes: 4 *
 **************************/

46.1760, 30.0144, 41.5584, 39.2496, 32.3232, 43.8672, 23.0880, 43.8672, 13.8528, 39.2496, 9.2352, 34.6320, 4.6176, 25.3968, 4.6176, 16.1616, 9.2352, 6.9264, 18.4704, 2.3088, 27.7056, 2.3088, 36.9408, 6.9264, 41.5584, 16.1616, GAMGI_IO_STROKE,

23.0880, 43.8672, 13.8528, 34.6320, 9.2352, 25.3968, 9.2352, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

69.2640, 99.2784, 41.5584, 16.1616, 41.5584, 6.9264, 50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 11.5440, 73.8816, 25.3968, GAMGI_IO_STROKE,

73.8816, 99.2784, 46.1760, 16.1616, 46.1760, 6.9264, 50.7936, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 101 e strokes: 2 *
 **************************/

13.8528, 11.5440, 23.0880, 16.1616, 27.7056, 20.7792, 32.3232, 30.0144, 32.3232, 39.2496, 27.7056, 43.8672, 23.0880, 43.8672, 13.8528, 39.2496, 9.2352, 34.6320, 4.6176, 25.3968, 4.6176, 16.1616, 9.2352, 6.9264, 18.4704, 2.3088, 32.3232, 2.3088, 46.1760, 11.5440, 55.4112, 25.3968, GAMGI_IO_STROKE,

23.0880, 43.8672, 13.8528, 34.6320, 9.2352, 25.3968, 9.2352, 11.5440, 18.4704, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 102 f strokes: 2 *
 **************************/

13.8528, 43.8672, 27.7056, 57.7200, 36.9408, 71.5728, 41.5584, 85.4256, 41.5584, 94.6608, 36.9408, 99.2784, 27.7056, 94.6608, 23.0880, 85.4256, -18.4704, -39.2496, -18.4704, -48.4848, -13.8528, -53.1024, -4.6176, -48.4848, 0.0000, -34.6320, 4.6176, 6.9264, 9.2352, 2.3088, 18.4704, 2.3088, 27.7056, 6.9264, 32.3232, 11.5440, 41.5584, 25.3968, GAMGI_IO_STROKE,

23.0880, 85.4256, 18.4704, 62.3376, 13.8528, 43.8672, 0.0000, 2.3088, -9.2352, -20.7792, -18.4704, -39.2496, GAMGI_IO_CHAR,

/**************************
 * char: 103 g strokes: 4 *
 **************************/

46.1760, 30.0144, 41.5584, 39.2496, 32.3232, 43.8672, 23.0880, 43.8672, 13.8528, 39.2496, 9.2352, 34.6320, 4.6176, 25.3968, 4.6176, 16.1616, 9.2352, 6.9264, 18.4704, 2.3088, 27.7056, 2.3088, 36.9408, 6.9264, 41.5584, 16.1616, GAMGI_IO_STROKE,

23.0880, 43.8672, 13.8528, 34.6320, 9.2352, 25.3968, 9.2352, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

50.7936, 43.8672, 23.0880, -39.2496, GAMGI_IO_STROKE,

55.4112, 43.8672, 41.5584, 2.3088, 32.3232, -20.7792, 23.0880, -39.2496, 18.4704, -48.4848, 9.2352, -53.1024, 4.6176, -48.4848, 4.6176, -39.2496, 9.2352, -25.3968, 18.4704, -16.1616, 32.3232, -6.9264, 50.7936, 2.3088, 64.6464, 11.5440, 73.8816, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 104 h strokes: 5 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 18.4704, 57.7200, GAMGI_IO_STROKE,

32.3232, 99.2784, 0.0000, 2.3088, GAMGI_IO_STROKE,

36.9408, 99.2784, 4.6176, 2.3088, GAMGI_IO_STROKE,

13.8528, 30.0144, 23.0880, 39.2496, 32.3232, 43.8672, 36.9408, 43.8672, 46.1760, 39.2496, 46.1760, 30.0144, 41.5584, 16.1616, 41.5584, 6.9264, 46.1760, 2.3088, GAMGI_IO_STROKE,

36.9408, 43.8672, 41.5584, 39.2496, 41.5584, 30.0144, 36.9408, 16.1616, 36.9408, 6.9264, 46.1760, 2.3088, 55.4112, 6.9264, 60.0288, 11.5440, 69.2640, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 105 i strokes: 3 *
 **************************/

23.0880, 71.5728, 18.4704, 66.9552, 23.0880, 62.3376, 27.7056, 66.9552, 23.0880, 71.5728, GAMGI_IO_STROKE,

13.8528, 43.8672, 4.6176, 16.1616, 4.6176, 6.9264, 13.8528, 2.3088, 23.0880, 6.9264, 27.7056, 11.5440, 36.9408, 25.3968, GAMGI_IO_STROKE,

18.4704, 43.8672, 9.2352, 16.1616, 9.2352, 6.9264, 13.8528, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 106 j strokes: 3 *
 **************************/

23.0880, 71.5728, 18.4704, 66.9552, 23.0880, 62.3376, 27.7056, 66.9552, 23.0880, 71.5728, GAMGI_IO_STROKE,

13.8528, 43.8672, -13.8528, -39.2496, GAMGI_IO_STROKE,

18.4704, 43.8672, 4.6176, 2.3088, -4.6176, -20.7792, -13.8528, -39.2496, -18.4704, -48.4848, -27.7056, -53.1024, -32.3232, -48.4848, -32.3232, -39.2496, -27.7056, -25.3968, -18.4704, -16.1616, -4.6176, -6.9264, 13.8528, 2.3088, 27.7056, 11.5440, 36.9408, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 107 k strokes: 6 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 18.4704, 57.7200, GAMGI_IO_STROKE,

32.3232, 99.2784, 0.0000, 2.3088, GAMGI_IO_STROKE,

36.9408, 99.2784, 4.6176, 2.3088, GAMGI_IO_STROKE,

41.5584, 43.8672, 41.5584, 39.2496, 46.1760, 39.2496, 41.5584, 43.8672, 36.9408, 43.8672, 27.7056, 34.6320, 13.8528, 30.0144, GAMGI_IO_STROKE,

13.8528, 30.0144, 27.7056, 25.3968, 32.3232, 6.9264, 36.9408, 2.3088, GAMGI_IO_STROKE,

13.8528, 30.0144, 23.0880, 25.3968, 27.7056, 6.9264, 36.9408, 2.3088, 41.5584, 2.3088, 55.4112, 11.5440, 64.6464, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 108 l strokes: 3 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 18.4704, 57.7200, GAMGI_IO_STROKE,

32.3232, 99.2784, 4.6176, 16.1616, 4.6176, 6.9264, 13.8528, 2.3088, 23.0880, 6.9264, 27.7056, 11.5440, 36.9408, 25.3968, GAMGI_IO_STROKE,

36.9408, 99.2784, 9.2352, 16.1616, 9.2352, 6.9264, 13.8528, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 109 m strokes: 6 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 18.4704, 43.8672, 27.7056, 39.2496, 27.7056, 30.0144, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 43.8672, 23.0880, 39.2496, 23.0880, 30.0144, 13.8528, 2.3088, GAMGI_IO_STROKE,

27.7056, 30.0144, 36.9408, 39.2496, 46.1760, 43.8672, 50.7936, 43.8672, 60.0288, 39.2496, 60.0288, 30.0144, 50.7936, 2.3088, GAMGI_IO_STROKE,

50.7936, 43.8672, 55.4112, 39.2496, 55.4112, 30.0144, 46.1760, 2.3088, GAMGI_IO_STROKE,

60.0288, 30.0144, 69.2640, 39.2496, 78.4992, 43.8672, 83.1168, 43.8672, 92.3520, 39.2496, 92.3520, 30.0144, 87.7344, 16.1616, 87.7344, 6.9264, 92.3520, 2.3088, GAMGI_IO_STROKE,

83.1168, 43.8672, 87.7344, 39.2496, 87.7344, 30.0144, 83.1168, 16.1616, 83.1168, 6.9264, 92.3520, 2.3088, 101.5872, 6.9264, 106.2048, 11.5440, 115.4400, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 110 n strokes: 4 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 18.4704, 43.8672, 27.7056, 39.2496, 27.7056, 30.0144, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 43.8672, 23.0880, 39.2496, 23.0880, 30.0144, 13.8528, 2.3088, GAMGI_IO_STROKE,

27.7056, 30.0144, 36.9408, 39.2496, 46.1760, 43.8672, 50.7936, 43.8672, 60.0288, 39.2496, 60.0288, 30.0144, 55.4112, 16.1616, 55.4112, 6.9264, 60.0288, 2.3088, GAMGI_IO_STROKE,

50.7936, 43.8672, 55.4112, 39.2496, 55.4112, 30.0144, 50.7936, 16.1616, 50.7936, 6.9264, 60.0288, 2.3088, 69.2640, 6.9264, 73.8816, 11.5440, 83.1168, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 111 o strokes: 2 *
 **************************/

32.3232, 43.8672, 23.0880, 43.8672, 13.8528, 39.2496, 9.2352, 34.6320, 4.6176, 25.3968, 4.6176, 16.1616, 9.2352, 6.9264, 18.4704, 2.3088, 27.7056, 2.3088, 36.9408, 6.9264, 41.5584, 11.5440, 46.1760, 20.7792, 46.1760, 30.0144, 41.5584, 39.2496, 32.3232, 43.8672, 27.7056, 39.2496, 27.7056, 30.0144, 32.3232, 20.7792, 41.5584, 16.1616, 50.7936, 16.1616, 60.0288, 20.7792, 64.6464, 25.3968, GAMGI_IO_STROKE,

23.0880, 43.8672, 13.8528, 34.6320, 9.2352, 25.3968, 9.2352, 11.5440, 18.4704, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 112 p strokes: 5 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 18.4704, 57.7200, GAMGI_IO_STROKE,

23.0880, 71.5728, -18.4704, -53.1024, GAMGI_IO_STROKE,

27.7056, 71.5728, -13.8528, -53.1024, GAMGI_IO_STROKE,

13.8528, 30.0144, 23.0880, 39.2496, 32.3232, 43.8672, 36.9408, 43.8672, 46.1760, 39.2496, 46.1760, 30.0144, 41.5584, 16.1616, 41.5584, 6.9264, 46.1760, 2.3088, GAMGI_IO_STROKE,

36.9408, 43.8672, 41.5584, 39.2496, 41.5584, 30.0144, 36.9408, 16.1616, 36.9408, 6.9264, 46.1760, 2.3088, 55.4112, 6.9264, 60.0288, 11.5440, 69.2640, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 113 q strokes: 4 *
 **************************/

46.1760, 30.0144, 41.5584, 39.2496, 32.3232, 43.8672, 23.0880, 43.8672, 13.8528, 39.2496, 9.2352, 34.6320, 4.6176, 25.3968, 4.6176, 16.1616, 9.2352, 6.9264, 18.4704, 2.3088, 27.7056, 2.3088, 36.9408, 6.9264, GAMGI_IO_STROKE,

23.0880, 43.8672, 13.8528, 34.6320, 9.2352, 25.3968, 9.2352, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

50.7936, 43.8672, 23.0880, -39.2496, 23.0880, -48.4848, 27.7056, -53.1024, 36.9408, -48.4848, 41.5584, -34.6320, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 11.5440, 73.8816, 25.3968, GAMGI_IO_STROKE,

55.4112, 43.8672, 41.5584, 2.3088, 32.3232, -20.7792, 23.0880, -39.2496, GAMGI_IO_CHAR,

/**************************
 * char: 114 r strokes: 4 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 18.4704, 43.8672, 27.7056, 39.2496, 27.7056, 30.0144, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 43.8672, 23.0880, 39.2496, 23.0880, 30.0144, 13.8528, 2.3088, GAMGI_IO_STROKE,

27.7056, 30.0144, 36.9408, 39.2496, 46.1760, 43.8672, 50.7936, 43.8672, 46.1760, 30.0144, GAMGI_IO_STROKE,

46.1760, 43.8672, 46.1760, 30.0144, 50.7936, 20.7792, 55.4112, 20.7792, 64.6464, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 115 s strokes: 3 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 13.8528, 48.4848, 13.8528, 39.2496, 27.7056, 30.0144, 32.3232, 20.7792, 32.3232, 11.5440, 27.7056, 6.9264, 18.4704, 2.3088, GAMGI_IO_STROKE,

13.8528, 39.2496, 23.0880, 30.0144, 27.7056, 20.7792, 27.7056, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

0.0000, 6.9264, 9.2352, 2.3088, 32.3232, 2.3088, 46.1760, 11.5440, 55.4112, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 116 t strokes: 4 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 18.4704, 57.7200, GAMGI_IO_STROKE,

32.3232, 99.2784, 4.6176, 16.1616, 4.6176, 6.9264, 13.8528, 2.3088, 23.0880, 6.9264, 27.7056, 11.5440, 36.9408, 25.3968, GAMGI_IO_STROKE,

36.9408, 99.2784, 9.2352, 16.1616, 9.2352, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

9.2352, 62.3376, 36.9408, 62.3376, GAMGI_IO_CHAR,

/**************************
 * char: 117 u strokes: 4 *
 **************************/

13.8528, 43.8672, 4.6176, 16.1616, 4.6176, 6.9264, 13.8528, 2.3088, 18.4704, 2.3088, 27.7056, 6.9264, 36.9408, 16.1616, 46.1760, 30.0144, GAMGI_IO_STROKE,

18.4704, 43.8672, 9.2352, 16.1616, 9.2352, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

50.7936, 43.8672, 41.5584, 16.1616, 41.5584, 6.9264, 50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 11.5440, 73.8816, 25.3968, GAMGI_IO_STROKE,

55.4112, 43.8672, 46.1760, 16.1616, 46.1760, 6.9264, 50.7936, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 118 v strokes: 3 *
 **************************/

13.8528, 43.8672, 9.2352, 34.6320, 4.6176, 20.7792, 4.6176, 6.9264, 13.8528, 2.3088, 18.4704, 2.3088, 32.3232, 6.9264, 41.5584, 16.1616, 46.1760, 30.0144, 46.1760, 43.8672, GAMGI_IO_STROKE,

18.4704, 43.8672, 13.8528, 34.6320, 9.2352, 20.7792, 9.2352, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

46.1760, 43.8672, 50.7936, 25.3968, 55.4112, 20.7792, 60.0288, 20.7792, 69.2640, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 119 w strokes: 5 *
 **************************/

18.4704, 43.8672, 9.2352, 34.6320, 4.6176, 20.7792, 4.6176, 6.9264, 13.8528, 2.3088, 18.4704, 2.3088, 27.7056, 6.9264, 36.9408, 16.1616, GAMGI_IO_STROKE,

23.0880, 43.8672, 13.8528, 34.6320, 9.2352, 20.7792, 9.2352, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

46.1760, 43.8672, 36.9408, 16.1616, 36.9408, 6.9264, 46.1760, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, 73.8816, 30.0144, 73.8816, 43.8672, GAMGI_IO_STROKE,

50.7936, 43.8672, 41.5584, 16.1616, 41.5584, 6.9264, 46.1760, 2.3088, GAMGI_IO_STROKE,

73.8816, 43.8672, 78.4992, 25.3968, 83.1168, 20.7792, 87.7344, 20.7792, 96.9696, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 120 x strokes: 6 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 18.4704, 43.8672, 27.7056, 43.8672, 32.3232, 39.2496, 32.3232, 30.0144, 27.7056, 16.1616, 23.0880, 6.9264, 13.8528, 2.3088, 9.2352, 2.3088, 4.6176, 6.9264, 4.6176, 11.5440, 9.2352, 11.5440, 4.6176, 6.9264, GAMGI_IO_STROKE,

60.0288, 39.2496, 55.4112, 34.6320, 60.0288, 34.6320, 60.0288, 39.2496, 55.4112, 43.8672, 50.7936, 43.8672, 41.5584, 39.2496, 36.9408, 30.0144, 32.3232, 16.1616, 32.3232, 6.9264, 36.9408, 2.3088, 50.7936, 2.3088, 64.6464, 11.5440, 73.8816, 25.3968, GAMGI_IO_STROKE,

32.3232, 39.2496, 36.9408, 30.0144, GAMGI_IO_STROKE,

41.5584, 39.2496, 32.3232, 30.0144, GAMGI_IO_STROKE,

27.7056, 16.1616, 32.3232, 6.9264, GAMGI_IO_STROKE,

32.3232, 16.1616, 23.0880, 6.9264, GAMGI_IO_CHAR,

/**************************
 * char: 121 y strokes: 4 *
 **************************/

13.8528, 43.8672, 4.6176, 16.1616, 4.6176, 6.9264, 13.8528, 2.3088, 18.4704, 2.3088, 27.7056, 6.9264, 36.9408, 16.1616, 46.1760, 30.0144, GAMGI_IO_STROKE,

18.4704, 43.8672, 9.2352, 16.1616, 9.2352, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

50.7936, 43.8672, 23.0880, -39.2496, GAMGI_IO_STROKE,

55.4112, 43.8672, 41.5584, 2.3088, 32.3232, -20.7792, 23.0880, -39.2496, 18.4704, -48.4848, 9.2352, -53.1024, 4.6176, -48.4848, 4.6176, -39.2496, 9.2352, -25.3968, 18.4704, -16.1616, 32.3232, -6.9264, 50.7936, 2.3088, 64.6464, 11.5440, 73.8816, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 122 z strokes: 4 *
 **************************/

0.0000, 25.3968, 9.2352, 39.2496, 18.4704, 43.8672, 27.7056, 43.8672, 36.9408, 39.2496, 36.9408, 25.3968, 32.3232, 16.1616, 18.4704, 6.9264, 9.2352, 2.3088, GAMGI_IO_STROKE,

27.7056, 43.8672, 32.3232, 39.2496, 32.3232, 25.3968, 27.7056, 16.1616, 18.4704, 6.9264, GAMGI_IO_STROKE,

9.2352, 2.3088, 18.4704, -2.3088, 23.0880, -11.5440, 23.0880, -25.3968, 18.4704, -39.2496, 9.2352, -48.4848, 0.0000, -53.1024, -4.6176, -48.4848, -4.6176, -39.2496, 0.0000, -25.3968, 13.8528, -11.5440, 27.7056, -2.3088, 46.1760, 11.5440, 60.0288, 25.3968, GAMGI_IO_STROKE,

9.2352, 2.3088, 13.8528, -2.3088, 18.4704, -11.5440, 18.4704, -25.3968, 13.8528, -39.2496, 9.2352, -48.4848, GAMGI_IO_CHAR,

/**************************
 * char: 123 { strokes: 3 *
 **************************/

46.1760, 117.7488, 32.3232, 103.8960, 27.7056, 90.0432, 27.7056, 80.8080, 32.3232, 66.9552, 41.5584, 57.7200, 41.5584, 53.1024, 23.0880, 43.8672, 41.5584, 34.6320, 41.5584, 30.0144, 32.3232, 20.7792, 27.7056, 6.9264, 27.7056, -2.3088, 32.3232, -16.1616, 46.1760, -30.0144, GAMGI_IO_STROKE,

36.9408, 108.5136, 32.3232, 94.6608, 32.3232, 76.1904, 36.9408, 62.3376, GAMGI_IO_STROKE,

36.9408, 25.3968, 32.3232, 11.5440, 32.3232, -6.9264, 36.9408, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 124 | strokes: 1 *
 **************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 125 } strokes: 3 *
 **************************/

23.0880, 117.7488, 36.9408, 103.8960, 41.5584, 90.0432, 41.5584, 80.8080, 36.9408, 66.9552, 27.7056, 57.7200, 27.7056, 53.1024, 46.1760, 43.8672, 27.7056, 34.6320, 27.7056, 30.0144, 36.9408, 20.7792, 41.5584, 6.9264, 41.5584, -2.3088, 36.9408, -16.1616, 23.0880, -30.0144, GAMGI_IO_STROKE,

32.3232, 108.5136, 36.9408, 94.6608, 36.9408, 76.1904, 32.3232, 62.3376, GAMGI_IO_STROKE,

32.3232, 25.3968, 36.9408, 11.5440, 36.9408, -6.9264, 32.3232, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 126 ~ strokes: 2 *
 **************************/

13.8528, 30.0144, 13.8528, 39.2496, 18.4704, 53.1024, 27.7056, 57.7200, 36.9408, 57.7200, 46.1760, 53.1024, 64.6464, 39.2496, 73.8816, 34.6320, 83.1168, 34.6320, 92.3520, 39.2496, 96.9696, 48.4848, GAMGI_IO_STROKE,

13.8528, 39.2496, 18.4704, 48.4848, 27.7056, 53.1024, 36.9408, 53.1024, 46.1760, 48.4848, 64.6464, 34.6320, 73.8816, 30.0144, 83.1168, 30.0144, 92.3520, 34.6320, 96.9696, 48.4848, 96.9696, 57.7200, GAMGI_IO_CHAR,

};

const float gamgi_io_font_hershey_gothic_english_points[GAMGI_IO_POINTS_GOTHIC_ENGLISH] = {

/***************
 * bottom, top *
 ***************/

-32.3232, 120.0576,

/**************
 * char 32-40 *
 **************/

73.8816, 55.4112, 83.1168, 106.2048, 101.5872, 110.8224, 115.4400, 55.4112, 64.6464, 

/**************
 * char 41-50 *
 **************/

64.6464, 73.8816, 115.4400, 55.4112, 115.4400, 55.4112, 106.2048, 92.3520, 92.3520, 92.3520, 

/**************
 * char 51-60 *
 **************/

92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 55.4112, 55.4112, 110.8224, 

/**************
 * char 61-70 *
 **************/

115.4400, 110.8224, 83.1168, 124.6752, 101.5872, 110.8224, 110.8224, 106.2048, 101.5872, 106.2048, 

/**************
 * char 71-80 *
 **************/

115.4400, 110.8224, 87.7344, 92.3520, 110.8224, 101.5872, 129.2928, 115.4400, 120.0576, 101.5872, 

/**************
 * char 81-90 *
 **************/

120.0576, 110.8224, 106.2048, 110.8224, 110.8224, 106.2048, 124.6752, 101.5872, 106.2048, 92.3520, 

/***************
 * char 91-100 *
 ***************/

64.6464, 106.2048, 64.6464, 73.8816, 101.5872, 55.4112, 78.4992, 83.1168, 64.6464, 78.4992, 

/****************
 * char 101-110 *
 ****************/

64.6464, 60.0288, 83.1168, 83.1168, 46.1760, 46.1760, 78.4992, 46.1760, 120.0576, 83.1168, 

/****************
 * char 111-120 *
 ****************/

83.1168, 83.1168, 83.1168, 64.6464, 73.8816, 46.1760, 83.1168, 83.1168, 120.0576, 87.7344, 

/****************
 * char 121-126 *
 ****************/

83.1168, 83.1168, 69.2640, 41.5584, 69.2640, 110.8224, 

/*************************
 * char: 32   strokes: 0 *
 *************************/

GAMGI_IO_CHAR,

/*************************
 * char: 33 ! strokes: 5 *
 *************************/

27.7056, 99.2784, 23.0880, 94.6608, 13.8528, 90.0432, 23.0880, 85.4256, 27.7056, 34.6320, GAMGI_IO_STROKE,

27.7056, 85.4256, 32.3232, 90.0432, 27.7056, 94.6608, 23.0880, 90.0432, 27.7056, 85.4256, 27.7056, 34.6320, GAMGI_IO_STROKE,

27.7056, 99.2784, 32.3232, 94.6608, 41.5584, 90.0432, 32.3232, 85.4256, 27.7056, 34.6320, GAMGI_IO_STROKE,

27.7056, 16.1616, 18.4704, 6.9264, 27.7056, 2.3088, 36.9408, 6.9264, 27.7056, 16.1616, GAMGI_IO_STROKE,

27.7056, 11.5440, 23.0880, 6.9264, 32.3232, 6.9264, 27.7056, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 34 " strokes: 6 *
 *************************/

23.0880, 99.2784, 18.4704, 94.6608, 18.4704, 66.9552, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 66.9552, GAMGI_IO_STROKE,

23.0880, 99.2784, 27.7056, 94.6608, 18.4704, 66.9552, GAMGI_IO_STROKE,

64.6464, 99.2784, 60.0288, 94.6608, 60.0288, 66.9552, GAMGI_IO_STROKE,

64.6464, 94.6608, 60.0288, 66.9552, GAMGI_IO_STROKE,

64.6464, 99.2784, 69.2640, 94.6608, 60.0288, 66.9552, GAMGI_IO_CHAR,

/*************************
 * char: 35 # strokes: 8 *
 *************************/

36.9408, 99.2784, 36.9408, -30.0144, 41.5584, -30.0144, GAMGI_IO_STROKE,

36.9408, 99.2784, 41.5584, 99.2784, 41.5584, -30.0144, GAMGI_IO_STROKE,

64.6464, 99.2784, 64.6464, -30.0144, 69.2640, -30.0144, GAMGI_IO_STROKE,

64.6464, 99.2784, 69.2640, 99.2784, 69.2640, -30.0144, GAMGI_IO_STROKE,

13.8528, 53.1024, 92.3520, 53.1024, 92.3520, 48.4848, GAMGI_IO_STROKE,

13.8528, 53.1024, 13.8528, 48.4848, 92.3520, 48.4848, GAMGI_IO_STROKE,

13.8528, 20.7792, 92.3520, 20.7792, 92.3520, 16.1616, GAMGI_IO_STROKE,

13.8528, 20.7792, 13.8528, 16.1616, 92.3520, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 36 $ strokes: 16 *
 *************************/

78.4992, 94.6608, 64.6464, 99.2784, 36.9408, 99.2784, 23.0880, 94.6608, 18.4704, 90.0432, 13.8528, 80.8080, 13.8528, 71.5728, 18.4704, 62.3376, 23.0880, 57.7200, 32.3232, 53.1024, 69.2640, 53.1024, 78.4992, 48.4848, 83.1168, 39.2496, 83.1168, 34.6320, 78.4992, 20.7792, GAMGI_IO_STROKE,

73.8816, 90.0432, 64.6464, 94.6608, GAMGI_IO_STROKE,

78.4992, 94.6608, 69.2640, 85.4256, 60.0288, 94.6608, 50.7936, 99.2784, GAMGI_IO_STROKE,

18.4704, 71.5728, 23.0880, 62.3376, 32.3232, 57.7200, 69.2640, 57.7200, 78.4992, 53.1024, 83.1168, 48.4848, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 76.1904, 23.0880, 66.9552, 32.3232, 62.3376, 69.2640, 62.3376, 78.4992, 57.7200, 83.1168, 53.1024, 87.7344, 43.8672, 87.7344, 34.6320, 78.4992, 20.7792, 69.2640, 2.3088, GAMGI_IO_STROKE,

73.8816, 11.5440, 60.0288, 16.1616, 46.1760, 16.1616, 32.3232, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

69.2640, 6.9264, 55.4112, 11.5440, 41.5584, 11.5440, 27.7056, 6.9264, GAMGI_IO_STROKE,

69.2640, 2.3088, 55.4112, 6.9264, 32.3232, 6.9264, 18.4704, 2.3088, GAMGI_IO_STROKE,

41.5584, 117.7488, 41.5584, 99.2784, GAMGI_IO_STROKE,

41.5584, 99.2784, 41.5584, 62.3376, GAMGI_IO_STROKE,

41.5584, 53.1024, 41.5584, 16.1616, GAMGI_IO_STROKE,

41.5584, 6.9264, 41.5584, -16.1616, GAMGI_IO_STROKE,

60.0288, 117.7488, 60.0288, 99.2784, GAMGI_IO_STROKE,

60.0288, 94.6608, 60.0288, 62.3376, GAMGI_IO_STROKE,

60.0288, 53.1024, 60.0288, 16.1616, GAMGI_IO_STROKE,

60.0288, 2.3088, 60.0288, -16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 37 % strokes: 14 *
 *************************/

18.4704, 94.6608, 23.0880, 94.6608, 32.3232, 99.2784, 41.5584, 94.6608, 46.1760, 94.6608, GAMGI_IO_STROKE,

18.4704, 94.6608, 18.4704, 76.1904, GAMGI_IO_STROKE,

23.0880, 94.6608, 23.0880, 76.1904, GAMGI_IO_STROKE,

41.5584, 94.6608, 41.5584, 76.1904, GAMGI_IO_STROKE,

46.1760, 94.6608, 46.1760, 76.1904, GAMGI_IO_STROKE,

18.4704, 76.1904, 23.0880, 76.1904, 32.3232, 71.5728, 41.5584, 76.1904, 46.1760, 76.1904, GAMGI_IO_STROKE,

92.3520, 99.2784, 13.8528, 2.3088, 18.4704, 2.3088, GAMGI_IO_STROKE,

92.3520, 99.2784, 96.9696, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

64.6464, 25.3968, 69.2640, 25.3968, 78.4992, 30.0144, 87.7344, 25.3968, 92.3520, 25.3968, GAMGI_IO_STROKE,

64.6464, 25.3968, 64.6464, 6.9264, GAMGI_IO_STROKE,

69.2640, 25.3968, 69.2640, 6.9264, GAMGI_IO_STROKE,

87.7344, 25.3968, 87.7344, 6.9264, GAMGI_IO_STROKE,

92.3520, 25.3968, 92.3520, 6.9264, GAMGI_IO_STROKE,

64.6464, 6.9264, 69.2640, 6.9264, 78.4992, 2.3088, 87.7344, 6.9264, 92.3520, 6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 38 & strokes: 22 *
 *************************/

32.3232, 85.4256, 41.5584, 85.4256, 50.7936, 90.0432, 55.4112, 99.2784, 60.0288, 94.6608, 69.2640, 90.0432, 78.4992, 90.0432, GAMGI_IO_STROKE,

32.3232, 85.4256, 32.3232, 62.3376, GAMGI_IO_STROKE,

36.9408, 80.8080, 36.9408, 66.9552, GAMGI_IO_STROKE,

41.5584, 85.4256, 41.5584, 62.3376, GAMGI_IO_STROKE,

50.7936, 90.0432, 60.0288, 85.4256, 60.0288, 62.3376, GAMGI_IO_STROKE,

55.4112, 94.6608, 64.6464, 85.4256, 64.6464, 66.9552, GAMGI_IO_STROKE,

78.4992, 90.0432, 69.2640, 85.4256, 69.2640, 62.3376, GAMGI_IO_STROKE,

32.3232, 62.3376, 41.5584, 62.3376, 69.2640, 48.4848, 78.4992, 48.4848, 92.3520, 62.3376, GAMGI_IO_STROKE,

92.3520, 62.3376, 96.9696, 57.7200, 101.5872, 57.7200, 106.2048, 62.3376, GAMGI_IO_STROKE,

87.7344, 57.7200, 92.3520, 53.1024, 96.9696, 53.1024, GAMGI_IO_STROKE,

83.1168, 53.1024, 87.7344, 48.4848, 92.3520, 48.4848, 101.5872, 53.1024, 106.2048, 62.3376, GAMGI_IO_STROKE,

69.2640, 62.3376, 60.0288, 62.3376, 32.3232, 48.4848, 23.0880, 48.4848, GAMGI_IO_STROKE,

23.0880, 48.4848, 23.0880, 16.1616, 13.8528, 11.5440, GAMGI_IO_STROKE,

27.7056, 43.8672, 27.7056, 16.1616, 36.9408, 6.9264, 41.5584, 6.9264, GAMGI_IO_STROKE,

32.3232, 48.4848, 32.3232, 16.1616, 46.1760, 6.9264, GAMGI_IO_STROKE,

69.2640, 48.4848, 69.2640, 16.1616, GAMGI_IO_STROKE,

73.8816, 43.8672, 73.8816, 20.7792, GAMGI_IO_STROKE,

78.4992, 48.4848, 78.4992, 16.1616, GAMGI_IO_STROKE,

13.8528, 11.5440, 23.0880, 11.5440, 32.3232, 6.9264, 36.9408, 2.3088, 46.1760, 6.9264, 60.0288, 6.9264, 69.2640, 16.1616, 78.4992, 16.1616, 92.3520, 2.3088, GAMGI_IO_STROKE,

83.1168, 11.5440, 87.7344, 16.1616, 92.3520, 16.1616, 101.5872, 11.5440, 106.2048, 2.3088, GAMGI_IO_STROKE,

87.7344, 6.9264, 92.3520, 11.5440, 96.9696, 11.5440, GAMGI_IO_STROKE,

92.3520, 2.3088, 96.9696, 6.9264, 101.5872, 6.9264, 106.2048, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 39 ' strokes: 2 *
 *************************/

27.7056, 71.5728, 27.7056, 80.8080, 18.4704, 90.0432, 27.7056, 99.2784, 32.3232, 90.0432, 32.3232, 80.8080, 27.7056, 71.5728, 18.4704, 66.9552, GAMGI_IO_STROKE,

27.7056, 94.6608, 23.0880, 90.0432, 27.7056, 85.4256, 27.7056, 94.6608, GAMGI_IO_CHAR,

/*************************
 * char: 40 ( strokes: 3 *
 *************************/

46.1760, 117.7488, 36.9408, 108.5136, 27.7056, 94.6608, 18.4704, 76.1904, 13.8528, 53.1024, 13.8528, 34.6320, 18.4704, 11.5440, 27.7056, -6.9264, 36.9408, -20.7792, 46.1760, -30.0144, GAMGI_IO_STROKE,

27.7056, 90.0432, 23.0880, 76.1904, 18.4704, 57.7200, 18.4704, 30.0144, 23.0880, 11.5440, 27.7056, -2.3088, GAMGI_IO_STROKE,

36.9408, 108.5136, 32.3232, 99.2784, 27.7056, 85.4256, 23.0880, 57.7200, 23.0880, 30.0144, 27.7056, 2.3088, 32.3232, -11.5440, 36.9408, -20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 41 ) strokes: 3 *
 *************************/

18.4704, 117.7488, 27.7056, 108.5136, 36.9408, 94.6608, 46.1760, 76.1904, 50.7936, 53.1024, 50.7936, 34.6320, 46.1760, 11.5440, 36.9408, -6.9264, 27.7056, -20.7792, 18.4704, -30.0144, GAMGI_IO_STROKE,

36.9408, 90.0432, 41.5584, 76.1904, 46.1760, 57.7200, 46.1760, 30.0144, 41.5584, 11.5440, 36.9408, -2.3088, GAMGI_IO_STROKE,

27.7056, 108.5136, 32.3232, 99.2784, 36.9408, 85.4256, 41.5584, 57.7200, 41.5584, 30.0144, 36.9408, 2.3088, 32.3232, -11.5440, 27.7056, -20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 42 * strokes: 9 *
 *************************/

36.9408, 99.2784, 32.3232, 94.6608, 41.5584, 48.4848, 36.9408, 43.8672, GAMGI_IO_STROKE,

36.9408, 99.2784, 36.9408, 43.8672, GAMGI_IO_STROKE,

36.9408, 99.2784, 41.5584, 94.6608, 32.3232, 48.4848, 36.9408, 43.8672, GAMGI_IO_STROKE,

13.8528, 85.4256, 18.4704, 85.4256, 55.4112, 57.7200, 60.0288, 57.7200, GAMGI_IO_STROKE,

13.8528, 85.4256, 60.0288, 57.7200, GAMGI_IO_STROKE,

13.8528, 85.4256, 13.8528, 80.8080, 60.0288, 62.3376, 60.0288, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 55.4112, 85.4256, 18.4704, 57.7200, 13.8528, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 13.8528, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 60.0288, 80.8080, 13.8528, 62.3376, 13.8528, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 43 + strokes: 4 *
 *************************/

55.4112, 85.4256, 55.4112, 6.9264, 60.0288, 6.9264, GAMGI_IO_STROKE,

55.4112, 85.4256, 60.0288, 85.4256, 60.0288, 6.9264, GAMGI_IO_STROKE,

18.4704, 48.4848, 96.9696, 48.4848, 96.9696, 43.8672, GAMGI_IO_STROKE,

18.4704, 48.4848, 18.4704, 43.8672, 96.9696, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 44 , strokes: 2 *
 *************************/

27.7056, -11.5440, 27.7056, -2.3088, 18.4704, 6.9264, 27.7056, 16.1616, 32.3232, 6.9264, 32.3232, -2.3088, 27.7056, -11.5440, 18.4704, -16.1616, GAMGI_IO_STROKE,

27.7056, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, 27.7056, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 45 - strokes: 2 *
 *************************/

18.4704, 48.4848, 96.9696, 48.4848, 96.9696, 43.8672, GAMGI_IO_STROKE,

18.4704, 48.4848, 18.4704, 43.8672, 96.9696, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 46 . strokes: 2 *
 *************************/

27.7056, 16.1616, 18.4704, 6.9264, 27.7056, 2.3088, 36.9408, 6.9264, 27.7056, 16.1616, GAMGI_IO_STROKE,

27.7056, 11.5440, 23.0880, 6.9264, 32.3232, 6.9264, 27.7056, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 47 / strokes: 2 *
 *************************/

92.3520, 117.7488, 9.2352, -30.0144, 13.8528, -30.0144, GAMGI_IO_STROKE,

92.3520, 117.7488, 96.9696, 117.7488, 13.8528, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 48 0 strokes: 8 *
 *************************/

18.4704, 90.0432, 18.4704, 16.1616, 9.2352, 11.5440, GAMGI_IO_STROKE,

23.0880, 85.4256, 23.0880, 16.1616, 36.9408, 6.9264, GAMGI_IO_STROKE,

27.7056, 90.0432, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 6.9264, GAMGI_IO_STROKE,

18.4704, 90.0432, 27.7056, 90.0432, 50.7936, 94.6608, 60.0288, 99.2784, GAMGI_IO_STROKE,

50.7936, 94.6608, 55.4112, 90.0432, 64.6464, 85.4256, 64.6464, 11.5440, GAMGI_IO_STROKE,

55.4112, 94.6608, 69.2640, 85.4256, 69.2640, 16.1616, GAMGI_IO_STROKE,

60.0288, 99.2784, 64.6464, 94.6608, 73.8816, 90.0432, 83.1168, 90.0432, 73.8816, 85.4256, 73.8816, 11.5440, GAMGI_IO_STROKE,

9.2352, 11.5440, 18.4704, 11.5440, 27.7056, 6.9264, 32.3232, 2.3088, 41.5584, 6.9264, 64.6464, 11.5440, 73.8816, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 49 1 strokes: 4 *
 *************************/

32.3232, 90.0432, 36.9408, 85.4256, 41.5584, 76.1904, 41.5584, 16.1616, 32.3232, 11.5440, GAMGI_IO_STROKE,

41.5584, 85.4256, 36.9408, 90.0432, 41.5584, 94.6608, 46.1760, 85.4256, 46.1760, 11.5440, 55.4112, 6.9264, GAMGI_IO_STROKE,

32.3232, 90.0432, 46.1760, 99.2784, 50.7936, 90.0432, 50.7936, 16.1616, 60.0288, 11.5440, 64.6464, 11.5440, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 11.5440, 46.1760, 6.9264, 50.7936, 2.3088, 55.4112, 6.9264, 64.6464, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 50 2 strokes: 10 *
 *************************/

18.4704, 90.0432, 27.7056, 90.0432, 36.9408, 94.6608, 41.5584, 99.2784, 50.7936, 94.6608, 64.6464, 90.0432, 73.8816, 90.0432, GAMGI_IO_STROKE,

36.9408, 90.0432, 46.1760, 94.6608, GAMGI_IO_STROKE,

18.4704, 90.0432, 27.7056, 85.4256, 36.9408, 85.4256, 46.1760, 90.0432, 50.7936, 94.6608, GAMGI_IO_STROKE,

64.6464, 90.0432, 64.6464, 53.1024, GAMGI_IO_STROKE,

69.2640, 85.4256, 69.2640, 57.7200, GAMGI_IO_STROKE,

73.8816, 90.0432, 73.8816, 53.1024, GAMGI_IO_STROKE,

73.8816, 53.1024, 64.6464, 53.1024, 13.8528, 2.3088, GAMGI_IO_STROKE,

13.8528, 2.3088, 32.3232, 11.5440, 50.7936, 16.1616, 64.6464, 16.1616, 83.1168, 11.5440, GAMGI_IO_STROKE,

27.7056, 6.9264, 41.5584, 11.5440, 64.6464, 11.5440, 78.4992, 6.9264, GAMGI_IO_STROKE,

13.8528, 2.3088, 36.9408, 6.9264, 60.0288, 6.9264, 73.8816, 2.3088, 83.1168, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 51 3 strokes: 12 *
 *************************/

18.4704, 90.0432, 23.0880, 90.0432, 32.3232, 94.6608, 36.9408, 99.2784, 46.1760, 94.6608, 64.6464, 90.0432, 73.8816, 90.0432, GAMGI_IO_STROKE,

32.3232, 90.0432, 41.5584, 94.6608, GAMGI_IO_STROKE,

18.4704, 90.0432, 27.7056, 85.4256, 36.9408, 85.4256, 46.1760, 94.6608, GAMGI_IO_STROKE,

64.6464, 90.0432, 64.6464, 57.7200, GAMGI_IO_STROKE,

69.2640, 85.4256, 69.2640, 62.3376, GAMGI_IO_STROKE,

73.8816, 90.0432, 73.8816, 57.7200, 64.6464, 57.7200, 50.7936, 53.1024, 41.5584, 48.4848, GAMGI_IO_STROKE,

41.5584, 53.1024, 50.7936, 48.4848, 64.6464, 43.8672, 73.8816, 43.8672, 73.8816, 11.5440, GAMGI_IO_STROKE,

69.2640, 39.2496, 69.2640, 16.1616, GAMGI_IO_STROKE,

64.6464, 43.8672, 64.6464, 11.5440, GAMGI_IO_STROKE,

13.8528, 11.5440, 23.0880, 16.1616, 32.3232, 16.1616, 41.5584, 11.5440, 46.1760, 6.9264, GAMGI_IO_STROKE,

32.3232, 11.5440, 41.5584, 6.9264, GAMGI_IO_STROKE,

13.8528, 11.5440, 23.0880, 11.5440, 32.3232, 6.9264, 36.9408, 2.3088, 46.1760, 6.9264, 64.6464, 11.5440, 73.8816, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 52 4 strokes: 8 *
 *************************/

60.0288, 99.2784, 13.8528, 53.1024, 13.8528, 30.0144, 55.4112, 30.0144, GAMGI_IO_STROKE,

64.6464, 30.0144, 83.1168, 30.0144, 87.7344, 25.3968, 87.7344, 34.6320, 83.1168, 30.0144, GAMGI_IO_STROKE,

18.4704, 53.1024, 18.4704, 34.6320, GAMGI_IO_STROKE,

23.0880, 62.3376, 23.0880, 30.0144, GAMGI_IO_STROKE,

55.4112, 94.6608, 55.4112, 16.1616, 46.1760, 11.5440, GAMGI_IO_STROKE,

60.0288, 80.8080, 64.6464, 90.0432, 60.0288, 94.6608, 60.0288, 11.5440, 69.2640, 6.9264, GAMGI_IO_STROKE,

60.0288, 99.2784, 69.2640, 90.0432, 64.6464, 80.8080, 64.6464, 16.1616, 73.8816, 11.5440, 78.4992, 11.5440, GAMGI_IO_STROKE,

46.1760, 11.5440, 50.7936, 11.5440, 60.0288, 6.9264, 64.6464, 2.3088, 69.2640, 6.9264, 78.4992, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 53 5 strokes: 11 *
 *************************/

18.4704, 99.2784, 18.4704, 57.7200, GAMGI_IO_STROKE,

18.4704, 99.2784, 73.8816, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 64.6464, 94.6608, GAMGI_IO_STROKE,

18.4704, 90.0432, 60.0288, 90.0432, 69.2640, 94.6608, 73.8816, 99.2784, GAMGI_IO_STROKE,

64.6464, 71.5728, 60.0288, 66.9552, 50.7936, 62.3376, 32.3232, 57.7200, 18.4704, 57.7200, GAMGI_IO_STROKE,

50.7936, 62.3376, 55.4112, 62.3376, 64.6464, 57.7200, 64.6464, 11.5440, GAMGI_IO_STROKE,

60.0288, 66.9552, 69.2640, 62.3376, 69.2640, 16.1616, GAMGI_IO_STROKE,

64.6464, 71.5728, 69.2640, 66.9552, 78.4992, 62.3376, 83.1168, 62.3376, 73.8816, 57.7200, 73.8816, 11.5440, GAMGI_IO_STROKE,

13.8528, 11.5440, 23.0880, 16.1616, 32.3232, 16.1616, 41.5584, 11.5440, 46.1760, 6.9264, GAMGI_IO_STROKE,

32.3232, 11.5440, 41.5584, 6.9264, GAMGI_IO_STROKE,

13.8528, 11.5440, 23.0880, 11.5440, 32.3232, 6.9264, 36.9408, 2.3088, 46.1760, 6.9264, 64.6464, 11.5440, 73.8816, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 54 6 strokes: 11 *
 *************************/

18.4704, 90.0432, 18.4704, 16.1616, 9.2352, 11.5440, GAMGI_IO_STROKE,

23.0880, 85.4256, 23.0880, 16.1616, 36.9408, 6.9264, GAMGI_IO_STROKE,

27.7056, 90.0432, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 6.9264, GAMGI_IO_STROKE,

18.4704, 90.0432, 27.7056, 90.0432, 46.1760, 94.6608, 55.4112, 99.2784, 60.0288, 94.6608, 69.2640, 90.0432, 73.8816, 90.0432, GAMGI_IO_STROKE,

50.7936, 94.6608, 60.0288, 90.0432, GAMGI_IO_STROKE,

46.1760, 94.6608, 55.4112, 85.4256, 64.6464, 85.4256, 73.8816, 90.0432, GAMGI_IO_STROKE,

27.7056, 53.1024, 32.3232, 53.1024, 50.7936, 57.7200, 60.0288, 62.3376, 64.6464, 66.9552, GAMGI_IO_STROKE,

50.7936, 57.7200, 55.4112, 57.7200, 64.6464, 53.1024, 64.6464, 11.5440, GAMGI_IO_STROKE,

60.0288, 62.3376, 69.2640, 53.1024, 69.2640, 16.1616, GAMGI_IO_STROKE,

64.6464, 66.9552, 69.2640, 62.3376, 78.4992, 57.7200, 83.1168, 57.7200, 73.8816, 53.1024, 73.8816, 11.5440, GAMGI_IO_STROKE,

9.2352, 11.5440, 18.4704, 11.5440, 27.7056, 6.9264, 32.3232, 2.3088, 41.5584, 6.9264, 64.6464, 11.5440, 73.8816, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 55 7 strokes: 6 *
 *************************/

13.8528, 90.0432, 23.0880, 99.2784, 36.9408, 94.6608, 60.0288, 94.6608, 83.1168, 99.2784, GAMGI_IO_STROKE,

18.4704, 94.6608, 32.3232, 90.0432, 55.4112, 90.0432, 69.2640, 94.6608, GAMGI_IO_STROKE,

13.8528, 90.0432, 32.3232, 85.4256, 46.1760, 85.4256, 64.6464, 90.0432, 83.1168, 99.2784, GAMGI_IO_STROKE,

83.1168, 99.2784, 78.4992, 90.0432, 69.2640, 76.1904, 50.7936, 57.7200, 41.5584, 43.8672, 36.9408, 30.0144, 36.9408, 16.1616, 41.5584, 2.3088, GAMGI_IO_STROKE,

46.1760, 48.4848, 41.5584, 34.6320, 41.5584, 20.7792, 46.1760, 6.9264, GAMGI_IO_STROKE,

60.0288, 66.9552, 50.7936, 53.1024, 46.1760, 39.2496, 46.1760, 25.3968, 50.7936, 11.5440, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 56 8 strokes: 16 *
 *************************/

18.4704, 85.4256, 18.4704, 57.7200, GAMGI_IO_STROKE,

23.0880, 80.8080, 23.0880, 62.3376, GAMGI_IO_STROKE,

27.7056, 85.4256, 27.7056, 57.7200, GAMGI_IO_STROKE,

18.4704, 85.4256, 27.7056, 85.4256, 50.7936, 90.0432, 60.0288, 94.6608, 64.6464, 99.2784, GAMGI_IO_STROKE,

50.7936, 90.0432, 55.4112, 90.0432, 64.6464, 85.4256, 64.6464, 57.7200, GAMGI_IO_STROKE,

60.0288, 94.6608, 69.2640, 90.0432, 69.2640, 62.3376, GAMGI_IO_STROKE,

64.6464, 99.2784, 69.2640, 94.6608, 78.4992, 90.0432, 83.1168, 90.0432, 73.8816, 85.4256, 73.8816, 57.7200, GAMGI_IO_STROKE,

18.4704, 57.7200, 27.7056, 57.7200, 64.6464, 43.8672, 73.8816, 43.8672, GAMGI_IO_STROKE,

73.8816, 57.7200, 64.6464, 57.7200, 27.7056, 43.8672, 18.4704, 43.8672, GAMGI_IO_STROKE,

18.4704, 43.8672, 18.4704, 16.1616, 9.2352, 11.5440, GAMGI_IO_STROKE,

23.0880, 39.2496, 23.0880, 16.1616, 36.9408, 6.9264, GAMGI_IO_STROKE,

27.7056, 43.8672, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 6.9264, GAMGI_IO_STROKE,

64.6464, 43.8672, 64.6464, 11.5440, GAMGI_IO_STROKE,

69.2640, 39.2496, 69.2640, 16.1616, GAMGI_IO_STROKE,

73.8816, 43.8672, 73.8816, 11.5440, GAMGI_IO_STROKE,

9.2352, 11.5440, 18.4704, 11.5440, 27.7056, 6.9264, 32.3232, 2.3088, 41.5584, 6.9264, 64.6464, 11.5440, 73.8816, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 57 9 strokes: 11 *
 *************************/

18.4704, 90.0432, 18.4704, 48.4848, 9.2352, 43.8672, GAMGI_IO_STROKE,

23.0880, 85.4256, 23.0880, 43.8672, 32.3232, 39.2496, GAMGI_IO_STROKE,

27.7056, 90.0432, 27.7056, 48.4848, 36.9408, 43.8672, 41.5584, 43.8672, GAMGI_IO_STROKE,

18.4704, 90.0432, 27.7056, 90.0432, 50.7936, 94.6608, 60.0288, 99.2784, GAMGI_IO_STROKE,

50.7936, 94.6608, 55.4112, 90.0432, 64.6464, 85.4256, 64.6464, 11.5440, GAMGI_IO_STROKE,

55.4112, 94.6608, 69.2640, 85.4256, 69.2640, 16.1616, GAMGI_IO_STROKE,

60.0288, 99.2784, 64.6464, 94.6608, 73.8816, 90.0432, 83.1168, 90.0432, 73.8816, 85.4256, 73.8816, 11.5440, GAMGI_IO_STROKE,

9.2352, 43.8672, 13.8528, 43.8672, 23.0880, 39.2496, 27.7056, 34.6320, 32.3232, 39.2496, 41.5584, 43.8672, 60.0288, 48.4848, 64.6464, 48.4848, GAMGI_IO_STROKE,

13.8528, 11.5440, 23.0880, 16.1616, 32.3232, 16.1616, 41.5584, 11.5440, 46.1760, 6.9264, GAMGI_IO_STROKE,

32.3232, 11.5440, 41.5584, 6.9264, GAMGI_IO_STROKE,

13.8528, 11.5440, 23.0880, 11.5440, 32.3232, 6.9264, 36.9408, 2.3088, 46.1760, 6.9264, 64.6464, 11.5440, 73.8816, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 58 : strokes: 4 *
 *************************/

27.7056, 66.9552, 18.4704, 57.7200, 27.7056, 53.1024, 36.9408, 57.7200, 27.7056, 66.9552, GAMGI_IO_STROKE,

27.7056, 62.3376, 23.0880, 57.7200, 32.3232, 57.7200, 27.7056, 62.3376, GAMGI_IO_STROKE,

27.7056, 16.1616, 18.4704, 6.9264, 27.7056, 2.3088, 36.9408, 6.9264, 27.7056, 16.1616, GAMGI_IO_STROKE,

27.7056, 11.5440, 23.0880, 6.9264, 32.3232, 6.9264, 27.7056, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 59 ; strokes: 4 *
 *************************/

27.7056, 66.9552, 18.4704, 57.7200, 27.7056, 53.1024, 36.9408, 57.7200, 27.7056, 66.9552, GAMGI_IO_STROKE,

27.7056, 62.3376, 23.0880, 57.7200, 32.3232, 57.7200, 27.7056, 62.3376, GAMGI_IO_STROKE,

27.7056, -11.5440, 27.7056, -2.3088, 18.4704, 6.9264, 27.7056, 16.1616, 32.3232, 6.9264, 32.3232, -2.3088, 27.7056, -11.5440, 18.4704, -16.1616, GAMGI_IO_STROKE,

27.7056, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, 27.7056, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 60 < strokes: 2 *
 *************************/

92.3520, 85.4256, 18.4704, 43.8672, 92.3520, 2.3088, GAMGI_IO_STROKE,

92.3520, 85.4256, 92.3520, 80.8080, 27.7056, 43.8672, 92.3520, 6.9264, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 61 = strokes: 4 *
 *************************/

18.4704, 66.9552, 96.9696, 66.9552, 96.9696, 62.3376, GAMGI_IO_STROKE,

18.4704, 66.9552, 18.4704, 62.3376, 96.9696, 62.3376, GAMGI_IO_STROKE,

18.4704, 30.0144, 96.9696, 30.0144, 96.9696, 25.3968, GAMGI_IO_STROKE,

18.4704, 30.0144, 18.4704, 25.3968, 96.9696, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 62 > strokes: 2 *
 *************************/

18.4704, 85.4256, 92.3520, 43.8672, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 85.4256, 18.4704, 80.8080, 83.1168, 43.8672, 18.4704, 6.9264, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 63 ? strokes: 11 *
 *************************/

9.2352, 85.4256, 18.4704, 85.4256, 27.7056, 90.0432, 36.9408, 99.2784, 41.5584, 90.0432, 60.0288, 80.8080, 69.2640, 80.8080, GAMGI_IO_STROKE,

27.7056, 85.4256, 36.9408, 90.0432, 36.9408, 94.6608, 27.7056, 85.4256, GAMGI_IO_STROKE,

9.2352, 85.4256, 18.4704, 80.8080, 27.7056, 80.8080, 36.9408, 85.4256, 41.5584, 90.0432, GAMGI_IO_STROKE,

60.0288, 80.8080, 60.0288, 53.1024, GAMGI_IO_STROKE,

64.6464, 76.1904, 64.6464, 57.7200, GAMGI_IO_STROKE,

69.2640, 80.8080, 69.2640, 53.1024, GAMGI_IO_STROKE,

69.2640, 53.1024, 50.7936, 53.1024, 36.9408, 48.4848, 32.3232, 43.8672, 41.5584, 34.6320, GAMGI_IO_STROKE,

46.1760, 48.4848, 36.9408, 43.8672, 41.5584, 39.2496, 46.1760, 48.4848, GAMGI_IO_STROKE,

60.0288, 53.1024, 50.7936, 48.4848, 46.1760, 43.8672, 41.5584, 34.6320, GAMGI_IO_STROKE,

41.5584, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, 50.7936, 6.9264, 41.5584, 16.1616, GAMGI_IO_STROKE,

41.5584, 11.5440, 36.9408, 6.9264, 46.1760, 6.9264, 41.5584, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 64 @ strokes: 8 *
 *************************/

41.5584, 66.9552, 50.7936, 66.9552, 64.6464, 71.5728, 73.8816, 76.1904, 78.4992, 71.5728, 87.7344, 71.5728, GAMGI_IO_STROKE,

41.5584, 66.9552, 41.5584, 34.6320, 36.9408, 30.0144, GAMGI_IO_STROKE,

46.1760, 62.3376, 46.1760, 34.6320, 50.7936, 30.0144, 55.4112, 30.0144, GAMGI_IO_STROKE,

50.7936, 66.9552, 50.7936, 34.6320, 60.0288, 30.0144, GAMGI_IO_STROKE,

64.6464, 71.5728, 73.8816, 66.9552, 73.8816, 34.6320, GAMGI_IO_STROKE,

69.2640, 71.5728, 73.8816, 71.5728, 78.4992, 66.9552, 78.4992, 34.6320, 83.1168, 30.0144, GAMGI_IO_STROKE,

87.7344, 71.5728, 83.1168, 66.9552, 83.1168, 34.6320, 87.7344, 25.3968, GAMGI_IO_STROKE,

36.9408, 30.0144, 46.1760, 30.0144, 50.7936, 25.3968, 60.0288, 30.0144, 73.8816, 34.6320, 78.4992, 30.0144, 87.7344, 25.3968, 96.9696, 25.3968, 106.2048, 30.0144, 110.8224, 43.8672, 110.8224, 57.7200, 106.2048, 71.5728, 101.5872, 80.8080, 92.3520, 90.0432, 83.1168, 94.6608, 69.2640, 99.2784, 55.4112, 99.2784, 41.5584, 94.6608, 32.3232, 90.0432, 23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 55.4112, 2.3088, 69.2640, 2.3088, 83.1168, 6.9264, 92.3520, 11.5440, 87.7344, 11.5440, 83.1168, 6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 65 A strokes: 11 *
 *************************/

23.0880, 85.4256, 32.3232, 94.6608, 41.5584, 99.2784, 50.7936, 99.2784, 55.4112, 94.6608, 87.7344, 20.7792, 92.3520, 16.1616, 101.5872, 16.1616, GAMGI_IO_STROKE,

46.1760, 94.6608, 50.7936, 90.0432, 83.1168, 16.1616, 87.7344, 6.9264, 92.3520, 11.5440, 83.1168, 16.1616, GAMGI_IO_STROKE,

32.3232, 94.6608, 41.5584, 94.6608, 46.1760, 90.0432, 78.4992, 16.1616, 83.1168, 6.9264, 87.7344, 2.3088, 92.3520, 2.3088, 101.5872, 16.1616, GAMGI_IO_STROKE,

23.0880, 66.9552, 27.7056, 71.5728, 36.9408, 76.1904, 41.5584, 76.1904, 46.1760, 71.5728, GAMGI_IO_STROKE,

41.5584, 71.5728, 41.5584, 66.9552, GAMGI_IO_STROKE,

27.7056, 71.5728, 36.9408, 71.5728, 41.5584, 62.3376, GAMGI_IO_STROKE,

0.0000, 2.3088, 9.2352, 11.5440, 18.4704, 16.1616, 32.3232, 16.1616, 41.5584, 11.5440, GAMGI_IO_STROKE,

13.8528, 11.5440, 32.3232, 11.5440, 36.9408, 6.9264, GAMGI_IO_STROKE,

0.0000, 2.3088, 13.8528, 6.9264, 27.7056, 6.9264, 32.3232, 2.3088, 41.5584, 11.5440, GAMGI_IO_STROKE,

50.7936, 80.8080, 23.0880, 16.1616, GAMGI_IO_STROKE,

32.3232, 39.2496, 69.2640, 39.2496, GAMGI_IO_CHAR,

/*************************
 * char: 66 B strokes: 22 *
 *************************/

9.2352, 90.0432, 18.4704, 99.2784, 32.3232, 99.2784, 41.5584, 94.6608, 50.7936, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 36.9408, 94.6608, GAMGI_IO_STROKE,

9.2352, 90.0432, 18.4704, 94.6608, 27.7056, 90.0432, 41.5584, 90.0432, 50.7936, 99.2784, GAMGI_IO_STROKE,

32.3232, 76.1904, 27.7056, 71.5728, 23.0880, 62.3376, 23.0880, 57.7200, 13.8528, 57.7200, 9.2352, 53.1024, 9.2352, 43.8672, 13.8528, 48.4848, 23.0880, 48.4848, 23.0880, 20.7792, GAMGI_IO_STROKE,

27.7056, 66.9552, 27.7056, 30.0144, GAMGI_IO_STROKE,

13.8528, 53.1024, 27.7056, 53.1024, GAMGI_IO_STROKE,

32.3232, 76.1904, 32.3232, 34.6320, 27.7056, 25.3968, 23.0880, 20.7792, GAMGI_IO_STROKE,

55.4112, 85.4256, 50.7936, 80.8080, 46.1760, 71.5728, 46.1760, 30.0144, GAMGI_IO_STROKE,

50.7936, 76.1904, 50.7936, 39.2496, GAMGI_IO_STROKE,

55.4112, 85.4256, 55.4112, 43.8672, 50.7936, 34.6320, 46.1760, 30.0144, GAMGI_IO_STROKE,

55.4112, 85.4256, 83.1168, 99.2784, 92.3520, 94.6608, 96.9696, 85.4256, 96.9696, 76.1904, 87.7344, 66.9552, 69.2640, 57.7200, GAMGI_IO_STROKE,

83.1168, 94.6608, 92.3520, 85.4256, 92.3520, 76.1904, GAMGI_IO_STROKE,

73.8816, 94.6608, 83.1168, 90.0432, 87.7344, 85.4256, 87.7344, 71.5728, 78.4992, 62.3376, GAMGI_IO_STROKE,

78.4992, 62.3376, 92.3520, 53.1024, 96.9696, 43.8672, 96.9696, 16.1616, GAMGI_IO_STROKE,

87.7344, 53.1024, 92.3520, 43.8672, 92.3520, 20.7792, GAMGI_IO_STROKE,

78.4992, 62.3376, 83.1168, 57.7200, 87.7344, 48.4848, 87.7344, 16.1616, GAMGI_IO_STROKE,

18.4704, 2.3088, 32.3232, 11.5440, 46.1760, 16.1616, 64.6464, 16.1616, 78.4992, 11.5440, GAMGI_IO_STROKE,

27.7056, 6.9264, 41.5584, 11.5440, 64.6464, 11.5440, 73.8816, 6.9264, GAMGI_IO_STROKE,

18.4704, 2.3088, 36.9408, 6.9264, 60.0288, 6.9264, 69.2640, 2.3088, 78.4992, 11.5440, 87.7344, 16.1616, 96.9696, 16.1616, GAMGI_IO_STROKE,

69.2640, 57.7200, 69.2640, 16.1616, GAMGI_IO_STROKE,

69.2640, 43.8672, 87.7344, 43.8672, GAMGI_IO_STROKE,

69.2640, 30.0144, 87.7344, 30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 67 C strokes: 10 *
 *************************/

41.5584, 94.6608, 32.3232, 90.0432, 23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 36.9408, 6.9264, 50.7936, 2.3088, 64.6464, 2.3088, 78.4992, 6.9264, 87.7344, 11.5440, 96.9696, 20.7792, 101.5872, 30.0144, GAMGI_IO_STROKE,

23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 27.7056, 20.7792, 41.5584, 11.5440, 55.4112, 6.9264, 69.2640, 6.9264, 83.1168, 11.5440, GAMGI_IO_STROKE,

41.5584, 94.6608, 32.3232, 85.4256, 27.7056, 76.1904, 23.0880, 62.3376, 23.0880, 43.8672, 27.7056, 30.0144, 41.5584, 16.1616, 55.4112, 11.5440, 69.2640, 11.5440, 83.1168, 16.1616, 92.3520, 20.7792, 101.5872, 30.0144, GAMGI_IO_STROKE,

50.7936, 80.8080, 50.7936, 25.3968, GAMGI_IO_STROKE,

55.4112, 80.8080, 55.4112, 34.6320, GAMGI_IO_STROKE,

60.0288, 85.4256, 60.0288, 39.2496, 55.4112, 30.0144, 50.7936, 25.3968, GAMGI_IO_STROKE,

50.7936, 80.8080, 60.0288, 85.4256, 73.8816, 99.2784, 83.1168, 94.6608, 92.3520, 94.6608, 96.9696, 99.2784, GAMGI_IO_STROKE,

69.2640, 94.6608, 78.4992, 90.0432, 87.7344, 90.0432, GAMGI_IO_STROKE,

64.6464, 90.0432, 73.8816, 85.4256, 83.1168, 85.4256, 92.3520, 90.0432, 96.9696, 99.2784, GAMGI_IO_STROKE,

83.1168, 85.4256, 83.1168, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 68 D strokes: 13 *
 *************************/

9.2352, 99.2784, 73.8816, 99.2784, 83.1168, 94.6608, 87.7344, 85.4256, 87.7344, 16.1616, GAMGI_IO_STROKE,

18.4704, 94.6608, 73.8816, 94.6608, 83.1168, 85.4256, 83.1168, 20.7792, GAMGI_IO_STROKE,

9.2352, 99.2784, 13.8528, 94.6608, 23.0880, 90.0432, 73.8816, 90.0432, 78.4992, 85.4256, 78.4992, 16.1616, GAMGI_IO_STROKE,

36.9408, 76.1904, 32.3232, 71.5728, 27.7056, 62.3376, 27.7056, 57.7200, 18.4704, 57.7200, 13.8528, 53.1024, 13.8528, 43.8672, 18.4704, 48.4848, 27.7056, 48.4848, 27.7056, 25.3968, GAMGI_IO_STROKE,

32.3232, 66.9552, 32.3232, 34.6320, GAMGI_IO_STROKE,

18.4704, 53.1024, 32.3232, 53.1024, GAMGI_IO_STROKE,

36.9408, 76.1904, 36.9408, 39.2496, 32.3232, 30.0144, 27.7056, 25.3968, GAMGI_IO_STROKE,

9.2352, 2.3088, 23.0880, 11.5440, 36.9408, 16.1616, 55.4112, 16.1616, 69.2640, 11.5440, GAMGI_IO_STROKE,

18.4704, 6.9264, 32.3232, 11.5440, 55.4112, 11.5440, 64.6464, 6.9264, GAMGI_IO_STROKE,

9.2352, 2.3088, 27.7056, 6.9264, 50.7936, 6.9264, 60.0288, 2.3088, 69.2640, 11.5440, 78.4992, 16.1616, 87.7344, 16.1616, GAMGI_IO_STROKE,

50.7936, 90.0432, 50.7936, 16.1616, GAMGI_IO_STROKE,

50.7936, 66.9552, 60.0288, 62.3376, 69.2640, 62.3376, 78.4992, 66.9552, GAMGI_IO_STROKE,

50.7936, 39.2496, 60.0288, 43.8672, 69.2640, 43.8672, 78.4992, 39.2496, GAMGI_IO_CHAR,

/*************************
 * char: 69 E strokes: 17 *
 *************************/

9.2352, 90.0432, 18.4704, 99.2784, 27.7056, 99.2784, 36.9408, 94.6608, 46.1760, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 32.3232, 94.6608, GAMGI_IO_STROKE,

9.2352, 90.0432, 18.4704, 94.6608, 27.7056, 90.0432, 36.9408, 90.0432, 46.1760, 99.2784, GAMGI_IO_STROKE,

32.3232, 76.1904, 27.7056, 71.5728, 23.0880, 62.3376, 23.0880, 57.7200, 13.8528, 57.7200, 9.2352, 53.1024, 9.2352, 43.8672, 13.8528, 48.4848, 23.0880, 48.4848, 23.0880, 20.7792, GAMGI_IO_STROKE,

27.7056, 66.9552, 27.7056, 30.0144, GAMGI_IO_STROKE,

13.8528, 53.1024, 27.7056, 53.1024, GAMGI_IO_STROKE,

32.3232, 76.1904, 32.3232, 34.6320, 27.7056, 25.3968, 23.0880, 20.7792, GAMGI_IO_STROKE,

46.1760, 66.9552, 50.7936, 80.8080, 55.4112, 90.0432, 60.0288, 94.6608, 69.2640, 99.2784, 78.4992, 99.2784, 92.3520, 94.6608, GAMGI_IO_STROKE,

60.0288, 90.0432, 69.2640, 94.6608, 78.4992, 94.6608, 87.7344, 90.0432, GAMGI_IO_STROKE,

50.7936, 80.8080, 55.4112, 85.4256, 64.6464, 90.0432, 73.8816, 90.0432, 83.1168, 85.4256, 92.3520, 94.6608, GAMGI_IO_STROKE,

46.1760, 30.0144, 50.7936, 43.8672, 55.4112, 53.1024, 60.0288, 57.7200, 69.2640, 57.7200, 78.4992, 53.1024, GAMGI_IO_STROKE,

60.0288, 53.1024, 69.2640, 53.1024, 73.8816, 48.4848, GAMGI_IO_STROKE,

50.7936, 43.8672, 55.4112, 48.4848, 64.6464, 48.4848, 69.2640, 43.8672, 78.4992, 53.1024, GAMGI_IO_STROKE,

18.4704, 2.3088, 32.3232, 11.5440, 50.7936, 16.1616, 73.8816, 16.1616, 92.3520, 11.5440, GAMGI_IO_STROKE,

27.7056, 6.9264, 41.5584, 11.5440, 73.8816, 11.5440, 87.7344, 6.9264, GAMGI_IO_STROKE,

18.4704, 2.3088, 36.9408, 6.9264, 69.2640, 6.9264, 83.1168, 2.3088, 92.3520, 11.5440, GAMGI_IO_STROKE,

46.1760, 66.9552, 46.1760, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 70 F strokes: 17 *
 *************************/

18.4704, 90.0432, 27.7056, 99.2784, 41.5584, 99.2784, 50.7936, 94.6608, 60.0288, 99.2784, GAMGI_IO_STROKE,

32.3232, 94.6608, 46.1760, 94.6608, GAMGI_IO_STROKE,

18.4704, 90.0432, 27.7056, 94.6608, 36.9408, 90.0432, 50.7936, 90.0432, 60.0288, 99.2784, GAMGI_IO_STROKE,

46.1760, 76.1904, 41.5584, 71.5728, 36.9408, 62.3376, 36.9408, 57.7200, 27.7056, 57.7200, 23.0880, 53.1024, 23.0880, 43.8672, 27.7056, 48.4848, 36.9408, 48.4848, 36.9408, 25.3968, GAMGI_IO_STROKE,

41.5584, 66.9552, 41.5584, 34.6320, GAMGI_IO_STROKE,

27.7056, 53.1024, 41.5584, 53.1024, GAMGI_IO_STROKE,

46.1760, 76.1904, 46.1760, 39.2496, 41.5584, 30.0144, 36.9408, 25.3968, GAMGI_IO_STROKE,

60.0288, 80.8080, 60.0288, 11.5440, 55.4112, 6.9264, 50.7936, 6.9264, 32.3232, 16.1616, 23.0880, 16.1616, 13.8528, 11.5440, 4.6176, 2.3088, GAMGI_IO_STROKE,

64.6464, 80.8080, 64.6464, 16.1616, GAMGI_IO_STROKE,

64.6464, 53.1024, 83.1168, 53.1024, GAMGI_IO_STROKE,

46.1760, 6.9264, 41.5584, 6.9264, 32.3232, 11.5440, 18.4704, 11.5440, GAMGI_IO_STROKE,

69.2640, 85.4256, 69.2640, 57.7200, 83.1168, 57.7200, GAMGI_IO_STROKE,

83.1168, 48.4848, 69.2640, 48.4848, 69.2640, 20.7792, 64.6464, 11.5440, 46.1760, 2.3088, 36.9408, 2.3088, 27.7056, 6.9264, 18.4704, 6.9264, 4.6176, 2.3088, GAMGI_IO_STROKE,

60.0288, 80.8080, 69.2640, 85.4256, 83.1168, 99.2784, 92.3520, 94.6608, 101.5872, 94.6608, 106.2048, 99.2784, GAMGI_IO_STROKE,

78.4992, 94.6608, 87.7344, 90.0432, 96.9696, 90.0432, GAMGI_IO_STROKE,

73.8816, 90.0432, 83.1168, 85.4256, 92.3520, 85.4256, 101.5872, 90.0432, 106.2048, 99.2784, GAMGI_IO_STROKE,

83.1168, 85.4256, 83.1168, 20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 71 G strokes: 14 *
 *************************/

41.5584, 94.6608, 32.3232, 90.0432, 23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 55.4112, 2.3088, 73.8816, 2.3088, 87.7344, 6.9264, 96.9696, 16.1616, 101.5872, 25.3968, 101.5872, 39.2496, 96.9696, 48.4848, 92.3520, 53.1024, 83.1168, 57.7200, 73.8816, 57.7200, GAMGI_IO_STROKE,

23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 25.3968, GAMGI_IO_STROKE,

41.5584, 94.6608, 32.3232, 85.4256, 27.7056, 76.1904, 23.0880, 62.3376, 23.0880, 39.2496, 27.7056, 25.3968, 32.3232, 16.1616, 41.5584, 6.9264, GAMGI_IO_STROKE,

92.3520, 16.1616, 96.9696, 20.7792, 96.9696, 39.2496, 92.3520, 48.4848, GAMGI_IO_STROKE,

73.8816, 2.3088, 83.1168, 6.9264, 87.7344, 11.5440, 92.3520, 20.7792, 92.3520, 39.2496, 87.7344, 48.4848, 83.1168, 53.1024, 73.8816, 57.7200, GAMGI_IO_STROKE,

50.7936, 80.8080, 50.7936, 20.7792, GAMGI_IO_STROKE,

55.4112, 80.8080, 55.4112, 30.0144, GAMGI_IO_STROKE,

60.0288, 85.4256, 60.0288, 34.6320, 55.4112, 25.3968, 50.7936, 20.7792, GAMGI_IO_STROKE,

50.7936, 80.8080, 60.0288, 85.4256, 73.8816, 99.2784, 83.1168, 94.6608, 92.3520, 94.6608, 96.9696, 99.2784, GAMGI_IO_STROKE,

69.2640, 94.6608, 78.4992, 90.0432, 87.7344, 90.0432, GAMGI_IO_STROKE,

64.6464, 90.0432, 73.8816, 85.4256, 83.1168, 85.4256, 92.3520, 90.0432, 96.9696, 99.2784, GAMGI_IO_STROKE,

92.3520, 90.0432, 73.8816, 57.7200, 73.8816, 2.3088, GAMGI_IO_STROKE,

73.8816, 39.2496, 92.3520, 39.2496, GAMGI_IO_STROKE,

73.8816, 25.3968, 92.3520, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 72 H strokes: 22 *
 *************************/

9.2352, 90.0432, 18.4704, 99.2784, 32.3232, 99.2784, 41.5584, 94.6608, 50.7936, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 36.9408, 94.6608, GAMGI_IO_STROKE,

9.2352, 90.0432, 18.4704, 94.6608, 27.7056, 90.0432, 41.5584, 90.0432, 50.7936, 99.2784, GAMGI_IO_STROKE,

32.3232, 76.1904, 27.7056, 71.5728, 23.0880, 62.3376, 23.0880, 57.7200, 13.8528, 57.7200, 9.2352, 53.1024, 9.2352, 43.8672, 13.8528, 48.4848, 23.0880, 48.4848, 23.0880, 20.7792, GAMGI_IO_STROKE,

27.7056, 66.9552, 27.7056, 30.0144, GAMGI_IO_STROKE,

13.8528, 53.1024, 27.7056, 53.1024, GAMGI_IO_STROKE,

32.3232, 76.1904, 32.3232, 34.6320, 27.7056, 25.3968, 23.0880, 20.7792, GAMGI_IO_STROKE,

18.4704, 2.3088, 32.3232, 11.5440, 46.1760, 16.1616, 60.0288, 16.1616, 69.2640, 11.5440, GAMGI_IO_STROKE,

27.7056, 6.9264, 41.5584, 11.5440, 55.4112, 11.5440, 64.6464, 6.9264, GAMGI_IO_STROKE,

18.4704, 2.3088, 36.9408, 6.9264, 50.7936, 6.9264, 60.0288, 2.3088, 69.2640, 11.5440, GAMGI_IO_STROKE,

55.4112, 85.4256, 50.7936, 80.8080, 46.1760, 71.5728, 46.1760, 30.0144, GAMGI_IO_STROKE,

50.7936, 76.1904, 50.7936, 39.2496, GAMGI_IO_STROKE,

55.4112, 85.4256, 55.4112, 43.8672, 50.7936, 34.6320, 46.1760, 30.0144, GAMGI_IO_STROKE,

55.4112, 85.4256, 64.6464, 94.6608, 73.8816, 99.2784, 83.1168, 99.2784, 92.3520, 94.6608, GAMGI_IO_STROKE,

78.4992, 94.6608, 83.1168, 94.6608, 87.7344, 90.0432, GAMGI_IO_STROKE,

64.6464, 94.6608, 73.8816, 94.6608, 83.1168, 85.4256, 92.3520, 94.6608, GAMGI_IO_STROKE,

69.2640, 57.7200, 78.4992, 62.3376, 87.7344, 71.5728, 92.3520, 66.9552, 96.9696, 53.1024, 96.9696, 34.6320, 92.3520, 16.1616, 83.1168, 2.3088, GAMGI_IO_STROKE,

83.1168, 66.9552, 87.7344, 62.3376, 92.3520, 53.1024, 92.3520, 30.0144, 87.7344, 16.1616, GAMGI_IO_STROKE,

78.4992, 62.3376, 83.1168, 62.3376, 87.7344, 53.1024, 87.7344, 30.0144, 83.1168, 2.3088, GAMGI_IO_STROKE,

69.2640, 57.7200, 69.2640, 11.5440, GAMGI_IO_STROKE,

69.2640, 43.8672, 87.7344, 43.8672, GAMGI_IO_STROKE,

69.2640, 30.0144, 87.7344, 30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 73 I strokes: 11 *
 *************************/

13.8528, 90.0432, 23.0880, 99.2784, 36.9408, 99.2784, 50.7936, 94.6608, 60.0288, 99.2784, GAMGI_IO_STROKE,

27.7056, 94.6608, 46.1760, 94.6608, GAMGI_IO_STROKE,

13.8528, 90.0432, 23.0880, 94.6608, 36.9408, 90.0432, 50.7936, 90.0432, 60.0288, 99.2784, GAMGI_IO_STROKE,

46.1760, 76.1904, 41.5584, 71.5728, 36.9408, 62.3376, 36.9408, 57.7200, 27.7056, 57.7200, 23.0880, 53.1024, 23.0880, 43.8672, 27.7056, 48.4848, 36.9408, 48.4848, 36.9408, 25.3968, GAMGI_IO_STROKE,

41.5584, 66.9552, 41.5584, 34.6320, GAMGI_IO_STROKE,

27.7056, 53.1024, 41.5584, 53.1024, GAMGI_IO_STROKE,

46.1760, 76.1904, 46.1760, 39.2496, 41.5584, 30.0144, 36.9408, 25.3968, GAMGI_IO_STROKE,

73.8816, 90.0432, 64.6464, 80.8080, 60.0288, 66.9552, 60.0288, 16.1616, 55.4112, 6.9264, 46.1760, 6.9264, 27.7056, 16.1616, 18.4704, 16.1616, 9.2352, 11.5440, 0.0000, 2.3088, GAMGI_IO_STROKE,

64.6464, 76.1904, 64.6464, 20.7792, GAMGI_IO_STROKE,

41.5584, 6.9264, 36.9408, 6.9264, 27.7056, 11.5440, 13.8528, 11.5440, GAMGI_IO_STROKE,

73.8816, 90.0432, 69.2640, 80.8080, 69.2640, 25.3968, 64.6464, 16.1616, 55.4112, 6.9264, 46.1760, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, 9.2352, 6.9264, 0.0000, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 74 J strokes: 11 *
 *************************/

18.4704, 90.0432, 27.7056, 99.2784, 41.5584, 99.2784, 55.4112, 94.6608, 64.6464, 99.2784, GAMGI_IO_STROKE,

32.3232, 94.6608, 50.7936, 94.6608, GAMGI_IO_STROKE,

18.4704, 90.0432, 27.7056, 94.6608, 41.5584, 90.0432, 55.4112, 90.0432, 64.6464, 99.2784, GAMGI_IO_STROKE,

50.7936, 76.1904, 46.1760, 71.5728, 41.5584, 62.3376, 41.5584, 57.7200, 32.3232, 57.7200, 27.7056, 53.1024, 27.7056, 43.8672, 32.3232, 48.4848, 41.5584, 48.4848, 41.5584, 25.3968, GAMGI_IO_STROKE,

46.1760, 66.9552, 46.1760, 34.6320, GAMGI_IO_STROKE,

32.3232, 53.1024, 46.1760, 53.1024, GAMGI_IO_STROKE,

50.7936, 76.1904, 50.7936, 39.2496, 46.1760, 30.0144, 41.5584, 25.3968, GAMGI_IO_STROKE,

78.4992, 90.0432, 69.2640, 80.8080, 64.6464, 66.9552, 64.6464, 16.1616, 60.0288, 6.9264, GAMGI_IO_STROKE,

69.2640, 76.1904, 69.2640, 20.7792, GAMGI_IO_STROKE,

78.4992, 90.0432, 73.8816, 80.8080, 73.8816, 25.3968, 69.2640, 16.1616, 60.0288, 6.9264, 46.1760, 2.3088, 32.3232, 2.3088, 18.4704, 6.9264, 9.2352, 16.1616, 9.2352, 25.3968, 13.8528, 30.0144, 18.4704, 30.0144, 23.0880, 25.3968, 18.4704, 20.7792, 13.8528, 20.7792, GAMGI_IO_STROKE,

9.2352, 25.3968, 23.0880, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 75 K strokes: 23 *
 *************************/

9.2352, 90.0432, 18.4704, 99.2784, 32.3232, 99.2784, 41.5584, 94.6608, 50.7936, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 36.9408, 94.6608, GAMGI_IO_STROKE,

9.2352, 90.0432, 18.4704, 94.6608, 27.7056, 90.0432, 41.5584, 90.0432, 50.7936, 99.2784, GAMGI_IO_STROKE,

32.3232, 76.1904, 27.7056, 71.5728, 23.0880, 62.3376, 23.0880, 57.7200, 13.8528, 57.7200, 9.2352, 53.1024, 9.2352, 43.8672, 13.8528, 48.4848, 23.0880, 48.4848, 23.0880, 20.7792, GAMGI_IO_STROKE,

27.7056, 66.9552, 27.7056, 30.0144, GAMGI_IO_STROKE,

13.8528, 53.1024, 27.7056, 53.1024, GAMGI_IO_STROKE,

32.3232, 76.1904, 32.3232, 34.6320, 27.7056, 25.3968, 23.0880, 20.7792, GAMGI_IO_STROKE,

18.4704, 2.3088, 32.3232, 11.5440, 46.1760, 16.1616, 60.0288, 16.1616, 69.2640, 11.5440, GAMGI_IO_STROKE,

27.7056, 6.9264, 36.9408, 11.5440, 55.4112, 11.5440, 64.6464, 6.9264, GAMGI_IO_STROKE,

18.4704, 2.3088, 36.9408, 6.9264, 50.7936, 6.9264, 60.0288, 2.3088, 69.2640, 11.5440, GAMGI_IO_STROKE,

55.4112, 85.4256, 50.7936, 80.8080, 46.1760, 71.5728, 46.1760, 30.0144, GAMGI_IO_STROKE,

50.7936, 76.1904, 50.7936, 39.2496, GAMGI_IO_STROKE,

55.4112, 85.4256, 55.4112, 43.8672, 50.7936, 34.6320, 46.1760, 30.0144, GAMGI_IO_STROKE,

55.4112, 85.4256, 64.6464, 94.6608, 73.8816, 99.2784, 83.1168, 99.2784, 92.3520, 94.6608, GAMGI_IO_STROKE,

78.4992, 94.6608, 83.1168, 94.6608, 87.7344, 90.0432, GAMGI_IO_STROKE,

64.6464, 94.6608, 73.8816, 94.6608, 83.1168, 85.4256, 92.3520, 94.6608, GAMGI_IO_STROKE,

69.2640, 57.7200, 83.1168, 71.5728, 87.7344, 66.9552, 96.9696, 62.3376, GAMGI_IO_STROKE,

78.4992, 66.9552, 87.7344, 62.3376, 96.9696, 62.3376, GAMGI_IO_STROKE,

96.9696, 62.3376, 87.7344, 48.4848, 78.4992, 39.2496, 69.2640, 30.0144, GAMGI_IO_STROKE,

78.4992, 39.2496, 87.7344, 34.6320, 92.3520, 16.1616, 96.9696, 6.9264, 101.5872, 6.9264, GAMGI_IO_STROKE,

87.7344, 25.3968, 92.3520, 6.9264, GAMGI_IO_STROKE,

78.4992, 39.2496, 83.1168, 34.6320, 87.7344, 6.9264, 92.3520, 2.3088, 96.9696, 2.3088, 101.5872, 6.9264, GAMGI_IO_STROKE,

69.2640, 57.7200, 69.2640, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 76 L strokes: 17 *
 *************************/

9.2352, 90.0432, 18.4704, 99.2784, 32.3232, 99.2784, 41.5584, 94.6608, 50.7936, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 36.9408, 94.6608, GAMGI_IO_STROKE,

9.2352, 90.0432, 18.4704, 94.6608, 27.7056, 90.0432, 41.5584, 90.0432, 50.7936, 99.2784, GAMGI_IO_STROKE,

32.3232, 76.1904, 27.7056, 71.5728, 23.0880, 62.3376, 23.0880, 57.7200, 13.8528, 57.7200, 9.2352, 53.1024, 9.2352, 43.8672, 13.8528, 48.4848, 23.0880, 48.4848, 23.0880, 20.7792, GAMGI_IO_STROKE,

27.7056, 66.9552, 27.7056, 30.0144, GAMGI_IO_STROKE,

13.8528, 53.1024, 27.7056, 53.1024, GAMGI_IO_STROKE,

32.3232, 76.1904, 32.3232, 34.6320, 27.7056, 25.3968, 23.0880, 20.7792, GAMGI_IO_STROKE,

18.4704, 2.3088, 32.3232, 11.5440, 50.7936, 16.1616, 73.8816, 16.1616, 92.3520, 11.5440, GAMGI_IO_STROKE,

27.7056, 6.9264, 41.5584, 11.5440, 73.8816, 11.5440, 87.7344, 6.9264, GAMGI_IO_STROKE,

18.4704, 2.3088, 36.9408, 6.9264, 69.2640, 6.9264, 83.1168, 2.3088, 92.3520, 11.5440, GAMGI_IO_STROKE,

55.4112, 85.4256, 50.7936, 80.8080, 46.1760, 71.5728, 46.1760, 30.0144, GAMGI_IO_STROKE,

50.7936, 76.1904, 50.7936, 39.2496, GAMGI_IO_STROKE,

55.4112, 85.4256, 55.4112, 43.8672, 50.7936, 34.6320, 46.1760, 30.0144, GAMGI_IO_STROKE,

55.4112, 85.4256, 64.6464, 94.6608, 73.8816, 99.2784, 83.1168, 99.2784, 92.3520, 94.6608, GAMGI_IO_STROKE,

78.4992, 94.6608, 83.1168, 94.6608, 87.7344, 90.0432, GAMGI_IO_STROKE,

64.6464, 94.6608, 73.8816, 94.6608, 83.1168, 85.4256, 92.3520, 94.6608, GAMGI_IO_STROKE,

73.8816, 94.6608, 73.8816, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 77 M strokes: 19 *
 *************************/

36.9408, 80.8080, 32.3232, 76.1904, 27.7056, 66.9552, 27.7056, 57.7200, 18.4704, 57.7200, 13.8528, 53.1024, 13.8528, 43.8672, 18.4704, 48.4848, 27.7056, 48.4848, 27.7056, 30.0144, GAMGI_IO_STROKE,

32.3232, 71.5728, 32.3232, 39.2496, GAMGI_IO_STROKE,

18.4704, 53.1024, 32.3232, 53.1024, GAMGI_IO_STROKE,

36.9408, 80.8080, 36.9408, 43.8672, 32.3232, 34.6320, 27.7056, 30.0144, GAMGI_IO_STROKE,

4.6176, 2.3088, 13.8528, 11.5440, 23.0880, 16.1616, 32.3232, 16.1616, 41.5584, 11.5440, 46.1760, 11.5440, 50.7936, 16.1616, GAMGI_IO_STROKE,

18.4704, 11.5440, 32.3232, 11.5440, 41.5584, 6.9264, GAMGI_IO_STROKE,

4.6176, 2.3088, 13.8528, 6.9264, 27.7056, 6.9264, 36.9408, 2.3088, 41.5584, 2.3088, 46.1760, 6.9264, 50.7936, 16.1616, GAMGI_IO_STROKE,

36.9408, 80.8080, 55.4112, 99.2784, 73.8816, 80.8080, 73.8816, 20.7792, 78.4992, 11.5440, 83.1168, 11.5440, GAMGI_IO_STROKE,

55.4112, 94.6608, 69.2640, 80.8080, 69.2640, 16.1616, 64.6464, 11.5440, 69.2640, 6.9264, 73.8816, 11.5440, 69.2640, 16.1616, GAMGI_IO_STROKE,

55.4112, 53.1024, 69.2640, 53.1024, GAMGI_IO_STROKE,

46.1760, 90.0432, 50.7936, 90.0432, 64.6464, 76.1904, 64.6464, 57.7200, 50.7936, 57.7200, GAMGI_IO_STROKE,

50.7936, 48.4848, 64.6464, 48.4848, 64.6464, 16.1616, 60.0288, 11.5440, 69.2640, 2.3088, 83.1168, 11.5440, 87.7344, 16.1616, GAMGI_IO_STROKE,

73.8816, 80.8080, 92.3520, 99.2784, 110.8224, 80.8080, 110.8224, 20.7792, 115.4400, 11.5440, 120.0576, 11.5440, GAMGI_IO_STROKE,

92.3520, 94.6608, 106.2048, 80.8080, 106.2048, 16.1616, 115.4400, 6.9264, GAMGI_IO_STROKE,

92.3520, 53.1024, 106.2048, 53.1024, GAMGI_IO_STROKE,

83.1168, 90.0432, 87.7344, 90.0432, 101.5872, 76.1904, 101.5872, 57.7200, 87.7344, 57.7200, GAMGI_IO_STROKE,

87.7344, 48.4848, 101.5872, 48.4848, 101.5872, 11.5440, 110.8224, 2.3088, 120.0576, 11.5440, GAMGI_IO_STROKE,

50.7936, 90.0432, 50.7936, 16.1616, GAMGI_IO_STROKE,

87.7344, 90.0432, 87.7344, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 78 N strokes: 15 *
 *************************/

9.2352, 85.4256, 18.4704, 94.6608, 27.7056, 99.2784, 36.9408, 99.2784, 46.1760, 94.6608, 55.4112, 80.8080, 78.4992, 30.0144, 87.7344, 16.1616, 92.3520, 11.5440, GAMGI_IO_STROKE,

36.9408, 94.6608, 46.1760, 85.4256, 50.7936, 76.1904, 78.4992, 20.7792, 92.3520, 6.9264, GAMGI_IO_STROKE,

18.4704, 94.6608, 27.7056, 94.6608, 36.9408, 90.0432, 46.1760, 76.1904, 69.2640, 25.3968, 78.4992, 11.5440, 83.1168, 6.9264, 92.3520, 2.3088, GAMGI_IO_STROKE,

78.4992, 90.0432, 87.7344, 85.4256, 96.9696, 85.4256, 106.2048, 90.0432, 110.8224, 99.2784, GAMGI_IO_STROKE,

83.1168, 94.6608, 92.3520, 90.0432, 101.5872, 90.0432, GAMGI_IO_STROKE,

78.4992, 90.0432, 87.7344, 99.2784, 96.9696, 94.6608, 106.2048, 94.6608, 110.8224, 99.2784, GAMGI_IO_STROKE,

27.7056, 57.7200, 18.4704, 57.7200, 13.8528, 53.1024, 13.8528, 43.8672, 18.4704, 48.4848, 27.7056, 48.4848, GAMGI_IO_STROKE,

18.4704, 53.1024, 27.7056, 53.1024, GAMGI_IO_STROKE,

9.2352, 2.3088, 18.4704, 11.5440, 27.7056, 16.1616, 41.5584, 16.1616, 50.7936, 11.5440, GAMGI_IO_STROKE,

23.0880, 11.5440, 36.9408, 11.5440, 46.1760, 6.9264, GAMGI_IO_STROKE,

9.2352, 2.3088, 23.0880, 6.9264, 36.9408, 6.9264, 41.5584, 2.3088, 50.7936, 11.5440, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 16.1616, GAMGI_IO_STROKE,

92.3520, 85.4256, 92.3520, 2.3088, GAMGI_IO_STROKE,

60.0288, 71.5728, 64.6464, 66.9552, 73.8816, 62.3376, 83.1168, 62.3376, 92.3520, 66.9552, GAMGI_IO_STROKE,

27.7056, 34.6320, 36.9408, 39.2496, 55.4112, 39.2496, 64.6464, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 79 O strokes: 11 *
 *************************/

41.5584, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 62.3376, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 55.4112, 2.3088, 64.6464, 2.3088, 78.4992, 6.9264, 87.7344, 11.5440, 96.9696, 20.7792, 101.5872, 30.0144, 106.2048, 43.8672, 106.2048, 62.3376, 101.5872, 76.1904, 96.9696, 85.4256, 87.7344, 94.6608, 78.4992, 99.2784, 73.8816, 94.6608, 60.0288, 85.4256, 46.1760, 80.8080, GAMGI_IO_STROKE,

23.0880, 80.8080, 18.4704, 66.9552, 18.4704, 39.2496, 23.0880, 25.3968, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 90.0432, 27.7056, 80.8080, 23.0880, 66.9552, 23.0880, 39.2496, 27.7056, 25.3968, 32.3232, 16.1616, 41.5584, 6.9264, GAMGI_IO_STROKE,

96.9696, 25.3968, 101.5872, 39.2496, 101.5872, 66.9552, 92.3520, 85.4256, 87.7344, 90.0432, GAMGI_IO_STROKE,

78.4992, 6.9264, 87.7344, 16.1616, 92.3520, 25.3968, 96.9696, 39.2496, 96.9696, 66.9552, 92.3520, 76.1904, 83.1168, 90.0432, 73.8816, 94.6608, GAMGI_IO_STROKE,

46.1760, 80.8080, 46.1760, 20.7792, GAMGI_IO_STROKE,

50.7936, 80.8080, 50.7936, 30.0144, GAMGI_IO_STROKE,

55.4112, 80.8080, 55.4112, 34.6320, 50.7936, 25.3968, 46.1760, 20.7792, GAMGI_IO_STROKE,

73.8816, 94.6608, 73.8816, 6.9264, GAMGI_IO_STROKE,

73.8816, 66.9552, 83.1168, 62.3376, 87.7344, 62.3376, 96.9696, 66.9552, GAMGI_IO_STROKE,

73.8816, 39.2496, 83.1168, 43.8672, 87.7344, 43.8672, 96.9696, 39.2496, GAMGI_IO_CHAR,

/*************************
 * char: 80 P strokes: 13 *
 *************************/

13.8528, 99.2784, 18.4704, 94.6608, 23.0880, 85.4256, 23.0880, 57.7200, 13.8528, 57.7200, 9.2352, 53.1024, 9.2352, 43.8672, 13.8528, 48.4848, 23.0880, 48.4848, 23.0880, 11.5440, 9.2352, 2.3088, 23.0880, 6.9264, 23.0880, -30.0144, 32.3232, -20.7792, GAMGI_IO_STROKE,

23.0880, 90.0432, 27.7056, 80.8080, 27.7056, -20.7792, GAMGI_IO_STROKE,

13.8528, 53.1024, 27.7056, 53.1024, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, 27.7056, 90.0432, 32.3232, 80.8080, 32.3232, -20.7792, GAMGI_IO_STROKE,

32.3232, 76.1904, 46.1760, 85.4256, 64.6464, 99.2784, 83.1168, 80.8080, 83.1168, 16.1616, GAMGI_IO_STROKE,

64.6464, 94.6608, 78.4992, 80.8080, 78.4992, 16.1616, GAMGI_IO_STROKE,

55.4112, 90.0432, 60.0288, 90.0432, 73.8816, 76.1904, 73.8816, 11.5440, GAMGI_IO_STROKE,

46.1760, 16.1616, 60.0288, 16.1616, 73.8816, 11.5440, GAMGI_IO_STROKE,

50.7936, 11.5440, 60.0288, 11.5440, 69.2640, 6.9264, GAMGI_IO_STROKE,

46.1760, 6.9264, 55.4112, 6.9264, 64.6464, 2.3088, 73.8816, 11.5440, 83.1168, 16.1616, GAMGI_IO_STROKE,

46.1760, 85.4256, 46.1760, -16.1616, GAMGI_IO_STROKE,

46.1760, 66.9552, 55.4112, 62.3376, 64.6464, 62.3376, 73.8816, 66.9552, GAMGI_IO_STROKE,

46.1760, 39.2496, 55.4112, 43.8672, 64.6464, 43.8672, 73.8816, 39.2496, GAMGI_IO_CHAR,

/*************************
 * char: 81 Q strokes: 14 *
 *************************/

41.5584, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 62.3376, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 50.7936, 2.3088, 69.2640, 2.3088, 78.4992, 6.9264, 87.7344, 11.5440, 96.9696, 20.7792, 101.5872, 30.0144, 106.2048, 43.8672, 106.2048, 62.3376, 101.5872, 76.1904, 96.9696, 85.4256, 87.7344, 94.6608, 78.4992, 99.2784, 73.8816, 94.6608, 60.0288, 85.4256, 46.1760, 80.8080, GAMGI_IO_STROKE,

23.0880, 80.8080, 18.4704, 66.9552, 18.4704, 39.2496, 23.0880, 25.3968, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 90.0432, 27.7056, 80.8080, 23.0880, 66.9552, 23.0880, 39.2496, 27.7056, 25.3968, 32.3232, 16.1616, 41.5584, 6.9264, GAMGI_IO_STROKE,

96.9696, 25.3968, 101.5872, 39.2496, 101.5872, 66.9552, 92.3520, 85.4256, 87.7344, 90.0432, GAMGI_IO_STROKE,

78.4992, 6.9264, 87.7344, 16.1616, 92.3520, 25.3968, 96.9696, 39.2496, 96.9696, 66.9552, 92.3520, 76.1904, 83.1168, 90.0432, 73.8816, 94.6608, GAMGI_IO_STROKE,

46.1760, 80.8080, 46.1760, 20.7792, GAMGI_IO_STROKE,

50.7936, 80.8080, 50.7936, 30.0144, GAMGI_IO_STROKE,

55.4112, 80.8080, 55.4112, 34.6320, 50.7936, 25.3968, 46.1760, 20.7792, GAMGI_IO_STROKE,

73.8816, 94.6608, 73.8816, 6.9264, GAMGI_IO_STROKE,

73.8816, 66.9552, 83.1168, 62.3376, 87.7344, 62.3376, 96.9696, 66.9552, GAMGI_IO_STROKE,

73.8816, 39.2496, 83.1168, 43.8672, 87.7344, 43.8672, 96.9696, 39.2496, GAMGI_IO_STROKE,

50.7936, 2.3088, 55.4112, 6.9264, 60.0288, 6.9264, 69.2640, 2.3088, 87.7344, -20.7792, 96.9696, -25.3968, 101.5872, -25.3968, GAMGI_IO_STROKE,

69.2640, -2.3088, 78.4992, -16.1616, 87.7344, -25.3968, 92.3520, -25.3968, GAMGI_IO_STROKE,

60.0288, 6.9264, 64.6464, 2.3088, 78.4992, -25.3968, 87.7344, -30.0144, 96.9696, -30.0144, 101.5872, -25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 82 R strokes: 19 *
 *************************/

9.2352, 90.0432, 18.4704, 99.2784, 32.3232, 99.2784, 41.5584, 94.6608, 50.7936, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 36.9408, 94.6608, GAMGI_IO_STROKE,

9.2352, 90.0432, 18.4704, 94.6608, 27.7056, 90.0432, 41.5584, 90.0432, 50.7936, 99.2784, GAMGI_IO_STROKE,

32.3232, 76.1904, 27.7056, 71.5728, 23.0880, 62.3376, 23.0880, 57.7200, 13.8528, 57.7200, 9.2352, 53.1024, 9.2352, 43.8672, 13.8528, 48.4848, 23.0880, 48.4848, 23.0880, 20.7792, GAMGI_IO_STROKE,

27.7056, 66.9552, 27.7056, 30.0144, GAMGI_IO_STROKE,

13.8528, 53.1024, 27.7056, 53.1024, GAMGI_IO_STROKE,

32.3232, 76.1904, 32.3232, 34.6320, 27.7056, 25.3968, 23.0880, 20.7792, GAMGI_IO_STROKE,

18.4704, 2.3088, 32.3232, 11.5440, 46.1760, 16.1616, 55.4112, 16.1616, 69.2640, 11.5440, GAMGI_IO_STROKE,

27.7056, 6.9264, 36.9408, 11.5440, 55.4112, 11.5440, 64.6464, 6.9264, GAMGI_IO_STROKE,

18.4704, 2.3088, 36.9408, 6.9264, 50.7936, 6.9264, 60.0288, 2.3088, 69.2640, 11.5440, GAMGI_IO_STROKE,

55.4112, 85.4256, 50.7936, 80.8080, 46.1760, 71.5728, 46.1760, 30.0144, GAMGI_IO_STROKE,

50.7936, 76.1904, 50.7936, 39.2496, GAMGI_IO_STROKE,

55.4112, 85.4256, 55.4112, 43.8672, 50.7936, 34.6320, 46.1760, 30.0144, GAMGI_IO_STROKE,

55.4112, 85.4256, 69.2640, 94.6608, 78.4992, 99.2784, 87.7344, 94.6608, 92.3520, 85.4256, 92.3520, 71.5728, 87.7344, 62.3376, 83.1168, 57.7200, 64.6464, 48.4848, 55.4112, 43.8672, GAMGI_IO_STROKE,

78.4992, 94.6608, 83.1168, 94.6608, 87.7344, 85.4256, 87.7344, 66.9552, 83.1168, 62.3376, GAMGI_IO_STROKE,

69.2640, 94.6608, 78.4992, 90.0432, 83.1168, 80.8080, 83.1168, 66.9552, 78.4992, 57.7200, 64.6464, 48.4848, GAMGI_IO_STROKE,

64.6464, 48.4848, 73.8816, 43.8672, 78.4992, 39.2496, 92.3520, 16.1616, 96.9696, 11.5440, 101.5872, 11.5440, GAMGI_IO_STROKE,

78.4992, 34.6320, 87.7344, 16.1616, 96.9696, 6.9264, GAMGI_IO_STROKE,

64.6464, 48.4848, 73.8816, 39.2496, 83.1168, 11.5440, 92.3520, 2.3088, 101.5872, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 83 S strokes: 14 *
 *************************/

64.6464, 85.4256, 60.0288, 90.0432, 50.7936, 94.6608, 36.9408, 99.2784, GAMGI_IO_STROKE,

69.2640, 90.0432, 60.0288, 94.6608, GAMGI_IO_STROKE,

73.8816, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, 23.0880, 94.6608, 18.4704, 90.0432, 13.8528, 80.8080, 18.4704, 71.5728, 23.0880, 66.9552, 36.9408, 62.3376, 73.8816, 62.3376, 83.1168, 57.7200, 87.7344, 53.1024, 87.7344, 43.8672, 83.1168, 30.0144, GAMGI_IO_STROKE,

18.4704, 76.1904, 23.0880, 71.5728, 36.9408, 66.9552, 78.4992, 66.9552, 87.7344, 62.3376, 92.3520, 57.7200, 92.3520, 48.4848, 87.7344, 39.2496, GAMGI_IO_STROKE,

18.4704, 90.0432, 18.4704, 80.8080, 23.0880, 76.1904, 36.9408, 71.5728, 83.1168, 71.5728, 92.3520, 66.9552, 96.9696, 57.7200, 96.9696, 48.4848, 83.1168, 30.0144, 64.6464, 2.3088, GAMGI_IO_STROKE,

9.2352, 57.7200, 13.8528, 53.1024, 23.0880, 48.4848, 64.6464, 48.4848, 69.2640, 43.8672, 69.2640, 39.2496, 64.6464, 30.0144, GAMGI_IO_STROKE,

13.8528, 48.4848, 23.0880, 43.8672, 60.0288, 43.8672, 64.6464, 39.2496, GAMGI_IO_STROKE,

9.2352, 57.7200, 9.2352, 53.1024, 13.8528, 43.8672, 23.0880, 39.2496, 55.4112, 39.2496, 64.6464, 34.6320, 64.6464, 30.0144, GAMGI_IO_STROKE,

9.2352, 2.3088, 23.0880, 11.5440, 41.5584, 16.1616, 55.4112, 16.1616, 69.2640, 11.5440, GAMGI_IO_STROKE,

18.4704, 6.9264, 32.3232, 11.5440, 50.7936, 11.5440, 64.6464, 6.9264, GAMGI_IO_STROKE,

9.2352, 2.3088, 27.7056, 6.9264, 50.7936, 6.9264, 64.6464, 2.3088, GAMGI_IO_STROKE,

73.8816, 94.6608, 64.6464, 85.4256, 55.4112, 71.5728, GAMGI_IO_STROKE,

50.7936, 62.3376, 41.5584, 48.4848, GAMGI_IO_STROKE,

36.9408, 39.2496, 27.7056, 30.0144, 18.4704, 25.3968, 13.8528, 25.3968, 13.8528, 30.0144, 18.4704, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 84 T strokes: 10 *
 *************************/

23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 39.2496, 18.4704, 25.3968, 27.7056, 11.5440, 36.9408, 6.9264, 50.7936, 2.3088, 64.6464, 2.3088, 78.4992, 6.9264, 87.7344, 11.5440, 96.9696, 20.7792, 101.5872, 30.0144, GAMGI_IO_STROKE,

18.4704, 39.2496, 23.0880, 25.3968, 32.3232, 16.1616, 41.5584, 11.5440, 55.4112, 6.9264, 69.2640, 6.9264, 83.1168, 11.5440, GAMGI_IO_STROKE,

23.0880, 80.8080, 18.4704, 66.9552, 18.4704, 48.4848, 23.0880, 34.6320, 32.3232, 20.7792, 41.5584, 16.1616, 55.4112, 11.5440, 69.2640, 11.5440, 83.1168, 16.1616, 92.3520, 20.7792, 101.5872, 30.0144, GAMGI_IO_STROKE,

13.8528, 85.4256, 18.4704, 94.6608, 27.7056, 99.2784, 46.1760, 99.2784, 73.8816, 94.6608, 92.3520, 94.6608, 101.5872, 99.2784, GAMGI_IO_STROKE,

50.7936, 94.6608, 69.2640, 90.0432, 87.7344, 90.0432, GAMGI_IO_STROKE,

13.8528, 85.4256, 18.4704, 90.0432, 27.7056, 94.6608, 41.5584, 94.6608, 69.2640, 85.4256, 83.1168, 85.4256, 92.3520, 90.0432, 101.5872, 99.2784, GAMGI_IO_STROKE,

64.6464, 85.4256, 60.0288, 80.8080, 50.7936, 76.1904, 50.7936, 25.3968, GAMGI_IO_STROKE,

55.4112, 76.1904, 55.4112, 34.6320, GAMGI_IO_STROKE,

60.0288, 80.8080, 60.0288, 39.2496, 55.4112, 30.0144, 50.7936, 25.3968, GAMGI_IO_STROKE,

83.1168, 85.4256, 83.1168, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 85 U strokes: 15 *
 *************************/

9.2352, 90.0432, 18.4704, 99.2784, 27.7056, 99.2784, 41.5584, 94.6608, 50.7936, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 36.9408, 94.6608, GAMGI_IO_STROKE,

9.2352, 90.0432, 18.4704, 94.6608, 32.3232, 90.0432, 41.5584, 90.0432, 50.7936, 99.2784, GAMGI_IO_STROKE,

23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 60.0288, 2.3088, 73.8816, 6.9264, 83.1168, 11.5440, 92.3520, 2.3088, 101.5872, 11.5440, GAMGI_IO_STROKE,

18.4704, 39.2496, 23.0880, 25.3968, 36.9408, 11.5440, 50.7936, 6.9264, 64.6464, 6.9264, GAMGI_IO_STROKE,

23.0880, 80.8080, 18.4704, 62.3376, 18.4704, 48.4848, 23.0880, 34.6320, 27.7056, 25.3968, 36.9408, 16.1616, 50.7936, 11.5440, 69.2640, 11.5440, 83.1168, 16.1616, GAMGI_IO_STROKE,

69.2640, 85.4256, 50.7936, 80.8080, 46.1760, 71.5728, 46.1760, 25.3968, GAMGI_IO_STROKE,

50.7936, 76.1904, 50.7936, 34.6320, GAMGI_IO_STROKE,

55.4112, 80.8080, 55.4112, 39.2496, 50.7936, 30.0144, 46.1760, 25.3968, GAMGI_IO_STROKE,

69.2640, 85.4256, 78.4992, 90.0432, 87.7344, 99.2784, 92.3520, 94.6608, 101.5872, 90.0432, 92.3520, 85.4256, 92.3520, 20.7792, 96.9696, 11.5440, 101.5872, 11.5440, GAMGI_IO_STROKE,

87.7344, 85.4256, 92.3520, 90.0432, 87.7344, 94.6608, 83.1168, 90.0432, 87.7344, 85.4256, 87.7344, 16.1616, 96.9696, 6.9264, GAMGI_IO_STROKE,

78.4992, 90.0432, 83.1168, 85.4256, 83.1168, 16.1616, GAMGI_IO_STROKE,

69.2640, 85.4256, 69.2640, 11.5440, GAMGI_IO_STROKE,

69.2640, 62.3376, 83.1168, 62.3376, GAMGI_IO_STROKE,

69.2640, 43.8672, 83.1168, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 86 V strokes: 12 *
 *************************/

13.8528, 99.2784, 18.4704, 94.6608, 23.0880, 85.4256, 23.0880, 57.7200, 13.8528, 57.7200, 9.2352, 53.1024, 9.2352, 43.8672, 13.8528, 48.4848, 23.0880, 48.4848, 23.0880, 16.1616, 13.8528, 11.5440, GAMGI_IO_STROKE,

23.0880, 90.0432, 27.7056, 80.8080, 27.7056, 16.1616, GAMGI_IO_STROKE,

13.8528, 53.1024, 27.7056, 53.1024, GAMGI_IO_STROKE,

32.3232, 11.5440, 46.1760, 11.5440, 55.4112, 6.9264, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, 27.7056, 90.0432, 32.3232, 80.8080, 32.3232, 16.1616, 50.7936, 16.1616, 64.6464, 11.5440, GAMGI_IO_STROKE,

13.8528, 11.5440, 27.7056, 11.5440, 41.5584, 6.9264, 50.7936, 2.3088, 64.6464, 11.5440, 78.4992, 16.1616, 87.7344, 16.1616, GAMGI_IO_STROKE,

50.7936, 80.8080, 64.6464, 85.4256, 73.8816, 90.0432, 83.1168, 99.2784, 87.7344, 94.6608, 96.9696, 90.0432, 87.7344, 85.4256, 87.7344, 16.1616, GAMGI_IO_STROKE,

83.1168, 85.4256, 87.7344, 90.0432, 83.1168, 94.6608, 78.4992, 90.0432, 83.1168, 85.4256, 83.1168, 20.7792, GAMGI_IO_STROKE,

73.8816, 90.0432, 78.4992, 85.4256, 78.4992, 16.1616, GAMGI_IO_STROKE,

50.7936, 80.8080, 50.7936, 16.1616, GAMGI_IO_STROKE,

50.7936, 66.9552, 60.0288, 62.3376, 69.2640, 62.3376, 78.4992, 66.9552, GAMGI_IO_STROKE,

50.7936, 39.2496, 60.0288, 43.8672, 69.2640, 43.8672, 78.4992, 39.2496, GAMGI_IO_CHAR,

/*************************
 * char: 87 W strokes: 19 *
 *************************/

13.8528, 99.2784, 18.4704, 94.6608, 23.0880, 85.4256, 23.0880, 57.7200, 13.8528, 57.7200, 9.2352, 53.1024, 9.2352, 43.8672, 13.8528, 48.4848, 23.0880, 48.4848, 23.0880, 16.1616, 13.8528, 11.5440, GAMGI_IO_STROKE,

23.0880, 90.0432, 27.7056, 80.8080, 27.7056, 16.1616, GAMGI_IO_STROKE,

13.8528, 53.1024, 27.7056, 53.1024, GAMGI_IO_STROKE,

32.3232, 11.5440, 41.5584, 11.5440, 50.7936, 6.9264, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, 27.7056, 90.0432, 32.3232, 80.8080, 32.3232, 16.1616, 46.1760, 16.1616, 55.4112, 11.5440, GAMGI_IO_STROKE,

13.8528, 11.5440, 27.7056, 11.5440, 41.5584, 6.9264, 46.1760, 2.3088, 55.4112, 11.5440, 69.2640, 16.1616, 78.4992, 11.5440, 83.1168, 2.3088, 92.3520, 11.5440, 106.2048, 16.1616, GAMGI_IO_STROKE,

46.1760, 90.0432, 60.0288, 99.2784, 69.2640, 90.0432, 69.2640, 16.1616, 83.1168, 16.1616, 92.3520, 11.5440, GAMGI_IO_STROKE,

60.0288, 94.6608, 64.6464, 90.0432, 64.6464, 16.1616, GAMGI_IO_STROKE,

46.1760, 90.0432, 55.4112, 90.0432, 60.0288, 85.4256, 60.0288, 16.1616, 55.4112, 11.5440, GAMGI_IO_STROKE,

83.1168, 11.5440, 87.7344, 6.9264, GAMGI_IO_STROKE,

83.1168, 90.0432, 96.9696, 99.2784, 106.2048, 90.0432, 106.2048, 16.1616, GAMGI_IO_STROKE,

96.9696, 94.6608, 101.5872, 90.0432, 101.5872, 16.1616, GAMGI_IO_STROKE,

83.1168, 90.0432, 92.3520, 90.0432, 96.9696, 85.4256, 96.9696, 16.1616, 92.3520, 11.5440, GAMGI_IO_STROKE,

46.1760, 90.0432, 46.1760, 16.1616, GAMGI_IO_STROKE,

83.1168, 90.0432, 83.1168, 16.1616, GAMGI_IO_STROKE,

46.1760, 62.3376, 60.0288, 62.3376, GAMGI_IO_STROKE,

46.1760, 43.8672, 60.0288, 43.8672, GAMGI_IO_STROKE,

83.1168, 62.3376, 96.9696, 62.3376, GAMGI_IO_STROKE,

83.1168, 43.8672, 96.9696, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 88 X strokes: 13 *
 *************************/

4.6176, 85.4256, 13.8528, 94.6608, 23.0880, 99.2784, 32.3232, 99.2784, 36.9408, 94.6608, 73.8816, 11.5440, 78.4992, 6.9264, 87.7344, 6.9264, GAMGI_IO_STROKE,

27.7056, 94.6608, 32.3232, 90.0432, 69.2640, 11.5440, 73.8816, 6.9264, GAMGI_IO_STROKE,

13.8528, 94.6608, 23.0880, 94.6608, 27.7056, 90.0432, 64.6464, 6.9264, 69.2640, 2.3088, 78.4992, 2.3088, 87.7344, 6.9264, 96.9696, 16.1616, GAMGI_IO_STROKE,

73.8816, 99.2784, 83.1168, 94.6608, 92.3520, 94.6608, 96.9696, 99.2784, GAMGI_IO_STROKE,

73.8816, 94.6608, 78.4992, 90.0432, 87.7344, 90.0432, GAMGI_IO_STROKE,

69.2640, 90.0432, 73.8816, 85.4256, 83.1168, 85.4256, 92.3520, 90.0432, 96.9696, 99.2784, GAMGI_IO_STROKE,

4.6176, 2.3088, 9.2352, 11.5440, 18.4704, 16.1616, 27.7056, 16.1616, 32.3232, 11.5440, GAMGI_IO_STROKE,

13.8528, 11.5440, 23.0880, 11.5440, 27.7056, 6.9264, GAMGI_IO_STROKE,

4.6176, 2.3088, 9.2352, 6.9264, 18.4704, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

73.8816, 99.2784, 55.4112, 57.7200, GAMGI_IO_STROKE,

46.1760, 43.8672, 27.7056, 2.3088, GAMGI_IO_STROKE,

23.0880, 53.1024, 41.5584, 53.1024, GAMGI_IO_STROKE,

55.4112, 53.1024, 78.4992, 53.1024, GAMGI_IO_CHAR,

/*************************
 * char: 89 Y strokes: 14 *
 *************************/

13.8528, 99.2784, 18.4704, 94.6608, 23.0880, 85.4256, 23.0880, 57.7200, 13.8528, 57.7200, 9.2352, 53.1024, 9.2352, 43.8672, 13.8528, 48.4848, 23.0880, 48.4848, 23.0880, 16.1616, 13.8528, 11.5440, GAMGI_IO_STROKE,

23.0880, 90.0432, 27.7056, 80.8080, 27.7056, 16.1616, GAMGI_IO_STROKE,

13.8528, 53.1024, 27.7056, 53.1024, GAMGI_IO_STROKE,

32.3232, 11.5440, 46.1760, 11.5440, 55.4112, 6.9264, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, 27.7056, 90.0432, 32.3232, 80.8080, 32.3232, 16.1616, 50.7936, 16.1616, 64.6464, 11.5440, GAMGI_IO_STROKE,

13.8528, 11.5440, 27.7056, 11.5440, 41.5584, 6.9264, 50.7936, 2.3088, 64.6464, 11.5440, 78.4992, 16.1616, GAMGI_IO_STROKE,

50.7936, 80.8080, 64.6464, 85.4256, 73.8816, 90.0432, 83.1168, 99.2784, 87.7344, 94.6608, 96.9696, 90.0432, 87.7344, 85.4256, 87.7344, -11.5440, 83.1168, -20.7792, 73.8816, -30.0144, 64.6464, -25.3968, 46.1760, -20.7792, 23.0880, -20.7792, GAMGI_IO_STROKE,

83.1168, 85.4256, 87.7344, 90.0432, 83.1168, 94.6608, 78.4992, 90.0432, 83.1168, 85.4256, 83.1168, 11.5440, GAMGI_IO_STROKE,

73.8816, 90.0432, 78.4992, 85.4256, 78.4992, 16.1616, 87.7344, 2.3088, GAMGI_IO_STROKE,

78.4992, -25.3968, 69.2640, -20.7792, 55.4112, -20.7792, GAMGI_IO_STROKE,

83.1168, -20.7792, 69.2640, -16.1616, 41.5584, -16.1616, 23.0880, -20.7792, GAMGI_IO_STROKE,

50.7936, 80.8080, 50.7936, 16.1616, GAMGI_IO_STROKE,

50.7936, 66.9552, 60.0288, 62.3376, 69.2640, 62.3376, 78.4992, 66.9552, GAMGI_IO_STROKE,

50.7936, 39.2496, 60.0288, 43.8672, 69.2640, 43.8672, 78.4992, 39.2496, GAMGI_IO_CHAR,

/*************************
 * char: 90 Z strokes: 11 *
 *************************/

73.8816, 94.6608, 69.2640, 85.4256, 46.1760, 57.7200, 32.3232, 39.2496, 23.0880, 20.7792, 9.2352, 2.3088, GAMGI_IO_STROKE,

64.6464, 76.1904, 27.7056, 25.3968, GAMGI_IO_STROKE,

83.1168, 99.2784, 69.2640, 80.8080, 60.0288, 62.3376, 46.1760, 43.8672, 23.0880, 16.1616, 18.4704, 6.9264, GAMGI_IO_STROKE,

9.2352, 90.0432, 18.4704, 99.2784, 32.3232, 94.6608, 60.0288, 94.6608, 83.1168, 99.2784, GAMGI_IO_STROKE,

13.8528, 94.6608, 32.3232, 90.0432, 50.7936, 90.0432, 69.2640, 94.6608, GAMGI_IO_STROKE,

9.2352, 90.0432, 27.7056, 85.4256, 46.1760, 85.4256, 64.6464, 90.0432, 73.8816, 94.6608, GAMGI_IO_STROKE,

18.4704, 6.9264, 27.7056, 11.5440, 46.1760, 16.1616, 64.6464, 16.1616, 83.1168, 11.5440, GAMGI_IO_STROKE,

23.0880, 6.9264, 41.5584, 11.5440, 60.0288, 11.5440, 78.4992, 6.9264, GAMGI_IO_STROKE,

9.2352, 2.3088, 32.3232, 6.9264, 60.0288, 6.9264, 73.8816, 2.3088, 83.1168, 11.5440, GAMGI_IO_STROKE,

23.0880, 53.1024, 41.5584, 53.1024, GAMGI_IO_STROKE,

55.4112, 53.1024, 73.8816, 53.1024, GAMGI_IO_CHAR,

/*************************
 * char: 91 [ strokes: 4 *
 *************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_STROKE,

23.0880, 117.7488, 23.0880, -30.0144, GAMGI_IO_STROKE,

18.4704, 117.7488, 50.7936, 117.7488, GAMGI_IO_STROKE,

18.4704, -30.0144, 50.7936, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 92 \ strokes: 2 *
 *************************/

13.8528, 117.7488, 96.9696, -30.0144, 92.3520, -30.0144, GAMGI_IO_STROKE,

13.8528, 117.7488, 9.2352, 117.7488, 92.3520, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 93 ] strokes: 4 *
 *************************/

41.5584, 117.7488, 41.5584, -30.0144, GAMGI_IO_STROKE,

46.1760, 117.7488, 46.1760, -30.0144, GAMGI_IO_STROKE,

13.8528, 117.7488, 46.1760, 117.7488, GAMGI_IO_STROKE,

13.8528, -30.0144, 46.1760, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 94 ^ strokes: 2 *
 *************************/

27.7056, 71.5728, 36.9408, 85.4256, 46.1760, 71.5728, GAMGI_IO_STROKE,

13.8528, 57.7200, 36.9408, 80.8080, 60.0288, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 95 _ strokes: 1 *
 *************************/

9.2352, -6.9264, 92.3520, -6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 96 ` strokes: 2 *
 *************************/

36.9408, 99.2784, 27.7056, 94.6608, 23.0880, 85.4256, 23.0880, 76.1904, 27.7056, 66.9552, 36.9408, 76.1904, 27.7056, 85.4256, 27.7056, 94.6608, GAMGI_IO_STROKE,

27.7056, 80.8080, 27.7056, 71.5728, 32.3232, 76.1904, 27.7056, 80.8080, GAMGI_IO_CHAR,

/*************************
 * char: 97 a strokes: 8 *
 *************************/

27.7056, 43.8672, 18.4704, 34.6320, 13.8528, 25.3968, 13.8528, 16.1616, 18.4704, 6.9264, 27.7056, 2.3088, 36.9408, 11.5440, 50.7936, 16.1616, GAMGI_IO_STROKE,

13.8528, 25.3968, 18.4704, 16.1616, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

18.4704, 34.6320, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 11.5440, 36.9408, 11.5440, GAMGI_IO_STROKE,

18.4704, 53.1024, 27.7056, 53.1024, 41.5584, 57.7200, 50.7936, 62.3376, 55.4112, 66.9552, 64.6464, 57.7200, 60.0288, 53.1024, 60.0288, 16.1616, 64.6464, 11.5440, 69.2640, 11.5440, GAMGI_IO_STROKE,

23.0880, 62.3376, 18.4704, 57.7200, 32.3232, 57.7200, GAMGI_IO_STROKE,

46.1760, 57.7200, 60.0288, 57.7200, 55.4112, 62.3376, 55.4112, 11.5440, 60.0288, 6.9264, GAMGI_IO_STROKE,

13.8528, 57.7200, 23.0880, 66.9552, 27.7056, 62.3376, 36.9408, 57.7200, 50.7936, 53.1024, 50.7936, 11.5440, 60.0288, 2.3088, 69.2640, 11.5440, GAMGI_IO_STROKE,

13.8528, 57.7200, 36.9408, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 98 b strokes: 7 *
 *************************/

13.8528, 90.0432, 18.4704, 80.8080, 18.4704, 16.1616, 9.2352, 11.5440, GAMGI_IO_STROKE,

23.0880, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 23.0880, 16.1616, 36.9408, 6.9264, GAMGI_IO_STROKE,

13.8528, 90.0432, 27.7056, 99.2784, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 6.9264, GAMGI_IO_STROKE,

9.2352, 11.5440, 18.4704, 11.5440, 27.7056, 6.9264, 32.3232, 2.3088, 41.5584, 6.9264, 55.4112, 11.5440, 64.6464, 11.5440, GAMGI_IO_STROKE,

27.7056, 53.1024, 41.5584, 57.7200, 50.7936, 62.3376, 55.4112, 66.9552, 60.0288, 62.3376, 69.2640, 57.7200, 73.8816, 57.7200, 64.6464, 53.1024, 64.6464, 11.5440, GAMGI_IO_STROKE,

50.7936, 62.3376, 60.0288, 57.7200, 60.0288, 16.1616, GAMGI_IO_STROKE,

41.5584, 57.7200, 46.1760, 57.7200, 55.4112, 53.1024, 55.4112, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 99 c strokes: 6 *
 *************************/

18.4704, 57.7200, 18.4704, 16.1616, 9.2352, 11.5440, 13.8528, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

23.0880, 57.7200, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

27.7056, 57.7200, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 11.5440, 32.3232, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

18.4704, 57.7200, 36.9408, 62.3376, 46.1760, 66.9552, 50.7936, 62.3376, 60.0288, 57.7200, 64.6464, 57.7200, GAMGI_IO_STROKE,

41.5584, 62.3376, 46.1760, 57.7200, 55.4112, 57.7200, GAMGI_IO_STROKE,

27.7056, 57.7200, 36.9408, 62.3376, 46.1760, 53.1024, 55.4112, 53.1024, 64.6464, 57.7200, GAMGI_IO_CHAR,

/**************************
 * char: 100 d strokes: 7 *
 **************************/

41.5584, 66.9552, 32.3232, 62.3376, 18.4704, 57.7200, 18.4704, 16.1616, 9.2352, 11.5440, GAMGI_IO_STROKE,

23.0880, 57.7200, 23.0880, 16.1616, 36.9408, 6.9264, GAMGI_IO_STROKE,

41.5584, 66.9552, 27.7056, 57.7200, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 6.9264, GAMGI_IO_STROKE,

9.2352, 11.5440, 18.4704, 11.5440, 27.7056, 6.9264, 32.3232, 2.3088, 41.5584, 6.9264, 55.4112, 11.5440, 64.6464, 11.5440, GAMGI_IO_STROKE,

18.4704, 90.0432, 32.3232, 99.2784, 36.9408, 85.4256, 64.6464, 57.7200, 64.6464, 11.5440, GAMGI_IO_STROKE,

32.3232, 85.4256, 23.0880, 90.0432, 27.7056, 94.6608, 32.3232, 85.4256, 60.0288, 57.7200, 60.0288, 16.1616, GAMGI_IO_STROKE,

18.4704, 90.0432, 55.4112, 53.1024, 55.4112, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 101 e strokes: 6 *
 **************************/

18.4704, 57.7200, 18.4704, 16.1616, 9.2352, 11.5440, 13.8528, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

23.0880, 57.7200, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

27.7056, 57.7200, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 11.5440, 32.3232, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

18.4704, 57.7200, 36.9408, 62.3376, 46.1760, 66.9552, 60.0288, 48.4848, 50.7936, 43.8672, 27.7056, 30.0144, GAMGI_IO_STROKE,

41.5584, 62.3376, 55.4112, 48.4848, GAMGI_IO_STROKE,

27.7056, 57.7200, 36.9408, 62.3376, 50.7936, 43.8672, GAMGI_IO_CHAR,

/**************************
 * char: 102 f strokes: 8 *
 **************************/

18.4704, 90.0432, 18.4704, 16.1616, 9.2352, 11.5440, 13.8528, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

23.0880, 90.0432, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

27.7056, 90.0432, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 11.5440, 32.3232, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

18.4704, 90.0432, 32.3232, 94.6608, 41.5584, 99.2784, 46.1760, 94.6608, 55.4112, 90.0432, 60.0288, 90.0432, GAMGI_IO_STROKE,

36.9408, 94.6608, 41.5584, 90.0432, 50.7936, 90.0432, GAMGI_IO_STROKE,

27.7056, 90.0432, 32.3232, 94.6608, 41.5584, 85.4256, 50.7936, 85.4256, 60.0288, 90.0432, GAMGI_IO_STROKE,

4.6176, 66.9552, 18.4704, 66.9552, GAMGI_IO_STROKE,

27.7056, 66.9552, 46.1760, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 103 g strokes: 8 *
 **************************/

18.4704, 57.7200, 18.4704, 16.1616, 9.2352, 11.5440, 13.8528, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, 32.3232, 6.9264, 41.5584, 11.5440, 55.4112, 16.1616, GAMGI_IO_STROKE,

23.0880, 53.1024, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

27.7056, 57.7200, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 11.5440, GAMGI_IO_STROKE,

18.4704, 57.7200, 27.7056, 57.7200, 41.5584, 62.3376, 50.7936, 66.9552, 55.4112, 62.3376, 64.6464, 57.7200, 73.8816, 57.7200, 64.6464, 53.1024, 64.6464, -2.3088, 60.0288, -16.1616, 50.7936, -25.3968, 41.5584, -30.0144, 36.9408, -25.3968, 27.7056, -20.7792, 18.4704, -20.7792, GAMGI_IO_STROKE,

46.1760, 62.3376, 60.0288, 53.1024, 60.0288, -2.3088, GAMGI_IO_STROKE,

46.1760, -25.3968, 36.9408, -20.7792, 32.3232, -20.7792, GAMGI_IO_STROKE,

41.5584, 62.3376, 46.1760, 57.7200, 55.4112, 53.1024, 55.4112, 6.9264, 60.0288, -6.9264, 60.0288, -16.1616, GAMGI_IO_STROKE,

50.7936, -25.3968, 46.1760, -20.7792, 36.9408, -16.1616, 27.7056, -16.1616, 18.4704, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 104 h strokes: 6 *
 **************************/

13.8528, 90.0432, 18.4704, 80.8080, 18.4704, 16.1616, 9.2352, 11.5440, 13.8528, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

23.0880, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

13.8528, 90.0432, 27.7056, 99.2784, 27.7056, 16.1616, 36.9408, 11.5440, 27.7056, 2.3088, GAMGI_IO_STROKE,

27.7056, 53.1024, 41.5584, 57.7200, 50.7936, 62.3376, 55.4112, 66.9552, 60.0288, 62.3376, 69.2640, 57.7200, 73.8816, 57.7200, 64.6464, 53.1024, 64.6464, 11.5440, 55.4112, 2.3088, 50.7936, -6.9264, GAMGI_IO_STROKE,

50.7936, 62.3376, 60.0288, 57.7200, 60.0288, 11.5440, 55.4112, 2.3088, GAMGI_IO_STROKE,

41.5584, 57.7200, 46.1760, 57.7200, 55.4112, 53.1024, 55.4112, 11.5440, 50.7936, -6.9264, 50.7936, -20.7792, 55.4112, -30.0144, 60.0288, -30.0144, 50.7936, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 105 i strokes: 5 *
 **************************/

23.0880, 99.2784, 13.8528, 90.0432, 23.0880, 85.4256, 32.3232, 90.0432, 23.0880, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 90.0432, 27.7056, 90.0432, 23.0880, 94.6608, GAMGI_IO_STROKE,

23.0880, 66.9552, 18.4704, 62.3376, 9.2352, 57.7200, 18.4704, 53.1024, 18.4704, 11.5440, 27.7056, 2.3088, 36.9408, 11.5440, GAMGI_IO_STROKE,

23.0880, 53.1024, 27.7056, 57.7200, 23.0880, 62.3376, 18.4704, 57.7200, 23.0880, 53.1024, 23.0880, 11.5440, 27.7056, 6.9264, GAMGI_IO_STROKE,

23.0880, 66.9552, 27.7056, 62.3376, 36.9408, 57.7200, 27.7056, 53.1024, 27.7056, 16.1616, 32.3232, 11.5440, 36.9408, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 106 j strokes: 5 *
 **************************/

23.0880, 99.2784, 13.8528, 90.0432, 23.0880, 85.4256, 32.3232, 90.0432, 23.0880, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 90.0432, 27.7056, 90.0432, 23.0880, 94.6608, GAMGI_IO_STROKE,

23.0880, 66.9552, 18.4704, 62.3376, 9.2352, 57.7200, 18.4704, 53.1024, 18.4704, 11.5440, 27.7056, 2.3088, 32.3232, -6.9264, GAMGI_IO_STROKE,

23.0880, 53.1024, 27.7056, 57.7200, 23.0880, 62.3376, 18.4704, 57.7200, 23.0880, 53.1024, 23.0880, 11.5440, 27.7056, 2.3088, GAMGI_IO_STROKE,

23.0880, 66.9552, 27.7056, 62.3376, 36.9408, 57.7200, 27.7056, 53.1024, 27.7056, 11.5440, 32.3232, -6.9264, 32.3232, -20.7792, 23.0880, -30.0144, 13.8528, -30.0144, 13.8528, -25.3968, 23.0880, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 107 k strokes: 9 *
 **************************/

13.8528, 90.0432, 18.4704, 80.8080, 18.4704, 16.1616, 9.2352, 11.5440, 13.8528, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

23.0880, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

13.8528, 90.0432, 27.7056, 99.2784, 27.7056, 16.1616, 36.9408, 11.5440, 27.7056, 2.3088, GAMGI_IO_STROKE,

27.7056, 53.1024, 41.5584, 62.3376, 50.7936, 66.9552, 60.0288, 53.1024, 46.1760, 43.8672, 27.7056, 30.0144, GAMGI_IO_STROKE,

46.1760, 62.3376, 55.4112, 53.1024, GAMGI_IO_STROKE,

41.5584, 62.3376, 50.7936, 48.4848, GAMGI_IO_STROKE,

46.1760, 43.8672, 50.7936, 39.2496, 60.0288, 16.1616, 64.6464, 11.5440, 69.2640, 11.5440, GAMGI_IO_STROKE,

46.1760, 39.2496, 50.7936, 34.6320, 55.4112, 11.5440, 60.0288, 6.9264, GAMGI_IO_STROKE,

41.5584, 39.2496, 46.1760, 34.6320, 50.7936, 11.5440, 60.0288, 2.3088, 69.2640, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 108 l strokes: 3 *
 **************************/

13.8528, 90.0432, 18.4704, 80.8080, 18.4704, 16.1616, 9.2352, 11.5440, 13.8528, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

23.0880, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

13.8528, 90.0432, 27.7056, 99.2784, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 11.5440, 32.3232, 6.9264, 27.7056, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 109 m strokes: 9 *
 **************************/

9.2352, 57.7200, 13.8528, 57.7200, 18.4704, 53.1024, 18.4704, 16.1616, 9.2352, 11.5440, 13.8528, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

18.4704, 62.3376, 23.0880, 57.7200, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

9.2352, 57.7200, 18.4704, 66.9552, 27.7056, 57.7200, 27.7056, 16.1616, 36.9408, 11.5440, 27.7056, 2.3088, GAMGI_IO_STROKE,

27.7056, 53.1024, 41.5584, 57.7200, 50.7936, 62.3376, 55.4112, 66.9552, 64.6464, 57.7200, 64.6464, 16.1616, 73.8816, 11.5440, 64.6464, 2.3088, GAMGI_IO_STROKE,

50.7936, 62.3376, 60.0288, 57.7200, 60.0288, 11.5440, 69.2640, 6.9264, GAMGI_IO_STROKE,

41.5584, 57.7200, 46.1760, 57.7200, 55.4112, 53.1024, 55.4112, 16.1616, 50.7936, 11.5440, 60.0288, 6.9264, 64.6464, 2.3088, GAMGI_IO_STROKE,

64.6464, 53.1024, 78.4992, 57.7200, 87.7344, 62.3376, 92.3520, 66.9552, 96.9696, 62.3376, 106.2048, 57.7200, 110.8224, 57.7200, 101.5872, 53.1024, 101.5872, 16.1616, 106.2048, 11.5440, 110.8224, 11.5440, GAMGI_IO_STROKE,

87.7344, 62.3376, 96.9696, 57.7200, 96.9696, 11.5440, 101.5872, 6.9264, GAMGI_IO_STROKE,

78.4992, 57.7200, 83.1168, 57.7200, 92.3520, 53.1024, 92.3520, 11.5440, 101.5872, 2.3088, 110.8224, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 110 n strokes: 6 *
 **************************/

9.2352, 57.7200, 13.8528, 57.7200, 18.4704, 53.1024, 18.4704, 16.1616, 9.2352, 11.5440, 13.8528, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

18.4704, 62.3376, 23.0880, 57.7200, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

9.2352, 57.7200, 18.4704, 66.9552, 27.7056, 57.7200, 27.7056, 16.1616, 36.9408, 11.5440, 27.7056, 2.3088, GAMGI_IO_STROKE,

27.7056, 53.1024, 41.5584, 57.7200, 50.7936, 62.3376, 55.4112, 66.9552, 60.0288, 62.3376, 69.2640, 57.7200, 73.8816, 57.7200, 64.6464, 53.1024, 64.6464, 16.1616, 69.2640, 11.5440, 73.8816, 11.5440, GAMGI_IO_STROKE,

50.7936, 62.3376, 60.0288, 57.7200, 60.0288, 11.5440, 64.6464, 6.9264, GAMGI_IO_STROKE,

41.5584, 57.7200, 46.1760, 57.7200, 55.4112, 53.1024, 55.4112, 11.5440, 64.6464, 2.3088, 73.8816, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 111 o strokes: 7 *
 **************************/

18.4704, 57.7200, 18.4704, 16.1616, 9.2352, 11.5440, GAMGI_IO_STROKE,

23.0880, 53.1024, 23.0880, 16.1616, 36.9408, 6.9264, GAMGI_IO_STROKE,

27.7056, 57.7200, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 6.9264, GAMGI_IO_STROKE,

9.2352, 11.5440, 18.4704, 11.5440, 27.7056, 6.9264, 32.3232, 2.3088, 41.5584, 6.9264, 55.4112, 11.5440, 64.6464, 11.5440, GAMGI_IO_STROKE,

18.4704, 57.7200, 27.7056, 57.7200, 41.5584, 62.3376, 50.7936, 66.9552, 55.4112, 62.3376, 64.6464, 57.7200, 73.8816, 57.7200, 64.6464, 53.1024, 64.6464, 11.5440, GAMGI_IO_STROKE,

46.1760, 62.3376, 60.0288, 53.1024, 60.0288, 16.1616, GAMGI_IO_STROKE,

41.5584, 62.3376, 46.1760, 57.7200, 55.4112, 53.1024, 55.4112, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 112 p strokes: 9 *
 **************************/

13.8528, 66.9552, 18.4704, 57.7200, 18.4704, 16.1616, 9.2352, 11.5440, 18.4704, 11.5440, 18.4704, -30.0144, GAMGI_IO_STROKE,

18.4704, 62.3376, 23.0880, 57.7200, 23.0880, -25.3968, 27.7056, -20.7792, 23.0880, -11.5440, GAMGI_IO_STROKE,

23.0880, 11.5440, 27.7056, 11.5440, 36.9408, 6.9264, GAMGI_IO_STROKE,

13.8528, 66.9552, 23.0880, 62.3376, 27.7056, 57.7200, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 6.9264, GAMGI_IO_STROKE,

27.7056, 6.9264, 32.3232, 2.3088, 41.5584, 6.9264, 55.4112, 11.5440, 64.6464, 11.5440, GAMGI_IO_STROKE,

27.7056, 6.9264, 27.7056, -11.5440, 32.3232, -20.7792, 18.4704, -30.0144, GAMGI_IO_STROKE,

27.7056, 53.1024, 41.5584, 57.7200, 50.7936, 62.3376, 55.4112, 66.9552, 60.0288, 62.3376, 69.2640, 57.7200, 73.8816, 57.7200, 64.6464, 53.1024, 64.6464, 11.5440, GAMGI_IO_STROKE,

50.7936, 62.3376, 60.0288, 57.7200, 60.0288, 16.1616, GAMGI_IO_STROKE,

41.5584, 57.7200, 46.1760, 57.7200, 55.4112, 53.1024, 55.4112, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 113 q strokes: 7 *
 **************************/

18.4704, 57.7200, 18.4704, 16.1616, 9.2352, 11.5440, GAMGI_IO_STROKE,

23.0880, 53.1024, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

27.7056, 57.7200, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 11.5440, GAMGI_IO_STROKE,

9.2352, 11.5440, 13.8528, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, 32.3232, 6.9264, 41.5584, 11.5440, 55.4112, 16.1616, GAMGI_IO_STROKE,

18.4704, 57.7200, 27.7056, 57.7200, 41.5584, 62.3376, 50.7936, 66.9552, 55.4112, 62.3376, 64.6464, 57.7200, 73.8816, 57.7200, 64.6464, 53.1024, 64.6464, -30.0144, GAMGI_IO_STROKE,

46.1760, 62.3376, 60.0288, 53.1024, 60.0288, -25.3968, 55.4112, -20.7792, 60.0288, -11.5440, GAMGI_IO_STROKE,

41.5584, 62.3376, 46.1760, 57.7200, 55.4112, 53.1024, 55.4112, -11.5440, 50.7936, -20.7792, 64.6464, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 114 r strokes: 6 *
 **************************/

9.2352, 57.7200, 13.8528, 57.7200, 18.4704, 53.1024, 18.4704, 16.1616, 9.2352, 11.5440, 13.8528, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

13.8528, 62.3376, 23.0880, 57.7200, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

9.2352, 57.7200, 18.4704, 66.9552, 27.7056, 57.7200, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 11.5440, 32.3232, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

27.7056, 57.7200, 46.1760, 66.9552, 50.7936, 62.3376, 60.0288, 57.7200, 64.6464, 57.7200, GAMGI_IO_STROKE,

41.5584, 62.3376, 46.1760, 57.7200, 55.4112, 57.7200, GAMGI_IO_STROKE,

36.9408, 62.3376, 46.1760, 53.1024, 55.4112, 53.1024, 64.6464, 57.7200, GAMGI_IO_CHAR,

/**************************
 * char: 115 s strokes: 12 *
 **************************/

13.8528, 57.7200, 13.8528, 39.2496, 23.0880, 34.6320, 50.7936, 34.6320, 60.0288, 30.0144, 60.0288, 11.5440, GAMGI_IO_STROKE,

18.4704, 57.7200, 18.4704, 39.2496, GAMGI_IO_STROKE,

55.4112, 30.0144, 55.4112, 11.5440, GAMGI_IO_STROKE,

27.7056, 62.3376, 23.0880, 57.7200, 23.0880, 39.2496, 32.3232, 34.6320, GAMGI_IO_STROKE,

41.5584, 34.6320, 50.7936, 30.0144, 50.7936, 11.5440, 46.1760, 6.9264, GAMGI_IO_STROKE,

13.8528, 57.7200, 27.7056, 62.3376, 36.9408, 66.9552, 46.1760, 62.3376, 55.4112, 62.3376, 60.0288, 66.9552, GAMGI_IO_STROKE,

32.3232, 62.3376, 41.5584, 62.3376, GAMGI_IO_STROKE,

27.7056, 62.3376, 36.9408, 57.7200, 46.1760, 57.7200, 55.4112, 62.3376, GAMGI_IO_STROKE,

60.0288, 11.5440, 46.1760, 6.9264, 36.9408, 2.3088, 27.7056, 6.9264, 18.4704, 6.9264, 9.2352, 2.3088, GAMGI_IO_STROKE,

41.5584, 6.9264, 32.3232, 6.9264, GAMGI_IO_STROKE,

46.1760, 6.9264, 36.9408, 11.5440, 23.0880, 11.5440, 9.2352, 2.3088, GAMGI_IO_STROKE,

60.0288, 66.9552, 55.4112, 57.7200, 46.1760, 43.8672, 23.0880, 20.7792, 9.2352, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 116 t strokes: 5 *
 **************************/

13.8528, 90.0432, 18.4704, 80.8080, 18.4704, 16.1616, 9.2352, 11.5440, 13.8528, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

23.0880, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

13.8528, 90.0432, 27.7056, 99.2784, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 11.5440, 32.3232, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

4.6176, 66.9552, 18.4704, 66.9552, GAMGI_IO_STROKE,

27.7056, 66.9552, 41.5584, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 117 u strokes: 7 *
 **************************/

9.2352, 57.7200, 13.8528, 57.7200, 18.4704, 53.1024, 18.4704, 16.1616, 9.2352, 11.5440, GAMGI_IO_STROKE,

13.8528, 62.3376, 23.0880, 57.7200, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

9.2352, 57.7200, 18.4704, 66.9552, 27.7056, 57.7200, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 11.5440, GAMGI_IO_STROKE,

9.2352, 11.5440, 13.8528, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, 32.3232, 6.9264, 41.5584, 11.5440, 55.4112, 16.1616, GAMGI_IO_STROKE,

55.4112, 66.9552, 60.0288, 62.3376, 69.2640, 57.7200, 73.8816, 57.7200, 64.6464, 53.1024, 64.6464, 16.1616, 69.2640, 11.5440, 73.8816, 11.5440, GAMGI_IO_STROKE,

50.7936, 62.3376, 60.0288, 57.7200, 60.0288, 11.5440, 64.6464, 6.9264, GAMGI_IO_STROKE,

55.4112, 66.9552, 46.1760, 57.7200, 55.4112, 53.1024, 55.4112, 11.5440, 64.6464, 2.3088, 73.8816, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 118 v strokes: 6 *
 **************************/

13.8528, 66.9552, 18.4704, 57.7200, 18.4704, 16.1616, 32.3232, 2.3088, 41.5584, 11.5440, 55.4112, 16.1616, 64.6464, 16.1616, GAMGI_IO_STROKE,

18.4704, 62.3376, 23.0880, 57.7200, 23.0880, 16.1616, 36.9408, 6.9264, GAMGI_IO_STROKE,

13.8528, 66.9552, 23.0880, 62.3376, 27.7056, 57.7200, 27.7056, 20.7792, 32.3232, 16.1616, 41.5584, 11.5440, GAMGI_IO_STROKE,

55.4112, 66.9552, 60.0288, 62.3376, 69.2640, 57.7200, 73.8816, 57.7200, 64.6464, 53.1024, 64.6464, 16.1616, GAMGI_IO_STROKE,

50.7936, 62.3376, 60.0288, 57.7200, 60.0288, 20.7792, GAMGI_IO_STROKE,

55.4112, 66.9552, 46.1760, 57.7200, 55.4112, 53.1024, 55.4112, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 119 w strokes: 9 *
 **************************/

13.8528, 66.9552, 18.4704, 57.7200, 18.4704, 16.1616, 32.3232, 2.3088, 41.5584, 11.5440, 55.4112, 16.1616, GAMGI_IO_STROKE,

18.4704, 62.3376, 23.0880, 57.7200, 23.0880, 16.1616, 36.9408, 6.9264, GAMGI_IO_STROKE,

13.8528, 66.9552, 23.0880, 62.3376, 27.7056, 57.7200, 27.7056, 20.7792, 32.3232, 16.1616, 41.5584, 11.5440, GAMGI_IO_STROKE,

55.4112, 66.9552, 46.1760, 57.7200, 55.4112, 53.1024, 55.4112, 16.1616, 69.2640, 2.3088, 78.4992, 11.5440, 92.3520, 16.1616, 101.5872, 16.1616, GAMGI_IO_STROKE,

50.7936, 62.3376, 60.0288, 57.7200, 60.0288, 16.1616, 73.8816, 6.9264, GAMGI_IO_STROKE,

55.4112, 66.9552, 60.0288, 62.3376, 69.2640, 57.7200, 64.6464, 53.1024, 64.6464, 20.7792, 69.2640, 16.1616, 78.4992, 11.5440, GAMGI_IO_STROKE,

92.3520, 66.9552, 96.9696, 62.3376, 106.2048, 57.7200, 110.8224, 57.7200, 101.5872, 53.1024, 101.5872, 16.1616, GAMGI_IO_STROKE,

87.7344, 62.3376, 96.9696, 57.7200, 96.9696, 20.7792, GAMGI_IO_STROKE,

92.3520, 66.9552, 83.1168, 57.7200, 92.3520, 53.1024, 92.3520, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 120 x strokes: 11 *
 **************************/

13.8528, 57.7200, 18.4704, 57.7200, 27.7056, 53.1024, 32.3232, 48.4848, 50.7936, 11.5440, 55.4112, 6.9264, 64.6464, 2.3088, 73.8816, 11.5440, GAMGI_IO_STROKE,

23.0880, 62.3376, 32.3232, 57.7200, 55.4112, 11.5440, 64.6464, 6.9264, GAMGI_IO_STROKE,

13.8528, 57.7200, 23.0880, 66.9552, 32.3232, 62.3376, 36.9408, 57.7200, 55.4112, 20.7792, 60.0288, 16.1616, 69.2640, 11.5440, 73.8816, 11.5440, GAMGI_IO_STROKE,

46.1760, 39.2496, 60.0288, 66.9552, 64.6464, 62.3376, 73.8816, 62.3376, 78.4992, 66.9552, GAMGI_IO_STROKE,

60.0288, 62.3376, 64.6464, 57.7200, 69.2640, 57.7200, GAMGI_IO_STROKE,

55.4112, 57.7200, 64.6464, 53.1024, 73.8816, 57.7200, 78.4992, 66.9552, GAMGI_IO_STROKE,

41.5584, 30.0144, 27.7056, 2.3088, 23.0880, 6.9264, 13.8528, 6.9264, 9.2352, 2.3088, GAMGI_IO_STROKE,

27.7056, 6.9264, 23.0880, 11.5440, 18.4704, 11.5440, GAMGI_IO_STROKE,

32.3232, 11.5440, 23.0880, 16.1616, 13.8528, 11.5440, 9.2352, 2.3088, GAMGI_IO_STROKE,

23.0880, 34.6320, 36.9408, 34.6320, GAMGI_IO_STROKE,

50.7936, 34.6320, 64.6464, 34.6320, GAMGI_IO_CHAR,

/**************************
 * char: 121 y strokes: 9 *
 **************************/

9.2352, 57.7200, 13.8528, 57.7200, 18.4704, 53.1024, 18.4704, 16.1616, 9.2352, 11.5440, GAMGI_IO_STROKE,

13.8528, 62.3376, 23.0880, 57.7200, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

9.2352, 57.7200, 18.4704, 66.9552, 27.7056, 57.7200, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 11.5440, GAMGI_IO_STROKE,

9.2352, 11.5440, 13.8528, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, 32.3232, 6.9264, 41.5584, 11.5440, 55.4112, 16.1616, GAMGI_IO_STROKE,

55.4112, 66.9552, 60.0288, 62.3376, 69.2640, 57.7200, 73.8816, 57.7200, 64.6464, 53.1024, 64.6464, -2.3088, 60.0288, -16.1616, 50.7936, -25.3968, 41.5584, -30.0144, 36.9408, -25.3968, 27.7056, -20.7792, 18.4704, -20.7792, GAMGI_IO_STROKE,

50.7936, 62.3376, 60.0288, 57.7200, 60.0288, -2.3088, GAMGI_IO_STROKE,

46.1760, -25.3968, 36.9408, -20.7792, 32.3232, -20.7792, GAMGI_IO_STROKE,

55.4112, 66.9552, 46.1760, 57.7200, 55.4112, 53.1024, 55.4112, 6.9264, 60.0288, -6.9264, 60.0288, -16.1616, GAMGI_IO_STROKE,

50.7936, -25.3968, 46.1760, -20.7792, 36.9408, -16.1616, 27.7056, -16.1616, 18.4704, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 122 z strokes: 8 *
 **************************/

69.2640, 66.9552, 13.8528, 2.3088, GAMGI_IO_STROKE,

13.8528, 57.7200, 23.0880, 53.1024, 36.9408, 53.1024, 50.7936, 57.7200, 69.2640, 66.9552, GAMGI_IO_STROKE,

18.4704, 62.3376, 27.7056, 57.7200, 46.1760, 57.7200, GAMGI_IO_STROKE,

13.8528, 57.7200, 23.0880, 66.9552, 32.3232, 62.3376, 50.7936, 62.3376, 69.2640, 66.9552, GAMGI_IO_STROKE,

13.8528, 2.3088, 32.3232, 11.5440, 46.1760, 16.1616, 60.0288, 16.1616, 69.2640, 11.5440, GAMGI_IO_STROKE,

36.9408, 11.5440, 55.4112, 11.5440, 64.6464, 6.9264, GAMGI_IO_STROKE,

13.8528, 2.3088, 32.3232, 6.9264, 50.7936, 6.9264, 60.0288, 2.3088, 69.2640, 11.5440, GAMGI_IO_STROKE,

23.0880, 34.6320, 60.0288, 34.6320, GAMGI_IO_CHAR,

/**************************
 * char: 123 { strokes: 3 *
 **************************/

46.1760, 117.7488, 32.3232, 103.8960, 27.7056, 90.0432, 27.7056, 80.8080, 32.3232, 66.9552, 41.5584, 57.7200, 41.5584, 53.1024, 23.0880, 43.8672, 41.5584, 34.6320, 41.5584, 30.0144, 32.3232, 20.7792, 27.7056, 6.9264, 27.7056, -2.3088, 32.3232, -16.1616, 46.1760, -30.0144, GAMGI_IO_STROKE,

36.9408, 108.5136, 32.3232, 94.6608, 32.3232, 76.1904, 36.9408, 62.3376, GAMGI_IO_STROKE,

36.9408, 25.3968, 32.3232, 11.5440, 32.3232, -6.9264, 36.9408, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 124 | strokes: 2 *
 **************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_STROKE,

23.0880, 117.7488, 23.0880, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 125 } strokes: 3 *
 **************************/

23.0880, 117.7488, 36.9408, 103.8960, 41.5584, 90.0432, 41.5584, 80.8080, 36.9408, 66.9552, 27.7056, 57.7200, 27.7056, 53.1024, 46.1760, 43.8672, 27.7056, 34.6320, 27.7056, 30.0144, 36.9408, 20.7792, 41.5584, 6.9264, 41.5584, -2.3088, 36.9408, -16.1616, 23.0880, -30.0144, GAMGI_IO_STROKE,

32.3232, 108.5136, 36.9408, 94.6608, 36.9408, 76.1904, 32.3232, 62.3376, GAMGI_IO_STROKE,

32.3232, 25.3968, 36.9408, 11.5440, 36.9408, -6.9264, 32.3232, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 126 ~ strokes: 2 *
 **************************/

13.8528, 30.0144, 13.8528, 39.2496, 18.4704, 53.1024, 27.7056, 57.7200, 36.9408, 57.7200, 46.1760, 53.1024, 64.6464, 39.2496, 73.8816, 34.6320, 83.1168, 34.6320, 92.3520, 39.2496, 96.9696, 48.4848, GAMGI_IO_STROKE,

13.8528, 39.2496, 18.4704, 48.4848, 27.7056, 53.1024, 36.9408, 53.1024, 46.1760, 48.4848, 64.6464, 34.6320, 73.8816, 30.0144, 83.1168, 30.0144, 92.3520, 34.6320, 96.9696, 48.4848, 96.9696, 57.7200, GAMGI_IO_CHAR,

};

const float gamgi_io_font_hershey_gothic_german_points[GAMGI_IO_POINTS_GOTHIC_GERMAN] = {

/***************
 * bottom, top *
 ***************/

-32.3232, 120.0576,

/**************
 * char 32-40 *
 **************/

73.8816, 50.7936, 83.1168, 106.2048, 92.3520, 110.8224, 120.0576, 50.7936, 64.6464, 

/**************
 * char 41-50 *
 **************/

64.6464, 73.8816, 115.4400, 50.7936, 115.4400, 50.7936, 106.2048, 92.3520, 92.3520, 92.3520, 

/**************
 * char 51-60 *
 **************/

92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 50.7936, 50.7936, 110.8224, 

/**************
 * char 61-70 *
 **************/

115.4400, 110.8224, 87.7344, 124.6752, 110.8224, 120.0576, 110.8224, 120.0576, 110.8224, 110.8224, 

/**************
 * char 71-80 *
 **************/

120.0576, 115.4400, 115.4400, 115.4400, 120.0576, 106.2048, 147.7632, 129.2928, 129.2928, 124.6752, 

/**************
 * char 81-90 *
 **************/

129.2928, 129.2928, 124.6752, 115.4400, 101.5872, 129.2928, 152.3808, 110.8224, 120.0576, 110.8224, 

/***************
 * char 91-100 *
 ***************/

64.6464, 106.2048, 64.6464, 73.8816, 101.5872, 50.7936, 78.4992, 78.4992, 60.0288, 78.4992, 

/****************
 * char 101-110 *
 ****************/

60.0288, 60.0288, 78.4992, 78.4992, 46.1760, 46.1760, 64.6464, 46.1760, 120.0576, 83.1168, 

/****************
 * char 111-120 *
 ****************/

78.4992, 78.4992, 78.4992, 64.6464, 50.7936, 55.4112, 83.1168, 78.4992, 115.4400, 69.2640, 

/****************
 * char 121-126 *
 ****************/

78.4992, 64.6464, 69.2640, 41.5584, 69.2640, 110.8224, 

/*************************
 * char: 32   strokes: 0 *
 *************************/

GAMGI_IO_CHAR,

/*************************
 * char: 33 ! strokes: 6 *
 *************************/

23.0880, 99.2784, 18.4704, 94.6608, 18.4704, 85.4256, 23.0880, 48.4848, GAMGI_IO_STROKE,

23.0880, 99.2784, 23.0880, 34.6320, 27.7056, 34.6320, GAMGI_IO_STROKE,

23.0880, 99.2784, 27.7056, 99.2784, 27.7056, 34.6320, GAMGI_IO_STROKE,

27.7056, 99.2784, 32.3232, 94.6608, 32.3232, 85.4256, 27.7056, 48.4848, GAMGI_IO_STROKE,

23.0880, 16.1616, 18.4704, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 2.3088, 32.3232, 6.9264, 32.3232, 11.5440, 27.7056, 16.1616, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 34 " strokes: 6 *
 *************************/

23.0880, 99.2784, 18.4704, 94.6608, 18.4704, 66.9552, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 66.9552, GAMGI_IO_STROKE,

23.0880, 99.2784, 27.7056, 94.6608, 18.4704, 66.9552, GAMGI_IO_STROKE,

64.6464, 99.2784, 60.0288, 94.6608, 60.0288, 66.9552, GAMGI_IO_STROKE,

64.6464, 94.6608, 60.0288, 66.9552, GAMGI_IO_STROKE,

64.6464, 99.2784, 69.2640, 94.6608, 60.0288, 66.9552, GAMGI_IO_CHAR,

/*************************
 * char: 35 # strokes: 8 *
 *************************/

36.9408, 99.2784, 36.9408, -30.0144, 41.5584, -30.0144, GAMGI_IO_STROKE,

36.9408, 99.2784, 41.5584, 99.2784, 41.5584, -30.0144, GAMGI_IO_STROKE,

64.6464, 99.2784, 64.6464, -30.0144, 69.2640, -30.0144, GAMGI_IO_STROKE,

64.6464, 99.2784, 69.2640, 99.2784, 69.2640, -30.0144, GAMGI_IO_STROKE,

13.8528, 53.1024, 92.3520, 53.1024, 92.3520, 48.4848, GAMGI_IO_STROKE,

13.8528, 53.1024, 13.8528, 48.4848, 92.3520, 48.4848, GAMGI_IO_STROKE,

13.8528, 20.7792, 92.3520, 20.7792, 92.3520, 16.1616, GAMGI_IO_STROKE,

13.8528, 20.7792, 13.8528, 16.1616, 92.3520, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 36 $ strokes: 5 *
 *************************/

36.9408, 117.7488, 36.9408, -16.1616, GAMGI_IO_STROKE,

55.4112, 117.7488, 55.4112, -16.1616, GAMGI_IO_STROKE,

73.8816, 76.1904, 73.8816, 80.8080, 69.2640, 80.8080, 69.2640, 71.5728, 78.4992, 71.5728, 78.4992, 80.8080, 73.8816, 90.0432, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, 23.0880, 94.6608, 13.8528, 85.4256, 13.8528, 71.5728, 18.4704, 62.3376, 32.3232, 53.1024, 60.0288, 43.8672, 69.2640, 39.2496, 73.8816, 30.0144, 73.8816, 16.1616, 69.2640, 6.9264, GAMGI_IO_STROKE,

18.4704, 71.5728, 23.0880, 62.3376, 32.3232, 57.7200, 60.0288, 48.4848, 69.2640, 43.8672, 73.8816, 34.6320, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 76.1904, 23.0880, 66.9552, 32.3232, 62.3376, 60.0288, 53.1024, 73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 20.7792, 73.8816, 11.5440, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 30.0144, 23.0880, 30.0144, 23.0880, 20.7792, 18.4704, 20.7792, 18.4704, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 37 % strokes: 12 *
 *************************/

96.9696, 99.2784, 87.7344, 94.6608, 73.8816, 90.0432, 60.0288, 90.0432, 46.1760, 94.6608, 36.9408, 99.2784, 27.7056, 99.2784, 18.4704, 94.6608, 13.8528, 85.4256, 13.8528, 76.1904, 23.0880, 66.9552, 32.3232, 66.9552, 41.5584, 71.5728, 46.1760, 80.8080, 46.1760, 90.0432, 36.9408, 99.2784, GAMGI_IO_STROKE,

96.9696, 99.2784, 9.2352, 2.3088, GAMGI_IO_STROKE,

96.9696, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

96.9696, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

87.7344, 34.6320, 78.4992, 34.6320, 69.2640, 30.0144, 64.6464, 20.7792, 64.6464, 11.5440, 73.8816, 2.3088, 83.1168, 2.3088, 92.3520, 6.9264, 96.9696, 16.1616, 96.9696, 25.3968, 87.7344, 34.6320, GAMGI_IO_STROKE,

41.5584, 94.6608, 27.7056, 99.2784, 13.8528, 85.4256, 18.4704, 71.5728, 32.3232, 66.9552, 46.1760, 80.8080, 41.5584, 94.6608, GAMGI_IO_STROKE,

36.9408, 99.2784, 18.4704, 94.6608, 13.8528, 76.1904, GAMGI_IO_STROKE,

23.0880, 66.9552, 41.5584, 71.5728, 46.1760, 90.0432, GAMGI_IO_STROKE,

92.3520, 30.0144, 78.4992, 34.6320, 64.6464, 20.7792, 69.2640, 6.9264, 83.1168, 2.3088, 96.9696, 16.1616, 92.3520, 30.0144, GAMGI_IO_STROKE,

87.7344, 34.6320, 69.2640, 30.0144, 64.6464, 11.5440, GAMGI_IO_STROKE,

73.8816, 2.3088, 92.3520, 6.9264, 96.9696, 25.3968, GAMGI_IO_STROKE,

9.2352, 2.3088, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 38 & strokes: 8 *
 *************************/

101.5872, 57.7200, 101.5872, 62.3376, 96.9696, 62.3376, 96.9696, 53.1024, 106.2048, 53.1024, 106.2048, 62.3376, 101.5872, 66.9552, 96.9696, 66.9552, 92.3520, 62.3376, 87.7344, 53.1024, 78.4992, 30.0144, 69.2640, 16.1616, 60.0288, 6.9264, 50.7936, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, 18.4704, 16.1616, 18.4704, 30.0144, 23.0880, 39.2496, 50.7936, 57.7200, 60.0288, 66.9552, 64.6464, 76.1904, 64.6464, 85.4256, 60.0288, 94.6608, 50.7936, 99.2784, 41.5584, 94.6608, 36.9408, 85.4256, 36.9408, 71.5728, 41.5584, 57.7200, 50.7936, 43.8672, 69.2640, 20.7792, 83.1168, 6.9264, 92.3520, 2.3088, 101.5872, 2.3088, 106.2048, 11.5440, 106.2048, 16.1616, GAMGI_IO_STROKE,

27.7056, 6.9264, 23.0880, 16.1616, 23.0880, 30.0144, 27.7056, 39.2496, 32.3232, 43.8672, GAMGI_IO_STROKE,

60.0288, 66.9552, 64.6464, 85.4256, GAMGI_IO_STROKE,

64.6464, 76.1904, 60.0288, 94.6608, GAMGI_IO_STROKE,

41.5584, 94.6608, 36.9408, 76.1904, GAMGI_IO_STROKE,

41.5584, 62.3376, 50.7936, 48.4848, 69.2640, 25.3968, 83.1168, 11.5440, 92.3520, 6.9264, GAMGI_IO_STROKE,

41.5584, 2.3088, 32.3232, 6.9264, 27.7056, 16.1616, 27.7056, 30.0144, 32.3232, 39.2496, 50.7936, 57.7200, GAMGI_IO_STROKE,

36.9408, 85.4256, 41.5584, 66.9552, 55.4112, 48.4848, 73.8816, 25.3968, 87.7344, 11.5440, 96.9696, 6.9264, 101.5872, 6.9264, 106.2048, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 39 ' strokes: 4 *
 *************************/

32.3232, 90.0432, 27.7056, 85.4256, 23.0880, 85.4256, 18.4704, 90.0432, 18.4704, 94.6608, 23.0880, 99.2784, 27.7056, 99.2784, 32.3232, 94.6608, 32.3232, 80.8080, 27.7056, 71.5728, 18.4704, 66.9552, GAMGI_IO_STROKE,

23.0880, 94.6608, 23.0880, 90.0432, 27.7056, 90.0432, 27.7056, 94.6608, 23.0880, 94.6608, GAMGI_IO_STROKE,

27.7056, 85.4256, 32.3232, 80.8080, GAMGI_IO_STROKE,

32.3232, 90.0432, 27.7056, 71.5728, GAMGI_IO_CHAR,

/*************************
 * char: 40 ( strokes: 3 *
 *************************/

46.1760, 117.7488, 36.9408, 108.5136, 27.7056, 94.6608, 18.4704, 76.1904, 13.8528, 53.1024, 13.8528, 34.6320, 18.4704, 11.5440, 27.7056, -6.9264, 36.9408, -20.7792, 46.1760, -30.0144, GAMGI_IO_STROKE,

27.7056, 90.0432, 23.0880, 76.1904, 18.4704, 57.7200, 18.4704, 30.0144, 23.0880, 11.5440, 27.7056, -2.3088, GAMGI_IO_STROKE,

36.9408, 108.5136, 32.3232, 99.2784, 27.7056, 85.4256, 23.0880, 57.7200, 23.0880, 30.0144, 27.7056, 2.3088, 32.3232, -11.5440, 36.9408, -20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 41 ) strokes: 3 *
 *************************/

18.4704, 117.7488, 27.7056, 108.5136, 36.9408, 94.6608, 46.1760, 76.1904, 50.7936, 53.1024, 50.7936, 34.6320, 46.1760, 11.5440, 36.9408, -6.9264, 27.7056, -20.7792, 18.4704, -30.0144, GAMGI_IO_STROKE,

36.9408, 90.0432, 41.5584, 76.1904, 46.1760, 57.7200, 46.1760, 30.0144, 41.5584, 11.5440, 36.9408, -2.3088, GAMGI_IO_STROKE,

27.7056, 108.5136, 32.3232, 99.2784, 36.9408, 85.4256, 41.5584, 57.7200, 41.5584, 30.0144, 36.9408, 2.3088, 32.3232, -11.5440, 27.7056, -20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 42 * strokes: 9 *
 *************************/

36.9408, 99.2784, 32.3232, 94.6608, 41.5584, 48.4848, 36.9408, 43.8672, GAMGI_IO_STROKE,

36.9408, 99.2784, 36.9408, 43.8672, GAMGI_IO_STROKE,

36.9408, 99.2784, 41.5584, 94.6608, 32.3232, 48.4848, 36.9408, 43.8672, GAMGI_IO_STROKE,

13.8528, 85.4256, 18.4704, 85.4256, 55.4112, 57.7200, 60.0288, 57.7200, GAMGI_IO_STROKE,

13.8528, 85.4256, 60.0288, 57.7200, GAMGI_IO_STROKE,

13.8528, 85.4256, 13.8528, 80.8080, 60.0288, 62.3376, 60.0288, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 55.4112, 85.4256, 18.4704, 57.7200, 13.8528, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 13.8528, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 60.0288, 80.8080, 13.8528, 62.3376, 13.8528, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 43 + strokes: 4 *
 *************************/

55.4112, 85.4256, 55.4112, 6.9264, 60.0288, 6.9264, GAMGI_IO_STROKE,

55.4112, 85.4256, 60.0288, 85.4256, 60.0288, 6.9264, GAMGI_IO_STROKE,

18.4704, 48.4848, 96.9696, 48.4848, 96.9696, 43.8672, GAMGI_IO_STROKE,

18.4704, 48.4848, 18.4704, 43.8672, 96.9696, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 44 , strokes: 4 *
 *************************/

32.3232, 6.9264, 27.7056, 2.3088, 23.0880, 2.3088, 18.4704, 6.9264, 18.4704, 11.5440, 23.0880, 16.1616, 27.7056, 16.1616, 32.3232, 11.5440, 32.3232, -2.3088, 27.7056, -11.5440, 18.4704, -16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_STROKE,

27.7056, 2.3088, 32.3232, -2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 27.7056, -11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 45 - strokes: 2 *
 *************************/

18.4704, 48.4848, 96.9696, 48.4848, 96.9696, 43.8672, GAMGI_IO_STROKE,

18.4704, 48.4848, 18.4704, 43.8672, 96.9696, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 46 . strokes: 2 *
 *************************/

23.0880, 16.1616, 18.4704, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 2.3088, 32.3232, 6.9264, 32.3232, 11.5440, 27.7056, 16.1616, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 47 / strokes: 2 *
 *************************/

92.3520, 117.7488, 9.2352, -30.0144, 13.8528, -30.0144, GAMGI_IO_STROKE,

92.3520, 117.7488, 96.9696, 117.7488, 13.8528, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 48 0 strokes: 5 *
 *************************/

41.5584, 99.2784, 27.7056, 94.6608, 18.4704, 80.8080, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 20.7792, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 20.7792, 78.4992, 43.8672, 78.4992, 57.7200, 73.8816, 80.8080, 64.6464, 94.6608, 50.7936, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

27.7056, 90.0432, 23.0880, 80.8080, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 20.7792, 27.7056, 11.5440, GAMGI_IO_STROKE,

64.6464, 11.5440, 69.2640, 20.7792, 73.8816, 39.2496, 73.8816, 62.3376, 69.2640, 80.8080, 64.6464, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, 27.7056, 85.4256, 23.0880, 62.3376, 23.0880, 39.2496, 27.7056, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 16.1616, 69.2640, 39.2496, 69.2640, 62.3376, 64.6464, 85.4256, 60.0288, 94.6608, 50.7936, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 49 1 strokes: 9 *
 *************************/

41.5584, 90.0432, 41.5584, 2.3088, GAMGI_IO_STROKE,

46.1760, 90.0432, 46.1760, 6.9264, GAMGI_IO_STROKE,

50.7936, 99.2784, 50.7936, 2.3088, GAMGI_IO_STROKE,

50.7936, 99.2784, 36.9408, 85.4256, 27.7056, 80.8080, GAMGI_IO_STROKE,

23.0880, 2.3088, 69.2640, 2.3088, GAMGI_IO_STROKE,

41.5584, 6.9264, 32.3232, 2.3088, GAMGI_IO_STROKE,

41.5584, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

50.7936, 11.5440, 55.4112, 2.3088, GAMGI_IO_STROKE,

50.7936, 6.9264, 60.0288, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 50 2 strokes: 7 *
 *************************/

18.4704, 80.8080, 18.4704, 76.1904, 23.0880, 76.1904, 23.0880, 80.8080, 18.4704, 80.8080, GAMGI_IO_STROKE,

18.4704, 85.4256, 23.0880, 85.4256, 27.7056, 80.8080, 27.7056, 76.1904, 23.0880, 71.5728, 18.4704, 71.5728, 13.8528, 76.1904, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 36.9408, 99.2784, 55.4112, 99.2784, 69.2640, 94.6608, 73.8816, 90.0432, 78.4992, 80.8080, 78.4992, 71.5728, 73.8816, 62.3376, 60.0288, 53.1024, 36.9408, 43.8672, 27.7056, 39.2496, 18.4704, 30.0144, 13.8528, 16.1616, 13.8528, 2.3088, GAMGI_IO_STROKE,

69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 71.5728, 69.2640, 62.3376, GAMGI_IO_STROKE,

55.4112, 99.2784, 64.6464, 94.6608, 69.2640, 80.8080, 69.2640, 71.5728, 64.6464, 62.3376, 55.4112, 53.1024, 36.9408, 43.8672, GAMGI_IO_STROKE,

13.8528, 11.5440, 18.4704, 16.1616, 27.7056, 16.1616, 50.7936, 11.5440, 69.2640, 11.5440, 78.4992, 16.1616, GAMGI_IO_STROKE,

27.7056, 16.1616, 50.7936, 6.9264, 69.2640, 6.9264, 73.8816, 11.5440, GAMGI_IO_STROKE,

27.7056, 16.1616, 50.7936, 2.3088, 69.2640, 2.3088, 73.8816, 6.9264, 78.4992, 16.1616, 78.4992, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 51 3 strokes: 8 *
 *************************/

18.4704, 80.8080, 18.4704, 76.1904, 23.0880, 76.1904, 23.0880, 80.8080, 18.4704, 80.8080, GAMGI_IO_STROKE,

18.4704, 85.4256, 23.0880, 85.4256, 27.7056, 80.8080, 27.7056, 76.1904, 23.0880, 71.5728, 18.4704, 71.5728, 13.8528, 76.1904, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 36.9408, 99.2784, 55.4112, 99.2784, 69.2640, 94.6608, 73.8816, 85.4256, 73.8816, 71.5728, 69.2640, 62.3376, 55.4112, 57.7200, GAMGI_IO_STROKE,

64.6464, 94.6608, 69.2640, 85.4256, 69.2640, 71.5728, 64.6464, 62.3376, GAMGI_IO_STROKE,

50.7936, 99.2784, 60.0288, 94.6608, 64.6464, 85.4256, 64.6464, 71.5728, 60.0288, 62.3376, 50.7936, 57.7200, GAMGI_IO_STROKE,

41.5584, 57.7200, 55.4112, 57.7200, 64.6464, 53.1024, 73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 20.7792, 73.8816, 11.5440, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 25.3968, 18.4704, 30.0144, 23.0880, 30.0144, 27.7056, 25.3968, 27.7056, 20.7792, 23.0880, 16.1616, 18.4704, 16.1616, GAMGI_IO_STROKE,

69.2640, 43.8672, 73.8816, 34.6320, 73.8816, 20.7792, 69.2640, 11.5440, GAMGI_IO_STROKE,

50.7936, 57.7200, 60.0288, 53.1024, 64.6464, 48.4848, 69.2640, 34.6320, 69.2640, 20.7792, 64.6464, 6.9264, 55.4112, 2.3088, GAMGI_IO_STROKE,

18.4704, 25.3968, 18.4704, 20.7792, 23.0880, 20.7792, 23.0880, 25.3968, 18.4704, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 52 4 strokes: 9 *
 *************************/

50.7936, 85.4256, 50.7936, 2.3088, GAMGI_IO_STROKE,

55.4112, 90.0432, 55.4112, 6.9264, GAMGI_IO_STROKE,

60.0288, 99.2784, 60.0288, 2.3088, GAMGI_IO_STROKE,

60.0288, 99.2784, 9.2352, 30.0144, 83.1168, 30.0144, GAMGI_IO_STROKE,

36.9408, 2.3088, 73.8816, 2.3088, GAMGI_IO_STROKE,

50.7936, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 11.5440, 46.1760, 2.3088, GAMGI_IO_STROKE,

60.0288, 11.5440, 64.6464, 2.3088, GAMGI_IO_STROKE,

60.0288, 6.9264, 69.2640, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 53 5 strokes: 7 *
 *************************/

23.0880, 99.2784, 13.8528, 53.1024, 23.0880, 62.3376, 36.9408, 66.9552, 50.7936, 66.9552, 64.6464, 62.3376, 73.8816, 53.1024, 78.4992, 39.2496, 78.4992, 30.0144, 73.8816, 16.1616, 64.6464, 6.9264, 50.7936, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 25.3968, 18.4704, 30.0144, 23.0880, 30.0144, 27.7056, 25.3968, 27.7056, 20.7792, 23.0880, 16.1616, 18.4704, 16.1616, GAMGI_IO_STROKE,

69.2640, 53.1024, 73.8816, 43.8672, 73.8816, 25.3968, 69.2640, 16.1616, GAMGI_IO_STROKE,

50.7936, 66.9552, 60.0288, 62.3376, 64.6464, 57.7200, 69.2640, 43.8672, 69.2640, 25.3968, 64.6464, 11.5440, 60.0288, 6.9264, 50.7936, 2.3088, GAMGI_IO_STROKE,

18.4704, 25.3968, 18.4704, 20.7792, 23.0880, 20.7792, 23.0880, 25.3968, 18.4704, 25.3968, GAMGI_IO_STROKE,

23.0880, 99.2784, 69.2640, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 60.0288, 94.6608, GAMGI_IO_STROKE,

23.0880, 90.0432, 41.5584, 90.0432, 60.0288, 94.6608, 69.2640, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 54 6 strokes: 6 *
 *************************/

64.6464, 85.4256, 64.6464, 80.8080, 69.2640, 80.8080, 69.2640, 85.4256, 64.6464, 85.4256, GAMGI_IO_STROKE,

69.2640, 90.0432, 64.6464, 90.0432, 60.0288, 85.4256, 60.0288, 80.8080, 64.6464, 76.1904, 69.2640, 76.1904, 73.8816, 80.8080, 73.8816, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 57.7200, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 30.0144, 78.4992, 34.6320, 73.8816, 48.4848, 64.6464, 57.7200, 50.7936, 62.3376, 41.5584, 62.3376, 32.3232, 57.7200, 27.7056, 53.1024, 23.0880, 43.8672, GAMGI_IO_STROKE,

27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 57.7200, 18.4704, 30.0144, 23.0880, 16.1616, 27.7056, 11.5440, GAMGI_IO_STROKE,

69.2640, 16.1616, 73.8816, 25.3968, 73.8816, 39.2496, 69.2640, 48.4848, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 32.3232, 90.0432, 27.7056, 80.8080, 23.0880, 62.3376, 23.0880, 30.0144, 27.7056, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 11.5440, 69.2640, 25.3968, 69.2640, 39.2496, 64.6464, 53.1024, 60.0288, 57.7200, 50.7936, 62.3376, GAMGI_IO_CHAR,

/*************************
 * char: 55 7 strokes: 7 *
 *************************/

13.8528, 99.2784, 13.8528, 71.5728, GAMGI_IO_STROKE,

78.4992, 99.2784, 78.4992, 85.4256, 73.8816, 71.5728, 55.4112, 48.4848, 50.7936, 39.2496, 46.1760, 20.7792, 46.1760, 2.3088, GAMGI_IO_STROKE,

50.7936, 43.8672, 46.1760, 34.6320, 41.5584, 20.7792, 41.5584, 2.3088, GAMGI_IO_STROKE,

73.8816, 71.5728, 50.7936, 48.4848, 41.5584, 34.6320, 36.9408, 20.7792, 36.9408, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

13.8528, 80.8080, 18.4704, 90.0432, 27.7056, 99.2784, 36.9408, 99.2784, 60.0288, 85.4256, 69.2640, 85.4256, 73.8816, 90.0432, 78.4992, 99.2784, GAMGI_IO_STROKE,

23.0880, 90.0432, 27.7056, 94.6608, 36.9408, 94.6608, 46.1760, 90.0432, GAMGI_IO_STROKE,

13.8528, 80.8080, 18.4704, 85.4256, 27.7056, 90.0432, 36.9408, 90.0432, 60.0288, 85.4256, GAMGI_IO_CHAR,

/*************************
 * char: 56 8 strokes: 10 *
 *************************/

36.9408, 99.2784, 23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 71.5728, 23.0880, 62.3376, 36.9408, 57.7200, 55.4112, 57.7200, 69.2640, 62.3376, 73.8816, 71.5728, 73.8816, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, GAMGI_IO_STROKE,

27.7056, 94.6608, 23.0880, 85.4256, 23.0880, 71.5728, 27.7056, 62.3376, GAMGI_IO_STROKE,

64.6464, 62.3376, 69.2640, 71.5728, 69.2640, 85.4256, 64.6464, 94.6608, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 94.6608, 27.7056, 85.4256, 27.7056, 71.5728, 32.3232, 62.3376, 36.9408, 57.7200, GAMGI_IO_STROKE,

55.4112, 57.7200, 60.0288, 62.3376, 64.6464, 71.5728, 64.6464, 85.4256, 60.0288, 94.6608, 55.4112, 99.2784, GAMGI_IO_STROKE,

36.9408, 57.7200, 23.0880, 53.1024, 18.4704, 48.4848, 13.8528, 39.2496, 13.8528, 20.7792, 18.4704, 11.5440, 23.0880, 6.9264, 36.9408, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 73.8816, 11.5440, 78.4992, 20.7792, 78.4992, 39.2496, 73.8816, 48.4848, 69.2640, 53.1024, 55.4112, 57.7200, GAMGI_IO_STROKE,

23.0880, 48.4848, 18.4704, 39.2496, 18.4704, 20.7792, 23.0880, 11.5440, GAMGI_IO_STROKE,

69.2640, 11.5440, 73.8816, 20.7792, 73.8816, 39.2496, 69.2640, 48.4848, GAMGI_IO_STROKE,

36.9408, 57.7200, 27.7056, 53.1024, 23.0880, 39.2496, 23.0880, 20.7792, 27.7056, 6.9264, 36.9408, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 64.6464, 6.9264, 69.2640, 20.7792, 69.2640, 39.2496, 64.6464, 53.1024, 55.4112, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 57 9 strokes: 6 *
 *************************/

23.0880, 20.7792, 23.0880, 16.1616, 27.7056, 16.1616, 27.7056, 20.7792, 23.0880, 20.7792, GAMGI_IO_STROKE,

69.2640, 57.7200, 64.6464, 48.4848, 60.0288, 43.8672, 50.7936, 39.2496, 41.5584, 39.2496, 27.7056, 43.8672, 18.4704, 53.1024, 13.8528, 66.9552, 13.8528, 71.5728, 18.4704, 85.4256, 27.7056, 94.6608, 41.5584, 99.2784, 50.7936, 99.2784, 64.6464, 94.6608, 73.8816, 85.4256, 78.4992, 71.5728, 78.4992, 43.8672, 73.8816, 25.3968, 69.2640, 16.1616, 60.0288, 6.9264, 46.1760, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, 18.4704, 16.1616, 18.4704, 20.7792, 23.0880, 25.3968, 27.7056, 25.3968, 32.3232, 20.7792, 32.3232, 16.1616, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_STROKE,

23.0880, 53.1024, 18.4704, 62.3376, 18.4704, 76.1904, 23.0880, 85.4256, GAMGI_IO_STROKE,

64.6464, 90.0432, 69.2640, 85.4256, 73.8816, 71.5728, 73.8816, 43.8672, 69.2640, 25.3968, 64.6464, 16.1616, GAMGI_IO_STROKE,

41.5584, 39.2496, 32.3232, 43.8672, 27.7056, 48.4848, 23.0880, 62.3376, 23.0880, 76.1904, 27.7056, 90.0432, 32.3232, 94.6608, 41.5584, 99.2784, GAMGI_IO_STROKE,

50.7936, 99.2784, 60.0288, 94.6608, 64.6464, 85.4256, 69.2640, 71.5728, 69.2640, 39.2496, 64.6464, 20.7792, 60.0288, 11.5440, 55.4112, 6.9264, 46.1760, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 58 : strokes: 4 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 18.4704, 57.7200, 23.0880, 53.1024, 27.7056, 53.1024, 32.3232, 57.7200, 32.3232, 62.3376, 27.7056, 66.9552, 23.0880, 66.9552, GAMGI_IO_STROKE,

23.0880, 62.3376, 23.0880, 57.7200, 27.7056, 57.7200, 27.7056, 62.3376, 23.0880, 62.3376, GAMGI_IO_STROKE,

23.0880, 16.1616, 18.4704, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 2.3088, 32.3232, 6.9264, 32.3232, 11.5440, 27.7056, 16.1616, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 59 ; strokes: 6 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 18.4704, 57.7200, 23.0880, 53.1024, 27.7056, 53.1024, 32.3232, 57.7200, 32.3232, 62.3376, 27.7056, 66.9552, 23.0880, 66.9552, GAMGI_IO_STROKE,

23.0880, 62.3376, 23.0880, 57.7200, 27.7056, 57.7200, 27.7056, 62.3376, 23.0880, 62.3376, GAMGI_IO_STROKE,

32.3232, 6.9264, 27.7056, 2.3088, 23.0880, 2.3088, 18.4704, 6.9264, 18.4704, 11.5440, 23.0880, 16.1616, 27.7056, 16.1616, 32.3232, 11.5440, 32.3232, -2.3088, 27.7056, -11.5440, 18.4704, -16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_STROKE,

27.7056, 2.3088, 32.3232, -2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 27.7056, -11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 60 < strokes: 2 *
 *************************/

92.3520, 85.4256, 18.4704, 43.8672, 92.3520, 2.3088, GAMGI_IO_STROKE,

92.3520, 85.4256, 92.3520, 80.8080, 27.7056, 43.8672, 92.3520, 6.9264, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 61 = strokes: 4 *
 *************************/

18.4704, 66.9552, 96.9696, 66.9552, 96.9696, 62.3376, GAMGI_IO_STROKE,

18.4704, 66.9552, 18.4704, 62.3376, 96.9696, 62.3376, GAMGI_IO_STROKE,

18.4704, 30.0144, 96.9696, 30.0144, 96.9696, 25.3968, GAMGI_IO_STROKE,

18.4704, 30.0144, 18.4704, 25.3968, 96.9696, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 62 > strokes: 2 *
 *************************/

18.4704, 85.4256, 92.3520, 43.8672, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 85.4256, 18.4704, 80.8080, 83.1168, 43.8672, 18.4704, 6.9264, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 63 ? strokes: 6 *
 *************************/

18.4704, 76.1904, 18.4704, 80.8080, 23.0880, 80.8080, 23.0880, 71.5728, 13.8528, 71.5728, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 32.3232, 99.2784, 50.7936, 99.2784, 64.6464, 94.6608, 69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 71.5728, 69.2640, 62.3376, 64.6464, 57.7200, 46.1760, 48.4848, GAMGI_IO_STROKE,

64.6464, 90.0432, 69.2640, 85.4256, 69.2640, 66.9552, 64.6464, 62.3376, GAMGI_IO_STROKE,

50.7936, 99.2784, 60.0288, 94.6608, 64.6464, 85.4256, 64.6464, 66.9552, 60.0288, 57.7200, 55.4112, 53.1024, GAMGI_IO_STROKE,

41.5584, 48.4848, 41.5584, 34.6320, 46.1760, 34.6320, 46.1760, 48.4848, 41.5584, 48.4848, GAMGI_IO_STROKE,

41.5584, 16.1616, 36.9408, 11.5440, 36.9408, 6.9264, 41.5584, 2.3088, 46.1760, 2.3088, 50.7936, 6.9264, 50.7936, 11.5440, 46.1760, 16.1616, 41.5584, 16.1616, GAMGI_IO_STROKE,

41.5584, 11.5440, 41.5584, 6.9264, 46.1760, 6.9264, 46.1760, 11.5440, 41.5584, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 64 @ strokes: 6 *
 *************************/

78.4992, 62.3376, 73.8816, 71.5728, 64.6464, 76.1904, 55.4112, 76.1904, 46.1760, 71.5728, 41.5584, 66.9552, 36.9408, 57.7200, 36.9408, 43.8672, 41.5584, 34.6320, 46.1760, 30.0144, 55.4112, 25.3968, 64.6464, 25.3968, 73.8816, 30.0144, 78.4992, 39.2496, GAMGI_IO_STROKE,

46.1760, 66.9552, 41.5584, 57.7200, 41.5584, 43.8672, 46.1760, 34.6320, GAMGI_IO_STROKE,

55.4112, 76.1904, 50.7936, 71.5728, 46.1760, 57.7200, 46.1760, 43.8672, 50.7936, 30.0144, 55.4112, 25.3968, GAMGI_IO_STROKE,

78.4992, 76.1904, 78.4992, 39.2496, 83.1168, 30.0144, 92.3520, 25.3968, 96.9696, 25.3968, 106.2048, 30.0144, 110.8224, 43.8672, 110.8224, 57.7200, 106.2048, 71.5728, 101.5872, 80.8080, 92.3520, 90.0432, 83.1168, 94.6608, 69.2640, 99.2784, 55.4112, 99.2784, 41.5584, 94.6608, 32.3232, 90.0432, 23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 55.4112, 2.3088, 69.2640, 2.3088, 83.1168, 6.9264, 92.3520, 11.5440, 87.7344, 11.5440, 83.1168, 6.9264, GAMGI_IO_STROKE,

83.1168, 71.5728, 83.1168, 39.2496, 87.7344, 30.0144, GAMGI_IO_STROKE,

78.4992, 76.1904, 87.7344, 76.1904, 87.7344, 39.2496, 92.3520, 30.0144, 96.9696, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 65 A strokes: 9 *
 *************************/

13.8528, 90.0432, 18.4704, 85.4256, 13.8528, 80.8080, 9.2352, 85.4256, 13.8528, 94.6608, 23.0880, 99.2784, 32.3232, 99.2784, 41.5584, 94.6608, 46.1760, 90.0432, 50.7936, 76.1904, 50.7936, 57.7200, 46.1760, 43.8672, 36.9408, 34.6320, 27.7056, 30.0144, 13.8528, 25.3968, GAMGI_IO_STROKE,

41.5584, 90.0432, 46.1760, 76.1904, 46.1760, 53.1024, 41.5584, 43.8672, GAMGI_IO_STROKE,

32.3232, 99.2784, 36.9408, 94.6608, 41.5584, 80.8080, 41.5584, 53.1024, 36.9408, 39.2496, 27.7056, 30.0144, GAMGI_IO_STROKE,

27.7056, 25.3968, 41.5584, 11.5440, GAMGI_IO_STROKE,

23.0880, 25.3968, 41.5584, 6.9264, GAMGI_IO_STROKE,

13.8528, 25.3968, 36.9408, 2.3088, 69.2640, 25.3968, GAMGI_IO_STROKE,

101.5872, 94.6608, 96.9696, 90.0432, 101.5872, 90.0432, 101.5872, 94.6608, 96.9696, 99.2784, 87.7344, 99.2784, 78.4992, 94.6608, 73.8816, 90.0432, 69.2640, 80.8080, 69.2640, 11.5440, 78.4992, 2.3088, 96.9696, 20.7792, GAMGI_IO_STROKE,

78.4992, 90.0432, 73.8816, 80.8080, 73.8816, 16.1616, 83.1168, 6.9264, GAMGI_IO_STROKE,

87.7344, 99.2784, 83.1168, 94.6608, 78.4992, 80.8080, 78.4992, 20.7792, 87.7344, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 66 B strokes: 14 *
 *************************/

9.2352, 48.4848, 9.2352, 43.8672, 13.8528, 39.2496, 23.0880, 39.2496, 32.3232, 43.8672, 32.3232, 57.7200, 27.7056, 66.9552, 18.4704, 80.8080, 18.4704, 90.0432, 27.7056, 99.2784, GAMGI_IO_STROKE,

27.7056, 57.7200, 18.4704, 76.1904, GAMGI_IO_STROKE,

23.0880, 39.2496, 27.7056, 43.8672, 27.7056, 53.1024, 18.4704, 66.9552, 13.8528, 76.1904, 13.8528, 85.4256, 18.4704, 94.6608, 27.7056, 99.2784, 41.5584, 99.2784, 50.7936, 94.6608, 55.4112, 90.0432, 60.0288, 80.8080, 60.0288, 43.8672, 55.4112, 30.0144, 46.1760, 20.7792, GAMGI_IO_STROKE,

50.7936, 90.0432, 55.4112, 80.8080, 55.4112, 34.6320, GAMGI_IO_STROKE,

41.5584, 99.2784, 46.1760, 94.6608, 50.7936, 80.8080, 50.7936, 30.0144, 46.1760, 20.7792, GAMGI_IO_STROKE,

60.0288, 85.4256, 64.6464, 94.6608, 73.8816, 99.2784, 83.1168, 99.2784, 92.3520, 94.6608, 96.9696, 90.0432, 101.5872, 80.8080, 106.2048, 76.1904, GAMGI_IO_STROKE,

92.3520, 90.0432, 96.9696, 80.8080, GAMGI_IO_STROKE,

83.1168, 99.2784, 87.7344, 94.6608, 92.3520, 80.8080, 96.9696, 76.1904, 106.2048, 76.1904, GAMGI_IO_STROKE,

106.2048, 76.1904, 60.0288, 53.1024, GAMGI_IO_STROKE,

92.3520, 66.9552, 101.5872, 57.7200, 106.2048, 43.8672, 106.2048, 30.0144, 101.5872, 16.1616, 92.3520, 6.9264, 78.4992, 2.3088, 64.6464, 2.3088, 50.7936, 6.9264, 23.0880, 20.7792, 18.4704, 20.7792, 13.8528, 16.1616, GAMGI_IO_STROKE,

87.7344, 62.3376, 92.3520, 62.3376, 101.5872, 53.1024, GAMGI_IO_STROKE,

78.4992, 62.3376, 92.3520, 57.7200, 101.5872, 48.4848, 106.2048, 39.2496, GAMGI_IO_STROKE,

69.2640, 6.9264, 60.0288, 6.9264, 32.3232, 20.7792, 27.7056, 20.7792, GAMGI_IO_STROKE,

96.9696, 11.5440, 87.7344, 6.9264, 73.8816, 6.9264, 60.0288, 11.5440, 41.5584, 20.7792, 27.7056, 25.3968, 18.4704, 25.3968, 13.8528, 16.1616, 13.8528, 6.9264, 18.4704, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 67 C strokes: 9 *
 *************************/

55.4112, 90.0432, 46.1760, 99.2784, 36.9408, 99.2784, 27.7056, 94.6608, 18.4704, 80.8080, 13.8528, 62.3376, 13.8528, 43.8672, 18.4704, 25.3968, 27.7056, 11.5440, 36.9408, 6.9264, 50.7936, 2.3088, 64.6464, 2.3088, 78.4992, 6.9264, 87.7344, 11.5440, 96.9696, 20.7792, GAMGI_IO_STROKE,

27.7056, 90.0432, 23.0880, 80.8080, 18.4704, 66.9552, 18.4704, 43.8672, 23.0880, 25.3968, 32.3232, 11.5440, 46.1760, 6.9264, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 94.6608, 27.7056, 85.4256, 23.0880, 66.9552, 23.0880, 48.4848, 27.7056, 30.0144, 32.3232, 20.7792, 41.5584, 11.5440, 55.4112, 6.9264, 69.2640, 6.9264, 83.1168, 11.5440, 96.9696, 20.7792, GAMGI_IO_STROKE,

69.2640, 99.2784, 55.4112, 90.0432, 50.7936, 85.4256, 46.1760, 76.1904, 46.1760, 71.5728, 50.7936, 62.3376, 64.6464, 53.1024, 69.2640, 43.8672, 69.2640, 34.6320, GAMGI_IO_STROKE,

50.7936, 76.1904, 50.7936, 71.5728, 69.2640, 53.1024, 69.2640, 48.4848, GAMGI_IO_STROKE,

50.7936, 85.4256, 50.7936, 80.8080, 55.4112, 71.5728, 69.2640, 62.3376, 73.8816, 53.1024, 73.8816, 43.8672, 69.2640, 34.6320, 60.0288, 30.0144, 55.4112, 30.0144, 46.1760, 34.6320, 41.5584, 43.8672, GAMGI_IO_STROKE,

69.2640, 99.2784, 73.8816, 94.6608, 83.1168, 90.0432, 92.3520, 90.0432, GAMGI_IO_STROKE,

69.2640, 94.6608, 73.8816, 90.0432, 78.4992, 90.0432, GAMGI_IO_STROKE,

64.6464, 94.6608, 73.8816, 85.4256, 83.1168, 85.4256, 92.3520, 90.0432, 96.9696, 94.6608, GAMGI_IO_CHAR,

/*************************
 * char: 68 D strokes: 8 *
 *************************/

13.8528, 71.5728, 13.8528, 76.1904, 18.4704, 85.4256, 27.7056, 94.6608, 41.5584, 99.2784, 60.0288, 99.2784, 73.8816, 94.6608, 83.1168, 90.0432, 92.3520, 80.8080, 101.5872, 66.9552, 106.2048, 48.4848, 106.2048, 30.0144, 101.5872, 16.1616, 92.3520, 6.9264, 78.4992, 2.3088, 64.6464, 2.3088, 50.7936, 6.9264, 23.0880, 20.7792, 18.4704, 20.7792, 13.8528, 16.1616, GAMGI_IO_STROKE,

27.7056, 90.0432, 36.9408, 94.6608, 60.0288, 94.6608, 73.8816, 90.0432, 83.1168, 85.4256, 92.3520, 76.1904, 101.5872, 62.3376, GAMGI_IO_STROKE,

69.2640, 6.9264, 60.0288, 6.9264, 32.3232, 20.7792, 27.7056, 20.7792, GAMGI_IO_STROKE,

13.8528, 76.1904, 23.0880, 85.4256, 36.9408, 90.0432, 60.0288, 90.0432, 73.8816, 85.4256, 83.1168, 80.8080, 92.3520, 71.5728, 101.5872, 57.7200, 106.2048, 43.8672, GAMGI_IO_STROKE,

96.9696, 11.5440, 87.7344, 6.9264, 73.8816, 6.9264, 60.0288, 11.5440, 41.5584, 20.7792, 27.7056, 25.3968, 18.4704, 25.3968, 13.8528, 16.1616, 13.8528, 6.9264, 18.4704, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, GAMGI_IO_STROKE,

50.7936, 90.0432, 36.9408, 76.1904, 32.3232, 66.9552, 32.3232, 57.7200, 41.5584, 39.2496, 41.5584, 30.0144, GAMGI_IO_STROKE,

36.9408, 62.3376, 36.9408, 57.7200, 41.5584, 48.4848, 41.5584, 43.8672, GAMGI_IO_STROKE,

36.9408, 76.1904, 36.9408, 66.9552, 46.1760, 48.4848, 46.1760, 39.2496, 41.5584, 30.0144, 36.9408, 25.3968, 27.7056, 25.3968, 23.0880, 30.0144, 23.0880, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 69 E strokes: 13 *
 *************************/

55.4112, 90.0432, 46.1760, 99.2784, 36.9408, 99.2784, 27.7056, 94.6608, 18.4704, 80.8080, 13.8528, 62.3376, 13.8528, 43.8672, 18.4704, 25.3968, 27.7056, 11.5440, 36.9408, 6.9264, 50.7936, 2.3088, 64.6464, 2.3088, 78.4992, 6.9264, 87.7344, 11.5440, 96.9696, 20.7792, GAMGI_IO_STROKE,

27.7056, 90.0432, 23.0880, 80.8080, 18.4704, 66.9552, 18.4704, 43.8672, 23.0880, 25.3968, 32.3232, 11.5440, 46.1760, 6.9264, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 94.6608, 27.7056, 85.4256, 23.0880, 66.9552, 23.0880, 48.4848, 27.7056, 30.0144, 32.3232, 20.7792, 41.5584, 11.5440, 55.4112, 6.9264, 69.2640, 6.9264, 83.1168, 11.5440, 96.9696, 20.7792, GAMGI_IO_STROKE,

69.2640, 99.2784, 55.4112, 90.0432, 50.7936, 85.4256, 46.1760, 76.1904, 46.1760, 71.5728, 50.7936, 62.3376, 64.6464, 53.1024, 69.2640, 43.8672, 69.2640, 34.6320, GAMGI_IO_STROKE,

50.7936, 76.1904, 50.7936, 71.5728, 69.2640, 53.1024, 69.2640, 48.4848, GAMGI_IO_STROKE,

50.7936, 85.4256, 50.7936, 80.8080, 55.4112, 71.5728, 69.2640, 62.3376, 73.8816, 53.1024, 73.8816, 43.8672, 69.2640, 34.6320, 60.0288, 30.0144, 55.4112, 30.0144, 46.1760, 34.6320, 41.5584, 43.8672, GAMGI_IO_STROKE,

69.2640, 99.2784, 73.8816, 94.6608, 83.1168, 90.0432, 92.3520, 90.0432, GAMGI_IO_STROKE,

69.2640, 94.6608, 73.8816, 90.0432, 78.4992, 90.0432, GAMGI_IO_STROKE,

64.6464, 94.6608, 73.8816, 85.4256, 83.1168, 85.4256, 92.3520, 90.0432, 96.9696, 94.6608, GAMGI_IO_STROKE,

69.2640, 62.3376, 87.7344, 76.1904, GAMGI_IO_STROKE,

87.7344, 76.1904, 92.3520, 71.5728, 101.5872, 71.5728, GAMGI_IO_STROKE,

83.1168, 71.5728, 87.7344, 66.9552, 92.3520, 66.9552, GAMGI_IO_STROKE,

78.4992, 66.9552, 83.1168, 62.3376, 92.3520, 62.3376, 101.5872, 71.5728, GAMGI_IO_CHAR,

/*************************
 * char: 70 F strokes: 12 *
 *************************/

32.3232, 62.3376, 23.0880, 66.9552, 18.4704, 76.1904, 18.4704, 85.4256, 23.0880, 94.6608, 36.9408, 99.2784, 50.7936, 99.2784, 64.6464, 94.6608, 83.1168, 85.4256, GAMGI_IO_STROKE,

23.0880, 90.0432, 32.3232, 94.6608, 55.4112, 94.6608, 69.2640, 90.0432, GAMGI_IO_STROKE,

18.4704, 76.1904, 23.0880, 85.4256, 32.3232, 90.0432, 55.4112, 90.0432, 83.1168, 85.4256, 92.3520, 85.4256, 96.9696, 90.0432, 96.9696, 94.6608, 92.3520, 99.2784, 87.7344, 99.2784, GAMGI_IO_STROKE,

60.0288, 90.0432, 55.4112, 85.4256, 50.7936, 76.1904, 50.7936, 66.9552, 55.4112, 57.7200, 73.8816, 39.2496, 78.4992, 25.3968, 78.4992, 11.5440, 73.8816, -2.3088, 69.2640, -6.9264, 60.0288, -11.5440, GAMGI_IO_STROKE,

64.6464, 53.1024, 78.4992, 39.2496, 83.1168, 25.3968, 83.1168, 11.5440, 78.4992, 2.3088, GAMGI_IO_STROKE,

50.7936, 66.9552, 60.0288, 57.7200, 73.8816, 48.4848, 83.1168, 39.2496, 87.7344, 25.3968, 87.7344, 11.5440, 83.1168, 2.3088, 73.8816, -6.9264, 60.0288, -11.5440, 41.5584, -11.5440, 27.7056, -6.9264, 23.0880, -2.3088, 18.4704, 6.9264, 18.4704, 20.7792, 27.7056, 34.6320, 27.7056, 43.8672, 23.0880, 48.4848, GAMGI_IO_STROKE,

27.7056, -2.3088, 23.0880, 2.3088, 23.0880, 20.7792, 27.7056, 30.0144, GAMGI_IO_STROKE,

41.5584, -11.5440, 32.3232, -6.9264, 27.7056, 2.3088, 27.7056, 20.7792, 32.3232, 34.6320, 32.3232, 43.8672, 27.7056, 48.4848, 18.4704, 48.4848, 13.8528, 43.8672, 13.8528, 39.2496, GAMGI_IO_STROKE,

69.2640, 53.1024, 87.7344, 71.5728, GAMGI_IO_STROKE,

87.7344, 71.5728, 92.3520, 66.9552, 101.5872, 66.9552, GAMGI_IO_STROKE,

83.1168, 66.9552, 87.7344, 62.3376, 92.3520, 62.3376, GAMGI_IO_STROKE,

78.4992, 62.3376, 83.1168, 57.7200, 92.3520, 57.7200, 101.5872, 66.9552, GAMGI_IO_CHAR,

/*************************
 * char: 71 G strokes: 12 *
 *************************/

73.8816, 80.8080, 69.2640, 90.0432, 64.6464, 94.6608, 55.4112, 99.2784, 41.5584, 99.2784, 27.7056, 94.6608, 18.4704, 80.8080, 13.8528, 62.3376, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 55.4112, 2.3088, 69.2640, 2.3088, 83.1168, 6.9264, 92.3520, 11.5440, 101.5872, 20.7792, 106.2048, 34.6320, 106.2048, 48.4848, 101.5872, 62.3376, 92.3520, 71.5728, GAMGI_IO_STROKE,

27.7056, 90.0432, 23.0880, 80.8080, 18.4704, 66.9552, 18.4704, 43.8672, 23.0880, 30.0144, 27.7056, 20.7792, GAMGI_IO_STROKE,

96.9696, 20.7792, 101.5872, 30.0144, 101.5872, 48.4848, 96.9696, 62.3376, 92.3520, 66.9552, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, 27.7056, 85.4256, 23.0880, 66.9552, 23.0880, 43.8672, 27.7056, 25.3968, 32.3232, 16.1616, 41.5584, 6.9264, GAMGI_IO_STROKE,

83.1168, 6.9264, 92.3520, 16.1616, 96.9696, 30.0144, 96.9696, 48.4848, 92.3520, 57.7200, 83.1168, 66.9552, GAMGI_IO_STROKE,

73.8816, 99.2784, 60.0288, 90.0432, 50.7936, 80.8080, 46.1760, 71.5728, 46.1760, 66.9552, 50.7936, 57.7200, 64.6464, 48.4848, 69.2640, 39.2496, 69.2640, 30.0144, GAMGI_IO_STROKE,

50.7936, 71.5728, 50.7936, 66.9552, 69.2640, 48.4848, 69.2640, 43.8672, GAMGI_IO_STROKE,

50.7936, 80.8080, 50.7936, 76.1904, 55.4112, 66.9552, 69.2640, 57.7200, 73.8816, 48.4848, 73.8816, 39.2496, 69.2640, 30.0144, 60.0288, 25.3968, 55.4112, 25.3968, 46.1760, 30.0144, 41.5584, 39.2496, GAMGI_IO_STROKE,

69.2640, 57.7200, 92.3520, 71.5728, 96.9696, 80.8080, GAMGI_IO_STROKE,

106.2048, 99.2784, 96.9696, 80.8080, GAMGI_IO_STROKE,

92.3520, 94.6608, 110.8224, 85.4256, GAMGI_IO_STROKE,

106.2048, 99.2784, 101.5872, 94.6608, 92.3520, 94.6608, 96.9696, 90.0432, 96.9696, 80.8080, 101.5872, 85.4256, 110.8224, 85.4256, 106.2048, 90.0432, 106.2048, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 72 H strokes: 13 *
 *************************/

55.4112, 99.2784, 46.1760, 94.6608, 36.9408, 85.4256, 32.3232, 76.1904, 32.3232, 66.9552, 36.9408, 57.7200, 46.1760, 48.4848, 50.7936, 39.2496, 50.7936, 30.0144, GAMGI_IO_STROKE,

36.9408, 71.5728, 36.9408, 66.9552, 50.7936, 48.4848, 50.7936, 43.8672, GAMGI_IO_STROKE,

36.9408, 85.4256, 36.9408, 76.1904, 41.5584, 66.9552, 50.7936, 57.7200, 55.4112, 48.4848, 55.4112, 39.2496, 50.7936, 30.0144, 46.1760, 25.3968, 36.9408, 20.7792, 27.7056, 20.7792, 18.4704, 25.3968, 13.8528, 30.0144, 9.2352, 39.2496, 9.2352, 48.4848, 13.8528, 53.1024, 18.4704, 48.4848, 13.8528, 43.8672, GAMGI_IO_STROKE,

55.4112, 99.2784, 64.6464, 90.0432, 73.8816, 90.0432, 83.1168, 94.6608, GAMGI_IO_STROKE,

50.7936, 94.6608, 60.0288, 90.0432, GAMGI_IO_STROKE,

46.1760, 94.6608, 50.7936, 90.0432, 60.0288, 85.4256, 69.2640, 85.4256, 83.1168, 94.6608, GAMGI_IO_STROKE,

55.4112, 53.1024, 87.7344, 76.1904, GAMGI_IO_STROKE,

87.7344, 76.1904, 96.9696, 62.3376, 101.5872, 48.4848, 101.5872, 34.6320, 96.9696, 20.7792, 87.7344, 11.5440, 73.8816, 6.9264, 55.4112, 2.3088, GAMGI_IO_STROKE,

83.1168, 71.5728, 92.3520, 62.3376, 96.9696, 48.4848, 96.9696, 30.0144, 92.3520, 20.7792, GAMGI_IO_STROKE,

73.8816, 66.9552, 78.4992, 66.9552, 87.7344, 57.7200, 92.3520, 43.8672, 92.3520, 25.3968, 87.7344, 16.1616, 83.1168, 11.5440, 73.8816, 6.9264, GAMGI_IO_STROKE,

73.8816, 6.9264, 64.6464, 6.9264, 55.4112, 11.5440, 46.1760, 11.5440, 36.9408, 6.9264, 32.3232, -2.3088, 36.9408, -11.5440, 46.1760, -16.1616, 55.4112, -16.1616, 64.6464, -11.5440, GAMGI_IO_STROKE,

60.0288, 6.9264, 50.7936, 6.9264, GAMGI_IO_STROKE,

55.4112, 2.3088, 46.1760, 6.9264, 36.9408, 6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 73 I strokes: 8 *
 *************************/

46.1760, 53.1024, 36.9408, 53.1024, 27.7056, 57.7200, 23.0880, 62.3376, 18.4704, 71.5728, 18.4704, 80.8080, 23.0880, 90.0432, 27.7056, 94.6608, 41.5584, 99.2784, 50.7936, 99.2784, 64.6464, 94.6608, 78.4992, 80.8080, 87.7344, 76.1904, GAMGI_IO_STROKE,

27.7056, 90.0432, 36.9408, 94.6608, 55.4112, 94.6608, 64.6464, 90.0432, 69.2640, 85.4256, GAMGI_IO_STROKE,

18.4704, 80.8080, 23.0880, 85.4256, 32.3232, 90.0432, 50.7936, 90.0432, 64.6464, 85.4256, 73.8816, 80.8080, 87.7344, 76.1904, 96.9696, 76.1904, 101.5872, 80.8080, 101.5872, 90.0432, 96.9696, 94.6608, 87.7344, 94.6608, GAMGI_IO_STROKE,

18.4704, 16.1616, 23.0880, 11.5440, 18.4704, 6.9264, 13.8528, 11.5440, 13.8528, 20.7792, 18.4704, 25.3968, 27.7056, 25.3968, 36.9408, 20.7792, 46.1760, 11.5440, 55.4112, -2.3088, 64.6464, -11.5440, GAMGI_IO_STROKE,

36.9408, 16.1616, 41.5584, 11.5440, 50.7936, -2.3088, 55.4112, -6.9264, GAMGI_IO_STROKE,

27.7056, 25.3968, 32.3232, 20.7792, 36.9408, 11.5440, 46.1760, -2.3088, 50.7936, -6.9264, 60.0288, -11.5440, 73.8816, -11.5440, 83.1168, -6.9264, 87.7344, -2.3088, 92.3520, 6.9264, 92.3520, 20.7792, 87.7344, 30.0144, 78.4992, 43.8672, 73.8816, 53.1024, 73.8816, 57.7200, GAMGI_IO_STROKE,

87.7344, 16.1616, 87.7344, 20.7792, 73.8816, 43.8672, 73.8816, 48.4848, GAMGI_IO_STROKE,

83.1168, -6.9264, 87.7344, 2.3088, 87.7344, 11.5440, 83.1168, 20.7792, 73.8816, 34.6320, 69.2640, 43.8672, 69.2640, 53.1024, 78.4992, 62.3376, 87.7344, 62.3376, 92.3520, 57.7200, 92.3520, 53.1024, GAMGI_IO_CHAR,

/*************************
 * char: 74 J strokes: 8 *
 *************************/

46.1760, 53.1024, 36.9408, 53.1024, 27.7056, 57.7200, 23.0880, 62.3376, 18.4704, 71.5728, 18.4704, 80.8080, 23.0880, 90.0432, 27.7056, 94.6608, 41.5584, 99.2784, 50.7936, 99.2784, 64.6464, 94.6608, 78.4992, 80.8080, 87.7344, 76.1904, GAMGI_IO_STROKE,

27.7056, 90.0432, 36.9408, 94.6608, 55.4112, 94.6608, 64.6464, 90.0432, 69.2640, 85.4256, GAMGI_IO_STROKE,

18.4704, 80.8080, 23.0880, 85.4256, 32.3232, 90.0432, 50.7936, 90.0432, 64.6464, 85.4256, 73.8816, 80.8080, 87.7344, 76.1904, 96.9696, 76.1904, 101.5872, 80.8080, 101.5872, 90.0432, 96.9696, 94.6608, 87.7344, 94.6608, GAMGI_IO_STROKE,

18.4704, 16.1616, 23.0880, 11.5440, 18.4704, 6.9264, 13.8528, 11.5440, 13.8528, 20.7792, 18.4704, 25.3968, 27.7056, 25.3968, 36.9408, 20.7792, 46.1760, 11.5440, 55.4112, -2.3088, 64.6464, -11.5440, GAMGI_IO_STROKE,

36.9408, 16.1616, 41.5584, 11.5440, 50.7936, -2.3088, 55.4112, -6.9264, GAMGI_IO_STROKE,

27.7056, 25.3968, 32.3232, 20.7792, 36.9408, 11.5440, 46.1760, -2.3088, 50.7936, -6.9264, 60.0288, -11.5440, 73.8816, -11.5440, 83.1168, -6.9264, 87.7344, -2.3088, 92.3520, 6.9264, 92.3520, 20.7792, 87.7344, 30.0144, 78.4992, 43.8672, 73.8816, 53.1024, 73.8816, 57.7200, GAMGI_IO_STROKE,

87.7344, 16.1616, 87.7344, 20.7792, 73.8816, 43.8672, 73.8816, 48.4848, GAMGI_IO_STROKE,

83.1168, -6.9264, 87.7344, 2.3088, 87.7344, 11.5440, 83.1168, 20.7792, 73.8816, 34.6320, 69.2640, 43.8672, 69.2640, 53.1024, 78.4992, 62.3376, 87.7344, 62.3376, 92.3520, 57.7200, 92.3520, 53.1024, GAMGI_IO_CHAR,

/*************************
 * char: 75 K strokes: 13 *
 *************************/

101.5872, 76.1904, 96.9696, 85.4256, 87.7344, 94.6608, 73.8816, 99.2784, 60.0288, 99.2784, 46.1760, 94.6608, 36.9408, 85.4256, 32.3232, 76.1904, 32.3232, 62.3376, 36.9408, 48.4848, 50.7936, 20.7792, 50.7936, 11.5440, 41.5584, 2.3088, GAMGI_IO_STROKE,

36.9408, 62.3376, 36.9408, 57.7200, 50.7936, 30.0144, 50.7936, 25.3968, GAMGI_IO_STROKE,

41.5584, 90.0432, 36.9408, 80.8080, 36.9408, 66.9552, 41.5584, 57.7200, 50.7936, 39.2496, 55.4112, 25.3968, 55.4112, 16.1616, 50.7936, 6.9264, 41.5584, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, GAMGI_IO_STROKE,

13.8528, 25.3968, 23.0880, 6.9264, GAMGI_IO_STROKE,

9.2352, 11.5440, 27.7056, 20.7792, GAMGI_IO_STROKE,

13.8528, 25.3968, 13.8528, 16.1616, 9.2352, 11.5440, 18.4704, 11.5440, 23.0880, 6.9264, 23.0880, 16.1616, 27.7056, 20.7792, 18.4704, 20.7792, 13.8528, 25.3968, GAMGI_IO_STROKE,

41.5584, 57.7200, 41.5584, 66.9552, 46.1760, 76.1904, 55.4112, 80.8080, 69.2640, 80.8080, 78.4992, 76.1904, 87.7344, 66.9552, 92.3520, 66.9552, GAMGI_IO_STROKE,

73.8816, 76.1904, 83.1168, 66.9552, GAMGI_IO_STROKE,

60.0288, 80.8080, 69.2640, 76.1904, 73.8816, 71.5728, 78.4992, 62.3376, GAMGI_IO_STROKE,

92.3520, 66.9552, 50.7936, 48.4848, GAMGI_IO_STROKE,

73.8816, 57.7200, 92.3520, 16.1616, 96.9696, 11.5440, 101.5872, 11.5440, GAMGI_IO_STROKE,

69.2640, 53.1024, 87.7344, 16.1616, 96.9696, 6.9264, GAMGI_IO_STROKE,

64.6464, 53.1024, 83.1168, 11.5440, 92.3520, 2.3088, 106.2048, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 76 L strokes: 8 *
 *************************/

87.7344, 39.2496, 83.1168, 34.6320, 69.2640, 34.6320, 64.6464, 39.2496, 64.6464, 48.4848, 69.2640, 57.7200, 78.4992, 71.5728, 83.1168, 80.8080, 83.1168, 90.0432, GAMGI_IO_STROKE,

69.2640, 48.4848, 69.2640, 53.1024, 83.1168, 71.5728, 83.1168, 76.1904, GAMGI_IO_STROKE,

73.8816, 34.6320, 69.2640, 39.2496, 69.2640, 43.8672, 73.8816, 53.1024, 83.1168, 62.3376, 87.7344, 71.5728, 87.7344, 80.8080, 83.1168, 90.0432, 78.4992, 94.6608, 64.6464, 99.2784, 41.5584, 99.2784, 27.7056, 94.6608, 23.0880, 90.0432, 18.4704, 80.8080, 18.4704, 71.5728, 23.0880, 62.3376, 32.3232, 48.4848, 36.9408, 39.2496, 36.9408, 34.6320, 32.3232, 25.3968, GAMGI_IO_STROKE,

23.0880, 76.1904, 23.0880, 71.5728, 36.9408, 48.4848, 36.9408, 43.8672, GAMGI_IO_STROKE,

23.0880, 90.0432, 23.0880, 80.8080, 27.7056, 71.5728, 36.9408, 57.7200, 41.5584, 48.4848, 41.5584, 39.2496, 36.9408, 30.0144, 27.7056, 20.7792, 13.8528, 11.5440, GAMGI_IO_STROKE,

27.7056, 20.7792, 36.9408, 20.7792, 50.7936, 11.5440, 64.6464, 6.9264, 78.4992, 6.9264, 87.7344, 11.5440, GAMGI_IO_STROKE,

32.3232, 16.1616, 36.9408, 16.1616, 55.4112, 6.9264, 60.0288, 6.9264, GAMGI_IO_STROKE,

13.8528, 11.5440, 23.0880, 16.1616, 27.7056, 16.1616, 46.1760, 6.9264, 60.0288, 2.3088, 69.2640, 2.3088, 83.1168, 6.9264, 87.7344, 11.5440, 92.3520, 20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 77 M strokes: 16 *
 *************************/

13.8528, 48.4848, 13.8528, 43.8672, 18.4704, 39.2496, 27.7056, 39.2496, 36.9408, 43.8672, 36.9408, 57.7200, 32.3232, 66.9552, 23.0880, 80.8080, 23.0880, 90.0432, 32.3232, 99.2784, GAMGI_IO_STROKE,

32.3232, 57.7200, 23.0880, 76.1904, GAMGI_IO_STROKE,

27.7056, 39.2496, 32.3232, 43.8672, 32.3232, 53.1024, 23.0880, 66.9552, 18.4704, 76.1904, 18.4704, 85.4256, 23.0880, 94.6608, 32.3232, 99.2784, 41.5584, 99.2784, 50.7936, 94.6608, 60.0288, 85.4256, 64.6464, 71.5728, 64.6464, 43.8672, 60.0288, 30.0144, 55.4112, 20.7792, 46.1760, 11.5440, 32.3232, 2.3088, 27.7056, 6.9264, 23.0880, 6.9264, GAMGI_IO_STROKE,

55.4112, 85.4256, 60.0288, 71.5728, 60.0288, 43.8672, 55.4112, 30.0144, 50.7936, 20.7792, GAMGI_IO_STROKE,

36.9408, 6.9264, 32.3232, 11.5440, 27.7056, 11.5440, GAMGI_IO_STROKE,

41.5584, 99.2784, 50.7936, 90.0432, 55.4112, 76.1904, 55.4112, 43.8672, 50.7936, 25.3968, 46.1760, 16.1616, 41.5584, 11.5440, 36.9408, 16.1616, 32.3232, 16.1616, 18.4704, 2.3088, GAMGI_IO_STROKE,

55.4112, 94.6608, 64.6464, 99.2784, 73.8816, 99.2784, 83.1168, 94.6608, 92.3520, 85.4256, 96.9696, 71.5728, 96.9696, 43.8672, 92.3520, 30.0144, 87.7344, 20.7792, 78.4992, 11.5440, 69.2640, 2.3088, 64.6464, 6.9264, 60.0288, 6.9264, GAMGI_IO_STROKE,

87.7344, 85.4256, 92.3520, 71.5728, 92.3520, 43.8672, 87.7344, 25.3968, GAMGI_IO_STROKE,

73.8816, 6.9264, 69.2640, 11.5440, 64.6464, 11.5440, GAMGI_IO_STROKE,

73.8816, 99.2784, 83.1168, 90.0432, 87.7344, 76.1904, 87.7344, 39.2496, 83.1168, 20.7792, 78.4992, 11.5440, 73.8816, 16.1616, 69.2640, 16.1616, 55.4112, 2.3088, GAMGI_IO_STROKE,

87.7344, 90.0432, 92.3520, 94.6608, 101.5872, 99.2784, 110.8224, 99.2784, 120.0576, 94.6608, 124.6752, 90.0432, 129.2928, 80.8080, 133.9104, 76.1904, GAMGI_IO_STROKE,

120.0576, 90.0432, 124.6752, 80.8080, GAMGI_IO_STROKE,

110.8224, 99.2784, 115.4400, 94.6608, 120.0576, 80.8080, 124.6752, 76.1904, 133.9104, 76.1904, GAMGI_IO_STROKE,

133.9104, 76.1904, 120.0576, 66.9552, 115.4400, 62.3376, 110.8224, 48.4848, 110.8224, 34.6320, 115.4400, 16.1616, 124.6752, 2.3088, 138.5280, 16.1616, GAMGI_IO_STROKE,

120.0576, 62.3376, 115.4400, 53.1024, 115.4400, 34.6320, 120.0576, 20.7792, 129.2928, 6.9264, GAMGI_IO_STROKE,

133.9104, 76.1904, 124.6752, 66.9552, 120.0576, 57.7200, 120.0576, 39.2496, 124.6752, 20.7792, 133.9104, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 78 N strokes: 12 *
 *************************/

13.8528, 48.4848, 13.8528, 43.8672, 18.4704, 39.2496, 27.7056, 39.2496, 36.9408, 43.8672, 36.9408, 57.7200, 32.3232, 66.9552, 23.0880, 80.8080, 23.0880, 90.0432, 32.3232, 99.2784, GAMGI_IO_STROKE,

32.3232, 57.7200, 23.0880, 76.1904, GAMGI_IO_STROKE,

27.7056, 39.2496, 32.3232, 43.8672, 32.3232, 53.1024, 23.0880, 66.9552, 18.4704, 76.1904, 18.4704, 85.4256, 23.0880, 94.6608, 32.3232, 99.2784, 46.1760, 99.2784, 55.4112, 94.6608, 64.6464, 85.4256, 69.2640, 71.5728, 69.2640, 43.8672, 64.6464, 30.0144, 60.0288, 20.7792, 50.7936, 11.5440, 36.9408, 2.3088, 32.3232, 6.9264, 23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

60.0288, 85.4256, 64.6464, 76.1904, 64.6464, 43.8672, 60.0288, 30.0144, 55.4112, 20.7792, 50.7936, 16.1616, GAMGI_IO_STROKE,

41.5584, 6.9264, 32.3232, 11.5440, 23.0880, 11.5440, GAMGI_IO_STROKE,

46.1760, 99.2784, 55.4112, 90.0432, 60.0288, 76.1904, 60.0288, 43.8672, 55.4112, 25.3968, 46.1760, 11.5440, 36.9408, 16.1616, 27.7056, 16.1616, 13.8528, 2.3088, GAMGI_IO_STROKE,

64.6464, 90.0432, 69.2640, 94.6608, 78.4992, 99.2784, 87.7344, 99.2784, 96.9696, 94.6608, 101.5872, 90.0432, 106.2048, 80.8080, 110.8224, 76.1904, GAMGI_IO_STROKE,

96.9696, 90.0432, 101.5872, 80.8080, GAMGI_IO_STROKE,

87.7344, 99.2784, 92.3520, 94.6608, 96.9696, 80.8080, 101.5872, 76.1904, 110.8224, 76.1904, GAMGI_IO_STROKE,

110.8224, 76.1904, 96.9696, 66.9552, 92.3520, 62.3376, 87.7344, 48.4848, 87.7344, 34.6320, 92.3520, 16.1616, 101.5872, 2.3088, 115.4400, 16.1616, GAMGI_IO_STROKE,

96.9696, 62.3376, 92.3520, 53.1024, 92.3520, 34.6320, 96.9696, 20.7792, 106.2048, 6.9264, GAMGI_IO_STROKE,

110.8224, 76.1904, 101.5872, 66.9552, 96.9696, 57.7200, 96.9696, 39.2496, 101.5872, 20.7792, 110.8224, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 79 O strokes: 8 *
 *************************/

55.4112, 99.2784, 46.1760, 94.6608, 36.9408, 85.4256, 32.3232, 76.1904, 32.3232, 66.9552, 41.5584, 48.4848, 41.5584, 39.2496, GAMGI_IO_STROKE,

36.9408, 71.5728, 36.9408, 66.9552, 41.5584, 57.7200, 41.5584, 53.1024, GAMGI_IO_STROKE,

36.9408, 85.4256, 36.9408, 76.1904, 46.1760, 57.7200, 46.1760, 48.4848, 41.5584, 39.2496, 36.9408, 34.6320, 27.7056, 34.6320, 23.0880, 39.2496, 23.0880, 43.8672, GAMGI_IO_STROKE,

55.4112, 99.2784, 60.0288, 94.6608, 87.7344, 85.4256, 101.5872, 76.1904, 106.2048, 66.9552, 110.8224, 53.1024, 110.8224, 39.2496, 106.2048, 25.3968, 101.5872, 16.1616, 92.3520, 6.9264, 78.4992, 2.3088, 64.6464, 2.3088, 50.7936, 6.9264, 23.0880, 20.7792, 18.4704, 20.7792, 13.8528, 16.1616, GAMGI_IO_STROKE,

55.4112, 94.6608, 60.0288, 90.0432, 87.7344, 80.8080, 96.9696, 76.1904, 101.5872, 71.5728, GAMGI_IO_STROKE,

55.4112, 99.2784, 55.4112, 90.0432, 60.0288, 85.4256, 87.7344, 76.1904, 96.9696, 71.5728, 106.2048, 62.3376, 110.8224, 53.1024, GAMGI_IO_STROKE,

69.2640, 6.9264, 60.0288, 6.9264, 32.3232, 20.7792, 27.7056, 20.7792, GAMGI_IO_STROKE,

96.9696, 11.5440, 87.7344, 6.9264, 73.8816, 6.9264, 60.0288, 11.5440, 41.5584, 20.7792, 27.7056, 25.3968, 18.4704, 25.3968, 13.8528, 16.1616, 13.8528, 6.9264, 18.4704, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 80 P strokes: 16 *
 *************************/

13.8528, 48.4848, 13.8528, 43.8672, 18.4704, 39.2496, 27.7056, 39.2496, 36.9408, 43.8672, 36.9408, 57.7200, 32.3232, 66.9552, 23.0880, 80.8080, 23.0880, 90.0432, 32.3232, 99.2784, GAMGI_IO_STROKE,

32.3232, 57.7200, 23.0880, 76.1904, GAMGI_IO_STROKE,

27.7056, 39.2496, 32.3232, 43.8672, 32.3232, 53.1024, 23.0880, 66.9552, 18.4704, 76.1904, 18.4704, 85.4256, 23.0880, 94.6608, 32.3232, 99.2784, 46.1760, 99.2784, 55.4112, 94.6608, 60.0288, 90.0432, 64.6464, 80.8080, 64.6464, 30.0144, GAMGI_IO_STROKE,

64.6464, 20.7792, 64.6464, -2.3088, 60.0288, -11.5440, 50.7936, -16.1616, 36.9408, -16.1616, 32.3232, -11.5440, 32.3232, -2.3088, 36.9408, 2.3088, 41.5584, -2.3088, 36.9408, -6.9264, GAMGI_IO_STROKE,

55.4112, 90.0432, 60.0288, 80.8080, 60.0288, -2.3088, 55.4112, -11.5440, GAMGI_IO_STROKE,

46.1760, 99.2784, 50.7936, 94.6608, 55.4112, 80.8080, 55.4112, 30.0144, GAMGI_IO_STROKE,

55.4112, 20.7792, 55.4112, -2.3088, 50.7936, -11.5440, 46.1760, -16.1616, GAMGI_IO_STROKE,

64.6464, 80.8080, 87.7344, 99.2784, GAMGI_IO_STROKE,

87.7344, 99.2784, 96.9696, 85.4256, 101.5872, 76.1904, 106.2048, 57.7200, 106.2048, 43.8672, 101.5872, 30.0144, 92.3520, 16.1616, 78.4992, 2.3088, GAMGI_IO_STROKE,

83.1168, 94.6608, 96.9696, 76.1904, 101.5872, 62.3376, 101.5872, 57.7200, GAMGI_IO_STROKE,

78.4992, 90.0432, 87.7344, 80.8080, 96.9696, 66.9552, 101.5872, 53.1024, 101.5872, 39.2496, 96.9696, 25.3968, 92.3520, 16.1616, GAMGI_IO_STROKE,

83.1168, 11.5440, 73.8816, 25.3968, 64.6464, 30.0144, GAMGI_IO_STROKE,

55.4112, 30.0144, 46.1760, 25.3968, 36.9408, 16.1616, GAMGI_IO_STROKE,

83.1168, 6.9264, 73.8816, 20.7792, 64.6464, 25.3968, 50.7936, 25.3968, GAMGI_IO_STROKE,

78.4992, 2.3088, 69.2640, 16.1616, 64.6464, 20.7792, GAMGI_IO_STROKE,

55.4112, 20.7792, 46.1760, 20.7792, 36.9408, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 81 Q strokes: 12 *
 *************************/

55.4112, 99.2784, 46.1760, 94.6608, 36.9408, 85.4256, 32.3232, 76.1904, 32.3232, 66.9552, 41.5584, 48.4848, 41.5584, 39.2496, GAMGI_IO_STROKE,

36.9408, 71.5728, 36.9408, 66.9552, 41.5584, 57.7200, 41.5584, 53.1024, GAMGI_IO_STROKE,

36.9408, 85.4256, 36.9408, 76.1904, 46.1760, 57.7200, 46.1760, 48.4848, 41.5584, 39.2496, 36.9408, 34.6320, 27.7056, 34.6320, 23.0880, 39.2496, 23.0880, 43.8672, GAMGI_IO_STROKE,

55.4112, 99.2784, 60.0288, 94.6608, 87.7344, 85.4256, 101.5872, 76.1904, 106.2048, 66.9552, 110.8224, 53.1024, 110.8224, 39.2496, 106.2048, 25.3968, 101.5872, 16.1616, GAMGI_IO_STROKE,

92.3520, 6.9264, 78.4992, 2.3088, 64.6464, 2.3088, 50.7936, 6.9264, 23.0880, 20.7792, 18.4704, 20.7792, 13.8528, 16.1616, GAMGI_IO_STROKE,

55.4112, 94.6608, 60.0288, 90.0432, 87.7344, 80.8080, 96.9696, 76.1904, 101.5872, 71.5728, GAMGI_IO_STROKE,

55.4112, 99.2784, 55.4112, 90.0432, 60.0288, 85.4256, 87.7344, 76.1904, 96.9696, 71.5728, 106.2048, 62.3376, 110.8224, 53.1024, GAMGI_IO_STROKE,

69.2640, 6.9264, 60.0288, 6.9264, 32.3232, 20.7792, 27.7056, 20.7792, GAMGI_IO_STROKE,

92.3520, 6.9264, 73.8816, 6.9264, 60.0288, 11.5440, 41.5584, 20.7792, 27.7056, 25.3968, 18.4704, 25.3968, 13.8528, 16.1616, 13.8528, 6.9264, 18.4704, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, GAMGI_IO_STROKE,

73.8816, 16.1616, 83.1168, 25.3968, 92.3520, 25.3968, 110.8224, 6.9264, 115.4400, 6.9264, GAMGI_IO_STROKE,

87.7344, 20.7792, 92.3520, 20.7792, 106.2048, 6.9264, GAMGI_IO_STROKE,

78.4992, 20.7792, 83.1168, 20.7792, 101.5872, 2.3088, 110.8224, 2.3088, 120.0576, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 82 R strokes: 15 *
 *************************/

13.8528, 48.4848, 13.8528, 43.8672, 18.4704, 39.2496, 27.7056, 39.2496, 36.9408, 43.8672, 36.9408, 57.7200, 32.3232, 66.9552, 23.0880, 80.8080, 23.0880, 90.0432, 32.3232, 99.2784, GAMGI_IO_STROKE,

32.3232, 57.7200, 23.0880, 76.1904, GAMGI_IO_STROKE,

27.7056, 39.2496, 32.3232, 43.8672, 32.3232, 53.1024, 23.0880, 66.9552, 18.4704, 76.1904, 18.4704, 85.4256, 23.0880, 94.6608, 32.3232, 99.2784, 46.1760, 99.2784, 55.4112, 94.6608, 60.0288, 90.0432, 64.6464, 80.8080, 64.6464, 25.3968, 60.0288, 16.1616, 50.7936, 6.9264, 41.5584, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, GAMGI_IO_STROKE,

55.4112, 90.0432, 60.0288, 80.8080, 60.0288, 25.3968, 55.4112, 16.1616, GAMGI_IO_STROKE,

46.1760, 99.2784, 50.7936, 94.6608, 55.4112, 80.8080, 55.4112, 25.3968, 50.7936, 11.5440, 41.5584, 2.3088, GAMGI_IO_STROKE,

13.8528, 25.3968, 23.0880, 6.9264, GAMGI_IO_STROKE,

9.2352, 11.5440, 27.7056, 20.7792, GAMGI_IO_STROKE,

13.8528, 25.3968, 13.8528, 16.1616, 9.2352, 11.5440, 18.4704, 11.5440, 23.0880, 6.9264, 23.0880, 16.1616, 27.7056, 20.7792, 18.4704, 20.7792, 13.8528, 25.3968, GAMGI_IO_STROKE,

64.6464, 85.4256, 69.2640, 94.6608, 78.4992, 99.2784, 87.7344, 99.2784, 96.9696, 94.6608, 101.5872, 90.0432, 106.2048, 80.8080, 110.8224, 76.1904, GAMGI_IO_STROKE,

96.9696, 90.0432, 101.5872, 80.8080, GAMGI_IO_STROKE,

87.7344, 99.2784, 92.3520, 94.6608, 96.9696, 80.8080, 101.5872, 76.1904, 110.8224, 76.1904, GAMGI_IO_STROKE,

110.8224, 76.1904, 64.6464, 53.1024, GAMGI_IO_STROKE,

73.8816, 57.7200, 92.3520, 11.5440, 101.5872, 2.3088, 115.4400, 16.1616, GAMGI_IO_STROKE,

78.4992, 57.7200, 96.9696, 16.1616, 106.2048, 6.9264, GAMGI_IO_STROKE,

83.1168, 62.3376, 101.5872, 16.1616, 106.2048, 11.5440, 110.8224, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 83 S strokes: 7 *
 *************************/

106.2048, 90.0432, 101.5872, 94.6608, 106.2048, 99.2784, 110.8224, 94.6608, 110.8224, 85.4256, 106.2048, 76.1904, 96.9696, 76.1904, 78.4992, 85.4256, 64.6464, 90.0432, 46.1760, 90.0432, 27.7056, 85.4256, 18.4704, 76.1904, GAMGI_IO_STROKE,

92.3520, 80.8080, 78.4992, 90.0432, 64.6464, 94.6608, 46.1760, 94.6608, 32.3232, 90.0432, GAMGI_IO_STROKE,

110.8224, 85.4256, 106.2048, 80.8080, 96.9696, 80.8080, 78.4992, 94.6608, 64.6464, 99.2784, 46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 62.3376, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 55.4112, 2.3088, 73.8816, 2.3088, 87.7344, 6.9264, 96.9696, 11.5440, 106.2048, 20.7792, 110.8224, 34.6320, 110.8224, 48.4848, 106.2048, 57.7200, 96.9696, 62.3376, 83.1168, 62.3376, 73.8816, 57.7200, 64.6464, 43.8672, 55.4112, 39.2496, 46.1760, 39.2496, GAMGI_IO_STROKE,

32.3232, 16.1616, 41.5584, 11.5440, 55.4112, 6.9264, 73.8816, 6.9264, 92.3520, 11.5440, GAMGI_IO_STROKE,

18.4704, 30.0144, 27.7056, 20.7792, 36.9408, 16.1616, 50.7936, 11.5440, 73.8816, 11.5440, 92.3520, 16.1616, 101.5872, 20.7792, 106.2048, 25.3968, 110.8224, 34.6320, GAMGI_IO_STROKE,

87.7344, 57.7200, 83.1168, 57.7200, 64.6464, 39.2496, 60.0288, 39.2496, GAMGI_IO_STROKE,

110.8224, 48.4848, 101.5872, 57.7200, 92.3520, 57.7200, 83.1168, 53.1024, 73.8816, 39.2496, 64.6464, 34.6320, 55.4112, 34.6320, 46.1760, 39.2496, 41.5584, 48.4848, 41.5584, 57.7200, 46.1760, 66.9552, 55.4112, 71.5728, GAMGI_IO_CHAR,

/*************************
 * char: 84 T strokes: 9 *
 *************************/

27.7056, 62.3376, 18.4704, 66.9552, 13.8528, 76.1904, 13.8528, 85.4256, 18.4704, 94.6608, 32.3232, 99.2784, 55.4112, 99.2784, 69.2640, 94.6608, 87.7344, 80.8080, 96.9696, 80.8080, 101.5872, 85.4256, GAMGI_IO_STROKE,

18.4704, 90.0432, 27.7056, 94.6608, 55.4112, 94.6608, 69.2640, 90.0432, 83.1168, 80.8080, GAMGI_IO_STROKE,

13.8528, 76.1904, 18.4704, 85.4256, 27.7056, 90.0432, 55.4112, 90.0432, 69.2640, 85.4256, 87.7344, 76.1904, 96.9696, 76.1904, 101.5872, 85.4256, 101.5872, 94.6608, 96.9696, 99.2784, 92.3520, 94.6608, 96.9696, 90.0432, GAMGI_IO_STROKE,

69.2640, 85.4256, 55.4112, 71.5728, 50.7936, 62.3376, 50.7936, 53.1024, 60.0288, 34.6320, 60.0288, 25.3968, GAMGI_IO_STROKE,

55.4112, 57.7200, 55.4112, 53.1024, 60.0288, 43.8672, 60.0288, 39.2496, GAMGI_IO_STROKE,

55.4112, 71.5728, 55.4112, 62.3376, 64.6464, 43.8672, 64.6464, 34.6320, 60.0288, 25.3968, 55.4112, 20.7792, 46.1760, 20.7792, 41.5584, 25.3968, 41.5584, 34.6320, GAMGI_IO_STROKE,

18.4704, 11.5440, 23.0880, 6.9264, 18.4704, 2.3088, 13.8528, 6.9264, 13.8528, 16.1616, 18.4704, 25.3968, 27.7056, 25.3968, 41.5584, 20.7792, 60.0288, 11.5440, 73.8816, 6.9264, 87.7344, 6.9264, 96.9696, 11.5440, GAMGI_IO_STROKE,

27.7056, 20.7792, 32.3232, 20.7792, 60.0288, 6.9264, 69.2640, 6.9264, GAMGI_IO_STROKE,

13.8528, 16.1616, 18.4704, 20.7792, 23.0880, 20.7792, 32.3232, 16.1616, 50.7936, 6.9264, 64.6464, 2.3088, 78.4992, 2.3088, 92.3520, 6.9264, 101.5872, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 85 U strokes: 7 *
 *************************/

13.8528, 90.0432, 18.4704, 90.0432, 23.0880, 85.4256, 23.0880, 20.7792, 13.8528, 16.1616, GAMGI_IO_STROKE,

18.4704, 94.6608, 27.7056, 90.0432, 27.7056, 16.1616, 41.5584, 6.9264, GAMGI_IO_STROKE,

9.2352, 85.4256, 23.0880, 99.2784, 32.3232, 90.0432, 32.3232, 20.7792, 41.5584, 11.5440, 50.7936, 11.5440, GAMGI_IO_STROKE,

13.8528, 16.1616, 18.4704, 16.1616, 27.7056, 11.5440, 36.9408, 2.3088, 50.7936, 11.5440, 69.2640, 25.3968, GAMGI_IO_STROKE,

60.0288, 90.0432, 64.6464, 90.0432, 69.2640, 85.4256, 69.2640, 11.5440, 78.4992, 2.3088, 92.3520, 16.1616, GAMGI_IO_STROKE,

64.6464, 94.6608, 73.8816, 90.0432, 73.8816, 11.5440, 83.1168, 6.9264, GAMGI_IO_STROKE,

55.4112, 85.4256, 69.2640, 99.2784, 83.1168, 90.0432, 78.4992, 85.4256, 78.4992, 16.1616, 83.1168, 11.5440, 87.7344, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 86 V strokes: 13 *
 **************************/

13.8528, 48.4848, 13.8528, 43.8672, 18.4704, 39.2496, 27.7056, 39.2496, 36.9408, 43.8672, 36.9408, 57.7200, 32.3232, 66.9552, 23.0880, 80.8080, 23.0880, 90.0432, 32.3232, 99.2784, GAMGI_IO_STROKE,

32.3232, 57.7200, 23.0880, 76.1904, GAMGI_IO_STROKE,

27.7056, 39.2496, 32.3232, 43.8672, 32.3232, 53.1024, 23.0880, 66.9552, 18.4704, 76.1904, 18.4704, 85.4256, 23.0880, 94.6608, 32.3232, 99.2784, 46.1760, 99.2784, 55.4112, 94.6608, 60.0288, 90.0432, 64.6464, 80.8080, 64.6464, 43.8672, 60.0288, 30.0144, 50.7936, 20.7792, GAMGI_IO_STROKE,

55.4112, 90.0432, 60.0288, 80.8080, 60.0288, 34.6320, GAMGI_IO_STROKE,

46.1760, 99.2784, 50.7936, 94.6608, 55.4112, 80.8080, 55.4112, 30.0144, 50.7936, 20.7792, GAMGI_IO_STROKE,

64.6464, 85.4256, 69.2640, 94.6608, 78.4992, 99.2784, 87.7344, 99.2784, 96.9696, 94.6608, 106.2048, 80.8080, 110.8224, 76.1904, GAMGI_IO_STROKE,

96.9696, 90.0432, 101.5872, 80.8080, GAMGI_IO_STROKE,

87.7344, 99.2784, 92.3520, 94.6608, 96.9696, 80.8080, 101.5872, 76.1904, 110.8224, 76.1904, GAMGI_IO_STROKE,

101.5872, 76.1904, 92.3520, 76.1904, 87.7344, 71.5728, 87.7344, 62.3376, 92.3520, 53.1024, 106.2048, 43.8672, 110.8224, 34.6320, GAMGI_IO_STROKE,

92.3520, 57.7200, 106.2048, 48.4848, GAMGI_IO_STROKE,

87.7344, 66.9552, 92.3520, 62.3376, 106.2048, 53.1024, 110.8224, 43.8672, 110.8224, 25.3968, 106.2048, 16.1616, 96.9696, 6.9264, 87.7344, 2.3088, 69.2640, 2.3088, 55.4112, 6.9264, 27.7056, 20.7792, 23.0880, 20.7792, 18.4704, 16.1616, GAMGI_IO_STROKE,

73.8816, 6.9264, 64.6464, 6.9264, 36.9408, 20.7792, 32.3232, 20.7792, GAMGI_IO_STROKE,

101.5872, 11.5440, 92.3520, 6.9264, 78.4992, 6.9264, 64.6464, 11.5440, 46.1760, 20.7792, 32.3232, 25.3968, 23.0880, 25.3968, 18.4704, 16.1616, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 6.9264, 23.0880, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 87 W strokes: 19 *
 **************************/

13.8528, 48.4848, 13.8528, 43.8672, 18.4704, 39.2496, 27.7056, 39.2496, 36.9408, 43.8672, 36.9408, 57.7200, 32.3232, 66.9552, 23.0880, 80.8080, 23.0880, 90.0432, 32.3232, 99.2784, GAMGI_IO_STROKE,

32.3232, 57.7200, 23.0880, 76.1904, GAMGI_IO_STROKE,

27.7056, 39.2496, 32.3232, 43.8672, 32.3232, 53.1024, 23.0880, 66.9552, 18.4704, 76.1904, 18.4704, 85.4256, 23.0880, 94.6608, 32.3232, 99.2784, 46.1760, 99.2784, 55.4112, 94.6608, 60.0288, 90.0432, 64.6464, 80.8080, 64.6464, 62.3376, 60.0288, 48.4848, 50.7936, 34.6320, 41.5584, 25.3968, GAMGI_IO_STROKE,

55.4112, 90.0432, 60.0288, 80.8080, 60.0288, 57.7200, 55.4112, 43.8672, GAMGI_IO_STROKE,

46.1760, 99.2784, 50.7936, 94.6608, 55.4112, 80.8080, 55.4112, 57.7200, 50.7936, 39.2496, 41.5584, 25.3968, GAMGI_IO_STROKE,

55.4112, 94.6608, 64.6464, 99.2784, 78.4992, 99.2784, 87.7344, 94.6608, GAMGI_IO_STROKE,

96.9696, 99.2784, 83.1168, 94.6608, 78.4992, 85.4256, 78.4992, 66.9552, 83.1168, 53.1024, 92.3520, 39.2496, 96.9696, 30.0144, 96.9696, 20.7792, 92.3520, 11.5440, GAMGI_IO_STROKE,

83.1168, 66.9552, 83.1168, 62.3376, 96.9696, 39.2496, 96.9696, 34.6320, GAMGI_IO_STROKE,

96.9696, 99.2784, 87.7344, 94.6608, 83.1168, 85.4256, 83.1168, 71.5728, 87.7344, 62.3376, 96.9696, 48.4848, 101.5872, 34.6320, 101.5872, 25.3968, 96.9696, 16.1616, 87.7344, 6.9264, 78.4992, 2.3088, 60.0288, 2.3088, 50.7936, 6.9264, 41.5584, 16.1616, 32.3232, 20.7792, 23.0880, 20.7792, 18.4704, 16.1616, GAMGI_IO_STROKE,

55.4112, 6.9264, 41.5584, 20.7792, 36.9408, 20.7792, GAMGI_IO_STROKE,

69.2640, 2.3088, 60.0288, 6.9264, 46.1760, 20.7792, 36.9408, 25.3968, 23.0880, 25.3968, 18.4704, 16.1616, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 6.9264, 23.0880, 11.5440, GAMGI_IO_STROKE,

96.9696, 99.2784, 110.8224, 99.2784, 120.0576, 94.6608, 129.2928, 80.8080, 133.9104, 76.1904, GAMGI_IO_STROKE,

120.0576, 90.0432, 124.6752, 80.8080, GAMGI_IO_STROKE,

110.8224, 99.2784, 115.4400, 94.6608, 120.0576, 80.8080, 124.6752, 76.1904, 133.9104, 76.1904, GAMGI_IO_STROKE,

124.6752, 76.1904, 115.4400, 76.1904, 110.8224, 71.5728, 110.8224, 62.3376, 115.4400, 53.1024, 129.2928, 43.8672, 133.9104, 34.6320, GAMGI_IO_STROKE,

115.4400, 57.7200, 129.2928, 48.4848, GAMGI_IO_STROKE,

110.8224, 66.9552, 115.4400, 62.3376, 129.2928, 53.1024, 133.9104, 43.8672, 133.9104, 20.7792, 129.2928, 11.5440, 124.6752, 6.9264, 115.4400, 2.3088, 101.5872, 2.3088, 87.7344, 6.9264, GAMGI_IO_STROKE,

106.2048, 6.9264, 101.5872, 6.9264, 92.3520, 11.5440, GAMGI_IO_STROKE,

129.2928, 11.5440, 120.0576, 6.9264, 110.8224, 6.9264, 101.5872, 11.5440, 96.9696, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 88 X strokes: 16 *
 *************************/

23.0880, 90.0432, 32.3232, 90.0432, 41.5584, 85.4256, 46.1760, 80.8080, 50.7936, 66.9552, 50.7936, 57.7200, GAMGI_IO_STROKE,

50.7936, 48.4848, 50.7936, 30.0144, 46.1760, 16.1616, 32.3232, 2.3088, 23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

36.9408, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_STROKE,

41.5584, 11.5440, 36.9408, 11.5440, 27.7056, 16.1616, 13.8528, 2.3088, GAMGI_IO_STROKE,

32.3232, 94.6608, 46.1760, 90.0432, 50.7936, 85.4256, 55.4112, 71.5728, 55.4112, 30.0144, 60.0288, 20.7792, 69.2640, 11.5440, 78.4992, 6.9264, GAMGI_IO_STROKE,

13.8528, 85.4256, 36.9408, 99.2784, 46.1760, 94.6608, 55.4112, 85.4256, 60.0288, 71.5728, 60.0288, 57.7200, GAMGI_IO_STROKE,

60.0288, 48.4848, 60.0288, 34.6320, 64.6464, 20.7792, 69.2640, 16.1616, 78.4992, 11.5440, 87.7344, 11.5440, GAMGI_IO_STROKE,

50.7936, 30.0144, 55.4112, 16.1616, 64.6464, 6.9264, 73.8816, 2.3088, 96.9696, 16.1616, GAMGI_IO_STROKE,

60.0288, 71.5728, 64.6464, 85.4256, 78.4992, 99.2784, 87.7344, 94.6608, 96.9696, 99.2784, GAMGI_IO_STROKE,

73.8816, 94.6608, 83.1168, 90.0432, 87.7344, 90.0432, GAMGI_IO_STROKE,

69.2640, 90.0432, 73.8816, 90.0432, 83.1168, 85.4256, 96.9696, 99.2784, GAMGI_IO_STROKE,

23.0880, 39.2496, 32.3232, 57.7200, 50.7936, 57.7200, GAMGI_IO_STROKE,

60.0288, 57.7200, 78.4992, 57.7200, 87.7344, 66.9552, GAMGI_IO_STROKE,

32.3232, 53.1024, 78.4992, 53.1024, GAMGI_IO_STROKE,

23.0880, 39.2496, 32.3232, 48.4848, 50.7936, 48.4848, GAMGI_IO_STROKE,

60.0288, 48.4848, 78.4992, 48.4848, 87.7344, 66.9552, GAMGI_IO_CHAR,

/*************************
 * char: 89 Y strokes: 9 *
 *************************/

13.8528, 48.4848, 13.8528, 43.8672, 18.4704, 39.2496, 27.7056, 39.2496, 36.9408, 43.8672, 36.9408, 57.7200, 32.3232, 66.9552, 23.0880, 80.8080, 23.0880, 90.0432, 32.3232, 99.2784, GAMGI_IO_STROKE,

32.3232, 57.7200, 23.0880, 76.1904, GAMGI_IO_STROKE,

27.7056, 39.2496, 32.3232, 43.8672, 32.3232, 53.1024, 23.0880, 66.9552, 18.4704, 76.1904, 18.4704, 85.4256, 23.0880, 94.6608, 32.3232, 99.2784, 46.1760, 99.2784, 55.4112, 94.6608, 60.0288, 90.0432, 64.6464, 80.8080, 64.6464, 57.7200, 60.0288, 43.8672, 55.4112, 34.6320, 55.4112, 30.0144, 64.6464, 20.7792, 69.2640, 20.7792, GAMGI_IO_STROKE,

55.4112, 90.0432, 60.0288, 80.8080, 60.0288, 53.1024, 55.4112, 39.2496, 50.7936, 30.0144, 64.6464, 16.1616, GAMGI_IO_STROKE,

46.1760, 99.2784, 50.7936, 94.6608, 55.4112, 80.8080, 55.4112, 53.1024, 50.7936, 34.6320, 46.1760, 25.3968, 60.0288, 11.5440, 73.8816, 25.3968, GAMGI_IO_STROKE,

64.6464, 80.8080, 101.5872, 99.2784, GAMGI_IO_STROKE,

92.3520, 94.6608, 92.3520, 6.9264, 87.7344, -6.9264, GAMGI_IO_STROKE,

96.9696, 94.6608, 96.9696, 16.1616, 92.3520, 2.3088, GAMGI_IO_STROKE,

101.5872, 99.2784, 101.5872, 25.3968, 96.9696, 6.9264, 92.3520, -2.3088, 83.1168, -11.5440, 69.2640, -16.1616, 50.7936, -16.1616, 36.9408, -11.5440, 27.7056, -2.3088, 23.0880, 6.9264, 27.7056, 11.5440, 32.3232, 6.9264, 27.7056, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 90 Z strokes: 9 *
 *************************/

36.9408, 85.4256, 41.5584, 94.6608, 50.7936, 99.2784, 64.6464, 99.2784, 73.8816, 94.6608, 78.4992, 90.0432, 83.1168, 80.8080, 83.1168, 66.9552, 78.4992, 57.7200, 73.8816, 53.1024, 64.6464, 48.4848, GAMGI_IO_STROKE,

50.7936, 48.4848, 41.5584, 53.1024, 36.9408, 62.3376, GAMGI_IO_STROKE,

73.8816, 90.0432, 78.4992, 85.4256, 78.4992, 62.3376, 73.8816, 57.7200, GAMGI_IO_STROKE,

64.6464, 99.2784, 69.2640, 94.6608, 73.8816, 85.4256, 73.8816, 62.3376, 69.2640, 53.1024, 64.6464, 48.4848, GAMGI_IO_STROKE,

32.3232, 30.0144, 36.9408, 39.2496, 41.5584, 43.8672, 50.7936, 48.4848, 64.6464, 48.4848, 78.4992, 43.8672, 87.7344, 34.6320, 92.3520, 25.3968, 92.3520, 6.9264, 87.7344, -2.3088, 78.4992, -11.5440, 64.6464, -16.1616, 46.1760, -16.1616, 36.9408, -11.5440, 23.0880, 6.9264, 18.4704, 11.5440, GAMGI_IO_STROKE,

83.1168, 34.6320, 87.7344, 25.3968, 87.7344, 6.9264, 83.1168, -2.3088, GAMGI_IO_STROKE,

64.6464, 48.4848, 78.4992, 39.2496, 83.1168, 30.0144, 83.1168, 2.3088, 78.4992, -6.9264, 73.8816, -11.5440, 64.6464, -16.1616, GAMGI_IO_STROKE,

41.5584, -11.5440, 36.9408, -6.9264, 27.7056, 6.9264, 23.0880, 11.5440, GAMGI_IO_STROKE,

55.4112, -16.1616, 46.1760, -11.5440, 41.5584, -6.9264, 32.3232, 6.9264, 27.7056, 11.5440, 13.8528, 11.5440, 9.2352, 6.9264, 9.2352, -2.3088, 13.8528, -6.9264, 18.4704, -6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 91 [ strokes: 4 *
 *************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_STROKE,

23.0880, 117.7488, 23.0880, -30.0144, GAMGI_IO_STROKE,

18.4704, 117.7488, 50.7936, 117.7488, GAMGI_IO_STROKE,

18.4704, -30.0144, 50.7936, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 92 \ strokes: 2 *
 *************************/

13.8528, 117.7488, 96.9696, -30.0144, 92.3520, -30.0144, GAMGI_IO_STROKE,

13.8528, 117.7488, 9.2352, 117.7488, 92.3520, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 93 ] strokes: 4 *
 *************************/

41.5584, 117.7488, 41.5584, -30.0144, GAMGI_IO_STROKE,

46.1760, 117.7488, 46.1760, -30.0144, GAMGI_IO_STROKE,

13.8528, 117.7488, 46.1760, 117.7488, GAMGI_IO_STROKE,

13.8528, -30.0144, 46.1760, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 94 ^ strokes: 2 *
 *************************/

27.7056, 71.5728, 36.9408, 85.4256, 46.1760, 71.5728, GAMGI_IO_STROKE,

13.8528, 57.7200, 36.9408, 80.8080, 60.0288, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 95 _ strokes: 1 *
 *************************/

9.2352, -6.9264, 92.3520, -6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 96 ` strokes: 4 *
 *************************/

32.3232, 99.2784, 23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 71.5728, 23.0880, 66.9552, 27.7056, 66.9552, 32.3232, 71.5728, 32.3232, 76.1904, 27.7056, 80.8080, 23.0880, 80.8080, 18.4704, 76.1904, GAMGI_IO_STROKE,

23.0880, 76.1904, 23.0880, 71.5728, 27.7056, 71.5728, 27.7056, 76.1904, 23.0880, 76.1904, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 76.1904, GAMGI_IO_STROKE,

18.4704, 85.4256, 23.0880, 80.8080, GAMGI_IO_CHAR,

/*************************
 * char: 97 a strokes: 8 *
 *************************/

46.1760, 66.9552, 32.3232, 62.3376, 23.0880, 57.7200, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 25.3968, 18.4704, 11.5440, 23.0880, 2.3088, 50.7936, 16.1616, GAMGI_IO_STROKE,

18.4704, 25.3968, 23.0880, 11.5440, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 62.3376, 23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 30.0144, 23.0880, 16.1616, 32.3232, 6.9264, GAMGI_IO_STROKE,

36.9408, 62.3376, 41.5584, 57.7200, 50.7936, 53.1024, 50.7936, 11.5440, 60.0288, 2.3088, 73.8816, 16.1616, GAMGI_IO_STROKE,

41.5584, 62.3376, 55.4112, 53.1024, 55.4112, 16.1616, 64.6464, 6.9264, GAMGI_IO_STROKE,

46.1760, 66.9552, 50.7936, 62.3376, 60.0288, 57.7200, 64.6464, 57.7200, GAMGI_IO_STROKE,

60.0288, 53.1024, 64.6464, 57.7200, GAMGI_IO_STROKE,

60.0288, 53.1024, 60.0288, 16.1616, 64.6464, 11.5440, 69.2640, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 98 b strokes: 8 *
 *************************/

9.2352, 90.0432, 13.8528, 85.4256, 18.4704, 76.1904, GAMGI_IO_STROKE,

46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 18.4704, 16.1616, 13.8528, 11.5440, GAMGI_IO_STROKE,

27.7056, 85.4256, 23.0880, 76.1904, 23.0880, 16.1616, 36.9408, 6.9264, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 32.3232, 90.0432, 27.7056, 76.1904, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 6.9264, GAMGI_IO_STROKE,

13.8528, 11.5440, 18.4704, 11.5440, 27.7056, 6.9264, 32.3232, 2.3088, 46.1760, 6.9264, GAMGI_IO_STROKE,

27.7056, 53.1024, 55.4112, 66.9552, 60.0288, 57.7200, 64.6464, 43.8672, 64.6464, 30.0144, 60.0288, 16.1616, 55.4112, 11.5440, 46.1760, 6.9264, GAMGI_IO_STROKE,

50.7936, 62.3376, 55.4112, 57.7200, 60.0288, 48.4848, GAMGI_IO_STROKE,

46.1760, 62.3376, 55.4112, 53.1024, 60.0288, 39.2496, 60.0288, 30.0144, 55.4112, 16.1616, 46.1760, 6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 99 c strokes: 4 *
 *************************/

32.3232, 62.3376, 41.5584, 53.1024, 50.7936, 57.7200, 41.5584, 66.9552, 32.3232, 62.3376, 18.4704, 53.1024, 13.8528, 43.8672, 13.8528, 20.7792, 18.4704, 11.5440, 27.7056, 2.3088, 46.1760, 11.5440, GAMGI_IO_STROKE,

36.9408, 62.3376, 46.1760, 57.7200, GAMGI_IO_STROKE,

23.0880, 53.1024, 18.4704, 43.8672, 18.4704, 20.7792, 23.0880, 11.5440, 27.7056, 6.9264, GAMGI_IO_STROKE,

27.7056, 57.7200, 23.0880, 48.4848, 23.0880, 25.3968, 27.7056, 16.1616, 36.9408, 6.9264, GAMGI_IO_CHAR,

/**************************
 * char: 100 d strokes: 7 *
 **************************/

32.3232, 99.2784, 18.4704, 85.4256, 18.4704, 76.1904, 23.0880, 71.5728, 41.5584, 62.3376, 55.4112, 53.1024, 60.0288, 43.8672, 60.0288, 30.0144, 55.4112, 16.1616, 46.1760, 6.9264, GAMGI_IO_STROKE,

23.0880, 80.8080, 23.0880, 76.1904, 41.5584, 66.9552, 55.4112, 57.7200, 60.0288, 53.1024, GAMGI_IO_STROKE,

23.0880, 90.0432, 23.0880, 85.4256, 27.7056, 80.8080, 50.7936, 66.9552, 60.0288, 57.7200, 64.6464, 43.8672, 64.6464, 30.0144, 60.0288, 16.1616, 46.1760, 6.9264, 32.3232, 2.3088, GAMGI_IO_STROKE,

36.9408, 62.3376, 18.4704, 53.1024, 18.4704, 16.1616, 13.8528, 11.5440, GAMGI_IO_STROKE,

23.0880, 53.1024, 23.0880, 16.1616, 36.9408, 6.9264, GAMGI_IO_STROKE,

27.7056, 57.7200, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 6.9264, GAMGI_IO_STROKE,

13.8528, 11.5440, 18.4704, 11.5440, 27.7056, 6.9264, 32.3232, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 101 e strokes: 4 *
 **************************/

23.0880, 30.0144, 50.7936, 48.4848, 36.9408, 66.9552, 18.4704, 53.1024, 13.8528, 43.8672, 13.8528, 20.7792, 18.4704, 11.5440, 27.7056, 2.3088, 46.1760, 11.5440, GAMGI_IO_STROKE,

46.1760, 48.4848, 32.3232, 62.3376, GAMGI_IO_STROKE,

23.0880, 53.1024, 18.4704, 43.8672, 18.4704, 20.7792, 23.0880, 11.5440, 27.7056, 6.9264, GAMGI_IO_STROKE,

41.5584, 43.8672, 32.3232, 57.7200, 27.7056, 57.7200, 23.0880, 48.4848, 23.0880, 25.3968, 27.7056, 16.1616, 36.9408, 6.9264, GAMGI_IO_CHAR,

/**************************
 * char: 102 f strokes: 9 *
 **************************/

55.4112, 99.2784, 50.7936, 94.6608, 41.5584, 94.6608, 32.3232, 99.2784, 23.0880, 99.2784, 18.4704, 90.0432, 18.4704, 66.9552, 13.8528, 57.7200, 9.2352, 53.1024, GAMGI_IO_STROKE,

46.1760, 90.0432, 36.9408, 90.0432, 27.7056, 94.6608, 23.0880, 94.6608, GAMGI_IO_STROKE,

55.4112, 99.2784, 50.7936, 90.0432, 46.1760, 85.4256, 36.9408, 85.4256, 27.7056, 90.0432, 23.0880, 90.0432, 18.4704, 85.4256, GAMGI_IO_STROKE,

18.4704, 76.1904, 23.0880, 66.9552, 27.7056, 62.3376, 36.9408, 57.7200, 46.1760, 57.7200, 46.1760, 53.1024, GAMGI_IO_STROKE,

9.2352, 53.1024, 18.4704, 53.1024, GAMGI_IO_STROKE,

27.7056, 53.1024, 46.1760, 53.1024, GAMGI_IO_STROKE,

18.4704, 53.1024, 18.4704, 34.6320, 23.0880, -20.7792, GAMGI_IO_STROKE,

32.3232, 57.7200, 18.4704, 57.7200, 23.0880, 62.3376, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 53.1024, 27.7056, 34.6320, 23.0880, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 103 g strokes: 8 *
 **************************/

46.1760, 66.9552, 32.3232, 62.3376, 23.0880, 57.7200, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 25.3968, 18.4704, 11.5440, 23.0880, 2.3088, 50.7936, 16.1616, GAMGI_IO_STROKE,

18.4704, 20.7792, 23.0880, 11.5440, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 62.3376, 23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 30.0144, 23.0880, 16.1616, 32.3232, 6.9264, GAMGI_IO_STROKE,

36.9408, 62.3376, 41.5584, 57.7200, 50.7936, 53.1024, 50.7936, 16.1616, 55.4112, 2.3088, 55.4112, -6.9264, 50.7936, -16.1616, GAMGI_IO_STROKE,

41.5584, 62.3376, 55.4112, 53.1024, 55.4112, 6.9264, GAMGI_IO_STROKE,

46.1760, 66.9552, 50.7936, 62.3376, 60.0288, 57.7200, 64.6464, 57.7200, GAMGI_IO_STROKE,

60.0288, 53.1024, 64.6464, 57.7200, GAMGI_IO_STROKE,

60.0288, 53.1024, 60.0288, -2.3088, 55.4112, -11.5440, 50.7936, -16.1616, 41.5584, -20.7792, 27.7056, -20.7792, 18.4704, -16.1616, 13.8528, -11.5440, 13.8528, -6.9264, 18.4704, -6.9264, 18.4704, -11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 104 h strokes: 8 *
 **************************/

9.2352, 90.0432, 13.8528, 85.4256, 18.4704, 76.1904, GAMGI_IO_STROKE,

46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 18.4704, 16.1616, 13.8528, 11.5440, GAMGI_IO_STROKE,

27.7056, 85.4256, 23.0880, 76.1904, 23.0880, 11.5440, 27.7056, 6.9264, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 32.3232, 90.0432, 27.7056, 76.1904, 27.7056, 16.1616, 32.3232, 11.5440, 36.9408, 11.5440, GAMGI_IO_STROKE,

13.8528, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, 41.5584, 16.1616, GAMGI_IO_STROKE,

27.7056, 53.1024, 55.4112, 66.9552, 60.0288, 57.7200, 64.6464, 39.2496, 64.6464, 20.7792, 60.0288, 6.9264, 55.4112, -2.3088, 46.1760, -11.5440, 32.3232, -20.7792, GAMGI_IO_STROKE,

50.7936, 62.3376, 55.4112, 57.7200, 60.0288, 43.8672, GAMGI_IO_STROKE,

46.1760, 62.3376, 55.4112, 48.4848, 60.0288, 34.6320, 60.0288, 20.7792, 55.4112, 2.3088, 46.1760, -11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 105 i strokes: 8 *
 **************************/

23.0880, 99.2784, 18.4704, 94.6608, 18.4704, 90.0432, 23.0880, 85.4256, 27.7056, 90.0432, 27.7056, 94.6608, 23.0880, 99.2784, GAMGI_IO_STROKE,

18.4704, 94.6608, 27.7056, 90.0432, GAMGI_IO_STROKE,

18.4704, 90.0432, 27.7056, 94.6608, GAMGI_IO_STROKE,

9.2352, 57.7200, 13.8528, 57.7200, 18.4704, 53.1024, 18.4704, 11.5440, 27.7056, 2.3088, 41.5584, 16.1616, GAMGI_IO_STROKE,

13.8528, 62.3376, 23.0880, 57.7200, 23.0880, 16.1616, 32.3232, 6.9264, GAMGI_IO_STROKE,

4.6176, 53.1024, 18.4704, 66.9552, 23.0880, 62.3376, 32.3232, 57.7200, GAMGI_IO_STROKE,

27.7056, 53.1024, 32.3232, 57.7200, GAMGI_IO_STROKE,

27.7056, 53.1024, 27.7056, 16.1616, 32.3232, 11.5440, 36.9408, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 106 j strokes: 9 *
 **************************/

23.0880, 99.2784, 18.4704, 94.6608, 18.4704, 90.0432, 23.0880, 85.4256, 27.7056, 90.0432, 27.7056, 94.6608, 23.0880, 99.2784, GAMGI_IO_STROKE,

18.4704, 94.6608, 27.7056, 90.0432, GAMGI_IO_STROKE,

18.4704, 90.0432, 27.7056, 94.6608, GAMGI_IO_STROKE,

9.2352, 57.7200, 13.8528, 57.7200, 18.4704, 53.1024, 18.4704, 2.3088, 13.8528, -11.5440, 9.2352, -16.1616, 0.0000, -20.7792, GAMGI_IO_STROKE,

13.8528, 62.3376, 23.0880, 57.7200, 23.0880, 2.3088, 18.4704, -6.9264, GAMGI_IO_STROKE,

4.6176, 53.1024, 18.4704, 66.9552, 23.0880, 62.3376, 32.3232, 57.7200, GAMGI_IO_STROKE,

27.7056, 53.1024, 32.3232, 57.7200, GAMGI_IO_STROKE,

27.7056, 53.1024, 27.7056, 2.3088, 23.0880, -6.9264, 13.8528, -16.1616, 0.0000, -20.7792, GAMGI_IO_STROKE,

27.7056, 2.3088, 32.3232, -6.9264, 36.9408, -11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 107 k strokes: 13 *
 **************************/

13.8528, 90.0432, 18.4704, 85.4256, 23.0880, 76.1904, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 27.7056, 85.4256, 23.0880, 76.1904, 23.0880, 66.9552, 18.4704, 57.7200, 13.8528, 53.1024, GAMGI_IO_STROKE,

23.0880, 53.1024, 23.0880, 16.1616, 18.4704, 11.5440, GAMGI_IO_STROKE,

32.3232, 85.4256, 27.7056, 76.1904, 27.7056, 66.9552, GAMGI_IO_STROKE,

27.7056, 57.7200, 23.0880, 57.7200, 27.7056, 66.9552, 27.7056, 16.1616, 36.9408, 6.9264, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 90.0432, 32.3232, 76.1904, 32.3232, 57.7200, GAMGI_IO_STROKE,

32.3232, 53.1024, 32.3232, 16.1616, 36.9408, 11.5440, 41.5584, 11.5440, GAMGI_IO_STROKE,

18.4704, 11.5440, 27.7056, 6.9264, 32.3232, 2.3088, 46.1760, 16.1616, GAMGI_IO_STROKE,

32.3232, 71.5728, 50.7936, 85.4256, 55.4112, 80.8080, 55.4112, 71.5728, 46.1760, 62.3376, 36.9408, 57.7200, GAMGI_IO_STROKE,

46.1760, 80.8080, 50.7936, 76.1904, 50.7936, 71.5728, 46.1760, 62.3376, GAMGI_IO_STROKE,

32.3232, 57.7200, 55.4112, 57.7200, 55.4112, 53.1024, GAMGI_IO_STROKE,

13.8528, 53.1024, 23.0880, 53.1024, GAMGI_IO_STROKE,

32.3232, 53.1024, 55.4112, 53.1024, GAMGI_IO_CHAR,

/**************************
 * char: 108 l strokes: 5 *
 **************************/

9.2352, 90.0432, 13.8528, 85.4256, 18.4704, 76.1904, GAMGI_IO_STROKE,

46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 18.4704, 16.1616, 13.8528, 11.5440, GAMGI_IO_STROKE,

27.7056, 85.4256, 23.0880, 76.1904, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 32.3232, 90.0432, 27.7056, 76.1904, 27.7056, 16.1616, 32.3232, 11.5440, 36.9408, 11.5440, GAMGI_IO_STROKE,

13.8528, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, 41.5584, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 109 m strokes: 11 *
 **************************/

9.2352, 57.7200, 13.8528, 57.7200, 18.4704, 53.1024, 18.4704, 16.1616, 13.8528, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

13.8528, 62.3376, 23.0880, 53.1024, 23.0880, 16.1616, 18.4704, 11.5440, 23.0880, 6.9264, 27.7056, 11.5440, 23.0880, 16.1616, GAMGI_IO_STROKE,

4.6176, 53.1024, 18.4704, 66.9552, 27.7056, 57.7200, 27.7056, 16.1616, 32.3232, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

41.5584, 62.3376, 50.7936, 57.7200, 55.4112, 48.4848, 55.4112, 16.1616, 50.7936, 11.5440, 60.0288, 2.3088, GAMGI_IO_STROKE,

50.7936, 62.3376, 55.4112, 57.7200, 60.0288, 48.4848, 60.0288, 16.1616, 55.4112, 11.5440, 60.0288, 6.9264, 64.6464, 11.5440, 60.0288, 16.1616, GAMGI_IO_STROKE,

27.7056, 53.1024, 41.5584, 62.3376, 50.7936, 66.9552, 60.0288, 62.3376, 64.6464, 53.1024, 64.6464, 16.1616, 69.2640, 11.5440, 60.0288, 2.3088, GAMGI_IO_STROKE,

78.4992, 62.3376, 83.1168, 57.7200, 92.3520, 53.1024, 92.3520, 11.5440, 101.5872, 2.3088, 115.4400, 16.1616, GAMGI_IO_STROKE,

83.1168, 62.3376, 96.9696, 53.1024, 96.9696, 16.1616, 106.2048, 6.9264, GAMGI_IO_STROKE,

64.6464, 53.1024, 78.4992, 62.3376, 87.7344, 66.9552, 92.3520, 62.3376, 101.5872, 57.7200, 106.2048, 57.7200, GAMGI_IO_STROKE,

101.5872, 53.1024, 106.2048, 57.7200, GAMGI_IO_STROKE,

101.5872, 53.1024, 101.5872, 16.1616, 106.2048, 11.5440, 110.8224, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 110 n strokes: 8 *
 **************************/

9.2352, 57.7200, 13.8528, 57.7200, 18.4704, 53.1024, 18.4704, 16.1616, 13.8528, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

13.8528, 62.3376, 23.0880, 53.1024, 23.0880, 16.1616, 18.4704, 11.5440, 23.0880, 6.9264, 27.7056, 11.5440, 23.0880, 16.1616, GAMGI_IO_STROKE,

4.6176, 53.1024, 18.4704, 66.9552, 27.7056, 57.7200, 27.7056, 16.1616, 32.3232, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

41.5584, 62.3376, 46.1760, 57.7200, 55.4112, 53.1024, 55.4112, 11.5440, 64.6464, 2.3088, 78.4992, 16.1616, GAMGI_IO_STROKE,

46.1760, 62.3376, 60.0288, 53.1024, 60.0288, 16.1616, 69.2640, 6.9264, GAMGI_IO_STROKE,

27.7056, 53.1024, 41.5584, 62.3376, 50.7936, 66.9552, 55.4112, 62.3376, 64.6464, 57.7200, 69.2640, 57.7200, GAMGI_IO_STROKE,

64.6464, 53.1024, 69.2640, 57.7200, GAMGI_IO_STROKE,

64.6464, 53.1024, 64.6464, 16.1616, 69.2640, 11.5440, 73.8816, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 111 o strokes: 7 *
 **************************/

18.4704, 53.1024, 18.4704, 16.1616, 13.8528, 11.5440, GAMGI_IO_STROKE,

23.0880, 53.1024, 23.0880, 16.1616, 36.9408, 6.9264, GAMGI_IO_STROKE,

32.3232, 57.7200, 27.7056, 53.1024, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 6.9264, GAMGI_IO_STROKE,

13.8528, 11.5440, 18.4704, 11.5440, 27.7056, 6.9264, 32.3232, 2.3088, 46.1760, 6.9264, GAMGI_IO_STROKE,

18.4704, 53.1024, 32.3232, 57.7200, 55.4112, 66.9552, 60.0288, 57.7200, 64.6464, 43.8672, 64.6464, 30.0144, 60.0288, 16.1616, 55.4112, 11.5440, 46.1760, 6.9264, GAMGI_IO_STROKE,

50.7936, 62.3376, 55.4112, 57.7200, 60.0288, 48.4848, GAMGI_IO_STROKE,

46.1760, 62.3376, 55.4112, 53.1024, 60.0288, 39.2496, 60.0288, 30.0144, 55.4112, 16.1616, 46.1760, 6.9264, GAMGI_IO_CHAR,

/**************************
 * char: 112 p strokes: 11 *
 **************************/

23.0880, 80.8080, 13.8528, 71.5728, 13.8528, 62.3376, 18.4704, 48.4848, 18.4704, 16.1616, 9.2352, 6.9264, GAMGI_IO_STROKE,

18.4704, 11.5440, 23.0880, -20.7792, GAMGI_IO_STROKE,

18.4704, 66.9552, 18.4704, 62.3376, 23.0880, 48.4848, 23.0880, 2.3088, GAMGI_IO_STROKE,

18.4704, 76.1904, 18.4704, 71.5728, 23.0880, 62.3376, 27.7056, 48.4848, 27.7056, 16.1616, 32.3232, 16.1616, 41.5584, 11.5440, 46.1760, 6.9264, GAMGI_IO_STROKE,

27.7056, 11.5440, 23.0880, -20.7792, GAMGI_IO_STROKE,

41.5584, 6.9264, 32.3232, 11.5440, GAMGI_IO_STROKE,

46.1760, 6.9264, 36.9408, 2.3088, 27.7056, 11.5440, GAMGI_IO_STROKE,

18.4704, 11.5440, 9.2352, 6.9264, GAMGI_IO_STROKE,

27.7056, 53.1024, 55.4112, 66.9552, 60.0288, 57.7200, 64.6464, 43.8672, 64.6464, 30.0144, 60.0288, 16.1616, 55.4112, 11.5440, 46.1760, 6.9264, GAMGI_IO_STROKE,

50.7936, 62.3376, 55.4112, 57.7200, 60.0288, 48.4848, GAMGI_IO_STROKE,

46.1760, 62.3376, 55.4112, 53.1024, 60.0288, 39.2496, 60.0288, 30.0144, 55.4112, 16.1616, 46.1760, 6.9264, GAMGI_IO_CHAR,

/**************************
 * char: 113 q strokes: 8 *
 **************************/

46.1760, 66.9552, 32.3232, 62.3376, 23.0880, 57.7200, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 25.3968, 18.4704, 11.5440, 23.0880, 2.3088, 50.7936, 16.1616, GAMGI_IO_STROKE,

18.4704, 20.7792, 23.0880, 11.5440, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 62.3376, 23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 30.0144, 23.0880, 16.1616, 32.3232, 6.9264, GAMGI_IO_STROKE,

36.9408, 62.3376, 41.5584, 57.7200, 50.7936, 53.1024, 50.7936, 16.1616, 55.4112, -20.7792, GAMGI_IO_STROKE,

41.5584, 62.3376, 55.4112, 53.1024, 55.4112, 2.3088, GAMGI_IO_STROKE,

46.1760, 66.9552, 50.7936, 62.3376, 60.0288, 57.7200, 64.6464, 57.7200, GAMGI_IO_STROKE,

60.0288, 53.1024, 64.6464, 57.7200, GAMGI_IO_STROKE,

60.0288, 53.1024, 60.0288, 16.1616, 55.4112, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 114 r strokes: 6 *
 **************************/

13.8528, 57.7200, 18.4704, 57.7200, 23.0880, 53.1024, 23.0880, 16.1616, 18.4704, 11.5440, GAMGI_IO_STROKE,

18.4704, 62.3376, 27.7056, 53.1024, 27.7056, 11.5440, 36.9408, 6.9264, GAMGI_IO_STROKE,

9.2352, 53.1024, 23.0880, 66.9552, 32.3232, 57.7200, 32.3232, 16.1616, 36.9408, 11.5440, 41.5584, 11.5440, GAMGI_IO_STROKE,

18.4704, 11.5440, 27.7056, 6.9264, 32.3232, 2.3088, 46.1760, 16.1616, GAMGI_IO_STROKE,

41.5584, 62.3376, 46.1760, 53.1024, 55.4112, 57.7200, 50.7936, 66.9552, 32.3232, 57.7200, GAMGI_IO_STROKE,

46.1760, 62.3376, 50.7936, 57.7200, GAMGI_IO_CHAR,

/**************************
 * char: 115 s strokes: 8 *
 **************************/

55.4112, 99.2784, 50.7936, 94.6608, 41.5584, 94.6608, 32.3232, 99.2784, 23.0880, 99.2784, 18.4704, 90.0432, 18.4704, 66.9552, 13.8528, 57.7200, 9.2352, 53.1024, GAMGI_IO_STROKE,

46.1760, 90.0432, 36.9408, 90.0432, 27.7056, 94.6608, 23.0880, 94.6608, GAMGI_IO_STROKE,

55.4112, 99.2784, 50.7936, 90.0432, 46.1760, 85.4256, 36.9408, 85.4256, 27.7056, 90.0432, 23.0880, 90.0432, 18.4704, 85.4256, GAMGI_IO_STROKE,

18.4704, 76.1904, 27.7056, 53.1024, GAMGI_IO_STROKE,

18.4704, 53.1024, 18.4704, 34.6320, 23.0880, -20.7792, GAMGI_IO_STROKE,

23.0880, 57.7200, 18.4704, 57.7200, 23.0880, 62.3376, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 53.1024, 27.7056, 34.6320, 23.0880, -20.7792, GAMGI_IO_STROKE,

9.2352, 53.1024, 18.4704, 53.1024, GAMGI_IO_CHAR,

/**************************
 * char: 116 t strokes: 8 *
 **************************/

32.3232, 85.4256, 27.7056, 71.5728, 23.0880, 62.3376, 18.4704, 57.7200, 9.2352, 53.1024, GAMGI_IO_STROKE,

32.3232, 85.4256, 32.3232, 57.7200, 46.1760, 57.7200, 46.1760, 53.1024, GAMGI_IO_STROKE,

9.2352, 53.1024, 23.0880, 53.1024, GAMGI_IO_STROKE,

32.3232, 53.1024, 46.1760, 53.1024, GAMGI_IO_STROKE,

23.0880, 53.1024, 23.0880, 16.1616, 18.4704, 11.5440, GAMGI_IO_STROKE,

27.7056, 57.7200, 23.0880, 57.7200, 27.7056, 66.9552, 27.7056, 16.1616, 36.9408, 6.9264, GAMGI_IO_STROKE,

32.3232, 53.1024, 32.3232, 16.1616, 36.9408, 11.5440, 41.5584, 11.5440, GAMGI_IO_STROKE,

18.4704, 11.5440, 27.7056, 6.9264, 32.3232, 2.3088, 46.1760, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 117 u strokes: 7 *
 **************************/

9.2352, 57.7200, 13.8528, 57.7200, 18.4704, 53.1024, 18.4704, 16.1616, 13.8528, 11.5440, GAMGI_IO_STROKE,

13.8528, 62.3376, 23.0880, 53.1024, 23.0880, 16.1616, 32.3232, 6.9264, GAMGI_IO_STROKE,

4.6176, 53.1024, 18.4704, 66.9552, 27.7056, 57.7200, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 6.9264, GAMGI_IO_STROKE,

13.8528, 11.5440, 18.4704, 11.5440, 27.7056, 6.9264, 32.3232, 2.3088, 41.5584, 6.9264, 55.4112, 16.1616, GAMGI_IO_STROKE,

60.0288, 66.9552, 50.7936, 57.7200, 55.4112, 53.1024, 55.4112, 11.5440, 64.6464, 2.3088, 78.4992, 16.1616, GAMGI_IO_STROKE,

60.0288, 53.1024, 64.6464, 57.7200, 60.0288, 62.3376, 55.4112, 57.7200, 60.0288, 53.1024, 60.0288, 16.1616, 69.2640, 6.9264, GAMGI_IO_STROKE,

60.0288, 66.9552, 69.2640, 57.7200, 64.6464, 53.1024, 64.6464, 16.1616, 69.2640, 11.5440, 73.8816, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 118 v strokes: 7 *
 **************************/

23.0880, 76.1904, 13.8528, 66.9552, 13.8528, 57.7200, 18.4704, 43.8672, 18.4704, 16.1616, 13.8528, 11.5440, GAMGI_IO_STROKE,

18.4704, 62.3376, 18.4704, 57.7200, 23.0880, 43.8672, 23.0880, 16.1616, 36.9408, 6.9264, GAMGI_IO_STROKE,

18.4704, 71.5728, 18.4704, 66.9552, 23.0880, 57.7200, 27.7056, 43.8672, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 6.9264, GAMGI_IO_STROKE,

13.8528, 11.5440, 18.4704, 11.5440, 27.7056, 6.9264, 32.3232, 2.3088, 46.1760, 6.9264, GAMGI_IO_STROKE,

27.7056, 53.1024, 55.4112, 66.9552, 60.0288, 57.7200, 64.6464, 43.8672, 64.6464, 30.0144, 60.0288, 16.1616, 55.4112, 11.5440, 46.1760, 6.9264, GAMGI_IO_STROKE,

50.7936, 62.3376, 55.4112, 57.7200, 60.0288, 48.4848, GAMGI_IO_STROKE,

46.1760, 62.3376, 55.4112, 53.1024, 60.0288, 39.2496, 60.0288, 30.0144, 55.4112, 16.1616, 46.1760, 6.9264, GAMGI_IO_CHAR,

/**************************
 * char: 119 w strokes: 10 *
 **************************/

23.0880, 76.1904, 13.8528, 66.9552, 13.8528, 57.7200, 18.4704, 43.8672, 18.4704, 16.1616, 13.8528, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

18.4704, 62.3376, 18.4704, 57.7200, 23.0880, 43.8672, 23.0880, 16.1616, 18.4704, 11.5440, 23.0880, 6.9264, 27.7056, 11.5440, 23.0880, 16.1616, GAMGI_IO_STROKE,

18.4704, 71.5728, 18.4704, 66.9552, 23.0880, 57.7200, 27.7056, 43.8672, 27.7056, 16.1616, 32.3232, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

41.5584, 62.3376, 50.7936, 57.7200, 55.4112, 48.4848, 55.4112, 16.1616, 50.7936, 11.5440, GAMGI_IO_STROKE,

50.7936, 62.3376, 55.4112, 57.7200, 60.0288, 48.4848, 60.0288, 16.1616, 73.8816, 6.9264, GAMGI_IO_STROKE,

27.7056, 53.1024, 41.5584, 62.3376, 50.7936, 66.9552, 60.0288, 62.3376, 64.6464, 53.1024, 64.6464, 16.1616, 73.8816, 11.5440, 78.4992, 6.9264, GAMGI_IO_STROKE,

50.7936, 11.5440, 55.4112, 11.5440, 64.6464, 6.9264, 69.2640, 2.3088, 83.1168, 6.9264, GAMGI_IO_STROKE,

64.6464, 53.1024, 92.3520, 66.9552, 96.9696, 57.7200, 101.5872, 43.8672, 101.5872, 34.6320, 96.9696, 16.1616, 92.3520, 11.5440, 83.1168, 6.9264, GAMGI_IO_STROKE,

87.7344, 62.3376, 92.3520, 57.7200, 96.9696, 48.4848, GAMGI_IO_STROKE,

83.1168, 62.3376, 92.3520, 53.1024, 96.9696, 39.2496, 96.9696, 30.0144, 92.3520, 16.1616, 83.1168, 6.9264, GAMGI_IO_CHAR,

/**************************
 * char: 120 x strokes: 6 *
 **************************/

18.4704, 57.7200, 23.0880, 57.7200, 27.7056, 53.1024, 27.7056, 16.1616, 23.0880, 16.1616, 13.8528, 11.5440, 9.2352, 2.3088, 9.2352, -6.9264, 13.8528, -16.1616, 23.0880, -20.7792, 36.9408, -20.7792, 50.7936, -16.1616, 50.7936, -11.5440, 46.1760, -11.5440, 46.1760, -16.1616, GAMGI_IO_STROKE,

23.0880, 62.3376, 32.3232, 53.1024, 32.3232, 16.1616, 46.1760, 6.9264, GAMGI_IO_STROKE,

13.8528, 53.1024, 27.7056, 66.9552, 36.9408, 57.7200, 36.9408, 16.1616, 46.1760, 11.5440, 50.7936, 6.9264, GAMGI_IO_STROKE,

60.0288, 11.5440, 41.5584, 2.3088, 36.9408, 6.9264, 27.7056, 11.5440, 18.4704, 11.5440, 9.2352, 2.3088, GAMGI_IO_STROKE,

46.1760, 62.3376, 50.7936, 53.1024, 60.0288, 57.7200, 55.4112, 66.9552, 36.9408, 57.7200, GAMGI_IO_STROKE,

50.7936, 62.3376, 55.4112, 57.7200, GAMGI_IO_CHAR,

/**************************
 * char: 121 y strokes: 7 *
 **************************/

23.0880, 76.1904, 13.8528, 66.9552, 13.8528, 57.7200, 18.4704, 43.8672, 18.4704, 16.1616, 13.8528, 11.5440, GAMGI_IO_STROKE,

18.4704, 62.3376, 18.4704, 57.7200, 23.0880, 43.8672, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

18.4704, 71.5728, 18.4704, 66.9552, 23.0880, 57.7200, 27.7056, 43.8672, 27.7056, 16.1616, 32.3232, 11.5440, 36.9408, 11.5440, GAMGI_IO_STROKE,

13.8528, 11.5440, 23.0880, 6.9264, 27.7056, 2.3088, 41.5584, 16.1616, GAMGI_IO_STROKE,

27.7056, 53.1024, 55.4112, 66.9552, 60.0288, 57.7200, 64.6464, 39.2496, 64.6464, 20.7792, 60.0288, 6.9264, 55.4112, -2.3088, 46.1760, -11.5440, 32.3232, -20.7792, GAMGI_IO_STROKE,

50.7936, 62.3376, 55.4112, 57.7200, 60.0288, 43.8672, GAMGI_IO_STROKE,

46.1760, 62.3376, 55.4112, 48.4848, 60.0288, 34.6320, 60.0288, 20.7792, 55.4112, 2.3088, 46.1760, -11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 122 z strokes: 6 *
 **************************/

13.8528, 53.1024, 36.9408, 66.9552, 46.1760, 62.3376, 50.7936, 53.1024, 50.7936, 43.8672, 46.1760, 34.6320, 27.7056, 25.3968, GAMGI_IO_STROKE,

36.9408, 62.3376, 46.1760, 57.7200, GAMGI_IO_STROKE,

32.3232, 62.3376, 41.5584, 57.7200, 46.1760, 48.4848, 46.1760, 43.8672, 41.5584, 34.6320, 36.9408, 30.0144, GAMGI_IO_STROKE,

36.9408, 30.0144, 46.1760, 20.7792, 50.7936, 11.5440, 50.7936, -6.9264, 46.1760, -16.1616, 36.9408, -20.7792, 27.7056, -20.7792, 18.4704, -16.1616, 13.8528, -6.9264, 13.8528, 2.3088, 18.4704, 11.5440, 27.7056, 16.1616, 55.4112, 25.3968, GAMGI_IO_STROKE,

32.3232, 25.3968, 41.5584, 20.7792, 46.1760, 11.5440, GAMGI_IO_STROKE,

27.7056, 25.3968, 41.5584, 16.1616, 46.1760, 6.9264, 46.1760, -6.9264, 41.5584, -16.1616, 36.9408, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 123 { strokes: 3 *
 **************************/

46.1760, 117.7488, 32.3232, 103.8960, 27.7056, 90.0432, 27.7056, 80.8080, 32.3232, 66.9552, 41.5584, 57.7200, 41.5584, 53.1024, 23.0880, 43.8672, 41.5584, 34.6320, 41.5584, 30.0144, 32.3232, 20.7792, 27.7056, 6.9264, 27.7056, -2.3088, 32.3232, -16.1616, 46.1760, -30.0144, GAMGI_IO_STROKE,

36.9408, 108.5136, 32.3232, 94.6608, 32.3232, 76.1904, 36.9408, 62.3376, GAMGI_IO_STROKE,

36.9408, 25.3968, 32.3232, 11.5440, 32.3232, -6.9264, 36.9408, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 124 | strokes: 2 *
 **************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_STROKE,

23.0880, 117.7488, 23.0880, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 125 } strokes: 3 *
 **************************/

23.0880, 117.7488, 36.9408, 103.8960, 41.5584, 90.0432, 41.5584, 80.8080, 36.9408, 66.9552, 27.7056, 57.7200, 27.7056, 53.1024, 46.1760, 43.8672, 27.7056, 34.6320, 27.7056, 30.0144, 36.9408, 20.7792, 41.5584, 6.9264, 41.5584, -2.3088, 36.9408, -16.1616, 23.0880, -30.0144, GAMGI_IO_STROKE,

32.3232, 108.5136, 36.9408, 94.6608, 36.9408, 76.1904, 32.3232, 62.3376, GAMGI_IO_STROKE,

32.3232, 25.3968, 36.9408, 11.5440, 36.9408, -6.9264, 32.3232, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 126 ~ strokes: 2 *
 **************************/

13.8528, 30.0144, 13.8528, 39.2496, 18.4704, 53.1024, 27.7056, 57.7200, 36.9408, 57.7200, 46.1760, 53.1024, 64.6464, 39.2496, 73.8816, 34.6320, 83.1168, 34.6320, 92.3520, 39.2496, 96.9696, 48.4848, GAMGI_IO_STROKE,

13.8528, 39.2496, 18.4704, 48.4848, 27.7056, 53.1024, 36.9408, 53.1024, 46.1760, 48.4848, 64.6464, 34.6320, 73.8816, 30.0144, 83.1168, 30.0144, 92.3520, 34.6320, 96.9696, 48.4848, 96.9696, 57.7200, GAMGI_IO_CHAR,

};

const float gamgi_io_font_hershey_gothic_italian_points[GAMGI_IO_POINTS_GOTHIC_ITALIAN] = {

/***************
 * bottom, top *
 ***************/

-32.3232, 120.0576,

/**************
 * char 32-40 *
 **************/

73.8816, 50.7936, 83.1168, 106.2048, 92.3520, 110.8224, 120.0576, 50.7936, 64.6464, 

/**************
 * char 41-50 *
 **************/

64.6464, 73.8816, 115.4400, 50.7936, 115.4400, 50.7936, 106.2048, 92.3520, 92.3520, 92.3520, 

/**************
 * char 51-60 *
 **************/

92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 50.7936, 50.7936, 110.8224, 

/**************
 * char 61-70 *
 **************/

115.4400, 110.8224, 87.7344, 124.6752, 120.0576, 120.0576, 120.0576, 120.0576, 120.0576, 120.0576, 

/**************
 * char 71-80 *
 **************/

120.0576, 120.0576, 120.0576, 120.0576, 120.0576, 120.0576, 120.0576, 120.0576, 120.0576, 120.0576, 

/**************
 * char 81-90 *
 **************/

120.0576, 120.0576, 120.0576, 120.0576, 120.0576, 120.0576, 120.0576, 120.0576, 120.0576, 120.0576, 

/***************
 * char 91-100 *
 ***************/

64.6464, 106.2048, 64.6464, 73.8816, 101.5872, 50.7936, 78.4992, 78.4992, 55.4112, 73.8816, 

/****************
 * char 101-110 *
 ****************/

60.0288, 55.4112, 78.4992, 83.1168, 46.1760, 46.1760, 78.4992, 46.1760, 120.0576, 83.1168, 

/****************
 * char 111-120 *
 ****************/

73.8816, 78.4992, 78.4992, 60.0288, 73.8816, 46.1760, 83.1168, 83.1168, 120.0576, 83.1168, 

/****************
 * char 121-126 *
 ****************/

83.1168, 69.2640, 69.2640, 41.5584, 69.2640, 110.8224, 

/*************************
 * char: 32   strokes: 0 *
 *************************/

GAMGI_IO_CHAR,

/*************************
 * char: 33 ! strokes: 6 *
 *************************/

23.0880, 99.2784, 18.4704, 94.6608, 18.4704, 85.4256, 23.0880, 48.4848, GAMGI_IO_STROKE,

23.0880, 99.2784, 23.0880, 34.6320, 27.7056, 34.6320, GAMGI_IO_STROKE,

23.0880, 99.2784, 27.7056, 99.2784, 27.7056, 34.6320, GAMGI_IO_STROKE,

27.7056, 99.2784, 32.3232, 94.6608, 32.3232, 85.4256, 27.7056, 48.4848, GAMGI_IO_STROKE,

23.0880, 16.1616, 18.4704, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 2.3088, 32.3232, 6.9264, 32.3232, 11.5440, 27.7056, 16.1616, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 34 " strokes: 6 *
 *************************/

23.0880, 99.2784, 18.4704, 94.6608, 18.4704, 66.9552, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 66.9552, GAMGI_IO_STROKE,

23.0880, 99.2784, 27.7056, 94.6608, 18.4704, 66.9552, GAMGI_IO_STROKE,

64.6464, 99.2784, 60.0288, 94.6608, 60.0288, 66.9552, GAMGI_IO_STROKE,

64.6464, 94.6608, 60.0288, 66.9552, GAMGI_IO_STROKE,

64.6464, 99.2784, 69.2640, 94.6608, 60.0288, 66.9552, GAMGI_IO_CHAR,

/*************************
 * char: 35 # strokes: 8 *
 *************************/

36.9408, 99.2784, 36.9408, -30.0144, 41.5584, -30.0144, GAMGI_IO_STROKE,

36.9408, 99.2784, 41.5584, 99.2784, 41.5584, -30.0144, GAMGI_IO_STROKE,

64.6464, 99.2784, 64.6464, -30.0144, 69.2640, -30.0144, GAMGI_IO_STROKE,

64.6464, 99.2784, 69.2640, 99.2784, 69.2640, -30.0144, GAMGI_IO_STROKE,

13.8528, 53.1024, 92.3520, 53.1024, 92.3520, 48.4848, GAMGI_IO_STROKE,

13.8528, 53.1024, 13.8528, 48.4848, 92.3520, 48.4848, GAMGI_IO_STROKE,

13.8528, 20.7792, 92.3520, 20.7792, 92.3520, 16.1616, GAMGI_IO_STROKE,

13.8528, 20.7792, 13.8528, 16.1616, 92.3520, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 36 $ strokes: 5 *
 *************************/

36.9408, 117.7488, 36.9408, -16.1616, GAMGI_IO_STROKE,

55.4112, 117.7488, 55.4112, -16.1616, GAMGI_IO_STROKE,

73.8816, 76.1904, 73.8816, 80.8080, 69.2640, 80.8080, 69.2640, 71.5728, 78.4992, 71.5728, 78.4992, 80.8080, 73.8816, 90.0432, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, 23.0880, 94.6608, 13.8528, 85.4256, 13.8528, 71.5728, 18.4704, 62.3376, 32.3232, 53.1024, 60.0288, 43.8672, 69.2640, 39.2496, 73.8816, 30.0144, 73.8816, 16.1616, 69.2640, 6.9264, GAMGI_IO_STROKE,

18.4704, 71.5728, 23.0880, 62.3376, 32.3232, 57.7200, 60.0288, 48.4848, 69.2640, 43.8672, 73.8816, 34.6320, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 76.1904, 23.0880, 66.9552, 32.3232, 62.3376, 60.0288, 53.1024, 73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 20.7792, 73.8816, 11.5440, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 30.0144, 23.0880, 30.0144, 23.0880, 20.7792, 18.4704, 20.7792, 18.4704, 25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 37 % strokes: 12 *
 **************************/

96.9696, 99.2784, 87.7344, 94.6608, 73.8816, 90.0432, 60.0288, 90.0432, 46.1760, 94.6608, 36.9408, 99.2784, 27.7056, 99.2784, 18.4704, 94.6608, 13.8528, 85.4256, 13.8528, 76.1904, 23.0880, 66.9552, 32.3232, 66.9552, 41.5584, 71.5728, 46.1760, 80.8080, 46.1760, 90.0432, 36.9408, 99.2784, GAMGI_IO_STROKE,

96.9696, 99.2784, 9.2352, 2.3088, GAMGI_IO_STROKE,

96.9696, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

96.9696, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

87.7344, 34.6320, 78.4992, 34.6320, 69.2640, 30.0144, 64.6464, 20.7792, 64.6464, 11.5440, 73.8816, 2.3088, 83.1168, 2.3088, 92.3520, 6.9264, 96.9696, 16.1616, 96.9696, 25.3968, 87.7344, 34.6320, GAMGI_IO_STROKE,

41.5584, 94.6608, 27.7056, 99.2784, 13.8528, 85.4256, 18.4704, 71.5728, 32.3232, 66.9552, 46.1760, 80.8080, 41.5584, 94.6608, GAMGI_IO_STROKE,

36.9408, 99.2784, 18.4704, 94.6608, 13.8528, 76.1904, GAMGI_IO_STROKE,

23.0880, 66.9552, 41.5584, 71.5728, 46.1760, 90.0432, GAMGI_IO_STROKE,

92.3520, 30.0144, 78.4992, 34.6320, 64.6464, 20.7792, 69.2640, 6.9264, 83.1168, 2.3088, 96.9696, 16.1616, 92.3520, 30.0144, GAMGI_IO_STROKE,

87.7344, 34.6320, 69.2640, 30.0144, 64.6464, 11.5440, GAMGI_IO_STROKE,

73.8816, 2.3088, 92.3520, 6.9264, 96.9696, 25.3968, GAMGI_IO_STROKE,

9.2352, 2.3088, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 38 & strokes: 8 *
 *************************/

101.5872, 57.7200, 101.5872, 62.3376, 96.9696, 62.3376, 96.9696, 53.1024, 106.2048, 53.1024, 106.2048, 62.3376, 101.5872, 66.9552, 96.9696, 66.9552, 92.3520, 62.3376, 87.7344, 53.1024, 78.4992, 30.0144, 69.2640, 16.1616, 60.0288, 6.9264, 50.7936, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, 18.4704, 16.1616, 18.4704, 30.0144, 23.0880, 39.2496, 50.7936, 57.7200, 60.0288, 66.9552, 64.6464, 76.1904, 64.6464, 85.4256, 60.0288, 94.6608, 50.7936, 99.2784, 41.5584, 94.6608, 36.9408, 85.4256, 36.9408, 71.5728, 41.5584, 57.7200, 50.7936, 43.8672, 69.2640, 20.7792, 83.1168, 6.9264, 92.3520, 2.3088, 101.5872, 2.3088, 106.2048, 11.5440, 106.2048, 16.1616, GAMGI_IO_STROKE,

27.7056, 6.9264, 23.0880, 16.1616, 23.0880, 30.0144, 27.7056, 39.2496, 32.3232, 43.8672, GAMGI_IO_STROKE,

60.0288, 66.9552, 64.6464, 85.4256, GAMGI_IO_STROKE,

64.6464, 76.1904, 60.0288, 94.6608, GAMGI_IO_STROKE,

41.5584, 94.6608, 36.9408, 76.1904, GAMGI_IO_STROKE,

41.5584, 62.3376, 50.7936, 48.4848, 69.2640, 25.3968, 83.1168, 11.5440, 92.3520, 6.9264, GAMGI_IO_STROKE,

41.5584, 2.3088, 32.3232, 6.9264, 27.7056, 16.1616, 27.7056, 30.0144, 32.3232, 39.2496, 50.7936, 57.7200, GAMGI_IO_STROKE,

36.9408, 85.4256, 41.5584, 66.9552, 55.4112, 48.4848, 73.8816, 25.3968, 87.7344, 11.5440, 96.9696, 6.9264, 101.5872, 6.9264, 106.2048, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 39 ' strokes: 4 *
 *************************/

32.3232, 90.0432, 27.7056, 85.4256, 23.0880, 85.4256, 18.4704, 90.0432, 18.4704, 94.6608, 23.0880, 99.2784, 27.7056, 99.2784, 32.3232, 94.6608, 32.3232, 80.8080, 27.7056, 71.5728, 18.4704, 66.9552, GAMGI_IO_STROKE,

23.0880, 94.6608, 23.0880, 90.0432, 27.7056, 90.0432, 27.7056, 94.6608, 23.0880, 94.6608, GAMGI_IO_STROKE,

27.7056, 85.4256, 32.3232, 80.8080, GAMGI_IO_STROKE,

32.3232, 90.0432, 27.7056, 71.5728, GAMGI_IO_CHAR,

/*************************
 * char: 40 ( strokes: 3 *
 *************************/

46.1760, 117.7488, 36.9408, 108.5136, 27.7056, 94.6608, 18.4704, 76.1904, 13.8528, 53.1024, 13.8528, 34.6320, 18.4704, 11.5440, 27.7056, -6.9264, 36.9408, -20.7792, 46.1760, -30.0144, GAMGI_IO_STROKE,

27.7056, 90.0432, 23.0880, 76.1904, 18.4704, 57.7200, 18.4704, 30.0144, 23.0880, 11.5440, 27.7056, -2.3088, GAMGI_IO_STROKE,

36.9408, 108.5136, 32.3232, 99.2784, 27.7056, 85.4256, 23.0880, 57.7200, 23.0880, 30.0144, 27.7056, 2.3088, 32.3232, -11.5440, 36.9408, -20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 41 ) strokes: 3 *
 *************************/

18.4704, 117.7488, 27.7056, 108.5136, 36.9408, 94.6608, 46.1760, 76.1904, 50.7936, 53.1024, 50.7936, 34.6320, 46.1760, 11.5440, 36.9408, -6.9264, 27.7056, -20.7792, 18.4704, -30.0144, GAMGI_IO_STROKE,

36.9408, 90.0432, 41.5584, 76.1904, 46.1760, 57.7200, 46.1760, 30.0144, 41.5584, 11.5440, 36.9408, -2.3088, GAMGI_IO_STROKE,

27.7056, 108.5136, 32.3232, 99.2784, 36.9408, 85.4256, 41.5584, 57.7200, 41.5584, 30.0144, 36.9408, 2.3088, 32.3232, -11.5440, 27.7056, -20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 42 * strokes: 9 *
 *************************/

36.9408, 99.2784, 32.3232, 94.6608, 41.5584, 48.4848, 36.9408, 43.8672, GAMGI_IO_STROKE,

36.9408, 99.2784, 36.9408, 43.8672, GAMGI_IO_STROKE,

36.9408, 99.2784, 41.5584, 94.6608, 32.3232, 48.4848, 36.9408, 43.8672, GAMGI_IO_STROKE,

13.8528, 85.4256, 18.4704, 85.4256, 55.4112, 57.7200, 60.0288, 57.7200, GAMGI_IO_STROKE,

13.8528, 85.4256, 60.0288, 57.7200, GAMGI_IO_STROKE,

13.8528, 85.4256, 13.8528, 80.8080, 60.0288, 62.3376, 60.0288, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 55.4112, 85.4256, 18.4704, 57.7200, 13.8528, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 13.8528, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 60.0288, 80.8080, 13.8528, 62.3376, 13.8528, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 43 + strokes: 4 *
 *************************/

55.4112, 85.4256, 55.4112, 6.9264, 60.0288, 6.9264, GAMGI_IO_STROKE,

55.4112, 85.4256, 60.0288, 85.4256, 60.0288, 6.9264, GAMGI_IO_STROKE,

18.4704, 48.4848, 96.9696, 48.4848, 96.9696, 43.8672, GAMGI_IO_STROKE,

18.4704, 48.4848, 18.4704, 43.8672, 96.9696, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 44 , strokes: 4 *
 *************************/

32.3232, 6.9264, 27.7056, 2.3088, 23.0880, 2.3088, 18.4704, 6.9264, 18.4704, 11.5440, 23.0880, 16.1616, 27.7056, 16.1616, 32.3232, 11.5440, 32.3232, -2.3088, 27.7056, -11.5440, 18.4704, -16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_STROKE,

27.7056, 2.3088, 32.3232, -2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 27.7056, -11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 45 - strokes: 2 *
 *************************/

18.4704, 48.4848, 96.9696, 48.4848, 96.9696, 43.8672, GAMGI_IO_STROKE,

18.4704, 48.4848, 18.4704, 43.8672, 96.9696, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 46 . strokes: 2 *
 *************************/

23.0880, 16.1616, 18.4704, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 2.3088, 32.3232, 6.9264, 32.3232, 11.5440, 27.7056, 16.1616, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 47 / strokes: 2 *
 *************************/

92.3520, 117.7488, 9.2352, -30.0144, 13.8528, -30.0144, GAMGI_IO_STROKE,

92.3520, 117.7488, 96.9696, 117.7488, 13.8528, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 48 0 strokes: 5 *
 *************************/

41.5584, 99.2784, 27.7056, 94.6608, 18.4704, 80.8080, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 20.7792, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 20.7792, 78.4992, 43.8672, 78.4992, 57.7200, 73.8816, 80.8080, 64.6464, 94.6608, 50.7936, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

27.7056, 90.0432, 23.0880, 80.8080, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 20.7792, 27.7056, 11.5440, GAMGI_IO_STROKE,

64.6464, 11.5440, 69.2640, 20.7792, 73.8816, 39.2496, 73.8816, 62.3376, 69.2640, 80.8080, 64.6464, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, 27.7056, 85.4256, 23.0880, 62.3376, 23.0880, 39.2496, 27.7056, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 16.1616, 69.2640, 39.2496, 69.2640, 62.3376, 64.6464, 85.4256, 60.0288, 94.6608, 50.7936, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 49 1 strokes: 9 *
 *************************/

41.5584, 90.0432, 41.5584, 2.3088, GAMGI_IO_STROKE,

46.1760, 90.0432, 46.1760, 6.9264, GAMGI_IO_STROKE,

50.7936, 99.2784, 50.7936, 2.3088, GAMGI_IO_STROKE,

50.7936, 99.2784, 36.9408, 85.4256, 27.7056, 80.8080, GAMGI_IO_STROKE,

23.0880, 2.3088, 69.2640, 2.3088, GAMGI_IO_STROKE,

41.5584, 6.9264, 32.3232, 2.3088, GAMGI_IO_STROKE,

41.5584, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

50.7936, 11.5440, 55.4112, 2.3088, GAMGI_IO_STROKE,

50.7936, 6.9264, 60.0288, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 50 2 strokes: 7 *
 *************************/

18.4704, 80.8080, 18.4704, 76.1904, 23.0880, 76.1904, 23.0880, 80.8080, 18.4704, 80.8080, GAMGI_IO_STROKE,

18.4704, 85.4256, 23.0880, 85.4256, 27.7056, 80.8080, 27.7056, 76.1904, 23.0880, 71.5728, 18.4704, 71.5728, 13.8528, 76.1904, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 36.9408, 99.2784, 55.4112, 99.2784, 69.2640, 94.6608, 73.8816, 90.0432, 78.4992, 80.8080, 78.4992, 71.5728, 73.8816, 62.3376, 60.0288, 53.1024, 36.9408, 43.8672, 27.7056, 39.2496, 18.4704, 30.0144, 13.8528, 16.1616, 13.8528, 2.3088, GAMGI_IO_STROKE,

69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 71.5728, 69.2640, 62.3376, GAMGI_IO_STROKE,

55.4112, 99.2784, 64.6464, 94.6608, 69.2640, 80.8080, 69.2640, 71.5728, 64.6464, 62.3376, 55.4112, 53.1024, 36.9408, 43.8672, GAMGI_IO_STROKE,

13.8528, 11.5440, 18.4704, 16.1616, 27.7056, 16.1616, 50.7936, 11.5440, 69.2640, 11.5440, 78.4992, 16.1616, GAMGI_IO_STROKE,

27.7056, 16.1616, 50.7936, 6.9264, 69.2640, 6.9264, 73.8816, 11.5440, GAMGI_IO_STROKE,

27.7056, 16.1616, 50.7936, 2.3088, 69.2640, 2.3088, 73.8816, 6.9264, 78.4992, 16.1616, 78.4992, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 51 3 strokes: 8 *
 *************************/

18.4704, 80.8080, 18.4704, 76.1904, 23.0880, 76.1904, 23.0880, 80.8080, 18.4704, 80.8080, GAMGI_IO_STROKE,

18.4704, 85.4256, 23.0880, 85.4256, 27.7056, 80.8080, 27.7056, 76.1904, 23.0880, 71.5728, 18.4704, 71.5728, 13.8528, 76.1904, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 36.9408, 99.2784, 55.4112, 99.2784, 69.2640, 94.6608, 73.8816, 85.4256, 73.8816, 71.5728, 69.2640, 62.3376, 55.4112, 57.7200, GAMGI_IO_STROKE,

64.6464, 94.6608, 69.2640, 85.4256, 69.2640, 71.5728, 64.6464, 62.3376, GAMGI_IO_STROKE,

50.7936, 99.2784, 60.0288, 94.6608, 64.6464, 85.4256, 64.6464, 71.5728, 60.0288, 62.3376, 50.7936, 57.7200, GAMGI_IO_STROKE,

41.5584, 57.7200, 55.4112, 57.7200, 64.6464, 53.1024, 73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 20.7792, 73.8816, 11.5440, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 25.3968, 18.4704, 30.0144, 23.0880, 30.0144, 27.7056, 25.3968, 27.7056, 20.7792, 23.0880, 16.1616, 18.4704, 16.1616, GAMGI_IO_STROKE,

69.2640, 43.8672, 73.8816, 34.6320, 73.8816, 20.7792, 69.2640, 11.5440, GAMGI_IO_STROKE,

50.7936, 57.7200, 60.0288, 53.1024, 64.6464, 48.4848, 69.2640, 34.6320, 69.2640, 20.7792, 64.6464, 6.9264, 55.4112, 2.3088, GAMGI_IO_STROKE,

18.4704, 25.3968, 18.4704, 20.7792, 23.0880, 20.7792, 23.0880, 25.3968, 18.4704, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 52 4 strokes: 9 *
 *************************/

50.7936, 85.4256, 50.7936, 2.3088, GAMGI_IO_STROKE,

55.4112, 90.0432, 55.4112, 6.9264, GAMGI_IO_STROKE,

60.0288, 99.2784, 60.0288, 2.3088, GAMGI_IO_STROKE,

60.0288, 99.2784, 9.2352, 30.0144, 83.1168, 30.0144, GAMGI_IO_STROKE,

36.9408, 2.3088, 73.8816, 2.3088, GAMGI_IO_STROKE,

50.7936, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 11.5440, 46.1760, 2.3088, GAMGI_IO_STROKE,

60.0288, 11.5440, 64.6464, 2.3088, GAMGI_IO_STROKE,

60.0288, 6.9264, 69.2640, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 53 5 strokes: 7 *
 *************************/

23.0880, 99.2784, 13.8528, 53.1024, 23.0880, 62.3376, 36.9408, 66.9552, 50.7936, 66.9552, 64.6464, 62.3376, 73.8816, 53.1024, 78.4992, 39.2496, 78.4992, 30.0144, 73.8816, 16.1616, 64.6464, 6.9264, 50.7936, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 25.3968, 18.4704, 30.0144, 23.0880, 30.0144, 27.7056, 25.3968, 27.7056, 20.7792, 23.0880, 16.1616, 18.4704, 16.1616, GAMGI_IO_STROKE,

69.2640, 53.1024, 73.8816, 43.8672, 73.8816, 25.3968, 69.2640, 16.1616, GAMGI_IO_STROKE,

50.7936, 66.9552, 60.0288, 62.3376, 64.6464, 57.7200, 69.2640, 43.8672, 69.2640, 25.3968, 64.6464, 11.5440, 60.0288, 6.9264, 50.7936, 2.3088, GAMGI_IO_STROKE,

18.4704, 25.3968, 18.4704, 20.7792, 23.0880, 20.7792, 23.0880, 25.3968, 18.4704, 25.3968, GAMGI_IO_STROKE,

23.0880, 99.2784, 69.2640, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 60.0288, 94.6608, GAMGI_IO_STROKE,

23.0880, 90.0432, 41.5584, 90.0432, 60.0288, 94.6608, 69.2640, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 54 6 strokes: 6 *
 *************************/

64.6464, 85.4256, 64.6464, 80.8080, 69.2640, 80.8080, 69.2640, 85.4256, 64.6464, 85.4256, GAMGI_IO_STROKE,

69.2640, 90.0432, 64.6464, 90.0432, 60.0288, 85.4256, 60.0288, 80.8080, 64.6464, 76.1904, 69.2640, 76.1904, 73.8816, 80.8080, 73.8816, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 57.7200, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 30.0144, 78.4992, 34.6320, 73.8816, 48.4848, 64.6464, 57.7200, 50.7936, 62.3376, 41.5584, 62.3376, 32.3232, 57.7200, 27.7056, 53.1024, 23.0880, 43.8672, GAMGI_IO_STROKE,

27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 57.7200, 18.4704, 30.0144, 23.0880, 16.1616, 27.7056, 11.5440, GAMGI_IO_STROKE,

69.2640, 16.1616, 73.8816, 25.3968, 73.8816, 39.2496, 69.2640, 48.4848, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 32.3232, 90.0432, 27.7056, 80.8080, 23.0880, 62.3376, 23.0880, 30.0144, 27.7056, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 11.5440, 69.2640, 25.3968, 69.2640, 39.2496, 64.6464, 53.1024, 60.0288, 57.7200, 50.7936, 62.3376, GAMGI_IO_CHAR,

/*************************
 * char: 55 7 strokes: 7 *
 *************************/

13.8528, 99.2784, 13.8528, 71.5728, GAMGI_IO_STROKE,

78.4992, 99.2784, 78.4992, 85.4256, 73.8816, 71.5728, 55.4112, 48.4848, 50.7936, 39.2496, 46.1760, 20.7792, 46.1760, 2.3088, GAMGI_IO_STROKE,

50.7936, 43.8672, 46.1760, 34.6320, 41.5584, 20.7792, 41.5584, 2.3088, GAMGI_IO_STROKE,

73.8816, 71.5728, 50.7936, 48.4848, 41.5584, 34.6320, 36.9408, 20.7792, 36.9408, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

13.8528, 80.8080, 18.4704, 90.0432, 27.7056, 99.2784, 36.9408, 99.2784, 60.0288, 85.4256, 69.2640, 85.4256, 73.8816, 90.0432, 78.4992, 99.2784, GAMGI_IO_STROKE,

23.0880, 90.0432, 27.7056, 94.6608, 36.9408, 94.6608, 46.1760, 90.0432, GAMGI_IO_STROKE,

13.8528, 80.8080, 18.4704, 85.4256, 27.7056, 90.0432, 36.9408, 90.0432, 60.0288, 85.4256, GAMGI_IO_CHAR,

/*************************
 * char: 56 8 strokes: 10 *
 *************************/

36.9408, 99.2784, 23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 71.5728, 23.0880, 62.3376, 36.9408, 57.7200, 55.4112, 57.7200, 69.2640, 62.3376, 73.8816, 71.5728, 73.8816, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, GAMGI_IO_STROKE,

27.7056, 94.6608, 23.0880, 85.4256, 23.0880, 71.5728, 27.7056, 62.3376, GAMGI_IO_STROKE,

64.6464, 62.3376, 69.2640, 71.5728, 69.2640, 85.4256, 64.6464, 94.6608, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 94.6608, 27.7056, 85.4256, 27.7056, 71.5728, 32.3232, 62.3376, 36.9408, 57.7200, GAMGI_IO_STROKE,

55.4112, 57.7200, 60.0288, 62.3376, 64.6464, 71.5728, 64.6464, 85.4256, 60.0288, 94.6608, 55.4112, 99.2784, GAMGI_IO_STROKE,

36.9408, 57.7200, 23.0880, 53.1024, 18.4704, 48.4848, 13.8528, 39.2496, 13.8528, 20.7792, 18.4704, 11.5440, 23.0880, 6.9264, 36.9408, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 73.8816, 11.5440, 78.4992, 20.7792, 78.4992, 39.2496, 73.8816, 48.4848, 69.2640, 53.1024, 55.4112, 57.7200, GAMGI_IO_STROKE,

23.0880, 48.4848, 18.4704, 39.2496, 18.4704, 20.7792, 23.0880, 11.5440, GAMGI_IO_STROKE,

69.2640, 11.5440, 73.8816, 20.7792, 73.8816, 39.2496, 69.2640, 48.4848, GAMGI_IO_STROKE,

36.9408, 57.7200, 27.7056, 53.1024, 23.0880, 39.2496, 23.0880, 20.7792, 27.7056, 6.9264, 36.9408, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 64.6464, 6.9264, 69.2640, 20.7792, 69.2640, 39.2496, 64.6464, 53.1024, 55.4112, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 57 9 strokes: 6 *
 *************************/

23.0880, 20.7792, 23.0880, 16.1616, 27.7056, 16.1616, 27.7056, 20.7792, 23.0880, 20.7792, GAMGI_IO_STROKE,

69.2640, 57.7200, 64.6464, 48.4848, 60.0288, 43.8672, 50.7936, 39.2496, 41.5584, 39.2496, 27.7056, 43.8672, 18.4704, 53.1024, 13.8528, 66.9552, 13.8528, 71.5728, 18.4704, 85.4256, 27.7056, 94.6608, 41.5584, 99.2784, 50.7936, 99.2784, 64.6464, 94.6608, 73.8816, 85.4256, 78.4992, 71.5728, 78.4992, 43.8672, 73.8816, 25.3968, 69.2640, 16.1616, 60.0288, 6.9264, 46.1760, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, 18.4704, 16.1616, 18.4704, 20.7792, 23.0880, 25.3968, 27.7056, 25.3968, 32.3232, 20.7792, 32.3232, 16.1616, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_STROKE,

23.0880, 53.1024, 18.4704, 62.3376, 18.4704, 76.1904, 23.0880, 85.4256, GAMGI_IO_STROKE,

64.6464, 90.0432, 69.2640, 85.4256, 73.8816, 71.5728, 73.8816, 43.8672, 69.2640, 25.3968, 64.6464, 16.1616, GAMGI_IO_STROKE,

41.5584, 39.2496, 32.3232, 43.8672, 27.7056, 48.4848, 23.0880, 62.3376, 23.0880, 76.1904, 27.7056, 90.0432, 32.3232, 94.6608, 41.5584, 99.2784, GAMGI_IO_STROKE,

50.7936, 99.2784, 60.0288, 94.6608, 64.6464, 85.4256, 69.2640, 71.5728, 69.2640, 39.2496, 64.6464, 20.7792, 60.0288, 11.5440, 55.4112, 6.9264, 46.1760, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 58 : strokes: 4 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 18.4704, 57.7200, 23.0880, 53.1024, 27.7056, 53.1024, 32.3232, 57.7200, 32.3232, 62.3376, 27.7056, 66.9552, 23.0880, 66.9552, GAMGI_IO_STROKE,

23.0880, 62.3376, 23.0880, 57.7200, 27.7056, 57.7200, 27.7056, 62.3376, 23.0880, 62.3376, GAMGI_IO_STROKE,

23.0880, 16.1616, 18.4704, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 2.3088, 32.3232, 6.9264, 32.3232, 11.5440, 27.7056, 16.1616, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 59 ; strokes: 6 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 18.4704, 57.7200, 23.0880, 53.1024, 27.7056, 53.1024, 32.3232, 57.7200, 32.3232, 62.3376, 27.7056, 66.9552, 23.0880, 66.9552, GAMGI_IO_STROKE,

23.0880, 62.3376, 23.0880, 57.7200, 27.7056, 57.7200, 27.7056, 62.3376, 23.0880, 62.3376, GAMGI_IO_STROKE,

32.3232, 6.9264, 27.7056, 2.3088, 23.0880, 2.3088, 18.4704, 6.9264, 18.4704, 11.5440, 23.0880, 16.1616, 27.7056, 16.1616, 32.3232, 11.5440, 32.3232, -2.3088, 27.7056, -11.5440, 18.4704, -16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_STROKE,

27.7056, 2.3088, 32.3232, -2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 27.7056, -11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 60 < strokes: 2 *
 *************************/

92.3520, 85.4256, 18.4704, 43.8672, 92.3520, 2.3088, GAMGI_IO_STROKE,

92.3520, 85.4256, 92.3520, 80.8080, 27.7056, 43.8672, 92.3520, 6.9264, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 61 = strokes: 4 *
 *************************/

18.4704, 66.9552, 96.9696, 66.9552, 96.9696, 62.3376, GAMGI_IO_STROKE,

18.4704, 66.9552, 18.4704, 62.3376, 96.9696, 62.3376, GAMGI_IO_STROKE,

18.4704, 30.0144, 96.9696, 30.0144, 96.9696, 25.3968, GAMGI_IO_STROKE,

18.4704, 30.0144, 18.4704, 25.3968, 96.9696, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 62 > strokes: 2 *
 *************************/

18.4704, 85.4256, 92.3520, 43.8672, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 85.4256, 18.4704, 80.8080, 83.1168, 43.8672, 18.4704, 6.9264, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 63 ? strokes: 6 *
 *************************/

18.4704, 76.1904, 18.4704, 80.8080, 23.0880, 80.8080, 23.0880, 71.5728, 13.8528, 71.5728, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 32.3232, 99.2784, 50.7936, 99.2784, 64.6464, 94.6608, 69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 71.5728, 69.2640, 62.3376, 64.6464, 57.7200, 46.1760, 48.4848, GAMGI_IO_STROKE,

64.6464, 90.0432, 69.2640, 85.4256, 69.2640, 66.9552, 64.6464, 62.3376, GAMGI_IO_STROKE,

50.7936, 99.2784, 60.0288, 94.6608, 64.6464, 85.4256, 64.6464, 66.9552, 60.0288, 57.7200, 55.4112, 53.1024, GAMGI_IO_STROKE,

41.5584, 48.4848, 41.5584, 34.6320, 46.1760, 34.6320, 46.1760, 48.4848, 41.5584, 48.4848, GAMGI_IO_STROKE,

41.5584, 16.1616, 36.9408, 11.5440, 36.9408, 6.9264, 41.5584, 2.3088, 46.1760, 2.3088, 50.7936, 6.9264, 50.7936, 11.5440, 46.1760, 16.1616, 41.5584, 16.1616, GAMGI_IO_STROKE,

41.5584, 11.5440, 41.5584, 6.9264, 46.1760, 6.9264, 46.1760, 11.5440, 41.5584, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 64 @ strokes: 6 *
 *************************/

78.4992, 62.3376, 73.8816, 71.5728, 64.6464, 76.1904, 55.4112, 76.1904, 46.1760, 71.5728, 41.5584, 66.9552, 36.9408, 57.7200, 36.9408, 43.8672, 41.5584, 34.6320, 46.1760, 30.0144, 55.4112, 25.3968, 64.6464, 25.3968, 73.8816, 30.0144, 78.4992, 39.2496, GAMGI_IO_STROKE,

46.1760, 66.9552, 41.5584, 57.7200, 41.5584, 43.8672, 46.1760, 34.6320, GAMGI_IO_STROKE,

55.4112, 76.1904, 50.7936, 71.5728, 46.1760, 57.7200, 46.1760, 43.8672, 50.7936, 30.0144, 55.4112, 25.3968, GAMGI_IO_STROKE,

78.4992, 76.1904, 78.4992, 39.2496, 83.1168, 30.0144, 92.3520, 25.3968, 96.9696, 25.3968, 106.2048, 30.0144, 110.8224, 43.8672, 110.8224, 57.7200, 106.2048, 71.5728, 101.5872, 80.8080, 92.3520, 90.0432, 83.1168, 94.6608, 69.2640, 99.2784, 55.4112, 99.2784, 41.5584, 94.6608, 32.3232, 90.0432, 23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 55.4112, 2.3088, 69.2640, 2.3088, 83.1168, 6.9264, 92.3520, 11.5440, 87.7344, 11.5440, 83.1168, 6.9264, GAMGI_IO_STROKE,

83.1168, 71.5728, 83.1168, 39.2496, 87.7344, 30.0144, GAMGI_IO_STROKE,

78.4992, 76.1904, 87.7344, 76.1904, 87.7344, 39.2496, 92.3520, 30.0144, 96.9696, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 65 A strokes: 9 *
 *************************/

41.5584, 90.0432, 32.3232, 85.4256, 23.0880, 76.1904, 18.4704, 66.9552, 13.8528, 53.1024, 13.8528, 39.2496, 18.4704, 30.0144, 27.7056, 25.3968, GAMGI_IO_STROKE,

23.0880, 71.5728, 18.4704, 57.7200, 18.4704, 39.2496, 23.0880, 30.0144, GAMGI_IO_STROKE,

41.5584, 90.0432, 32.3232, 80.8080, 27.7056, 71.5728, 23.0880, 57.7200, 23.0880, 43.8672, 27.7056, 25.3968, 27.7056, 16.1616, 23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

78.4992, 90.0432, 87.7344, 90.0432, 87.7344, 11.5440, 78.4992, 11.5440, GAMGI_IO_STROKE,

92.3520, 90.0432, 92.3520, 11.5440, GAMGI_IO_STROKE,

96.9696, 94.6608, 96.9696, 6.9264, GAMGI_IO_STROKE,

13.8528, 99.2784, 27.7056, 94.6608, 55.4112, 90.0432, 78.4992, 90.0432, 96.9696, 94.6608, 106.2048, 99.2784, GAMGI_IO_STROKE,

23.0880, 53.1024, 87.7344, 53.1024, GAMGI_IO_STROKE,

13.8528, 2.3088, 27.7056, 6.9264, 55.4112, 11.5440, 78.4992, 11.5440, 96.9696, 6.9264, 106.2048, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 66 B strokes: 9 *
 *************************/

32.3232, 94.6608, 32.3232, 6.9264, GAMGI_IO_STROKE,

36.9408, 94.6608, 36.9408, 6.9264, GAMGI_IO_STROKE,

50.7936, 99.2784, 41.5584, 94.6608, 41.5584, 6.9264, 50.7936, 2.3088, GAMGI_IO_STROKE,

13.8528, 80.8080, 23.0880, 90.0432, 32.3232, 94.6608, 50.7936, 99.2784, 73.8816, 99.2784, 87.7344, 94.6608, 96.9696, 85.4256, 96.9696, 76.1904, 92.3520, 66.9552, GAMGI_IO_STROKE,

87.7344, 90.0432, 92.3520, 85.4256, 92.3520, 76.1904, 87.7344, 66.9552, GAMGI_IO_STROKE,

73.8816, 99.2784, 83.1168, 94.6608, 87.7344, 85.4256, 87.7344, 76.1904, 83.1168, 71.5728, GAMGI_IO_STROKE,

55.4112, 30.0144, 46.1760, 34.6320, 41.5584, 43.8672, 41.5584, 53.1024, 46.1760, 62.3376, 50.7936, 66.9552, 64.6464, 71.5728, 78.4992, 71.5728, 92.3520, 66.9552, 101.5872, 57.7200, 106.2048, 48.4848, 106.2048, 34.6320, 101.5872, 20.7792, 92.3520, 11.5440, 83.1168, 6.9264, 69.2640, 2.3088, 50.7936, 2.3088, 32.3232, 6.9264, 23.0880, 11.5440, 13.8528, 20.7792, GAMGI_IO_STROKE,

96.9696, 57.7200, 101.5872, 48.4848, 101.5872, 30.0144, 96.9696, 20.7792, GAMGI_IO_STROKE,

78.4992, 71.5728, 92.3520, 62.3376, 96.9696, 48.4848, 96.9696, 30.0144, 92.3520, 16.1616, 83.1168, 6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 67 C strokes: 8 *
 *************************/

106.2048, 99.2784, 101.5872, 90.0432, 96.9696, 80.8080, 87.7344, 90.0432, 78.4992, 94.6608, 64.6464, 99.2784, 55.4112, 99.2784, 41.5584, 94.6608, 32.3232, 90.0432, 23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 55.4112, 2.3088, 64.6464, 2.3088, 78.4992, 6.9264, 87.7344, 11.5440, 96.9696, 20.7792, 101.5872, 11.5440, 106.2048, 2.3088, GAMGI_IO_STROKE,

101.5872, 90.0432, 96.9696, 66.9552, 96.9696, 34.6320, 101.5872, 11.5440, GAMGI_IO_STROKE,

96.9696, 76.1904, 92.3520, 80.8080, GAMGI_IO_STROKE,

96.9696, 62.3376, 92.3520, 76.1904, 87.7344, 85.4256, 78.4992, 94.6608, GAMGI_IO_STROKE,

23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 25.3968, GAMGI_IO_STROKE,

41.5584, 94.6608, 32.3232, 85.4256, 27.7056, 76.1904, 23.0880, 62.3376, 23.0880, 39.2496, 27.7056, 25.3968, 32.3232, 16.1616, 41.5584, 6.9264, GAMGI_IO_STROKE,

92.3520, 20.7792, 96.9696, 25.3968, GAMGI_IO_STROKE,

78.4992, 6.9264, 87.7344, 16.1616, 92.3520, 25.3968, 96.9696, 39.2496, GAMGI_IO_CHAR,

/*************************
 * char: 68 D strokes: 6 *
 *************************/

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 94.6608, 32.3232, 6.9264, GAMGI_IO_STROKE,

41.5584, 99.2784, 36.9408, 94.6608, 36.9408, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

13.8528, 76.1904, 18.4704, 85.4256, 27.7056, 94.6608, 41.5584, 99.2784, 64.6464, 99.2784, 78.4992, 94.6608, 87.7344, 90.0432, 96.9696, 80.8080, 101.5872, 71.5728, 106.2048, 57.7200, 106.2048, 43.8672, 101.5872, 30.0144, 96.9696, 20.7792, 87.7344, 11.5440, 78.4992, 6.9264, 64.6464, 2.3088, 41.5584, 2.3088, 27.7056, 6.9264, 18.4704, 16.1616, 13.8528, 25.3968, GAMGI_IO_STROKE,

96.9696, 76.1904, 101.5872, 62.3376, 101.5872, 39.2496, 96.9696, 25.3968, GAMGI_IO_STROKE,

78.4992, 94.6608, 87.7344, 85.4256, 92.3520, 76.1904, 96.9696, 62.3376, 96.9696, 39.2496, 92.3520, 25.3968, 87.7344, 16.1616, 78.4992, 6.9264, GAMGI_IO_CHAR,

/**************************
 * char: 69 E strokes: 12 *
 **************************/

106.2048, 99.2784, 101.5872, 90.0432, 96.9696, 80.8080, 87.7344, 90.0432, 78.4992, 94.6608, 64.6464, 99.2784, 55.4112, 99.2784, 41.5584, 94.6608, 32.3232, 90.0432, 23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 55.4112, 2.3088, 64.6464, 2.3088, 78.4992, 6.9264, 87.7344, 11.5440, 96.9696, 20.7792, 101.5872, 11.5440, 106.2048, 2.3088, GAMGI_IO_STROKE,

101.5872, 90.0432, 96.9696, 66.9552, 96.9696, 34.6320, 101.5872, 11.5440, GAMGI_IO_STROKE,

96.9696, 76.1904, 92.3520, 80.8080, GAMGI_IO_STROKE,

96.9696, 66.9552, 87.7344, 85.4256, 78.4992, 94.6608, GAMGI_IO_STROKE,

23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 25.3968, GAMGI_IO_STROKE,

41.5584, 94.6608, 32.3232, 85.4256, 27.7056, 76.1904, 23.0880, 62.3376, 23.0880, 39.2496, 27.7056, 25.3968, 32.3232, 16.1616, 41.5584, 6.9264, GAMGI_IO_STROKE,

92.3520, 20.7792, 96.9696, 25.3968, GAMGI_IO_STROKE,

78.4992, 6.9264, 87.7344, 16.1616, 92.3520, 25.3968, 96.9696, 39.2496, GAMGI_IO_STROKE,

23.0880, 53.1024, 27.7056, 57.7200, 41.5584, 57.7200, 73.8816, 48.4848, 87.7344, 48.4848, 96.9696, 53.1024, GAMGI_IO_STROKE,

50.7936, 53.1024, 60.0288, 48.4848, 73.8816, 43.8672, 83.1168, 43.8672, 92.3520, 48.4848, GAMGI_IO_STROKE,

36.9408, 57.7200, 60.0288, 43.8672, 73.8816, 39.2496, 83.1168, 39.2496, 92.3520, 43.8672, 96.9696, 53.1024, GAMGI_IO_STROKE,

96.9696, 66.9552, 92.3520, 71.5728, 87.7344, 71.5728, 83.1168, 66.9552, 87.7344, 62.3376, 92.3520, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 70 F strokes: 11 *
 **************************/

23.0880, 90.0432, 23.0880, 6.9264, GAMGI_IO_STROKE,

36.9408, 94.6608, 27.7056, 90.0432, 27.7056, 11.5440, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 32.3232, 85.4256, 32.3232, 11.5440, 41.5584, 11.5440, GAMGI_IO_STROKE,

13.8528, 80.8080, 23.0880, 90.0432, 32.3232, 94.6608, 46.1760, 99.2784, 64.6464, 99.2784, 78.4992, 94.6608, 87.7344, 90.0432, 92.3520, 85.4256, 106.2048, 99.2784, GAMGI_IO_STROKE,

106.2048, 99.2784, 101.5872, 90.0432, 96.9696, 71.5728, 96.9696, 57.7200, 101.5872, 39.2496, 106.2048, 30.0144, GAMGI_IO_STROKE,

96.9696, 85.4256, 92.3520, 76.1904, GAMGI_IO_STROKE,

78.4992, 94.6608, 87.7344, 85.4256, 92.3520, 71.5728, 96.9696, 57.7200, GAMGI_IO_STROKE,

32.3232, 53.1024, 36.9408, 57.7200, 46.1760, 57.7200, 69.2640, 53.1024, 83.1168, 53.1024, 92.3520, 57.7200, GAMGI_IO_STROKE,

55.4112, 53.1024, 69.2640, 48.4848, 78.4992, 48.4848, 87.7344, 53.1024, GAMGI_IO_STROKE,

41.5584, 57.7200, 69.2640, 43.8672, 78.4992, 43.8672, 87.7344, 48.4848, 92.3520, 57.7200, 92.3520, 71.5728, 87.7344, 76.1904, 83.1168, 76.1904, 78.4992, 71.5728, 83.1168, 66.9552, 87.7344, 71.5728, GAMGI_IO_STROKE,

13.8528, 2.3088, 23.0880, 6.9264, 41.5584, 11.5440, 64.6464, 11.5440, 92.3520, 6.9264, 106.2048, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 71 G strokes: 12 *
 **************************/

106.2048, 99.2784, 101.5872, 90.0432, 96.9696, 80.8080, 87.7344, 90.0432, 78.4992, 94.6608, 64.6464, 99.2784, 55.4112, 99.2784, 41.5584, 94.6608, 32.3232, 90.0432, 23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 55.4112, 2.3088, 69.2640, 2.3088, 78.4992, 6.9264, 87.7344, 11.5440, 92.3520, 16.1616, 96.9696, 25.3968, 101.5872, 11.5440, 106.2048, 2.3088, GAMGI_IO_STROKE,

101.5872, 90.0432, 96.9696, 66.9552, 96.9696, 34.6320, 101.5872, 11.5440, GAMGI_IO_STROKE,

96.9696, 76.1904, 92.3520, 80.8080, GAMGI_IO_STROKE,

96.9696, 62.3376, 92.3520, 76.1904, 87.7344, 85.4256, 78.4992, 94.6608, GAMGI_IO_STROKE,

23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 25.3968, GAMGI_IO_STROKE,

41.5584, 94.6608, 32.3232, 85.4256, 27.7056, 76.1904, 23.0880, 62.3376, 23.0880, 39.2496, 27.7056, 25.3968, 32.3232, 16.1616, 41.5584, 6.9264, GAMGI_IO_STROKE,

87.7344, 16.1616, 92.3520, 25.3968, 92.3520, 43.8672, GAMGI_IO_STROKE,

78.4992, 6.9264, 83.1168, 11.5440, 87.7344, 25.3968, 87.7344, 48.4848, GAMGI_IO_STROKE,

27.7056, 39.2496, 32.3232, 43.8672, 36.9408, 39.2496, 32.3232, 34.6320, 27.7056, 34.6320, 23.0880, 39.2496, GAMGI_IO_STROKE,

23.0880, 53.1024, 27.7056, 62.3376, 36.9408, 66.9552, 46.1760, 66.9552, 60.0288, 62.3376, 73.8816, 53.1024, 83.1168, 48.4848, GAMGI_IO_STROKE,

27.7056, 57.7200, 36.9408, 62.3376, 46.1760, 62.3376, 60.0288, 57.7200, 69.2640, 53.1024, GAMGI_IO_STROKE,

23.0880, 53.1024, 32.3232, 57.7200, 46.1760, 57.7200, 73.8816, 48.4848, 92.3520, 48.4848, 96.9696, 53.1024, GAMGI_IO_CHAR,

/*************************
 * char: 72 H strokes: 8 *
 *************************/

23.0880, 94.6608, 23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

27.7056, 90.0432, 27.7056, 6.9264, GAMGI_IO_STROKE,

41.5584, 90.0432, 32.3232, 90.0432, 32.3232, 6.9264, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, 41.5584, 90.0432, 64.6464, 90.0432, 92.3520, 94.6608, 106.2048, 99.2784, GAMGI_IO_STROKE,

32.3232, 53.1024, 36.9408, 62.3376, 46.1760, 71.5728, 60.0288, 76.1904, 78.4992, 76.1904, 92.3520, 71.5728, 101.5872, 62.3376, 106.2048, 48.4848, 106.2048, 34.6320, 101.5872, 30.0144, 92.3520, 25.3968, GAMGI_IO_STROKE,

96.9696, 62.3376, 101.5872, 53.1024, 101.5872, 39.2496, 96.9696, 30.0144, GAMGI_IO_STROKE,

78.4992, 76.1904, 87.7344, 71.5728, 92.3520, 66.9552, 96.9696, 57.7200, 96.9696, 39.2496, 92.3520, 25.3968, 92.3520, 16.1616, 96.9696, 6.9264, 106.2048, 2.3088, GAMGI_IO_STROKE,

13.8528, 2.3088, 32.3232, 6.9264, 50.7936, 6.9264, 73.8816, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 73 I strokes: 5 *
 *************************/

55.4112, 85.4256, 55.4112, 11.5440, GAMGI_IO_STROKE,

60.0288, 80.8080, 60.0288, 16.1616, GAMGI_IO_STROKE,

64.6464, 85.4256, 64.6464, 11.5440, GAMGI_IO_STROKE,

13.8528, 99.2784, 32.3232, 90.0432, 50.7936, 85.4256, 69.2640, 85.4256, 87.7344, 90.0432, 106.2048, 99.2784, GAMGI_IO_STROKE,

13.8528, 2.3088, 27.7056, 6.9264, 46.1760, 11.5440, 73.8816, 11.5440, 92.3520, 6.9264, 106.2048, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 74 J strokes: 7 *
 *************************/

69.2640, 85.4256, 78.4992, 85.4256, 78.4992, 16.1616, 73.8816, 6.9264, 64.6464, 2.3088, GAMGI_IO_STROKE,

83.1168, 85.4256, 83.1168, 16.1616, 78.4992, 11.5440, GAMGI_IO_STROKE,

87.7344, 90.0432, 87.7344, 11.5440, GAMGI_IO_STROKE,

13.8528, 99.2784, 32.3232, 90.0432, 50.7936, 85.4256, 69.2640, 85.4256, 87.7344, 90.0432, 106.2048, 99.2784, GAMGI_IO_STROKE,

18.4704, 57.7200, 13.8528, 48.4848, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 64.6464, 2.3088, 78.4992, 6.9264, 87.7344, 11.5440, 96.9696, 20.7792, 106.2048, 34.6320, GAMGI_IO_STROKE,

18.4704, 30.0144, 23.0880, 16.1616, 27.7056, 11.5440, GAMGI_IO_STROKE,

13.8528, 39.2496, 23.0880, 30.0144, 27.7056, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 75 K strokes: 11 *
 **************************/

23.0880, 94.6608, 23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

27.7056, 90.0432, 27.7056, 6.9264, GAMGI_IO_STROKE,

41.5584, 90.0432, 32.3232, 90.0432, 32.3232, 6.9264, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, 41.5584, 90.0432, 64.6464, 90.0432, 92.3520, 94.6608, 106.2048, 99.2784, GAMGI_IO_STROKE,

32.3232, 53.1024, 36.9408, 62.3376, 46.1760, 71.5728, 60.0288, 76.1904, 73.8816, 76.1904, 87.7344, 71.5728, 92.3520, 66.9552, 92.3520, 57.7200, 87.7344, 53.1024, 64.6464, 43.8672, 55.4112, 39.2496, 50.7936, 34.6320, 50.7936, 30.0144, 55.4112, 25.3968, 60.0288, 30.0144, 55.4112, 34.6320, GAMGI_IO_STROKE,

83.1168, 71.5728, 87.7344, 66.9552, 87.7344, 57.7200, 83.1168, 53.1024, GAMGI_IO_STROKE,

73.8816, 76.1904, 83.1168, 66.9552, 83.1168, 57.7200, 78.4992, 53.1024, 64.6464, 43.8672, GAMGI_IO_STROKE,

64.6464, 43.8672, 78.4992, 43.8672, 92.3520, 39.2496, 96.9696, 30.0144, 96.9696, 20.7792, 92.3520, 16.1616, GAMGI_IO_STROKE,

83.1168, 39.2496, 92.3520, 30.0144, 92.3520, 20.7792, GAMGI_IO_STROKE,

64.6464, 43.8672, 78.4992, 39.2496, 87.7344, 30.0144, 92.3520, 16.1616, 96.9696, 6.9264, 101.5872, 2.3088, 106.2048, 2.3088, GAMGI_IO_STROKE,

13.8528, 2.3088, 32.3232, 6.9264, 50.7936, 6.9264, 73.8816, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 76 L strokes: 8 *
 *************************/

23.0880, 94.6608, 23.0880, 6.9264, GAMGI_IO_STROKE,

27.7056, 90.0432, 27.7056, 11.5440, GAMGI_IO_STROKE,

41.5584, 90.0432, 32.3232, 90.0432, 32.3232, 11.5440, 41.5584, 11.5440, GAMGI_IO_STROKE,

106.2048, 76.1904, 96.9696, 62.3376, 92.3520, 53.1024, 87.7344, 39.2496, 87.7344, 30.0144, 92.3520, 20.7792, 101.5872, 16.1616, GAMGI_IO_STROKE,

96.9696, 57.7200, 92.3520, 43.8672, 92.3520, 30.0144, 96.9696, 20.7792, GAMGI_IO_STROKE,

106.2048, 76.1904, 101.5872, 66.9552, 96.9696, 48.4848, 96.9696, 34.6320, 101.5872, 16.1616, 106.2048, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, 41.5584, 90.0432, 64.6464, 90.0432, 92.3520, 94.6608, 106.2048, 99.2784, GAMGI_IO_STROKE,

13.8528, 2.3088, 23.0880, 6.9264, 41.5584, 11.5440, 64.6464, 11.5440, 92.3520, 6.9264, 106.2048, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 77 M strokes: 10 *
 **************************/

55.4112, 85.4256, 55.4112, 11.5440, GAMGI_IO_STROKE,

60.0288, 80.8080, 60.0288, 16.1616, GAMGI_IO_STROKE,

64.6464, 85.4256, 64.6464, 11.5440, GAMGI_IO_STROKE,

41.5584, 11.5440, 32.3232, 20.7792, 23.0880, 25.3968, 18.4704, 30.0144, 13.8528, 43.8672, 13.8528, 66.9552, 18.4704, 80.8080, 27.7056, 90.0432, 36.9408, 94.6608, 50.7936, 99.2784, 69.2640, 99.2784, 83.1168, 94.6608, 92.3520, 90.0432, 101.5872, 80.8080, 106.2048, 66.9552, 106.2048, 43.8672, 101.5872, 30.0144, 96.9696, 25.3968, 87.7344, 20.7792, 78.4992, 11.5440, GAMGI_IO_STROKE,

23.0880, 30.0144, 18.4704, 43.8672, 18.4704, 66.9552, 23.0880, 80.8080, GAMGI_IO_STROKE,

32.3232, 20.7792, 27.7056, 30.0144, 23.0880, 43.8672, 23.0880, 71.5728, 27.7056, 85.4256, 36.9408, 94.6608, GAMGI_IO_STROKE,

96.9696, 80.8080, 101.5872, 66.9552, 101.5872, 43.8672, 96.9696, 30.0144, GAMGI_IO_STROKE,

83.1168, 94.6608, 92.3520, 85.4256, 96.9696, 71.5728, 96.9696, 43.8672, 92.3520, 30.0144, 87.7344, 20.7792, GAMGI_IO_STROKE,

13.8528, 99.2784, 32.3232, 90.0432, 50.7936, 85.4256, 69.2640, 85.4256, 87.7344, 90.0432, 106.2048, 99.2784, GAMGI_IO_STROKE,

13.8528, 2.3088, 27.7056, 6.9264, 46.1760, 11.5440, 73.8816, 11.5440, 92.3520, 6.9264, 106.2048, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 78 N strokes: 7 *
 *************************/

23.0880, 90.0432, 23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

32.3232, 90.0432, 27.7056, 85.4256, 27.7056, 6.9264, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 32.3232, 85.4256, 32.3232, 6.9264, GAMGI_IO_STROKE,

13.8528, 80.8080, 23.0880, 90.0432, 32.3232, 94.6608, 46.1760, 99.2784, 64.6464, 99.2784, 78.4992, 94.6608, 87.7344, 90.0432, 96.9696, 80.8080, 101.5872, 71.5728, 106.2048, 57.7200, 106.2048, 39.2496, 101.5872, 30.0144, 92.3520, 25.3968, GAMGI_IO_STROKE,

96.9696, 76.1904, 101.5872, 62.3376, 101.5872, 43.8672, 96.9696, 30.0144, GAMGI_IO_STROKE,

78.4992, 94.6608, 87.7344, 85.4256, 92.3520, 76.1904, 96.9696, 62.3376, 96.9696, 43.8672, 92.3520, 25.3968, 92.3520, 16.1616, 96.9696, 6.9264, 101.5872, 2.3088, 106.2048, 2.3088, GAMGI_IO_STROKE,

13.8528, 2.3088, 32.3232, 6.9264, 50.7936, 6.9264, 73.8816, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 79 O strokes: 5 *
 *************************/

55.4112, 99.2784, 41.5584, 94.6608, 32.3232, 90.0432, 23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 55.4112, 2.3088, 64.6464, 2.3088, 78.4992, 6.9264, 87.7344, 11.5440, 96.9696, 20.7792, 101.5872, 30.0144, 106.2048, 43.8672, 106.2048, 57.7200, 101.5872, 71.5728, 96.9696, 80.8080, 87.7344, 90.0432, 78.4992, 94.6608, 64.6464, 99.2784, 55.4112, 99.2784, GAMGI_IO_STROKE,

23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 25.3968, GAMGI_IO_STROKE,

41.5584, 94.6608, 32.3232, 85.4256, 27.7056, 76.1904, 23.0880, 62.3376, 23.0880, 39.2496, 27.7056, 25.3968, 32.3232, 16.1616, 41.5584, 6.9264, GAMGI_IO_STROKE,

96.9696, 25.3968, 101.5872, 39.2496, 101.5872, 62.3376, 96.9696, 76.1904, GAMGI_IO_STROKE,

78.4992, 6.9264, 87.7344, 16.1616, 92.3520, 25.3968, 96.9696, 39.2496, 96.9696, 62.3376, 92.3520, 76.1904, 87.7344, 85.4256, 78.4992, 94.6608, GAMGI_IO_CHAR,

/*************************
 * char: 80 P strokes: 7 *
 *************************/

23.0880, 85.4256, 23.0880, 6.9264, GAMGI_IO_STROKE,

36.9408, 90.0432, 27.7056, 80.8080, 27.7056, 11.5440, GAMGI_IO_STROKE,

55.4112, 99.2784, 46.1760, 94.6608, 36.9408, 85.4256, 32.3232, 76.1904, 32.3232, 11.5440, 41.5584, 11.5440, GAMGI_IO_STROKE,

13.8528, 76.1904, 23.0880, 85.4256, 41.5584, 94.6608, 55.4112, 99.2784, 69.2640, 99.2784, 83.1168, 94.6608, 92.3520, 90.0432, 101.5872, 80.8080, 106.2048, 66.9552, 106.2048, 57.7200, 101.5872, 43.8672, 92.3520, 34.6320, 78.4992, 30.0144, 60.0288, 30.0144, 46.1760, 34.6320, 36.9408, 43.8672, 32.3232, 57.7200, GAMGI_IO_STROKE,

96.9696, 80.8080, 101.5872, 71.5728, 101.5872, 53.1024, 96.9696, 43.8672, GAMGI_IO_STROKE,

83.1168, 94.6608, 92.3520, 85.4256, 96.9696, 71.5728, 96.9696, 53.1024, 92.3520, 39.2496, 78.4992, 30.0144, GAMGI_IO_STROKE,

13.8528, 2.3088, 23.0880, 6.9264, 41.5584, 11.5440, 64.6464, 11.5440, 92.3520, 6.9264, 106.2048, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 81 Q strokes: 8 *
 *************************/

55.4112, 99.2784, 41.5584, 94.6608, 32.3232, 90.0432, 23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 55.4112, 2.3088, 64.6464, 2.3088, 78.4992, 6.9264, 87.7344, 11.5440, 96.9696, 20.7792, 101.5872, 30.0144, 106.2048, 43.8672, 106.2048, 57.7200, 101.5872, 71.5728, 96.9696, 80.8080, 87.7344, 90.0432, 78.4992, 94.6608, 64.6464, 99.2784, 55.4112, 99.2784, GAMGI_IO_STROKE,

23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 25.3968, GAMGI_IO_STROKE,

41.5584, 94.6608, 32.3232, 85.4256, 27.7056, 76.1904, 23.0880, 62.3376, 23.0880, 39.2496, 27.7056, 25.3968, 32.3232, 16.1616, 41.5584, 6.9264, GAMGI_IO_STROKE,

96.9696, 25.3968, 101.5872, 39.2496, 101.5872, 62.3376, 96.9696, 76.1904, GAMGI_IO_STROKE,

78.4992, 6.9264, 87.7344, 16.1616, 92.3520, 25.3968, 96.9696, 39.2496, 96.9696, 62.3376, 92.3520, 76.1904, 87.7344, 85.4256, 78.4992, 94.6608, GAMGI_IO_STROKE,

23.0880, 39.2496, 27.7056, 30.0144, 41.5584, 25.3968, 69.2640, 20.7792, 101.5872, 20.7792, 106.2048, 16.1616, 106.2048, 6.9264, 101.5872, 2.3088, 101.5872, 6.9264, 106.2048, 11.5440, GAMGI_IO_STROKE,

50.7936, 20.7792, 60.0288, 20.7792, GAMGI_IO_STROKE,

27.7056, 30.0144, 41.5584, 20.7792, 55.4112, 16.1616, 64.6464, 16.1616, 69.2640, 20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 82 R strokes: 10 *
 **************************/

23.0880, 85.4256, 23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

27.7056, 85.4256, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 90.0432, 32.3232, 6.9264, GAMGI_IO_STROKE,

13.8528, 76.1904, 23.0880, 85.4256, 32.3232, 90.0432, 41.5584, 94.6608, 55.4112, 99.2784, 73.8816, 99.2784, 92.3520, 94.6608, 101.5872, 85.4256, 106.2048, 76.1904, 106.2048, 62.3376, 101.5872, 53.1024, 96.9696, 48.4848, GAMGI_IO_STROKE,

92.3520, 90.0432, 96.9696, 85.4256, 101.5872, 76.1904, 101.5872, 62.3376, 96.9696, 53.1024, GAMGI_IO_STROKE,

73.8816, 99.2784, 83.1168, 94.6608, 92.3520, 85.4256, 96.9696, 76.1904, 96.9696, 57.7200, 92.3520, 48.4848, GAMGI_IO_STROKE,

87.7344, 43.8672, 73.8816, 39.2496, 60.0288, 39.2496, 50.7936, 43.8672, 50.7936, 53.1024, 60.0288, 57.7200, 73.8816, 57.7200, 87.7344, 53.1024, 96.9696, 43.8672, 106.2048, 30.0144, 106.2048, 20.7792, 101.5872, 16.1616, 96.9696, 16.1616, GAMGI_IO_STROKE,

87.7344, 48.4848, 92.3520, 43.8672, 101.5872, 25.3968, 101.5872, 20.7792, 96.9696, 34.6320, GAMGI_IO_STROKE,

69.2640, 57.7200, 78.4992, 53.1024, 87.7344, 43.8672, 92.3520, 34.6320, 96.9696, 16.1616, 101.5872, 6.9264, 106.2048, 2.3088, GAMGI_IO_STROKE,

13.8528, 2.3088, 32.3232, 6.9264, 50.7936, 6.9264, 73.8816, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 83 S strokes: 8 *
 *************************/

69.2640, 99.2784, 96.9696, 94.6608, 106.2048, 99.2784, 101.5872, 90.0432, 101.5872, 80.8080, 92.3520, 90.0432, 83.1168, 94.6608, 69.2640, 99.2784, 50.7936, 99.2784, 36.9408, 94.6608, 23.0880, 80.8080, 18.4704, 66.9552, 18.4704, 57.7200, 23.0880, 43.8672, 32.3232, 34.6320, 46.1760, 30.0144, 60.0288, 30.0144, 69.2640, 34.6320, 73.8816, 39.2496, 78.4992, 48.4848, 78.4992, 53.1024, GAMGI_IO_STROKE,

101.5872, 94.6608, 96.9696, 90.0432, 101.5872, 80.8080, GAMGI_IO_STROKE,

23.0880, 53.1024, 27.7056, 43.8672, 32.3232, 39.2496, 46.1760, 34.6320, 60.0288, 34.6320, 69.2640, 39.2496, GAMGI_IO_STROKE,

27.7056, 85.4256, 23.0880, 76.1904, 23.0880, 62.3376, 27.7056, 53.1024, 36.9408, 43.8672, 50.7936, 39.2496, 60.0288, 39.2496, 69.2640, 43.8672, 78.4992, 53.1024, 83.1168, 57.7200, 87.7344, 57.7200, GAMGI_IO_STROKE,

32.3232, 48.4848, 36.9408, 48.4848, 41.5584, 53.1024, 50.7936, 62.3376, 60.0288, 66.9552, 73.8816, 66.9552, 83.1168, 62.3376, 92.3520, 53.1024, 96.9696, 43.8672, 96.9696, 30.0144, 92.3520, 16.1616, 83.1168, 6.9264, GAMGI_IO_STROKE,

50.7936, 66.9552, 60.0288, 71.5728, 73.8816, 71.5728, 87.7344, 66.9552, 96.9696, 57.7200, 101.5872, 43.8672, 101.5872, 30.0144, 96.9696, 20.7792, GAMGI_IO_STROKE,

18.4704, 20.7792, 23.0880, 11.5440, 18.4704, 6.9264, GAMGI_IO_STROKE,

41.5584, 53.1024, 41.5584, 57.7200, 46.1760, 66.9552, 50.7936, 71.5728, 60.0288, 76.1904, 73.8816, 76.1904, 87.7344, 71.5728, 101.5872, 57.7200, 106.2048, 43.8672, 106.2048, 34.6320, 101.5872, 20.7792, 92.3520, 11.5440, 83.1168, 6.9264, 69.2640, 2.3088, 50.7936, 2.3088, 36.9408, 6.9264, 27.7056, 11.5440, 18.4704, 20.7792, 18.4704, 11.5440, 13.8528, 2.3088, 23.0880, 6.9264, 50.7936, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 84 T strokes: 7 *
 *************************/

55.4112, 90.0432, 36.9408, 90.0432, 27.7056, 85.4256, 23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 27.7056, 11.5440, 36.9408, 6.9264, 50.7936, 2.3088, 64.6464, 2.3088, 78.4992, 6.9264, 87.7344, 11.5440, 96.9696, 20.7792, 101.5872, 30.0144, 106.2048, 43.8672, 106.2048, 62.3376, 101.5872, 76.1904, 92.3520, 85.4256, 83.1168, 90.0432, GAMGI_IO_STROKE,

73.8816, 90.0432, 69.2640, 85.4256, 69.2640, 76.1904, 73.8816, 71.5728, 78.4992, 76.1904, 73.8816, 80.8080, GAMGI_IO_STROKE,

18.4704, 39.2496, 23.0880, 25.3968, 32.3232, 16.1616, 41.5584, 11.5440, 55.4112, 6.9264, 69.2640, 6.9264, 83.1168, 11.5440, GAMGI_IO_STROKE,

23.0880, 80.8080, 18.4704, 62.3376, 18.4704, 48.4848, 23.0880, 34.6320, 32.3232, 20.7792, 41.5584, 16.1616, 55.4112, 11.5440, 69.2640, 11.5440, 83.1168, 16.1616, 92.3520, 20.7792, 101.5872, 34.6320, 106.2048, 43.8672, GAMGI_IO_STROKE,

13.8528, 99.2784, 27.7056, 85.4256, GAMGI_IO_STROKE,

27.7056, 90.0432, 32.3232, 94.6608, GAMGI_IO_STROKE,

18.4704, 94.6608, 23.0880, 94.6608, 27.7056, 99.2784, 36.9408, 94.6608, 55.4112, 90.0432, 83.1168, 90.0432, 96.9696, 94.6608, 106.2048, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 85 U strokes: 7 *
 *************************/

32.3232, 90.0432, 23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 55.4112, 2.3088, 73.8816, 2.3088, 87.7344, 6.9264, 96.9696, 11.5440, GAMGI_IO_STROKE,

27.7056, 80.8080, 23.0880, 71.5728, 18.4704, 57.7200, 18.4704, 39.2496, 23.0880, 25.3968, GAMGI_IO_STROKE,

27.7056, 85.4256, 32.3232, 80.8080, 32.3232, 76.1904, 27.7056, 66.9552, 23.0880, 53.1024, 23.0880, 39.2496, 27.7056, 25.3968, 32.3232, 16.1616, 41.5584, 6.9264, GAMGI_IO_STROKE,

78.4992, 90.0432, 87.7344, 90.0432, 87.7344, 16.1616, 83.1168, 6.9264, 73.8816, 2.3088, GAMGI_IO_STROKE,

92.3520, 90.0432, 92.3520, 16.1616, 87.7344, 11.5440, GAMGI_IO_STROKE,

96.9696, 94.6608, 96.9696, 11.5440, 106.2048, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 27.7056, 94.6608, 55.4112, 90.0432, 78.4992, 90.0432, 96.9696, 94.6608, 106.2048, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 86 V strokes: 7 *
 *************************/

13.8528, 99.2784, 60.0288, 2.3088, GAMGI_IO_STROKE,

18.4704, 94.6608, 23.0880, 90.0432, 55.4112, 20.7792, 60.0288, 11.5440, GAMGI_IO_STROKE,

23.0880, 94.6608, 27.7056, 90.0432, 60.0288, 20.7792, 64.6464, 16.1616, GAMGI_IO_STROKE,

106.2048, 99.2784, 60.0288, 2.3088, GAMGI_IO_STROKE,

84.1168, 58.3376, 72.3816, 35.2496, GAMGI_IO_STROKE,

/********************************************************
 * Original stroke:                                     *
 * 83.1168, 62.3376, 73.8816, 39.2496, GAMGI_IO_STROKE, *
 ********************************************************/

92.3520, 71.5728, 73.8816, 48.4848, 69.2640, 34.6320, 69.2640, 25.3968, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, 46.1760, 90.0432, 73.8816, 90.0432, 96.9696, 94.6608, 106.2048, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 87 W strokes: 9 *
 *************************/

32.3232, 90.0432, 23.0880, 80.8080, 18.4704, 71.5728, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 30.0144, 23.0880, 20.7792, 32.3232, 11.5440, 41.5584, 6.9264, 55.4112, 2.3088, 64.6464, 2.3088, 78.4992, 6.9264, 87.7344, 11.5440, 96.9696, 20.7792, 101.5872, 30.0144, 106.2048, 43.8672, 106.2048, 57.7200, 101.5872, 71.5728, 96.9696, 80.8080, 87.7344, 90.0432, GAMGI_IO_STROKE,

23.0880, 71.5728, 18.4704, 57.7200, 18.4704, 43.8672, 23.0880, 30.0144, 27.7056, 20.7792, GAMGI_IO_STROKE,

23.0880, 80.8080, 27.7056, 76.1904, 27.7056, 71.5728, 23.0880, 57.7200, 23.0880, 43.8672, 27.7056, 25.3968, 32.3232, 16.1616, 41.5584, 6.9264, GAMGI_IO_STROKE,

92.3520, 20.7792, 96.9696, 30.0144, 101.5872, 43.8672, 101.5872, 57.7200, 96.9696, 71.5728, GAMGI_IO_STROKE,

78.4992, 6.9264, 87.7344, 16.1616, 92.3520, 25.3968, 96.9696, 43.8672, 96.9696, 57.7200, 92.3520, 71.5728, 92.3520, 76.1904, 96.9696, 80.8080, GAMGI_IO_STROKE,

55.4112, 85.4256, 55.4112, 2.3088, GAMGI_IO_STROKE,

60.0288, 80.8080, 60.0288, 6.9264, GAMGI_IO_STROKE,

64.6464, 85.4256, 64.6464, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 32.3232, 90.0432, 50.7936, 85.4256, 69.2640, 85.4256, 87.7344, 90.0432, 106.2048, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 88 X strokes: 9 *
 *************************/

13.8528, 99.2784, 87.7344, 11.5440, 92.3520, 6.9264, GAMGI_IO_STROKE,

18.4704, 94.6608, 27.7056, 90.0432, 96.9696, 6.9264, GAMGI_IO_STROKE,

32.3232, 90.0432, 106.2048, 2.3088, GAMGI_IO_STROKE,

106.2048, 99.2784, 64.6464, 53.1024, GAMGI_IO_STROKE,

55.4112, 43.8672, 23.0880, 6.9264, GAMGI_IO_STROKE,

50.7936, 39.2496, 36.9408, 30.0144, 32.3232, 20.7792, GAMGI_IO_STROKE,

55.4112, 43.8672, 36.9408, 34.6320, 32.3232, 30.0144, 27.7056, 20.7792, 27.7056, 11.5440, GAMGI_IO_STROKE,

13.8528, 99.2784, 32.3232, 90.0432, 50.7936, 85.4256, 69.2640, 85.4256, 87.7344, 90.0432, 106.2048, 99.2784, GAMGI_IO_STROKE,

13.8528, 2.3088, 23.0880, 6.9264, 41.5584, 11.5440, 64.6464, 11.5440, 92.3520, 6.9264, 106.2048, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 89 Y strokes: 8 *
 *************************/

87.7344, 90.0432, 87.7344, 6.9264, GAMGI_IO_STROKE,

92.3520, 90.0432, 92.3520, 11.5440, GAMGI_IO_STROKE,

96.9696, 94.6608, 96.9696, 11.5440, GAMGI_IO_STROKE,

27.7056, 90.0432, 18.4704, 80.8080, 13.8528, 66.9552, 13.8528, 53.1024, 18.4704, 39.2496, 27.7056, 30.0144, 36.9408, 25.3968, 50.7936, 20.7792, 64.6464, 20.7792, 78.4992, 25.3968, 87.7344, 30.0144, GAMGI_IO_STROKE,

32.3232, 30.0144, 46.1760, 25.3968, 73.8816, 25.3968, GAMGI_IO_STROKE,

13.8528, 53.1024, 18.4704, 43.8672, 27.7056, 34.6320, 41.5584, 30.0144, 69.2640, 30.0144, 78.4992, 25.3968, GAMGI_IO_STROKE,

13.8528, 99.2784, 32.3232, 90.0432, 50.7936, 85.4256, 69.2640, 85.4256, 87.7344, 90.0432, 106.2048, 99.2784, GAMGI_IO_STROKE,

13.8528, 20.7792, 23.0880, 11.5440, 32.3232, 6.9264, 50.7936, 2.3088, 69.2640, 2.3088, 87.7344, 6.9264, 106.2048, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 90 Z strokes: 8 *
 *************************/

13.8528, 99.2784, 18.4704, 94.6608, 27.7056, 90.0432, 41.5584, 90.0432, 64.6464, 99.2784, 78.4992, 99.2784, 92.3520, 94.6608, 96.9696, 85.4256, 96.9696, 76.1904, 92.3520, 66.9552, GAMGI_IO_STROKE,

87.7344, 94.6608, 92.3520, 85.4256, 92.3520, 76.1904, 87.7344, 66.9552, GAMGI_IO_STROKE,

78.4992, 99.2784, 83.1168, 94.6608, 87.7344, 85.4256, 87.7344, 71.5728, GAMGI_IO_STROKE,

87.7344, 62.3376, 69.2640, 57.7200, 60.0288, 57.7200, 50.7936, 62.3376, 50.7936, 71.5728, 60.0288, 76.1904, 69.2640, 76.1904, 87.7344, 71.5728, GAMGI_IO_STROKE,

69.2640, 76.1904, 78.4992, 71.5728, 83.1168, 66.9552, 78.4992, 62.3376, 69.2640, 57.7200, GAMGI_IO_STROKE,

92.3520, 66.9552, 101.5872, 57.7200, 106.2048, 43.8672, 106.2048, 34.6320, 101.5872, 20.7792, 92.3520, 11.5440, 83.1168, 6.9264, 69.2640, 2.3088, 50.7936, 2.3088, 36.9408, 6.9264, 27.7056, 11.5440, 18.4704, 20.7792, 13.8528, 34.6320, 13.8528, 43.8672, 18.4704, 57.7200, 23.0880, 62.3376, 32.3232, 66.9552, 41.5584, 66.9552, 50.7936, 62.3376, 50.7936, 53.1024, 46.1760, 48.4848, 41.5584, 53.1024, 46.1760, 57.7200, GAMGI_IO_STROKE,

87.7344, 66.9552, 96.9696, 57.7200, 101.5872, 48.4848, 101.5872, 30.0144, 96.9696, 20.7792, GAMGI_IO_STROKE,

87.7344, 62.3376, 92.3520, 57.7200, 96.9696, 48.4848, 96.9696, 30.0144, 92.3520, 16.1616, 83.1168, 6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 91 [ strokes: 4 *
 *************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_STROKE,

23.0880, 117.7488, 23.0880, -30.0144, GAMGI_IO_STROKE,

18.4704, 117.7488, 50.7936, 117.7488, GAMGI_IO_STROKE,

18.4704, -30.0144, 50.7936, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 92 \ strokes: 2 *
 *************************/

13.8528, 117.7488, 96.9696, -30.0144, 92.3520, -30.0144, GAMGI_IO_STROKE,

13.8528, 117.7488, 9.2352, 117.7488, 92.3520, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 93 ] strokes: 4 *
 *************************/

41.5584, 117.7488, 41.5584, -30.0144, GAMGI_IO_STROKE,

46.1760, 117.7488, 46.1760, -30.0144, GAMGI_IO_STROKE,

13.8528, 117.7488, 46.1760, 117.7488, GAMGI_IO_STROKE,

13.8528, -30.0144, 46.1760, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 94 ^ strokes: 2 *
 *************************/

27.7056, 71.5728, 36.9408, 85.4256, 46.1760, 71.5728, GAMGI_IO_STROKE,

13.8528, 57.7200, 36.9408, 80.8080, 60.0288, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 95 _ strokes: 1 *
 *************************/

9.2352, -6.9264, 92.3520, -6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 96 ` strokes: 4 *
 *************************/

32.3232, 99.2784, 23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 71.5728, 23.0880, 66.9552, 27.7056, 66.9552, 32.3232, 71.5728, 32.3232, 76.1904, 27.7056, 80.8080, 23.0880, 80.8080, 18.4704, 76.1904, GAMGI_IO_STROKE,

23.0880, 76.1904, 23.0880, 71.5728, 27.7056, 71.5728, 27.7056, 76.1904, 23.0880, 76.1904, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 76.1904, GAMGI_IO_STROKE,

18.4704, 85.4256, 23.0880, 80.8080, GAMGI_IO_CHAR,

/*************************
 * char: 97 a strokes: 7 *
 *************************/

27.7056, 48.4848, 13.8528, 34.6320, 13.8528, 16.1616, 27.7056, 2.3088, 46.1760, 11.5440, GAMGI_IO_STROKE,

18.4704, 34.6320, 18.4704, 16.1616, 27.7056, 6.9264, GAMGI_IO_STROKE,

23.0880, 43.8672, 23.0880, 20.7792, 36.9408, 6.9264, GAMGI_IO_STROKE,

36.9408, 39.2496, 13.8528, 62.3376, 18.4704, 66.9552, 23.0880, 62.3376, 18.4704, 57.7200, GAMGI_IO_STROKE,

23.0880, 62.3376, 41.5584, 62.3376, 50.7936, 66.9552, 60.0288, 57.7200, 60.0288, 16.1616, 64.6464, 11.5440, GAMGI_IO_STROKE,

50.7936, 62.3376, 55.4112, 57.7200, 55.4112, 16.1616, 50.7936, 11.5440, 55.4112, 6.9264, 60.0288, 11.5440, 55.4112, 16.1616, GAMGI_IO_STROKE,

41.5584, 62.3376, 50.7936, 53.1024, 50.7936, 16.1616, 46.1760, 11.5440, 55.4112, 2.3088, 64.6464, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 98 b strokes: 6 *
 *************************/

23.0880, 90.0432, 13.8528, 99.2784, 18.4704, 80.8080, 18.4704, 16.1616, 32.3232, 2.3088, 55.4112, 11.5440, 64.6464, 16.1616, GAMGI_IO_STROKE,

23.0880, 90.0432, 23.0880, 16.1616, 32.3232, 6.9264, GAMGI_IO_STROKE,

23.0880, 90.0432, 32.3232, 99.2784, 27.7056, 80.8080, 27.7056, 20.7792, 41.5584, 6.9264, GAMGI_IO_STROKE,

27.7056, 57.7200, 50.7936, 66.9552, 64.6464, 53.1024, 64.6464, 16.1616, GAMGI_IO_STROKE,

50.7936, 62.3376, 60.0288, 53.1024, 60.0288, 16.1616, GAMGI_IO_STROKE,

41.5584, 62.3376, 55.4112, 48.4848, 55.4112, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 99 c strokes: 5 *
 *************************/

13.8528, 53.1024, 13.8528, 11.5440, 23.0880, 2.3088, 32.3232, 11.5440, GAMGI_IO_STROKE,

18.4704, 53.1024, 18.4704, 11.5440, 23.0880, 6.9264, GAMGI_IO_STROKE,

23.0880, 57.7200, 23.0880, 16.1616, 27.7056, 11.5440, 32.3232, 11.5440, GAMGI_IO_STROKE,

13.8528, 53.1024, 41.5584, 66.9552, 50.7936, 57.7200, 41.5584, 53.1024, 32.3232, 62.3376, GAMGI_IO_STROKE,

36.9408, 62.3376, 46.1760, 57.7200, GAMGI_IO_CHAR,

/**************************
 * char: 100 d strokes: 6 *
 **************************/

36.9408, 66.9552, 13.8528, 53.1024, 13.8528, 16.1616, 27.7056, 2.3088, 36.9408, 6.9264, 50.7936, 11.5440, 60.0288, 11.5440, GAMGI_IO_STROKE,

18.4704, 53.1024, 18.4704, 16.1616, 27.7056, 6.9264, GAMGI_IO_STROKE,

23.0880, 57.7200, 23.0880, 20.7792, 36.9408, 6.9264, GAMGI_IO_STROKE,

27.7056, 85.4256, 27.7056, 99.2784, 32.3232, 85.4256, 60.0288, 53.1024, 60.0288, 11.5440, GAMGI_IO_STROKE,

27.7056, 85.4256, 55.4112, 53.1024, 55.4112, 16.1616, GAMGI_IO_STROKE,

27.7056, 85.4256, 13.8528, 85.4256, 27.7056, 80.8080, 50.7936, 53.1024, 50.7936, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 101 e strokes: 6 *
 **************************/

13.8528, 53.1024, 13.8528, 11.5440, 23.0880, 2.3088, 32.3232, 11.5440, GAMGI_IO_STROKE,

18.4704, 53.1024, 18.4704, 11.5440, 23.0880, 6.9264, GAMGI_IO_STROKE,

23.0880, 57.7200, 23.0880, 16.1616, 27.7056, 11.5440, 32.3232, 11.5440, GAMGI_IO_STROKE,

13.8528, 53.1024, 41.5584, 66.9552, 55.4112, 48.4848, 23.0880, 30.0144, GAMGI_IO_STROKE,

36.9408, 62.3376, 50.7936, 48.4848, GAMGI_IO_STROKE,

32.3232, 62.3376, 46.1760, 43.8672, GAMGI_IO_CHAR,

/**************************
 * char: 102 f strokes: 7 *
 **************************/

18.4704, 85.4256, 18.4704, 16.1616, 13.8528, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

23.0880, 85.4256, 23.0880, 16.1616, 18.4704, 11.5440, 23.0880, 6.9264, 27.7056, 11.5440, 23.0880, 16.1616, GAMGI_IO_STROKE,

27.7056, 90.0432, 27.7056, 16.1616, 32.3232, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

18.4704, 85.4256, 46.1760, 99.2784, 55.4112, 90.0432, 46.1760, 85.4256, 36.9408, 94.6608, GAMGI_IO_STROKE,

41.5584, 94.6608, 50.7936, 90.0432, GAMGI_IO_STROKE,

4.6176, 66.9552, 18.4704, 66.9552, GAMGI_IO_STROKE,

27.7056, 66.9552, 46.1760, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 103 g strokes: 7 *
 **************************/

13.8528, 53.1024, 13.8528, 16.1616, 27.7056, 2.3088, 50.7936, 11.5440, GAMGI_IO_STROKE,

18.4704, 53.1024, 18.4704, 16.1616, 27.7056, 6.9264, GAMGI_IO_STROKE,

23.0880, 57.7200, 23.0880, 20.7792, 36.9408, 6.9264, GAMGI_IO_STROKE,

13.8528, 53.1024, 23.0880, 57.7200, 46.1760, 66.9552, 60.0288, 53.1024, 60.0288, -6.9264, 55.4112, -16.1616, 50.7936, -20.7792, 41.5584, -25.3968, 32.3232, -25.3968, 23.0880, -20.7792, 13.8528, -25.3968, 23.0880, -30.0144, 32.3232, -25.3968, GAMGI_IO_STROKE,

46.1760, 62.3376, 55.4112, 53.1024, 55.4112, -6.9264, 50.7936, -16.1616, GAMGI_IO_STROKE,

27.7056, -25.3968, 18.4704, -25.3968, GAMGI_IO_STROKE,

36.9408, 62.3376, 50.7936, 48.4848, 50.7936, -11.5440, 46.1760, -20.7792, 41.5584, -25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 104 h strokes: 6 *
 **************************/

23.0880, 90.0432, 13.8528, 99.2784, 18.4704, 80.8080, 18.4704, 16.1616, 13.8528, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

23.0880, 90.0432, 23.0880, 16.1616, 18.4704, 11.5440, 23.0880, 6.9264, 27.7056, 11.5440, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 90.0432, 32.3232, 99.2784, 27.7056, 80.8080, 27.7056, 16.1616, 32.3232, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 57.7200, 41.5584, 62.3376, 50.7936, 66.9552, 64.6464, 53.1024, 64.6464, 11.5440, 50.7936, -6.9264, 50.7936, -20.7792, 55.4112, -30.0144, 60.0288, -30.0144, 50.7936, -20.7792, GAMGI_IO_STROKE,

50.7936, 62.3376, 60.0288, 53.1024, 60.0288, 11.5440, 55.4112, 2.3088, GAMGI_IO_STROKE,

41.5584, 62.3376, 55.4112, 48.4848, 55.4112, 6.9264, 50.7936, -6.9264, GAMGI_IO_CHAR,

/**************************
 * char: 105 i strokes: 5 *
 **************************/

23.0880, 99.2784, 13.8528, 90.0432, 23.0880, 80.8080, 32.3232, 90.0432, 23.0880, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 90.0432, 23.0880, 85.4256, 27.7056, 90.0432, 23.0880, 94.6608, GAMGI_IO_STROKE,

23.0880, 66.9552, 13.8528, 57.7200, 18.4704, 53.1024, 18.4704, 16.1616, 13.8528, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

23.0880, 53.1024, 27.7056, 57.7200, 23.0880, 62.3376, 18.4704, 57.7200, 23.0880, 53.1024, 23.0880, 16.1616, 18.4704, 11.5440, 23.0880, 6.9264, 27.7056, 11.5440, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 66.9552, 32.3232, 57.7200, 27.7056, 53.1024, 27.7056, 16.1616, 32.3232, 11.5440, 23.0880, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 106 j strokes: 5 *
 **************************/

23.0880, 99.2784, 13.8528, 90.0432, 23.0880, 80.8080, 32.3232, 90.0432, 23.0880, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 90.0432, 23.0880, 85.4256, 27.7056, 90.0432, 23.0880, 94.6608, GAMGI_IO_STROKE,

23.0880, 66.9552, 13.8528, 57.7200, 18.4704, 53.1024, 18.4704, 11.5440, 32.3232, -6.9264, GAMGI_IO_STROKE,

23.0880, 53.1024, 27.7056, 57.7200, 23.0880, 62.3376, 18.4704, 57.7200, 23.0880, 53.1024, 23.0880, 11.5440, 27.7056, 2.3088, GAMGI_IO_STROKE,

23.0880, 66.9552, 32.3232, 57.7200, 27.7056, 53.1024, 27.7056, 6.9264, 32.3232, -6.9264, 32.3232, -20.7792, 23.0880, -30.0144, 13.8528, -25.3968, 13.8528, -30.0144, 23.0880, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 107 k strokes: 9 *
 **************************/

23.0880, 90.0432, 13.8528, 99.2784, 18.4704, 80.8080, 18.4704, 16.1616, 13.8528, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

23.0880, 90.0432, 23.0880, 16.1616, 18.4704, 11.5440, 23.0880, 6.9264, 27.7056, 11.5440, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 90.0432, 32.3232, 99.2784, 27.7056, 80.8080, 27.7056, 16.1616, 32.3232, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 53.1024, 41.5584, 62.3376, 50.7936, 66.9552, 60.0288, 53.1024, 46.1760, 43.8672, 27.7056, 30.0144, GAMGI_IO_STROKE,

46.1760, 62.3376, 55.4112, 53.1024, GAMGI_IO_STROKE,

41.5584, 62.3376, 50.7936, 48.4848, GAMGI_IO_STROKE,

41.5584, 39.2496, 46.1760, 34.6320, 50.7936, 11.5440, 60.0288, 2.3088, 69.2640, 11.5440, GAMGI_IO_STROKE,

46.1760, 39.2496, 50.7936, 30.0144, 55.4112, 11.5440, 60.0288, 6.9264, GAMGI_IO_STROKE,

46.1760, 43.8672, 50.7936, 39.2496, 60.0288, 16.1616, 64.6464, 11.5440, 69.2640, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 108 l strokes: 3 *
 **************************/

23.0880, 90.0432, 13.8528, 99.2784, 18.4704, 80.8080, 18.4704, 16.1616, 13.8528, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

23.0880, 90.0432, 23.0880, 16.1616, 18.4704, 11.5440, 23.0880, 6.9264, 27.7056, 11.5440, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 90.0432, 32.3232, 99.2784, 27.7056, 80.8080, 27.7056, 16.1616, 32.3232, 11.5440, 23.0880, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 109 m strokes: 9 *
 **************************/

9.2352, 57.7200, 13.8528, 57.7200, 18.4704, 53.1024, 18.4704, 16.1616, 13.8528, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

18.4704, 62.3376, 23.0880, 57.7200, 23.0880, 16.1616, 18.4704, 11.5440, 23.0880, 6.9264, 27.7056, 11.5440, 23.0880, 16.1616, GAMGI_IO_STROKE,

9.2352, 57.7200, 18.4704, 66.9552, 27.7056, 57.7200, 27.7056, 16.1616, 32.3232, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 57.7200, 41.5584, 62.3376, 50.7936, 66.9552, 64.6464, 57.7200, 64.6464, 16.1616, 69.2640, 11.5440, 60.0288, 2.3088, GAMGI_IO_STROKE,

50.7936, 62.3376, 60.0288, 57.7200, 60.0288, 16.1616, 55.4112, 11.5440, 60.0288, 6.9264, 64.6464, 11.5440, 60.0288, 16.1616, GAMGI_IO_STROKE,

41.5584, 62.3376, 55.4112, 53.1024, 55.4112, 16.1616, 50.7936, 11.5440, 60.0288, 2.3088, GAMGI_IO_STROKE,

64.6464, 57.7200, 78.4992, 62.3376, 87.7344, 66.9552, 101.5872, 57.7200, 101.5872, 16.1616, 106.2048, 11.5440, 96.9696, 2.3088, GAMGI_IO_STROKE,

87.7344, 62.3376, 96.9696, 57.7200, 96.9696, 16.1616, 92.3520, 11.5440, 96.9696, 6.9264, 101.5872, 11.5440, 96.9696, 16.1616, GAMGI_IO_STROKE,

78.4992, 62.3376, 92.3520, 53.1024, 92.3520, 16.1616, 87.7344, 11.5440, 96.9696, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 110 n strokes: 6 *
 **************************/

9.2352, 57.7200, 13.8528, 57.7200, 18.4704, 53.1024, 18.4704, 16.1616, 13.8528, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

18.4704, 62.3376, 23.0880, 57.7200, 23.0880, 16.1616, 18.4704, 11.5440, 23.0880, 6.9264, 27.7056, 11.5440, 23.0880, 16.1616, GAMGI_IO_STROKE,

9.2352, 57.7200, 18.4704, 66.9552, 27.7056, 57.7200, 27.7056, 16.1616, 32.3232, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 57.7200, 41.5584, 62.3376, 50.7936, 66.9552, 64.6464, 57.7200, 64.6464, 16.1616, 69.2640, 11.5440, 60.0288, 2.3088, GAMGI_IO_STROKE,

50.7936, 62.3376, 60.0288, 57.7200, 60.0288, 16.1616, 55.4112, 11.5440, 60.0288, 6.9264, 64.6464, 11.5440, 60.0288, 16.1616, GAMGI_IO_STROKE,

41.5584, 62.3376, 55.4112, 53.1024, 55.4112, 16.1616, 50.7936, 11.5440, 60.0288, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 111 o strokes: 6 *
 **************************/

13.8528, 53.1024, 13.8528, 16.1616, 27.7056, 2.3088, 50.7936, 11.5440, 60.0288, 16.1616, GAMGI_IO_STROKE,

18.4704, 53.1024, 18.4704, 16.1616, 27.7056, 6.9264, GAMGI_IO_STROKE,

23.0880, 57.7200, 23.0880, 20.7792, 36.9408, 6.9264, GAMGI_IO_STROKE,

13.8528, 53.1024, 23.0880, 57.7200, 46.1760, 66.9552, 60.0288, 53.1024, 60.0288, 16.1616, GAMGI_IO_STROKE,

46.1760, 62.3376, 55.4112, 53.1024, 55.4112, 16.1616, GAMGI_IO_STROKE,

36.9408, 62.3376, 50.7936, 48.4848, 50.7936, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 112 p strokes: 9 *
 **************************/

13.8528, 66.9552, 18.4704, 57.7200, 18.4704, 16.1616, 9.2352, 11.5440, 18.4704, 11.5440, 18.4704, -16.1616, 13.8528, -30.0144, 23.0880, -20.7792, GAMGI_IO_STROKE,

23.0880, 57.7200, 23.0880, -20.7792, GAMGI_IO_STROKE,

13.8528, 66.9552, 23.0880, 62.3376, 27.7056, 57.7200, 27.7056, 16.1616, 36.9408, 11.5440, 41.5584, 6.9264, GAMGI_IO_STROKE,

23.0880, 11.5440, 27.7056, 11.5440, 36.9408, 6.9264, GAMGI_IO_STROKE,

27.7056, 6.9264, 32.3232, 2.3088, 55.4112, 11.5440, 64.6464, 16.1616, GAMGI_IO_STROKE,

27.7056, 6.9264, 27.7056, -16.1616, 32.3232, -30.0144, 23.0880, -20.7792, GAMGI_IO_STROKE,

27.7056, 57.7200, 41.5584, 62.3376, 50.7936, 66.9552, 64.6464, 53.1024, 64.6464, 16.1616, GAMGI_IO_STROKE,

50.7936, 62.3376, 60.0288, 53.1024, 60.0288, 16.1616, GAMGI_IO_STROKE,

41.5584, 62.3376, 55.4112, 48.4848, 55.4112, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 113 q strokes: 6 *
 **************************/

13.8528, 53.1024, 13.8528, 16.1616, 27.7056, 2.3088, 50.7936, 11.5440, GAMGI_IO_STROKE,

18.4704, 53.1024, 18.4704, 16.1616, 27.7056, 6.9264, GAMGI_IO_STROKE,

23.0880, 57.7200, 23.0880, 20.7792, 36.9408, 6.9264, GAMGI_IO_STROKE,

13.8528, 53.1024, 23.0880, 57.7200, 46.1760, 66.9552, 60.0288, 53.1024, 60.0288, -16.1616, 64.6464, -30.0144, 55.4112, -20.7792, GAMGI_IO_STROKE,

46.1760, 62.3376, 55.4112, 53.1024, 55.4112, -20.7792, GAMGI_IO_STROKE,

36.9408, 62.3376, 50.7936, 48.4848, 50.7936, -16.1616, 46.1760, -30.0144, 55.4112, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 114 r strokes: 5 *
 **************************/

9.2352, 57.7200, 13.8528, 57.7200, 18.4704, 53.1024, 18.4704, 16.1616, 13.8528, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

18.4704, 62.3376, 23.0880, 57.7200, 23.0880, 16.1616, 18.4704, 11.5440, 23.0880, 6.9264, 27.7056, 11.5440, 23.0880, 16.1616, GAMGI_IO_STROKE,

9.2352, 57.7200, 18.4704, 66.9552, 27.7056, 57.7200, 27.7056, 16.1616, 32.3232, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 57.7200, 46.1760, 66.9552, 55.4112, 57.7200, 46.1760, 53.1024, 36.9408, 62.3376, GAMGI_IO_STROKE,

41.5584, 62.3376, 50.7936, 57.7200, GAMGI_IO_CHAR,

/**************************
 * char: 115 s strokes: 9 *
 **************************/

13.8528, 53.1024, 13.8528, 39.2496, 23.0880, 30.0144, 50.7936, 43.8672, 60.0288, 34.6320, 60.0288, 16.1616, GAMGI_IO_STROKE,

18.4704, 53.1024, 18.4704, 39.2496, 23.0880, 34.6320, GAMGI_IO_STROKE,

23.0880, 57.7200, 23.0880, 39.2496, 27.7056, 34.6320, GAMGI_IO_STROKE,

50.7936, 39.2496, 55.4112, 34.6320, 55.4112, 16.1616, GAMGI_IO_STROKE,

46.1760, 39.2496, 50.7936, 34.6320, 50.7936, 11.5440, GAMGI_IO_STROKE,

13.8528, 53.1024, 41.5584, 66.9552, 55.4112, 62.3376, 46.1760, 57.7200, 32.3232, 62.3376, GAMGI_IO_STROKE,

36.9408, 62.3376, 50.7936, 62.3376, GAMGI_IO_STROKE,

60.0288, 16.1616, 32.3232, 2.3088, 13.8528, 11.5440, 23.0880, 16.1616, 41.5584, 6.9264, GAMGI_IO_STROKE,

23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_CHAR,

/**************************
 * char: 116 t strokes: 5 *
 **************************/

23.0880, 90.0432, 13.8528, 99.2784, 18.4704, 80.8080, 18.4704, 16.1616, 13.8528, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

23.0880, 90.0432, 23.0880, 16.1616, 18.4704, 11.5440, 23.0880, 6.9264, 27.7056, 11.5440, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 90.0432, 32.3232, 99.2784, 27.7056, 80.8080, 27.7056, 16.1616, 32.3232, 11.5440, 23.0880, 2.3088, GAMGI_IO_STROKE,

4.6176, 66.9552, 18.4704, 66.9552, GAMGI_IO_STROKE,

27.7056, 66.9552, 41.5584, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 117 u strokes: 6 *
 **************************/

9.2352, 57.7200, 13.8528, 57.7200, 18.4704, 53.1024, 18.4704, 11.5440, 32.3232, 2.3088, 55.4112, 11.5440, GAMGI_IO_STROKE,

18.4704, 62.3376, 23.0880, 57.7200, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

9.2352, 57.7200, 18.4704, 66.9552, 27.7056, 57.7200, 27.7056, 16.1616, 41.5584, 6.9264, GAMGI_IO_STROKE,

60.0288, 66.9552, 69.2640, 57.7200, 64.6464, 53.1024, 64.6464, 16.1616, 69.2640, 11.5440, 73.8816, 11.5440, GAMGI_IO_STROKE,

60.0288, 53.1024, 64.6464, 57.7200, 60.0288, 62.3376, 55.4112, 57.7200, 60.0288, 53.1024, 60.0288, 11.5440, 64.6464, 6.9264, GAMGI_IO_STROKE,

60.0288, 66.9552, 50.7936, 57.7200, 55.4112, 53.1024, 55.4112, 11.5440, 64.6464, 2.3088, 73.8816, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 118 v strokes: 6 *
 **************************/

13.8528, 66.9552, 18.4704, 57.7200, 18.4704, 16.1616, 36.9408, 2.3088, 46.1760, 11.5440, 64.6464, 20.7792, GAMGI_IO_STROKE,

18.4704, 62.3376, 23.0880, 57.7200, 23.0880, 16.1616, 36.9408, 6.9264, GAMGI_IO_STROKE,

13.8528, 66.9552, 23.0880, 62.3376, 27.7056, 57.7200, 27.7056, 20.7792, 41.5584, 11.5440, 46.1760, 11.5440, GAMGI_IO_STROKE,

60.0288, 66.9552, 69.2640, 57.7200, 64.6464, 53.1024, 64.6464, 20.7792, GAMGI_IO_STROKE,

60.0288, 53.1024, 64.6464, 57.7200, 60.0288, 62.3376, 55.4112, 57.7200, 60.0288, 53.1024, 60.0288, 20.7792, GAMGI_IO_STROKE,

60.0288, 66.9552, 50.7936, 57.7200, 55.4112, 53.1024, 55.4112, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 119 w strokes: 9 *
 **************************/

13.8528, 66.9552, 18.4704, 57.7200, 18.4704, 16.1616, 36.9408, 2.3088, 46.1760, 11.5440, 55.4112, 16.1616, GAMGI_IO_STROKE,

18.4704, 62.3376, 23.0880, 57.7200, 23.0880, 16.1616, 36.9408, 6.9264, GAMGI_IO_STROKE,

13.8528, 66.9552, 23.0880, 62.3376, 27.7056, 57.7200, 27.7056, 20.7792, 41.5584, 11.5440, 46.1760, 11.5440, GAMGI_IO_STROKE,

60.0288, 66.9552, 50.7936, 57.7200, 55.4112, 53.1024, 55.4112, 16.1616, 73.8816, 2.3088, 83.1168, 11.5440, 101.5872, 20.7792, GAMGI_IO_STROKE,

60.0288, 53.1024, 64.6464, 57.7200, 60.0288, 62.3376, 55.4112, 57.7200, 60.0288, 53.1024, 60.0288, 16.1616, 73.8816, 6.9264, GAMGI_IO_STROKE,

60.0288, 66.9552, 69.2640, 57.7200, 64.6464, 53.1024, 64.6464, 20.7792, 78.4992, 11.5440, 83.1168, 11.5440, GAMGI_IO_STROKE,

96.9696, 66.9552, 106.2048, 57.7200, 101.5872, 53.1024, 101.5872, 20.7792, GAMGI_IO_STROKE,

96.9696, 53.1024, 101.5872, 57.7200, 96.9696, 62.3376, 92.3520, 57.7200, 96.9696, 53.1024, 96.9696, 20.7792, GAMGI_IO_STROKE,

96.9696, 66.9552, 87.7344, 57.7200, 92.3520, 53.1024, 92.3520, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 120 x strokes: 7 *
 **************************/

13.8528, 57.7200, 23.0880, 53.1024, 55.4112, 6.9264, 60.0288, 2.3088, 69.2640, 11.5440, GAMGI_IO_STROKE,

18.4704, 62.3376, 27.7056, 57.7200, 55.4112, 11.5440, 64.6464, 6.9264, GAMGI_IO_STROKE,

13.8528, 57.7200, 23.0880, 66.9552, 27.7056, 62.3376, 60.0288, 16.1616, 69.2640, 11.5440, GAMGI_IO_STROKE,

69.2640, 66.9552, 60.0288, 66.9552, 60.0288, 57.7200, 69.2640, 57.7200, 69.2640, 66.9552, 60.0288, 57.7200, 46.1760, 39.2496, GAMGI_IO_STROKE,

36.9408, 30.0144, 23.0880, 11.5440, 13.8528, 2.3088, 23.0880, 2.3088, 23.0880, 11.5440, 13.8528, 11.5440, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 34.6320, 36.9408, 34.6320, GAMGI_IO_STROKE,

46.1760, 34.6320, 60.0288, 34.6320, GAMGI_IO_CHAR,

/**************************
 * char: 121 y strokes: 7 *
 **************************/

9.2352, 57.7200, 13.8528, 57.7200, 18.4704, 53.1024, 18.4704, 11.5440, 32.3232, 2.3088, 55.4112, 11.5440, GAMGI_IO_STROKE,

18.4704, 62.3376, 23.0880, 57.7200, 23.0880, 11.5440, 32.3232, 6.9264, GAMGI_IO_STROKE,

9.2352, 57.7200, 18.4704, 66.9552, 27.7056, 57.7200, 27.7056, 16.1616, 41.5584, 6.9264, GAMGI_IO_STROKE,

60.0288, 66.9552, 69.2640, 57.7200, 64.6464, 53.1024, 64.6464, -6.9264, 60.0288, -16.1616, 55.4112, -20.7792, 46.1760, -25.3968, 36.9408, -25.3968, 27.7056, -20.7792, 18.4704, -25.3968, 27.7056, -30.0144, 36.9408, -25.3968, GAMGI_IO_STROKE,

60.0288, 53.1024, 64.6464, 57.7200, 60.0288, 62.3376, 55.4112, 57.7200, 60.0288, 53.1024, 60.0288, -11.5440, 55.4112, -16.1616, GAMGI_IO_STROKE,

32.3232, -25.3968, 23.0880, -25.3968, GAMGI_IO_STROKE,

60.0288, 66.9552, 50.7936, 57.7200, 55.4112, 53.1024, 55.4112, -11.5440, 50.7936, -20.7792, 46.1760, -25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 122 z strokes: 7 *
 **************************/

27.7056, 62.3376, 13.8528, 53.1024, 13.8528, 57.7200, 27.7056, 62.3376, 36.9408, 66.9552, 50.7936, 57.7200, 50.7936, 39.2496, 27.7056, 30.0144, GAMGI_IO_STROKE,

36.9408, 62.3376, 46.1760, 57.7200, 46.1760, 39.2496, GAMGI_IO_STROKE,

27.7056, 62.3376, 41.5584, 53.1024, 41.5584, 39.2496, 36.9408, 34.6320, GAMGI_IO_STROKE,

27.7056, 30.0144, 50.7936, 20.7792, 50.7936, -6.9264, 46.1760, -16.1616, 41.5584, -20.7792, 32.3232, -25.3968, 23.0880, -25.3968, 13.8528, -20.7792, 4.6176, -25.3968, 13.8528, -30.0144, 23.0880, -25.3968, GAMGI_IO_STROKE,

46.1760, 20.7792, 46.1760, -11.5440, 41.5584, -16.1616, GAMGI_IO_STROKE,

18.4704, -25.3968, 9.2352, -25.3968, GAMGI_IO_STROKE,

36.9408, 25.3968, 41.5584, 20.7792, 41.5584, -11.5440, 36.9408, -20.7792, 32.3232, -25.3968, GAMGI_IO_CHAR,

/**************************
 * char: 123 { strokes: 3 *
 **************************/

46.1760, 117.7488, 32.3232, 103.8960, 27.7056, 90.0432, 27.7056, 80.8080, 32.3232, 66.9552, 41.5584, 57.7200, 41.5584, 53.1024, 23.0880, 43.8672, 41.5584, 34.6320, 41.5584, 30.0144, 32.3232, 20.7792, 27.7056, 6.9264, 27.7056, -2.3088, 32.3232, -16.1616, 46.1760, -30.0144, GAMGI_IO_STROKE,

36.9408, 108.5136, 32.3232, 94.6608, 32.3232, 76.1904, 36.9408, 62.3376, GAMGI_IO_STROKE,

36.9408, 25.3968, 32.3232, 11.5440, 32.3232, -6.9264, 36.9408, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 124 | strokes: 2 *
 **************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_STROKE,

23.0880, 117.7488, 23.0880, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 125 } strokes: 3 *
 **************************/

23.0880, 117.7488, 36.9408, 103.8960, 41.5584, 90.0432, 41.5584, 80.8080, 36.9408, 66.9552, 27.7056, 57.7200, 27.7056, 53.1024, 46.1760, 43.8672, 27.7056, 34.6320, 27.7056, 30.0144, 36.9408, 20.7792, 41.5584, 6.9264, 41.5584, -2.3088, 36.9408, -16.1616, 23.0880, -30.0144, GAMGI_IO_STROKE,

32.3232, 108.5136, 36.9408, 94.6608, 36.9408, 76.1904, 32.3232, 62.3376, GAMGI_IO_STROKE,

32.3232, 25.3968, 36.9408, 11.5440, 36.9408, -6.9264, 32.3232, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 126 ~ strokes: 2 *
 **************************/

13.8528, 30.0144, 13.8528, 39.2496, 18.4704, 53.1024, 27.7056, 57.7200, 36.9408, 57.7200, 46.1760, 53.1024, 64.6464, 39.2496, 73.8816, 34.6320, 83.1168, 34.6320, 92.3520, 39.2496, 96.9696, 48.4848, GAMGI_IO_STROKE,

13.8528, 39.2496, 18.4704, 48.4848, 27.7056, 53.1024, 36.9408, 53.1024, 46.1760, 48.4848, 64.6464, 34.6320, 73.8816, 30.0144, 83.1168, 30.0144, 92.3520, 34.6320, 96.9696, 48.4848, 96.9696, 57.7200, GAMGI_IO_CHAR,

};

const float gamgi_io_font_hershey_symbol_sans_points[GAMGI_IO_POINTS_SYMBOL_SANS] = {

/***************
 * bottom, top *
 ***************/

-32.3232, 120.0576,

/**************
 * char 32-40 *
 **************/

73.8816, 46.1760, 83.1168, 101.5872, 87.7344, 110.8224, 120.0576, 110.8224, 64.6464, 

/**************
 * char 41-50 *
 **************/

64.6464, 73.8816, 120.0576, 46.1760, 120.0576, 46.1760, 101.5872, 92.3520, 92.3520, 92.3520, 

/**************
 * char 51-60 *
 **************/

92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 46.1760, 46.1760, 110.8224, 

/**************
 * char 61-70 *
 **************/

120.0576, 110.8224, 83.1168, 110.8224, 83.1168, 96.9696, 92.3520, 83.1168, 87.7344, 92.3520, 

/**************
 * char 71-80 *
 **************/

78.4992, 101.5872, 36.9408, 101.5872, 96.9696, 83.1168, 110.8224, 101.5872, 101.5872, 101.5872, 

/**************
 * char 81-90 *
 **************/

101.5872, 96.9696, 83.1168, 73.8816, 83.1168, 83.1168, 92.3520, 83.1168, 101.5872, 92.3520, 

/***************
 * char 91-100 *
 ***************/

64.6464, 120.0576, 64.6464, 110.8224, 101.5872, 0.0, 96.9696, 87.7344, 83.1168, 83.1168, 
/*64.6464, 120.0576, 64.6464, 110.8224, 101.5872, 101.5872, 96.9696, 87.7344, 83.1168, 83.1168,*/ 

/****************
 * char 101-110 *
 ****************/

73.8816, 92.3520, 87.7344, 92.3520, 50.7936, 101.5872, 83.1168, 73.8816, 96.9696, 83.1168, 

/****************
 * char 111-120 *
 ****************/

78.4992, 101.5872, 78.4992, 83.1168, 92.3520, 92.3520, 92.3520, 106.2048, 106.2048, 73.8816, 

/****************
 * char 121-126 *
 ****************/

106.2048, 69.2640, 64.6464, 36.9408, 64.6464, 110.8224, 

/*************************
 * char: 32   strokes: 0 *
 *************************/

GAMGI_IO_CHAR,

/*************************
 * char: 33 ! strokes: 2 *
 *************************/

23.0880, 99.2784, 23.0880, 34.6320, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 6.9264, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 34 " strokes: 2 *
 *************************/

9.2352, 99.2784, 41.5584, 2.3088, 73.8816, 99.2784, GAMGI_IO_STROKE,

18.4704, 71.5728, 64.6464, 71.5728, GAMGI_IO_CHAR,

/*************************
 * char: 35 # strokes: 4 *
 *************************/

36.9408, 99.2784, 36.9408, -30.0144, GAMGI_IO_STROKE,

64.6464, 99.2784, 64.6464, -30.0144, GAMGI_IO_STROKE,

13.8528, 48.4848, 87.7344, 48.4848, GAMGI_IO_STROKE,

13.8528, 20.7792, 87.7344, 20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 36 $ strokes: 4 *
 *************************/

69.2640, 99.2784, 69.2640, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 69.2640, 99.2784, GAMGI_IO_STROKE,

32.3232, 53.1024, 69.2640, 53.1024, GAMGI_IO_STROKE,

9.2352, 2.3088, 69.2640, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 37 % strokes: 3 *
 *************************/

96.9696, 99.2784, 87.7344, 94.6608, 73.8816, 90.0432, 60.0288, 90.0432, 46.1760, 94.6608, 36.9408, 99.2784, 27.7056, 99.2784, 18.4704, 94.6608, 13.8528, 85.4256, 13.8528, 76.1904, 23.0880, 66.9552, 32.3232, 66.9552, 41.5584, 71.5728, 46.1760, 80.8080, 46.1760, 90.0432, 36.9408, 99.2784, GAMGI_IO_STROKE,

96.9696, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

87.7344, 34.6320, 78.4992, 34.6320, 69.2640, 30.0144, 64.6464, 20.7792, 64.6464, 11.5440, 73.8816, 2.3088, 83.1168, 2.3088, 92.3520, 6.9264, 96.9696, 16.1616, 96.9696, 25.3968, 87.7344, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 38 & strokes: 1 *
 *************************/

106.2048, 57.7200, 106.2048, 62.3376, 101.5872, 66.9552, 96.9696, 66.9552, 92.3520, 62.3376, 87.7344, 53.1024, 78.4992, 30.0144, 69.2640, 16.1616, 60.0288, 6.9264, 50.7936, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 30.0144, 18.4704, 39.2496, 23.0880, 43.8672, 55.4112, 62.3376, 60.0288, 66.9552, 64.6464, 76.1904, 64.6464, 85.4256, 60.0288, 94.6608, 50.7936, 99.2784, 41.5584, 94.6608, 36.9408, 85.4256, 36.9408, 76.1904, 41.5584, 62.3376, 50.7936, 48.4848, 73.8816, 16.1616, 83.1168, 6.9264, 92.3520, 2.3088, 101.5872, 2.3088, 106.2048, 6.9264, 106.2048, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 39 ' strokes: 2 *
 *************************/

18.4704, 80.8080, 50.7936, 80.8080, 69.2640, 76.1904, 78.4992, 71.5728, 87.7344, 62.3376, 92.3520, 48.4848, 92.3520, 39.2496, 87.7344, 25.3968, 78.4992, 16.1616, 69.2640, 11.5440, 50.7936, 6.9264, 18.4704, 6.9264, GAMGI_IO_STROKE,

41.5584, 43.8672, 92.3520, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 40 ( strokes: 1 *
 *************************/

50.7936, 117.7488, 41.5584, 108.5136, 32.3232, 94.6608, 23.0880, 76.1904, 18.4704, 53.1024, 18.4704, 34.6320, 23.0880, 11.5440, 32.3232, -6.9264, 41.5584, -20.7792, 50.7936, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 41 ) strokes: 1 *
 *************************/

13.8528, 117.7488, 23.0880, 108.5136, 32.3232, 94.6608, 41.5584, 76.1904, 46.1760, 53.1024, 46.1760, 34.6320, 41.5584, 11.5440, 32.3232, -6.9264, 23.0880, -20.7792, 13.8528, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 42 * strokes: 3 *
 *************************/

36.9408, 71.5728, 36.9408, 16.1616, GAMGI_IO_STROKE,

13.8528, 57.7200, 60.0288, 30.0144, GAMGI_IO_STROKE,

60.0288, 57.7200, 13.8528, 30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 43 + strokes: 2 *
 *************************/

60.0288, 85.4256, 60.0288, 2.3088, GAMGI_IO_STROKE,

18.4704, 43.8672, 101.5872, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 44 , strokes: 1 *
 *************************/

27.7056, 6.9264, 23.0880, 2.3088, 18.4704, 6.9264, 23.0880, 11.5440, 27.7056, 6.9264, 27.7056, -2.3088, 23.0880, -11.5440, 18.4704, -16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 45 - strokes: 1 *
 *************************/

18.4704, 43.8672, 101.5872, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 46 . strokes: 1 *
 *************************/

23.0880, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 6.9264, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 47 / strokes: 1 *
 *************************/

92.3520, 117.7488, 9.2352, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 48 0 strokes: 1 *
 *************************/

41.5584, 99.2784, 27.7056, 94.6608, 18.4704, 80.8080, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 20.7792, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 20.7792, 78.4992, 43.8672, 78.4992, 57.7200, 73.8816, 80.8080, 64.6464, 94.6608, 50.7936, 99.2784, 41.5584, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 49 1 strokes: 1 *
 *************************/

27.7056, 80.8080, 36.9408, 85.4256, 50.7936, 99.2784, 50.7936, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 50 2 strokes: 1 *
 *************************/

18.4704, 76.1904, 18.4704, 80.8080, 23.0880, 90.0432, 27.7056, 94.6608, 36.9408, 99.2784, 55.4112, 99.2784, 64.6464, 94.6608, 69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 71.5728, 69.2640, 62.3376, 60.0288, 48.4848, 13.8528, 2.3088, 78.4992, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 51 3 strokes: 1 *
 *************************/

23.0880, 99.2784, 73.8816, 99.2784, 46.1760, 62.3376, 60.0288, 62.3376, 69.2640, 57.7200, 73.8816, 53.1024, 78.4992, 39.2496, 78.4992, 30.0144, 73.8816, 16.1616, 64.6464, 6.9264, 50.7936, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 52 4 strokes: 2 *
 *************************/

60.0288, 99.2784, 13.8528, 34.6320, 83.1168, 34.6320, GAMGI_IO_STROKE,

60.0288, 99.2784, 60.0288, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 53 5 strokes: 1 *
 *************************/

69.2640, 99.2784, 23.0880, 99.2784, 18.4704, 57.7200, 23.0880, 62.3376, 36.9408, 66.9552, 50.7936, 66.9552, 64.6464, 62.3376, 73.8816, 53.1024, 78.4992, 39.2496, 78.4992, 30.0144, 73.8816, 16.1616, 64.6464, 6.9264, 50.7936, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 54 6 strokes: 1 *
 *************************/

73.8816, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 80.8080, 18.4704, 57.7200, 18.4704, 34.6320, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 30.0144, 78.4992, 34.6320, 73.8816, 48.4848, 64.6464, 57.7200, 50.7936, 62.3376, 46.1760, 62.3376, 32.3232, 57.7200, 23.0880, 48.4848, 18.4704, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 55 7 strokes: 2 *
 *************************/

78.4992, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 78.4992, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 56 8 strokes: 1 *
 *************************/

36.9408, 99.2784, 23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 76.1904, 23.0880, 66.9552, 32.3232, 62.3376, 50.7936, 57.7200, 64.6464, 53.1024, 73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 20.7792, 73.8816, 11.5440, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 34.6320, 18.4704, 43.8672, 27.7056, 53.1024, 41.5584, 57.7200, 60.0288, 62.3376, 69.2640, 66.9552, 73.8816, 76.1904, 73.8816, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 57 9 strokes: 1 *
 *************************/

73.8816, 66.9552, 69.2640, 53.1024, 60.0288, 43.8672, 46.1760, 39.2496, 41.5584, 39.2496, 27.7056, 43.8672, 18.4704, 53.1024, 13.8528, 66.9552, 13.8528, 71.5728, 18.4704, 85.4256, 27.7056, 94.6608, 41.5584, 99.2784, 46.1760, 99.2784, 60.0288, 94.6608, 69.2640, 85.4256, 73.8816, 66.9552, 73.8816, 43.8672, 69.2640, 20.7792, 60.0288, 6.9264, 46.1760, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 58 : strokes: 2 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 23.0880, 57.7200, 27.7056, 62.3376, 23.0880, 66.9552, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 6.9264, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 59 ; strokes: 2 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 23.0880, 57.7200, 27.7056, 62.3376, 23.0880, 66.9552, GAMGI_IO_STROKE,

27.7056, 6.9264, 23.0880, 2.3088, 18.4704, 6.9264, 23.0880, 11.5440, 27.7056, 6.9264, 27.7056, -2.3088, 23.0880, -11.5440, 18.4704, -16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 60 < strokes: 1 *
 *************************/

92.3520, 85.4256, 18.4704, 43.8672, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 61 = strokes: 2 *
 *************************/

18.4704, 57.7200, 101.5872, 57.7200, GAMGI_IO_STROKE,

18.4704, 30.0144, 101.5872, 30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 62 > strokes: 1 *
 *************************/

18.4704, 85.4256, 92.3520, 43.8672, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 63 ? strokes: 2 *
 *************************/

13.8528, 76.1904, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 32.3232, 99.2784, 50.7936, 99.2784, 60.0288, 94.6608, 64.6464, 90.0432, 69.2640, 80.8080, 69.2640, 71.5728, 64.6464, 62.3376, 60.0288, 57.7200, 41.5584, 48.4848, 41.5584, 34.6320, GAMGI_IO_STROKE,

41.5584, 11.5440, 36.9408, 6.9264, 41.5584, 2.3088, 46.1760, 6.9264, 41.5584, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 64 @ strokes: 4 *
 *************************/

13.8528, 39.2496, 18.4704, 48.4848, 27.7056, 53.1024, 36.9408, 53.1024, 46.1760, 48.4848, 64.6464, 34.6320, 73.8816, 30.0144, 83.1168, 30.0144, 92.3520, 34.6320, 96.9696, 48.4848, GAMGI_IO_STROKE,

13.8528, 39.2496, 18.4704, 53.1024, 27.7056, 57.7200, 36.9408, 57.7200, 46.1760, 53.1024, 64.6464, 39.2496, 73.8816, 34.6320, 83.1168, 34.6320, 92.3520, 39.2496, 96.9696, 48.4848, GAMGI_IO_STROKE,

13.8528, 20.7792, 96.9696, 20.7792, GAMGI_IO_STROKE,

13.8528, 2.3088, 96.9696, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 65 A strokes: 3 *
 *************************/

41.5584, 99.2784, 4.6176, 2.3088, GAMGI_IO_STROKE,

41.5584, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

18.4704, 34.6320, 64.6464, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 66 B strokes: 3 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 60.0288, 99.2784, 73.8816, 94.6608, 78.4992, 90.0432, 83.1168, 80.8080, 83.1168, 71.5728, 78.4992, 62.3376, 73.8816, 57.7200, 60.0288, 53.1024, GAMGI_IO_STROKE,

18.4704, 53.1024, 60.0288, 53.1024, 73.8816, 48.4848, 78.4992, 43.8672, 83.1168, 34.6320, 83.1168, 20.7792, 78.4992, 11.5440, 73.8816, 6.9264, 60.0288, 2.3088, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 67 C strokes: 2 *
 *************************/

13.8528, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

13.8528, 2.3088, 78.4992, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 68 D strokes: 3 *
 *************************/

41.5584, 99.2784, 4.6176, 2.3088, GAMGI_IO_STROKE,

41.5584, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

4.6176, 2.3088, 78.4992, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 69 E strokes: 4 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 78.4992, 99.2784, GAMGI_IO_STROKE,

18.4704, 53.1024, 55.4112, 53.1024, GAMGI_IO_STROKE,

18.4704, 2.3088, 78.4992, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 70 F strokes: 2 *
 *************************/

46.1760, 99.2784, 46.1760, 2.3088, GAMGI_IO_STROKE,

36.9408, 76.1904, 23.0880, 71.5728, 18.4704, 66.9552, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 34.6320, 23.0880, 30.0144, 36.9408, 25.3968, 55.4112, 25.3968, 69.2640, 30.0144, 73.8816, 34.6320, 78.4992, 43.8672, 78.4992, 57.7200, 73.8816, 66.9552, 69.2640, 71.5728, 55.4112, 76.1904, 36.9408, 76.1904, GAMGI_IO_CHAR,

/*************************
 * char: 71 G strokes: 2 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 73.8816, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 72 H strokes: 3 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 83.1168, 2.3088, GAMGI_IO_STROKE,

18.4704, 53.1024, 83.1168, 53.1024, GAMGI_IO_CHAR,

/*************************
 * char: 73 I strokes: 1 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 74 J strokes: 2 *
 *************************/

41.5584, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 62.3376, 13.8528, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, 87.7344, 39.2496, 87.7344, 62.3376, 83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

36.9408, 53.1024, 64.6464, 53.1024, GAMGI_IO_CHAR,

/*************************
 * char: 75 K strokes: 3 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 18.4704, 34.6320, GAMGI_IO_STROKE,

41.5584, 57.7200, 83.1168, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 76 L strokes: 2 *
 *************************/

41.5584, 99.2784, 4.6176, 2.3088, GAMGI_IO_STROKE,

41.5584, 99.2784, 78.4992, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 77 M strokes: 4 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 55.4112, 2.3088, GAMGI_IO_STROKE,

92.3520, 99.2784, 55.4112, 2.3088, GAMGI_IO_STROKE,

92.3520, 99.2784, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 78 N strokes: 3 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 83.1168, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 83.1168, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 79 O strokes: 1 *
 *************************/

41.5584, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 62.3376, 13.8528, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, 87.7344, 39.2496, 87.7344, 62.3376, 83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 41.5584, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 80 P strokes: 3 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 83.1168, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 83.1168, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 81 Q strokes: 2 *
 *************************/

41.5584, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 62.3376, 13.8528, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, 87.7344, 39.2496, 87.7344, 62.3376, 83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

36.9408, 53.1024, 64.6464, 53.1024, GAMGI_IO_CHAR,

/*************************
 * char: 82 R strokes: 2 *
 *************************/

18.4704, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 60.0288, 99.2784, 73.8816, 94.6608, 78.4992, 90.0432, 83.1168, 80.8080, 83.1168, 66.9552, 78.4992, 57.7200, 73.8816, 53.1024, 60.0288, 48.4848, 18.4704, 48.4848, GAMGI_IO_CHAR,

/*************************
 * char: 83 S strokes: 3 *
 *************************/

9.2352, 99.2784, 41.5584, 53.1024, 9.2352, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 73.8816, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 73.8816, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 84 T strokes: 2 *
 *************************/

36.9408, 99.2784, 36.9408, 2.3088, GAMGI_IO_STROKE,

4.6176, 99.2784, 69.2640, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 85 U strokes: 2 *
 *************************/

4.6176, 99.2784, 41.5584, 53.1024, 41.5584, 2.3088, GAMGI_IO_STROKE,

78.4992, 99.2784, 41.5584, 53.1024, GAMGI_IO_CHAR,

/*************************
 * char: 86 V strokes: 1 *
 *************************/

69.2640, 57.7200, 64.6464, 62.3376, 50.7936, 66.9552, 36.9408, 66.9552, 23.0880, 62.3376, 18.4704, 57.7200, 13.8528, 48.4848, 13.8528, 39.2496, 18.4704, 30.0144, 27.7056, 20.7792, 46.1760, 6.9264, 50.7936, -2.3088, 50.7936, -11.5440, 46.1760, -16.1616, 36.9408, -16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 87 W strokes: 1 *
 *************************/

13.8528, 2.3088, 32.3232, 2.3088, 18.4704, 34.6320, 13.8528, 53.1024, 13.8528, 71.5728, 18.4704, 85.4256, 27.7056, 94.6608, 41.5584, 99.2784, 50.7936, 99.2784, 64.6464, 94.6608, 73.8816, 85.4256, 78.4992, 71.5728, 78.4992, 53.1024, 73.8816, 34.6320, 60.0288, 2.3088, 78.4992, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 88 X strokes: 3 *
 *************************/

9.2352, 99.2784, 73.8816, 99.2784, GAMGI_IO_STROKE,

27.7056, 53.1024, 55.4112, 53.1024, GAMGI_IO_STROKE,

9.2352, 2.3088, 73.8816, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 89 Y strokes: 2 *
 *************************/

50.7936, 99.2784, 50.7936, 2.3088, GAMGI_IO_STROKE,

9.2352, 71.5728, 13.8528, 71.5728, 18.4704, 66.9552, 23.0880, 48.4848, 27.7056, 39.2496, 32.3232, 34.6320, 46.1760, 30.0144, 55.4112, 30.0144, 69.2640, 34.6320, 73.8816, 39.2496, 78.4992, 48.4848, 83.1168, 66.9552, 87.7344, 71.5728, 92.3520, 71.5728, GAMGI_IO_CHAR,

/*************************
 * char: 90 Z strokes: 3 *
 *************************/

78.4992, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 78.4992, 99.2784, GAMGI_IO_STROKE,

13.8528, 2.3088, 78.4992, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 91 [ strokes: 3 *
 *************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_STROKE,

18.4704, 117.7488, 50.7936, 117.7488, GAMGI_IO_STROKE,

18.4704, -30.0144, 50.7936, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 92 \ strokes: 3 *
 *************************/

60.0288, 85.4256, 55.4112, 80.8080, 60.0288, 76.1904, 64.6464, 80.8080, 60.0288, 85.4256, GAMGI_IO_STROKE,

18.4704, 11.5440, 13.8528, 6.9264, 18.4704, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, GAMGI_IO_STROKE,

101.5872, 11.5440, 96.9696, 6.9264, 101.5872, 2.3088, 106.2048, 6.9264, 101.5872, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 93 ] strokes: 3 *
 *************************/

46.1760, 117.7488, 46.1760, -30.0144, GAMGI_IO_STROKE,

13.8528, 117.7488, 46.1760, 117.7488, GAMGI_IO_STROKE,

13.8528, -30.0144, 46.1760, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 94 ^ strokes: 2 *
 *************************/

55.4112, 117.7488, 55.4112, 2.3088, GAMGI_IO_STROKE,

13.8528, 2.3088, 96.9696, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 95 _ strokes: 1 *
 *************************/

9.2352, -6.9264, 92.3520, -6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 96 ` strokes: 1 *
 *************************/

18.4704, 117.7488, 92.3520, 117.7488, GAMGI_IO_CHAR,
/*152.3808, 154.6896, 263.2032, 154.6896, GAMGI_IO_CHAR,*/

/*************************
 * char: 97 a strokes: 2 *
 *************************/

41.5584, 66.9552, 32.3232, 62.3376, 23.0880, 53.1024, 18.4704, 43.8672, 13.8528, 30.0144, 13.8528, 16.1616, 18.4704, 6.9264, 27.7056, 2.3088, 36.9408, 2.3088, 46.1760, 6.9264, 60.0288, 20.7792, 69.2640, 34.6320, 78.4992, 53.1024, 83.1168, 66.9552, GAMGI_IO_STROKE,

41.5584, 66.9552, 50.7936, 66.9552, 55.4112, 62.3376, 60.0288, 53.1024, 69.2640, 16.1616, 73.8816, 6.9264, 78.4992, 2.3088, 83.1168, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 98 b strokes: 3 *
 *************************/

55.4112, 99.2784, 46.1760, 94.6608, 36.9408, 85.4256, 27.7056, 66.9552, 23.0880, 53.1024, 18.4704, 34.6320, 13.8528, 6.9264, 9.2352, -30.0144, GAMGI_IO_STROKE,

55.4112, 99.2784, 64.6464, 99.2784, 73.8816, 90.0432, 73.8816, 76.1904, 69.2640, 66.9552, 64.6464, 62.3376, 55.4112, 57.7200, 41.5584, 57.7200, GAMGI_IO_STROKE,

41.5584, 57.7200, 50.7936, 53.1024, 60.0288, 43.8672, 64.6464, 34.6320, 64.6464, 20.7792, 60.0288, 11.5440, 55.4112, 6.9264, 46.1760, 2.3088, 36.9408, 2.3088, 27.7056, 6.9264, 23.0880, 11.5440, 18.4704, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 99 c strokes: 2 *
 *************************/

9.2352, 66.9552, 18.4704, 66.9552, 27.7056, 57.7200, 55.4112, -20.7792, 64.6464, -30.0144, 73.8816, -30.0144, GAMGI_IO_STROKE,

78.4992, 66.9552, 73.8816, 57.7200, 64.6464, 43.8672, 18.4704, -6.9264, 9.2352, -20.7792, 4.6176, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 100 d strokes: 1 *
 **************************/

50.7936, 66.9552, 36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 25.3968, 18.4704, 11.5440, 23.0880, 6.9264, 32.3232, 2.3088, 41.5584, 2.3088, 50.7936, 6.9264, 60.0288, 16.1616, 64.6464, 30.0144, 64.6464, 43.8672, 60.0288, 57.7200, 50.7936, 66.9552, 41.5584, 76.1904, 36.9408, 85.4256, 36.9408, 94.6608, 41.5584, 99.2784, 50.7936, 99.2784, 60.0288, 94.6608, 69.2640, 85.4256, GAMGI_IO_CHAR,

/**************************
 * char: 101 e strokes: 2 *
 **************************/

60.0288, 57.7200, 55.4112, 62.3376, 46.1760, 66.9552, 32.3232, 66.9552, 23.0880, 62.3376, 23.0880, 53.1024, 27.7056, 43.8672, 41.5584, 39.2496, GAMGI_IO_STROKE,

41.5584, 39.2496, 23.0880, 34.6320, 13.8528, 25.3968, 13.8528, 16.1616, 18.4704, 6.9264, 27.7056, 2.3088, 41.5584, 2.3088, 50.7936, 6.9264, 60.0288, 16.1616, GAMGI_IO_CHAR,

/**************************
 * char: 102 f strokes: 2 *
 **************************/

64.6464, 99.2784, 27.7056, -30.0144, GAMGI_IO_STROKE,

41.5584, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 25.3968, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 30.0144, 78.4992, 43.8672, 73.8816, 53.1024, 64.6464, 62.3376, 50.7936, 66.9552, 41.5584, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 103 g strokes: 2 *
 **************************/

4.6176, 53.1024, 13.8528, 62.3376, 23.0880, 66.9552, 27.7056, 66.9552, 36.9408, 62.3376, 41.5584, 57.7200, 46.1760, 43.8672, 46.1760, 25.3968, 41.5584, 2.3088, GAMGI_IO_STROKE,

78.4992, 66.9552, 73.8816, 53.1024, 69.2640, 43.8672, 41.5584, 2.3088, 32.3232, -16.1616, 27.7056, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 104 h strokes: 2 *
 **************************/

4.6176, 48.4848, 9.2352, 57.7200, 18.4704, 66.9552, 27.7056, 66.9552, 32.3232, 62.3376, 32.3232, 53.1024, 27.7056, 34.6320, 18.4704, 2.3088, GAMGI_IO_STROKE,

27.7056, 34.6320, 36.9408, 53.1024, 46.1760, 62.3376, 55.4112, 66.9552, 64.6464, 66.9552, 73.8816, 57.7200, 73.8816, 43.8672, 69.2640, 20.7792, 55.4112, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 105 i strokes: 1 *
 **************************/

27.7056, 66.9552, 18.4704, 34.6320, 13.8528, 16.1616, 13.8528, 6.9264, 18.4704, 2.3088, 27.7056, 2.3088, 36.9408, 11.5440, 41.5584, 20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 106 j strokes: 1 *
 **************************/

36.9408, 62.3376, 27.7056, 57.7200, 18.4704, 48.4848, 13.8528, 34.6320, 13.8528, 20.7792, 18.4704, 11.5440, 23.0880, 6.9264, 32.3232, 2.3088, 46.1760, 2.3088, 60.0288, 6.9264, 73.8816, 16.1616, 83.1168, 30.0144, 87.7344, 43.8672, 87.7344, 57.7200, 78.4992, 66.9552, 69.2640, 66.9552, 60.0288, 57.7200, 50.7936, 39.2496, 41.5584, 16.1616, 27.7056, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 107 k strokes: 3 *
 **************************/

27.7056, 66.9552, 9.2352, 2.3088, GAMGI_IO_STROKE,

73.8816, 62.3376, 69.2640, 66.9552, 64.6464, 66.9552, 55.4112, 62.3376, 36.9408, 43.8672, 27.7056, 39.2496, 23.0880, 39.2496, GAMGI_IO_STROKE,

23.0880, 39.2496, 32.3232, 34.6320, 36.9408, 30.0144, 46.1760, 6.9264, 50.7936, 2.3088, 55.4112, 2.3088, 60.0288, 6.9264, GAMGI_IO_CHAR,

/**************************
 * char: 108 l strokes: 2 *
 **************************/

4.6176, 99.2784, 13.8528, 99.2784, 23.0880, 94.6608, 27.7056, 90.0432, 64.6464, 2.3088, GAMGI_IO_STROKE,

36.9408, 66.9552, 9.2352, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 109 m strokes: 3 *
 **************************/

32.3232, 66.9552, 4.6176, -30.0144, GAMGI_IO_STROKE,

27.7056, 48.4848, 23.0880, 25.3968, 23.0880, 11.5440, 32.3232, 2.3088, 41.5584, 2.3088, 50.7936, 6.9264, 60.0288, 16.1616, 69.2640, 34.6320, GAMGI_IO_STROKE,

78.4992, 66.9552, 69.2640, 34.6320, 64.6464, 16.1616, 64.6464, 6.9264, 69.2640, 2.3088, 78.4992, 2.3088, 87.7344, 11.5440, 92.3520, 20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 110 n strokes: 2 *
 **************************/

13.8528, 66.9552, 27.7056, 66.9552, 23.0880, 39.2496, 18.4704, 16.1616, 13.8528, 2.3088, GAMGI_IO_STROKE,

73.8816, 66.9552, 69.2640, 53.1024, 64.6464, 43.8672, 55.4112, 30.0144, 41.5584, 16.1616, 27.7056, 6.9264, 13.8528, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 111 o strokes: 1 *
 **************************/

36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 25.3968, 18.4704, 11.5440, 23.0880, 6.9264, 32.3232, 2.3088, 41.5584, 2.3088, 50.7936, 6.9264, 60.0288, 16.1616, 64.6464, 30.0144, 64.6464, 43.8672, 60.0288, 57.7200, 55.4112, 62.3376, 46.1760, 66.9552, 36.9408, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 112 p strokes: 3 *
 **************************/

41.5584, 66.9552, 23.0880, 2.3088, GAMGI_IO_STROKE,

64.6464, 66.9552, 69.2640, 39.2496, 73.8816, 16.1616, 78.4992, 2.3088, GAMGI_IO_STROKE,

9.2352, 53.1024, 18.4704, 62.3376, 32.3232, 66.9552, 92.3520, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 113 q strokes: 2 *
 **************************/

46.1760, 99.2784, 36.9408, 94.6608, 27.7056, 80.8080, 23.0880, 71.5728, 18.4704, 57.7200, 13.8528, 34.6320, 13.8528, 16.1616, 18.4704, 6.9264, 23.0880, 2.3088, 32.3232, 2.3088, 41.5584, 6.9264, 50.7936, 20.7792, 55.4112, 30.0144, 60.0288, 43.8672, 64.6464, 66.9552, 64.6464, 85.4256, 60.0288, 94.6608, 55.4112, 99.2784, 46.1760, 99.2784, GAMGI_IO_STROKE,

18.4704, 53.1024, 60.0288, 53.1024, GAMGI_IO_CHAR,

/**************************
 * char: 114 r strokes: 1 *
 **************************/

18.4704, 39.2496, 18.4704, 25.3968, 23.0880, 11.5440, 27.7056, 6.9264, 36.9408, 2.3088, 46.1760, 2.3088, 55.4112, 6.9264, 64.6464, 16.1616, 69.2640, 30.0144, 69.2640, 43.8672, 64.6464, 57.7200, 60.0288, 62.3376, 50.7936, 66.9552, 41.5584, 66.9552, 32.3232, 62.3376, 23.0880, 53.1024, 18.4704, 39.2496, 0.0000, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 115 s strokes: 1 *
 **************************/

83.1168, 66.9552, 36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 25.3968, 18.4704, 11.5440, 23.0880, 6.9264, 32.3232, 2.3088, 41.5584, 2.3088, 50.7936, 6.9264, 60.0288, 16.1616, 64.6464, 30.0144, 64.6464, 43.8672, 60.0288, 57.7200, 55.4112, 62.3376, 46.1760, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 116 t strokes: 2 *
 **************************/

50.7936, 66.9552, 36.9408, 2.3088, GAMGI_IO_STROKE,

9.2352, 53.1024, 18.4704, 62.3376, 32.3232, 66.9552, 83.1168, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 117 u strokes: 1 *
 **************************/

4.6176, 48.4848, 9.2352, 57.7200, 18.4704, 66.9552, 27.7056, 66.9552, 32.3232, 62.3376, 32.3232, 53.1024, 23.0880, 25.3968, 23.0880, 11.5440, 32.3232, 2.3088, 41.5584, 2.3088, 55.4112, 6.9264, 64.6464, 16.1616, 73.8816, 34.6320, 78.4992, 53.1024, 78.4992, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 118 v strokes: 2 *
 **************************/

36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 48.4848, 13.8528, 34.6320, 13.8528, 20.7792, 18.4704, 6.9264, 23.0880, 2.3088, 32.3232, 2.3088, 41.5584, 6.9264, 50.7936, 20.7792, GAMGI_IO_STROKE,

55.4112, 39.2496, 50.7936, 20.7792, 55.4112, 6.9264, 60.0288, 2.3088, 69.2640, 2.3088, 78.4992, 6.9264, 87.7344, 20.7792, 92.3520, 34.6320, 92.3520, 48.4848, 87.7344, 62.3376, 83.1168, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 119 w strokes: 2 *
 **************************/

36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 48.4848, 13.8528, 34.6320, 13.8528, 20.7792, 18.4704, 6.9264, 23.0880, 2.3088, 32.3232, 2.3088, 41.5584, 6.9264, 50.7936, 20.7792, GAMGI_IO_STROKE,

55.4112, 39.2496, 50.7936, 20.7792, 55.4112, 6.9264, 60.0288, 2.3088, 69.2640, 2.3088, 78.4992, 6.9264, 87.7344, 20.7792, 92.3520, 34.6320, 92.3520, 48.4848, 87.7344, 62.3376, 83.1168, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 120 x strokes: 3 *
 **************************/

46.1760, 99.2784, 36.9408, 94.6608, 32.3232, 90.0432, 32.3232, 85.4256, 36.9408, 80.8080, 50.7936, 76.1904, 64.6464, 76.1904, GAMGI_IO_STROKE,

50.7936, 76.1904, 36.9408, 71.5728, 27.7056, 66.9552, 23.0880, 57.7200, 23.0880, 48.4848, 32.3232, 39.2496, 46.1760, 34.6320, 55.4112, 34.6320, GAMGI_IO_STROKE,

46.1760, 34.6320, 27.7056, 30.0144, 18.4704, 25.3968, 13.8528, 16.1616, 13.8528, 6.9264, 23.0880, -2.3088, 41.5584, -11.5440, 46.1760, -16.1616, 46.1760, -25.3968, 36.9408, -30.0144, 27.7056, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 121 y strokes: 2 *
 **************************/

73.8816, 99.2784, 36.9408, -30.0144, GAMGI_IO_STROKE,

4.6176, 48.4848, 9.2352, 57.7200, 18.4704, 66.9552, 27.7056, 66.9552, 32.3232, 62.3376, 32.3232, 53.1024, 27.7056, 30.0144, 27.7056, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 83.1168, 30.0144, 92.3520, 53.1024, 96.9696, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 122 z strokes: 2 *
 **************************/

46.1760, 99.2784, 36.9408, 94.6608, 32.3232, 90.0432, 32.3232, 85.4256, 36.9408, 80.8080, 50.7936, 76.1904, 64.6464, 76.1904, GAMGI_IO_STROKE,

64.6464, 76.1904, 46.1760, 66.9552, 32.3232, 57.7200, 18.4704, 43.8672, 13.8528, 30.0144, 13.8528, 20.7792, 18.4704, 11.5440, 27.7056, 2.3088, 41.5584, -6.9264, 46.1760, -16.1616, 46.1760, -25.3968, 41.5584, -30.0144, 32.3232, -30.0144, 27.7056, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 123 { strokes: 1 *
 **************************/

41.5584, 117.7488, 27.7056, 103.8960, 23.0880, 90.0432, 23.0880, 80.8080, 27.7056, 66.9552, 36.9408, 57.7200, 36.9408, 53.1024, 18.4704, 43.8672, 36.9408, 34.6320, 36.9408, 30.0144, 27.7056, 20.7792, 23.0880, 6.9264, 23.0880, -2.3088, 27.7056, -16.1616, 41.5584, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 124 | strokes: 1 *
 **************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 125 } strokes: 1 *
 **************************/

23.0880, 117.7488, 36.9408, 103.8960, 41.5584, 90.0432, 41.5584, 80.8080, 36.9408, 66.9552, 27.7056, 57.7200, 27.7056, 53.1024, 46.1760, 43.8672, 27.7056, 34.6320, 27.7056, 30.0144, 36.9408, 20.7792, 41.5584, 6.9264, 41.5584, -2.3088, 36.9408, -16.1616, 23.0880, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 126 ~ strokes: 2 *
 **************************/

13.8528, 30.0144, 13.8528, 39.2496, 18.4704, 53.1024, 27.7056, 57.7200, 36.9408, 57.7200, 46.1760, 53.1024, 64.6464, 39.2496, 73.8816, 34.6320, 83.1168, 34.6320, 92.3520, 39.2496, 96.9696, 48.4848, GAMGI_IO_STROKE,

13.8528, 39.2496, 18.4704, 48.4848, 27.7056, 53.1024, 36.9408, 53.1024, 46.1760, 48.4848, 64.6464, 34.6320, 73.8816, 30.0144, 83.1168, 30.0144, 92.3520, 34.6320, 96.9696, 48.4848, 96.9696, 57.7200, GAMGI_IO_CHAR,

};

const float gamgi_io_font_hershey_symbol_serif_points[GAMGI_IO_POINTS_SYMBOL_SERIF] = {

/***************
 * bottom, top *
 ***************/

-32.3232, 120.0576,

/**************
 * char 32-40 *
 **************/

73.8816, 46.1760, 83.1168, 101.5872, 87.7344, 110.8224, 115.4400, 110.8224, 64.6464, 

/**************
 * char 41-50 *
 **************/

64.6464, 73.8816, 120.0576, 46.1760, 120.0576, 46.1760, 101.5872, 92.3520, 92.3520, 92.3520, 

/**************
 * char 51-60 *
 **************/

92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 46.1760, 46.1760, 110.8224, 

/**************
 * char 61-70 *
 **************/

120.0576, 110.8224, 83.1168, 110.8224, 92.3520, 101.5872, 92.3520, 92.3520, 96.9696, 96.9696, 

/**************
 * char 71-80 *
 **************/

83.1168, 110.8224, 50.7936, 106.2048, 101.5872, 92.3520, 115.4400, 106.2048, 101.5872, 110.8224, 

/**************
 * char 81-90 *
 **************/

101.5872, 101.5872, 96.9696, 87.7344, 96.9696, 83.1168, 101.5872, 101.5872, 106.2048, 92.3520, 

/***************
 * char 91-100 *
 ***************/

64.6464, 120.0576, 64.6464, 110.8224, 101.5872, 0.0, 106.2048, 96.9696, 83.1168, 87.7344, 
/*64.6464, 120.0576, 64.6464, 110.8224, 101.5872, 101.5872, 106.2048, 96.9696, 83.1168, 87.7344,*/ 

/****************
 * char 101-110 *
 ****************/

83.1168, 101.5872, 92.3520, 101.5872, 55.4112, 101.5872, 92.3520, 92.3520, 106.2048, 92.3520, 

/****************
 * char 111-120 *
 ****************/

83.1168, 101.5872, 87.7344, 87.7344, 96.9696, 92.3520, 92.3520, 106.2048, 106.2048, 78.4992, 

/****************
 * char 121-126 *
 ****************/

106.2048, 83.1168, 69.2640, 36.9408, 69.2640, 110.8224, 

/*************************
 * char: 32   strokes: 0 *
 *************************/

GAMGI_IO_CHAR,

/*************************
 * char: 33 ! strokes: 3 *
 *************************/

23.0880, 99.2784, 18.4704, 90.0432, 23.0880, 34.6320, 27.7056, 90.0432, 23.0880, 99.2784, GAMGI_IO_STROKE,

23.0880, 90.0432, 23.0880, 62.3376, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 6.9264, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 34 " strokes: 2 *
 *************************/

9.2352, 99.2784, 41.5584, 2.3088, 73.8816, 99.2784, GAMGI_IO_STROKE,

18.4704, 71.5728, 64.6464, 71.5728, GAMGI_IO_CHAR,

/*************************
 * char: 35 # strokes: 4 *
 *************************/

36.9408, 99.2784, 36.9408, -30.0144, GAMGI_IO_STROKE,

64.6464, 99.2784, 64.6464, -30.0144, GAMGI_IO_STROKE,

13.8528, 48.4848, 87.7344, 48.4848, GAMGI_IO_STROKE,

13.8528, 20.7792, 87.7344, 20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 36 $ strokes: 4 *
 *************************/

69.2640, 99.2784, 69.2640, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 69.2640, 99.2784, GAMGI_IO_STROKE,

32.3232, 53.1024, 69.2640, 53.1024, GAMGI_IO_STROKE,

9.2352, 2.3088, 69.2640, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 37 % strokes: 3 *
 *************************/

96.9696, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

36.9408, 99.2784, 46.1760, 90.0432, 46.1760, 80.8080, 41.5584, 71.5728, 32.3232, 66.9552, 23.0880, 66.9552, 13.8528, 76.1904, 13.8528, 85.4256, 18.4704, 94.6608, 27.7056, 99.2784, 36.9408, 99.2784, 46.1760, 94.6608, 60.0288, 90.0432, 73.8816, 90.0432, 87.7344, 94.6608, 96.9696, 99.2784, GAMGI_IO_STROKE,

78.4992, 34.6320, 69.2640, 30.0144, 64.6464, 20.7792, 64.6464, 11.5440, 73.8816, 2.3088, 83.1168, 2.3088, 92.3520, 6.9264, 96.9696, 16.1616, 96.9696, 25.3968, 87.7344, 34.6320, 78.4992, 34.6320, GAMGI_IO_CHAR,

/*************************
 * char: 38 & strokes: 3 *
 *************************/

96.9696, 62.3376, 92.3520, 57.7200, 96.9696, 53.1024, 101.5872, 57.7200, 101.5872, 62.3376, 96.9696, 66.9552, 92.3520, 66.9552, 87.7344, 62.3376, 83.1168, 53.1024, 73.8816, 30.0144, 64.6464, 16.1616, 55.4112, 6.9264, 46.1760, 2.3088, 32.3232, 2.3088, 18.4704, 6.9264, 13.8528, 16.1616, 13.8528, 30.0144, 18.4704, 39.2496, 46.1760, 57.7200, 55.4112, 66.9552, 60.0288, 76.1904, 60.0288, 85.4256, 55.4112, 94.6608, 46.1760, 99.2784, 36.9408, 94.6608, 32.3232, 85.4256, 32.3232, 76.1904, 36.9408, 62.3376, 46.1760, 48.4848, 69.2640, 16.1616, 78.4992, 6.9264, 92.3520, 2.3088, 96.9696, 2.3088, 101.5872, 6.9264, 101.5872, 11.5440, GAMGI_IO_STROKE,

32.3232, 2.3088, 23.0880, 6.9264, 18.4704, 16.1616, 18.4704, 30.0144, 23.0880, 39.2496, 32.3232, 48.4848, GAMGI_IO_STROKE,

32.3232, 76.1904, 36.9408, 66.9552, 73.8816, 16.1616, 83.1168, 6.9264, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 39 ' strokes: 2 *
 *************************/

18.4704, 80.8080, 50.7936, 80.8080, 69.2640, 76.1904, 78.4992, 71.5728, 87.7344, 62.3376, 92.3520, 48.4848, 92.3520, 39.2496, 87.7344, 25.3968, 78.4992, 16.1616, 69.2640, 11.5440, 50.7936, 6.9264, 18.4704, 6.9264, GAMGI_IO_STROKE,

41.5584, 43.8672, 92.3520, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 40 ( strokes: 2 *
 *************************/

50.7936, 117.7488, 41.5584, 108.5136, 32.3232, 94.6608, 23.0880, 76.1904, 18.4704, 53.1024, 18.4704, 34.6320, 23.0880, 11.5440, 32.3232, -6.9264, 41.5584, -20.7792, 50.7936, -30.0144, GAMGI_IO_STROKE,

41.5584, 108.5136, 32.3232, 90.0432, 27.7056, 76.1904, 23.0880, 53.1024, 23.0880, 34.6320, 27.7056, 11.5440, 32.3232, -2.3088, 41.5584, -20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 41 ) strokes: 2 *
 *************************/

13.8528, 117.7488, 23.0880, 108.5136, 32.3232, 94.6608, 41.5584, 76.1904, 46.1760, 53.1024, 46.1760, 34.6320, 41.5584, 11.5440, 32.3232, -6.9264, 23.0880, -20.7792, 13.8528, -30.0144, GAMGI_IO_STROKE,

23.0880, 108.5136, 32.3232, 90.0432, 36.9408, 76.1904, 41.5584, 53.1024, 41.5584, 34.6320, 36.9408, 11.5440, 32.3232, -2.3088, 23.0880, -20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 42 * strokes: 3 *
 *************************/

36.9408, 99.2784, 36.9408, 43.8672, GAMGI_IO_STROKE,

13.8528, 85.4256, 60.0288, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 13.8528, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 43 + strokes: 2 *
 *************************/

60.0288, 85.4256, 60.0288, 2.3088, GAMGI_IO_STROKE,

18.4704, 43.8672, 101.5872, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 44 , strokes: 1 *
 *************************/

23.0880, 2.3088, 18.4704, 6.9264, 23.0880, 11.5440, 27.7056, 6.9264, 27.7056, -2.3088, 23.0880, -11.5440, 18.4704, -16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 45 - strokes: 1 *
 *************************/

18.4704, 43.8672, 101.5872, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 46 . strokes: 1 *
 *************************/

23.0880, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 6.9264, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 47 / strokes: 1 *
 *************************/

92.3520, 117.7488, 9.2352, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 48 0 strokes: 3 *
 *************************/

41.5584, 99.2784, 27.7056, 94.6608, 18.4704, 80.8080, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 20.7792, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 20.7792, 78.4992, 43.8672, 78.4992, 57.7200, 73.8816, 80.8080, 64.6464, 94.6608, 50.7936, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, 27.7056, 90.0432, 23.0880, 80.8080, 18.4704, 57.7200, 18.4704, 43.8672, 23.0880, 20.7792, 27.7056, 11.5440, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 11.5440, 69.2640, 20.7792, 73.8816, 43.8672, 73.8816, 57.7200, 69.2640, 80.8080, 64.6464, 90.0432, 60.0288, 94.6608, 50.7936, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 49 1 strokes: 3 *
 *************************/

27.7056, 80.8080, 36.9408, 85.4256, 50.7936, 99.2784, 50.7936, 2.3088, GAMGI_IO_STROKE,

46.1760, 94.6608, 46.1760, 2.3088, GAMGI_IO_STROKE,

27.7056, 2.3088, 69.2640, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 50 2 strokes: 4 *
 *************************/

18.4704, 80.8080, 23.0880, 76.1904, 18.4704, 71.5728, 13.8528, 76.1904, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 36.9408, 99.2784, 55.4112, 99.2784, 69.2640, 94.6608, 73.8816, 90.0432, 78.4992, 80.8080, 78.4992, 71.5728, 73.8816, 62.3376, 60.0288, 53.1024, 36.9408, 43.8672, 27.7056, 39.2496, 18.4704, 30.0144, 13.8528, 16.1616, 13.8528, 2.3088, GAMGI_IO_STROKE,

55.4112, 99.2784, 64.6464, 94.6608, 69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 71.5728, 69.2640, 62.3376, 55.4112, 53.1024, 36.9408, 43.8672, GAMGI_IO_STROKE,

13.8528, 11.5440, 18.4704, 16.1616, 27.7056, 16.1616, 50.7936, 6.9264, 64.6464, 6.9264, 73.8816, 11.5440, 78.4992, 16.1616, GAMGI_IO_STROKE,

27.7056, 16.1616, 50.7936, 2.3088, 69.2640, 2.3088, 73.8816, 6.9264, 78.4992, 16.1616, 78.4992, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 51 3 strokes: 4 *
 *************************/

18.4704, 80.8080, 23.0880, 76.1904, 18.4704, 71.5728, 13.8528, 76.1904, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 36.9408, 99.2784, 55.4112, 99.2784, 69.2640, 94.6608, 73.8816, 85.4256, 73.8816, 71.5728, 69.2640, 62.3376, 55.4112, 57.7200, 41.5584, 57.7200, GAMGI_IO_STROKE,

55.4112, 99.2784, 64.6464, 94.6608, 69.2640, 85.4256, 69.2640, 71.5728, 64.6464, 62.3376, 55.4112, 57.7200, GAMGI_IO_STROKE,

55.4112, 57.7200, 64.6464, 53.1024, 73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 20.7792, 73.8816, 11.5440, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 25.3968, 18.4704, 30.0144, 23.0880, 25.3968, 18.4704, 20.7792, GAMGI_IO_STROKE,

69.2640, 48.4848, 73.8816, 34.6320, 73.8816, 20.7792, 69.2640, 11.5440, 64.6464, 6.9264, 55.4112, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 52 4 strokes: 4 *
 *************************/

55.4112, 90.0432, 55.4112, 2.3088, GAMGI_IO_STROKE,

60.0288, 99.2784, 60.0288, 2.3088, GAMGI_IO_STROKE,

60.0288, 99.2784, 9.2352, 30.0144, 83.1168, 30.0144, GAMGI_IO_STROKE,

41.5584, 2.3088, 73.8816, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 53 5 strokes: 5 *
 *************************/

23.0880, 99.2784, 13.8528, 53.1024, GAMGI_IO_STROKE,

13.8528, 53.1024, 23.0880, 62.3376, 36.9408, 66.9552, 50.7936, 66.9552, 64.6464, 62.3376, 73.8816, 53.1024, 78.4992, 39.2496, 78.4992, 30.0144, 73.8816, 16.1616, 64.6464, 6.9264, 50.7936, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 25.3968, 18.4704, 30.0144, 23.0880, 25.3968, 18.4704, 20.7792, GAMGI_IO_STROKE,

50.7936, 66.9552, 60.0288, 62.3376, 69.2640, 53.1024, 73.8816, 39.2496, 73.8816, 30.0144, 69.2640, 16.1616, 60.0288, 6.9264, 50.7936, 2.3088, GAMGI_IO_STROKE,

23.0880, 99.2784, 69.2640, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 46.1760, 94.6608, 69.2640, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 54 6 strokes: 3 *
 *************************/

69.2640, 85.4256, 64.6464, 80.8080, 69.2640, 76.1904, 73.8816, 80.8080, 73.8816, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 57.7200, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 30.0144, 78.4992, 34.6320, 73.8816, 48.4848, 64.6464, 57.7200, 50.7936, 62.3376, 46.1760, 62.3376, 32.3232, 57.7200, 23.0880, 48.4848, 18.4704, 34.6320, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 57.7200, 18.4704, 30.0144, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, 73.8816, 30.0144, 73.8816, 34.6320, 69.2640, 48.4848, 60.0288, 57.7200, 50.7936, 62.3376, GAMGI_IO_CHAR,

/*************************
 * char: 55 7 strokes: 5 *
 *************************/

13.8528, 99.2784, 13.8528, 71.5728, GAMGI_IO_STROKE,

13.8528, 80.8080, 18.4704, 90.0432, 27.7056, 99.2784, 36.9408, 99.2784, 60.0288, 85.4256, 69.2640, 85.4256, 73.8816, 90.0432, 78.4992, 99.2784, GAMGI_IO_STROKE,

18.4704, 90.0432, 27.7056, 94.6608, 36.9408, 94.6608, 60.0288, 85.4256, GAMGI_IO_STROKE,

78.4992, 99.2784, 78.4992, 85.4256, 73.8816, 71.5728, 55.4112, 48.4848, 50.7936, 39.2496, 46.1760, 25.3968, 46.1760, 2.3088, GAMGI_IO_STROKE,

73.8816, 71.5728, 50.7936, 48.4848, 46.1760, 39.2496, 41.5584, 25.3968, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 56 8 strokes: 6 *
 *************************/

36.9408, 99.2784, 23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 71.5728, 23.0880, 62.3376, 36.9408, 57.7200, 55.4112, 57.7200, 69.2640, 62.3376, 73.8816, 71.5728, 73.8816, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, GAMGI_IO_STROKE,

36.9408, 99.2784, 27.7056, 94.6608, 23.0880, 85.4256, 23.0880, 71.5728, 27.7056, 62.3376, 36.9408, 57.7200, GAMGI_IO_STROKE,

55.4112, 57.7200, 64.6464, 62.3376, 69.2640, 71.5728, 69.2640, 85.4256, 64.6464, 94.6608, 55.4112, 99.2784, GAMGI_IO_STROKE,

36.9408, 57.7200, 23.0880, 53.1024, 18.4704, 48.4848, 13.8528, 39.2496, 13.8528, 20.7792, 18.4704, 11.5440, 23.0880, 6.9264, 36.9408, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 73.8816, 11.5440, 78.4992, 20.7792, 78.4992, 39.2496, 73.8816, 48.4848, 69.2640, 53.1024, 55.4112, 57.7200, GAMGI_IO_STROKE,

36.9408, 57.7200, 27.7056, 53.1024, 23.0880, 48.4848, 18.4704, 39.2496, 18.4704, 20.7792, 23.0880, 11.5440, 27.7056, 6.9264, 36.9408, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 64.6464, 6.9264, 69.2640, 11.5440, 73.8816, 20.7792, 73.8816, 39.2496, 69.2640, 48.4848, 64.6464, 53.1024, 55.4112, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 57 9 strokes: 3 *
 *************************/

73.8816, 66.9552, 69.2640, 53.1024, 60.0288, 43.8672, 46.1760, 39.2496, 41.5584, 39.2496, 27.7056, 43.8672, 18.4704, 53.1024, 13.8528, 66.9552, 13.8528, 71.5728, 18.4704, 85.4256, 27.7056, 94.6608, 41.5584, 99.2784, 50.7936, 99.2784, 64.6464, 94.6608, 73.8816, 85.4256, 78.4992, 71.5728, 78.4992, 43.8672, 73.8816, 25.3968, 69.2640, 16.1616, 60.0288, 6.9264, 46.1760, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, 18.4704, 16.1616, 18.4704, 20.7792, 23.0880, 25.3968, 27.7056, 20.7792, 23.0880, 16.1616, GAMGI_IO_STROKE,

41.5584, 39.2496, 32.3232, 43.8672, 23.0880, 53.1024, 18.4704, 66.9552, 18.4704, 71.5728, 23.0880, 85.4256, 32.3232, 94.6608, 41.5584, 99.2784, GAMGI_IO_STROKE,

50.7936, 99.2784, 60.0288, 94.6608, 69.2640, 85.4256, 73.8816, 71.5728, 73.8816, 43.8672, 69.2640, 25.3968, 64.6464, 16.1616, 55.4112, 6.9264, 46.1760, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 58 : strokes: 2 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 23.0880, 57.7200, 27.7056, 62.3376, 23.0880, 66.9552, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 6.9264, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 59 ; strokes: 2 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 23.0880, 57.7200, 27.7056, 62.3376, 23.0880, 66.9552, GAMGI_IO_STROKE,

23.0880, 2.3088, 18.4704, 6.9264, 23.0880, 11.5440, 27.7056, 6.9264, 27.7056, -2.3088, 23.0880, -11.5440, 18.4704, -16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 60 < strokes: 1 *
 *************************/

92.3520, 85.4256, 18.4704, 43.8672, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 61 = strokes: 2 *
 *************************/

18.4704, 57.7200, 101.5872, 57.7200, GAMGI_IO_STROKE,

18.4704, 30.0144, 101.5872, 30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 62 > strokes: 1 *
 *************************/

18.4704, 85.4256, 92.3520, 43.8672, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 63 ? strokes: 3 *
 *************************/

18.4704, 80.8080, 23.0880, 76.1904, 18.4704, 71.5728, 13.8528, 76.1904, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 32.3232, 99.2784, 46.1760, 99.2784, 60.0288, 94.6608, 64.6464, 90.0432, 69.2640, 80.8080, 69.2640, 71.5728, 64.6464, 62.3376, 60.0288, 57.7200, 41.5584, 48.4848, 41.5584, 34.6320, GAMGI_IO_STROKE,

46.1760, 99.2784, 55.4112, 94.6608, 60.0288, 90.0432, 64.6464, 80.8080, 64.6464, 71.5728, 60.0288, 62.3376, 50.7936, 53.1024, GAMGI_IO_STROKE,

41.5584, 11.5440, 36.9408, 6.9264, 41.5584, 2.3088, 46.1760, 6.9264, 41.5584, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 64 @ strokes: 4 *
 *************************/

13.8528, 39.2496, 18.4704, 48.4848, 27.7056, 53.1024, 36.9408, 53.1024, 46.1760, 48.4848, 64.6464, 34.6320, 73.8816, 30.0144, 83.1168, 30.0144, 92.3520, 34.6320, 96.9696, 48.4848, GAMGI_IO_STROKE,

13.8528, 39.2496, 18.4704, 53.1024, 27.7056, 57.7200, 36.9408, 57.7200, 46.1760, 53.1024, 64.6464, 39.2496, 73.8816, 34.6320, 83.1168, 34.6320, 92.3520, 39.2496, 96.9696, 48.4848, GAMGI_IO_STROKE,

13.8528, 20.7792, 96.9696, 20.7792, GAMGI_IO_STROKE,

13.8528, 2.3088, 96.9696, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 65 A strokes: 6 *
 *************************/

46.1760, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

46.1760, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

46.1760, 85.4256, 73.8816, 2.3088, GAMGI_IO_STROKE,

23.0880, 30.0144, 64.6464, 30.0144, GAMGI_IO_STROKE,

4.6176, 2.3088, 32.3232, 2.3088, GAMGI_IO_STROKE,

60.0288, 2.3088, 87.7344, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 66 B strokes: 6 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 64.6464, 99.2784, 78.4992, 94.6608, 83.1168, 90.0432, 87.7344, 80.8080, 87.7344, 71.5728, 83.1168, 62.3376, 78.4992, 57.7200, 64.6464, 53.1024, GAMGI_IO_STROKE,

64.6464, 99.2784, 73.8816, 94.6608, 78.4992, 90.0432, 83.1168, 80.8080, 83.1168, 71.5728, 78.4992, 62.3376, 73.8816, 57.7200, 64.6464, 53.1024, GAMGI_IO_STROKE,

27.7056, 53.1024, 64.6464, 53.1024, 78.4992, 48.4848, 83.1168, 43.8672, 87.7344, 34.6320, 87.7344, 20.7792, 83.1168, 11.5440, 78.4992, 6.9264, 64.6464, 2.3088, 9.2352, 2.3088, GAMGI_IO_STROKE,

64.6464, 53.1024, 73.8816, 48.4848, 78.4992, 43.8672, 83.1168, 34.6320, 83.1168, 20.7792, 78.4992, 11.5440, 73.8816, 6.9264, 64.6464, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 67 C strokes: 7 *
 *************************/

13.8528, 99.2784, 73.8816, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

78.4992, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

4.6176, 99.2784, 32.3232, 99.2784, GAMGI_IO_STROKE,

60.0288, 99.2784, 87.7344, 99.2784, GAMGI_IO_STROKE,

4.6176, 2.3088, 32.3232, 2.3088, GAMGI_IO_STROKE,

60.0288, 2.3088, 87.7344, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 68 D strokes: 5 *
 *************************/

46.1760, 99.2784, 9.2352, 2.3088, GAMGI_IO_STROKE,

46.1760, 99.2784, 83.1168, 2.3088, GAMGI_IO_STROKE,

46.1760, 85.4256, 78.4992, 2.3088, GAMGI_IO_STROKE,

13.8528, 6.9264, 78.4992, 6.9264, GAMGI_IO_STROKE,

9.2352, 2.3088, 83.1168, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 69 E strokes: 6 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

55.4112, 71.5728, 55.4112, 34.6320, GAMGI_IO_STROKE,

9.2352, 99.2784, 83.1168, 99.2784, 83.1168, 71.5728, 78.4992, 99.2784, GAMGI_IO_STROKE,

27.7056, 53.1024, 55.4112, 53.1024, GAMGI_IO_STROKE,

9.2352, 2.3088, 83.1168, 2.3088, 83.1168, 30.0144, 78.4992, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 70 F strokes: 7 *
 *************************/

46.1760, 99.2784, 46.1760, 2.3088, GAMGI_IO_STROKE,

50.7936, 99.2784, 50.7936, 2.3088, GAMGI_IO_STROKE,

36.9408, 76.1904, 23.0880, 71.5728, 18.4704, 66.9552, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 34.6320, 23.0880, 30.0144, 36.9408, 25.3968, 60.0288, 25.3968, 73.8816, 30.0144, 78.4992, 34.6320, 83.1168, 43.8672, 83.1168, 57.7200, 78.4992, 66.9552, 73.8816, 71.5728, 60.0288, 76.1904, 36.9408, 76.1904, GAMGI_IO_STROKE,

36.9408, 76.1904, 27.7056, 71.5728, 23.0880, 66.9552, 18.4704, 57.7200, 18.4704, 43.8672, 23.0880, 34.6320, 27.7056, 30.0144, 36.9408, 25.3968, GAMGI_IO_STROKE,

60.0288, 25.3968, 69.2640, 30.0144, 73.8816, 34.6320, 78.4992, 43.8672, 78.4992, 57.7200, 73.8816, 66.9552, 69.2640, 71.5728, 60.0288, 76.1904, GAMGI_IO_STROKE,

32.3232, 99.2784, 64.6464, 99.2784, GAMGI_IO_STROKE,

32.3232, 2.3088, 64.6464, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 71 G strokes: 4 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 78.4992, 99.2784, 78.4992, 71.5728, 73.8816, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 72 H strokes: 9 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 83.1168, 2.3088, GAMGI_IO_STROKE,

87.7344, 99.2784, 87.7344, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

69.2640, 99.2784, 101.5872, 99.2784, GAMGI_IO_STROKE,

27.7056, 53.1024, 83.1168, 53.1024, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_STROKE,

69.2640, 2.3088, 101.5872, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 73 I strokes: 4 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 74 J strokes: 3 *
 *************************/

4.6176, 48.4848, 9.2352, 57.7200, 18.4704, 66.9552, 32.3232, 66.9552, 36.9408, 62.3376, 36.9408, 53.1024, 32.3232, 30.0144, 32.3232, 16.1616, 36.9408, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

27.7056, 66.9552, 32.3232, 62.3376, 32.3232, 53.1024, 27.7056, 30.0144, 27.7056, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, 78.4992, 30.0144, 83.1168, 43.8672, 87.7344, 66.9552, 87.7344, 85.4256, 83.1168, 94.6608, 73.8816, 99.2784, 64.6464, 99.2784, 55.4112, 90.0432, 55.4112, 80.8080, 60.0288, 66.9552, 69.2640, 53.1024, 78.4992, 43.8672, 92.3520, 34.6320, GAMGI_IO_STROKE,

60.0288, 6.9264, 69.2640, 20.7792, 73.8816, 30.0144, 78.4992, 43.8672, 83.1168, 66.9552, 83.1168, 85.4256, 78.4992, 94.6608, 73.8816, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 75 K strokes: 9 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

87.7344, 99.2784, 27.7056, 39.2496, GAMGI_IO_STROKE,

50.7936, 57.7200, 87.7344, 2.3088, GAMGI_IO_STROKE,

46.1760, 57.7200, 83.1168, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

69.2640, 99.2784, 96.9696, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_STROKE,

69.2640, 2.3088, 96.9696, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 76 L strokes: 5 *
 *************************/

46.1760, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

46.1760, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

46.1760, 85.4256, 73.8816, 2.3088, GAMGI_IO_STROKE,

4.6176, 2.3088, 32.3232, 2.3088, GAMGI_IO_STROKE,

60.0288, 2.3088, 87.7344, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 77 M strokes: 10 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 55.4112, 16.1616, GAMGI_IO_STROKE,

23.0880, 99.2784, 55.4112, 2.3088, GAMGI_IO_STROKE,

87.7344, 99.2784, 55.4112, 2.3088, GAMGI_IO_STROKE,

87.7344, 99.2784, 87.7344, 2.3088, GAMGI_IO_STROKE,

92.3520, 99.2784, 92.3520, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 27.7056, 99.2784, GAMGI_IO_STROKE,

87.7344, 99.2784, 106.2048, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 36.9408, 2.3088, GAMGI_IO_STROKE,

73.8816, 2.3088, 106.2048, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 78 N strokes: 7 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 83.1168, 11.5440, GAMGI_IO_STROKE,

27.7056, 90.0432, 83.1168, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 83.1168, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 27.7056, 99.2784, GAMGI_IO_STROKE,

69.2640, 99.2784, 96.9696, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 36.9408, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 79 O strokes: 3 *
 *************************/

46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, 87.7344, 43.8672, 87.7344, 57.7200, 83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 46.1760, 99.2784, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 57.7200, 18.4704, 43.8672, 23.0880, 25.3968, 27.7056, 16.1616, 36.9408, 6.9264, 46.1760, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 25.3968, 83.1168, 43.8672, 83.1168, 57.7200, 78.4992, 76.1904, 73.8816, 85.4256, 64.6464, 94.6608, 55.4112, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 80 P strokes: 7 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 83.1168, 2.3088, GAMGI_IO_STROKE,

87.7344, 99.2784, 87.7344, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 101.5872, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_STROKE,

69.2640, 2.3088, 101.5872, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 81 Q strokes: 7 *
 *************************/

46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, 87.7344, 43.8672, 87.7344, 57.7200, 83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 46.1760, 99.2784, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 57.7200, 18.4704, 43.8672, 23.0880, 25.3968, 27.7056, 16.1616, 36.9408, 6.9264, 46.1760, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 25.3968, 83.1168, 43.8672, 83.1168, 57.7200, 78.4992, 76.1904, 73.8816, 85.4256, 64.6464, 94.6608, 55.4112, 99.2784, GAMGI_IO_STROKE,

36.9408, 66.9552, 36.9408, 34.6320, GAMGI_IO_STROKE,

64.6464, 66.9552, 64.6464, 34.6320, GAMGI_IO_STROKE,

36.9408, 53.1024, 64.6464, 53.1024, GAMGI_IO_STROKE,

36.9408, 48.4848, 64.6464, 48.4848, GAMGI_IO_CHAR,

/*************************
 * char: 82 R strokes: 5 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 27.7056, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 64.6464, 99.2784, 78.4992, 94.6608, 83.1168, 90.0432, 87.7344, 80.8080, 87.7344, 66.9552, 83.1168, 57.7200, 78.4992, 53.1024, 64.6464, 48.4848, 27.7056, 48.4848, GAMGI_IO_STROKE,

64.6464, 99.2784, 73.8816, 94.6608, 78.4992, 90.0432, 83.1168, 80.8080, 83.1168, 66.9552, 78.4992, 57.7200, 73.8816, 53.1024, 64.6464, 48.4848, GAMGI_IO_STROKE,

9.2352, 2.3088, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 83 S strokes: 5 *
 *************************/

13.8528, 99.2784, 46.1760, 53.1024, 9.2352, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 41.5584, 53.1024, GAMGI_IO_STROKE,

9.2352, 99.2784, 78.4992, 99.2784, 83.1168, 71.5728, 73.8816, 99.2784, GAMGI_IO_STROKE,

13.8528, 6.9264, 73.8816, 6.9264, GAMGI_IO_STROKE,

9.2352, 2.3088, 78.4992, 2.3088, 83.1168, 30.0144, 73.8816, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 84 T strokes: 4 *
 *************************/

41.5584, 99.2784, 41.5584, 2.3088, GAMGI_IO_STROKE,

46.1760, 99.2784, 46.1760, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 9.2352, 71.5728, 9.2352, 99.2784, 78.4992, 99.2784, 78.4992, 71.5728, 73.8816, 99.2784, GAMGI_IO_STROKE,

27.7056, 2.3088, 60.0288, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 85 U strokes: 6 *
 *************************/

13.8528, 99.2784, 46.1760, 48.4848, 46.1760, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 50.7936, 48.4848, 50.7936, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 50.7936, 48.4848, GAMGI_IO_STROKE,

4.6176, 99.2784, 32.3232, 99.2784, GAMGI_IO_STROKE,

64.6464, 99.2784, 92.3520, 99.2784, GAMGI_IO_STROKE,

32.3232, 2.3088, 64.6464, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 86 V strokes: 2 *
 *************************/

50.7936, 66.9552, 60.0288, 62.3376, 69.2640, 53.1024, 69.2640, 57.7200, 64.6464, 62.3376, 50.7936, 66.9552, 36.9408, 66.9552, 23.0880, 62.3376, 18.4704, 57.7200, 13.8528, 48.4848, 13.8528, 39.2496, 18.4704, 30.0144, 27.7056, 20.7792, 46.1760, 6.9264, GAMGI_IO_STROKE,

36.9408, 66.9552, 27.7056, 62.3376, 23.0880, 57.7200, 18.4704, 48.4848, 18.4704, 39.2496, 23.0880, 30.0144, 46.1760, 6.9264, 50.7936, -2.3088, 50.7936, -11.5440, 46.1760, -16.1616, 36.9408, -16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 87 W strokes: 5 *
 *************************/

13.8528, 16.1616, 18.4704, 2.3088, 36.9408, 2.3088, 27.7056, 20.7792, 18.4704, 39.2496, 13.8528, 53.1024, 13.8528, 71.5728, 18.4704, 85.4256, 27.7056, 94.6608, 41.5584, 99.2784, 60.0288, 99.2784, 73.8816, 94.6608, 83.1168, 85.4256, 87.7344, 71.5728, 87.7344, 53.1024, 83.1168, 39.2496, 73.8816, 20.7792, 64.6464, 2.3088, 83.1168, 2.3088, 87.7344, 16.1616, GAMGI_IO_STROKE,

27.7056, 20.7792, 23.0880, 34.6320, 18.4704, 53.1024, 18.4704, 71.5728, 23.0880, 85.4256, 32.3232, 94.6608, 41.5584, 99.2784, GAMGI_IO_STROKE,

60.0288, 99.2784, 69.2640, 94.6608, 78.4992, 85.4256, 83.1168, 71.5728, 83.1168, 53.1024, 78.4992, 34.6320, 73.8816, 20.7792, GAMGI_IO_STROKE,

18.4704, 6.9264, 32.3232, 6.9264, GAMGI_IO_STROKE,

69.2640, 6.9264, 83.1168, 6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 88 X strokes: 12 *
 *************************/

18.4704, 103.8960, 13.8528, 80.8080, GAMGI_IO_STROKE,

87.7344, 103.8960, 83.1168, 80.8080, GAMGI_IO_STROKE,

36.9408, 62.3376, 32.3232, 39.2496, GAMGI_IO_STROKE,

69.2640, 62.3376, 64.6464, 39.2496, GAMGI_IO_STROKE,

18.4704, 20.7792, 13.8528, -2.3088, GAMGI_IO_STROKE,

87.7344, 20.7792, 83.1168, -2.3088, GAMGI_IO_STROKE,

18.4704, 94.6608, 83.1168, 94.6608, GAMGI_IO_STROKE,

18.4704, 90.0432, 83.1168, 90.0432, GAMGI_IO_STROKE,

36.9408, 53.1024, 64.6464, 53.1024, GAMGI_IO_STROKE,

36.9408, 48.4848, 64.6464, 48.4848, GAMGI_IO_STROKE,

18.4704, 11.5440, 83.1168, 11.5440, GAMGI_IO_STROKE,

18.4704, 6.9264, 83.1168, 6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 89 Y strokes: 7 *
 *************************/

50.7936, 99.2784, 50.7936, 2.3088, GAMGI_IO_STROKE,

55.4112, 99.2784, 55.4112, 2.3088, GAMGI_IO_STROKE,

9.2352, 66.9552, 13.8528, 71.5728, 23.0880, 66.9552, 27.7056, 48.4848, 32.3232, 39.2496, 36.9408, 34.6320, 46.1760, 30.0144, GAMGI_IO_STROKE,

13.8528, 71.5728, 18.4704, 66.9552, 23.0880, 48.4848, 27.7056, 39.2496, 32.3232, 34.6320, 46.1760, 30.0144, 60.0288, 30.0144, 73.8816, 34.6320, 78.4992, 39.2496, 83.1168, 48.4848, 87.7344, 66.9552, 92.3520, 71.5728, GAMGI_IO_STROKE,

60.0288, 30.0144, 69.2640, 34.6320, 73.8816, 39.2496, 78.4992, 48.4848, 83.1168, 66.9552, 92.3520, 71.5728, 96.9696, 66.9552, GAMGI_IO_STROKE,

36.9408, 99.2784, 69.2640, 99.2784, GAMGI_IO_STROKE,

36.9408, 2.3088, 69.2640, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 90 Z strokes: 4 *
 *************************/

73.8816, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

78.4992, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 13.8528, 71.5728, 13.8528, 99.2784, 78.4992, 99.2784, GAMGI_IO_STROKE,

13.8528, 2.3088, 78.4992, 2.3088, 78.4992, 30.0144, 73.8816, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 91 [ strokes: 4 *
 *************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_STROKE,

23.0880, 117.7488, 23.0880, -30.0144, GAMGI_IO_STROKE,

18.4704, 117.7488, 50.7936, 117.7488, GAMGI_IO_STROKE,

18.4704, -30.0144, 50.7936, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 92 \ strokes: 3 *
 *************************/

60.0288, 85.4256, 55.4112, 80.8080, 60.0288, 76.1904, 64.6464, 80.8080, 60.0288, 85.4256, GAMGI_IO_STROKE,

18.4704, 11.5440, 13.8528, 6.9264, 18.4704, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, GAMGI_IO_STROKE,

101.5872, 11.5440, 96.9696, 6.9264, 101.5872, 2.3088, 106.2048, 6.9264, 101.5872, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 93 ] strokes: 4 *
 *************************/

41.5584, 117.7488, 41.5584, -30.0144, GAMGI_IO_STROKE,

46.1760, 117.7488, 46.1760, -30.0144, GAMGI_IO_STROKE,

13.8528, 117.7488, 46.1760, 117.7488, GAMGI_IO_STROKE,

13.8528, -30.0144, 46.1760, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 94 ^ strokes: 2 *
 *************************/

55.4112, 117.7488, 55.4112, 2.3088, GAMGI_IO_STROKE,

13.8528, 2.3088, 96.9696, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 95 _ strokes: 1 *
 *************************/

9.2352, -6.9264, 92.3520, -6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 96 ` strokes: 1 *
 *************************/

18.4704, 117.7488, 92.3520, 117.7488, GAMGI_IO_CHAR,
/*152.3808, 154.6896, 263.2032, 154.6896, GAMGI_IO_CHAR,*/

/*************************
 * char: 97 a strokes: 4 *
 *************************/

46.1760, 66.9552, 32.3232, 62.3376, 23.0880, 53.1024, 18.4704, 43.8672, 13.8528, 30.0144, 13.8528, 16.1616, 18.4704, 6.9264, 32.3232, 2.3088, 41.5584, 2.3088, 50.7936, 6.9264, 64.6464, 20.7792, 73.8816, 34.6320, 83.1168, 53.1024, 87.7344, 66.9552, GAMGI_IO_STROKE,

46.1760, 66.9552, 36.9408, 62.3376, 27.7056, 53.1024, 23.0880, 43.8672, 18.4704, 30.0144, 18.4704, 16.1616, 23.0880, 6.9264, 32.3232, 2.3088, GAMGI_IO_STROKE,

46.1760, 66.9552, 55.4112, 66.9552, 64.6464, 62.3376, 69.2640, 53.1024, 78.4992, 16.1616, 83.1168, 6.9264, 87.7344, 2.3088, GAMGI_IO_STROKE,

55.4112, 66.9552, 60.0288, 62.3376, 64.6464, 53.1024, 73.8816, 16.1616, 78.4992, 6.9264, 87.7344, 2.3088, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 98 b strokes: 6 *
 *************************/

60.0288, 99.2784, 46.1760, 94.6608, 36.9408, 85.4256, 27.7056, 66.9552, 23.0880, 53.1024, 18.4704, 34.6320, 13.8528, 6.9264, 9.2352, -30.0144, GAMGI_IO_STROKE,

60.0288, 99.2784, 50.7936, 94.6608, 41.5584, 85.4256, 32.3232, 66.9552, 27.7056, 53.1024, 23.0880, 34.6320, 18.4704, 6.9264, 13.8528, -30.0144, GAMGI_IO_STROKE,

60.0288, 99.2784, 69.2640, 99.2784, 78.4992, 94.6608, 83.1168, 90.0432, 83.1168, 76.1904, 78.4992, 66.9552, 73.8816, 62.3376, 60.0288, 57.7200, 41.5584, 57.7200, GAMGI_IO_STROKE,

69.2640, 99.2784, 78.4992, 90.0432, 78.4992, 76.1904, 73.8816, 66.9552, 69.2640, 62.3376, 60.0288, 57.7200, GAMGI_IO_STROKE,

41.5584, 57.7200, 60.0288, 53.1024, 69.2640, 43.8672, 73.8816, 34.6320, 73.8816, 20.7792, 69.2640, 11.5440, 64.6464, 6.9264, 50.7936, 2.3088, 41.5584, 2.3088, 32.3232, 6.9264, 27.7056, 11.5440, 23.0880, 25.3968, GAMGI_IO_STROKE,

41.5584, 57.7200, 55.4112, 53.1024, 64.6464, 43.8672, 69.2640, 34.6320, 69.2640, 20.7792, 64.6464, 11.5440, 60.0288, 6.9264, 50.7936, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 99 c strokes: 3 *
 *************************/

9.2352, 66.9552, 18.4704, 66.9552, 27.7056, 62.3376, 32.3232, 53.1024, 55.4112, -16.1616, 60.0288, -25.3968, 64.6464, -30.0144, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 62.3376, 27.7056, 53.1024, 50.7936, -16.1616, 55.4112, -25.3968, 64.6464, -30.0144, 73.8816, -30.0144, GAMGI_IO_STROKE,

78.4992, 66.9552, 73.8816, 57.7200, 64.6464, 43.8672, 18.4704, -6.9264, 9.2352, -20.7792, 4.6176, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 100 d strokes: 3 *
 **************************/

60.0288, 62.3376, 50.7936, 66.9552, 41.5584, 66.9552, 27.7056, 62.3376, 18.4704, 48.4848, 13.8528, 34.6320, 13.8528, 20.7792, 18.4704, 11.5440, 23.0880, 6.9264, 32.3232, 2.3088, 41.5584, 2.3088, 55.4112, 6.9264, 64.6464, 20.7792, 69.2640, 34.6320, 69.2640, 48.4848, 64.6464, 57.7200, 46.1760, 80.8080, 41.5584, 90.0432, 41.5584, 99.2784, 46.1760, 103.8960, 55.4112, 103.8960, 64.6464, 99.2784, 73.8816, 90.0432, GAMGI_IO_STROKE,

41.5584, 66.9552, 32.3232, 62.3376, 23.0880, 48.4848, 18.4704, 34.6320, 18.4704, 16.1616, 23.0880, 6.9264, GAMGI_IO_STROKE,

41.5584, 2.3088, 50.7936, 6.9264, 60.0288, 20.7792, 64.6464, 34.6320, 64.6464, 53.1024, 60.0288, 62.3376, 50.7936, 76.1904, 46.1760, 85.4256, 46.1760, 94.6608, 50.7936, 99.2784, 60.0288, 99.2784, 73.8816, 90.0432, GAMGI_IO_CHAR,

/**************************
 * char: 101 e strokes: 4 *
 **************************/

69.2640, 53.1024, 60.0288, 62.3376, 50.7936, 66.9552, 32.3232, 66.9552, 23.0880, 62.3376, 23.0880, 53.1024, 32.3232, 43.8672, 46.1760, 39.2496, GAMGI_IO_STROKE,

32.3232, 66.9552, 27.7056, 62.3376, 27.7056, 53.1024, 36.9408, 43.8672, 46.1760, 39.2496, GAMGI_IO_STROKE,

46.1760, 39.2496, 23.0880, 34.6320, 13.8528, 25.3968, 13.8528, 16.1616, 18.4704, 6.9264, 32.3232, 2.3088, 46.1760, 2.3088, 55.4112, 6.9264, 64.6464, 16.1616, GAMGI_IO_STROKE,

46.1760, 39.2496, 27.7056, 34.6320, 18.4704, 25.3968, 18.4704, 16.1616, 23.0880, 6.9264, 32.3232, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 102 f strokes: 5 *
 **************************/

64.6464, 99.2784, 36.9408, -30.0144, GAMGI_IO_STROKE,

69.2640, 99.2784, 32.3232, -30.0144, GAMGI_IO_STROKE,

46.1760, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 25.3968, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 55.4112, 2.3088, 73.8816, 6.9264, 83.1168, 16.1616, 87.7344, 30.0144, 87.7344, 43.8672, 83.1168, 53.1024, 73.8816, 62.3376, 60.0288, 66.9552, 46.1760, 66.9552, GAMGI_IO_STROKE,

46.1760, 66.9552, 32.3232, 62.3376, 23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 30.0144, 83.1168, 43.8672, 78.4992, 53.1024, 69.2640, 62.3376, 60.0288, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 103 g strokes: 4 *
 **************************/

4.6176, 53.1024, 13.8528, 62.3376, 23.0880, 66.9552, 32.3232, 66.9552, 41.5584, 62.3376, 46.1760, 57.7200, 50.7936, 43.8672, 50.7936, 25.3968, 46.1760, 6.9264, 32.3232, -30.0144, GAMGI_IO_STROKE,

9.2352, 57.7200, 18.4704, 62.3376, 36.9408, 62.3376, 46.1760, 57.7200, GAMGI_IO_STROKE,

83.1168, 66.9552, 78.4992, 53.1024, 73.8816, 43.8672, 50.7936, 11.5440, 36.9408, -11.5440, 27.7056, -30.0144, GAMGI_IO_STROKE,

78.4992, 66.9552, 73.8816, 53.1024, 69.2640, 43.8672, 50.7936, 11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 104 h strokes: 4 *
 **************************/

4.6176, 48.4848, 9.2352, 57.7200, 18.4704, 66.9552, 32.3232, 66.9552, 36.9408, 62.3376, 36.9408, 53.1024, 32.3232, 34.6320, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 66.9552, 32.3232, 62.3376, 32.3232, 53.1024, 27.7056, 34.6320, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 34.6320, 41.5584, 53.1024, 50.7936, 62.3376, 60.0288, 66.9552, 69.2640, 66.9552, 78.4992, 62.3376, 83.1168, 57.7200, 83.1168, 43.8672, 78.4992, 20.7792, 64.6464, -30.0144, GAMGI_IO_STROKE,

69.2640, 66.9552, 78.4992, 57.7200, 78.4992, 43.8672, 73.8816, 20.7792, 60.0288, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 105 i strokes: 2 *
 **************************/

27.7056, 66.9552, 18.4704, 34.6320, 13.8528, 16.1616, 13.8528, 6.9264, 18.4704, 2.3088, 32.3232, 2.3088, 41.5584, 11.5440, 46.1760, 20.7792, GAMGI_IO_STROKE,

32.3232, 66.9552, 23.0880, 34.6320, 18.4704, 16.1616, 18.4704, 6.9264, 23.0880, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 106 j strokes: 3 *
 **************************/

36.9408, 62.3376, 27.7056, 57.7200, 18.4704, 48.4848, 13.8528, 34.6320, 13.8528, 20.7792, 18.4704, 11.5440, 23.0880, 6.9264, 32.3232, 2.3088, 46.1760, 2.3088, 60.0288, 6.9264, 73.8816, 16.1616, 83.1168, 30.0144, 87.7344, 43.8672, 87.7344, 57.7200, 78.4992, 66.9552, 69.2640, 66.9552, 60.0288, 57.7200, 50.7936, 39.2496, 41.5584, 16.1616, 27.7056, -30.0144, GAMGI_IO_STROKE,

13.8528, 20.7792, 23.0880, 11.5440, 32.3232, 6.9264, 46.1760, 6.9264, 60.0288, 11.5440, 73.8816, 20.7792, 83.1168, 30.0144, GAMGI_IO_STROKE,

87.7344, 57.7200, 78.4992, 62.3376, 69.2640, 62.3376, 60.0288, 53.1024, 50.7936, 39.2496, 41.5584, 11.5440, 32.3232, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 107 k strokes: 5 *
 **************************/

27.7056, 66.9552, 9.2352, 2.3088, GAMGI_IO_STROKE,

32.3232, 66.9552, 13.8528, 2.3088, GAMGI_IO_STROKE,

73.8816, 66.9552, 78.4992, 62.3376, 83.1168, 62.3376, 78.4992, 66.9552, 69.2640, 66.9552, 60.0288, 62.3376, 41.5584, 43.8672, 32.3232, 39.2496, 23.0880, 39.2496, GAMGI_IO_STROKE,

32.3232, 39.2496, 41.5584, 34.6320, 50.7936, 6.9264, 55.4112, 2.3088, GAMGI_IO_STROKE,

32.3232, 39.2496, 36.9408, 34.6320, 46.1760, 6.9264, 50.7936, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 78.4992, 20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 108 l strokes: 4 *
 **************************/

13.8528, 99.2784, 23.0880, 99.2784, 32.3232, 94.6608, 36.9408, 90.0432, 41.5584, 80.8080, 69.2640, 16.1616, 73.8816, 6.9264, 78.4992, 2.3088, GAMGI_IO_STROKE,

23.0880, 99.2784, 32.3232, 90.0432, 36.9408, 80.8080, 64.6464, 16.1616, 69.2640, 6.9264, 78.4992, 2.3088, 83.1168, 2.3088, GAMGI_IO_STROKE,

46.1760, 66.9552, 9.2352, 2.3088, GAMGI_IO_STROKE,

46.1760, 66.9552, 13.8528, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 109 m strokes: 5 *
 **************************/

32.3232, 66.9552, 4.6176, -30.0144, GAMGI_IO_STROKE,

36.9408, 66.9552, 9.2352, -30.0144, GAMGI_IO_STROKE,

32.3232, 53.1024, 27.7056, 25.3968, 27.7056, 11.5440, 36.9408, 2.3088, 46.1760, 2.3088, 55.4112, 6.9264, 64.6464, 16.1616, 73.8816, 30.0144, GAMGI_IO_STROKE,

83.1168, 66.9552, 69.2640, 16.1616, 69.2640, 6.9264, 73.8816, 2.3088, 87.7344, 2.3088, 96.9696, 11.5440, 101.5872, 20.7792, GAMGI_IO_STROKE,

87.7344, 66.9552, 73.8816, 16.1616, 73.8816, 6.9264, 78.4992, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 110 n strokes: 5 *
 **************************/

27.7056, 66.9552, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 66.9552, 27.7056, 39.2496, 23.0880, 16.1616, 18.4704, 2.3088, GAMGI_IO_STROKE,

78.4992, 66.9552, 73.8816, 48.4848, 64.6464, 30.0144, GAMGI_IO_STROKE,

83.1168, 66.9552, 78.4992, 53.1024, 73.8816, 43.8672, 64.6464, 30.0144, 55.4112, 20.7792, 41.5584, 11.5440, 32.3232, 6.9264, 18.4704, 2.3088, GAMGI_IO_STROKE,

13.8528, 66.9552, 32.3232, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 111 o strokes: 3 *
 **************************/

41.5584, 66.9552, 27.7056, 62.3376, 18.4704, 48.4848, 13.8528, 34.6320, 13.8528, 20.7792, 18.4704, 11.5440, 23.0880, 6.9264, 32.3232, 2.3088, 41.5584, 2.3088, 55.4112, 6.9264, 64.6464, 20.7792, 69.2640, 34.6320, 69.2640, 48.4848, 64.6464, 57.7200, 60.0288, 62.3376, 50.7936, 66.9552, 41.5584, 66.9552, GAMGI_IO_STROKE,

41.5584, 66.9552, 32.3232, 62.3376, 23.0880, 48.4848, 18.4704, 34.6320, 18.4704, 16.1616, 23.0880, 6.9264, GAMGI_IO_STROKE,

41.5584, 2.3088, 50.7936, 6.9264, 60.0288, 20.7792, 64.6464, 34.6320, 64.6464, 53.1024, 60.0288, 62.3376, GAMGI_IO_CHAR,

/**************************
 * char: 112 p strokes: 6 *
 **************************/

41.5584, 62.3376, 23.0880, 2.3088, GAMGI_IO_STROKE,

41.5584, 62.3376, 27.7056, 2.3088, GAMGI_IO_STROKE,

69.2640, 62.3376, 69.2640, 2.3088, GAMGI_IO_STROKE,

69.2640, 62.3376, 73.8816, 2.3088, GAMGI_IO_STROKE,

9.2352, 53.1024, 18.4704, 62.3376, 32.3232, 66.9552, 92.3520, 66.9552, GAMGI_IO_STROKE,

9.2352, 53.1024, 18.4704, 57.7200, 32.3232, 62.3376, 92.3520, 62.3376, GAMGI_IO_CHAR,

/**************************
 * char: 113 q strokes: 4 *
 **************************/

50.7936, 99.2784, 36.9408, 94.6608, 27.7056, 80.8080, 23.0880, 71.5728, 18.4704, 57.7200, 13.8528, 34.6320, 13.8528, 16.1616, 18.4704, 6.9264, 27.7056, 2.3088, 36.9408, 2.3088, 50.7936, 6.9264, 60.0288, 20.7792, 64.6464, 30.0144, 69.2640, 43.8672, 73.8816, 66.9552, 73.8816, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 50.7936, 99.2784, GAMGI_IO_STROKE,

50.7936, 99.2784, 41.5584, 94.6608, 32.3232, 80.8080, 27.7056, 71.5728, 23.0880, 57.7200, 18.4704, 34.6320, 18.4704, 16.1616, 23.0880, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

36.9408, 2.3088, 46.1760, 6.9264, 55.4112, 20.7792, 60.0288, 30.0144, 64.6464, 43.8672, 69.2640, 66.9552, 69.2640, 85.4256, 64.6464, 94.6608, 60.0288, 99.2784, GAMGI_IO_STROKE,

23.0880, 53.1024, 64.6464, 53.1024, GAMGI_IO_CHAR,

/**************************
 * char: 114 r strokes: 3 *
 **************************/

18.4704, 25.3968, 23.0880, 11.5440, 27.7056, 6.9264, 36.9408, 2.3088, 46.1760, 2.3088, 60.0288, 6.9264, 69.2640, 20.7792, 73.8816, 34.6320, 73.8816, 48.4848, 69.2640, 57.7200, 64.6464, 62.3376, 55.4112, 66.9552, 46.1760, 66.9552, 32.3232, 62.3376, 23.0880, 48.4848, 18.4704, 34.6320, 0.0000, -30.0144, GAMGI_IO_STROKE,

46.1760, 2.3088, 55.4112, 6.9264, 64.6464, 20.7792, 69.2640, 34.6320, 69.2640, 53.1024, 64.6464, 62.3376, GAMGI_IO_STROKE,

46.1760, 66.9552, 36.9408, 62.3376, 27.7056, 48.4848, 23.0880, 34.6320, 4.6176, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 115 s strokes: 4 *
 **************************/

87.7344, 66.9552, 41.5584, 66.9552, 27.7056, 62.3376, 18.4704, 48.4848, 13.8528, 34.6320, 13.8528, 20.7792, 18.4704, 11.5440, 23.0880, 6.9264, 32.3232, 2.3088, 41.5584, 2.3088, 55.4112, 6.9264, 64.6464, 20.7792, 69.2640, 34.6320, 69.2640, 48.4848, 64.6464, 57.7200, 60.0288, 62.3376, 50.7936, 66.9552, GAMGI_IO_STROKE,

41.5584, 66.9552, 32.3232, 62.3376, 23.0880, 48.4848, 18.4704, 34.6320, 18.4704, 16.1616, 23.0880, 6.9264, GAMGI_IO_STROKE,

41.5584, 2.3088, 50.7936, 6.9264, 60.0288, 20.7792, 64.6464, 34.6320, 64.6464, 53.1024, 60.0288, 62.3376, GAMGI_IO_STROKE,

60.0288, 62.3376, 87.7344, 62.3376, GAMGI_IO_CHAR,

/**************************
 * char: 116 t strokes: 4 *
 **************************/

50.7936, 62.3376, 36.9408, 2.3088, GAMGI_IO_STROKE,

50.7936, 62.3376, 41.5584, 2.3088, GAMGI_IO_STROKE,

9.2352, 53.1024, 18.4704, 62.3376, 32.3232, 66.9552, 83.1168, 66.9552, GAMGI_IO_STROKE,

9.2352, 53.1024, 18.4704, 57.7200, 32.3232, 62.3376, 83.1168, 62.3376, GAMGI_IO_CHAR,

/**************************
 * char: 117 u strokes: 3 *
 **************************/

4.6176, 48.4848, 9.2352, 57.7200, 18.4704, 66.9552, 32.3232, 66.9552, 36.9408, 62.3376, 36.9408, 53.1024, 27.7056, 25.3968, 27.7056, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

27.7056, 66.9552, 32.3232, 62.3376, 32.3232, 53.1024, 23.0880, 25.3968, 23.0880, 11.5440, 27.7056, 6.9264, 36.9408, 2.3088, 41.5584, 2.3088, 55.4112, 6.9264, 64.6464, 16.1616, 73.8816, 30.0144, 78.4992, 43.8672, 78.4992, 57.7200, 73.8816, 66.9552, 69.2640, 62.3376, 73.8816, 57.7200, 78.4992, 43.8672, GAMGI_IO_STROKE,

73.8816, 30.0144, 78.4992, 57.7200, GAMGI_IO_CHAR,

/**************************
 * char: 118 v strokes: 6 *
 **************************/

18.4704, 48.4848, 27.7056, 57.7200, 41.5584, 62.3376, 36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 48.4848, 13.8528, 34.6320, 13.8528, 20.7792, 18.4704, 6.9264, 23.0880, 2.3088, 32.3232, 2.3088, 41.5584, 6.9264, 50.7936, 20.7792, 55.4112, 34.6320, GAMGI_IO_STROKE,

13.8528, 20.7792, 18.4704, 11.5440, 23.0880, 6.9264, 32.3232, 6.9264, 41.5584, 11.5440, 50.7936, 20.7792, GAMGI_IO_STROKE,

50.7936, 34.6320, 50.7936, 20.7792, 55.4112, 6.9264, 60.0288, 2.3088, 69.2640, 2.3088, 78.4992, 6.9264, 87.7344, 20.7792, 92.3520, 34.6320, 92.3520, 48.4848, 87.7344, 62.3376, 83.1168, 66.9552, 78.4992, 62.3376, 87.7344, 57.7200, 92.3520, 48.4848, GAMGI_IO_STROKE,

50.7936, 20.7792, 55.4112, 11.5440, 60.0288, 6.9264, 69.2640, 6.9264, 78.4992, 11.5440, 87.7344, 20.7792, GAMGI_IO_STROKE,

13.8528, 53.1024, 23.0880, 62.3376, 36.9408, 66.9552, 96.9696, 66.9552, GAMGI_IO_STROKE,

13.8528, 53.1024, 23.0880, 57.7200, 36.9408, 62.3376, 96.9696, 62.3376, GAMGI_IO_CHAR,

/**************************
 * char: 119 w strokes: 4 *
 **************************/

18.4704, 48.4848, 27.7056, 57.7200, 41.5584, 62.3376, 36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 48.4848, 13.8528, 34.6320, 13.8528, 20.7792, 18.4704, 6.9264, 23.0880, 2.3088, 32.3232, 2.3088, 41.5584, 6.9264, 50.7936, 20.7792, 55.4112, 34.6320, GAMGI_IO_STROKE,

13.8528, 20.7792, 18.4704, 11.5440, 23.0880, 6.9264, 32.3232, 6.9264, 41.5584, 11.5440, 50.7936, 20.7792, GAMGI_IO_STROKE,

50.7936, 34.6320, 50.7936, 20.7792, 55.4112, 6.9264, 60.0288, 2.3088, 69.2640, 2.3088, 78.4992, 6.9264, 87.7344, 20.7792, 92.3520, 34.6320, 92.3520, 48.4848, 87.7344, 62.3376, 83.1168, 66.9552, 78.4992, 62.3376, 87.7344, 57.7200, 92.3520, 48.4848, GAMGI_IO_STROKE,

50.7936, 20.7792, 55.4112, 11.5440, 60.0288, 6.9264, 69.2640, 6.9264, 78.4992, 11.5440, 87.7344, 20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 120 x strokes: 5 *
 **************************/

50.7936, 99.2784, 41.5584, 94.6608, 36.9408, 90.0432, 36.9408, 85.4256, 41.5584, 80.8080, 55.4112, 76.1904, 69.2640, 76.1904, GAMGI_IO_STROKE,

55.4112, 76.1904, 36.9408, 71.5728, 27.7056, 66.9552, 23.0880, 57.7200, 23.0880, 48.4848, 32.3232, 39.2496, 46.1760, 34.6320, 60.0288, 34.6320, GAMGI_IO_STROKE,

55.4112, 76.1904, 41.5584, 71.5728, 32.3232, 66.9552, 27.7056, 57.7200, 27.7056, 48.4848, 36.9408, 39.2496, 46.1760, 34.6320, GAMGI_IO_STROKE,

46.1760, 34.6320, 27.7056, 30.0144, 18.4704, 25.3968, 13.8528, 16.1616, 13.8528, 6.9264, 23.0880, -2.3088, 46.1760, -11.5440, 50.7936, -16.1616, 50.7936, -25.3968, 41.5584, -30.0144, 32.3232, -30.0144, GAMGI_IO_STROKE,

46.1760, 34.6320, 32.3232, 30.0144, 23.0880, 25.3968, 18.4704, 16.1616, 18.4704, 6.9264, 27.7056, -2.3088, 46.1760, -11.5440, GAMGI_IO_CHAR,

/**************************
 * char: 121 y strokes: 4 *
 **************************/

69.2640, 99.2784, 41.5584, -30.0144, GAMGI_IO_STROKE,

73.8816, 99.2784, 36.9408, -30.0144, GAMGI_IO_STROKE,

4.6176, 48.4848, 9.2352, 57.7200, 18.4704, 66.9552, 32.3232, 66.9552, 36.9408, 62.3376, 36.9408, 53.1024, 32.3232, 30.0144, 32.3232, 16.1616, 41.5584, 6.9264, 55.4112, 6.9264, 64.6464, 11.5440, 78.4992, 25.3968, 87.7344, 39.2496, GAMGI_IO_STROKE,

27.7056, 66.9552, 32.3232, 62.3376, 32.3232, 53.1024, 27.7056, 30.0144, 27.7056, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, 55.4112, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 83.1168, 30.0144, 87.7344, 39.2496, 96.9696, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 122 z strokes: 2 *
 **************************/

50.7936, 99.2784, 41.5584, 94.6608, 36.9408, 90.0432, 36.9408, 85.4256, 41.5584, 80.8080, 55.4112, 76.1904, 78.4992, 76.1904, 78.4992, 80.8080, 64.6464, 76.1904, 46.1760, 66.9552, 32.3232, 57.7200, 18.4704, 43.8672, 13.8528, 30.0144, 13.8528, 20.7792, 18.4704, 11.5440, 32.3232, 2.3088, 46.1760, -6.9264, 50.7936, -16.1616, 50.7936, -25.3968, 46.1760, -30.0144, 36.9408, -30.0144, 32.3232, -25.3968, GAMGI_IO_STROKE,

55.4112, 71.5728, 36.9408, 57.7200, 23.0880, 43.8672, 18.4704, 30.0144, 18.4704, 20.7792, 23.0880, 11.5440, 32.3232, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 123 { strokes: 3 *
 **************************/

46.1760, 117.7488, 32.3232, 103.8960, 27.7056, 90.0432, 27.7056, 80.8080, 32.3232, 66.9552, 41.5584, 57.7200, 41.5584, 53.1024, 23.0880, 43.8672, 41.5584, 34.6320, 41.5584, 30.0144, 32.3232, 20.7792, 27.7056, 6.9264, 27.7056, -2.3088, 32.3232, -16.1616, 46.1760, -30.0144, GAMGI_IO_STROKE,

36.9408, 108.5136, 32.3232, 94.6608, 32.3232, 76.1904, 36.9408, 62.3376, GAMGI_IO_STROKE,

36.9408, 25.3968, 32.3232, 11.5440, 32.3232, -6.9264, 36.9408, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 124 | strokes: 1 *
 **************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 125 } strokes: 3 *
 **************************/

23.0880, 117.7488, 36.9408, 103.8960, 41.5584, 90.0432, 41.5584, 80.8080, 36.9408, 66.9552, 27.7056, 57.7200, 27.7056, 53.1024, 46.1760, 43.8672, 27.7056, 34.6320, 27.7056, 30.0144, 36.9408, 20.7792, 41.5584, 6.9264, 41.5584, -2.3088, 36.9408, -16.1616, 23.0880, -30.0144, GAMGI_IO_STROKE,

32.3232, 108.5136, 36.9408, 94.6608, 36.9408, 76.1904, 32.3232, 62.3376, GAMGI_IO_STROKE,

32.3232, 25.3968, 36.9408, 11.5440, 36.9408, -6.9264, 32.3232, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 126 ~ strokes: 2 *
 **************************/

13.8528, 30.0144, 13.8528, 39.2496, 18.4704, 53.1024, 27.7056, 57.7200, 36.9408, 57.7200, 46.1760, 53.1024, 64.6464, 39.2496, 73.8816, 34.6320, 83.1168, 34.6320, 92.3520, 39.2496, 96.9696, 48.4848, GAMGI_IO_STROKE,

13.8528, 39.2496, 18.4704, 48.4848, 27.7056, 53.1024, 36.9408, 53.1024, 46.1760, 48.4848, 64.6464, 34.6320, 73.8816, 30.0144, 83.1168, 30.0144, 92.3520, 34.6320, 96.9696, 48.4848, 96.9696, 57.7200, GAMGI_IO_CHAR,

};

const float gamgi_io_font_hershey_symbol_serif_bold_points[GAMGI_IO_POINTS_SYMBOL_SERIF_BOLD] = {

/***************
 * bottom, top *
 ***************/

-32.3232, 120.0576,

/**************
 * char 32-40 *
 **************/

73.8816, 50.7936, 83.1168, 106.2048, 87.7344, 110.8224, 92.3520, 110.8224, 64.6464, 

/**************
 * char 41-50 *
 **************/

64.6464, 73.8816, 115.4400, 50.7936, 115.4400, 50.7936, 106.2048, 92.3520, 92.3520, 92.3520, 

/**************
 * char 51-60 *
 **************/

92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 92.3520, 50.7936, 50.7936, 110.8224, 

/**************
 * char 61-70 *
 **************/

115.4400, 110.8224, 87.7344, 110.8224, 92.3520, 101.5872, 92.3520, 92.3520, 96.9696, 101.5872, 

/**************
 * char 71-80 *
 **************/

83.1168, 110.8224, 55.4112, 106.2048, 101.5872, 92.3520, 120.0576, 110.8224, 101.5872, 110.8224, 

/**************
 * char 81-90 *
 **************/

101.5872, 101.5872, 101.5872, 92.3520, 101.5872, 92.3520, 101.5872, 101.5872, 110.8224, 92.3520, 

/***************
 * char 91-100 *
 ***************/

64.6464, 120.0576, 64.6464, 110.8224, 101.5872, 0.0, 106.2048, 96.9696, 92.3520, 92.3520, 
/*64.6464, 120.0576, 64.6464, 110.8224, 101.5872, 101.5872, 106.2048, 96.9696, 92.3520, 92.3520,*/

/****************
 * char 101-110 *
 ****************/

83.1168, 101.5872, 101.5872, 101.5872, 69.2640, 101.5872, 101.5872, 92.3520, 101.5872, 101.5872, 

/****************
 * char 111-120 *
 ****************/

92.3520, 101.5872, 92.3520, 96.9696, 101.5872, 92.3520, 96.9696, 110.8224, 110.8224, 73.8816, 

/****************
 * char 121-126 *
 ****************/

106.2048, 83.1168, 69.2640, 41.5584, 69.2640, 110.8224, 

/*************************
 * char: 32   strokes: 0 *
 *************************/

GAMGI_IO_CHAR,

/*************************
 * char: 33 ! strokes: 6 *
 *************************/

23.0880, 99.2784, 18.4704, 94.6608, 18.4704, 85.4256, 23.0880, 48.4848, GAMGI_IO_STROKE,

23.0880, 99.2784, 23.0880, 34.6320, 27.7056, 34.6320, GAMGI_IO_STROKE,

23.0880, 99.2784, 27.7056, 99.2784, 27.7056, 34.6320, GAMGI_IO_STROKE,

27.7056, 99.2784, 32.3232, 94.6608, 32.3232, 85.4256, 27.7056, 48.4848, GAMGI_IO_STROKE,

23.0880, 16.1616, 18.4704, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 2.3088, 32.3232, 6.9264, 32.3232, 11.5440, 27.7056, 16.1616, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 34 " strokes: 2 *
 *************************/

9.2352, 99.2784, 41.5584, 2.3088, 73.8816, 99.2784, GAMGI_IO_STROKE,

18.4704, 71.5728, 64.6464, 71.5728, GAMGI_IO_CHAR,

/*************************
 * char: 35 # strokes: 8 *
 *************************/

36.9408, 99.2784, 36.9408, -30.0144, 41.5584, -30.0144, GAMGI_IO_STROKE,

36.9408, 99.2784, 41.5584, 99.2784, 41.5584, -30.0144, GAMGI_IO_STROKE,

64.6464, 99.2784, 64.6464, -30.0144, 69.2640, -30.0144, GAMGI_IO_STROKE,

64.6464, 99.2784, 69.2640, 99.2784, 69.2640, -30.0144, GAMGI_IO_STROKE,

13.8528, 53.1024, 92.3520, 53.1024, 92.3520, 48.4848, GAMGI_IO_STROKE,

13.8528, 53.1024, 13.8528, 48.4848, 92.3520, 48.4848, GAMGI_IO_STROKE,

13.8528, 20.7792, 92.3520, 20.7792, 92.3520, 16.1616, GAMGI_IO_STROKE,

13.8528, 20.7792, 13.8528, 16.1616, 92.3520, 16.1616, GAMGI_IO_CHAR,

/*************************
 * char: 36 $ strokes: 4 *
 *************************/

69.2640, 99.2784, 69.2640, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 69.2640, 99.2784, GAMGI_IO_STROKE,

32.3232, 53.1024, 69.2640, 53.1024, GAMGI_IO_STROKE,

9.2352, 2.3088, 69.2640, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 37 % strokes: 12 *
 *************************/

96.9696, 99.2784, 87.7344, 94.6608, 73.8816, 90.0432, 60.0288, 90.0432, 46.1760, 94.6608, 36.9408, 99.2784, 27.7056, 99.2784, 18.4704, 94.6608, 13.8528, 85.4256, 13.8528, 76.1904, 23.0880, 66.9552, 32.3232, 66.9552, 41.5584, 71.5728, 46.1760, 80.8080, 46.1760, 90.0432, 36.9408, 99.2784, GAMGI_IO_STROKE,

96.9696, 99.2784, 9.2352, 2.3088, GAMGI_IO_STROKE,

96.9696, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

96.9696, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

87.7344, 34.6320, 78.4992, 34.6320, 69.2640, 30.0144, 64.6464, 20.7792, 64.6464, 11.5440, 73.8816, 2.3088, 83.1168, 2.3088, 92.3520, 6.9264, 96.9696, 16.1616, 96.9696, 25.3968, 87.7344, 34.6320, GAMGI_IO_STROKE,

41.5584, 94.6608, 27.7056, 99.2784, 13.8528, 85.4256, 18.4704, 71.5728, 32.3232, 66.9552, 46.1760, 80.8080, 41.5584, 94.6608, GAMGI_IO_STROKE,

36.9408, 99.2784, 18.4704, 94.6608, 13.8528, 76.1904, GAMGI_IO_STROKE,

23.0880, 66.9552, 41.5584, 71.5728, 46.1760, 90.0432, GAMGI_IO_STROKE,

92.3520, 30.0144, 78.4992, 34.6320, 64.6464, 20.7792, 69.2640, 6.9264, 83.1168, 2.3088, 96.9696, 16.1616, 92.3520, 30.0144, GAMGI_IO_STROKE,

87.7344, 34.6320, 69.2640, 30.0144, 64.6464, 11.5440, GAMGI_IO_STROKE,

73.8816, 2.3088, 92.3520, 6.9264, 96.9696, 25.3968, GAMGI_IO_STROKE,

9.2352, 2.3088, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 38 & strokes: 5 *
 *************************/

36.9408, 117.7488, 36.9408, -16.1616, GAMGI_IO_STROKE,

55.4112, 117.7488, 55.4112, -16.1616, GAMGI_IO_STROKE,

73.8816, 76.1904, 73.8816, 80.8080, 69.2640, 80.8080, 69.2640, 71.5728, 78.4992, 71.5728, 78.4992, 80.8080, 73.8816, 90.0432, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, 23.0880, 94.6608, 13.8528, 85.4256, 13.8528, 71.5728, 18.4704, 62.3376, 32.3232, 53.1024, 60.0288, 43.8672, 69.2640, 39.2496, 73.8816, 30.0144, 73.8816, 16.1616, 69.2640, 6.9264, GAMGI_IO_STROKE,

18.4704, 71.5728, 23.0880, 62.3376, 32.3232, 57.7200, 60.0288, 48.4848, 69.2640, 43.8672, 73.8816, 34.6320, GAMGI_IO_STROKE,

23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 76.1904, 23.0880, 66.9552, 32.3232, 62.3376, 60.0288, 53.1024, 73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 20.7792, 73.8816, 11.5440, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 30.0144, 23.0880, 30.0144, 23.0880, 20.7792, 18.4704, 20.7792, 18.4704, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 39 ' strokes: 2 *
 *************************/

18.4704, 80.8080, 50.7936, 80.8080, 69.2640, 76.1904, 78.4992, 71.5728, 87.7344, 62.3376, 92.3520, 48.4848, 92.3520, 39.2496, 87.7344, 25.3968, 78.4992, 16.1616, 69.2640, 11.5440, 50.7936, 6.9264, 18.4704, 6.9264, GAMGI_IO_STROKE,

41.5584, 43.8672, 92.3520, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 40 ( strokes: 3 *
 *************************/

46.1760, 117.7488, 36.9408, 108.5136, 27.7056, 94.6608, 18.4704, 76.1904, 13.8528, 53.1024, 13.8528, 34.6320, 18.4704, 11.5440, 27.7056, -6.9264, 36.9408, -20.7792, 46.1760, -30.0144, GAMGI_IO_STROKE,

27.7056, 90.0432, 23.0880, 76.1904, 18.4704, 57.7200, 18.4704, 30.0144, 23.0880, 11.5440, 27.7056, -2.3088, GAMGI_IO_STROKE,

36.9408, 108.5136, 32.3232, 99.2784, 27.7056, 85.4256, 23.0880, 57.7200, 23.0880, 30.0144, 27.7056, 2.3088, 32.3232, -11.5440, 36.9408, -20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 41 ) strokes: 3 *
 *************************/

18.4704, 117.7488, 27.7056, 108.5136, 36.9408, 94.6608, 46.1760, 76.1904, 50.7936, 53.1024, 50.7936, 34.6320, 46.1760, 11.5440, 36.9408, -6.9264, 27.7056, -20.7792, 18.4704, -30.0144, GAMGI_IO_STROKE,

36.9408, 90.0432, 41.5584, 76.1904, 46.1760, 57.7200, 46.1760, 30.0144, 41.5584, 11.5440, 36.9408, -2.3088, GAMGI_IO_STROKE,

27.7056, 108.5136, 32.3232, 99.2784, 36.9408, 85.4256, 41.5584, 57.7200, 41.5584, 30.0144, 36.9408, 2.3088, 32.3232, -11.5440, 27.7056, -20.7792, GAMGI_IO_CHAR,

/*************************
 * char: 42 * strokes: 9 *
 *************************/

36.9408, 99.2784, 32.3232, 94.6608, 41.5584, 48.4848, 36.9408, 43.8672, GAMGI_IO_STROKE,

36.9408, 99.2784, 36.9408, 43.8672, GAMGI_IO_STROKE,

36.9408, 99.2784, 41.5584, 94.6608, 32.3232, 48.4848, 36.9408, 43.8672, GAMGI_IO_STROKE,

13.8528, 85.4256, 18.4704, 85.4256, 55.4112, 57.7200, 60.0288, 57.7200, GAMGI_IO_STROKE,

13.8528, 85.4256, 60.0288, 57.7200, GAMGI_IO_STROKE,

13.8528, 85.4256, 13.8528, 80.8080, 60.0288, 62.3376, 60.0288, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 55.4112, 85.4256, 18.4704, 57.7200, 13.8528, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 13.8528, 57.7200, GAMGI_IO_STROKE,

60.0288, 85.4256, 60.0288, 80.8080, 13.8528, 62.3376, 13.8528, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 43 + strokes: 4 *
 *************************/

55.4112, 85.4256, 55.4112, 6.9264, 60.0288, 6.9264, GAMGI_IO_STROKE,

55.4112, 85.4256, 60.0288, 85.4256, 60.0288, 6.9264, GAMGI_IO_STROKE,

18.4704, 48.4848, 96.9696, 48.4848, 96.9696, 43.8672, GAMGI_IO_STROKE,

18.4704, 48.4848, 18.4704, 43.8672, 96.9696, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 44 , strokes: 4 *
 *************************/

32.3232, 6.9264, 27.7056, 2.3088, 23.0880, 2.3088, 18.4704, 6.9264, 18.4704, 11.5440, 23.0880, 16.1616, 27.7056, 16.1616, 32.3232, 11.5440, 32.3232, -2.3088, 27.7056, -11.5440, 18.4704, -16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_STROKE,

27.7056, 2.3088, 32.3232, -2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 27.7056, -11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 45 - strokes: 2 *
 *************************/

18.4704, 48.4848, 96.9696, 48.4848, 96.9696, 43.8672, GAMGI_IO_STROKE,

18.4704, 48.4848, 18.4704, 43.8672, 96.9696, 43.8672, GAMGI_IO_CHAR,

/*************************
 * char: 46 . strokes: 2 *
 *************************/

23.0880, 16.1616, 18.4704, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 2.3088, 32.3232, 6.9264, 32.3232, 11.5440, 27.7056, 16.1616, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 47 / strokes: 2 *
 *************************/

92.3520, 117.7488, 9.2352, -30.0144, 13.8528, -30.0144, GAMGI_IO_STROKE,

92.3520, 117.7488, 96.9696, 117.7488, 13.8528, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 48 0 strokes: 5 *
 *************************/

41.5584, 99.2784, 27.7056, 94.6608, 18.4704, 80.8080, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 20.7792, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 20.7792, 78.4992, 43.8672, 78.4992, 57.7200, 73.8816, 80.8080, 64.6464, 94.6608, 50.7936, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

27.7056, 90.0432, 23.0880, 80.8080, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 20.7792, 27.7056, 11.5440, GAMGI_IO_STROKE,

64.6464, 11.5440, 69.2640, 20.7792, 73.8816, 39.2496, 73.8816, 62.3376, 69.2640, 80.8080, 64.6464, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, 27.7056, 85.4256, 23.0880, 62.3376, 23.0880, 39.2496, 27.7056, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 16.1616, 69.2640, 39.2496, 69.2640, 62.3376, 64.6464, 85.4256, 60.0288, 94.6608, 50.7936, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 49 1 strokes: 9 *
 *************************/

41.5584, 90.0432, 41.5584, 2.3088, GAMGI_IO_STROKE,

46.1760, 90.0432, 46.1760, 6.9264, GAMGI_IO_STROKE,

50.7936, 99.2784, 50.7936, 2.3088, GAMGI_IO_STROKE,

50.7936, 99.2784, 36.9408, 85.4256, 27.7056, 80.8080, GAMGI_IO_STROKE,

23.0880, 2.3088, 69.2640, 2.3088, GAMGI_IO_STROKE,

41.5584, 6.9264, 32.3232, 2.3088, GAMGI_IO_STROKE,

41.5584, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

50.7936, 11.5440, 55.4112, 2.3088, GAMGI_IO_STROKE,

50.7936, 6.9264, 60.0288, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 50 2 strokes: 7 *
 *************************/

18.4704, 80.8080, 18.4704, 76.1904, 23.0880, 76.1904, 23.0880, 80.8080, 18.4704, 80.8080, GAMGI_IO_STROKE,

18.4704, 85.4256, 23.0880, 85.4256, 27.7056, 80.8080, 27.7056, 76.1904, 23.0880, 71.5728, 18.4704, 71.5728, 13.8528, 76.1904, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 36.9408, 99.2784, 55.4112, 99.2784, 69.2640, 94.6608, 73.8816, 90.0432, 78.4992, 80.8080, 78.4992, 71.5728, 73.8816, 62.3376, 60.0288, 53.1024, 36.9408, 43.8672, 27.7056, 39.2496, 18.4704, 30.0144, 13.8528, 16.1616, 13.8528, 2.3088, GAMGI_IO_STROKE,

69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 71.5728, 69.2640, 62.3376, GAMGI_IO_STROKE,

55.4112, 99.2784, 64.6464, 94.6608, 69.2640, 80.8080, 69.2640, 71.5728, 64.6464, 62.3376, 55.4112, 53.1024, 36.9408, 43.8672, GAMGI_IO_STROKE,

13.8528, 11.5440, 18.4704, 16.1616, 27.7056, 16.1616, 50.7936, 11.5440, 69.2640, 11.5440, 78.4992, 16.1616, GAMGI_IO_STROKE,

27.7056, 16.1616, 50.7936, 6.9264, 69.2640, 6.9264, 73.8816, 11.5440, GAMGI_IO_STROKE,

27.7056, 16.1616, 50.7936, 2.3088, 69.2640, 2.3088, 73.8816, 6.9264, 78.4992, 16.1616, 78.4992, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 51 3 strokes: 8 *
 *************************/

18.4704, 80.8080, 18.4704, 76.1904, 23.0880, 76.1904, 23.0880, 80.8080, 18.4704, 80.8080, GAMGI_IO_STROKE,

18.4704, 85.4256, 23.0880, 85.4256, 27.7056, 80.8080, 27.7056, 76.1904, 23.0880, 71.5728, 18.4704, 71.5728, 13.8528, 76.1904, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 36.9408, 99.2784, 55.4112, 99.2784, 69.2640, 94.6608, 73.8816, 85.4256, 73.8816, 71.5728, 69.2640, 62.3376, 55.4112, 57.7200, GAMGI_IO_STROKE,

64.6464, 94.6608, 69.2640, 85.4256, 69.2640, 71.5728, 64.6464, 62.3376, GAMGI_IO_STROKE,

50.7936, 99.2784, 60.0288, 94.6608, 64.6464, 85.4256, 64.6464, 71.5728, 60.0288, 62.3376, 50.7936, 57.7200, GAMGI_IO_STROKE,

41.5584, 57.7200, 55.4112, 57.7200, 64.6464, 53.1024, 73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 20.7792, 73.8816, 11.5440, 69.2640, 6.9264, 55.4112, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 25.3968, 18.4704, 30.0144, 23.0880, 30.0144, 27.7056, 25.3968, 27.7056, 20.7792, 23.0880, 16.1616, 18.4704, 16.1616, GAMGI_IO_STROKE,

69.2640, 43.8672, 73.8816, 34.6320, 73.8816, 20.7792, 69.2640, 11.5440, GAMGI_IO_STROKE,

50.7936, 57.7200, 60.0288, 53.1024, 64.6464, 48.4848, 69.2640, 34.6320, 69.2640, 20.7792, 64.6464, 6.9264, 55.4112, 2.3088, GAMGI_IO_STROKE,

18.4704, 25.3968, 18.4704, 20.7792, 23.0880, 20.7792, 23.0880, 25.3968, 18.4704, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 52 4 strokes: 9 *
 *************************/

50.7936, 85.4256, 50.7936, 2.3088, GAMGI_IO_STROKE,

55.4112, 90.0432, 55.4112, 6.9264, GAMGI_IO_STROKE,

60.0288, 99.2784, 60.0288, 2.3088, GAMGI_IO_STROKE,

60.0288, 99.2784, 9.2352, 30.0144, 83.1168, 30.0144, GAMGI_IO_STROKE,

36.9408, 2.3088, 73.8816, 2.3088, GAMGI_IO_STROKE,

50.7936, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 11.5440, 46.1760, 2.3088, GAMGI_IO_STROKE,

60.0288, 11.5440, 64.6464, 2.3088, GAMGI_IO_STROKE,

60.0288, 6.9264, 69.2640, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 53 5 strokes: 7 *
 *************************/

23.0880, 99.2784, 13.8528, 53.1024, 23.0880, 62.3376, 36.9408, 66.9552, 50.7936, 66.9552, 64.6464, 62.3376, 73.8816, 53.1024, 78.4992, 39.2496, 78.4992, 30.0144, 73.8816, 16.1616, 64.6464, 6.9264, 50.7936, 2.3088, 36.9408, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, 13.8528, 20.7792, 13.8528, 25.3968, 18.4704, 30.0144, 23.0880, 30.0144, 27.7056, 25.3968, 27.7056, 20.7792, 23.0880, 16.1616, 18.4704, 16.1616, GAMGI_IO_STROKE,

69.2640, 53.1024, 73.8816, 43.8672, 73.8816, 25.3968, 69.2640, 16.1616, GAMGI_IO_STROKE,

50.7936, 66.9552, 60.0288, 62.3376, 64.6464, 57.7200, 69.2640, 43.8672, 69.2640, 25.3968, 64.6464, 11.5440, 60.0288, 6.9264, 50.7936, 2.3088, GAMGI_IO_STROKE,

18.4704, 25.3968, 18.4704, 20.7792, 23.0880, 20.7792, 23.0880, 25.3968, 18.4704, 25.3968, GAMGI_IO_STROKE,

23.0880, 99.2784, 69.2640, 99.2784, GAMGI_IO_STROKE,

23.0880, 94.6608, 60.0288, 94.6608, GAMGI_IO_STROKE,

23.0880, 90.0432, 41.5584, 90.0432, 60.0288, 94.6608, 69.2640, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 54 6 strokes: 6 *
 *************************/

64.6464, 85.4256, 64.6464, 80.8080, 69.2640, 80.8080, 69.2640, 85.4256, 64.6464, 85.4256, GAMGI_IO_STROKE,

69.2640, 90.0432, 64.6464, 90.0432, 60.0288, 85.4256, 60.0288, 80.8080, 64.6464, 76.1904, 69.2640, 76.1904, 73.8816, 80.8080, 73.8816, 85.4256, 69.2640, 94.6608, 60.0288, 99.2784, 46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 57.7200, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 30.0144, 78.4992, 34.6320, 73.8816, 48.4848, 64.6464, 57.7200, 50.7936, 62.3376, 41.5584, 62.3376, 32.3232, 57.7200, 27.7056, 53.1024, 23.0880, 43.8672, GAMGI_IO_STROKE,

27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 57.7200, 18.4704, 30.0144, 23.0880, 16.1616, 27.7056, 11.5440, GAMGI_IO_STROKE,

69.2640, 16.1616, 73.8816, 25.3968, 73.8816, 39.2496, 69.2640, 48.4848, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 32.3232, 90.0432, 27.7056, 80.8080, 23.0880, 62.3376, 23.0880, 30.0144, 27.7056, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 11.5440, 69.2640, 25.3968, 69.2640, 39.2496, 64.6464, 53.1024, 60.0288, 57.7200, 50.7936, 62.3376, GAMGI_IO_CHAR,

/*************************
 * char: 55 7 strokes: 7 *
 *************************/

13.8528, 99.2784, 13.8528, 71.5728, GAMGI_IO_STROKE,

78.4992, 99.2784, 78.4992, 85.4256, 73.8816, 71.5728, 55.4112, 48.4848, 50.7936, 39.2496, 46.1760, 20.7792, 46.1760, 2.3088, GAMGI_IO_STROKE,

50.7936, 43.8672, 46.1760, 34.6320, 41.5584, 20.7792, 41.5584, 2.3088, GAMGI_IO_STROKE,

73.8816, 71.5728, 50.7936, 48.4848, 41.5584, 34.6320, 36.9408, 20.7792, 36.9408, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

13.8528, 80.8080, 18.4704, 90.0432, 27.7056, 99.2784, 36.9408, 99.2784, 60.0288, 85.4256, 69.2640, 85.4256, 73.8816, 90.0432, 78.4992, 99.2784, GAMGI_IO_STROKE,

23.0880, 90.0432, 27.7056, 94.6608, 36.9408, 94.6608, 46.1760, 90.0432, GAMGI_IO_STROKE,

13.8528, 80.8080, 18.4704, 85.4256, 27.7056, 90.0432, 36.9408, 90.0432, 60.0288, 85.4256, GAMGI_IO_CHAR,

/*************************
 * char: 56 8 strokes: 10 *
 *************************/

36.9408, 99.2784, 23.0880, 94.6608, 18.4704, 85.4256, 18.4704, 71.5728, 23.0880, 62.3376, 36.9408, 57.7200, 55.4112, 57.7200, 69.2640, 62.3376, 73.8816, 71.5728, 73.8816, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 36.9408, 99.2784, GAMGI_IO_STROKE,

27.7056, 94.6608, 23.0880, 85.4256, 23.0880, 71.5728, 27.7056, 62.3376, GAMGI_IO_STROKE,

64.6464, 62.3376, 69.2640, 71.5728, 69.2640, 85.4256, 64.6464, 94.6608, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 94.6608, 27.7056, 85.4256, 27.7056, 71.5728, 32.3232, 62.3376, 36.9408, 57.7200, GAMGI_IO_STROKE,

55.4112, 57.7200, 60.0288, 62.3376, 64.6464, 71.5728, 64.6464, 85.4256, 60.0288, 94.6608, 55.4112, 99.2784, GAMGI_IO_STROKE,

36.9408, 57.7200, 23.0880, 53.1024, 18.4704, 48.4848, 13.8528, 39.2496, 13.8528, 20.7792, 18.4704, 11.5440, 23.0880, 6.9264, 36.9408, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 73.8816, 11.5440, 78.4992, 20.7792, 78.4992, 39.2496, 73.8816, 48.4848, 69.2640, 53.1024, 55.4112, 57.7200, GAMGI_IO_STROKE,

23.0880, 48.4848, 18.4704, 39.2496, 18.4704, 20.7792, 23.0880, 11.5440, GAMGI_IO_STROKE,

69.2640, 11.5440, 73.8816, 20.7792, 73.8816, 39.2496, 69.2640, 48.4848, GAMGI_IO_STROKE,

36.9408, 57.7200, 27.7056, 53.1024, 23.0880, 39.2496, 23.0880, 20.7792, 27.7056, 6.9264, 36.9408, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 64.6464, 6.9264, 69.2640, 20.7792, 69.2640, 39.2496, 64.6464, 53.1024, 55.4112, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 57 9 strokes: 6 *
 *************************/

23.0880, 20.7792, 23.0880, 16.1616, 27.7056, 16.1616, 27.7056, 20.7792, 23.0880, 20.7792, GAMGI_IO_STROKE,

69.2640, 57.7200, 64.6464, 48.4848, 60.0288, 43.8672, 50.7936, 39.2496, 41.5584, 39.2496, 27.7056, 43.8672, 18.4704, 53.1024, 13.8528, 66.9552, 13.8528, 71.5728, 18.4704, 85.4256, 27.7056, 94.6608, 41.5584, 99.2784, 50.7936, 99.2784, 64.6464, 94.6608, 73.8816, 85.4256, 78.4992, 71.5728, 78.4992, 43.8672, 73.8816, 25.3968, 69.2640, 16.1616, 60.0288, 6.9264, 46.1760, 2.3088, 32.3232, 2.3088, 23.0880, 6.9264, 18.4704, 16.1616, 18.4704, 20.7792, 23.0880, 25.3968, 27.7056, 25.3968, 32.3232, 20.7792, 32.3232, 16.1616, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_STROKE,

23.0880, 53.1024, 18.4704, 62.3376, 18.4704, 76.1904, 23.0880, 85.4256, GAMGI_IO_STROKE,

64.6464, 90.0432, 69.2640, 85.4256, 73.8816, 71.5728, 73.8816, 43.8672, 69.2640, 25.3968, 64.6464, 16.1616, GAMGI_IO_STROKE,

41.5584, 39.2496, 32.3232, 43.8672, 27.7056, 48.4848, 23.0880, 62.3376, 23.0880, 76.1904, 27.7056, 90.0432, 32.3232, 94.6608, 41.5584, 99.2784, GAMGI_IO_STROKE,

50.7936, 99.2784, 60.0288, 94.6608, 64.6464, 85.4256, 69.2640, 71.5728, 69.2640, 39.2496, 64.6464, 20.7792, 60.0288, 11.5440, 55.4112, 6.9264, 46.1760, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 58 : strokes: 4 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 18.4704, 57.7200, 23.0880, 53.1024, 27.7056, 53.1024, 32.3232, 57.7200, 32.3232, 62.3376, 27.7056, 66.9552, 23.0880, 66.9552, GAMGI_IO_STROKE,

23.0880, 62.3376, 23.0880, 57.7200, 27.7056, 57.7200, 27.7056, 62.3376, 23.0880, 62.3376, GAMGI_IO_STROKE,

23.0880, 16.1616, 18.4704, 11.5440, 18.4704, 6.9264, 23.0880, 2.3088, 27.7056, 2.3088, 32.3232, 6.9264, 32.3232, 11.5440, 27.7056, 16.1616, 23.0880, 16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 59 ; strokes: 6 *
 *************************/

23.0880, 66.9552, 18.4704, 62.3376, 18.4704, 57.7200, 23.0880, 53.1024, 27.7056, 53.1024, 32.3232, 57.7200, 32.3232, 62.3376, 27.7056, 66.9552, 23.0880, 66.9552, GAMGI_IO_STROKE,

23.0880, 62.3376, 23.0880, 57.7200, 27.7056, 57.7200, 27.7056, 62.3376, 23.0880, 62.3376, GAMGI_IO_STROKE,

32.3232, 6.9264, 27.7056, 2.3088, 23.0880, 2.3088, 18.4704, 6.9264, 18.4704, 11.5440, 23.0880, 16.1616, 27.7056, 16.1616, 32.3232, 11.5440, 32.3232, -2.3088, 27.7056, -11.5440, 18.4704, -16.1616, GAMGI_IO_STROKE,

23.0880, 11.5440, 23.0880, 6.9264, 27.7056, 6.9264, 27.7056, 11.5440, 23.0880, 11.5440, GAMGI_IO_STROKE,

27.7056, 2.3088, 32.3232, -2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 27.7056, -11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 60 < strokes: 2 *
 *************************/

92.3520, 85.4256, 18.4704, 43.8672, 92.3520, 2.3088, GAMGI_IO_STROKE,

92.3520, 85.4256, 92.3520, 80.8080, 27.7056, 43.8672, 92.3520, 6.9264, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 61 = strokes: 4 *
 *************************/

18.4704, 66.9552, 96.9696, 66.9552, 96.9696, 62.3376, GAMGI_IO_STROKE,

18.4704, 66.9552, 18.4704, 62.3376, 96.9696, 62.3376, GAMGI_IO_STROKE,

18.4704, 30.0144, 96.9696, 30.0144, 96.9696, 25.3968, GAMGI_IO_STROKE,

18.4704, 30.0144, 18.4704, 25.3968, 96.9696, 25.3968, GAMGI_IO_CHAR,

/*************************
 * char: 62 > strokes: 2 *
 *************************/

18.4704, 85.4256, 92.3520, 43.8672, 18.4704, 2.3088, GAMGI_IO_STROKE,

18.4704, 85.4256, 18.4704, 80.8080, 83.1168, 43.8672, 18.4704, 6.9264, 18.4704, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 63 ? strokes: 6 *
 *************************/

18.4704, 76.1904, 18.4704, 80.8080, 23.0880, 80.8080, 23.0880, 71.5728, 13.8528, 71.5728, 13.8528, 80.8080, 18.4704, 90.0432, 23.0880, 94.6608, 32.3232, 99.2784, 50.7936, 99.2784, 64.6464, 94.6608, 69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 71.5728, 69.2640, 62.3376, 64.6464, 57.7200, 46.1760, 48.4848, GAMGI_IO_STROKE,

64.6464, 90.0432, 69.2640, 85.4256, 69.2640, 66.9552, 64.6464, 62.3376, GAMGI_IO_STROKE,

50.7936, 99.2784, 60.0288, 94.6608, 64.6464, 85.4256, 64.6464, 66.9552, 60.0288, 57.7200, 55.4112, 53.1024, GAMGI_IO_STROKE,

41.5584, 48.4848, 41.5584, 34.6320, 46.1760, 34.6320, 46.1760, 48.4848, 41.5584, 48.4848, GAMGI_IO_STROKE,

41.5584, 16.1616, 36.9408, 11.5440, 36.9408, 6.9264, 41.5584, 2.3088, 46.1760, 2.3088, 50.7936, 6.9264, 50.7936, 11.5440, 46.1760, 16.1616, 41.5584, 16.1616, GAMGI_IO_STROKE,

41.5584, 11.5440, 41.5584, 6.9264, 46.1760, 6.9264, 46.1760, 11.5440, 41.5584, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 64 @ strokes: 4 *
 *************************/

13.8528, 39.2496, 18.4704, 48.4848, 27.7056, 53.1024, 36.9408, 53.1024, 46.1760, 48.4848, 64.6464, 34.6320, 73.8816, 30.0144, 83.1168, 30.0144, 92.3520, 34.6320, 96.9696, 48.4848, GAMGI_IO_STROKE,

13.8528, 39.2496, 18.4704, 53.1024, 27.7056, 57.7200, 36.9408, 57.7200, 46.1760, 53.1024, 64.6464, 39.2496, 73.8816, 34.6320, 83.1168, 34.6320, 92.3520, 39.2496, 96.9696, 48.4848, GAMGI_IO_STROKE,

13.8528, 20.7792, 96.9696, 20.7792, GAMGI_IO_STROKE,

13.8528, 2.3088, 96.9696, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 65 A strokes: 12 *
 *************************/

46.1760, 99.2784, 13.8528, 6.9264, GAMGI_IO_STROKE,

41.5584, 85.4256, 69.2640, 2.3088, GAMGI_IO_STROKE,

46.1760, 85.4256, 73.8816, 2.3088, GAMGI_IO_STROKE,

46.1760, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

23.0880, 30.0144, 64.6464, 30.0144, GAMGI_IO_STROKE,

4.6176, 2.3088, 32.3232, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 87.7344, 2.3088, GAMGI_IO_STROKE,

13.8528, 6.9264, 9.2352, 2.3088, GAMGI_IO_STROKE,

13.8528, 6.9264, 23.0880, 2.3088, GAMGI_IO_STROKE,

69.2640, 6.9264, 60.0288, 2.3088, GAMGI_IO_STROKE,

69.2640, 11.5440, 64.6464, 2.3088, GAMGI_IO_STROKE,

73.8816, 11.5440, 83.1168, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 66 B strokes: 17 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 64.6464, 99.2784, 78.4992, 94.6608, 83.1168, 90.0432, 87.7344, 80.8080, 87.7344, 71.5728, 83.1168, 62.3376, 78.4992, 57.7200, 64.6464, 53.1024, GAMGI_IO_STROKE,

78.4992, 90.0432, 83.1168, 80.8080, 83.1168, 71.5728, 78.4992, 62.3376, GAMGI_IO_STROKE,

64.6464, 99.2784, 73.8816, 94.6608, 78.4992, 85.4256, 78.4992, 66.9552, 73.8816, 57.7200, 64.6464, 53.1024, GAMGI_IO_STROKE,

32.3232, 53.1024, 64.6464, 53.1024, 78.4992, 48.4848, 83.1168, 43.8672, 87.7344, 34.6320, 87.7344, 20.7792, 83.1168, 11.5440, 78.4992, 6.9264, 64.6464, 2.3088, 9.2352, 2.3088, GAMGI_IO_STROKE,

78.4992, 43.8672, 83.1168, 34.6320, 83.1168, 20.7792, 78.4992, 11.5440, GAMGI_IO_STROKE,

64.6464, 53.1024, 73.8816, 48.4848, 78.4992, 39.2496, 78.4992, 16.1616, 73.8816, 6.9264, 64.6464, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 67 C strokes: 18 *
 *************************/

13.8528, 99.2784, 69.2640, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 73.8816, 2.3088, GAMGI_IO_STROKE,

23.0880, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

73.8816, 94.6608, 18.4704, 6.9264, GAMGI_IO_STROKE,

4.6176, 99.2784, 36.9408, 99.2784, GAMGI_IO_STROKE,

60.0288, 99.2784, 87.7344, 99.2784, GAMGI_IO_STROKE,

4.6176, 2.3088, 32.3232, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 87.7344, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

27.7056, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

32.3232, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

64.6464, 99.2784, 73.8816, 94.6608, GAMGI_IO_STROKE,

83.1168, 99.2784, 73.8816, 94.6608, GAMGI_IO_STROKE,

18.4704, 6.9264, 9.2352, 2.3088, GAMGI_IO_STROKE,

18.4704, 6.9264, 27.7056, 2.3088, GAMGI_IO_STROKE,

69.2640, 6.9264, 60.0288, 2.3088, GAMGI_IO_STROKE,

69.2640, 11.5440, 64.6464, 2.3088, GAMGI_IO_STROKE,

69.2640, 11.5440, 83.1168, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 68 D strokes: 7 *
 *************************/

46.1760, 99.2784, 9.2352, 2.3088, GAMGI_IO_STROKE,

41.5584, 85.4256, 73.8816, 2.3088, GAMGI_IO_STROKE,

46.1760, 85.4256, 78.4992, 2.3088, GAMGI_IO_STROKE,

46.1760, 99.2784, 83.1168, 2.3088, GAMGI_IO_STROKE,

13.8528, 11.5440, 73.8816, 11.5440, GAMGI_IO_STROKE,

13.8528, 6.9264, 73.8816, 6.9264, GAMGI_IO_STROKE,

9.2352, 2.3088, 83.1168, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 69 E strokes: 26 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 83.1168, 99.2784, 83.1168, 71.5728, GAMGI_IO_STROKE,

32.3232, 53.1024, 60.0288, 53.1024, GAMGI_IO_STROKE,

60.0288, 71.5728, 60.0288, 34.6320, GAMGI_IO_STROKE,

9.2352, 2.3088, 83.1168, 2.3088, 83.1168, 30.0144, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

60.0288, 99.2784, 83.1168, 94.6608, GAMGI_IO_STROKE,

69.2640, 99.2784, 83.1168, 90.0432, GAMGI_IO_STROKE,

73.8816, 99.2784, 83.1168, 85.4256, GAMGI_IO_STROKE,

78.4992, 99.2784, 83.1168, 71.5728, GAMGI_IO_STROKE,

60.0288, 71.5728, 55.4112, 53.1024, 60.0288, 34.6320, GAMGI_IO_STROKE,

60.0288, 62.3376, 50.7936, 53.1024, 60.0288, 43.8672, GAMGI_IO_STROKE,

60.0288, 57.7200, 41.5584, 53.1024, 60.0288, 48.4848, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

60.0288, 2.3088, 83.1168, 6.9264, GAMGI_IO_STROKE,

69.2640, 2.3088, 83.1168, 11.5440, GAMGI_IO_STROKE,

73.8816, 2.3088, 83.1168, 16.1616, GAMGI_IO_STROKE,

78.4992, 2.3088, 83.1168, 30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 70 F strokes: 18 *
 *************************/

46.1760, 99.2784, 46.1760, 2.3088, GAMGI_IO_STROKE,

50.7936, 94.6608, 50.7936, 6.9264, GAMGI_IO_STROKE,

55.4112, 99.2784, 55.4112, 2.3088, GAMGI_IO_STROKE,

32.3232, 99.2784, 69.2640, 99.2784, GAMGI_IO_STROKE,

32.3232, 2.3088, 69.2640, 2.3088, GAMGI_IO_STROKE,

36.9408, 99.2784, 46.1760, 94.6608, GAMGI_IO_STROKE,

41.5584, 99.2784, 46.1760, 90.0432, GAMGI_IO_STROKE,

60.0288, 99.2784, 55.4112, 90.0432, GAMGI_IO_STROKE,

64.6464, 99.2784, 55.4112, 94.6608, GAMGI_IO_STROKE,

46.1760, 6.9264, 36.9408, 2.3088, GAMGI_IO_STROKE,

46.1760, 11.5440, 41.5584, 2.3088, GAMGI_IO_STROKE,

55.4112, 11.5440, 60.0288, 2.3088, GAMGI_IO_STROKE,

55.4112, 6.9264, 64.6464, 2.3088, GAMGI_IO_STROKE,

36.9408, 76.1904, 23.0880, 71.5728, 18.4704, 66.9552, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 34.6320, 23.0880, 30.0144, 36.9408, 25.3968, 64.6464, 25.3968, 78.4992, 30.0144, 83.1168, 34.6320, 87.7344, 43.8672, 87.7344, 57.7200, 83.1168, 66.9552, 78.4992, 71.5728, 64.6464, 76.1904, 36.9408, 76.1904, GAMGI_IO_STROKE,

23.0880, 66.9552, 18.4704, 57.7200, 18.4704, 43.8672, 23.0880, 34.6320, GAMGI_IO_STROKE,

78.4992, 34.6320, 83.1168, 43.8672, 83.1168, 57.7200, 78.4992, 66.9552, GAMGI_IO_STROKE,

36.9408, 76.1904, 27.7056, 71.5728, 23.0880, 57.7200, 23.0880, 43.8672, 27.7056, 30.0144, 36.9408, 25.3968, GAMGI_IO_STROKE,

64.6464, 25.3968, 73.8816, 30.0144, 78.4992, 43.8672, 78.4992, 57.7200, 73.8816, 71.5728, 64.6464, 76.1904, GAMGI_IO_CHAR,

/*************************
 * char: 71 G strokes: 17 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 78.4992, 99.2784, 78.4992, 71.5728, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

55.4112, 99.2784, 78.4992, 94.6608, GAMGI_IO_STROKE,

64.6464, 99.2784, 78.4992, 90.0432, GAMGI_IO_STROKE,

69.2640, 99.2784, 78.4992, 85.4256, GAMGI_IO_STROKE,

73.8816, 99.2784, 78.4992, 71.5728, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 72 H strokes: 27 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

78.4992, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

83.1168, 94.6608, 83.1168, 6.9264, GAMGI_IO_STROKE,

87.7344, 99.2784, 87.7344, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 46.1760, 99.2784, GAMGI_IO_STROKE,

64.6464, 99.2784, 101.5872, 99.2784, GAMGI_IO_STROKE,

32.3232, 53.1024, 78.4992, 53.1024, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

64.6464, 2.3088, 101.5872, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

69.2640, 99.2784, 78.4992, 94.6608, GAMGI_IO_STROKE,

73.8816, 99.2784, 78.4992, 90.0432, GAMGI_IO_STROKE,

92.3520, 99.2784, 87.7344, 90.0432, GAMGI_IO_STROKE,

96.9696, 99.2784, 87.7344, 94.6608, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

78.4992, 6.9264, 69.2640, 2.3088, GAMGI_IO_STROKE,

78.4992, 11.5440, 73.8816, 2.3088, GAMGI_IO_STROKE,

87.7344, 11.5440, 92.3520, 2.3088, GAMGI_IO_STROKE,

87.7344, 6.9264, 96.9696, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 73 I strokes: 13 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 46.1760, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 74 J strokes: 5 *
 *************************/

13.8528, 66.9552, 18.4704, 62.3376, 23.0880, 53.1024, 23.0880, 34.6320, 27.7056, 20.7792, 32.3232, 11.5440, 36.9408, 6.9264, 50.7936, 2.3088, 60.0288, 2.3088, 73.8816, 6.9264, 78.4992, 11.5440, 83.1168, 20.7792, 87.7344, 43.8672, 87.7344, 57.7200, 83.1168, 80.8080, 73.8816, 94.6608, 64.6464, 99.2784, 55.4112, 99.2784, 46.1760, 94.6608, 41.5584, 85.4256, 41.5584, 76.1904, 46.1760, 66.9552, 60.0288, 57.7200, 73.8816, 53.1024, 96.9696, 48.4848, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 62.3376, 27.7056, 53.1024, 27.7056, 34.6320, 32.3232, 20.7792, 36.9408, 11.5440, GAMGI_IO_STROKE,

73.8816, 11.5440, 78.4992, 20.7792, 83.1168, 43.8672, 83.1168, 57.7200, 78.4992, 80.8080, 73.8816, 90.0432, 64.6464, 94.6608, GAMGI_IO_STROKE,

4.6176, 53.1024, 9.2352, 62.3376, 13.8528, 66.9552, 23.0880, 66.9552, 27.7056, 62.3376, 32.3232, 53.1024, 32.3232, 34.6320, 36.9408, 16.1616, 41.5584, 6.9264, 50.7936, 2.3088, GAMGI_IO_STROKE,

60.0288, 2.3088, 69.2640, 6.9264, 73.8816, 16.1616, 78.4992, 39.2496, 78.4992, 62.3376, 73.8816, 80.8080, 69.2640, 90.0432, 60.0288, 94.6608, 50.7936, 94.6608, 41.5584, 85.4256, GAMGI_IO_CHAR,

/*************************
 * char: 75 K strokes: 23 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

83.1168, 94.6608, 32.3232, 43.8672, GAMGI_IO_STROKE,

46.1760, 53.1024, 78.4992, 2.3088, GAMGI_IO_STROKE,

50.7936, 53.1024, 83.1168, 2.3088, GAMGI_IO_STROKE,

50.7936, 62.3376, 87.7344, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 46.1760, 99.2784, GAMGI_IO_STROKE,

69.2640, 99.2784, 96.9696, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

64.6464, 2.3088, 96.9696, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

78.4992, 99.2784, 83.1168, 94.6608, GAMGI_IO_STROKE,

92.3520, 99.2784, 83.1168, 94.6608, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

78.4992, 11.5440, 69.2640, 2.3088, GAMGI_IO_STROKE,

78.4992, 11.5440, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 76 L strokes: 11 *
 *************************/

46.1760, 99.2784, 13.8528, 6.9264, GAMGI_IO_STROKE,

41.5584, 85.4256, 69.2640, 2.3088, GAMGI_IO_STROKE,

46.1760, 85.4256, 73.8816, 2.3088, GAMGI_IO_STROKE,

46.1760, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

4.6176, 2.3088, 32.3232, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 87.7344, 2.3088, GAMGI_IO_STROKE,

13.8528, 6.9264, 9.2352, 2.3088, GAMGI_IO_STROKE,

13.8528, 6.9264, 23.0880, 2.3088, GAMGI_IO_STROKE,

69.2640, 6.9264, 60.0288, 2.3088, GAMGI_IO_STROKE,

69.2640, 11.5440, 64.6464, 2.3088, GAMGI_IO_STROKE,

73.8816, 11.5440, 83.1168, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 77 M strokes: 21 *
 *************************/

23.0880, 99.2784, 23.0880, 6.9264, GAMGI_IO_STROKE,

23.0880, 99.2784, 55.4112, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 55.4112, 16.1616, GAMGI_IO_STROKE,

32.3232, 99.2784, 60.0288, 16.1616, GAMGI_IO_STROKE,

87.7344, 99.2784, 55.4112, 2.3088, GAMGI_IO_STROKE,

87.7344, 99.2784, 87.7344, 2.3088, GAMGI_IO_STROKE,

92.3520, 94.6608, 92.3520, 6.9264, GAMGI_IO_STROKE,

96.9696, 99.2784, 96.9696, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 32.3232, 99.2784, GAMGI_IO_STROKE,

87.7344, 99.2784, 110.8224, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 36.9408, 2.3088, GAMGI_IO_STROKE,

73.8816, 2.3088, 110.8224, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

101.5872, 99.2784, 96.9696, 90.0432, GAMGI_IO_STROKE,

106.2048, 99.2784, 96.9696, 94.6608, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 6.9264, 32.3232, 2.3088, GAMGI_IO_STROKE,

87.7344, 6.9264, 78.4992, 2.3088, GAMGI_IO_STROKE,

87.7344, 11.5440, 83.1168, 2.3088, GAMGI_IO_STROKE,

96.9696, 11.5440, 101.5872, 2.3088, GAMGI_IO_STROKE,

96.9696, 6.9264, 106.2048, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 78 N strokes: 13 *
 *************************/

23.0880, 99.2784, 23.0880, 6.9264, GAMGI_IO_STROKE,

23.0880, 99.2784, 87.7344, 2.3088, GAMGI_IO_STROKE,

27.7056, 99.2784, 83.1168, 16.1616, GAMGI_IO_STROKE,

32.3232, 99.2784, 87.7344, 16.1616, GAMGI_IO_STROKE,

87.7344, 94.6608, 87.7344, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 32.3232, 99.2784, GAMGI_IO_STROKE,

73.8816, 99.2784, 101.5872, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 36.9408, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

78.4992, 99.2784, 87.7344, 94.6608, GAMGI_IO_STROKE,

96.9696, 99.2784, 87.7344, 94.6608, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 6.9264, 32.3232, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 79 O strokes: 5 *
 *************************/

46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, 87.7344, 43.8672, 87.7344, 57.7200, 83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 46.1760, 99.2784, GAMGI_IO_STROKE,

27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 25.3968, 27.7056, 16.1616, GAMGI_IO_STROKE,

73.8816, 16.1616, 78.4992, 25.3968, 83.1168, 39.2496, 83.1168, 62.3376, 78.4992, 76.1904, 73.8816, 85.4256, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 27.7056, 80.8080, 23.0880, 62.3376, 23.0880, 39.2496, 27.7056, 20.7792, 36.9408, 6.9264, 46.1760, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 64.6464, 6.9264, 73.8816, 20.7792, 78.4992, 39.2496, 78.4992, 62.3376, 73.8816, 80.8080, 64.6464, 94.6608, 55.4112, 99.2784, GAMGI_IO_CHAR,

/*************************
 * char: 80 P strokes: 25 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

78.4992, 99.2784, 78.4992, 2.3088, GAMGI_IO_STROKE,

83.1168, 94.6608, 83.1168, 6.9264, GAMGI_IO_STROKE,

87.7344, 99.2784, 87.7344, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 101.5872, 99.2784, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

64.6464, 2.3088, 101.5872, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

69.2640, 99.2784, 78.4992, 94.6608, GAMGI_IO_STROKE,

73.8816, 99.2784, 78.4992, 90.0432, GAMGI_IO_STROKE,

92.3520, 99.2784, 87.7344, 90.0432, GAMGI_IO_STROKE,

96.9696, 99.2784, 87.7344, 94.6608, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

78.4992, 6.9264, 69.2640, 2.3088, GAMGI_IO_STROKE,

78.4992, 11.5440, 73.8816, 2.3088, GAMGI_IO_STROKE,

87.7344, 11.5440, 92.3520, 2.3088, GAMGI_IO_STROKE,

87.7344, 6.9264, 96.9696, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 81 Q strokes: 17 *
 *************************/

46.1760, 99.2784, 32.3232, 94.6608, 23.0880, 85.4256, 18.4704, 76.1904, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 25.3968, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 25.3968, 87.7344, 43.8672, 87.7344, 57.7200, 83.1168, 76.1904, 78.4992, 85.4256, 69.2640, 94.6608, 55.4112, 99.2784, 46.1760, 99.2784, GAMGI_IO_STROKE,

27.7056, 85.4256, 23.0880, 76.1904, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 25.3968, 27.7056, 16.1616, GAMGI_IO_STROKE,

73.8816, 16.1616, 78.4992, 25.3968, 83.1168, 39.2496, 83.1168, 62.3376, 78.4992, 76.1904, 73.8816, 85.4256, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 27.7056, 80.8080, 23.0880, 62.3376, 23.0880, 39.2496, 27.7056, 20.7792, 36.9408, 6.9264, 46.1760, 2.3088, GAMGI_IO_STROKE,

55.4112, 2.3088, 64.6464, 6.9264, 73.8816, 20.7792, 78.4992, 39.2496, 78.4992, 62.3376, 73.8816, 80.8080, 64.6464, 94.6608, 55.4112, 99.2784, GAMGI_IO_STROKE,

36.9408, 66.9552, 36.9408, 34.6320, GAMGI_IO_STROKE,

64.6464, 66.9552, 64.6464, 34.6320, GAMGI_IO_STROKE,

36.9408, 53.1024, 64.6464, 53.1024, GAMGI_IO_STROKE,

36.9408, 48.4848, 64.6464, 48.4848, GAMGI_IO_STROKE,

36.9408, 62.3376, 41.5584, 53.1024, GAMGI_IO_STROKE,

36.9408, 57.7200, 46.1760, 53.1024, GAMGI_IO_STROKE,

64.6464, 62.3376, 60.0288, 53.1024, GAMGI_IO_STROKE,

64.6464, 57.7200, 55.4112, 53.1024, GAMGI_IO_STROKE,

41.5584, 48.4848, 36.9408, 39.2496, GAMGI_IO_STROKE,

46.1760, 48.4848, 36.9408, 43.8672, GAMGI_IO_STROKE,

55.4112, 48.4848, 64.6464, 43.8672, GAMGI_IO_STROKE,

60.0288, 48.4848, 64.6464, 39.2496, GAMGI_IO_CHAR,

/*************************
 * char: 82 R strokes: 15 *
 *************************/

23.0880, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

27.7056, 94.6608, 27.7056, 6.9264, GAMGI_IO_STROKE,

32.3232, 99.2784, 32.3232, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 64.6464, 99.2784, 78.4992, 94.6608, 83.1168, 90.0432, 87.7344, 80.8080, 87.7344, 66.9552, 83.1168, 57.7200, 78.4992, 53.1024, 64.6464, 48.4848, 32.3232, 48.4848, GAMGI_IO_STROKE,

78.4992, 90.0432, 83.1168, 80.8080, 83.1168, 66.9552, 78.4992, 57.7200, GAMGI_IO_STROKE,

64.6464, 99.2784, 73.8816, 94.6608, 78.4992, 85.4256, 78.4992, 62.3376, 73.8816, 53.1024, 64.6464, 48.4848, GAMGI_IO_STROKE,

9.2352, 2.3088, 46.1760, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

18.4704, 99.2784, 23.0880, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 32.3232, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, GAMGI_IO_STROKE,

23.0880, 6.9264, 13.8528, 2.3088, GAMGI_IO_STROKE,

23.0880, 11.5440, 18.4704, 2.3088, GAMGI_IO_STROKE,

32.3232, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 83 S strokes: 9 *
 *************************/

9.2352, 99.2784, 41.5584, 53.1024, 46.1760, 48.4848, GAMGI_IO_STROKE,

13.8528, 99.2784, 46.1760, 53.1024, GAMGI_IO_STROKE,

18.4704, 99.2784, 50.7936, 53.1024, 9.2352, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 83.1168, 99.2784, 87.7344, 71.5728, 83.1168, 85.4256, 73.8816, 99.2784, GAMGI_IO_STROKE,

69.2640, 99.2784, 83.1168, 90.0432, GAMGI_IO_STROKE,

60.0288, 99.2784, 83.1168, 94.6608, GAMGI_IO_STROKE,

18.4704, 11.5440, 83.1168, 11.5440, GAMGI_IO_STROKE,

13.8528, 6.9264, 83.1168, 6.9264, GAMGI_IO_STROKE,

9.2352, 2.3088, 83.1168, 2.3088, 87.7344, 30.0144, 83.1168, 16.1616, 73.8816, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 84 T strokes: 19 *
 *************************/

9.2352, 99.2784, 9.2352, 71.5728, GAMGI_IO_STROKE,

41.5584, 99.2784, 41.5584, 2.3088, GAMGI_IO_STROKE,

46.1760, 94.6608, 46.1760, 6.9264, GAMGI_IO_STROKE,

50.7936, 99.2784, 50.7936, 2.3088, GAMGI_IO_STROKE,

83.1168, 99.2784, 83.1168, 71.5728, GAMGI_IO_STROKE,

9.2352, 99.2784, 83.1168, 99.2784, GAMGI_IO_STROKE,

27.7056, 2.3088, 64.6464, 2.3088, GAMGI_IO_STROKE,

13.8528, 99.2784, 9.2352, 71.5728, GAMGI_IO_STROKE,

18.4704, 99.2784, 9.2352, 85.4256, GAMGI_IO_STROKE,

23.0880, 99.2784, 9.2352, 90.0432, GAMGI_IO_STROKE,

32.3232, 99.2784, 9.2352, 94.6608, GAMGI_IO_STROKE,

60.0288, 99.2784, 83.1168, 94.6608, GAMGI_IO_STROKE,

69.2640, 99.2784, 83.1168, 90.0432, GAMGI_IO_STROKE,

73.8816, 99.2784, 83.1168, 85.4256, GAMGI_IO_STROKE,

78.4992, 99.2784, 83.1168, 71.5728, GAMGI_IO_STROKE,

41.5584, 6.9264, 32.3232, 2.3088, GAMGI_IO_STROKE,

41.5584, 11.5440, 36.9408, 2.3088, GAMGI_IO_STROKE,

50.7936, 11.5440, 55.4112, 2.3088, GAMGI_IO_STROKE,

50.7936, 6.9264, 60.0288, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 85 U strokes: 15 *
 *************************/

13.8528, 99.2784, 46.1760, 48.4848, 46.1760, 2.3088, GAMGI_IO_STROKE,

18.4704, 99.2784, 50.7936, 48.4848, 50.7936, 6.9264, GAMGI_IO_STROKE,

23.0880, 99.2784, 55.4112, 48.4848, 55.4112, 2.3088, GAMGI_IO_STROKE,

83.1168, 94.6608, 55.4112, 48.4848, GAMGI_IO_STROKE,

4.6176, 99.2784, 36.9408, 99.2784, GAMGI_IO_STROKE,

69.2640, 99.2784, 96.9696, 99.2784, GAMGI_IO_STROKE,

32.3232, 2.3088, 69.2640, 2.3088, GAMGI_IO_STROKE,

9.2352, 99.2784, 18.4704, 94.6608, GAMGI_IO_STROKE,

32.3232, 99.2784, 23.0880, 94.6608, GAMGI_IO_STROKE,

73.8816, 99.2784, 83.1168, 94.6608, GAMGI_IO_STROKE,

92.3520, 99.2784, 83.1168, 94.6608, GAMGI_IO_STROKE,

46.1760, 6.9264, 36.9408, 2.3088, GAMGI_IO_STROKE,

46.1760, 11.5440, 41.5584, 2.3088, GAMGI_IO_STROKE,

55.4112, 11.5440, 60.0288, 2.3088, GAMGI_IO_STROKE,

55.4112, 6.9264, 64.6464, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 86 V strokes: 4 *
 *************************/

55.4112, 66.9552, 64.6464, 62.3376, 73.8816, 53.1024, 78.4992, 53.1024, 78.4992, 57.7200, 69.2640, 62.3376, 55.4112, 66.9552, 36.9408, 66.9552, 23.0880, 62.3376, 18.4704, 57.7200, 13.8528, 48.4848, 13.8528, 39.2496, 18.4704, 30.0144, 27.7056, 20.7792, 36.9408, 16.1616, 46.1760, 11.5440, 50.7936, 6.9264, 55.4112, -2.3088, 55.4112, -11.5440, 50.7936, -16.1616, 41.5584, -16.1616, 32.3232, -11.5440, 36.9408, -11.5440, 41.5584, -16.1616, GAMGI_IO_STROKE,

23.0880, 57.7200, 18.4704, 48.4848, 18.4704, 39.2496, 23.0880, 30.0144, 32.3232, 20.7792, GAMGI_IO_STROKE,

36.9408, 66.9552, 27.7056, 62.3376, 23.0880, 53.1024, 23.0880, 39.2496, 27.7056, 30.0144, 46.1760, 11.5440, GAMGI_IO_STROKE,

78.4992, 53.1024, 73.8816, 57.7200, GAMGI_IO_CHAR,

/*************************
 * char: 87 W strokes: 7 *
 *************************/

32.3232, 11.5440, 18.4704, 11.5440, 13.8528, 20.7792, 18.4704, 2.3088, 36.9408, 2.3088, 27.7056, 25.3968, 18.4704, 43.8672, 13.8528, 57.7200, 13.8528, 71.5728, 18.4704, 85.4256, 27.7056, 94.6608, 41.5584, 99.2784, 60.0288, 99.2784, 73.8816, 94.6608, 83.1168, 85.4256, 87.7344, 71.5728, 87.7344, 57.7200, 83.1168, 43.8672, 73.8816, 25.3968, 64.6464, 2.3088, 83.1168, 2.3088, 87.7344, 20.7792, 83.1168, 11.5440, 69.2640, 11.5440, GAMGI_IO_STROKE,

23.0880, 39.2496, 18.4704, 57.7200, 18.4704, 71.5728, 23.0880, 85.4256, GAMGI_IO_STROKE,

78.4992, 85.4256, 83.1168, 71.5728, 83.1168, 57.7200, 78.4992, 39.2496, GAMGI_IO_STROKE,

36.9408, 2.3088, 27.7056, 30.0144, 23.0880, 53.1024, 23.0880, 76.1904, 27.7056, 90.0432, 32.3232, 94.6608, 41.5584, 99.2784, GAMGI_IO_STROKE,

60.0288, 99.2784, 69.2640, 94.6608, 73.8816, 90.0432, 78.4992, 76.1904, 78.4992, 53.1024, 73.8816, 30.0144, 64.6464, 2.3088, GAMGI_IO_STROKE,

18.4704, 6.9264, 32.3232, 6.9264, GAMGI_IO_STROKE,

69.2640, 6.9264, 83.1168, 6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 88 X strokes: 34 *
 *************************/

13.8528, 103.8960, 13.8528, 71.5728, GAMGI_IO_STROKE,

87.7344, 103.8960, 87.7344, 71.5728, GAMGI_IO_STROKE,

36.9408, 66.9552, 36.9408, 34.6320, GAMGI_IO_STROKE,

64.6464, 66.9552, 64.6464, 34.6320, GAMGI_IO_STROKE,

13.8528, 30.0144, 13.8528, -2.3088, GAMGI_IO_STROKE,

87.7344, 30.0144, 87.7344, -2.3088, GAMGI_IO_STROKE,

13.8528, 94.6608, 87.7344, 94.6608, GAMGI_IO_STROKE,

13.8528, 90.0432, 87.7344, 90.0432, GAMGI_IO_STROKE,

13.8528, 85.4256, 87.7344, 85.4256, GAMGI_IO_STROKE,

36.9408, 53.1024, 64.6464, 53.1024, GAMGI_IO_STROKE,

36.9408, 48.4848, 64.6464, 48.4848, GAMGI_IO_STROKE,

13.8528, 16.1616, 87.7344, 16.1616, GAMGI_IO_STROKE,

13.8528, 11.5440, 87.7344, 11.5440, GAMGI_IO_STROKE,

13.8528, 6.9264, 87.7344, 6.9264, GAMGI_IO_STROKE,

13.8528, 99.2784, 27.7056, 90.0432, GAMGI_IO_STROKE,

87.7344, 99.2784, 73.8816, 90.0432, GAMGI_IO_STROKE,

18.4704, 85.4256, 13.8528, 76.1904, GAMGI_IO_STROKE,

23.0880, 85.4256, 13.8528, 80.8080, GAMGI_IO_STROKE,

78.4992, 85.4256, 87.7344, 80.8080, GAMGI_IO_STROKE,

83.1168, 85.4256, 87.7344, 76.1904, GAMGI_IO_STROKE,

36.9408, 62.3376, 41.5584, 53.1024, GAMGI_IO_STROKE,

36.9408, 57.7200, 46.1760, 53.1024, GAMGI_IO_STROKE,

64.6464, 62.3376, 60.0288, 53.1024, GAMGI_IO_STROKE,

64.6464, 57.7200, 55.4112, 53.1024, GAMGI_IO_STROKE,

41.5584, 48.4848, 36.9408, 39.2496, GAMGI_IO_STROKE,

46.1760, 48.4848, 36.9408, 43.8672, GAMGI_IO_STROKE,

55.4112, 48.4848, 64.6464, 43.8672, GAMGI_IO_STROKE,

60.0288, 48.4848, 64.6464, 39.2496, GAMGI_IO_STROKE,

13.8528, 25.3968, 18.4704, 16.1616, GAMGI_IO_STROKE,

13.8528, 20.7792, 23.0880, 16.1616, GAMGI_IO_STROKE,

87.7344, 20.7792, 78.4992, 16.1616, GAMGI_IO_STROKE,

87.7344, 25.3968, 83.1168, 16.1616, GAMGI_IO_STROKE,

27.7056, 11.5440, 13.8528, 2.3088, GAMGI_IO_STROKE,

73.8816, 11.5440, 87.7344, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 89 Y strokes: 18 *
 *************************/

50.7936, 99.2784, 50.7936, 2.3088, GAMGI_IO_STROKE,

55.4112, 94.6608, 55.4112, 6.9264, GAMGI_IO_STROKE,

60.0288, 99.2784, 60.0288, 2.3088, GAMGI_IO_STROKE,

36.9408, 99.2784, 73.8816, 99.2784, GAMGI_IO_STROKE,

36.9408, 2.3088, 73.8816, 2.3088, GAMGI_IO_STROKE,

41.5584, 99.2784, 50.7936, 94.6608, GAMGI_IO_STROKE,

46.1760, 99.2784, 50.7936, 90.0432, GAMGI_IO_STROKE,

64.6464, 99.2784, 60.0288, 90.0432, GAMGI_IO_STROKE,

69.2640, 99.2784, 60.0288, 94.6608, GAMGI_IO_STROKE,

50.7936, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 11.5440, 46.1760, 2.3088, GAMGI_IO_STROKE,

60.0288, 11.5440, 64.6464, 2.3088, GAMGI_IO_STROKE,

60.0288, 6.9264, 69.2640, 2.3088, GAMGI_IO_STROKE,

9.2352, 66.9552, 13.8528, 66.9552, 18.4704, 62.3376, 23.0880, 48.4848, 27.7056, 39.2496, 32.3232, 34.6320, 46.1760, 30.0144, 64.6464, 30.0144, 78.4992, 34.6320, 83.1168, 39.2496, 87.7344, 48.4848, 92.3520, 62.3376, 96.9696, 66.9552, 101.5872, 66.9552, GAMGI_IO_STROKE,

27.7056, 43.8672, 23.0880, 62.3376, 18.4704, 71.5728, 13.8528, 71.5728, 23.0880, 62.3376, GAMGI_IO_STROKE,

9.2352, 66.9552, 13.8528, 76.1904, 18.4704, 76.1904, 23.0880, 71.5728, 27.7056, 53.1024, 32.3232, 39.2496, 36.9408, 34.6320, 46.1760, 30.0144, GAMGI_IO_STROKE,

87.7344, 62.3376, 96.9696, 71.5728, 92.3520, 71.5728, 87.7344, 62.3376, 83.1168, 43.8672, GAMGI_IO_STROKE,

64.6464, 30.0144, 73.8816, 34.6320, 78.4992, 39.2496, 83.1168, 53.1024, 87.7344, 71.5728, 92.3520, 76.1904, 96.9696, 76.1904, 101.5872, 66.9552, GAMGI_IO_CHAR,

/*************************
 * char: 90 Z strokes: 13 *
 *************************/

78.4992, 99.2784, 13.8528, 99.2784, 13.8528, 71.5728, GAMGI_IO_STROKE,

69.2640, 99.2784, 13.8528, 2.3088, GAMGI_IO_STROKE,

73.8816, 99.2784, 18.4704, 2.3088, GAMGI_IO_STROKE,

78.4992, 99.2784, 23.0880, 2.3088, GAMGI_IO_STROKE,

13.8528, 2.3088, 78.4992, 2.3088, 78.4992, 30.0144, GAMGI_IO_STROKE,

18.4704, 99.2784, 13.8528, 71.5728, GAMGI_IO_STROKE,

23.0880, 99.2784, 13.8528, 85.4256, GAMGI_IO_STROKE,

27.7056, 99.2784, 13.8528, 90.0432, GAMGI_IO_STROKE,

36.9408, 99.2784, 13.8528, 94.6608, GAMGI_IO_STROKE,

55.4112, 2.3088, 78.4992, 6.9264, GAMGI_IO_STROKE,

64.6464, 2.3088, 78.4992, 11.5440, GAMGI_IO_STROKE,

69.2640, 2.3088, 78.4992, 16.1616, GAMGI_IO_STROKE,

73.8816, 2.3088, 78.4992, 30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 91 [ strokes: 4 *
 *************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_STROKE,

23.0880, 117.7488, 23.0880, -30.0144, GAMGI_IO_STROKE,

18.4704, 117.7488, 50.7936, 117.7488, GAMGI_IO_STROKE,

18.4704, -30.0144, 50.7936, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 92 \ strokes: 3 *
 *************************/

60.0288, 85.4256, 55.4112, 80.8080, 60.0288, 76.1904, 64.6464, 80.8080, 60.0288, 85.4256, GAMGI_IO_STROKE,

18.4704, 11.5440, 13.8528, 6.9264, 18.4704, 2.3088, 23.0880, 6.9264, 18.4704, 11.5440, GAMGI_IO_STROKE,

101.5872, 11.5440, 96.9696, 6.9264, 101.5872, 2.3088, 106.2048, 6.9264, 101.5872, 11.5440, GAMGI_IO_CHAR,

/*************************
 * char: 93 ] strokes: 4 *
 *************************/

41.5584, 117.7488, 41.5584, -30.0144, GAMGI_IO_STROKE,

46.1760, 117.7488, 46.1760, -30.0144, GAMGI_IO_STROKE,

13.8528, 117.7488, 46.1760, 117.7488, GAMGI_IO_STROKE,

13.8528, -30.0144, 46.1760, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 94 ^ strokes: 2 *
 *************************/

55.4112, 117.7488, 55.4112, 2.3088, GAMGI_IO_STROKE,

13.8528, 2.3088, 96.9696, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 95 _ strokes: 1 *
 *************************/

9.2352, -6.9264, 92.3520, -6.9264, GAMGI_IO_CHAR,

/*************************
 * char: 96 ` strokes: 1 *
 *************************/

18.4704, 117.7488, 92.3520, 117.7488, GAMGI_IO_CHAR,
/*152.3808, 154.6896, 263.2032, 154.6896, GAMGI_IO_CHAR,*/

/*************************
 * char: 97 a strokes: 5 *
 *************************/

92.3520, 66.9552, 87.7344, 48.4848, 83.1168, 34.6320, 73.8816, 16.1616, 64.6464, 6.9264, 50.7936, 2.3088, 41.5584, 2.3088, 27.7056, 6.9264, 18.4704, 16.1616, 13.8528, 30.0144, 13.8528, 39.2496, 18.4704, 53.1024, 27.7056, 62.3376, 41.5584, 66.9552, 50.7936, 66.9552, 64.6464, 62.3376, 69.2640, 57.7200, 73.8816, 48.4848, 83.1168, 16.1616, 87.7344, 6.9264, 92.3520, 2.3088, 96.9696, 2.3088, GAMGI_IO_STROKE,

87.7344, 66.9552, 83.1168, 48.4848, 78.4992, 34.6320, 73.8816, 25.3968, 64.6464, 11.5440, 60.0288, 6.9264, 50.7936, 2.3088, GAMGI_IO_STROKE,

23.0880, 16.1616, 18.4704, 25.3968, 18.4704, 43.8672, 23.0880, 53.1024, GAMGI_IO_STROKE,

41.5584, 2.3088, 32.3232, 6.9264, 27.7056, 11.5440, 23.0880, 25.3968, 23.0880, 43.8672, 27.7056, 57.7200, 32.3232, 62.3376, 41.5584, 66.9552, GAMGI_IO_STROKE,

50.7936, 66.9552, 60.0288, 62.3376, 64.6464, 57.7200, 69.2640, 48.4848, 78.4992, 16.1616, 83.1168, 6.9264, 92.3520, 2.3088, GAMGI_IO_CHAR,

/*************************
 * char: 98 b strokes: 10 *
 *************************/

46.1760, 99.2784, 32.3232, 94.6608, 27.7056, 90.0432, 23.0880, 80.8080, 18.4704, 62.3376, 18.4704, -30.0144, GAMGI_IO_STROKE,

32.3232, 90.0432, 27.7056, 80.8080, 23.0880, 62.3376, 23.0880, -25.3968, GAMGI_IO_STROKE,

46.1760, 99.2784, 36.9408, 94.6608, 32.3232, 85.4256, 27.7056, 62.3376, 27.7056, -30.0144, GAMGI_IO_STROKE,

46.1760, 99.2784, 55.4112, 99.2784, 69.2640, 94.6608, 73.8816, 90.0432, 78.4992, 80.8080, 78.4992, 71.5728, 73.8816, 62.3376, 69.2640, 57.7200, 55.4112, 53.1024, GAMGI_IO_STROKE,

41.5584, 53.1024, 60.0288, 53.1024, 73.8816, 48.4848, 78.4992, 43.8672, 83.1168, 34.6320, 83.1168, 20.7792, 78.4992, 11.5440, 73.8816, 6.9264, 60.0288, 2.3088, 46.1760, 2.3088, 36.9408, 6.9264, 32.3232, 11.5440, 27.7056, 20.7792, GAMGI_IO_STROKE,

69.2640, 90.0432, 73.8816, 80.8080, 73.8816, 71.5728, 69.2640, 62.3376, GAMGI_IO_STROKE,

73.8816, 43.8672, 78.4992, 34.6320, 78.4992, 20.7792, 73.8816, 11.5440, GAMGI_IO_STROKE,

55.4112, 99.2784, 64.6464, 94.6608, 69.2640, 85.4256, 69.2640, 66.9552, 64.6464, 57.7200, 55.4112, 53.1024, GAMGI_IO_STROKE,

60.0288, 53.1024, 69.2640, 48.4848, 73.8816, 39.2496, 73.8816, 16.1616, 69.2640, 6.9264, 60.0288, 2.3088, GAMGI_IO_STROKE,

18.4704, -30.0144, 27.7056, -30.0144, GAMGI_IO_CHAR,

/*************************
 * char: 99 c strokes: 4 *
 *************************/

18.4704, 66.9552, 23.0880, 62.3376, 27.7056, 53.1024, 55.4112, -16.1616, 64.6464, -25.3968, 73.8816, -30.0144, 83.1168, -30.0144, 87.7344, -25.3968, GAMGI_IO_STROKE,

27.7056, 57.7200, 32.3232, 53.1024, 60.0288, -16.1616, 64.6464, -20.7792, GAMGI_IO_STROKE,

4.6176, 62.3376, 9.2352, 66.9552, 18.4704, 66.9552, 27.7056, 62.3376, 36.9408, 53.1024, 64.6464, -16.1616, 69.2640, -25.3968, 73.8816, -30.0144, GAMGI_IO_STROKE,

64.6464, 39.2496, 73.8816, 53.1024, 78.4992, 66.9552, 83.1168, 66.9552, 78.4992, 57.7200, 64.6464, 39.2496, 27.7056, -2.3088, 13.8528, -20.7792, 9.2352, -30.0144, 13.8528, -30.0144, 18.4704, -16.1616, 27.7056, -2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 100 d strokes: 5 *
 **************************/

50.7936, 66.9552, 41.5584, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 30.0144, 78.4992, 39.2496, 73.8816, 53.1024, 64.6464, 62.3376, 50.7936, 66.9552, 36.9408, 71.5728, 27.7056, 76.1904, 23.0880, 80.8080, 23.0880, 90.0432, 27.7056, 94.6608, 36.9408, 99.2784, 50.7936, 99.2784, 69.2640, 90.0432, GAMGI_IO_STROKE,

23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 30.0144, 23.0880, 16.1616, GAMGI_IO_STROKE,

69.2640, 16.1616, 73.8816, 30.0144, 73.8816, 39.2496, 69.2640, 53.1024, GAMGI_IO_STROKE,

41.5584, 66.9552, 32.3232, 62.3376, 27.7056, 57.7200, 23.0880, 43.8672, 23.0880, 25.3968, 27.7056, 11.5440, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 11.5440, 69.2640, 25.3968, 69.2640, 43.8672, 64.6464, 57.7200, 60.0288, 62.3376, 32.3232, 76.1904, 27.7056, 80.8080, 27.7056, 85.4256, 32.3232, 90.0432, 41.5584, 94.6608, 55.4112, 94.6608, 69.2640, 90.0432, GAMGI_IO_CHAR,

/**************************
 * char: 101 e strokes: 6 *
 **************************/

46.1760, 66.9552, 55.4112, 62.3376, 60.0288, 57.7200, 64.6464, 57.7200, 60.0288, 62.3376, 46.1760, 66.9552, 36.9408, 66.9552, 18.4704, 62.3376, 13.8528, 57.7200, 13.8528, 48.4848, 18.4704, 43.8672, 36.9408, 39.2496, GAMGI_IO_STROKE,

46.1760, 39.2496, 36.9408, 39.2496, 18.4704, 34.6320, 9.2352, 25.3968, 9.2352, 16.1616, 18.4704, 6.9264, 32.3232, 2.3088, 46.1760, 2.3088, 60.0288, 6.9264, 69.2640, 16.1616, 64.6464, 16.1616, 60.0288, 6.9264, GAMGI_IO_STROKE,

23.0880, 62.3376, 18.4704, 57.7200, 18.4704, 48.4848, 23.0880, 43.8672, GAMGI_IO_STROKE,

18.4704, 30.0144, 13.8528, 25.3968, 13.8528, 16.1616, 18.4704, 11.5440, GAMGI_IO_STROKE,

36.9408, 66.9552, 27.7056, 62.3376, 23.0880, 57.7200, 23.0880, 48.4848, 27.7056, 43.8672, 36.9408, 39.2496, GAMGI_IO_STROKE,

36.9408, 39.2496, 23.0880, 34.6320, 18.4704, 25.3968, 18.4704, 16.1616, 23.0880, 6.9264, 32.3232, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 102 f strokes: 9 *
 **************************/

41.5584, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 60.0288, 2.3088, 73.8816, 6.9264, 83.1168, 16.1616, 87.7344, 30.0144, 87.7344, 39.2496, 83.1168, 53.1024, 73.8816, 62.3376, 60.0288, 66.9552, 41.5584, 66.9552, GAMGI_IO_STROKE,

23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 30.0144, 23.0880, 16.1616, GAMGI_IO_STROKE,

78.4992, 16.1616, 83.1168, 30.0144, 83.1168, 39.2496, 78.4992, 53.1024, GAMGI_IO_STROKE,

41.5584, 66.9552, 32.3232, 62.3376, 27.7056, 57.7200, 23.0880, 43.8672, 23.0880, 25.3968, 27.7056, 11.5440, 32.3232, 6.9264, 41.5584, 2.3088, 60.0288, 2.3088, 69.2640, 6.9264, 73.8816, 11.5440, 78.4992, 25.3968, 78.4992, 43.8672, 73.8816, 57.7200, 69.2640, 62.3376, 60.0288, 66.9552, GAMGI_IO_STROKE,

46.1760, 99.2784, 55.4112, -30.0144, GAMGI_IO_STROKE,

50.7936, 94.6608, 50.7936, -25.3968, GAMGI_IO_STROKE,

55.4112, 99.2784, 46.1760, -30.0144, GAMGI_IO_STROKE,

46.1760, 99.2784, 55.4112, 99.2784, GAMGI_IO_STROKE,

46.1760, -30.0144, 55.4112, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 103 g strokes: 8 *
 **************************/

9.2352, 43.8672, 13.8528, 62.3376, 23.0880, 66.9552, 32.3232, 66.9552, 41.5584, 62.3376, 46.1760, 57.7200, 50.7936, 43.8672, 55.4112, 11.5440, 60.0288, -30.0144, GAMGI_IO_STROKE,

13.8528, 57.7200, 23.0880, 62.3376, 32.3232, 62.3376, 41.5584, 57.7200, 46.1760, 53.1024, GAMGI_IO_STROKE,

9.2352, 43.8672, 13.8528, 53.1024, 23.0880, 57.7200, 32.3232, 57.7200, 41.5584, 53.1024, 46.1760, 48.4848, 50.7936, 34.6320, 55.4112, 11.5440, 55.4112, -25.3968, GAMGI_IO_STROKE,

83.1168, 66.9552, 78.4992, 53.1024, 73.8816, 43.8672, 64.6464, 30.0144, 60.0288, 20.7792, 55.4112, 2.3088, 50.7936, -30.0144, GAMGI_IO_STROKE,

87.7344, 66.9552, 78.4992, 48.4848, GAMGI_IO_STROKE,

92.3520, 66.9552, 87.7344, 57.7200, 78.4992, 43.8672, 64.6464, 25.3968, 60.0288, 16.1616, 55.4112, 2.3088, GAMGI_IO_STROKE,

83.1168, 66.9552, 92.3520, 66.9552, GAMGI_IO_STROKE,

50.7936, -30.0144, 60.0288, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 104 h strokes: 8 *
 **************************/

13.8528, 66.9552, 18.4704, 62.3376, 23.0880, 53.1024, 23.0880, 2.3088, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 62.3376, 27.7056, 53.1024, 27.7056, 6.9264, GAMGI_IO_STROKE,

4.6176, 53.1024, 9.2352, 62.3376, 13.8528, 66.9552, 23.0880, 66.9552, 27.7056, 62.3376, 32.3232, 53.1024, 32.3232, 2.3088, GAMGI_IO_STROKE,

64.6464, 66.9552, 69.2640, 62.3376, 73.8816, 48.4848, 73.8816, -30.0144, GAMGI_IO_STROKE,

73.8816, 57.7200, 78.4992, 43.8672, 78.4992, -25.3968, GAMGI_IO_STROKE,

32.3232, 48.4848, 36.9408, 57.7200, 41.5584, 62.3376, 50.7936, 66.9552, 64.6464, 66.9552, 73.8816, 62.3376, 78.4992, 57.7200, 83.1168, 43.8672, 83.1168, -30.0144, GAMGI_IO_STROKE,

23.0880, 2.3088, 32.3232, 2.3088, GAMGI_IO_STROKE,

73.8816, -30.0144, 83.1168, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 105 i strokes: 3 *
 **************************/

13.8528, 66.9552, 18.4704, 62.3376, 23.0880, 53.1024, 23.0880, 16.1616, 27.7056, 6.9264, 36.9408, 2.3088, 46.1760, 2.3088, 55.4112, 6.9264, 60.0288, 16.1616, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 62.3376, 27.7056, 53.1024, 27.7056, 16.1616, 32.3232, 6.9264, GAMGI_IO_STROKE,

4.6176, 53.1024, 9.2352, 62.3376, 13.8528, 66.9552, 23.0880, 66.9552, 27.7056, 62.3376, 32.3232, 53.1024, 32.3232, 16.1616, 36.9408, 6.9264, 41.5584, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 106 j strokes: 9 *
 **************************/

50.7936, 48.4848, 46.1760, 62.3376, 41.5584, 66.9552, 32.3232, 66.9552, 23.0880, 62.3376, 18.4704, 57.7200, 13.8528, 43.8672, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 60.0288, 2.3088, 73.8816, 6.9264, 83.1168, 16.1616, 87.7344, 30.0144, 87.7344, 43.8672, 83.1168, 57.7200, 78.4992, 62.3376, 69.2640, 66.9552, 60.0288, 66.9552, 55.4112, 62.3376, 50.7936, 48.4848, GAMGI_IO_STROKE,

23.0880, 57.7200, 18.4704, 43.8672, 18.4704, 30.0144, 23.0880, 16.1616, GAMGI_IO_STROKE,

78.4992, 16.1616, 83.1168, 30.0144, 83.1168, 43.8672, 78.4992, 57.7200, GAMGI_IO_STROKE,

32.3232, 66.9552, 27.7056, 62.3376, 23.0880, 48.4848, 23.0880, 25.3968, 27.7056, 11.5440, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

60.0288, 2.3088, 69.2640, 6.9264, 73.8816, 11.5440, 78.4992, 25.3968, 78.4992, 48.4848, 73.8816, 62.3376, 69.2640, 66.9552, GAMGI_IO_STROKE,

50.7936, 48.4848, 46.1760, -30.0144, GAMGI_IO_STROKE,

50.7936, 48.4848, 50.7936, -25.3968, GAMGI_IO_STROKE,

50.7936, 48.4848, 55.4112, -30.0144, GAMGI_IO_STROKE,

46.1760, -30.0144, 55.4112, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 107 k strokes: 9 *
 **************************/

13.8528, 66.9552, 18.4704, 62.3376, 23.0880, 53.1024, 23.0880, 2.3088, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 62.3376, 27.7056, 53.1024, 27.7056, 6.9264, GAMGI_IO_STROKE,

4.6176, 53.1024, 9.2352, 62.3376, 13.8528, 66.9552, 23.0880, 66.9552, 27.7056, 62.3376, 32.3232, 53.1024, 32.3232, 2.3088, GAMGI_IO_STROKE,

55.4112, 57.7200, 64.6464, 62.3376, 73.8816, 62.3376, 78.4992, 57.7200, 78.4992, 53.1024, 87.7344, 53.1024, 87.7344, 62.3376, 78.4992, 66.9552, 69.2640, 66.9552, 60.0288, 62.3376, 46.1760, 48.4848, 36.9408, 34.6320, 32.3232, 20.7792, GAMGI_IO_STROKE,

78.4992, 62.3376, 83.1168, 57.7200, 83.1168, 53.1024, GAMGI_IO_STROKE,

41.5584, 39.2496, 46.1760, 39.2496, 73.8816, 11.5440, 83.1168, 11.5440, 87.7344, 16.1616, GAMGI_IO_STROKE,

60.0288, 20.7792, 73.8816, 6.9264, 83.1168, 6.9264, GAMGI_IO_STROKE,

50.7936, 34.6320, 64.6464, 6.9264, 69.2640, 2.3088, 78.4992, 2.3088, 83.1168, 6.9264, 87.7344, 16.1616, GAMGI_IO_STROKE,

23.0880, 2.3088, 32.3232, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 108 l strokes: 4 *
 **************************/

9.2352, 94.6608, 13.8528, 99.2784, 23.0880, 99.2784, 32.3232, 94.6608, 41.5584, 85.4256, 73.8816, 16.1616, 78.4992, 6.9264, 83.1168, 2.3088, GAMGI_IO_STROKE,

32.3232, 90.0432, 36.9408, 85.4256, 69.2640, 16.1616, 73.8816, 11.5440, GAMGI_IO_STROKE,

23.0880, 99.2784, 27.7056, 94.6608, 32.3232, 85.4256, 64.6464, 16.1616, 73.8816, 6.9264, 83.1168, 2.3088, 87.7344, 2.3088, GAMGI_IO_STROKE,

46.1760, 66.9552, 9.2352, 6.9264, 9.2352, 2.3088, 13.8528, 2.3088, 46.1760, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 109 m strokes: 10 *
 **************************/

18.4704, 66.9552, 18.4704, -30.0144, GAMGI_IO_STROKE,

23.0880, 62.3376, 23.0880, -25.3968, GAMGI_IO_STROKE,

27.7056, 66.9552, 27.7056, -30.0144, GAMGI_IO_STROKE,

69.2640, 66.9552, 69.2640, 16.1616, 73.8816, 6.9264, 78.4992, 2.3088, 87.7344, 2.3088, 92.3520, 6.9264, 96.9696, 16.1616, GAMGI_IO_STROKE,

73.8816, 62.3376, 73.8816, 16.1616, 78.4992, 6.9264, 83.1168, 2.3088, GAMGI_IO_STROKE,

78.4992, 66.9552, 78.4992, 16.1616, 83.1168, 6.9264, 87.7344, 2.3088, GAMGI_IO_STROKE,

27.7056, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 11.5440, 69.2640, 20.7792, GAMGI_IO_STROKE,

18.4704, 66.9552, 27.7056, 66.9552, GAMGI_IO_STROKE,

69.2640, 66.9552, 78.4992, 66.9552, GAMGI_IO_STROKE,

18.4704, -30.0144, 27.7056, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 110 n strokes: 5 *
 **************************/

13.8528, 66.9552, 18.4704, 62.3376, 23.0880, 53.1024, 27.7056, 34.6320, 32.3232, 2.3088, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 62.3376, 27.7056, 53.1024, 32.3232, 34.6320, 36.9408, 6.9264, GAMGI_IO_STROKE,

4.6176, 53.1024, 9.2352, 62.3376, 13.8528, 66.9552, 23.0880, 66.9552, 27.7056, 62.3376, 32.3232, 53.1024, 36.9408, 34.6320, 41.5584, 6.9264, GAMGI_IO_STROKE,

69.2640, 25.3968, 73.8816, 34.6320, 78.4992, 48.4848, 78.4992, 66.9552, 83.1168, 66.9552, 87.7344, 62.3376, 83.1168, 48.4848, 78.4992, 39.2496, 69.2640, 25.3968, 60.0288, 16.1616, 46.1760, 6.9264, 32.3232, 2.3088, GAMGI_IO_STROKE,

78.4992, 43.8672, 83.1168, 57.7200, 83.1168, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 111 o strokes: 5 *
 **************************/

41.5584, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 30.0144, 78.4992, 39.2496, 73.8816, 53.1024, 64.6464, 62.3376, 50.7936, 66.9552, 41.5584, 66.9552, GAMGI_IO_STROKE,

23.0880, 53.1024, 18.4704, 43.8672, 18.4704, 25.3968, 23.0880, 16.1616, GAMGI_IO_STROKE,

69.2640, 16.1616, 73.8816, 25.3968, 73.8816, 43.8672, 69.2640, 53.1024, GAMGI_IO_STROKE,

41.5584, 66.9552, 32.3232, 62.3376, 27.7056, 57.7200, 23.0880, 43.8672, 23.0880, 25.3968, 27.7056, 11.5440, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 11.5440, 69.2640, 25.3968, 69.2640, 43.8672, 64.6464, 57.7200, 60.0288, 62.3376, 50.7936, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 112 p strokes: 8 *
 **************************/

9.2352, 48.4848, 13.8528, 57.7200, 18.4704, 62.3376, 27.7056, 66.9552, 92.3520, 66.9552, GAMGI_IO_STROKE,

18.4704, 57.7200, 27.7056, 62.3376, 87.7344, 62.3376, GAMGI_IO_STROKE,

9.2352, 48.4848, 13.8528, 53.1024, 23.0880, 57.7200, 92.3520, 57.7200, GAMGI_IO_STROKE,

36.9408, 57.7200, 32.3232, 6.9264, 27.7056, 2.3088, 23.0880, 6.9264, 27.7056, 20.7792, 36.9408, 57.7200, GAMGI_IO_STROKE,

64.6464, 57.7200, 69.2640, 6.9264, 73.8816, 2.3088, 78.4992, 6.9264, 73.8816, 20.7792, 64.6464, 57.7200, GAMGI_IO_STROKE,

92.3520, 66.9552, 92.3520, 57.7200, GAMGI_IO_STROKE,

36.9408, 57.7200, 27.7056, 6.9264, GAMGI_IO_STROKE,

64.6464, 57.7200, 73.8816, 6.9264, GAMGI_IO_CHAR,

/**************************
 * char: 113 q strokes: 7 *
 **************************/

41.5584, 99.2784, 27.7056, 94.6608, 18.4704, 80.8080, 13.8528, 57.7200, 13.8528, 43.8672, 18.4704, 20.7792, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 20.7792, 78.4992, 43.8672, 78.4992, 57.7200, 73.8816, 80.8080, 64.6464, 94.6608, 50.7936, 99.2784, 41.5584, 99.2784, GAMGI_IO_STROKE,

27.7056, 90.0432, 23.0880, 80.8080, 18.4704, 62.3376, 18.4704, 39.2496, 23.0880, 20.7792, 27.7056, 11.5440, GAMGI_IO_STROKE,

64.6464, 11.5440, 69.2640, 20.7792, 73.8816, 39.2496, 73.8816, 62.3376, 69.2640, 80.8080, 64.6464, 90.0432, GAMGI_IO_STROKE,

41.5584, 99.2784, 32.3232, 94.6608, 27.7056, 85.4256, 23.0880, 62.3376, 23.0880, 39.2496, 27.7056, 16.1616, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 16.1616, 69.2640, 39.2496, 69.2640, 62.3376, 64.6464, 85.4256, 60.0288, 94.6608, 50.7936, 99.2784, GAMGI_IO_STROKE,

18.4704, 53.1024, 73.8816, 48.4848, GAMGI_IO_STROKE,

18.4704, 48.4848, 73.8816, 53.1024, GAMGI_IO_CHAR,

/**************************
 * char: 114 r strokes: 7 *
 **************************/

46.1760, 66.9552, 32.3232, 62.3376, 23.0880, 53.1024, 18.4704, 34.6320, 18.4704, -30.0144, GAMGI_IO_STROKE,

27.7056, 53.1024, 23.0880, 34.6320, 23.0880, -25.3968, GAMGI_IO_STROKE,

46.1760, 66.9552, 36.9408, 62.3376, 32.3232, 57.7200, 27.7056, 39.2496, 27.7056, -30.0144, GAMGI_IO_STROKE,

27.7056, 20.7792, 32.3232, 11.5440, 36.9408, 6.9264, 46.1760, 2.3088, 55.4112, 2.3088, 69.2640, 6.9264, 78.4992, 16.1616, 83.1168, 30.0144, 83.1168, 39.2496, 78.4992, 53.1024, 69.2640, 62.3376, 55.4112, 66.9552, 46.1760, 66.9552, GAMGI_IO_STROKE,

73.8816, 16.1616, 78.4992, 25.3968, 78.4992, 43.8672, 73.8816, 53.1024, GAMGI_IO_STROKE,

55.4112, 2.3088, 64.6464, 6.9264, 69.2640, 11.5440, 73.8816, 25.3968, 73.8816, 43.8672, 69.2640, 57.7200, 64.6464, 62.3376, 55.4112, 66.9552, GAMGI_IO_STROKE,

18.4704, -30.0144, 27.7056, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 115 s strokes: 7 *
 **************************/

41.5584, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 30.0144, 18.4704, 16.1616, 27.7056, 6.9264, 41.5584, 2.3088, 50.7936, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 30.0144, 78.4992, 39.2496, 73.8816, 53.1024, 64.6464, 62.3376, 50.7936, 66.9552, GAMGI_IO_STROKE,

23.0880, 53.1024, 18.4704, 43.8672, 18.4704, 25.3968, 23.0880, 16.1616, GAMGI_IO_STROKE,

69.2640, 16.1616, 73.8816, 25.3968, 73.8816, 43.8672, 69.2640, 53.1024, GAMGI_IO_STROKE,

41.5584, 66.9552, 32.3232, 62.3376, 27.7056, 57.7200, 23.0880, 43.8672, 23.0880, 25.3968, 27.7056, 11.5440, 32.3232, 6.9264, 41.5584, 2.3088, GAMGI_IO_STROKE,

50.7936, 2.3088, 60.0288, 6.9264, 64.6464, 11.5440, 69.2640, 25.3968, 69.2640, 43.8672, 64.6464, 57.7200, 60.0288, 62.3376, 50.7936, 66.9552, GAMGI_IO_STROKE,

50.7936, 66.9552, 87.7344, 57.7200, 92.3520, 62.3376, 92.3520, 66.9552, 41.5584, 66.9552, GAMGI_IO_STROKE,

50.7936, 66.9552, 87.7344, 62.3376, GAMGI_IO_CHAR,

/**************************
 * char: 116 t strokes: 6 *
 **************************/

9.2352, 48.4848, 13.8528, 57.7200, 18.4704, 62.3376, 27.7056, 66.9552, 83.1168, 66.9552, GAMGI_IO_STROKE,

18.4704, 57.7200, 27.7056, 62.3376, 78.4992, 62.3376, GAMGI_IO_STROKE,

9.2352, 48.4848, 13.8528, 53.1024, 23.0880, 57.7200, 83.1168, 57.7200, GAMGI_IO_STROKE,

46.1760, 57.7200, 41.5584, 6.9264, 46.1760, 2.3088, 50.7936, 6.9264, 46.1760, 57.7200, GAMGI_IO_STROKE,

83.1168, 66.9552, 83.1168, 57.7200, GAMGI_IO_STROKE,

46.1760, 57.7200, 46.1760, 6.9264, GAMGI_IO_CHAR,

/**************************
 * char: 117 u strokes: 4 *
 **************************/

13.8528, 66.9552, 18.4704, 62.3376, 23.0880, 53.1024, 23.0880, 30.0144, 27.7056, 16.1616, 36.9408, 6.9264, 46.1760, 2.3088, 55.4112, 2.3088, 64.6464, 6.9264, 73.8816, 16.1616, 78.4992, 25.3968, 83.1168, 43.8672, 83.1168, 62.3376, 78.4992, 66.9552, 73.8816, 66.9552, 78.4992, 53.1024, 78.4992, 39.2496, 73.8816, 20.7792, 64.6464, 6.9264, GAMGI_IO_STROKE,

18.4704, 66.9552, 23.0880, 62.3376, 27.7056, 53.1024, 27.7056, 30.0144, 32.3232, 16.1616, GAMGI_IO_STROKE,

73.8816, 66.9552, 78.4992, 62.3376, 78.4992, 57.7200, GAMGI_IO_STROKE,

4.6176, 53.1024, 9.2352, 62.3376, 13.8528, 66.9552, 23.0880, 66.9552, 27.7056, 62.3376, 32.3232, 53.1024, 32.3232, 25.3968, 36.9408, 11.5440, 46.1760, 2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 118 v strokes: 6 *
 **************************/

36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 20.7792, 18.4704, 11.5440, 23.0880, 6.9264, 32.3232, 2.3088, 41.5584, 2.3088, 50.7936, 6.9264, 55.4112, 11.5440, 60.0288, 20.7792, 60.0288, 34.6320, 55.4112, 39.2496, 50.7936, 34.6320, 50.7936, 20.7792, 55.4112, 11.5440, 60.0288, 6.9264, 69.2640, 2.3088, 78.4992, 2.3088, 87.7344, 6.9264, 92.3520, 11.5440, 96.9696, 20.7792, 96.9696, 39.2496, 92.3520, 53.1024, 83.1168, 62.3376, 73.8816, 66.9552, GAMGI_IO_STROKE,

23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 20.7792, 23.0880, 11.5440, GAMGI_IO_STROKE,

55.4112, 34.6320, 55.4112, 16.1616, GAMGI_IO_STROKE,

87.7344, 11.5440, 92.3520, 20.7792, 92.3520, 39.2496, 87.7344, 53.1024, GAMGI_IO_STROKE,

36.9408, 66.9552, 27.7056, 57.7200, 23.0880, 43.8672, 23.0880, 20.7792, 27.7056, 6.9264, 32.3232, 2.3088, GAMGI_IO_STROKE,

78.4992, 2.3088, 83.1168, 6.9264, 87.7344, 20.7792, 87.7344, 43.8672, 83.1168, 57.7200, 73.8816, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 119 w strokes: 6 *
 **************************/

36.9408, 66.9552, 27.7056, 62.3376, 18.4704, 53.1024, 13.8528, 39.2496, 13.8528, 20.7792, 18.4704, 11.5440, 23.0880, 6.9264, 32.3232, 2.3088, 41.5584, 2.3088, 50.7936, 6.9264, 55.4112, 11.5440, 60.0288, 20.7792, 60.0288, 34.6320, 55.4112, 39.2496, 50.7936, 34.6320, 50.7936, 20.7792, 55.4112, 11.5440, 60.0288, 6.9264, 69.2640, 2.3088, 78.4992, 2.3088, 87.7344, 6.9264, 92.3520, 11.5440, 96.9696, 20.7792, 96.9696, 39.2496, 92.3520, 53.1024, 83.1168, 62.3376, 73.8816, 66.9552, GAMGI_IO_STROKE,

23.0880, 53.1024, 18.4704, 39.2496, 18.4704, 20.7792, 23.0880, 11.5440, GAMGI_IO_STROKE,

55.4112, 34.6320, 55.4112, 16.1616, GAMGI_IO_STROKE,

87.7344, 11.5440, 92.3520, 20.7792, 92.3520, 39.2496, 87.7344, 53.1024, GAMGI_IO_STROKE,

36.9408, 66.9552, 27.7056, 57.7200, 23.0880, 43.8672, 23.0880, 20.7792, 27.7056, 6.9264, 32.3232, 2.3088, GAMGI_IO_STROKE,

78.4992, 2.3088, 83.1168, 6.9264, 87.7344, 20.7792, 87.7344, 43.8672, 83.1168, 57.7200, 73.8816, 66.9552, GAMGI_IO_CHAR,

/**************************
 * char: 120 x strokes: 5 *
 **************************/

27.7056, 94.6608, 41.5584, 99.2784, 36.9408, 99.2784, 27.7056, 94.6608, 23.0880, 90.0432, 23.0880, 85.4256, 27.7056, 80.8080, 41.5584, 76.1904, 55.4112, 71.5728, 60.0288, 76.1904, 55.4112, 80.8080, 41.5584, 76.1904, 27.7056, 71.5728, 18.4704, 66.9552, 13.8528, 57.7200, 13.8528, 48.4848, 18.4704, 43.8672, 27.7056, 39.2496, 41.5584, 34.6320, 55.4112, 30.0144, 60.0288, 34.6320, 55.4112, 39.2496, 41.5584, 34.6320, 23.0880, 30.0144, 13.8528, 25.3968, 9.2352, 16.1616, 9.2352, 6.9264, 13.8528, 2.3088, 23.0880, -2.3088, 41.5584, -6.9264, 50.7936, -11.5440, 55.4112, -16.1616, 55.4112, -25.3968, 46.1760, -30.0144, 36.9408, -30.0144, 23.0880, -25.3968, 27.7056, -25.3968, 36.9408, -30.0144, GAMGI_IO_STROKE,

23.0880, 66.9552, 18.4704, 57.7200, 18.4704, 48.4848, 23.0880, 43.8672, GAMGI_IO_STROKE,

18.4704, 25.3968, 13.8528, 16.1616, 13.8528, 6.9264, 18.4704, 2.3088, GAMGI_IO_STROKE,

55.4112, 76.1904, 41.5584, 76.1904, 32.3232, 71.5728, 27.7056, 66.9552, 23.0880, 57.7200, 23.0880, 48.4848, 32.3232, 39.2496, 41.5584, 34.6320, GAMGI_IO_STROKE,

55.4112, 34.6320, 41.5584, 34.6320, 27.7056, 30.0144, 23.0880, 25.3968, 18.4704, 16.1616, 18.4704, 6.9264, 27.7056, -2.3088, 41.5584, -6.9264, GAMGI_IO_CHAR,

/**************************
 * char: 121 y strokes: 9 *
 **************************/

9.2352, 62.3376, 13.8528, 62.3376, 18.4704, 53.1024, 18.4704, 30.0144, 23.0880, 16.1616, 32.3232, 6.9264, 46.1760, 2.3088, 64.6464, 2.3088, 73.8816, 6.9264, 83.1168, 16.1616, 87.7344, 25.3968, 92.3520, 43.8672, 92.3520, 62.3376, 87.7344, 66.9552, 83.1168, 66.9552, 87.7344, 53.1024, 87.7344, 39.2496, 83.1168, 20.7792, 73.8816, 6.9264, GAMGI_IO_STROKE,

18.4704, 62.3376, 23.0880, 53.1024, 23.0880, 30.0144, 27.7056, 16.1616, GAMGI_IO_STROKE,

83.1168, 66.9552, 87.7344, 62.3376, 87.7344, 57.7200, GAMGI_IO_STROKE,

4.6176, 53.1024, 9.2352, 62.3376, 13.8528, 66.9552, 18.4704, 66.9552, 23.0880, 62.3376, 27.7056, 53.1024, 27.7056, 25.3968, 32.3232, 11.5440, 36.9408, 6.9264, 46.1760, 2.3088, GAMGI_IO_STROKE,

50.7936, 99.2784, 60.0288, -30.0144, GAMGI_IO_STROKE,

55.4112, 94.6608, 55.4112, -25.3968, GAMGI_IO_STROKE,

60.0288, 99.2784, 50.7936, -30.0144, GAMGI_IO_STROKE,

50.7936, 99.2784, 60.0288, 99.2784, GAMGI_IO_STROKE,

50.7936, -30.0144, 60.0288, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 122 z strokes: 3 *
 **************************/

36.9408, 90.0432, 41.5584, 94.6608, 41.5584, 99.2784, 36.9408, 99.2784, 32.3232, 94.6608, 32.3232, 85.4256, 36.9408, 80.8080, 50.7936, 76.1904, 69.2640, 76.1904, 73.8816, 76.1904, 73.8816, 80.8080, 69.2640, 80.8080, 55.4112, 76.1904, 46.1760, 71.5728, 32.3232, 62.3376, 23.0880, 53.1024, 18.4704, 43.8672, 13.8528, 30.0144, 13.8528, 20.7792, 18.4704, 11.5440, 23.0880, 6.9264, 32.3232, 2.3088, 46.1760, -2.3088, 55.4112, -6.9264, 60.0288, -16.1616, 60.0288, -25.3968, 55.4112, -30.0144, 46.1760, -30.0144, 41.5584, -25.3968, 41.5584, -20.7792, 46.1760, -20.7792, 46.1760, -25.3968, GAMGI_IO_STROKE,

32.3232, 57.7200, 27.7056, 53.1024, 23.0880, 43.8672, 18.4704, 30.0144, 18.4704, 20.7792, 23.0880, 11.5440, 27.7056, 6.9264, GAMGI_IO_STROKE,

55.4112, 76.1904, 41.5584, 66.9552, 36.9408, 62.3376, 27.7056, 48.4848, 23.0880, 34.6320, 23.0880, 20.7792, 27.7056, 11.5440, 36.9408, 2.3088, 46.1760, -2.3088, GAMGI_IO_CHAR,

/**************************
 * char: 123 { strokes: 3 *
 **************************/

46.1760, 117.7488, 32.3232, 103.8960, 27.7056, 90.0432, 27.7056, 80.8080, 32.3232, 66.9552, 41.5584, 57.7200, 41.5584, 53.1024, 23.0880, 43.8672, 41.5584, 34.6320, 41.5584, 30.0144, 32.3232, 20.7792, 27.7056, 6.9264, 27.7056, -2.3088, 32.3232, -16.1616, 46.1760, -30.0144, GAMGI_IO_STROKE,

36.9408, 108.5136, 32.3232, 94.6608, 32.3232, 76.1904, 36.9408, 62.3376, GAMGI_IO_STROKE,

36.9408, 25.3968, 32.3232, 11.5440, 32.3232, -6.9264, 36.9408, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 124 | strokes: 2 *
 **************************/

18.4704, 117.7488, 18.4704, -30.0144, GAMGI_IO_STROKE,

23.0880, 117.7488, 23.0880, -30.0144, GAMGI_IO_CHAR,

/**************************
 * char: 125 } strokes: 3 *
 **************************/

23.0880, 117.7488, 36.9408, 103.8960, 41.5584, 90.0432, 41.5584, 80.8080, 36.9408, 66.9552, 27.7056, 57.7200, 27.7056, 53.1024, 46.1760, 43.8672, 27.7056, 34.6320, 27.7056, 30.0144, 36.9408, 20.7792, 41.5584, 6.9264, 41.5584, -2.3088, 36.9408, -16.1616, 23.0880, -30.0144, GAMGI_IO_STROKE,

32.3232, 108.5136, 36.9408, 94.6608, 36.9408, 76.1904, 32.3232, 62.3376, GAMGI_IO_STROKE,

32.3232, 25.3968, 36.9408, 11.5440, 36.9408, -6.9264, 32.3232, -20.7792, GAMGI_IO_CHAR,

/**************************
 * char: 126 ~ strokes: 2 *
 **************************/

13.8528, 30.0144, 13.8528, 39.2496, 18.4704, 53.1024, 27.7056, 57.7200, 36.9408, 57.7200, 46.1760, 53.1024, 64.6464, 39.2496, 73.8816, 34.6320, 83.1168, 34.6320, 92.3520, 39.2496, 96.9696, 48.4848, GAMGI_IO_STROKE,

13.8528, 39.2496, 18.4704, 48.4848, 27.7056, 53.1024, 36.9408, 53.1024, 46.1760, 48.4848, 64.6464, 34.6320, 73.8816, 30.0144, 83.1168, 30.0144, 92.3520, 34.6320, 96.9696, 48.4848, 96.9696, 57.7200, GAMGI_IO_CHAR,

};

/***********
 * drivers *
 ***********/

const int gamgi_io_font_hershey_sans_driver[GAMGI_IO_ASCII_RANGE] = {
97, 98, 114, 124, 144, 195, 256, 325, 340, 
361, 382, 397, 407, 424, 429, 440, 445, 480, 489, 
518, 549, 561, 596, 643, 653, 712, 759, 781, 809, 
816, 826, 833, 873, 959, 974, 1019, 1056, 1086, 1106, 
1121, 1165, 1180, 1185, 1206, 1221, 1231, 1251, 1266, 1309, 
1335, 1383, 1414, 1455, 1465, 1486, 1496, 1516, 1526, 1538, 
1553, 1568, 1573, 1588, 1602, 1607, 1622, 1656, 1690, 1719, 
1753, 1788, 1804, 1848, 1868, 1884, 1906, 1921, 1926, 1961, 
1981, 2016, 2050, 2084, 2100, 2135, 2151, 2171, 2181, 2201, 
2211, 2229, 2244, 2275, 2280, 2311, 
};

const int gamgi_io_font_hershey_sans_bold_driver[GAMGI_IO_ASCII_RANGE] = {
97, 98, 142, 180, 236, 333, 455, 592, 636, 
682, 728, 797, 825, 869, 883, 913, 927, 1006, 1028, 
1092, 1180, 1211, 1308, 1425, 1446, 1577, 1694, 1754, 1828, 
1846, 1874, 1892, 2000, 2161, 2195, 2277, 2351, 2411, 2457, 
2493, 2579, 2617, 2631, 2669, 2707, 2731, 2775, 2809, 2887, 
2937, 3029, 3091, 3175, 3201, 3247, 3271, 3315, 3343, 3373, 
3407, 3427, 3441, 3461, 3475, 3480, 3524, 3592, 3660, 3722, 
3790, 3860, 3903, 3995, 4041, 4085, 4129, 4167, 4181, 4259, 
4305, 4375, 4443, 4511, 4549, 4641, 4669, 4715, 4739, 4783, 
4811, 4841, 4875, 4924, 4934, 4983, 
};

const int gamgi_io_font_hershey_serif_driver[GAMGI_IO_ASCII_RANGE] = {
97, 98, 125, 145, 165, 245, 306, 401, 416, 
454, 492, 507, 517, 532, 537, 548, 553, 630, 649, 
735, 825, 847, 920, 1013, 1070, 1190, 1283, 1305, 1331, 
1338, 1348, 1355, 1416, 1524, 1554, 1638, 1700, 1756, 1794, 
1828, 1903, 1948, 1968, 2005, 2050, 2074, 2124, 2159, 2244, 
2297, 2420, 2503, 2569, 2597, 2639, 2664, 2704, 2739, 2773, 
2801, 2821, 2826, 2846, 2860, 2865, 2880, 2954, 3015, 3069, 
3135, 3194, 3234, 3348, 3397, 3428, 3474, 3519, 3539, 3617, 
3666, 3735, 3801, 3862, 3903, 3965, 3994, 4043, 4068, 4108, 
4143, 4182, 4210, 4259, 4264, 4313, 
};

const int gamgi_io_font_hershey_serif_bold_driver[GAMGI_IO_ASCII_RANGE] = {
97, 98, 160, 198, 254, 361, 495, 635, 679, 
730, 781, 850, 878, 922, 936, 966, 980, 1075, 1122, 
1239, 1383, 1430, 1533, 1665, 1744, 1892, 2024, 2084, 2158, 
2176, 2204, 2222, 2320, 2450, 2510, 2649, 2720, 2830, 2970, 
3088, 3198, 3333, 3398, 3479, 3594, 3681, 3786, 3851, 3954, 
4057, 4203, 4345, 4430, 4525, 4604, 4661, 4754, 4844, 4925, 
4994, 5014, 5028, 5048, 5062, 5067, 5111, 5213, 5299, 5364, 
5458, 5535, 5606, 5774, 5886, 5959, 6033, 6135, 6187, 6359, 
6471, 6558, 6665, 6764, 6839, 6920, 6960, 7036, 7088, 7164, 
7244, 7314, 7383, 7432, 7442, 7491, 
};

const int gamgi_io_font_hershey_script_driver[GAMGI_IO_ASCII_RANGE] = {
97, 98, 114, 124, 144, 195, 256, 325, 340, 
361, 382, 397, 407, 424, 429, 440, 445, 480, 489, 
518, 549, 561, 596, 643, 653, 712, 759, 781, 809, 
816, 826, 833, 873, 959, 998, 1078, 1125, 1194, 1249, 
1302, 1359, 1433, 1482, 1531, 1606, 1663, 1750, 1812, 1869, 
1930, 1993, 2068, 2123, 2171, 2235, 2298, 2344, 2414, 2488, 
2567, 2582, 2587, 2602, 2616, 2621, 2636, 2679, 2724, 2751, 
2797, 2830, 2877, 2931, 2987, 3017, 3055, 3118, 3153, 3216, 
3260, 3305, 3350, 3402, 3431, 3461, 3490, 3526, 3558, 3605, 
3643, 3687, 3732, 3763, 3768, 3799, 
};

const int gamgi_io_font_hershey_script_bold_driver[GAMGI_IO_ASCII_RANGE] = {
97, 98, 128, 148, 168, 246, 307, 414, 429, 
467, 505, 520, 530, 545, 550, 561, 566, 647, 673, 
753, 849, 866, 939, 1028, 1083, 1203, 1292, 1312, 1338, 
1345, 1355, 1362, 1427, 1535, 1607, 1741, 1821, 1905, 1999, 
2087, 2189, 2295, 2359, 2425, 2537, 2615, 2707, 2779, 2845, 
2947, 3031, 3155, 3225, 3298, 3372, 3442, 3518, 3619, 3699, 
3784, 3804, 3809, 3829, 3843, 3848, 3863, 3925, 3968, 4010, 
4072, 4116, 4168, 4240, 4295, 4330, 4375, 4431, 4462, 4546, 
4606, 4662, 4717, 4783, 4827, 4868, 4904, 4954, 4997, 5064, 
5142, 5202, 5274, 5323, 5328, 5377, 
};

const int gamgi_io_font_hershey_gothic_english_driver[GAMGI_IO_ASCII_RANGE] = {
97, 98, 153, 191, 247, 399, 497, 679, 705, 
756, 807, 876, 904, 930, 944, 964, 978, 1054, 1104, 
1188, 1290, 1364, 1459, 1566, 1636, 1762, 1871, 1911, 1957, 
1975, 2003, 2021, 2120, 2250, 2359, 2557, 2685, 2816, 2987, 
3152, 3312, 3514, 3637, 3756, 3963, 4116, 4311, 4464, 4611, 
4738, 4922, 5119, 5293, 5425, 5588, 5720, 5891, 6008, 6166, 
6269, 6289, 6303, 6323, 6337, 6342, 6368, 6466, 6547, 6611, 
6686, 6744, 6818, 6922, 7010, 7075, 7148, 7239, 7280, 7405, 
7489, 7562, 7661, 7742, 7812, 7918, 7969, 8056, 8122, 8227, 
8334, 8445, 8513, 8562, 8572, 8621, 
};

const int gamgi_io_font_hershey_gothic_german_driver[GAMGI_IO_ASCII_RANGE] = {
97, 98, 160, 198, 254, 361, 495, 635, 679, 
730, 781, 850, 878, 922, 936, 966, 980, 1075, 1122, 
1239, 1383, 1430, 1533, 1665, 1744, 1892, 2024, 2084, 2158, 
2176, 2204, 2222, 2320, 2450, 2565, 2753, 2902, 3052, 3229, 
3405, 3591, 3762, 3920, 4078, 4227, 4365, 4605, 4785, 4921, 
5105, 5269, 5446, 5605, 5758, 5841, 6028, 6295, 6451, 6590, 
6729, 6749, 6763, 6783, 6797, 6802, 6846, 6930, 7022, 7072, 
7159, 7209, 7298, 7396, 7488, 7558, 7639, 7752, 7805, 7942, 
8032, 8107, 8210, 8288, 8346, 8422, 8488, 8575, 8662, 8796, 
8878, 8965, 9045, 9094, 9104, 9153, 
};

const int gamgi_io_font_hershey_gothic_italian_driver[GAMGI_IO_ASCII_RANGE] = {
97, 98, 160, 198, 254, 361, 495, 635, 679, 
730, 781, 850, 878, 922, 936, 966, 980, 1075, 1122, 
1239, 1383, 1430, 1533, 1665, 1744, 1892, 2024, 2084, 2158, 
2176, 2204, 2222, 2320, 2450, 2545, 2666, 2778, 2864, 3024, 
3151, 3319, 3411, 3452, 3529, 3658, 3740, 3866, 3955, 4058, 
4153, 4293, 4421, 4601, 4726, 4821, 4876, 5001, 5074, 5160, 
5298, 5318, 5332, 5352, 5366, 5371, 5415, 5492, 5548, 5589, 
5647, 5691, 5748, 5823, 5901, 5970, 6039, 6132, 6171, 6294, 
6376, 6426, 6511, 6567, 6624, 6697, 6746, 6820, 6886, 6995, 
7066, 7157, 7236, 7285, 7295, 7344, 
};

const int gamgi_io_font_hershey_symbol_sans_driver[GAMGI_IO_ASCII_RANGE] = {
97, 98, 114, 126, 146, 166, 227, 296, 326, 
347, 368, 383, 393, 410, 415, 426, 431, 466, 475, 
504, 535, 547, 582, 629, 639, 698, 745, 767, 795, 
802, 812, 819, 859, 911, 926, 971, 981, 996, 1016, 
1056, 1066, 1081, 1086, 1134, 1149, 1159, 1179, 1194, 1237, 
1252, 1300, 1326, 1343, 1353, 1365, 1396, 1429, 1444, 1478, 
1493, 1508, 1541, 1556, 1566, 1571, 1576, 1622, 1681, 1707, 
1754, 1790, 1830, 1862, 1898, 1915, 1956, 1991, 2007, 2046, 
2072, 2107, 2130, 2174, 2211, 2246, 2260, 2291, 2335, 2379, 
2434, 2472, 2516, 2547, 2552, 2583, 
};

const int gamgi_io_font_hershey_symbol_serif_driver[GAMGI_IO_ASCII_RANGE] = {
97, 98, 125, 137, 157, 177, 238, 333, 363, 
401, 439, 454, 464, 479, 484, 495, 500, 577, 596, 
682, 772, 794, 867, 960, 1017, 1137, 1230, 1252, 1278, 
1285, 1295, 1302, 1363, 1415, 1445, 1529, 1564, 1589, 1627, 
1716, 1740, 1785, 1805, 1890, 1935, 1960, 2010, 2045, 2130, 
2165, 2270, 2323, 2358, 2386, 2420, 2472, 2553, 2613, 2688, 
2716, 2736, 2769, 2789, 2799, 2804, 2809, 2885, 2993, 3036, 
3121, 3181, 3260, 3312, 3372, 3400, 3471, 3524, 3566, 3617, 
3660, 3721, 3759, 3841, 3900, 3966, 3994, 4053, 4155, 4239, 
4324, 4388, 4448, 4497, 4502, 4551, 
};

const int gamgi_io_font_hershey_symbol_serif_bold_driver[GAMGI_IO_ASCII_RANGE] = {
97, 98, 160, 172, 228, 248, 382, 489, 519, 
570, 621, 690, 718, 762, 776, 806, 820, 915, 962, 
1079, 1223, 1270, 1373, 1505, 1584, 1732, 1864, 1924, 1998, 
2016, 2044, 2062, 2160, 2212, 2272, 2411, 2501, 2536, 2676, 
2820, 2907, 3042, 3107, 3228, 3343, 3398, 3503, 3568, 3671, 
3796, 3959, 4062, 4123, 4218, 4299, 4377, 4484, 4654, 4804, 
4873, 4893, 4926, 4946, 4956, 4961, 4966, 5067, 5195, 5263, 
5378, 5472, 5583, 5675, 5753, 5802, 5915, 6018, 6070, 6148, 
6219, 6306, 6374, 6479, 6566, 6667, 6715, 6791, 6895, 6999, 
7128, 7229, 7328, 7377, 7387, 7436, 
};
