/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ColorWindow {
    private double[] rgb = new double[3];
    private JFrame frame;
    private JPanel colorPanel;
    private JTextArea rgbvalues;
    private JTextArea rgbhexvalues;
    private JSlider amountBar;
    private JSlider brightnessBar;
    private Box graphBox;
    private double AMOUNT = 0.5;
    private double BRIGHTNESS = 0.0;
    private Boolean GAMMA = false;
    private Boolean MERGE = false;
    private String SPECTRUMFILE = "";
    private String PREV_SPECTRUMFILE = "";
    private ColorCalculator cc = null;

    public ColorWindow() {
        this.initComponents();
        this.cc = new ColorCalculator();
    }

    public static void main(String[] stringArray) {
        new ColorWindow();
    }

    private double applyGamma(double d) {
        if (d > 1.0) {
            d = 1.0;
        }
        double d2 = 0.055;
        d = d < 0.0031308 ? (d *= 12.92) : (1.0 + d2) * Math.pow(d, 0.4166666666666667) - d2;
        if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }

    private void initComponents() {
        this.frame = new JFrame();
        this.frame.setLayout(new BorderLayout());
        JCheckBox jCheckBox = new JCheckBox("Use Gamma Correction", (boolean)this.GAMMA);
        jCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ColorWindow.this.GAMMA = ((JCheckBox)changeEvent.getSource()).isSelected();
                ColorWindow.this.action_calculateColor();
            }
        });
        JCheckBox jCheckBox2 = new JCheckBox("Merge graphs", (boolean)this.MERGE);
        jCheckBox2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ColorWindow.this.MERGE = ((JCheckBox)changeEvent.getSource()).isSelected();
                ColorWindow.this.drawGraphs(true);
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(jCheckBox);
        box.add(jCheckBox2);
        this.amountBar = new JSlider(0, 1000, 500);
        this.amountBar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (!jSlider.getValueIsAdjusting()) {
                    ColorWindow.this.AMOUNT = (double)jSlider.getModel().getValue() / 1000.0;
                }
                ColorWindow.this.action_calculateColor();
            }
        });
        this.amountBar.setPaintLabels(true);
        this.brightnessBar = new JSlider(1, -100, 100, 0);
        this.brightnessBar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (!jSlider.getValueIsAdjusting()) {
                    ColorWindow.this.BRIGHTNESS = (double)jSlider.getModel().getValue() / 1000.0;
                }
                ColorWindow.this.action_calculateColor();
            }
        });
        JList jList = GUITools.getFolderList(null);
        JPanel jPanel = new JPanel();
        jPanel.add(jList);
        jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ColorWindow.this.PREV_SPECTRUMFILE = ColorWindow.this.SPECTRUMFILE;
                ColorWindow.this.SPECTRUMFILE = ((JList)listSelectionEvent.getSource()).getSelectedValue().toString();
                ColorWindow.this.action_calculateColor();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setAutoscrolls(true);
        jScrollPane.setPreferredSize(new Dimension(125, 500));
        Box box2 = Box.createHorizontalBox();
        box2.add(new JLabel("Amount"));
        box2.add(this.amountBar);
        Box box3 = Box.createVerticalBox();
        this.rgbvalues = new JTextArea();
        this.rgbhexvalues = new JTextArea();
        box3.add(this.rgbvalues);
        box3.add(this.rgbhexvalues);
        this.colorPanel = new JPanel();
        this.colorPanel.setMinimumSize(new Dimension(100, 100));
        this.colorPanel.setPreferredSize(new Dimension(150, 400));
        box3.add(this.colorPanel);
        this.graphBox = Box.createVerticalBox();
        this.frame.setMinimumSize(new Dimension(600, 400));
        this.frame.getContentPane().add((Component)box3, "East");
        this.frame.getContentPane().add((Component)box, "North");
        this.frame.getContentPane().add((Component)this.graphBox, "Center");
        this.frame.getContentPane().add((Component)box2, "South");
        this.frame.getContentPane().add((Component)jScrollPane, "West");
        this.frame.setTitle("Color viewer version 5");
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void action_calculateColor() {
        int n;
        if (!this.SPECTRUMFILE.equals(this.PREV_SPECTRUMFILE)) {
            this.cc.loadAbsorbSpectrum(this.SPECTRUMFILE);
        }
        this.rgb = this.cc.calculateIlluminatedColor(this.AMOUNT, this.BRIGHTNESS);
        System.out.println("Amount: " + this.AMOUNT + " , BRIGHTNESS: " + this.BRIGHTNESS + " GAMMA correction: " + this.GAMMA);
        if (this.GAMMA.booleanValue()) {
            for (n = 0; n < 3; ++n) {
                this.rgb[n] = this.applyGamma(this.rgb[n]);
            }
        }
        for (n = 0; n < this.rgb.length; ++n) {
            if (this.rgb[n] < 0.0) {
                this.rgb[n] = 0.0;
            }
            if (!(this.rgb[n] > 1.0)) continue;
            this.rgb[n] = 1.0;
        }
        Color color = new Color((float)this.rgb[0], (float)this.rgb[1], (float)this.rgb[2]);
        this.colorPanel.setBackground(color);
        this.rgbvalues.setText("RGB: " + color.getRed() + " " + color.getGreen() + " " + color.getBlue());
        this.rgbhexvalues.setText("RGB: #" + Integer.toHexString(color.getRed()).toUpperCase() + Integer.toHexString(color.getGreen()).toUpperCase() + Integer.toHexString(color.getBlue()).toUpperCase());
        this.drawGraphs(false);
        this.frame.validate();
    }

    private void drawGraphs(Boolean bl) {
        this.graphBox.removeAll();
        if (this.MERGE.booleanValue()) {
            this.graphBox.add(this.cc.createGraph());
        } else {
            this.graphBox.add(this.cc.createAbsorbptionGraph());
            this.graphBox.add(this.cc.createResultLightGraph());
        }
        if (bl.booleanValue()) {
            this.frame.validate();
        }
    }
}

