/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.CDATASectionImpl;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CommentImpl;
import org.apache.xerces.dom.CoreDOMImplementationImpl;
import org.apache.xerces.dom.DeepNodeListImpl;
import org.apache.xerces.dom.DocumentFragmentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementDefinitionImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.NotationImpl;
import org.apache.xerces.dom.ParentNode;
import org.apache.xerces.dom.ProcessingInstructionImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class CoreDocumentImpl
extends ParentNode
implements Document {
    static final long serialVersionUID = 0L;
    protected DocumentTypeImpl docType;
    protected ElementImpl docElement;
    protected String encoding;
    protected String version;
    protected boolean standalone;
    protected Hashtable identifiers;
    protected static int[] kidOK = new int[13];
    protected int changes = 0;
    protected boolean allowGrammarAccess;
    protected boolean errorChecking = true;

    static {
        CoreDocumentImpl.kidOK[9] = 1410;
        CoreDocumentImpl.kidOK[1] = 442;
        CoreDocumentImpl.kidOK[5] = 442;
        CoreDocumentImpl.kidOK[6] = 442;
        CoreDocumentImpl.kidOK[11] = 442;
        CoreDocumentImpl.kidOK[2] = 40;
        CoreDocumentImpl.kidOK[12] = 0;
        CoreDocumentImpl.kidOK[4] = 0;
        CoreDocumentImpl.kidOK[3] = 0;
        CoreDocumentImpl.kidOK[8] = 0;
        CoreDocumentImpl.kidOK[7] = 0;
        CoreDocumentImpl.kidOK[10] = 0;
    }

    public CoreDocumentImpl() {
        this(false);
        XMLCharacterProperties.initCharFlags();
    }

    public CoreDocumentImpl(DocumentType documentType) {
        this(documentType, false);
        XMLCharacterProperties.initCharFlags();
    }

    public CoreDocumentImpl(DocumentType documentType, boolean bl) {
        this(bl);
        if (documentType != null) {
            try {
                DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)documentType;
            }
            catch (ClassCastException classCastException) {
                throw new DOMException(4, "DOM005 Wrong document");
            }
            documentTypeImpl.ownerDocument = this;
            this.appendChild(documentType);
        }
        XMLCharacterProperties.initCharFlags();
    }

    public CoreDocumentImpl(boolean bl) {
        super(null);
        this.ownerDocument = this;
        this.allowGrammarAccess = bl;
        XMLCharacterProperties.initCharFlags();
    }

    protected void addEventListener(NodeImpl nodeImpl, String string, EventListener eventListener, boolean bl) {
    }

    public Node adoptNode(Node node) {
        NodeImpl nodeImpl;
        try {
            nodeImpl = (NodeImpl)node;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        switch (nodeImpl.getNodeType()) {
            case 2: {
                AttrImpl attrImpl = (AttrImpl)nodeImpl;
                attrImpl.getOwnerElement().removeAttributeNode(attrImpl);
                attrImpl.isSpecified(true);
                attrImpl.setOwnerDocument(this);
                break;
            }
            case 9: 
            case 10: {
                throw new DOMException(9, "cannot adopt this type of node.");
            }
            case 5: {
                NamedNodeMap namedNodeMap;
                Node node2;
                Node node3;
                Node node4 = nodeImpl.getParentNode();
                if (node4 != null) {
                    node4.removeChild(node);
                }
                while ((node3 = nodeImpl.getFirstChild()) != null) {
                    nodeImpl.removeChild(node3);
                }
                nodeImpl.setOwnerDocument(this);
                if (this.docType == null || (node2 = (namedNodeMap = this.docType.getEntities()).getNamedItem(nodeImpl.getNodeName())) == null) break;
                EntityImpl entityImpl = (EntityImpl)node2;
                node3 = node2.getFirstChild();
                while (node3 != null) {
                    Node node5 = node3.cloneNode(true);
                    nodeImpl.appendChild(node5);
                    node3 = node3.getNextSibling();
                }
                break;
            }
            case 1: {
                Node node6 = nodeImpl.getParentNode();
                if (node6 != null) {
                    node6.removeChild(node);
                }
                nodeImpl.setOwnerDocument(this);
                ((ElementImpl)nodeImpl).reconcileDefaultAttributes();
                break;
            }
            default: {
                Node node7 = nodeImpl.getParentNode();
                if (node7 != null) {
                    node7.removeChild(node);
                }
                nodeImpl.setOwnerDocument(this);
            }
        }
        return nodeImpl;
    }

    protected void changed() {
        ++this.changes;
    }

    protected int changes() {
        return this.changes;
    }

    public Object clone() throws CloneNotSupportedException {
        CoreDocumentImpl coreDocumentImpl = (CoreDocumentImpl)super.clone();
        coreDocumentImpl.docType = null;
        coreDocumentImpl.docElement = null;
        return coreDocumentImpl;
    }

    protected void cloneNode(CoreDocumentImpl coreDocumentImpl, boolean bl) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (bl) {
            Object object;
            Hashtable hashtable = null;
            if (this.identifiers != null) {
                hashtable = new Hashtable();
                object = this.identifiers.keys();
                while (object.hasMoreElements()) {
                    Object e = object.nextElement();
                    hashtable.put(this.identifiers.get(e), e);
                }
            }
            object = this.firstChild;
            while (object != null) {
                coreDocumentImpl.appendChild(coreDocumentImpl.importNode((Node)object, true, hashtable));
                object = ((ChildNode)object).nextSibling;
            }
        }
        coreDocumentImpl.allowGrammarAccess = this.allowGrammarAccess;
        coreDocumentImpl.errorChecking = this.errorChecking;
    }

    public Node cloneNode(boolean bl) {
        CoreDocumentImpl coreDocumentImpl = new CoreDocumentImpl();
        this.cloneNode(coreDocumentImpl, bl);
        return coreDocumentImpl;
    }

    public Attr createAttribute(String string) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new AttrImpl(this, string);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string2)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new AttrNSImpl(this, string, string2);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new CDATASectionImpl(this, string);
    }

    public Comment createComment(String string) {
        return new CommentImpl(this, string);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public DocumentType createDocumentType(String string, String string2, String string3) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new DocumentTypeImpl(this, string, string2, string3);
    }

    public Element createElement(String string) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new ElementImpl(this, string);
    }

    public ElementDefinitionImpl createElementDefinition(String string) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new ElementDefinitionImpl(this, string);
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string2)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new ElementNSImpl(this, string, string2);
    }

    public Entity createEntity(String string) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new EntityImpl(this, string);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new EntityReferenceImpl(this, string);
    }

    public Notation createNotation(String string) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new NotationImpl(this, string);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new ProcessingInstructionImpl(this, string, string2);
    }

    public Text createTextNode(String string) {
        return new TextImpl(this, string);
    }

    void deletedText(NodeImpl nodeImpl, int n, int n2) {
    }

    protected boolean dispatchEvent(NodeImpl nodeImpl, Event event) {
        return false;
    }

    public DocumentType getDoctype() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.docType;
    }

    public Element getDocumentElement() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.docElement;
    }

    public Element getElementById(String string) {
        return this.getIdentifier(string);
    }

    public NodeList getElementsByTagName(String string) {
        return new DeepNodeListImpl(this, string);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return new DeepNodeListImpl(this, string, string2);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean getErrorChecking() {
        return this.errorChecking;
    }

    public Element getIdentifier(String string) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return null;
        }
        return (Element)this.identifiers.get(string);
    }

    public Enumeration getIdentifiers() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        return this.identifiers.keys();
    }

    public DOMImplementation getImplementation() {
        return CoreDOMImplementationImpl.getDOMImplementation();
    }

    boolean getMutationEvents() {
        return false;
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public final Document getOwnerDocument() {
        return null;
    }

    public boolean getStandalone() {
        return this.standalone;
    }

    public boolean getStrictErrorChecking() {
        return this.errorChecking;
    }

    protected Object getUserData(NodeImpl nodeImpl) {
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        return this.importNode(node, bl, null);
    }

    private Node importNode(Node node, boolean bl, Hashtable hashtable) throws DOMException {
        Node node2;
        Node node3 = null;
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                Object v;
                boolean bl2 = node.getOwnerDocument().getImplementation().hasFeature("XML", "2.0");
                node2 = !bl2 || node.getLocalName() == null ? this.createElement(node.getNodeName()) : this.createElementNS(node.getNamespaceURI(), node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    int n = namedNodeMap.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        Attr attr = (Attr)namedNodeMap.item(n2);
                        if (attr.getSpecified()) {
                            Attr attr2 = (Attr)this.importNode(attr, true, hashtable);
                            if (!bl2 || attr.getLocalName() == null) {
                                node2.setAttributeNode(attr2);
                            } else {
                                node2.setAttributeNodeNS(attr2);
                            }
                        }
                        ++n2;
                    }
                }
                if (hashtable != null && (v = hashtable.get(node)) != null) {
                    if (this.identifiers == null) {
                        this.identifiers = new Hashtable();
                    }
                    this.identifiers.put(v, node2);
                }
                node3 = node2;
                break;
            }
            case 2: {
                node3 = node.getOwnerDocument().getImplementation().hasFeature("XML", "2.0") ? (node.getLocalName() == null ? this.createAttribute(node.getNodeName()) : this.createAttributeNS(node.getNamespaceURI(), node.getNodeName())) : this.createAttribute(node.getNodeName());
                if (node instanceof AttrImpl) {
                    node2 = (AttrImpl)node;
                    if (((NodeImpl)node2).hasStringValue()) {
                        AttrImpl attrImpl = (AttrImpl)node3;
                        attrImpl.setValue(((AttrImpl)node2).getValue());
                        bl = false;
                        break;
                    }
                    bl = true;
                    break;
                }
                if (node.getFirstChild() == null) {
                    node3.setNodeValue(node.getNodeValue());
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 3: {
                node3 = this.createTextNode(node.getNodeValue());
                break;
            }
            case 4: {
                node3 = this.createCDATASection(node.getNodeValue());
                break;
            }
            case 5: {
                node3 = this.createEntityReference(node.getNodeName());
                ((EntityReferenceImpl)node3).isReadOnly(false);
                break;
            }
            case 6: {
                node2 = (Entity)node;
                EntityImpl entityImpl = (EntityImpl)this.createEntity(node.getNodeName());
                entityImpl.setPublicId(node2.getPublicId());
                entityImpl.setSystemId(node2.getSystemId());
                entityImpl.setNotationName(node2.getNotationName());
                entityImpl.isReadOnly(false);
                node3 = entityImpl;
                break;
            }
            case 7: {
                node3 = this.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 8: {
                node3 = this.createComment(node.getNodeValue());
                break;
            }
            case 11: {
                node3 = this.createDocumentFragment();
                break;
            }
            case 12: {
                node2 = (Notation)node;
                NotationImpl notationImpl = (NotationImpl)this.createNotation(node.getNodeName());
                notationImpl.setPublicId(node2.getPublicId());
                notationImpl.setSystemId(node2.getSystemId());
                node3 = notationImpl;
                break;
            }
            default: {
                throw new DOMException(9, "Node type being imported is not supported");
            }
        }
        if (bl) {
            node2 = node.getFirstChild();
            while (node2 != null) {
                node3.appendChild(this.importNode(node2, true, hashtable));
                node2 = node2.getNextSibling();
            }
        }
        if (node3.getNodeType() == 5 || node3.getNodeType() == 6) {
            ((NodeImpl)node3).setReadOnly(true, true);
        }
        return node3;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        short s = node.getNodeType();
        if (this.errorChecking && (s == 1 && this.docElement != null || s == 10 && this.docType != null)) {
            throw new DOMException(3, "DOM006 Hierarchy request error");
        }
        super.insertBefore(node, node2);
        if (s == 1) {
            this.docElement = (ElementImpl)node;
        } else if (s == 10) {
            this.docType = (DocumentTypeImpl)node;
        }
        return node;
    }

    void insertedNode(NodeImpl nodeImpl, NodeImpl nodeImpl2, boolean bl) {
    }

    void insertedText(NodeImpl nodeImpl, int n, int n2) {
    }

    void insertingNode(NodeImpl nodeImpl, boolean bl) {
    }

    protected boolean isKidOK(Node node, Node node2) {
        if (this.allowGrammarAccess && node.getNodeType() == 10) {
            return node2.getNodeType() == 1;
        }
        return (kidOK[node.getNodeType()] & 1 << node2.getNodeType()) != 0;
    }

    public static boolean isXMLName(String string) {
        if (string == null) {
            return false;
        }
        return XMLCharacterProperties.validName(string);
    }

    void modifiedAttrValue(AttrImpl attrImpl, String string) {
    }

    void modifiedCharacterData(NodeImpl nodeImpl, String string, String string2) {
    }

    void modifyingCharacterData(NodeImpl nodeImpl) {
    }

    public void putIdentifier(String string, Element element) {
        if (element == null) {
            this.removeIdentifier(string);
            return;
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        this.identifiers.put(string, element);
    }

    public Node removeChild(Node node) throws DOMException {
        super.removeChild(node);
        short s = node.getNodeType();
        if (s == 1) {
            this.docElement = null;
        } else if (s == 10) {
            this.docType = null;
        }
        return node;
    }

    protected void removeEventListener(NodeImpl nodeImpl, String string, EventListener eventListener, boolean bl) {
    }

    public void removeIdentifier(String string) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return;
        }
        this.identifiers.remove(string);
    }

    void removedAttrNode(AttrImpl attrImpl, NodeImpl nodeImpl, String string) {
    }

    void removedNode(NodeImpl nodeImpl, boolean bl) {
    }

    void removingNode(NodeImpl nodeImpl, NodeImpl nodeImpl2, boolean bl) {
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        super.replaceChild(node, node2);
        short s = node2.getNodeType();
        if (s == 1) {
            this.docElement = (ElementImpl)node;
        } else if (s == 10) {
            this.docType = (DocumentTypeImpl)node;
        }
        return node2;
    }

    void replacedNode(NodeImpl nodeImpl) {
    }

    void replacedText(NodeImpl nodeImpl) {
    }

    void replacingNode(NodeImpl nodeImpl) {
    }

    void setAttrNode(AttrImpl attrImpl, AttrImpl attrImpl2) {
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setErrorChecking(boolean bl) {
        this.errorChecking = bl;
    }

    void setMutationEvents(boolean bl) {
    }

    public void setStandalone(boolean bl) {
        this.standalone = bl;
    }

    public void setStrictErrorChecking(boolean bl) {
        this.errorChecking = bl;
    }

    protected void setUserData(NodeImpl nodeImpl, Object object) {
    }

    public void setVersion(String string) {
        this.version = string;
    }
}

