/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.soap;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.filetree.LocalAndRemoteFileTreeFrame;
import org.emboss.jemboss.soap.JembossSoapException;

public class AuthPopup
extends JFrame {
    private JPanel splashp;
    private int iprogress = 0;
    private int iprogressmax = 0;
    private JembossParams mysettings;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private JButton okButton;
    private JTextField ufield;
    private JPasswordField pfield;
    private boolean exitOnDone = false;
    private JPanel promptPanel;

    public AuthPopup(JembossParams mysettings, JFrame f) {
        if (f != null) {
            String text = "";
            text = mysettings.getUseAuth() ? (mysettings.getServiceUserName() == null ? "You need to supply a username and password\nbefore running an application." : "Login to server failed\nPlease check your login details.") : "The server wants a username and password,\nbut we weren't expecting to need to.\nPlease supply the correct login details.";
            JOptionPane.showMessageDialog(f, text, "Authentication failed", 0);
        }
        JPanel logoPanel = new JPanel(new BorderLayout());
        ClassLoader cl = this.getClass().getClassLoader();
        ImageIcon ii = new ImageIcon(cl.getResource("images/Jemboss_logo_greyback.gif"));
        logoPanel.add((Component)new JLabel(ii), "West");
        this.splashp = (JPanel)this.getContentPane();
        this.splashp.setLayout(new BorderLayout());
        this.splashp.add((Component)logoPanel, "North");
        if (mysettings.getUseAuth()) {
            this.setTitle("Login");
            this.promptPanel = new JPanel(new BorderLayout());
            JPanel loginPanel = new JPanel();
            loginPanel.setLayout(new GridLayout(2, 2));
            this.ufield = new JTextField(16);
            if (mysettings.getServiceUserName() != null) {
                this.ufield.setText(mysettings.getServiceUserName());
            }
            this.pfield = new JPasswordField(16);
            JLabel ulab = new JLabel(" Username:", 2);
            JLabel plab = new JLabel(" Password:", 2);
            loginPanel.add(ulab);
            loginPanel.add(this.ufield);
            loginPanel.add(plab);
            loginPanel.add(this.pfield);
            this.promptPanel.add((Component)loginPanel, "Center");
            this.setSize(380, 170);
            this.setDefaultCloseOperation(1);
        } else {
            this.setTitle("Jemboss Launch");
            this.exitOnDone = true;
        }
        this.setLocation(1, 5);
        this.mysettings = mysettings;
    }

    public AuthPopup(JembossParams mysettings, int iprogressmax) {
        this(mysettings, null);
        this.mysettings = mysettings;
        this.iprogressmax = iprogressmax;
        if (iprogressmax > 0) {
            JPanel progressPanel = new JPanel();
            progressPanel.setLayout(new FlowLayout(0));
            this.progressBar = new JProgressBar(0, iprogressmax);
            this.progressBar.setValue(0);
            this.progressLabel = new JLabel("Starting up.");
            progressPanel.add(this.progressBar);
            progressPanel.add(this.progressLabel);
            this.splashp.add((Component)progressPanel, "South");
        }
        this.splashp.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black));
        this.setSize(380, 200);
        this.setDefaultCloseOperation(1);
    }

    public void addBottomPanel() {
        this.setTitle("File Manager Login");
        final JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton exitButton = new JButton("Exit");
        this.okButton = new JButton("OK");
        exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        final AuthPopup fthis = this;
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AuthPopup.this.mysettings.setServiceUserName(AuthPopup.this.ufield.getText());
                AuthPopup.this.mysettings.setServicePasswd(AuthPopup.this.pfield.getPassword());
                AuthPopup.this.exitOnDone = true;
                if (AuthPopup.this.iprogressmax > 0) {
                    AuthPopup.this.remove(AuthPopup.this.promptPanel);
                    AuthPopup.this.pack();
                } else {
                    AuthPopup.this.setVisible(false);
                }
                try {
                    LocalAndRemoteFileTreeFrame treeFrame = new LocalAndRemoteFileTreeFrame(AuthPopup.this.mysettings);
                    treeFrame.setExit();
                    Dimension d = treeFrame.getToolkit().getScreenSize();
                    treeFrame.setLocation(0, ((int)d.getHeight() - treeFrame.getHeight()) / 2);
                    treeFrame.setVisible(true);
                }
                catch (JembossSoapException jse) {
                    if (AuthPopup.this.iprogressmax > 0) {
                        AuthPopup.this.promptPanel.add((Component)buttonPanel, "South");
                        AuthPopup.this.pack();
                    }
                    AuthPopup.this.setVisible(true);
                }
            }
        });
        buttonPanel.add(exitButton);
        buttonPanel.add(this.okButton);
        this.promptPanel.add((Component)buttonPanel, "South");
        this.splashp.add(this.promptPanel);
        this.pfield.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AuthPopup.this.mysettings.setServiceUserName(AuthPopup.this.ufield.getText());
                AuthPopup.this.mysettings.setServicePasswd(AuthPopup.this.pfield.getPassword());
                AuthPopup.this.exitOnDone = true;
                fthis.setVisible(false);
                try {
                    LocalAndRemoteFileTreeFrame treeFrame = new LocalAndRemoteFileTreeFrame(AuthPopup.this.mysettings);
                    treeFrame.setExit();
                    Dimension d = treeFrame.getToolkit().getScreenSize();
                    treeFrame.setLocation(0, ((int)d.getHeight() - treeFrame.getHeight()) / 2);
                    treeFrame.setVisible(true);
                }
                catch (JembossSoapException jse) {
                    fthis.setVisible(true);
                }
            }
        });
    }

    public void setBottomPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton exitButton = new JButton("Exit");
        JButton okButton = new JButton("OK");
        exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AuthPopup.this.mysettings.setServiceUserName(AuthPopup.this.ufield.getText());
                AuthPopup.this.mysettings.setServicePasswd(AuthPopup.this.pfield.getPassword());
                AuthPopup.this.exitOnDone = true;
                if (AuthPopup.this.iprogressmax > 0 && AuthPopup.this.iprogress != AuthPopup.this.iprogressmax) {
                    AuthPopup.this.remove(AuthPopup.this.promptPanel);
                    AuthPopup.this.pack();
                }
                AuthPopup.this.dispose();
            }
        });
        buttonPanel.add(exitButton);
        buttonPanel.add(okButton);
        if (this.promptPanel != null) {
            this.promptPanel.add((Component)buttonPanel, "South");
            this.splashp.add(this.promptPanel);
        }
        if (this.pfield != null) {
            this.pfield.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AuthPopup.this.mysettings.setServiceUserName(AuthPopup.this.ufield.getText());
                    AuthPopup.this.mysettings.setServicePasswd(AuthPopup.this.pfield.getPassword());
                    AuthPopup.this.exitOnDone = true;
                    if (AuthPopup.this.iprogressmax > 0 && AuthPopup.this.iprogress != AuthPopup.this.iprogressmax) {
                        AuthPopup.this.remove(AuthPopup.this.promptPanel);
                        AuthPopup.this.pack();
                    }
                    AuthPopup.this.dispose();
                }
            });
        }
    }

    public void doneSomething(String s) {
        if (this.iprogressmax > 0) {
            if (this.iprogress < this.iprogressmax) {
                ++this.iprogress;
                this.progressBar.setValue(this.iprogress);
            }
            this.progressLabel.setText(s);
            if (this.iprogress == this.iprogressmax) {
                this.progressLabel.setText("Startup complete.");
                if (this.exitOnDone) {
                    this.setVisible(false);
                }
            }
        }
    }

    public void doneEverything(String s) {
        if (this.iprogressmax > 0) {
            this.progressBar.setValue(this.iprogressmax);
            this.progressLabel.setText(s);
            if (this.exitOnDone) {
                this.setVisible(false);
            }
        }
    }

    public JFrame getSplashFrame() {
        return this;
    }
}

