/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

using GLib;

[GtkTemplate (ui = "/org/gnome/DejaDup/BasicNavigationPage.ui")]
public class BasicNavigationPage : Adw.NavigationPage
{
  public Gtk.Widget content {get; set;}

  construct
  {
    var op_watcher = DejaDup.OperationWatcher.get_instance();
    op_watcher.notify["active"].connect(update_content_sensitivity);
    notify["content"].connect(update_content_sensitivity);
  }

  void update_content_sensitivity()
  {
    if (content != null)
      content.sensitive = !DejaDup.OperationWatcher.get_instance().active;
  }
}
