# Generate packaging example log data

The source package examples are here.  These are used to produce log data in advance.

source package name:     debhello
executable command name: hello

## Pre-pre-build

After making manual changes, please make sure to clean tailing white spaces.

 $ make groom

## Pre-build

Prior to the packaging, the up-to-date packaging example logs need to created
as pre-build and committed to the source tree in the testing environment.

This pre-build requires a testing environment with many packages related to
the typical source building infrastructure.

In this sub-directory:

```
 $ sudo apt install\
       autoconf\
       automake\
       autopoint\
       cmake\
       debhelper\
       debmake\
       devscripts\
       gettext\
       gir1.2-gtk-3.0\
       libltdl-dev\
       libtool\
       libxml2-utils\
       lintian\
       locales-all\
       python3-all\
       python3-debian\
       python3-distutils-extra\
       python3-gi\
       quilt\
       tree\
       vim\
       w3m\
       zip
 $ make
 $ make clean
 $ git add -A .
 $ git commit -m "Update example logs"
```

## Debug pre-build for partial build log examples

If you want to create only a partial packaging example logs for
debugging, you can do it as:

```
 $ make prep
 $ cd debhello-1.6_build-1
 $ make
```

## Notes on file organization

### Files in `template/`

This directory contains a set of template files used to be copied to
`debian/*` files of many examples of the packaged source tree.

The changelog file in this template/ is for the latest version of the
package example which is split up properly for each version and copied
accordingly.

### Files in `debhello-<version>/`

Each of these contains an entire set of an example source tree with template
for properly packaged `debian/*` files.

The upstream tarballs used in the packaging example are generated by the tar
command while excluding the debian/ directory.

### Files in `debhello-<version>_build-<revision>/`

These are used to generate the packaging process example.

These contain `step<number>.cmd` files which are executed sequentially and the
results are logged to the step<number>.log files with the script program.

Since the `step<number>.log` files are terminated by `<CR><LF>`, may contain
`<TAB>`, and may be too long, the filtered `step<number>.slog` files are generated.

The `<revision>` is usually 1 and it matches the Debian revision of the binary
packages generated.

If you wish to run script-by-script, you can do the following

```
 $ make step<number>.cmd
```

<!-- vim:se tw=78 sts=4 ts=4 et ai: -->
