
# Произвольный ключ партиционирования

Ключ партиционирования может представлять собой произвольное выражение из столбцов таблицы, а также кортеж из таких выражений (аналогично первичному ключу). Ключ партиционирования может отсутствовать. При создании таблицы ключ партиционирования указывается в описании движка (ENGINE) с новым синтаксисом:

```
ENGINE [=] Name(...) [PARTITION BY expr] [ORDER BY expr] [SAMPLE BY expr] [SETTINGS name=value, ...]
```

Для MergeTree таблиц выражение партиционирования указывается после `PARTITION BY`, первичный ключ после `ORDER BY`, ключ сэмплирования после `SAMPLE BY`, а в `SETTINGS` можно указать `index_granularity` (не обязательно, значение по умолчанию 8192), а также другие настройки из [MergeTreeSettings.h](https://github.com/yandex/ClickHouse/blob/master/dbms/src/Storages/MergeTree/MergeTreeSettings.h). Остальные параметры движка по-прежнему указываются в скобках после его названия. Пример:
``` sql
ENGINE = ReplicatedCollapsingMergeTree('/clickhouse/tables/name', 'replica1', Sign)
    PARTITION BY (toMonday(StartDate), EventType)
    ORDER BY (CounterID, StartDate, intHash32(UserID))
    SAMPLE BY intHash32(UserID)
```

Традиционному партиционированию по месяцу соответствует выражение `toYYYYMM(date_column)`.

Таблицу старого стиля сконвертировать в таблицу с произвольным партиционированием нельзя (только через INSERT SELECT).

После создания такой таблицы слияние кусков будет работать только для кусков с одинаковым значением выражения партиционирования. Замечание: это означает, что нежелательно делать слишком гранулированное партиционирование (более порядка тысячи партиций), иначе производительность SELECT будет неудовлетворительной.

Чтобы указать партицию в командах ALTER PARTITION, нужно указать значение выражения партиционирования (или кортежа). Поддерживаются константы и константные выражения. Пример:
``` sql
ALTER TABLE table DROP PARTITION (toMonday(today()), 1)
```
удалит партицию за текущую неделю с типом события 1. То же самое для запроса OPTIMIZE. Чтобы указать единственную партицию непартиционированной таблицы, укажите `PARTITION tuple()`.

Замечание: для таблиц старого стиля можно указывать партицию и как число `201710`, и как строку `'201710'`. Синтаксис для таблиц нового типа более строг к типам (аналогично парсеру входного формата VALUES). Также, ALTER TABLE FREEZE PARTITION для таблиц нового типа работает по полному совпадению (не по префиксу).

В таблице `system.parts` в столбце `partition` указывается значение выражения партиционирования, пригодное к использованию в запросах ALTER (если убрать квотирование). В столбце `name` указывается имя куска, формат которого изменился.

Было: `20140317_20140323_2_2_0` (минимальная дата - максимальная дата - номер минимального блока - номер максимального блока - уровень).

Стало: `201403_2_2_0` (ID партиции - номер минимального блока - номер максимального блока - уровень).

ID партиции - это её строковый идентификатор (по возможности человекочитаемый), используемый для имён кусков на файловой системе и в ZooKeeper. Его можно указывать в запросах ALTER вместо значения ключа партиционирования. Пример: ключ партиционирования `toYYYYMM(EventDate)`, в ALTER можно указывать либо `PARTITION 201710`, либо `PARTITION ID '201710'`.

Больше примеров в тестах [`00502_custom_partitioning_local`](https://github.com/yandex/ClickHouse/blob/master/dbms/tests/queries/0_stateless/00502_custom_partitioning_local.sql) и [`00502_custom_partitioning_replicated_zookeeper`](https://github.com/yandex/ClickHouse/blob/master/dbms/tests/queries/0_stateless/00502_custom_partitioning_replicated_zookeeper.sql).

[Оригинальная статья](https://clickhouse.yandex/docs/ru/operations/table_engines/custom_partitioning_key/) <!--hide-->
