___
___
# Ant Tasks

The `bnd.jar` file can also be used as an ANT task. The following example shows how you can use it from an ANT file.

 <target name="build"> 
   <taskdef resource="aQute/bnd/ant/taskdef.properties"
      classpath="bnd.jar"/> 
   <bnd 
      classpath="src" 
      eclipse="true" 
      failok="false" 
      exceptions="true" 
      files="test.bnd"/> 
 </target>

You can set the following attributes:

||
||!Attribute ||!Description ||
||classpath ||Comma separated list of file names. File paths are relative from the ant project file. ||
||eclipse ||True or false. True if the eclipse .classpath file should be read (default). ||
||failok ||Succeed even if there are errors. ||
||exceptions ||If errors occur, show the exception stack trace. ||
||files ||A comma separated list of bnd files ||
||sourcepath||A source path||
||output||Where the output should go||

The following tasks have also been added:
||task name||Class||attributes||
||bndeclipse||EclipseTask||prefix='project.'||
||bndexpand||ExpandPropertiesTask||propertyFile='<file>'||
||bndwrap||WrapTask||jars='<list>', output='<dir>', definitions='<dir>', classpath='<file-list>'||
