#!/usr/bin/sh

# helper script called from within ansible-test-integration.py to

set -eu

# workaround for various integration tests trying to do this and failing
# due to missing root permission
echo 'apt-mark changes'
/usr/bin/apt-mark manual debconf-utils || true
/usr/bin/apt-mark manual equivs || true
/usr/bin/apt-mark manual git || true
/usr/bin/apt-mark manual iptables || true
/usr/bin/apt-mark manual libfile-fcntllock-perl || true
/usr/bin/apt-mark manual openssl || true
/usr/bin/apt-mark manual python3-distlib || true

# Set default locale to en_US.UTF-8 to remove lots of warnings when
# running the tests
echo 'debconf selection changes'
# These values get overwritten by what is in the config files when
# running dpkg-reconfigure, see  https://bugs.debian.org/684134
cat << EOF | debconf-set-selections
locales	locales/default_environment_locale	select	en_US.UTF-8
locales	locales/locales_to_be_generated	multiselect	en_US.UTF-8 UTF-8
EOF

# So set these values manually in the config files.
echo 'en_US.UTF-8 UTF-8' > /etc/locale.gen
echo 'LANG=en_US.UTF-8' > /etc/locale.conf
echo 'LANG=en_US.UTF-8' > /etc/default/locale

echo 'dpkg-reconfigure changes'
dpkg-reconfigure --frontend=noninteractive locales

# create empty authorized_keys for integration test 'copy'
[ -d /root/.ssh ] || mkdir /root/.ssh/

touch /root/.ssh/authorized_keys

# allow pip to install system packages for the tests
rm -f /usr/lib/python3*/EXTERNALLY-MANAGED
