/*
 * Decompiled with CFR 0.152.
 */
package com.wombatinvasion.pmwikidraw.gui;

import com.wombatinvasion.pmwikidraw.PmWikiDrawing;
import com.wombatinvasion.pmwikidraw.PmWikiDrawingConverter;
import com.wombatinvasion.pmwikidraw.PmWikiDrawingView;
import com.wombatinvasion.pmwikidraw.symbol.SymbolPackage;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.jhotdraw.contrib.dnd.DragNDropTool;
import org.jhotdraw.figures.GroupFigure;
import org.jhotdraw.figures.TextFigure;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.framework.ViewChangeListener;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.UndoManager;
import qdxml.QDParser;

public class SymbolPackageContainer
extends JFrame
implements DrawingEditor {
    private SymbolPackage symbolPackage = null;
    private DrawingView[] views = null;
    private JTabbedPane tabbedContainer = null;
    private Tool myTool = null;
    private UndoManager myUndoManager = new UndoManager();
    private String packageUrl;
    private List listeners = new ArrayList();

    public SymbolPackageContainer(String string) {
        try {
            this.packageUrl = string;
            this.retrieveResource();
            this.buildContent();
            this.setSize(400, 400);
            this.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void retrieveResource() throws Exception {
        URL uRL = new URL("jar:" + this.packageUrl + "!/symbols.xml");
        URLConnection uRLConnection = uRL.openConnection();
        this.parseManifest(uRLConnection.getInputStream());
        this.setTitle("Symbols - " + this.symbolPackage.getName());
    }

    private void parseManifest(InputStream inputStream) throws Exception {
        this.symbolPackage = new SymbolPackage();
        QDParser.parse(this.symbolPackage, new InputStreamReader(inputStream));
    }

    private void buildContent() {
        List list = this.symbolPackage.getSymbolGroups();
        if (list.size() > 1) {
            int n;
            this.tabbedContainer = new JTabbedPane();
            ArrayList<PmWikiDrawingView> arrayList = new ArrayList<PmWikiDrawingView>();
            for (n = 0; n < list.size(); ++n) {
                SymbolPackage.SymbolGroup symbolGroup = (SymbolPackage.SymbolGroup)list.get(n);
                PmWikiDrawingView pmWikiDrawingView = this.createSymbolGroupPane(symbolGroup);
                this.tabbedContainer.add(symbolGroup.name.toString(), new JScrollPane(pmWikiDrawingView));
                arrayList.add(pmWikiDrawingView);
            }
            this.views = new DrawingView[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                this.views[n] = (DrawingView)arrayList.get(n);
            }
            this.myTool = new DragNDropTool(this);
            for (n = 0; n < this.views.length; ++n) {
                this.fireViewCreatedEvent(this.views[n]);
            }
            this.setContentPane(this.tabbedContainer);
            this.myTool.activate();
        } else if (list.size() == 1) {
            PmWikiDrawingView pmWikiDrawingView = this.createSymbolGroupPane((SymbolPackage.SymbolGroup)list.get(0));
            this.getContentPane().add(new JScrollPane(pmWikiDrawingView));
            this.views = new DrawingView[1];
            this.views[0] = pmWikiDrawingView;
            this.myTool = new DragNDropTool(this);
            this.myTool.activate();
            this.fireViewCreatedEvent(pmWikiDrawingView);
        } else {
            System.err.println("Symbol Package appears to be empty ?!?!");
        }
    }

    private PmWikiDrawingView createSymbolGroupPane(SymbolPackage.SymbolGroup symbolGroup) {
        int n = 360;
        int n2 = 340;
        PmWikiDrawing pmWikiDrawing = new PmWikiDrawing();
        int n3 = 6;
        int n4 = 6;
        int n5 = 0;
        PmWikiDrawingConverter pmWikiDrawingConverter = new PmWikiDrawingConverter();
        for (int i = 0; i < symbolGroup.symbols.size(); ++i) {
            SymbolPackage.Symbol symbol = (SymbolPackage.Symbol)symbolGroup.symbols.get(i);
            if (symbol.location == null || symbol.location.equals("")) continue;
            Drawing drawing = null;
            try {
                URL uRL = new URL("jar:" + this.packageUrl + "!/" + symbol.location);
                URLConnection uRLConnection = uRL.openConnection();
                pmWikiDrawingConverter.convert(uRLConnection.getInputStream());
                StorableInput storableInput = new StorableInput(pmWikiDrawingConverter.getConvertedStream());
                drawing = (Drawing)storableInput.readStorable();
                GroupFigure groupFigure = new GroupFigure();
                groupFigure.addAll(drawing.figures());
                TextFigure textFigure = new TextFigure();
                textFigure.setText(symbol.name.toString());
                int n6 = 0;
                if (textFigure.displayBox().width > groupFigure.displayBox().width) {
                    textFigure.moveBy(0, groupFigure.displayBox().height + 4);
                    n6 = textFigure.displayBox().width;
                    groupFigure.moveBy(textFigure.displayBox().width / 2 - groupFigure.displayBox().width / 2, 0);
                } else {
                    textFigure.moveBy(groupFigure.displayBox().width / 2 - textFigure.displayBox().width / 2, groupFigure.displayBox().height + 4);
                    n6 = groupFigure.displayBox().width;
                }
                if (n3 + n6 <= n) {
                    if (textFigure.displayBox().y + textFigure.displayBox().height >= n5) {
                        n5 = textFigure.displayBox().y + textFigure.displayBox().height;
                    }
                    groupFigure.moveBy(n3, n4);
                    textFigure.moveBy(n3, n4);
                    n3 += n6;
                    n3 += 6;
                } else {
                    n3 = 6;
                    n4 += n5;
                    groupFigure.moveBy(n3, n4 += 6);
                    textFigure.moveBy(n3, n4);
                    n3 += n6;
                    n3 += 6;
                    n5 = 0;
                }
                pmWikiDrawing.add(groupFigure);
                pmWikiDrawing.add(textFigure);
                textFigure.setReadOnly(true);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        SymbolPackageContainerDrawingView symbolPackageContainerDrawingView = new SymbolPackageContainerDrawingView(this, n, n2);
        symbolPackageContainerDrawingView.setBackground(Color.white);
        symbolPackageContainerDrawingView.setDrawing(pmWikiDrawing);
        return symbolPackageContainerDrawingView;
    }

    public DrawingView view() {
        if (this.tabbedContainer == null) {
            return this.views[0];
        }
        return this.views[this.tabbedContainer.getSelectedIndex()];
    }

    public DrawingView[] views() {
        return this.views;
    }

    public Tool tool() {
        return this.myTool;
    }

    public void toolDone() {
    }

    public void figureSelectionChanged(DrawingView drawingView) {
    }

    public void addViewChangeListener(ViewChangeListener viewChangeListener) {
        this.listeners.add(viewChangeListener);
    }

    public void removeViewChangeListener(ViewChangeListener viewChangeListener) {
    }

    public void showStatus(String string) {
    }

    public UndoManager getUndoManager() {
        return this.myUndoManager;
    }

    protected void fireViewCreatedEvent(DrawingView drawingView) {
        ListIterator listIterator = this.listeners.listIterator(this.listeners.size());
        while (listIterator.hasPrevious()) {
            ViewChangeListener viewChangeListener = (ViewChangeListener)listIterator.previous();
            viewChangeListener.viewCreated(drawingView);
        }
    }

    private class SymbolPackageContainerDrawingView
    extends PmWikiDrawingView {
        public SymbolPackageContainerDrawingView(DrawingEditor drawingEditor, int n, int n2) {
            super(drawingEditor, n, n2);
        }

        public boolean allowDropping() {
            return false;
        }
    }
}

