#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2017 Google
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)
# ----------------------------------------------------------------------------
#
#     ***     AUTO GENERATED CODE    ***    AUTO GENERATED CODE     ***
#
# ----------------------------------------------------------------------------
#
#     This file is automatically generated by Magic Modules and manual
#     changes will be clobbered when the file is regenerated.
#
#     Please read more about how to change this file at
#     https://www.github.com/GoogleCloudPlatform/magic-modules
#
# ----------------------------------------------------------------------------

from __future__ import absolute_import, division, print_function
__metaclass__ = type

################################################################################
# Documentation
################################################################################

ANSIBLE_METADATA = {'metadata_version': '1.1',
                    'status': ["preview"],
                    'supported_by': 'community'}

DOCUMENTATION = '''
---
module: gcp_compute_http_health_check_facts
description:
  - Gather facts for GCP HttpHealthCheck
short_description: Gather facts for GCP HttpHealthCheck
version_added: 2.7
author: Google Inc. (@googlecloudplatform)
requirements:
    - python >= 2.6
    - requests >= 2.18.4
    - google-auth >= 1.3.0
options:
    filters:
       description:
           A list of filter value pairs. Available filters are listed here
           U(https://cloud.google.com/sdk/gcloud/reference/topic/filters).
           Each additional filter in the list will act be added as an AND condition
           (filter1 and filter2)
extends_documentation_fragment: gcp
'''

EXAMPLES = '''
- name:  a http health check facts
  gcp_compute_http_health_check_facts:
      filters:
      - name = test_object
      project: test_project
      auth_kind: service_account
      service_account_file: "/tmp/auth.pem"
'''

RETURN = '''
items:
    description: List of items
    returned: always
    type: complex
    contains:
        check_interval_sec:
            description:
                - How often (in seconds) to send a health check. The default value is 5 seconds.
            returned: success
            type: int
        creation_timestamp:
            description:
                - Creation timestamp in RFC3339 text format.
            returned: success
            type: str
        description:
            description:
                - An optional description of this resource. Provide this property when you create
                  the resource.
            returned: success
            type: str
        healthy_threshold:
            description:
                - A so-far unhealthy instance will be marked healthy after this many consecutive successes.
                  The default value is 2.
            returned: success
            type: int
        host:
            description:
                - The value of the host header in the HTTP health check request. If left empty (default
                  value), the public IP on behalf of which this health check is performed will be
                  used.
            returned: success
            type: str
        id:
            description:
                - The unique identifier for the resource. This identifier is defined by the server.
            returned: success
            type: int
        name:
            description:
                - Name of the resource. Provided by the client when the resource is created. The name
                  must be 1-63 characters long, and comply with RFC1035.  Specifically, the name must
                  be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`
                  which means the first character must be a lowercase letter, and all following characters
                  must be a dash, lowercase letter, or digit, except the last character, which cannot
                  be a dash.
            returned: success
            type: str
        port:
            description:
                - The TCP port number for the HTTP health check request.
                - The default value is 80.
            returned: success
            type: int
        request_path:
            description:
                - The request path of the HTTP health check request.
                - The default value is /.
            returned: success
            type: str
        timeout_sec:
            description:
                - How long (in seconds) to wait before claiming failure.
                - The default value is 5 seconds.  It is invalid for timeoutSec to have greater value
                  than checkIntervalSec.
            returned: success
            type: int
        unhealthy_threshold:
            description:
                - A so-far healthy instance will be marked unhealthy after this many consecutive failures.
                  The default value is 2.
            returned: success
            type: int
'''

################################################################################
# Imports
################################################################################
from ansible.module_utils.gcp_utils import navigate_hash, GcpSession, GcpModule, GcpRequest
import json

################################################################################
# Main
################################################################################


def main():
    module = GcpModule(
        argument_spec=dict(
            filters=dict(type='list', elements='str'),
        )
    )

    if 'scopes' not in module.params:
        module.params['scopes'] = ['https://www.googleapis.com/auth/compute']

    items = fetch_list(module, collection(module), query_options(module.params['filters']))
    if items.get('items'):
        items = items.get('items')
    else:
        items = []
    return_value = {
        'items': items
    }
    module.exit_json(**return_value)


def collection(module):
    return "https://www.googleapis.com/compute/v1/projects/{project}/global/httpHealthChecks".format(**module.params)


def fetch_list(module, link, query):
    auth = GcpSession(module, 'compute')
    response = auth.get(link, params={'filter': query})
    return return_if_object(module, response)


def query_options(filters):
    if not filters:
        return ''

    if len(filters) == 1:
        return filters[0]
    else:
        queries = []
        for f in filters:
            # For multiple queries, all queries should have ()
            if f[0] != '(' and f[-1] != ')':
                queries.append("(%s)" % ''.join(f))
            else:
                queries.append(f)

        return ' '.join(queries)


def return_if_object(module, response):
    # If not found, return nothing.
    if response.status_code == 404:
        return None

    # If no content, return nothing.
    if response.status_code == 204:
        return None

    try:
        module.raise_for_status(response)
        result = response.json()
    except getattr(json.decoder, 'JSONDecodeError', ValueError) as inst:
        module.fail_json(msg="Invalid JSON response with error: %s" % inst)

    if navigate_hash(result, ['error', 'errors']):
        module.fail_json(msg=navigate_hash(result, ['error', 'errors']))

    return result


if __name__ == "__main__":
    main()
