.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbNoteIndicatorChanges __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbNoteIndicatorChanges \- Notes the changes in a changes structure 
.SH SYNOPSIS
.HP
.B void XkbNoteIndicatorChanges
.BI "(\^XkbIndicatorChangesPtr " "old" "\^,"
.BI "XkbIndicatorNotifyEvent *" "new" "\^,"
.BI "unsigned int " "wanted" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I old
XkbIndicatorChanges structure to be updated
.TP
.I new
event from which changes are to be copied
.TP
.I wanted
which changes are to be noted
.SH DESCRIPTION
.LP
Whenever an indicator changes state, the server sends XkbIndicatorStateNotify events to all 
interested clients. Similarly, whenever an indicator's map changes, the server sends 
XkbIndicatorMapNotify events to all interested clients.

To receive XkbIndicatorStateNotify events, use 
.I XkbSelectEvents 
with both the 
.I bits_to_change 
and 
.I values_for_bits 
parameters containing XkbIndicatorStateNotifyMask. To receive XkbIndicatorMapNotify events, 
use 
.I XkbSelectEvents 
with XkbIndicatorMapNotifyMask.

To receive events for only specific indicators, use 
.I XkbSelectEventDetails. 
Set the 
.I event_type 
parameter to XkbIndicatorStateNotify or XkbIndicatorMapNotify, and set both the
.I bits_to_change 
and 
.I values_for_bits 
detail parameters to a mask where each bit specifies one indicator, turning on those bits that 
specify the indicators for which you want to receive events.

The 
.I changed 
parameter is a mask that is the bitwise inclusive OR of the indicators that have changed. If 
the event is of type XkbIndicatorMapNotify, 
.I changed 
reports the maps that changed. If the event is of type XkbIndicatorStateNotify, 
.I changed 
reports the indicators that have changed state. 
.I state 
is a mask that specifies the current state of all indicators, whether they have changed or 
not, for both XkbIndicatorStateNotify and IndicatorMapNotify events.

When your client application receives either a XkbIndicatorStateNotify event or 
XkbIndicatorMapNotify event, you can note the changes in a changes structure by calling
.I XkbNoteIndicatorChanges.


The 
.I wanted 
parameter is the bitwise inclusive OR of XkbIndicatorMapMask and 
XkbIndicatorStateMask. 
.I XkbNoteIndicatorChanges 
copies any changes reported in 
.I new 
and specified in 
.I wanted 
into the changes record specified by 
.I old.
.SH STRUCTURES
Both types of indicator events use the same structure:
.nf

typedef struct _XkbIndicatorNotify {
  int            type;       /\&* Xkb extension base event code */
  unsigned long  serial;     /\&* X server serial number for event */
  Bool           send_event; /\&* True => synthetically generated */
  Display *      display;    /\&* server connection where event generated */
  Time           time;       /\&* server time when event generated */
  int            xkb_type;   /\&* specifies state or map notify */
  int            device;     /\&* Xkb device ID, will not be XkbUseCoreKbd */
  unsigned int   changed;    /\&* mask of indicators with new state or map */
  unsigned int   state;      /\&* current state of all indicators */
} XkbIndicatorNotifyEvent;
     
.fi     
.I xkb_type 
is either XkbIndicatorStateNotify or XkbIndicatorMapNotify, depending on whether the event is 
a kbIndicatorStateNotify event or kbIndicatorMapNotify event.
.SH "SEE ALSO"
.BR XkbIndicatorMapMask (__libmansuffix__),
.BR XkbIndicatorStateMask (__libmansuffix__),
.BR XkbSelectEventDetails (__libmansuffix__),
.BR XkbSelectEvents (__libmansuffix__)
