/*---------------------------------------------------------------------------*/
/*ncache.h*/
/*---------------------------------------------------------------------------*/
/*The cache of nodes*/
/*---------------------------------------------------------------------------*/
/*Based on the code of unionfs translator.*/
/*---------------------------------------------------------------------------*/
/*Copyright (C) 2001, 2002, 2005, 2008, 2009 Free Software Foundation,
  Inc.  Written by Sergiu Ivanov <unlimitedscolobb@gmail.com>.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or * (at your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA.*/
/*---------------------------------------------------------------------------*/
#ifndef __NCACHE_H__
#define __NCACHE_H__

/*---------------------------------------------------------------------------*/
#include <error.h>
#include <hurd/netfs.h>
/*---------------------------------------------------------------------------*/
#include "node.h"
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/*--------Macros-------------------------------------------------------------*/
/*The default maximal cache size*/
/*#define NCACHE_SIZE 256*/
/*SEE ALSO the comment in ncache.c*/
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/*--------Types--------------------------------------------------------------*/
/*A cache chain*/
struct ncache
{
  /*the MRU end of the cache chain */
  node_t *mru;

  /*the LRU end of the cache chain */
  node_t *lru;

  /*the maximal number of nodes to cache */
  /*int size_max; */
  /*SEE ALSO the comment in ncache.c */

  /*the current length of the cache chain */
  int size_current;

  /*a lock */
  pthread_mutex_t lock;
};				/*struct ncache */
/*---------------------------------------------------------------------------*/
typedef struct ncache ncache_t;
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/*--------Global Variables---------------------------------------------------*/
/*The cache size (may be overwritten by the user)*/
/*extern int cache_size;*/
/*SEE ALSO the comment in ncache.c*/
/*---------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/*--------Functions----------------------------------------------------------*/
/*Initializes the node cache*/
void ncache_init (void);
/*---------------------------------------------------------------------------*/
/*Looks up the lnode and stores the result in `node`; creates a new
  entry in the cache if the lookup fails*/
error_t ncache_node_lookup (lnode_t * lnode,	/*search for this */
			    node_t ** node	/*put the result here */
			    );
/*---------------------------------------------------------------------------*/
/*Removes the given node from the cache. Does not release the
  reference held by the cache (for some further finalization actions
  on the node)*/
/*Nodes will NOT be removed from the cache automatically*/
void ncache_node_remove (node_t * node);
/*---------------------------------------------------------------------------*/
/*Resets the node cache*/
/*No references to nodes are released*/
void ncache_reset (void);
/*---------------------------------------------------------------------------*/
/*Adds the given node to the cache*/
void ncache_node_add (node_t * node);
/*---------------------------------------------------------------------------*/
#endif /*__NCACHE_H__*/
