
(in-package :translator-test)

(def-test-method io-identity-test ((test io-test))
  (with-testport (p1 (file-name-lookup +translator-root+))
    (with-testport (p2 (file-name-lookup +translator-root+))
      (multiple-value-bind (idport fsysport ino)
        (io-identity p1)
        (assert-true (and (port-valid-p idport)
                          (port-valid-p fsysport)))
        (multiple-value-bind (idport2 fsysport2 ino2)
          (io-identity p2)
          (assert-true (and (port-valid-p idport2)
                            (port-valid-p fsysport2)))
          (assert-equal ino ino2)
          (port-deallocate idport2)
          (port-deallocate fsysport2))
        (port-deallocate idport)
        (port-deallocate fsysport)))))
