# -*- mode: makefile; coding: utf-8 -*-
# Copyright © 2002,2003 Colin Walters <walters@debian.org>
# Description: Builds and cleans packages which have a Makefile
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
# 02111-1307 USA.

_cdbs_scripts_path ?= /usr/lib/cdbs
_cdbs_rules_path ?= /usr/share/cdbs/1/rules
_cdbs_class_path ?= /usr/share/cdbs/1/class

ifndef _cdbs_class_makefile
_cdbs_class_makefile = 1

include $(_cdbs_rules_path)/buildcore.mk$(_cdbs_makefile_suffix)
include $(_cdbs_class_path)/makefile-vars.mk$(_cdbs_makefile_suffix)

DEB_PHONY_RULES += makefile-clean

common-build-arch common-build-indep:: debian/stamp-makefile-build
debian/stamp-makefile-build:
	+$(DEB_MAKE_INVOKE) $(DEB_MAKE_BUILD_TARGET)
	touch $@

clean:: makefile-clean
makefile-clean::
	$(if $(DEB_MAKE_CLEAN_TARGET),+-$(DEB_MAKE_INVOKE) -k $(DEB_MAKE_CLEAN_TARGET),@echo "DEB_MAKE_CLEAN_TARGET unset, not running clean")
	rm -f debian/stamp-makefile-build

common-install-arch common-install-indep:: common-install-impl
common-install-impl::
	$(if $(DEB_MAKE_INSTALL_TARGET),+$(DEB_MAKE_INVOKE) $(DEB_MAKE_INSTALL_TARGET),@echo "DEB_MAKE_INSTALL_TARGET unset, skipping default makefile.mk common-install target")

ifeq (,$(findstring nocheck,$(DEB_BUILD_OPTIONS)))
common-build-arch common-build-indep:: debian/stamp-makefile-check
debian/stamp-makefile-check: debian/stamp-makefile-build
	$(if $(DEB_MAKE_CHECK_TARGET),+$(DEB_MAKE_INVOKE) $(DEB_MAKE_CHECK_TARGET),@echo "DEB_MAKE_CHECK_TARGET unset, not running checks")
	$(if $(DEB_MAKE_CHECK_TARGET),touch $@)

makefile-clean::
	$(if $(DEB_MAKE_CHECK_TARGET),rm -f debian/stamp-makefile-check)
endif

endif
