#!/usr/bin/perl -w
# This file was preprocessed, do not edit!
package Debconf::FrontEnd::Passthrough;
use strict;
use Carp;
use IO::Socket;
use IO::Handle;
use Debconf::FrontEnd;
use Debconf::Element;
use Debconf::Log qw(:all);
use base qw(Debconf::FrontEnd);
my ($READFD, $WRITEFD, $SOCKET);
if (defined $ENV{DEBCONF_PIPE}) {
        $SOCKET = $ENV{DEBCONF_PIPE};
} elsif (defined $ENV{DEBCONF_READFD} && defined $ENV{DEBCONF_WRITEFD}) {
        $READFD = $ENV{DEBCONF_READFD};
        $WRITEFD = $ENV{DEBCONF_WRITEFD};
} else {
        die "Neither DEBCONF_PIPE nor DEBCONF_READFD and DEBCONF_WRITEFD were set\n";
}
sub init {
	my $this=shift;
        if (defined $SOCKET) {
                $this->{readfh} = $this->{writefh} = IO::Socket::UNIX->new(
		        Type => SOCK_STREAM,
		        Peer => $SOCKET
	        ) || croak "Cannot connect to $SOCKET: $!";
        } else {
                $this->{readfh} = IO::Handle->new_from_fd(int($READFD), "r") || croak "Failed to open fd $READFD: $!";
                $this->{writefh} = IO::Handle->new_from_fd(int($WRITEFD), "w") || croak "Failed to open fd $WRITEFD: $!";
        }
	$this->{readfh}->autoflush(1);
	$this->{writefh}->autoflush(1);
	
	$this->SUPER::init(@_);
	$this->interactive(1);
}
sub talk {
	my $this=shift;
	my $command=join(' ', @_);
	my $reply;
	
	my $readfh = $this->{readfh} || croak "Broken pipe";
	my $writefh = $this->{writefh} || croak "Broken pipe";
	
	debug developer => "----> $command";
	print $writefh $command."\n";
	$writefh->flush;
	$reply = <$readfh>;
	chomp($reply);
	debug developer => "<---- $reply";
	my ($tag, $val) = split(' ', $reply, 2);
	return ($tag, $val) if wantarray;
	return $tag;
}
sub shutdown {
	my $this=shift;
	
	debug developer => "Sending done signal";
	$this->talk('STOP');
}
sub makeelement
{
	my $this=shift;
	my $question=shift;
	
	return Debconf::Element->new(question => $question);
}
sub capb_backup
{
	my $this=shift;
	my $val = shift;
	$this->{capb_backup} = $val;
	$this->talk('CAPB', 'backup') if $val;
}
sub capb
{
	my $this=shift;
	my $ret;
	return $this->{capb} if exists $this->{capb};
	($ret, $this->{capb}) = $this->talk('CAPB');
	return $this->{capb} if $ret eq '0';
}
sub title
{
	my $this = shift;
	my $title = shift;
	$this->{title} = $title;
	$this->talk('TITLE', $title);
}
sub go {
	my $this = shift;
	my @elements=grep $_->visible, @{$this->elements};
	foreach my $element (@elements) {
		my $question = $element->question;
		my $tag = $question->template->template;
		my $type = $question->template->type;
		my $desc = $question->description;
		my $extdesc = $question->extended_description;
		my $default = $question->value;
                $this->talk('DATA', $tag, 'type', $type);
		if ($desc) {
			$desc =~ s/\n/\\n/g;
			$this->talk('DATA', $tag, 'description', $desc);
		}
		if ($extdesc) {
			$extdesc =~ s/\n/\\n/g;
			$this->talk('DATA', $tag, 'extended_description',
			            $extdesc);
		}
		if ($type eq "select" || $type eq "multiselect") {
			my $choices = $question->choices;
			$choices =~ s/\n/\\n/g if ($choices);
			$this->talk('DATA', $tag, 'choices', $choices);
		}
		$this->talk('SET', $tag, $default) if $default ne '';
                
		$this->talk('INPUT', $question->priority, $tag);
	}
	if (@elements && (scalar($this->talk('GO')) eq "30") && $this->{capb_backup}) {
		return;
	}
	
	foreach my $element (@{$this->elements}) {
		if ($element->visible) {
			my $tag = $element->question->template->template;
			my ($ret, $val)=$this->talk('GET', $tag);
			if ($ret eq "0") {
				$element->value($val);
				debug developer => "Got \"$val\" for $tag";
			}
		} else {
			my $default='';
			$default=$element->question->value if defined $element->question->value;
			$element->value($default);
		}
	}
	return 1;
}
1
