/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.ant;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Stack;
import org.apache.woden.ant.NamespaceWriter;
import org.apache.woden.types.NCName;

public class XMLWriter {
    private HashMap registry = new HashMap();
    private PrintWriter out;
    private int indentation = 2;
    private Stack tags = new Stack();

    public XMLWriter(PrintWriter out) {
        this.out = out;
    }

    public void close() {
        if (this.out != null) {
            this.out.close();
        }
    }

    public void xmlDeclaration(String encoding) {
        if (this.out == null) {
            return;
        }
        if (encoding == null) {
            this.out.println("<?xml version='1.0'?>");
        } else {
            this.out.println("<?xml version='1.0' encoding='" + encoding + "'?>");
        }
    }

    public void beginElement(String tag) {
        if (this.out == null) {
            return;
        }
        this.beginElement(tag, "");
    }

    public void beginElement(String tag, String attributes) {
        if (this.out == null) {
            return;
        }
        this.indent();
        if (attributes.length() == 0) {
            this.out.println("<" + tag + ">");
        } else {
            this.out.println("<" + tag + " " + attributes + ">");
        }
        this.tags.push(tag);
    }

    public void endElement() {
        if (this.out == null) {
            return;
        }
        String tag = (String)this.tags.pop();
        this.indent();
        this.out.println("</" + tag + ">");
    }

    public void endAllElements() {
        while (!this.tags.empty()) {
            this.endElement();
        }
    }

    public void element(String tag, String content) {
        if (this.out == null) {
            return;
        }
        this.indent();
        this.out.println("<" + tag + ">" + XMLWriter.escape(content) + "</" + tag + ">");
    }

    public void emptyElement(String tag, String attributes) {
        if (this.out == null) {
            return;
        }
        this.indent();
        this.out.println("<" + tag + " " + attributes + "/>");
    }

    private void indent() {
        if (this.out == null) {
            return;
        }
        for (int i = 0; i < this.tags.size(); ++i) {
            for (int j = 0; j < this.indentation; ++j) {
                this.out.write(32);
            }
        }
    }

    public void write(String tag, NCName ncname) {
        if (ncname == null) {
            return;
        }
        this.element(tag, ncname.toString());
    }

    public void write(String tag, String content) {
        if (content == null) {
            return;
        }
        this.element(tag, content);
    }

    public void write(String tag, Boolean o) {
        if (o == null) {
            return;
        }
        this.write(tag, (boolean)o);
    }

    public void write(String tag, boolean value) {
        this.element(tag, Boolean.toString(value));
    }

    public void write(String tag, int value) {
        this.element(tag, Integer.toString(value));
    }

    public static String escape(String x) {
        if (x == null) {
            return null;
        }
        StringBuffer y = new StringBuffer();
        block7: for (int i = 0; i < x.length(); ++i) {
            char c = x.charAt(i);
            switch (c) {
                case '&': {
                    y.append("&amp;");
                    continue block7;
                }
                case '<': {
                    y.append("&lt;");
                    continue block7;
                }
                case '>': {
                    y.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    y.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    y.append("&apos;");
                    continue block7;
                }
                default: {
                    y.append(c);
                }
            }
        }
        return y.toString();
    }

    public void register(NamespaceWriter writer) {
        this.registry.put(writer.getNamespace(), writer);
    }

    public NamespaceWriter lookup(String namespace) {
        return (NamespaceWriter)this.registry.get(namespace);
    }
}

