Apache Axiom 2.0.0 Release Note
===============================

Axiom 2 introduces breaking changes to remove the dependency of `axiom-api` on classes in the
`javax.activation` package, in particular `DataHandler`:

- Some classes that depend on `javax.activation` have been moved into a separate `axiom-javax-activation`
  JAR. In some cases the package name has also been changed to avoid split packages. If you
  encounter a missing class during migration, check whether that class exists in `axiom-javax-activation`
  and update dependencies and package names as needed.

- The legacy `Attachments` API has been moved into a separate `axiom-legacy-attachments` JAR. This
  API is still used by Axis2, but new code should use `MultipartBody` instead. The (previously
  deprecated) methods in `OMXMLBuilderFactory` that refer to `Attachments` have been removed. To
  continue using the `Attachments` class, call the `getMultipartBody` method and pass the result to
  `OMXMLBuilderFactory`.

- Because of these changes the XOP/MTOM serializer no longer infers the content type and content
  transfer encoding of non-root parts from (`Blob` wrapped) `DataHandler` objects linked to `OMText`
  nodes by default. This behavior now needs to be enabled explicitly by setting the
  `ContentTypeProvider` and `ContentTransferEncodingPolicy` on the `OMOutputFormat` to
  `DataHandlerContentTypeProvider.INSTANCE` and `ConfigurableDataHandler.CONTENT_TRANSFER_ENCODING_POLICY`
  respectively.

- APIs that have been updated to remove the dependency on `DataHandler` have also been changed to
  make use of `ContentType` instead of `String` where this is relevant.

Jira issues completed for 2.0.0:

<h2>        Bug
</h2>
<ul>
<li>[<a href='https://issues.apache.org/jira/browse/AXIOM-516'>AXIOM-516</a>] -         Recent Axiom versions serialize character references differently
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIOM-518'>AXIOM-518</a>] -         AXIOM DOAP file has a parsing error
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIOM-519'>AXIOM-519</a>] -         NullPointerException after using setOptimize(true) on a plain OMText node
</li>
</ul>
                
<h2>        Improvement
</h2>
<ul>
<li>[<a href='https://issues.apache.org/jira/browse/AXIOM-506'>AXIOM-506</a>] -         Upgrade to org.glassfish 3.0.1 and jakarta packages
</li>
</ul>
