/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.attachments.IncomingAttachmentStreams;

public class IncomingAttachmentInputStream
extends InputStream {
    private Map<String, String> _headers = null;
    private Map<String, String> _headersLowerCase = null;
    private InputStream _stream = null;
    private IncomingAttachmentStreams parentContainer;
    public static final String HEADER_CONTENT_DESCRIPTION = "content-description";
    public static final String HEADER_CONTENT_TYPE = "content-type";
    public static final String HEADER_CONTENT_TRANSFER_ENCODING = "content-transfer-encoding";
    public static final String HEADER_CONTENT_LENGTH = "content-length";
    public static final String HEADER_CONTENT_LOCATION = "content-location";
    public static final String HEADER_CONTENT_ID = "content-id";

    public IncomingAttachmentInputStream(InputStream in, IncomingAttachmentStreams parentContainer) {
        this._stream = in;
        this.parentContainer = parentContainer;
    }

    public Map<String, String> getHeaders() {
        return this._headers;
    }

    public void addHeader(String name, String value) {
        if (this._headers == null) {
            this._headers = new HashMap<String, String>();
            this._headersLowerCase = new HashMap<String, String>();
        }
        this._headers.put(name, value);
        this._headersLowerCase.put(name.toLowerCase(), value);
    }

    public String getHeader(String name) {
        String header = null;
        if (this._headersLowerCase == null || (header = this._headersLowerCase.get(name.toLowerCase())) == null) {
            return null;
        }
        return header.toString();
    }

    public String getContentId() {
        return this.getHeader(HEADER_CONTENT_ID);
    }

    public String getContentLocation() {
        return this.getHeader(HEADER_CONTENT_LOCATION);
    }

    public String getContentType() {
        return this.getHeader(HEADER_CONTENT_TYPE);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("markNotSupported");
    }

    @Override
    public void mark(int readLimit) {
    }

    @Override
    public int read() throws IOException {
        int retval = this._stream.read();
        this.parentContainer.setReadyToGetNextStream(retval == -1);
        return retval;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int retval = this._stream.read(b);
        this.parentContainer.setReadyToGetNextStream(retval == -1);
        return retval;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int retval = this._stream.read(b, off, len);
        this.parentContainer.setReadyToGetNextStream(retval == -1);
        return retval;
    }
}

