/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.validation.Schema;
import org.apache.axiom.dom.DOMDocument;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactorySPI;
import org.apache.axiom.om.dom.DOMMetaFactory;
import org.apache.axiom.om.impl.dom.factory.DOOMNodeFactory;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class DOOMDocumentBuilder
extends DocumentBuilder {
    private final OMFactory factory;
    private final StAXParserConfiguration parserConfiguration;
    private final Schema schema;

    DOOMDocumentBuilder(OMFactory factory, StAXParserConfiguration parserConfiguration, Schema schema) {
        this.factory = factory;
        this.parserConfiguration = parserConfiguration;
        this.schema = schema;
    }

    @Override
    public boolean isNamespaceAware() {
        return true;
    }

    @Override
    public boolean isValidating() {
        return true;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return ((DOMMetaFactory)this.factory.getMetaFactory()).getDOMImplementation();
    }

    @Override
    public Document newDocument() {
        return DOOMNodeFactory.INSTANCE.createNode(DOMDocument.class);
    }

    @Override
    public void setEntityResolver(EntityResolver er) {
    }

    @Override
    public void setErrorHandler(ErrorHandler eh) {
    }

    @Override
    public Document parse(InputSource inputSource) throws SAXException, IOException {
        OMDocument document = ((OMMetaFactorySPI)this.factory.getMetaFactory()).createOMBuilder(this.parserConfiguration, inputSource).getDocument();
        document.close(true);
        return (Document)((Object)document);
    }

    @Override
    public Document parse(InputStream is) throws SAXException, IOException {
        return this.parse(new InputSource(is));
    }

    @Override
    public Document parse(File file) throws SAXException, IOException {
        try (FileInputStream in = new FileInputStream(file);){
            Document document = this.parse(in);
            return document;
        }
    }

    @Override
    public Document parse(InputStream is, String systemId) throws SAXException, IOException {
        InputSource inputSource = new InputSource(is);
        inputSource.setSystemId(systemId);
        return this.parse(inputSource);
    }

    @Override
    public Document parse(String uri) throws SAXException, IOException {
        return this.parse(new InputSource(uri));
    }
}

