
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  Create a new Element node, add a new atttribute node to it.  Compare the position 
 *  of the Element and the Document.  This should return disconnected, implementation specific, and that
 *  the order of these two nodes is preserved. 
 *  Also compare the position of the Element node with respect to the Attr node and this should
 *  be PRECEDING and contains, and the Attr node follows and is contained by the Element node
* @author IBM
* @author Jenny Hsu
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Node3-compareDocumentPosition">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Node3-compareDocumentPosition</a>
*/
public final class nodecomparedocumentposition33 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public nodecomparedocumentposition33(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Element elem;
      Attr attr;
      int position1;
      int position2;
      int position3;
      int position4;
      int position5;
      Attr replacedAttr;
      doc = (Document) load("hc_staff", false);
      elem = doc.createElementNS("http://www.w3.org/1999/xhtml", "br");
      attr = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang");
      replacedAttr = elem.setAttributeNodeNS(attr);
      position4 = (int) elem.compareDocumentPosition(attr);
      assertEquals("nodecomparedocumentposition3FollowingisContained33", 20, position4);
      position5 = (int) attr.compareDocumentPosition(elem);
      assertEquals("nodecomparedocumentposition4ContainsPRECEDING33", 10, position5);
      position1 = (int) doc.compareDocumentPosition(elem);
      assertEquals("isImplSpecificDisconnected1", 33 & 57, position1 & 57);
      position2 = (int) elem.compareDocumentPosition(doc);
      assertNotEquals("notBothPreceding", position1 & 2, position2 & 2);
assertNotEquals("notBothFollowing", position1 & 4, position2 & 4);
assertEquals("isImplSpecificDisconnected2", 33 & 57, position2 & 57);
      position3 = (int) doc.compareDocumentPosition(elem);
      assertEquals("isConsistent", position1, position3);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/nodecomparedocumentposition33";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(nodecomparedocumentposition33.class, args);
   }
}

