/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring.test;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.Resource;

public class ApplicationContextMock
extends AbstractApplicationContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
    private final long startupTime;

    public ApplicationContextMock() {
        this.beanFactory.setSerializationId(ApplicationContextMock.class.getName());
        this.startupTime = System.currentTimeMillis();
    }

    public <T> void putBean(String name, T bean) {
        this.beanFactory.registerBeanDefinition(name, (BeanDefinition)new RootBeanDefinition(bean.getClass(), () -> bean));
    }

    public void putBean(Object bean) {
        this.putBean(bean.getClass().getName(), bean);
    }

    public Object getBean(String name) throws BeansException {
        return this.beanFactory.getBean(name);
    }

    public Object getBean(String name, Object ... args) throws BeansException {
        return this.beanFactory.getBean(name, args);
    }

    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        return (T)this.beanFactory.getBean(name, requiredType);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        return this.beanFactory.getBeansOfType(type);
    }

    public <T> T getBean(Class<T> requiredType) throws BeansException {
        return (T)this.beanFactory.getBean(requiredType);
    }

    public <T> T getBean(Class<T> requiredType, Object ... objects) throws BeansException {
        return (T)this.beanFactory.getBean(requiredType, objects);
    }

    public <T> ObjectProvider<T> getBeanProvider(Class<T> aClass) {
        return this.beanFactory.getBeanProvider(aClass);
    }

    public <T> ObjectProvider<T> getBeanProvider(ResolvableType resolvableType) {
        return this.beanFactory.getBeanProvider(resolvableType);
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) throws BeansException {
        return this.beanFactory.getBeansWithAnnotation(annotationType);
    }

    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) {
        return (A)this.beanFactory.findAnnotationOnBean(beanName, annotationType);
    }

    public ApplicationContext getParent() {
        return null;
    }

    public String getDisplayName() {
        return ApplicationContextMock.class.getSimpleName();
    }

    public long getStartupDate() {
        return this.startupTime;
    }

    public void publishEvent(ApplicationEvent event) {
        throw new UnsupportedOperationException();
    }

    public void publishEvent(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean containsBeanDefinition(String beanName) {
        return this.beanFactory.containsBean(beanName);
    }

    public int getBeanDefinitionCount() {
        return this.beanFactory.getBeanDefinitionCount();
    }

    public String[] getBeanDefinitionNames() {
        return this.beanFactory.getBeanDefinitionNames();
    }

    public <T> ObjectProvider<T> getBeanProvider(Class<T> aClass, boolean b) {
        return this.beanFactory.getBeanProvider(aClass, b);
    }

    public <T> ObjectProvider<T> getBeanProvider(ResolvableType resolvableType, boolean b) {
        return this.beanFactory.getBeanProvider(resolvableType, b);
    }

    public String[] getBeanNamesForType(ResolvableType resolvableType) {
        return this.beanFactory.getBeanNamesForType(resolvableType);
    }

    public String[] getBeanNamesForType(ResolvableType resolvableType, boolean includeNonSingletons, boolean allowEagerInit) {
        return this.beanFactory.getBeanNamesForType(resolvableType, includeNonSingletons, allowEagerInit);
    }

    public String[] getBeanNamesForType(Class type) {
        return this.beanFactory.getBeanNamesForType(type);
    }

    public String[] getBeanNamesForType(Class type, boolean includeNonSingletons, boolean allowEagerInit) {
        return this.beanFactory.getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        return this.beanFactory.getBeansOfType(type, includeNonSingletons, allowEagerInit);
    }

    public String[] getBeanNamesForAnnotation(Class<? extends Annotation> aClass) {
        return this.beanFactory.getBeanNamesForAnnotation(aClass);
    }

    public boolean containsBean(String name) {
        return this.beanFactory.containsBean(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return this.beanFactory.isSingleton(name);
    }

    public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return this.beanFactory.getType(name);
    }

    public Class<?> getType(String name, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        return this.beanFactory.getType(name, allowFactoryBeanInit);
    }

    public String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        return this.beanFactory.getAliases(name);
    }

    public BeanFactory getParentBeanFactory() {
        return this.beanFactory.getParentBeanFactory();
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        throw new UnsupportedOperationException();
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        throw new UnsupportedOperationException();
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        throw new UnsupportedOperationException();
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void refreshBeanFactory() throws BeansException, IllegalStateException {
    }

    protected void closeBeanFactory() {
    }

    public ConfigurableListableBeanFactory getBeanFactory() throws IllegalStateException {
        return this.beanFactory;
    }

    public Resource getResource(String location) {
        throw new UnsupportedOperationException();
    }

    public AutowireCapableBeanFactory getAutowireCapableBeanFactory() throws IllegalStateException {
        return this.beanFactory;
    }

    public boolean containsLocalBean(String name) {
        return this.beanFactory.containsLocalBean(name);
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        return this.beanFactory.isPrototype(name);
    }

    public boolean isTypeMatch(String s, ResolvableType resolvableType) throws NoSuchBeanDefinitionException {
        return this.beanFactory.isTypeMatch(s, resolvableType);
    }

    public boolean isTypeMatch(String name, Class targetType) throws NoSuchBeanDefinitionException {
        return this.beanFactory.isTypeMatch(name, targetType);
    }
}

