/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.SagaActionUriDefinition;
import org.apache.camel.model.SagaCompletionMode;
import org.apache.camel.model.SagaOptionDefinition;
import org.apache.camel.model.SagaPropagation;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.saga.SagaProcessorBuilder;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.saga.CamelSagaStep;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(label="eip,routing")
@XmlRootElement(name="saga")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SagaDefinition
extends OutputDefinition<SagaDefinition> {
    private static final Logger LOG = LoggerFactory.getLogger(SagaDefinition.class);
    @XmlAttribute
    @Metadata(defaultValue="REQUIRED")
    private SagaPropagation propagation;
    @XmlAttribute
    @Metadata(defaultValue="AUTO")
    private SagaCompletionMode completionMode;
    @XmlAttribute
    private Long timeoutInMilliseconds;
    @XmlElement
    private SagaActionUriDefinition compensation;
    @XmlElement
    private SagaActionUriDefinition completion;
    @XmlElement(name="option")
    private List<SagaOptionDefinition> options;
    @XmlTransient
    private CamelSagaService sagaService;

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        SagaCompletionMode completionMode;
        Optional<Endpoint> compensationEndpoint = Optional.ofNullable(this.compensation).map(SagaActionUriDefinition::getUri).map(routeContext::resolveEndpoint);
        Optional<Endpoint> completionEndpoint = Optional.ofNullable(this.completion).map(SagaActionUriDefinition::getUri).map(routeContext::resolveEndpoint);
        TreeMap<String, Expression> optionsMap = new TreeMap<String, Expression>();
        if (this.options != null) {
            for (SagaOptionDefinition optionDef : this.options) {
                String optionName = optionDef.getOptionName();
                ExpressionDefinition expr = optionDef.getExpression();
                optionsMap.put(optionName, expr);
            }
        }
        CamelSagaStep step = new CamelSagaStep(compensationEndpoint, completionEndpoint, optionsMap, Optional.ofNullable(this.timeoutInMilliseconds));
        SagaPropagation propagation = this.propagation;
        if (propagation == null) {
            propagation = SagaPropagation.REQUIRED;
        }
        if ((completionMode = this.completionMode) == null) {
            completionMode = SagaCompletionMode.defaultCompletionMode();
        }
        Processor childProcessor = this.createChildProcessor(routeContext, true);
        CamelSagaService camelSagaService = this.findSagaService(routeContext.getCamelContext());
        camelSagaService.registerStep(step);
        return new SagaProcessorBuilder().camelContext(routeContext.getCamelContext()).childProcessor(childProcessor).sagaService(camelSagaService).step(step).propagation(propagation).completionMode(completionMode).build();
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public boolean isTopLevelOnly() {
        return true;
    }

    @Override
    public boolean isWrappingEntireOutput() {
        return true;
    }

    @Override
    public String getLabel() {
        String desc = this.description();
        if (ObjectHelper.isEmpty(desc)) {
            return "saga";
        }
        return "saga[" + desc + "]";
    }

    @Override
    public String toString() {
        String desc = this.description();
        if (ObjectHelper.isEmpty(desc)) {
            return "Saga -> [" + this.outputs + "]";
        }
        return "Saga[" + desc + "] -> [" + this.outputs + "]";
    }

    public SagaActionUriDefinition getCompensation() {
        return this.compensation;
    }

    public void setCompensation(SagaActionUriDefinition compensation) {
        this.compensation = compensation;
    }

    public SagaActionUriDefinition getCompletion() {
        return this.completion;
    }

    public void setCompletion(SagaActionUriDefinition completion) {
        this.completion = completion;
    }

    public SagaPropagation getPropagation() {
        return this.propagation;
    }

    public void setPropagation(SagaPropagation propagation) {
        this.propagation = propagation;
    }

    public SagaCompletionMode getCompletionMode() {
        return this.completionMode;
    }

    public void setCompletionMode(SagaCompletionMode completionMode) {
        this.completionMode = completionMode;
    }

    public CamelSagaService getSagaService() {
        return this.sagaService;
    }

    public void setSagaService(CamelSagaService sagaService) {
        this.sagaService = sagaService;
    }

    public List<SagaOptionDefinition> getOptions() {
        return this.options;
    }

    public void setOptions(List<SagaOptionDefinition> options) {
        this.options = options;
    }

    public Long getTimeoutInMilliseconds() {
        return this.timeoutInMilliseconds;
    }

    public void setTimeoutInMilliseconds(Long timeoutInMilliseconds) {
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    private void addOption(String option, Expression expression) {
        if (this.options == null) {
            this.options = new ArrayList<SagaOptionDefinition>();
        }
        this.options.add(new SagaOptionDefinition(option, expression));
    }

    public SagaDefinition compensation(String compensation) {
        if (this.compensation != null) {
            throw new IllegalStateException("Compensation has already been set");
        }
        this.compensation = new SagaActionUriDefinition(compensation);
        return this;
    }

    public SagaDefinition completion(String completion) {
        if (this.completion != null) {
            throw new IllegalStateException("Completion has already been set");
        }
        this.completion = new SagaActionUriDefinition(completion);
        return this;
    }

    public SagaDefinition propagation(SagaPropagation propagation) {
        this.setPropagation(propagation);
        return this;
    }

    public SagaDefinition sagaService(CamelSagaService sagaService) {
        this.setSagaService(sagaService);
        return this;
    }

    public SagaDefinition completionMode(SagaCompletionMode completionMode) {
        this.setCompletionMode(completionMode);
        return this;
    }

    public SagaDefinition option(String option, Expression expression) {
        this.addOption(option, expression);
        return this;
    }

    public SagaDefinition timeout(long timeout, TimeUnit unit) {
        this.setTimeoutInMilliseconds(unit.toMillis(timeout));
        return this;
    }

    protected CamelSagaService findSagaService(CamelContext context) {
        CamelSagaService sagaService = this.getSagaService();
        if (sagaService != null) {
            return sagaService;
        }
        sagaService = context.hasService(CamelSagaService.class);
        if (sagaService != null) {
            return sagaService;
        }
        sagaService = CamelContextHelper.findByType(context, CamelSagaService.class);
        if (sagaService != null) {
            return sagaService;
        }
        throw new RuntimeCamelException("Cannot find a CamelSagaService");
    }

    protected String description() {
        StringBuilder desc = new StringBuilder();
        this.addField(desc, "compensation", this.compensation);
        this.addField(desc, "completion", this.completion);
        this.addField(desc, "propagation", (Object)this.propagation);
        return desc.toString();
    }

    private void addField(StringBuilder builder, String key, Object value) {
        if (value == null) {
            return;
        }
        if (builder.length() > 0) {
            builder.append(',');
        }
        builder.append(key).append(':').append(value);
    }
}

